#version unofficial megapov 0.5;

#declare test_lunettes_inc = off;

#include "colors"
// #include "shapes"
// #include "textures"

#declare T_Verre = texture {
	pigment { rgbf .999 }
	finish { ambient 0 diffuse 0
		specular 1 roughness .001
		reflection .1
		conserve_energy
	}
}	

#declare T_Cercle = texture {
	pigment { rgb .1 }
	finish { specular .3 roughness .02 }
}

#declare Verre1 = intersection {
	cylinder{ <0,0,0>, <-.3, 0, 0>, 1 }
	difference {
		sphere{ <5,0,0>, 5.2/cos(atan2(1,5))}
		sphere{ <5,0,0>, 5/cos(atan2(1,5))}
	}
	texture { T_Verre }
	interior { ior 1.9 caustics .7 }
}

#declare Verre2 = intersection {
	cylinder{ <0,0,0>, <-.3, 0, 0>, 1 }
	difference {
		sphere{ <5,0,0>, 5.2/cos(atan2(1,5))}
		sphere{ <5,0,0>, 5/cos(atan2(1,5))}
	}
	texture { T_Verre
		normal {
			crackle
			scale 3
			warp { turbulence.3 }
			scale <100,1/3,1/3>
			translate -.5*y
			slope_map {
				[.01 <0,0>]
				[.011 <0,3>]
				[.012 <1,0>]
			}
		}
	}
	interior { ior 1.9 caustics .7 }
}

#declare Verre_Cercle1 = union {
	object { Verre1 }
	difference {
		cylinder { <-.2, 0,0>, <0,0,0>, 1.05 }
		cylinder { <-.21, 0,0>, <.01,0,0>, 1.00 }
		texture { T_Cercle }
	}
	scale <1, 1.5,2.4>
}

#declare Verre_Cercle2 = union {
	object { Verre2 }
	difference {
		cylinder { <-.2, 0,0>, <0,0,0>, 1.05 }
		cylinder { <-.21, 0,0>, <.01,0,0>, 1.00 }
		texture { T_Cercle }
	}
	scale <1, 1.5,2.4>
}

#declare Deux_Verres = union {
	object { Verre_Cercle1 translate 3.15*z }
	object { Verre_Cercle2 translate -3.15*z }
	intersection {
		box { <-.26,1-1.1/cos(atan2(.75,1))-.01,-.75>, <.01,.1,.75> }
		difference {
			cylinder { <-.25,1,0>, <0.00,1,0>, 1.1/cos(atan2(.75,1)) }
			cylinder { <-.26,1,0>, <0.01,1,0>, 0.9/cos(atan2(.75,1)) }
		}
		texture { T_Cercle }
	}
}


#declare Decal_z = 2.5+3.15+.1;
#declare Lunettes = union {
	union {
		object { Deux_Verres
			rotate -10*z
		}
		cylinder { <-.1,-.15,Decal_z>, <-.1,.15,Decal_z>, .1 }
		cylinder { <-.1,-.15,-Decal_z>, <-.1,.15,-Decal_z>, .1 }
		translate 1.05*1.5*cos(radians(10))*y
	}
	union {
		cylinder { <0,1.05*1.5*cos(radians(10)),0>, <10, .1,0>, .1 scale <1,1,.6> }
		union {
			intersection {
				torus { 1, .1/5 }
				box { <0, -.1, -1.1>, <1.1, .1, 0> }
				rotate -x*90
			}
			sphere { <1,0,0>, .1/5 }
			translate 1*y
			scale <3, 4, 5*.6>
			translate .1*y + 10*x
		}
		rotate -y*10
		translate Decal_z*z
	}
	union {
		cylinder { <0,1.05*1.5*cos(radians(10)),0>, <10, .1,0>, .1 scale <1,1,.6>}
		union {
			intersection {
				torus { 1, .1/5 }
				box { <0, -.1, -1.1>, <1.1, .1, 0> }
				rotate -x*90
			}
			sphere { <1,0,0>, .1/5 }
			translate 1*y
			scale <3, 4, 5*.6>
			translate .1*y + 10*x
		}
		rotate y*10
		translate -Decal_z*z
	}
	texture {T_Cercle}
}


#if (test_lunettes_inc)

global_settings {
	max_trace_level 20
	adc_bailout .1
}

sky_sphere { pigment { rgb .8 } }

camera{
	location <-25,12,-20>
	angle 20
	look_at <0,1.05*1.5*cos(radians(10)),0>
}

light_source{ <200,200,-200>
              color White}
light_source{ <-200,200,-200>
              color White}

object{ Lunettes }

plane { y,0
	pigment { checker rgb <.95, .90, .80>, rgb <.65, .45, .15>*.6 scale 2 }
}

#end
