#version unofficial megapov 0.5;

#ifndef (test_paille_inc)

#declare test_paille_inc = off;

// Paille_brin(dep, fin, larg, turb, sturb, nbs, st)
// dep:   startpoint of the strand
// fin:   endpoint of the strand
// larg:  width of the strand
// turb:  amount of turbulence on the straigth strand
// sturb: "frequency" of the turbulence
// nbs:   number of segments in the strand (1 segment = 2 triangles)
// st:    random generator ID

#macro Paille_brin(dep, fin, larg, turb, sturb, nbs, st)
	#local dir = fin-dep;
	#local norm = <-dir.y, dir.x, 0>;
	#local norm = vaxis_rotate(norm, dir, rand(st)*180);
	#local i=0;
	#local tmp1 = dep;
	#while (i<nbs)
		#local i=i+1;
		#local tmp2 = dep + dir*i/nbs;
		#local tmp2 = tmp2 + (1-abs(pow((2*i/nbs)-1,3)))*turb*vturbulence(3,1,1,tmp2*sturb);
		triangle { tmp1+larg*norm, tmp1-larg*norm, tmp2+larg*norm }
		triangle { tmp2+larg*norm, tmp2-larg*norm, tmp1-larg*norm }
		#local tmp1 = tmp2;
	#end
#end


// Paille_mesh(coin1, coin2, nbb, larg, turb, sturb, nbs, st)
// coin1: first corner of the patch
// coin2: second corner of the patch
// nbb:   number of strands
// larg:  width of the strands
// turb:  amount of turbulence on a straigth strand
// sturb: "frequency" of the turbulence
// nbs:   number of segments for one strand (1 segment = 2 triangles)
// st:    random generator ID

#macro Paille_mesh(coin1, coin2, nbb, larg, turb, sturb, nbs, st)

#local st1 = seed(3652*rand(st));
#local st2 = seed(3652*rand(st));
#local st3 = seed(3652*rand(st));
mesh {
	#local i=0;
	#while (i<nbb)
		#local tmp1 = coin1+<rand(st1), rand(st1), rand(st1)>*(coin2-coin1);
		#local tmp2 = coin1+<rand(st2), rand(st2), rand(st2)>*(coin2-coin1);
		Paille_brin(tmp1, tmp2, larg, turb, sturb, nbs, st3)
		#local i=i+1;
	#end
}

#end

#macro Paille_tapis(coin1, coin2, nbx, nbz, m_paille, st)

union {
	#local incx = (coin2.x-coin1.x)/nbx;
	#local incz = (coin2.z-coin1.z)/nbz;
	#local i=coin1.x;
	#while (i<(coin2.x))
		#local j=coin1.z;
		#while (j<coin2.z)
			object { m_paille rotate y*36521*rand(st) translate i*x+j*z}
			#local j=j+incz;
		#end
		#local i=i+incx;
	#end
	translate y*coin1.y
}

#end


#if (test_paille_inc)
//====================================================
//		DEMO SCENE
//====================================================

#declare Use_Rad = off;

global_settings {
	assumed_gamma 1.0
#if (Use_Rad)
	ini_option "+QR"
	radiosity{
		count 30
		nearest_count 5
		error_bound .5
		recursion_limit 1
		brightness 1.0

		pretrace_start  .1
		pretrace_end  .02

		low_error_factor .5
		gray_threshold 0.0
		minimum_reuse 0.015
		normal off

		max_sample 1
		adc_bailout 0.05
	}
#end
}

#default { texture { finish { diffuse 1 ambient 0 } } }

sky_sphere { pigment { rgb <.8, .9, 1> } }

camera {
	location <1, 5, -7>
	right x*4/3
	up y
	angle 40
	look_at <0,0,-.5>
}

/*
light_source {
	<-15, 15, -15>*100, color rgb 1
}
*/

#local sr = seed(352);

// sol
box { <-10, -.3, -3>, <10, -.05, 10> texture { pigment { rgb .5 } } }

union{

#declare Bloc1 = union {
	box { <-1, 0, -1>, <1, .1, 1> }
	sphere { 0, .1 translate -x-z }
	sphere { 0, .1 translate -x+z }
	sphere { 0, .1 translate x-z }
	sphere { 0, .1 translate x+z }
	cylinder { -x-z, x-z, .1 }
	cylinder { -x-z, -x+z, .1 }
	cylinder { x-z, x+z, .1 }
	cylinder { -x+z, x+z, .1 }
	scale <.505/1.1, 1, .505/1.1>
	scale <1.2,1,1.2>
}

#local st=seed(3521);

#local i=-10;
#while (i<10)
	#local j=-3;
	#while (j<10)
		object { Bloc1
			rotate <.5*(-1+2*rand(st)), 1*(-1+2*rand(st)), .5*(-1+2*rand(st))>
			translate <i, -.1, j>
		}
		#local j=j+1.2;
	#end
	#local i=i+1.2;
#end
	texture {
		pigment { color rgb .9 }
		normal {
			average
			normal_map {
				[1 bozo .1 scale .1 turbulence .1 octaves 3]
				[1 dents .5 scale .05 ]
			}
		}
		finish {
			brilliance .6
			reflection_min 0
			reflection_max .3
			reflection_falloff 2
			specular .2 roughness .01
			phong .1 phong_size 5
		}
	}
}

// Paille_mesh(coin1, coin2, nbb, larg, turb, sturb, nbs, st)
#declare m_paille = Paille_mesh(<-1, 0, -1>, <1, .15, 1>, 200, .01, .1, 4, 5, sr)

// bac
union {
	box { <-3, 0, -2>, <3, .01, 2> }
	box { <-3, 0, -2>, <3, .5, -1.9> }
	box { <-3, 0, 1.9>, <3, .5, 2> }
	box { <-3, 0, -2>, <-2.9, .5, 2> }
	box { <3, 0, -2>, <2.9, .5, 2> }
	texture {
		pigment { rgb .7 }
		finish {
			brilliance .8
			phong .5 phong_size 20
		}
	}
}

union {
	// Paille_tapis(coin1, coin2, nbx, nbz, m_paille, st)
	object {
		Paille_tapis(<-2.9, .01, -1.9>, <2.9, .01, 1.9>, 5, 4, m_paille, sr)
		clipped_by { box {<-2.9, 0, -1.9>, <2.9, .2, 1.9>} }
	}
	mesh {
	// des brins qui remontent sur les bords
	// bord du fond
	#local i=-2.75;
	#while (i<2.75)
		#local dep = <i, .25+.2*rand(sr), 1.9-.1*rand(sr)>;
		#local fin = <i+(.3*rand(sr)-.15), .1, 1.6-.2*rand(sr)>;
		// Paille_brin(dep, fin, larg, turb, sturb, nbs, st)
		Paille_brin(dep, fin, .03, .2, 4, 5, sr)
		#local i = i+.05+.2*rand(sr);
	#end
	// bord de droite et gauche
	#local i=-1.75;
	#while (i<1.75)
		#local dep = <2.9-.1*rand(sr), .25+.2*rand(sr), i>;
		#local fin = <2.6-.2*rand(sr), .1, i+(.3*rand(sr)-.15)>;
		// Paille_brin(dep, fin, larg, turb, sturb, nbs, st)
		Paille_brin(dep, fin, .03, .2, 4, 5, sr)
		#local dep = <-2.9+.1*rand(sr), .25+.2*rand(sr), i>;
		#local fin = <-2.6+.2*rand(sr), .1, i+(.3*rand(sr)-.15)>;
		// Paille_brin(dep, fin, larg, turb, sturb, nbs, st)
		Paille_brin(dep, fin, .03, .2, 4, 5, sr)
		#local i = i+.05+.2*rand(sr);
	#end
	}
	texture {
		pigment {
			spotted
			turbulence .4 octaves 2
			scale <.2,.005,.2>
			color_map {
				[.2 color rgb<1,.9,.3>]
				[.5 color rgb<.9,.7,.4>]
				[.8 color rgb<.9,.5,.1>]
			}
		}
	}
} 


#end


#end
