#declare test_poche_inc = off;

#declare Poche = merge {
	difference {
		merge {
			cylinder { 0, .11*y, .1 }
			cone { .1*y, .1, .4*y, .4 }
		}
		union {
			cylinder { -.01*y, .11*y, .09 }
			cone { .1*y, .09, .4*y, .39 }
		}
	}
	difference {
		cylinder { .4*y, 1.2*y, .4 }
		cylinder { .39*y, 1.19*y, .39 }
	}
	texture {
		pigment {
			planar
			scale <1,.4,1>
			pigment_map {
				[ 0.8 color rgbf<.98,.99,1,.9> ]
				[ 0.8 gradient x scale <1.2,1,1> color_map {
					#local i=.3;
					#while (i<=.9)
						[i color rgbf<.98,.99,1,.9> ]
						[i color rgbf<.98,.99,1,.0> ]
						[i+.01 color rgbf<.98,.99,1,.0> ]
						[i+.01 color rgbf<.98,.99,1,.9> ]
						#local i=i+.1;
					#end
					} ]
			}
			rotate z*90
		}
		normal { bozo .2 turbulence .3 scale .2 }
		finish { diffuse 0 ambient 0 specular .3 roughness .03 }
	}
	interior {
		ior 1.6
		caustics .6
	}
}

#declare Liquide = merge {
	cylinder { 0, .11*y, .089 }
	cone { .1*y, .089, .4*y, .389 }
	cylinder { .4*y, 0.90*y, .389 }

	texture {
		pigment { color rgbf <1,.9,.5,.95> }
		finish { diffuse 0 ambient 0 }
	}
	interior {
		ior 1.5
	//	fade_distance .05
	//	fade_color <1,.9,.5>
	}
}

#declare Bouchon = difference {
	union {
		cylinder { .05*y, -.05*y, .11 }
		cone { -.05*y, .11, -.06*y, .03 }
	}
	union {
		cylinder { .06*y, 0, 1 }
		cylinder { .01*y, -.07*y, .02 }
	}
	texture {
		pigment { color rgb .95 }
	}
}

#declare Attache = union {
	difference {
		cylinder { 1.1*y, 1.15*y, .401 }
		cylinder { 1.09*y, 1.16*y, .40 }
	}
	box { <-.401, 1.1, -.02>, <-.40 , 1.2, .02> }
	box { < .40 , 1.1, -.02>, < .401, 1.2, .02> }
	box { <0.0  , 0.0, -.02>, < .001 , 1.0, .02>
		scale <1,.4*sqrt(2), 1>
		rotate -45*z
		translate -.401*x + 1.2*y
	}
	box { <-.001  , 0.0, -.02>, < 0 , 1.0, .02>
		scale <1,.4*sqrt(2), 1>
		rotate 45*z
		translate .401*x + 1.2*y
	}
	texture {
		pigment { rgb .1 }
	}
}

#declare Poche_Liquide = union {
	object { Poche }
	object { Liquide }
	object { Bouchon }
	object { Attache }
}

#if (test_poche_inc)


#version unofficial megapov 0.5;

#declare Use_Rad = off;

#if (Use_Rad)
global_settings {
	assumed_gamma 1.0
	max_trace_level 30
	adc_bailout   0.1
	ini_option "+QR"
	radiosity{
		count 30
		nearest_count 5
		error_bound .5
		recursion_limit 1
		brightness 1.0

		pretrace_start  .1
		pretrace_end  .02

		low_error_factor .5
		gray_threshold 0.0
		minimum_reuse 0.015
		normal off

		max_sample 1
		adc_bailout 0.05
	}
}

#default { texture { finish { diffuse 1 ambient 0 } } }

#else

global_settings {
	assumed_gamma 1.0
	max_trace_level 30
	adc_bailout   0.1
}

#default { texture { finish { diffuse .7 ambient 0.3 } } }

light_source { <15,15,-15>*100, color rgb .9 }
light_source { <-15,10,-15>*100, color rgb .3 shadowless }

#end

sky_sphere { pigment { rgb <.8, .9, 1> } }


camera {
	location <3, 5, -7>
	right x*4/3
	up y
	angle 40
	look_at <0,.8,0>
}

/*
light_source {
	<-15, 15, -15>*100, color rgb 1
}
*/

#local sr = seed(352);

//==============================
// SOL
//==============================

box { <-10, -.3, -3>, <10, -.05, 10> texture { pigment { rgb .5 } } }
union{
#declare Bloc1 = union {
	box { <-1, 0, -1>, <1, .1, 1> }
	sphere { 0, .1 translate -x-z }
	sphere { 0, .1 translate -x+z }
	sphere { 0, .1 translate x-z }
	sphere { 0, .1 translate x+z }
	cylinder { -x-z, x-z, .1 }
	cylinder { -x-z, -x+z, .1 }
	cylinder { x-z, x+z, .1 }
	cylinder { -x+z, x+z, .1 }
	scale <.505/1.1, 1, .505/1.1>
	scale <1.4,1,1.4>
}

#local st=seed(3521);

#local i=-10;
#while (i<10)
	#local j=-3;
	#while (j<11)
		object { Bloc1
			rotate <.5*(-1+2*rand(st)), 1*(-1+2*rand(st)), .5*(-1+2*rand(st))>
			translate <i, -.1, j>
		}
		#local j=j+1.4;
	#end
	#local i=i+1.4;
#end
	texture {
		pigment { color rgb .9 }
		normal {
			average
			normal_map {
				[1 bozo .1 scale .1 turbulence .1 octaves 3]
				[1 dents .5 scale .05 ]
			}
		}
		finish {
			brilliance .6
			reflection_min 0
			reflection_max .3
			reflection_falloff 2
			specular .2 roughness .01
			phong .1 phong_size 5
		}
	}
}

object {
	Poche_Liquide
	scale 2
}


#end
