// beaker.inc

#local thick = 0.002;
#local rad = 0.04;
#local height = 0.10;
#local torRad = 0.007;
#local rad2 = rad+2*torRad-thick;
#local liquidheight = 0.06;

#declare Beaker = merge {
	cylinder { <0,0,0>, <0,thick,0>, rad+0.00001 }
	difference {
		torus { rad, torRad }
		torus { rad, torRad-thick }
		cylinder { <0,-2*torRad,0>, <0,2*torRad,0>, rad }
		plane { -y, 0 }
		translate <0,torRad,0>
	}
	difference {
		cylinder { <0,torRad-0.00001,0>, <0,height+0.00001,0>, rad+torRad }
		cylinder { <0,torRad-0.1,0>, <0,height+0.1,0>, rad+torRad-thick }
	}
	difference {
		torus { rad2, torRad }
		torus { rad2, torRad-thick }
		cone { <0,0,0>, rad2, <0,rad2,0>, 0
			inverse
		}
		plane { y, 0 }
		translate <0,height,0>
	}
	torus { rad2-(torRad-thick/2)*sin(radians(45)), thick/2
		translate <0,height+(torRad-thick/2)*sin(radians(45)),0>
	}

	// glass texture
	texture { T_glass }
	interior { I_glass }
}

#declare BeakerLiquid = merge {
	cylinder { <0,torRad,0>, <0,liquidheight,0>, rad+torRad-thick-0.00001 }
	cylinder { <0,thick+0.00001,0>, <0,torRad+0.0001,0>, rad }
	torus { rad, torRad-thick-0.00001 }
	texture {
		pigment { rgbf <0.6,0.7,1,1> }
	}
	interior {
		ior 1.33
		caustics 0.3
	}
}