// flask.inc

#declare flaskThick = 0.003;
#local bottomRad = 0.06;
#local torRad = 0.01;
#local slope = radians(30);
#local y1 = - bottomRad * tan(slope);
#local y2 = y1 + (bottomRad + torRad) * tan(slope);
#local y3 = torRad + (torRad - flaskThick) * sin(slope);
#local r3 = bottomRad + (torRad - flaskThick) * cos(slope);
#local y4 = y3 + r3 / tan(slope);
#local r4 = r3 + flaskThick / cos(slope);
#local y5 = y4 + flaskThick / sin(slope);
#local neckRad = 0.015;
#local y10 = y3 + (r3 - neckRad + flaskThick) / tan(slope) + torRad * tan(slope/2);
#local ycoff = (r3 - neckRad + flaskThick - torRad * (1 - cos(slope))) * (tan(slope) + 1 / tan(slope)) - y10;
#local neckHeight = 0.07;

#declare ConicalFlask = merge {
	// base
	cylinder { <0,0,0>, <0,flaskThick,0>, bottomRad + 0.00001 }
	// base curve
	difference {
		torus { bottomRad, torRad }
		torus { bottomRad, torRad-flaskThick }
		cylinder { <0,y1,0>, <0,y2,0>, bottomRad }
		cone { <0,y1,0>, 0, <0,y5,0>, bottomRad + torRad + (y5 - y2 - torRad) / tan(slope) }
		translate <0, torRad, 0>
	}
	// cone walls
	difference {
		cone { <0,y3,0>, r4, <0,y5,0>, 0 }
		cone { <0,y3-0.00001,0>, r3, <0,y4,0>, 0 }
		cone { <0,y1+torRad-0.00001,0>, 0, <0,y5-0.00001,0>, bottomRad + torRad + (y5 - y2 - torRad) / tan(slope)
			inverse
		}
		cone { <0,y1+torRad+ycoff+y10+0.00001,0>, 0, <0,y5+ycoff+y10+0.00001,0>, bottomRad + torRad + (y5 - y2 - torRad) / tan(slope)
		}
	}
	// top curve
	difference {
		torus { neckRad+torRad-flaskThick, torRad }
		torus { neckRad+torRad-flaskThick, torRad-flaskThick }
		plane { -y, 0 }
		cone { <0,y1+torRad+ycoff,0>, 0, <0,y5+ycoff,0>, bottomRad + torRad + (y5 - y2 - torRad) / tan(slope)
			inverse
		}
		translate <0, y10, 0>
	}
	// neck
	difference {
		cylinder { <0,y10-0.00001,0>, <0,y10+neckHeight,0>, neckRad }
		cylinder { <0,y10-0.001,0>, <0,y10+neckHeight+0.001,0>, neckRad-flaskThick }
	}
	// lip
	torus { neckRad, flaskThick
		translate <0,y10+neckHeight,0>
	}
	
	// glass texture
	texture { T_glass }
	interior { I_glass }
}