// retort.inc

#local length = 0.2;
#local breadth = 0.14;
#local thick = 0.01;
#local height = 0.5;
#local rad = 0.004;
#local x1 = -0.07;
#local clampheight = 0.35;
#local clamplength = 0.06;
#local clampthick = 0.025;
#local clamparm = 0.15;
#local screwrad = 0.003;
#local screwlength = clampthick/2 + 0.01;
#local screwarm = 0.02;

#declare Retort = union {
	// base
	superellipsoid { <0.2,0.2>
		scale <length,thick,breadth>/2
	}
	// post with rounded end
	cylinder { <x1,0,0>, <x1,height,0>, rad }
	sphere { <x1,height,0>, rad }
	// clamp to post with screw
	superellipsoid { <1.5,0.5>
		scale <clamplength,clampthick,clampthick>/2
		translate <x1,clampheight,0>
	}
	union {
		cylinder { <0,0,0>, <0,0,screwlength>, screwrad }
		cylinder { <-screwarm,0,0>, <screwarm,0,0>, screwrad }
		sphere { <-screwarm,0,0>, screwrad }
		sphere { <screwarm,0,0>, screwrad }
		rotate <0,0,56>
		translate <x1,clampheight,-screwlength>
	}
	// arm of clamp with screw
	cylinder { <x1,clampheight,0>, <x1+clamparm,clampheight,0>, rad }
	union {
		cylinder { <0,0,0>, <0,0,screwlength>, screwrad }
		cylinder { <-screwarm,0,0>, <screwarm,0,0>, screwrad }
		sphere { <-screwarm,0,0>, screwrad }
		sphere { <screwarm,0,0>, screwrad }
		rotate <0,0,133>
		translate <x1+clamparm-clamplength/4,clampheight,-screwlength>
	}
	// clamp jaws
	difference {
		superellipsoid { <1.5,0.5>
			rotate <90,0,0>
			scale <clamplength,clampthick,clampthick>/2
		}
		plane { z, 0 }
		box { <0,0,-clamplength>, <clamplength*2,clampthick/4,clamplength> }
		box { <0,-clampthick/2,-clamplength>, <clamplength*2,-clampthick/4,clamplength> }
		cylinder { <0,-clampthick,0>, <0,clampthick,0>, clampthick/4
			scale <clamplength/clampthick,1,1>
		}
		translate <x1+clamparm,clampheight,0>		
	}
	difference {
		superellipsoid { <1.5,0.5>
			rotate <90,0,0>
			scale <clamplength,clampthick,clampthick>/2
		}
		plane { z, 0 }
		box { <0,0,-clamplength>, <clamplength*2,clampthick/4,clamplength> }
		box { <0,-clampthick/2,-clamplength>, <clamplength*2,-clampthick/4,clamplength> }
		cylinder { <0,-clampthick,0>, <0,clampthick,0>, clampthick/4
			scale <clamplength/clampthick,1,1>
		}
		rotate <180,0,0>
		translate <x1+clamparm,clampheight,0>		
	}
	// texture
	texture {
		pigment { rgb <0.3,0.4,0.4>
		}
		finish {
			reflection 0.1
			phong 0.8
			phong_size 100
		}
	}
	texture {
		pigment { bozo
			colour_map {
				[0.0 rgbf <1,1,1,1>]
				[0.8 rgbf <1,1,1,1>]
				[0.9 rgbf <1,0.5,0.4,0.5>]
				[1.0 rgb <0.8,0.4,0.3>]
			}
			turbulence 0.9
			omega 0.7
			scale <0.1,0.1,0.01>
		}
	}
}