// table.inc

#include "woods.inc"

#local legThick = 0.03;
#declare legLength = 0.9;
#local legInset = 0.13;
#local tableWidth = 1.1;
#local tableLength = 1.5;
#declare tableThick = 0.03;

#local T_legs =
	texture { pigment{ P_WoodGrain1A colour_map { M_Wood3A }} rotate <90,0,0> scale 0.3 }
	texture { pigment{ P_WoodGrain17B colour_map { M_Wood5B }} rotate <90,0,0> scale 0.3 }
/*
texture {
	pigment { wood
		colour_map {
			[0.0 rgb <1,0.7,0.4> ]
			[0.8 rgb <0.9,0.7,0.3> ]
			[1.0 rgb <0.6,0.2,0.1> ]
		}
		turbulence 0.1
		scale 0.01
	}
}
*/

#declare T_Top =
	texture { pigment{ P_WoodGrain1A colour_map { M_Wood13A }}} // wood grain
	texture { pigment{ P_WoodGrain1B colour_map { M_Wood13B }}} // wood overlay
	texture { // dirt overlay
		pigment { bozo
			colour_map {
				[0.0 rgbf <0.4,0.8,0.8,0.5>]
				[0.02 rgbf <0.6,0.9,0.9,0.8>]
				[0.05 rgbf <1,1,1,1>]
				[0.9 rgbf <1,1,1,1>]
				[0.95 rgbf <0.4,0.3,0.1,0.8>]
				[1.0 rgbf <0.1,0.2,0.15,0.6>]
			}
			turbulence <0.5,0,0.1>
			omega 0.9
			scale 0.9
			translate <0,0,-0.3>
		}
	}
    

#declare Table = union {
	box { <-legThick,0,-legThick>, <legThick,legLength,legThick>
		translate <-tableLength/2+legInset,0,-tableWidth/2+legInset>
	}
	box { <-legThick,0,-legThick>, <legThick,legLength,legThick>
		translate <tableLength/2-legInset,0,-tableWidth/2+legInset>
	}
	box { <-legThick,0,-legThick>, <legThick,legLength,legThick>
		translate <-tableLength/2+legInset,0,tableWidth/2-legInset>
	}
	box { <-legThick,0,-legThick>, <legThick,legLength,legThick>
		translate <tableLength/2-legInset,0,tableWidth/2-legInset>
	}
	box { <-tableLength/2,legLength,-tableWidth/2>, <tableLength/2,legLength+tableThick,tableWidth/2>
		texture {
			T_Top
			scale 0.5
		}
	}
	texture {
		T_legs
	}
}