// Frasco Scene File
// (POV-Ray ver 3.1g)
// By S.Nishimura 


#include "coordinate_color.mcr.inc"


global_settings { assumed_gamma 2.2 }


//
camera { angle 60
	 right < 4/3, 0, 0 >
	 location < 0, 0, -500 >
	 look_at < 0, 0, 0 >
}

//
light_source { < 300,   0, -1000 > color rgb 0.5 }
light_source { <   0, 400, -1000 > color rgb 0.5 }
light_source { < 300, 400, -1000 > color rgb 1
    spotlight
    radius 20
    falloff 30
    tightness 10
    area_light < 5, 0, 0 >, < 0, 0, 5 >, 5, 5
    adaptive 1
    jitter
    point_at < 0, 0, 0 >
  }


//***********************************************************
coordinate_color( 70, 0.5, 0.6, 1, 0 )
background { color rgb < R0, G0, B0 > }
//
sky_sphere {
 coordinate_color( 210, 0.67, 0.40, 1, 1 )
 coordinate_color( 210, 0.12, 0.65, 1, 2 )
 coordinate_color(  30, 0.53, 0.80, 1, 3 )
 pigment { wrinkles
           turbulence 0.1                         
           color_map { [ 0.3 rgb < R1, G1, B1 > ]
                       [ 0.6 rgb < R2, G2, B2 > ]
                       [ 0.9 rgb < R3, G3, B3 > ] }
           scale 0.1
           rotate < 90, 45, 45 >
           translate 60*x }
}
//
plane { y, -80-12
 coordinate_color(  96, 0.95, 0.55, 1, 0 )
 coordinate_color( 292, 0.90, 0.55, 1, 1 )
 coordinate_color( 300, 0.67, 0.55, 1, 2 )
 coordinate_color( 316, 0.41, 0.55, 1, 3 )
 coordinate_color(  44, 0.48, 0.55, 1, 4 )
 coordinate_color(  60, 0.67, 0.55, 1, 5 )
 coordinate_color(  68, 0.88, 0.55, 1, 6 )
 texture { 
  pigment { color rgbf < R0, G0, B0, 0.9 > }
  pigment { wrinkles 
            turbulence 0.05
            color_map { [ 0.0 rgbf < R1, G1, B1, 0.85 > ]
                        [ 0.1 rgbf < R2, G2, B2, 0.80 > ]
                        [ 0.3 rgbf < R3, G3, B3, 0.75 > ]
                        [ 0.5 rgbf < R4, G4, B4, 0.70 > ]
                        [ 0.7 rgbf < R5, G5, B5, 0.65 > ]
                        [ 1.0 rgbf < R6, G6, B6, 0.60 > ] }
            scale 40 }
  finish { reflection 0.5 } }
}
//***********************************************************
#include "FaceR03c.dat.inc"
#declare Face =
union {
 object { dxfobj0 // hair  
  coordinate_color( 164, 0.96, 0.74, 1, 1 )
  coordinate_color( 166, 0.97, 0.67, 1, 2 )
  coordinate_color( 184, 0.95, 0.63, 1, 4 )
  coordinate_color( 208, 0.88, 0.55, 1, 6 )
  texture { 
   pigment { gradient y
             turbulence 0.3
             frequency 0.8
             color_map { [ 0.0 rgbf < R1, G1, B1, 0.95 > ]
                         [ 0.2 rgbf < R2, G2, B2, 0.85 > ]
                         [ 0.4 rgbf < R2, G2, B2, 0.75 > ]
                         [ 0.6 rgbf < R4, G4, B4, 0.75 > ]
                         [ 0.8 rgbf < R4, G4, B4, 0.85 > ]
                         [ 1.0 rgbf < R6, G6, B6, 0.95 > ] } }
   normal { ripples 0.1 frequency 0.8 }
   finish { diffuse 0.4 reflection 0.1 specular 0.12 }
   rotate < 90-15, 0, 0 >
   scale 0.5 }
   interior { ior 1.45 }
  } 
 object { dxfobj1 // hair (eyebrow)
  texture {
   pigment { gradient y
             turbulence 0.3
             frequency 0.8
             color_map { [ 0.0 rgbf < R1, G1, B1, 0.95 > ]
                         [ 0.2 rgbf < R2, G2, B2, 0.85 > ]
                         [ 0.4 rgbf < R2, G2, B2, 0.75 > ]
                         [ 0.6 rgbf < R4, G4, B4, 0.75 > ]
                         [ 0.8 rgbf < R4, G4, B4, 0.85 > ]
                         [ 1.0 rgbf < R6, G6, B6, 0.95 > ] } }
   normal { ripples 0.1 frequency 0.8 }
   finish { diffuse 0.4 reflection 0.1 specular 0.12 }
   rotate < 90-15, 0, 0 >
   scale 0.5 }
   interior { ior 1.45 }
  }
 object { dxfobj2 // face 
  coordinate_color( 330, 0.48, 0.80, 1, 7 )
  texture { pigment { color rgb < R7, G7, B7 > } }
  normal { bumps 0.1 scale 0.08 } 
  }
 object { dxfobj3 // mouth
  coordinate_color( 293, 1.00, 0.72, 1, 8 )
  texture { pigment { color rgb < R8, G8, B8 > } }
  normal { bumps 0.2 scale 0.1 }
  }
 object { dxfobj4 // eyemask 
  coordinate_color( 360, 1.00, 1.00, 1, 9 )
  texture { pigment { color rgb <  R9, G9, B9 > } } 
  }
 sphere { < 5, 71, -84 >, 8 // L_eye
  coordinate_color(  30, 0.70, 0.70, 1, 1 )
  coordinate_color(  30, 0.14, 0.55, 1, 3 )
  coordinate_color( 150, 0.14, 0.45, 1, 4 )
  coordinate_color( 210, 0.08, 0.45, 1, 5 )
  texture {
   pigment { wood
             color_map { [ 0.0 rgbf < R1, G1, B1, 0.4 > ]
                         [ 0.4 rgbf < R1, G1, B1, 0.4 > ]
                         [ 0.6 rgbf < R3, G3, B3, 0.4 > ]
                         [ 0.8 rgbf < R4, G4, B4, 0.4 > ]
                         [ 1.0 rgbf < R5, G5, B5, 0.4 > ] }
             scale 1.1
             rotate < 90, 0, 0 > }
   finish { diffuse 0.15
            reflection 0.15
            specular 0.6
            roughness 0.002
            phong 1
            phong_size 50 }
  }
  interior { ior 2.25 }
  scale < 1, 1, 0.48 >
  rotate < 1, -22, 0 >
  }
 sphere { < -5, 71, -84 >, 8 // R_eye
  texture {
   pigment { wood
             color_map { [ 0.0 rgbf < R1, G1, B1, 0.4 > ]
                         [ 0.4 rgbf < R1, G1, B1, 0.4 > ]
                         [ 0.6 rgbf < R3, G3, B3, 0.4 > ]
                         [ 0.8 rgbf < R4, G4, B4, 0.4 > ]
                         [ 1.0 rgbf < R5, G5, B5, 0.4 > ] }
             scale 1.1
             rotate < 90, 0, 0 > }
   finish { diffuse 0.15
            reflection 0.15
            specular 0.6
            roughness 0.002
            phong 1
            phong_size 50 }
  }
  interior { ior 2.25 }
  scale < 1, 1, 0.48 >
  rotate < 1, 22, 0 >
  }  
}
object { Face rotate < -60, 60, -60 > translate < -200, -60, 0 > }
//***********************************************************
coordinate_color( 270, 0.2, 0.85, 1, 1 )
#local T_Frasco =
  texture {
  pigment { color rgbf < R1, G1, B1, 0.94 > }
  finish { diffuse 0.15
           reflection 0.15
           specular 0.6
           roughness 0.002
           phong 1
           phong_size 100 }
 }

//
#local Flask =
merge {
 torus { 12, 1.5 translate 180*y }
 cylinder { 100*y, 180*y, 12 }
 cone { 0*y, 60, 100*y, 12 }
 torus { 60-(8-1), 8 translate -4*y }
 disc { < 0, -12, 0 > y, 60-(8-1) }
}
//
union {
object { Flask texture { T_Frasco } interior { ior 1.0 } hollow }
difference {
 object { Flask }
 box { < -62, 50, -62 >  < 62,  180+1, 62 > }
 coordinate_color( 270, 0.9, 0.5, 3, 1 )
 texture {
 pigment { color rgbt < R1, G1, B1, 0.5 > }
 }
 scale 0.98 }
 translate < -100, -80, 60 >
}

//
#local Beaker =
merge {
 torus { 40, 1.5 translate 100*y }
 cylinder { 0*y, 100*y, 40 }
 torus { 40-8, 8 }
 disc { < 0, -8, 0 > y, 40-8 }
}
//
union {
object { Beaker texture { T_Frasco } interior { ior 1.0 } hollow }
difference {
 object { Beaker }
 box { < -42, 50, -42 >  < 42,  180+1, 42 > }
 //coordinate_color( 270, 0.9, 0.5, 3, 1 )
 texture {
 pigment { color rgbt < R2, G2, B2, 0.5 > }
 }
 scale 0.98 }
 translate < 20, -80-4, 0 >
}

//
#local Frasco =
merge {
 torus { 12, 1.5 translate 180*y }
 cylinder { 100*y, 180*y, 12 }
 sphere { < 0, 50, 0 > 62 }
}
//
union {
object { Frasco texture { T_Frasco } interior { ior 1.0 } hollow }
difference {
 object { Frasco }
 box { < -64, 50, -64 >  < 64,  180+1, 64 > }
 //coordinate_color( 270, 0.9, 0.5, 3, 1 )
 texture {
 pigment { color rgbt < R3, G3, B3, 0.4 > }
 }
 scale 0.98 }
 translate < 140, -80, 0 >
}

//
#local Test_tube =
merge {
 torus { 12, 1.5 translate 180*y }
 cylinder { 0*y, 180*y, 12 }
 sphere { < 0, 0, 0 > 12 }
}
//
union {
object { Test_tube texture { T_Frasco } interior { ior 1.0 } hollow }
difference {
 object { Test_tube }
 box { < -14, 50, -14 >  < 14,  180+1, 14 > }
 coordinate_color( 270, 0.9, 0.5, 2, 1 )
 texture {
 pigment { color rgbt < R2, G2, B2, 0.6 > }
 }
 scale 0.98 }
 translate < 240, -80, 0 >
}

//
#local Pipet =
merge {
 torus { 6, 1.5 rotate 90*z }
 cylinder { 0*x, 200*x, 6 }
 sphere { 60*x 10 scale < 1.5, 1, 1 > }
 cone { 200*x, 6, 280*x, 3 }
}
coordinate_color( 270, 0.9, 0.5, 3, 1 )
object { Pipet
 texture { T_Frasco } interior { ior 1.0 } hollow
 pigment { color rgbt < R1, G1, B1, 0.8 > }
 scale < 0.8, 0.4, 0.4 > rotate -30*y translate < -60, -80, -260 > }
//***********************************************************
#include "LadyR01b.dat.inc"
#declare Lady =
union {
 object { dxfobj0 // underwear
  coordinate_color( 90, 0.86, 0.50, 1, 0 )
  texture { pigment { color rgbf < R0, G0, B0, 0.3 > } }
  coordinate_color( 297, 0.85, 0.68, 1, 1 )
  coordinate_color( 286, 0.75, 0.63, 1, 2 )
  coordinate_color( 275, 0.69, 0.58, 1, 3 )
  coordinate_color( 266, 0.71, 0.55, 1, 4 )
  coordinate_color( 258, 0.80, 0.55, 1, 5 )
  coordinate_color( 252, 0.90, 0.55, 1, 6 )
  texture {
   pigment { marble 
             color_map { [ 0.00 rgbf < R1, G1, B1, 0.6 > ]
                         [ 0.15 rgbf < R2, G2, B2, 0.6 > ]
                         [ 0.35 rgbf < R3, G3, B3, 0.6 > ]
                         [ 0.55 rgbf < R4, G4, B4, 0.6 > ]
                         [ 0.75 rgbf < R5, G5, B5, 0.6 > ]
                         [ 0.85 rgbf < R6, G6, B6, 0.6 > ] } }
   normal { ripples 0.4 frequency 0.6 }
   scale < 0.05, 0.10, 0.15 > } 
 }
 object { dxfobj1 // body
  coordinate_color( 330, 0.48, 0.80, 1, 7 )
  texture { pigment { color rgb < R7, G7, B7 > } }
  normal { bumps 0.1 scale 0.08 } 
 }
 object { dxfobj2 // hair 
  coordinate_color(  90, 0.25, 0.15, 1, 0 )
  texture { pigment { color rgb < R0, G0, B0 > } }
  coordinate_color( 164, 0.96, 0.74, 1, 1 )
  coordinate_color( 166, 0.97, 0.67, 1, 2 )
  coordinate_color( 184, 0.95, 0.63, 1, 4 )
  coordinate_color( 208, 0.88, 0.55, 1, 6 )
  texture { 
   pigment { gradient y
             turbulence 0.3
             frequency 0.8
             color_map { [ 0.0 rgbf < R1, G1, B1, 0.95 > ]
                         [ 0.2 rgbf < R2, G2, B2, 0.85 > ]
                         [ 0.4 rgbf < R2, G2, B2, 0.75 > ]
                         [ 0.6 rgbf < R4, G4, B4, 0.75 > ]
                         [ 0.8 rgbf < R4, G4, B4, 0.85 > ]
                         [ 1.0 rgbf < R6, G6, B6, 0.95 > ] } }
   normal { ripples 0.1 frequency 0.8 }
   finish { diffuse 0.4 reflection 0.1 specular 0.12 }
   rotate < 90-15, 0, 0 >
   scale 0.5 }
  interior { ior 1.45 } 
 }
 object { dxfobj3 // mouth
  coordinate_color( 293, 1.00, 0.72, 1, 7 )
  texture { pigment { color rgb < R7, G7, B7 > } }
  normal { bumps 0.2 scale 0.1 }  
 }
 object { dxfobj4 // eyemask
  coordinate_color( 360, 0.00, 1.00, 1, 8 )
  texture { pigment { color rgb < R8, G8, B8 > } }
 }
 object { dxfobj5 // eyebrow
  coordinate_color( 172, 0.81, 0.50, 1, 0 )
  texture { pigment { color rgb < R0, G0, B0 > } }
  coordinate_color( 109, 1.00, 0.45, 1, 1 )
  coordinate_color( 255, 0.90, 0.90, 1, 2 )
  coordinate_color( 255, 0.91, 0.78, 1, 4 )
  coordinate_color( 255, 0.92, 0.56, 1, 6 )
  texture { 
   pigment { gradient x
             color_map { [ 0.00 rgbf < R1, G1, B1, 0 > ]
                         [ 0.20 rgbf < R2, G2, B2, 0.65 > ]
                         [ 0.40 rgbf < R2, G2, B2, 0.65 > ]
                         [ 0.60 rgbf < R4, G4, B4, 0.85 > ]
                         [ 0.80 rgbf < R4, G4, B4, 0.85 > ]
                         [ 1.00 rgbf < R6, G6, B6, 0.95 > ] } }
   normal { bumps 0.1 scale 0.1 }
   scale < 0.01, 0.2, 0.3 > } 
 }
 sphere { < 4.2, 133, 11.5 > 1.7 // L_eye
  coordinate_color( 101, 0.69, 0.65, 1, 1 )
  coordinate_color( 109, 0.74, 0.60, 1, 2 )
  coordinate_color( 136, 0.54, 0.40, 1, 3 )
  coordinate_color( 150, 0.73, 0.30, 1, 4 )
  coordinate_color( 161, 1.00, 0.25, 1, 5 )
  texture {
   pigment { wood
             color_map { [ 0.0 rgbf < R1, G1, B1, 0.4 > ]
                         [ 0.4 rgbf < R2, G2, B2, 0.4 > ]
                         [ 0.6 rgbf < R3, G3, B3, 0.4 > ]
                         [ 0.8 rgbf < R4, G4, B4, 0.4 > ]
                         [ 1.0 rgbf < R5, G5, B5, 0.4 > ] }
             scale 1.1
             rotate < 90, 0, 0 > }
   finish { diffuse 0.15
            reflection 0.15
            specular 0.6
            roughness 0.002
            phong 1
            phong_size 50 } }
  interior { ior 2.25 } 
 }
 sphere { < -4.0, 133, 11.5 > 1.7 // R_eye
  texture {
   pigment { wood
             color_map { [ 0.0 rgbf < R1, G1, B1, 0.4 > ]
                         [ 0.4 rgbf < R2, G2, B2, 0.4 > ]
                         [ 0.6 rgbf < R3, G3, B3, 0.4 > ]
                         [ 0.8 rgbf < R4, G4, B4, 0.4 > ]
                         [ 1.0 rgbf < R5, G5, B5, 0.4 > ] }
             scale 1.1
             rotate < 90, 0, 0 > }
   finish { diffuse 0.15
            reflection 0.15
            specular 0.6
            roughness 0.002
            phong 1
            phong_size 50 } }
  interior { ior 2.25 }
 }
}
object { Lady scale 0.5 rotate < 0,-30, 0 > translate < 140, -50, 0 > }
//
//object { Lady scale 2.0 rotate < 0, 80, 0 > translate < 350, -50+80, 360 > }
//***********************************************************
// locuse of uniform velocity motion
#macro Uvm_locus(P0,Lr,Func_type)
 #local Sp=-pi; #local Ep=pi; #local Ap=pi/8;
#while(Sp<Ep)
 #switch (Func_type)
  #case(0) #local Mv=radians(110); #local Mh=radians(-50)-atan2( cos(Sp),1); #break
  #case(1) #local Mv=radians(105); #local Mh=radians(-60)-atan2( cos(Sp),1); #break
  #case(2) #local Mv=radians(115); #local Mh=radians(-48)+atan2(-sin(Sp),1); #break
  #case(3) #local Mv=radians(105); #local Mh=radians(-60)+atan2(-sin(Sp),1); #break
  #case(4) #local Mv=radians(110); #local Mh=radians(-50)+atan2(-sin(Sp),1); #break
 #end
#if ( 0 = mod(Sp, Ap*2)) 
 object { Locus_seg01 texture { T_locus } transform Tfm_prism rotate <-45,0,90-degrees(Mv)> rotate (-degrees(Mh))*y translate P0 }
#else
 object { Locus_seg02 texture { T_locus } transform Tfm_prism rotate < 45,0,90-degrees(Mv)> rotate (-degrees(Mh))*y translate P0 }
#end
// next stage value
 #local P0=P0+<Lr*sin(Mv)*cos(Mh),Lr*cos(Mv),Lr*sin(Mv)*sin(Mh)>;
 #local Sp=Sp+Ap;
#end // while end
#end // macro end
//***********************************************************
// Locus definition
coordinate_color( 30, 0.43, 0.63, 1, 1 )
#local T_locus =
 texture {
   pigment { color rgbt < R1, G1, B1, 0.4 > }
    finish { metallic
             ambient 0.1
             diffuse 0.4
             reflection 0.25
             specular 1 }
 }
#local Tfm_prism =
 transform { translate -1*y rotate -90*x scale < 1, 1, 2 >*7.2 }
//***********************************************************
#include "TextBz01a.dat.inc"
//
#local P0=< -320, 220, 120 >; #local Lr=20;
union { 
 Uvm_locus(P0,Lr,2)
 Uvm_locus(P0,Lr,3)
 Uvm_locus(P0,Lr,4)
 rotate < 0, -160, 0 >
 no_shadow
}
//***********************************************************
#include "TextBz02a.dat.inc"
//
#local P0=< -320, 220, 120 >; #local Lr=20;
union { 
 Uvm_locus(P0,Lr,2)
 Uvm_locus(P0,Lr,3)
 Uvm_locus(P0,Lr,4)
 rotate < -4, 2, 0 > translate 16*x
 no_shadow
}
//***********************************************************
// Curved line
#include "curved_line.mcr.inc"
#local Crvobj =
union {
 coordinate_color( 360*0/24, 0.7, 0.8, 1, 1 )
 #union { Curved_line(0.1,-pi,pi*2.6,pi/8,tan(radians(135)),0) pigment { color rgb < R1, G1, B1 > } }
 coordinate_color( 360*5/24, 0.7, 0.8, 1, 1 )
 #union { Curved_line(0.1,-pi,pi,pi/8,(-2/3)*(cos(-pi)/sin(-pi)),5) pigment { color rgb < R1, G1, B1 > } }
 coordinate_color( 360*11/24, 0.7, 0.8, 1, 1 )
 #union { Curved_line(0.1,-pi,pi,pi/38,tan(radians(180+1.0e-12)),11) pigment { color rgb < R1, G1, B1 > } }
}
// parameter Lw:Bp:Ep:Ap:Mx:Func_type
union {
 object { Crvobj }
 coordinate_color( 360*16/24, 0.7, 0.8, 1, 1 )
 #union { Curved_line(0.1,-pi*2,pi*2,pi/30,tan(radians(180)),12) pigment { color rgb < R1, G1, B1 > } }
 scale 30 translate < 350, 100, 360 >
}
// parameter Lw:Bp:Ep:Ap:Mx:Func_type
union {
 object { Crvobj }
 coordinate_color( 360*16/24, 0.7, 0.8, 1, 1 )
 #union { Curved_line(0.1,-pi,pi,pi/76,tan(radians(90)),7) pigment { color rgb < R1, G1, B1 > } }
 scale 30 translate < 350, 150, 360 >
}
// parameter Lw:Bp:Ep:Ap:Mx:Func_type
union {
 object { Crvobj }
 coordinate_color( 360*16/24, 0.7, 0.8, 1, 1 )
 #union { Curved_line(0.1,-pi,pi,pi/76,tan(radians(270)),8) pigment { color rgb < R1, G1, B1 > } }
 scale 30 translate < 350, 200, 360 >
}
// parameter Lw:Bp:Ep:Ap:Mx:Func_type
union {
 object { Crvobj }
 coordinate_color( 360*16/24, 0.7, 0.8, 1, 1 )
 #local Mx=(-2/3)*(sin(4*-pi)*sin(-pi)+cos(-pi)*cos(4*-pi))/(sin(4*-pi)*cos(-pi)+sin(-pi)*cos(4*-pi));
 #union { Curved_line(0.1,-pi,pi,pi/120,Mx,9) pigment { color rgb < R1, G1, B1 > } }
 scale 30 translate < 350, 250, 360 >
}
//*****************************************************************
// spark
coordinate_color( 360, 0,    0,    1, 1 )
coordinate_color( 356, 1.00, 0.45, 1, 2 )
coordinate_color(  16, 1.00, 0.40, 1, 3 )
coordinate_color( 349, 0.31, 0.55, 1, 4 )
#local M_spark =
 media { emission rgb 0.01
         intervals 50
         samples 1, 1
         confidence 0.999
         variance 0.001
         density { spherical
                   frequency 1
                   color_map { [ 0.0 rgb < R1, G1, B1 > ]
                               [ 0.4 rgb < R2, G2, B2 > ]
                               [ 0.6 rgb < R3, G3, B3 > ]
                               [ 0.8 rgb < R4, G4, B4 > ]
                             [ 0.999 rgb < R2, G2, B2 > ]
                               [ 1.0 rgb < R1, G1, B1 > ] }
          scale 21.5 }
 }
//
#local Spark_seg =
 sphere { 0 30 hollow pigment { color rgbt 1 } interior { media { M_spark } } scale 5 }
//
coordinate_color( 270, 1.00, 0.96, 1, 7 )
#local Sparkobj =
union {
 sphere { 0 22 scale < 1, 1, 0.1 > pigment { color rgbt < R7, G7, B7, 0.3 > } finish { reflection 0.5 } }
 object { Spark_seg scale < 12, 0.1, 0.1 > }
 object { Spark_seg scale <3.8, 0.1, 0.1 > rotate 120*z }
 object { Spark_seg scale <  6, 0.1, 0.1 > rotate 240*z }
}
//
object { Sparkobj rotate < 0, 10, 5 > translate < -300, 450, 1000 > }
//*****************************************************************


// Signature
//#include "Sealreverse.sgn.inc"
//object { Sealing translate < -110, -82, -300 > }
