// Persistence of Vision Ray Tracer Scene Description File
// File: Glasswar.pov
// Vers: 3.1
// Desc: Glassware
// Date: 29/10/2000
// Auth: Bruno Lailler
//

#version 3.1

#include "colors.inc"
#include "finish.inc"
#include "glass.inc"
#include "metals.inc"

// ---------------------------------------- Camera
camera {
  location  <100, 10, 0>
  direction 1.5*z
  right     4/3*x
  look_at   <0, 7, -2>
  //look_at   <0, 9, -6>
  angle 20
}

// ---------------------------------------- Lights
light_source {
  0*x 
  color rgb <0,0,.5>
  translate <20, 20, -100>
}

light_source {
  0*x 
  color Gray80
  area_light 
  <8,0,0> <0,0,8>
  4, 4 
  adaptive 0
  jitter 
  translate <-15, 20, -15>
} 

// ---------------------------------------- Decor
// Set a color of the background (sky)
//background { color red .2 green .2 blue .2 }

plane { 
  y, -1
  texture { T_Chrome_1E }
  normal { waves translate <0,0,-10> } 
}
plane { x, -20 
  pigment { color White }
  finish { Dull roughness 0.8 }
}

// ---------------------------------------- Objects declarations
#declare Erlenmeyer = 
union {
  difference {
    torus { 
      5, 1 sturm
      clipped_by { cylinder { -1*y, 0.375*y, 7 } }
      clipped_by { torus { 6, 1.7 }}
    }
  }
  cone { <0,0.375,0> 5.927 <0,10,0> 2 open }
  sphere { -12*y, 12 clipped_by { cylinder { -1*y, 1*y, 6 } } }
  cylinder { 10*y, 14*y, 2 open }
  torus { 
    2.5, 0.5 sturm 
    translate 14*y 
    clipped_by { cylinder { 14*y, 15*y, 2.5 } }
  }
  torus { 2.5, 0.1 sturm translate 14.6*y }
}

#declare Tube =
union {
  difference {
    union {
      sphere { 0*y, 1.5 } //clipped_by { plane { y, 0 } } }
      cylinder { 0*y, 15*y, 1.5 }
    }
    union {
      sphere { 0*y, 1.4 } //clipped_by { plane { y, 0 } } }
      cylinder { 0*y, 16*y, 1.4 }
    }
  }
  torus { 1.48, 0.08 sturm translate 15*y }
  pigment{
    image_map {
      png "Gradu3.png" once map_type 2 interpolate 2
      #declare n=0;
      #while (n<256)
        transmit n,1-pow(n/(256-1),1)
      #declare n=n+1;
      #end
    }
    scale <1, 5, 1>
    rotate 160*y
    translate 8*y
  }
  finish { ambient 0.5 diffuse 0.2 }
  texture { T_Glass2 }
  interior { ior 1.5 caustics 1 }
}

// ---------------------------------------- Staging

union {
  object { Erlenmeyer //texture { T_Glass2 } }
    pigment{
      image_map {
        png "Gradu.png" once map_type 2 interpolate 2
        #declare n=0;
        #while (n<256)
          transmit n,1-pow(n/(256-1),1)
        #declare n=n+1;
        #end
      }
      scale <.4, 20, .4>
      rotate 180*y
      translate -5*y
    }
    finish { ambient 0.5 diffuse 0.2 }
    interior { ior 1.5 caustics 1 }
  }
  
  object { Erlenmeyer 
    clipped_by { cylinder { -1.1*y, 14*y, 7 } }
    #declare Ech=0.98;
    scale Ech
    translate 7.3*(1-Ech)*y
    texture { T_Glass2 }
  } 
  translate 1*y
  rotate -30*x
  rotate 25*y
}

object { Erlenmeyer
  scale 0.95
  translate 1*y
  rotate -30*x
  rotate 25*y
  clipped_by { cylinder { -1.2*y, 11*y, 15 } }
  pigment { Black }
  finish { Glossy }
}
union {
  torus { 1.6, 0.3 sturm }
  cylinder { 0*y, 0.3*y, 1.6 }
  scale <1,1,1.16>
  clipped_by { cylinder { 0*y, 1*y, 3 } }
  rotate 2*x
  translate -6.33*z
  rotate 25*y
  translate 10.9*y
}
/*
sphere { // the top of the liquid
  <0,0,-5.5> 1.9
  scale <1,0.2,1.155>
  pigment { Black }
  finish { Glossy }
  clipped_by { cylinder { 0*y, 3*y, 20 } }
  rotate 2*x
  rotate 25*y
  translate 10.7*y
} */

object { Tube rotate 40*x rotate 20*y translate <-8,-4,5> }
object { Tube rotate 180*y rotate 60*x rotate 120*y translate <-18,-3,-8> }

