global_settings {assumed_gamma 1.5}

#declare UseRealGlobe=1;
#declare UseAreaLight=1;
#declare UseEnterprise=1;
#declare UseTrailLight=1;
#declare UseSextant=1;

#ifndef (UseRealGlobe) #declare UseRealGlobe=1; #end
#ifndef (UseAreaLight) #declare UseAreaLight=1; #end
#ifndef (UseEnterprise) #declare UseEnterprise=1; #end
#ifndef (UseTrailLight) #declare UseTrailLight=1; #end
#ifndef (UseSextant) #declare UseSextant=1; #end

#include "colors.inc"
#include "metals.inc"
#if (UseRealGlobe!=0) #include "globus.inc"
#else #declare Globus=sphere {335*y, 200 pigment {Blue}} #end
#if (UseEnterprise!=0) #include "big_e.inc" #end
#include "buch.inc"
#if (UseSextant!=0) #include "sextant.inc" #end

#declare EarthHeight=270*y;
#declare GlobusLocation=150*x;
#declare CameraLocation=<300, 600, -1500>;
#declare EnterpriseCamera=<60, 40, -200>/10;

#declare EnterpriseLocation=CameraLocation-EnterpriseCamera;
#declare EarthLocation=EarthHeight+GlobusLocation;

camera {location CameraLocation look_at EarthHeight-17 angle 30}
//camera {location EnterpriseLocation+<0, 600, 0>/10 look_at EnterpriseLocation angle 10}
//camera {location <150, 1000, 0> look_at <0, 0, 0> angle 30}

light_source {<3500, 500, -10000>+EarthHeight color White
	#if (UseAreaLight!=0) area_light 500*y, 500*<1, 0, 0.5>, 5, 5
		adaptive 0 #end}
light_source {<-10000, 0, 0>+EarthHeight color 0.3*White
	#if (UseAreaLight!=0) area_light 500*y, 500*z, 5, 5
		adaptive 0 #end}
light_source {EnterpriseLocation+<0, 100, -150> color 0.6*White
	spotlight radius 10/10 falloff 30/10 point_at EnterpriseLocation}

#declare Moon=sphere {0, 1 pigment {image_map {gif "moon.gif" map_type 1}
		rotate -90*y}
	finish {diffuse 0.9 ambient 0.1 specular 0}}
#if (UseEnterprise!=0)
	#declare Enterprise=object {NCC_1701_A} #end
#macro Fase(D) prism {linear_spline linear_sweep -1, 2, 4,
	<-1, -1>, <D, 0>, <0, D>, <-1, -1>} #end
/*
#macro Rand(D, L) difference {box {-D*y, <4*D, 0, L>}
		object {Fase(D) scale < 1, L,  1> rotate 90*x}
		object {Fase(D) scale <-1, L,  1> rotate 90*x translate 4*D*x}
		object {Fase(D) scale <-1, -4*D,  1> rotate 90*z}
		object {Fase(D) scale <-1, -4*D, -1> rotate 90*z translate L*z}
		translate D*y} #end
	difference {box {-D*y, <4*D, 0, L>}
		object {Fase(D) scale < 1, L,  1> rotate 90*x}
		object {Fase(D) scale <-1, L,  1> rotate 90*x translate 4*D*x}
		object {Fase(D) scale <-1, -4*D,  1> rotate 90*z}
		object {Fase(D) scale <-1, -4*D, -1> rotate 90*z translate L*z}
		translate D*y} #end
*/
#macro Rand(D, L) intersection {union {difference {box {-0.5*D*y, <4*D, 0, L>}
			cylinder {0, L*z, 0.5*D translate 4*D*x}}
		box {0.5*D*x, <3*D, 0.5*D, L>}
		cylinder {0, L*z, 0.5*D translate 0.5*D*x}
		cylinder {0, L*z, 0.5*D translate 3*D*x}
		translate 0.5*D*y}
	plane {x-z, 0} plane {x+z, 0 translate L*z}} #end
#declare F_Metal=finish {ambient 0.35 brilliance 2 diffuse 0.3  metallic
	specular 0.80 roughness 1/5 reflection 0.2}
#declare A=<-550, -30, -200>;
#declare B=<350, 0, 500>;
#declare Tisch=union {difference {box {A, B}
/*
		object {Fase(5) scale < 1, B.y-A.y,  1> translate A}
		object {Fase(5) scale <-1, B.y-A.y,  1>
			translate <B.x, A.y, A.z>}
		object {Fase(5) scale < 1, B.y-A.y, -1>
			translate <A.x, A.y, B.z>}
		object {Fase(5) scale <-1, B.y-A.y, -1>
			translate <B.x, A.y, B.z>}
*/
		object {Fase(5) scale < 1, B.z-A.z, -1> rotate 90*x
			translate A}
		object {Fase(5) scale <-1, B.z-A.z, -1> rotate 90*x
			translate <B.x, A.y, A.z>}
		object {Fase(5) scale < 1, B.x-A.x,  1> rotate 90*z
			translate A}
		object {Fase(5) scale < 1, B.x-A.x, -1> rotate 90*z
			translate <A.x, A.y, B.z>}
		texture {pigment {P_Chrome4} finish {F_Metal}}}
	union {object {Rand(5, B.z-A.z) translate <A.x, B.y, A.z>}
		object {Rand(5, B.z-A.z) scale <-1, 1, 1>
			translate <B.x, B.y, A.z>}
		object {Rand(5, B.x-A.x) rotate 90*y translate <A.x, B.y, B.z>}
		object {Rand(5, B.x-A.x) rotate 90*y scale <1, 1, -1>
			translate <A.x, B.y, A.z>}
		texture {pigment {P_Chrome5} finish {F_Metal}}}}
#macro Position(T) (50000*(vaxis_rotate(-x, <0.3, -1, 0>, T)+x)) #end
object {Globus rotate 15*y translate GlobusLocation}
object {Moon scale 50 translate <-144, 0, -68>+1.2*<-277, 375, 894>}
object {Tisch rotate 10*y}
#if (UseTrailLight) #declare Trail = merge {
	#declare I=0.3/10;
	#declare DI=0.2;
	#while (I<8)
		sphere {vrotate(<46.8, 25, 0>, 2*I*z)+Position(I), 5.6
			hollow no_shadow pigment {Clear} finish {specular 0}
			interior {media {emission 0.13*(1-I/8)}}}
		cylinder {vrotate(<46.8, 25, 0>, 2*I*z)+Position(I),
			vrotate(<46.8, 25, 0>, 2*(I+DI)*z)+Position(I+DI), 5.6
			hollow no_shadow pigment {Clear} finish {specular 0}
			interior {media {emission 0.13*(1-I/8)}}}
		sphere {vrotate(<-46.8, 25, 0>, 2*I*z)+Position(I), 5.6
			hollow no_shadow pigment {Clear} finish {specular 0}
			interior {media {emission 0.13*(1-I/8)}}}
		cylinder {vrotate(<-46.8, 25, 0>, 2*I*z)+Position(I),
			vrotate(<-46.8, 25, 0>, 2*(I+DI)*z)+Position(I+DI), 5.6
			hollow no_shadow pigment {Clear} finish {specular 0}
			interior {media {emission 0.13*(1-I/8)}}}
		#declare I=I+DI;
	#end
	} #end
union {#if (UseEnterprise!=0) object {Enterprise} #end
	#if (UseTrailLight!=0) object {Trail} #end
	rotate -10*z /* Rollen */ rotate -4*x /* Steigung */
	rotate 157*y /* Richtung */ scale 0.018 translate EnterpriseLocation}
object {Buch rotate -10*y translate <-420, 0, -50>}
#if (UseSextant!=0)
	object {Sextant scale 1.3 rotate 90*x translate <-210, 5, 330>} #end

#declare star_count=30000;
#declare star_distance=100000;
#declare star_scale=0.2;
#declare star_colour_turb=0.5;
#include "galaxy.sf"
#declare galaxy_object_name="Meteor2"
#declare galaxy_object_position=<-13, -24, 0>;
#declare galaxy_object_scale=0.2;
#declare galaxy_object_rotate=120;
#declare galaxy_cluster_name=""
#include "galaxy.obj"
