#version unofficial MegaPov 0.5;

#macro W(radius1, radius2, d, num) 
    #local seedx = seed(1000); 
    #local seedy = seed(1001);
    #local seedz = seed(1002);
    #local counter=0;  
    #while (counter != num)
        #local lx = 0.2 * rand(seedx);
        #local ly = 0.2 * rand(seedy); 
        #local lz = d * rand(seedz);
        torus{radius1, radius2 rotate x*90
            translate -y*(radius1 - radius2)
            scale <1, 1 + 2 * ly, 1>
            rotate <20*lx, 20*ly, 20*lz>   
            translate <lx, 0, -lz>
        }
        #local counter = counter + 1;
    #end 
    
    cylinder{0, <0, -2 * radius1, 0>, radius2 translate <-radius1*0.95, -radius1, -radius2*3> } 
#end 

/*
1.Number of helixes - e.g. 2 for a double helix 
2.Period - is related to the number of turns per unit length. 
3.Minor radius 
4.Major radius 
5.Shape parameter. If this is greater than 1 then the tube becomes fatter
  in the y direction. 
6.Cross section type. 
7.Cross section rotation angle (degrees). E.g. if you choose a square
  cross section and rotate it by 45 degrees you get a diamond cross
  section. 
*/
#declare LineObject =
isosurface {
	function   {"func_6", <5, 1, 0.3, 0.3, 2, 1, 0>, library "i_nfunc"}   
	contained_by{ box {<-0.5, -0, -0.5>, <0.5, 50, 0.5>}}
}

#declare CurveObject=
isosurface {
	function  {"func_12", <8.0, 20, 8, 0, 0.5, 0.7, 1/36, 0,0,0>, library "i_nfunc"}
	contained_by{ box {<-10, -2, -10>, <10, 2, 10>}}
} 

#declare AlarmLight = union {
    // base
    union {
        cylinder{0, <0, 0, -0.2>, 1}
        union {
            cylinder{0, <0, 0, -0.1>, 0.15} 
            cylinder{<0, 0, -0.1>, <0, 0, -0.16>, 0.05}
            box{<-0.15, -0.3, 0>, <0.15, 0, -0.1>}
            translate y*1.15
            rotate z*0
        } 
        union {
            cylinder{0, <0, 0, -0.1>, 0.15}
            cylinder{<0, 0, -0.1>, <0, 0, -0.16>, 0.05}
            box{<-0.15, -0.3, 0>, <0.15, 0, -0.1>}
            translate y*1.15
            rotate z*90
        }
        union {
            cylinder{0, <0, 0, -0.1>, 0.15}            
            cylinder{<0, 0, -0.1>, <0, 0, -0.16>, 0.05}
            box{<-0.15, -0.3, 0>, <0.15, 0, -0.1>}
            translate y*1.15
            rotate z*180
        }
        union {
            cylinder{0, <0, 0, -0.1>, 0.15}            
            cylinder{<0, 0, -0.1>, <0, 0, -0.16>, 0.05}
            box{<-0.15, -0.3, 0>, <0.15, 0, -0.1>}
            translate y*1.15
            rotate z*270
        }
    }  
    // frame
    union {
        union {
            cylinder{0, <0, 0, -1.8>, 0.05 translate <0, 0.85, -0.2>}
            difference{
                torus{0.85, 0.05 rotate<90, 90, 0>}
                plane{-z, 0}
                plane{y, 0}
                translate -z*2 
            }                 
            rotate z*0
        } 
        union {
            cylinder{0, <0, 0, -1.8>, 0.05 translate <0, 0.85, -0.2>}
            difference{
                torus{0.85, 0.05 rotate<90, 90, 0>}
                plane{-z, 0}
                plane{y, 0}
                translate -z*2 
            }                 
            rotate z*90
        }
        union {
            cylinder{0, <0, 0, -1.8>, 0.05 translate <0, 0.85, -0.2>}
            difference{
                torus{0.85, 0.05 rotate<90, 90, 0>}
                plane{-z, 0}
                plane{y, 0}
                translate -z*2 
            }                 
            rotate z*180
        }
        union {
            cylinder{0, <0, 0, -1.8>, 0.05 translate <0, 0.85, -0.2>}
            difference{
                torus{0.85, 0.05 rotate<90, 90, 0>}
                plane{-z, 0}
                plane{y, 0}
                translate -z*2 
            }                 
            rotate z*270
        }
        torus{0.95, 0.05 rotate x*90 translate -z*0.25} 
        torus{0.95, 0.05 rotate x*90 translate -z*0.8} 
        torus{0.95, 0.05 rotate x*90 translate -z*1.4}
        torus{0.95, 0.05 rotate x*90 translate -z*2.0}
        torus{0.70, 0.05 rotate x*90 translate -z*2.6}
    } 
    
    // glass
    union {
        cylinder{0, <0, 0, -2>, 0.7}
        sphere{0, 0.7 translate -z*2}
        pigment{color rgbf <0.82, 0.82, 0.8, 0.65>}
        finish{ambient 0.2 phong 1 phong_size 50 reflection 0.3}
    }
}

#declare Electric = union {
    intersection {
        plane {-z, 0 texture {Efront}}
        plane {-x, 0 texture {Eside rotate y*90}}
        plane {x, 0 translate x*1 texture {Eside rotate y*90}}
        plane {-y, 0 texture {Eside rotate x*90}}
        plane {z, 1}
        plane {y, 1 texture {Eside rotate x*90}}

        translate -z*1
	    scale <1, 1.2, 0.5>
	}  
	
	torus{0.3, 0.1 rotate <90, 90, 0> texture {Eside} translate <0.5, 0, 0>}
	
    union {
        W(1, 0.02, 0.1, 34) 
        texture {WiresTxt}
        scale 0.5 
        translate <0.5, -0.15, 0>
    }	
    
    #include "ewires.inc"
    object {Ewires translate <0.5, 1.2, 0>}  
    object{AlarmLight scale 0.2 rotate z*45 translate <2.65, 2.7, 0> 
        texture {TubeTexture scale <1, 0.31, 1> translate y*0.3}
    }
} 

	
	
	           
	           