#declare Nut = intersection {
    plane{y, 0.025}
    plane{-y, 0}
    plane{x, 0.04 rotate y*0}
    plane{x, 0.04 rotate y*60}
    plane{x, 0.04 rotate y*120}
    plane{x, 0.04 rotate y*180}
    plane{x, 0.04 rotate y*240}
    plane{x, 0.04 rotate y*300} 
}

#declare Hydro = union {
    cylinder{0, <0, 0.05, 0>, 0.35}     
    object{Nut scale 1.5 translate <0.25, 0.05, 0>} 
    object{Nut scale 1.5 translate <0.25, 0.05, 0> rotate y*60}
    object{Nut scale 1.5 translate <0.25, 0.05, 0> rotate y*120}
    object{Nut scale 1.5 translate <0.25, 0.05, 0> rotate y*180}
    object{Nut scale 1.5 translate <0.25, 0.05, 0> rotate y*240}
    object{Nut scale 1.5 translate <0.25, 0.05, 0> rotate y*300}
    cylinder{0, <0, 0.3, 0>, 0.15}
    cylinder{0, <0, 1.2, 0>, 0.12} 
    cylinder{0, <0, 0.4, 0>, 0.15 translate y*0.5} 
    cylinder{<0, 0.025>, <0, 0.4-0.025, 0>, 0.02 translate <0, 0.5, -0.15> rotate y*45} 
    cylinder{<0, 0.025>, <0, 0.4-0.025, 0>, 0.02 translate <0, 0.5, -0.15> rotate y*(45 + 90)}   
    cylinder{<0, 0.025>, <0, 0.4-0.025, 0>, 0.02 translate <0, 0.5, -0.15> rotate y*(45 + 180)}  
    cylinder{<0, 0.025>, <0, 0.4-0.025, 0>, 0.02 translate <0, 0.5, -0.15> rotate y*(45 + 270)}  
    torus{0.15, 0.025 translate y*0.275} 
    torus{0.15, 0.025 translate y*0.525}
    torus{0.15, 0.025 translate y*0.875} 
    
    difference{
        torus{0.25, 0.14}
        plane{x, 0}
        plane{z, 0}
        
        rotate -x*90
        translate <-0.25, 1.2, 0>
    }
    torus{0.14, 0.025 translate y*1.225}
    torus{0.14, 0.025 rotate z*90 translate <-0.225, 1.45, 0>}
    
    union {
        cylinder{0, <-2.2, 0, 0>, 0.12}          
        cylinder{0, <0, 0.4, 0>, 0.05 translate <-0.2, 0, 0>} 
        cylinder{0, <0, 0.025, 0>, 0.1 translate <-0.2, 0.18, 0>}  
        cylinder{0, <0, 0.15, 0>, 0.08 translate <-0.2, 0.2, 0>} 
        cylinder{0, <0.12, 0, 0>, 0.04 translate <-0.2, 0.3, 0>} 
        
        translate <-0.25, 1.45, 0>
    }  
    
    cylinder{0, <0.6, 0, 0>, 0.16 translate <-1.3, 1.45, 0>}
    sphere{0, 0.16 translate <-1.3, 1.45, 0>}
    sphere{0, 0.16 translate <-0.7, 1.45, 0>} 
                                                   
    cylinder{0, <0, 0.2, 0>, 0.18 translate <-1, 0, 0>} 
    cylinder{0, <0, 0.3, 0>, 0.16 translate <-1, 0, 0>}                                                  
    cylinder{0, <0, 2.7, 0>, 0.12 translate <-1, 0, 0>} 
    cylinder{0, <0, 0.9, 0>, 0.16 translate <-1, 1, 0>}
    object{Nut scale 4.3 translate <-1, 1, 0>} 
    object{Nut scale 4.3 translate <-1, 1.9, 0>} 
    cylinder{0, <0.3, 0, 0>, 0.12 translate <-1, 0.6, 0>} 
    torus{0.12, 0.025 rotate <90, 90, 0> translate <-0.675, 0.6, 0>}
    
    // tap
    cylinder{0, <0.5, 0, 0>, 0.04 translate <-1, 0.6, 0>} 
    sphere{0, 0.1 scale <0.5, 1, 1> translate <-0.5, 0.6, 0>} 
    torus{0.2, 0.04 rotate <90, 90, 0> translate <-0.5, 0.6, 0>} 
    cylinder{<0, 0, -0.2>, <0, 0, 0.2>, 0.03 rotate x*45 translate <-0.5, 0.6, 0>} 
    cylinder{<0, 0, -0.2>, <0, 0, 0.2>, 0.03 rotate -x*45 translate <-0.5, 0.6, 0>} 
    
    sphere{0, 0.2 translate <-1, 2.7, 0>} 
    cylinder{0, <0, 0.4, 0>, 0.2 translate <-1, 2.7, 0>} 
    torus{0.2, 0.04 translate <-1, 2.7, 0>} 
    torus{0.2, 0.04 translate <-1, 3.1, 0>}  
    
    difference{
        torus{0.6, 0.2}
        plane{x, 0}
        plane{z, 0}
        
        rotate -x*90
        translate <-1.6, 3.1, 0>
    }
    
    cylinder{0, <0.1, 0, 0>, 0.4 translate <-1.6, 3.7, 0>} 
    cylinder{0, <0.1, 0, 0>, 0.4 translate <-1.72, 3.7, 0>}     
    union {
        object{Nut scale 1.5 rotate -z*90 translate y*0.3} 
        object{Nut scale 1.5 rotate -z*90 translate y*0.3 rotate x*60}
        object{Nut scale 1.5 rotate -z*90 translate y*0.3 rotate x*120}
        object{Nut scale 1.5 rotate -z*90 translate y*0.3 rotate x*180}
        object{Nut scale 1.5 rotate -z*90 translate y*0.3 rotate x*240}
        object{Nut scale 1.5 rotate -z*90 translate y*0.3 rotate x*300}
        
        translate <-1.5, 3.7, 0>
    } 
    union {
        object{Nut scale 1.5 rotate z*90 translate y*0.3} 
        object{Nut scale 1.5 rotate z*90 translate y*0.3 rotate x*60}
        object{Nut scale 1.5 rotate z*90 translate y*0.3 rotate x*120}
        object{Nut scale 1.5 rotate z*90 translate y*0.3 rotate x*180}
        object{Nut scale 1.5 rotate z*90 translate y*0.3 rotate x*240}
        object{Nut scale 1.5 rotate z*90 translate y*0.3 rotate x*300}
        
        translate <-1.72, 3.7, 0>
    }    
    
    cylinder{0, <-0.5, 0, 0>, 0.14 translate <-1.35, 2.9, 0>}
    torus{0.14, 0.025 rotate <90, 90, 0> translate <-1.35, 2.9, 0>}  
    torus{0.14, 0.025 rotate <90, 90, 0> translate <-1.85, 2.9, 0>} 
    cylinder{0, <0, 1.4, 0>, 0.12 translate <-1.6, 1.5, 0>} 
    cylinder{0, <0, 0.4, 0>, 0.15 translate <-1.6, 2.0, 0>}
    torus{0.15, 0.025 translate <-1.6, 2.025, 0>}
    torus{0.15, 0.025 translate <-1.6, 2.425, 0>}
    cylinder{0, <0, 0, -0.2>, 0.14 translate <-1.6, 2.225, 0>} 
    cylinder{0, <0, 0, -0.35>, 0.03 translate <-1.6, 2.225, 0>}
    sphere{0, 0.06 scale <1, 1, 0.5> translate <-1.6, 2.225, -0.3>} 
    torus{0.2, 0.03 rotate <90, 0, 0> translate <-1.6, 2.225, -0.3>} 
    cylinder{<-0.2, 0, 0>, <0.2, 0, 0>, 0.02 rotate z*45 translate <-1.6, 2.225, -0.3>} 
    cylinder{<-0.2, 0, 0>, <0.2, 0, 0>, 0.02 rotate -z*45 translate <-1.6, 2.225, -0.3>}
    
    // big
    sphere{0, 0.5 translate <-2.5, 1.3, 0>}
    cylinder{0, <0, 2.6, 0>, 0.5 translate <-2.5, 1.3, 0>}
    torus{0.2, 0.3 translate <-2.5, 3.9, 0>} 
    cylinder{0, <0, 0.1, 0>, 0.2 translate <-2.5, 4.2, 0>}   
    
    union {
        cylinder{0, <0, 0.3, 0>, 0.02 translate x*0.2 rotate y*60}  
        cylinder{0, <0, 0.3, 0>, 0.02 translate x*0.2 rotate y*120}
        cylinder{0, <0, 0.3, 0>, 0.02 translate x*0.2 rotate y*180}
        cylinder{0, <0, 0.3, 0>, 0.02 translate x*0.2 rotate y*240}
        cylinder{0, <0, 0.3, 0>, 0.02 translate x*0.2 rotate y*300}
        cylinder{0, <0, 0.3, 0>, 0.02 translate x*0.2 rotate y*360}
        torus{0.2, 0.02 translate y*0.3} 
        translate <-2.5, 4.2, 0>   
    }
    
    union {
        sphere{0, 0.05 scale <0.5, 1, 1> translate x*0.5 rotate y*36*0} 
        sphere{0, 0.05 scale <0.5, 1, 1> translate x*0.5 rotate y*36*1}
        sphere{0, 0.05 scale <0.5, 1, 1> translate x*0.5 rotate y*36*2}
        sphere{0, 0.05 scale <0.5, 1, 1> translate x*0.5 rotate y*36*3}
        sphere{0, 0.05 scale <0.5, 1, 1> translate x*0.5 rotate y*36*4}
        sphere{0, 0.05 scale <0.5, 1, 1> translate x*0.5 rotate y*36*5}
        sphere{0, 0.05 scale <0.5, 1, 1> translate x*0.5 rotate y*36*6}
        sphere{0, 0.05 scale <0.5, 1, 1> translate x*0.5 rotate y*36*7}
        sphere{0, 0.05 scale <0.5, 1, 1> translate x*0.5 rotate y*36*8}
        sphere{0, 0.05 scale <0.5, 1, 1> translate x*0.5 rotate y*36*9}
        translate <-2.5, 1.65, 0>
    } 
    union {
        sphere{0, 0.05 scale <0.5, 1, 1> translate x*0.5 rotate y*36*0} 
        sphere{0, 0.05 scale <0.5, 1, 1> translate x*0.5 rotate y*36*1}
        sphere{0, 0.05 scale <0.5, 1, 1> translate x*0.5 rotate y*36*2}
        sphere{0, 0.05 scale <0.5, 1, 1> translate x*0.5 rotate y*36*3}
        sphere{0, 0.05 scale <0.5, 1, 1> translate x*0.5 rotate y*36*4}
        sphere{0, 0.05 scale <0.5, 1, 1> translate x*0.5 rotate y*36*5}
        sphere{0, 0.05 scale <0.5, 1, 1> translate x*0.5 rotate y*36*6}
        sphere{0, 0.05 scale <0.5, 1, 1> translate x*0.5 rotate y*36*7}
        sphere{0, 0.05 scale <0.5, 1, 1> translate x*0.5 rotate y*36*8}
        sphere{0, 0.05 scale <0.5, 1, 1> translate x*0.5 rotate y*36*9}
        translate <-2.5, 3.35, 0>
    }
    
    difference{                                                
        union{
            cylinder{0, <0, 0.1, 0>, 0.6 translate <-2.5, 2.5, 0>}
            cylinder{0, <0, 0.1, 0>, 0.6 translate <-2.5, 2.38, 0>}
        }   
        box{<-0.1, -0.2, -1>, <0.1, 0.2, 1> translate <-2.5, 2.4, 0>}
    } 
    
    difference{
        cylinder{0, <0, 1, 0>, 0.65}
        plane{x, -0.2}
        plane{x, 0.2 inverse} 
        box{<-0.1, 0.1, -1>, <0.1, 2, 1>} 
        translate <-2.5, 1.9, 0>
    }
    difference{
        torus{0.58, 0.05}
        plane{x, -0.22} 
        plane{x, 0.22 inverse}
        translate y*0.85 
        translate <-2.5, 1.9, 0>
    }
    cylinder{0, <0, -0.65, 0>, 0.05 translate <-2.5, 2.75, -0.58>}
    sphere{0, 0.1 translate <-2.5, 2.1, -0.58>}  
    cylinder{0, <0, -0.65, 0>, 0.05 translate <0, 2.75, -0.58> rotate y*180 translate -x*2.5}
    sphere{0, 0.1 translate <0, 2.1, -0.58> rotate y*180  translate -x*2.5} 
    
    cylinder{0, <-2.4, 0, 0>, 0.12 translate <-1, 2.9, 0>}
    difference{
        torus{0.3, 0.14}
        plane{-x, 0} 
        plane{z, 0}
        rotate -x*90
        translate <-3.4, 2.6, 0>
    }    
    torus{0.14, 0.025 translate <-3.7, 2.625, 0>} 
    torus{0.14, 0.025 rotate z*90 translate <-3.375, 2.9, 0>}
    cylinder{0, <0, -1.5, 0>, 0.12 translate <-3.7, 2.6, 0>}
    sphere{0, 0.12 translate <-3.7, 1.1, 0>}
    
    sphere{0, 0.3 translate <-3.7, 2.2, 0>} 
    sphere{0, 0.3 translate <-3.7, 1.6, 0>} 
    cylinder{0, <0, 0.1, 0>, 0.45 translate <-3.7, 2.15, 0>}
    cylinder{0, <0, 0.1, 0>, 0.45 translate <-3.7, 1.55, 0>} 
    
    cylinder{0, <0, 0.8, 0>, 0.03 translate x*0.38 rotate y*60 translate <-3.7, 1.5, 0>} 
    cylinder{0, <0, 0.8, 0>, 0.03 translate x*0.38 rotate y*120 translate <-3.7, 1.5, 0>}
    cylinder{0, <0, 0.8, 0>, 0.03 translate x*0.38 rotate y*180 translate <-3.7, 1.5, 0>}
    cylinder{0, <0, 0.8, 0>, 0.03 translate x*0.38 rotate y*240 translate <-3.7, 1.5, 0>}
    cylinder{0, <0, 0.8, 0>, 0.03 translate x*0.38 rotate y*300 translate <-3.7, 1.5, 0>}
    cylinder{0, <0, 0.8, 0>, 0.03 translate x*0.38 rotate y*360 translate <-3.7, 1.5, 0>}

    cylinder{0, <-3, 0, 0>, 0.2 translate <-1.6, 3.7, 0>}
    torus{0.2, 0.1 rotate <90, 90, 0> translate <-3.6, 3.7, 0>}
    cylinder{0, <0.1, 0, 0>, 0.5 translate <-3.7, 3.7, 0>} 
    torus{0.2, 0.1 rotate <90, 90, 0> translate <-3.82, 3.7, 0>}
    cylinder{0, <0.1, 0, 0>, 0.5 translate <-3.82, 3.7, 0>}  
    union {
        object{Nut scale 1.5 rotate -z*90 translate y*0.4} 
        object{Nut scale 1.5 rotate -z*90 translate y*0.4 rotate x*60}
        object{Nut scale 1.5 rotate -z*90 translate y*0.4 rotate x*120}
        object{Nut scale 1.5 rotate -z*90 translate y*0.4 rotate x*180}
        object{Nut scale 1.5 rotate -z*90 translate y*0.4 rotate x*240}
        object{Nut scale 1.5 rotate -z*90 translate y*0.4 rotate x*300}
        
        translate <-3.6, 3.7, 0>
    } 
    union {
        object{Nut scale 1.5 rotate z*90 translate y*0.4} 
        object{Nut scale 1.5 rotate z*90 translate y*0.4 rotate x*60}
        object{Nut scale 1.5 rotate z*90 translate y*0.4 rotate x*120}
        object{Nut scale 1.5 rotate z*90 translate y*0.4 rotate x*180}
        object{Nut scale 1.5 rotate z*90 translate y*0.4 rotate x*240}
        object{Nut scale 1.5 rotate z*90 translate y*0.4 rotate x*300}
        
        translate <-3.82, 3.7, 0>
    }  
    
    torus{0.3, 0.15 rotate <90, 90, 0> translate <-4.5, 3.7, 0>}
    torus{0.3, 0.15 rotate <90, 90, 0> translate <-4.8, 3.7, 0>}
    cylinder{0, <0.3, 0, 0>, 0.45 translate <-4.8, 3.7, 0>}
    cylinder{0, <0.6, 0, 0>, 0.3 translate <-4.95, 3.7, 0>} 
    torus{0.45, 0.025 rotate <0, 0, 90> translate <-4.8, 3.7, 0>}
    torus{0.45, 0.025 rotate <0, 0, 90> translate <-4.5, 3.7, 0>} 
    union {
        cylinder{0, <0.3, 0, 0>, 0.02 translate y*0.45 rotate x*36*0}
        cylinder{0, <0.3, 0, 0>, 0.02 translate y*0.45 rotate x*36*1}
        cylinder{0, <0.3, 0, 0>, 0.02 translate y*0.45 rotate x*36*2}
        cylinder{0, <0.3, 0, 0>, 0.02 translate y*0.45 rotate x*36*3}
        cylinder{0, <0.3, 0, 0>, 0.02 translate y*0.45 rotate x*36*4}
        cylinder{0, <0.3, 0, 0>, 0.02 translate y*0.45 rotate x*36*5}
        cylinder{0, <0.3, 0, 0>, 0.02 translate y*0.45 rotate x*36*6}
        cylinder{0, <0.3, 0, 0>, 0.02 translate y*0.45 rotate x*36*7}
        cylinder{0, <0.3, 0, 0>, 0.02 translate y*0.45 rotate x*36*8}
        cylinder{0, <0.3, 0, 0>, 0.02 translate y*0.45 rotate x*36*9}
        translate <-4.8, 3.7, 0>
    } 
    
    cylinder{0, <0, 1.4, 0>, 0.15 translate <-4.65, 2.8, 0>}
    
    cylinder{0, <0.4, 0, 0>, 0.6 translate <-4.85, 2.3, 0>}
    sphere{0, 0.6 scale <0.4, 1, 1> translate <-4.85, 2.3, 0>}
    sphere{0, 0.6 scale <0.4, 1, 1> translate <-4.45, 2.3, 0>}
    torus{0.6, 0.025 rotate <0, 0, 90> translate <-4.8, 2.3, 0>}
    torus{0.6, 0.025 rotate <0, 0, 90> translate <-4.5, 2.3, 0>} 
    union {
        sphere{0, 0.05 scale <1, 0.5, 1> translate y*0.6 rotate x*36*0} 
        sphere{0, 0.05 scale <1, 0.5, 1> translate y*0.6 rotate x*36*1}
        sphere{0, 0.05 scale <1, 0.5, 1> translate y*0.6 rotate x*36*2}
        sphere{0, 0.05 scale <1, 0.5, 1> translate y*0.6 rotate x*36*3}
        sphere{0, 0.05 scale <1, 0.5, 1> translate y*0.6 rotate x*36*4}
        sphere{0, 0.05 scale <1, 0.5, 1> translate y*0.6 rotate x*36*5}
        sphere{0, 0.05 scale <1, 0.5, 1> translate y*0.6 rotate x*36*6}
        sphere{0, 0.05 scale <1, 0.5, 1> translate y*0.6 rotate x*36*7}
        sphere{0, 0.05 scale <1, 0.5, 1> translate y*0.6 rotate x*36*8}
        sphere{0, 0.05 scale <1, 0.5, 1> translate y*0.6 rotate x*36*9} 
        translate <-4.65, 2.3, 0>
    }    
    
    cylinder{0, <0.3, 0, 0>, 0.1 translate <-4.65, 3.1, 0>} 
    object{Nut scale 3 rotate z*90 translate <-4.35, 3.1, 0>}
    // tap
    union {
        cylinder{0, <0.4, 0, 0>, 0.04} 
        sphere{0, 0.1 scale <0.5, 1, 1> translate <0.4, 0, 0>} 
        torus{0.2, 0.04 rotate <90, 90, 0> translate <0.4, 0, 0>} 
        cylinder{<0, 0, -0.2>, <0, 0, 0.2>, 0.03 rotate x*45 translate <0.4, 0, 0>} 
        cylinder{<0, 0, -0.2>, <0, 0, 0.2>, 0.03 rotate -x*45 translate <0.4, 0, 0>}  
        translate <-4.65, 3.1, 0>
    }
    
    cylinder{0, <0.4, 0, 0>, 0.4 translate <-5.2, 2.3, 0>}
    torus{0.6, 0.3 rotate <90, 90, 0> translate <-5.5, 2.3, 0>} 
    cylinder{0, <0.6, 0, 0>, 0.6 translate <-5.8, 2.3, 0>} 
    cylinder{0, <0.1, 0, 0>, 1.1 translate <-5.61, 2.3, 0>} 
    cylinder{0, <0.1, 0, 0>, 1.1 translate <-5.49, 2.3, 0>} 
    
    union{
        difference{torus{0.4, 0.04 rotate <90, 0, 0>} plane{y, 0} plane{-x, 0} translate y*0.6 rotate x*30*0} 
        difference{torus{0.4, 0.04 rotate <90, 0, 0>} plane{y, 0} plane{-x, 0} translate y*0.6 rotate x*30*1}
        difference{torus{0.4, 0.04 rotate <90, 0, 0>} plane{y, 0} plane{-x, 0} translate y*0.6 rotate x*30*2}
        difference{torus{0.4, 0.04 rotate <90, 0, 0>} plane{y, 0} plane{-x, 0} translate y*0.6 rotate x*30*3}
        difference{torus{0.4, 0.04 rotate <90, 0, 0>} plane{y, 0} plane{-x, 0} translate y*0.6 rotate x*30*4}
        difference{torus{0.4, 0.04 rotate <90, 0, 0>} plane{y, 0} plane{-x, 0} translate y*0.6 rotate x*30*5}
        difference{torus{0.4, 0.04 rotate <90, 0, 0>} plane{y, 0} plane{-x, 0} translate y*0.6 rotate x*30*6}
        difference{torus{0.4, 0.04 rotate <90, 0, 0>} plane{y, 0} plane{-x, 0} translate y*0.6 rotate x*30*7}
        difference{torus{0.4, 0.04 rotate <90, 0, 0>} plane{y, 0} plane{-x, 0} translate y*0.6 rotate x*30*8}
        difference{torus{0.4, 0.04 rotate <90, 0, 0>} plane{y, 0} plane{-x, 0} translate y*0.6 rotate x*30*9} 
        difference{torus{0.4, 0.04 rotate <90, 0, 0>} plane{y, 0} plane{-x, 0} translate y*0.6 rotate x*30*10}
        difference{torus{0.4, 0.04 rotate <90, 0, 0>} plane{y, 0} plane{-x, 0} translate y*0.6 rotate x*30*11}
        torus{0.6, 0.04 rotate <90, 90, 0> translate <-0.4, 0, 0>}  
        union {
            object{Nut scale 1.5 rotate -z*90 translate <0.11, 1, 0> rotate x*30*0} 
            object{Nut scale 1.5 rotate -z*90 translate <0.11, 1, 0> rotate x*30*1}
            object{Nut scale 1.5 rotate -z*90 translate <0.11, 1, 0> rotate x*30*2}
            object{Nut scale 1.5 rotate -z*90 translate <0.11, 1, 0> rotate x*30*3}
            object{Nut scale 1.5 rotate -z*90 translate <0.11, 1, 0> rotate x*30*4}
            object{Nut scale 1.5 rotate -z*90 translate <0.11, 1, 0> rotate x*30*5}
            object{Nut scale 1.5 rotate -z*90 translate <0.11, 1, 0> rotate x*30*6}
            object{Nut scale 1.5 rotate -z*90 translate <0.11, 1, 0> rotate x*30*7}
            object{Nut scale 1.5 rotate -z*90 translate <0.11, 1, 0> rotate x*30*8}
            object{Nut scale 1.5 rotate -z*90 translate <0.11, 1, 0> rotate x*30*9}
            object{Nut scale 1.5 rotate -z*90 translate <0.11, 1, 0> rotate x*30*10}
            object{Nut scale 1.5 rotate -z*90 translate <0.11, 1, 0> rotate x*30*11}
        } 
         
        translate <-5.5, 2.3, 0>
    } 
    
    cylinder{0, <0, 2, 0>, 0.12 translate <-4.65, 0, 0>} 
    cylinder{0, <0, 0.05, 0>, 0.35 translate <-4.65, 0, 0>}
    object{Nut scale 1.5 translate <0.25, 0.05, 0>  translate <-4.65, 0, 0>} 
    object{Nut scale 1.5 translate <0.25, 0.05, 0> rotate y*60  translate <-4.65, 0, 0>}
    object{Nut scale 1.5 translate <0.25, 0.05, 0> rotate y*120 translate <-4.65, 0, 0>}
    object{Nut scale 1.5 translate <0.25, 0.05, 0> rotate y*180 translate <-4.65, 0, 0>}
    object{Nut scale 1.5 translate <0.25, 0.05, 0> rotate y*240 translate <-4.65, 0, 0>}
    object{Nut scale 1.5 translate <0.25, 0.05, 0> rotate y*300 translate <-4.65, 0, 0>}
    cylinder{0, <0, 0.3, 0>, 0.15 translate <-4.65, 0, 0>}
    cylinder{0, <0, 0.3, 0>, 0.15 translate <-4.65, 0.9, 0>}
    torus{0.15, 0.02 translate <-4.65, 0.92, 0>} 
    torus{0.15, 0.02 translate <-4.65, 1.18, 0>}  
                                           
    cylinder{0, <0, 0.4, 0>, 0.2 translate <-2.5, 0.75, 0>} 
    cylinder{0, <0, 0.4, 0>, 0.06 translate <-2.5, 0.65, 0>}                                           
    difference{torus{0.2, 0.04 rotate <90, 0, 0>} plane{-y, 0} plane{x, 0} translate -x*0.2 translate<-2.5, 0.65, 0>} 
    cylinder{0, <-1, 0, 0>, 0.04 translate <-2.7, 0.45, 0>}
    sphere{0, 0.08 translate <-3.7, 0.45, 0>} 
    cylinder{0, <0.2, 0, 0>, 0.08 translate <-3.7, 0.45, 0>} 
    sphere{0, 0.08 scale <0.5, 1, 1>translate <-3.5, 0.45, 0>} 
    cylinder{0, <0, 0.2, 0>, 0.08 translate <-3.7, 0.45, 0>} 
    sphere{0, 0.08 scale <1, 0.5, 1>translate <-3.7, 0.65, 0>}
    cylinder{0, <0, 1, 0>, 0.04 translate <-3.7, 0.45, 0>} 
    difference{torus{0.2, 0.08} plane{-z, 0} plane{x, 0} translate -x*0.2 translate<-3.7, 0.45, 0>}
    sphere{0, 0.08 scale <0.5, 1, 1>translate <-3.9, 0.45, -0.2>} 
    cylinder{0, <-1, 0, 0>, 0.04 translate <-3.9, 0.45, -0.2>} 
    union{
         difference{torus{0.2, 0.04 rotate <90, 0, 0>} plane{-y, 0} plane{-x, 0} translate y*0.2}
         cylinder{0, <0, 1, 0>, 0.04 translate <-0.2, 0.2, 0>} 
         difference{torus{0.2, 0.08 rotate <90, 0, 0>} plane{y, 0} plane{x, 0} translate <-0.4, 1.2, 0>} 
         sphere{0, 0.08 scale <1, 0.5, 1>translate <-0.2, 1.2, 0>}
         rotate x*15
         translate <-4.9, 0.45, -0.2>
    }
    
    cylinder{0, <-0.6, 0, 0>, 0.2 translate <-5.5, 2.3, 0>}
    torus{0.2, 0.025 rotate <0, 0, 90> translate <-6.075, 2.3, 0>} 
    sphere{0, 0.1 scale<0.5, 1, 1> translate <-6.1, 2.3, 0>} 
    difference{torus{0.2, 0.04 rotate <90, 0, 0>} plane{-y, 0} plane{-x, 0} translate <-6.1, 2.5, 0>} 
    cylinder{0, <0, 1, 0>, 0.04 translate <-6.3, 2.5, 0>} 
    difference{torus{0.2, 0.04 rotate <90, 0, 0>} plane{y, 0} plane{-x, 0} translate <-6.1, 3.5, 0>} 
    cylinder{0, <1.4, 0, 0>, 0.04 translate <-6.1, 3.7, 0>} 
    cylinder{0, <0.4, 0, 0>, 0.08 translate <-5.8, 3.7, 0>}
    torus{0.08, 0.02 rotate <0, 0, 90> translate <-5.78, 3.7, 0>}    
    torus{0.08, 0.02 rotate <0, 0, 90> translate <-5.42, 3.7, 0>}
    cylinder{0, <0, 0.2, 0>, 0.08 translate <-5.6, 3.7, 0>}  
    torus{0.08, 0.02 translate <-5.6, 3.88, 0>} 
    cylinder{0, <0, 0.5, 0>, 0.04 translate <-5.6, 3.7, 0>}
    difference{torus{0.2, 0.04 rotate <90, 0, 0>} plane{y, 0} plane{-x, 0} translate <-5.4, 4.2, 0>} 
    cylinder{0, <1.1, 0, 0>, 0.04 translate <-5.4, 4.4, 0>}
    difference{torus{0.2, 0.04 rotate <90, 0, 0>} plane{y, 0} plane{x, 0} translate <-4.3, 4.2, 0>} 
    cylinder{0, <0, 0.5, 0>, 0.04 translate <-4.1, 3.7, 0>} 
    cylinder{0, <0, 0.3, 0>, 0.1 translate <-4.1, 3.7, 0>}
    torus{0.1, 0.025 translate <-4.1, 4, 0>} 
}

#declare Top = union{
    cylinder{0, <0, 5, 0>, 0.1 translate <-2.5, 4.2, 0>} 
    difference{
        torus{0.4, 0.1}
        plane{x, 0}
        plane{z, 0}
        
        translate -x*0.4
        rotate <-90, -90, 0>
        translate <-2.5, 9.2, 0>
    }
    cylinder{<0, 3, -0.4>, <0, 3, -2.5>, 0.1 translate <-2.5, 6.6, 0>}
} 

#declare HydroRight = union {
    object{Hydro}
    object{Top}
    
    texture{HydroTxt}
} 

#declare HydroLeft = union {
    object{Hydro rotate y*180}
    object{Top translate x*5}
     translate -x*13
    
    texture{HydroTxt}
}

#declare HydroSystem = union{
    object{HydroRight translate x*6}   
    object{HydroLeft  translate x*5.4}
}
