#version unofficial MegaPov 0.5;

#declare Spiral = union{
    isosurface {
	    function   {"func_6", <2, 15, 0.06, 0.3, 1, 1, 0>, library "i_nfunc"}
	    contained_by{ box {<-0.5, 0, -0.5>, <0.5, 1, 0.5>}} 
    } 
    cylinder{0, <0, 0.1, 0>, 0.4 translate y*1 texture{GreenRustTxt rotate x*90}} // top
    sphere{0, 0.2 scale <1, 0.4, 1> translate y*1.1 texture{RustTxt rotate x*90}}
    cylinder{0, <0, 1, 0>, 0.2 texture{RustTxt}} // center
    texture{SpiralTxt rotate x*90}
} 

#declare Trans = union{
    object{Spiral translate -x*0.6}
    object{Spiral translate x*0.6}                     
    union{  // bottom
        cylinder{0, <0, 0.1, 0>, 0.4 translate <-0.9, -0.1, 0>} 
        cylinder{0, <0, 0.1, 0>, 0.4 translate <0.9, -0.1, 0>}
        box{<-0.9, -0.1, -0.4>, <0.9, 0, 0.4>} 
        box{<-0.6, 1, -0.3>, <0.6, 1.05, 0.3>}   
        texture{GreenRustTxt scale 2 rotate x*90} 
    } 
    union{                
        difference{torus{0.3, 0.06 rotate <90, 0, 0>} plane{y, 0} translate <-0.9, 1.1, 0>} 
        difference{torus{0.3, 0.06 rotate <90, 0, 0>} plane{y, 0} translate <0.9, 1.1, 0>} 
        cylinder{0, <0, 1, 0>, 0.1}
        cylinder{0, <0, 1.1, 0>, 0.06 translate <1.2, 0, 0>} 
        cylinder{0, <0, 1.1, 0>, 0.06 translate <-1.2, 0, 0>}
        
        texture{RustTxt}
    }
    difference{sphere{0, 0.2} plane{y, 0} scale <1, 0.5, 1> translate y*1.05 texture{RustTxt rotate x*90}}
}  

#declare Grid = union{
    isosurface { 
        function {"mesh1",<0.25, 0.25, 1, 0.01, 1>}
        contained_by{ box {<-3.4, -0.3, -0.8>, <3.4, 0.3, 0.8>}}
        threshold 0.05 
    }  
    cylinder{<0, 0, -0.8>, <0, 0, 0.8>, 0.08}
    cylinder{<0, 0, -0.8>, <0, 0, 0.8>, 0.08 translate <-3.4, 0, 0>}  
    cylinder{<0, 0, -0.8>, <0, 0, 0.8>, 0.08 translate <3.4, 0, 0>} 
    sphere{0, 0.08 translate<-3.4, 0, -0.8>}
    sphere{0, 0.08 translate<-3.4, 0, 0.8>} 
    sphere{0, 0.08 translate<3.4, 0, -0.8>}
    sphere{0, 0.08 translate<3.4, 0, 0.8>}
    cylinder{<-3.4, 0, -0.8>, <3.4, 0, -0.8>, 0.08} 
    cylinder{<-3.4, 0, 0.8>, <3.4, 0, 0.8>, 0.08}
    
    texture{GreenRustTxt scale 3 rotate x*90}
}     

#declare Reflector = union{
    object{Trans translate <-1.7, 0.15, 0>}
    object{Trans translate <1.7, 0.15, 0>}
    object{Grid} 
}                              

#declare Keeper = union{
    object{Reflector rotate x*45 translate <-3.5, 3, 3>} 
    object{Reflector rotate x*45 translate <3.5, 3, 3>}
    object{Reflector rotate x*135 translate <-3.5, -3, 3>} 
    object{Reflector rotate x*135 translate <3.5, -3, 3>} 
    
    object{Reflector rotate -x*45 translate <-3.5, 3, -3>} 
    object{Reflector rotate -x*45 translate <3.5, 3, -3>}
    object{Reflector rotate -x*135 translate <-3.5, -3, -3>} 
    object{Reflector rotate -x*135 translate <3.5, -3, -3>} 
    
    torus{4.3, 0.08 rotate z*90 translate -x*3.5 texture{GreenRustTxt scale 2}} 
    torus{4.3, 0.08 rotate z*90 translate x*3.5 texture{GreenRustTxt scale 2}} 
    
    cylinder{0, <0, 4.1, 0>, 0.16 translate <-3.5, 4.3, 0> texture{CondTxt scale<1, 3, 1>}}  
    cylinder{0, <0, 4.1, 0>, 0.16 translate <3.5, 4.3, 0> texture{CondTxt scale<1, 3, 1> translate x*0.2}}  
     
    union{ 
        cylinder{0, <0, -0.05, 0>, 0.6 translate <-3.5, 8.4, 0>} 
            union{
            sphere{0, 0.08 scale <1, 0.5, 1> translate x*0.4 rotate y*60*0}
            sphere{0, 0.08 scale <1, 0.5, 1> translate x*0.4 rotate y*60*1}
            sphere{0, 0.08 scale <1, 0.5, 1> translate x*0.4 rotate y*60*2}
            sphere{0, 0.08 scale <1, 0.5, 1> translate x*0.4 rotate y*60*3}
            sphere{0, 0.08 scale <1, 0.5, 1> translate x*0.4 rotate y*60*4}
            sphere{0, 0.08 scale <1, 0.5, 1> translate x*0.4 rotate y*60*5}
            translate<-3.5, 8.35, 0>
        }
        texture{CondTxt rotate x*90} 
    }   
    union{  
        cylinder{0, <0, -0.05, 0>, 0.6 translate <3.5, 8.4, 0>}
        union{
            sphere{0, 0.08 scale <1, 0.5, 1> translate x*0.4 rotate y*60*0}
            sphere{0, 0.08 scale <1, 0.5, 1> translate x*0.4 rotate y*60*1}
            sphere{0, 0.08 scale <1, 0.5, 1> translate x*0.4 rotate y*60*2}
            sphere{0, 0.08 scale <1, 0.5, 1> translate x*0.4 rotate y*60*3}
            sphere{0, 0.08 scale <1, 0.5, 1> translate x*0.4 rotate y*60*4}
            sphere{0, 0.08 scale <1, 0.5, 1> translate x*0.4 rotate y*60*5}
            translate<3.5, 8.35, 0> 
        }
        texture{CondTxt rotate x*90 translate x*0.6} 
    } 
}

#declare Shining = merge {
    sphere {0, 2}
    torus{2, 1 rotate z*90}
    cylinder{0, <6, 0, 0>, 3} 
    torus{2, 1 rotate z*90 translate x*6}
    sphere{0, 2 translate x*6}

    pigment {color rgbf 1} 
    interior {
        media {
            scattering {1, .4 extinction .4}
            method 2
            samples 2, 2
            intervals 4
            jitter 0
      
            absorption 0
            density {
                cylindrical
                turbulence 0.6
                color_map {
                    [0 color rgb<0.1, 0.1, 0.7>*2] 
                }  
            }
        }  
    }
    hollow 
    no_shadow 
}  

#declare Part1 = union {
    union{
	    sphere{0, 0.4} 
	    torus{0.4, 0.04 rotate z*90} 
	    difference{torus{0.4, 0.04 rotate x*90} plane{x, 0} rotate x*36*0} 
	    difference{torus{0.4, 0.04 rotate x*90} plane{x, 0} rotate x*36*1}
	    difference{torus{0.4, 0.04 rotate x*90} plane{x, 0} rotate x*36*2}
	    difference{torus{0.4, 0.04 rotate x*90} plane{x, 0} rotate x*36*3}
	    difference{torus{0.4, 0.04 rotate x*90} plane{x, 0} rotate x*36*4}
	    texture{Blue1RustTxt scale 2}	    
	    translate <-5.2, 1.4, 0>
	}
	union{
	    sphere{0, 0.4} 
	    torus{0.4, 0.04 rotate z*90} 
	    difference{torus{0.4, 0.04 rotate x*90} plane{x, 0} rotate x*36*0} 
	    difference{torus{0.4, 0.04 rotate x*90} plane{x, 0} rotate x*36*1}
	    difference{torus{0.4, 0.04 rotate x*90} plane{x, 0} rotate x*36*2}
	    difference{torus{0.4, 0.04 rotate x*90} plane{x, 0} rotate x*36*3}
	    difference{torus{0.4, 0.04 rotate x*90} plane{x, 0} rotate x*36*4}
	    texture{Blue1RustTxt scale 2.4}
	    rotate y*180	    
	    translate <-2.6, 1.4, 0>
	}
	
	union{
	    difference{sphere{0, 0.4} plane{x, 0} translate <-3.4, 1.4, 0>} 
	    difference{sphere{0, 0.4} plane{-x, 0} translate <-4.4, 1.4, 0>}
	    torus{0.4, 0.04 rotate z*90 translate <-3.4, 1.4, 0>}
	    torus{0.4, 0.04 rotate z*90 translate <-4.4, 1.4, 0>}
	    
	     texture{Blue2RustTxt scale 2 rotate y*90}    
	}
	union{
        cylinder{0, <1, 0, 0>, 0.44 scale <1, 0.2, 1> texture{Blue2RustTxt scale 2.1 rotate x*90} rotate x*36*0} 
        cylinder{0, <1, 0, 0>, 0.44 scale <1, 0.2, 1> texture{Blue2RustTxt scale 2.2 rotate x*90} rotate x*36*1}
        cylinder{0, <1, 0, 0>, 0.44 scale <1, 0.2, 1> texture{Blue2RustTxt scale 2 rotate x*90} rotate x*36*2}
        cylinder{0, <1, 0, 0>, 0.44 scale <1, 0.2, 1> texture{Blue2RustTxt scale 2.1 rotate x*90} rotate x*36*3}
        cylinder{0, <1, 0, 0>, 0.44 scale <1, 0.2, 1> texture{Blue2RustTxt scale 2.2 rotate x*90} rotate x*36*4}
        translate <-4.4, 1.4, 0>
    } 
}

#declare Injector = union{
    union{
        intersection{
            isosurface { 
                function {"mesh1",<0.25, 0.25, 1, 0.01, 1>}
                contained_by{ box {<-3, -0.3, -3>, <3, 0.3, 3>}}
                threshold 0.05 
            }  
            cylinder{<0, -1, 0>, <0, 1, 0>, 3} 
            rotate z*90 
        }
        torus{3, 0.08 rotate z*90} 
        torus{2, 0.08 rotate z*90 translate -x*1}
        
        texture{GreenRustTxt scale 3 rotate z*90}
    }                                            
    union{
        difference{torus{1, 0.08 rotate x*90} plane{y, 0} plane{-x, 0} translate y*2 rotate x*36*0} 
        difference{torus{1, 0.08 rotate x*90} plane{y, 0} plane{-x, 0} translate y*2 rotate x*36*1}
        difference{torus{1, 0.08 rotate x*90} plane{y, 0} plane{-x, 0} translate y*2 rotate x*36*2}
        difference{torus{1, 0.08 rotate x*90} plane{y, 0} plane{-x, 0} translate y*2 rotate x*36*3}
        difference{torus{1, 0.08 rotate x*90} plane{y, 0} plane{-x, 0} translate y*2 rotate x*36*4}
        difference{torus{1, 0.08 rotate x*90} plane{y, 0} plane{-x, 0} translate y*2 rotate x*36*5} 
        difference{torus{1, 0.08 rotate x*90} plane{y, 0} plane{-x, 0} translate y*2 rotate x*36*6}
        difference{torus{1, 0.08 rotate x*90} plane{y, 0} plane{-x, 0} translate y*2 rotate x*36*7}
        difference{torus{1, 0.08 rotate x*90} plane{y, 0} plane{-x, 0} translate y*2 rotate x*36*8}
        difference{torus{1, 0.08 rotate x*90} plane{y, 0} plane{-x, 0} translate y*2 rotate x*36*9} 
        
        texture{GreenRustTxt scale 3}
    } 
    union{
        cylinder{<-2, 2, 0>, <-1, 2, 0>, 0.08 rotate x*36*0} 
        cylinder{<-2, 2, 0>, <-1, 2, 0>, 0.08 rotate x*36*1}
        cylinder{<-2, 2, 0>, <-1, 2, 0>, 0.08 rotate x*36*2}
        cylinder{<-2, 2, 0>, <-1, 2, 0>, 0.08 rotate x*36*3}
        cylinder{<-2, 2, 0>, <-1, 2, 0>, 0.08 rotate x*36*4}
        cylinder{<-2, 2, 0>, <-1, 2, 0>, 0.08 rotate x*36*5}
        cylinder{<-2, 2, 0>, <-1, 2, 0>, 0.08 rotate x*36*6}
        cylinder{<-2, 2, 0>, <-1, 2, 0>, 0.08 rotate x*36*7}
        cylinder{<-2, 2, 0>, <-1, 2, 0>, 0.08 rotate x*36*8}
        cylinder{<-2, 2, 0>, <-1, 2, 0>, 0.08 rotate x*36*9} 
        texture{CondTxt}
    }
    
    torus{2, 0.08 rotate z*90 translate -x*2 texture{CondTxt rotate y*90}} 
    
    object{Spiral scale<1, 0.7, 1> rotate -z*90 translate <-1.8, -2, 0> rotate x*36*0}  
    object{Spiral scale<1, 0.7, 1> rotate -z*90 translate <-1.8, -2, 0> rotate x*36*1}
    object{Spiral scale<1, 0.7, 1> rotate -z*90 translate <-1.8, -2, 0> rotate x*36*2}
    object{Spiral scale<1, 0.7, 1> rotate -z*90 translate <-1.8, -2, 0> rotate x*36*3}
    object{Spiral scale<1, 0.7, 1> rotate -z*90 translate <-1.8, -2, 0> rotate x*36*4} 
    object{Spiral scale<1, 0.7, 1> rotate -z*90 translate <-1.8, -2, 0> rotate x*36*5}  
    object{Spiral scale<1, 0.7, 1> rotate -z*90 translate <-1.8, -2, 0> rotate x*36*6}
    object{Spiral scale<1, 0.7, 1> rotate -z*90 translate <-1.8, -2, 0> rotate x*36*7}
    object{Spiral scale<1, 0.7, 1> rotate -z*90 translate <-1.8, -2, 0> rotate x*36*8}
    object{Spiral scale<1, 0.7, 1> rotate -z*90 translate <-1.8, -2, 0> rotate x*36*9}
    union{
        difference{sphere{0, 0.4} plane{-x, 0} scale<0.5, 1, 1> translate <-1.8, -2, 0> rotate x*36*0}  
        difference{sphere{0, 0.4} plane{-x, 0} scale<0.5, 1, 1> translate <-1.8, -2, 0> rotate x*36*1}
        difference{sphere{0, 0.4} plane{-x, 0} scale<0.5, 1, 1> translate <-1.8, -2, 0> rotate x*36*2}
        difference{sphere{0, 0.4} plane{-x, 0} scale<0.5, 1, 1> translate <-1.8, -2, 0> rotate x*36*3}
        difference{sphere{0, 0.4} plane{-x, 0} scale<0.5, 1, 1> translate <-1.8, -2, 0> rotate x*36*4} 
        difference{sphere{0, 0.4} plane{-x, 0} scale<0.5, 1, 1> translate <-1.8, -2, 0> rotate x*36*5}  
        difference{sphere{0, 0.4} plane{-x, 0} scale<0.5, 1, 1> translate <-1.8, -2, 0> rotate x*36*6}
        difference{sphere{0, 0.4} plane{-x, 0} scale<0.5, 1, 1> translate <-1.8, -2, 0> rotate x*36*7}
        difference{sphere{0, 0.4} plane{-x, 0} scale<0.5, 1, 1> translate <-1.8, -2, 0> rotate x*36*8}
        difference{sphere{0, 0.4} plane{-x, 0} scale<0.5, 1, 1> translate <-1.8, -2, 0> rotate x*36*9} 
        texture{CondTxt rotate y*90}
    }
    cylinder{<-2, 2, 0>, <-5, 2, 0>, 0.08 texture{CondTxt scale 2} rotate x*0} 
    cylinder{<-2, 2, 0>, <-5, 2, 0>, 0.08 texture{CondTxt scale 2} rotate x*90}
    cylinder{<-2, 2, 0>, <-5, 2, 0>, 0.08 texture{CondTxt scale 2} rotate x*180}
    cylinder{<-2, 2, 0>, <-5, 2, 0>, 0.08 texture{CondTxt scale 2} rotate x*270} 
    difference{torus{1, 0.08 rotate x*90} plane{y, 0} plane{-x, 0} texture{CondTxt scale 2}  translate <-5, 1, 0> rotate x*0} 
    difference{torus{1, 0.08 rotate x*90} plane{y, 0} plane{-x, 0} texture{CondTxt scale 2}  translate <-5, 1, 0> rotate x*90}
    difference{torus{1, 0.08 rotate x*90} plane{y, 0} plane{-x, 0} texture{CondTxt scale 2}  translate <-5, 1, 0> rotate x*180}
    difference{torus{1, 0.08 rotate x*90} plane{y, 0} plane{-x, 0} texture{CondTxt scale 2}  translate <-5, 1, 0> rotate x*270}
    
    torus{1, 0.08 rotate z*90 translate -x*6 texture{CondTxt rotate y*90}}
    
    union{
        union{
            isosurface {
	            function   {"func_6", <2, 15, 0.06, 0.3, 1, 1, 0>, library "i_nfunc"}
	            contained_by{ box {<-0.5, 0, -0.5>, <0.5, 2, 0.5>}} 
            }  
            isosurface {
	            function   {"func_6", <2, 15, 0.06, 0.3, 1, 1, 0>, library "i_nfunc"}
	            contained_by{ box {<-0.5, 0, -0.5>, <0.5, 2, 0.5>}} 
	            translate -x*3
            }
            texture{SpiralTxt}     
        } 

        cylinder{<-1, 0, 0>, <-1, 9.4, 0>, 0.3 texture{CondTxt scale<1, 6, 1> translate x*0.6}}  
        cylinder{<-2, 0, 0>, <-2, 9.4, 0>, 0.3 texture{CondTxt scale<1, 6, 1> translate x*0.4}}
                                               
        union{                                               
            cylinder{<0, 2, 0>, <0, 2.2, 0>, 0.6}  
            cylinder{<-3, 2, 0>, <-3, 2.2, 0>, 0.6}
            sphere{0, 0.5 scale<1, 0.6, 1>} 
            sphere{0, 0.5 scale<1, 0.6, 1> translate -x*3} 
            box{<-3, 2, -0.5>, <0, 2.2, 0.5>} 
            cylinder{0, <0, 2.4, 0>, 0.2}  
            cylinder{<-3, 0, 0>, <-3, 2.4, 0>, 0.2}
            sphere{<-1, 0, 0>, 0.5 scale<1, 0.6, 1>} 
            sphere{<-2, 0, 0>, 0.5 scale<1, 0.6, 1>} 
            cylinder{<-1, 1.5, 0>, <-1, 2.7, 0>, 0.4}  
            cylinder{<-2, 1.5, 0>, <-2, 2.7, 0>, 0.4}
            torus{0.6, 0.1 translate<-1, 2.1, 0>}
            torus{0.6, 0.1 translate<-2, 2.1, 0>}
            texture{CondTxt scale 2}  
        }
        union{
            cylinder{<-1, 9, 0>, <-1, 9.1, 0>, 0.9}  
            cylinder{<-2, 9, 0>, <-2, 9.1, 0>, 0.9}
            box{<-2, 9, -0.9>, <-1, 9.1, 0.9>}
            sphere{<-0.7, 0, 0>, 0.1 scale <1, 0.5, 1> rotate y*0 translate<-2, 9, 0>}
            sphere{<-0.7, 0, 0>, 0.1 scale <1, 0.5, 1> rotate y*45 translate<-2, 9, 0>}
            sphere{<-0.7, 0, 0>, 0.1 scale <1, 0.5, 1> rotate -y*45 translate<-2, 9, 0>} 
            sphere{<-0.7, 0, 0>, 0.1 scale <1, 0.5, 1> rotate y*90 translate<-2, 9, 0>}
            sphere{<-0.7, 0, 0>, 0.1 scale <1, 0.5, 1> rotate -y*90 translate<-2, 9, 0>} 
        
            sphere{<0.7, 0, 0>, 0.1 scale <1, 0.5, 1> rotate y*0 translate<-1, 9, 0>}
            sphere{<0.7, 0, 0>, 0.1 scale <1, 0.5, 1> rotate y*45 translate<-1, 9, 0>}
            sphere{<0.7, 0, 0>, 0.1 scale <1, 0.5, 1> rotate -y*45 translate<-1, 9, 0>} 
            sphere{<0.7, 0, 0>, 0.1 scale <1, 0.5, 1> rotate y*90 translate<-1, 9, 0>}
            sphere{<0.7, 0, 0>, 0.1 scale <1, 0.5, 1> rotate -y*90 translate<-1, 9, 0>}
            texture{CondTxt scale 0.5 rotate x*90 translate x*0.6}
        } 
        
        scale 0.5
        translate<-3, 2, 0>        	                   
    } 
    
    isosurface {
	    function  {"func_12", <16, 30, 6, 0, 0.5, 2.5, 1/36, 0,0,0>, library "i_nfunc"}
	    contained_by{ box {<-20, -6, -20>, <20, 6, 20>}} 
	    rotate z*90
	    scale 0.1
	    translate -x*2
	    
	    texture{SpiralTxt}
	}                                  
	
	union{
	    object{Part1 rotate x*36*0}
	    object{Part1 rotate x*36*1}
	    object{Part1 rotate x*36*2}
	    object{Part1 rotate x*36*3}
	    object{Part1 rotate x*36*4}
	    object{Part1 rotate x*36*5}
	    object{Part1 rotate x*36*6}
	    object{Part1 rotate x*36*7}
	    object{Part1 rotate x*36*8}
	    object{Part1 rotate x*36*9}
    }
}

#declare Injectors = union{
    object{Injector scale 0.45 translate -x*2.9}
    object{Injector rotate y*180 scale 0.45 translate x*2.9} 
}

/*
1.Major radius 
2.Number of winding loops. 
3.Twistiness of winding. When zero, each winding loop is separate. When
  set to one, each loop twists into the next one. When set to two, each
  loop twists into the one after next. 
4.Fatness of winding? 
5.Threshold. Setting this parameter to 1 and the threshold to zero has s
  similar effect as setting this parameter to zero and the threshold to 1. 
6.Negative minor radius? Reducing this parameter increases the minor
  radius of the central torus. Increasing it can make the torus disappear
  and be replaced by a vertical column. The value at which the surface
  switches from one form to the other depends on several other
  parameters. 
7.Another fatness of winding control? 
8.Groove period. Increase this for more grooves. 
9.Groove amplitude. Increase this for deeper grooves. 
10.Groove phase. Set this to zero for symmetrical grooves. 
*/                                                
#declare Cable = union{
    isosurface {
	    function  {"func_12", <18, 46, 8, 0, 0.5, 0.7, 1/36, 0,0,0>, library "i_nfunc"}
	    contained_by{ box {<-20, -2, -20>, <20, 2, 0>}} 
	    rotate -x*90
	    texture{WiresTxt}
	} 
	union{
	    sphere{0, 2 scale<1, 0.6, 1>}
	    cylinder{0, <0, 5, 0>, 2} 
	    torus{2, 0.4 translate y*0.3}  
	    torus{2, 0.4 translate y*4} 
	    cylinder{0, <0, 6, 0>, 0.6 translate<-0.5, 16, 0>}
	    cylinder{0, <0, 6, 0>, 0.6 translate<2, 16, 0>}
	    cylinder{0, <0, 6, 0>, 0.6 translate<4.5, 16, 0>}
	    texture{HydroTxt scale 8}
	     
	    translate -x*18
	}                  
	intersection{
	    plane{-z, 0 translate -z*2.5 texture{BoxTxt scale 10 translate <-3, 5, 0>}} //
	    plane{z, 2.5 texture{BoxTxt scale 10 translate <-3, 5, 0>}} //
	    plane{x, 7 texture{BoxTxt scale 10 rotate y*90 translate y*5}}
	    plane{-x, 0 translate -x*3 texture{BoxTxt scale 10 rotate y*90 translate y*5}}
	    plane{y, 16 texture{BoxTxt scale 10 translate -x*3 rotate x*90}}
	    plane{-y, 0 translate y*5 texture{BoxTxt scale 10 translate -x*3 rotate x*90}} 
	    translate -x*18
	}
}                           
 
#declare Cables = union{
    object{Cable scale 0.05 translate -x*4.28} 
    object{Cable rotate y*180 scale 0.05 translate x*4.28}
}
