#declare Block = intersection {
    plane {-z, 0 texture {Concrete}}
    plane {-x, 0 texture {Concrete1 rotate y*90}}
    plane {x, 0 translate x*2 texture {Concrete rotate y*90}}
    plane {-y, 0 texture {Concrete rotate x*90}}
    plane {z, 1 texture {Concrete}}
    difference {
        plane {y, 1}
        sphere {0, 0.25 translate <0.5, 1.05, 0.5>} 
        sphere {0, 0.25 translate <1.5, 1.05, 0.5>}
        texture {Concrete rotate x*90 translate -z*0.4}
    }
    translate -z*1
}

#declare Balloon = union {
    sphere {0, 0.2}
    cylinder {0, <0, 2, 0>, 0.2}
    sphere {<0, 2, 0>, 0.2} 
    cylinder {<0, 2.1, 0>, <0, 2.2, 0>, 0.1}
    cylinder {<0, 2.2, 0>, <0, 2.25, 0>, 0.06} 
    cylinder {<0, 2.25, 0>, <0, 2.4, 0>, 0.02}  
    sphere{<0, 2.3, 0>, 0.04}
    sphere{0, 0.03 scale<1, 0.5, 1> translate y*2.4} 
    cylinder {<-0.05, 2.35, 0>, <0.05, 2.4, 0>, 0.01} 
    cylinder {<0, 2.35, -0.05>, <0, 2.4, 0.05>, 0.01}
    torus{0.1, 0.011 translate y*2.4} 
    
    translate y*0.2 
} 

#declare Fix = difference {
    intersection { 
        plane {-z, 0 translate -z*0.8 texture {Wood1 scale 0.3 translate -x*0.05 rotate z*90}}
        plane {-x, 0 translate x*0.2 texture {Wood1 scale 0.3 translate -x*0.05 rotate z*90 rotate y*90}}
        plane {x, 0 translate x*1.8 texture {Wood1 scale 0.3 translate -x*0.05 rotate z*90 rotate y*90}}
        plane {-y, 0 texture {Wood1 scale 0.3 translate -x*0.05 rotate z*90 rotate x*90}}
        plane {z, 0 texture {Wood1 scale 0.3 translate -x*0.05 rotate z*90}}  
        plane {y, 0.2 texture {Wood1 scale 0.3 translate -x*0.05 rotate z*90 rotate x*90}}
    }
    cylinder {<0.5, -2, -0.5>, <0.5, 2, -0.5>, 0.23}
    cylinder {<0.5, -2, -0.5>, <0.5, 2, -0.5>, 0.23 translate x*1}
                        
    pigment {color rgb 0.8}                        
} 

#declare Stick = cylinder {0, <0, 1, 0>, 0.02}

#declare Inbetween = union {
    cylinder {0, <0.1, 0, 0>, 0.04} 
    cylinder {0, <0.1, 0, 0>, 0.04 translate x*0.9} 
    sphere{0, 0.04 scale<0.5, 1, 1> translate x*0.1}
    sphere{0, 0.04 scale<0.5, 1, 1> translate x*0.9} 
    cylinder {0, <1, 0, 0>, 0.01}
    cylinder {<0.4, 0, 0>, <0.6, 0, 0>, 0.02} 
    sphere{0, 0.02 scale<0.5, 1, 1> translate x*0.4} 
    sphere{0, 0.02 scale<0.5, 1, 1> translate x*0.6} 
    cylinder {<0.5, 0, 0>, <0.5, 0.1, 0>, 0.02} 
    sphere{0, 0.02 scale<1, 0.5, 1> translate <0.5, 0.1, 0>} 
    difference{torus{0.06, 0.01 rotate <0, 0, 90>} plane{y, 0} plane{z, 0} translate <0.5, 0.1, -0.06>} 
    cylinder {<0.5, 0.16, -0.04>, <0.5, 0.16, -5.5>, 0.01}                            
    union{
        difference{torus{0.06, 0.01 rotate <90, 90, 0>} plane{-y, 0} plane{-z, 0} translate y*0.06}
        cylinder{<0, 0.06, -0.06>, <0, 1, -0.06>, 0.01}
        translate<0.5, 0.16, -5.5>
    } 
    union{
        cylinder{0, <0, 0, -0.1>, 0.02} 
        cylinder{0, <0, 0.1, 0>, 0.02 translate -z*0.05}
        cylinder{0, <0, 1, 0>, 0.01 translate -z*0.05}
        translate<0.5, 0.16, -0.6>
    }
}

#declare Oxygen = union {
    object {Block} 
    union {
        object {Balloon texture{BalloonTxt} translate x*0.5} 
        object {Balloon texture{BalloonTxt rotate -y*100} translate x*1.5}
        object {Inbetween texture{BalloonTxt} translate <0.5, 2.5, 0>} 
        translate <0, 0.8, -0.5>
    }
    object {Fix translate y*1.8} 
    object {Stick texture {StickT translate x*0.8} translate <0.25, 1, -0.75>}  
    object {Stick texture {StickT translate x*0.2} translate <1, 1, -0.75>} 
    object {Stick texture {StickT translate x*0.5} translate <1.75, 1, -0.75>} 
    object {Stick texture {StickT translate x*0.4} translate <0.25, 1, -0.15>}  
    
    scale 2.2
    rotate -y*90
}  
