//*****************************************************************************************************************************
// scene environment
//*****************************************************************************************************************************
#version unofficial MegaPov 0.6;

#local radrend=1;
#local showdoor=1;
#local showvents=1;
#local showventsdetail=1;
#local showwormhole=1;
#local showwormholestand=1;
#local showdoordisplay=1;
#local showprobe=1;
#local showlightswitches=1;
#local showcomputers=1;
#local plasmascreen=1;
#local maincamera=1;
#local plainfloor=0;
//#local mirrorrays=1;
#local mirrorrays=25;
#local complightsseed=42^2;

#declare cpov= <0,40,5>;
#declare cpoi= <0,10,0>;
#declare pov = <40,40,-40>;
#declare poi = <-10,15,75>;

#if (maincamera=1)
	camera { //render @ 980x480
		location pov
		sky y
		right 6/3*x
		look_at poi
	}
#else
	camera { //render @ 320x240->512x384
		location cpov
		angle 90
		sky y
		right 4/3*x
		look_at cpoi
	}
	#local reflectivefloor=0;
#end
	
global_settings {
	max_trace_level 30
  	ini_option "Preview_Start_Size=16"
  	ini_option "Preview_End_Size=8"
	#if (radrend=1)
	  	ini_option "+QR"
	  	radiosity{
		    count 40
		    nearest_count 3
		    error_bound 3
		    recursion_limit 3
		    low_error_factor .5
		    gray_threshold 0.0
		    minimum_reuse 0.015
		    brightness 1
		    max_sample 1
		    adc_bailout 0.01/1
		    normal on
	  	}
	#end
}

#local standout=texture {
	pigment { rgb x+z }
	finish {
		ambient 1
		diffuse 0
	}
}

#local standout2=texture {
	pigment { rgb x+z }
	finish {
		ambient 0
		diffuse 1
	}
}

#local darkmetal=texture {
	pigment { rgb 1 }
	finish {
		reflection 0.2
		ambient 0
		specular 1
		diffuse 0.1
		ambient 0
		reflection_blur 0.01
		reflection_samples mirrorrays
	}
}
#local blackseal=texture {
	pigment { rgb 0 }
	finish { specular 1 ambient 0 diffuse 0 }
}

#declare metal = texture {
	pigment {
		rgb 1
	}
	finish {
		reflection 0.7
		ambient 0
		specular 1
		diffuse 0.3
		ambient 0
		reflection_blur 0.01
		reflection_samples mirrorrays
	}
}

#declare walltext= texture {
	pigment {
		rgb 1
	}
	normal {
		granite 0.2
	}
	finish {
		ambient 0
		diffuse 0.999
	}
}
texture {
	pigment {
		granite
		pigment_map {
			[0 rgbt <0,0,0,1>]
			[1 planar
				colour_map {
					[0 rgbt <0,0,0,0.6>]
					[1 rgbt <0,0,0,1>]
				}
				scale 3/4
			]
		}
		warp { black_hole 0,1 strength 4 }
		translate y
	}
	finish {
		ambient 0
		diffuse 0.99
	}
	scale 80
}
	
#declare venttext = texture {
	pigment {
		granite
		colour_map {
			[0 rgb 1/3]
			[1 rgb 2/3]
		}
	}
	normal {
		granite 0.2
	}
	finish {
		ambient 0
		diffuse 0.8
		specular 0.2
		metallic
	}
}
texture {
	pigment {
		granite
		scale 20
		colour_map {
			[0 rgbt <0,0,0,1>]
			[1 rgbt <0,0,0,0.6>]
		}
	}
	finish {
		ambient 0
		diffuse 0.99
	}
}
	

#declare lightcable = texture {
	pigment {
		rgb 1
	}
	finish {
		specular 0.9
		phong 0
		diffuse 0.1
		ambient 0
	}
}

#macro rwallbox(isize,rsize,pos,rot,textur)
union{
	box { -1,1 scale <isize.x+rsize,isize.y,isize.z> }
	box { -1,1 scale <isize.x,isize.y+rsize,isize.z> }
	cylinder { <isize.x,isize.y,isize.z> <isize.x,isize.y,-isize.z> rsize }
	cylinder { <-isize.x,isize.y,isize.z> <-isize.x,isize.y,-isize.z> rsize }
	cylinder { <isize.x,-isize.y,isize.z> <isize.x,-isize.y,-isize.z> rsize }
	cylinder { <-isize.x,-isize.y,isize.z> <-isize.x,-isize.y,-isize.z> rsize }
	texture { textur }
	rotate rot
	translate pos
}
#end

#macro camera_stand(view,interest,origin,textur)
	union {
		intersection {
			cylinder { view origin 0.1 }
			sphere { view 0.5 inverse }
		}
		sphere { view+vnormalize(origin-view)*0.5 0.2 texture { metal } }
		intersection {
			cone { view+vnormalize(interest-view)*0.5 0.6 view-vnormalize(interest-view)*0.5 0.4 }
			cone { view+vnormalize(interest-view)*0.51 0.6 view-vnormalize(interest-view)*0.4 0.3 inverse }
		}
		sphere { origin 0.5 }
		texture { textur }
	}
#end

camera_stand(cpov,cpoi,<0,40,2.5>,darkmetal)	
camera_stand(pov,poi,<pov.x,60,pov.z>,darkmetal)

#include "room.inc"

#if (showwormholestand=1) 
	#include "wormholestand.inc"
#end

#if (showvents=1)
	#include "vents.inc"
#end

#if (showwormhole=1)
	#include "wormhole.inc"
#end	

#if (plasmascreen=1)
	#include "plasmascreen.inc"
#end
				
#if (showlightswitches=1)
	#include "lightswitches.inc"
#end

#if (showdoor=1)
	#include "door.inc"
#end

#if (showdoordisplay=1)
	#include "doorsidedisplay.inc"
#end

#if (showprobe=1)
	#include "probe.inc"
#end

#if (showcomputers=1)
	#include "computers.inc"
#end
	