#version unofficial MegaPov 0.6;

#macro hydrarm(orig,aim,sections,blength,sizea,sizeb)
	#local dvec=vnormalize(aim-orig);
	#local dlen=vlength(aim-orig)-blength;
	#local dlensec=dlen/(sections-1);
	#local swidsec=(sizeb-sizea)/(sections-1);
	#local hac=0;
	#while (hac<sections)
		cylinder {
			orig+dvec*dlensec*hac
			orig+dvec*(dlensec*hac+blength)
			sizea+swidsec*hac
			texture { metal }
		}
		cylinder {
			orig+dvec*dlensec*hac*1.01
			orig+dvec*(dlensec*hac+blength)*1.1
			sizea+swidsec*(hac+1.1)
			texture { blackseal }
		}
		#local hac=hac+1;
	#end
#end

#local f_spike = function ( sqrt(x*x+y*y+z*z)-(sin(atan2(x,z)*5)^10+sin(atan2(sqrt(x*x+z*z),y)*5+atan2(x,z)*5)^10)*0.5 )
isosurface {
	function { f_spike(x,y,z) }
	contained_by { sphere  { 0, 5 } }
	accuracy 0.001
	sign 1
	threshold 4
	max_gradient 40
	texture {
		pigment {
			granite
			scale 0.2
			colour_map {
				[0 rgb 5/6]
				[1 rgb 2/3]
			}
		}
		finish {
			ambient 0
			diffuse 1
			specular 1
			metallic
		}
	}
	scale <0.5,1,0.5>
	translate 30*y
}
sphere {
	<0,0,0>, 4.1
	scale <0.5,1,0.5>
	translate 30*y
	texture {
		pigment { rgb 1 }
		finish {
			ambient 0
			diffuse 0
			reflection 0.7
			specular 0.3
			phong 0.3
		}
	}
}
union {
	glow { location 24.9*y type 0 size 0.1 colour rgb 1*x fade_power 2 }
	hydrarm(<0,50,0>,<0,33,0>,5,12,2,1)
	cylinder { 49*y 51*y 3 }
	cylinder { 39*y 40*y 3 }
	sphere { 51*y 3 }
	torus { 2.5,0.5 translate y*39 }
	#local rc=0;
	#while (rc<360)
		cylinder { <0,40,2.6> <0,49,2.6> 0.4 rotate y* rc }
		#local rc= rc + 30;
	#end
	texture { darkmetal }
}
union {
	sphere { <-3,50,0> 0.5 texture { blackseal } }
	sphere { <-3,40,0> 0.5 texture { blackseal } }
	hydrarm( <-30,50,0>,<-3,50,0>,5,10,1,0.5)
	hydrarm( <-30,40,0>,<-3,40,0>,5,10,1,0.5)
	hydrarm( <-30,45,2>,<-3,45,2>,5,10,1,0.5)
	hydrarm( <-30,45,-2>,<-3,45,-2>,5,10,1,0.5)
	union {
		cylinder { <-3,50,0> <-3,45,-2> 0.5 }
		cylinder { <-3,50,0> <-3,45,2> 0.5 }
		cylinder { <-3,40,0> <-3,45,-2> 0.5 }
		cylinder { <-3,40,0> <-3,45,2> 0.5 }
		cylinder { <-3,45,2> <-3,45,-2> 0.5 }
		sphere { <-3,45,2> 0.5 }
		sphere { <-3,45,-2> 0.5 }
		texture { darkmetal }
	}
}
glow { location <-35,45,0>+<5,7,5> type 0 size 0.1 colour rgb x fade_power 2 }
glow { location <-35,45,0>+<-5,7,5> type 0 size 0.1 colour rgb x fade_power 2 }
glow { location <-35,45,0>+<5,7,-5> type 0 size 0.1 colour rgb x fade_power 2 }
glow { location <-35,45,0>+<-5,7,-5> type 0 size 0.1 colour rgb x fade_power 2 }
glow { location <-35,45,0>+<5,-7,5> type 0 size 0.1 colour rgb x fade_power 2 }
glow { location <-35,45,0>+<-5,-7,5> type 0 size 0.1 colour rgb x fade_power 2 }
glow { location <-35,45,0>+<5,-7,-5> type 0 size 0.1 colour rgb x fade_power 2 }
glow { location <-35,45,0>+<-5,-7,-5> type 0 size 0.1 colour rgb x fade_power 2 }
glow { location <-35,16,0>+<5,3.5,5> type 0 size 0.1 colour rgb x fade_power 2 }
glow { location <-35,16,0>+<-5,3.5,5> type 0 size 0.1 colour rgb x fade_power 2 }
glow { location <-35,16,0>+<5,3.5,-5> type 0 size 0.1 colour rgb x fade_power 2 }
glow { location <-35,16,0>+<-5,3.5,-5> type 0 size 0.1 colour rgb x fade_power 2 }
glow { location <-35,5,0>+<6,7,6> type 0 size 0.1 colour rgb x fade_power 2 }
glow { location <-35,5,0>+<-6,7,6> type 0 size 0.1 colour rgb x fade_power 2 }
glow { location <-35,5,0>+<6,7,-6> type 0 size 0.1 colour rgb x fade_power 2 }
glow { location <-35,5,0>+<-6,7,-6> type 0 size 0.1 colour rgb x fade_power 2 }
rwallbox(<5,5,7>,1,<-35,45,0>,<90,0,0>,darkmetal)
rwallbox(<6,6,7>,1,<-35,5,0>,<90,0,0>,darkmetal)
rwallbox(<5,5,3.5>,1,<-35,16,0>,<90,0,0>,darkmetal)
torus { 5,1 translate <-35,12.25,0> texture { blackseal } }
hydrarm(<-35,19.49,0>,<-35,38.01,0>,5,5,5,4)
