// Persistence of Vision Ray Tracer Scene Description File
// File: mg_lab.pov
// Vers: 3.1g
// Desc:IRTC entry "Laboratory" topic. Title:"Timeless Alchemy" 
// Date: October 27, 2000 
// Auth: Marjorie Graterol 


// ==== Standard POV-Ray Includes ====
#include "colors.inc"	
#include "textures.inc"
#include "mglab_1.inc"
#include "mglab_2.inc"	

global_settings{assumed_gamma 2.20}
//global_settings { ambient_light color Gold+Wheat}


camera
{
  location  <0 ,6 ,-15.0>
  look_at   <0.0 , 4.5 , 0.0>
  right     1.5/2*x
  aperture 0.1
  angle 45
   
} 

light_source
{
  0*x 
  color   Copper//Salmon//Sienna//Bronze2//Gold //filter 0.5 //IndianRed
  //MandarinOrange+IndianRed   Dar;olivegreen
  fade_power 1
  fade_distance 25//50 30 100
  translate <3, 15, -20>// <10, 15, -20><-20, 15, -20>
}  
//nueva
light_source
{
  0*x 
  color  Wheat //IndianRed
  //MandarinOrange+IndianRed   Dar;olivegreen
  fade_power 10
  fade_distance 10//30 100
  translate <5,14,7>
}
/*
light_source
{
  0*x 
  color  Wheat //IndianRed
  //MandarinOrange+IndianRed   Dar;olivegreen
  fade_power 10
  fade_distance 8//10 30 100
  translate <-2,10,6>
}
 */
light_source
{
  0*x 
  color Flesh//CoolCopper//Gold+BrownLightWood+Scarlet// +Firebrick// 
  translate <-4, 10, -20>//<-10, 10, -20>
  fade_power 1//1 2
  fade_distance 25//100
} 
/*

//luces de mg_fte
light_source
{
  0*x                     
  color Feldspar      
  spotlight               
  translate <10, 80, -40> //<10, 20, -40>
  point_at <-3,10,-3.98>  //<-5,6,-3.98>     
  radius 40               
  tightness 10           
  falloff 80
  fade_distance 150
  fade_power 50
  //media_attenuation on

               
}

light_source
{
  0*x                     
  color MandarinOrange       
  spotlight               
  translate <-40, 80, -40>   //<40, 80, -40> 
  point_at <-3.60,12,3.98>  //<-1.60,12,-3.98>     
  radius 40                
  tightness 10          
  falloff 80
  fade_distance 40//150
  fade_power 20
  //media_attenuation on

               
}


light_source
{
  0*x                     
  color Gold//VeryDarkBrown       
  spotlight               
  translate <1, 7, -20> //<5, 1, -20>
  point_at <1,5,-2> //<1,1,-2>     
  radius 20                
  tightness 10           
  falloff 80
  fade_distance 150
  fade_power 50
  //media_attenuation on

               
}   

//background{color Black}




light_source
{
  0*x 
  color   Gold filter 0.5 //IndianRed
  //MandarinOrange+IndianRed   Dar;olivegreen
  fade_power 1
  fade_distance 50//30 100
  translate <-20, 15, -20>
}

light_source
{
  0*x 
  color   Gold//Light_Purple filter 0.5 //IndianRed
  //MandarinOrange+IndianRed   Dar;olivegreen
  fade_power 1
  fade_distance 50//30 100
  translate <-9, 5, -30>
}



light_source
{
  0*x                     // light's position (translated below)
  color White//Gold//rgb <1,1,1>       // light's color
  //fade_power 1
  spotlight               // this kind of light source
  translate <6, 40, -20> // <x y z> position of light
  point_at <0, 7.5, 0>      // direction of spotlight
  radius 10                // hotspot (inner, in degrees)
  tightness 30100//50            // tightness of falloff (1...100) lower is softer, higher is tighter
  falloff 50//8               // intensity falloff radius (outer, in degrees)
}


*/









/*
//eliminar
light_source
{
  0*x 
  color   White //IndianRed
  //MandarinOrange+IndianRed   Dar;olivegreen
  fade_power 1
  fade_distance 5//30 100
  translate <1,5,-13>
}

//probando eliminar esta solamente


light_source
{
  0*x 
  color   White //IndianRed
  //MandarinOrange+IndianRed   Dar;olivegreen
  fade_power 1
  fade_distance 5//30 100
  translate <0,6,6>
}


*/
//// >>> Gold (from file "colors.inc", line 74) <<<
//#declare Gold = color red 0.8 green 0.498039 blue 0.196078;
//color rgb <1.000,0.851,0.718>
/*
light_source
{
  0*x 
  color rj9 //filter 0.5//CornflowerBlue filter 0.5
  //MandarinOrange+IndianRed   Dar;olivegreen
  //fade_power 2
  //fade_distance 20//250//  30
  translate <0,14.5,3>// <0,15,-11>
}
//Quartz
light_source
{
  0*x 
  color  Gold//Violet //filter 0.5//CornflowerBlue filter 0.5
  //MandarinOrange+IndianRed   Dar;olivegreen
  //fade_power 2
  //fade_distance 5//10//250//  30
  translate <-8,14.5,-10>//era -18
}
 
light_source
{
  0*x 
  color  White//Violet //filter 0.5//CornflowerBlue filter 0.5
  //MandarinOrange+IndianRed   Dar;olivegreen
  //fade_power 2
  //fade_distance 100//10//250//  30
  translate <0,14.5,50>//era -18
}

light_source
{
  0*x                     
  color Wheat      
  translate <4, 6, 5> 
  fade_power 2
  fade_distance 10
  
}
*/
difference
{
    object {building rotate -10*y translate <0,0,0>}

//mesa abajo
box
    {
    <-5.75,0.55,-0.25>  
    <-1.25,2.75,-3.50>
    pigment{Gray05 filter 0.4 transmit 0.3}  
    texture{lab_02tb}
    rotate -10*y
    } 

#include "cuatrilob.inc"

object
    {
    lobulo
    texture{ lab_02tb } 
    rotate -10*y
    translate<0,14,5.55>
    }
        
object
    {
    lobulo
    texture{lab_02tb} 
    rotate -10*y
    translate<1.75,14,5.55>
    }
        
}   
       



      
//escaleras 

#include "esc1.inc" 
object{
        esc1 
        scale <3.50,2.75,2.25> 
        rotate 170*y 
        translate <-2.25,10.5,-1.25>
        texture{lab_02tb scale <15,15,14>}
        } 

 


//ojo 
 
#include "mod5.inc" 
object{
        mod5 
        rotate 170*y 
        scale 0.50 
        translate <-3.45,12,4.95> 
        texture {Gold_Nugget}
        }




//escalera de madera al frente - wood stairs front


#include "esc3.inc" 

object {
        esc3
        no_shadow
        scale <2,2.5,2> 
        rotate<0,-10,0>
        rotate<15,0,0>  
        translate<-0.85,6.5,-7>
        }



//escritorio

box
        {
        <-3, 0, -2>  
        < 0.75,  5.25,  -1.5> //< 0.5,  5.25,  -1.5>  
        //pigment {Gray10 filter 0.4 transmit 0.3}
        texture {lab_02tb rotate <45,0,15>}
        
        rotate -10*y
        translate<-0.5,0,-12.20>

        } 



 

//piso
object{piso rotate -10*y}  




//destilador


#include "mod6.inc"
 
object{still rotate 155*y translate <2,4.5,-5>}

//destilador part2
//#include "mglab_2.inc"
 
object {horno2 scale 0.90 translate <3.91,-0.80,-4.74>}



//candelabro - 


#include "mod7.inc"
object {candelabro
        scale <1,1.5,1>
        //rotate 25*y
        translate<-2,2.70,4.5> }//<-4,5.74,0.95>


        


//espejo de Dee -Dee's Mirror 

sphere
    {
    <0, 0, 0> 
    0.50//0.75       
  
    pigment {Mica}
    finish {Phong_Glossy}
    interior{ior 1.482}
    translate <-1.1,4.18,-2.5>//4.55

    } 



//soporte de la esfera de obsidiana
#include "mod10.inc"

object{
    mod10
    texture {
            pigment {
                    colour rgb <0.64, 0.51, 0.05>
                    }
            finish {
                ambient 0.3
                diffuse 0.5
                reflection 0.9
                brilliance 8
                specular 0.5
                }
        }
    scale 0.45//0.60
    translate <-1.1,3.54,-2.5>  //3.79
}


//ornamento pared frontal -ornament front wall

#include "aldaba.inc"

object{baseobs rotate -10*y  translate <3.45,9.35,-1.85> } 


//papel
#include "papel.inc"

object { papel scale 3.5 rotate -10*y translate <3,6,-2.60>} 

//asa
#include "papel2.inc" 

object {asa scale <1.8,1.5,1.5> rotate -10*y  translate <3.80,7.55,-2.4> }

 
//cuello de cisne mesa -swan rear table


#include "mod3.inc"

object{mod3  
//rotate 60*y 
translate<-4.10,3.50,-3.50>} 


//cuello de cisne escritorio- swan  desk


#include "mod4.inc"

object{mod4 scale 0.20  translate <-0.35,5.49,-14>}



 #include "reloj.inc"
 object{reloj
        scale 0.50
        translate <-5.55,6.15,4> //<-2.80,3.76,-3>
        } 

 
 
#include "mort3.inc"

object{mort3 scale 0.25 translate <0.34,5.24,-13.8>}



//reja - metal door

#include "mod13.inc"

object{reja2 scale <2.20,2.85,2.75> rotate-35*y translate <4.0,3.8,0.5>} 


//termoscopio- thermoscope 

#include "thermos.inc"

object{thermos scale 0.15 rotate -90*y translate <-0.20,5.49,-13.9>} //SCALA ESTABA EN 0.15


//librero -bookcase (rear)

#include "librero.inc"


object{librero scale <3,4,2> translate<-0.70,2,5.5>} 


#include "balanza.inc"

object{balanza 
scale 0.10
rotate 45*y 
translate <0.1,5.42,-13.95>} 
 


union{
object{envase translate<-4,9,-6>}
object{envase scale<0.25,0.5,0.25> translate<-2.85,9,-6.35>}
object{envase scale<0.30,0.8,0.30> translate<-2.75,9,-5.75>}
object{envase scale<0.25,0.5,0.25> translate<-2.20,9,-6.10>}
object{envase scale<0.25,0.5,0.25> rotate 2*y translate<-2.20,9.15,-6.10>} 

object{envase   translate<-5,0.45,-2.5>}
object {envase2  translate<-2.80,3,-3>}  
}


#include "piedras.inc"

object {piedras no_shadow texture{piedras1} 
    scale 0.60 
    translate<-2.85,3.15,-3>}
 
object {piedras no_shadow texture{piedras2} scale <0.07,0.05,0.06> rotate <4,33,7> translate <0.20,5.51,-14.28>}



#include "cortina.inc"
object{cortina scale <2.87,4,3>
    texture {tela2 scale 0.90} 
    rotate -40*y 
    rotate 7*z 
    translate <0.4,3.65,0.75>
    } 

 
#include "fabric.inc"
object{fabric scale <1.95,1.95,1.95> rotate -10*y translate <-3,7.97,-5.70>
        texture {tela3 scale 0.40}
        }  


#include "holder.inc"
object{holder scale 0.25 rotate 70*y translate <-1.80,0.60,-2.2>}


cylinder
{
  0*y,  2*y, 0.50
   open
   texture{
    pigment{Silver}
    normal {bumps 0.5 scale 0.05  bump_size 0.20}
    finish {
            metallic
            ambient 0.0
            diffuse 0.0
            brilliance 6.0
            reflection 0.9
            phong 0.8
            phong_size 120
            }
   
    } translate <1.4,7.25,-2>
} 


#include "mesa.inc"

object{mesa  scale <6,5.50,6> rotate -10*y translate<-5.35,2.74,4>} 









/*
// >>> NewTan (from file "colors.inc", line 140) <<<
#declare NewTan = color red 0.92 green 0.78 blue 0.62; 


#local ambiente= color rgb <0.808,0.694,0.518>

*/