// --------------------------------------------------------------------------------
// --------------------------------------------------------------------------------
/*
TITLE: Ocean Lab
RENDERER USED: Povray 3.1 / Mega POV 6.0
TOOLS USED: MGI Photosuite
RENDER TIME: ~8 hours
HARDWARE USED: Celeron 333

IMAGE DESCRIPTION:

Laboratory on the Ocean... OK, maybe this could have been entered inentered in the "SEA" 
topic in August 2000.

DESCRIPTION OF HOW THIS IMAGE WAS CREATED:

Painted the Island, Island vegitation and Beach layers with MGI photosuite.
I used POV to generate the underwater rocks, touched up with MGI PS.

I went through multiple iterations with the "lab" and finally decided to use the MadPipe 
macro by Gilles Tran.  I defined my own decorations which are included.  I also modified 
the pipedeco.inc file to handle dynamic number of decorations.

The Island Palm Trees are from TOMTREE.inc by AUST.  They are randomly placed.


The Rail system relies on Chris Colefax's SPLINE.INC and LINK.INC includes.  Spline 
calculates point to point and link link 'em up.  I also modified the link macro 
(probably unnecessarily) to fix the scaling of my link object.

The submarine is a blob object with an MGI PS painted image file mapped on it.

The spheres in the water are torus' combined with clear spheres.

The water surface is an isosurface. 

Some textures may have changed since the image was rendered.
*/
// --------------------------------------------------------------------------------
// --------------------------------------------------------------------------------
#version 3.1
#version unofficial MegaPov 0.5;


#declare render_lab         = 1;
#declare render_spheres     = 1;
#declare render_rails       = 1;
#declare render_supports    = 1;
#declare render_ship        = 1;

#declare render_trees       = 1;
#declare render_island_veg  = 1;
#declare render_island_sand = 1;
#declare render_island_rock = 1;
#declare render_high_water  = 1;
#declare render_low_water   = 1;
#declare render_water_rocks = 1;
#declare render_sky         = 1;
#declare render_fog         = 1;


#include "textures.inc"
#include "FunTex.inc"

background { rgb <.1,.1,.8> }

#declare C1 = 
camera{                 
  location <2.2,1.9,-27>
  angle 15
  look_at <4.3,0,5>
}

#declare C2 = 
camera{                 
  location <4.0, 1.2, -30>
  look_at <4.3, 0, 5>
}

#declare C3 = 
camera{                 
  location <2, 1.5, -3>
  look_at <2, .5, 0>
}

camera { C1 }   


// An area light (creates soft shadows)
light_source
{
  0*x 
  color rgb 1.0 
  area_light
  <10, 0, 0> <0, 0, 10> 
  4, 4 
  adaptive 0
  jitter 
  translate <-200, 900, -100> 
}

// create a regular point light source
light_source
{
  0*x // light's position (translated below)
  color rgb <0.8, 0.8, 0.8>  // light's color
  translate < 2, 30, -50> //<200, 900, 200>
  shadowless
}

// ------------  The Sea Ship
//
// Blob ship defined in ship.inc
//
#if (render_ship)

  #include "Ship.inc"

  object { M_Ship ( T_Submarine, T_Rust, T_Cockpit ) scale .47 rotate <-10,  58, -9> translate <1.8,.36,-13.2> }

  #declare k = seed(3301);  // x - seed
  #declare l = seed(22328); // z - seed
  #declare m = seed(217);   // y - height seed

  #declare i = 0; 
  #declare O_Bubbles = 
  union {
    #while (i <3000)
     
      sphere { <0,0,0> (.004+.007*rand(k))  translate <.6+4*rand(k),-.15+.3*rand(l),-.19+.38*rand(m)> texture {  T_Bubbles } }      
      #declare i = i+1;
      
    #end // while
  }
  object {O_Bubbles scale .38 rotate -9*z rotate 77*y  translate <1.9,.34,-13.1> }
  
  #declare i = 0; 
  #declare O_Bubbles = 
  union {
    #while (i <350)
      #declare xx = rand(k);     
      sphere { <0,0,0> (.011+.014*rand(k)) scale <1,.5,1> translate <(-.1+.4*xx), .03*rand(l), 0> rotate y*(360*rand(m)) texture { T_Bubbles } }      
      #declare i = i+1;
      
    #end // while
  // Center of the splash: < 2.3, .15, -13.9 >
  }

  object {O_Bubbles scale .5 translate < (.8+1.5), .15, (-16.4+1.5) > }


  #declare O_Wire = 
  union {
    cylinder { <-0.02,0,0> <0.02,0,0> .002 pigment {rgb 0}}
  }

  #declare link_object = O_Wire
  #declare link_size_override = 1;
  #declare link_looseness = 1;

  union {
    object { M_Ship ( T_Submarine, T_Rust, T_Cockpit ) scale .52 rotate <0, -95, -9> translate <-.6,.25,0>}

  // crane
    union {
      cylinder {<-.6,.5,-.04> <-.6,.5, .04> .04 }
      cylinder {<-.6,.5, 0> <-.3,.75,0> .02 }

      cylinder {<-.6,.5, 0> <-.3,.75,0> .02 }
      cylinder {<-.6,.5, 0> <-.3,.72,0> .02 }

      cylinder {<-.3,.68, 0> <-.3,.78,0> .04 }

      cylinder {<-.3,.75,0> <0,.75,0> .02 }
      cylinder {<-.3,.75,0> <0,.69,0> .02 }

    // crane power lines
      union {

         #declare link_looseness = 4;
         #declare link_point1 = <-.6,.5, 0>;
         #declare link_point2 = <-.3,.75,0>;
         #include "LINK.INC"     
         #declare link_looseness = 5;
         #declare link_point1 = <-.6,.5, 0>;
         #declare link_point2 = <-.3,.75,0>;
         #include "LINK.INC"     
         #declare link_looseness = 4;
         #declare link_point1 = <-.3,.75,0>;
         #declare link_point2 = <  0,.75,0>;
         #include "LINK.INC"     
         #declare link_looseness = 5;
         #declare link_point1 = <-.3,.75,0>;
         #declare link_point2 = <  0,.75,0>;
         #include "LINK.INC"     

      }

      superellipsoid { <0.3, .3> scale <.07,.09,.07> translate <0.1,.70,0> }

      cylinder {<-.6,.25,0> <-.6,.5,0> .003 pigment {rgb 0}}
    } 
    texture { T_Base_Building }    
    texture { T_Building_Rust }
    rotate <0,-45,0>
    translate <4.55, .72,  -0.0 >
  }


#end // if

            
// ------------  The Water Spheres
// 
// Tubular cage, holding a glass sphere with liquid.
// 
#if ( render_spheres = 1 )

  #declare b_rad = .22;    
  #declare i_rad = b_rad*.03;    
  #declare O_Ex_Sphere_Cage =    
  union {
    union {
      torus { b_rad i_rad rotate z*0 }
      torus { b_rad i_rad rotate z*30 }
      torus { b_rad i_rad rotate z*60 }
      torus { b_rad i_rad rotate z*90 }
      torus { b_rad i_rad rotate z*120 }
      torus { b_rad i_rad rotate z*150 }
      rotate <90,0,90 > 
    }
    torus { sqrt (pow(b_rad,2)-pow(b_rad*.9,2)) i_rad translate y* b_rad*.9 }
    torus { sqrt (pow(b_rad,2)-pow(b_rad*.9,2)) i_rad translate y*-b_rad*.9 }

    texture { T_Base_Building }
    texture { T_Rust }
  } // union
  
  #declare O_Ex_Sphere_Container =
  difference {
      sphere { <0, 0, 0> b_rad*.99 } 
      sphere { <0, 0, 0> b_rad*.98 } 
      texture { Glass2 }
  }

  #declare j = seed(6130); // rotate seed
  #declare k = seed(3301); // x - seed
  #declare l = seed(22328); // z - seed
  #declare m = seed(217); // y - height seed

  // Put a bunch of spheres randomly in the water
  
  #declare i = 0; 
  #while (i < 42) 
    union {                  
      object { O_Ex_Sphere_Cage  
        rotate <120*rand(j),110*rand(j),150*rand(j)> }

      #declare f_height = rand(m);
      // liquid inside
      #if (f_height > .2 )  // 20% of the cages are "empty"

        object { O_Ex_Sphere_Container }
      
        difference {
          sphere { <0, 0, 0> b_rad*.96 } 
          box { <-.3,(b_rad*.85-b_rad*f_height),-.3> <.3,.3,.3> } 
          texture { T_Liquid }
        }
      #end
      scale .75
      translate <(5-6*rand(k)),(.09+.05*f_height),(-13+12*rand(l))> 
    }
      
    #declare i = i+1;
  #end // while

  // Couple of "empty" cages on the beach  
  object { O_Ex_Sphere_Cage scale .8 rotate < 42,0,-12> translate <4.4, .28, 2.3 > }   
  object { O_Ex_Sphere_Cage scale .8 rotate <-18,0, 15> translate <4.5, .24, 1.75> }   
#end // if




// ------------  The Lab
//
// Uses MadPipe macro by Gilles Tran.  Some of Gilles decorations plus 
// my own defined in pipedeco.  Also altered pipedeco.inc to configure the Deco Array based on
// the value contained in nDeco.  This allowed me to easily test new decorations without
// commenting out large sections of pipedeco.inc.
//
#if ( render_lab = 1 )

  #declare nDeco=4;
  #declare Deco=array[nDeco]
  #include "pipedeco.inc"

  #declare box_hole=<0,0,0>; 
  #declare dPipe=0; 
  #declare nPipe=150;
  #declare rPipe=0.5;
  #declare lPipe=3.1; 
  #declare container=<5,13,5>;  
  
  #include "madpipe.inc"
  #declare Pipe_1=
  object{
    MadPipe(rPipe,lPipe,nPipe,dPipe,container,box_hole,1,16,false,"4.inc")  // 7 30   
    texture { T_Base_Building }    
    texture { T_Building_Rust }
    rotate -23*y
    scale .12
    translate <2.65, 1.05+.8  -1.1 >
  }            
  
  object {Pipe_1}

  #declare nPipe=30;
  #declare lPipe=1; 
  #declare container=<1,13,1>;  

  #declare Pipe_2=
  object{
    MadPipe(rPipe,lPipe,nPipe,dPipe,container,box_hole,1,28,false,"4.inc")      // 25 30 36
    texture { T_Base_Building }    
    texture { T_Building_Rust }
    rotate  -65*y
    scale .12
    translate <4.75, 1.15+.2  -0.5 >
  }            

  object {Pipe_2}
  
#end


// ------------ Rail supports  
//
//  Rail Support macro defines support. 
//
#if ( render_supports = 1 )
                
  #include "Rail_Support.inc"

  #declare O_Rail_Support = 
  union {  //        height, base, top, segments
    object { Rail_Support (5, .07, .07, 8) translate <0,-5,0> scale .4}
    cylinder { <.063,0,0> < -.063,0,0> .01}
  }
  // Supports positioned as in the .spl file
  #declare O_Support = 
  union {
     object {O_Rail_Support rotate -35*y translate <0,1,0> }          // 1
     object {O_Rail_Support rotate   0*y translate <3,.5,-3> }        // 2
     object {O_Rail_Support rotate -45*y translate <5,.5,-5> }        // 3
     object {O_Rail_Support rotate  25*y translate <6,.3,-9> }        // 4 
     object {O_Rail_Support rotate  53*y  translate < 4, 0.6,-11 > }  // 5 
     object {O_Rail_Support rotate  20*y translate  < 1.5, 0.75,-14 > } // 6
     object {O_Rail_Support rotate -37*y translate  < 3, 0.45,-18 > }  // 7
  }

  object { O_Support scale .7 rotate 16*y translate <3.32,-.07, -.3> 
    texture { T_Black_Metal }
    texture { T_Rust scale <2,11,2>}
  }
#end
  

// ------------ Rail on top of the supports  
//  
//  Uses SPLINE.INC and LINK.INC created by Chris Colefax
//  Spline calculates the rail system points.  Link connects to two with 
//  the define O_Rail_Elem
//  LINK.inc was modified (probably unecessarily) to force the consistent scale
//  of the link_object (link_size_override)
//
#if ( render_rails = 1 )

  #declare O_Rail_Elem = 
  union {
    cylinder { <-0.3,0,-.1> < 0.3,0,-.1> .025}
    cylinder { <-0.3,0, .1> < 0.3,0, .1> .025}
  }

  // setup the spline.inc and link.inc parameters
  #declare link_object = O_Rail_Elem
  #declare link_size_override = .5;
  #declare link_looseness = 0;
  #declare total_link_twist = 0; // in degrees
  #declare Smoothness = 350;
  #declare Smoothness = (1 / Smoothness);
  #declare Count = 0; 

  #declare O_Rail = 
  union {

     // cycle the clock to calculate a new spline point
     #while (Count < 1)
       #declare spline_clock = Count; 
       
       // vectors.spl includes the spline vectors and start/ end points 
       // It also includes spline.inc
       #include "rails.spl"
   
       #declare CurPoint = spline_pos;

       #ifdef (PrevPoint)
         #declare link_point1 = PrevPoint;
         #declare link_point2 = CurPoint;
         // now connect the two points with the rails from above
         #include "LINK.INC"     
       #end

       #declare PrevPoint = CurPoint;

     #declare Count = Count + Smoothness;
     #end

  }
    
  object { O_Rail scale .7 rotate 16*y translate <3.32,-.07, -.3> 
    texture { T_Black_Metal }
    texture { T_Rust scale .5 }
  }

#end

// ------------ Palm Trees  
//
// Uses TOMTREE.inc by AUST to create the Island Palms
// 
#if (render_trees = 1)
  #include "PALM.inc"
  #include "TOMTREE.inc"

//  #declare TREE = sphere {<0,0,0>, .4 scale <1,1.5,1.5> pigment { rgb <1,1,1>} }           
           
  #declare O_Tree = 				
  object
  {
    TREE
    scale .5
  } 

  #declare O_Trees = 
  union {  
  // Trees on left mountain
    #declare j = seed(32);
    #declare k = seed(14);
    #declare l = seed(1234);
    #declare i = 0;
    #while (i < 16) 

      object { O_Tree
        rotate <0,360*rand(l),0> 
        scale <1, 1+rand(k)*.1, 1> 
        translate <2.2+1.3*rand(j), .84, 3.3+3.3*rand(k)>
      }
      #declare i = i+1;
    #end // while


  // Trees on Right Mountain
    #declare j = seed(132);
    #declare k = seed(382);
    #declare l = seed(6231);
    #declare i = 0;

    #while (i < 22) 
      object { O_Tree 
        rotate <0,360*rand(l),0> 
        scale <1, 1+rand(k)*.1, 1> 
        translate <5.2+2*rand(j), .85, 3.2+3.4*rand(k) >
      }
      #declare i = i+1;
    #end // while

  // Trees on Right Beach
    #declare j = seed(13);
    #declare k = seed(32);
    #declare l = seed(31);
    #declare i = 0;

    #while (i < 4) 
      object { O_Tree 
        rotate <0,360*rand(l),0> 
        scale <1, 1+rand(k)*.1, 1> 
        translate <6.7+.4*rand(j), .05, 2.0+.6*rand(k) >
      }
      #declare i = i+1;
    #end // while

  // Trees on Left Beach
    #declare j = seed(17);
    #declare k = seed(367);
    #declare l = seed(32);
    #declare i = 0;

    #while (i < 3) 
      object { O_Tree 
        rotate <0,360*rand(l),0> 
        scale <1, 1+rand(k)*.1, 1> 
        translate <1.9-.5*rand(j), .02, 1.2+.8*rand(k)>
      }
      #declare i = i+1;
    #end // while

  // Trees on Center Beach
    #declare j = seed(100);
    #declare k = seed(4);
    #declare l = seed(66);
    #declare i = 0;

    #while (i < 5) 
      object { O_Tree 
        rotate <0,360*rand(l),0> 
        scale <1, 1+rand(k)*.1, 1> 
        translate <3.6+.7*rand(j), .06, 2.2+.8*rand(k) >
      }
      #declare i = i+1;
    #end // while

   } // union

  object { O_Trees }

#end // if



// ------------ Island
//
// vegatation layer - hand-painted HF
//
#if (render_island_veg = 1)
  #declare O_Vegitation=
  height_field
  {
    tga
    "island_veg_hf.tga" scale <10, 1.0, 10 > //<9.999,1.05,9.999>  
    smooth
    water_level .1
  texture{T_Grass}
  translate <0,0.06,0>
  }
  object { O_Vegitation }
#end


// Rocky layer - hand-painted HF
//
#if (render_island_rock = 1)
  #declare O_Island=
  height_field
  {
    tga
    "island_hf.tga" scale <10,1.0,10>  
    smooth
    water_level .001
  texture{T_Base}
  texture{T_Dirt scale .8}
  }
  object { O_Island }
#end
  
// Sand layer - hand-painted HF
//
#if (render_island_sand = 1)
  #declare O_Sand=
  height_field
  {
    tga
    "island_sand_hf.tga" scale <10,1.4,10>  
    smooth
    water_level .01
  texture{T_Sand}
  texture{T_Dirt scale .3}
  translate <0,0.0,0>
  }
  object { O_Sand }
#end


// ------------ Water Rocks
// 
#if ( render_water_rocks = 1 )
  #declare O_Water_Rocks=
  height_field
  {
    tga
    "rocks_hf.tga" scale <20,.18,20>
    water_level .01
    texture{ T_Sand } //T_Sand}
    texture{ T_Dirt scale .2}
    translate <-4,.011,-14>
  }
  
  object { O_Water_Rocks }
#end
  

// ------------ Sea Surface
//
#if ( render_high_water = 1 )

/*
  height_field
  {
    tga
    "waves_hf.tga" scale <100, .04, 300 >
    smooth
    translate < -20, .13,-20 >
    texture{ T_Water00 }
    no_shadow
  }
*/

  #declare i_max = 500000;

  #declare F_W_S =
     function { pigment { granite scale 25 color_map {[0 rgb 1][1 rgb 0]} } }

  #declare O_Water =
  isosurface {               
    function { y + 0.5 - F_W_S(x,y,z)*0.8 }   
    contained_by { sphere { <0,-i_max,0> i_max+1 } } 
    method 2 
    max_gradient 1.2 //eval
    accuracy 0.01
  }

  #declare O_Ocean =
  union {
    object { 
      O_Water 
      material { M_Water }
      hollow 
    }
    sphere { <0,-i_max,0>, i_max-500
      texture { pigment { rgb <0,1,0> } finish { ambient 0 diffuse 1 } }
    }
  }

  object { O_Ocean translate +.03*y }

#end


// ------------ Sea Bottom
//
#if ( render_low_water  = 1 )
  #declare O_Low_Water =
  plane {
    y, 0.01
   texture{ T_Rocks }
  }
  
  object { O_Low_Water }  
  
// behind the island, simplify the sea bottom
  box {<-400,.02,2><400,.02,3000> 
    pigment { rgb <.1, 0.4, 0.1>*.2 
    }
  }

#end


// ------------  Fog Layer
//
#if ( render_fog = 1 )
  fog {
      distance 100
      colour rgbf<0.97, 1.0, 0.97, 0.1>
      fog_type 2
      fog_offset 0
      fog_alt 1
      turbulence 0.4
  }
#end


// ------------  Sky
//
#if ( render_sky = 1 )
  sky_sphere { S_Clouds scale .1 }
#end
