 furnish.inc     
B@ 8"
B D  PDX    
B@TEXTMPS           &  J=$z                       ^  // Persistence Of Vision INCLUDE file
// File:        furnish.inc
// Vers:        3.1g.r1 Mac PPC
// Desc:        General house furnishings
// Auth:        Peter Murray
// Date:        10 October 2000

#debug "\r  furnish.inc - General house furnishings\r"

// Textures
#declare CeramicWhite=
texture{WhitePt finish{specular 1 roughness 0.1}}

#declare PlasticWhite=
texture{WhitePt finish{Phong_Shiny}}

// Variables

// Objects
#declare Screw025=
union{
	difference{
		cone{<0,0,0>*in,0.12*in,<0,0,0.25>*in,0.1*in}
		box{<-0.025,-2,-0.1>*in,<0.025,2,0.125>*in}
	}
	cylinder{<0,0,0.25>*in,<0,0,0.45>*in,0.1*in}
	texture{T_Brass_3C}
}

#declare Screw0125=
union{
	difference{
		cone{<0,0,0>*in,0.06*in,<0,0,0.25>*in,0.05*in}
		box{<-0.0125,-2,-0.1>*in,<0.0125,2,0.125>*in}
	}
	cylinder{<0,0,0.25>*in,<0,0,0.45>*in,0.05*in}
	texture{T_Brass_4E}
}

#declare Stool=
union{
	cylinder{<0,16,0>*in,<0,18,0>*in,9*in}
	difference{
		union{
			#local Angle=45;
			#while (Angle<360)
				cylinder{<0,17,-7>*in,<0,0,-9.5>*in,0.5*in rotate y*Angle}
				#local Angle=Angle+90;
			#end
		}
		box{<-11,-1,-11>*in,<11,0,11>*in}
	}
	torus{6.5*in,0.5*in translate <0,12,0>*in}
	torus{8.5*in,0.5*in translate <0,4.5,0>*in}
	texture{T_Wood10}
}

// Sink origin = <centre, top of basin, back>
#declare SinkUnit=
union{
	difference{
		union{
			box{<-5.5,-6.5,-10>*in,<5.5,0,0>*in}
			box{<-6,-6.5,-9.5>*in,<6,0,-0.5>*in}
			cylinder{<-5.5,0,-0.5>*in,<5.5,0,-0.5>*in,0.5*in scale <1,0.5,1>}
			cylinder{<-5.5,0,-0.5>*in,<-5.5,0,-9.5>*in,0.5*in scale <1,0.5,1>}
			cylinder{<5.5,0,-0.5>*in,<5.5,0,-9.5>*in,0.5*in scale <1,0.5,1>}
			cylinder{<-5.5,0,-9.5>*in,<5.5,0,-9.5>*in,0.5*in scale <1,0.5,1>}
			sphere{<-5.5,0,-0.5>*in,0.5*in scale <1,0.5,1>}
			cylinder{<-5.5,0,-0.5>*in,<-5.5,-6.5,-0.5>*in,0.5*in}
			sphere{<5.5,0,-0.5>*in,0.5*in scale <1,0.5,1>}
			cylinder{<5.5,0,-0.5>*in,<5.5,-6.5,-0.5>*in,0.5*in}
			sphere{<-5.5,0,-9.5>*in,0.5*in scale <1,0.5,1>}
			cylinder{<-5.5,0,-9.5>*in,<-5.5,-6.5,-9.5>*in,0.5*in}
			sphere{<5.5,0,-9.5>*in,0.5*in scale <1,0.5,1>}
			cylinder{<5.5,0,-9.5>*in,<5.5,-6.5,-9.5>*in,0.5*in}
		}
		box{<-5,-5,-9>*in,<5,0.5,-1>*in}
		cylinder{<-5,-5,-1.25>*in,<5,-5,-1.25>*in,1*in scale <1,1,4>}
		cylinder{<0,-5,-9>*in,<0,-5,-1>*in,1*in scale <5,1,1>}
		cylinder{<-0,-7,-5>*in,<0,-5,-5>*in,0.75*in}
		box{<-0.5,-0.75,-0.25>*in,<0.5,-1.25,-2>*in}
		cylinder{<-0.5,-1,-0.25>*in,<-0.5,-1,-2>*in,0.25*in}
		cylinder{<0.5,-1,-0.25>*in,<0.5,-1,-2>*in,0.25*in}
		texture{CeramicWhite}
	}
	// drain
	difference{
		cylinder{<-0,-6.6,-5>*in,<0,-5.9,-5>*in,1.25*in}
		cylinder{<-0,-6.7,-5>*in,<0,-5.8,-5>*in,0.75*in}
		texture{SilverPt}
	}
	// tap section
	union{
		box{<-1.5,0,0>*in,<1.5,0.75,-1>*in}
		cylinder{<0,0.75,-0.5>*in,<0,2.5,-0.5>*in,0.5*in}
		cone{<0,2.5,-0.5>*in,0.5*in,<0,2.75,-0.5>*in,0.25*in}
		cylinder{<-1.0,1.5,-0.5>*in,<1.0,1.5,-0.5>*in,0.5*in}
		cylinder{<-1.1,1.5,-0.5>*in,<1.1,1.5,-0.5>*in,0.45*in}
		texture{CeramicWhite}
	}
	// hot tap
	union{
		cone{<0,0,0.1>*in,0.5*in,<0,0,-1>*in,0.75*in}
		cone{<0,0,-1>*in,0.75*in,<0,0,-1.5>*in,0.4*in}
		box{<0,-0.1,-1.1>*in,<1.5,0.1,-1.4>*in}
		cylinder{<0,0,-1.6>*in,<0,0,-1.4>*in,0.35*in texture{RedPt finish{Shiny}}}
		rotate y*90
		rotate x*90*0
		translate <-1.0,1.5,-0.5>*in
		texture{PlasticWhite}
	}
	// cold tap
	union{
		cone{<0,0,0.1>*in,0.5*in,<0,0,-1>*in,0.75*in}
		cone{<0,0,-1>*in,0.75*in,<0,0,-1.5>*in,0.4*in}
		box{<0,-0.1,-1.1>*in,<-1.5,0.1,-1.4>*in}
		cylinder{<0,0,-1.6>*in,<0,0,-1.4>*in,0.35*in texture{BluePt finish{Shiny}}}
		rotate y*-90
		rotate x*90*0
		translate <1.0,1.5,-0.5>*in
		texture{PlasticWhite}
	}
	// water inlet
	union{
		cylinder{<0,2.75,0>*in,<0,5,0>*in,0.25*in}
		intersection{
			torus{1,0.25 rotate <0,0,90>}
			box{<-0.3,0,0>*in,<0.3,1.3,1.3>*in}
			translate <0,5,-1>*in
		}
		cylinder{<0,6,-1>*in,<0,6,-2.5>*in,0.25*in}
		intersection{
			torus{1,0.25 rotate <0,0,90>}
			box{<-0.3,0,0>*in,<0.3,1.3,-1.3>*in}
			translate <0,5,-2.5>*in
		}
		cylinder{<0,4.5,-3.5>*in,<0,5,-3.5>*in,0.25*in hollow}
		rotate y*-80
		translate <0,0,-0.5>*in
		texture{PlasticWhite}
	}
}

// Plug in at <1.25,0.3125,-1.2>*in and <-1.25,0.3125,-1.2>*in
#declare PowerSocket=
union{
	difference{
		superellipsoid{
			<0.15,0.15> scale <2.5,1.5,0.625>
			translate <0,0,-0.625>*in
		}
		difference{//mark where faceplate comes off
			box{<-2.6,-1.6,-0.95>*in,<2.6,1.6,-1.05>*in}
			box{<-2.4,-1.4,-0.9>*in,<2.4,1.4,-1.1>*in}
		}
		//mounting holes
		cylinder{<2.125,0,-1.3>*in,<2.125,0,-0.8>*in,0.125*in}
		cylinder{<-2.125,0,-1.3>*in,<-2.125,0,-0.8>*in,0.125*in}
		// right socket
		box{<1.15625,0.125,-1.3>*in,<1.34375,0.5,-0.8>*in}
		box{<1.875,-0.625,-1.3>*in,<1.5,-0.4375,-0.8>*in}
		box{<1,-0.625,-1.3>*in,<0.625,-0.4375,-0.8>*in}
		// left socket
		box{<-1.15625,0.125,-1.3>*in,<-1.34375,0.5,-0.8>*in}
		box{<-1.875,-0.625,-1.3>*in,<-1.5,-0.4375,-0.8>*in}
		box{<-1,-0.625,-1.3>*in,<-0.625,-0.4375,-0.8>*in}
		// spaces for switches
		box{<-0.5,0.25,-1.3>*in,<-0.125,1.125,-0.8>*in}
		box{<0.5,0.25,-1.3>*in,<0.125,1.125,-0.8>*in}
	}
	// switches
	box{
		<-0.45,-0.437,-0.1>*in,<-0.13,0.437,0.1>*in
		rotate x*9 translate <0,0.6825,-1.2>*in
	}
	box{
		<0.45,-0.437,-0.1>*in,<0.13,0.437,0.1>*in
		rotate x*-9 translate <0,0.6825,-1.2>*in
	}
	// screws
	object{Screw025 rotate z*15 translate <2.125,0,-1.2>*in}
	object{Screw025 rotate z*80 translate <-2.125,0,-1.2>*in}
	texture{PlasticWhite}
}

#macro PowerPlug(Bodycolour)
union{
	difference{
		prism{//body
			linear_sweep cubic_spline
			0,0.5,11,
			<-0.5,-1.5>*in,<0,-1.625>*in,<0.5,-1.5>*in,<0.875,-1>*in,
			<0.625,0.25>*in,<0,0.5>*in,<-0.625,0.25>*in,<-0.875,-1>*in,
			<-0.5,-1.5>*in,<0,-1.625>*in,<0.5,-1.5>*in
			rotate x*-90
			translate <0,0,0>*in
		}
		cylinder{<0,-1.7,-0.5>*in,<0,0,-0.5>*in,0.25*in}//hole for wire
		cylinder{<-0.25,-0.5,0.1>*in,<-0.25,-0.5,-0.6>*in,0.125*in}//plug to hold body and top together
		//screws gripping wire
		cylinder{<-0.375,-1.25,0.1>*in,<-0.375,-1.25,-0.6>*in,0.125*in}
		cylinder{<0.375,-1.25,0.1>*in,<0.375,-1.25,-0.6>*in,0.125*in}
		//view of fuse
		box{<0.3,-0.75,0.1>*in,<0.5,-0.25,-0.6>*in}
		//finger holds
		sphere{<0,0,0>,0.5*in scale <0.25,1,0.5> translate <0.875,-0.25,-0.5>*in}
		sphere{<0,0,0>,0.5*in scale <0.25,1,0.5> translate <-0.875,-0.25,-0.5>*in}
		texture{PlasticWhite pigment{Bodycolour}}
	}
	difference{
		prism{//top
			linear_sweep cubic_spline
			0,0.25,11,
			<-0.5,-1.5>*in,<0,-1.625>*in,<0.5,-1.5>*in,<0.875,-1>*in,
			<0.625,0.25>*in,<0,0.5>*in,<-0.625,0.25>*in,<-0.875,-1>*in,
			<-0.5,-1.5>*in,<0,-1.625>*in,<0.5,-1.5>*in
			rotate x*-90
			translate <0,0,-0.51>*in
		}
		cylinder{<0.125,-1.7,-0.5>*in,<0.125,0,-0.5>*in,0.125*in}
		box{<-0.125,-1.7,-0.625>*in,<0.125,0,-0.5>*in}
		cylinder{<-0.125,-1.7,-0.5>*in,<-0.125,0,-0.5>*in,0.125*in}
		texture{PlasticWhite pigment{Bodycolour}}
	}
	box{<-0.0625,-1.25/8,0>*in,<0.0625,1.25/8,0.875>*in}
	box{<-1.25/4,-15/16,0>*in,<-1.25/4-0.25,-13/16,0.6875>*in}
	box{<1.25/4,-15/16,0>*in,<1.25/4+0.25,-13/16,0.6875>*in}
	object{Screw025 rotate y*180 rotate z*25 translate <-0.25,-0.5,-0.05>*in}
	object{Screw025 rotate y*180 rotate z*130 translate <-0.375,-1.25,-0.05>*in}
	object{Screw025 rotate y*180 rotate z*70 translate <0.375,-1.25,-0.05>*in}
	texture{T_Brass_5B}
}
#end

// Plug in at <0,0,-1.125>*in
#declare TelecomSocket=
union{
	difference{
		superellipsoid{
			<0.15,0.15> scale <1.3125,1.25,0.625>
			translate <0,0,-0.5>*in
		}
		difference{//mark where faceplate comes off
			box{<-1.4,-1.3,-0.95>*in,<1.4,1.3,-1.05>*in}
			box{<-1.2625,-1.2,-0.9>*in,<1.2625,1.2,-1.1>*in}
		}
		box{<-1.4,-1.3,0>*in,<1.4,1.3,0.2>*in}
		//mounting holes 1/8 in 1/8 wide
		cylinder{<1.0625,0,-1.2>*in,<1.0625,0,-0.8>*in,0.0625*in}
		cylinder{<-1.0625,0,-1.2>*in,<-1.0625,0,-0.8>*in,0.0625*in}
		//socket
		box{<-0.3125,-0.1875,-1.2>*in,<0.3125,0.1875,-0.5>*in}
		//socket surround
		box{<-0.3125,-0.6,-1.05>*in,<0.3125,-0.1875,-1.3>*in rotate x*7}
	}
	union{
		box{<-0.3125,0.175,-1.2>*in,<0.3125,0.1875,-1>*in}
		box{<-0.3125,0.175,-1.05>*in,<0.3125,0.6,-1>*in}
		translate y*-0.3625*0//to close the shutter
	}
	// screws
	object{Screw0125 rotate z*42 translate <1.0625,0,-1.175>*in}
	object{Screw0125 rotate z*75 translate <-1.0625,0,-1.15>*in}
	texture{PlasticWhite}
}

#macro TelecomPlug(PluggedIn)
union{
	difference{
		box{<-0.21875,-0.125,-0.375>*in,<0.21875,0.125,0.625>*in}
		//lots of notches on the bottom
		box{<-0.3,-0.0625,0>*in,<0.3,-0.15,0.7>*in}
		box{<-0.1855,0,0>*in,<-0.3,-0.08,0.7>*in}
		box{<-0.0625,0,0.34375>*in,<0.0625,-0.08,0.7>*in}
		box{<-0.0625,0,-0.125>*in,<0.0625,-0.08,-0.0625>*in}
		box{<-0.0625,-0.0625,-0.1875>*in,<0.0625,-0.15,-0.0625>*in}
		//lots of notches on the top
		box{<-0.15625,0,-0.1875>*in,<0.15625,0.15,-0.0625>*in}
		box{<-0.15625,0,0.3125>*in,<0.15625,0.15,0.375>*in}
		#local XX=-0.15625;
		#while (XX<=0.15625)
			box{<XX-0.028,0.0625,0.3125>*in,<XX+0.028,0.15,0.7>*in}
			box{<XX-0.028,0.09375,0.125>*in,<XX+0.028,0.15,0.3125>*in}
			#local XX=XX+0.0625;
		#end
	}
	//clip on the side
	box{<0.2,-0.09375,0.5>*in,<0.25,0.09375,0.625>*in}
	box{
		<0,-0.09375,-0.5>*in,<0.0625,0.09375,0>*in
		rotate y*-(5-4*PluggedIn) translate <0.25,0,0.625>*in
	}
	box{<0,-0.09375,-0.375>*in,<0.0625,0.09375,0>*in
		rotate y*-7 translate <0,0,-0.5>*in
		rotate y*-(5-4*PluggedIn) translate <0.25,0,0.625>*in
	}
	box{
		<-0.2,0,0.45>*in,<0.2,0.1,0.625>*in
		texture{T_Brass_5E}
	}
	//and the cable leading out
	difference{
		superellipsoid{
			<0.15,0.15> scale <0.09375,0.03125,2>
		}
		box{<-0.1,-0.05,0>*in,<0.1,0.05,3>*in}
		translate <0,0,-0.375>*in
		texture{PlasticWhite pigment{Gray90}}
	}
	texture{PlasticWhite}
}
#end

#declare Conduit12=
union{
	superellipsoid{
		<0.025,0.5> scale <7,0.5,0.5>
		translate <0,0,-0.25>*in
		bounded_by{box{<-6,-1,-0.75>*in,<6,1,0>*in}}
		clipped_by{bounded_by}
	}
	texture{PlasticWhite}
}

#debug "\r----\rend of furnish.inc\r----\r"
                                                                                                                  n   n   >  QIcon
           @         furnish.incs(EX) Apr 2000leesnd  TEXTMPS   K R                  J=  &       Q
lamppost.pict   PICTJVWR         $                                                  x                Q   H 	Monaco ssw|<inc
// Vers:        CC$z                CC                   n   n   >z%P    >  MPSR  
           L|#                                                                                    