 
matrix.mcr      
B@ 8"
B D  PDXx   
B@TEXTMPS            _#2                       K  // Persistence Of Vision INCLUDE file
// File:        matrix.mcr
// Vers:        3.1 Mac PPC
// Desc:        Define macros to manipulate matrices
// Auth:        Peter Murray
// Date:        10th December 1999

#debug "\r  matrix.mcr - Define macros to manipulate matrices.\r"

// writeout("The present value of A is",A)
#macro writeout(String,Matrix)
  #if (dimensions(Matrix)=2)
	  #local Row=0;#local Col=0;
		#write(DebugFile,String)
		#local WString=substr("                              ",1,strlen(String))
		#while (Row<dimension_size(Matrix,1))
			#while (Col<dimension_size(Matrix,2))
				#write(DebugFile,Matrix[Row][Col],",")
				#local Col=Col+1;
			#end
			#local Row=Row+1;#local Col=0;
			#write(DebugFile,"\n",WString)
		#end
	#end
#end

// Defines the matrix equivalent of 1
#declare IdentityMatrix=array[4][4]{
  {1,0,0,0},
  {0,1,0,0},
  {0,0,1,0},
  {0,0,0,1}
}

// Add a column to a POV matrix to make manipulation easier.
#macro MatrixExtend(aMatrix)
  #local bMatrix=array[4][4]{
    {aMatrix[0][0],aMatrix[0][1],aMatrix[0][2],0}
    {aMatrix[1][0],aMatrix[1][1],aMatrix[1][2],0}
    {aMatrix[2][0],aMatrix[2][1],aMatrix[2][2],0}
    {aMatrix[3][0],aMatrix[3][1],aMatrix[3][2],1}
  }
  #declare aMatrix=bMatrix
#end

// Remove the extra column from a manipulable matrix for POV to use.
#macro MatrixUse(aMatrix)
  matrix <
    aMatrix[0][0],aMatrix[0][1],aMatrix[0][2],
    aMatrix[1][0],aMatrix[1][1],aMatrix[1][2],
    aMatrix[2][0],aMatrix[2][1],aMatrix[2][2],
    aMatrix[3][0],aMatrix[3][1],aMatrix[3][2]
  >
#end

// Assume for now both are 4x4.
// Add two matrices.
// Return a value in aMatrix
#macro MatrixAdd(aMatrix,bMatrix)
  #local cMatrix=array[4][4]{
		{0,0,0,0},
		{0,0,0,0},
		{0,0,0,0},
		{0,0,0,0}
	}
	#local Row=0;#local Col=0;
	#while (Row<dimension_size(aMatrix,1))
		#while (Col<dimension_size(aMatrix,2))
			#local cMatrix[Row][Col]=aMatrix[Row][Col]+bMatrix[Row][Col];
			#local Col=Col+1;
		#end
		#local Row=Row+1;#local Col=0;
	#end
	#local aMatrix=cMatrix
#end

// Assume for now both are 4x4.
// Multiply two matrices.
// Return a value in aMatrix
#macro MatrixMult(aMatrix,bMatrix)
  #local cMatrix=array[4][4]{
		{0,0,0,0},
		{0,0,0,0},
		{0,0,0,0},
		{0,0,0,0}
	}
	#local Row=0;#local Col=0;#local Indx=0;
	#while (Row<dimension_size(aMatrix,1))
		#while (Col<dimension_size(bMatrix,2))
			#while (Indx<dimension_size(aMatrix,2))
				#local cMatrix[Row][Col]=cMatrix[Row][Col]+(aMatrix[Row][Indx]*bMatrix[Indx][Col]);
				#local Indx=Indx+1;
			#end
			#local Col=Col+1;#local Indx=0;
		#end
		#local Row=Row+1;#local Col=0;#local Indx=0;
	#end
	#local aMatrix=cMatrix
#end

#macro MatrixTranslate(aMatrix,aTranslation)
  #local cMatrix=array[4][4]{
		{ 1, 0, 0, 0}
		{ 0, 1, 0, 0}
		{ 0, 0, 1, 0}
		{aTranslation.x,aTranslation.y,aTranslation.z, 1}
	}
	// Now apply that to aMatrix:
	MatrixMult(aMatrix,cMatrix)
#end

#macro MatrixScale(aMatrix,aScale)
  #local cMatrix=array[4][4]{
		{aScale.x, 0, 0, 0}
		{ 0,aScale.y, 0, 0}
		{ 0, 0,aScale.z, 0}
		{ 0, 0, 0, 1}
	}
	// Now apply that to aMatrix:
	MatrixMult(aMatrix,cMatrix)
#end

#macro MatrixXRotate(aMatrix,aRotate)
	#local CTheta=cos(radians((x*aRotate).x));
	#local STheta=sin(radians((x*aRotate).x));
  #local cMatrix=array[4][4]{
		{ 1, 0, 0, 0}
		{ 0, CTheta, STheta, 0}
		{ 0,-STheta, CTheta, 0}
		{ 0, 0, 0, 1}
	}
	// Now apply that to aMatrix:
	MatrixMult(aMatrix,cMatrix)
#end

#macro MatrixYRotate(aMatrix,aRotate)
	#local CTheta=cos(radians((y*aRotate).y));
	#local STheta=sin(radians((y*aRotate).y));
  #local cMatrix=array[4][4]{
		{ CTheta, 0,-STheta, 0}
		{ 0, 1, 0, 0}
		{STheta, 0, CTheta, 0}
		{ 0, 0, 0, 1}
	}
	// Now apply that to aMatrix:
	MatrixMult(aMatrix,cMatrix)
#end

#macro MatrixZRotate(aMatrix,aRotate)
	#local CTheta=cos(radians((z*aRotate).z));
	#local STheta=sin(radians((z*aRotate).z));
  #local cMatrix=array[4][4]{
		{CTheta,STheta, 0, 0}
		{-STheta, CTheta, 0, 0}
		{ 0, 0, 1, 0}
		{ 0, 0, 0, 1}
	}
	// Now apply that to aMatrix:
	MatrixMult(aMatrix,cMatrix)
#end

                                                                                      n   n   >                                
matrix.mcrus(EX) Apr 2000leesnd  TEXTMPS   &                   _        S                                                            . ^  A p p l e C D   A u d i o   P l a y e r       #   H 	Monaco ffz# wwwwww  	   O^ O^#2  !  /  
     O^ O^  
               n   n   >z%@D    >  MPSR  
           L|#h                                                                                    