#version 3.1
#macro flask(water_v, translation)

#declare gold = 
texture {
    pigment { color rgb <1,.9,.4> } 
    finish { diffuse .3 brilliance 1 specular 2 roughness .01 reflection .3 metallic ambient .1 }
}

#if (Main > 1)
    #local glass = 
    material { 
        texture { 
            pigment { color rgbf <.98,1,.99,.925> } 
            finish { diffuse .05 ambient 0 specular .025 ambient .001 roughness .001 reflection .15 }
        }
        interior {
            ior 1.5
            caustics .7
        }
    }
    #local water = 
    material { 
        texture { 
            pigment { color rgbf water_v } // Example: color rgbf <0,1,0,.9>
            finish { diffuse .05 ambient .2 specular .05 roughness .002 reflection .15 }
        }
        interior {
            ior 1.33
            caustics .7
        }
    }
#else
    #local glass = 
    material { 
        texture { 
            pigment { color rgbf <1,1,1,.8> } 
        } 
    }
    #local water = 
    material { 
        texture { 
            pigment { color rgbf water_v } 
        } 
    }
#end

union {
    blob {
        threshold 0.1
        
        cylinder { <0,1,0> <0,8,0> 1.2 50 }
        sphere { <0,0,0> 1 75 scale <1.3,.6,1.3> translate y*8.7 }
        cylinder { <0,2,0> <0,12,0> 1, -600 }
        
        sphere { <0,0,0> 1 500 scale <3,4,3> translate y*3 }
        sphere { <0,0,0> 1, -5000 scale <2.8,3.8,2.8> translate y*3 }
        
        rotate <0,0,0>
    
        material { glass }
        
    }
    
    blob {
        threshold 0.2
        sphere { <0,0,0> 1 50 scale <2.8,3.6,2.8> translate y*3 rotate <0,0,0>}
        sphere { <0,0,0> 1, -10000 scale <500,5,500> translate y*8 }
        
        material { water }
    
    }

    blob {
        threshold .2
        sphere { <0,0,0> 1 10 scale <3,.35,3> }
        sphere { <0,0,0> 1, -550 scale <3,4,3> translate y*3 }

        sphere { <0,0,0> 1 3 scale <4.5,1,.5> translate y*-.5 }
        sphere { <0,0,0> 1 3 scale <.5,1,4.5> translate y*-.5 }

        texture { gold }
    }

    scale .25
    translate translation+<0,.2,0>
    
}
#end