////////////

#declare Main = 5;

////////////

camera {location <0,3.25,-5> look_at <0,.2,0> angle 60 }

light_source { <5,10,5> color rgb 1 area_light <.75,0,-.75> <0,1,0> 2 2 }

global_settings { 
    max_trace_level 22
    radiosity { brightness 5 distance_maximum 2 recursion_limit 2 }
}

////////////

#declare wall_texture =
texture {
    pigment { color rgb <.75,1,.8> }
    normal { bumps .05 scale .1}
    finish { specular .3 roughness .75 }
}

#declare board_texture =
texture {
    pigment { color rgb <1,1,1> }
    normal { brick .125 brick_size <.009,.009,.009> mortar .005 }
    finish { specular .2 ambient .125 roughness .75 }
}

////////////

box { <-6,-1,-5> <6,0,5> texture { board_texture } }

plane { y, -5 pigment {color rgb <.75,.8,1> } }

plane { z, -20 texture{ wall_texture } }
plane { -z, -20 texture{ wall_texture } }
plane { -x, -20 texture{ wall_texture } }
plane { x, -20 texture{ wall_texture } }

plane { y, 15 pigment {color rgb <.75,.8,1> } }

#include "bottle.pov"

flask(<1,0,0,.9>,<2.25,0,0>)
flask(<.5,.5,.5,.9>,<0,0,0>)
flask(<0,0,1,.9>,<-2.25,0,0>)
flask(<0,1,0,.9>,<1.125,0,-1.125>)
flask(<1,1,0,.9>,<-1.125,0,-1.125>)

