#include "kolors.inc"  
#include "keyboard.inc"   
#include "monitor.inc"
#include "monitor1.inc"
#include "monitor2.inc"
#include "textures.inc"   

#declare use_display  = 1;
#declare use_window = 0;
#declare entrancegate = 1;

background{Black}

  camera {
    angle 10
    location <100,350,-500>
    //location <100,350,-300>
    //location <300,20,0>
    look_at <0,0,0>
  }
        
              
  //light coming from within the control centre              
  light_source { <0, 80, -400> color White }
  
  light_source { <400, 0, 0> color White }
 
 

                
//Create the monitor but then take away the base and backbit by using the difference function
#declare ControlPanelScreen1 = difference
   {  
      //Create monitor
      union
      {  
      	Monitor(use_display) //Piccy resolution 861x620
      
      	translate <10*cm, 0, -20*cm>
      }

      //Combine the two boxes and then "take them away" from the monitor
      union {
         // create a box that extends between the 2 specified points
         box
         {
           <-3, -1, -1>  // one corner position <X1 Y1 Z1>
           < 1,  1.5,  1>  // other corner position <X2 Y2 Z2>
           scale <20, 6, 30>
           translate <30, 0, -10>
           pigment {Green}
         }
         
         
         // create a box that extends between the 2 specified points
         box
         {
           <-3, -3, -1>  // one corner position <X1 Y1 Z1>
           < 1,  2,  1>  // other corner position <X2 Y2 Z2>
           scale <20, 6, 30>
           translate <30, 0, -10>
           pigment {Green}
           rotate <90, 0, 0>
         }
      }
   }  
   
   
//Create the monitor but then take away the base and backbit by using the difference function
#declare ControlPanelScreen2 = difference
   {  
      //Create monitor
      union
      {  
      	Monitor1(use_display) //Piccy resolution 861x620
      
      	translate <10*cm, 0, -20*cm>
      }

      //Combine the two boxes and then "take them away" from the monitor
      union {
         // create a box that extends between the 2 specified points
         box
         {
           <-3, -1, -1>  // one corner position <X1 Y1 Z1>
           < 1,  1.5,  1>  // other corner position <X2 Y2 Z2>
           scale <20, 6, 30>
           translate <30, 0, -10>
           pigment {Green}
         }
         
         
         // create a box that extends between the 2 specified points
         box
         {
           <-3, -3, -1>  // one corner position <X1 Y1 Z1>
           < 1,  2,  1>  // other corner position <X2 Y2 Z2>
           scale <20, 6, 30>
           translate <30, 0, -10>
           pigment {Green}
           rotate <90, 0, 0>
         }
      }
   }
   
      //Create the monitor but then take away the base and backbit by using the difference function
#declare ControlPanelScreen3 = difference
   {  
      //Create monitor
      union
      {  
      	Monitor2(use_display) //Piccy resolution 861x620
      
      	translate <10*cm, 0, -20*cm>
      }

      //Combine the two boxes and then "take them away" from the monitor
      union {
         // create a box that extends between the 2 specified points
         box
         {
           <-3, -1, -1>  // one corner position <X1 Y1 Z1>
           < 1,  1.5,  1>  // other corner position <X2 Y2 Z2>
           scale <20, 6, 30>
           translate <30, 0, -10>
           pigment {Green}
         }
         
         
         // create a box that extends between the 2 specified points
         box
         {
           <-3, -3, -1>  // one corner position <X1 Y1 Z1>
           < 1,  2,  1>  // other corner position <X2 Y2 Z2>
           scale <20, 6, 30>
           translate <30, 0, -10>
           pigment {Green}
           rotate <90, 0, 0>
         }
      }
   }   
   
#declare toppanel =
   // create a box that extends between the 2 specified points
   box
   {
     <-30, -1, -1>  // one corner position <X1 Y1 Z1>
     < 30,  1,  1>  // other corner position <X2 Y2 Z2>
     //pigment {Grey}
             texture {
              pigment { image_map { png "control_panel.png"} scale 3} 
               normal { bumps 0.1 }

               }        
     //finish { reflection 0.2 specular 0.2 }
     scale <5, 10, 5>
     translate <0, 90, 7>
     //rotate <-10, 0, 0>
     
   } 
   

#declare panel_for_monitors =
   // create a box that extends between the 2 specified points
   box
   {
     <-30, -1, -10>  // one corner position <X1 Y1 Z1>
     < 30,  1,  1>  // other corner position <X2 Y2 Z2>
     //texture {}
     //pigment {Grey}
          
               
     scale <4, 4, 4>
     translate <0, 0, 0>
     rotate <-90, 0, 0>
     
     
   }
   
   
#declare panel_for_monitors_texture =
object {panel_for_monitors
                   texture {
              pigment { image_map { png "control_panel.png"} scale 20} 
               //normal { bumps 0 }

               } 
       }
                       
 
 
#declare panel_for_keyboards =
   // create a box that extends between the 2 specified points
   box
   {
     <-30, -1, -10>  // one corner position <X1 Y1 Z1>
     < 30,  1,  1>  // other corner position <X2 Y2 Z2>
     pigment {Grey}
/*     
             texture {
              pigment { image_map { png "control_panel.png"} scale 3} 
               normal { bumps 0.1 }

               }     
*/               
     scale <4, 4, 4>
     translate <0, -30, -10>
     rotate <-10, 0, 0>
     
   }


#declare panel_for_keyboards_texture =
object {panel_for_keyboards
                   texture {
              pigment { image_map { png "control_panel.png"} scale 20} 
               //normal { bumps 0 }

               } 
       }



   
#declare controlpanel = 
union {                       
   object {panel_for_keyboards_texture}
   
   object {panel_for_monitors_texture
            rotate <20, 0, 0>
            }
   
   object {ControlPanelScreen3
           translate <60, -40, 14>
           rotate <17, 0, 0>
           scale <0.9, 0.9, 1>
         }          
   
   object {ControlPanelScreen2
           translate <-40, -40, 14>
           rotate <17, 0, 0>
           scale <0.9, 0.9, 1>
         }      
         
   object {ControlPanelScreen1
           translate <-90, -40, 14>
           rotate <17, 0, 0>
           scale <0.9, 0.9, 1>
         }      
         
         
   union
   {
   	Keyboard()
   
   	
   	translate <80, -26, -35>
   	rotate <-10, 0, 0>
   	scale <0.8, 1, 1>
   }
   
   
   union
   {
   	Keyboard()
   
   	
   	translate <-35, -26, -35>
   	rotate <-10, 0, 0>
   	scale <0.8, 1, 1>
   }
   
   union
   {
   	Keyboard()
   
   	
   	translate <-90, -26, -35>
   	rotate <-10, 0, 0>
   	scale <0.8, 1, 1>
   }
   
   #if (use_window)
      //Window of the laboratory
      box
      {
        <-1, -1, 0>  // one corner position <X1 Y1 Z1>
        < 1,  1,  1>  // other corner position <X2 Y2 Z2>
        pigment { White filter 1 }
        //pigment { Green }
        
          finish {
           ambient 0
           diffuse 0
           reflection .01
           specular 1
           roughness .009
          }
        scale <80, 20, 1.0>
        translate <0, 25, 0>    
      }    
   #end 
   
   // create a box that extends between the 2 specified points
   box
   {
     <-30, -1, -1>  // one corner position <X1 Y1 Z1>
     < 30,  1,  1>  // other corner position <X2 Y2 Z2>
     pigment {Grey}
     scale <5, 10, 5>
     translate <0, 90, 3>
     rotate <0, 0, 0>
     
   }
   
   object {toppanel
            rotate <-10, 0, 0>}
            
      text { ttf "lucon.ttf" "spacelab" 0.01, 0
      pigment { Yellow }                          
      finish { reflection 1 specular 0.5 }
          /*
      
      //scale <-1, -1, 0>
      translate -2.5*x
      translate 30*y
      translate -50*z
      //scale 0.9*y
      //scale 0.9*x
      scale 20*x
      //no_shadow
      rotate <30, 0, 20>
      
      */ 
      translate <-2, 10.5, 0.1>
      scale <15,8,5>
      rotate <-10, 0, 0>
    }             
/*   
   // create a box that extends between the 2 specified points
   box
   {
     <-30, -1, -1>  // one corner position <X1 Y1 Z1>
     < 30,  1,  1>  // other corner position <X2 Y2 Z2>
     //pigment {Grey}
     
             texture {
              pigment { image_map { png "control_panel.png"} scale 3} 
               normal { bumps 0.1 }

               }        
     scale <5, 10, 5>
     translate <0, 90, 7>
     rotate <-10, 0, 0>
     
   }          
*/   
}   
   


//object {controlpanel}


         


 