// Persistence of Vision Ray Tracer Scene Description File
// File: lightUtils.INC
// Vers: 3.1
// Desc: Definitions and macros for light sources including true area lights.
// Date Started: 7/31/98
// Auth: Chris Huff
//===============================================================
#ifndef (LIGHT_UTILS)// Start of inclusion guard
#declare LIGHT_UTILS = true;
#include "miscUtils.INC"
//****************************************
//****************************************
#declare stdLight = light_source {<-30, 45, -20>*100 color White}
//****************************************
//****************************************
#macro LightBall(centerOfBall, ballRadius, ballTex, lightColor)
//makes a sphere with a point light at the center
//hint:use a ballTex with highlights and a colored, filtering pigment
	union {
		sphere {centerOfBall, ballRadius texture{ ballTex}}
		light_source {centerOfBall color lightColor}
	}
#end
//****************************************
//****************************************
#macro LightString(stPt, endPt, numOfLights, lightColor)
		#local k=0;
	#while(k < numOfLights)
		#local propDone = k/numOfLights *(numOfLights/(numOfLights-1));//the proportion of the line done
		#local lightPos = LIntVal(stPt,endPt,propDone);
		light_source {lightPos color lightColor}
		#local k=k+1;
	#end
#end
//****************************************
//****************************************
#macro LightArray(pos, ptAt, xSize, zSize, xNum, zNum, lightColor)
//incomplete, ptAt not yet implemented
	#local k=0;
	#while(k < zNum)
		#local propColDone = k/zNum *(zNum/(zNum-1));
		#local lightZPos = LIntVal(-(zSize/2),(zSize/2),propColDone);
		#local j=0;
		#while(j < xNum)
			#local propRowDone = j/xNum *(xNum/(xNum-1));
			#local lightXPos = LIntVal(-(xSize/2),(xSize/2),propRowDone);
//			sphere {< lightXPos, 0, lightZPos>, 0.5 pigment{ color lightColor}
//				//rotate to point at ptAt
//				translate pos
//			}
			light_source {< lightXPos, 0, lightZPos> color lightColor
				//rotate to point at ptAt
				translate pos
			}
			#local j=j+1;
		#end//endwhile
		#local k=k+1;
	#end//endwhile
#end
//****************************************
//****************************************
#macro TrueAreaLight1(stPt, endPt, numOfLights, lightColor)
//use for cylinderical light sources, like flourescent lights
	LightString(stPt, endPt, numOfLights, lightColor/numOfLights)
#end
//****************************************
//****************************************
//custom versions of the above macros for use with specialized light_sources
//****************************************
#macro CustLightBall(centerOfBall, ballRadius, ballTex, light)
//makes a sphere with a customized light at the center
//hint:use a ballTex with highlights and a colored, filtering pigment
	union {
		sphere {centerOfBall, ballRadius texture{ ballTex}}
		light_source {light}
	}
#end
//****************************************
//****************************************



//===============================================================
#end// End of inclusion guard
