// Persistence of Vision Ray Tracer Scene Description File
// File: miscUtils.mac
// Vers: 3.1
// Desc: Miscellaneous macros, including math, looping, etc
// Date Started: 7/31/98
// Auth: Chris Huff
//===============================================================
#ifndef (MISC_UTILS)// Start of inclusion guard
#declare MISC_UTILS = true;
//****************************************
//****************************************
#declare origin = < 0,0,0>;//The center of the POV-Universe
//****************************************
//****************************************
#declare mirrorImage = //not a macro, but a transformation to create a mirror image of an object
transform {
	matrix <	1,0,0,
			0,0,1,
			0,1,0,
			0,0,0 >
}
//****************************************
//****************************************
#macro PropDone( currVal,endVal)
//designed for zero-based loops
//varies from 0 to 1 as loop completes
	(currVal/endVal / ((endVal-1)/endVal))
#end
//****************************************
//****************************************
#macro GetRandVect(randStream)
//returns a unit length vector pointing in a random direction
	vrotate(y, < 360*rand(randStream), 360*rand(randStream), 360*rand(randStream)>)
#end
//****************************************
//****************************************
//these macros are not implemented with pow() because
//doing it this way allows you to use vectors, colors, etc.
#macro CUBE(num)
	(num * num * num)
#end
#macro SQR(num)
	(num * num)
#end
//****************************************
//****************************************
#macro ODD(num)
(
	#if(mod(num, 2) > 0)
		true
	#else
		false
	#end
)
#end
#macro EVEN(num)
(
	#if(ODD(num) = false)
		true
	#else
		false
	#end
)
#end
//****************************************
//****************************************
//Macros for checking whether vectors are equal or unequal
#macro vEqual(vA, vB)
	((vA.x = vB.x)&(vA.y = vB.y)&(vA.z = vB.z))
#end
#macro vNEqual(vA, vB)
	((vA.x != vB.x)&(vA.y != vB.y)&(vA.z != vB.z))
#end
//****************************************
//****************************************
#macro Average(v1)//untested
//calculates the average of all values in array v1
//use like this:
//Average(array[3] {1, 2, 5})
	#local numOfVals = dimension_size(v1, 1);
	#local total=0;
	#local k=0;
	#while(k < numOfVals)
		#local total = total + v1[k];
		#local k=k+1;
	#end
	(total/numOfVals)
#end
//****************************************
//****************************************
#macro Average2(v1, v2)
//Averages two vectors, colors, floats...
	( (v1 + v2)/2 )
#end
//****************************************
//****************************************
#macro WeightedAverage(v1)//untested
//calculates the average of all values in array v1
//values are weighted by values in row of the array 2
	#local numOfVals = dimension_size(v1, 1);
	#local total=0;
	#local k=0;
	#while(k < numOfVals)
		#local total = total + (v1[0][k] * v1[1][k]);
		#local k=k+1;
	#end
	(total/numOfVals)
#end
//****************************************
//****************************************
#macro WeightedAverage2(v1, v2, w1)
//I don't know what exactly a "weighted average" is,
//but this makes one value "count" more than the other
	( (v1*w1) + (v2*(1-w1)) )
#end
//****************************************
//****************************************
#macro WeightedAverage2b(v1, v2, w1, w2)
//I don't know what exactly a "weighted average" is,
//but this makes one value "count" more than the other
	( (v1*w1) + (v2*w2) )
#end
//****************************************
//****************************************
#macro YReorient(newAxis)
//rotates an object so its y-axis points along newAxis
	#if(vNEqual(newAxis, < 0, 1, 0>))
		#local NY = vnormalize(newAxis);
		#local NX = vnormalize(vcross(NY,-y));
		#local NZ = vcross(NX,NY);
		matrix <	NX.x,NX.y,NX.z,
				NY.x,NY.y,NY.z,
				NZ.x,NZ.y,NZ.z,
				0, 0, 0 >
	#end
#end //YRotToAxis
//****************************************
//****************************************
#macro pmRand(randStream)
//returns a random value between -1 and 1
//otherwise used the same as rand()
	((rand(randStream)-0.5)*2)
#end //pmRand
//****************************************
//****************************************
#macro VectRotate(ptToRot,ptToRotAround,amountToRot)
//rotates ptToRot around ptToRotAround by amountToRot
	(ptToRotAround + vrotate((ptToRot-ptToRotAround),amountToRot))
#end //VectRotate
//****************************************
//****************************************
#macro delimitStr(sourceString)
//creates a quote-delimited string
	#local delimiter = "\""
	concat(delimiter,sourceString,delimiter)
#end //delimitStr
//****************************************
//****************************************
#macro vectToStr(vect, minLen, numOfDigits)
	//converts from a vector to a string
	#local xVal = vect.x;
	#local yVal = vect.y;
	#local zVal = vect.z;
	concat("< ", str(xVal, minLen, numOfDigits), ", ", str(yVal, minLen, numOfDigits), ", ", str(zVal, minLen, numOfDigits), ">")
#end //vectToStr
//****************************************
//****************************************
#macro LIntVal(valA,valB,dist)
//perform a linear interpolation of a value(can be vector, float, color...)
//	(valA + ((valB-valA) * dist))//This one I developed myself, apparently doesn't work right
	(valA * (1-dist) + valB * dist)//I have also seen this one
#end //LIntVal
//****************************************
//****************************************
#macro CosinIntVal(valA,valB,dist)//Thanks to http://freespace.virgin.net/hugo.elias
//perform a cosine interpolation of a float
	#local ft = dist*pi;
	#local f = (1 - cos(ft)) * 0.5;
	(valA * (1 - f) + valB*f)
#end //CosinIntVal
//****************************************
//****************************************
#macro CubicIntVal(cp1,p1,p2,cp2,dist)//Thanks to http://freespace.virgin.net/hugo.elias
//perform a cubic interpolation of a float
	#local P = (cp2 - p2) - (cp1 - p1);
	#local Q = (cp1 - p1) - P;
	#local R = p2 - cp1;
	#local S = p1;
	(P * CUBE(dist) + Q * SQR(dist) + R * dist + S)
#end //CubicIntVal
//****************************************
//****************************************
#macro MidPtOfLine(stPt, endPt)
//returns the midpoint of a line from stPt to endPt
	(((endPt - stPt)*0.5) + stPt)
#end
//****************************************
//****************************************
//===============================================================
#end// End of inclusion guard
