//
//             N K F l a r e . I N C
//   ------------------------------------------
//
//      Lens Flare "plug-in" for POV-RAY 3.1
//
//    Copyright (C) 1997-1998      Nathan Kopp
//
//    Version 5.0                October, 1998
//
//   ------------------------------------------
//
//  THIS SOFTWARE IS CURRENTLY IN BETA-TESTING STAGES.
//
//    Documentation for NKFlare is in the file
//    NKFlare.TXT.  NKFlare.TXT must accompany
//    NKFlare.INC in all distributions.
//
// NKFlare is a very flexible lens flare include file for POV-Ray 3.1.
//
// Adding lens flare to your POV scene is now a simple as adding the
// following few lines to your scene description file:
//
//  #declare cam_loc = <x,y,z>    // use the x, y, and z of your camera
//  #declare light_loc = <x,y,z>  // use the x, y, and z of the light
//                                // you wish to flare
//  #declare lookat = <x,y,z>     // the look_at vector of your camera
//  #declare sky_vect = <x,y,z>   // the sky vector of your camera
//  #include "35mm.flr"           // or whatever pre-defined flare you like
//  #include "NKFlare.inc"        // create the lens flare
//
//   ------------------------------------------

#local crisps = 0;
#local sspread = 1;
#local smirror = 2;
#local ssize = 3;
#local sarms = 4;
#local swidth = 5;
#local srand = 6;
#local ssrand = 7;
#local sseed = 8;
#local srot = 9;

#local dnum = 0;
#local dskip = 1;
#local dopp = 2;
#local ddist = 3;
#local ddistpwr = 4;
#local doffset = 5;
#local drnd = 6;
#local dsize = 7;
#local dsizernd = 8;
#local dseed = 9;

//#version -1.0;

#declare lf_Clear = rgbt<0,0,0,.5>;

//#macro NKFlare (light_loc, cam_loc, lookat, sky_vect)

// if they defined "flare_type" and it is not blank, then
// use it for the include filename
//
#ifdef (flare_type)
  #if (strlen(flare_type)>0)
    #if (strcmp(flare_type, "camcorder")=0)
      #include "camcordr.flr"
    #else #if (strcmp(flare_type, "smallstar")=0)
      #include "smlstar.flr"
    #else #if (strcmp(flare_type, "warpflare")=0)
      #include "warp.flr"
    #else
      #declare filename = concat(flare_type,".flr")
      #if (file_exists(filename))
        #include filename
      #else
        #debug concat("Could not find the file: ",filename)
        #debug "\n"
      #end
    #end #end #end
  #end
#end

// *****************************************************************
// ** Additional rotation degrees.
//
#ifndef (flare_rotate) #declare flare_rotate = 0; #end
#ifndef (flare_auto_rotate) #declare flare_auto_rotate = false; #end
#ifndef (spots_auto_rotate) #declare spots_auto_rotate = false; #end
#ifndef (disc_size) #declare disc_size = .001; #end
#ifndef (flare_size) #declare flare_size = <1,1,1>; #end
#ifndef (AmbientLight) #declare AmbientLight = <1,1,1>; #end

// *****************************************************************
// ************ DECLARE TRANSFORM VARIABLES ********************
// *****************************************************************

// *****************************************************************
// ** compute relative location of camera to light source
// ** compute relative location of camera to center
// *****************************************************************
#local lf_2light = cam_loc - light_loc;
#local lf_2ctr = cam_loc - lookat;

// Now project lf_2light onto lf_2ctr to find new lf_2ctr vector.  This gives us
// a vector from cam_loc to lf_2ctr that is perpendecular to the relative
// lookat vector.  The newctr vector is used in for multiple flare
// spot calculation.
#local lf_newctr = lf_2ctr * vdot(lf_2light,lf_2ctr) / (vlength(lf_2ctr)*vlength(lf_2ctr));

// *****************************************************************
// ** compute rotation values for x and z axes
// *****************************************************************

// matrix concept by John VanSickle <vansickl@erols.kosher.com>
             
#local CamD = vnormalize(lookat-cam_loc);
#local CamR = vnormalize(vcross(sky_vect,CamD));
#local CamU = vnormalize(vcross(CamD,CamR));

#local CamRc = vnormalize(vcross(lf_2light,CamD));
#local CamUc = vnormalize(vcross(CamD,CamRc));

/*
cylinder
{
//  <0,0,0>, CamU, .1
  <0,0,0>,<0,1,0> .1


      matrix < CamRc.x,CamRc.y,CamRc.z,
               CamUc.x,CamUc.y,CamUc.z,
               CamD.x,CamD.y,CamD.z,   // maybe 0,0,0 (but then no inverse)
               0,0,0 >  // no translate
  
  scale .1
  translate cam_loc+.5*CamD
  pigment{rgb<1,0,0>}
  finish{ambient 1}
}
*/
                                      
// *****************************************************************
// ** set up lf_StarTex for the sparkle textures
// *****************************************************************

#local lf_StarTex=array[dimension_size(lf_spk_info,1)]

#local i=0;
#ifdef (lf_spk_info)
#while(i<dimension_size(lf_spk_info,1))

  #local star_seed = seed(lf_spk_info[i][sseed]);

  #local lf_temp_tr = 0.0;
  #if (lf_spk_info[i][crisps] = true) #local lf_temp_tr = 1.0; #end

  #if (lf_spk_info[i][sarms] > 0)
    #local lf_StarTex[i] = pigment {
    radial

    #if (lf_spk_info[i][smirror] = true)
      frequency 2
      #local lf_tmp_width = lf_spk_info[i][swidth] / lf_spk_info[i][sarms] * 2;
      #local lf_ave_dist  = 1 / lf_spk_info[i][sarms] * 2;
    #else
      frequency 1
      #local lf_tmp_width = lf_spk_info[i][swidth] / lf_spk_info[i][sarms];
      #local lf_ave_dist  = 1 / lf_spk_info[i][sarms];
    #end
  
    #local lf_loc = 0;

    color_map{
      [0.0          color lf_spk_vect[i][0] transmit .5]
      [lf_tmp_width color lf_spk_vect[i][0]*lf_temp_tr transmit .5]
      [lf_tmp_width color lf_Clear              ]

      #local lf_loc = lf_loc +  lf_ave_dist + (rand(star_seed)*2 - 1)*lf_spk_info[i][srand]*(lf_ave_dist-2*lf_tmp_width);
      #while (lf_loc <(1-2*lf_tmp_width))
        #local lf_s_color = lf_spk_vect[i][0] + lf_spk_vect[i][1] * <(rand(star_seed) * 2 - 1),(rand(star_seed) * 2 - 1),(rand(star_seed) * 2 - 1)>;
      
        [lf_loc - lf_tmp_width  color lf_Clear ]
        [lf_loc - lf_tmp_width  color lf_s_color*lf_temp_tr transmit .5]
        [lf_loc                 color lf_s_color            transmit .5]
        [lf_loc + lf_tmp_width  color lf_s_color*lf_temp_tr transmit .5]
        [lf_loc + lf_tmp_width  color lf_Clear ]
      
        #declare lf_loc = lf_loc +  lf_ave_dist + (rand(star_seed)*2 - 1)*lf_spk_info[i][srand]*(lf_ave_dist-2*lf_tmp_width);
      #end

      [1-lf_tmp_width color lf_Clear ]
      [1-lf_tmp_width color lf_spk_vect[i][0]*lf_temp_tr transmit .5]
      [1.0            color lf_spk_vect[i][0]            transmit .5]
    }

   rotate <90,0,-90>
  }
  #end

  #local i = i+1;
#end
#end  

#local lf_Finish = finish {
  //#version -3.1;
  refraction 2.0
  //#version 3.1;

  specular 0
  phong 0
  diffuse 0.0
  reflection 0.0

  #declare lf_bright = <1,1,1>;
  #ifdef (AmbientLight)
      #declare lf_bright = lf_bright /  AmbientLight;
  #end
  #ifdef (flare_brightness)
    #declare lf_bright = lf_bright * flare_brightness;
  #end
  #ifdef (bright_background) #if (bright_background)
    #declare lf_bright = lf_bright * 0.3;
  #end #end

  ambient lf_bright*2
}

// *****************************************************************
// ** First, make sure the camera is in front of the camera by
//    checking the plane with normal from cam_loc to lookat.
//
//  Plane equation:   a(x-x0) + b(y-y0) + c(z-z0) = 0
//
// *****************************************************************
#local cam_plane = 1 * vdot(lf_2ctr, lf_2light);

#if (cam_plane < 0)
  #warning "Light is behind camera or behind the planet.  Lens flare not created."
  // *****************************************************************
  // Skip lens flare completely... can have an impact on
  // render speed.
  // *****************************************************************
#else

// *****************************************************************
// ********** THE ACTUAL DISCS FOR LENS FLARE **********************
// *****************************************************************

#ifndef (lf_flares_drawn) #declare lf_flares_drawn = 0; #end

// *****************************************************************
// **********           glows                 **********************
#local i = 0;
#while(i<dimension_size(lf_glows,1))

  #declare lf_new_disc_size = disc_size + .001 * lf_flares_drawn;
  
  disc {
    <0,0,0>, z, 1/2

    texture {
      // ***************** Primary flare ********************
      pigment { lf_glows[i] }
      finish { lf_Finish }
    }
    scale lf_glow_sca[i] * lf_new_disc_size * flare_size

    #local lf_2spot = lf_2light + (lf_newctr - lf_2light) * lf_glow_dst[i];

    #if (lf_glow_rot[i] >= 1000)
      rotate (lf_glow_rot[i] - 1000)*z
      matrix < CamRc.x,CamRc.y,CamRc.z,
               CamUc.x,CamUc.y,CamUc.z,
               CamD.x,CamD.y,CamD.z,   // maybe 0,0,0 (but then no inverse)
               0,0,0 >  // no translate
    #else
      rotate lf_glow_rot[i]*z
      matrix < CamR.x,CamR.y,CamR.z,
               CamU.x,CamU.y,CamU.z,
               CamD.x,CamD.y,CamD.z,   // maybe 0,0,0 (but then no inverse)
               0,0,0 >  // no translate
    #end

    #local lf_dist = 1/( vdot(lf_2spot,lf_2ctr)/(vlength(lf_2ctr)*vlength(lf_2spot)) );
    translate cam_loc + lf_new_disc_size * vnormalize(-lf_2spot)*lf_dist
    no_shadow hollow
  }
  #declare lf_flares_drawn = lf_flares_drawn + 1;
  #local i = i+1;
#end


// *****************************************************************
// **********           sparkles              **********************
#ifdef (lf_spk_info)

#local i = 0;
#while (i<dimension_size(lf_spk_info, 1))

#if (lf_spk_info[i][sspread])
  
    #local lf_new_disc_size = disc_size + .001 * lf_flares_drawn;
    disc {
      <0,0,0>, z, lf_spk_info[i][ssize]*3/2

      texture {
      // ************** Star-type flare *********************
      pigment {
        wood scallop_wave
        pigment_map {
          [ 0.0                        lf_StarTex[i]]
          [ lf_spk_info[i][ssize]      lf_StarTex[i]]
          [ lf_spk_info[i][ssize] * 3  lf_Clear  ]
          [ 1                          lf_Clear  ]
        }
      }
      finish { lf_Finish }
      }
      
      scale lf_spk_vect[i][2] * lf_new_disc_size * flare_size

    #if (lf_spk_info[i][srot] >= 1000)
      rotate (lf_spk_info[i][srot] - 1000)*z
      matrix < CamRc.x,CamRc.y,CamRc.z,
               CamUc.x,CamUc.y,CamUc.z,
               CamD.x,CamD.y,CamD.z,   // maybe 0,0,0 (but then no inverse)
               0,0,0 >  // no translate
    #else
      rotate lf_spk_info[i][srot]*z
      matrix < CamR.x,CamR.y,CamR.z,
               CamU.x,CamU.y,CamU.z,
               CamD.x,CamD.y,CamD.z,   // maybe 0,0,0 (but then no inverse)
               0,0,0 >  // no translate
    #end
    
      #local lf_dist = 1/( vdot(lf_2light,lf_2ctr)/(vlength(lf_2ctr)*vlength(lf_2light)) );
      translate cam_loc + lf_new_disc_size * vnormalize(-lf_2light)*lf_dist
      no_shadow hollow
    }
    #declare lf_flares_drawn = lf_flares_drawn + 1;
#else // star_spread
  // **************************************
  // Create a bunch of streaks to simulate
  // the sparkle pattern
  //

  #ifdef(lf_clock)
    #local star_seed1 = seed(lf_spk_info[i][sseed]+floor(lf_clock));
    #local star_seed2 = seed(lf_spk_info[i][sseed]+floor(lf_clock)+1);
  #end
    
  #local star_seed = seed(lf_spk_info[i][sseed]);

  #if (lf_spk_info[i][smirror])
    #local lf_num = lf_spk_info[i][sarms] / 2;
  #else
    #local lf_num = lf_spk_info[i][sarms];
  #end
  
  #declare lf_tmp_width = lf_spk_info[i][swidth] / lf_spk_info[i][sarms] * .25;
  #declare lf_ave_ang  = 360 / lf_spk_info[i][sarms];

  #while (lf_num > 0)

    #ifdef(lf_clock)
      #local lf_tmp_size1 = lf_spk_info[i][ssize] + (rand(star_seed1) * 2 - 1) * lf_spk_info[i][ssrand]*lf_spk_info[i][ssize];
      #local lf_tmp_size2 = lf_spk_info[i][ssize] + (rand(star_seed2) * 2 - 1) * lf_spk_info[i][ssrand]*lf_spk_info[i][ssize];
      #local lf_tmp_size = lf_tmp_size2*(lf_clock-floor(lf_clock))+lf_tmp_size1*(1-(lf_clock-floor(lf_clock)));
    #else
      #local lf_tmp_size = lf_spk_info[i][ssize] + (rand(star_seed) * 2 - 1) * lf_spk_info[i][ssrand]*lf_spk_info[i][ssize];
    #end

    #declare lf_tmp_ang  = lf_num * lf_ave_ang + (rand(star_seed) * 2 - 1) * lf_spk_info[i][srand] * lf_ave_ang;
    #declare lf_s_color = lf_spk_vect[i][0] + lf_spk_vect[i][1] * <(rand(star_seed) * 2 - 1),(rand(star_seed) * 2 - 1),(rand(star_seed) * 2 - 1)>;

    #declare lf_new_disc_size = disc_size + .001 * lf_flares_drawn;
    disc {
      <0,0,0>, z, 1
      texture {
        pigment {
          wood
          ramp_wave
          color_map{
            [0.0 color lf_s_color transmit .5]
            #if (lf_spk_info[i][crisps]=true)
              [1.0 color lf_s_color transmit .5]
            #else
              [1.0 color lf_Clear]
            #end
          }
        }
        finish { lf_Finish }
      }
      
      scale <lf_tmp_size,lf_tmp_width,1> * lf_new_disc_size*.9
        scale <.5,1,1>
        translate <.5,0,0>*lf_tmp_size* lf_new_disc_size.x// * flare_size.x

    rotate (lf_tmp_ang)*z
    scale lf_spk_vect[i][2] * flare_size

    #if (lf_spk_info[i][srot] >= 1000)
      rotate (lf_spk_info[i][srot] - 1000)*z
      matrix < CamRc.x,CamRc.y,CamRc.z,
               CamUc.x,CamUc.y,CamUc.z,
               CamD.x,CamD.y,CamD.z,   // maybe 0,0,0 (but then no inverse)
               0,0,0 >  // no translate
    #else
      rotate lf_spk_info[i][srot]*z
      matrix < CamR.x,CamR.y,CamR.z,
               CamU.x,CamU.y,CamU.z,
               CamD.x,CamD.y,CamD.z,   // maybe 0,0,0 (but then no inverse)
               0,0,0 >  // no translate
    #end

      #local lf_dist = 1/( vdot(lf_2light,lf_2ctr)/(vlength(lf_2ctr)*vlength(lf_2light)) );
      translate cam_loc + lf_new_disc_size * vnormalize(-lf_2light)*lf_dist
      no_shadow hollow
    }
    #declare lf_flares_drawn = lf_flares_drawn + 1;
        
    // make another copy if mirror is turned on.
    #if (lf_spk_info[i][smirror]=true)
    #declare lf_new_disc_size = disc_size + .001 * lf_flares_drawn;
    disc {
      <0,0,0>, z, 1
      texture {
        pigment {
          wood
          ramp_wave
          color_map{
            [0.0 color lf_s_color transmit .5]
            #if (lf_spk_info[i][crisps]=true)
              [1.0 color lf_s_color transmit .5]
            #else
              [1.0 color lf_Clear]
            #end
          }
        }
        finish { lf_Finish }
      }
      
      scale <lf_tmp_size,lf_tmp_width,1> * lf_new_disc_size*.9
      scale <.5,1,1>
      translate <-.5,0,0>*lf_tmp_size* lf_new_disc_size.x //* flare_size.x

    rotate (lf_tmp_ang)*z
    scale lf_spk_vect[i][2] * flare_size

    #if (lf_spk_info[i][srot] >= 1000)
      rotate (lf_spk_info[i][srot] - 1000)*z
      matrix < CamRc.x,CamRc.y,CamRc.z,
               CamUc.x,CamUc.y,CamUc.z,
               CamD.x,CamD.y,CamD.z,   // maybe 0,0,0 (but then no inverse)
               0,0,0 >  // no translate
    #else
      rotate lf_spk_info[i][srot]*z
      matrix < CamR.x,CamR.y,CamR.z,
               CamU.x,CamU.y,CamU.z,
               CamD.x,CamD.y,CamD.z,   // maybe 0,0,0 (but then no inverse)
               0,0,0 >  // no translate
    #end

      #local lf_dist = 1/( vdot(lf_2light,lf_2ctr)/(vlength(lf_2ctr)*vlength(lf_2light)) );
      translate cam_loc + lf_new_disc_size * vnormalize(-lf_2light)*lf_dist
      no_shadow hollow
    }
    #declare lf_flares_drawn = lf_flares_drawn + 1;
    #end

    #local lf_num = lf_num - 1;
  #end
#end // star_spread

#local i = i+1;

#end // while
#end

//  *********************************************************************
//  *********************  Multiple lens flare spots ********************
//  *********************************************************************

#ifdef (lf_spot_types)

#local i = 0;
#while(i<dimension_size(lf_spot_types,1))
#local spot_seed = seed(lf_spot_info[i][dseed]);

// *****************************************************************
// ** randoms are relative to their respective variables
// *****************************************************************
#local s_dist_rand = lf_spot_info[i][drnd]; //* lf_spot_info[i][ddist]*10;
#local s_size_rand = lf_spot_info[i][dsizernd]; //* lf_spot_info[i][dsize]*10;


#local lf_cur_spot = lf_spot_info[i][dskip]+1;
#while ((lf_cur_spot <= lf_spot_info[i][dnum]+lf_spot_info[i][dskip]) | (lf_cur_spot <= lf_spot_info[i][dopp]+lf_spot_info[i][dskip]))
  #local lf_side = 0;
  #while (lf_side <= 1)
    #switch(lf_side)
      #case (0) #local lf_xspot = lf_spot_info[i][dnum]+lf_spot_info[i][dskip]; #break
      #case (1) #local lf_xspot = lf_spot_info[i][dopp]+lf_spot_info[i][dskip]; #break
    #end
  
    #if (lf_cur_spot <= lf_xspot)
    // *****************************************************************
    // ** randomly shift various attributes
    // *****************************************************************
    #local lf_s_size  = lf_spot_info[i][dsize] + (rand(spot_seed) * 2 - 1) * s_size_rand;
    #local lf_s_dist  = (rand(spot_seed) * 2 - 1); // * s_dist_rand;
    #local lf_s_color = lf_spot_vect[i][0] + lf_spot_vect[i][1] * <(rand(spot_seed) * 2 - 1),(rand(spot_seed) * 2 - 1),(rand(spot_seed) * 2 - 1)>;
    #local lf_d_size  = lf_s_size;
    #local lf_d_color = lf_s_color;

    #local lf_pentagon = false;

    #if(strcmp(lf_spot_types[i],"dot")=0)
      #local lf_SpotPigment = pigment {
        wood
        #local tmp_tr = 1.0; //-spot_fade_amount*(lf_spot_info[i][dnum] - lf_spot_info[i][dskip]);
        color_map {
           [ 0.0              color lf_d_color*tmp_tr*1.2     transmit .5 ]
           [ lf_d_size / 1.2  color lf_d_color*tmp_tr*.53 transmit .5 ]
           [ lf_d_size        color lf_Clear  ]
           [ 1                color lf_Clear  ]
        }
      }
      #local lf_bound_y = lf_d_size/2;
    #end

    #if(strcmp(lf_spot_types[i],"hex")=0)
      #local tmp_tr = 1.0; //-spot_fade_amount*(lf_spot_info[i][dnum] - lf_spot_info[i][dskip]);
      #local lf_hex_pig = pigment {hexagon lf_s_color*tmp_tr transmit .5,lf_Clear,lf_Clear rotate 90*x scale .45}
      #local lf_SpotPigment = pigment{ wood scallop_wave pigment_map {
           [0.0  lf_hex_pig]
           [0.95 lf_hex_pig]
           [1.0  lf_Clear  ] }
           scale lf_s_size*1.2
           }
      #local lf_bound_y = lf_s_size/2;
    #end

    #if(strcmp(lf_spot_types[i],"pent")=0)
      #local lf_pentagon = true;
      #local tmp_tr = 1.0; //-spot_fade_amount*(lf_spot_info[i][dnum] - lf_spot_info[i][dskip]);
      #declare lf_SpotPigment = pigment{ wood scallop_wave color_map{
         [0.0  color lf_s_color*tmp_tr transmit .5]
         [0.95 color lf_s_color*tmp_tr transmit .5]
         [1.0  color lf_s_color*tmp_tr*.5 transmit .5] }
         scale 1.05*lf_s_size
         }
      #local lf_bound_y = lf_s_size/2;
    #end

    #if(strcmp(lf_spot_types[i],"spot")=0)
      #declare lf_SpotPigment = pigment {
        wood
        #local tmp_tr = 1.0; //-spot_fade_amount*(lf_spot_info[i][dnum] - lf_spot_info[i][dskip]);
        color_map {
           [ 0.0                       lf_Clear ]
           [ lf_s_size / 1.8           color lf_s_color*tmp_tr*.53 transmit .5 ]
           [ lf_s_size                 color lf_s_color*tmp_tr     transmit .5 ]
           [ lf_s_size +.1 * lf_s_size lf_Clear ]
           [ 1                         lf_Clear ]
        }
      }
      #local lf_bound_y = lf_s_size*1.1/2;
    #end

    #local lf_new_disc_size = disc_size + .001 * lf_flares_drawn;

    #if (lf_pentagon=false)
    disc {
      <0,0,0>, z, lf_bound_y
    #else
    polygon {
      6,
      <0,-1>
      < cos(radians(18)),-sin(radians(18))>, < cos(radians(54)), sin(radians(54))>,
      <-cos(radians(54)), sin(radians(54))>, <-cos(radians(18)),-sin(radians(18))>,
      <0,-1>
      scale lf_s_size*.5
    #end            
      texture { pigment { lf_SpotPigment } finish { lf_Finish } }

      // *****************************************************************
      // ** calculate the apparant position of the flare spot
      // *****************************************************************
      #switch(lf_side)
      #case(0)
        #local lf_2spot = lf_2light + (lf_newctr - lf_2light) * ((lf_spot_info[i][ddist]) * pow(lf_cur_spot+lf_spot_info[i][doffset]+lf_s_dist, lf_spot_info[i][ddistpwr]));
      #break #case (1)
        #local lf_2spot = lf_2light - (lf_newctr - lf_2light) * ((lf_spot_info[i][ddist]) * pow(lf_cur_spot+lf_spot_info[i][doffset]+lf_s_dist, lf_spot_info[i][ddistpwr]));
                                    //(lf_newctr - lf_2light) * (lf_spot_info[i][ddist] * pow(lf_cur_spot, lf_spot_info[i][ddistpwr]) + lf_s_dist);
      #end

      scale lf_new_disc_size * flare_size

      matrix < CamRc.x,CamRc.y,CamRc.z,
               CamUc.x,CamUc.y,CamUc.z,
               CamD.x,CamD.y,CamD.z,   // maybe 0,0,0 (but then no inverse)
               0,0,0 >  // no translate

      #local lf_dist = 1/( vdot(lf_2spot,lf_2ctr)/(vlength(lf_2ctr)*vlength(lf_2spot)) );
      translate cam_loc + lf_new_disc_size * vnormalize(-lf_2spot)*lf_dist
      no_shadow hollow
    }
    #declare lf_flares_drawn = lf_flares_drawn + 1;

    #end // if
    #local lf_side=lf_side+1;
  #end  // while side

  #local lf_cur_spot = lf_cur_spot + 1;
#end  // while lf_cur_spot

#local i = i+1;

#end // while loop for different spots


#end // ifdef(lf_spot_types)

#end  // if light was behind camera, lens flare was skipped.

//#end // of macro
