
    #include "kolors.inc"
    #include "metals.inc"
    #include "rmpgasflame.pov"
    #include "stones1.inc"

    
  #declare RocketFlame = 1;
    
  background{Black}
  camera {
    angle 30
    //location <2, 10, -30>
    
    //location <2, 0, -100> //slightly back up and above
    //location <0, 150, -5>       look_at <0, 1, 5>       // Looking directly down
    //location <0, 200, -5>       look_at <0, 1, 5>       // Looking directly down - but higher up
    //location <20, 10, -150>       look_at <10, 1, 5>       // Looking at the left side of the ship
    //location <-100, 0, 5>     look_at <0, 1, 5>       // Looking at the front of the ship
    //location <-200, 0, 5>     look_at <0, 1, 5>       // Looking at the front of the ship - but further away
    location <-80, 60, -60>   look_at <0, 5, -5>      //Normal view
    //look_at <0, 1, 5>
  }
  light_source { <20, 100, -20> color White }  
  light_source { <-200, 100, 0> color White }    
  

#declare front_tubes = union
{
         cylinder
         {
          -15*x,  10*x,  1
          //pigment {Grey}
          // open
         }

         cylinder
         {
           -15*x,  10*x,  1
           //pigment {Grey}
           // open
           translate <0, 0, 10>
         }
   //rotate <90, 0, 0>         
} 
 
//-----------------------------------------------------
// Main wing
#declare mainwing =
        object {         
                  cylinder {
                    <0, 0, 0>,     // Center of one end
                    <0, 0, 5>,     // Center of other end
                    2            // Radius
                               // Remove end caps
                    //pigment {Grey}
                    translate <7.5, 0, -2>
                    scale <2.0, 0.3, 10> 
                    //texture { T_Stone25 scale 4 }
                    rotate <90, 0, 0>
                  }       
               }
//------------------------------------------------------               
           
//-----------------------------------------------------               
// Create a wing-strengther
#declare wingattachment = object {
        box
        {
          <12, 3.0, 11>  // one corner position <X1 Y1 Z1>
          <17,  3.3, 19>  // other corner position <X2 Y2 Z2>
          //pigment {Grey}
          rotate <17, 0, 0>
          translate <0, 2.5, 0>
             texture {
              pigment { image_map { png "hull_stripe.png"} rotate <0, 90, 0> scale 5} 
               normal { bumps 0.1 }

               }             
          
        }           
}
//-----------------------------------------------------                  
               
       
  #declare Egg = union { // Egg1
    bicubic_patch {
      type 1 flatness 0.0100 u_steps 4 v_steps 4,
      <2.023314, 0.000000, 4.355987>,
      <2.023314, -0.000726, 4.355987>,
      <2.023312, -0.000726, 4.356867>,
      <2.023312, 0.000000, 4.356867>,
      <2.032037, 0.000000, 2.734598>,
      <2.032037, -1.758562, 2.734598>,
      <2.027431, -1.758562, 6.141971>,
      <2.027431, 0.000000, 6.141971>,
      <-1.045672, 0.000000, 3.281572>,
      <-1.045672, -1.758562, 3.281572>,
      <-1.050279, -1.758562, 5.414183>,
      <-1.050279, 0.000000, 5.414183>,
      <-1.044333, 0.000000, 4.341816>,
      <-1.044333, -0.002947, 4.341816>,
      <-1.044341, -0.002947, 4.345389>,
      <-1.044341, 0.000000, 4.345389>
    }
    bicubic_patch {
      type 1 flatness 0.0100 u_steps 4 v_steps 4,
      <2.023312, 0.000000, 4.356867>,
      <2.023312, 0.000726, 4.356867>,
      <2.023314, 0.000726, 4.355987>,
      <2.023314, 0.000000, 4.355987>,
      <2.027431, 0.000000, 6.141971>,
      <2.027431, 1.758562, 6.141971>,
      <2.032037, 1.758562, 2.734598>,
      <2.032037, 0.000000, 2.734598>,
      <-1.050279, 0.000000, 5.414183>,
      <-1.050279, 1.758562, 5.414183>,
      <-1.045672, 1.758562, 3.281572>,
      <-1.045672, 0.000000, 3.281572>,
      <-1.044341, 0.000000, 4.345389>,
      <-1.044341, 0.002947, 4.345389>,
      <-1.044333, 0.002947, 4.341816>,
      <-1.044333, 0.000000, 4.341816>
    }      
             
    //pigment { Grey }
    //translate <0.5, 0, -5>  // centers the egg around the origin
    //rotate <0, 180, 0>            
   }                      

#declare main_body = 

  object { Egg 
           //rotate <0, 180, 0>
           scale <6, 4, 8>
           translate <10, 0, -30>
           //translate <0, 0, 0>
          }         

           
/*           
// create a box that extends between the 2 specified points
box
{
  <11, -0.5, -18>  // one corner position <X1 Y1 Z1>
  <18,  0.5,  25>  // other corner position <X2 Y2 Z2>
  pigment {Green}
  translate <0, 0, 1>
}
*/   

                            
               
               
  #declare TeePeeTex = texture {
    pigment {
      color rgb <1, 1, 1,>
    }
    finish {
      ambient .2
      diffuse .6
    }
  }                
                
#declare TeePee = bicubic_patch {
    type 1 flatness 0.0100 u_steps 3 v_steps 3,
    <-5.174134, 5.528420, -13.211995>,
    <-1.769023, 5.528420, 0.000000>,
    <1.636088, 5.528420, 0.000000>,
    <5.041199, 5.528420, -13.003932>,
    <-5.174134, 1.862827, 0.000000>,
    <0.038471, 0.031270, 18.101474>,
    <0.036657, 0.031270, 18.101474>,
    <5.041199, 1.862827, 0.000000>,
    <-5.174134, -1.802766, 0.000000>,
    <0.038471, 0.028792, 18.101474>,
    <0.036657, 0.028792, 18.101474>,
    <5.041199, -1.802766, 0.000000>,
    <-5.174134, -5.468359, -13.070366>,
    <-1.769023, -5.468359, 0.000000>,
    <1.636088, -5.468359, 0.000000>,
    <4.974128, -5.468359, -12.801446>
    //texture {
    //  TeePeeTex
    // }
     rotate -90*x // to orient the object to LHC
     rotate 25*y  // to see the four "legs" better
  }      
  
  #declare rocket_booster = difference
        {
          object { TeePee
                    texture {T_Silver_1A} 
                    translate <0, 0, -10>
                    scale <1, 2, 1>
                    rotate <0, 0, 90> }
            
        // create a box that extends between the 2 specified points
          box
          {
            <-1, -1, -1>  // one corner position <X1 Y1 Z1>
            < 7,  1,  1>  // other corner position <X2 Y2 Z2>
            pigment {Green}
            translate <1, 0, -1>
            scale <7, 7, 9>
          }
       }
       
      
//Put the ship together from component parts
#declare traveller = union
{
   object {front_tubes
              texture {
                 pigment { image_map { png "hulls2.png"} scale 5} 
                  normal { bumps 0.1 }
                  //bump_map { png "hull1.png"} bump_size 0.5}
                  }                              
           } 
   
   object {mainwing
                texture {
                 pigment { image_map { png "hulls2.png"} scale 10} 
                  normal { bumps 0.1 }
                  //bump_map { png "hull1.png"} bump_size 0.5}
                  }                              
           rotate <-90, 0, 0>               
   }
   
   
   object {main_body
                   texture {
                 pigment { image_map { png "hulls2.png"} scale 10} 
                  normal { bumps 0.1 }
                  //bump_map { png "hull1.png"} bump_size 0.5}
                  } }              
         
         
   object {
           wingattachment
           }
           
   object {
           wingattachment          
           rotate <-34, 0, 0>
           translate <0, -8, -16>
           }
   

      object {rocket_booster
              translate <30, 0, 15>
              //scale <1, 1, 1>
             }        

         
              
   // create a box that extends between the 2 specified points
   box
   {
     <-2, -0.5, -0>  // one corner position <X1 Y1 Z1>
     < 2,  0.5,  10>  // other corner position <X2 Y2 Z2>
       texture {
        pigment { image_map { png "hull_stripe.png"} rotate <0, 90, 0> scale 5} 
         normal { bumps 0.1 }

         }   
   }        
   

      object {rocket_booster
              scale <0.5, 0.5, 0.5>
              texture {T_Silver_1A}
              translate <19, 0, -16>
              }
              
      #if (RocketFlame)   
         object {rocket_flame
              scale <1, 1, 1>
              rotate <0, 0, -90>
              translate <19, 0, -21.5>
              }
      #end              
              
      object {rocket_booster
              scale <0.5, 0.5, 0.5>
              texture {T_Silver_1A}
              translate <19, 0, 36>
              }
              
      #if (RocketFlame)   
         object {rocket_flame
              scale <1, 1, 1>
              rotate <0, 0, -90>
              translate <19, 0, 31.5>
              }
      #end   
              

   
   #if (RocketFlame)   
      object {rocket_flame
           scale <2, 2, 2>
           rotate <0, 0, -90>
           translate <30, 0, 5>
           }
   #end
   
   object { Egg 
       pigment {Red filter 1 }
       finish {
        ambient 0
        diffuse 0
        reflection .25
        specular 1
        roughness .001
       }
      interior{ior 1.33}
      translate <3, 1.5, -3.4>
      scale <4, 2, 5>
    }
}           



//object {traveller}       