//#local RThick = .05;
#local RThick = .075;
                                      
#local LSR = union {// Lamp Shade Rim
	intersection {
		torus {.65,RThick}
		plane {-z,0}
		translate z*2.2
	}
	sphere {<-.65,0,2.2>,RThick}
	cylinder {<.65,0,2.2>,<.2475,0,-.11>,RThick}
	cylinder {<.2475,0,-.11>,<-.2475,0,-.11>,RThick}
	sphere {<.2475,0,-.11>,RThick}
}

#declare LampShade = union {
	object { LSR translate z*Ar rotate <An,0,0> }
	object { LSR translate z*Ar rotate <An,60,0> }
	object { LSR translate z*Ar rotate <An,120,0> }
	object { LSR translate z*Ar rotate <An,180,0> }
	object { LSR translate z*Ar rotate <An,240,0> }
	object { LSR translate z*Ar rotate <An,300,0> }
	#local LSRz=.51;
	box {vrotate(<0,-1.25,LSRz>,<0,30,0>),vrotate(<0,-1.16,LSRz>,<0,210,0>)}
	box {vrotate(<0,-1.25,LSRz>,<0,30,0>),vrotate(<0,-1.16,LSRz>,<0,210,0>) rotate y*120}
	box {vrotate(<0,-1.25,LSRz>,<0,30,0>),vrotate(<0,-1.16,LSRz>,<0,210,0>) rotate y*240}
	sphere {<0,-1.1,0>,.1 }
	cylinder {
		<0,-1.1,0>,<0,-1.15,0>,.1
	}
	texture { Met_Tex }
}

#local Thickness = .05;

#local Glass_Tex = texture {
	pigment {color rgbf <1,1,1,.5> quick_color rgb .5}
	finish {specular .5 roughness .05 ambient .4}
}

#declare Pane = merge {
		intersection {
			plane {y,Thickness}
			plane {-y,Thickness}
			plane {x,.15 rotate y*degrees(atan2(4,22))}
			plane {-x,.15 rotate -y*degrees(atan2(4,22))}
			plane {z,2.2}
			plane {-z,0}
		}
		intersection {
			merge {
				cylinder {<0,-Thickness,2.2>,<0,Thickness,2.2>,.5525}
				torus {.5525,Thickness translate z*2.2}
			}
			plane {-z,-2.2}
			bounded_by {box {<-.5525-Thickness,-Thickness,2.2>,<.5525+Thickness,Thickness,2.7525>} }
		}
	cylinder {<-.15,0,0>,<-.5525,0,2.2>,Thickness}
	cylinder {<.15,0,0>,<.5525,0,2.2>,Thickness}
	cylinder {<-.15,0,0>,<.15,0,0>,Thickness}
	sphere {<-.5525,0,2.2>,Thickness}
	sphere {<.5525,0,2.2>,Thickness}
	sphere {<-.15,0,0>,Thickness}
	sphere {<.15,0,0>,Thickness}
	bounded_by {box {<-.5525-Thickness,-Thickness,-Thickness>,<.5525+Thickness,Thickness,2.7525+Thickness>} }

	hollow on
	texture { Glass_Tex }
	interior {ior 1.5}
}

#local Bulb = union {
	light_source {
		#if (Fading=true)
			#local Light=4;
		#else
			#local Light=1;
		#end
		#if (Lights!=1)
			<-.2,.1,-.2>,<Light,Light,Light*3/4>
			area_light .4*x,.4*z
			Lights,Lights
		#else
			<0,0,0>,<Light,Light,Light*3/4>
		#end
		#if (Fading=true)
			fade_distance 1
			fade_power 2
		#end
	}
	sphere {
		0,.2
		texture {
			pigment {color rgb 10}
			finish {ambient 1 diffuse .8}
		}
		no_shadow
	}
}

#local Branch = union {
	intersection {
		torus {1,.075}
		box {<-1.075,-.075,0>,<1.075,.075,1.075>}
		rotate x*90
	}
	object { Bulb translate <1,.15,0>}
	translate <1,3,0>
	scale <.4,1,.4>
}

#declare LampPost = union {

	cylinder {0,y*.2,.9}
	torus {.9,.1 translate y*.1}
	difference {
		cylinder {-y*.2,0,.8}
		torus {.8,.2}
		cone {<0,-.8,0>,0,<0,.2,0>,1}
		translate y*.4
	}
	#local Num=2*sqrt(pow(.2,2)/2);
	torus {.8-Num,.2 translate <0,.4-Num,0>}
	cylinder {<0,.3,0>,<0,.6-Num,0>,.8-Num}
	torus {.15,.05 translate <0,0.6-Num,0>}
	torus {.15,.05 translate <0,0.7-Num,0>}
	torus {.15,.05 translate <0,0.8-Num,0>}
	torus {.15,.05 translate <0,0.9-Num,0>}
	torus {.15,.05 translate <0,1.0-Num,0>}
	torus {.15,.05 translate <0,1.1-Num,0>}
	torus {.15,.05 translate <0,1.2-Num,0>}
	torus {.15,.05 translate <0,1.3-Num,0>}
	torus {.15,.05 translate <0,1.4-Num,0>}
	cylinder {<0,1.4-Num,0>,y*5,.15}
	object { Branch }
	object { Branch rotate y*120 }
	object { Branch rotate y*240 }
	texture { Met_Tex }
}

#declare Lamp = union {
#if (HideGlass=false)
	object { Pane translate z*Ar rotate x*An rotate y*0 }
	object { Pane translate z*Ar rotate x*An rotate y*60 }
	object { Pane translate z*Ar rotate x*An rotate y*120 }
	object { Pane translate z*Ar rotate x*An rotate y*180 }
	object { Pane translate z*Ar rotate x*An rotate y*240 }
	object { Pane translate z*Ar rotate x*An rotate y*300 }
#end
	object { LampShade }
	object { LampPost translate -y*6}
	scale <4/3,1,4/3>
	translate y*6
}
