/*
	Title: Then & Now
	Author: Ben Chambers
*/

global_settings {
	max_trace_level 64
	adc_bailout 1/32
}

#declare HideGlass		=	false;
#declare Fading			=	true;
#declare Lights			=	5;
#declare IsLamp			=	true;
#declare IsPhoto		=	true;
#declare IsGen			=	true;
#declare IsFurniture	=	true;
#declare IsMilk			=	true;
#declare IsHome			=	true;

camera {
	up <0,1,0>
	right <16/9,0,0>
	location <3,2,-5>
	look_at <3,1,0>
}

#local MP1 = pigment {color rgb <.8,.6,.2> quick_color rgb <1,1,0>}
#local MP2 = pigment {color rgb <.6,.4,0> quick_color rgb <1,1,0>}
#local MF1 = finish {specular .75 roughness .025 ambient .3}
#local MF2 = finish {specular 0 roughness .5 ambient .3}
#local Met_Shiny = texture {pigment {MP1} finish {MF1}}
#local Met_Tarnished = texture {pigment {MP2} finish {MF2}}
#local Met_Tex = texture {bozo texture_map {[0 Met_Shiny] [1 Met_Tarnished]} scale .2 }

#local An=70;
#local Ar=1.4;

#if (IsLamp=true)
	#include "lamp.inc"
	object{Lamp rotate y*0 translate z*1}
#else
	light_source {<0,5,0>,2}
#end
#if (IsPhoto=true)
	#include "photo.inc"
	object{Photo_New rotate y*30 translate <4,0,2> bounded_by {sphere{<3,2,-5>,.1}}}
	object{Photo_Old rotate y*30 translate <4,0,2> bounded_by {sphere{<5,2,3>,3.25}}}
#end
#if (IsGen=true)
	#include "gen.inc"
	object{Gen rotate -y*60 translate <1,0,-2.75>}
#end
#if (IsFurniture=true)
	#include "furniture.inc"
	object{Table}
	object{Wall}
#end
#if (IsMilk=true)
	#include "Milk.inc"
	object{Milk translate <0.5,0,-1.0>}
#end
#if (IsHome=true)
	#include "home.inc"
	object{Home translate <1,1.25,4>}
#end