#include "colors.inc"
#include "shapes.inc"
#include "textures.inc" 
#include "skies.inc"
#include "glass.inc"     
#include "metals.inc"

camera {
   location <0.0, 0.0, -1400.0>
   direction <0.0, 0.0, 2.0>
   up <0.0, 1.0, 0.0>
   right <210/297, 0.0, 0.0>
   look_at <0.0, 0.0, 0.0>
}

light_source {
   <290.0, 1000.0, -900.0>
   color White 
}   

plane {
   z, 15.0
   pigment {White}
   finish {ambient 1.0}
}

#declare Scheibe =
sphere {
   <0.0, 0.0, -1.0>, 10.0
   pigment {Black}
   finish {Phong_Dull ambient 0.2}
} 

#declare Halb =
difference {
   object {Scheibe}
   plane {x, 0.0 rotate z*45.0}
}

union {
   object {Scheibe translate <0.0, 335.0, 0.0>}  
   object {Scheibe translate <25.0, 335.0, 0.0>}
   object {Scheibe translate <-25.0, 335.0, 0.0>}  
   object {Scheibe translate <50.0, 335.0, 0.0>} 
   object {Scheibe translate <-50.0, 335.0, 0.0>} 
   object {Scheibe translate <75.0, 335.0, 0.0>} 
   object {Scheibe translate <-75.0, 335.0, 0.0>}  
   object {Scheibe translate <100.0, 335.0, 0.0>} 
   object {Halb translate <-100.0, 335.0, 0.0>}  
   object {Scheibe translate <125.0, 335.0, 0.0>}  
   object {Scheibe translate <-125.0, 335.0, 0.0>} 
   object {Scheibe translate <150.0, 335.0, 0.0>}  
   object {Scheibe translate <-150.0, 335.0, 0.0>} 
   object {Halb rotate z*90.0 translate <175.0, 335.0, 0.0>} 
   object {Scheibe translate <-175.0, 335.0, 0.0>} 
   object {Scheibe translate <200.0, 335.0, 0.0>}  
   object {Scheibe translate <-200.0, 335.0, 0.0>} 
   object {Scheibe translate <225.0, 335.0, 0.0>}  
   object {Scheibe translate <-225.0, 335.0, 0.0>} 
} 

union {
   object {Scheibe translate <0.0, 335.0, 0.0>}  
   object {Scheibe translate <25.0, 335.0, 0.0>} 
   object {Scheibe translate <-25.0, 335.0, 0.0>}  
   object {Scheibe translate <50.0, 335.0, 0.0>} 
   object {Scheibe translate <-50.0, 335.0, 0.0>} 
   object {Scheibe translate <75.0, 335.0, 0.0>} 
   object {Halb translate <-75.0, 335.0, 0.0>}  
   object {Scheibe translate <100.0, 335.0, 0.0>} 
   object {Scheibe translate <-100.0, 335.0, 0.0>}  
   object {Scheibe translate <125.0, 335.0, 0.0>}  
   object {Scheibe translate <-125.0, 335.0, 0.0>} 
   object {Halb rotate z*90.0 translate <150.0, 335.0, 0.0>}  
   object {Scheibe translate <-150.0, 335.0, 0.0>} 
   object {Scheibe translate <175.0, 335.0, 0.0>} 
   object {Scheibe translate <-175.0, 335.0, 0.0>} 
   object {Scheibe translate <200.0, 335.0, 0.0>}  
   object {Scheibe translate <-200.0, 335.0, 0.0>} 
   object {Scheibe translate <225.0, 335.0, 0.0>}  
   object {Scheibe translate <-225.0, 335.0, 0.0>} 
   scale <1.0, 1.0, 0.95>
   translate y*-25
}   
  
union {
   object {Scheibe translate <0.0, 335.0, 0.0>}  
   object {Scheibe translate <25.0, 335.0, 0.0>} 
   object {Scheibe translate <-25.0, 335.0, 0.0>}  
   object {Scheibe translate <50.0, 335.0, 0.0>} 
   object {Halb translate <-50.0, 335.0, 0.0>} 
   object {Scheibe translate <75.0, 335.0, 0.0>} 
   object {Scheibe translate <-75.0, 335.0, 0.0>}  
   object {Scheibe translate <100.0, 335.0, 0.0>} 
   object {Scheibe translate <-100.0, 335.0, 0.0>}  
   object {Halb rotate z*90.0 translate <125.0, 335.0, 0.0>}  
   object {Scheibe translate <-125.0, 335.0, 0.0>} 
   object {Scheibe translate <150.0, 335.0, 0.0>}  
   object {Scheibe translate <-150.0, 335.0, 0.0>} 
   object {Scheibe translate <175.0, 335.0, 0.0>} 
   object {Halb translate <-175.0, 335.0, 0.0>} 
   object {Scheibe translate <200.0, 335.0, 0.0>}  
   object {Halb rotate z*90.0 translate <-200.0, 335.0, 0.0>} 
   object {Scheibe translate <225.0, 335.0, 0.0>}  
   object {Scheibe translate <-225.0, 335.0, 0.0>} 
   scale <1.0, 1.0, 0.90>
   translate y*-50
} 

union {
   object {Scheibe translate <0.0, 335.0, 0.0>}  
   object {Scheibe translate <25.0, 335.0, 0.0>} 
   object {Halb translate <-25.0, 335.0, 0.0>}  
   object {Scheibe translate <50.0, 335.0, 0.0>} 
   object {Halb rotate z*90.0 translate <-50.0, 335.0, 0.0>} 
   object {Scheibe translate <75.0, 335.0, 0.0>} 
   object {Scheibe translate <-75.0, 335.0, 0.0>}  
   object {Halb rotate z*90.0 translate <100.0, 335.0, 0.0>} 
   object {Scheibe translate <-100.0, 335.0, 0.0>}  
   object {Scheibe translate <125.0, 335.0, 0.0>}  
   object {Scheibe translate <-125.0, 335.0, 0.0>} 
   object {Scheibe translate <150.0, 335.0, 0.0>}  
   object {Scheibe translate <-150.0, 335.0, 0.0>} 
   object {Scheibe translate <175.0, 335.0, 0.0>} 
   object {Halb rotate z*-90.0 translate <-175.0, 335.0, 0.0>} 
   object {Scheibe translate <200.0, 335.0, 0.0>}  
   object {Halb  rotate z*180.0 translate <-200.0, 335.0, 0.0>} 
   object {Scheibe translate <225.0, 335.0, 0.0>}  
   object {Scheibe translate <-225.0, 335.0, 0.0>} 
   scale <1.0, 1.0, 0.85>
   translate y*-75
}     

union {
   object {Halb translate <0.0, 335.0, 0.0>}  
   object {Scheibe translate <25.0, 335.0, 0.0>} 
   object {Scheibe translate <-25.0, 335.0, 0.0>}  
   object {Scheibe translate <50.0, 335.0, 0.0>} 
   object {Scheibe translate <-50.0, 335.0, 0.0>} 
   object {Halb rotate z*90.0 translate <75.0, 335.0, 0.0>} 
   object {Halb rotate z*90.0 translate <-75.0, 335.0, 0.0>}  
   object {Halb rotate z*0.0 translate <100.0, 335.0, 0.0>} 
   object {Scheibe translate <-100.0, 335.0, 0.0>}  
   object {Scheibe translate <125.0, 335.0, 0.0>}  
   object {Scheibe translate <-125.0, 335.0, 0.0>} 
   object {Scheibe translate <150.0, 335.0, 0.0>}  
   object {Scheibe translate <-150.0, 335.0, 0.0>} 
   object {Scheibe translate <175.0, 335.0, 0.0>} 
   object {Scheibe translate <-175.0, 335.0, 0.0>} 
   object {Scheibe translate <200.0, 335.0, 0.0>}  
   object {Scheibe translate <-200.0, 335.0, 0.0>} 
   object {Scheibe translate <225.0, 335.0, 0.0>}  
   object {Scheibe translate <-225.0, 335.0, 0.0>} 
   scale <1.0, 1.0, 0.80>
   translate y*-100
}    

union {
   object {Scheibe translate <0.0, 335.0, 0.0>}  
   object {Halb translate <25.0, 335.0, 0.0>} 
   object {Scheibe translate <-25.0, 335.0, 0.0>}  
   object {Halb rotate z*90.0 translate <50.0, 335.0, 0.0>} 
   object {Scheibe translate <-50.0, 335.0, 0.0>} 
   object {Scheibe translate <75.0, 335.0, 0.0>} 
   object {Scheibe translate <-75.0, 335.0, 0.0>}  
   object {Scheibe translate <100.0, 335.0, 0.0>} 
   object {Halb rotate z*90.0 translate <-100.0, 335.0, 0.0>}  
   object {Halb rotate z*0.0 translate <125.0, 335.0, 0.0>}  
   object {Scheibe translate <-125.0, 335.0, 0.0>} 
   object {Scheibe translate <150.0, 335.0, 0.0>}  
   object {Scheibe translate <-150.0, 335.0, 0.0>} 
   object {Scheibe translate <175.0, 335.0, 0.0>} 
   object {Scheibe translate <-175.0, 335.0, 0.0>} 
   object {Scheibe translate <200.0, 335.0, 0.0>}  
   object {Scheibe translate <-200.0, 335.0, 0.0>} 
   object {Scheibe translate <225.0, 335.0, 0.0>}  
   object {Scheibe translate <-225.0, 335.0, 0.0>} 
   scale <1.0, 1.0, 0.75>
   translate y*-125
}    
    
union {
   object {Scheibe translate <0.0, 335.0, 0.0>}  
   object {Scheibe translate <25.0, 335.0, 0.0>} 
   object {Scheibe translate <-25.0, 335.0, 0.0>}  
   object {Scheibe translate <50.0, 335.0, 0.0>} 
   object {Scheibe translate <-50.0, 335.0, 0.0>} 
   object {Scheibe translate <75.0, 335.0, 0.0>} 
   object {Scheibe translate <-75.0, 335.0, 0.0>}  
   object {Scheibe translate <100.0, 335.0, 0.0>} 
   object {Scheibe translate <-100.0, 335.0, 0.0>}  
   object {Halb rotate z*270.0 translate <125.0, 335.0, 0.0>}  
   object {Halb rotate z*90.0 translate <-125.0, 335.0, 0.0>} 
   object {Scheibe translate <150.0, 335.0, 0.0>}  
   object {Scheibe translate <-150.0, 335.0, 0.0>} 
   object {Scheibe translate <175.0, 335.0, 0.0>} 
   object {Scheibe translate <-175.0, 335.0, 0.0>} 
   object {Scheibe translate <200.0, 335.0, 0.0>}  
   object {Scheibe translate <-200.0, 335.0, 0.0>} 
   object {Scheibe translate <225.0, 335.0, 0.0>}  
   object {Scheibe translate <-225.0, 335.0, 0.0>} 
   scale <1.0, 1.0, 0.70>
   translate y*-150
}          

union {
   object {Scheibe translate <0.0, 335.0, 0.0>}  
   object {Scheibe translate <25.0, 335.0, 0.0>} 
   object {Scheibe translate <-25.0, 335.0, 0.0>}  
   object {Scheibe translate <50.0, 335.0, 0.0>} 
   object {Scheibe translate <-50.0, 335.0, 0.0>} 
   object {Scheibe translate <75.0, 335.0, 0.0>} 
   object {Scheibe translate <-75.0, 335.0, 0.0>}  
   object {Halb rotate z*270.0 translate <100.0, 335.0, 0.0>} 
   object {Scheibe translate <-100.0, 335.0, 0.0>}  
   object {Scheibe translate <125.0, 335.0, 0.0>}  
   object {Scheibe translate <-125.0, 335.0, 0.0>} 
   object {Scheibe translate <150.0, 335.0, 0.0>}  
   object {Halb rotate z*90.0 translate <-150.0, 335.0, 0.0>} 
   object {Scheibe translate <175.0, 335.0, 0.0>} 
   object {Scheibe translate <-175.0, 335.0, 0.0>} 
   object {Scheibe translate <200.0, 335.0, 0.0>}  
   object {Scheibe translate <-200.0, 335.0, 0.0>} 
   object {Scheibe translate <225.0, 335.0, 0.0>}  
   object {Scheibe translate <-225.0, 335.0, 0.0>} 
   scale <1.0, 1.0, 0.65>
   translate y*-175
}    

union {
   object {Scheibe translate <0.0, 335.0, 0.0>}  
   object {Scheibe translate <25.0, 335.0, 0.0>} 
   object {Scheibe translate <-25.0, 335.0, 0.0>}  
   object {Scheibe translate <50.0, 335.0, 0.0>} 
   object {Halb rotate z*180.0 translate <-50.0, 335.0, 0.0>} 
   object {Halb rotate z*270.0 translate <75.0, 335.0, 0.0>} 
   object {Halb rotate z*-90.0 translate <-75.0, 335.0, 0.0>}  
   object {Scheibe translate <100.0, 335.0, 0.0>} 
   object {Scheibe translate <-100.0, 335.0, 0.0>}  
   object {Scheibe translate <125.0, 335.0, 0.0>}  
   object {Scheibe translate <-125.0, 335.0, 0.0>} 
   object {Scheibe translate <150.0, 335.0, 0.0>}  
   object {Halb rotate z*180.0 translate <-150.0, 335.0, 0.0>} 
   object {Scheibe translate <175.0, 335.0, 0.0>} 
   object {Scheibe translate <-175.0, 335.0, 0.0>} 
   object {Scheibe translate <200.0, 335.0, 0.0>}  
   object {Scheibe translate <-200.0, 335.0, 0.0>} 
   object {Scheibe translate <225.0, 335.0, 0.0>}  
   object {Scheibe translate <-225.0, 335.0, 0.0>} 
   scale <1.0, 1.0, 0.60>
   translate y*-200
}    

union {
   object {Scheibe translate <0.0, 335.0, 0.0>}  
   object {Scheibe translate <25.0, 335.0, 0.0>} 
   object {Halb rotate z*180.0 translate <-25.0, 335.0, 0.0>}  
   object {Halb rotate z*270.0 translate <50.0, 335.0, 0.0>} 
   object {Scheibe translate <-50.0, 335.0, 0.0>} 
   object {Scheibe translate <75.0, 335.0, 0.0>} 
   object {Scheibe translate <-75.0, 335.0, 0.0>}  
   object {Scheibe translate <100.0, 335.0, 0.0>} 
   object {Halb rotate z*-90.0 translate <-100.0, 335.0, 0.0>}  
   object {Scheibe translate <125.0, 335.0, 0.0>}  
   object {Halb rotate z*180.0 translate <-125.0, 335.0, 0.0>} 
   object {Scheibe translate <150.0, 335.0, 0.0>}  
   object {Scheibe translate <-150.0, 335.0, 0.0>} 
   object {Scheibe translate <175.0, 335.0, 0.0>} 
   object {Scheibe translate <-175.0, 335.0, 0.0>} 
   object {Scheibe translate <200.0, 335.0, 0.0>}  
   object {Scheibe translate <-200.0, 335.0, 0.0>} 
   object {Scheibe translate <225.0, 335.0, 0.0>}  
   object {Scheibe translate <-225.0, 335.0, 0.0>} 
   scale <1.0, 1.0, 0.55>
   translate y*-225
}    
  
union {
   object {Halb rotate z*180.0 translate <0.0, 335.0, 0.0>}  
   object {Halb rotate z*270.0 translate <25.0, 335.0, 0.0>} 
   object {Scheibe translate <-25.0, 335.0, 0.0>}  
   object {Scheibe translate <50.0, 335.0, 0.0>} 
   object {Scheibe translate <-50.0, 335.0, 0.0>} 
   object {Scheibe translate <75.0, 335.0, 0.0>} 
   object {Scheibe translate <-75.0, 335.0, 0.0>}  
   object {Scheibe translate <100.0, 335.0, 0.0>} 
   object {Halb rotate z*180.0 translate <-100.0, 335.0, 0.0>}  
   object {Scheibe translate <125.0, 335.0, 0.0>}  
   object {Halb rotate z*-90.0 translate <-125.0, 335.0, 0.0>} 
   object {Scheibe translate <150.0, 335.0, 0.0>}  
   object {Scheibe translate <-150.0, 335.0, 0.0>} 
   object {Scheibe translate <175.0, 335.0, 0.0>} 
   object {Scheibe translate <-175.0, 335.0, 0.0>} 
   object {Scheibe translate <200.0, 335.0, 0.0>}  
   object {Scheibe translate <-200.0, 335.0, 0.0>} 
   object {Scheibe translate <225.0, 335.0, 0.0>}  
   object {Scheibe translate <-225.0, 335.0, 0.0>} 
   scale <1.0, 1.0, 0.50>
   translate y*-250
}    

union {
   object {Halb rotate z*270.0 translate <0.0, 335.0, 0.0>}  
   object {Halb rotate z*180.0 translate <25.0, 335.0, 0.0>} 
   object {Scheibe translate <-25.0, 335.0, 0.0>}  
   object {Scheibe translate <50.0, 335.0, 0.0>} 
   object {Scheibe translate <-50.0, 335.0, 0.0>} 
   object {Scheibe translate <75.0, 335.0, 0.0>} 
   object {Halb rotate z*180.0 translate <-75.0, 335.0, 0.0>}  
   object {Scheibe translate <100.0, 335.0, 0.0>} 
   object {Scheibe translate <-100.0, 335.0, 0.0>}  
   object {Scheibe translate <125.0, 335.0, 0.0>}  
   object {Scheibe translate <-125.0, 335.0, 0.0>} 
   object {Scheibe translate <150.0, 335.0, 0.0>}  
   object {Halb rotate z*-90.0 translate <-150.0, 335.0, 0.0>} 
   object {Scheibe translate <175.0, 335.0, 0.0>} 
   object {Scheibe translate <-175.0, 335.0, 0.0>} 
   object {Scheibe translate <200.0, 335.0, 0.0>}  
   object {Scheibe translate <-200.0, 335.0, 0.0>} 
   object {Scheibe translate <225.0, 335.0, 0.0>}  
   object {Scheibe translate <-225.0, 335.0, 0.0>} 
   scale <1.0, 1.0, 0.45>
   translate y*-275
}    
  
union {
   object {Scheibe translate <0.0, 335.0, 0.0>}  
   object {Scheibe translate <25.0, 335.0, 0.0>} 
   object {Halb rotate z*270.0 translate <-25.0, 335.0, 0.0>}  
   object {Halb rotate z*180.0 translate <50.0, 335.0, 0.0>} 
   object {Halb rotate z*180.0 translate <-50.0, 335.0, 0.0>} 
   object {Scheibe translate <75.0, 335.0, 0.0>} 
   object {Scheibe translate <-75.0, 335.0, 0.0>}  
   object {Scheibe translate <100.0, 335.0, 0.0>} 
   object {Scheibe translate <-100.0, 335.0, 0.0>}  
   object {Scheibe translate <125.0, 335.0, 0.0>}  
   object {Scheibe translate <-125.0, 335.0, 0.0>} 
   object {Scheibe translate <150.0, 335.0, 0.0>}  
   object {Halb rotate z*0.0 translate <-150.0, 335.0, 0.0>} 
   object {Scheibe translate <175.0, 335.0, 0.0>} 
   object {Scheibe translate <-175.0, 335.0, 0.0>} 
   object {Scheibe translate <200.0, 335.0, 0.0>}  
   object {Scheibe translate <-200.0, 335.0, 0.0>} 
   object {Scheibe translate <225.0, 335.0, 0.0>}  
   object {Scheibe translate <-225.0, 335.0, 0.0>} 
   scale <1.0, 1.0, 0.40>
   translate y*-300
}

union {
   object {Scheibe translate <0.0, 335.0, 0.0>}  
   object {Scheibe translate <25.0, 335.0, 0.0>} 
   object {Scheibe translate <-25.0, 335.0, 0.0>}  
   object {Scheibe translate <50.0, 335.0, 0.0>} 
   object {Scheibe translate <-50.0, 335.0, 0.0>} 
   object {Halb rotate z*180.0 translate <75.0, 335.0, 0.0>} 
   object {Scheibe translate <-75.0, 335.0, 0.0>}  
   object {Scheibe translate <100.0, 335.0, 0.0>} 
   object {Scheibe translate <-100.0, 335.0, 0.0>}  
   object {Scheibe translate <125.0, 335.0, 0.0>}  
   object {Halb rotate z*0.0 translate <-125.0, 335.0, 0.0>} 
   object {Scheibe translate <150.0, 335.0, 0.0>}  
   object {Scheibe translate <-150.0, 335.0, 0.0>} 
   object {Scheibe translate <175.0, 335.0, 0.0>} 
   object {Scheibe translate <-175.0, 335.0, 0.0>} 
   object {Scheibe translate <200.0, 335.0, 0.0>}  
   object {Scheibe translate <-200.0, 335.0, 0.0>} 
   object {Scheibe translate <225.0, 335.0, 0.0>}  
   object {Scheibe translate <-225.0, 335.0, 0.0>} 
   scale <1.0, 1.0, 0.35>
   translate y*-325
}     

union {
   object {Scheibe translate <0.0, 335.0, 0.0>}  
   object {Scheibe translate <25.0, 335.0, 0.0>} 
   object {Scheibe translate <-25.0, 335.0, 0.0>}  
   object {Scheibe translate <50.0, 335.0, 0.0>} 
   object {Scheibe translate <-50.0, 335.0, 0.0>} 
   object {Halb rotate z*90.0 translate <75.0, 335.0, 0.0>} 
   object {Scheibe translate <-75.0, 335.0, 0.0>}  
   object {Scheibe translate <100.0, 335.0, 0.0>} 
   object {Halb rotate z*0.0 translate <-100.0, 335.0, 0.0>}  
   object {Scheibe translate <125.0, 335.0, 0.0>}  
   object {Scheibe translate <-125.0, 335.0, 0.0>} 
   object {Scheibe translate <150.0, 335.0, 0.0>}  
   object {Scheibe translate <-150.0, 335.0, 0.0>} 
   object {Scheibe translate <175.0, 335.0, 0.0>} 
   object {Scheibe translate <-175.0, 335.0, 0.0>} 
   object {Scheibe translate <200.0, 335.0, 0.0>}  
   object {Scheibe translate <-200.0, 335.0, 0.0>} 
   object {Scheibe translate <225.0, 335.0, 0.0>}  
   object {Scheibe translate <-225.0, 335.0, 0.0>} 
   scale <1.0, 1.0, 0.30>
   translate y*-350
}        

union {
   object {Scheibe translate <0.0, 335.0, 0.0>}  
   object {Scheibe translate <25.0, 335.0, 0.0>} 
   object {Scheibe translate <-25.0, 335.0, 0.0>}  
   object {Halb rotate z*90.0 translate <50.0, 335.0, 0.0>} 
   object {Scheibe translate <-50.0, 335.0, 0.0>} 
   object {Scheibe translate <75.0, 335.0, 0.0>} 
   object {Halb rotate z*0.0 translate <-75.0, 335.0, 0.0>}  
   object {Scheibe translate <100.0, 335.0, 0.0>} 
   object {Scheibe translate <-100.0, 335.0, 0.0>}  
   object {Scheibe translate <125.0, 335.0, 0.0>}  
   object {Scheibe translate <-125.0, 335.0, 0.0>} 
   object {Scheibe translate <150.0, 335.0, 0.0>}  
   object {Scheibe translate <-150.0, 335.0, 0.0>} 
   object {Scheibe translate <175.0, 335.0, 0.0>} 
   object {Scheibe translate <-175.0, 335.0, 0.0>} 
   object {Scheibe translate <200.0, 335.0, 0.0>}  
   object {Scheibe translate <-200.0, 335.0, 0.0>} 
   object {Scheibe translate <225.0, 335.0, 0.0>}  
   object {Scheibe translate <-225.0, 335.0, 0.0>} 
   scale <1.0, 1.0, 0.25>
   translate y*-375
}    

union {
   object {Scheibe translate <0.0, 335.0, 0.0>}  
   object {Halb rotate z*90.0 translate <25.0, 335.0, 0.0>} 
   object {Scheibe translate <-25.0, 335.0, 0.0>}  
   object {Scheibe translate <50.0, 335.0, 0.0>} 
   object {Halb rotate z*0.0 translate <-50.0, 335.0, 0.0>} 
   object {Scheibe translate <75.0, 335.0, 0.0>} 
   object {Scheibe translate <-75.0, 335.0, 0.0>}  
   object {Scheibe translate <100.0, 335.0, 0.0>} 
   object {Scheibe translate <-100.0, 335.0, 0.0>}  
   object {Scheibe translate <125.0, 335.0, 0.0>}  
   object {Scheibe translate <-125.0, 335.0, 0.0>} 
   object {Scheibe translate <150.0, 335.0, 0.0>}  
   object {Scheibe translate <-150.0, 335.0, 0.0>} 
   object {Scheibe translate <175.0, 335.0, 0.0>} 
   object {Scheibe translate <-175.0, 335.0, 0.0>} 
   object {Scheibe translate <200.0, 335.0, 0.0>}  
   object {Scheibe translate <-200.0, 335.0, 0.0>} 
   object {Scheibe translate <225.0, 335.0, 0.0>}  
   object {Scheibe translate <-225.0, 335.0, 0.0>} 
   scale <1.0, 1.0, 0.20>
   translate y*-400
}    

union {
   object {Halb rotate z*90.0 translate <0.0, 335.0, 0.0>}  
   object {Scheibe translate <25.0, 335.0, 0.0>} 
   object {Halb rotate z*0.0 translate <-25.0, 335.0, 0.0>}  
   object {Scheibe translate <50.0, 335.0, 0.0>} 
   object {Scheibe translate <-50.0, 335.0, 0.0>} 
   object {Scheibe translate <75.0, 335.0, 0.0>} 
   object {Scheibe translate <-75.0, 335.0, 0.0>}  
   object {Scheibe translate <100.0, 335.0, 0.0>} 
   object {Scheibe translate <-100.0, 335.0, 0.0>}  
   object {Scheibe translate <125.0, 335.0, 0.0>}  
   object {Scheibe translate <-125.0, 335.0, 0.0>} 
   object {Scheibe translate <150.0, 335.0, 0.0>}  
   object {Scheibe translate <-150.0, 335.0, 0.0>} 
   object {Scheibe translate <175.0, 335.0, 0.0>} 
   object {Scheibe translate <-175.0, 335.0, 0.0>} 
   object {Scheibe translate <200.0, 335.0, 0.0>}  
   object {Scheibe translate <-200.0, 335.0, 0.0>} 
   object {Scheibe translate <225.0, 335.0, 0.0>}  
   object {Scheibe translate <-225.0, 335.0, 0.0>} 
   scale <1.0, 1.0, 0.15>
   translate y*-425
}       

union {
   object {Scheibe translate <0.0, 335.0, 0.0>}  
   object {Scheibe translate <25.0, 335.0, 0.0>} 
   object {Scheibe translate <-25.0, 335.0, 0.0>}  
   object {Scheibe translate <50.0, 335.0, 0.0>} 
   object {Scheibe translate <-50.0, 335.0, 0.0>} 
   object {Scheibe translate <75.0, 335.0, 0.0>} 
   object {Scheibe translate <-75.0, 335.0, 0.0>}  
   object {Scheibe translate <100.0, 335.0, 0.0>} 
   object {Scheibe translate <-100.0, 335.0, 0.0>}  
   object {Scheibe translate <125.0, 335.0, 0.0>}  
   object {Scheibe translate <-125.0, 335.0, 0.0>} 
   object {Scheibe translate <150.0, 335.0, 0.0>}  
   object {Scheibe translate <-150.0, 335.0, 0.0>} 
   object {Scheibe translate <175.0, 335.0, 0.0>} 
   object {Scheibe translate <-175.0, 335.0, 0.0>} 
   object {Scheibe translate <200.0, 335.0, 0.0>}  
   object {Scheibe translate <-200.0, 335.0, 0.0>} 
   object {Scheibe translate <225.0, 335.0, 0.0>}  
   object {Scheibe translate <-225.0, 335.0, 0.0>} 
   scale <1.0, 1.0, 0.10>
   translate y*-450
}   

union {
   object {Scheibe translate <0.0, 335.0, 0.0>}  
   object {Scheibe translate <25.0, 335.0, 0.0>} 
   object {Scheibe translate <-25.0, 335.0, 0.0>}  
   object {Scheibe translate <50.0, 335.0, 0.0>} 
   object {Scheibe translate <-50.0, 335.0, 0.0>} 
   object {Scheibe translate <75.0, 335.0, 0.0>} 
   object {Scheibe translate <-75.0, 335.0, 0.0>}  
   object {Scheibe translate <100.0, 335.0, 0.0>} 
   object {Scheibe translate <-100.0, 335.0, 0.0>}  
   object {Scheibe translate <125.0, 335.0, 0.0>}  
   object {Scheibe translate <-125.0, 335.0, 0.0>} 
   object {Scheibe translate <150.0, 335.0, 0.0>}  
   object {Scheibe translate <-150.0, 335.0, 0.0>} 
   object {Scheibe translate <175.0, 335.0, 0.0>} 
   object {Scheibe translate <-175.0, 335.0, 0.0>} 
   object {Scheibe translate <200.0, 335.0, 0.0>}  
   object {Scheibe translate <-200.0, 335.0, 0.0>} 
   object {Scheibe translate <225.0, 335.0, 0.0>}  
   object {Scheibe translate <-225.0, 335.0, 0.0>} 
   scale <1.0, 1.0, 0.05>
   translate y*-475
}    

box {
   <-235.0, -180.0, 0.0>, <-85.0, -330.0, -1.0>
   pigment {Black}
}   

sphere {
   <10.0, -255.0, 0.0>, 75.0
   pigment {Black}
   finish {Phong_Dull}
}  

triangle {
   <85.0, -330.0, 0.0>, <235.0, -330.0, 0.0>, <160.0, -180.0, 0.0>
   pigment {Black}
}  




    


