#include "colors.inc"   
#include "mT.inc"
#include "tower.inc"
#include "hills.inc"
#include "tree.inc"

#include "hillsF.inc"
#include "headFoot.inc"
#include "treeF.inc"
#include "towerF.inc"

   
#declare cloudsT = texture{
  pigment{
    bozo
    turbulence 1
    color_map{
      [0.00 rgbf<1,1,1,0.6>]
      [0.20 White filter 1]
      [0.80 White filter 1]
      [1.00 rgbf<1,1,1,0.6>]
    }
    scale 800
    translate x*000
  }
  finish{ambient 1}
}
#declare skyT = texture{
  pigment{color rgb<0.5,0.5,1>}
  finish{ambient 1}
}
#declare waterT =
texture {
    pigment{ rgb <0.02, 0.02, 0.02> }
    normal {
        ripples 0.2
        turbulence 1.5
        scale 1
    }
    finish {
        reflection 0.3
    }
}
//#declare waterT = texture { pigment{White}}       
camera{ 
  location <0,4,-70>
  look_at <0,3,0>
  //location <0,10,-60>
  //look_at <0,13,-40>
}
        
//light_source{
//  <200,300,-200>
//  color red 1.0  green 1.0  blue 1.0
//  rotate y*-0
//}
light_source{
  <200,300,-200>
  color White
  area_light <3,0,3>,<0,3,0> 3,3
  adaptive 1
  jitter
}

box{
  <0,0,-30>,<500,0.01,200>
  texture{waterT}
} 

box{
  <0,500,-100>,<10000,501,1000000>
  texture{skyT}
  texture{cloudsT translate x*1000+z*2000}
}

difference{ 
height_field{ gif "mHF.gif"
  translate x*-0.5+z*-0.5
  scale <200,25,250>
  translate x*0
  texture{mT}
}
box{<0,-1,-100>,<-1000,100,200>}
} 


union{
  object{
    hills
    //pigment{White}
    texture{hillT}
  } 
  // grs
  #declare s1=seed(1);
  union{ 
    #declare x0=0.01;
    #while(x0<1.6)
      #declare z0=0.5;
      #while(z0<1)
        #declare xV=x0+rand(s1)*0.1;
        #declare zV=z0+rand(s1)*0.1;
        triangle{
          <-0.003,0,0>,
          <0.003,0,0>,
          <0,0.2,0>
          rotate z*(20-40*rand(s1))
          rotate y*360*rand(s1)
          translate <xV,(1+sin(xV)*sin(zV))*sin(xV*pi/6)*sin(zV*pi/10),zV>
        }
        
        #declare z0=z0+0.024;
      #end
      #declare x0=x0+0.024;
    #end     
    #declare x0=0.01;
    #while(x0<1.9)
      #declare z0=1;
      #while(z0<2)
        #declare xV=x0+rand(s1)*0.1;
        #declare zV=z0+rand(s1)*0.1;
        triangle{
          <-0.003,0,0>,
          <0.003,0,0>,
          <0,0.2,0>
          rotate z*(20-40*rand(s1))
          rotate y*360*rand(s1)
          translate <xV,(1+sin(xV)*sin(zV))*sin(xV*pi/6)*sin(zV*pi/10),zV>
        }
        
        #declare z0=z0+0.024;
      #end
      #declare x0=x0+0.024;
    #end         
    #declare x0=0.01;
    #while(x0<2.5)
      #declare z0=2;
      #while(z0<4)
        #declare xV=x0+rand(s1)*0.1;
        #declare zV=z0+rand(s1)*0.1;
        triangle{
          <-0.005,0,0>,
          <0.005,0,0>,
          <0,0.2,0>
          rotate z*(20-40*rand(s1))
          rotate y*360*rand(s1)
          translate <xV,(1+sin(xV)*sin(zV))*sin(xV*pi/6)*sin(zV*pi/10),zV>
        }
        
        #declare z0=z0+0.04;
      #end
      #declare x0=x0+0.04;
    #end         
    #declare x0=0.01;
    #while(x0<3.5)
      #declare z0=4;
      #while(z0<7.5)
        #declare xV=x0+rand(s1)*0.1;
        #declare zV=z0+rand(s1)*0.1;
        triangle{
          <-0.007,0,0>,
          <0.007,0,0>,
          <0,0.25,0>
          rotate z*(20-40*rand(s1))
          rotate y*360*rand(s1)
          translate <xV,(1+sin(xV)*sin(zV))*sin(xV*pi/6)*sin(zV*pi/10),zV>
        }
        
        #declare z0=z0+0.04;
      #end
      #declare x0=x0+0.04;
    #end  
    texture{pigment{color rgb<0.2,0.7,0.> } finish{ambient 0.4}}//pigment{rgb<0.992,0.902,0.525>} finish{ambient 0.3}}
  }     //slut grs             0.7,1,0.3
    
  
  #declare s2=seed(2);
    
  #declare i=0;
  #while(i<300)
    #declare x0=0.5;
    #declare z0=0.8;
    #declare r=1*sqrt(rand(s2)*rand(s2))+0.02;
    #declare theta=360*rand(s2);
    #declare xVal=abs(x0+r*cos(theta));
    #declare zVal=z0+r*sin(theta);
    object{leaf
      scale <1/4,1/2.,1/3.5>
      scale 0.8
      rotate y*(0.5-rand(s2))*5
      rotate z*360*rand(s2)
      rotate x*(56+10*rand(s2))
      translate <xVal,(1+sin(xVal)*sin(zVal))*sin(xVal*pi/6)*sin(zVal*pi/10)+0.02,zVal>
      texture{leafGT translate z*100*rand(s1)}
    }
    #declare i=i+1;
  #end
  object{tree
    rotate -90*y
    rotate z*-7
    scale <1/4,1/2,1/3.5>
    scale 0.4
    translate <x0-0.1,(1+sin(x0)*sin(z0))*sin(x0*pi/6)*sin(z0*pi/10)-0.8,z0-0.1> 
  }
    
  #declare i=0;
  #while(i<300)
    #declare x0=1.7;//1.5
    #declare z0=1.8;
    #declare r=1.3*sqrt(rand(s2)*rand(s2))+0.02;
    #declare theta=90+160*rand(s2);
    #declare xVal=x0+r*cos(theta);
    #declare zVal=z0+r*sin(theta);
    object{leaf
      scale <1/4,1/2.,1/3.5>
      scale 0.8
      rotate y*(0.5-rand(s2))*5
      rotate z*360*rand(s2)
      rotate x*(56+10*rand(s2))
      translate <xVal,(1+sin(xVal)*sin(zVal))*sin(xVal*pi/6)*sin(zVal*pi/10)+0.02,zVal>
      texture{leafGT translate z*100*rand(s1)}
    }
    #declare i=i+1;
  #end
  object{tree
    rotate y*50
    rotate z*5
    scale <1/4,1/2,1/3.5>
    scale 0.4
    translate <x0-0.1,(1+sin(x0)*sin(z0))*sin(x0*pi/6)*sin(z0*pi/10)-0.8,z0-0.1> 
  } 

  #declare x0=0.3;
  #declare z0=4;
  object{tree
    scale <1/4,1/2,1/3.5>
    scale 0.3
    translate <x0-0.1,(1+sin(x0)*sin(z0))*sin(x0*pi/6)*sin(z0*pi/10)-0.8,z0-0.1> 
  }                         
 
                  
  scale <4,2.,3.5>
  translate y*0.07
  translate z*-65 
}   

object{tower scale 0.2 rotate y*50 translate z*-30}
  
makeMan(10,-20,0,0,0,0,0,0,0,0,0)
object{Man
  scale 1
  rotate y*-80
  translate <35,2.8,30>        
}
  
//fiction      

#declare skyT = texture{
  pigment{color rgb<0.5,0.5,1>}
  finish{ambient 1}
}                                 

box{
  <-10000,500,-100>,<0,501,100000>
  texture{skyT}
}

box{
  <0,0,-30>,<-100,0.01,130>
  texture{
    pigment{Black}
    finish{phong 4 phong_size 20 reflection 0.3 irid{0.5 thickness 0.1 turbulence 1}}
    normal{ripples 3 turbulence 0 scale 0.2}
    scale 50
    translate z*100
  }
}

#declare cloud = union{
  sphere { < -3.3,   0,    0>, 2.5 translate y*-0.7}
  sphere { <0,  0, 0>, 3.5}
  sphere { <3.7, 0, 0>, 2.5 translate y*-0.7}
  sphere { <5.5, 0, 0>, 1.5 translate y*-1.4}
  texture{pigment{rgb<1,0.99,0.85>} finish{ambient 0.4 phong 3 phong_size 20}}
  scale 1*<2,2,1>
}
#object{cloud translate <-20,30,0>}
#object{cloud translate <-70,40,70>}
difference{
#object{cloud translate <-10,39.1,50>}
box{<0,30,40>,<20,60,60>}
}
#object{
  hillsF
  scale <1,1.5,1>
  rotate y*180
  translate z*-30+y*0.02
  texture{pigment{rgb<0.35,0.91,0.36>} finish{ambient 0.4 phong 0.7 phong_size 20}}
} 

difference{
union{
cone{
  0*y,  60.0,
  20*y, 0.0
  translate z*115+x*-20
}
cone{
  0*y,  50.0,
  25*y, 0.0
  translate z*120+x*-50
}
cone{
  0*y,  100.0,
  15*y, 0.0
  translate z*140+x*-80
}
cone{
  0*y,  40.0,
  30*y, 0.0
  translate z*110+x*-40
}    
cone{
  0*y,  20.0,
  35*y, 0.0
  translate z*110+x*-90
}  
cone{
  0*y,  35.0,
  40*y, 0.0
  translate z*100+x*-105
}  
cone{
  0*y,  40.0,
  60*y, 0.0
  translate z*150+x*-15
}                                     
  texture{pigment{rgb<0.30,0.21,0.96>} finish{ambient 0.4 phong 0.7 phong_size 20}}
}
box{<0,-1,50>,<100,100,200>}
}


//eyeXAngle,eyeYAngle,kneeAngle,legAngleL,legAngleR,handAngleL,handAngleR,
//elbowAngleL,elbowAngleR,elbowA2L,elbowA2R 

makeMan(30,20,0,-60,60,0,50,25,70,0,70)
#declare xV=1*pi;
#declare zV=10*pi;

object{Man
  scale <1,1/1.5,1>
  rotate y*-180 
  translate <xV,sin(xV/4)*sin(xV/4)*sin(zV/2)*sin(zV/2)-0.1,zV>
  scale <1,1.5,1>
  rotate y*180
  translate z*-30+y*0.02        
}

makeMan(0,0,60,10,40,80,80,90,90,50,50)
#declare xV=0.4*pi;
#declare zV=4*pi;

object{
  Man
  translate y*-1.9
  rotate x*-40
  translate y*1.9
  rotate y*30

  scale <1,1/1.5,1>
  rotate y*-180 
  translate <xV,sin(xV/4)*sin(xV/4)*sin(zV/2)*sin(zV/2)-0.1,zV>
  scale <1,1.5,1>
  rotate y*180
  translate z*-30+y*0.02  
}

makeMan(20,-22,130,140,140,40,50,90,60,100,-20)
#declare xV=1.4*pi;
#declare zV=8*pi;

object{
  Man
  scale 0.7
  rotate y*-35
  translate y*-0.4+x*2

  scale <1,1/1.5,1>
  rotate y*-180 
  translate <xV,sin(xV/4)*sin(xV/4)*sin(zV/2)*sin(zV/2)-0.1,zV>
  scale <1,1.5,1>
  rotate y*180
  translate z*-30+y*0.02
} 

makeMan(-30,10,0,0,0,0,0,0,0,0,0)
object{Man
  rotate y*20
  translate <-2.4,14.5,-31.5>        
}
makeMan(10,-20,0,0,0,0,0,0,0,0,0)
object{Man
  rotate y*220
  translate <-40,25,103>        
}

object{treeF
  rotate y*10
  scale 1.4
  translate y*2.+z*-57+x*-8
  texture{pigment{Brown} finish{ambient 0.4 phong 0.7 phong_size 20}}
}
object{treeF
  rotate y*10
  scale 1.4
  translate y*0.5+z*-40+x*-3
  texture{pigment{Brown} finish{ambient 0.4 phong 0.7 phong_size 20}}
}

object{towerF scale 0.20  translate z*-30}   