#include "treeT.inc"        

#declare leaf = mesh{
  triangle{<0,0.1,0>,<-0.06,0.3,-0.02>,<0,0.38,-0.0>}
  triangle{<0,0.1,0>,<0.06,0.3,-0.02>,<0,0.38,-0.0>}
  triangle{<0,0.1,0>,<-0.06,0.3,-0.02>,<-0.12,0.31,-0.05>}
  triangle{<0,0.1,0>,<0.06,0.3,-0.02>,<0.12,0.31,-0.05>}
  triangle{<0,0.1,0>,<-0.12,0.31,-0.05>,<-0.11,0.17,-0.1>}
  triangle{<0,0.1,0>,<0.12,0.31,-0.05>,<0.11,0.17,-0.1>}
  triangle{<0,0.1,0>,<-0.01,-0.1,0>,<0.01,-0.1,0>}
  rotate y*180
}
#declare leafs = union{
  #object{
    leaf
    translate y*0.1
    rotate x*-5
  }
  #object{
    leaf
    rotate 20*y
    rotate 45*z
    rotate x*15
  }
  #object{
    leaf
    rotate -20*y
    rotate -45*z
    rotate x*15
  }
  scale 2
}

#local leafT=texture{
  pigment{
    bozo
    color_map{
        [0 rgbf<0,0.9,0,0.4>]
        [0.15 rgbf<0,0.9,0,0.4>]
        [0.151 rgbf <0.9,0.9,0,0.5>]
        [0.5 rgbf <0.9,0.9,0,0.5>]
        [0.501 rgbf <1,0.5,0,0.3>]
        [0.8 rgbf <1,0.5,0,0.3>]
        [0.801 rgbf<0,0.9,0,0.4>]
        [1 rgbf<0,0.9,0,0.4>]
    }
    scale 0.8
  }
  finish{ambient 0.3 phong 0.2 phong_size 1}
}
#declare leafGT=texture{
  pigment{
    bozo
    color_map{
        [0 rgbf <0.9,0.9,0,0.5>]
        [0.5 rgbf <0.9,0.9,0,0.5>]
        [0.501 rgbf <1,0.5,0,0.3>]
        [1 rgbf <1,0.5,0,0.3>]
    }
    scale 0.8
  }
  finish{ambient 0.3 phong 0.2 phong_size 1}
}
      
     
//#local leafT=texture{
  //pigment{rgbf <1,0.5,0,0.3>}
  //finish{ambient 0.3 phong 0.2 phong_size 1}
//}
        
        
#macro branch (startRadius,nrSegments,changeFreq,radiusChange,branchProb,startBranch,stopBranch,branchFreq,minAngle,maxAngle,seed1,seed2,seed3)
  #declare branchPos = array[nrSegments]
  #declare branchRadius = array[nrSegments]
  #declare branchRotZ = array[nrSegments]
  #declare branchRotY = array[nrSegments]
  #declare nrBranches=0;

  #local oldAngle=rand(seed3)*360;
    
  #local i=0;
  #local currentPosition=<0,0,0> ;
  #local currentRadius=startRadius;
  #local coneVector=y*0.1;
  #local dirChange=<0,0,0>;
  #declare branchO = union{
    #while(i<nrSegments)
      #if(mod(i+1,changeFreq)=0)
        #local dirChange = <0.01*(rand(seed1)-0.5),0,0.01*(rand(seed1)-0.5)>;
      #end
      #local coneVector=coneVector+dirChange;
      #local nextRadius=currentRadius*radiusChange;//-startRadius*0.02;
      #local nextPosition=currentPosition+coneVector;
      #cone{
        currentPosition,currentRadius
        nextPosition,nextRadius
      }
      #if((rand(seed2)<branchProb)&(mod(i,branchFreq)=0)&(i>startBranch)&(i<stopBranch))
        #declare branchPos[nrBranches]= nextPosition;
        #declare branchRadius[nrBranches]= nextRadius*4/5;
        #declare branchRotZ[nrBranches]=minAngle+rand(seed2)*(maxAngle-minAngle);
        #declare branchRotY[nrBranches]=oldAngle+90+rand(seed3)*180;
        #local oldAngle=branchRotY[nrBranches]; 
        #declare nrBranches=nrBranches+1;
      #end
      #local currentPosition=nextPosition+0.2*(currentPosition-nextPosition);
      #local currentRadius=nextRadius;     
      #local i=i+1;
    #end
    #if(0<branchProb)
      #declare branchPos[nrBranches]= currentPosition;
      #declare branchRadius[nrBranches]= nextRadius;
      #declare branchRotZ[nrBranches]=0;
      #declare branchRotY[nrBranches]=0;
      #declare nrBranches=nrBranches+1;
    #end
  }
#end

#local ls1=seed(90);

#declare tree = union{
     
#local s1= seed(1);
#local s2= seed(52);
#local s3= seed(12);
//(startRadius,nrSegments,changeFreq,radiusChange,branchProb,startBranch,stopBranch,branchFreq,minAngle,maxAngle,                 
branch(0.25,130,1,0.99,0.99,80,130,7,30,65,s1,s2,s3)
#object{
  branchO
  texture{
    treeT
  }
}

#declare branchPosOut = branchPos
#declare branchRadiusOut = branchRadius
#declare branchRotZOut = branchRotZ
#declare branchRotYOut = branchRotY
#declare nrBranchesOut = nrBranches;
   
#local s4= seed(6);
#local s5= seed(6);
#local s6= seed(7);
#local s7= seed(8);
#local s8= seed(9);
#local s9= seed(10);
 
#declare i=0;
#while(i<nrBranchesOut)
////(startRadius,nrSegments,changeFreq,branchProb,startBranch,stopBranch,branchFreq,minAngle,maxAngle,
  branch(branchRadiusOut[i],sqrt(branchRadiusOut[i])*110,5,0.99,0.8,3,100,5,30,70,s4,s5,s6)
  union{
    #object{
      branchO      
      texture{treeT}
    }
    #declare branchPosOutII = branchPos
    #declare branchRadiusOutII = branchRadius
    #declare branchRotZOutII = branchRotZ
    #declare branchRotYOutII = branchRotY
    #declare nrBranchesOutII = nrBranches;
    #declare j=0;
    #while(j<nrBranchesOutII)
      branch(branchRadiusOutII[j],400*branchRadiusOutII[j]+7,7,0.98,0.57,0,31,2,70,95,s7,s8,s9)
      union{
        #object{
          branchO
          texture{treeT}
        }
        #declare leafPos = branchPos//branchPosOutIII = branchPos
        //#declare branchRadiusOutIII = branchRadius
        #declare leafRotZ = branchRotZ//branchRotZOutIII = branchRotZ
        #declare leafRotY = branchRotY//branchRotYOutIII = branchRotY
        #declare nrLeaf = nrBranches;//nrBranchesOutIII = nrBranches;
        #declare k=0;
        //#while(k<nrBranchesOutIII)
          //branch(branchRadiusOutIII[k]*0.8,20,1,2,23,1,70,90)
          //union{
            //#object{
              //branchO
              
              //pigment{treeP}
            //}
            //#declare leafPos = branchPos
            //#declare leafRotZ = branchRotZ
            //#declare leafRotY = branchRotY
            //#declare nrLeaf = nrBranches;
            #declare m=0;
            #while(m<nrLeaf)
              #object{
                leafs
                texture{
                  leafT
                  translate rand(ls1)*100
                }
                translate branchRadius[m]*y
                rotate leafRotZ[m]*z
                rotate leafRotY[m]*y
                translate leafPos[m]
              }
              #declare m=m+1;
            #end
            //rotate branchRotZOutIII[k]*z
            //rotate branchRotYOutIII[k]*y
            //translate branchPosOutIII[k]
          //}
          //#declare k=k+1;
        //#end
        rotate branchRotZOutII[j]*z
        rotate branchRotYOutII[j]*y
        translate branchPosOutII[j]
      }
      #declare j=j+1;
    #end
    rotate branchRotZOut[i]*z
    rotate branchRotYOut[i]*y
    translate branchPosOut[i]
  }
  #declare i=i+1;
#end

     /*
      branch(0.05,30,4,0.99,0,31,2,70,95,s7,s8,s9)
      union{
        #object{
          branchO
          texture{treeT}
        }
        #declare leafPos = branchPos//branchPosOutIII = branchPos
        //#declare branchRadiusOutIII = branchRadius
        #declare leafRotZ = branchRotZ//branchRotZOutIII = branchRotZ
        #declare leafRotY = branchRotY//branchRotYOutIII = branchRotY
        #declare nrLeaf = nrBranches;//nrBranchesOutIII = nrBranches;
        #declare k=0;
        //#while(k<nrBranchesOutIII)
          //branch(branchRadiusOutIII[k]*0.8,20,1,2,23,1,70,90)
          //union{
            //#object{
              //branchO
              
              //pigment{treeP}
            //}
            //#declare leafPos = branchPos
            //#declare leafRotZ = branchRotZ
            //#declare leafRotY = branchRotY
            //#declare nrLeaf = nrBranches;
            #declare m=0;
            #while(m<nrLeaf)
              #object{
                leafs
                translate branchRadius[m]*y
                rotate leafRotZ[m]*z
                rotate leafRotY[m]*y
                translate leafPos[m]
              }
              #declare m=m+1;
            #end} */

}


