#version unofficial MegaPOV 0.5;

#declare test_crayons_inc=off;



#macro ArcSphere(R, d)

#local A = (R*R/(d*d))+1;
#local B = -2*R*R/(d*d);
#local det = B*B - 4*A;
#local rac = (-B - sqrt(det))/(2*A);
#local gamma = acos(rac);
#local Rayon = abs(R)/sin(gamma);
intersection {
	box { <0, -R*1.01, -R*1.1>, <d*1.1, R*1.01, R*1.01> }
	sphere { 0, Rayon translate -(Rayon-abs(d))*x }
}
#end

#macro Crayon_Bois(lng, R, angmin, devang, nbdiff, TexCen, TexMil, TexExt, sc, mal_taille)

#local stc=seed(sc);

#local motif1 = pigment {
	pigment_pattern {
		planar
		rotate z*90
		scale <R, 1, 1>
	}
	color_map {
		[0 rgb 0]
		[1 rgb 1]
	}
}

#local motif2 = pigment {
	radial
	pigment_map {
		[ 30/360 motif1 ]
		[ 30/360 motif1 rotate  60*y ]
		[ 90/360 motif1 rotate  60*y ]
		[ 90/360 motif1 rotate  120*y]
		[150/360 motif1 rotate  120*y]
		[150/360 motif1 rotate  180*y]
		[210/360 motif1 rotate  180*y]
		[210/360 motif1 rotate -120*y]
		[270/360 motif1 rotate -120*y]
		[270/360 motif1 rotate -60*y ]
		[330/360 motif1 rotate -60*y ]
		[330/360 motif1 ]
	}
}

difference {
	// partie principale
	intersection {
		box { <-R, 0, -2*R>, <R, lng, 2*R> }
		box { <-R, 0, -2*R>, <R, lng, 2*R> rotate -60*y }
		box { <-R, 0, -2*R>, <R, lng, 2*R> rotate  60*y }
	}
	// taillage de la mine
	#local i=0;
	#local ang=0;
	#while (i<nbdiff)
		plane { x, 0 rotate -z*(angmin+devang*rand(stc)) rotate y*((i+.05*rand(stc))*750/nbdiff) translate lng*y }
		#local ang=ang+20+5*rand(stc);
		#local i=i+1;
	#end
	// bout de la mine
	#if (mal_taille)
		#local mal_taille=1;
	#else
		#local mal_taille=0;
	#end
	#local i=0;
	#while (i<10)
		plane { x, 0 rotate -z*(50+35*rand(stc)) rotate y*(i*360/10) translate (.998*lng -(.4*R*mal_taille))*y }
		#local i=i+1;
	#end

	texture {
		pigment_pattern {
			motif2
		}
		texture_map {
			[.01 TexExt]
			[.01 TexMil]
			[.65 TexMil]
			[.65 TexCen]
		}
	}
}

#end



#macro Crayon_Bic(CoulEnc, TexExt, Ior, sc, mange)

union {
	// corps
	difference {
		union {
			cylinder { 0, 12.5*y, .5 }
			cone { 12.5*y, .5, 13.5*y, .3 }
		}
		plane { x, - .5*cos(radians(30)) }
		plane { x, - .5*cos(radians(30)) rotate y*60 }
		plane { x, - .5*cos(radians(30)) rotate y*120 }
		plane { x, - .5*cos(radians(30)) rotate y*180 }
		plane { x, - .5*cos(radians(30)) rotate -y*60 }
		plane { x, - .5*cos(radians(30)) rotate -y*120 }
		cylinder { -.1*y, 12.001*y, .45*cos(radians(30)) }
		cylinder { 6*y, 6*y+.5*x, .05 }
		cone { 12*y, .45*cos(radians(30)), 13.51*y, .3*.45/.5 }
		texture { TexExt }
		interior { ior Ior }
	}
	// mine
	union {
		cylinder { 12*y, 12.5*y, .15 }
		cylinder { 12.5*y, 13.5*y, .95*.3*.45/.5 }
		cone { 13.5*y, .29, 14.25*y, .1 }
		texture {
			pigment { color rgb <.64,.46,.24> }
			finish { specular .7 roughness .001 metallic }
		}
	}
	// bout de mine
	union {
		cone { 14.25*y, .09, 14.45*y, .05 }
		cone { 14.45*y, .05, 14.5*y, 0 }
		texture {
			pigment { color rgb <.64,.46,.24>*1.25 }
			finish { specular .7 roughness .001 metallic }
		}
	}
	// encre
	object {
		cylinder { 1*y, 12*y, .15 }
		texture {
			pigment {
				gradient y
				scale <1, 12.1, 1>
				warp { turbulence .8 octaves 2 }
				scale <.1,1,.1>
				color_map {
					[.3 color rgbf<1,1,1,.99>]
					[.3 color rgb CoulEnc*.1 ]
				}
			}
			finish { specular .3 roughness .01 }
		}
	}
	// cul
	union {
		cylinder { 0*y, 0.6*y, .15 }
		object { ArcSphere( 0.5*cos(radians(30)), .2) rotate -z*90 }
		texture {
			pigment { color CoulEnc }
			finish { specular .2 roughness .03 }
		}
	}
}

#end



#if (test_crayons_inc)

#include "colors.inc"
#include "woods.inc"

camera {
	location <6,5,-8>*2.0
	right x*4/3
	up y
	angle 20
	look_at <5,.15,0>
}

#declare Use_Rad = off;

global_settings {
	max_trace_level 20
	adc_bailout .1
}

#if (Use_Rad)

global_settings {
	assumed_gamma 1.0
	ini_option "+QR"
	radiosity{
		count 10
		nearest_count 4
		error_bound .2
		recursion_limit 1
		brightness 1.0

		pretrace_start  .1
		pretrace_end  .01

		low_error_factor .5
		gray_threshold 0.0
		minimum_reuse 0.015
		normal on

		max_sample 1
		adc_bailout 0.05
	}
}

#default { texture { finish { diffuse 1 ambient 0 } } }

sky_sphere { pigment { gradient y color_map { [.5 rgb <1, .99, .95>*.4] [.9 rgb <1, 1, 1>*.6] } } }

light_source { <-15,15,-15>*100, color rgb .8 }

#else


light_source { <-15,15,-15>*100, color rgb 1.5 }
light_source { <15,5,-5>*100, color rgb .3 shadowless }

#default { texture { finish { diffuse 0.9 ambient 0.1 } } }

#end


plane { y, 0
	texture { T_Wood22 scale .1 translate 10*x }
}


#declare TexCen = texture { pigment { color rgb .1 } }
#declare TexMil = texture {
	pigment {
		spotted
		warp { turbulence .2 octaves 2 }
		scale <5,1,1>*.1
		color_map {
			[0.55 color rgb <1, .7, .3>]
			[0.75 color rgb <1, .7, .3>*.7]
		}
	}
}
#declare TexExt = texture {
	pigment { color rgb<.3, 1, .5>*.8 }
	normal { dents .5 scale .3 slope_map {[0 <0,3>] [.4 <.9,2>] [.5 <1,0>]} }
}


#declare TexBicTr = texture {
	pigment { color rgbf <1,1,1,.97> }
	finish { specular .5 roughness .005 }
}

object {
	Crayon_Bois(12, .4, 15, 5, 60, TexCen, TexMil, TexExt, 85632, on)
	rotate -z*90
	translate .4*y - 6*x - 1.5*z
}

object {
// Crayon_Bic(CoulEnc, TexExt, Ior, sc, mange)
	Crayon_Bic(<.1,.3,1>, TexBicTr, 1.4, 3211, off)
	rotate -z*90
	translate .5*sin(radians(30))*y - 7*x + 1.5*z
}	


#end
