// buildings.inc
// various extra buildings

#local B1Width = 15;
#local B1Length = 10;
#local B1Height = 55;
#local B1Top = 4;
#local B2Width = 12;
#local B2Length = 12;
#local B2Height = 75;
#local B2Top = 6;

#local T_grey = texture {
	pigment { rgb <0.3,0.3,0.35> }
	normal { gradient x+z 0.8
		scale 0.8
		translate <2*B1Width,0,-2*B1Length>
	}
}

#local T_darkgrey = texture {
	pigment { rgb <0.1,0.1,0.1> }
	normal { gradient x+z 0.8
		scale 0.8
		translate <2*B2Width,0,-2*B2Length>
	}
}

#local T_glass = texture {
	pigment { rgb <0.1,0.1,0.1> }
	normal { bozo 0.3
		turbulence 0.4
		scale 5
	}
	finish {
		reflection 0.4
		specular 0.9
		roughness 0.0005
	}
}

#local T_windows = texture { gradient x+z
	texture_map {
		[0.0 T_grey]
		[0.4 T_grey]
		[0.4 T_glass]
		[1.0 T_glass]
	}
	scale 0.8
}

#local T_darkwindows = texture { gradient x+z
	texture_map {
		[0.0 T_darkgrey]
		[0.2 T_darkgrey]
		[0.2 T_glass]
		[1.0 T_glass]
	}
	scale 0.8
}

#local T_metal = texture {
	pigment { rgb <0.5,0.5,0.5> }
	finish {
		reflection 0.3
		specular 0.8
		roughness 0.0005
		metallic
	}
}

#declare Building1 = union {
	box { <-B1Width,0,-B1Length>, <B1Width,B1Height,B1Length>
		texture { gradient y
			texture_map {
				[0.0 T_grey]
				[0.4 T_grey]
				[0.4 T_windows]
				[1.0 T_windows]
			}
			scale 3
		}
	}
	superellipsoid { <0.7,0.2>
		rotate <0,90,0>
		scale <3*B1Width/4,B1Top,B1Length/2>
		translate <0,B1Height,0>
		texture { gradient x
			texture_map {
				[0.0 T_grey]
				[0.6 T_grey]
				[0.6 T_metal]
				[0.69 T_metal]
				[0.69 T_grey]
				[0.7 T_grey]
				[0.7 T_metal]
				[0.79 T_metal]
				[0.79 T_grey]
				[0.8 T_grey]
				[0.8 T_metal]
				[0.89 T_metal]
				[0.89 T_grey]
				[0.9 T_grey]
				[0.9 T_metal]
				[0.99 T_metal]
				[0.99 T_grey]
				[1.0 T_grey]
			}
			scale <18,1,1>
			translate <12,0,0>
		}
	}
	cone { <0,0,0>, 0.1*B1Width, <0,3*B1Top,0>, 0
		texture {
			pigment { spiral2 5
				pigment_map {
					[0.0 rgbt <1,1,1,1>]
					[0.6 rgbt <1,1,1,1>]
					[0.6 rgb <1,0,0>]
					[0.7 rgb <1,0,0>]
					[0.7 rgb <0.9,0.9,0.9>]
					[1.0 rgb <0.9,0.9,0.9>]
				}
			}
			scale 2
		}
		translate <0.85*B1Width,B1Height,0.8*B1Length>
	}
	texture {
		pigment { rgb <1,0,0> }
	}
}

#declare Building2 = union {
	box { <-B2Width,0,-B2Length>, <B2Width,B2Height,B2Length>
		texture { gradient y
			texture_map {
				[0.0 T_darkgrey]
				[0.2 T_darkgrey]
				[0.2 T_windows]
				[1.0 T_windows]
			}
			scale 3
		}
	}
	box { <-B2Width,B2Height,-B2Length>, <B2Width,B2Height+B2Top,B2Length>
		texture { gradient x+z
			texture_map {
				[0.0 T_darkgrey]
				[0.2 T_darkgrey]
				[0.2 T_grey]
				[1.0 T_grey]
			}
			scale 3
		}
	}
}
