// dmcontra.pov

// development switches
#declare Fog = 0;
#declare Clouds = 0;
#declare Room = 1;
#declare Pic = 1;
#declare PicLabel = 1;
#declare StPaulsCathedral = 1;
#declare NatWestTower = 1;
#declare WindowGlass = 1;
#declare GlassDirt = 1;
#declare OtherBuildings = 1;

// Parameters
#declare Light = <1.5, 1.5, 1.5>;
#declare FillLight = <0.3, 0.3, 0.3>;
#declare FogColour = <1.4, 0.7, 0.4>;
#declare GlassIor = 1.4;
#declare seed1 = seed(4871);

// glass texture
#declare T_glass = texture {
	pigment { rgbt <0.97,1,1,0.95> }
	finish {
		reflection 0.05
		phong 0.3
		phong_size 250
	}
}
#declare I_glass = interior {
	ior GlassIor
	caustics 0.7
}

// debug texture
#declare T_debug = texture { pigment { rgb <0,1,0> } }

global_settings {
	max_trace_level 40
}

// includes
#include "woods.inc"
#include "stpauls.inc"
#include "natwest.inc"
#include "picture.inc"
#include "buildings.inc"

#declare Camera1 = camera {
	location <0, 1.6, 0>
	look_at <0,1.6,2>
}
#declare Camera4 = camera {
	location <0, 1.6, -0.2>
	look_at <0,1.6,2>
}
#declare Camera2 = camera {
	location <0, 50, 100>
	look_at <0,50,200>
}
#declare Camera3 = camera {
	location <0, 25, 50>
	look_at <0,25,100>
}

camera { Camera4 }

// ***** LIGHTS *****
light_source { <-10, 2.45, -5>, rgb Light
}
light_source { <4, 2, -1>, rgb FillLight
	shadowless
}
#if (Room)
light_source { <4, 2, -1>, rgb Light
}
#end
// ***** END LIGHTS *****

// positional constants
#declare roomHeight = 2.5;
#declare RoomX1 = -5;
#declare RoomX2 = 5;
#declare RoomZ1 = -5;
#declare RoomZ2 = 1.0;
#declare WallThick = 0.1;
#declare winSill = 1.07;
#declare winTop = 2.13;
#declare winHalf = (winSill+winTop)/2;
#declare winStart = -4;
#declare winStop = 4;
#declare winWidth = 0.9;
#declare winSep = 2;


#if (Room)
// ***** ROOM OBJECTS *****

// room
difference {
	box { <RoomX1-WallThick,-WallThick,RoomZ1-WallThick>, <RoomX2+WallThick,roomHeight+WallThick,RoomZ2+WallThick> }
	box { <RoomX1,0,RoomZ1>, <RoomX2,roomHeight,RoomZ2> }
	#declare x1 = winStart;
	#while (x1 < winStop)
		box { <x1,winSill,RoomZ1-2*WallThick>, <x1+winWidth,winTop,RoomZ2+2*WallThick> }
		#declare x1 = x1 + winSep;
	#end
	texture {
		pigment { bozo
			colour_map {
				[0.0 rgb <1,0.95,0.9>]
				[0.6 rgb <1,0.95,0.9>]
				[1.0 rgb <0.7,0.7,0.6>]
			}
			turbulence 1
		}
		scale 0.01
	}
	normal { granite 0.02
		scale 0.01
		turbulence 0.3
	}
}

// windows
#declare T_Pane = texture { T_Wood32 scale 0.8 }
/*
#declare T_Pane = texture {
	pigment { wood
		colour_map {
			[0.0 rgb <0.6,0.5,0.2>]
			[0.2 rgb <0.7,0.35,0.1>]
			[0.4 rgb <0.64,0.29,0.13>]
			[0.7 rgb <0.89,0.385,0.21>]
			[1.0 rgb <0.48,0.25,0.17>]
		}
	}
}
texture {
	pigment { wood
		colour_map {
			[0.0 rgb <0.7,0.5,0.4>]
			[0.1 rgb <0.8,0.6,0.5>]
			[0.15 rgbt <0.9,0.7,0.6,1>]
			[0.2 rgbt <1,1,1,1>]
			[1.0 rgbt <1,1,1,1>]
		}
		turbulence 0.7
		omega 0.7
		scale <0.2,0.5,0.2>
		rotate <5,3,4>
	}
	finish {
		reflection 0.2
		phong 0.2
		phong_size 80
	}
} // end T_Pane
*/

#declare P_dirt = pigment { crackle
	colour_map {
		[0.0 rgbt <1,1,1,1>]
		[0.1 rgbt <1,1,1,1>]
		[0.5 rgbt <0.3,0.2,0.2,1>]
		[0.7 rgbt <0.3,0.2,0.2,0.3>]
		[1.0 rgbt <0.3,0.2,0.2,0>]
	}
	scale 0.1
	turbulence 0.8
	omega 0.7
}

#declare Pane = union {
	difference {
		box { <0.03,0,0>, <winWidth-0.03,winHalf-winSill-0.06,0.03> }
		box { <0.06,0.03,-0.1>, <winWidth-0.06,winHalf-winSill-0.09,0.1> }
	}
	superellipsoid { <0.6,0.6>
		scale <0.04,0.015,0.015>
		translate <winWidth/2,0.03,0>
		texture {
			pigment { rgb <1,0.8,0.5> }
			finish {
				reflection 0.2
				phong 0.5
				phong_size 160
				metallic
			}
		}
	}
	#if (WindowGlass)
	box { <0.05,0.02,0.01>, <winWidth-0.05,winHalf-winSill-0.08,0.02>
		texture { T_glass }
		#if (GlassDirt)
		texture {
			pigment { quilted
				pigment_map {
					[0.0 rgbt <1,1,1,1> ]
					[0.5 rgbt <1,1,1,1> ]
					[0.9 P_dirt translate <rand(seed1)*50,0,0> ]
					[1.0 P_dirt translate <rand(seed1)*50,0,0> ]
				}
				control1 1
				control0 0.5
				translate <0.06,0.03,0.01>
				scale <0.8,0.3,1>
				turbulence 0.2
				omega 0.3
			}
		}
		#end
		//interior { I_glass }
	}
	#end
}

#declare x1 = winStart;
#while (x1 < winStop)
	union {
		difference {
			box { <x1,1,RoomZ2+0.03>, <x1+0.9,winTop,RoomZ2+0.06> }
			box { <x1+0.03,winSill+0.03,RoomZ2>, <x1+0.87,winHalf-0.03,RoomZ2+0.1> }
			box { <x1+0.03,winHalf,RoomZ2>, <x1+0.87,winTop-0.03,RoomZ2+0.1> }
		}
		#if (WindowGlass)
		box { <x1+0.02,1.39,RoomZ2+0.04>, <x1+0.88,winTop-0.02,RoomZ2+0.05>
			texture { T_glass }
			#if (GlassDirt)
			texture {
				pigment { quilted
					pigment_map {
						[0.0 rgbt <1,1,1,1> ]
						[0.7 P_dirt translate <rand(seed1)*50,0,0> ]
						[1.0 P_dirt translate <rand(seed1)*50,0,0> ]
					}
					control1 1
					control0 0.5
					scale <winWidth-0.06,winHalf-winSill-0.03,1>
					translate <x1+0.03,winHalf,0.04>
					turbulence 0.2
					omega 0.3
				}
			}
			#end
			//interior { I_glass }
		}
		#end
		object { Pane
			translate <x1,winSill+0.03+rand(seed1)*(winHalf-winSill),RoomZ2>
		}
		texture { T_Pane }
	}
	#declare x1 = x1 + winSep;
#end

#end // if (Room)

// picture
#if (Pic)
	object { Picture
		rotate <-5,0,0>
		translate <-0.45,1.3,RoomZ2>
	}
#end
// label
#if (PicLabel)
	object { PictureLabel
		translate <-0.45,1.1,RoomZ2>
	}
#end

#declare Ground = -85; // ground level for external buildings

#if (StPaulsCathedral)
object { StPauls
	translate <50,Ground+25,110>
}
#end // if (StPaulsCathedral)

#if (NatWestTower)
object { NatWest
	rotate <0,-18,0>
	translate <31,Ground,210>
}
#end // if (NatWestTower)

#if (OtherBuildings)
object { Building1
	rotate <0,34,0>
	translate <11,Ground,160>
}
object { Building2
	rotate <0,-3,0>
	translate <45,Ground,190>
}
#end // if (NatWestTower)

sky_sphere {
		pigment { gradient y
			colour_map {
				[0.0 rgb <0.7,0.8,1>]
				[0.5 rgb <0.7,0.8,1>]
				[0.6 rgb <0.3,0.5,0.8>]
				[1.0 rgb <0.3,0.4,0.8>]
			}
			scale 2
			translate <0,-1,0>
		}
		pigment { bozo
			colour_map {
				[0.0 rgbt <1,1,1,1>]
				[0.6 rgbt <1,1,1,1>]
				[0.7 rgbf <1,0.9,0.8,0.5>]
				[1.0 rgbf <1,1,1,0>]
			}
			turbulence 0.5
			omega 0.8
			scale <0.2,0.05,0.2>
		}
}

#if (Clouds)
// simple cloud plane
plane { y, 300
	hollow
	texture {
		pigment { bozo
			colour_map {
				[0.0 rgbt <1,1,1,1>]
				[0.6 rgbt <1,1,1,1>]
				[0.7 rgbf <1,0.9,0.8,0.5>]
				[1.0 rgbf <1,1,1,0>]
			}
			turbulence 0.5
			omega 0.2
			scale 600
		}
		finish {
			ambient 0.9
		}
	}
}
#end

#if (Fog)
// fog layer
fog {
	fog_type 2
	rgb FogColour
	distance 3000
	fog_offset 30
	fog_alt 20
}
#end
