// natwest.inc
// NatWest Tower, London
// Ground level centre of tower = <0,0,0>

#local L = 12; // scale length of horizontal dimensions == length of wing walls
#local Lx = L/2;
#local Lz = L * sin(radians(60));
#local R120 = <0,120,0>;
#local R240 = <0,240,0>;
#local T1 = <0,Lz>;
#local T2 = <-Lz*sin(radians(60)),-Lz*sin(radians(30))>;
#local T3 = <Lz*sin(radians(60)),-Lz*sin(radians(30))>;
#local C1 = <-L,0>;
#local C2 = <-Lx,Lz>;
#local C3 = <Lx,Lz>;
#local C4 = <L,0>;
#local C5 = <Lx,-Lz>;
#local C6 = <-Lx,-Lz>;
#local W1 = <Lx,0>;
#local W2 = <0,Lz>;
#local W3 = <-L,Lz>;
#local W4 = <-Lx,2*Lz>;
#local W5 = <Lx,2*Lz>;
#local W6 = <L,Lz>;

#local CoreH = 150;
#local WingH1 = 120;
#local WingH2 = 130;
#local WingH3 = 140;
#local CylR = 0.5;

#local T_shiny = texture {
	pigment { rgb <1,0.98,0.95> }
	finish {
		reflection 0.4
		specular 1
		roughness 0.005
		metallic
	}
}

#local T_notsoshiny = texture {
	pigment { rgb <0.35,0.33,0.30> }
	finish {
		reflection 0.2
		specular 0.3
		roughness 0.005
		metallic
	}
}

#local T_stripes = texture { gradient y
	texture_map {
		[0.0 T_shiny]
		[0.9 T_shiny]
		[0.9 T_notsoshiny]
		[1.0 T_notsoshiny]
	}
	scale 38
}

#local T_windows = texture {
	pigment { rgb <0,0,0.05> }
	finish {
		reflection 0.2
		specular 0.3
		roughness 0.005
	}
}

#macro Wing(H)
	union {
		prism {
			linear_spline
			linear_sweep
			0, H, 7
			W1, W2, W3, W4, W5, W6, W1
			texture { radial
				texture_map {
					[0.0 T_stripes]
					[0.15 T_stripes]
					[0.15 T_windows]
					[1.0 T_windows]
				}
				frequency 100
			}
		}
		union {
			cylinder { <W1.x,0,W1.y>, <W1.x,H,W1.y>, CylR }
			cylinder { <W2.x,0,W2.y>, <W2.x,H,W2.y>, CylR }
			cylinder { <W3.x,0,W3.y>, <W3.x,H,W3.y>, CylR }
			cylinder { <W4.x,0,W4.y>, <W4.x,H,W4.y>, CylR }
			cylinder { <W5.x,0,W5.y>, <W5.x,H,W5.y>, CylR }
			cylinder { <W6.x,0,W6.y>, <W6.x,H,W6.y>, CylR }
			texture { T_shiny }
		}
	}
#end

#declare NatWest = union {
	prism {
		linear_spline
		linear_sweep
		0, CoreH, 7
		C1, C2, C3, C4, C5, C6, C1
		texture {
			pigment { radial
				colour_map {
					[0.0 rgb <0,0,0>]
					[0.2 rgb <0,0,0>]
					[0.2 rgb <0.1,0.1,0.1>]
					[1.0 rgb <0.1,0.1,0.1>]
				}
				frequency 60
			}
			finish {
				reflection 0.1
				specular 0.4
				roughness 0.005
			}
		}
	}
	Wing(WingH1)
	object { Wing(WingH2)
		rotate R120
	}
	object { Wing(WingH3)
		rotate R240
	}
}