// picture.inc
// Picture frame is centred in x, bottom edge at y=0
// Exterior frame size is 2*FrameX by 2*FrameY
// Interior frame size is 2*InsideX by 2*InsideY

// picture
#local pictureseed = seed(3052);
#local FrameX = 0.35;
#local FrameY = 0.35;
#local FrameWidth = 0.05;
#local InsideX = FrameX - FrameWidth;
#local InsideY = FrameY - FrameWidth;
#local FrameEdge = prism {
	linear_sweep
	cubic_spline
	-1, 1, 31
	<0,0>, <0,-0.001>, <0,-0.009>, <0,-0.01>, <0.001,-0.0105>, <0.004,-0.012>, <0.0042,-0.014>,
	<0.006,-0.017>, <0.008,-0.018>, <0.01,-0.018>, <0.01,-0.02>, <0.014,-0.028>, <0.02,-0.032>,
	<0.03,-0.032>, <0.036, -0.028>, <0.04,-0.02>, <0.042,-0.018>, <0.043,-0.017>, <0.045,-0.017>,
	<0.048,-0.014>, <0.05,-0.012>, <0.05,-0.01>, <0.05,-0.002>, <0.05,0>, <0.048,0>, <0.046,0>,
	<0.004,0>, <0.002,0>, <0,0>, <0,-0.001>, <0,-0.009>
}

#local LabelX = 0.20;
#local LabelY = 0.07;
#local LabelThick = 0.004;
#local LabelCutR = 0.02;
#local LabelInset = 0.01;
#local LabelInsetThick = 0.002;
#local LabelWood = 0.02;
#local LabelWoodThick = 0.02;
#local ScrewR = 0.005;
#local ScrewSlot = ScrewR / 8;
#declare PictureLabel = union {
	// wooden backplate
	union {
		// basic box
		difference {
			box { <-LabelX-LabelWood,-LabelY-LabelWood,-LabelWoodThick>, <LabelX+LabelWood,LabelY+LabelWood,0> }
			// screw holes
			cylinder { <-LabelX-LabelWood/2,-LabelY-LabelWood/2,-LabelWoodThick-0.001>, <-LabelX-LabelWood/2,-LabelY-LabelWood/2,0>, ScrewR }
			cylinder { <LabelX+LabelWood/2,-LabelY-LabelWood/2,-LabelWoodThick-0.001>, <LabelX+LabelWood/2,-LabelY-LabelWood/2,0>, ScrewR }
			cylinder { <-LabelX-LabelWood/2,LabelY+LabelWood/2,-LabelWoodThick-0.001>, <-LabelX-LabelWood/2,LabelY+LabelWood/2,0>, ScrewR }
			cylinder { <LabelX+LabelWood/2,LabelY+LabelWood/2,-LabelWoodThick-0.001>, <LabelX+LabelWood/2,LabelY+LabelWood/2,0>, ScrewR }
		}
		// rounded edges
		cylinder { <-LabelX-LabelWood,-LabelY-LabelWood,0>, <-LabelX-LabelWood,LabelY+LabelWood,0>, LabelWoodThick }
		cylinder { <LabelX+LabelWood,-LabelY-LabelWood,0>, <LabelX+LabelWood,LabelY+LabelWood,0>, LabelWoodThick }
		cylinder { <-LabelX-LabelWood,-LabelY-LabelWood,0>, <LabelX+LabelWood,-LabelY-LabelWood,0>, LabelWoodThick }
		cylinder { <-LabelX-LabelWood,LabelY+LabelWood,0>, <LabelX+LabelWood,LabelY+LabelWood,0>, LabelWoodThick }
		// rounded corners
		intersection {
			cylinder { <-LabelX-LabelWood,-LabelY-LabelWood-LabelWoodThick,0>, <-LabelX-LabelWood,LabelY+LabelWood,0>, LabelWoodThick }
			cylinder { <-LabelX-LabelWood-LabelWoodThick,-LabelY-LabelWood,0>, <LabelX+LabelWood,-LabelY-LabelWood,0>, LabelWoodThick }
		}
		intersection {
			cylinder { <-LabelX-LabelWood,-LabelY-LabelWood,0>, <-LabelX-LabelWood,LabelY+LabelWood+LabelWoodThick,0>, LabelWoodThick }
			cylinder { <-LabelX-LabelWood-LabelWoodThick,LabelY+LabelWood,0>, <LabelX+LabelWood,LabelY+LabelWood,0>, LabelWoodThick }
		}
		intersection {
			cylinder { <LabelX+LabelWood,-LabelY-LabelWood-LabelWoodThick,0>, <LabelX+LabelWood,LabelY+LabelWood,0>, LabelWoodThick }
			cylinder { <-LabelX-LabelWood,-LabelY-LabelWood,0>, <LabelX+LabelWood+LabelWoodThick,-LabelY-LabelWood,0>, LabelWoodThick }
		}
		intersection {
			cylinder { <LabelX+LabelWood,-LabelY-LabelWood,0>, <LabelX+LabelWood,LabelY+LabelWood+LabelWoodThick,0>, LabelWoodThick }
			cylinder { <-LabelX-LabelWood,LabelY+LabelWood,0>, <LabelX+LabelWood+LabelWoodThick,LabelY+LabelWood,0>, LabelWoodThick }
		}
		// woodgrain
		texture {
			pigment { wood
				colour_map {
					[0.00 rgb <0.3,0.1,0.0>]
					[0.05 rgb <0.3,0.1,0.0>]
					[0.1 rgb <0.4,0.2,0.1>]
					[0.5 rgb <0.5,0.25,0.2>]
					[1.0 rgb <0.45,0.25,0.15>]
				}
				rotate <-3,90,3>
				scale 0.01
				turbulence 0.1
				omega 0.2
			}
		}
		// shiny varnish
		texture {
			pigment { rgbf <1,1,1,1> }
			finish {
				reflection 0.2
				specular 0.7
				roughness 0.005
			}
		}
	}
	// screws
	union {
		difference {
			cylinder { <0,0,-LabelWoodThick>, <0,0,0>, ScrewR }
			box { <-ScrewSlot,-ScrewR,-LabelWoodThick-0.001>, <ScrewSlot,ScrewR,-LabelWoodThick+0.005>
				rotate <0,0,32>
			}
			translate <-LabelX-LabelWood/2,-LabelY-LabelWood/2,0>
		}
		difference {
			cylinder { <0,0,-LabelWoodThick>, <0,0,0>, ScrewR }
			box { <-ScrewSlot,-ScrewR,-LabelWoodThick-0.001>, <ScrewSlot,ScrewR,-LabelWoodThick+0.005>
				rotate <0,0,156>
			}
			translate <LabelX+LabelWood/2,-LabelY-LabelWood/2,0>
		}
		difference {
			cylinder { <0,0,-LabelWoodThick>, <0,0,0>, ScrewR }
			box { <-ScrewSlot,-ScrewR,-LabelWoodThick-0.001>, <ScrewSlot,ScrewR,-LabelWoodThick+0.005>
				rotate <0,0,209>
			}
			translate <-LabelX-LabelWood/2,LabelY+LabelWood/2,0>
		}
		difference {
			cylinder { <0,0,-LabelWoodThick>, <0,0,0>, ScrewR }
			box { <-ScrewSlot,-ScrewR,-LabelWoodThick-0.001>, <ScrewSlot,ScrewR,-LabelWoodThick+0.005>
				rotate <0,0,317>
			}
			translate <LabelX+LabelWood/2,LabelY+LabelWood/2,0>
		}
		texture {
			pigment { rgb <1,0.9,0.6> }
			finish {
				reflection 0.5
				specular 0.9
				roughness 0.0001
				metallic
			}
		}
	}
	// metal frontplate
	difference {
		box { <-LabelX,-LabelY,-LabelThick>, <LabelX,LabelY,0> }
		// cut off corners
		cylinder { <-LabelX,-LabelY,-LabelThick-0.1>, <-LabelX,-LabelY,0.1>, LabelCutR }
		cylinder { <LabelX,-LabelY,-LabelThick-0.1>, <LabelX,-LabelY,0.1>, LabelCutR }
		cylinder { <-LabelX,LabelY,-LabelThick-0.1>, <-LabelX,LabelY,0.1>, LabelCutR }
		cylinder { <LabelX,LabelY,-LabelThick-0.1>, <LabelX,LabelY,0.1>, LabelCutR }
		
		// text
		text { ttf "C:\WINDOWS\FONTS\palatino.TTF" "St Paul's Cathedral" 0.002, 0
			scale <0.03,0.03,1>
			translate <-0.122,0.02,-LabelThick-0.001>
			texture {
				pigment { rgb <0,0,0> }
			}
		}
		text { ttf "C:\WINDOWS\FONTS\palatino.TTF" "in the London Blitz" 0.002, 0
			scale <0.03,0.03,1>
			translate <-0.125,-0.01,-LabelThick-0.001>
			texture {
				pigment { rgb <0,0,0> }
			}
		}
		text { ttf "C:\WINDOWS\FONTS\palatino.TTF" "Pen, ink and wash - artist unknown" 0.002, 0
			scale <0.02,0.02,1>
			translate <-0.157,-0.04,-LabelThick-0.001>
			texture {
				pigment { rgb <0,0,0> }
			}
		}
		
		// etch border
		union {
			box { <-LabelX+LabelInset,-LabelY+LabelCutR+LabelInset,-LabelThick-0.001>, <-LabelX+LabelInset+LabelInsetThick,LabelY-LabelCutR-LabelInset,-LabelThick+0.001> }
			box { <LabelX-LabelInset,-LabelY+LabelCutR+LabelInset,-LabelThick-0.001>, <LabelX-LabelInset-LabelInsetThick,LabelY-LabelCutR-LabelInset,-LabelThick+0.001> }
			box { <-LabelX+LabelCutR+LabelInset,-LabelY+LabelInset,-LabelThick-0.001>, <LabelX-LabelCutR-LabelInset,-LabelY+LabelInset+LabelInsetThick,-LabelThick+0.001> }
			box { <-LabelX+LabelCutR+LabelInset,LabelY-LabelInset,-LabelThick-0.001>, <LabelX-LabelCutR-LabelInset,LabelY-LabelInset-LabelInsetThick,-LabelThick+0.001> }
			difference {
				cylinder { <-LabelX,-LabelY,-LabelThick-0.001>, <-LabelX,-LabelY,-LabelThick+0.001>, LabelCutR+LabelInset+LabelInsetThick }
				cylinder { <-LabelX,-LabelY,-LabelThick-0.001>, <-LabelX,-LabelY,-LabelThick+0.001>, LabelCutR+LabelInset }
				plane { x, -LabelX+LabelInset }
				plane { y, -LabelY+LabelInset }
			}
			difference {
				cylinder { <LabelX,-LabelY,-LabelThick-0.001>, <LabelX,-LabelY,-LabelThick+0.001>, LabelCutR+LabelInset+LabelInsetThick }
				cylinder { <LabelX,-LabelY,-LabelThick-0.001>, <LabelX,-LabelY,-LabelThick+0.001>, LabelCutR+LabelInset }
				plane { -x, -LabelX+LabelInset }
				plane { y, -LabelY+LabelInset }
			}
			difference {
				cylinder { <LabelX,LabelY,-LabelThick-0.001>, <LabelX,LabelY,-LabelThick+0.001>, LabelCutR+LabelInset+LabelInsetThick }
				cylinder { <LabelX,LabelY,-LabelThick-0.001>, <LabelX,LabelY,-LabelThick+0.001>, LabelCutR+LabelInset }
				plane { -x, -LabelX+LabelInset }
				plane { -y, -LabelY+LabelInset }
			}
			difference {
				cylinder { <-LabelX,LabelY,-LabelThick-0.001>, <-LabelX,LabelY,-LabelThick+0.001>, LabelCutR+LabelInset+LabelInsetThick }
				cylinder { <-LabelX,LabelY,-LabelThick-0.001>, <-LabelX,LabelY,-LabelThick+0.001>, LabelCutR+LabelInset }
				plane { x, -LabelX+LabelInset }
				plane { -y, -LabelY+LabelInset }
			}
			texture {
				pigment { rgb <0,0,0> }
			}
		}
		// shiny silver
		texture {
			pigment { rgb <0.8,0.8,0.84> }
			normal { gradient y 0.1
				scale 0.001
			}
			finish {
				reflection 0.5
				specular 0.9
				roughness 0.0001
				metallic
			}
		}
		bounded_by {
			box { <-LabelX,-LabelY,-LabelThick>, <LabelX,LabelY,0> }
		}
		translate <0,0,-LabelWoodThick>
	}
}

// macro for generating pen lines
#local lineR = 0.2;
#macro line(x1,y1,x2,y2)
	cylinder { <x1,y1,0>, <x2,y2,0>, lineR
		texture {
			pigment { rgb <0,0,0> }
		}
	}
#end

// macro for generating colour wash
#macro Colour(the_colour,the_scale)
	sphere { <0,0,0>, 1
		hollow
		texture {
			pigment { rgbt <1,1,1,1> }
		}
		interior {
			media {
				emission rgb the_colour/0.0025
	            density { spherical
	                colour_map{
	                    [0.0 rgb <0,0,0>]
	                    [0.2 rgb <1,1,1>]
	                    [1.0 rgb <1,1,1>]
	                }
	                turbulence 0.7
	                lambda 2.5
	                omega 0.3
	            }
				scale InsideX
			}
		}
		no_shadow
		rotate <360*rand(pictureseed),360*rand(pictureseed),360*rand(pictureseed)>
		scale <InsideX,InsideY,0.0025>*the_scale
		translate <0,FrameY,-0.0025>
	}
#end

// the picture object
#declare Picture = union {
	// frame
	union {
		difference {
			object { FrameEdge }
			plane { <1,1,0>, FrameY/sqrt(2) inverse }
			plane { <1,-1,0>, FrameY/sqrt(2) inverse }
			translate <-FrameX,FrameY,0>
		}
		difference {
			object { FrameEdge rotate <0,0,180> }
			plane { <-1,1,0>, FrameY/sqrt(2) inverse }
			plane { <-1,-1,0>, FrameY/sqrt(2) inverse }
			translate <FrameX,FrameY,0>
		}
		difference {
			object { FrameEdge rotate <0,0,90> }
			plane { <-1,1,0>, FrameX/sqrt(2) inverse }
			plane { <1,1,0>, FrameX/sqrt(2) inverse }
			translate <0,0,0>
		}
		difference {
			object { FrameEdge rotate <0,0,-90> }
			plane { <-1,-1,0>, FrameX/sqrt(2) inverse }
			plane { <1,-1,0>, FrameX/sqrt(2) inverse }
			translate <0,2*FrameY,0>
		}
		texture {
			pigment { rgb <1,0.7,0.5> }
			finish {
				reflection 0.1
				specular 0.5
				roughness 0.01
			}
		}
	}
	// paper
	box { <-FrameX,0,-0.0001>, <FrameX,2*FrameY,0>
		texture {
			pigment { rgb <0.3,0.3,0.3> }
		}
	}
	// drawing
	union {
		// steeple at left
		line(7.5,26,32.5,27.4)
		line(29,26,34,26.3)
		line(33.7,26.3,33.5,28.8)
		line(31.2,28.7,33.8,28.8)
		line(32.2,7.2,32.4,26.9)
		line(11,29.2,37,29.7)
		line(28.4,29.7,28.1,35)
		line(10.6,30.1,10.9,33.5)
		line(10,33.2,29.1,34.2)
		line(11,35,28,35.4)
		line(11,27.5,10.5,52.3)
		line(12.9,34.1,11.7,51)
		line(14.3,36,14,44.8)
		line(16.6,35.7,17,49.5)
		line(18.7,36.2,18.1,49.6)
		line(21.3,36.1,21.3,49.4)
		line(24.5,36.2,24.6,50.7)
		line(26.3,36,27,51.5)
		line(16,49.6,22.5,50)
		line(12.3,50.7,27.7,51.5)
		line(14,50.5,26,52)
		line(12,52,25,53.8)
		line(12.5,53.5,12.1,58)
		line(14.6,54.4,14.3,57.3)
		line(16.2,55.2,16,57.2)
		line(17.9,55,17.9,57)
		line(19.2,53,19,55)
		line(20.5,53.8,20,57)
		line(22.4,53.6,22.2,58.1)
		line(23.8,54,24.3,57.4)
		line(25.2,53,25.1,59)
		line(12,58.5,24.4,58)
		line(14,58.5,14.6,61.3)
		line(16,58.6,16,61)
		line(16.5,57.3,15.5,66)
		line(15.5,66,20,81)
		line(23.2,59,23.7,67.6)
		line(23.3,67.7,20.3,79.4)
		line(21.6,61.3,21.4,65.7)
		line(22.5,62,22.5,67.3)
		line(17.6,61.5,17,66.3)
		line(20.2,61.1,20,67)
		line(17.1,67,21,67.4)
		// roofline below
		line(42,8.8,114,8)
		line(44,9,73,26)
		line(73,27,100,8)
		line(54.6,12,86,10.5)
		line(44,9,44,15.4)
		line(45.4,9,45.8,12.7)
		line(44,12,45.5,12)
		line(44.9,12,44.5,14.2)
		line(72.5,21.4,72.3,32)
		line(74,27,73.5,32)
		line(71.6,32.7,74.6,32.3)
		line(111,14.1,119,13.5)
		line(118,13.6,118.8,6.3)
		line(119.2,5.2,128.8,5.6)
		line(129.1,5.7,129,10.5)
		line(129.4,10.6,136,10.7)
		line(135.2,11,134.8,7.9)
		line(134.8,7.3,145.7,6.9)
		line(143,6.2,142.3,9.1)
		line(142.3,9.1,144.1,9.3)
		line(144.2,9,144,7)
		line(145.7,7,145,0)
		line(144.8,1.2,150,1.1)
		/*  removed to fit picture inside 150*150 units
		line(144.8,1.2,169.5,1)
		line(169,2,168.7,5.8)
		line(169,5.3,175,6)
		line(176.1,5.4,170.6,1)
		line(171,3,179,3.1)
		*/
		// right steeple
		line(92.5,25,117.5,26.4)
		line(114,25,119,25.3)
		line(118.7,25.3,118.5,27.8)
		line(116.2,27.7,118.8,27.8)
		line(117.2,6.2,117.4,25.9)
		line(96,28.2,122,28.7)
		line(113.4,28.7,113.1,34)
		line(95.6,29.1,95.9,32.5)
		line(95,32.2,114.1,33.2)
		line(96,34,113,34.4)
		line(96,26.5,95.5,51.3)
		line(97.9,33.1,96.7,50)
		line(99.3,35,99,43.8)
		line(101.6,34.7,102,48.5)
		line(103.7,35.2,103.1,48.6)
		line(106.3,35.1,106.3,48.4)
		line(109.5,35.2,109.6,49.7)
		line(111.3,35,112,50.5)
		line(101,48.6,107.5,49)
		line(97.3,49.7,112.7,50.5)
		line(99,49.5,111,51)
		line(97,51,110,52.8)
		line(97.5,52.5,97.1,57)
		line(99.6,53.4,99.3,56.3)
		line(101.2,54.2,101,56.2)
		line(102.9,54,102.9,56)
		line(104.2,52,104,54)
		line(105.5,52.8,105,56)
		line(107.4,52.6,107.2,57.1)
		line(108.8,53,109.3,56.4)
		line(110.2,52,110.1,58)
		line(97,57.5,109.4,57)
		line(99,57.5,99.6,60.3)
		line(101,57.6,101,60)
		line(101.5,56.3,100.5,65)
		line(100.5,65,105,80)
		line(108.2,58,108.7,66.6)
		line(108.3,66.7,105.3,78.4)
		line(106.6,60.3,106.4,64.7)
		line(107.5,61,107.5,66.3)
		line(102.6,60.5,102,65.3)
		line(105.2,60.1,105,66)
		line(102.1,66,106,66.4)
		// main dome
		// columns and cylinders above
		line(37.8,8,37,29)
		line(35.5,28,55,30)
		line(61.5,30.3,71.2,30)
		line(75,29.5,97,28)
		line(50.5,29.5,49.5,52)
		line(52.7,31,51,51)
		line(55.2,30.8,54.3,51.4)
		line(56.6,30.5,55.5,50.6)
		line(60,31,60,52.2)
		line(62.2,31.5,61.7,50.4)
		line(67,33,67,52.4)
		line(68.1,31,69,51)
		line(74,35,73.6,53)
		line(75.4,29.5,75,51)
		line(81.8,33.8,81,53)
		line(84,31.3,84.1,52.2)
		line(89,28.8,90,52.3)
		line(91.3,30,91.8,52)
		line(45.7,50.8,75,53.3)
		line(75,53.3,95,54.1)
		line(48,52.6,75,56)
		line(75,56,95.2,56)
		line(48.5,52,48.8,56)
		line(52,57,70,60.5)
		line(70,60.5,84,61.2)
		line(84,61.2,96,59)
		// windows area
		line(53.3,57.7,52.5,68.2)
		line(59.1,58.8,58,69.5)
		line(60.7,59.1,59.8,68)
		line(65.4,59.4,64.5,69.2)
		line(66.5,60,66,68.8)
		line(72.4,60.5,71.3,69.8)
		line(73.5,61.2,73.3,69)
		line(80,61,79.7,69.8)
		line(81,61.1,81.4,69.5)
		line(87.5,60.9,87,70.5)
		line(88.3,60.4,89,70)
		line(95,59.6,94.7,69)
		line(95.5,59,96.2,70)
		line(55.2,58.6,55,60.1)
		line(56.2,59.1,56.5,60.5)
		line(57.4,58.9,58.4,60.1)
		line(61.2,59.3,61.1,60.6)
		line(62.2,59.9,62,61)
		line(63.5,60,63.2,61.1)
		line(67.6,60.2,67.8,61.8)
		line(69,60.8,69,62)
		line(71.3,60.6,70.1,62)
		line(75.6,61,75.9,62.6)
		line(76.8,61,76.9,62.4)
		line(77.9,61.2,77.8,62.4)
		line(83,61.1,83.1,62.1)
		line(84,61,84,62)
		line(85,60.9,85.1,61.8)
		line(90.9,60.3,91,61.8)
		line(91.8,60,92,61.5)
		line(93.1,60,92.8,61.4)
		line(97.2,59.4,97.1,61.2)
		line(98.3,59.9,98.4,61.3)
		line(99.3,60,99.3,61.1)
		// actual windows
		line(54.8,64.6,56.7,64.5)
		line(56.7,64.5,56.3,68)
		line(56.3,68,54.5,67.2)
		line(54.5,67.2,54.7,65.4)
		line(61.1,64.5,63.7,64.5)
		line(63.7,64.5,63,68.2)
		line(63,68.2,61.1,68.2)
		line(61.1,68.2,61.6,65.6)
		line(67.9,65.2,70.4,65.3)
		line(70.4,65.3,70,68.3)
		line(70,68.3,67.5,68.1)
		line(67.5,68.1,68,66.3)
		line(75.8,69,75.9,65.7)
		line(75.9,65.7,78.1,65.4)
		line(78.1,65.4,77.6,68.5)
		line(77.6,68.5,75.3,68.2)
		line(83,65.6,86,65.3)
		line(86,65.3,85.4,68.9)
		line(85.4,68.9,83,68.5)
		line(83,68.5,83.2,66.8)
		line(90,65.1,93.9,65.4)
		line(93.9,65.4,92.5,68.7)
		line(92.5,68.7,90.6,68.8)
		line(90.6,68.8,90.8,66.6)
		line(97.5,64.8,99.7,64.5)
		line(99.7,64.5,99.3,68)
		line(99.3,68,97.8,68)
		line(97.8,68,97.8,65.4)
		// lines above windows
		line(53.8,69.4,65,70.7)
		line(65,70.7,90,71)
		line(90,71,101,69.9)
		line(56,71,69,72.4)
		line(69,72.4,102,72)
		line(56,73.1,65,73.9)
		line(65,73.9,69.3,73.4)
		line(66,74.2,73,75)
		line(73,75,94,75)
		// dome itself
		line(55,70.6,55.2,80)
		line(55.2,80,60,94.4)
		line(60,94.4,65.5,100)
		line(65.5,100,73.5,104.8)
		line(73.5,104.8,82,105.7)
		line(82,105.7,92.7,103)
		line(92.7,103,100,97)
		line(100,97,106,86)
		line(106,86,107.2,78)
		line(56.3,75,57.6,83)
		line(57.6,83,63.2,93)
		line(63.2,93,70,100)
		line(70,100,74,103.1)
		line(59,76,60,83)
		line(60,83,63.4,90)
		line(63.4,90,70,98)
		line(70,98,75.8,103.4)
		line(62.4,76,64.3,85)
		line(64.3,85,67,91.4)
		line(67,91.4,73,100)
		line(73,100,77,103.6)
		line(65,76,66,84)
		line(66,84,67.3,90)
		line(67.3,90,73,98.4)
		line(73,98.4,76,102.5)
		line(76,102.5,79,104.1)
		line(67.8,75.8,67.6,80)
		line(67.6,80,69,88.3)
		line(69,88.3,72.1,96)
		line(72.1,96,77,102)
		line(69.1,75.7,70,86)
		line(70,86,74,95.6)
		line(74,95.6,79,103.2)
		line(79,103.2,81,104.8)
		line(71.3,76,74,86.1)
		line(74,86.1,78,98)
		line(78,98,81.1,104.2)
		line(77.3,78.2,77.2,84.3)
		line(77.2,84.3,80.2,101.3)
		line(80.8,76.9,81.6,85)
		line(81.6,85,81.8,98)
		line(81.8,98,81.5,102)
		line(86.5,76.7,86,89)
		line(86,89,85,95)
		line(85,95,82.6,101)
		line(93,77,90,87)
		line(90,87,86.2,98)
		line(86.2,98,83,102)
		line(96.4,76.4,93,86.2)
		line(93,86.2,89.1,95)
		line(89.1,95,86.7,99.1)
		line(100.1,76.4,98.8,83)
		line(98.8,83,92.4,94)
		line(92.4,94,87.7,100)
		line(87.7,100,83,103.4)
		line(103.7,76,103,80.4)
		line(103,80.4,95,94.6)
		line(95,94.6,91.4,100)
		line(91.4,100,86.4,103)
		line(105.6,79,105.5,82)
		line(105.5,82,98.1,95)
		line(98.1,95,93,100.4)
		line(93,100.4,86,104.2)
		// lantern
		line(76.8,104.9,77.1,107.4)
		line(86,104.6,85.6,107.9)
		line(78.3,107.8,86,108)
		line(78.6,107.6,77.5,119.5)
		line(80,109.2,79.2,120.2)
		line(81,111,80.5,117.4)
		line(81.5,110.7,80.6,118.8)
		line(82.3,110.9,82,117.2)
		line(82,117.2,80.5,117.4)
		line(84.4,108.4,83.2,120)
		line(85.8,111,85.1,120)
		line(81.2,108.6,81,109.9)
		line(81,109.9,82,109.9)
		line(82,109.9,82,109)
		line(81.4,108.9,81.5,109.9)
		line(77.5,120.8,76.9,122.1)
		line(84.9,122,84.6,123.3)
		line(85.2,120.8,86,123.3)
		line(78.3,120.6,84.8,121.6)
		line(84.8,121.6,78.9,122.6)
		line(78.9,122.6,83.6,123.1)
		line(79.4,123.4,79,127)
		line(83,123.9,82.3,128)
		line(82.3,128,79.5,127.6)
		line(80,123.9,81.4,124.1)
		line(80.1,124.4,81.5,124.4)
		line(80.5,126,81.5,126)
		line(80.4,126.7,81.6,126.6)
		// cross
		line(79.6,128,79.4,129)
		line(79.4,129,80,130.4)
		line(80,130.4,81.2,130.8)
		line(81.2,130.8,82.6,130)
		line(82.6,130,82.6,128.8)
		line(80.9,131.1,80.3,140.3)
		line(78.9,138.8,81.6,139.1)
		line(80,132.2,80,133.6)
		line(80,133.6,81,133.9)
		line(81,133.9,81.4,133)
		line(81.4,133,81,132.1)
		line(81,132.1,80,132.2)
		line(81.4,135.1,79.6,135.5)
		line(79.6,135.5,80.5,136.4)
		line(80.5,136.4,81.2,136)
		line(81.2,136,80.6,135.2)
		line(80.6,135.2,81.4,135.1)

		// scale and translate
		scale 2*InsideX/150
		translate <-InsideX,FrameWidth,-0.005>
		no_shadow
	}
	// colouring
	union {
		// red glow low right
		object { Colour(<1,0,0>,<0.6,0.4,1>)
			translate <0.23,-0.22,0>
		}
		// whitish cloud upper left
		object { Colour(<0.9,0.7,0.65>,<2.2,1.5,1>)
			translate <-0.1,0.22,0>
		}
		// pink cloud upper right
		object { Colour(<0.9,0.55,0.5>,<2,2.1,1>)
			translate <0.23,0.15,0>
		}
		// dark pink mid right
		object { Colour(<0.7,0.4,0.35>,<1.4,1.8,1>)
			translate <0.24,-0.11,0>
		}
		// orange mid left
		object { Colour(<0.8,0.52,0.45>,<1.1,2.1,1>)
			translate <-0.13,0.05,0>
		}
		// pink-orange far left
		object { Colour(<0.8,0.55,0.4>,<0.7,2.1,1>)
			translate <-0.26,0.05,0>
		}
		// dark brown of dome right
		object { Colour(<0.2,0.13,0.1>,<0.7,0.9,1>)
			translate <0.06,0.07,0>
		}
		// light brown of dome left
		object { Colour(<0.4,0.3,0.2>,<0.6,0.7,1>)
			translate <-0.02,0.07,0>
		}
		// dark red above bright red glow right
		object { Colour(<0.5,0,0>,<0.8,0.6,1>)
			translate <0.27,-0.18,0>
		}
		// white area at left side of columns area
		object { Colour(<0.9,0.8,0.8>,<0.6,1.2,1>)
			translate <-0.06,-0.10,0>
		}
		// greyer area at centre of columns area
		object { Colour(<0.6,0.52,0.52>,<0.6,1.2,1>)
			translate <0.0,-0.10,0>
		}
		// darker grey area at right of columns area
		object { Colour(<0.3,0.25,0.25>,<0.6,1.2,1>)
			translate <0.06,-0.10,0>
		}
		// light grey of lantern
		object { Colour(<0.6,0.52,0.52>,<0.2,0.5,1>)
			translate <0.025,0.14,0>
		}
		// light grey of left steeple
		object { Colour(<0.6,0.52,0.52>,<0.4,0.6,1>)
			translate <-0.22,-0.16,0>
		}
		// dim dark pink cloud at bottom
		object { Colour(<0.7,0.4,0.35>,<3,0.6,1>)
			rotate <0,0,-10>
			translate <0.02,-0.27,0>
		}
		clipped_by {
			box { <-InsideX,FrameWidth,-0.005>, <InsideX,FrameWidth+2*InsideY,0> }
		}
		bounded_by { clipped_by }
	}
}
