// stpauls.inc
// St Paul's Cathedral, London
// Ground level under dome = <0,0,0>

// stuff on top of dome
#local Cyl1R = 5.4;
#local Cyl1H = 1.2;
#local Cyl2R = 5.6;
#local Cyl2H = 0.2;
#local LBaseRect1 = 2.375;
#local LBaseRect2 = 3.875;
#local LBaseRectH = 3.45;
#local LBaseDoorW = 0.45;
#local LBaseDoorH = 3.00;
#local LBaseRectEdge = 0.35;
#local LBaseRectHH = 10;
#local LBaseColCut = 0.9;
#local LBaseRectColH = LBaseRectH + LBaseRectEdge + 0.6;
#local LBaseRectColHH = LBaseRectHH - 1.6;
#local LBaseHoleW = 0.65;
#local LBaseHoleH = 1.0;
#local LBaseHoleD = 1;
#local LBaseTurretH = 1.6;
#local LTopRect1 = 1.29;
#local LTopRect2 = 2.5;
#local LTopRectH = 4.06;
#local LTopHoleR = 0.52;
#local LTopHoleH = 2.6;
#local LTopRectEdge = 0.22;
#local LTopGoldH = 0.65;
#local LTopDomeH = 3;
#local CrossH = 9.1;
#local CrossX = 1.72;
#local CrossR = 0.34;
#local BallR = 0.97;
#local BallH = 4.32;
#local GoldCylH = 1.28;
// dome
#local DomeR = 19;
#local DomeH = 20.5;
#local DomeZ = 50; // height of centre of dome
#local DomeSym = 28; // order or radial symmetry of dome
#local LanternZ = DomeZ + DomeH - 0.5;
// small grey cylinders just below dome
#local DomeCylH = 1.2;
#local DomeCylR1 = 19.5;
#local DomeCylR2 = 20.5;
#local DomeCylTorR = 0.1;
#local RibR = 0.4;
// big white cylinder just below dome
#local CylH = 10.3;
#local CylR = 21;
#local CylLipH = 0.6;
#local CylLipR = 21.4;
#local CylWinW = 2;
#local CylWinH = 3;
#local CylWinTop = 1.5;
#local CylWinSill = 0.28;
#local CylBarW = 1;
// lip and railing at bottom of big white cylinder
#local LipR = 26;
#local LipH = 0.3;
#local RailR = 25;
#local RailH1 = 1.2;
#local RailH2 = 2.9;
#local RailH3 = 3.1;
#local RailT = 0.5;
#local RailBlockW = 1;
#local RailDownH = 1.7;
// columns
#local ColumnH = 13.6;
#local ColumnR = 0.65;
// base
#local BaseH = 5.7;

#local seedSP = seed(9181);

// ***** TEXTURES *****

// macro to slightly randomise colour of all marble surfaces
#macro Marble()
	#local grey = 0.1*rand(seedSP);
	texture {
		pigment { rgb <0.85+grey+0.05*rand(seedSP),0.8+grey+0.05*rand(seedSP),0.8+grey+0.05*rand(seedSP)> }
		normal { brick 0.06
			scale 0.2
		}
	}
	// dirt layer
	texture {
		pigment { bozo
			colour_map {
				[0.0 rgbt <1,1,1,1>]
				[0.9 rgbt <1,1,1,1>]
				[0.95 rgbt <0.5,0.46,0.43,0.7>]
				[1.0 rgbt <0.4,0.35,0.34,0>]
			}
			scale <1,10,1>
			turbulence 0.9
			omega 0.7
			lambda 3.0
		}
	}
#end

// dome pigments
#local P_DomeBase = pigment { gradient y
	colour_map {
		[0.0 rgb <0.4,0.37,0.36>]
		[0.1 rgb <0.7,0.60,0.55>]
		[1.0 rgb <0.7,0.60,0.55>]
	}
	scale DomeH/10
	translate -DomeH
}

#local P_clear = pigment {
	rgbf <1,1,1,1>
}
#local P_grey = pigment {
	rgbf <0,0,0,0.7>
}
#local P_black = pigment {
	rgbf <0,0,0,0.4>
}
/*
#local P_black = pigment { gradient y
	colour_map {
		[0.0 rgbf <0,0,0,0.2>]
		[0.3 rgbf <0,0,0,0.2>]
		[0.5 rgbf <0.3,0.3,0.3,0.7>]
		[1.0 rgbf <1,1,1,1>]
	}
	scale DomeH
	translate <0,DomeZ,0>
}
*/
#local P_thickblack = pigment { radial
	pigment_map {
		[0.0 P_grey]
		[0.3 P_black]
		[1.0 P_black]
	}
	frequency 150
	sine_wave
}
#local P_thinblack = pigment { radial
	pigment_map {
		[0.0 P_clear]
		[0.8 P_grey]
		[1.0 P_grey]
	}
	frequency 150
	sine_wave
}
#local P_Dome01 = pigment { gradient y
	pigment_map {
		[0.0 P_thickblack]
		[0.3 P_thickblack]
		[0.5 P_thinblack]
		[1.0 P_thinblack]
	}
	scale DomeH
	translate <0,DomeZ,0>
}
#local P_Dome02 = pigment { gradient y
	pigment_map {
		[0.0 P_thickblack]
		[0.3 P_thickblack]
		[0.45 P_thinblack]
		[1.0 P_thinblack]
	}
	scale DomeH
	translate <0,DomeZ,0>
}
#local P_Dome03 = pigment { gradient y
	pigment_map {
		[0.0 P_thickblack]
		[0.28 P_thickblack]
		[0.42 P_thinblack]
		[1.0 P_thinblack]
	}
	scale DomeH
	translate <0,DomeZ,0>
}
#local P_Dome04 = pigment { gradient y
	pigment_map {
		[0.0 P_thickblack]
		[0.25 P_thickblack]
		[0.39 P_thinblack]
		[1.0 P_thinblack]
	}
	scale DomeH
	translate <0,DomeZ,0>
}
#local P_Dome05 = pigment { gradient y
	pigment_map {
		[0.0 P_thickblack]
		[0.46 P_thickblack]
		[0.75 P_thinblack]
		[1.0 P_thinblack]
	}
	scale DomeH
	translate <0,DomeZ,0>
}
#local P_Dome06 = pigment { gradient y
	pigment_map {
		[0.0 P_thickblack]
		[0.26 P_thickblack]
		[0.43 P_thinblack]
		[1.0 P_thinblack]
	}
	scale DomeH
	translate <0,DomeZ,0>
}
#local P_Dome07 = pigment { gradient y
	pigment_map {
		[0.0 P_thickblack]
		[0.22 P_thickblack]
		[0.41 P_thinblack]
		[1.0 P_thinblack]
	}
	scale DomeH
	translate <0,DomeZ,0>
}
#local P_Dome08 = pigment { gradient y
	pigment_map {
		[0.0 P_thickblack]
		[0.19 P_thickblack]
		[0.28 P_thinblack]
		[1.0 P_thinblack]
	}
	scale DomeH
	translate <0,DomeZ,0>
}
#local P_Dome09 = pigment { gradient y
	pigment_map {
		[0.0 P_thickblack]
		[0.37 P_thickblack]
		[0.69 P_thinblack]
		[1.0 P_thinblack]
	}
	scale DomeH
	translate <0,DomeZ,0>
}
#local P_Dome10 = pigment { gradient y
	pigment_map {
		[0.0 P_thickblack]
		[0.25 P_thickblack]
		[0.43 P_thinblack]
		[1.0 P_thinblack]
	}
	scale DomeH
	translate <0,DomeZ,0>
}
#local P_Dome11 = pigment { gradient y
	pigment_map {
		[0.0 P_thickblack]
		[0.22 P_thickblack]
		[0.36 P_thinblack]
		[1.0 P_thinblack]
	}
	scale DomeH
	translate <0,DomeZ,0>
}
#local P_Dome12 = pigment { gradient y
	pigment_map {
		[0.0 P_thickblack]
		[0.18 P_thickblack]
		[0.34 P_thinblack]
		[1.0 P_thinblack]
	}
	scale DomeH
	translate <0,DomeZ,0>
}
#local P_Dome13 = pigment { gradient y
	pigment_map {
		[0.0 P_thickblack]
		[0.15 P_thickblack]
		[0.30 P_thinblack]
		[1.0 P_thinblack]
	}
	scale DomeH
	translate <0,DomeZ,0>
}
#local P_Dome14 = pigment { gradient y
	pigment_map {
		[0.0 P_thickblack]
		[0.22 P_thickblack]
		[0.38 P_thinblack]
		[1.0 P_thinblack]
	}
	scale DomeH
	translate <0,DomeZ,0>
}

// grey cylinder inside columns pigments
#local P_Stripy = pigment { gradient y
	colour_map {
		[0.0 rgb <0.34,0.32,0.3>]
		[0.5 rgb <0.14,0.12,0.1>]
		[1.0 rgb <0.34,0.32,0.3>]
	}
	triangle_wave
	scale 0.05
}

#local P_Flat = pigment { rgb <0.24,0.22,0.2> }

// textures
#local T_Gold = texture {
	pigment { rgb <0.85,0.65,0.2> }
	finish {
		reflection 0.3
		phong 1
		metallic
	}
}

#local T_NotGold = texture {
	pigment { rgb <0.4,0.35,0.3> }
}

// column object
#local Column = union {
	cylinder { <0,0,0>, <0,ColumnH,0>, ColumnR }
	box { <-ColumnR,0,-ColumnR>, <ColumnR,2*ColumnR,ColumnR> }
}

// ***** THE CATHEDRAL OBJECT *****

#declare StPauls = union {
	// lantern structure
	// cylindrical base
	#local z1 = LanternZ;
	#local z2 = z1 + Cyl1H;
	cylinder { <0,z1,0>, <0,z2,0>, Cyl1R
		Marble()
	}
	#local z1 = z2;
	#local z2 = z1 + Cyl2H;
	cylinder { <0,z1,0>, <0,z2,0>, Cyl2R
		Marble()
	}
	// circular railing
	#local z1 = z2;
	#local z2 = z1 + Cyl1H;
	cylinder { <0,z1,0>, <0,z2,0>, Cyl1R
		texture {
			pigment { rgbt <1,0.8,0.5,0.5> }
		}
	}
	// lantern: marble base
	#local z1 = LanternZ+Cyl1H+Cyl2H;
	#local z2 = z1 + LBaseRectHH;
	difference {
		union {
			box { <-LBaseRect1,z1,-LBaseRect2>, <LBaseRect1,z2,LBaseRect2> }
			box { <-LBaseRect2,z1,-LBaseRect1>, <LBaseRect2,z2,LBaseRect1> }
		}
		// doors
		#local z2 = z1 + LBaseDoorH;
		box { <-LBaseDoorW,z1,-LBaseRect2-0.1>, <LBaseDoorW,z2,LBaseRect2+0.1> }
		box { <-LBaseRect2-0.1,z1,-LBaseDoorW>, <LBaseRect2+0.1,z2,LBaseDoorW> }
		// column niches
		#local z2 = z1 + LBaseRectColHH;
		#local z1 = z1 + LBaseRectColH;
		box { <LBaseRect1-LBaseColCut,z1,LBaseRect2-LBaseColCut>,   <LBaseRect1+0.1,z2,LBaseRect2+0.1> }
		box { <LBaseRect2-LBaseColCut,z1,LBaseRect1-LBaseColCut>,   <LBaseRect2+0.1,z2,LBaseRect1+0.1> }
		box { <-LBaseRect1+LBaseColCut,z1,LBaseRect2-LBaseColCut>,  <-LBaseRect1-0.1,z2,LBaseRect2+0.1> }
		box { <-LBaseRect2+LBaseColCut,z1,LBaseRect1-LBaseColCut>,  <-LBaseRect2-0.1,z2,LBaseRect1+0.1> }
		box { <LBaseRect1-LBaseColCut,z1,-LBaseRect2+LBaseColCut>,  <LBaseRect1+0.1,z2,-LBaseRect2-0.1> }
		box { <LBaseRect2-LBaseColCut,z1,-LBaseRect1+LBaseColCut>,  <LBaseRect2+0.1,z2,-LBaseRect1-0.1> }
		box { <-LBaseRect1+LBaseColCut,z1,-LBaseRect2+LBaseColCut>, <-LBaseRect1-0.1,z2,-LBaseRect2-0.1> }
		box { <-LBaseRect2+LBaseColCut,z1,-LBaseRect1+LBaseColCut>, <-LBaseRect2-0.1,z2,-LBaseRect1-0.1> }
		// big rectangular holes
		#local z1 = z1 + LBaseHoleH;
		union {
			box { <-LBaseHoleW,z1,-LBaseRect2-LBaseHoleD>, <LBaseHoleW,z2,-LBaseRect2+LBaseHoleD> }
			box { <-LBaseHoleW,z1,LBaseRect2-LBaseHoleD>, <LBaseHoleW,z2,LBaseRect2+LBaseHoleD> }
			box { <-LBaseRect2-LBaseHoleD,z1,-LBaseHoleW>, <-LBaseRect2+LBaseHoleD,z2,LBaseHoleW> }
			box { <LBaseRect2-LBaseHoleD,z1,-LBaseHoleW>, <LBaseRect2+LBaseHoleD,z2,LBaseHoleW> }
			texture {
				pigment { gradient y
					colour_map {
						[0.0 rgb <0.9,0.85,0.8>]
						[0.4 rgb <0.4,0.3,0.3>]
						[1.0 rgb <0.4,0.3,0.3>]
					}
					frequency 3
				}
			}
		}
		Marble()
	}
	// lantern: columns
	#local z1 = z1 - 0.01;
	#local z2 = LanternZ+Cyl1H+Cyl2H + LBaseRectHH + LBaseRectEdge + LBaseTurretH;
	#local x1 = LBaseColCut / 3;
	#local r = LBaseColCut / 4;
	cylinder { <LBaseRect1-x1,z1,LBaseRect2-x1>,   <LBaseRect1-x1,z2,LBaseRect2-x1>,   r Marble() }
	cylinder { <LBaseRect2-x1,z1,LBaseRect1-x1>,   <LBaseRect2-x1,z2,LBaseRect1-x1>,   r Marble() }
	cylinder { <-LBaseRect1+x1,z1,LBaseRect2-x1>,  <-LBaseRect1+x1,z2,LBaseRect2-x1>,  r Marble() }
	cylinder { <-LBaseRect2+x1,z1,LBaseRect1-x1>,  <-LBaseRect2+x1,z2,LBaseRect1-x1>,  r Marble() }
	cylinder { <LBaseRect1-x1,z1,-LBaseRect2+x1>,  <LBaseRect1-x1,z2,-LBaseRect2+x1>,  r Marble() }
	cylinder { <LBaseRect2-x1,z1,-LBaseRect1+x1>,  <LBaseRect2-x1,z2,-LBaseRect1+x1>,  r Marble() }
	cylinder { <-LBaseRect1+x1,z1,-LBaseRect2+x1>, <-LBaseRect1+x1,z2,-LBaseRect2+x1>, r Marble() }
	cylinder { <-LBaseRect2+x1,z1,-LBaseRect1+x1>, <-LBaseRect2+x1,z2,-LBaseRect1+x1>, r Marble() }
	// lantern: column tops
	#local z2 = LanternZ+Cyl1H+Cyl2H + LBaseRectHH + LBaseRectEdge + LBaseTurretH/6;
	#local r = LBaseColCut / 2;
	sphere { <LBaseRect1-x1,z2,LBaseRect2-x1>,   r Marble() }
	sphere { <LBaseRect2-x1,z2,LBaseRect1-x1>,   r Marble() }
	sphere { <-LBaseRect1+x1,z2,LBaseRect2-x1>,  r Marble() }
	sphere { <-LBaseRect2+x1,z2,LBaseRect1-x1>,  r Marble() }
	sphere { <LBaseRect1-x1,z2,-LBaseRect2+x1>,  r Marble() }
	sphere { <LBaseRect2-x1,z2,-LBaseRect1+x1>,  r Marble() }
	sphere { <-LBaseRect1+x1,z2,-LBaseRect2+x1>, r Marble() }
	sphere { <-LBaseRect2+x1,z2,-LBaseRect1+x1>, r Marble() }
	#local z2 = LanternZ+Cyl1H+Cyl2H + LBaseRectHH + LBaseRectEdge + LBaseTurretH*0.75;
	#local r = LBaseColCut / 3;
	sphere { <LBaseRect1-x1,z2,LBaseRect2-x1>,   r Marble() }
	sphere { <LBaseRect2-x1,z2,LBaseRect1-x1>,   r Marble() }
	sphere { <-LBaseRect1+x1,z2,LBaseRect2-x1>,  r Marble() }
	sphere { <-LBaseRect2+x1,z2,LBaseRect1-x1>,  r Marble() }
	sphere { <LBaseRect1-x1,z2,-LBaseRect2+x1>,  r Marble() }
	sphere { <LBaseRect2-x1,z2,-LBaseRect1+x1>,  r Marble() }
	sphere { <-LBaseRect1+x1,z2,-LBaseRect2+x1>, r Marble() }
	sphere { <-LBaseRect2+x1,z2,-LBaseRect1+x1>, r Marble() }
	// lantern base: first ledge
	#local z1 = LanternZ+Cyl1H+Cyl2H + LBaseRectH;
	#local z2 = z1 + LBaseRectEdge;
	box { <-LBaseRect1-LBaseRectEdge,z1,-LBaseRect2-LBaseRectEdge>, <LBaseRect1+LBaseRectEdge,z2,LBaseRect2+LBaseRectEdge> Marble() }
	box { <-LBaseRect2-LBaseRectEdge,z1,-LBaseRect1-LBaseRectEdge>, <LBaseRect2+LBaseRectEdge,z2,LBaseRect1+LBaseRectEdge> Marble() }
	// lantern base: top ledge
	#local z1 = z1 - LBaseRectH + LBaseRectHH;
	#local z2 = z1 + LBaseRectEdge;
	box { <-LBaseRect1-LBaseRectEdge,z1,-LBaseRect2-LBaseRectEdge>, <LBaseRect1+LBaseRectEdge,z2,LBaseRect2+LBaseRectEdge> Marble() }
	box { <-LBaseRect2-LBaseRectEdge,z1,-LBaseRect1-LBaseRectEdge>, <LBaseRect2+LBaseRectEdge,z2,LBaseRect1+LBaseRectEdge> Marble() }
	// lantern: marble top
	#local z1 = z2;
	#local z2 = z2 + LTopRectH;
	difference {
		prism { z1, z2, 9
			<-LTopRect1,-LTopRect2>, <-LTopRect2,-LTopRect1>, <-LTopRect2,LTopRect1>,
			<-LTopRect1,LTopRect2>, <LTopRect1,LTopRect2>, <LTopRect2,LTopRect1>,
			<LTopRect2,-LTopRect1>, <LTopRect1,-LTopRect2>, <-LTopRect1,-LTopRect2>
		}
		// holes
		#local z1 = z1 + LTopHoleH;
		cylinder { <0,z1,-LTopRect2-0.1>, <0,z1,LTopRect2+0.1>, LTopHoleR }
		cylinder { <-LTopRect2-0.1,z1,0>, <LTopRect2+0.1,z1,0>, LTopHoleR }
		Marble()
	}
	// lantern: ledge below gold
	#local z1 = z2;
	#local z2 = z2 + LTopRectEdge;
	prism { z1, z2, 9
		<-LTopRect1,-LTopRect2>, <-LTopRect2,-LTopRect1>, <-LTopRect2,LTopRect1>,
		<-LTopRect1,LTopRect2>, <LTopRect1,LTopRect2>, <LTopRect2,LTopRect1>,
		<LTopRect2,-LTopRect1>, <LTopRect1,-LTopRect2>, <-LTopRect1,-LTopRect2>
		scale <(LTopRect2+LTopRectEdge)/LTopRect2,1,(LTopRect2+LTopRectEdge)/LTopRect2>
		Marble()
	}
	// lantern: gold section of marble top
	#local z1 = z2;
	#local z2 = z2 + LTopGoldH;
	prism { z1, z2, 9
		<-LTopRect1,-LTopRect2>, <-LTopRect2,-LTopRect1>, <-LTopRect2,LTopRect1>,
		<-LTopRect1,LTopRect2>, <LTopRect1,LTopRect2>, <LTopRect2,LTopRect1>,
		<LTopRect2,-LTopRect1>, <LTopRect1,-LTopRect2>, <-LTopRect1,-LTopRect2>
		texture {
			pigment { rgb <0.85,0.65,0.2> }
			finish {
				reflection 0.3
				phong 1
				metallic
			}
		}
	}
	// lantern: ledge above gold
	#local z1 = z2;
	#local z2 = z2 + LTopRectEdge;
	prism { z1, z2, 9
		<-LTopRect1,-LTopRect2>, <-LTopRect2,-LTopRect1>, <-LTopRect2,LTopRect1>,
		<-LTopRect1,LTopRect2>, <LTopRect1,LTopRect2>, <LTopRect2,LTopRect1>,
		<LTopRect2,-LTopRect1>, <LTopRect1,-LTopRect2>, <-LTopRect1,-LTopRect2>
		scale <(LTopRect2+LTopRectEdge)/LTopRect2,1,(LTopRect2+LTopRectEdge)/LTopRect2>
		Marble()
	}
	// lantern: dome
	#local z1 = z2;
	#local c1 = <0.4,0.35,0.3>; 
	#local c2 = <0.7,0.6,0.5>; 
	sphere { <0,0,0>, LTopRect2
		scale <1,LTopDomeH/LTopRect2,1>
		translate <0,z1,0>
		texture {
			pigment { radial
				colour_map {
					[0.00 rgb c1]
					[0.30 rgb c1]
					[0.30 rgb c2]
					[0.37 rgb c2]
					[0.37 rgb c1]
					[0.63 rgb c1]
					[0.63 rgb c2]
					[0.70 rgb c2]
					[0.70 rgb c1]
					[1.00 rgb c1]
				}
				frequency 4
			}
		}
	}
	// lantern: gold cross
	#local z1 = z1 + LTopDomeH;
	#local z2 = z1 + CrossH;
	union {
		cylinder { <0,z1,0>, <0,z2,0>, CrossR }
		cylinder { <-CrossX,z2-CrossX,0>, <CrossX,z2-CrossX,0>, CrossR }
		#local z2 = z2 - CrossX;
		intersection {
			union {
				cylinder { <-CrossX,0,0>, <CrossX,0,0>, CrossR
					rotate <0,0,45>
					translate <0,z2,0>
				}
				cylinder { <-CrossX,0,0>, <CrossX,0,0>, CrossR
					rotate <0,0,-45>
					translate <0,z2,0>
				}
			}
			box { <-CrossX/2.5,z2-CrossX/2.5,-CrossR*2>, <CrossX/2.5,z2+CrossX/2.5,CrossR*2> }
		}
		#local z2 = z1+BallH;
		sphere { <0,z2,0>, BallR }
		cylinder { <0,z1,0>, <0,z2,0>, 1.5*CrossR }
		cylinder { <0,z2-1.3*BallR,0>,<0,z2-1.5*BallR,0>, 2*CrossR } 
		#local z2 = z1 + GoldCylH;
		cylinder { <0,z1-1,0>, <0,z2,0>, 2.6*CrossR }
		cylinder { <0,0.8*z1+0.2*z2,0>, <0,0.6*z1+0.4*z2,0>, 3.5*CrossR }
		sphere { <0,0,0>, 2.6*CrossR
			scale <1,1.5,1>
			translate <0,z2,0>
			texture { radial
				texture_map {
					[0.0 T_NotGold]
					[0.4 T_NotGold]
					[0.4 T_Gold]
					[1.0 T_Gold]
				}
				frequency 8
				rotate <0,22.5,0>
			}
		}
		texture { T_Gold }
	}

	// main dome
	sphere { <0,0,0>, DomeR
		scale <1,DomeH/DomeR,1>
		translate <0,DomeZ,0>
		texture {
			pigment { P_DomeBase }
			normal { granite 0.8
				scale 0.5
				turbulence 0.4
			}
		}
		texture {
			pigment { radial
				pigment_map {
					[0.0000 P_Dome01]
					[0.0357 P_Dome01]
					[0.0357 P_Dome02]
					[0.0714 P_Dome02]
					[0.0714 P_Dome03]
					[0.1071 P_Dome03]
					[0.1071 P_Dome04]
					[0.1429 P_Dome04]
					[0.1429 P_Dome05]
					[0.1786 P_Dome05]
					[0.1786 P_Dome06]
					[0.2143 P_Dome06]
					[0.2143 P_Dome07]
					[0.2500 P_Dome07]
					[0.2500 P_Dome08]
					[0.2857 P_Dome08]
					[0.2857 P_Dome09]
					[0.3214 P_Dome09]
					[0.3214 P_Dome10]
					[0.3571 P_Dome10]
					[0.3571 P_Dome11]
					[0.3929 P_Dome11]
					[0.3929 P_Dome12]
					[0.4286 P_Dome12]
					[0.4286 P_Dome13]
					[0.4643 P_Dome13]
					[0.4643 P_Dome14]
					[0.5000 P_Dome14]
					[0.5000 P_Dome01]
					[0.5357 P_Dome01]
					[0.5357 P_Dome02]
					[0.5714 P_Dome02]
					[0.5714 P_Dome03]
					[0.6071 P_Dome03]
					[0.6071 P_Dome04]
					[0.6429 P_Dome04]
					[0.6429 P_Dome05]
					[0.6786 P_Dome05]
					[0.6786 P_Dome06]
					[0.7143 P_Dome06]
					[0.7143 P_Dome07]
					[0.7500 P_Dome07]
					[0.7500 P_Dome08]
					[0.7857 P_Dome08]
					[0.7857 P_Dome09]
					[0.8214 P_Dome09]
					[0.8214 P_Dome10]
					[0.8571 P_Dome10]
					[0.8571 P_Dome11]
					[0.8929 P_Dome11]
					[0.8929 P_Dome12]
					[0.9286 P_Dome12]
					[0.9286 P_Dome13]
					[0.9643 P_Dome13]
					[0.9643 P_Dome14]
					[1.0000 P_Dome14]
				}
			}
		}
	}
	// dome ribbing
	#local i = 0;
	#while (i < DomeSym/2)
		torus { DomeR-RibR/2, RibR
			rotate <90,0,0>
			scale <1,DomeH/DomeR,1>
			rotate <0,i*360/DomeSym,0>
			translate <0,DomeZ,0>
			texture {
				pigment { P_DomeBase }
				normal { granite 0.3
					scale 0.5
					turbulence 0.4
				}
			}
		}
		#local i = i + 1;
	#end

	// grey cylinders below dome
	union {
		cylinder { <0,DomeZ-DomeCylH,0>, <0,DomeZ,0>, DomeCylR1 }
		cylinder { <0,DomeZ-2*DomeCylH-CylH,0>, <0,DomeZ-DomeCylH,0>, DomeCylR2 }
		texture {
			pigment { rgb <0.2,0.2,0.2> }
		}
	}
	// toruses around these cylinders
	union {
		torus { DomeCylR1, DomeCylTorR translate <0,DomeZ,0> }
		torus { DomeCylR2, DomeCylTorR translate <0,DomeZ-DomeCylH,0> }
		texture {
			pigment { rgb <1,1,1> }
		}
	}

	// big white cylinder just below dome
	#local z1 = DomeZ-2*DomeCylH-CylWinTop;
	#local z2 = z1 - CylWinH;
	difference {
		union {
			cylinder { <0,DomeZ-2*DomeCylH-CylH,0>, <0,DomeZ-2*DomeCylH,0>, CylR }
			#local i = 0.;
			#while (i < DomeSym/2)
				box { <-CylR-1,z2-CylWinSill,-CylWinW/2-CylWinSill>, <CylR+CylWinSill/2,z1+CylWinSill,CylWinW/2+CylWinSill>
					rotate <0,(i+0.5)*360/DomeSym,0>
					Marble()
				}
				box { <-CylR-1,DomeZ-2*DomeCylH,-CylBarW/2>, <CylR+CylWinSill,DomeZ-2*DomeCylH-CylH,CylBarW/2>
					rotate <0,i*360/DomeSym,0>
					Marble()
				}
				#local i = i + 1;
			#end
			Marble()
		}
		// cut out windows
		#local i = 0.5;
		#while (i < DomeSym/2)
			box { <-CylR-1,z2,-CylWinW/2>, <CylR+1,z1,CylWinW/2>
				rotate <0,i*360/DomeSym,0>
				Marble()
			}
			#local i = i + 1;
		#end
	}
	// lip of big white cylinder just below dome
	cylinder { <0,DomeZ-2*DomeCylH-CylLipH,0>, <0,DomeZ-2*DomeCylH,0>, CylLipR
		Marble()
	}
	torus { CylLipR, DomeCylTorR
		translate <0,DomeZ-2*DomeCylH-CylLipH/2,0>
		Marble()
	}
	// lip at bottom of big white cylinder
	#local z1 = DomeZ-2*DomeCylH-CylH;
	#local z2 = z1 - LipH;
	cylinder { <0,z1,0>, <0,z2,0>, LipR
		Marble()
	}
	// railing at bottom of big white cylinder
	difference {
		cylinder { <0,z2-RailDownH,0>, <0,z1+RailH3,0>, RailR }
		cylinder { <0,z1,0>, <0,z1+RailH3+1,0>, RailR-RailT }
		cylinder { <0,z1+RailH1,0>, <0,z1+RailH2,0>, RailR+1 }
		Marble()
	}
	#local i = 0;
	#while (i < DomeSym)
		// railing blocks
		box { <RailR,z1+RailH1,-RailBlockW/2>, <RailR-RailT,z1+RailH2,RailBlockW/2>
			Marble()
			rotate <0,i*360/DomeSym,0>
		}
		// railing columns
		union {
			cylinder { <RailR-RailT/2,z1+RailH1,0>, <RailR-RailT/2,z1+RailH2,0>, RailT/2
				Marble()
			}
			cylinder { <RailR-RailT/2,z1+RailH1,0>, <RailR-RailT/2,z1+RailH2,0>, RailT/2
				rotate <0,360/DomeSym/7,0>
				Marble()
			}
			cylinder { <RailR-RailT/2,z1+RailH1,0>, <RailR-RailT/2,z1+RailH2,0>, RailT/2
				rotate <0,-360/DomeSym/7,0>
				Marble()
			}
			cylinder { <RailR-RailT/2,z1+RailH1,0>, <RailR-RailT/2,z1+RailH2,0>, RailT/2
				rotate <0,720/DomeSym/7,0>
				Marble()
			}
			cylinder { <RailR-RailT/2,z1+RailH1,0>, <RailR-RailT/2,z1+RailH2,0>, RailT/2
				rotate <0,-720/DomeSym/7,0>
				Marble()
			}
			rotate <0,(i+0.5)*360/DomeSym,0>
		}
		// big columns below
		object { Column
			translate <RailR-ColumnR,z2-RailDownH-ColumnH,0>
			rotate <0,i*360/DomeSym,0>
			Marble()
		}
		#local i = i + 1;
	#end
	// grey cylinder inside columns
	#local z1 = z2-RailDownH;
	#local z2 = z1-ColumnH;
	cylinder { <0,z1,0>, <0,z2,0>, RailR-3*ColumnR
		texture {
			pigment { gradient y
				pigment_map {
					[0.0 P_Stripy]
					[0.6 P_Stripy]
					[0.6 P_Flat]
					[0.8 P_Flat]
					[0.8 P_Stripy]
					[1.0 P_Stripy]
				}
				scale ColumnH
				translate <0,z2,0>
			}
			normal { brick 0.2
				scale 0.4
			}
		}
	}
	// lip under columns
	#local z1 = z2;
	#local z2 = z1 - LipH;
	cylinder { <0,z1,0>, <0,z2,0>, LipR
		Marble()
	}
	// base under columns
	#local z1 = z2;
	#local z2 = z1 - BaseH;
	cylinder { <0,z1,0>, <0,z2,0>, RailR
		Marble()
		texture {
			pigment { bozo
				colour_map {
					[0.0 rgbf <0,0,0,0.2>]
					[0.4 rgbf <0,0,0,0.5>]
					[0.6 rgbf <1,1,1,1>]
					[1.0 rgbf <1,1,1,1>]
				}
				turbulence 0.4
				omega 0.2
				scale <50,9,50>
				translate <50,10,0>
			}
		}
	}
}
