//CHRISTMAS WINDOW
//by Dan S Allsop
//panthus@xtra.co.nz   
//for IRTC competition November-December 2000: 'CONTRAST'.
//******************************************************************************************
//										    ELEMENTS
//******************************************************************************************
#declare Mall_Switch=		on;	#declare Window_Switch=		on;
#declare Plant_Switch=		on;	#declare Bench_Switch=		on;
#declare Gumball_Switch=	on;	#declare Letters_Switch=	on;
#declare Frosting_Switch=	on;	#declare Sky_Switch=		on;
#declare City_Switch=		on;	#declare Glass_Switch=		on;
//******************************************************************************************
//										      PAINTS
//******************************************************************************************
#declare MallWallTex = texture { 
	pigment { rgb <0.7, 0.6, 0.2> } 
}
#declare MallRailTex = texture { 
        pigment { rgb <0.6, 0.4, 0.0> }
        finish { metallic brilliance 2 specular 0.8 roughness 0.01 reflection 0.1 }
}
#declare MallMetalTex = texture { 
        pigment { rgb 0.5 }
        finish { metallic brilliance 2 specular 0.4 roughness 0.01 }
}
#declare MallPillarTopTex = texture { 
        pigment { rgb <0.6, 0.5, 0.2> }
	finish { specular 0.1 roughness 0.1 }
}
#declare MallPillarTex = texture { 
        pigment { rgb <0.3, 0.2, 0.2> }
        finish { metallic brilliance 4 specular 0.8 roughness 0.01 }
}
#declare RubbishBinTex = texture { 
        pigment { rgb <0.3, 0.7, 0.3> }
        finish { specular 0.2 roughness 0.5 }
        normal { dents 0.1 scale 0.3 }
}
#declare WindowWallTex = texture { 
	pigment { gradient z color_map { [ 0.1 rgb 0.3 ] [ 0.9 rgb 1 ] } scale 4.5 
		translate <0, 0, -8.25> }
}
#declare WindowGlassTex = texture { 
	pigment { rgbf 0.95 }
	finish { reflection 0.6 }
}
#declare WindowClothTex = texture { 
	pigment { rgb <0.6, 0.1, 0.1> }
	normal { gradient x 0.1 scale 0.075 turbulence 1 }
	finish { specular 0.2 roughness 0.01 }
}
#declare WindowWireTex = texture { 
	pigment { rgb <0.3, 0.3, 0.3> }
	finish { specular 0.5 roughness 0.5 }
}
#declare LightMetalTex = texture { 
        pigment { rgb 0.8 }
        finish { metallic brilliance 5 specular 1 roughness 0.01 reflection 0.1 }
        normal { radial 0.1 frequency 10 }
}
#declare DogFurTex = texture {
	pigment { rgb <0.7 0.3, 0.2> } 
}
#declare DogFleshTex = texture {
	pigment { rgb 1 } 
}
#declare DogRuffTex = texture {
	pigment { rgb 1 }
	finish { ambient 0.2 specular 1 roughness 0.1 }
	normal { granite 0.5 scale 0.05 }
}
#declare DogShirtTex = texture {
	pigment { rgb <1, 0, 0> }
	finish { ambient 0.2 specular 0.5 roughness 0.5 }
	normal { quilted 0.15 scale <0.015, 0.06, 0.015> }
}
#declare DogButtonTex = texture { 
        pigment { rgb <0.9, 0.8, 0.3> }
        finish { metallic brilliance 2 specular 0.8 roughness 0.01 reflection 0.1 }
}
#declare PagerTex = texture { 
        pigment { rgb 0.3 }
        finish { metallic brilliance 2 specular 0.8 roughness 0.01 reflection 0.1 }
}
#declare PotTex = texture { 
	pigment { rgb <0.9, 0.6, 0.2> }
	normal { radial 0.01 frequency 50 }
	finish { specular 0.3 roughness 0.1 }
}
#declare MilkshakeTex = texture { 
	pigment { radial color_map { [ 0.0 rgb 0.9 ] [ 0.5 rgb <0.9, 0.3, 0.3> ]
		[ 1.0 rgb 0.9 ] } frequency 50 turbulence 1 }
	finish { specular 1 roughness 0.01 }
}
#declare MilkshakeLidTex = texture { 
	pigment { rgbf <0.9, 0.9, 0.9, 0.2> }
	finish { specular 1 roughness 0.01 }
}
#declare MilkshakeStrawTex = texture { 
	pigment { radial color_map { [ 0.0 rgbf <0.8, 0.6, 0.6, 0.6> ]
		[ 0.25 rgbf <0.8, 0.6, 0.6, 0.6> ] [ 0.25 rgbf <0.6, 0.8, 0.6, 0.6> ]
		[ 0.5 rgbf <0.6, 0.8, 0.6, 0.6> ] [ 0.5 rgbf <0.6, 0.6, 0.8, 0.6> ]
		[ 0.75 rgbf <0.6, 0.6, 0.8, 0.6> ] [ 0.75 rgbf <0.8, 0.8, 0.8, 0.6> ]
		[ 1.0 rgbf <0.8, 0.8, 0.8, 0.6> ] } frequency 3 
	}
	finish { specular 0.5 roughness 0.01 }
}
#declare BenchTex = texture { 
        pigment { rgb <0.2, 0.3, 0.5> }
        finish { specular 1 roughness 0.01 reflection 0.05 }
        normal { dents 0.05 scale 0.5 }
}
#declare NewspaperTex = texture { 
        pigment { gradient z color_map { [ 0.7 rgb 1 ] [ 0.7 rgb 0 ] } scale 0.25
        	turbulence 0.5 }
}
#declare GumballGlassTex = texture { 
        pigment { rgbf 0.9 }
        finish { specular 1 roughness 0.001 reflection 0.2 }
}
#declare GumballMachineTex = texture { 
        pigment { rgb <0.4, 0.2, 0.6> }
        finish { specular 0.5 roughness 0.5 }
}
#declare SnowLetterTex = texture { 
        pigment { rgb 1 }
        finish { ambient 0.2 specular 1 roughness 0.01 }
        normal { granite 0.05 scale 0.1 }
}
#declare BuildingFrameTex = texture { 
        pigment { rgb <0.6, 0.5, 0.4> }
        finish { metallic brilliance 2 specular 0.8 roughness 0.01 reflection 0.05 }
}
#declare BuildingGlassTex = texture { 
        pigment { rgbf 0.2 }
        finish { specular 1 roughness 0.01 reflection 0.5 ambient 0.2 }
}
#declare BuildingLitGlassTex = texture { 
        pigment { bozo color_map { [ 0.5 rgbf <0.6, 0.6, 0.6, 0.2> ] [ 1.0 rgb 0.5 ] } 
        	scale 0.5 }
        finish { specular 1 roughness 0.01 reflection 0.5 ambient 0.5 }
}
#declare PhotoWallTex = texture { 
        pigment { rgb 1 }
        finish { ambient 0.5 diffuse 0.5 reflection 0.1 }
}
//******************************************************************************************
//										   SANTA HAT
//******************************************************************************************
#declare SantaHat = blob {
	threshold 0.1
	sphere { 0, 1.05, 1.05 scale <1, 0.4, 1> texture { DogRuffTex }
		translate <0, 0.55, 0> }
	sphere { 0, 1.1, 1.1 scale <1, 1.25, 1> texture { DogShirtTex } }
	#declare FlopCounter=0;
	#while(FlopCounter<24)
		sphere { 0, 0.8-(FlopCounter/30), 0.8-(FlopCounter/30)
			scale <1, 1.25, 1> texture { DogShirtTex }
			translate <-0.5, 0, 0> rotate <0, 0, -(FlopCounter*10)>
			translate <0.5, 0.5, 0>
		}
		#declare FlopCounter=FlopCounter+1;
	#end
	sphere { 0, 0.3, 0.3 texture { DogButtonTex } translate <0.95, 0, 0> }
	sphere { 0, 0.3, 0.3 texture { DogButtonTex } translate <0.95, 0, 0> }
	sphere { 0, 1.5, -1.5 scale <0.85, 1, 1> translate <-0.1, -0.5, 0> }
	sphere { 0, 1.5, -1.5 scale <0.85, 0.75, 1> translate <-0.1, -0.25, 0> }
	texture { DogButtonTex }
	translate <0, 3, 0>
}
//******************************************************************************************
//											MALL
//******************************************************************************************
#if(Mall_Switch=on)
#declare RandCable=seed(43890);
#declare MallSign = union {
	intersection {
		union {
			superellipsoid { 0.3 translate <-3, 0, 0> }
			box { <-3, -1, -1>, <3, 1, 1> }
			superellipsoid { 0.3 translate <3, 0, 0> }
		}
		box { <-5, -2, -0.15>, <5, 2, 0.15> }
		pigment { image_map { gif "mallsign.gif" once interpolate 2 }
			scale <8, 2, 1> translate <-4, -1, 0> }
		finish { specular 0.1 roughness 0.01 }
		normal { dents 0.1 scale 0.1 }
	}
	sphere { <-3.75, -0.75, -0.1>, 0.1 }
	sphere { <-3.75, 0.75, -0.1>, 0.1 }
	sphere { <3.75, -0.75, -0.1>, 0.1 }
	sphere { <3.75, 0.75, -0.1>, 0.1 }
	cylinder { <-3, 1, 0>, <-3, 2, 0>, 0.15 }
	cylinder { <3, 1, 0>, <3, 2, 0>, 0.15 }
	sphere { <-3, 2, 0>, 0.25 }
	sphere { <3, 2, 0>, 0.25 }
	texture { MallMetalTex }
	scale 0.5 
	translate <-8.5, 9, 15>
}
#declare RubbishBin = union {
	cone { <0, 0, 0>, 1, <0, 3, 0>, 1.3 hollow }
	difference {
		torus { 1.35, 0.05 sturm translate <0, 3, 0> hollow }
		box { <-2, 0, -2>, <2, 3, 2> }
	}
	cylinder { <0, 2.7, 0>, <0, 3, 0>, 1.4 hollow }
	difference {
		sphere { <0, 3, 0>, 1.3 hollow }
		box { <-2, 0, -2>, <2, 3, 2> }
		box { <-0.6, 3.1, -2>, <0.6, 3.9, 0> }
	}
	torus { 1.15, 0.1 sturm translate <0, 0.5, 0> texture { MallMetalTex } }
	torus { 1.3, 0.1 sturm translate <0, 2.5, 0> texture { MallMetalTex } }
	#declare CageCounter=0;
	#while(CageCounter<30)
		cylinder { <0, 0.5, 1.15>, <0, 2.5, 1.3>, 0.05
			rotate <0, CageCounter*12, 0>
			texture { MallMetalTex }
		}
		#declare CageCounter=CageCounter+1;
	#end
	scale 0.75
	texture { RubbishBinTex }
	translate <7.5, 1.5, 18>
}
#declare Mall = union {
	difference {
		box { <-20, 0, -20>, <20, 11, 21> }
		box { <-19, 1, -21>, <19, 10, 22> }
		#declare MallCeilingCounter=0;
		#while(MallCeilingCounter<32)
			box { <-2, 9, -2>, <2, 10.5, 2>
				translate <-20+(MallCeilingCounter*5), 0, 2.5>
				#if(MallCeilingCounter>7) translate <-40, 0, 5> #end
				#if(MallCeilingCounter>15) translate <-40, 0, 5> #end
				#if(MallCeilingCounter>23) translate <-40, 0, 5> #end
			}
			#declare MallCeilingCounter=MallCeilingCounter+1;
		#end
		box { <-0.3, 9, -0.3>, <0.3, 12, 0.3> translate <7.5, 0, 10> }
		box { <-0.3, 9, -0.3>, <0.3, 12, 0.3> translate <-7.5, 0, 10> }
		cylinder { <-20, 10.5, 9>, <20, 10.5, 9>, 0.4 }
		texture { MallWallTex }
	}
	union {
		#declare CableCounter=0;
		#while(CableCounter<18)
			cylinder { <-20, 0, -0.35>, <20, 0, -0.35>, 0.04
				rotate <-((CableCounter*180)/18), 0, 0>
				pigment { rgb <(rand(RandCable)/2), (rand(RandCable)/2), 0> }
				finish { specular 1 roughness 0.01 }
			}
			#declare CableCounter=CableCounter+1;
		#end
		translate <0, 10.5, 9>
	}
	difference {
		box { <-0.4, 9.95, -0.4>, <0.4, 11, 0.4> }
		box { <-0.25, 9, -0.25>, <0.25, 10.9, 0.25> }
		translate <7.5, 0, 10>
		texture { MallMetalTex }
	}
	union {
		cylinder { <-0.3, 10, -0.125>, <0.3, 10, -0.125>, 0.05 }
		cylinder { <-0.3, 10, 0.125>, <0.3, 10, 0.125>, 0.05 }
		cylinder { <-0.125, 10, -0.3>, <-0.125, 10, 0.3>, 0.05 }
		cylinder { <0.125, 10, -0.3>, <0.125, 10, 0.3>, 0.05 }
		translate <7.5, 0, 10> 
		texture { MallMetalTex }
	}
	difference {
		box { <-0.4, 9.95, -0.4>, <0.4, 11, 0.4> }
		box { <-0.25, 9, -0.25>, <0.25, 10.9, 0.25> }
		translate <-7.5, 0, 10>
		texture { MallMetalTex }
	}
	union {
		cylinder { <-0.3, 10, -0.125>, <0.3, 10, -0.125>, 0.05 }
		cylinder { <-0.3, 10, 0.125>, <0.3, 10, 0.125>, 0.05 }
		cylinder { <-0.125, 10, -0.3>, <-0.125, 10, 0.3>, 0.05 }
		cylinder { <0.125, 10, -0.3>, <0.125, 10, 0.3>, 0.05 }
		translate <-7.5, 0, 10> 
		texture { MallMetalTex }
	}
	object { MallSign }
	object { RubbishBin }
	union {
		cylinder { <0, 0, -20>, <0, 0, 21>, 0.2 }
		torus { 0.2, 0.05 sturm rotate <90, 0, 0> scale <1, 1, 3> }
		torus { 0.2, 0.05 sturm rotate <90, 0, 0> scale <1, 1, 3> 
			translate <0, 0, 5> }
		torus { 0.2, 0.05 sturm rotate <90, 0, 0> scale <1, 1, 3> 
			translate <0, 0, 10> }
		torus { 0.2, 0.05 sturm rotate <90, 0, 0> scale <1, 1, 3> 
			translate <0, 0, 15> }
		texture { MallMetalTex
			normal { radial 0.05 frequency 20 rotate <90, 0, 0> } } 
		translate <-2.5, 9.9, 0>
	}
	#declare MallLightCounter=0;
	#while(MallLightCounter<16)
		light_source { <-20+(MallLightCounter*5), 9.9, 0> rgb 1
			looks_like { sphere { 0, 0.1 pigment { rgb 1 } 
			finish { specular 1 ambient 1 } } }
			fade_power 2 fade_distance 4 
			#if(MallLightCounter>7) translate <-40, 0, 10> #end
		}
		#declare MallLightCounter=MallLightCounter+1;
	#end
	#declare MallPillarCounter=0;
	#while(MallPillarCounter<9)
		cylinder { <0, 1, 20>, <0, 10, 20>, 0.5 texture { MallPillarTopTex }
			translate <-22.5+(MallPillarCounter*5), 0, 0>
		}
		cylinder { <0, 1, 20>, <0, 5, 20>, 0.75 texture { MallPillarTex } 
			translate <-22.5+(MallPillarCounter*5), 0, 0>
		}
		#declare MallPillarCounter=MallPillarCounter+1;
	#end
	cylinder { <-20, 4, 20>, <20, 4, 20>, 0.1 texture { MallRailTex } }
	#declare MallRailCounter=0;
	#while(MallRailCounter<80)
		cylinder { <0, 0, 20>, <0, 4, 20>, 0.1
			texture { MallRailTex }	translate <-20+(MallRailCounter/2), 0, 0>
		}
		#declare MallRailCounter=MallRailCounter+1;
	#end
}
#end	
//******************************************************************************************
//										      WINDOW
//******************************************************************************************
#if(Glass_Switch=on)
plane { z, -4.36 clipped_by { box { <-20, 0, -5>, <20, 11, 0> } } 
	texture { WindowGlassTex } }
#end
#if(Window_Switch=on)
#declare RandLight=seed(43267);
#declare RandCloth=seed(95487);
#declare RandSnow=seed(12375);
#declare RandPresent=seed(95437);
#declare XmasLight = union {
	cylinder { <0, -0.075, 0>, <0, -0.025, 0>, 0.025 texture { LightMetalTex } }
	sphere { <0, -0.05, 0.025>, 0.01 texture { LightMetalTex } }
	sphere { <0, -0.05, -0.025>, 0.01 texture { LightMetalTex } }
	sphere { 0, 0.025 scale <1, 2, 1> }
	difference {
		sphere { 0, 0.04 scale <1, 0.5, 1> }
		box { <-1, -1, -1>, <1, 0, 1> }
		texture { LightMetalTex }
		translate <0, -0.075, 0> 
	}
}
#declare Window = union {
	difference {
		box { <-20, 0, -20>, <20, 10, -4> }
		box { <-4, 3, -8.1>, <4, 9, 10> }
	}
	box { <-20, 0, -20>, <20, 4, -7> }
	difference {
		box { <-20, 0, -4.5>, <20, 3.2, -4.3> }
		box { <-21, 3.1, -4.4>, <21, 4, -4.35> }
	}
	#declare LightCounter=0;
	#while(LightCounter<22)
		#declare LightColour = rgbf <rand(RandLight)/2, rand(RandLight)/2, 0, 0.8>;
		light_source { <-2.75+(LightCounter/4), 3.275, -4.475> LightColour
			looks_like { object { XmasLight rotate <0, rand(RandLight)*360, 0> 
				pigment { LightColour } finish { specular 1 ambient 1 } } } 
			fade_power 3 fade_distance 0.5 }
		difference {
			torus { 0.125, 0.01 sturm rotate <90, 0, 0> }
			box { <-1, 0, -1>, <1, 1, 1> }
			scale <1, 0.5+rand(RandLight), 1>
			rotate <5, 0, 0>
			translate <-2.625+(LightCounter/4), 3.205, -4.5>
			texture { WindowWireTex }
		}
		#declare LightCounter=LightCounter+1;
	#end
	box { <-3, 2, -7.1>, <3, 3.001, -4.5> texture { WindowClothTex } }
	light_source { <0, 5, -5> rgb 1 area_light <5, 0, 0> <0, 0, 0> 5, 1 
		adaptive 1 fade_power 2 fade_distance 1 }
	#declare SnowCounter=0;
	#while(SnowCounter<500)
		#declare SnowSize=rand(RandSnow)/20;
		#declare SnowPosition_Z=rand(RandSnow)*2.5;
		sphere { 0, SnowSize translate <-2+(rand(RandSnow)*4.3), 3+SnowSize, 
				-7.1+SnowPosition_Z>
			pigment { rgb 0.35+(SnowPosition_Z/4) } 
			finish { specular 0+(SnowPosition_Z/5) roughness 0.5 }
			normal { granite 0.1 scale 0.01 }
		}
		#declare SnowCounter=SnowCounter+1;
	#end
	texture { WindowWallTex }
}
#end
//******************************************************************************************
//										       PLANT
//******************************************************************************************
#if(Plant_Switch=on)
#declare RandPlant=seed(54894);
#declare Leaf = sphere { 0, 1 hollow 
        clipped_by { box { <-2, -0.25, -2>, <2, 2, 2> } }
        clipped_by { box { <0, -2, -2>, <2, 2, 2> rotate <0, 10, 0> } }
        clipped_by { box { <-2, -2, -2>, <0, 2, 2> rotate <0, -10, 0> } }
        rotate <90, 0, 0>
}
#declare Plant = union {
        #declare LeafCounter=0;
        #while (LeafCounter<2000)
                #declare LeafHeight=(rand(RandPlant)*3.75)+3;
                object { Leaf
                        pigment { gradient z color_map { 
                        	[ 0.0 rgb <0.3, 0.4, 0.0>+(rand(RandPlant)/2) ] 
                        	[ 1.0 rgb <0.2, 0.5, 0.15>+(rand(RandPlant)/2) ] } 
                        }
                        normal { gradient z 0.2 scale 0.01 turbulence 1 }
                        finish { specular 0.5 roughness 0.01 }
                       	scale <0.15, 0.1, rand(RandPlant)/LeafHeight>
                        scale 3.5
                        rotate <-20+(rand(RandPlant)*30), 0, -45+(rand(RandPlant)*90)>
                        translate <0, LeafHeight, rand(RandPlant)/4>
                        rotate <0, rand(RandPlant)*360, 0>
                }
                #declare LeafCounter=LeafCounter+1;
        #end
}
#declare Milkshake = union {
	difference {
		cone { <0, 0, 0>, 0.8, <0, 2.3, 0>, 0.95 hollow }
		sphere { <0, 0, 0>, 0.7 scale <1, 0.5, 1> }
	}
	difference {
		union {
			cylinder { <0, 2.25, 0>, <0, 2.5, 0>, 0.8 hollow }
			intersection {
				torus { 0.8, 0.4 sturm translate <0, 2.1, 0> hollow }
				cylinder { <0, 2.25, 0>, <0, 3, 0>, 1 hollow }
			}
		}
		sphere { 0, 0.1 scale <2, 0.5, 2> translate <0, 2.5, 0> }
		cylinder { <0, 2, 0>, <0, 3, 0>, 0.1 }
		texture { MilkshakeLidTex }
	}
	merge {
		cylinder { <0, 0.8, 0>, <0, 3.001, 0>, 0.1 hollow
			texture { MilkshakeStrawTex } }
		cylinder { <0, -0.001, 0>, <0, 1.5, 0>, 0.1 texture { MilkshakeStrawTex } 
			rotate <0, 0, -40> translate <0, 3, 0> hollow }
		sphere { <0, 3, 0>, 0.1 hollow texture { MilkshakeStrawTex } }
	}
	texture { MilkshakeTex }
	scale 0.3 rotate <0, 30, 0> 
	rotate <-60, 0, 0> translate <0, 3, -0.4> 
	rotate <0, -80, 0>
}
#declare RandDirt=seed(12837);
#declare PotPlant = union {
	cone { <0, 1, 0>, 0.7, <0, 2.5, 0>, 1 }
	difference {
		cylinder { <0, 2.5, 0>, <0, 3, 0>, 1.1 }
		cylinder { <0, 2, 0>, <0, 4, 0>, 1 }
	}
	torus { 1.05, 0.05 sturm translate <0, 3, 0> }
	blob {
		threshold 0.1
		#declare DirtCounter=0;
		#while(DirtCounter<100)
			sphere { 0, 0.2+(rand(RandDirt)/4), 0.2+(rand(RandDirt)/4)
				translate <0, rand(RandDirt)/4, rand(RandDirt)-0.2>
				rotate <0, rand(RandDirt)*360, 0>
				pigment { rgb <0.4, 0.3, 0.2>+(rand(RandDirt)/4) }
				normal { granite 0.1 scale 0.1 }
			}
			#declare DirtCounter=DirtCounter+1;
		#end
		sturm
		translate <0, 2.5, 0>
	}
	object { Plant }
	object { Milkshake }
	texture { PotTex }
	translate <-3.5, 0, -1>
}
#end
//******************************************************************************************
//										       BENCH
//******************************************************************************************
#if(Bench_Switch=on)
#declare BenchSeat = prism { linear_sweep cubic_spline 0, 2, 15,
	<-1, 0>, <0, 0>, <2.4, 0>, <2.9, 0>, <3, 0.5>, <2.4, 1.5>,
	<0.7, 1.5>, <0.2, 3>, <0, 3>, <0.5, 1.3>, <2.2, 1.3>, <2.8, 0.3>,
	<2.3, 0>, <0, 0>, <0, -1> sturm 
	rotate <-90, 0, 0> rotate <0, 90, 0> translate <1, 0, 1.3>
}
#declare BenchLeg = union {
	cylinder { <0, 0.2, 0>, <0, 1.2, 0>, 0.2 }
	difference {
		sphere { 0, 0.4 scale <1, 0.5, 1> }
		box { <-1, -1, -1>, <1, 0, 1> }
		translate <0, 0.2, 0> 
	}
}
#declare RandPage=seed(43728);
#macro PageMake ( PageLevel )
	#declare NewspaperPage = difference {
		union {
			cylinder { <-PageLevel, 0, 0>, <-PageLevel, 0, 6>, PageLevel/2 }
			box { <-PageLevel, -(PageLevel/2), 0>, <PageLevel, PageLevel/2, 6> }
			cylinder { <PageLevel, 0, 0>, <PageLevel, 0, 6>, PageLevel/2 }
		}
		cylinder { <-(PageLevel-0.05), 0, -1>, <-(PageLevel-0.05), 0, 8>, 
			(PageLevel/2)-0.05 }
		box { <-(PageLevel-0.05), -((PageLevel/2)-0.05), -1>, 
			<PageLevel-0.05, (PageLevel/2)-0.05, 8> }
		cylinder { <PageLevel-0.05, 0, -1>, <PageLevel-0.05, 0, 8>, 
			(PageLevel/2)-0.05 }
		translate <0, 0, -0.5+(rand(RandPage))>
	}
#end
#declare Newspaper = union {
	PageMake ( 1.0 )	object { NewspaperPage }
	PageMake ( 0.9 )	object { NewspaperPage }
	PageMake ( 0.8 )	object { NewspaperPage }
	PageMake ( 0.7 )	object { NewspaperPage }
	PageMake ( 0.6 )	object { NewspaperPage }
	PageMake ( 0.5 )	object { NewspaperPage }
	texture { NewspaperTex }
	scale 0.2 rotate <0, -30, 0> translate <2, 1.6, -1.5>
}
#declare Bench = union {
	difference {
		union {
			object { BenchSeat translate <-4.4, 0, 0> }
			object { BenchSeat translate <-2.2, 0, 0> }
			object { BenchSeat translate <0, 0, 0> }
			object { BenchSeat translate <2.2, 0, 0> }
			object { BenchSeat translate <4.4, 0, 0> }
		}
		box { <-10, -1, -3>, <10, 0.8, 3> }
	}
	object { Newspaper }
	union {
		box { <-5.7, 1.1, -0.5>, <5.7, 1.3, 0.3> }
		object { BenchLeg translate <-5.5, 0, 0> }
		object { BenchLeg translate <-3.3, 0, 0> }
		object { BenchLeg translate <-1.1, 0, 0> }
		object { BenchLeg translate <1.1, 0, 0> }
		object { BenchLeg translate <3.3, 0, 0> }
		object { BenchLeg translate <5.5, 0, 0> }
		texture { MallMetalTex } 
	}
	texture { BenchTex }
	translate <-9, 0.8, 17>
}	
#end
//******************************************************************************************
//									     GUMBALL MACHINE
//******************************************************************************************
#if(Gumball_Switch=on)
#declare RandGumball=seed(46755);
#declare GumballMachine = union {
	difference {
		sphere { 0, 1 }
		sphere { 0, 0.95 }
		texture { GumballGlassTex }
	}
	#declare GumCounter=0;
	#while(GumCounter<2000)
		sphere { 0, 0.025+(rand(RandGumball)/40)
			translate <0, 0, 0.9>
			rotate <-20+(rand(RandGumball)*60), 10-(rand(RandGumball)*200), 0>
			pigment { rgb <rand(RandGumball), rand(RandGumball), 
				rand(RandGumball)> }
			finish { ambient 0.3 metallic specular 0.8 roughness 0.3 }
		}
		#declare GumCounter=GumCounter+1;
	#end
	#declare GumCounter=0;
	#while(GumCounter<1500)
		sphere { 0, 0.025+(rand(RandGumball)/40)
			translate <0, 0, rand(RandGumball)*0.9>
			rotate <-20+(rand(RandGumball)*10), rand(RandGumball)*360, 0>
			pigment { rgb <rand(RandGumball), rand(RandGumball), 
				rand(RandGumball)> }
			finish { ambient 0.3 metallic specular 0.8 roughness 0.3 }
		}
		#declare GumCounter=GumCounter+1;
	#end
	difference {
		sphere { 0, 0.85 }
		sphere { <0, 3, 0>, 3 }
		pigment { rgb 0 } 
	}
	difference {
		union {
			torus { 0.8, 0.1 sturm translate <0, -0.6, 0> }
			cylinder { <0, -2.5, 0>, <0, -0.6, 0>, 0.8 }
		}
		sphere { 0, 1 }
		box { <-0.4, -2.3, -2>, <0.4, -1.4, 0> }
		cylinder { <0, -2, 0>, <0, 0, 0>, 0.5 }
	}		
	texture { GumballMachineTex }
	translate <3.1, 3.5, -2.5>
}
#end
//******************************************************************************************
//										   LETTERING
//******************************************************************************************
#if(Letters_Switch=on)
#declare RandLetter=seed(54879);
#declare RandLSpray=seed(94327);
#macro LineMake ( LineLength, LinePosition_X, LinePosition_Y, LineAngle )
	#declare LineCounter=0;
	#while(LineCounter<LineLength)
		sphere { 0, 1, 1 
			scale <0.5+(rand(RandLetter)/2), 0.5+(rand(RandLetter)/2),
				0.5+(rand(RandLetter)/2)>
			translate <-0.25+(rand(RandLetter)/2), 
				(LineCounter/4)+(rand(RandLetter)/2), 0>
			rotate <0, 0, LineAngle>
			translate <LinePosition_X, LinePosition_Y, 0>
		}
		#declare SprayCounter=0;
		#while(SprayCounter<15)
			sphere { 0, 0.25, 0.25 
				scale 0.5+(rand(RandLSpray)/2)
				translate <-2+(rand(RandLSpray)*4), 0, 0>
				rotate <0, 0, rand(RandLSpray)*360> 
				translate <0, (LineCounter/4)+(rand(RandLSpray)/2), 0>
				rotate <0, 0, LineAngle>
				translate <LinePosition_X, LinePosition_Y, -0.45>
			}
			#declare SprayCounter=SprayCounter+1;
		#end
		#declare LineCounter=LineCounter+1;
	#end
#end
#macro LetterMake ( LetterChoice )
	#if(LetterChoice=1)
		#declare Letter_M = intersection {
			blob {
				threshold 0.5
				LineMake ( 24, -2, 0, 0 )	LineMake ( 24, 2, 0, 0 )
				LineMake ( 12, 0, 3, -35 )	LineMake ( 12, 0, 3, 35 )
				sturm 
			}
			box { <-10, -10, -0.6>, <10, 10, 10> }
		}
	#end
	#if(LetterChoice=2)
		#declare Letter_E = intersection {
			blob {
				threshold 0.5
				LineMake ( 24, 2, 0, 0 )	LineMake ( 16, 2, 0.5, 90 )
				LineMake ( 12, 2, 3.25, 90 )	LineMake ( 16, 2, 6, 90 )
				sturm 
			}
			box { <-10, -10, -0.6>, <10, 10, 10> }
		}
	#end
	#if(LetterChoice=3)
		#declare Letter_R = intersection {
			blob {
				threshold 0.5
				LineMake ( 24, 2, 0, 0 )	LineMake ( 16, -2, 0, -55 )
				LineMake ( 8, 2, 3.25, 90 )	LineMake ( 8, 2, 6, 90 )
				#declare R_CurveCounter=0;
				#while(R_CurveCounter<20)
					sphere { 0, 1, 1 
						scale <0.5+(rand(RandLetter)/2), 
							0.5+(rand(RandLetter)/2),
							0.5+(rand(RandLetter)/2)>
						translate <-1-(rand(RandLetter)/2), 0, 0>
						rotate <0, 0, 90-((R_CurveCounter*10)+
							(rand(RandLetter)*5))>
						translate <-0.5, 4.5, 0>
					}
					#declare SprayCounter=0;
					#while(SprayCounter<15)
						sphere { 0, 0.25, 0.25 
							scale 0.5+(rand(RandLSpray)/2)
							translate <-2+(rand(RandLSpray)*4), 
								0, 0>
							rotate <0, 0, rand(RandLSpray)*360> 
							translate <-1-(rand(RandLSpray)/2), 
								0, 0>
							rotate <0, 0, 90-
								((R_CurveCounter*10)+
								(rand(RandLSpray)*5))>
							translate <-0.5, 4.5, -0.45>
						}
						#declare SprayCounter=SprayCounter+1;
					#end
					#declare R_CurveCounter=R_CurveCounter+1;
				#end
				sturm 
			}
			box { <-10, -10, -0.6>, <10, 10, 10> }
		}
	#end
	#if(LetterChoice=4)
		#declare Letter_Y = intersection {
			blob {
				threshold 0.5
				LineMake ( 12, 0, 0, 0 )
				LineMake ( 16, 0, 3, -35 )	LineMake ( 16, 0, 3, 35 )
				sturm   	
			}
			box { <-10, -10, -0.6>, <10, 10, 10> }
		}
	#end
	#if(LetterChoice=5)
		#declare Letter_X = intersection {
			blob {
				threshold 0.5
				LineMake ( 28, -2, 0, -35 )	LineMake ( 28, 2, 0, 35 )
				sturm 
			}
			box { <-10, -10, -0.6>, <10, 10, 10> }
		}
	#end
	#if(LetterChoice=6)
		#declare Letter_A = intersection {
			blob {
				threshold 0.5
				LineMake ( 24, -2, 0, -20 )	LineMake ( 24, 2, 0, 20 )
				LineMake ( 12, 1.5, 2, 90 )
				sturm 
			}
			box { <-10, -10, -0.6>, <10, 10, 10> }
		}
	#end
	#if(LetterChoice=7)
		#declare Letter_S = intersection {
			blob {
				threshold 0.5
				#declare S_CurveCounter=0;
				#while(S_CurveCounter<26)
					sphere { 0, 1, 1 
						scale <0.5+(rand(RandLetter)/2), 
							0.5+(rand(RandLetter)/2),
							0.5+(rand(RandLetter)/2)>
						translate <-1.5-(rand(RandLetter)/2), 0, 0>
						rotate <0, 0, -90+((S_CurveCounter*10)+
							(rand(RandLetter)*5))>
						translate <0, 1.5, 0>
					}
					#declare SprayCounter=0;
					#while(SprayCounter<15)
						sphere { 0, 0.25, 0.25 
							scale 0.5+(rand(RandLSpray)/2)
							translate <-2+(rand(RandLSpray)*4), 
								0, 0>
							rotate <0, 0, rand(RandLSpray)*360> 
							translate <-1.5-(rand(RandLSpray)/2), 
								0, 0>
							rotate <0, 0, -90+
								((S_CurveCounter*10)+
								(rand(RandLSpray)*5))>
							translate <0, 1.5, -0.45>
						}
						#declare SprayCounter=SprayCounter+1;
					#end
					sphere { 0, 1, 1 
						scale <0.5+(rand(RandLetter)/2), 
							0.5+(rand(RandLetter)/2),
							0.5+(rand(RandLetter)/2)>
						translate <-1.5-(rand(RandLetter)/2), 0, 0>
						rotate <0, 180, -90+((S_CurveCounter*10)+
							(rand(RandLetter)*5))>
						translate <0, 4.5, 0>
					}
					#declare SprayCounter=0;
					#while(SprayCounter<15)
						sphere { 0, 0.25, 0.25 
							scale 0.5+(rand(RandLSpray)/2)
							translate <-2+(rand(RandLSpray)*4), 
								0, 0>
							rotate <0, 0, rand(RandLSpray)*360> 
							translate <-1.5-(rand(RandLSpray)/2),
								0, 0>
							rotate <0, 180, -90+
								((S_CurveCounter*10)+
								(rand(RandLSpray)*5))>
							translate <0, 4.5, -0.45>
						}
						#declare SprayCounter=SprayCounter+1;
					#end
					#declare S_CurveCounter=S_CurveCounter+1;
				#end
				sturm 
			}
			box { <-10, -10, -0.6>, <10, 10, 10> }
		}
	#end
#end
#declare SnowLetters = union {
	//1=M, 2=E, 3=R, 4=Y, 5=X, 6=A, 7=S
	union {
		LetterMake ( 1 )	object { Letter_M scale 0.1 translate <2.3, 0, 0> }
		LetterMake ( 2 )	object { Letter_E scale 0.1 translate <1.8, 0, 0> }
		LetterMake ( 3 )	object { Letter_R scale 0.1 translate <1.3, 0, 0> }
		LetterMake ( 3 )	object { Letter_R scale 0.1 translate <0.8, 0, 0> }
		LetterMake ( 4 )	object { Letter_Y scale 0.1 translate <0.3, 0, 0> }
		//rotate <0, 180, 0>
		//translate <1.3, 5.6, -4>
	}
	union {
		LetterMake ( 5 )	object { Letter_X scale 0.1 translate <-0.8, 0, 0> }
		LetterMake ( 1 )	object { Letter_M scale 0.1 translate <-1.3, 0, 0> }
		LetterMake ( 6 )	object { Letter_A scale 0.1 translate <-1.8, 0, 0> }
		LetterMake ( 7 )	object { Letter_S scale 0.1 translate <-2.3, 0, 0> }
		//rotate <0, 180, 0>
		//translate <-1.6, 3.5, -4.5>
	}
	translate <0, 5.75, -4.3>
	texture { SnowLetterTex }
}
#end
//******************************************************************************************
//										    FROSTING
//******************************************************************************************
#if(Frosting_Switch=on)
#declare RandFrost=seed(43218);
#declare RandFSpray=seed(29544);
#macro CurveMake ( CurvePosition_X )
	#declare CurveCounter=0;
	#while(CurveCounter<30)
		sphere { 0, 1, 1 
			scale <0.5+(rand(RandFrost)/2), 0.5+(rand(RandFrost)/2),
				0.5+(rand(RandFrost)/2)>
			translate <-3-(rand(RandFrost)/2), 0, 0>
			rotate <0, 0, (CurveCounter*6)+(rand(RandFrost)*3)>
			translate <CurvePosition_X, 0, 0>
		}
		#declare SprayCounter=0;
		#while(SprayCounter<25)
			sphere { 0, 0.25, 0.25 
				scale 0.5+(rand(RandFSpray)/2)
				translate <-2+(rand(RandFSpray)*4), 0, 0>
				rotate <0, 0, rand(RandFSpray)*360> 
				translate <-3-(rand(RandFSpray)/2), 0, 0>
				rotate <0, 0, (CurveCounter*6)+(rand(RandFSpray)*3)>
				translate <CurvePosition_X, 0, -0.45>
			}
			#declare SprayCounter=SprayCounter+1;
		#end
		#declare CurveCounter=CurveCounter+1;
	#end
#end
#declare Frosting = intersection {
	blob {
		threshold 0.5
		#declare FrostCounter=0;
		#while(FrostCounter<10)
			CurveMake ( FrostCounter*6 )
			#declare FrostCounter=FrostCounter+1;
		#end
		sturm
	}
	box { <-10, -10, -0.6>, <100, 10, 10> }
	scale 0.1
	translate <-2.75, 3.7, -4.3>
	texture { SnowLetterTex }
}
#end
//******************************************************************************************
//											CITY
//******************************************************************************************
#if(City_Switch=on)
#declare RandHeight=seed(32789);
#declare RandWindows=seed(32789);
#macro BuildingMake ()
	#declare BuildingHeight=20+(ceil((rand(RandHeight)*20))*2);
	#declare WindowStart=-1-(rand(RandWindows));
	#declare Building = union {
		difference {
			box { <-10, 0, -10>, <10, BuildingHeight, 10> }
			#declare WindowCounter=0;
			#while(WindowCounter<(BuildingHeight*5))
				#declare WindowRow=floor(WindowCounter/10);
				box { <-0.9, -0.9, -11>, <0.9, 0.9, 11>
					translate <-9+(WindowCounter*2), WindowStart, 0>
					translate <-20*WindowRow, 2*WindowRow, 0>
				}
				box { <-11, -0.9, -0.9>, <11, 0.9, 0.9>
					translate <0, WindowStart, -9+(WindowCounter*2)>
					translate <0, 2*WindowRow, -20*WindowRow>
				}
				#declare WindowCounter=WindowCounter+1;
			#end
			texture { BuildingFrameTex }
		}
		difference {
			box { <-9.9, 0, -9.9>, <9.9, BuildingHeight-0.1, 9.9> }
			box { <-9.85, 0.05, -9.85>, <9.85, BuildingHeight-0.15, 9.85> }
			texture { BuildingGlassTex } 
		}
		#declare LitWindowCounter=0;
		#while(LitWindowCounter<floor(rand(RandWindows)*50))
			#declare LitWindowPosition=floor(rand(RandWindows)*300);
			#while(LitWindowPosition>(BuildingHeight*5))
				#declare LitWindowPosition=floor(rand(RandWindows)*300);
			#end
			#declare LitWindowRow=floor(LitWindowPosition/10);
			difference {
				box { <-0.9, -0.9, -9.95>, <0.9, 0.9, 9.95> }
				box { <-1, -1, -9.91>, <1, 1, 9.91> }
				translate <-9+(LitWindowPosition*2), WindowStart, 0>
				translate <-20*LitWindowRow, 2*LitWindowRow, 0>
				texture { BuildingLitGlassTex }
			}
			#declare LitWindowPosition=floor(rand(RandWindows)*300);
			#while(LitWindowPosition>(BuildingHeight*5))
				#declare LitWindowPosition=floor(rand(RandWindows)*300);
			#end
			#declare LitWindowRow=floor(LitWindowPosition/10);
			difference {
				box { <-9.95, -0.9, -0.9>, <9.95, 0.9, 0.9> }
				box { <-9.91, -1, -1>, <9.91, 1, 1> }
				translate <0, WindowStart, -9+(LitWindowPosition*2)>
				translate <0, 2*LitWindowRow, -20*LitWindowRow>
				texture { BuildingLitGlassTex }
			}
			#declare LitWindowCounter=LitWindowCounter+1;
		#end
	}
#end
#declare RandBuilding=seed(32789);
#declare City = union {
	#declare BuildingPosition=-80;
	#declare BuildingCounter=0;
	#while(BuildingCounter<8)
		BuildingMake ()
		object { Building translate <BuildingPosition, -20, 
				100+(rand(RandBuilding)*10)>
		}
		#declare BuildingPosition=BuildingPosition+21+(rand(RandBuilding)*5);
		#declare BuildingCounter=BuildingCounter+1;
	#end
	#declare BuildingPosition=-180;
	#declare BuildingCounter=0;
	#while(BuildingCounter<8)
		BuildingMake ()
		difference {
			object { Building scale 2 translate <BuildingPosition, -30, 
					rand(RandBuilding)*10>
			}
			union {
				box { <-19.1, 0.9, -30>, <19.1, 10.6, 40> }
				box { <-30, -10, 20>, <30, 20, 40> }
				texture { BuildingFrameTex } 
			}
		}
		#declare BuildingPosition=BuildingPosition+42+(rand(RandBuilding)*10);
		#declare BuildingCounter=BuildingCounter+1;
	#end
}
#end
//******************************************************************************************
//										     DISPLAY
//******************************************************************************************
#if(Mall_Switch=on)	object { Mall }			#end
#if(Window_Switch=on)	object { Window }		#end
#if(Plant_Switch=on)	object { PotPlant }		#end
#if(Bench_Switch=on)	object { Bench }		#end
#if(Gumball_Switch=on)	object { GumballMachine }	#end
#if(Letters_Switch=on)	object { SnowLetters }		#end
#if(Frosting_Switch=on)	object { Frosting }		#end
#if(City_Switch=on)	object { City }			#end
#if(Sky_Switch=on)
sky_sphere { pigment { gradient y color_map { [ 0.0 rgb <0.55, 0.55, 0.6> ] 
	[ 1.0 rgb <0.2, 0.15, 0.3> ] } scale 0.5 }
	pigment { bozo color_map { [ 0.01 rgb 1 ]
	[ 0.01 rgbf <1, 1, 1, 1> ] } scale 0.0001 }
	pigment { bozo color_map { [ 0.1 rgbf 0.2 ]
	[ 0.7 rgbf <1, 1, 1, 1> ] } turbulence 1 scale <0.25, 0.1, 0.1> } }
#end
background { rgb 0.5 }
light_source { <0, 50, 80> rgb <1, 0.9, 0.9> }
camera { location <0, 5, -8> look_at <0, 4, 0> }


