//  Persistence of Vision Raytracer V3.1
//  World definition file.
//
//  Contains 2 lights, 29 materials and 105 primitives.
//
//  This file was generated for POV-Ray V3.1 by
//  Moray V3.2 For Windows Copyright (c) 1993-2000 Lutz + Kretzschmar
//

//  Date : 12/22/2000    (22.12.2000)
//

/*
  The text between these two comments is in MorayPOV.INC and is
  automatically included in all POV files that Moray exports.
*/

default {
  texture {
    pigment { rgb <1,0,0> }
  }
}

/* // Scene Comment

This scene was created by Txemi Jendrix inspiriens

12/22/00

If you want to render it, you will have to comment some textures

as they have image maps that ar not included in this zip.

Search them thru' escher.inc file.

http://home.dencity.com/tji

tji@euskalnet.net

Bye

*/ // End Scene Comment

global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.9
  hf_gray_16 off
  irid_wavelength <0.247059,0.176471,0.137255>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
  radiosity {
    brightness       3.3
    count            100
    distance_maximum 0.0
    error_bound      0.4
    gray_threshold   0.5
    low_error_factor 0.8
    minimum_reuse    0.015
    nearest_count    6
    recursion_limit  1
  }
}

background { color <0.000,0.000,0.020> }

camera {  //  Camera StdCam
  location  <    -28.199,     -48.453,      30.613>
  sky       <    0.00000,     0.00000,     1.00000> // Use right handed-system 
  up        <        0.0,         0.0,         1.0> // Where Z is up
  right     <    0.72472,         0.0,         0.0> // Right Vector is adjusted to compensate for spherical (Moray) vs. planar (POV-Ray) aspect ratio
  angle         40.00000    // Vertical      53.333
  look_at   <     -2.302,      -4.325,      12.554>
}

//    Other cameras are commented out.
/*
camera {  //  Camera Cameradientes
  location  <    -19.500,     -28.495,      15.804>
  sky       <    0.00000,     0.00000,     1.00000> // Use right handed-system 
  up        <        0.0,         0.0,         1.0> // Where Z is up
  right     <    1.34707,         0.0,         0.0> // Right Vector is adjusted to compensate for spherical (Moray) vs. planar (POV-Ray) aspect ratio
  angle         30.00000    // Vertical      22.500
  look_at   <      2.571,      -2.548,       5.801>
}

*/

/*
camera {  //  Camera Camerapan
  location  <     20.000,     -33.042,      20.911>
  sky       <    0.00000,     0.00000,     1.00000> // Use right handed-system 
  up        <        0.0,         0.0,         1.0> // Where Z is up
  right     <    1.34707,         0.0,         0.0> // Right Vector is adjusted to compensate for spherical (Moray) vs. planar (POV-Ray) aspect ratio
  angle         30.00000    // Vertical      22.500
  look_at   <     16.865,      -1.584,      17.909>
}

*/

/*
camera {  //  Camera Camerapelos
  location  <      5.691,     -31.981,      28.390>
  sky       <    0.00000,     0.00000,     1.00000> // Use right handed-system 
  up        <        0.0,         0.0,         1.0> // Where Z is up
  right     <    1.34707,         0.0,         0.0> // Right Vector is adjusted to compensate for spherical (Moray) vs. planar (POV-Ray) aspect ratio
  angle         30.00000    // Vertical      22.500
  look_at   <     14.983,       0.000,       3.350>
}

*/

/*
camera {  //  Camera Cameratarro
  location  <     -2.193,     -10.790,      10.399>
  sky       <    0.00000,     0.00000,     1.00000> // Use right handed-system 
  up        <        0.0,         0.0,         1.0> // Where Z is up
  right     <    1.35836,         0.0,         0.0> // Right Vector is adjusted to compensate for spherical (Moray) vs. planar (POV-Ray) aspect ratio
  angle         40.00000    // Vertical      30.000
  look_at   <    -16.498,       5.588,       1.000>
}

*/

/*
camera {  //  Camera Cameraperfum
  location  <    -26.464,     -16.007,      15.804>
  sky       <    0.00000,     0.00000,     1.00000> // Use right handed-system 
  up        <        0.0,         0.0,         1.0> // Where Z is up
  right     <    1.34707,         0.0,         0.0> // Right Vector is adjusted to compensate for spherical (Moray) vs. planar (POV-Ray) aspect ratio
  angle         30.00000    // Vertical      22.500
  look_at   <     -5.355,      -4.469,       5.801>
}

*/

//
// *******  L I G H T S *******
//

light_source {   // Light001
  <0.0, 0.0, 0.0>
  color rgb <1.000, 1.000, 1.000>
  shadowless
  fade_distance  15.0
  fade_power 2.0
  translate  <19.071411, -28.565463, 31.830032>
}

light_source {   // Light1
  <0.0, 0.0, 0.0>
  color rgb <1.000, 1.000, 1.000>
  fade_distance  35.0
  fade_power 2.0
  translate  <0.0, -56.671929, 36.248507>
}


//
// ********  MATERIALS  *******
//

#include "escher.inc"


//
// ********  REFERENCED OBJECTS  *******
//

#declare Cylndr009 = object {
  cylinder { // Cylndr009
    <0,0,1>, <0,0,0>, 1 
    material {
      pelos_dientes_txt
    }
    scale <0.065, 0.065, 1.0>
    translate  -1.2*y
  }
}
#declare filac = union {
  object { Cylndr009 }
  object { // Cylndr010->Cylndr009
    Cylndr009
    translate  0.15*y
  }
  object { // Cylndr011->Cylndr009
    Cylndr009
    translate  0.3*y
  }
  object { // Cylndr012->Cylndr009
    Cylndr009
    translate  0.45*y
  }
  object { // Cylndr013->Cylndr009
    Cylndr009
    translate  0.6*y
  }
  object { // Cylndr014->Cylndr009
    Cylndr009
    translate  0.75*y
  }
  object { // Cylndr015->Cylndr009
    Cylndr009
    translate  0.9*y
  }
  object { // Cylndr016->Cylndr009
    Cylndr009
    translate  1.05*y
  }
  object { // Cylndr017->Cylndr009
    Cylndr009
    translate  1.2*y
  }
  object { // Cylndr018->Cylndr009
    Cylndr009
    translate  1.35*y
  }
  object { // Cylndr019->Cylndr009
    Cylndr009
    translate  1.5*y
  }
  object { // Cylndr020->Cylndr009
    Cylndr009
    translate  1.65*y
  }
  object { // Cylndr021->Cylndr009
    Cylndr009
    translate  1.8*y
  }
  object { // Cylndr022->Cylndr009
    Cylndr009
    translate  1.95*y
  }
  object { // Cylndr023->Cylndr009
    Cylndr009
    translate  2.1*y
  }
  object { // Cylndr024->Cylndr009
    Cylndr009
    translate  2.25*y
  }
  object { // Cylndr025->Cylndr009
    Cylndr009
    translate  2.4*y
  }
  object { // Cylndr026->Cylndr009
    Cylndr009
    translate  2.55*y
  }
  object { // Cylndr027->Cylndr009
    Cylndr009
    translate  2.7*y
  }
}


#declare sPatchObj1 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000001, 4.030155, -16.192387>, <0.000001, 2.855166, -16.192387>, <0.000000, 1.288514, -16.192387>, <0.000000, 0.113525, -16.192387>, 
      <0.925365, 4.030155, -16.192387>, <0.925365, 2.855166, -16.192387>, <0.026067, 1.288514, -16.192387>, <0.026067, 0.113525, -16.192387>, 
      <2.195419, 3.504080, -16.192387>, <1.364576, 2.673238, -16.192387>, <0.892686, 0.929549, -16.192387>, <0.061843, 0.098707, -16.192387>, 
      <2.849750, 2.849749, -16.192387>, <2.018908, 2.018907, -16.192387>, <0.911118, 0.911117, -16.192387>, <0.080275, 0.080275, -16.192387>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.849749, 2.849750, -16.192387>, <-2.018907, 2.018908, -16.192387>, <-0.911117, 0.911118, -16.192387>, <-0.080275, 0.080275, -16.192387>, 
      <-2.195418, 3.504081, -16.192387>, <-1.364575, 2.673239, -16.192387>, <-0.892685, 0.929549, -16.192387>, <-0.061843, 0.098707, -16.192387>, 
      <-0.925363, 4.030155, -16.192387>, <-0.925364, 2.855166, -16.192387>, <-0.026066, 1.288514, -16.192387>, <-0.026067, 0.113525, -16.192387>, 
      <0.000001, 4.030155, -16.192387>, <0.000001, 2.855166, -16.192387>, <0.000000, 1.288514, -16.192387>, <0.000000, 0.113525, -16.192387>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-4.030155, 0.000000, -16.192387>, <-2.855166, 0.000000, -16.192387>, <-1.288514, 0.000000, -16.192387>, <-0.113525, 0.000000, -16.192387>, 
      <-4.030155, 0.925364, -16.192387>, <-2.855166, 0.925364, -16.192387>, <-1.288514, 0.026067, -16.192387>, <-0.113525, 0.026067, -16.192387>, 
      <-3.504080, 2.195419, -16.192387>, <-2.673238, 1.364576, -16.192387>, <-0.929549, 0.892686, -16.192387>, <-0.098707, 0.061843, -16.192387>, 
      <-2.849749, 2.849750, -16.192387>, <-2.018907, 2.018908, -16.192387>, <-0.911117, 0.911118, -16.192387>, <-0.080275, 0.080275, -16.192387>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.849750, -2.849750, -16.192387>, <-2.018908, -2.018908, -16.192387>, <-0.911118, -0.911118, -16.192387>, <-0.080275, -0.080275, -16.192387>, 
      <-3.504081, -2.195419, -16.192387>, <-2.673239, -1.364576, -16.192387>, <-0.929549, -0.892686, -16.192387>, <-0.098707, -0.061843, -16.192387>, 
      <-4.030155, -0.925364, -16.192387>, <-2.855166, -0.925364, -16.192387>, <-1.288514, -0.026067, -16.192387>, <-0.113525, -0.026067, -16.192387>, 
      <-4.030155, 0.000000, -16.192387>, <-2.855166, 0.000000, -16.192387>, <-1.288514, 0.000000, -16.192387>, <-0.113525, 0.000000, -16.192387>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -4.030155, -16.192387>, <0.000000, -2.855166, -16.192387>, <0.000000, -1.288514, -16.192387>, <0.000000, -0.113525, -16.192387>, 
      <-0.925364, -4.030155, -16.192387>, <-0.925364, -2.855166, -16.192387>, <-0.026067, -1.288514, -16.192387>, <-0.026067, -0.113525, -16.192387>, 
      <-2.195419, -3.504081, -16.192387>, <-1.364576, -2.673239, -16.192387>, <-0.892686, -0.929549, -16.192387>, <-0.061843, -0.098707, -16.192387>, 
      <-2.849750, -2.849750, -16.192387>, <-2.018908, -2.018908, -16.192387>, <-0.911118, -0.911118, -16.192387>, <-0.080275, -0.080275, -16.192387>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.849750, -2.849750, -16.192387>, <2.018908, -2.018908, -16.192387>, <0.911118, -0.911118, -16.192387>, <0.080275, -0.080275, -16.192387>, 
      <2.195419, -3.504081, -16.192387>, <1.364576, -2.673239, -16.192387>, <0.892686, -0.929549, -16.192387>, <0.061843, -0.098707, -16.192387>, 
      <0.925364, -4.030155, -16.192387>, <0.925364, -2.855166, -16.192387>, <0.026067, -1.288514, -16.192387>, <0.026067, -0.113525, -16.192387>, 
      <0.000000, -4.030155, -16.192387>, <0.000000, -2.855166, -16.192387>, <0.000000, -1.288514, -16.192387>, <0.000000, -0.113525, -16.192387>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000001, 3.916629, -13.372355>, <0.000001, 3.950687, -14.218365>, <0.000001, 3.996097, -15.346378>, <0.000001, 4.030155, -16.192387>, 
      <0.899298, 3.916629, -13.372355>, <0.899298, 3.950687, -14.218365>, <0.925365, 3.996097, -15.346378>, <0.925365, 4.030155, -16.192387>, 
      <2.133576, 3.405373, -13.372355>, <2.157658, 3.429456, -14.218365>, <2.171336, 3.479998, -15.346378>, <2.195419, 3.504080, -16.192387>, 
      <2.769475, 2.769474, -13.372355>, <2.793557, 2.793556, -14.218365>, <2.825668, 2.825667, -15.346378>, <2.849750, 2.849749, -16.192387>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.769475, 2.769475, -13.372355>, <-2.793557, 2.793557, -14.218365>, <-2.825667, 2.825668, -15.346378>, <-2.849749, 2.849750, -16.192387>, 
      <-2.133575, 3.405374, -13.372355>, <-2.157658, 3.429457, -14.218365>, <-2.171335, 3.479999, -15.346378>, <-2.195418, 3.504081, -16.192387>, 
      <-0.899297, 3.916629, -13.372355>, <-0.899297, 3.950687, -14.218365>, <-0.925363, 3.996097, -15.346378>, <-0.925363, 4.030155, -16.192387>, 
      <0.000001, 3.916629, -13.372355>, <0.000001, 3.950687, -14.218365>, <0.000001, 3.996097, -15.346378>, <0.000001, 4.030155, -16.192387>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.916629, 0.000000, -13.372355>, <-3.950687, 0.000000, -14.218365>, <-3.996097, 0.000000, -15.346378>, <-4.030155, 0.000000, -16.192387>, 
      <-3.916629, 0.899297, -13.372355>, <-3.950687, 0.899297, -14.218365>, <-3.996097, 0.925364, -15.346378>, <-4.030155, 0.925364, -16.192387>, 
      <-3.405374, 2.133576, -13.372355>, <-3.429457, 2.157658, -14.218365>, <-3.479998, 2.171336, -15.346378>, <-3.504080, 2.195419, -16.192387>, 
      <-2.769475, 2.769475, -13.372355>, <-2.793557, 2.793557, -14.218365>, <-2.825667, 2.825668, -15.346378>, <-2.849749, 2.849750, -16.192387>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.769475, -2.769475, -13.372355>, <-2.793557, -2.793557, -14.218365>, <-2.825668, -2.825668, -15.346378>, <-2.849750, -2.849750, -16.192387>, 
      <-3.405374, -2.133576, -13.372355>, <-3.429457, -2.157658, -14.218365>, <-3.479999, -2.171336, -15.346378>, <-3.504081, -2.195419, -16.192387>, 
      <-3.916629, -0.899297, -13.372355>, <-3.950687, -0.899297, -14.218365>, <-3.996097, -0.925364, -15.346378>, <-4.030155, -0.925364, -16.192387>, 
      <-3.916629, 0.000000, -13.372355>, <-3.950687, 0.000000, -14.218365>, <-3.996097, 0.000000, -15.346378>, <-4.030155, 0.000000, -16.192387>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -3.916629, -13.372355>, <0.000000, -3.950687, -14.218365>, <0.000000, -3.996097, -15.346378>, <0.000000, -4.030155, -16.192387>, 
      <-0.899297, -3.916629, -13.372355>, <-0.899297, -3.950687, -14.218365>, <-0.925364, -3.996097, -15.346378>, <-0.925364, -4.030155, -16.192387>, 
      <-2.133576, -3.405374, -13.372355>, <-2.157658, -3.429457, -14.218365>, <-2.171336, -3.479999, -15.346378>, <-2.195419, -3.504081, -16.192387>, 
      <-2.769475, -2.769475, -13.372355>, <-2.793557, -2.793557, -14.218365>, <-2.825668, -2.825668, -15.346378>, <-2.849750, -2.849750, -16.192387>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.769475, -2.769475, -13.372355>, <2.793557, -2.793557, -14.218365>, <2.825668, -2.825668, -15.346378>, <2.849750, -2.849750, -16.192387>, 
      <2.133576, -3.405374, -13.372355>, <2.157658, -3.429457, -14.218365>, <2.171336, -3.479999, -15.346378>, <2.195419, -3.504081, -16.192387>, 
      <0.899297, -3.916629, -13.372355>, <0.899297, -3.950687, -14.218365>, <0.925364, -3.996097, -15.346378>, <0.925364, -4.030155, -16.192387>, 
      <0.000000, -3.916629, -13.372355>, <0.000000, -3.950687, -14.218365>, <0.000000, -3.996097, -15.346378>, <0.000000, -4.030155, -16.192387>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 3.519290, -13.638731>, <0.000000, 3.657305, -13.678062>, <0.000001, 3.797428, -13.452269>, <0.000001, 3.916629, -13.372355>, 
      <0.808065, 3.519290, -13.638731>, <0.808065, 3.657305, -13.678062>, <0.899298, 3.797427, -13.452269>, <0.899298, 3.916629, -13.372355>, 
      <1.917126, 3.059901, -13.638731>, <2.014717, 3.157492, -13.678062>, <2.049288, 3.321085, -13.452269>, <2.133576, 3.405373, -13.372355>, 
      <2.488514, 2.488513, -13.638731>, <2.586105, 2.586104, -13.678062>, <2.685187, 2.685186, -13.452269>, <2.769475, 2.769474, -13.372355>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.488513, 2.488514, -13.638731>, <-2.586105, 2.586106, -13.678062>, <-2.685186, 2.685187, -13.452269>, <-2.769475, 2.769475, -13.372355>, 
      <-1.917125, 3.059902, -13.638731>, <-2.014717, 3.157493, -13.678062>, <-2.049287, 3.321086, -13.452269>, <-2.133575, 3.405374, -13.372355>, 
      <-0.808064, 3.519290, -13.638731>, <-0.808064, 3.657306, -13.678062>, <-0.899297, 3.797428, -13.452269>, <-0.899297, 3.916629, -13.372355>, 
      <0.000000, 3.519290, -13.638731>, <0.000000, 3.657305, -13.678062>, <0.000001, 3.797428, -13.452269>, <0.000001, 3.916629, -13.372355>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.519290, 0.000000, -13.638731>, <-3.657305, 0.000000, -13.678062>, <-3.797428, 0.000000, -13.452269>, <-3.916629, 0.000000, -13.372355>, 
      <-3.519290, 0.808065, -13.638731>, <-3.657305, 0.808065, -13.678062>, <-3.797428, 0.899297, -13.452269>, <-3.916629, 0.899297, -13.372355>, 
      <-3.059901, 1.917126, -13.638731>, <-3.157493, 2.014718, -13.678062>, <-3.321086, 2.049287, -13.452269>, <-3.405374, 2.133576, -13.372355>, 
      <-2.488513, 2.488514, -13.638731>, <-2.586105, 2.586106, -13.678062>, <-2.685186, 2.685187, -13.452269>, <-2.769475, 2.769475, -13.372355>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.488514, -2.488514, -13.638731>, <-2.586105, -2.586105, -13.678062>, <-2.685187, -2.685187, -13.452269>, <-2.769475, -2.769475, -13.372355>, 
      <-3.059902, -1.917126, -13.638731>, <-3.157493, -2.014718, -13.678062>, <-3.321086, -2.049287, -13.452269>, <-3.405374, -2.133576, -13.372355>, 
      <-3.519290, -0.808064, -13.638731>, <-3.657306, -0.808064, -13.678062>, <-3.797428, -0.899297, -13.452269>, <-3.916629, -0.899297, -13.372355>, 
      <-3.519290, 0.000000, -13.638731>, <-3.657305, 0.000000, -13.678062>, <-3.797428, 0.000000, -13.452269>, <-3.916629, 0.000000, -13.372355>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -3.519290, -13.638731>, <0.000000, -3.657305, -13.678062>, <0.000000, -3.797428, -13.452269>, <0.000000, -3.916629, -13.372355>, 
      <-0.808064, -3.519290, -13.638731>, <-0.808064, -3.657305, -13.678062>, <-0.899297, -3.797428, -13.452269>, <-0.899297, -3.916629, -13.372355>, 
      <-1.917126, -3.059902, -13.638731>, <-2.014718, -3.157493, -13.678062>, <-2.049287, -3.321086, -13.452269>, <-2.133576, -3.405374, -13.372355>, 
      <-2.488514, -2.488514, -13.638731>, <-2.586105, -2.586105, -13.678062>, <-2.685187, -2.685187, -13.452269>, <-2.769475, -2.769475, -13.372355>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.488514, -2.488514, -13.638731>, <2.586105, -2.586105, -13.678062>, <2.685187, -2.685187, -13.452269>, <2.769475, -2.769475, -13.372355>, 
      <1.917126, -3.059902, -13.638731>, <2.014718, -3.157493, -13.678062>, <2.049287, -3.321086, -13.452269>, <2.133576, -3.405374, -13.372355>, 
      <0.808064, -3.519290, -13.638731>, <0.808064, -3.657305, -13.678062>, <0.899297, -3.797428, -13.452269>, <0.899297, -3.916629, -13.372355>, 
      <0.000000, -3.519290, -13.638731>, <0.000000, -3.657305, -13.678062>, <0.000000, -3.797428, -13.452269>, <0.000000, -3.916629, -13.372355>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 3.576053, -13.275301>, <0.000000, 3.678314, -13.316774>, <-0.000000, 3.413164, -13.608490>, <0.000000, 3.519290, -13.638731>, 
      <0.821098, 3.576053, -13.275301>, <0.821098, 3.678314, -13.316774>, <0.808064, 3.413164, -13.608490>, <0.808065, 3.519290, -13.638731>, 
      <1.948047, 3.109254, -13.275301>, <2.020357, 3.181564, -13.316774>, <1.842083, 2.984859, -13.608490>, <1.917126, 3.059901, -13.638731>, 
      <2.528651, 2.528650, -13.275301>, <2.600960, 2.600960, -13.316774>, <2.413471, 2.413471, -13.608490>, <2.488514, 2.488513, -13.638731>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.528651, 2.528651, -13.275301>, <-2.600961, 2.600961, -13.316774>, <-2.413471, 2.413471, -13.608490>, <-2.488513, 2.488514, -13.638731>, 
      <-1.948047, 3.109255, -13.275301>, <-2.020357, 3.181565, -13.316774>, <-1.842083, 2.984859, -13.608490>, <-1.917125, 3.059902, -13.638731>, 
      <-0.821098, 3.576053, -13.275301>, <-0.821098, 3.678314, -13.316774>, <-0.808064, 3.413164, -13.608490>, <-0.808064, 3.519290, -13.638731>, 
      <0.000000, 3.576053, -13.275301>, <0.000000, 3.678314, -13.316774>, <-0.000000, 3.413164, -13.608490>, <0.000000, 3.519290, -13.638731>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.576053, 0.000000, -13.275301>, <-3.678314, 0.000000, -13.316774>, <-3.413164, 0.000000, -13.608490>, <-3.519290, 0.000000, -13.638731>, 
      <-3.576053, 0.821098, -13.275301>, <-3.678314, 0.821098, -13.316774>, <-3.413164, 0.808065, -13.608490>, <-3.519290, 0.808065, -13.638731>, 
      <-3.109255, 1.948047, -13.275301>, <-3.181565, 2.020357, -13.316774>, <-2.984859, 1.842083, -13.608490>, <-3.059901, 1.917126, -13.638731>, 
      <-2.528651, 2.528651, -13.275301>, <-2.600961, 2.600961, -13.316774>, <-2.413471, 2.413471, -13.608490>, <-2.488513, 2.488514, -13.638731>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.528651, -2.528651, -13.275301>, <-2.600961, -2.600961, -13.316774>, <-2.413471, -2.413471, -13.608490>, <-2.488514, -2.488514, -13.638731>, 
      <-3.109255, -1.948047, -13.275301>, <-3.181565, -2.020357, -13.316774>, <-2.984859, -1.842084, -13.608490>, <-3.059902, -1.917126, -13.638731>, 
      <-3.576053, -0.821098, -13.275301>, <-3.678314, -0.821098, -13.316774>, <-3.413164, -0.808064, -13.608490>, <-3.519290, -0.808064, -13.638731>, 
      <-3.576053, 0.000000, -13.275301>, <-3.678314, 0.000000, -13.316774>, <-3.413164, 0.000000, -13.608490>, <-3.519290, 0.000000, -13.638731>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -3.576053, -13.275301>, <0.000000, -3.678314, -13.316774>, <0.000000, -3.413164, -13.608490>, <0.000000, -3.519290, -13.638731>, 
      <-0.821098, -3.576053, -13.275301>, <-0.821098, -3.678314, -13.316774>, <-0.808064, -3.413164, -13.608490>, <-0.808064, -3.519290, -13.638731>, 
      <-1.948047, -3.109255, -13.275301>, <-2.020357, -3.181565, -13.316774>, <-1.842084, -2.984859, -13.608490>, <-1.917126, -3.059902, -13.638731>, 
      <-2.528651, -2.528651, -13.275301>, <-2.600961, -2.600961, -13.316774>, <-2.413471, -2.413471, -13.608490>, <-2.488514, -2.488514, -13.638731>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.528651, -2.528651, -13.275301>, <2.600961, -2.600961, -13.316774>, <2.413471, -2.413471, -13.608490>, <2.488514, -2.488514, -13.638731>, 
      <1.948047, -3.109255, -13.275301>, <2.020357, -3.181565, -13.316774>, <1.842084, -2.984859, -13.608490>, <1.917126, -3.059902, -13.638731>, 
      <0.821098, -3.576053, -13.275301>, <0.821098, -3.678314, -13.316774>, <0.808064, -3.413164, -13.608490>, <0.808064, -3.519290, -13.638731>, 
      <0.000000, -3.576053, -13.275301>, <0.000000, -3.678314, -13.316774>, <0.000000, -3.413164, -13.608490>, <0.000000, -3.519290, -13.638731>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 3.065188, -13.454566>, <0.000000, 3.117547, -13.608317>, <0.000000, 3.425538, -13.214258>, <0.000000, 3.576053, -13.275301>, 
      <0.703798, 3.065187, -13.454566>, <0.703798, 3.117547, -13.608317>, <0.821098, 3.425538, -13.214258>, <0.821098, 3.576053, -13.275301>, 
      <1.669755, 2.665075, -13.454566>, <1.706779, 2.702098, -13.608317>, <1.841618, 3.002824, -13.214258>, <1.948047, 3.109254, -13.275301>, 
      <2.167416, 2.167414, -13.454566>, <2.204439, 2.204437, -13.608317>, <2.422222, 2.422220, -13.214258>, <2.528651, 2.528650, -13.275301>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.167415, 2.167416, -13.454566>, <-2.204438, 2.204439, -13.608317>, <-2.422222, 2.422222, -13.214258>, <-2.528651, 2.528651, -13.275301>, 
      <-1.669755, 2.665076, -13.454566>, <-1.706778, 2.702100, -13.608317>, <-1.841618, 3.002825, -13.214258>, <-1.948047, 3.109255, -13.275301>, 
      <-0.703798, 3.065188, -13.454566>, <-0.703798, 3.117547, -13.608317>, <-0.821098, 3.425539, -13.214258>, <-0.821098, 3.576053, -13.275301>, 
      <0.000000, 3.065188, -13.454566>, <0.000000, 3.117547, -13.608317>, <0.000000, 3.425538, -13.214258>, <0.000000, 3.576053, -13.275301>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.065188, 0.000000, -13.454566>, <-3.117547, 0.000000, -13.608317>, <-3.425538, 0.000000, -13.214258>, <-3.576053, 0.000000, -13.275301>, 
      <-3.065188, 0.703798, -13.454566>, <-3.117547, 0.703798, -13.608317>, <-3.425538, 0.821098, -13.214258>, <-3.576053, 0.821098, -13.275301>, 
      <-2.665076, 1.669756, -13.454566>, <-2.702099, 1.706779, -13.608317>, <-3.002825, 1.841618, -13.214258>, <-3.109255, 1.948047, -13.275301>, 
      <-2.167415, 2.167416, -13.454566>, <-2.204438, 2.204439, -13.608317>, <-2.422222, 2.422222, -13.214258>, <-2.528651, 2.528651, -13.275301>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.167415, -2.167415, -13.454566>, <-2.204438, -2.204438, -13.608317>, <-2.422221, -2.422221, -13.214258>, <-2.528651, -2.528651, -13.275301>, 
      <-2.665075, -1.669755, -13.454566>, <-2.702099, -1.706778, -13.608317>, <-3.002825, -1.841618, -13.214258>, <-3.109255, -1.948047, -13.275301>, 
      <-3.065188, -0.703798, -13.454566>, <-3.117547, -0.703798, -13.608317>, <-3.425538, -0.821098, -13.214258>, <-3.576053, -0.821098, -13.275301>, 
      <-3.065188, 0.000000, -13.454566>, <-3.117547, 0.000000, -13.608317>, <-3.425538, 0.000000, -13.214258>, <-3.576053, 0.000000, -13.275301>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -3.065188, -13.454566>, <0.000000, -3.117547, -13.608317>, <0.000000, -3.425538, -13.214258>, <0.000000, -3.576053, -13.275301>, 
      <-0.703798, -3.065188, -13.454566>, <-0.703798, -3.117547, -13.608317>, <-0.821098, -3.425538, -13.214258>, <-0.821098, -3.576053, -13.275301>, 
      <-1.669755, -2.665075, -13.454566>, <-1.706778, -2.702099, -13.608317>, <-1.841618, -3.002825, -13.214258>, <-1.948047, -3.109255, -13.275301>, 
      <-2.167415, -2.167415, -13.454566>, <-2.204438, -2.204438, -13.608317>, <-2.422221, -2.422221, -13.214258>, <-2.528651, -2.528651, -13.275301>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.167415, -2.167415, -13.454566>, <2.204438, -2.204438, -13.608317>, <2.422221, -2.422221, -13.214258>, <2.528651, -2.528651, -13.275301>, 
      <1.669755, -2.665075, -13.454566>, <1.706778, -2.702099, -13.608317>, <1.841618, -3.002825, -13.214258>, <1.948047, -3.109255, -13.275301>, 
      <0.703798, -3.065188, -13.454566>, <0.703798, -3.117547, -13.608317>, <0.821098, -3.425538, -13.214258>, <0.821098, -3.576053, -13.275301>, 
      <0.000000, -3.065188, -13.454566>, <0.000000, -3.117547, -13.608317>, <0.000000, -3.425538, -13.214258>, <0.000000, -3.576053, -13.275301>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 3.292239, -12.441892>, <0.000000, 3.322611, -12.751752>, <0.000000, 2.964821, -13.159843>, <0.000000, 3.065188, -13.454566>, 
      <0.755931, 3.292239, -12.441892>, <0.755931, 3.322611, -12.751752>, <0.703798, 2.964821, -13.159843>, <0.703798, 3.065187, -13.454566>, 
      <1.793441, 2.862488, -12.441892>, <1.814917, 2.883965, -12.751752>, <1.598786, 2.594105, -13.159842>, <1.669755, 2.665075, -13.454566>, 
      <2.327965, 2.327964, -12.441892>, <2.349441, 2.349440, -12.751752>, <2.096446, 2.096444, -13.159842>, <2.167416, 2.167414, -13.454566>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.327964, 2.327965, -12.441892>, <-2.349440, 2.349441, -12.751752>, <-2.096445, 2.096446, -13.159843>, <-2.167415, 2.167416, -13.454566>, 
      <-1.793440, 2.862489, -12.441892>, <-1.814916, 2.883965, -12.751752>, <-1.598785, 2.594106, -13.159843>, <-1.669755, 2.665076, -13.454566>, 
      <-0.755931, 3.292239, -12.441892>, <-0.755931, 3.322611, -12.751752>, <-0.703798, 2.964821, -13.159843>, <-0.703798, 3.065188, -13.454566>, 
      <0.000000, 3.292239, -12.441892>, <0.000000, 3.322611, -12.751752>, <0.000000, 2.964821, -13.159843>, <0.000000, 3.065188, -13.454566>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.292239, 0.000000, -12.441892>, <-3.322611, 0.000000, -12.751752>, <-2.964821, 0.000000, -13.159843>, <-3.065188, 0.000000, -13.454566>, 
      <-3.292239, 0.755931, -12.441892>, <-3.322611, 0.755931, -12.751752>, <-2.964821, 0.703798, -13.159843>, <-3.065188, 0.703798, -13.454566>, 
      <-2.862488, 1.793441, -12.441892>, <-2.883965, 1.814917, -12.751752>, <-2.594105, 1.598786, -13.159843>, <-2.665076, 1.669756, -13.454566>, 
      <-2.327964, 2.327965, -12.441892>, <-2.349440, 2.349441, -12.751752>, <-2.096445, 2.096446, -13.159843>, <-2.167415, 2.167416, -13.454566>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.327965, -2.327965, -12.441892>, <-2.349441, -2.349441, -12.751752>, <-2.096445, -2.096445, -13.159842>, <-2.167415, -2.167415, -13.454566>, 
      <-2.862489, -1.793441, -12.441892>, <-2.883965, -1.814917, -12.751752>, <-2.594105, -1.598785, -13.159842>, <-2.665075, -1.669755, -13.454566>, 
      <-3.292239, -0.755931, -12.441892>, <-3.322611, -0.755931, -12.751752>, <-2.964821, -0.703798, -13.159843>, <-3.065188, -0.703798, -13.454566>, 
      <-3.292239, 0.000000, -12.441892>, <-3.322611, 0.000000, -12.751752>, <-2.964821, 0.000000, -13.159843>, <-3.065188, 0.000000, -13.454566>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -3.292239, -12.441892>, <0.000000, -3.322611, -12.751752>, <0.000000, -2.964821, -13.159843>, <0.000000, -3.065188, -13.454566>, 
      <-0.755931, -3.292239, -12.441892>, <-0.755931, -3.322611, -12.751752>, <-0.703798, -2.964821, -13.159843>, <-0.703798, -3.065188, -13.454566>, 
      <-1.793441, -2.862489, -12.441892>, <-1.814917, -2.883965, -12.751752>, <-1.598785, -2.594105, -13.159842>, <-1.669755, -2.665075, -13.454566>, 
      <-2.327965, -2.327965, -12.441892>, <-2.349441, -2.349441, -12.751752>, <-2.096445, -2.096445, -13.159842>, <-2.167415, -2.167415, -13.454566>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.327965, -2.327965, -12.441892>, <2.349441, -2.349441, -12.751752>, <2.096445, -2.096445, -13.159842>, <2.167415, -2.167415, -13.454566>, 
      <1.793441, -2.862489, -12.441892>, <1.814917, -2.883965, -12.751752>, <1.598785, -2.594105, -13.159842>, <1.669755, -2.665075, -13.454566>, 
      <0.755931, -3.292239, -12.441892>, <0.755931, -3.322611, -12.751752>, <0.703798, -2.964821, -13.159843>, <0.703798, -3.065188, -13.454566>, 
      <0.000000, -3.292239, -12.441892>, <0.000000, -3.322611, -12.751752>, <0.000000, -2.964821, -13.159843>, <0.000000, -3.065188, -13.454566>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 2.894900, -11.717257>, <0.000000, 2.922817, -11.963607>, <0.000000, 3.268054, -12.195147>, <0.000000, 3.292239, -12.441892>, 
      <0.664698, 2.894900, -11.717257>, <0.664698, 2.922817, -11.963607>, <0.755931, 3.268053, -12.195147>, <0.755931, 3.292239, -12.441892>, 
      <1.576991, 2.517015, -11.717257>, <1.596732, 2.536755, -11.963607>, <1.776339, 2.845387, -12.195147>, <1.793441, 2.862488, -12.441892>, 
      <2.047004, 2.047002, -11.717257>, <2.066744, 2.066742, -11.963607>, <2.310863, 2.310862, -12.195147>, <2.327965, 2.327964, -12.441892>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.047003, 2.047004, -11.717257>, <-2.066743, 2.066744, -11.963607>, <-2.310862, 2.310863, -12.195147>, <-2.327964, 2.327965, -12.441892>, 
      <-1.576991, 2.517016, -11.717257>, <-1.596731, 2.536757, -11.963607>, <-1.776338, 2.845387, -12.195147>, <-1.793440, 2.862489, -12.441892>, 
      <-0.664698, 2.894900, -11.717257>, <-0.664698, 2.922817, -11.963607>, <-0.755931, 3.268054, -12.195147>, <-0.755931, 3.292239, -12.441892>, 
      <0.000000, 2.894900, -11.717257>, <0.000000, 2.922817, -11.963607>, <0.000000, 3.268054, -12.195147>, <0.000000, 3.292239, -12.441892>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.894900, 0.000000, -11.717257>, <-2.922817, 0.000000, -11.963607>, <-3.268054, 0.000000, -12.195147>, <-3.292239, 0.000000, -12.441892>, 
      <-2.894900, 0.664698, -11.717257>, <-2.922817, 0.664698, -11.963607>, <-3.268053, 0.755931, -12.195147>, <-3.292239, 0.755931, -12.441892>, 
      <-2.517016, 1.576991, -11.717257>, <-2.536756, 1.596732, -11.963607>, <-2.845387, 1.776339, -12.195147>, <-2.862488, 1.793441, -12.441892>, 
      <-2.047003, 2.047004, -11.717257>, <-2.066743, 2.066744, -11.963607>, <-2.310862, 2.310863, -12.195147>, <-2.327964, 2.327965, -12.441892>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.047003, -2.047003, -11.717257>, <-2.066743, -2.066743, -11.963607>, <-2.310863, -2.310863, -12.195147>, <-2.327965, -2.327965, -12.441892>, 
      <-2.517015, -1.576991, -11.717257>, <-2.536756, -1.596731, -11.963607>, <-2.845387, -1.776339, -12.195147>, <-2.862489, -1.793441, -12.441892>, 
      <-2.894900, -0.664698, -11.717257>, <-2.922817, -0.664698, -11.963607>, <-3.268054, -0.755931, -12.195147>, <-3.292239, -0.755931, -12.441892>, 
      <-2.894900, 0.000000, -11.717257>, <-2.922817, 0.000000, -11.963607>, <-3.268054, 0.000000, -12.195147>, <-3.292239, 0.000000, -12.441892>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -2.894900, -11.717257>, <0.000000, -2.922817, -11.963607>, <0.000000, -3.268054, -12.195147>, <0.000000, -3.292239, -12.441892>, 
      <-0.664698, -2.894900, -11.717257>, <-0.664698, -2.922817, -11.963607>, <-0.755931, -3.268054, -12.195147>, <-0.755931, -3.292239, -12.441892>, 
      <-1.576991, -2.517015, -11.717257>, <-1.596731, -2.536756, -11.963607>, <-1.776339, -2.845387, -12.195147>, <-1.793441, -2.862489, -12.441892>, 
      <-2.047003, -2.047003, -11.717257>, <-2.066743, -2.066743, -11.963607>, <-2.310863, -2.310863, -12.195147>, <-2.327965, -2.327965, -12.441892>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.047003, -2.047003, -11.717257>, <2.066743, -2.066743, -11.963607>, <2.310863, -2.310863, -12.195147>, <2.327965, -2.327965, -12.441892>, 
      <1.576991, -2.517015, -11.717257>, <1.596731, -2.536756, -11.963607>, <1.776339, -2.845387, -12.195147>, <1.793441, -2.862489, -12.441892>, 
      <0.664698, -2.894900, -11.717257>, <0.664698, -2.922817, -11.963607>, <0.755931, -3.268054, -12.195147>, <0.755931, -3.292239, -12.441892>, 
      <0.000000, -2.894900, -11.717257>, <0.000000, -2.922817, -11.963607>, <0.000000, -3.268054, -12.195147>, <0.000000, -3.292239, -12.441892>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 2.951663, -9.436507>, <0.000000, 2.976038, -10.120510>, <0.000000, 2.817832, -11.037172>, <0.000000, 2.894900, -11.717257>, 
      <0.677732, 2.951663, -9.436507>, <0.677732, 2.976038, -10.120510>, <0.664698, 2.817831, -11.037172>, <0.664698, 2.894900, -11.717257>, 
      <1.607912, 2.566369, -9.436507>, <1.625148, 2.583605, -10.120510>, <1.522496, 2.462519, -11.037172>, <1.576991, 2.517015, -11.717257>, 
      <2.087141, 2.087140, -9.436507>, <2.104377, 2.104376, -10.120510>, <1.992508, 1.992506, -11.037172>, <2.047004, 2.047002, -11.717257>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.087140, 2.087141, -9.436507>, <-2.104376, 2.104377, -10.120510>, <-1.992507, 1.992508, -11.037172>, <-2.047003, 2.047004, -11.717257>, 
      <-1.607912, 2.566370, -9.436507>, <-1.625148, 2.583606, -10.120510>, <-1.522495, 2.462521, -11.037172>, <-1.576991, 2.517016, -11.717257>, 
      <-0.677731, 2.951663, -9.436507>, <-0.677731, 2.976038, -10.120510>, <-0.664698, 2.817832, -11.037172>, <-0.664698, 2.894900, -11.717257>, 
      <0.000000, 2.951663, -9.436507>, <0.000000, 2.976038, -10.120510>, <0.000000, 2.817832, -11.037172>, <0.000000, 2.894900, -11.717257>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.951663, 0.000000, -9.436507>, <-2.976038, 0.000000, -10.120510>, <-2.817832, 0.000000, -11.037172>, <-2.894900, 0.000000, -11.717257>, 
      <-2.951663, 0.677732, -9.436507>, <-2.976038, 0.677732, -10.120510>, <-2.817832, 0.664698, -11.037172>, <-2.894900, 0.664698, -11.717257>, 
      <-2.566369, 1.607912, -9.436507>, <-2.583605, 1.625148, -10.120510>, <-2.462520, 1.522496, -11.037172>, <-2.517016, 1.576991, -11.717257>, 
      <-2.087140, 2.087141, -9.436507>, <-2.104376, 2.104377, -10.120510>, <-1.992507, 1.992508, -11.037172>, <-2.047003, 2.047004, -11.717257>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.087141, -2.087141, -9.436507>, <-2.104377, -2.104377, -10.120510>, <-1.992507, -1.992507, -11.037172>, <-2.047003, -2.047003, -11.717257>, 
      <-2.566370, -1.607912, -9.436507>, <-2.583605, -1.625148, -10.120510>, <-2.462520, -1.522495, -11.037172>, <-2.517015, -1.576991, -11.717257>, 
      <-2.951663, -0.677732, -9.436507>, <-2.976038, -0.677732, -10.120510>, <-2.817832, -0.664698, -11.037172>, <-2.894900, -0.664698, -11.717257>, 
      <-2.951663, 0.000000, -9.436507>, <-2.976038, 0.000000, -10.120510>, <-2.817832, 0.000000, -11.037172>, <-2.894900, 0.000000, -11.717257>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -2.951663, -9.436507>, <0.000000, -2.976038, -10.120510>, <0.000000, -2.817832, -11.037172>, <0.000000, -2.894900, -11.717257>, 
      <-0.677732, -2.951663, -9.436507>, <-0.677732, -2.976038, -10.120510>, <-0.664698, -2.817832, -11.037172>, <-0.664698, -2.894900, -11.717257>, 
      <-1.607912, -2.566370, -9.436507>, <-1.625148, -2.583605, -10.120510>, <-1.522495, -2.462520, -11.037172>, <-1.576991, -2.517015, -11.717257>, 
      <-2.087141, -2.087141, -9.436507>, <-2.104377, -2.104377, -10.120510>, <-1.992507, -1.992507, -11.037172>, <-2.047003, -2.047003, -11.717257>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.087141, -2.087141, -9.436507>, <2.104377, -2.104377, -10.120510>, <1.992507, -1.992507, -11.037172>, <2.047003, -2.047003, -11.717257>, 
      <1.607912, -2.566370, -9.436507>, <1.625148, -2.583605, -10.120510>, <1.522495, -2.462520, -11.037172>, <1.576991, -2.517015, -11.717257>, 
      <0.677732, -2.951663, -9.436507>, <0.677732, -2.976038, -10.120510>, <0.664698, -2.817832, -11.037172>, <0.664698, -2.894900, -11.717257>, 
      <0.000000, -2.951663, -9.436507>, <0.000000, -2.976038, -10.120510>, <0.000000, -2.817832, -11.037172>, <0.000000, -2.894900, -11.717257>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 2.781374, -8.531567>, <0.000000, 2.915012, -8.773338>, <0.000000, 2.941825, -9.160436>, <0.000000, 2.951663, -9.436507>, 
      <0.638632, 2.781374, -8.531567>, <0.638632, 2.915012, -8.773338>, <0.677732, 2.941825, -9.160436>, <0.677732, 2.951663, -9.436507>, 
      <1.515148, 2.418309, -8.531567>, <1.609645, 2.512805, -8.773338>, <1.600956, 2.559412, -9.160436>, <1.607912, 2.566369, -9.436507>, 
      <1.966729, 1.966728, -8.531567>, <2.061225, 2.061224, -8.773338>, <2.080184, 2.080184, -9.160436>, <2.087141, 2.087140, -9.436507>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.966728, 1.966729, -8.531567>, <-2.061224, 2.061225, -8.773338>, <-2.080184, 2.080184, -9.160436>, <-2.087140, 2.087141, -9.436507>, 
      <-1.515147, 2.418309, -8.531567>, <-1.609644, 2.512806, -8.773338>, <-1.600955, 2.559413, -9.160436>, <-1.607912, 2.566370, -9.436507>, 
      <-0.638631, 2.781374, -8.531567>, <-0.638631, 2.915012, -8.773338>, <-0.677731, 2.941825, -9.160436>, <-0.677731, 2.951663, -9.436507>, 
      <0.000000, 2.781374, -8.531567>, <0.000000, 2.915012, -8.773338>, <0.000000, 2.941825, -9.160436>, <0.000000, 2.951663, -9.436507>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.781374, 0.000000, -8.531567>, <-2.915012, 0.000000, -8.773338>, <-2.941825, 0.000000, -9.160436>, <-2.951663, 0.000000, -9.436507>, 
      <-2.781374, 0.638632, -8.531567>, <-2.915012, 0.638632, -8.773338>, <-2.941825, 0.677732, -9.160436>, <-2.951663, 0.677732, -9.436507>, 
      <-2.418309, 1.515148, -8.531567>, <-2.512805, 1.609645, -8.773338>, <-2.559412, 1.600956, -9.160436>, <-2.566369, 1.607912, -9.436507>, 
      <-1.966728, 1.966729, -8.531567>, <-2.061224, 2.061225, -8.773338>, <-2.080184, 2.080184, -9.160436>, <-2.087140, 2.087141, -9.436507>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.966729, -1.966729, -8.531567>, <-2.061225, -2.061225, -8.773338>, <-2.080184, -2.080184, -9.160436>, <-2.087141, -2.087141, -9.436507>, 
      <-2.418310, -1.515148, -8.531567>, <-2.512806, -1.609645, -8.773338>, <-2.559413, -1.600956, -9.160436>, <-2.566370, -1.607912, -9.436507>, 
      <-2.781374, -0.638632, -8.531567>, <-2.915012, -0.638632, -8.773338>, <-2.941825, -0.677732, -9.160436>, <-2.951663, -0.677732, -9.436507>, 
      <-2.781374, 0.000000, -8.531567>, <-2.915012, 0.000000, -8.773338>, <-2.941825, 0.000000, -9.160436>, <-2.951663, 0.000000, -9.436507>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -2.781374, -8.531567>, <0.000000, -2.915012, -8.773338>, <0.000000, -2.941825, -9.160436>, <0.000000, -2.951663, -9.436507>, 
      <-0.638632, -2.781374, -8.531567>, <-0.638632, -2.915012, -8.773338>, <-0.677732, -2.941825, -9.160436>, <-0.677732, -2.951663, -9.436507>, 
      <-1.515148, -2.418310, -8.531567>, <-1.609645, -2.512806, -8.773338>, <-1.600956, -2.559413, -9.160436>, <-1.607912, -2.566370, -9.436507>, 
      <-1.966729, -1.966729, -8.531567>, <-2.061225, -2.061225, -8.773338>, <-2.080184, -2.080184, -9.160436>, <-2.087141, -2.087141, -9.436507>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.966729, -1.966729, -8.531567>, <2.061225, -2.061225, -8.773338>, <2.080184, -2.080184, -9.160436>, <2.087141, -2.087141, -9.436507>, 
      <1.515148, -2.418310, -8.531567>, <1.609645, -2.512806, -8.773338>, <1.600956, -2.559413, -9.160436>, <1.607912, -2.566370, -9.436507>, 
      <0.638632, -2.781374, -8.531567>, <0.638632, -2.915012, -8.773338>, <0.677732, -2.941825, -9.160436>, <0.677732, -2.951663, -9.436507>, 
      <0.000000, -2.781374, -8.531567>, <0.000000, -2.915012, -8.773338>, <0.000000, -2.941825, -9.160436>, <0.000000, -2.951663, -9.436507>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 2.440798, -8.512278>, <0.000000, 2.420391, -8.612559>, <0.000000, 2.731867, -8.442002>, <0.000000, 2.781374, -8.531567>, 
      <0.560432, 2.440798, -8.512278>, <0.560432, 2.420391, -8.612559>, <0.638632, 2.731867, -8.442002>, <0.638632, 2.781374, -8.531567>, 
      <1.329620, 2.122189, -8.512278>, <1.315190, 2.107759, -8.612559>, <1.480142, 2.383302, -8.442002>, <1.515148, 2.418309, -8.531567>, 
      <1.725905, 1.725904, -8.512278>, <1.711475, 1.711474, -8.612559>, <1.931722, 1.931721, -8.442002>, <1.966729, 1.966728, -8.531567>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.725904, 1.725905, -8.512278>, <-1.711474, 1.711475, -8.612559>, <-1.931721, 1.931722, -8.442002>, <-1.966728, 1.966729, -8.531567>, 
      <-1.329619, 2.122190, -8.512278>, <-1.315189, 2.107760, -8.612559>, <-1.480141, 2.383303, -8.442002>, <-1.515147, 2.418309, -8.531567>, 
      <-0.560432, 2.440798, -8.512278>, <-0.560432, 2.420392, -8.612559>, <-0.638631, 2.731868, -8.442002>, <-0.638631, 2.781374, -8.531567>, 
      <0.000000, 2.440798, -8.512278>, <0.000000, 2.420391, -8.612559>, <0.000000, 2.731867, -8.442002>, <0.000000, 2.781374, -8.531567>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.440798, 0.000000, -8.512278>, <-2.420391, 0.000000, -8.612559>, <-2.731867, 0.000000, -8.442002>, <-2.781374, 0.000000, -8.531567>, 
      <-2.440798, 0.560432, -8.512278>, <-2.420391, 0.560432, -8.612559>, <-2.731867, 0.638632, -8.442002>, <-2.781374, 0.638632, -8.531567>, 
      <-2.122189, 1.329620, -8.512278>, <-2.107759, 1.315190, -8.612559>, <-2.383302, 1.480142, -8.442002>, <-2.418309, 1.515148, -8.531567>, 
      <-1.725904, 1.725905, -8.512278>, <-1.711474, 1.711475, -8.612559>, <-1.931721, 1.931722, -8.442002>, <-1.966728, 1.966729, -8.531567>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.725905, -1.725905, -8.512278>, <-1.711475, -1.711475, -8.612559>, <-1.931722, -1.931722, -8.442002>, <-1.966729, -1.966729, -8.531567>, 
      <-2.122190, -1.329620, -8.512278>, <-2.107760, -1.315190, -8.612559>, <-2.383303, -1.480142, -8.442002>, <-2.418310, -1.515148, -8.531567>, 
      <-2.440798, -0.560432, -8.512278>, <-2.420392, -0.560432, -8.612559>, <-2.731868, -0.638632, -8.442002>, <-2.781374, -0.638632, -8.531567>, 
      <-2.440798, 0.000000, -8.512278>, <-2.420391, 0.000000, -8.612559>, <-2.731867, 0.000000, -8.442002>, <-2.781374, 0.000000, -8.531567>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -2.440798, -8.512278>, <0.000000, -2.420391, -8.612559>, <0.000000, -2.731867, -8.442002>, <0.000000, -2.781374, -8.531567>, 
      <-0.560432, -2.440798, -8.512278>, <-0.560432, -2.420391, -8.612559>, <-0.638632, -2.731867, -8.442002>, <-0.638632, -2.781374, -8.531567>, 
      <-1.329620, -2.122190, -8.512278>, <-1.315190, -2.107760, -8.612559>, <-1.480142, -2.383303, -8.442002>, <-1.515148, -2.418310, -8.531567>, 
      <-1.725905, -1.725905, -8.512278>, <-1.711475, -1.711475, -8.612559>, <-1.931722, -1.931722, -8.442002>, <-1.966729, -1.966729, -8.531567>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.725905, -1.725905, -8.512278>, <1.711475, -1.711475, -8.612559>, <1.931722, -1.931722, -8.442002>, <1.966729, -1.966729, -8.531567>, 
      <1.329620, -2.122190, -8.512278>, <1.315190, -2.107760, -8.612559>, <1.480142, -2.383303, -8.442002>, <1.515148, -2.418310, -8.531567>, 
      <0.560432, -2.440798, -8.512278>, <0.560432, -2.420391, -8.612559>, <0.638632, -2.731867, -8.442002>, <0.638632, -2.781374, -8.531567>, 
      <0.000000, -2.440798, -8.512278>, <0.000000, -2.420391, -8.612559>, <0.000000, -2.731867, -8.442002>, <0.000000, -2.781374, -8.531567>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 3.121951, -6.857923>, <0.000000, 2.878303, -7.336162>, <0.000000, 2.547826, -7.986329>, <0.000000, 2.440798, -8.512278>, 
      <0.716832, 3.121951, -6.857923>, <0.716832, 2.878303, -7.336162>, <0.560432, 2.547826, -7.986329>, <0.560432, 2.440798, -8.512278>, 
      <1.700676, 2.714428, -6.857923>, <1.528391, 2.542143, -7.336162>, <1.405299, 2.197869, -7.986329>, <1.329620, 2.122189, -8.512278>, 
      <2.207553, 2.207552, -6.857923>, <2.035268, 2.035267, -7.336162>, <1.801585, 1.801584, -7.986329>, <1.725905, 1.725904, -8.512278>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.207552, 2.207553, -6.857923>, <-2.035267, 2.035268, -7.336162>, <-1.801584, 1.801585, -7.986329>, <-1.725904, 1.725905, -8.512278>, 
      <-1.700676, 2.714429, -6.857923>, <-1.528390, 2.542144, -7.336162>, <-1.405299, 2.197870, -7.986329>, <-1.329619, 2.122190, -8.512278>, 
      <-0.716831, 3.121951, -6.857923>, <-0.716831, 2.878304, -7.336162>, <-0.560432, 2.547826, -7.986329>, <-0.560432, 2.440798, -8.512278>, 
      <0.000000, 3.121951, -6.857923>, <0.000000, 2.878303, -7.336162>, <0.000000, 2.547826, -7.986329>, <0.000000, 2.440798, -8.512278>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.121951, 0.000000, -6.857923>, <-2.878303, 0.000000, -7.336162>, <-2.547826, 0.000000, -7.986329>, <-2.440798, 0.000000, -8.512278>, 
      <-3.121951, 0.716832, -6.857923>, <-2.878303, 0.716832, -7.336162>, <-2.547826, 0.560432, -7.986329>, <-2.440798, 0.560432, -8.512278>, 
      <-2.714428, 1.700676, -6.857923>, <-2.542143, 1.528391, -7.336162>, <-2.197869, 1.405299, -7.986329>, <-2.122189, 1.329620, -8.512278>, 
      <-2.207552, 2.207553, -6.857923>, <-2.035267, 2.035268, -7.336162>, <-1.801584, 1.801585, -7.986329>, <-1.725904, 1.725905, -8.512278>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.207553, -2.207552, -6.857923>, <-2.035268, -2.035267, -7.336162>, <-1.801585, -1.801584, -7.986329>, <-1.725905, -1.725905, -8.512278>, 
      <-2.714429, -1.700676, -6.857923>, <-2.542144, -1.528391, -7.336162>, <-2.197870, -1.405299, -7.986329>, <-2.122190, -1.329620, -8.512278>, 
      <-3.121951, -0.716831, -6.857923>, <-2.878304, -0.716831, -7.336162>, <-2.547826, -0.560432, -7.986329>, <-2.440798, -0.560432, -8.512278>, 
      <-3.121951, 0.000000, -6.857923>, <-2.878303, 0.000000, -7.336162>, <-2.547826, 0.000000, -7.986329>, <-2.440798, 0.000000, -8.512278>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -3.121951, -6.857923>, <0.000000, -2.878303, -7.336162>, <0.000000, -2.547826, -7.986329>, <0.000000, -2.440798, -8.512278>, 
      <-0.716832, -3.121951, -6.857923>, <-0.716832, -2.878303, -7.336162>, <-0.560432, -2.547826, -7.986329>, <-0.560432, -2.440798, -8.512278>, 
      <-1.700676, -2.714428, -6.857923>, <-1.528391, -2.542143, -7.336162>, <-1.405299, -2.197870, -7.986329>, <-1.329620, -2.122190, -8.512278>, 
      <-2.207553, -2.207552, -6.857923>, <-2.035268, -2.035267, -7.336162>, <-1.801585, -1.801584, -7.986329>, <-1.725905, -1.725905, -8.512278>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.207552, -2.207552, -6.857923>, <2.035267, -2.035267, -7.336162>, <1.801584, -1.801584, -7.986329>, <1.725905, -1.725905, -8.512278>, 
      <1.700676, -2.714428, -6.857923>, <1.528391, -2.542143, -7.336162>, <1.405299, -2.197870, -7.986329>, <1.329620, -2.122190, -8.512278>, 
      <0.716831, -3.121951, -6.857923>, <0.716831, -2.878303, -7.336162>, <0.560432, -2.547826, -7.986329>, <0.560432, -2.440798, -8.512278>, 
      <0.000000, -3.121951, -6.857923>, <0.000000, -2.878303, -7.336162>, <0.000000, -2.547826, -7.986329>, <0.000000, -2.440798, -8.512278>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 3.746341, -5.949719>, <-0.000000, 3.597784, -6.245106>, <0.000000, 3.272045, -6.563314>, <0.000000, 3.121951, -6.857923>, 
      <0.860198, 3.746341, -5.949719>, <0.860198, 3.597784, -6.245106>, <0.716832, 3.272045, -6.563314>, <0.716832, 3.121951, -6.857923>, 
      <2.040812, 3.257313, -5.949719>, <1.935766, 3.152268, -6.245106>, <1.806809, 2.820561, -6.563314>, <1.700676, 2.714428, -6.857923>, 
      <2.649063, 2.649062, -5.949719>, <2.544018, 2.544017, -6.245106>, <2.313685, 2.313684, -6.563314>, <2.207553, 2.207552, -6.857923>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.649063, 2.649063, -5.949719>, <-2.544018, 2.544018, -6.245106>, <-2.313685, 2.313685, -6.563314>, <-2.207552, 2.207553, -6.857923>, 
      <-2.040812, 3.257315, -5.949719>, <-1.935766, 3.152269, -6.245106>, <-1.806808, 2.820562, -6.563314>, <-1.700676, 2.714429, -6.857923>, 
      <-0.860198, 3.746341, -5.949719>, <-0.860198, 3.597785, -6.245106>, <-0.716831, 3.272045, -6.563314>, <-0.716831, 3.121951, -6.857923>, 
      <0.000000, 3.746341, -5.949719>, <-0.000000, 3.597784, -6.245106>, <0.000000, 3.272045, -6.563314>, <0.000000, 3.121951, -6.857923>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.746341, 0.000000, -5.949719>, <-3.597784, 0.000000, -6.245106>, <-3.272045, 0.000000, -6.563314>, <-3.121951, 0.000000, -6.857923>, 
      <-3.746341, 0.860198, -5.949719>, <-3.597784, 0.860198, -6.245106>, <-3.272045, 0.716832, -6.563314>, <-3.121951, 0.716832, -6.857923>, 
      <-3.257315, 2.040812, -5.949719>, <-3.152269, 1.935766, -6.245106>, <-2.820561, 1.806809, -6.563314>, <-2.714428, 1.700676, -6.857923>, 
      <-2.649063, 2.649063, -5.949719>, <-2.544018, 2.544018, -6.245106>, <-2.313685, 2.313685, -6.563314>, <-2.207552, 2.207553, -6.857923>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.649063, -2.649063, -5.949719>, <-2.544018, -2.544018, -6.245106>, <-2.313685, -2.313684, -6.563314>, <-2.207553, -2.207552, -6.857923>, 
      <-3.257315, -2.040812, -5.949719>, <-3.152269, -1.935766, -6.245106>, <-2.820562, -1.806808, -6.563314>, <-2.714429, -1.700676, -6.857923>, 
      <-3.746341, -0.860198, -5.949719>, <-3.597784, -0.860198, -6.245106>, <-3.272045, -0.716831, -6.563314>, <-3.121951, -0.716831, -6.857923>, 
      <-3.746341, 0.000000, -5.949719>, <-3.597784, 0.000000, -6.245106>, <-3.272045, 0.000000, -6.563314>, <-3.121951, 0.000000, -6.857923>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -3.746341, -5.949719>, <0.000000, -3.597784, -6.245106>, <0.000000, -3.272045, -6.563314>, <0.000000, -3.121951, -6.857923>, 
      <-0.860198, -3.746341, -5.949719>, <-0.860198, -3.597784, -6.245106>, <-0.716832, -3.272045, -6.563314>, <-0.716832, -3.121951, -6.857923>, 
      <-2.040812, -3.257315, -5.949719>, <-1.935766, -3.152269, -6.245106>, <-1.806809, -2.820561, -6.563314>, <-1.700676, -2.714428, -6.857923>, 
      <-2.649063, -2.649063, -5.949719>, <-2.544018, -2.544018, -6.245106>, <-2.313685, -2.313684, -6.563314>, <-2.207553, -2.207552, -6.857923>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.649063, -2.649063, -5.949719>, <2.544018, -2.544018, -6.245107>, <2.313684, -2.313684, -6.563314>, <2.207552, -2.207552, -6.857923>, 
      <2.040812, -3.257315, -5.949719>, <1.935766, -3.152269, -6.245107>, <1.806808, -2.820561, -6.563314>, <1.700676, -2.714428, -6.857923>, 
      <0.860198, -3.746341, -5.949719>, <0.860198, -3.597784, -6.245106>, <0.716831, -3.272045, -6.563314>, <0.716831, -3.121951, -6.857923>, 
      <0.000000, -3.746341, -5.949719>, <0.000000, -3.597784, -6.245106>, <0.000000, -3.272045, -6.563314>, <0.000000, -3.121951, -6.857923>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000001, 4.541138, -4.036035>, <0.000001, 4.392984, -4.639774>, <0.000000, 4.025649, -5.394348>, <0.000000, 3.746341, -5.949719>, 
      <1.042692, 4.541138, -4.036035>, <1.042692, 4.392984, -4.639774>, <0.860198, 4.025649, -5.394348>, <0.860198, 3.746341, -5.949719>, 
      <2.473776, 3.948362, -4.036035>, <2.369016, 3.843602, -4.639774>, <2.238312, 3.454814, -5.394348>, <2.040812, 3.257313, -5.949719>, 
      <3.211070, 3.211068, -4.036035>, <3.106310, 3.106308, -4.639774>, <2.846564, 2.846562, -5.394348>, <2.649063, 2.649062, -5.949719>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.211069, 3.211070, -4.036035>, <-3.106309, 3.106310, -4.639774>, <-2.846564, 2.846564, -5.394348>, <-2.649063, 2.649063, -5.949719>, 
      <-2.473775, 3.948364, -4.036035>, <-2.369015, 3.843603, -4.639774>, <-2.238312, 3.454815, -5.394348>, <-2.040812, 3.257315, -5.949719>, 
      <-1.042690, 4.541139, -4.036035>, <-1.042690, 4.392985, -4.639774>, <-0.860197, 4.025649, -5.394348>, <-0.860198, 3.746341, -5.949719>, 
      <0.000001, 4.541138, -4.036035>, <0.000001, 4.392984, -4.639774>, <0.000000, 4.025649, -5.394348>, <0.000000, 3.746341, -5.949719>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-4.541138, 0.000000, -4.036035>, <-4.392984, 0.000000, -4.639774>, <-4.025649, 0.000000, -5.394348>, <-3.746341, 0.000000, -5.949719>, 
      <-4.541138, 1.042691, -4.036035>, <-4.392984, 1.042691, -4.639774>, <-4.025649, 0.860198, -5.394348>, <-3.746341, 0.860198, -5.949719>, 
      <-3.948363, 2.473776, -4.036035>, <-3.843603, 2.369016, -4.639774>, <-3.454815, 2.238312, -5.394348>, <-3.257315, 2.040812, -5.949719>, 
      <-3.211069, 3.211070, -4.036035>, <-3.106309, 3.106310, -4.639774>, <-2.846564, 2.846564, -5.394348>, <-2.649063, 2.649063, -5.949719>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.211070, -3.211070, -4.036035>, <-3.106310, -3.106310, -4.639774>, <-2.846564, -2.846564, -5.394348>, <-2.649063, -2.649063, -5.949719>, 
      <-3.948364, -2.473776, -4.036035>, <-3.843604, -2.369016, -4.639774>, <-3.454815, -2.238312, -5.394348>, <-3.257315, -2.040812, -5.949719>, 
      <-4.541138, -1.042691, -4.036035>, <-4.392984, -1.042691, -4.639774>, <-4.025649, -0.860198, -5.394348>, <-3.746341, -0.860198, -5.949719>, 
      <-4.541138, 0.000000, -4.036035>, <-4.392984, 0.000000, -4.639774>, <-4.025649, 0.000000, -5.394348>, <-3.746341, 0.000000, -5.949719>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -4.541138, -4.036035>, <0.000000, -4.392984, -4.639774>, <0.000000, -4.025649, -5.394348>, <0.000000, -3.746341, -5.949719>, 
      <-1.042691, -4.541138, -4.036035>, <-1.042691, -4.392984, -4.639774>, <-0.860198, -4.025649, -5.394348>, <-0.860198, -3.746341, -5.949719>, 
      <-2.473776, -3.948364, -4.036035>, <-2.369016, -3.843604, -4.639774>, <-2.238312, -3.454815, -5.394348>, <-2.040812, -3.257315, -5.949719>, 
      <-3.211070, -3.211070, -4.036035>, <-3.106310, -3.106310, -4.639774>, <-2.846564, -2.846564, -5.394348>, <-2.649063, -2.649063, -5.949719>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.211070, -3.211070, -4.036035>, <3.106310, -3.106310, -4.639774>, <2.846564, -2.846564, -5.394348>, <2.649063, -2.649063, -5.949719>, 
      <2.473776, -3.948364, -4.036035>, <2.369016, -3.843604, -4.639774>, <2.238312, -3.454815, -5.394348>, <2.040812, -3.257315, -5.949719>, 
      <1.042691, -4.541138, -4.036035>, <1.042691, -4.392984, -4.639774>, <0.860198, -4.025649, -5.394348>, <0.860198, -3.746341, -5.949719>, 
      <0.000000, -4.541138, -4.036035>, <0.000000, -4.392984, -4.639774>, <0.000000, -4.025649, -5.394348>, <0.000000, -3.746341, -5.949719>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000001, 5.192366, -0.057038>, <0.000001, 5.245845, -1.265436>, <0.000001, 4.829409, -2.861307>, <0.000001, 4.541138, -4.036035>, 
      <1.192221, 5.192366, -0.057038>, <1.192221, 5.245844, -1.265436>, <1.042692, 4.829408, -2.861307>, <1.042692, 4.541138, -4.036035>, 
      <2.828532, 4.514583, -0.057038>, <2.866347, 4.552398, -1.265436>, <2.677615, 4.152200, -2.861307>, <2.473776, 3.948362, -4.036035>, 
      <3.671558, 3.671556, -0.057038>, <3.709373, 3.709371, -1.265436>, <3.414908, 3.414906, -2.861307>, <3.211070, 3.211068, -4.036035>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.671557, 3.671558, -0.057038>, <-3.709372, 3.709373, -1.265436>, <-3.414907, 3.414908, -2.861307>, <-3.211069, 3.211070, -4.036035>, 
      <-2.828530, 4.514584, -0.057038>, <-2.866346, 4.552400, -1.265436>, <-2.677613, 4.152202, -2.861307>, <-2.473775, 3.948364, -4.036035>, 
      <-1.192219, 5.192367, -0.057038>, <-1.192219, 5.245845, -1.265436>, <-1.042690, 4.829409, -2.861307>, <-1.042690, 4.541139, -4.036035>, 
      <0.000001, 5.192366, -0.057038>, <0.000001, 5.245845, -1.265436>, <0.000001, 4.829409, -2.861307>, <0.000001, 4.541138, -4.036035>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-5.192366, 0.000000, -0.057038>, <-5.245845, 0.000000, -1.265436>, <-4.829409, 0.000000, -2.861307>, <-4.541138, 0.000000, -4.036035>, 
      <-5.192366, 1.192220, -0.057038>, <-5.245845, 1.192220, -1.265436>, <-4.829409, 1.042691, -2.861307>, <-4.541138, 1.042691, -4.036035>, 
      <-4.514584, 2.828531, -0.057038>, <-4.552399, 2.866347, -1.265436>, <-4.152202, 2.677614, -2.861307>, <-3.948363, 2.473776, -4.036035>, 
      <-3.671557, 3.671558, -0.057038>, <-3.709372, 3.709373, -1.265436>, <-3.414907, 3.414908, -2.861307>, <-3.211069, 3.211070, -4.036035>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.671557, -3.671557, -0.057038>, <-3.709372, -3.709372, -1.265436>, <-3.414908, -3.414908, -2.861307>, <-3.211070, -3.211070, -4.036035>, 
      <-4.514584, -2.828530, -0.057038>, <-4.552399, -2.866346, -1.265436>, <-4.152202, -2.677614, -2.861307>, <-3.948364, -2.473776, -4.036035>, 
      <-5.192366, -1.192220, -0.057038>, <-5.245845, -1.192220, -1.265436>, <-4.829409, -1.042691, -2.861307>, <-4.541138, -1.042691, -4.036035>, 
      <-5.192366, 0.000000, -0.057038>, <-5.245845, 0.000000, -1.265436>, <-4.829409, 0.000000, -2.861307>, <-4.541138, 0.000000, -4.036035>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -5.192366, -0.057038>, <0.000000, -5.245845, -1.265436>, <0.000000, -4.829409, -2.861307>, <0.000000, -4.541138, -4.036035>, 
      <-1.192220, -5.192366, -0.057038>, <-1.192220, -5.245845, -1.265436>, <-1.042691, -4.829409, -2.861307>, <-1.042691, -4.541138, -4.036035>, 
      <-2.828530, -4.514584, -0.057038>, <-2.866346, -4.552399, -1.265436>, <-2.677614, -4.152202, -2.861307>, <-2.473776, -3.948364, -4.036035>, 
      <-3.671557, -3.671557, -0.057038>, <-3.709372, -3.709372, -1.265436>, <-3.414908, -3.414908, -2.861307>, <-3.211070, -3.211070, -4.036035>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.671557, -3.671557, -0.057038>, <3.709372, -3.709372, -1.265436>, <3.414908, -3.414908, -2.861307>, <3.211070, -3.211070, -4.036035>, 
      <2.828530, -4.514584, -0.057038>, <2.866346, -4.552399, -1.265436>, <2.677614, -4.152202, -2.861307>, <2.473776, -3.948364, -4.036035>, 
      <1.192220, -5.192366, -0.057038>, <1.192220, -5.245845, -1.265436>, <1.042691, -4.829409, -2.861307>, <1.042691, -4.541138, -4.036035>, 
      <0.000000, -5.192366, -0.057038>, <0.000000, -5.245845, -1.265436>, <0.000000, -4.829409, -2.861307>, <0.000000, -4.541138, -4.036035>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 3.388075, 22.018371>, <0.000000, 3.818974, 15.387651>, <0.000001, 4.898586, 6.581171>, <0.000001, 5.192366, -0.057038>, 
      <0.777936, 3.388075, 22.018371>, <0.777937, 3.818974, 15.387651>, <1.192220, 4.898585, 6.581171>, <1.192221, 5.192366, -0.057038>, 
      <1.845647, 2.945814, 22.018371>, <2.150339, 3.250506, 15.387651>, <2.620797, 4.306848, 6.581171>, <2.828532, 4.514583, -0.057038>, 
      <2.395731, 2.395730, 22.018371>, <2.700423, 2.700422, 15.387651>, <3.463824, 3.463822, 6.581171>, <3.671558, 3.671556, -0.057038>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.395731, 2.395731, 22.018371>, <-2.700423, 2.700423, 15.387651>, <-3.463823, 3.463824, 6.581171>, <-3.671557, 3.671558, -0.057038>, 
      <-1.845647, 2.945815, 22.018371>, <-2.150339, 3.250507, 15.387651>, <-2.620796, 4.306850, 6.581171>, <-2.828530, 4.514584, -0.057038>, 
      <-0.777936, 3.388075, 22.018371>, <-0.777936, 3.818974, 15.387651>, <-1.192219, 4.898586, 6.581171>, <-1.192219, 5.192367, -0.057038>, 
      <0.000000, 3.388075, 22.018371>, <0.000000, 3.818974, 15.387651>, <0.000001, 4.898586, 6.581171>, <0.000001, 5.192366, -0.057038>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.388075, 0.000000, 22.018371>, <-3.818974, 0.000000, 15.387651>, <-4.898586, 0.000000, 6.581171>, <-5.192366, 0.000000, -0.057038>, 
      <-3.388075, 0.777936, 22.018371>, <-3.818974, 0.777936, 15.387651>, <-4.898586, 1.192220, 6.581171>, <-5.192366, 1.192220, -0.057038>, 
      <-2.945815, 1.845647, 22.018371>, <-3.250507, 2.150339, 15.387651>, <-4.306850, 2.620797, 6.581171>, <-4.514584, 2.828531, -0.057038>, 
      <-2.395731, 2.395731, 22.018371>, <-2.700423, 2.700423, 15.387651>, <-3.463823, 3.463824, 6.581171>, <-3.671557, 3.671558, -0.057038>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.395731, -2.395731, 22.018371>, <-2.700423, -2.700423, 15.387651>, <-3.463823, -3.463823, 6.581171>, <-3.671557, -3.671557, -0.057038>, 
      <-2.945815, -1.845647, 22.018371>, <-3.250507, -2.150339, 15.387651>, <-4.306850, -2.620796, 6.581171>, <-4.514584, -2.828530, -0.057038>, 
      <-3.388075, -0.777936, 22.018371>, <-3.818974, -0.777936, 15.387651>, <-4.898586, -1.192220, 6.581171>, <-5.192366, -1.192220, -0.057038>, 
      <-3.388075, 0.000000, 22.018371>, <-3.818974, 0.000000, 15.387651>, <-4.898586, 0.000000, 6.581171>, <-5.192366, 0.000000, -0.057038>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -3.388075, 22.018371>, <0.000000, -3.818974, 15.387651>, <0.000000, -4.898586, 6.581171>, <0.000000, -5.192366, -0.057038>, 
      <-0.777936, -3.388075, 22.018371>, <-0.777936, -3.818974, 15.387651>, <-1.192220, -4.898586, 6.581171>, <-1.192220, -5.192366, -0.057038>, 
      <-1.845647, -2.945815, 22.018371>, <-2.150339, -3.250507, 15.387651>, <-2.620796, -4.306850, 6.581171>, <-2.828530, -4.514584, -0.057038>, 
      <-2.395731, -2.395731, 22.018371>, <-2.700423, -2.700423, 15.387651>, <-3.463823, -3.463823, 6.581171>, <-3.671557, -3.671557, -0.057038>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.395731, -2.395731, 22.018371>, <2.700423, -2.700423, 15.387651>, <3.463823, -3.463823, 6.581171>, <3.671557, -3.671557, -0.057038>, 
      <1.845647, -2.945815, 22.018371>, <2.150339, -3.250507, 15.387651>, <2.620796, -4.306850, 6.581171>, <2.828530, -4.514584, -0.057038>, 
      <0.777936, -3.388075, 22.018371>, <0.777936, -3.818974, 15.387651>, <1.192220, -4.898586, 6.581171>, <1.192220, -5.192366, -0.057038>, 
      <0.000000, -3.388075, 22.018371>, <0.000000, -3.818974, 15.387651>, <0.000000, -4.898586, 6.581171>, <0.000000, -5.192366, -0.057038>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 3.730029, 22.445547>, <0.000000, 3.783579, 22.290371>, <0.000000, 3.377430, 22.182182>, <0.000000, 3.388075, 22.018371>, 
      <0.856452, 3.730029, 22.445547>, <0.856452, 3.783578, 22.290371>, <0.777936, 3.377430, 22.182182>, <0.777936, 3.388075, 22.018371>, 
      <2.031926, 3.243131, 22.445547>, <2.069791, 3.280996, 22.290371>, <1.838120, 2.938287, 22.182182>, <1.845647, 2.945814, 22.018371>, 
      <2.637529, 2.637528, 22.445547>, <2.675394, 2.675393, 22.290371>, <2.388204, 2.388203, 22.182182>, <2.395731, 2.395730, 22.018371>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.637528, 2.637529, 22.445547>, <-2.675393, 2.675394, 22.290371>, <-2.388204, 2.388204, 22.182182>, <-2.395731, 2.395731, 22.018371>, 
      <-2.031925, 3.243132, 22.445547>, <-2.069790, 3.280997, 22.290371>, <-1.838120, 2.938288, 22.182182>, <-1.845647, 2.945815, 22.018371>, 
      <-0.856452, 3.730029, 22.445547>, <-0.856452, 3.783579, 22.290371>, <-0.777936, 3.377430, 22.182182>, <-0.777936, 3.388075, 22.018371>, 
      <0.000000, 3.730029, 22.445547>, <0.000000, 3.783579, 22.290371>, <0.000000, 3.377430, 22.182182>, <0.000000, 3.388075, 22.018371>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.730029, 0.000000, 22.445547>, <-3.783579, 0.000000, 22.290371>, <-3.377430, 0.000000, 22.182182>, <-3.388075, 0.000000, 22.018371>, 
      <-3.730029, 0.856452, 22.445547>, <-3.783578, 0.856452, 22.290371>, <-3.377430, 0.777936, 22.182182>, <-3.388075, 0.777936, 22.018371>, 
      <-3.243131, 2.031926, 22.445547>, <-3.280996, 2.069791, 22.290371>, <-2.938288, 1.838120, 22.182182>, <-2.945815, 1.845647, 22.018371>, 
      <-2.637528, 2.637529, 22.445547>, <-2.675393, 2.675394, 22.290371>, <-2.388204, 2.388204, 22.182182>, <-2.395731, 2.395731, 22.018371>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.637529, -2.637528, 22.445547>, <-2.675394, -2.675393, 22.290371>, <-2.388204, -2.388204, 22.182182>, <-2.395731, -2.395731, 22.018371>, 
      <-3.243132, -2.031925, 22.445547>, <-3.280997, -2.069790, 22.290371>, <-2.938288, -1.838120, 22.182182>, <-2.945815, -1.845647, 22.018371>, 
      <-3.730029, -0.856452, 22.445547>, <-3.783579, -0.856452, 22.290371>, <-3.377430, -0.777936, 22.182182>, <-3.388075, -0.777936, 22.018371>, 
      <-3.730029, 0.000000, 22.445547>, <-3.783579, 0.000000, 22.290371>, <-3.377430, 0.000000, 22.182182>, <-3.388075, 0.000000, 22.018371>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -3.730029, 22.445547>, <0.000000, -3.783579, 22.290371>, <0.000000, -3.377430, 22.182182>, <0.000000, -3.388075, 22.018371>, 
      <-0.856452, -3.730029, 22.445547>, <-0.856452, -3.783579, 22.290371>, <-0.777936, -3.377430, 22.182182>, <-0.777936, -3.388075, 22.018371>, 
      <-2.031926, -3.243131, 22.445547>, <-2.069791, -3.280996, 22.290371>, <-1.838120, -2.938288, 22.182182>, <-1.845647, -2.945815, 22.018371>, 
      <-2.637529, -2.637528, 22.445547>, <-2.675394, -2.675393, 22.290371>, <-2.388204, -2.388204, 22.182182>, <-2.395731, -2.395731, 22.018371>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.637528, -2.637528, 22.445547>, <2.675393, -2.675393, 22.290371>, <2.388204, -2.388204, 22.182181>, <2.395731, -2.395731, 22.018371>, 
      <2.031925, -3.243131, 22.445547>, <2.069790, -3.280996, 22.290371>, <1.838120, -2.938288, 22.182181>, <1.845647, -2.945815, 22.018371>, 
      <0.856452, -3.730029, 22.445547>, <0.856452, -3.783579, 22.290371>, <0.777936, -3.377430, 22.182182>, <0.777936, -3.388075, 22.018371>, 
      <0.000000, -3.730029, 22.445547>, <0.000000, -3.783579, 22.290371>, <0.000000, -3.377430, 22.182182>, <0.000000, -3.388075, 22.018371>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 3.145757, 22.720562>, <0.000000, 3.155923, 22.527101>, <0.000000, 3.666833, 22.628677>, <0.000000, 3.730029, 22.445547>, 
      <0.722298, 3.145757, 22.720562>, <0.722298, 3.155922, 22.527101>, <0.856452, 3.666832, 22.628677>, <0.856452, 3.730029, 22.445547>, 
      <1.713645, 2.735128, 22.720562>, <1.720834, 2.742316, 22.527101>, <1.987239, 3.198445, 22.628677>, <2.031926, 3.243131, 22.445547>, 
      <2.224387, 2.224386, 22.720562>, <2.231575, 2.231574, 22.527101>, <2.592843, 2.592842, 22.628677>, <2.637529, 2.637528, 22.445547>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.224386, 2.224387, 22.720562>, <-2.231574, 2.231575, 22.527101>, <-2.592841, 2.592843, 22.628677>, <-2.637528, 2.637529, 22.445547>, 
      <-1.713645, 2.735128, 22.720562>, <-1.720833, 2.742317, 22.527101>, <-1.987238, 3.198446, 22.628677>, <-2.031925, 3.243132, 22.445547>, 
      <-0.722297, 3.145757, 22.720562>, <-0.722297, 3.155923, 22.527101>, <-0.856452, 3.666833, 22.628677>, <-0.856452, 3.730029, 22.445547>, 
      <0.000000, 3.145757, 22.720562>, <0.000000, 3.155923, 22.527101>, <0.000000, 3.666833, 22.628677>, <0.000000, 3.730029, 22.445547>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.145757, 0.000000, 22.720562>, <-3.155923, 0.000000, 22.527101>, <-3.666833, 0.000000, 22.628677>, <-3.730029, 0.000000, 22.445547>, 
      <-3.145757, 0.722298, 22.720562>, <-3.155923, 0.722298, 22.527101>, <-3.666832, 0.856452, 22.628677>, <-3.730029, 0.856452, 22.445547>, 
      <-2.735128, 1.713645, 22.720562>, <-2.742316, 1.720834, 22.527101>, <-3.198445, 1.987239, 22.628677>, <-3.243131, 2.031926, 22.445547>, 
      <-2.224386, 2.224387, 22.720562>, <-2.231574, 2.231575, 22.527101>, <-2.592841, 2.592843, 22.628677>, <-2.637528, 2.637529, 22.445547>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.224386, -2.224386, 22.720562>, <-2.231574, -2.231574, 22.527101>, <-2.592842, -2.592841, 22.628677>, <-2.637529, -2.637528, 22.445547>, 
      <-2.735127, -1.713645, 22.720562>, <-2.742316, -1.720833, 22.527101>, <-3.198445, -1.987238, 22.628677>, <-3.243132, -2.031925, 22.445547>, 
      <-3.145757, -0.722298, 22.720562>, <-3.155923, -0.722298, 22.527101>, <-3.666833, -0.856452, 22.628677>, <-3.730029, -0.856452, 22.445547>, 
      <-3.145757, 0.000000, 22.720562>, <-3.155923, 0.000000, 22.527101>, <-3.666833, 0.000000, 22.628677>, <-3.730029, 0.000000, 22.445547>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -3.145757, 22.720562>, <0.000000, -3.155923, 22.527101>, <0.000000, -3.666833, 22.628677>, <0.000000, -3.730029, 22.445547>, 
      <-0.722298, -3.145757, 22.720562>, <-0.722298, -3.155923, 22.527101>, <-0.856452, -3.666833, 22.628677>, <-0.856452, -3.730029, 22.445547>, 
      <-1.713645, -2.735127, 22.720562>, <-1.720833, -2.742316, 22.527101>, <-1.987239, -3.198445, 22.628677>, <-2.031926, -3.243131, 22.445547>, 
      <-2.224386, -2.224386, 22.720562>, <-2.231574, -2.231574, 22.527101>, <-2.592842, -2.592841, 22.628677>, <-2.637529, -2.637528, 22.445547>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.224386, -2.224386, 22.720562>, <2.231574, -2.231574, 22.527101>, <2.592841, -2.592841, 22.628677>, <2.637528, -2.637528, 22.445547>, 
      <1.713645, -2.735127, 22.720562>, <1.720833, -2.742316, 22.527101>, <1.987238, -3.198445, 22.628677>, <2.031925, -3.243131, 22.445547>, 
      <0.722298, -3.145757, 22.720562>, <0.722298, -3.155923, 22.527101>, <0.856452, -3.666833, 22.628677>, <0.856452, -3.730029, 22.445547>, 
      <0.000000, -3.145757, 22.720562>, <0.000000, -3.155923, 22.527101>, <0.000000, -3.666833, 22.628677>, <0.000000, -3.730029, 22.445547>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 2.330597, 49.077763>, <0.000000, 2.463962, 41.167946>, <0.000000, 2.730637, 30.620605>, <0.000000, 3.145757, 22.720562>, 
      <0.535129, 2.330597, 49.077763>, <0.535129, 2.463962, 41.167946>, <0.722298, 2.730636, 30.620605>, <0.722298, 3.145757, 22.720562>, 
      <1.269588, 2.026373, 49.077763>, <1.363892, 2.120677, 41.167946>, <1.420111, 2.441593, 30.620605>, <1.713645, 2.735128, 22.720562>, 
      <1.647981, 1.647980, 49.077763>, <1.742285, 1.742284, 41.167946>, <1.930853, 1.930852, 30.620605>, <2.224387, 2.224386, 22.720562>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.647981, 1.647981, 49.077763>, <-1.742285, 1.742285, 41.167946>, <-1.930852, 1.930853, 30.620605>, <-2.224386, 2.224387, 22.720562>, 
      <-1.269588, 2.026374, 49.077763>, <-1.363892, 2.120678, 41.167946>, <-1.420111, 2.441594, 30.620605>, <-1.713645, 2.735128, 22.720562>, 
      <-0.535129, 2.330597, 49.077763>, <-0.535129, 2.463962, 41.167946>, <-0.722297, 2.730637, 30.620605>, <-0.722297, 3.145757, 22.720562>, 
      <0.000000, 2.330597, 49.077763>, <0.000000, 2.463962, 41.167946>, <0.000000, 2.730637, 30.620605>, <0.000000, 3.145757, 22.720562>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.330597, 0.000000, 49.077763>, <-2.463962, 0.000000, 41.167946>, <-2.730637, 0.000000, 30.620605>, <-3.145757, 0.000000, 22.720562>, 
      <-2.330597, 0.535129, 49.077763>, <-2.463962, 0.535129, 41.167946>, <-2.730637, 0.722298, 30.620605>, <-3.145757, 0.722298, 22.720562>, 
      <-2.026374, 1.269588, 49.077763>, <-2.120677, 1.363892, 41.167946>, <-2.441594, 1.420111, 30.620605>, <-2.735128, 1.713645, 22.720562>, 
      <-1.647981, 1.647981, 49.077763>, <-1.742285, 1.742285, 41.167946>, <-1.930852, 1.930853, 30.620605>, <-2.224386, 2.224387, 22.720562>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.647981, -1.647981, 49.077763>, <-1.742285, -1.742285, 41.167946>, <-1.930852, -1.930852, 30.620605>, <-2.224386, -2.224386, 22.720562>, 
      <-2.026374, -1.269588, 49.077763>, <-2.120677, -1.363892, 41.167946>, <-2.441593, -1.420111, 30.620605>, <-2.735127, -1.713645, 22.720562>, 
      <-2.330597, -0.535129, 49.077763>, <-2.463962, -0.535129, 41.167946>, <-2.730637, -0.722298, 30.620605>, <-3.145757, -0.722298, 22.720562>, 
      <-2.330597, 0.000000, 49.077763>, <-2.463962, 0.000000, 41.167946>, <-2.730637, 0.000000, 30.620605>, <-3.145757, 0.000000, 22.720562>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -2.330597, 49.077763>, <0.000000, -2.463962, 41.167946>, <0.000000, -2.730637, 30.620605>, <0.000000, -3.145757, 22.720562>, 
      <-0.535129, -2.330597, 49.077763>, <-0.535129, -2.463962, 41.167946>, <-0.722298, -2.730637, 30.620605>, <-0.722298, -3.145757, 22.720562>, 
      <-1.269588, -2.026374, 49.077763>, <-1.363892, -2.120677, 41.167946>, <-1.420110, -2.441593, 30.620605>, <-1.713645, -2.735127, 22.720562>, 
      <-1.647981, -1.647981, 49.077763>, <-1.742285, -1.742285, 41.167946>, <-1.930852, -1.930852, 30.620605>, <-2.224386, -2.224386, 22.720562>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.647981, -1.647981, 49.077763>, <1.742285, -1.742285, 41.167946>, <1.930852, -1.930852, 30.620605>, <2.224386, -2.224386, 22.720562>, 
      <1.269588, -2.026374, 49.077763>, <1.363892, -2.120677, 41.167946>, <1.420111, -2.441593, 30.620605>, <1.713645, -2.735127, 22.720562>, 
      <0.535129, -2.330597, 49.077763>, <0.535129, -2.463962, 41.167946>, <0.722298, -2.730637, 30.620605>, <0.722298, -3.145757, 22.720562>, 
      <0.000000, -2.330597, 49.077763>, <0.000000, -2.463962, 41.167946>, <0.000000, -2.730637, 30.620605>, <0.000000, -3.145757, 22.720562>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 2.693499, 49.543744>, <0.000000, 2.716117, 49.368003>, <0.000000, 2.327610, 49.254925>, <0.000000, 2.330597, 49.077763>, 
      <0.618455, 2.693499, 49.543744>, <0.618455, 2.716117, 49.368003>, <0.535129, 2.327610, 49.254925>, <0.535129, 2.330597, 49.077763>, 
      <1.467278, 2.341903, 49.543744>, <1.483271, 2.357897, 49.368006>, <1.267476, 2.024261, 49.254925>, <1.269588, 2.026373, 49.077763>, 
      <1.904591, 1.904590, 49.543744>, <1.920585, 1.920584, 49.368006>, <1.645869, 1.645868, 49.254925>, <1.647981, 1.647980, 49.077763>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.904591, 1.904591, 49.543744>, <-1.920585, 1.920585, 49.368006>, <-1.645869, 1.645869, 49.254925>, <-1.647981, 1.647981, 49.077763>, 
      <-1.467278, 2.341904, 49.543744>, <-1.483272, 2.357898, 49.368006>, <-1.267476, 2.024262, 49.254925>, <-1.269588, 2.026374, 49.077763>, 
      <-0.618454, 2.693499, 49.543744>, <-0.618454, 2.716118, 49.368003>, <-0.535129, 2.327610, 49.254925>, <-0.535129, 2.330597, 49.077763>, 
      <0.000000, 2.693499, 49.543744>, <0.000000, 2.716117, 49.368003>, <0.000000, 2.327610, 49.254925>, <0.000000, 2.330597, 49.077763>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.693499, 0.000000, 49.543744>, <-2.716117, 0.000000, 49.368003>, <-2.327610, 0.000000, 49.254925>, <-2.330597, 0.000000, 49.077763>, 
      <-2.693499, 0.618454, 49.543744>, <-2.716117, 0.618454, 49.368003>, <-2.327610, 0.535129, 49.254925>, <-2.330597, 0.535129, 49.077763>, 
      <-2.341904, 1.467278, 49.543744>, <-2.357898, 1.483271, 49.368006>, <-2.024262, 1.267476, 49.254925>, <-2.026374, 1.269588, 49.077763>, 
      <-1.904591, 1.904591, 49.543744>, <-1.920585, 1.920585, 49.368006>, <-1.645869, 1.645869, 49.254925>, <-1.647981, 1.647981, 49.077763>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.904591, -1.904591, 49.543744>, <-1.920585, -1.920585, 49.368006>, <-1.645869, -1.645869, 49.254925>, <-1.647981, -1.647981, 49.077763>, 
      <-2.341904, -1.467278, 49.543744>, <-2.357898, -1.483272, 49.368006>, <-2.024262, -1.267476, 49.254925>, <-2.026374, -1.269588, 49.077763>, 
      <-2.693499, -0.618454, 49.543744>, <-2.716117, -0.618454, 49.368003>, <-2.327610, -0.535129, 49.254925>, <-2.330597, -0.535129, 49.077763>, 
      <-2.693499, 0.000000, 49.543744>, <-2.716117, 0.000000, 49.368003>, <-2.327610, 0.000000, 49.254925>, <-2.330597, 0.000000, 49.077763>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -2.693499, 49.543744>, <0.000000, -2.716117, 49.368003>, <0.000000, -2.327610, 49.254925>, <0.000000, -2.330597, 49.077763>, 
      <-0.618454, -2.693499, 49.543744>, <-0.618454, -2.716117, 49.368003>, <-0.535129, -2.327610, 49.254925>, <-0.535129, -2.330597, 49.077763>, 
      <-1.467278, -2.341904, 49.543744>, <-1.483272, -2.357898, 49.368006>, <-1.267476, -2.024262, 49.254925>, <-1.269588, -2.026374, 49.077763>, 
      <-1.904591, -1.904591, 49.543744>, <-1.920585, -1.920585, 49.368006>, <-1.645869, -1.645869, 49.254925>, <-1.647981, -1.647981, 49.077763>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.904591, -1.904591, 49.543744>, <1.920585, -1.920585, 49.368006>, <1.645869, -1.645869, 49.254925>, <1.647981, -1.647981, 49.077763>, 
      <1.467278, -2.341904, 49.543744>, <1.483272, -2.357898, 49.368006>, <1.267476, -2.024262, 49.254925>, <1.269588, -2.026374, 49.077763>, 
      <0.618454, -2.693499, 49.543744>, <0.618454, -2.716117, 49.368003>, <0.535129, -2.327610, 49.254925>, <0.535129, -2.330597, 49.077763>, 
      <0.000000, -2.693499, 49.543744>, <0.000000, -2.716117, 49.368003>, <0.000000, -2.327610, 49.254925>, <0.000000, -2.330597, 49.077763>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 2.239872, 49.782662>, <0.000000, 2.250134, 49.629197>, <0.000000, 2.673865, 49.696294>, <0.000000, 2.693499, 49.543744>, 
      <0.514297, 2.239872, 49.782662>, <0.514297, 2.250134, 49.629197>, <0.618455, 2.673864, 49.696294>, <0.618455, 2.693499, 49.543744>, 
      <1.220166, 1.947491, 49.782662>, <1.227423, 1.954748, 49.629197>, <1.453394, 2.328020, 49.696294>, <1.467278, 2.341903, 49.543744>, 
      <1.583829, 1.583828, 49.782662>, <1.591086, 1.591085, 49.629197>, <1.890707, 1.890706, 49.696294>, <1.904591, 1.904590, 49.543744>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.583828, 1.583829, 49.782662>, <-1.591085, 1.591086, 49.629197>, <-1.890707, 1.890707, 49.696294>, <-1.904591, 1.904591, 49.543744>, 
      <-1.220165, 1.947492, 49.782662>, <-1.227422, 1.954749, 49.629197>, <-1.453394, 2.328021, 49.696294>, <-1.467278, 2.341904, 49.543744>, 
      <-0.514297, 2.239872, 49.782662>, <-0.514297, 2.250134, 49.629197>, <-0.618454, 2.673865, 49.696294>, <-0.618454, 2.693499, 49.543744>, 
      <0.000000, 2.239872, 49.782662>, <0.000000, 2.250134, 49.629197>, <0.000000, 2.673865, 49.696294>, <0.000000, 2.693499, 49.543744>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.239872, 0.000000, 49.782662>, <-2.250134, 0.000000, 49.629197>, <-2.673865, 0.000000, 49.696294>, <-2.693499, 0.000000, 49.543744>, 
      <-2.239872, 0.514297, 49.782662>, <-2.250134, 0.514297, 49.629197>, <-2.673865, 0.618454, 49.696294>, <-2.693499, 0.618454, 49.543744>, 
      <-1.947491, 1.220166, 49.782662>, <-1.954748, 1.227423, 49.629197>, <-2.328020, 1.453394, 49.696294>, <-2.341904, 1.467278, 49.543744>, 
      <-1.583828, 1.583829, 49.782662>, <-1.591085, 1.591086, 49.629197>, <-1.890707, 1.890707, 49.696294>, <-1.904591, 1.904591, 49.543744>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.583828, -1.583828, 49.782662>, <-1.591085, -1.591085, 49.629197>, <-1.890707, -1.890707, 49.696294>, <-1.904591, -1.904591, 49.543744>, 
      <-1.947491, -1.220165, 49.782662>, <-1.954748, -1.227422, 49.629197>, <-2.328020, -1.453394, 49.696294>, <-2.341904, -1.467278, 49.543744>, 
      <-2.239872, -0.514297, 49.782662>, <-2.250134, -0.514297, 49.629197>, <-2.673865, -0.618454, 49.696294>, <-2.693499, -0.618454, 49.543744>, 
      <-2.239872, 0.000000, 49.782662>, <-2.250134, 0.000000, 49.629197>, <-2.673865, 0.000000, 49.696294>, <-2.693499, 0.000000, 49.543744>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -2.239872, 49.782662>, <0.000000, -2.250134, 49.629197>, <0.000000, -2.673865, 49.696294>, <0.000000, -2.693499, 49.543744>, 
      <-0.514297, -2.239872, 49.782662>, <-0.514297, -2.250134, 49.629197>, <-0.618454, -2.673865, 49.696294>, <-0.618454, -2.693499, 49.543744>, 
      <-1.220165, -1.947491, 49.782662>, <-1.227422, -1.954748, 49.629197>, <-1.453394, -2.328020, 49.696294>, <-1.467278, -2.341904, 49.543744>, 
      <-1.583828, -1.583828, 49.782662>, <-1.591085, -1.591085, 49.629197>, <-1.890707, -1.890707, 49.696294>, <-1.904591, -1.904591, 49.543744>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.583828, -1.583828, 49.782662>, <1.591085, -1.591085, 49.629197>, <1.890707, -1.890707, 49.696294>, <1.904591, -1.904591, 49.543744>, 
      <1.220165, -1.947491, 49.782662>, <1.227422, -1.954748, 49.629197>, <1.453394, -2.328020, 49.696294>, <1.467278, -2.341904, 49.543744>, 
      <0.514297, -2.239872, 49.782662>, <0.514297, -2.250134, 49.629197>, <0.618454, -2.673865, 49.696294>, <0.618454, -2.693499, 49.543744>, 
      <0.000000, -2.239872, 49.782662>, <0.000000, -2.250134, 49.629197>, <0.000000, -2.673865, 49.696294>, <0.000000, -2.693499, 49.543744>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 1.913202, 61.212563>, <0.000000, 1.882437, 57.782330>, <0.000000, 2.010993, 53.205386>, <0.000000, 2.239872, 49.782662>, 
      <0.439291, 1.913202, 61.212563>, <0.439291, 1.882437, 57.782330>, <0.514297, 2.010993, 53.205386>, <0.514297, 2.239872, 49.782662>, 
      <1.042213, 1.663462, 61.212563>, <1.020458, 1.641708, 57.782330>, <1.058324, 1.785650, 53.205386>, <1.220166, 1.947491, 49.782662>, 
      <1.352838, 1.352837, 61.212563>, <1.331084, 1.331083, 57.782330>, <1.421988, 1.421987, 53.205386>, <1.583829, 1.583828, 49.782662>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.352838, 1.352838, 61.212563>, <-1.331084, 1.331084, 57.782330>, <-1.421987, 1.421988, 53.205386>, <-1.583828, 1.583829, 49.782662>, 
      <-1.042213, 1.663463, 61.212563>, <-1.020458, 1.641709, 57.782330>, <-1.058324, 1.785650, 53.205386>, <-1.220165, 1.947492, 49.782662>, 
      <-0.439290, 1.913202, 61.212563>, <-0.439290, 1.882437, 57.782330>, <-0.514297, 2.010994, 53.205386>, <-0.514297, 2.239872, 49.782662>, 
      <0.000000, 1.913202, 61.212563>, <0.000000, 1.882437, 57.782330>, <0.000000, 2.010993, 53.205386>, <0.000000, 2.239872, 49.782662>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.913202, 0.000000, 61.212563>, <-1.882437, 0.000000, 57.782330>, <-2.010993, 0.000000, 53.205386>, <-2.239872, 0.000000, 49.782662>, 
      <-1.913202, 0.439290, 61.212563>, <-1.882437, 0.439290, 57.782330>, <-2.010993, 0.514297, 53.205386>, <-2.239872, 0.514297, 49.782662>, 
      <-1.663463, 1.042213, 61.212563>, <-1.641709, 1.020458, 57.782330>, <-1.785650, 1.058324, 53.205386>, <-1.947491, 1.220166, 49.782662>, 
      <-1.352838, 1.352838, 61.212563>, <-1.331084, 1.331084, 57.782330>, <-1.421987, 1.421988, 53.205386>, <-1.583828, 1.583829, 49.782662>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.352838, -1.352838, 61.212563>, <-1.331083, -1.331084, 57.782330>, <-1.421987, -1.421987, 53.205386>, <-1.583828, -1.583828, 49.782662>, 
      <-1.663463, -1.042213, 61.212563>, <-1.641709, -1.020458, 57.782330>, <-1.785649, -1.058324, 53.205386>, <-1.947491, -1.220165, 49.782662>, 
      <-1.913202, -0.439290, 61.212563>, <-1.882437, -0.439290, 57.782330>, <-2.010993, -0.514297, 53.205386>, <-2.239872, -0.514297, 49.782662>, 
      <-1.913202, 0.000000, 61.212563>, <-1.882437, 0.000000, 57.782330>, <-2.010993, 0.000000, 53.205386>, <-2.239872, 0.000000, 49.782662>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -1.913202, 61.212563>, <0.000000, -1.882437, 57.782330>, <0.000000, -2.010993, 53.205386>, <0.000000, -2.239872, 49.782662>, 
      <-0.439290, -1.913202, 61.212563>, <-0.439290, -1.882437, 57.782330>, <-0.514297, -2.010993, 53.205386>, <-0.514297, -2.239872, 49.782662>, 
      <-1.042213, -1.663463, 61.212563>, <-1.020458, -1.641709, 57.782330>, <-1.058324, -1.785649, 53.205386>, <-1.220165, -1.947491, 49.782662>, 
      <-1.352838, -1.352838, 61.212563>, <-1.331083, -1.331084, 57.782330>, <-1.421987, -1.421987, 53.205386>, <-1.583828, -1.583828, 49.782662>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.352838, -1.352838, 61.212563>, <1.331084, -1.331084, 57.782330>, <1.421987, -1.421987, 53.205386>, <1.583828, -1.583828, 49.782662>, 
      <1.042213, -1.663463, 61.212563>, <1.020458, -1.641709, 57.782330>, <1.058324, -1.785649, 53.205386>, <1.220165, -1.947491, 49.782662>, 
      <0.439290, -1.913202, 61.212563>, <0.439290, -1.882437, 57.782330>, <0.514297, -2.010993, 53.205386>, <0.514297, -2.239872, 49.782662>, 
      <0.000000, -1.913202, 61.212563>, <0.000000, -1.882437, 57.782330>, <0.000000, -2.010993, 53.205386>, <0.000000, -2.239872, 49.782662>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 2.347060, 61.733901>, <0.000000, 2.422248, 61.544826>, <0.000000, 1.915027, 61.416032>, <0.000000, 1.913202, 61.212563>, 
      <0.538909, 2.347060, 61.733901>, <0.538909, 2.422248, 61.544826>, <0.439291, 1.915027, 61.416032>, <0.439291, 1.913202, 61.212563>, 
      <1.278557, 2.040688, 61.733901>, <1.331723, 2.093854, 61.544826>, <1.043503, 1.664753, 61.416032>, <1.042213, 1.663462, 61.212563>, 
      <1.659623, 1.659622, 61.733901>, <1.712789, 1.712788, 61.544826>, <1.354129, 1.354127, 61.416032>, <1.352838, 1.352837, 61.212563>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.659622, 1.659623, 61.733901>, <-1.712788, 1.712789, 61.544826>, <-1.354128, 1.354128, 61.416032>, <-1.352838, 1.352838, 61.212563>, 
      <-1.278556, 2.040689, 61.733901>, <-1.331722, 2.093855, 61.544826>, <-1.043503, 1.664754, 61.416032>, <-1.042213, 1.663463, 61.212563>, 
      <-0.538909, 2.347060, 61.733901>, <-0.538909, 2.422248, 61.544826>, <-0.439290, 1.915027, 61.416032>, <-0.439290, 1.913202, 61.212563>, 
      <0.000000, 2.347060, 61.733901>, <0.000000, 2.422248, 61.544826>, <0.000000, 1.915027, 61.416032>, <0.000000, 1.913202, 61.212563>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.347060, 0.000000, 61.733901>, <-2.422248, 0.000000, 61.544826>, <-1.915027, 0.000000, 61.416032>, <-1.913202, 0.000000, 61.212563>, 
      <-2.347060, 0.538909, 61.733901>, <-2.422248, 0.538909, 61.544826>, <-1.915027, 0.439290, 61.416032>, <-1.913202, 0.439290, 61.212563>, 
      <-2.040688, 1.278557, 61.733901>, <-2.093854, 1.331723, 61.544826>, <-1.664754, 1.043503, 61.416032>, <-1.663463, 1.042213, 61.212563>, 
      <-1.659622, 1.659623, 61.733901>, <-1.712788, 1.712789, 61.544826>, <-1.354128, 1.354128, 61.416032>, <-1.352838, 1.352838, 61.212563>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.659623, -1.659622, 61.733901>, <-1.712789, -1.712788, 61.544826>, <-1.354129, -1.354128, 61.416032>, <-1.352838, -1.352838, 61.212563>, 
      <-2.040689, -1.278556, 61.733901>, <-2.093855, -1.331722, 61.544826>, <-1.664754, -1.043503, 61.416032>, <-1.663463, -1.042213, 61.212563>, 
      <-2.347060, -0.538909, 61.733901>, <-2.422248, -0.538909, 61.544826>, <-1.915027, -0.439290, 61.416032>, <-1.913202, -0.439290, 61.212563>, 
      <-2.347060, 0.000000, 61.733901>, <-2.422248, 0.000000, 61.544826>, <-1.915027, 0.000000, 61.416032>, <-1.913202, 0.000000, 61.212563>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -2.347060, 61.733901>, <0.000000, -2.422248, 61.544826>, <0.000000, -1.915027, 61.416032>, <0.000000, -1.913202, 61.212563>, 
      <-0.538909, -2.347060, 61.733901>, <-0.538909, -2.422248, 61.544826>, <-0.439290, -1.915027, 61.416032>, <-0.439290, -1.913202, 61.212563>, 
      <-1.278557, -2.040688, 61.733901>, <-1.331723, -2.093854, 61.544826>, <-1.043503, -1.664754, 61.416032>, <-1.042213, -1.663463, 61.212563>, 
      <-1.659623, -1.659622, 61.733901>, <-1.712789, -1.712788, 61.544826>, <-1.354129, -1.354128, 61.416032>, <-1.352838, -1.352838, 61.212563>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.659622, -1.659622, 61.733901>, <1.712788, -1.712788, 61.544826>, <1.354128, -1.354128, 61.416032>, <1.352838, -1.352838, 61.212563>, 
      <1.278556, -2.040688, 61.733901>, <1.331722, -2.093854, 61.544826>, <1.043503, -1.664754, 61.416032>, <1.042213, -1.663463, 61.212563>, 
      <0.538909, -2.347060, 61.733901>, <0.538909, -2.422248, 61.544826>, <0.439290, -1.915027, 61.416032>, <0.439290, -1.913202, 61.212563>, 
      <0.000000, -2.347060, 61.733901>, <0.000000, -2.422248, 61.544826>, <0.000000, -1.915027, 61.416032>, <0.000000, -1.913202, 61.212563>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 1.611636, 61.970906>, <0.000000, 1.570853, 61.742720>, <0.000000, 2.261405, 61.949293>, <0.000000, 2.347060, 61.733901>, 
      <0.370048, 1.611636, 61.970906>, <0.370048, 1.570853, 61.742720>, <0.538909, 2.261405, 61.949293>, <0.538909, 2.347060, 61.733901>, 
      <0.877935, 1.401262, 61.970906>, <0.849098, 1.372425, 61.742720>, <1.217989, 1.980121, 61.949293>, <1.278557, 2.040688, 61.733901>, 
      <1.139599, 1.139599, 61.970906>, <1.110761, 1.110761, 61.742720>, <1.599056, 1.599055, 61.949293>, <1.659623, 1.659622, 61.733901>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.139599, 1.139599, 61.970906>, <-1.110761, 1.110761, 61.742720>, <-1.599055, 1.599056, 61.949293>, <-1.659622, 1.659623, 61.733901>, 
      <-0.877935, 1.401262, 61.970906>, <-0.849098, 1.372425, 61.742720>, <-1.217989, 1.980121, 61.949293>, <-1.278556, 2.040689, 61.733901>, 
      <-0.370048, 1.611636, 61.970906>, <-0.370048, 1.570853, 61.742720>, <-0.538909, 2.261405, 61.949293>, <-0.538909, 2.347060, 61.733901>, 
      <0.000000, 1.611636, 61.970906>, <0.000000, 1.570853, 61.742720>, <0.000000, 2.261405, 61.949293>, <0.000000, 2.347060, 61.733901>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.611636, 0.000000, 61.970906>, <-1.570853, 0.000000, 61.742720>, <-2.261405, 0.000000, 61.949293>, <-2.347060, 0.000000, 61.733901>, 
      <-1.611636, 0.370048, 61.970906>, <-1.570853, 0.370048, 61.742720>, <-2.261405, 0.538909, 61.949293>, <-2.347060, 0.538909, 61.733901>, 
      <-1.401262, 0.877935, 61.970906>, <-1.372425, 0.849098, 61.742720>, <-1.980121, 1.217989, 61.949293>, <-2.040688, 1.278557, 61.733901>, 
      <-1.139599, 1.139599, 61.970906>, <-1.110761, 1.110761, 61.742720>, <-1.599055, 1.599056, 61.949293>, <-1.659622, 1.659623, 61.733901>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.139599, -1.139599, 61.970906>, <-1.110761, -1.110761, 61.742720>, <-1.599056, -1.599055, 61.949293>, <-1.659623, -1.659622, 61.733901>, 
      <-1.401262, -0.877935, 61.970906>, <-1.372425, -0.849098, 61.742720>, <-1.980121, -1.217989, 61.949293>, <-2.040689, -1.278556, 61.733901>, 
      <-1.611636, -0.370048, 61.970906>, <-1.570853, -0.370048, 61.742720>, <-2.261405, -0.538909, 61.949293>, <-2.347060, -0.538909, 61.733901>, 
      <-1.611636, 0.000000, 61.970906>, <-1.570853, 0.000000, 61.742720>, <-2.261405, 0.000000, 61.949293>, <-2.347060, 0.000000, 61.733901>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -1.611636, 61.970906>, <0.000000, -1.570853, 61.742720>, <0.000000, -2.261405, 61.949293>, <0.000000, -2.347060, 61.733901>, 
      <-0.370048, -1.611636, 61.970906>, <-0.370048, -1.570853, 61.742720>, <-0.538909, -2.261405, 61.949293>, <-0.538909, -2.347060, 61.733901>, 
      <-0.877935, -1.401262, 61.970906>, <-0.849098, -1.372424, 61.742720>, <-1.217989, -1.980121, 61.949293>, <-1.278557, -2.040688, 61.733901>, 
      <-1.139599, -1.139599, 61.970906>, <-1.110761, -1.110761, 61.742720>, <-1.599056, -1.599055, 61.949293>, <-1.659623, -1.659622, 61.733901>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.139599, -1.139599, 61.970906>, <1.110761, -1.110761, 61.742720>, <1.599055, -1.599055, 61.949293>, <1.659622, -1.659622, 61.733901>, 
      <0.877935, -1.401262, 61.970906>, <0.849098, -1.372424, 61.742720>, <1.217989, -1.980121, 61.949293>, <1.278556, -2.040688, 61.733901>, 
      <0.370048, -1.611636, 61.970906>, <0.370048, -1.570853, 61.742720>, <0.538909, -2.261405, 61.949293>, <0.538909, -2.347060, 61.733901>, 
      <0.000000, -1.611636, 61.970906>, <0.000000, -1.570853, 61.742720>, <0.000000, -2.261405, 61.949293>, <0.000000, -2.347060, 61.733901>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 2.793890, 64.233971>, <0.000000, 2.644533, 63.482694>, <0.000000, 1.746402, 62.724934>, <0.000000, 1.611636, 61.970906>, 
      <0.641505, 2.793890, 64.233971>, <0.641505, 2.644533, 63.482694>, <0.370048, 1.746402, 62.724934>, <0.370048, 1.611636, 61.970906>, 
      <1.521966, 2.429191, 64.233971>, <1.342345, 2.249569, 63.511334>, <0.973229, 1.496556, 62.724934>, <0.877935, 1.401262, 61.970906>, 
      <1.975579, 1.975578, 64.233971>, <1.795957, 1.795956, 63.511334>, <1.234893, 1.234893, 62.724934>, <1.139599, 1.139599, 61.970906>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.975578, 1.975579, 64.233971>, <-1.795956, 1.795957, 63.511334>, <-1.234893, 1.234893, 62.724934>, <-1.139599, 1.139599, 61.970906>, 
      <-1.521965, 2.429192, 64.233971>, <-1.342344, 2.249570, 63.511334>, <-0.973229, 1.496556, 62.724934>, <-0.877935, 1.401262, 61.970906>, 
      <-0.641505, 2.793890, 64.233971>, <-0.641505, 2.644533, 63.482694>, <-0.370048, 1.746402, 62.724934>, <-0.370048, 1.611636, 61.970906>, 
      <0.000000, 2.793890, 64.233971>, <0.000000, 2.644533, 63.482694>, <0.000000, 1.746402, 62.724934>, <0.000000, 1.611636, 61.970906>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.793890, 0.000000, 64.233971>, <-2.644533, 0.000000, 63.482694>, <-1.746402, 0.000000, 62.724934>, <-1.611636, 0.000000, 61.970906>, 
      <-2.793890, 0.641505, 64.233971>, <-2.644533, 0.641505, 63.482694>, <-1.746402, 0.370048, 62.724934>, <-1.611636, 0.370048, 61.970906>, 
      <-2.429191, 1.521966, 64.233971>, <-2.249569, 1.342345, 63.511334>, <-1.496556, 0.973229, 62.724934>, <-1.401262, 0.877935, 61.970906>, 
      <-1.975578, 1.975579, 64.233971>, <-1.795956, 1.795957, 63.511334>, <-1.234893, 1.234893, 62.724934>, <-1.139599, 1.139599, 61.970906>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.975579, -1.975579, 64.233971>, <-1.795957, -1.795957, 63.511334>, <-1.234893, -1.234893, 62.724934>, <-1.139599, -1.139599, 61.970906>, 
      <-2.429192, -1.521966, 64.233971>, <-2.249570, -1.342345, 63.511334>, <-1.496556, -0.973230, 62.724934>, <-1.401262, -0.877935, 61.970906>, 
      <-2.793890, -0.641505, 64.233971>, <-2.644533, -0.641505, 63.482694>, <-1.746402, -0.370048, 62.724934>, <-1.611636, -0.370048, 61.970906>, 
      <-2.793890, 0.000000, 64.233971>, <-2.644533, 0.000000, 63.482694>, <-1.746402, 0.000000, 62.724934>, <-1.611636, 0.000000, 61.970906>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -2.793890, 64.233971>, <0.000000, -2.644533, 63.482694>, <0.000000, -1.746402, 62.724934>, <0.000000, -1.611636, 61.970906>, 
      <-0.641505, -2.793890, 64.233971>, <-0.641505, -2.644533, 63.482694>, <-0.370048, -1.746402, 62.724934>, <-0.370048, -1.611636, 61.970906>, 
      <-1.521966, -2.429192, 64.233971>, <-1.342345, -2.249570, 63.511334>, <-0.973229, -1.496557, 62.724934>, <-0.877935, -1.401262, 61.970906>, 
      <-1.975579, -1.975579, 64.233971>, <-1.795957, -1.795957, 63.511334>, <-1.234893, -1.234893, 62.724934>, <-1.139599, -1.139599, 61.970906>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.975579, -1.975579, 64.233971>, <1.795957, -1.795957, 63.511334>, <1.234893, -1.234893, 62.724934>, <1.139599, -1.139599, 61.970906>, 
      <1.521966, -2.429192, 64.233971>, <1.342345, -2.249570, 63.511334>, <0.973230, -1.496557, 62.724934>, <0.877935, -1.401262, 61.970906>, 
      <0.641505, -2.793890, 64.233971>, <0.641505, -2.644533, 63.482694>, <0.370048, -1.746402, 62.724934>, <0.370048, -1.611636, 61.970906>, 
      <0.000000, -2.793890, 64.233971>, <0.000000, -2.644533, 63.482694>, <0.000000, -1.746402, 62.724934>, <0.000000, -1.611636, 61.970906>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 2.322118, 65.544685>, <0.000000, 2.677875, 65.325402>, <0.000000, 2.875378, 64.643859>, <0.000000, 2.793890, 64.233971>, 
      <0.672018, 2.322118, 65.544685>, <0.672018, 2.677875, 65.325402>, <0.641505, 2.875377, 64.643859>, <0.641505, 2.793890, 64.233971>, 
      <1.690026, 2.640401, 66.097037>, <2.029932, 2.980307, 65.800742>, <1.654384, 2.561608, 64.766694>, <1.521966, 2.429191, 64.233971>, 
      <2.165214, 2.165213, 66.097037>, <2.505120, 2.505119, 65.800742>, <2.107996, 2.107995, 64.766694>, <1.975579, 1.975578, 64.233971>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.165214, 2.165214, 66.097037>, <-2.505120, 2.505120, 65.800742>, <-2.107995, 2.107996, 64.766694>, <-1.975578, 1.975579, 64.233971>, 
      <-1.690026, 2.640402, 66.097037>, <-2.029932, 2.980308, 65.800742>, <-1.654383, 2.561609, 64.766694>, <-1.521965, 2.429192, 64.233971>, 
      <-0.672018, 2.322118, 65.544685>, <-0.672018, 2.677875, 65.325402>, <-0.641505, 2.875378, 64.643859>, <-0.641505, 2.793890, 64.233971>, 
      <0.000000, 2.322118, 65.544685>, <0.000000, 2.677875, 65.325402>, <0.000000, 2.875378, 64.643859>, <0.000000, 2.793890, 64.233971>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.322118, 0.000000, 65.544685>, <-2.677875, 0.000000, 65.325402>, <-2.875378, 0.000000, 64.643859>, <-2.793890, 0.000000, 64.233971>, 
      <-2.322118, 0.672018, 65.544685>, <-2.677875, 0.672018, 65.325402>, <-2.875377, 0.641505, 64.643859>, <-2.793890, 0.641505, 64.233971>, 
      <-2.640402, 1.690026, 66.097037>, <-2.980308, 2.029932, 65.800742>, <-2.561608, 1.654384, 64.766694>, <-2.429191, 1.521966, 64.233971>, 
      <-2.165214, 2.165214, 66.097037>, <-2.505120, 2.505120, 65.800742>, <-2.107995, 2.107996, 64.766694>, <-1.975578, 1.975579, 64.233971>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.165214, -2.165214, 66.097037>, <-2.505120, -2.505120, 65.800742>, <-2.107996, -2.107996, 64.766694>, <-1.975579, -1.975579, 64.233971>, 
      <-2.640402, -1.690026, 66.097037>, <-2.980308, -2.029932, 65.800742>, <-2.561609, -1.654384, 64.766694>, <-2.429192, -1.521966, 64.233971>, 
      <-2.322118, -0.672018, 65.544685>, <-2.677875, -0.672018, 65.325402>, <-2.875378, -0.641505, 64.643859>, <-2.793890, -0.641505, 64.233971>, 
      <-2.322118, 0.000000, 65.544685>, <-2.677875, 0.000000, 65.325402>, <-2.875378, 0.000000, 64.643859>, <-2.793890, 0.000000, 64.233971>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -2.322118, 65.544685>, <0.000000, -2.677875, 65.325402>, <0.000000, -2.875378, 64.643859>, <0.000000, -2.793890, 64.233971>, 
      <-0.672018, -2.322118, 65.544685>, <-0.672018, -2.677875, 65.325402>, <-0.641505, -2.875378, 64.643859>, <-0.641505, -2.793890, 64.233971>, 
      <-1.690026, -2.640402, 66.097037>, <-2.029932, -2.980308, 65.800742>, <-1.654384, -2.561609, 64.766694>, <-1.521966, -2.429192, 64.233971>, 
      <-2.165214, -2.165214, 66.097037>, <-2.505120, -2.505120, 65.800742>, <-2.107996, -2.107996, 64.766694>, <-1.975579, -1.975579, 64.233971>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.165214, -2.165214, 66.097037>, <2.505120, -2.505120, 65.800742>, <2.107996, -2.107996, 64.766694>, <1.975579, -1.975579, 64.233971>, 
      <1.690026, -2.640402, 66.097037>, <2.029932, -2.980308, 65.800742>, <1.654384, -2.561609, 64.766694>, <1.521966, -2.429192, 64.233971>, 
      <0.672018, -2.322118, 65.544685>, <0.672018, -2.677875, 65.325402>, <0.641505, -2.875378, 64.643859>, <0.641505, -2.793890, 64.233971>, 
      <0.000000, -2.322118, 65.544685>, <0.000000, -2.677875, 65.325402>, <0.000000, -2.875378, 64.643859>, <0.000000, -2.793890, 64.233971>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 1.614460, 64.960960>, <0.000000, 1.703691, 64.700621>, <0.000000, 2.087845, 65.689088>, <0.000000, 2.322118, 65.544685>, 
      <0.370696, 1.614460, 64.960960>, <0.370696, 1.703691, 64.700621>, <0.672018, 2.087845, 65.689088>, <0.672018, 2.322118, 65.544685>, 
      <0.879474, 1.403717, 64.960960>, <1.248451, 1.772694, 64.780755>, <1.357721, 2.308096, 66.386714>, <1.690026, 2.640401, 66.097037>, 
      <1.141596, 1.141595, 64.960960>, <1.510573, 1.510572, 64.780755>, <1.832909, 1.832908, 66.386714>, <2.165214, 2.165213, 66.097037>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.141596, 1.141596, 64.960960>, <-1.510573, 1.510573, 64.780755>, <-1.832909, 1.832909, 66.386714>, <-2.165214, 2.165214, 66.097037>, 
      <-0.879474, 1.403718, 64.960960>, <-1.248451, 1.772695, 64.780755>, <-1.357721, 2.308097, 66.386714>, <-1.690026, 2.640402, 66.097037>, 
      <-0.370696, 1.614460, 64.960960>, <-0.370696, 1.703691, 64.700621>, <-0.672018, 2.087845, 65.689088>, <-0.672018, 2.322118, 65.544685>, 
      <0.000000, 1.614460, 64.960960>, <0.000000, 1.703691, 64.700621>, <0.000000, 2.087845, 65.689088>, <0.000000, 2.322118, 65.544685>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.614460, 0.000000, 64.960960>, <-1.703691, 0.000000, 64.700621>, <-2.087845, 0.000000, 65.689088>, <-2.322118, 0.000000, 65.544685>, 
      <-1.614460, 0.370696, 64.960960>, <-1.703691, 0.370696, 64.700621>, <-2.087845, 0.672018, 65.689088>, <-2.322118, 0.672018, 65.544685>, 
      <-1.403718, 0.879474, 64.960960>, <-1.772695, 1.248451, 64.780755>, <-2.308098, 1.357721, 66.386714>, <-2.640402, 1.690026, 66.097037>, 
      <-1.141596, 1.141596, 64.960960>, <-1.510573, 1.510573, 64.780755>, <-1.832909, 1.832909, 66.386714>, <-2.165214, 2.165214, 66.097037>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.141596, -1.141596, 64.960960>, <-1.510573, -1.510573, 64.780755>, <-1.832909, -1.832909, 66.386714>, <-2.165214, -2.165214, 66.097037>, 
      <-1.403718, -0.879474, 64.960960>, <-1.772695, -1.248451, 64.780755>, <-2.308097, -1.357721, 66.386714>, <-2.640402, -1.690026, 66.097037>, 
      <-1.614460, -0.370696, 64.960960>, <-1.703691, -0.370696, 64.700621>, <-2.087845, -0.672018, 65.689088>, <-2.322118, -0.672018, 65.544685>, 
      <-1.614460, 0.000000, 64.960960>, <-1.703691, 0.000000, 64.700621>, <-2.087845, 0.000000, 65.689088>, <-2.322118, 0.000000, 65.544685>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -1.614460, 64.960960>, <0.000000, -1.703691, 64.700621>, <0.000000, -2.087845, 65.689088>, <0.000000, -2.322118, 65.544685>, 
      <-0.370696, -1.614460, 64.960960>, <-0.370696, -1.703691, 64.700621>, <-0.672018, -2.087845, 65.689088>, <-0.672018, -2.322118, 65.544685>, 
      <-0.879474, -1.403718, 64.960960>, <-1.248451, -1.772695, 64.780755>, <-1.357721, -2.308097, 66.386714>, <-1.690026, -2.640402, 66.097037>, 
      <-1.141596, -1.141596, 64.960960>, <-1.510573, -1.510573, 64.780755>, <-1.832909, -1.832909, 66.386714>, <-2.165214, -2.165214, 66.097037>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.141596, -1.141596, 64.960960>, <1.510573, -1.510573, 64.780755>, <1.832909, -1.832909, 66.386714>, <2.165214, -2.165214, 66.097037>, 
      <0.879474, -1.403718, 64.960960>, <1.248451, -1.772695, 64.780755>, <1.357721, -2.308097, 66.386714>, <1.690026, -2.640402, 66.097037>, 
      <0.370696, -1.614460, 64.960960>, <0.370696, -1.703691, 64.700621>, <0.672018, -2.087845, 65.689088>, <0.672018, -2.322118, 65.544685>, 
      <0.000000, -1.614460, 64.960960>, <0.000000, -1.703691, 64.700621>, <0.000000, -2.087845, 65.689088>, <0.000000, -2.322118, 65.544685>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 2.059168, 66.311853>, <0.000000, 2.023234, 65.886701>, <0.000000, 1.476120, 65.364570>, <0.000000, 1.614460, 64.960960>, 
      <0.527212, 2.059168, 66.311853>, <0.527212, 2.023233, 65.886701>, <0.370696, 1.476120, 65.364570>, <0.370696, 1.614460, 64.960960>, 
      <1.352589, 2.098178, 66.311853>, <1.319503, 2.065093, 65.839200>, <0.562024, 1.086267, 65.116006>, <0.879474, 1.403717, 64.960960>, 
      <1.725384, 1.725383, 66.311853>, <1.692298, 1.692297, 65.839200>, <0.824146, 0.824145, 65.116006>, <1.141596, 1.141595, 64.960960>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.725384, 1.725384, 66.311853>, <-1.692298, 1.692298, 65.839200>, <-0.824146, 0.824146, 65.116006>, <-1.141596, 1.141596, 64.960960>, 
      <-1.352589, 2.098179, 66.311853>, <-1.319503, 2.065094, 65.839200>, <-0.562024, 1.086268, 65.116006>, <-0.879474, 1.403718, 64.960960>, 
      <-0.527212, 2.059168, 66.311853>, <-0.527212, 2.023234, 65.886701>, <-0.370696, 1.476120, 65.364570>, <-0.370696, 1.614460, 64.960960>, 
      <0.000000, 2.059168, 66.311853>, <0.000000, 2.023234, 65.886701>, <0.000000, 1.476120, 65.364570>, <0.000000, 1.614460, 64.960960>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.059168, 0.000000, 66.311853>, <-2.023234, 0.000000, 65.886701>, <-1.476120, 0.000000, 65.364570>, <-1.614460, 0.000000, 64.960960>, 
      <-2.059168, 0.527212, 66.311853>, <-2.023234, 0.527212, 65.886701>, <-1.476120, 0.370696, 65.364570>, <-1.614460, 0.370696, 64.960960>, 
      <-2.098179, 1.352589, 66.311853>, <-2.065094, 1.319503, 65.839200>, <-1.086268, 0.562024, 65.116006>, <-1.403718, 0.879474, 64.960960>, 
      <-1.725384, 1.725384, 66.311853>, <-1.692298, 1.692298, 65.839200>, <-0.824146, 0.824146, 65.116006>, <-1.141596, 1.141596, 64.960960>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.725384, -1.725384, 66.311853>, <-1.692298, -1.692298, 65.839200>, <-0.824146, -0.824146, 65.116006>, <-1.141596, -1.141596, 64.960960>, 
      <-2.098179, -1.352589, 66.311853>, <-2.065094, -1.319503, 65.839200>, <-1.086268, -0.562024, 65.116006>, <-1.403718, -0.879474, 64.960960>, 
      <-2.059168, -0.527212, 66.311853>, <-2.023234, -0.527212, 65.886701>, <-1.476120, -0.370696, 65.364570>, <-1.614460, -0.370696, 64.960960>, 
      <-2.059168, 0.000000, 66.311853>, <-2.023234, 0.000000, 65.886701>, <-1.476120, 0.000000, 65.364570>, <-1.614460, 0.000000, 64.960960>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -2.059168, 66.311853>, <0.000000, -2.023234, 65.886701>, <0.000000, -1.476120, 65.364570>, <0.000000, -1.614460, 64.960960>, 
      <-0.527212, -2.059168, 66.311853>, <-0.527212, -2.023234, 65.886701>, <-0.370696, -1.476120, 65.364570>, <-0.370696, -1.614460, 64.960960>, 
      <-1.352589, -2.098179, 66.311853>, <-1.319503, -2.065094, 65.839200>, <-0.562024, -1.086268, 65.116006>, <-0.879474, -1.403718, 64.960960>, 
      <-1.725384, -1.725384, 66.311853>, <-1.692298, -1.692298, 65.839200>, <-0.824146, -0.824146, 65.116006>, <-1.141596, -1.141596, 64.960960>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.725384, -1.725384, 66.311853>, <1.692298, -1.692298, 65.839200>, <0.824146, -0.824146, 65.116006>, <1.141596, -1.141596, 64.960960>, 
      <1.352589, -2.098179, 66.311853>, <1.319503, -2.065094, 65.839200>, <0.562024, -1.086268, 65.116006>, <0.879474, -1.403718, 64.960960>, 
      <0.527212, -2.059168, 66.311853>, <0.527212, -2.023234, 65.886701>, <0.370696, -1.476120, 65.364570>, <0.370696, -1.614460, 64.960960>, 
      <0.000000, -2.059168, 66.311853>, <0.000000, -2.023234, 65.886701>, <0.000000, -1.476120, 65.364570>, <0.000000, -1.614460, 64.960960>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 1.970336, 69.171379>, <0.000000, 2.271057, 68.367514>, <0.000000, 2.131454, 67.167078>, <0.000000, 2.059168, 66.311853>, 
      <0.459716, 1.970336, 69.171379>, <0.459716, 2.271057, 68.367514>, <0.527212, 2.131454, 67.167078>, <0.527212, 2.059168, 66.311853>, 
      <1.111260, 1.761395, 69.171379>, <1.360176, 2.010311, 68.379514>, <1.412955, 2.158545, 67.174214>, <1.352589, 2.098178, 66.311853>, 
      <1.436328, 1.436327, 69.171379>, <1.685244, 1.685243, 68.379514>, <1.785750, 1.785749, 67.174214>, <1.725384, 1.725383, 66.311853>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.436328, 1.436328, 69.171379>, <-1.685244, 1.685244, 68.379514>, <-1.785750, 1.785750, 67.174214>, <-1.725384, 1.725384, 66.311853>, 
      <-1.111260, 1.761396, 69.171379>, <-1.360176, 2.010312, 68.379514>, <-1.412955, 2.158545, 67.174214>, <-1.352589, 2.098179, 66.311853>, 
      <-0.459715, 1.970336, 69.171379>, <-0.459715, 2.271057, 68.367514>, <-0.527212, 2.131454, 67.167078>, <-0.527212, 2.059168, 66.311853>, 
      <0.000000, 1.970336, 69.171379>, <0.000000, 2.271057, 68.367514>, <0.000000, 2.131454, 67.167078>, <0.000000, 2.059168, 66.311853>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.970336, 0.000000, 69.171379>, <-2.271057, 0.000000, 68.367514>, <-2.131454, 0.000000, 67.167078>, <-2.059168, 0.000000, 66.311853>, 
      <-1.970336, 0.459715, 69.171379>, <-2.271057, 0.459715, 68.367514>, <-2.131454, 0.527212, 67.167078>, <-2.059168, 0.527212, 66.311853>, 
      <-1.761396, 1.111260, 69.171379>, <-2.010312, 1.360176, 68.379514>, <-2.158545, 1.412955, 67.174214>, <-2.098179, 1.352589, 66.311853>, 
      <-1.436328, 1.436328, 69.171379>, <-1.685244, 1.685244, 68.379514>, <-1.785750, 1.785750, 67.174214>, <-1.725384, 1.725384, 66.311853>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.436328, -1.436328, 69.171379>, <-1.685244, -1.685244, 68.379514>, <-1.785750, -1.785750, 67.174214>, <-1.725384, -1.725384, 66.311853>, 
      <-1.761396, -1.111260, 69.171379>, <-2.010312, -1.360176, 68.379514>, <-2.158545, -1.412955, 67.174214>, <-2.098179, -1.352589, 66.311853>, 
      <-1.970336, -0.459715, 69.171379>, <-2.271057, -0.459715, 68.367514>, <-2.131454, -0.527212, 67.167078>, <-2.059168, -0.527212, 66.311853>, 
      <-1.970336, 0.000000, 69.171379>, <-2.271057, 0.000000, 68.367514>, <-2.131454, 0.000000, 67.167078>, <-2.059168, 0.000000, 66.311853>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -1.970336, 69.171379>, <0.000000, -2.271057, 68.367514>, <0.000000, -2.131454, 67.167078>, <0.000000, -2.059168, 66.311853>, 
      <-0.459715, -1.970336, 69.171379>, <-0.459715, -2.271057, 68.367514>, <-0.527212, -2.131454, 67.167078>, <-0.527212, -2.059168, 66.311853>, 
      <-1.111260, -1.761396, 69.171379>, <-1.360176, -2.010312, 68.379514>, <-1.412955, -2.158545, 67.174214>, <-1.352589, -2.098179, 66.311853>, 
      <-1.436328, -1.436328, 69.171379>, <-1.685244, -1.685244, 68.379514>, <-1.785750, -1.785750, 67.174214>, <-1.725384, -1.725384, 66.311853>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.436328, -1.436328, 69.171379>, <1.685244, -1.685244, 68.379514>, <1.785750, -1.785750, 67.174214>, <1.725384, -1.725384, 66.311853>, 
      <1.111260, -1.761396, 69.171379>, <1.360176, -2.010312, 68.379514>, <1.412955, -2.158545, 67.174214>, <1.352589, -2.098179, 66.311853>, 
      <0.459715, -1.970336, 69.171379>, <0.459715, -2.271057, 68.367514>, <0.527212, -2.131454, 67.167078>, <0.527212, -2.059168, 66.311853>, 
      <0.000000, -1.970336, 69.171379>, <0.000000, -2.271057, 68.367514>, <0.000000, -2.131454, 67.167078>, <0.000000, -2.059168, 66.311853>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 0.036741, 71.718054>, <0.000000, 0.616820, 70.954054>, <0.000000, 1.634229, 70.069830>, <0.000000, 1.970336, 69.171379>, 
      <0.008436, 0.036741, 71.718054>, <0.008436, 0.616820, 70.954054>, <0.459716, 1.634229, 70.069830>, <0.459716, 1.970336, 69.171379>, 
      <0.020015, 0.031945, 71.718054>, <0.443119, 0.455049, 70.954054>, <0.832514, 1.482649, 70.058138>, <1.111260, 1.761395, 69.171379>, 
      <0.025980, 0.025980, 71.718054>, <0.449085, 0.449084, 70.954054>, <1.157582, 1.157581, 70.058138>, <1.436328, 1.436327, 69.171379>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.025980, 0.025980, 71.718054>, <-0.449085, 0.449085, 70.954054>, <-1.157582, 1.157582, 70.058138>, <-1.436328, 1.436328, 69.171379>, 
      <-0.020015, 0.031945, 71.718054>, <-0.443119, 0.455050, 70.954054>, <-0.832514, 1.482650, 70.058138>, <-1.111260, 1.761396, 69.171379>, 
      <-0.008436, 0.036741, 71.718054>, <-0.008436, 0.616820, 70.954054>, <-0.459715, 1.634229, 70.069830>, <-0.459715, 1.970336, 69.171379>, 
      <0.000000, 0.036741, 71.718054>, <0.000000, 0.616820, 70.954054>, <0.000000, 1.634229, 70.069830>, <0.000000, 1.970336, 69.171379>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.036741, 0.000000, 71.718054>, <-0.616820, 0.000000, 70.954054>, <-1.634229, 0.000000, 70.069830>, <-1.970336, 0.000000, 69.171379>, 
      <-0.036741, 0.008436, 71.718054>, <-0.616820, 0.008436, 70.954054>, <-1.634229, 0.459715, 70.069830>, <-1.970336, 0.459715, 69.171379>, 
      <-0.031945, 0.020015, 71.718054>, <-0.455050, 0.443119, 70.954054>, <-1.482650, 0.832514, 70.058138>, <-1.761396, 1.111260, 69.171379>, 
      <-0.025980, 0.025980, 71.718054>, <-0.449085, 0.449085, 70.954054>, <-1.157582, 1.157582, 70.058138>, <-1.436328, 1.436328, 69.171379>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.025980, -0.025980, 71.718054>, <-0.449085, -0.449085, 70.954054>, <-1.157582, -1.157582, 70.058138>, <-1.436328, -1.436328, 69.171379>, 
      <-0.031945, -0.020015, 71.718054>, <-0.455050, -0.443119, 70.954054>, <-1.482650, -0.832514, 70.058138>, <-1.761396, -1.111260, 69.171379>, 
      <-0.036741, -0.008436, 71.718054>, <-0.616820, -0.008436, 70.954054>, <-1.634229, -0.459715, 70.069830>, <-1.970336, -0.459715, 69.171379>, 
      <-0.036741, 0.000000, 71.718054>, <-0.616820, 0.000000, 70.954054>, <-1.634229, 0.000000, 70.069830>, <-1.970336, 0.000000, 69.171379>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -0.036741, 71.718054>, <0.000000, -0.616820, 70.954054>, <0.000000, -1.634229, 70.069830>, <0.000000, -1.970336, 69.171379>, 
      <-0.008436, -0.036741, 71.718054>, <-0.008436, -0.616820, 70.954054>, <-0.459715, -1.634229, 70.069830>, <-0.459715, -1.970336, 69.171379>, 
      <-0.020015, -0.031945, 71.718054>, <-0.443119, -0.455050, 70.954054>, <-0.832514, -1.482650, 70.058138>, <-1.111260, -1.761396, 69.171379>, 
      <-0.025980, -0.025980, 71.718054>, <-0.449085, -0.449085, 70.954054>, <-1.157582, -1.157582, 70.058138>, <-1.436328, -1.436328, 69.171379>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.025980, -0.025980, 71.718054>, <0.449085, -0.449085, 70.954054>, <1.157582, -1.157582, 70.058138>, <1.436328, -1.436328, 69.171379>, 
      <0.020015, -0.031945, 71.718054>, <0.443119, -0.455050, 70.954054>, <0.832514, -1.482650, 70.058138>, <1.111260, -1.761396, 69.171379>, 
      <0.008436, -0.036741, 71.718054>, <0.008436, -0.616820, 70.954054>, <0.459715, -1.634229, 70.069830>, <0.459715, -1.970336, 69.171379>, 
      <0.000000, -0.036741, 71.718054>, <0.000000, -0.616820, 70.954054>, <0.000000, -1.634229, 70.069830>, <0.000000, -1.970336, 69.171379>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.036741, 0.000000, 71.718054>, <0.616820, 0.000000, 70.954054>, <1.634229, 0.000000, 70.069830>, <1.970336, 0.000000, 69.171379>, 
      <0.036741, -0.008436, 71.718054>, <0.616820, -0.008436, 70.954054>, <1.634229, -0.459715, 70.069830>, <1.970336, -0.459715, 69.171379>, 
      <0.031945, -0.020015, 71.718054>, <0.455050, -0.443119, 70.954054>, <1.482650, -0.832514, 70.058138>, <1.761396, -1.111260, 69.171379>, 
      <0.025980, -0.025980, 71.718054>, <0.449085, -0.449085, 70.954054>, <1.157582, -1.157582, 70.058138>, <1.436328, -1.436328, 69.171379>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.036741, 0.000000, 71.718054>, <0.036741, 0.008436, 71.718054>, <0.031945, 0.020015, 71.718054>, <0.025980, 0.025980, 71.718054>, 
      <0.616820, 0.000000, 70.954054>, <0.616820, 0.008436, 70.954054>, <0.455050, 0.443119, 70.954054>, <0.449085, 0.449084, 70.954054>, 
      <1.634229, 0.000000, 70.069830>, <1.634229, 0.459715, 70.069830>, <1.482650, 0.832514, 70.058138>, <1.157582, 1.157581, 70.058138>, 
      <1.970336, 0.000000, 69.171379>, <1.970336, 0.459715, 69.171379>, <1.761396, 1.111259, 69.171379>, <1.436328, 1.436327, 69.171379>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.059168, 0.000000, 66.311853>, <2.059168, -0.527212, 66.311853>, <2.098179, -1.352589, 66.311853>, <1.725384, -1.725384, 66.311853>, 
      <2.131454, 0.000000, 67.167078>, <2.131454, -0.527212, 67.167078>, <2.158545, -1.412955, 67.174214>, <1.785750, -1.785750, 67.174214>, 
      <2.271057, 0.000000, 68.367514>, <2.271057, -0.459715, 68.367514>, <2.010312, -1.360176, 68.379514>, <1.685244, -1.685244, 68.379514>, 
      <1.970336, 0.000000, 69.171379>, <1.970336, -0.459715, 69.171379>, <1.761396, -1.111260, 69.171379>, <1.436328, -1.436328, 69.171379>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.059168, 0.000000, 66.311853>, <2.131454, 0.000000, 67.167078>, <2.271057, 0.000000, 68.367514>, <1.970336, 0.000000, 69.171379>, 
      <2.059168, 0.527212, 66.311853>, <2.131454, 0.527212, 67.167078>, <2.271057, 0.459715, 68.367514>, <1.970336, 0.459715, 69.171379>, 
      <2.098179, 1.352588, 66.311853>, <2.158545, 1.412954, 67.174214>, <2.010312, 1.360175, 68.379514>, <1.761396, 1.111259, 69.171379>, 
      <1.725384, 1.725383, 66.311853>, <1.785750, 1.785749, 67.174214>, <1.685244, 1.685243, 68.379514>, <1.436328, 1.436327, 69.171379>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.614460, 0.000000, 64.960960>, <1.614460, -0.370696, 64.960960>, <1.403718, -0.879474, 64.960960>, <1.141596, -1.141596, 64.960960>, 
      <1.476120, 0.000000, 65.364570>, <1.476120, -0.370696, 65.364570>, <1.086268, -0.562024, 65.116006>, <0.824146, -0.824146, 65.116006>, 
      <2.023234, 0.000000, 65.886701>, <2.023234, -0.527212, 65.886701>, <2.065094, -1.319503, 65.839200>, <1.692298, -1.692298, 65.839200>, 
      <2.059168, 0.000000, 66.311853>, <2.059168, -0.527212, 66.311853>, <2.098179, -1.352589, 66.311853>, <1.725384, -1.725384, 66.311853>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.614460, 0.000000, 64.960960>, <1.476120, 0.000000, 65.364570>, <2.023234, 0.000000, 65.886701>, <2.059168, 0.000000, 66.311853>, 
      <1.614460, 0.370696, 64.960960>, <1.476120, 0.370696, 65.364570>, <2.023234, 0.527212, 65.886701>, <2.059168, 0.527212, 66.311853>, 
      <1.403718, 0.879473, 64.960960>, <1.086268, 0.562023, 65.116006>, <2.065093, 1.319502, 65.839200>, <2.098179, 1.352588, 66.311853>, 
      <1.141596, 1.141595, 64.960960>, <0.824146, 0.824145, 65.116006>, <1.692298, 1.692297, 65.839200>, <1.725384, 1.725383, 66.311853>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.322118, 0.000000, 65.544685>, <2.322118, -0.672018, 65.544685>, <2.640402, -1.690026, 66.097037>, <2.165214, -2.165214, 66.097037>, 
      <2.087845, 0.000000, 65.689088>, <2.087845, -0.672018, 65.689088>, <2.308097, -1.357721, 66.386714>, <1.832909, -1.832909, 66.386714>, 
      <1.703691, 0.000000, 64.700621>, <1.703691, -0.370696, 64.700621>, <1.772695, -1.248451, 64.780755>, <1.510573, -1.510573, 64.780755>, 
      <1.614460, 0.000000, 64.960960>, <1.614460, -0.370696, 64.960960>, <1.403718, -0.879474, 64.960960>, <1.141596, -1.141596, 64.960960>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.322118, 0.000000, 65.544685>, <2.087845, 0.000000, 65.689088>, <1.703691, 0.000000, 64.700621>, <1.614460, 0.000000, 64.960960>, 
      <2.322118, 0.672018, 65.544685>, <2.087845, 0.672018, 65.689088>, <1.703691, 0.370696, 64.700621>, <1.614460, 0.370696, 64.960960>, 
      <2.640402, 1.690025, 66.097037>, <2.308097, 1.357720, 66.386714>, <1.772695, 1.248450, 64.780755>, <1.403718, 0.879473, 64.960960>, 
      <2.165214, 2.165213, 66.097037>, <1.832909, 1.832908, 66.386714>, <1.510573, 1.510572, 64.780755>, <1.141596, 1.141595, 64.960960>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.793890, 0.000000, 64.233971>, <2.793890, -0.641505, 64.233971>, <2.429192, -1.521966, 64.233971>, <1.975579, -1.975579, 64.233971>, 
      <2.875378, 0.000000, 64.643859>, <2.875378, -0.641505, 64.643859>, <2.561609, -1.654384, 64.766694>, <2.107996, -2.107996, 64.766694>, 
      <2.677875, 0.000000, 65.325402>, <2.677875, -0.672018, 65.325402>, <2.980308, -2.029932, 65.800742>, <2.505120, -2.505120, 65.800742>, 
      <2.322118, 0.000000, 65.544685>, <2.322118, -0.672018, 65.544685>, <2.640402, -1.690026, 66.097037>, <2.165214, -2.165214, 66.097037>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.793890, 0.000000, 64.233971>, <2.875378, 0.000000, 64.643859>, <2.677875, 0.000000, 65.325402>, <2.322118, 0.000000, 65.544685>, 
      <2.793890, 0.641505, 64.233971>, <2.875378, 0.641505, 64.643859>, <2.677875, 0.672018, 65.325402>, <2.322118, 0.672018, 65.544685>, 
      <2.429192, 1.521965, 64.233971>, <2.561609, 1.654383, 64.766694>, <2.980308, 2.029931, 65.800742>, <2.640402, 1.690025, 66.097037>, 
      <1.975579, 1.975578, 64.233971>, <2.107996, 2.107995, 64.766694>, <2.505120, 2.505119, 65.800742>, <2.165214, 2.165213, 66.097037>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.611636, 0.000000, 61.970906>, <1.611636, -0.370048, 61.970906>, <1.401262, -0.877935, 61.970906>, <1.139599, -1.139599, 61.970906>, 
      <1.746402, 0.000000, 62.724934>, <1.746402, -0.370048, 62.724934>, <1.496557, -0.973230, 62.724934>, <1.234893, -1.234893, 62.724934>, 
      <2.644533, 0.000000, 63.482694>, <2.644533, -0.641505, 63.482694>, <2.249570, -1.342345, 63.511334>, <1.795957, -1.795957, 63.511334>, 
      <2.793890, 0.000000, 64.233971>, <2.793890, -0.641505, 64.233971>, <2.429192, -1.521966, 64.233971>, <1.975579, -1.975579, 64.233971>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.611636, 0.000000, 61.970906>, <1.746402, 0.000000, 62.724934>, <2.644533, 0.000000, 63.482694>, <2.793890, 0.000000, 64.233971>, 
      <1.611636, 0.370048, 61.970906>, <1.746402, 0.370048, 62.724934>, <2.644533, 0.641505, 63.482694>, <2.793890, 0.641505, 64.233971>, 
      <1.401262, 0.877935, 61.970906>, <1.496556, 0.973229, 62.724934>, <2.249570, 1.342344, 63.511334>, <2.429192, 1.521965, 64.233971>, 
      <1.139599, 1.139599, 61.970906>, <1.234893, 1.234893, 62.724934>, <1.795957, 1.795956, 63.511334>, <1.975579, 1.975578, 64.233971>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.347060, 0.000000, 61.733901>, <2.347060, -0.538909, 61.733901>, <2.040688, -1.278556, 61.733901>, <1.659622, -1.659622, 61.733901>, 
      <2.261405, 0.000000, 61.949293>, <2.261405, -0.538909, 61.949293>, <1.980121, -1.217989, 61.949293>, <1.599055, -1.599055, 61.949293>, 
      <1.570853, 0.000000, 61.742720>, <1.570853, -0.370048, 61.742720>, <1.372424, -0.849098, 61.742720>, <1.110761, -1.110761, 61.742720>, 
      <1.611636, 0.000000, 61.970906>, <1.611636, -0.370048, 61.970906>, <1.401262, -0.877935, 61.970906>, <1.139599, -1.139599, 61.970906>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.347060, 0.000000, 61.733901>, <2.261405, 0.000000, 61.949293>, <1.570853, 0.000000, 61.742720>, <1.611636, 0.000000, 61.970906>, 
      <2.347060, 0.538909, 61.733901>, <2.261405, 0.538909, 61.949293>, <1.570853, 0.370048, 61.742720>, <1.611636, 0.370048, 61.970906>, 
      <2.040689, 1.278556, 61.733901>, <1.980121, 1.217989, 61.949293>, <1.372425, 0.849098, 61.742720>, <1.401262, 0.877935, 61.970906>, 
      <1.659623, 1.659622, 61.733901>, <1.599056, 1.599055, 61.949293>, <1.110761, 1.110761, 61.742720>, <1.139599, 1.139599, 61.970906>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.913202, 0.000000, 61.212563>, <1.913202, -0.439290, 61.212563>, <1.663463, -1.042213, 61.212563>, <1.352838, -1.352838, 61.212563>, 
      <1.915027, 0.000000, 61.416032>, <1.915027, -0.439290, 61.416032>, <1.664754, -1.043503, 61.416032>, <1.354128, -1.354128, 61.416032>, 
      <2.422248, 0.000000, 61.544826>, <2.422248, -0.538909, 61.544826>, <2.093854, -1.331722, 61.544826>, <1.712788, -1.712788, 61.544826>, 
      <2.347060, 0.000000, 61.733901>, <2.347060, -0.538909, 61.733901>, <2.040688, -1.278556, 61.733901>, <1.659622, -1.659622, 61.733901>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.913202, 0.000000, 61.212563>, <1.915027, 0.000000, 61.416032>, <2.422248, 0.000000, 61.544826>, <2.347060, 0.000000, 61.733901>, 
      <1.913202, 0.439290, 61.212563>, <1.915027, 0.439290, 61.416032>, <2.422248, 0.538909, 61.544826>, <2.347060, 0.538909, 61.733901>, 
      <1.663463, 1.042212, 61.212563>, <1.664754, 1.043502, 61.416032>, <2.093855, 1.331722, 61.544826>, <2.040689, 1.278556, 61.733901>, 
      <1.352838, 1.352837, 61.212563>, <1.354129, 1.354127, 61.416032>, <1.712789, 1.712788, 61.544826>, <1.659623, 1.659622, 61.733901>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.239872, 0.000000, 49.782662>, <2.239872, -0.514297, 49.782662>, <1.947491, -1.220165, 49.782662>, <1.583828, -1.583828, 49.782662>, 
      <2.010993, 0.000000, 53.205386>, <2.010993, -0.514297, 53.205386>, <1.785649, -1.058324, 53.205386>, <1.421987, -1.421987, 53.205386>, 
      <1.882437, 0.000000, 57.782330>, <1.882437, -0.439290, 57.782330>, <1.641709, -1.020458, 57.782330>, <1.331084, -1.331084, 57.782330>, 
      <1.913202, 0.000000, 61.212563>, <1.913202, -0.439290, 61.212563>, <1.663463, -1.042213, 61.212563>, <1.352838, -1.352838, 61.212563>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.239872, 0.000000, 49.782662>, <2.010993, 0.000000, 53.205386>, <1.882437, 0.000000, 57.782330>, <1.913202, 0.000000, 61.212563>, 
      <2.239872, 0.514297, 49.782662>, <2.010994, 0.514297, 53.205386>, <1.882437, 0.439290, 57.782330>, <1.913202, 0.439290, 61.212563>, 
      <1.947492, 1.220165, 49.782662>, <1.785650, 1.058324, 53.205386>, <1.641709, 1.020458, 57.782330>, <1.663463, 1.042212, 61.212563>, 
      <1.583829, 1.583828, 49.782662>, <1.421988, 1.421987, 53.205386>, <1.331084, 1.331083, 57.782330>, <1.352838, 1.352837, 61.212563>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.693499, 0.000000, 49.543744>, <2.693499, -0.618454, 49.543744>, <2.341904, -1.467278, 49.543744>, <1.904591, -1.904591, 49.543744>, 
      <2.673865, 0.000000, 49.696294>, <2.673865, -0.618454, 49.696294>, <2.328020, -1.453394, 49.696294>, <1.890707, -1.890707, 49.696294>, 
      <2.250134, 0.000000, 49.629197>, <2.250134, -0.514297, 49.629197>, <1.954748, -1.227422, 49.629197>, <1.591085, -1.591085, 49.629197>, 
      <2.239872, 0.000000, 49.782662>, <2.239872, -0.514297, 49.782662>, <1.947491, -1.220165, 49.782662>, <1.583828, -1.583828, 49.782662>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.693499, 0.000000, 49.543744>, <2.673865, 0.000000, 49.696294>, <2.250134, 0.000000, 49.629197>, <2.239872, 0.000000, 49.782662>, 
      <2.693499, 0.618454, 49.543744>, <2.673865, 0.618454, 49.696294>, <2.250134, 0.514297, 49.629197>, <2.239872, 0.514297, 49.782662>, 
      <2.341904, 1.467277, 49.543744>, <2.328021, 1.453393, 49.696294>, <1.954748, 1.227422, 49.629197>, <1.947492, 1.220165, 49.782662>, 
      <1.904591, 1.904590, 49.543744>, <1.890707, 1.890706, 49.696294>, <1.591086, 1.591085, 49.629197>, <1.583829, 1.583828, 49.782662>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.330597, 0.000000, 49.077763>, <2.330597, -0.535129, 49.077763>, <2.026374, -1.269588, 49.077763>, <1.647981, -1.647981, 49.077763>, 
      <2.327610, 0.000000, 49.254925>, <2.327610, -0.535129, 49.254925>, <2.024262, -1.267476, 49.254925>, <1.645869, -1.645869, 49.254925>, 
      <2.716117, 0.000000, 49.368003>, <2.716117, -0.618454, 49.368003>, <2.357898, -1.483272, 49.368006>, <1.920585, -1.920585, 49.368006>, 
      <2.693499, 0.000000, 49.543744>, <2.693499, -0.618454, 49.543744>, <2.341904, -1.467278, 49.543744>, <1.904591, -1.904591, 49.543744>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.330597, 0.000000, 49.077763>, <2.327610, 0.000000, 49.254925>, <2.716117, 0.000000, 49.368003>, <2.693499, 0.000000, 49.543744>, 
      <2.330597, 0.535128, 49.077763>, <2.327610, 0.535128, 49.254925>, <2.716117, 0.618454, 49.368003>, <2.693499, 0.618454, 49.543744>, 
      <2.026374, 1.269587, 49.077763>, <2.024262, 1.267475, 49.254925>, <2.357898, 1.483270, 49.368006>, <2.341904, 1.467277, 49.543744>, 
      <1.647981, 1.647980, 49.077763>, <1.645869, 1.645868, 49.254925>, <1.920585, 1.920584, 49.368006>, <1.904591, 1.904590, 49.543744>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.145757, 0.000000, 22.720562>, <3.145757, -0.722298, 22.720562>, <2.735127, -1.713645, 22.720562>, <2.224386, -2.224386, 22.720562>, 
      <2.730637, 0.000000, 30.620605>, <2.730636, -0.722298, 30.620605>, <2.441593, -1.420111, 30.620605>, <1.930852, -1.930852, 30.620605>, 
      <2.463962, 0.000000, 41.167946>, <2.463962, -0.535129, 41.167946>, <2.120677, -1.363892, 41.167946>, <1.742285, -1.742285, 41.167946>, 
      <2.330597, 0.000000, 49.077763>, <2.330597, -0.535129, 49.077763>, <2.026374, -1.269588, 49.077763>, <1.647981, -1.647981, 49.077763>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.145757, 0.000000, 22.720562>, <2.730637, 0.000000, 30.620605>, <2.463962, 0.000000, 41.167946>, <2.330597, 0.000000, 49.077763>, 
      <3.145757, 0.722297, 22.720562>, <2.730637, 0.722297, 30.620605>, <2.463962, 0.535128, 41.167946>, <2.330597, 0.535128, 49.077763>, 
      <2.735128, 1.713645, 22.720562>, <2.441594, 1.420110, 30.620605>, <2.120678, 1.363891, 41.167946>, <2.026374, 1.269587, 49.077763>, 
      <2.224387, 2.224386, 22.720562>, <1.930853, 1.930852, 30.620605>, <1.742285, 1.742284, 41.167946>, <1.647981, 1.647980, 49.077763>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.730029, 0.000000, 22.445547>, <3.730029, -0.856452, 22.445547>, <3.243131, -2.031925, 22.445547>, <2.637528, -2.637528, 22.445547>, 
      <3.666833, 0.000000, 22.628677>, <3.666832, -0.856452, 22.628677>, <3.198445, -1.987238, 22.628677>, <2.592841, -2.592841, 22.628677>, 
      <3.155923, 0.000000, 22.527101>, <3.155922, -0.722298, 22.527101>, <2.742316, -1.720833, 22.527101>, <2.231574, -2.231574, 22.527101>, 
      <3.145757, 0.000000, 22.720562>, <3.145757, -0.722298, 22.720562>, <2.735127, -1.713645, 22.720562>, <2.224386, -2.224386, 22.720562>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.730029, 0.000000, 22.445547>, <3.666833, 0.000000, 22.628677>, <3.155923, 0.000000, 22.527101>, <3.145757, 0.000000, 22.720562>, 
      <3.730029, 0.856452, 22.445547>, <3.666833, 0.856452, 22.628677>, <3.155923, 0.722297, 22.527101>, <3.145757, 0.722297, 22.720562>, 
      <3.243132, 2.031925, 22.445547>, <3.198446, 1.987239, 22.628677>, <2.742317, 1.720833, 22.527101>, <2.735128, 1.713645, 22.720562>, 
      <2.637529, 2.637528, 22.445547>, <2.592843, 2.592842, 22.628677>, <2.231575, 2.231574, 22.527101>, <2.224387, 2.224386, 22.720562>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.388075, 0.000000, 22.018371>, <3.388075, -0.777936, 22.018371>, <2.945815, -1.845647, 22.018371>, <2.395731, -2.395731, 22.018371>, 
      <3.377430, 0.000000, 22.182182>, <3.377430, -0.777936, 22.182182>, <2.938288, -1.838120, 22.182181>, <2.388204, -2.388204, 22.182181>, 
      <3.783579, 0.000000, 22.290371>, <3.783578, -0.856452, 22.290371>, <3.280996, -2.069790, 22.290371>, <2.675393, -2.675393, 22.290371>, 
      <3.730029, 0.000000, 22.445547>, <3.730029, -0.856452, 22.445547>, <3.243131, -2.031925, 22.445547>, <2.637528, -2.637528, 22.445547>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.388075, 0.000000, 22.018371>, <3.377430, 0.000000, 22.182182>, <3.783579, 0.000000, 22.290371>, <3.730029, 0.000000, 22.445547>, 
      <3.388075, 0.777936, 22.018371>, <3.377430, 0.777936, 22.182182>, <3.783579, 0.856452, 22.290371>, <3.730029, 0.856452, 22.445547>, 
      <2.945815, 1.845646, 22.018371>, <2.938287, 1.838119, 22.182182>, <3.280997, 2.069790, 22.290371>, <3.243132, 2.031925, 22.445547>, 
      <2.395731, 2.395730, 22.018371>, <2.388204, 2.388203, 22.182182>, <2.675394, 2.675393, 22.290371>, <2.637529, 2.637528, 22.445547>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <5.192366, 0.000000, -0.057038>, <5.192366, -1.192220, -0.057038>, <4.514584, -2.828530, -0.057038>, <3.671557, -3.671557, -0.057038>, 
      <4.898586, 0.000000, 6.581171>, <4.898586, -1.192220, 6.581171>, <4.306850, -2.620796, 6.581171>, <3.463823, -3.463823, 6.581171>, 
      <3.818974, 0.000000, 15.387651>, <3.818974, -0.777936, 15.387651>, <3.250507, -2.150339, 15.387651>, <2.700423, -2.700423, 15.387651>, 
      <3.388075, 0.000000, 22.018371>, <3.388075, -0.777936, 22.018371>, <2.945815, -1.845647, 22.018371>, <2.395731, -2.395731, 22.018371>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <5.192366, 0.000000, -0.057038>, <4.898586, 0.000000, 6.581171>, <3.818974, 0.000000, 15.387651>, <3.388075, 0.000000, 22.018371>, 
      <5.192366, 1.192219, -0.057038>, <4.898586, 1.192219, 6.581171>, <3.818974, 0.777936, 15.387651>, <3.388075, 0.777936, 22.018371>, 
      <4.514584, 2.828530, -0.057038>, <4.306850, 2.620796, 6.581171>, <3.250507, 2.150338, 15.387651>, <2.945815, 1.845646, 22.018371>, 
      <3.671558, 3.671556, -0.057038>, <3.463824, 3.463822, 6.581171>, <2.700423, 2.700422, 15.387651>, <2.395731, 2.395730, 22.018371>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.121951, 0.000000, -6.857923>, <3.121951, -0.716831, -6.857923>, <2.714428, -1.700676, -6.857923>, <2.207552, -2.207552, -6.857923>, 
      <3.272045, 0.000000, -6.563314>, <3.272045, -0.716831, -6.563314>, <2.820561, -1.806808, -6.563314>, <2.313684, -2.313684, -6.563314>, 
      <3.597784, 0.000000, -6.245106>, <3.597784, -0.860198, -6.245106>, <3.152269, -1.935766, -6.245107>, <2.544018, -2.544018, -6.245107>, 
      <3.746341, 0.000000, -5.949719>, <3.746341, -0.860198, -5.949719>, <3.257315, -2.040812, -5.949719>, <2.649063, -2.649063, -5.949719>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.121951, 0.000000, -6.857923>, <3.272045, 0.000000, -6.563314>, <3.597784, 0.000000, -6.245106>, <3.746341, 0.000000, -5.949719>, 
      <3.121951, 0.716831, -6.857923>, <3.272045, 0.716831, -6.563314>, <3.597784, 0.860197, -6.245106>, <3.746341, 0.860197, -5.949719>, 
      <2.714429, 1.700676, -6.857923>, <2.820562, 1.806808, -6.563314>, <3.152269, 1.935765, -6.245106>, <3.257314, 2.040811, -5.949719>, 
      <2.207553, 2.207552, -6.857923>, <2.313685, 2.313684, -6.563314>, <2.544018, 2.544017, -6.245106>, <2.649063, 2.649062, -5.949719>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.541138, 0.000000, -4.036035>, <4.392984, 0.000000, -4.639774>, <4.025649, 0.000000, -5.394348>, <3.746341, 0.000000, -5.949719>, 
      <4.541138, -1.042691, -4.036035>, <4.392984, -1.042691, -4.639774>, <4.025649, -0.860198, -5.394348>, <3.746341, -0.860198, -5.949719>, 
      <3.948364, -2.473776, -4.036035>, <3.843604, -2.369016, -4.639774>, <3.454815, -2.238312, -5.394348>, <3.257315, -2.040812, -5.949719>, 
      <3.211070, -3.211070, -4.036035>, <3.106310, -3.106310, -4.639774>, <2.846564, -2.846564, -5.394348>, <2.649063, -2.649063, -5.949719>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.541138, 0.000000, -4.036035>, <4.541138, 1.042691, -4.036035>, <3.948364, 2.473774, -4.036035>, <3.211070, 3.211068, -4.036035>, 
      <4.392984, 0.000000, -4.639774>, <4.392984, 1.042691, -4.639774>, <3.843603, 2.369014, -4.639774>, <3.106310, 3.106308, -4.639774>, 
      <4.025649, 0.000000, -5.394348>, <4.025649, 0.860197, -5.394348>, <3.454815, 2.238311, -5.394348>, <2.846564, 2.846562, -5.394348>, 
      <3.746341, 0.000000, -5.949719>, <3.746341, 0.860197, -5.949719>, <3.257314, 2.040811, -5.949719>, <2.649063, 2.649062, -5.949719>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.541138, 0.000000, -4.036035>, <4.541138, -1.042691, -4.036035>, <3.948364, -2.473776, -4.036035>, <3.211070, -3.211070, -4.036035>, 
      <4.829409, 0.000000, -2.861307>, <4.829409, -1.042691, -2.861307>, <4.152202, -2.677614, -2.861307>, <3.414908, -3.414908, -2.861307>, 
      <5.245845, 0.000000, -1.265436>, <5.245845, -1.192220, -1.265436>, <4.552399, -2.866346, -1.265436>, <3.709372, -3.709372, -1.265436>, 
      <5.192366, 0.000000, -0.057038>, <5.192366, -1.192220, -0.057038>, <4.514584, -2.828530, -0.057038>, <3.671557, -3.671557, -0.057038>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.541138, 0.000000, -4.036035>, <4.829409, 0.000000, -2.861307>, <5.245845, 0.000000, -1.265436>, <5.192366, 0.000000, -0.057038>, 
      <4.541138, 1.042691, -4.036035>, <4.829409, 1.042691, -2.861307>, <5.245845, 1.192219, -1.265436>, <5.192366, 1.192219, -0.057038>, 
      <3.948364, 2.473774, -4.036035>, <4.152202, 2.677613, -2.861307>, <4.552400, 2.866345, -1.265436>, <4.514584, 2.828530, -0.057038>, 
      <3.211070, 3.211068, -4.036035>, <3.414908, 3.414906, -2.861307>, <3.709373, 3.709371, -1.265436>, <3.671558, 3.671556, -0.057038>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.440798, 0.000000, -8.512278>, <2.440798, -0.560432, -8.512278>, <2.122190, -1.329620, -8.512278>, <1.725905, -1.725905, -8.512278>, 
      <2.547826, 0.000000, -7.986329>, <2.547826, -0.560432, -7.986329>, <2.197870, -1.405299, -7.986329>, <1.801584, -1.801584, -7.986329>, 
      <2.878303, 0.000000, -7.336162>, <2.878303, -0.716831, -7.336162>, <2.542143, -1.528391, -7.336162>, <2.035267, -2.035267, -7.336162>, 
      <3.121951, 0.000000, -6.857923>, <3.121951, -0.716831, -6.857923>, <2.714428, -1.700676, -6.857923>, <2.207552, -2.207552, -6.857923>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.440798, 0.000000, -8.512278>, <2.547826, 0.000000, -7.986329>, <2.878303, 0.000000, -7.336162>, <3.121951, 0.000000, -6.857923>, 
      <2.440798, 0.560432, -8.512278>, <2.547826, 0.560432, -7.986329>, <2.878304, 0.716831, -7.336162>, <3.121951, 0.716831, -6.857923>, 
      <2.122190, 1.329619, -8.512278>, <2.197870, 1.405299, -7.986329>, <2.542144, 1.528391, -7.336162>, <2.714429, 1.700676, -6.857923>, 
      <1.725905, 1.725904, -8.512278>, <1.801585, 1.801584, -7.986329>, <2.035268, 2.035267, -7.336162>, <2.207553, 2.207552, -6.857923>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.781374, 0.000000, -8.531567>, <2.781374, -0.638632, -8.531567>, <2.418310, -1.515148, -8.531567>, <1.966729, -1.966729, -8.531567>, 
      <2.731867, 0.000000, -8.442002>, <2.731867, -0.638632, -8.442002>, <2.383303, -1.480142, -8.442002>, <1.931722, -1.931722, -8.442002>, 
      <2.420391, 0.000000, -8.612559>, <2.420391, -0.560432, -8.612559>, <2.107760, -1.315190, -8.612559>, <1.711475, -1.711475, -8.612559>, 
      <2.440798, 0.000000, -8.512278>, <2.440798, -0.560432, -8.512278>, <2.122190, -1.329620, -8.512278>, <1.725905, -1.725905, -8.512278>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.781374, 0.000000, -8.531567>, <2.731867, 0.000000, -8.442002>, <2.420391, 0.000000, -8.612559>, <2.440798, 0.000000, -8.512278>, 
      <2.781374, 0.638631, -8.531567>, <2.731867, 0.638631, -8.442002>, <2.420391, 0.560432, -8.612559>, <2.440798, 0.560432, -8.512278>, 
      <2.418309, 1.515147, -8.531567>, <2.383303, 1.480141, -8.442002>, <2.107760, 1.315189, -8.612559>, <2.122190, 1.329619, -8.512278>, 
      <1.966729, 1.966728, -8.531567>, <1.931722, 1.931721, -8.442002>, <1.711475, 1.711474, -8.612559>, <1.725905, 1.725904, -8.512278>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.951663, 0.000000, -9.436507>, <2.951663, -0.677732, -9.436507>, <2.566370, -1.607912, -9.436507>, <2.087141, -2.087141, -9.436507>, 
      <2.941825, 0.000000, -9.160436>, <2.941825, -0.677732, -9.160436>, <2.559413, -1.600956, -9.160436>, <2.080184, -2.080184, -9.160436>, 
      <2.915012, 0.000000, -8.773338>, <2.915012, -0.638632, -8.773338>, <2.512806, -1.609645, -8.773338>, <2.061225, -2.061225, -8.773338>, 
      <2.781374, 0.000000, -8.531567>, <2.781374, -0.638632, -8.531567>, <2.418310, -1.515148, -8.531567>, <1.966729, -1.966729, -8.531567>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.951663, 0.000000, -9.436507>, <2.941825, 0.000000, -9.160436>, <2.915012, 0.000000, -8.773338>, <2.781374, 0.000000, -8.531567>, 
      <2.951663, 0.677731, -9.436507>, <2.941825, 0.677731, -9.160436>, <2.915012, 0.638631, -8.773338>, <2.781374, 0.638631, -8.531567>, 
      <2.566370, 1.607912, -9.436507>, <2.559413, 1.600955, -9.160436>, <2.512806, 1.609644, -8.773338>, <2.418309, 1.515147, -8.531567>, 
      <2.087141, 2.087140, -9.436507>, <2.080184, 2.080184, -9.160436>, <2.061225, 2.061224, -8.773338>, <1.966729, 1.966728, -8.531567>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.894900, 0.000000, -11.717257>, <2.894900, -0.664698, -11.717257>, <2.517015, -1.576991, -11.717257>, <2.047003, -2.047003, -11.717257>, 
      <2.817832, 0.000000, -11.037172>, <2.817831, -0.664698, -11.037172>, <2.462520, -1.522495, -11.037172>, <1.992507, -1.992507, -11.037172>, 
      <2.976038, 0.000000, -10.120510>, <2.976038, -0.677732, -10.120510>, <2.583605, -1.625148, -10.120510>, <2.104377, -2.104377, -10.120510>, 
      <2.951663, 0.000000, -9.436507>, <2.951663, -0.677732, -9.436507>, <2.566370, -1.607912, -9.436507>, <2.087141, -2.087141, -9.436507>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.894900, 0.000000, -11.717257>, <2.817832, 0.000000, -11.037172>, <2.976038, 0.000000, -10.120510>, <2.951663, 0.000000, -9.436507>, 
      <2.894900, 0.664698, -11.717257>, <2.817832, 0.664698, -11.037172>, <2.976038, 0.677731, -10.120510>, <2.951663, 0.677731, -9.436507>, 
      <2.517016, 1.576990, -11.717257>, <2.462521, 1.522494, -11.037172>, <2.583606, 1.625148, -10.120510>, <2.566370, 1.607912, -9.436507>, 
      <2.047004, 2.047002, -11.717257>, <1.992508, 1.992506, -11.037172>, <2.104377, 2.104376, -10.120510>, <2.087141, 2.087140, -9.436507>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.292239, 0.000000, -12.441892>, <3.292239, -0.755931, -12.441892>, <2.862489, -1.793441, -12.441892>, <2.327965, -2.327965, -12.441892>, 
      <3.268054, 0.000000, -12.195147>, <3.268054, -0.755931, -12.195147>, <2.845387, -1.776339, -12.195147>, <2.310863, -2.310863, -12.195147>, 
      <2.922817, 0.000000, -11.963607>, <2.922817, -0.664698, -11.963607>, <2.536756, -1.596731, -11.963607>, <2.066743, -2.066743, -11.963607>, 
      <2.894900, 0.000000, -11.717257>, <2.894900, -0.664698, -11.717257>, <2.517015, -1.576991, -11.717257>, <2.047003, -2.047003, -11.717257>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.292239, 0.000000, -12.441892>, <3.268054, 0.000000, -12.195147>, <2.922817, 0.000000, -11.963607>, <2.894900, 0.000000, -11.717257>, 
      <3.292239, 0.755931, -12.441892>, <3.268054, 0.755931, -12.195147>, <2.922817, 0.664698, -11.963607>, <2.894900, 0.664698, -11.717257>, 
      <2.862489, 1.793440, -12.441892>, <2.845387, 1.776338, -12.195147>, <2.536757, 1.596730, -11.963607>, <2.517016, 1.576990, -11.717257>, 
      <2.327965, 2.327964, -12.441892>, <2.310863, 2.310862, -12.195147>, <2.066744, 2.066742, -11.963607>, <2.047004, 2.047002, -11.717257>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.065188, 0.000000, -13.454566>, <3.065188, -0.703798, -13.454566>, <2.665075, -1.669755, -13.454566>, <2.167415, -2.167415, -13.454566>, 
      <2.964821, 0.000000, -13.159843>, <2.964821, -0.703798, -13.159843>, <2.594105, -1.598785, -13.159842>, <2.096445, -2.096445, -13.159842>, 
      <3.322611, 0.000000, -12.751752>, <3.322611, -0.755931, -12.751752>, <2.883965, -1.814917, -12.751752>, <2.349441, -2.349441, -12.751752>, 
      <3.292239, 0.000000, -12.441892>, <3.292239, -0.755931, -12.441892>, <2.862489, -1.793441, -12.441892>, <2.327965, -2.327965, -12.441892>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.065188, 0.000000, -13.454566>, <2.964821, 0.000000, -13.159843>, <3.322611, 0.000000, -12.751752>, <3.292239, 0.000000, -12.441892>, 
      <3.065188, 0.703798, -13.454566>, <2.964821, 0.703798, -13.159843>, <3.322611, 0.755931, -12.751752>, <3.292239, 0.755931, -12.441892>, 
      <2.665076, 1.669754, -13.454566>, <2.594106, 1.598784, -13.159842>, <2.883965, 1.814916, -12.751752>, <2.862489, 1.793440, -12.441892>, 
      <2.167416, 2.167414, -13.454566>, <2.096446, 2.096444, -13.159842>, <2.349441, 2.349440, -12.751752>, <2.327965, 2.327964, -12.441892>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.576053, 0.000000, -13.275301>, <3.576053, -0.821098, -13.275301>, <3.109255, -1.948047, -13.275301>, <2.528651, -2.528651, -13.275301>, 
      <3.425538, 0.000000, -13.214258>, <3.425538, -0.821098, -13.214258>, <3.002825, -1.841618, -13.214258>, <2.422221, -2.422221, -13.214258>, 
      <3.117547, 0.000000, -13.608317>, <3.117547, -0.703798, -13.608317>, <2.702099, -1.706778, -13.608317>, <2.204438, -2.204438, -13.608317>, 
      <3.065188, 0.000000, -13.454566>, <3.065188, -0.703798, -13.454566>, <2.665075, -1.669755, -13.454566>, <2.167415, -2.167415, -13.454566>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.576053, 0.000000, -13.275301>, <3.425538, 0.000000, -13.214258>, <3.117547, 0.000000, -13.608317>, <3.065188, 0.000000, -13.454566>, 
      <3.576053, 0.821098, -13.275301>, <3.425538, 0.821098, -13.214258>, <3.117547, 0.703798, -13.608317>, <3.065188, 0.703798, -13.454566>, 
      <3.109255, 1.948046, -13.275301>, <3.002825, 1.841617, -13.214258>, <2.702100, 1.706777, -13.608317>, <2.665076, 1.669754, -13.454566>, 
      <2.528651, 2.528650, -13.275301>, <2.422222, 2.422220, -13.214258>, <2.204439, 2.204437, -13.608317>, <2.167416, 2.167414, -13.454566>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.519290, 0.000000, -13.638731>, <3.519290, -0.808064, -13.638731>, <3.059902, -1.917126, -13.638731>, <2.488514, -2.488514, -13.638731>, 
      <3.413164, 0.000000, -13.608490>, <3.413164, -0.808064, -13.608490>, <2.984859, -1.842084, -13.608490>, <2.413471, -2.413471, -13.608490>, 
      <3.678314, 0.000000, -13.316774>, <3.678314, -0.821098, -13.316774>, <3.181565, -2.020357, -13.316774>, <2.600961, -2.600961, -13.316774>, 
      <3.576053, 0.000000, -13.275301>, <3.576053, -0.821098, -13.275301>, <3.109255, -1.948047, -13.275301>, <2.528651, -2.528651, -13.275301>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.519290, 0.000000, -13.638731>, <3.413164, 0.000000, -13.608490>, <3.678314, 0.000000, -13.316774>, <3.576053, 0.000000, -13.275301>, 
      <3.519290, 0.808064, -13.638731>, <3.413164, 0.808064, -13.608490>, <3.678314, 0.821098, -13.316774>, <3.576053, 0.821098, -13.275301>, 
      <3.059902, 1.917125, -13.638731>, <2.984859, 1.842083, -13.608490>, <3.181564, 2.020356, -13.316774>, <3.109255, 1.948046, -13.275301>, 
      <2.488514, 2.488513, -13.638731>, <2.413471, 2.413471, -13.608490>, <2.600960, 2.600960, -13.316774>, <2.528651, 2.528650, -13.275301>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.916629, 0.000000, -13.372355>, <3.916629, -0.899297, -13.372355>, <3.405374, -2.133576, -13.372355>, <2.769475, -2.769475, -13.372355>, 
      <3.797428, 0.000000, -13.452269>, <3.797428, -0.899297, -13.452269>, <3.321086, -2.049287, -13.452269>, <2.685187, -2.685187, -13.452269>, 
      <3.657305, 0.000000, -13.678062>, <3.657305, -0.808064, -13.678062>, <3.157493, -2.014718, -13.678062>, <2.586105, -2.586105, -13.678062>, 
      <3.519290, 0.000000, -13.638731>, <3.519290, -0.808064, -13.638731>, <3.059902, -1.917126, -13.638731>, <2.488514, -2.488514, -13.638731>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.916629, 0.000000, -13.372355>, <3.797428, 0.000000, -13.452269>, <3.657305, 0.000000, -13.678062>, <3.519290, 0.000000, -13.638731>, 
      <3.916629, 0.899297, -13.372355>, <3.797428, 0.899297, -13.452269>, <3.657305, 0.808064, -13.678062>, <3.519290, 0.808064, -13.638731>, 
      <3.405374, 2.133575, -13.372355>, <3.321086, 2.049287, -13.452269>, <3.157493, 2.014717, -13.678062>, <3.059902, 1.917125, -13.638731>, 
      <2.769475, 2.769474, -13.372355>, <2.685187, 2.685186, -13.452269>, <2.586105, 2.586104, -13.678062>, <2.488514, 2.488513, -13.638731>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.030155, 0.000000, -16.192387>, <4.030155, -0.925364, -16.192387>, <3.504081, -2.195419, -16.192387>, <2.849750, -2.849750, -16.192387>, 
      <3.996097, 0.000000, -15.346378>, <3.996097, -0.925364, -15.346378>, <3.479999, -2.171336, -15.346378>, <2.825668, -2.825668, -15.346378>, 
      <3.950687, 0.000000, -14.218365>, <3.950687, -0.899297, -14.218365>, <3.429457, -2.157658, -14.218365>, <2.793557, -2.793557, -14.218365>, 
      <3.916629, 0.000000, -13.372355>, <3.916629, -0.899297, -13.372355>, <3.405374, -2.133576, -13.372355>, <2.769475, -2.769475, -13.372355>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.030155, 0.000000, -16.192387>, <3.996097, 0.000000, -15.346378>, <3.950687, 0.000000, -14.218365>, <3.916629, 0.000000, -13.372355>, 
      <4.030155, 0.925364, -16.192387>, <3.996097, 0.925364, -15.346378>, <3.950687, 0.899297, -14.218365>, <3.916629, 0.899297, -13.372355>, 
      <3.504081, 2.195418, -16.192387>, <3.479998, 2.171335, -15.346378>, <3.429456, 2.157657, -14.218365>, <3.405374, 2.133575, -13.372355>, 
      <2.849750, 2.849749, -16.192387>, <2.825668, 2.825667, -15.346378>, <2.793557, 2.793556, -14.218365>, <2.769475, 2.769474, -13.372355>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.113525, 0.000000, -16.192387>, <0.113525, -0.026067, -16.192387>, <0.098707, -0.061843, -16.192387>, <0.080275, -0.080275, -16.192387>, 
      <1.288514, 0.000000, -16.192387>, <1.288514, -0.026067, -16.192387>, <0.929549, -0.892686, -16.192387>, <0.911118, -0.911118, -16.192387>, 
      <2.855166, 0.000000, -16.192387>, <2.855166, -0.925364, -16.192387>, <2.673239, -1.364576, -16.192387>, <2.018908, -2.018908, -16.192387>, 
      <4.030155, 0.000000, -16.192387>, <4.030155, -0.925364, -16.192387>, <3.504081, -2.195419, -16.192387>, <2.849750, -2.849750, -16.192387>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.113525, 0.000000, -16.192387>, <1.288514, 0.000000, -16.192387>, <2.855166, 0.000000, -16.192387>, <4.030155, 0.000000, -16.192387>, 
      <0.113525, 0.026067, -16.192387>, <1.288514, 0.026067, -16.192387>, <2.855166, 0.925364, -16.192387>, <4.030155, 0.925364, -16.192387>, 
      <0.098707, 0.061843, -16.192387>, <0.929549, 0.892685, -16.192387>, <2.673239, 1.364576, -16.192387>, <3.504081, 2.195418, -16.192387>, 
      <0.080275, 0.080275, -16.192387>, <0.911118, 0.911117, -16.192387>, <2.018908, 2.018907, -16.192387>, <2.849750, 2.849749, -16.192387>
    }
  }
  scale 0.35
  translate  <-13.299834, 7.316039, 6.656611>
}
#declare resta_basica_liston = difference {
  box { // Cube001
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.25, 10.0>
  }
  box { // Cube003
    <-1, -1, -1>, <1, 1, 1>
    scale <1.5, 0.25, 10.2>
    rotate 5.0*z
    translate  -0.415*y
  }
}
#declare liston_espejo = union {
  object { resta_basica_liston }
  cylinder { // Cylndr001
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 20.4>
    translate  <-1.1, -0.25, -10.2>
  }
  box { // Cube002
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.25, 10.2>
    translate  -1.1*x
  }
  cylinder { // Cylndr002
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 20.4>
    translate  <1.1, -0.07609, -10.2>
  }
  scale <1.0, 1.0, 1.5>
}
#declare liston_basico = difference {
  object { liston_espejo }
  box { // Cube005
    <-1, -1, -1>, <1, 1, 1>
    scale <3.0, 0.5, 3.0>
    rotate -45.0*y
    translate  <1.421068, 0.0, -16.78777>
  }
  box { // Cube004
    <-1, -1, -1>, <1, 1, 1>
    scale <3.0, 0.5, 3.0>
    rotate -45.0*y
    translate  <1.421068, 0.0, 16.787771>
  }
}
#declare resta_basica_liston1 = difference {
  box { // Cube006
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.25, 10.0>
  }
  box { // Cube007
    <-1, -1, -1>, <1, 1, 1>
    scale <1.5, 0.25, 10.2>
    rotate 5.0*z
    translate  -0.415*y
  }
}
#declare liston_espejo1 = union {
  object { resta_basica_liston1 }
  cylinder { // Cylndr003
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 20.4>
    translate  <-1.1, -0.25, -10.2>
  }
  box { // Cube008
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.25, 10.2>
    translate  -1.1*x
  }
  cylinder { // Cylndr004
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 20.4>
    translate  <1.1, -0.07609, -10.2>
  }
  scale <1.0, 1.0, 1.125>
}
#declare liston_basico1 = difference {
  object { liston_espejo1 }
  box { // Cube009
    <-1, -1, -1>, <1, 1, 1>
    scale <3.0, 0.5, 3.0>
    rotate -45.0*y
    translate  <1.421068, 0.0, -13.07897>
  }
  box { // Cube010
    <-1, -1, -1>, <1, 1, 1>
    scale <3.0, 0.5, 3.0>
    rotate -45.0*y
    translate  <1.421068, 0.0, 13.078967>
  }
  rotate -90.0*y
  translate  <10.277373, 0.0, -13.977228>
}
#declare marco_espejo_1 = union {
  object { liston_basico }
  object { liston_basico1 }
  translate  <-10.268709, 0.0, 7.4975>
}




//
// ********  OBJECTS  *******
//

#declare tubo_dientes = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.500000, 0.040827, 1.411635>, <0.449202, 0.010341, 1.509308>, <0.319112, -0.000007, 1.220164>, <0.241589, -0.017507, 1.138105>, 
      <0.500000, -0.217204, 1.500482>, <0.449202, -0.247690, 1.598155>, <0.319112, -0.124682, 1.263093>, <0.241589, -0.142182, 1.181034>, 
      <0.272899, -0.431932, 1.574419>, <0.273087, -0.420862, 1.694851>, <0.131859, -0.301734, 1.324057>, <0.131859, -0.245935, 1.216759>, 
      <0.000000, -0.431932, 1.574419>, <0.000188, -0.420862, 1.694851>, <0.000000, -0.301734, 1.324057>, <0.000000, -0.245935, 1.216759>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 0.513586, 1.248851>, <0.005741, 0.522323, 1.355452>, <0.000000, 0.301720, 1.116271>, <0.000000, 0.210920, 1.059451>, 
      <0.272899, 0.513586, 1.248851>, <0.278641, 0.522323, 1.355452>, <0.131859, 0.301720, 1.116271>, <0.131859, 0.210920, 1.059451>, 
      <0.500000, 0.298858, 1.322788>, <0.449202, 0.268373, 1.420461>, <0.319112, 0.124668, 1.177235>, <0.241589, 0.107168, 1.095176>, 
      <0.500000, 0.040827, 1.411635>, <0.449202, 0.010341, 1.509308>, <0.319112, -0.000007, 1.220164>, <0.241589, -0.017507, 1.138105>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.500000, 0.040827, 1.411635>, <-0.430601, 0.049562, 1.501953>, <-0.319112, -0.000007, 1.220164>, <-0.241589, -0.017507, 1.138105>, 
      <-0.500000, 0.298858, 1.322788>, <-0.430601, 0.307593, 1.413106>, <-0.319112, 0.124668, 1.177235>, <-0.241589, 0.107168, 1.095176>, 
      <-0.272899, 0.513586, 1.248851>, <-0.267158, 0.522323, 1.355452>, <-0.131859, 0.301720, 1.116271>, <-0.131859, 0.210920, 1.059451>, 
      <0.000000, 0.513586, 1.248851>, <0.005741, 0.522323, 1.355452>, <0.000000, 0.301720, 1.116271>, <0.000000, 0.210920, 1.059451>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.500000, 0.040827, 1.411635>, <-0.500000, -0.217204, 1.500482>, <-0.272899, -0.431932, 1.574419>, <0.000000, -0.431932, 1.574419>, 
      <-0.430601, 0.049562, 1.501953>, <-0.430601, -0.208470, 1.590800>, <-0.272711, -0.420862, 1.694851>, <0.000188, -0.420862, 1.694851>, 
      <-0.319112, -0.000007, 1.220164>, <-0.319112, -0.124682, 1.263093>, <-0.131859, -0.301734, 1.324057>, <0.000000, -0.301734, 1.324057>, 
      <-0.241589, -0.017507, 1.138105>, <-0.241589, -0.142182, 1.181034>, <-0.131859, -0.245935, 1.216759>, <0.000000, -0.245935, 1.216759>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.500000, -0.004288, -2.697739>, <0.500000, -0.004288, -2.668010>, <0.500000, -0.004288, -2.628370>, <0.500000, -0.004288, -2.598640>, 
      <0.350000, -0.004729, -2.697739>, <0.350000, -0.004729, -2.668010>, <0.500000, -0.197497, -2.628370>, <0.500000, -0.197497, -2.598640>, 
      <0.192970, -0.005759, -2.697739>, <0.192970, -0.012804, -2.668010>, <0.193209, -0.018625, -2.627289>, <0.193209, -0.029242, -2.598640>, 
      <0.000000, -0.005759, -2.697739>, <0.000000, -0.012804, -2.668010>, <0.000000, -0.018625, -2.627289>, <0.000000, -0.029242, -2.598640>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -0.002817, -2.697739>, <0.000000, 0.004228, -2.668010>, <0.000000, 0.010049, -2.627289>, <0.000000, 0.020666, -2.598640>, 
      <0.192970, -0.002817, -2.697739>, <0.192970, 0.004228, -2.668010>, <0.193209, 0.010049, -2.627289>, <0.193209, 0.020666, -2.598640>, 
      <0.350000, -0.003847, -2.697739>, <0.350000, -0.003847, -2.668010>, <0.500000, 0.188921, -2.628370>, <0.500000, 0.188921, -2.598640>, 
      <0.500000, -0.004288, -2.697739>, <0.500000, -0.004288, -2.668010>, <0.500000, -0.004288, -2.628370>, <0.500000, -0.004288, -2.598640>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.500000, -0.004288, -2.697739>, <-0.500000, -0.004288, -2.668010>, <-0.500000, -0.004288, -2.628370>, <-0.500000, -0.004288, -2.598640>, 
      <-0.350000, -0.003847, -2.697739>, <-0.350000, -0.003847, -2.668010>, <-0.500000, 0.188921, -2.628370>, <-0.500000, 0.188921, -2.598640>, 
      <-0.192970, -0.002817, -2.697739>, <-0.192970, 0.004228, -2.668010>, <-0.193209, 0.010049, -2.627289>, <-0.193209, 0.020666, -2.598640>, 
      <0.000000, -0.002817, -2.697739>, <0.000000, 0.004228, -2.668010>, <0.000000, 0.010049, -2.627289>, <0.000000, 0.020666, -2.598640>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.500000, -0.004288, -2.697739>, <-0.350000, -0.004729, -2.697739>, <-0.192970, -0.005759, -2.697739>, <0.000000, -0.005759, -2.697739>, 
      <-0.500000, -0.004288, -2.668010>, <-0.350000, -0.004729, -2.668010>, <-0.192970, -0.012804, -2.668010>, <0.000000, -0.012804, -2.668010>, 
      <-0.500000, -0.004288, -2.628370>, <-0.500000, -0.197497, -2.628370>, <-0.193209, -0.018625, -2.627289>, <0.000000, -0.018625, -2.627289>, 
      <-0.500000, -0.004288, -2.598640>, <-0.500000, -0.197497, -2.598640>, <-0.193209, -0.029242, -2.598640>, <0.000000, -0.029242, -2.598640>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.500000, -0.004288, -2.481523>, <0.500000, -0.199810, -2.481523>, <0.195522, -0.085890, -2.481523>, <0.000000, -0.085890, -2.481523>, 
      <0.500000, -0.000504, -2.516454>, <0.500000, -0.196026, -2.516454>, <0.195522, -0.074681, -2.518909>, <0.000000, -0.074681, -2.518909>, 
      <0.500000, -0.004288, -2.563505>, <0.500000, -0.197497, -2.563505>, <0.193209, -0.042805, -2.562044>, <0.000000, -0.042805, -2.562044>, 
      <0.500000, -0.004288, -2.598640>, <0.500000, -0.197497, -2.598640>, <0.193209, -0.029242, -2.598640>, <0.000000, -0.029242, -2.598640>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 0.077314, -2.481523>, <0.195522, 0.077314, -2.481523>, <0.500000, 0.191234, -2.481523>, <0.500000, -0.004288, -2.481523>, 
      <0.000000, 0.066921, -2.519143>, <0.195522, 0.066921, -2.519143>, <0.500000, 0.195018, -2.516454>, <0.500000, -0.000504, -2.516454>, 
      <0.000000, 0.034229, -2.562044>, <0.193209, 0.034229, -2.562044>, <0.500000, 0.188921, -2.563505>, <0.500000, -0.004288, -2.563505>, 
      <0.000000, 0.020666, -2.598640>, <0.193209, 0.020666, -2.598640>, <0.500000, 0.188921, -2.598640>, <0.500000, -0.004288, -2.598640>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.500000, -0.004288, -2.481523>, <-0.500000, 0.191234, -2.481523>, <-0.195522, 0.077314, -2.481523>, <0.000000, 0.077314, -2.481523>, 
      <-0.500000, -0.009364, -2.516290>, <-0.500000, 0.186158, -2.516290>, <-0.195522, 0.066921, -2.519143>, <0.000000, 0.066921, -2.519143>, 
      <-0.500000, -0.004288, -2.563505>, <-0.500000, 0.188921, -2.563505>, <-0.193209, 0.034229, -2.562044>, <0.000000, 0.034229, -2.562044>, 
      <-0.500000, -0.004288, -2.598640>, <-0.500000, 0.188921, -2.598640>, <-0.193209, 0.020666, -2.598640>, <0.000000, 0.020666, -2.598640>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.500000, -0.004288, -2.481523>, <-0.500000, -0.009364, -2.516290>, <-0.500000, -0.004288, -2.563505>, <-0.500000, -0.004288, -2.598640>, 
      <-0.500000, -0.199810, -2.481523>, <-0.500000, -0.204886, -2.516290>, <-0.500000, -0.197497, -2.563505>, <-0.500000, -0.197497, -2.598640>, 
      <-0.195522, -0.085890, -2.481523>, <-0.195522, -0.074681, -2.518909>, <-0.193209, -0.042805, -2.562044>, <-0.193209, -0.029242, -2.598640>, 
      <0.000000, -0.085890, -2.481523>, <0.000000, -0.074681, -2.518909>, <0.000000, -0.042805, -2.562044>, <0.000000, -0.029242, -2.598640>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.500000, -0.112618, -0.819819>, <0.500000, -0.322892, -0.819819>, <0.203786, -0.380894, -0.819819>, <0.000000, -0.329063, -0.819819>, 
      <0.499342, -0.129209, -1.864975>, <0.499342, -0.339482, -1.864975>, <0.204252, -0.322304, -1.867048>, <0.000467, -0.270473, -1.867048>, 
      <0.500000, -0.033028, -2.216224>, <0.500000, -0.228550, -2.216224>, <0.195522, -0.164789, -2.218369>, <0.000000, -0.164789, -2.218369>, 
      <0.500000, -0.004288, -2.481523>, <0.500000, -0.199810, -2.481523>, <0.195522, -0.085890, -2.481523>, <0.000000, -0.085890, -2.481523>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 0.296938, -0.819819>, <0.241745, 0.235453, -0.819819>, <0.500000, 0.136823, -0.819819>, <0.500000, -0.112618, -0.819819>, 
      <0.001345, 0.284588, -1.871294>, <0.243090, 0.223103, -1.871294>, <0.499342, 0.120233, -1.864975>, <0.499342, -0.129209, -1.864975>, 
      <0.000000, 0.149996, -2.218442>, <0.195522, 0.149996, -2.218442>, <0.500000, 0.162494, -2.216224>, <0.500000, -0.033028, -2.216224>, 
      <0.000000, 0.077314, -2.481523>, <0.195522, 0.077314, -2.481523>, <0.500000, 0.191234, -2.481523>, <0.500000, -0.004288, -2.481523>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.500000, 0.141722, -0.819819>, <-0.500000, 0.343775, -0.819819>, <-0.195819, 0.346743, -0.819819>, <0.000000, 0.296938, -0.819819>, 
      <-0.499174, 0.146748, -1.867055>, <-0.499174, 0.348801, -1.867055>, <-0.194474, 0.334393, -1.871294>, <0.001345, 0.284588, -1.871294>, 
      <-0.500000, 0.034499, -2.215878>, <-0.500000, 0.230021, -2.215878>, <-0.195522, 0.149996, -2.218442>, <0.000000, 0.149996, -2.218442>, 
      <-0.500000, -0.004288, -2.481523>, <-0.500000, 0.191234, -2.481523>, <-0.195522, 0.077314, -2.481523>, <0.000000, 0.077314, -2.481523>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.500000, 0.141722, -0.819819>, <-0.499174, 0.146748, -1.867055>, <-0.500000, 0.034499, -2.215878>, <-0.500000, -0.004288, -2.481523>, 
      <-0.500000, -0.123325, -0.819819>, <-0.499174, -0.118299, -1.867055>, <-0.500000, -0.161023, -2.215878>, <-0.500000, -0.199810, -2.481523>, 
      <-0.256869, -0.263731, -0.819819>, <-0.256402, -0.205141, -1.867048>, <-0.195522, -0.164789, -2.218369>, <-0.195522, -0.085890, -2.481523>, 
      <0.000000, -0.329063, -0.819819>, <0.000467, -0.270473, -1.867048>, <0.000000, -0.164789, -2.218369>, <0.000000, -0.085890, -2.481523>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.505760, 0.141032, 0.630166>, <0.509391, -0.067639, 0.216104>, <0.447686, -0.302060, -0.393501>, <-0.002400, -0.387344, -0.321714>, 
      <0.505760, 0.110737, 0.189602>, <0.509391, -0.097934, -0.224460>, <0.447686, -0.295602, -0.543815>, <-0.002400, -0.380886, -0.472028>, 
      <0.501088, -0.085163, -0.379070>, <0.501088, -0.295436, -0.379070>, <0.203530, -0.412980, -0.672828>, <-0.000255, -0.361150, -0.672828>, 
      <0.500000, -0.112618, -0.819819>, <0.500000, -0.322892, -0.819819>, <0.203786, -0.380894, -0.819819>, <0.000000, -0.329063, -0.819819>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.505760, 0.141032, 0.630166>, <0.505760, 0.157247, 0.865976>, <0.605107, 0.103906, 1.209539>, <0.500000, 0.040827, 1.411635>, 
      <0.509391, -0.067639, 0.216104>, <0.509391, -0.051423, 0.451914>, <0.605107, -0.154126, 1.298387>, <0.500000, -0.217204, 1.500482>, 
      <0.447686, -0.302060, -0.393501>, <0.447686, -0.326485, 0.174972>, <0.272015, -0.484012, 1.007810>, <0.272899, -0.431932, 1.574419>, 
      <-0.002400, -0.387344, -0.321714>, <-0.002400, -0.411769, 0.246759>, <-0.000884, -0.484012, 1.007810>, <0.000000, -0.431932, 1.574419>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.012480, 0.191928, 0.827726>, <0.196164, 0.231463, 0.794448>, <0.504077, 0.237764, 0.822110>, <0.505760, 0.141032, 0.630166>, 
      <-0.012480, 0.140340, 0.335139>, <0.196164, 0.179875, 0.301861>, <0.504077, 0.207469, 0.381546>, <0.505760, 0.110737, 0.189602>, 
      <-0.002440, 0.319348, -0.325052>, <0.239305, 0.257863, -0.325052>, <0.501088, 0.164279, -0.379070>, <0.501088, -0.085163, -0.379070>, 
      <0.000000, 0.296938, -0.819819>, <0.241745, 0.235453, -0.819819>, <0.500000, 0.136823, -0.819819>, <0.500000, -0.112618, -0.819819>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.012480, 0.191928, 0.827726>, <-0.012480, 0.208491, 0.985880>, <-0.008523, 0.500615, 1.090591>, <0.000000, 0.513586, 1.248851>, 
      <0.196164, 0.231463, 0.794448>, <0.196164, 0.248026, 0.952602>, <0.264376, 0.500615, 1.090591>, <0.272899, 0.513586, 1.248851>, 
      <0.504077, 0.237764, 0.822110>, <0.504077, 0.253980, 1.057920>, <0.605107, 0.361937, 1.120692>, <0.500000, 0.298858, 1.322788>, 
      <0.505760, 0.141032, 0.630166>, <0.505760, 0.157247, 0.865976>, <0.605107, 0.103906, 1.209539>, <0.500000, 0.040827, 1.411635>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.507680, -0.050998, 0.791806>, <-0.509351, 0.045004, 0.982301>, <-0.219549, 0.152692, 0.860753>, <-0.012480, 0.191928, 0.827726>, 
      <-0.507680, -0.029004, 0.305365>, <-0.509351, 0.066998, 0.495861>, <-0.219549, 0.101104, 0.368166>, <-0.012480, 0.140340, 0.335139>, 
      <-0.501499, 0.132606, -0.332969>, <-0.501499, 0.334659, -0.332969>, <-0.198259, 0.369153, -0.325052>, <-0.002440, 0.319348, -0.325052>, 
      <-0.500000, 0.141722, -0.819819>, <-0.500000, 0.343775, -0.819819>, <-0.195819, 0.346743, -0.819819>, <0.000000, 0.296938, -0.819819>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.507680, -0.050998, 0.791806>, <-0.507680, -0.059489, 0.979606>, <-0.614206, 0.026453, 1.263003>, <-0.500000, 0.040827, 1.411635>, 
      <-0.509351, 0.045004, 0.982301>, <-0.509351, 0.036513, 1.170101>, <-0.614206, 0.284484, 1.174156>, <-0.500000, 0.298858, 1.322788>, 
      <-0.219549, 0.152692, 0.860753>, <-0.219549, 0.169255, 1.018906>, <-0.281423, 0.500615, 1.090591>, <-0.272899, 0.513586, 1.248851>, 
      <-0.012480, 0.191928, 0.827726>, <-0.012480, 0.208491, 0.985880>, <-0.008523, 0.500615, 1.090591>, <0.000000, 0.513586, 1.248851>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.507680, -0.050998, 0.791806>, <-0.507680, -0.029004, 0.305365>, <-0.501499, 0.132606, -0.332969>, <-0.500000, 0.141722, -0.819819>, 
      <-0.503847, -0.271264, 0.354735>, <-0.503847, -0.249270, -0.131705>, <-0.501499, -0.132441, -0.332969>, <-0.500000, -0.123325, -0.819819>, 
      <-0.477496, -0.477367, -0.245938>, <-0.477496, -0.470909, -0.396252>, <-0.257124, -0.295818, -0.672828>, <-0.256869, -0.263731, -0.819819>, 
      <-0.002400, -0.387344, -0.321714>, <-0.002400, -0.380886, -0.472028>, <-0.000255, -0.361150, -0.672828>, <0.000000, -0.329063, -0.819819>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.507680, -0.050998, 0.791806>, <-0.503847, -0.271264, 0.354735>, <-0.477496, -0.477367, -0.245938>, <-0.002400, -0.387344, -0.321714>, 
      <-0.507680, -0.059489, 0.979606>, <-0.503847, -0.279756, 0.542536>, <-0.477496, -0.501791, 0.322535>, <-0.002400, -0.411769, 0.246759>, 
      <-0.614206, 0.026453, 1.263003>, <-0.614206, -0.231579, 1.351851>, <-0.273783, -0.484012, 1.007810>, <-0.000884, -0.484012, 1.007810>, 
      <-0.500000, 0.040827, 1.411635>, <-0.500000, -0.217204, 1.500482>, <-0.272899, -0.431932, 1.574419>, <0.000000, -0.431932, 1.574419>
    }
  }
  material {
    tubodientes_txt
  }
}
#declare tapon_dientes = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.158772, 0.204905, 1.876204>, <0.158772, 0.122969, 1.904417>, <0.086657, 0.054784, 1.927895>, <0.000000, 0.054784, 1.927895>, 
      <0.166298, 0.180931, 1.811525>, <0.166298, 0.098995, 1.839738>, <0.086657, 0.023694, 1.865666>, <0.000000, 0.023694, 1.865666>, 
      <0.144351, 0.143990, 1.714395>, <0.144351, 0.049107, 1.747066>, <0.100349, 0.007437, 1.761343>, <0.000000, 0.007437, 1.761343>, 
      <0.183858, 0.124993, 1.660608>, <0.183858, 0.030111, 1.693279>, <0.100349, -0.048848, 1.720466>, <0.000000, -0.048848, 1.720466>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 0.355027, 1.824513>, <0.086658, 0.355027, 1.824513>, <0.158772, 0.286841, 1.847991>, <0.158772, 0.204905, 1.876204>, 
      <0.000000, 0.338169, 1.757384>, <0.086658, 0.338169, 1.757384>, <0.166298, 0.262868, 1.783312>, <0.166298, 0.180931, 1.811525>, 
      <0.000000, 0.280454, 1.667478>, <0.100349, 0.280454, 1.667478>, <0.144351, 0.238872, 1.681724>, <0.144351, 0.143990, 1.714395>, 
      <0.000000, 0.298834, 1.600749>, <0.100349, 0.298834, 1.600749>, <0.183858, 0.219875, 1.627937>, <0.183858, 0.124993, 1.660608>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.158771, 0.204905, 1.876204>, <-0.158771, 0.286841, 1.847991>, <-0.086657, 0.355027, 1.824513>, <0.000000, 0.355027, 1.824513>, 
      <-0.166297, 0.180931, 1.811525>, <-0.166297, 0.262867, 1.783312>, <-0.086657, 0.338169, 1.757384>, <0.000000, 0.338169, 1.757384>, 
      <-0.144351, 0.143990, 1.714395>, <-0.144351, 0.238872, 1.681724>, <-0.100349, 0.280454, 1.667478>, <0.000000, 0.280454, 1.667478>, 
      <-0.183858, 0.124993, 1.660608>, <-0.183858, 0.219875, 1.627937>, <-0.100349, 0.298834, 1.600749>, <0.000000, 0.298834, 1.600749>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.158771, 0.204905, 1.876204>, <-0.166297, 0.180931, 1.811525>, <-0.144351, 0.143990, 1.714395>, <-0.183858, 0.124993, 1.660608>, 
      <-0.158771, 0.122969, 1.904417>, <-0.166297, 0.098996, 1.839738>, <-0.144351, 0.049107, 1.747066>, <-0.183858, 0.030111, 1.693279>, 
      <-0.086657, 0.054784, 1.927895>, <-0.086657, 0.023694, 1.865666>, <-0.100349, 0.007437, 1.761343>, <-0.100349, -0.048848, 1.720466>, 
      <0.000000, 0.054784, 1.927895>, <0.000000, 0.023694, 1.865666>, <0.000000, 0.007437, 1.761343>, <0.000000, -0.048848, 1.720466>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.500000, 0.040827, 1.411635>, <0.405157, 0.066077, 1.486327>, <0.254080, 0.091227, 1.565003>, <0.183858, 0.124993, 1.660608>, 
      <0.500000, -0.217204, 1.500482>, <0.405157, -0.191955, 1.575174>, <0.254080, -0.003655, 1.597674>, <0.183858, 0.030111, 1.693279>, 
      <0.272899, -0.431932, 1.574419>, <0.272899, -0.317007, 1.618233>, <0.100349, -0.148366, 1.648191>, <0.100349, -0.048848, 1.720466>, 
      <0.000000, -0.431932, 1.574419>, <0.000000, -0.317007, 1.618233>, <0.000000, -0.148366, 1.648191>, <0.000000, -0.048848, 1.720466>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 0.513586, 1.248851>, <0.000000, 0.449160, 1.354420>, <0.000000, 0.331676, 1.481514>, <0.000000, 0.298834, 1.600749>, 
      <0.272899, 0.513586, 1.248851>, <0.272899, 0.449160, 1.354420>, <0.100349, 0.331676, 1.481514>, <0.100349, 0.298834, 1.600749>, 
      <0.500000, 0.298858, 1.322788>, <0.405157, 0.324108, 1.397480>, <0.254080, 0.186109, 1.532333>, <0.183858, 0.219875, 1.627937>, 
      <0.500000, 0.040827, 1.411635>, <0.405157, 0.066077, 1.486327>, <0.254080, 0.091227, 1.565003>, <0.183858, 0.124993, 1.660608>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.500000, 0.040827, 1.411635>, <-0.405157, 0.066077, 1.486327>, <-0.254080, 0.091227, 1.565003>, <-0.183858, 0.124993, 1.660608>, 
      <-0.500000, 0.298858, 1.322788>, <-0.405157, 0.324108, 1.397480>, <-0.254080, 0.186109, 1.532333>, <-0.183858, 0.219875, 1.627937>, 
      <-0.272899, 0.513586, 1.248851>, <-0.272899, 0.449160, 1.354420>, <-0.100349, 0.331676, 1.481514>, <-0.100349, 0.298834, 1.600749>, 
      <0.000000, 0.513586, 1.248851>, <0.000000, 0.449160, 1.354420>, <0.000000, 0.331676, 1.481514>, <0.000000, 0.298834, 1.600749>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.500000, 0.040827, 1.411635>, <-0.500000, -0.217204, 1.500482>, <-0.272899, -0.431932, 1.574419>, <0.000000, -0.431932, 1.574419>, 
      <-0.405157, 0.066077, 1.486327>, <-0.405157, -0.191955, 1.575174>, <-0.272899, -0.317007, 1.618233>, <0.000000, -0.317007, 1.618233>, 
      <-0.254080, 0.091227, 1.565003>, <-0.254080, -0.003655, 1.597674>, <-0.100349, -0.148366, 1.648191>, <0.000000, -0.148366, 1.648191>, 
      <-0.183858, 0.124993, 1.660608>, <-0.183858, 0.030111, 1.693279>, <-0.100349, -0.048848, 1.720466>, <0.000000, -0.048848, 1.720466>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.079096, 0.298201, 1.723167>, <-0.037997, 0.320202, 1.714278>, <0.037997, 0.320202, 1.714278>, <0.079096, 0.298201, 1.723167>, 
      <-0.073503, 0.288995, 1.726239>, <-0.032404, 0.310995, 1.717350>, <0.032404, 0.310996, 1.717350>, <0.073503, 0.288995, 1.726239>, 
      <-0.068426, 0.286718, 1.744081>, <-0.035247, 0.304479, 1.736906>, <0.035247, 0.304479, 1.736906>, <0.068426, 0.286718, 1.744081>, 
      <-0.063853, 0.281797, 1.753045>, <-0.030674, 0.299558, 1.745869>, <0.030674, 0.299558, 1.745869>, <0.063853, 0.281797, 1.753045>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.158192, 0.171179, 1.774487>, <-0.158192, 0.215181, 1.756709>, <-0.120195, 0.276200, 1.732056>, <-0.079096, 0.298201, 1.723167>, 
      <-0.147007, 0.170954, 1.773930>, <-0.147007, 0.214956, 1.756153>, <-0.114603, 0.266994, 1.735128>, <-0.073503, 0.288995, 1.726239>, 
      <-0.136851, 0.176832, 1.788479>, <-0.136851, 0.212353, 1.774127>, <-0.101605, 0.268957, 1.751257>, <-0.068426, 0.286718, 1.744081>, 
      <-0.127705, 0.179254, 1.794475>, <-0.127705, 0.214776, 1.780123>, <-0.097032, 0.264036, 1.760221>, <-0.063853, 0.281797, 1.753045>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.079096, 0.044156, 1.825807>, <-0.120196, 0.066157, 1.816918>, <-0.158192, 0.127177, 1.792265>, <-0.158192, 0.171179, 1.774487>, 
      <-0.073503, 0.052913, 1.821622>, <-0.114603, 0.074914, 1.812733>, <-0.147007, 0.126952, 1.791708>, <-0.147007, 0.170954, 1.773930>, 
      <-0.068426, 0.066945, 1.832876>, <-0.101605, 0.084705, 1.825700>, <-0.136851, 0.141310, 1.802830>, <-0.136851, 0.176832, 1.788479>, 
      <-0.063853, 0.076711, 1.835905>, <-0.097032, 0.094472, 1.828729>, <-0.127705, 0.143732, 1.808827>, <-0.127705, 0.179254, 1.794475>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.079096, 0.044156, 1.825807>, <0.037997, 0.022155, 1.834696>, <-0.037997, 0.022155, 1.834696>, <-0.079096, 0.044156, 1.825807>, 
      <0.073503, 0.052913, 1.821622>, <0.032404, 0.030911, 1.830510>, <-0.032404, 0.030912, 1.830510>, <-0.073503, 0.052913, 1.821622>, 
      <0.068426, 0.066945, 1.832876>, <0.035247, 0.049183, 1.840052>, <-0.035247, 0.049183, 1.840052>, <-0.068426, 0.066945, 1.832876>, 
      <0.063853, 0.076711, 1.835905>, <0.030674, 0.058950, 1.843081>, <-0.030674, 0.058950, 1.843081>, <-0.063853, 0.076711, 1.835905>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.131822, 0.393685, 1.715710>, <-0.052729, 0.393685, 1.715710>, <0.052729, 0.393685, 1.715710>, <0.131822, 0.393685, 1.715710>, 
      <-0.116004, 0.365040, 1.717947>, <-0.036911, 0.365040, 1.717947>, <0.036911, 0.365040, 1.717947>, <0.116004, 0.365040, 1.717947>, 
      <-0.095472, 0.325158, 1.714172>, <-0.054372, 0.347159, 1.705283>, <0.054372, 0.347159, 1.705283>, <0.095472, 0.325158, 1.714172>, 
      <-0.079096, 0.298201, 1.723167>, <-0.037997, 0.320202, 1.714278>, <0.037997, 0.320202, 1.714278>, <0.079096, 0.298201, 1.723167>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.263644, 0.181988, 1.801241>, <-0.224097, 0.245497, 1.775582>, <-0.171369, 0.330176, 1.741369>, <-0.131822, 0.393685, 1.715710>, 
      <-0.232008, 0.178745, 1.793215>, <-0.192462, 0.242254, 1.767555>, <-0.155551, 0.301531, 1.743606>, <-0.116004, 0.365040, 1.717947>, 
      <-0.190943, 0.171838, 1.776117>, <-0.190943, 0.215839, 1.758339>, <-0.136571, 0.303157, 1.723061>, <-0.095472, 0.325158, 1.714172>, 
      <-0.158192, 0.171179, 1.774487>, <-0.158192, 0.215181, 1.756709>, <-0.120195, 0.276200, 1.732056>, <-0.079096, 0.298201, 1.723167>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.131822, -0.029709, 1.886772>, <-0.171369, 0.033800, 1.861113>, <-0.224097, 0.118479, 1.826900>, <-0.263644, 0.181988, 1.801241>, 
      <-0.116004, -0.007549, 1.868482>, <-0.155551, 0.055960, 1.842823>, <-0.192462, 0.115236, 1.818874>, <-0.232008, 0.178745, 1.793215>, 
      <-0.095472, 0.018516, 1.838062>, <-0.136571, 0.040517, 1.829173>, <-0.190943, 0.127836, 1.793895>, <-0.190943, 0.171838, 1.776117>, 
      <-0.079096, 0.044156, 1.825807>, <-0.120196, 0.066157, 1.816918>, <-0.158192, 0.127177, 1.792265>, <-0.158192, 0.171179, 1.774487>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.131822, -0.029709, 1.886772>, <0.052729, -0.029709, 1.886772>, <-0.052729, -0.029709, 1.886772>, <-0.131822, -0.029709, 1.886772>, 
      <0.116004, -0.007549, 1.868482>, <0.036911, -0.007549, 1.868482>, <-0.036911, -0.007549, 1.868482>, <-0.116004, -0.007549, 1.868482>, 
      <0.095472, 0.018516, 1.838062>, <0.054372, -0.003485, 1.846951>, <-0.054372, -0.003485, 1.846951>, <-0.095472, 0.018516, 1.838062>, 
      <0.079096, 0.044156, 1.825807>, <0.037997, 0.022155, 1.834696>, <-0.037997, 0.022155, 1.834696>, <-0.079096, 0.044156, 1.825807>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.131822, 0.481832, 1.933883>, <-0.052729, 0.481832, 1.933883>, <0.052729, 0.481832, 1.933883>, <0.131822, 0.481832, 1.933883>, 
      <-0.131822, 0.455388, 1.868431>, <-0.052729, 0.455388, 1.868431>, <0.052729, 0.455388, 1.868431>, <0.131822, 0.455388, 1.868431>, 
      <-0.131822, 0.420129, 1.781162>, <-0.052729, 0.420129, 1.781162>, <0.052729, 0.420129, 1.781162>, <0.131822, 0.420129, 1.781162>, 
      <-0.131822, 0.393685, 1.715710>, <-0.052729, 0.393685, 1.715710>, <0.052729, 0.393685, 1.715710>, <0.131822, 0.393685, 1.715710>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.263644, 0.270135, 2.019414>, <-0.224097, 0.333644, 1.993755>, <-0.171369, 0.418323, 1.959542>, <-0.131822, 0.481832, 1.933883>, 
      <-0.263644, 0.243691, 1.953962>, <-0.224097, 0.307200, 1.928303>, <-0.171369, 0.391879, 1.894090>, <-0.131822, 0.455388, 1.868431>, 
      <-0.263644, 0.208432, 1.866693>, <-0.224097, 0.271941, 1.841034>, <-0.171369, 0.356620, 1.806821>, <-0.131822, 0.420129, 1.781162>, 
      <-0.263644, 0.181988, 1.801241>, <-0.224097, 0.245497, 1.775582>, <-0.171369, 0.330176, 1.741369>, <-0.131822, 0.393685, 1.715710>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.131822, 0.058439, 2.104945>, <-0.171369, 0.121948, 2.079286>, <-0.224097, 0.206626, 2.045073>, <-0.263644, 0.270135, 2.019414>, 
      <-0.131822, 0.031995, 2.039493>, <-0.171369, 0.095503, 2.013834>, <-0.224097, 0.180182, 1.979621>, <-0.263644, 0.243691, 1.953962>, 
      <-0.131822, -0.003265, 1.952224>, <-0.171369, 0.060244, 1.926565>, <-0.224097, 0.144923, 1.892352>, <-0.263644, 0.208432, 1.866693>, 
      <-0.131822, -0.029709, 1.886772>, <-0.171369, 0.033800, 1.861113>, <-0.224097, 0.118479, 1.826900>, <-0.263644, 0.181988, 1.801241>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.131822, 0.058439, 2.104945>, <0.052729, 0.058439, 2.104945>, <-0.052729, 0.058439, 2.104945>, <-0.131822, 0.058439, 2.104945>, 
      <0.131822, 0.031995, 2.039493>, <0.052729, 0.031995, 2.039493>, <-0.052729, 0.031995, 2.039493>, <-0.131822, 0.031995, 2.039493>, 
      <0.131822, -0.003265, 1.952224>, <0.052729, -0.003265, 1.952224>, <-0.052729, -0.003265, 1.952224>, <-0.131822, -0.003265, 1.952224>, 
      <0.131822, -0.029709, 1.886772>, <0.052729, -0.029709, 1.886772>, <-0.052729, -0.029709, 1.886772>, <-0.131822, -0.029709, 1.886772>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.094554, 0.432792, 1.984817>, <-0.045422, 0.459093, 1.974191>, <0.045422, 0.459093, 1.974191>, <0.094554, 0.432792, 1.984817>, 
      <-0.106287, 0.449791, 1.972640>, <-0.057156, 0.476092, 1.962013>, <0.057156, 0.476092, 1.962013>, <0.106287, 0.449791, 1.972640>, 
      <-0.120642, 0.467120, 1.949163>, <-0.041548, 0.467120, 1.949163>, <0.041548, 0.467120, 1.949163>, <0.120642, 0.467120, 1.949163>, 
      <-0.131822, 0.481832, 1.933883>, <-0.052729, 0.481832, 1.933883>, <0.052729, 0.481832, 1.933883>, <0.131822, 0.481832, 1.933883>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.189108, 0.280945, 2.046168>, <-0.189108, 0.333546, 2.024916>, <-0.143686, 0.406491, 1.995443>, <-0.094554, 0.432792, 1.984817>, 
      <-0.212575, 0.279101, 2.041604>, <-0.212575, 0.331702, 2.020351>, <-0.155419, 0.423490, 1.983266>, <-0.106287, 0.449791, 1.972640>, 
      <-0.241283, 0.273378, 2.027440>, <-0.201737, 0.336887, 2.001781>, <-0.160188, 0.403611, 1.974823>, <-0.120642, 0.467120, 1.949163>, 
      <-0.263644, 0.270135, 2.019414>, <-0.224097, 0.333644, 1.993755>, <-0.171369, 0.418323, 1.959542>, <-0.131822, 0.481832, 1.933883>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.094554, 0.129097, 2.107518>, <-0.143686, 0.155398, 2.096892>, <-0.189108, 0.228344, 2.067420>, <-0.189108, 0.280945, 2.046168>, 
      <-0.106287, 0.108410, 2.110567>, <-0.155419, 0.134711, 2.099941>, <-0.212575, 0.226499, 2.062856>, <-0.212575, 0.279101, 2.041604>, 
      <-0.120642, 0.079636, 2.105717>, <-0.160188, 0.143145, 2.080058>, <-0.201737, 0.209869, 2.053099>, <-0.241283, 0.273378, 2.027440>, 
      <-0.131822, 0.058439, 2.104945>, <-0.171369, 0.121948, 2.079286>, <-0.224097, 0.206626, 2.045073>, <-0.263644, 0.270135, 2.019414>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.094554, 0.129097, 2.107518>, <0.045422, 0.102796, 2.118144>, <-0.045422, 0.102796, 2.118144>, <-0.094554, 0.129097, 2.107518>, 
      <0.106287, 0.108410, 2.110567>, <0.057156, 0.082109, 2.121193>, <-0.057156, 0.082109, 2.121193>, <-0.106287, 0.108410, 2.110567>, 
      <0.120642, 0.079636, 2.105717>, <0.041548, 0.079636, 2.105717>, <-0.041548, 0.079636, 2.105717>, <-0.120642, 0.079636, 2.105717>, 
      <0.131822, 0.058439, 2.104945>, <0.052729, 0.058439, 2.104945>, <-0.052729, 0.058439, 2.104945>, <-0.131822, 0.058439, 2.104945>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 0.290853, 2.070693>, <0.000000, 0.290853, 2.070693>, <0.000000, 0.290853, 2.070693>, <0.000000, 0.290853, 2.070693>, 
      <-0.028366, 0.333435, 2.044930>, <-0.028366, 0.333435, 2.044930>, <0.028366, 0.333435, 2.044930>, <0.028366, 0.333435, 2.044930>, 
      <-0.066522, 0.392180, 2.013910>, <-0.017390, 0.418480, 2.003284>, <0.017390, 0.418480, 2.003284>, <0.066522, 0.392180, 2.013910>, 
      <-0.094554, 0.432792, 1.984817>, <-0.045422, 0.459093, 1.974191>, <0.045422, 0.459093, 1.974191>, <0.094554, 0.432792, 1.984817>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 0.290853, 2.070693>, <0.000000, 0.290853, 2.070693>, <0.000000, 0.290853, 2.070693>, <0.000000, 0.290853, 2.070693>, 
      <-0.056732, 0.287881, 2.063335>, <-0.056732, 0.287881, 2.063335>, <-0.028366, 0.333435, 2.044930>, <-0.028366, 0.333435, 2.044930>, 
      <-0.133044, 0.285351, 2.057073>, <-0.133044, 0.337952, 2.035820>, <-0.115653, 0.365879, 2.024536>, <-0.066522, 0.392180, 2.013910>, 
      <-0.189108, 0.280945, 2.046168>, <-0.189108, 0.333546, 2.024916>, <-0.143686, 0.406491, 1.995443>, <-0.094554, 0.432792, 1.984817>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 0.290853, 2.070693>, <0.000000, 0.290853, 2.070693>, <0.000000, 0.290853, 2.070693>, <0.000000, 0.290853, 2.070693>, 
      <-0.028366, 0.242326, 2.081740>, <-0.028366, 0.242326, 2.081740>, <-0.056732, 0.287881, 2.063335>, <-0.056732, 0.287881, 2.063335>, 
      <-0.066522, 0.178520, 2.100234>, <-0.115654, 0.204821, 2.089608>, <-0.133044, 0.232749, 2.078325>, <-0.133044, 0.285351, 2.057073>, 
      <-0.094554, 0.129097, 2.107518>, <-0.143686, 0.155398, 2.096892>, <-0.189108, 0.228344, 2.067420>, <-0.189108, 0.280945, 2.046168>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 0.290853, 2.070693>, <0.000000, 0.290853, 2.070693>, <0.000000, 0.290853, 2.070693>, <0.000000, 0.290853, 2.070693>, 
      <0.028366, 0.242326, 2.081740>, <0.028366, 0.242326, 2.081740>, <-0.028366, 0.242326, 2.081740>, <-0.028366, 0.242326, 2.081740>, 
      <0.066522, 0.178520, 2.100234>, <0.017390, 0.152220, 2.110860>, <-0.017390, 0.152220, 2.110860>, <-0.066522, 0.178520, 2.100234>, 
      <0.094554, 0.129097, 2.107518>, <0.045422, 0.102796, 2.118144>, <-0.045422, 0.102796, 2.118144>, <-0.094554, 0.129097, 2.107518>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.158191, 0.171179, 1.774487>, <0.158191, 0.127177, 1.792265>, <0.120195, 0.066157, 1.816918>, <0.079096, 0.044156, 1.825807>, 
      <0.147006, 0.170954, 1.773930>, <0.147006, 0.126952, 1.791708>, <0.114603, 0.074914, 1.812733>, <0.073503, 0.052913, 1.821622>, 
      <0.136851, 0.176832, 1.788479>, <0.136851, 0.141310, 1.802830>, <0.101605, 0.084705, 1.825700>, <0.068426, 0.066945, 1.832876>, 
      <0.127705, 0.179254, 1.794475>, <0.127705, 0.143732, 1.808827>, <0.097032, 0.094472, 1.828729>, <0.063853, 0.076711, 1.835905>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.158191, 0.171179, 1.774487>, <0.147006, 0.170954, 1.773930>, <0.136851, 0.176832, 1.788479>, <0.127705, 0.179254, 1.794475>, 
      <0.158191, 0.215181, 1.756709>, <0.147006, 0.214956, 1.756153>, <0.136851, 0.212353, 1.774127>, <0.127705, 0.214776, 1.780123>, 
      <0.120195, 0.276200, 1.732056>, <0.114603, 0.266994, 1.735128>, <0.101605, 0.268957, 1.751257>, <0.097032, 0.264036, 1.760221>, 
      <0.079096, 0.298201, 1.723167>, <0.073503, 0.288995, 1.726239>, <0.068426, 0.286718, 1.744081>, <0.063853, 0.281797, 1.753045>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.263644, 0.181988, 1.801241>, <0.224097, 0.118479, 1.826900>, <0.171369, 0.033800, 1.861113>, <0.131822, -0.029709, 1.886772>, 
      <0.232008, 0.178745, 1.793215>, <0.192462, 0.115236, 1.818874>, <0.155551, 0.055960, 1.842823>, <0.116004, -0.007549, 1.868482>, 
      <0.190943, 0.171838, 1.776117>, <0.190943, 0.127836, 1.793895>, <0.136571, 0.040517, 1.829173>, <0.095472, 0.018516, 1.838062>, 
      <0.158191, 0.171179, 1.774487>, <0.158191, 0.127177, 1.792265>, <0.120195, 0.066157, 1.816918>, <0.079096, 0.044156, 1.825807>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.263644, 0.181988, 1.801241>, <0.232008, 0.178745, 1.793215>, <0.190943, 0.171838, 1.776117>, <0.158191, 0.171179, 1.774487>, 
      <0.224097, 0.245497, 1.775582>, <0.192462, 0.242254, 1.767555>, <0.190943, 0.215839, 1.758340>, <0.158191, 0.215181, 1.756709>, 
      <0.171369, 0.330176, 1.741369>, <0.155551, 0.301531, 1.743606>, <0.136571, 0.303157, 1.723061>, <0.120195, 0.276200, 1.732056>, 
      <0.131822, 0.393685, 1.715710>, <0.116004, 0.365040, 1.717947>, <0.095472, 0.325158, 1.714172>, <0.079096, 0.298201, 1.723167>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.263644, 0.270135, 2.019414>, <0.224097, 0.206626, 2.045073>, <0.171369, 0.121948, 2.079286>, <0.131822, 0.058439, 2.104945>, 
      <0.263644, 0.243691, 1.953962>, <0.224097, 0.180182, 1.979621>, <0.171369, 0.095503, 2.013834>, <0.131822, 0.031995, 2.039493>, 
      <0.263644, 0.208432, 1.866693>, <0.224097, 0.144923, 1.892352>, <0.171369, 0.060244, 1.926565>, <0.131822, -0.003265, 1.952224>, 
      <0.263644, 0.181988, 1.801241>, <0.224097, 0.118479, 1.826900>, <0.171369, 0.033800, 1.861113>, <0.131822, -0.029709, 1.886772>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.263644, 0.270135, 2.019414>, <0.263644, 0.243691, 1.953962>, <0.263644, 0.208432, 1.866693>, <0.263644, 0.181988, 1.801241>, 
      <0.224097, 0.333644, 1.993755>, <0.224097, 0.307200, 1.928303>, <0.224097, 0.271941, 1.841034>, <0.224097, 0.245497, 1.775582>, 
      <0.171369, 0.418323, 1.959542>, <0.171369, 0.391879, 1.894090>, <0.171369, 0.356620, 1.806821>, <0.171369, 0.330176, 1.741369>, 
      <0.131822, 0.481832, 1.933883>, <0.131822, 0.455388, 1.868431>, <0.131822, 0.420129, 1.781162>, <0.131822, 0.393685, 1.715710>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.189108, 0.280945, 2.046168>, <0.189108, 0.228344, 2.067420>, <0.143686, 0.155398, 2.096892>, <0.094554, 0.129097, 2.107518>, 
      <0.212575, 0.279101, 2.041604>, <0.212575, 0.226499, 2.062856>, <0.155419, 0.134711, 2.099941>, <0.106287, 0.108410, 2.110567>, 
      <0.241283, 0.273378, 2.027440>, <0.201737, 0.209869, 2.053099>, <0.160188, 0.143145, 2.080058>, <0.120642, 0.079636, 2.105717>, 
      <0.263644, 0.270135, 2.019414>, <0.224097, 0.206626, 2.045073>, <0.171369, 0.121948, 2.079286>, <0.131822, 0.058439, 2.104945>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.189108, 0.280945, 2.046168>, <0.212575, 0.279101, 2.041604>, <0.241283, 0.273378, 2.027440>, <0.263644, 0.270135, 2.019414>, 
      <0.189108, 0.333546, 2.024916>, <0.212575, 0.331702, 2.020351>, <0.201737, 0.336887, 2.001781>, <0.224097, 0.333644, 1.993755>, 
      <0.143686, 0.406491, 1.995443>, <0.155419, 0.423490, 1.983266>, <0.160188, 0.403611, 1.974823>, <0.171369, 0.418323, 1.959542>, 
      <0.094554, 0.432792, 1.984817>, <0.106287, 0.449791, 1.972640>, <0.120642, 0.467120, 1.949163>, <0.131822, 0.481832, 1.933883>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 0.290853, 2.070693>, <0.000000, 0.290853, 2.070693>, <0.000000, 0.290853, 2.070693>, <0.000000, 0.290853, 2.070693>, 
      <0.056732, 0.287881, 2.063335>, <0.056732, 0.287881, 2.063335>, <0.028366, 0.242326, 2.081740>, <0.028366, 0.242326, 2.081740>, 
      <0.133044, 0.285351, 2.057073>, <0.133044, 0.232749, 2.078325>, <0.115654, 0.204821, 2.089608>, <0.066522, 0.178520, 2.100234>, 
      <0.189108, 0.280945, 2.046168>, <0.189108, 0.228344, 2.067420>, <0.143686, 0.155398, 2.096892>, <0.094554, 0.129097, 2.107518>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 0.290853, 2.070693>, <0.056732, 0.287881, 2.063335>, <0.133044, 0.285351, 2.057073>, <0.189108, 0.280945, 2.046168>, 
      <0.000000, 0.290853, 2.070693>, <0.056732, 0.287881, 2.063335>, <0.133044, 0.337952, 2.035820>, <0.189108, 0.333546, 2.024916>, 
      <0.000000, 0.290853, 2.070693>, <0.028366, 0.333435, 2.044930>, <0.115653, 0.365879, 2.024536>, <0.143686, 0.406491, 1.995443>, 
      <0.000000, 0.290853, 2.070693>, <0.028366, 0.333435, 2.044930>, <0.066522, 0.392180, 2.013910>, <0.094554, 0.432792, 1.984817>
    }
  }
}
#declare pasta_dientes = union {
  object { tubo_dientes }
  object { tapon_dientes }
  material {
    dientes_bas_txt
  }
  no_shadow
  scale 2.0
  rotate 121.922691*z
  translate  <1.337984, -4.018715, 6.799241>
}
#declare cdientes = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.420537, -0.878364, 7.189060>, <0.164427, -0.863994, 7.182066>, <-0.178713, -0.863994, 7.182066>, <-0.434823, -0.878364, 7.189060>, 
      <0.473634, -0.878364, 7.985104>, <0.217525, -0.863994, 7.978110>, <-0.231811, -0.863994, 7.978110>, <-0.487920, -0.878364, 7.985104>, 
      <0.481763, -0.878363, 9.052976>, <0.225898, -0.864007, 9.039762>, <-0.240184, -0.864007, 9.039762>, <-0.496049, -0.878363, 9.052976>, 
      <0.420537, -0.878363, 9.848435>, <0.164672, -0.864006, 9.835222>, <-0.178958, -0.864006, 9.835222>, <-0.434823, -0.878363, 9.848435>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.198777, -0.878364, 6.523780>, <0.198777, -0.878364, 6.734160>, <0.406535, -0.878364, 6.979146>, <0.420537, -0.878364, 7.189060>, 
      <0.076130, -0.864071, 6.519479>, <0.076130, -0.864071, 6.729859>, <0.150426, -0.863994, 6.972152>, <0.164427, -0.863994, 7.182066>, 
      <-0.090416, -0.864071, 6.519479>, <-0.090416, -0.864071, 6.729859>, <-0.164712, -0.863994, 6.972152>, <-0.178713, -0.863994, 7.182066>, 
      <-0.213063, -0.878364, 6.523780>, <-0.213063, -0.878364, 6.734160>, <-0.420822, -0.878364, 6.979146>, <-0.434823, -0.878364, 7.189060>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.420537, -0.878364, 5.858500>, <0.421752, -0.878364, 6.068876>, <0.198777, -0.878364, 6.313400>, <0.198777, -0.878364, 6.523780>, 
      <0.164337, -0.863989, 5.856846>, <0.165552, -0.863989, 6.067222>, <0.076130, -0.864071, 6.309099>, <0.076130, -0.864071, 6.519479>, 
      <-0.178623, -0.863989, 5.856846>, <-0.179838, -0.863989, 6.067222>, <-0.090416, -0.864071, 6.309099>, <-0.090416, -0.864071, 6.519479>, 
      <-0.434823, -0.878364, 5.858500>, <-0.436038, -0.878364, 6.068876>, <-0.213063, -0.878364, 6.313400>, <-0.213063, -0.878364, 6.523780>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.420537, -0.878364, 5.858500>, <0.164337, -0.863989, 5.856846>, <-0.178623, -0.863989, 5.856846>, <-0.434823, -0.878364, 5.858500>, 
      <0.411191, -0.878364, 4.240055>, <0.154992, -0.863989, 4.238400>, <-0.169278, -0.863989, 4.238400>, <-0.425477, -0.878364, 4.240055>, 
      <0.265664, -0.878364, 2.084968>, <0.165929, -0.864365, 2.104433>, <-0.180215, -0.864365, 2.104433>, <-0.279950, -0.878364, 2.084968>, 
      <0.163818, -0.878364, 0.469703>, <0.064083, -0.864365, 0.489168>, <-0.078369, -0.864365, 0.489168>, <-0.178104, -0.878364, 0.469703>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.424267, -1.148174, 9.841384>, <0.416950, -1.148174, 9.935495>, <0.289774, -1.148174, 10.031786>, <0.200573, -1.148174, 10.062670>, 
      <0.166268, -1.162594, 9.826226>, <0.158951, -1.162594, 9.920338>, <0.172003, -1.148174, 10.072562>, <0.082803, -1.148174, 10.103446>, 
      <-0.180554, -1.162594, 9.826226>, <-0.173237, -1.162594, 9.920338>, <-0.186289, -1.148174, 10.072562>, <-0.097089, -1.148174, 10.103446>, 
      <-0.438553, -1.148174, 9.841384>, <-0.431237, -1.148174, 9.935495>, <-0.304060, -1.148174, 10.031786>, <-0.214859, -1.148174, 10.062670>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.438553, -1.148175, 7.185330>, <-0.180235, -1.162613, 7.177304>, <0.165949, -1.162613, 7.177304>, <0.424267, -1.148175, 7.185330>, 
      <-0.492121, -1.148175, 7.980343>, <-0.233802, -1.162613, 7.972318>, <0.219516, -1.162613, 7.972318>, <0.477835, -1.148175, 7.980343>, 
      <-0.500314, -1.148174, 9.046965>, <-0.242315, -1.162595, 9.031807>, <0.228029, -1.162595, 9.031807>, <0.486028, -1.148174, 9.046965>, 
      <-0.438553, -1.148174, 9.841384>, <-0.180554, -1.162594, 9.826226>, <0.166268, -1.162594, 9.826226>, <0.424267, -1.148174, 9.841384>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.200573, -1.148175, 6.521474>, <0.200573, -1.148175, 6.731633>, <0.410139, -1.148175, 6.975646>, <0.424267, -1.148175, 7.185330>, 
      <0.076872, -1.162535, 6.516540>, <0.076872, -1.162535, 6.726699>, <0.151820, -1.162613, 6.967620>, <0.165949, -1.162613, 7.177304>, 
      <-0.091158, -1.162535, 6.516540>, <-0.091158, -1.162535, 6.726699>, <-0.166106, -1.162613, 6.967620>, <-0.180235, -1.162613, 7.177304>, 
      <-0.214859, -1.148175, 6.521474>, <-0.214859, -1.148175, 6.731633>, <-0.424425, -1.148175, 6.975646>, <-0.438553, -1.148175, 7.185330>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.438553, -1.148175, 5.857620>, <-0.180117, -1.162620, 5.855722>, <0.165831, -1.162620, 5.855722>, <0.424267, -1.148175, 5.857620>, 
      <-0.439780, -1.148175, 6.067775>, <-0.181344, -1.162620, 6.065878>, <0.167058, -1.162620, 6.065878>, <0.425494, -1.148175, 6.067775>, 
      <-0.214859, -1.148175, 6.311315>, <-0.091158, -1.162535, 6.306381>, <0.076872, -1.162535, 6.306381>, <0.200573, -1.148175, 6.311315>, 
      <-0.214859, -1.148175, 6.521474>, <-0.091158, -1.162535, 6.516540>, <0.076872, -1.162535, 6.516540>, <0.200573, -1.148175, 6.521474>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.438553, -1.148175, 5.857620>, <-0.429126, -1.148175, 4.242598>, <-0.282327, -1.148175, 2.092133>, <-0.179595, -1.148175, 0.480354>, 
      <-0.180117, -1.162620, 5.855722>, <-0.170690, -1.162620, 4.240700>, <-0.182243, -1.162169, 2.114352>, <-0.079511, -1.162169, 0.502573>, 
      <0.165831, -1.162620, 5.855722>, <0.156404, -1.162620, 4.240700>, <0.167957, -1.162169, 2.114352>, <0.065225, -1.162169, 0.502573>, 
      <0.424267, -1.148175, 5.857620>, <0.414840, -1.148175, 4.242598>, <0.268041, -1.148175, 2.092133>, <0.165309, -1.148175, 0.480354>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.541205, -1.094212, 7.215326>, <-0.525891, -1.126413, 7.210852>, <-0.474416, -1.146171, 7.186444>, <-0.438553, -1.148175, 7.185330>, 
      <-0.607350, -1.094212, 8.017438>, <-0.592036, -1.126413, 8.012962>, <-0.527984, -1.146170, 7.981458>, <-0.492121, -1.148175, 7.980343>, 
      <-0.617505, -1.094211, 9.096897>, <-0.601321, -1.128242, 9.087954>, <-0.538917, -1.146017, 9.049233>, <-0.500314, -1.148174, 9.046965>, 
      <-0.541205, -1.094211, 9.898106>, <-0.525021, -1.128242, 9.889163>, <-0.477156, -1.146016, 9.843652>, <-0.438553, -1.148174, 9.841384>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.264285, -1.094212, 6.540017>, <-0.259248, -1.116211, 6.538128>, <-0.237337, -1.145566, 6.522370>, <-0.214859, -1.148175, 6.521474>, 
      <-0.264285, -1.094212, 6.758982>, <-0.259248, -1.116211, 6.757092>, <-0.237337, -1.145566, 6.732530>, <-0.214859, -1.148175, 6.731633>, 
      <-0.523209, -1.094212, 6.997102>, <-0.507896, -1.126413, 6.992628>, <-0.460288, -1.146171, 6.976760>, <-0.424425, -1.148175, 6.975646>, 
      <-0.541205, -1.094212, 7.215326>, <-0.525891, -1.126413, 7.210852>, <-0.474416, -1.146171, 7.186444>, <-0.438553, -1.148175, 7.185330>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.541205, -1.094212, 5.864709>, <-0.526241, -1.125676, 5.863676>, <-0.473354, -1.146230, 5.857875>, <-0.438553, -1.148175, 5.857620>, 
      <-0.542760, -1.094212, 6.083668>, <-0.527797, -1.125676, 6.082634>, <-0.474581, -1.146230, 6.068030>, <-0.439780, -1.148175, 6.067775>, 
      <-0.264285, -1.094212, 6.321053>, <-0.259248, -1.116211, 6.319163>, <-0.237337, -1.145566, 6.312212>, <-0.214859, -1.148175, 6.311315>, 
      <-0.264285, -1.094212, 6.540017>, <-0.259248, -1.116211, 6.538128>, <-0.237337, -1.145566, 6.522370>, <-0.214859, -1.148175, 6.521474>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.220629, -1.094212, 0.394673>, <-0.214926, -1.124212, 0.406581>, <-0.211299, -1.143742, 0.473316>, <-0.179595, -1.148175, 0.480354>, 
      <-0.347753, -1.094212, 2.033576>, <-0.342050, -1.124212, 2.045485>, <-0.314031, -1.143742, 2.085094>, <-0.282327, -1.148175, 2.092133>, 
      <-0.529528, -1.094212, 4.220924>, <-0.514564, -1.125676, 4.219890>, <-0.463927, -1.146230, 4.242853>, <-0.429126, -1.148175, 4.242598>, 
      <-0.541205, -1.094212, 5.864709>, <-0.526241, -1.125676, 5.863676>, <-0.473354, -1.146230, 5.857875>, <-0.438553, -1.148175, 5.857620>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.526919, -1.094212, 5.864709>, <0.511955, -1.125676, 5.863676>, <0.459068, -1.146230, 5.857875>, <0.424267, -1.148175, 5.857620>, 
      <0.515242, -1.094212, 4.220924>, <0.500278, -1.125676, 4.219890>, <0.449641, -1.146230, 4.242853>, <0.414840, -1.148175, 4.242598>, 
      <0.333467, -1.094212, 2.033576>, <0.327764, -1.124212, 2.045485>, <0.299745, -1.143742, 2.085094>, <0.268041, -1.148175, 2.092133>, 
      <0.206343, -1.094212, 0.394673>, <0.200640, -1.124212, 0.406581>, <0.197013, -1.143742, 0.473316>, <0.165309, -1.148175, 0.480354>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.249999, -1.094212, 6.540017>, <0.244962, -1.116211, 6.538128>, <0.223051, -1.145566, 6.522370>, <0.200573, -1.148175, 6.521474>, 
      <0.249999, -1.094212, 6.321053>, <0.244962, -1.116211, 6.319163>, <0.223051, -1.145566, 6.312212>, <0.200573, -1.148175, 6.311315>, 
      <0.528474, -1.094212, 6.083668>, <0.513511, -1.125676, 6.082634>, <0.460295, -1.146230, 6.068030>, <0.425494, -1.148175, 6.067775>, 
      <0.526919, -1.094212, 5.864709>, <0.511955, -1.125676, 5.863676>, <0.459068, -1.146230, 5.857875>, <0.424267, -1.148175, 5.857620>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.526919, -1.094212, 7.215326>, <0.511605, -1.126413, 7.210852>, <0.460130, -1.146171, 7.186444>, <0.424267, -1.148175, 7.185330>, 
      <0.508923, -1.094212, 6.997102>, <0.493610, -1.126413, 6.992628>, <0.446002, -1.146171, 6.976760>, <0.410139, -1.148175, 6.975646>, 
      <0.249999, -1.094212, 6.758982>, <0.244962, -1.116211, 6.757092>, <0.223051, -1.145566, 6.732530>, <0.200573, -1.148175, 6.731633>, 
      <0.249999, -1.094212, 6.540017>, <0.244962, -1.116211, 6.538128>, <0.223051, -1.145566, 6.522370>, <0.200573, -1.148175, 6.521474>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.526919, -1.094211, 9.898106>, <0.510735, -1.128242, 9.889163>, <0.462870, -1.146016, 9.843652>, <0.424267, -1.148174, 9.841384>, 
      <0.603219, -1.094211, 9.096897>, <0.587035, -1.128242, 9.087954>, <0.524631, -1.146017, 9.049233>, <0.486028, -1.148174, 9.046965>, 
      <0.593064, -1.094212, 8.017438>, <0.577750, -1.126413, 8.012962>, <0.513698, -1.146170, 7.981458>, <0.477835, -1.148175, 7.980343>, 
      <0.526919, -1.094212, 7.215326>, <0.511605, -1.126413, 7.210852>, <0.460130, -1.146171, 7.186444>, <0.424267, -1.148175, 7.185330>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.249999, -1.094211, 10.123208>, <0.243865, -1.121001, 10.115694>, <0.215401, -1.131985, 10.080831>, <0.200573, -1.148174, 10.062670>, 
      <0.352973, -1.094211, 10.093911>, <0.346839, -1.121001, 10.086397>, <0.304601, -1.131985, 10.049948>, <0.289774, -1.148174, 10.031786>, 
      <0.516769, -1.094211, 10.004685>, <0.500585, -1.128242, 9.995742>, <0.455554, -1.146016, 9.937763>, <0.416950, -1.148174, 9.935495>, 
      <0.526919, -1.094211, 9.898106>, <0.510735, -1.128242, 9.889163>, <0.462870, -1.146016, 9.843652>, <0.424267, -1.148174, 9.841384>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.264285, -1.094211, 10.123208>, <-0.258151, -1.121001, 10.115694>, <-0.229687, -1.131985, 10.080831>, <-0.214859, -1.148174, 10.062670>, 
      <-0.115889, -1.094211, 10.165428>, <-0.109754, -1.121001, 10.157914>, <-0.111917, -1.131985, 10.121608>, <-0.097089, -1.148174, 10.103446>, 
      <0.101603, -1.094211, 10.165428>, <0.095468, -1.121001, 10.157914>, <0.097630, -1.131985, 10.121608>, <0.082803, -1.148174, 10.103446>, 
      <0.249999, -1.094211, 10.123208>, <0.243865, -1.121001, 10.115694>, <0.215401, -1.131985, 10.080831>, <0.200573, -1.148174, 10.062670>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.264285, -1.094211, 10.123208>, <-0.367259, -1.094211, 10.093911>, <-0.531055, -1.094211, 10.004685>, <-0.541205, -1.094211, 9.898106>, 
      <-0.258151, -1.121001, 10.115694>, <-0.361125, -1.121001, 10.086397>, <-0.514871, -1.128242, 9.995742>, <-0.525021, -1.128242, 9.889163>, 
      <-0.229687, -1.131985, 10.080831>, <-0.318887, -1.131985, 10.049948>, <-0.469840, -1.146016, 9.937763>, <-0.477156, -1.146016, 9.843652>, 
      <-0.214859, -1.148174, 10.062670>, <-0.304060, -1.148174, 10.031786>, <-0.431237, -1.148174, 9.935495>, <-0.438553, -1.148174, 9.841384>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.090177, -1.148175, 0.391897>, <-0.125834, -1.148175, 0.404243>, <-0.177195, -1.148175, 0.442697>, <-0.179595, -1.148175, 0.480354>, 
      <-0.096104, -1.131986, 0.365735>, <-0.131761, -1.131986, 0.378081>, <-0.208899, -1.143742, 0.435658>, <-0.211299, -1.143742, 0.473316>, 
      <-0.107284, -1.123158, 0.316386>, <-0.148446, -1.123158, 0.328097>, <-0.211616, -1.124212, 0.363913>, <-0.214926, -1.124212, 0.406581>, 
      <-0.109933, -1.094212, 0.304692>, <-0.151096, -1.094212, 0.316403>, <-0.217319, -1.094212, 0.352005>, <-0.220629, -1.094212, 0.394673>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.075891, -1.148175, 0.391897>, <0.028813, -1.148175, 0.375597>, <-0.043098, -1.148175, 0.375597>, <-0.090177, -1.148175, 0.391897>, 
      <0.081818, -1.131986, 0.365735>, <0.034739, -1.131986, 0.349436>, <-0.049025, -1.131986, 0.349436>, <-0.096104, -1.131986, 0.365735>, 
      <0.092998, -1.123158, 0.316386>, <0.033678, -1.123158, 0.299510>, <-0.047964, -1.123158, 0.299510>, <-0.107284, -1.123158, 0.316386>, 
      <0.095647, -1.094212, 0.304692>, <0.036327, -1.094212, 0.287815>, <-0.050613, -1.094212, 0.287815>, <-0.109933, -1.094212, 0.304692>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.075891, -1.148175, 0.391897>, <0.111548, -1.148175, 0.404243>, <0.162909, -1.148175, 0.442697>, <0.165309, -1.148175, 0.480354>, 
      <0.028813, -1.148175, 0.375597>, <0.064469, -1.148175, 0.387943>, <0.062825, -1.162169, 0.464916>, <0.065225, -1.162169, 0.502573>, 
      <-0.043098, -1.148175, 0.375597>, <-0.078755, -1.148175, 0.387943>, <-0.077111, -1.162169, 0.464916>, <-0.079511, -1.162169, 0.502573>, 
      <-0.090177, -1.148175, 0.391897>, <-0.125834, -1.148175, 0.404243>, <-0.177195, -1.148175, 0.442697>, <-0.179595, -1.148175, 0.480354>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.075891, -1.148175, 0.391897>, <0.081818, -1.131986, 0.365735>, <0.092998, -1.123158, 0.316386>, <0.095647, -1.094212, 0.304692>, 
      <0.111548, -1.148175, 0.404243>, <0.117475, -1.131986, 0.378081>, <0.134160, -1.123158, 0.328097>, <0.136810, -1.094212, 0.316403>, 
      <0.162909, -1.148175, 0.442697>, <0.194613, -1.143742, 0.435658>, <0.197330, -1.124212, 0.363913>, <0.203033, -1.094212, 0.352005>, 
      <0.165309, -1.148175, 0.480354>, <0.197013, -1.143742, 0.473316>, <0.200640, -1.124212, 0.406581>, <0.206343, -1.094212, 0.394673>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.541205, -0.932327, 7.215326>, <-0.525102, -0.899653, 7.211351>, <-0.471395, -0.880416, 7.190059>, <-0.434823, -0.878364, 7.189060>, 
      <-0.607350, -0.932327, 8.017438>, <-0.591247, -0.899653, 8.013462>, <-0.524492, -0.880416, 7.986103>, <-0.487920, -0.878364, 7.985104>, 
      <-0.617505, -0.932327, 9.096897>, <-0.600722, -0.898274, 9.089061>, <-0.534701, -0.880532, 9.054972>, <-0.496049, -0.878363, 9.052976>, 
      <-0.541205, -0.932327, 9.898106>, <-0.524422, -0.898274, 9.890270>, <-0.473475, -0.880532, 9.850431>, <-0.434823, -0.878363, 9.848435>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.541205, -0.932327, 7.215326>, <-0.562548, -0.975632, 7.220597>, <-0.561901, -1.050695, 7.221374>, <-0.541205, -1.094212, 7.215326>, 
      <-0.607350, -0.932327, 8.017438>, <-0.628693, -0.975632, 8.022708>, <-0.628046, -1.050695, 8.023485>, <-0.607350, -1.094212, 8.017438>, 
      <-0.617505, -0.932327, 9.096897>, <-0.638531, -0.974989, 9.106714>, <-0.637799, -1.051538, 9.108110>, <-0.617505, -1.094211, 9.096897>, 
      <-0.541205, -0.932327, 9.898106>, <-0.562231, -0.974989, 9.907922>, <-0.561499, -1.051538, 9.909319>, <-0.541205, -1.094211, 9.898106>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.264285, -0.932327, 6.540017>, <-0.259024, -0.910158, 6.538350>, <-0.235742, -0.881007, 6.524575>, <-0.213063, -0.878364, 6.523780>, 
      <-0.264285, -0.932327, 6.758982>, <-0.259024, -0.910158, 6.757314>, <-0.235742, -0.881007, 6.734955>, <-0.213063, -0.878364, 6.734160>, 
      <-0.523209, -0.932327, 6.997102>, <-0.507106, -0.899653, 6.993127>, <-0.457393, -0.880416, 6.980146>, <-0.420822, -0.878364, 6.979146>, 
      <-0.541205, -0.932327, 7.215326>, <-0.525102, -0.899653, 7.211351>, <-0.471395, -0.880416, 7.190059>, <-0.434823, -0.878364, 7.189060>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.264285, -0.932327, 6.540017>, <-0.275469, -0.979454, 6.543562>, <-0.275087, -1.047037, 6.544070>, <-0.264285, -1.094212, 6.540017>, 
      <-0.264285, -0.932327, 6.758982>, <-0.275469, -0.979454, 6.762527>, <-0.275087, -1.047037, 6.763034>, <-0.264285, -1.094212, 6.758982>, 
      <-0.523209, -0.932327, 6.997102>, <-0.544552, -0.975632, 7.002373>, <-0.543905, -1.050695, 7.003150>, <-0.523209, -1.094212, 6.997102>, 
      <-0.541205, -0.932327, 7.215326>, <-0.562548, -0.975632, 7.220597>, <-0.561901, -1.050695, 7.221374>, <-0.541205, -1.094212, 7.215326>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.541205, -0.932327, 5.864709>, <-0.562668, -0.975875, 5.865962>, <-0.562054, -1.050373, 5.866149>, <-0.541205, -1.094212, 5.864709>, 
      <-0.542760, -0.932327, 6.083668>, <-0.564223, -0.975875, 6.084920>, <-0.563609, -1.050373, 6.085108>, <-0.542760, -1.094212, 6.083668>, 
      <-0.264285, -0.932327, 6.321053>, <-0.275469, -0.979454, 6.324598>, <-0.275087, -1.047037, 6.325106>, <-0.264285, -1.094212, 6.321053>, 
      <-0.264285, -0.932327, 6.540017>, <-0.275469, -0.979454, 6.543562>, <-0.275087, -1.047037, 6.544070>, <-0.264285, -1.094212, 6.540017>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.541205, -0.932327, 5.864709>, <-0.525369, -0.900195, 5.863785>, <-0.470600, -0.880371, 5.858731>, <-0.434823, -0.878364, 5.858500>, 
      <-0.542760, -0.932327, 6.083668>, <-0.526924, -0.900195, 6.082744>, <-0.471815, -0.880371, 6.069107>, <-0.436038, -0.878364, 6.068876>, 
      <-0.264285, -0.932327, 6.321053>, <-0.259024, -0.910158, 6.319386>, <-0.235742, -0.881007, 6.314195>, <-0.213063, -0.878364, 6.313400>, 
      <-0.264285, -0.932327, 6.540017>, <-0.259024, -0.910158, 6.538350>, <-0.235742, -0.881007, 6.524575>, <-0.213063, -0.878364, 6.523780>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.220629, -0.932327, 0.394673>, <-0.229514, -0.977426, 0.378996>, <-0.229079, -1.049761, 0.377028>, <-0.220629, -1.094212, 0.394673>, 
      <-0.347753, -0.932327, 2.033576>, <-0.356638, -0.977426, 2.017900>, <-0.356204, -1.049761, 2.015932>, <-0.347753, -1.094212, 2.033576>, 
      <-0.529528, -0.932327, 4.220924>, <-0.550990, -0.975875, 4.222176>, <-0.550376, -1.050373, 4.222364>, <-0.529528, -1.094212, 4.220924>, 
      <-0.541205, -0.932327, 5.864709>, <-0.562668, -0.975875, 5.865962>, <-0.562054, -1.050373, 5.866149>, <-0.541205, -1.094212, 5.864709>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.220629, -0.932327, 0.394673>, <-0.215045, -0.903985, 0.404525>, <-0.207779, -0.882529, 0.463912>, <-0.178104, -0.878364, 0.469703>, 
      <-0.347753, -0.932327, 2.033576>, <-0.342170, -0.903985, 2.043428>, <-0.309625, -0.882529, 2.079177>, <-0.279950, -0.878364, 2.084968>, 
      <-0.529528, -0.932327, 4.220924>, <-0.513691, -0.900195, 4.220000>, <-0.461255, -0.880371, 4.240285>, <-0.425477, -0.878364, 4.240055>, 
      <-0.541205, -0.932327, 5.864709>, <-0.525369, -0.900195, 5.863785>, <-0.470600, -0.880371, 5.858731>, <-0.434823, -0.878364, 5.858500>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.109933, -0.932327, 0.304692>, <-0.114259, -0.977930, 0.288558>, <-0.114040, -1.049344, 0.286565>, <-0.109933, -1.094212, 0.304692>, 
      <-0.151096, -0.932327, 0.316403>, <-0.155421, -0.977930, 0.300269>, <-0.155202, -1.049344, 0.298276>, <-0.151096, -1.094212, 0.316403>, 
      <-0.217319, -0.932327, 0.352005>, <-0.226205, -0.977426, 0.336328>, <-0.225770, -1.049761, 0.334360>, <-0.217319, -1.094212, 0.352005>, 
      <-0.220629, -0.932327, 0.394673>, <-0.229514, -0.977426, 0.378996>, <-0.229079, -1.049761, 0.377028>, <-0.220629, -1.094212, 0.394673>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.095647, -0.932327, 0.304692>, <0.099973, -0.977930, 0.288558>, <0.099754, -1.049344, 0.286565>, <0.095647, -1.094212, 0.304692>, 
      <0.036327, -0.932327, 0.287815>, <0.040653, -0.977930, 0.271682>, <0.040434, -1.049344, 0.269688>, <0.036327, -1.094212, 0.287815>, 
      <-0.050613, -0.932327, 0.287815>, <-0.054939, -0.977930, 0.271682>, <-0.054720, -1.049344, 0.269688>, <-0.050613, -1.094212, 0.287815>, 
      <-0.109933, -0.932327, 0.304692>, <-0.114259, -0.977930, 0.288558>, <-0.114040, -1.049344, 0.286565>, <-0.109933, -1.094212, 0.304692>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.206343, -0.932327, 0.394673>, <0.215228, -0.977426, 0.378996>, <0.214793, -1.049761, 0.377028>, <0.206343, -1.094212, 0.394673>, 
      <0.203033, -0.932327, 0.352005>, <0.211919, -0.977426, 0.336328>, <0.211484, -1.049761, 0.334360>, <0.203033, -1.094212, 0.352005>, 
      <0.136810, -0.932327, 0.316403>, <0.141136, -0.977930, 0.300269>, <0.140916, -1.049344, 0.298276>, <0.136810, -1.094212, 0.316403>, 
      <0.095647, -0.932327, 0.304692>, <0.099973, -0.977930, 0.288558>, <0.099754, -1.049344, 0.286565>, <0.095647, -1.094212, 0.304692>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.526919, -0.932327, 5.864709>, <0.548382, -0.975875, 5.865962>, <0.547768, -1.050373, 5.866149>, <0.526919, -1.094212, 5.864709>, 
      <0.515242, -0.932327, 4.220924>, <0.536704, -0.975875, 4.222176>, <0.536091, -1.050373, 4.222364>, <0.515242, -1.094212, 4.220924>, 
      <0.333467, -0.932327, 2.033576>, <0.342352, -0.977426, 2.017900>, <0.341918, -1.049761, 2.015932>, <0.333467, -1.094212, 2.033576>, 
      <0.206343, -0.932327, 0.394673>, <0.215228, -0.977426, 0.378996>, <0.214793, -1.049761, 0.377028>, <0.206343, -1.094212, 0.394673>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.526919, -0.932327, 5.864709>, <0.511083, -0.900195, 5.863785>, <0.456314, -0.880371, 5.858731>, <0.420537, -0.878364, 5.858500>, 
      <0.515242, -0.932327, 4.220924>, <0.499405, -0.900195, 4.220000>, <0.446969, -0.880371, 4.240285>, <0.411191, -0.878364, 4.240055>, 
      <0.333467, -0.932327, 2.033576>, <0.327884, -0.903985, 2.043428>, <0.295339, -0.882529, 2.079177>, <0.265664, -0.878364, 2.084968>, 
      <0.206343, -0.932327, 0.394673>, <0.200759, -0.903985, 0.404525>, <0.193493, -0.882529, 0.463912>, <0.163818, -0.878364, 0.469703>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.249999, -0.932327, 6.540017>, <0.249999, -0.932327, 6.321053>, <0.528474, -0.932327, 6.083668>, <0.526919, -0.932327, 5.864709>, 
      <0.244738, -0.910158, 6.538350>, <0.244738, -0.910158, 6.319386>, <0.512638, -0.900195, 6.082744>, <0.511083, -0.900195, 5.863785>, 
      <0.221456, -0.881007, 6.524575>, <0.221456, -0.881007, 6.314195>, <0.457529, -0.880371, 6.069107>, <0.456314, -0.880371, 5.858731>, 
      <0.198777, -0.878364, 6.523780>, <0.198777, -0.878364, 6.313400>, <0.421752, -0.878364, 6.068876>, <0.420537, -0.878364, 5.858500>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.249999, -0.932327, 6.540017>, <0.261183, -0.979454, 6.543562>, <0.260801, -1.047037, 6.544070>, <0.249999, -1.094212, 6.540017>, 
      <0.249999, -0.932327, 6.321053>, <0.261183, -0.979454, 6.324598>, <0.260801, -1.047037, 6.325106>, <0.249999, -1.094212, 6.321053>, 
      <0.528474, -0.932327, 6.083668>, <0.549937, -0.975875, 6.084920>, <0.549323, -1.050373, 6.085108>, <0.528474, -1.094212, 6.083668>, 
      <0.526919, -0.932327, 5.864709>, <0.548382, -0.975875, 5.865962>, <0.547768, -1.050373, 5.866149>, <0.526919, -1.094212, 5.864709>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.526919, -0.932327, 7.215326>, <0.508923, -0.932327, 6.997102>, <0.249999, -0.932327, 6.758982>, <0.249999, -0.932327, 6.540017>, 
      <0.510815, -0.899653, 7.211351>, <0.492820, -0.899653, 6.993127>, <0.244738, -0.910158, 6.757314>, <0.244738, -0.910158, 6.538350>, 
      <0.457109, -0.880416, 7.190059>, <0.443107, -0.880416, 6.980146>, <0.221456, -0.881007, 6.734955>, <0.221456, -0.881007, 6.524575>, 
      <0.420537, -0.878364, 7.189060>, <0.406535, -0.878364, 6.979146>, <0.198777, -0.878364, 6.734160>, <0.198777, -0.878364, 6.523780>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.526919, -0.932327, 7.215326>, <0.548262, -0.975632, 7.220597>, <0.547615, -1.050695, 7.221374>, <0.526919, -1.094212, 7.215326>, 
      <0.508923, -0.932327, 6.997102>, <0.530266, -0.975632, 7.002373>, <0.529619, -1.050695, 7.003150>, <0.508923, -1.094212, 6.997102>, 
      <0.249999, -0.932327, 6.758982>, <0.261183, -0.979454, 6.762527>, <0.260801, -1.047037, 6.763034>, <0.249999, -1.094212, 6.758982>, 
      <0.249999, -0.932327, 6.540017>, <0.261183, -0.979454, 6.543562>, <0.260801, -1.047037, 6.544070>, <0.249999, -1.094212, 6.540017>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.526919, -0.932327, 9.898106>, <0.547945, -0.974989, 9.907922>, <0.547213, -1.051538, 9.909319>, <0.526919, -1.094211, 9.898106>, 
      <0.603219, -0.932327, 9.096897>, <0.624245, -0.974989, 9.106714>, <0.623513, -1.051538, 9.108110>, <0.603219, -1.094211, 9.096897>, 
      <0.593064, -0.932327, 8.017438>, <0.614407, -0.975632, 8.022708>, <0.613760, -1.050695, 8.023485>, <0.593064, -1.094212, 8.017438>, 
      <0.526919, -0.932327, 7.215326>, <0.548262, -0.975632, 7.220597>, <0.547615, -1.050695, 7.221374>, <0.526919, -1.094212, 7.215326>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.526919, -0.932327, 9.898106>, <0.603219, -0.932327, 9.096897>, <0.593064, -0.932327, 8.017438>, <0.526919, -0.932327, 7.215326>, 
      <0.510136, -0.898274, 9.890270>, <0.586436, -0.898274, 9.089061>, <0.576960, -0.899653, 8.013462>, <0.510815, -0.899653, 7.211351>, 
      <0.459189, -0.880532, 9.850431>, <0.520415, -0.880532, 9.054972>, <0.510206, -0.880416, 7.986103>, <0.457109, -0.880416, 7.190059>, 
      <0.420537, -0.878363, 9.848435>, <0.481763, -0.878363, 9.052976>, <0.473634, -0.878364, 7.985104>, <0.420537, -0.878364, 7.189060>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.249999, -0.932327, 10.123208>, <0.260905, -0.978286, 10.134496>, <0.260456, -1.048547, 10.136015>, <0.249999, -1.094211, 10.123208>, 
      <0.352973, -0.932327, 10.093911>, <0.363880, -0.978286, 10.105199>, <0.363430, -1.048547, 10.106718>, <0.352973, -1.094211, 10.093911>, 
      <0.516769, -0.932327, 10.004685>, <0.537796, -0.974989, 10.014502>, <0.537064, -1.051538, 10.015898>, <0.516769, -1.094211, 10.004685>, 
      <0.526919, -0.932327, 9.898106>, <0.547945, -0.974989, 9.907922>, <0.547213, -1.051538, 9.909319>, <0.526919, -1.094211, 9.898106>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.264285, -0.932327, 10.123208>, <-0.275191, -0.978286, 10.134496>, <-0.274742, -1.048547, 10.136015>, <-0.264285, -1.094211, 10.123208>, 
      <-0.115889, -0.932327, 10.165428>, <-0.126795, -0.978286, 10.176716>, <-0.126345, -1.048547, 10.178235>, <-0.115889, -1.094211, 10.165428>, 
      <0.101603, -0.932327, 10.165428>, <0.112509, -0.978286, 10.176716>, <0.112059, -1.048547, 10.178235>, <0.101603, -1.094211, 10.165428>, 
      <0.249999, -0.932327, 10.123208>, <0.260905, -0.978286, 10.134496>, <0.260456, -1.048547, 10.136015>, <0.249999, -1.094211, 10.123208>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.264285, -0.932327, 10.123208>, <-0.367259, -0.932327, 10.093911>, <-0.531055, -0.932327, 10.004685>, <-0.541205, -0.932327, 9.898106>, 
      <-0.275191, -0.978286, 10.134496>, <-0.378166, -0.978286, 10.105199>, <-0.552082, -0.974989, 10.014502>, <-0.562231, -0.974989, 9.907922>, 
      <-0.274742, -1.048547, 10.136015>, <-0.377716, -1.048547, 10.106718>, <-0.551350, -1.051538, 10.015898>, <-0.561499, -1.051538, 9.909319>, 
      <-0.264285, -1.094211, 10.123208>, <-0.367259, -1.094211, 10.093911>, <-0.531055, -1.094211, 10.004685>, <-0.541205, -1.094211, 9.898106>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.089458, -0.878364, 0.381057>, <-0.124956, -0.878364, 0.393481>, <-0.175737, -0.878364, 0.432168>, <-0.178104, -0.878364, 0.469703>, 
      <-0.095601, -0.894553, 0.358148>, <-0.131098, -0.894553, 0.370572>, <-0.205412, -0.882529, 0.426377>, <-0.207779, -0.882529, 0.463912>, 
      <-0.107375, -0.905362, 0.314232>, <-0.148538, -0.905362, 0.325943>, <-0.211736, -0.903985, 0.361857>, <-0.215045, -0.903985, 0.404525>, 
      <-0.109933, -0.932327, 0.304692>, <-0.151096, -0.932327, 0.316403>, <-0.217319, -0.932327, 0.352005>, <-0.220629, -0.932327, 0.394673>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.075172, -0.878364, 0.381057>, <0.028556, -0.878364, 0.364741>, <-0.042842, -0.878364, 0.364741>, <-0.089458, -0.878364, 0.381057>, 
      <0.081314, -0.894553, 0.358148>, <0.034698, -0.894553, 0.341832>, <-0.048984, -0.894553, 0.341832>, <-0.095601, -0.894553, 0.358148>, 
      <0.093089, -0.905362, 0.314232>, <0.033769, -0.905362, 0.297355>, <-0.048055, -0.905362, 0.297355>, <-0.107375, -0.905362, 0.314232>, 
      <0.095647, -0.932327, 0.304692>, <0.036327, -0.932327, 0.287815>, <-0.050613, -0.932327, 0.287815>, <-0.109933, -0.932327, 0.304692>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.075172, -0.878364, 0.381057>, <0.081314, -0.894553, 0.358148>, <0.093089, -0.905362, 0.314232>, <0.095647, -0.932327, 0.304692>, 
      <0.110670, -0.878364, 0.393481>, <0.116812, -0.894553, 0.370572>, <0.134252, -0.905362, 0.325943>, <0.136810, -0.932327, 0.316403>, 
      <0.161451, -0.878364, 0.432168>, <0.191126, -0.882529, 0.426377>, <0.197450, -0.903985, 0.361857>, <0.203033, -0.932327, 0.352005>, 
      <0.163818, -0.878364, 0.469703>, <0.193493, -0.882529, 0.463912>, <0.200759, -0.903985, 0.404525>, <0.206343, -0.932327, 0.394673>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.075172, -0.878364, 0.381057>, <0.110670, -0.878364, 0.393481>, <0.161451, -0.878364, 0.432168>, <0.163818, -0.878364, 0.469703>, 
      <0.028556, -0.878364, 0.364741>, <0.064054, -0.878364, 0.377166>, <0.061716, -0.864365, 0.451633>, <0.064083, -0.864365, 0.489168>, 
      <-0.042842, -0.878364, 0.364741>, <-0.078340, -0.878364, 0.377166>, <-0.076002, -0.864365, 0.451633>, <-0.078369, -0.864365, 0.489168>, 
      <-0.089458, -0.878364, 0.381057>, <-0.124956, -0.878364, 0.393481>, <-0.175737, -0.878364, 0.432168>, <-0.178104, -0.878364, 0.469703>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.198777, -0.878363, 10.070196>, <0.214144, -0.894552, 10.086100>, <0.243844, -0.906391, 10.116838>, <0.249999, -0.932327, 10.123208>, 
      <0.287580, -0.878363, 10.039115>, <0.302946, -0.894552, 10.055018>, <0.346819, -0.906391, 10.087542>, <0.352973, -0.932327, 10.093911>, 
      <0.413317, -0.878363, 9.942242>, <0.451969, -0.880532, 9.944238>, <0.499986, -0.898274, 9.996848>, <0.516769, -0.932327, 10.004685>, 
      <0.420537, -0.878363, 9.848435>, <0.459189, -0.880532, 9.850431>, <0.510136, -0.898274, 9.890270>, <0.526919, -0.932327, 9.898106>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.213063, -0.878363, 10.070196>, <-0.228430, -0.894552, 10.086100>, <-0.258130, -0.906391, 10.116838>, <-0.264285, -0.932327, 10.123208>, 
      <-0.096447, -0.878363, 10.111011>, <-0.111814, -0.894552, 10.126915>, <-0.109734, -0.906391, 10.159058>, <-0.115889, -0.932327, 10.165428>, 
      <0.082161, -0.878363, 10.111011>, <0.097528, -0.894552, 10.126915>, <0.095448, -0.906391, 10.159058>, <0.101603, -0.932327, 10.165428>, 
      <0.198777, -0.878363, 10.070196>, <0.214144, -0.894552, 10.086100>, <0.243844, -0.906391, 10.116838>, <0.249999, -0.932327, 10.123208>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.213063, -0.878363, 10.070196>, <-0.096447, -0.878363, 10.111011>, <0.082161, -0.878363, 10.111011>, <0.198777, -0.878363, 10.070196>, 
      <-0.301866, -0.878363, 10.039115>, <-0.185250, -0.878363, 10.079930>, <0.170964, -0.878363, 10.079930>, <0.287580, -0.878363, 10.039115>, 
      <-0.427603, -0.878363, 9.942242>, <-0.171738, -0.864006, 9.929029>, <0.157452, -0.864006, 9.929029>, <0.413317, -0.878363, 9.942242>, 
      <-0.434823, -0.878363, 9.848435>, <-0.178958, -0.864006, 9.835222>, <0.164672, -0.864006, 9.835222>, <0.420537, -0.878363, 9.848435>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.213063, -0.878363, 10.070196>, <-0.301866, -0.878363, 10.039115>, <-0.427603, -0.878363, 9.942242>, <-0.434823, -0.878363, 9.848435>, 
      <-0.228430, -0.894552, 10.086100>, <-0.317232, -0.894552, 10.055018>, <-0.466255, -0.880532, 9.944238>, <-0.473475, -0.880532, 9.850431>, 
      <-0.258130, -0.906391, 10.116838>, <-0.361105, -0.906391, 10.087542>, <-0.514272, -0.898274, 9.996848>, <-0.524422, -0.898274, 9.890270>, 
      <-0.264285, -0.932327, 10.123208>, <-0.367259, -0.932327, 10.093911>, <-0.531055, -0.932327, 10.004685>, <-0.541205, -0.932327, 9.898106>
    }
  }
  material {
    cepilloddientes_txt
  }
  rotate 90.0*x
  translate  <0.0, 8.701293, 1.0>
}
#declare pelos_dientes = union {
  object { filac }
  object { // filaizq->filac
    filac
    translate  <-0.3, 0.1, 0.0>
  }
  object { // filadcha->filac
    filac
    translate  <0.3, 0.1, 0.0>
  }
  material {
    bordecesto_txt
  }
}
#declare cepillodientes = union {
  object { cdientes }
  object { pelos_dientes }
  no_shadow
  scale 1.5
  rotate <-69.764069, -0.0, -175.431213>
  translate  <-0.548429, -1.144794, 13.322865>
}
#declare vaso = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.380387, 0.866390, 0.024491>, <2.425694, 0.741911, 0.024491>, <2.471668, 0.570332, 0.024491>, <2.494671, 0.439877, 0.024491>, 
      <1.666262, 0.606470, 0.030793>, <1.711569, 0.481991, 0.030793>, <1.723258, 0.438367, 0.030793>, <1.746261, 0.307912, 0.030793>, 
      <0.714116, 0.259917, 0.041590>, <0.714116, 0.259917, 0.041590>, <0.748401, 0.131963, 0.041590>, <0.748401, 0.131963, 0.041590>, 
      <0.000000, 0.000000, 0.048918>, <0.000000, 0.000000, 0.048918>, <0.000000, 0.000000, 0.048918>, <0.000000, 0.000000, 0.048918>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.193777, 1.266577, 0.024491>, <2.260011, 1.151857, 0.024491>, <2.335081, 0.990868, 0.024491>, <2.380387, 0.866390, 0.024491>, 
      <1.535636, 0.886599, 0.030793>, <1.601870, 0.771879, 0.030793>, <1.620956, 0.730948, 0.030793>, <1.666262, 0.606470, 0.030793>, 
      <0.658133, 0.379973, 0.041590>, <0.658133, 0.379973, 0.041590>, <0.714116, 0.259917, 0.041590>, <0.714116, 0.259917, 0.041590>, 
      <0.000000, 0.000000, 0.048918>, <0.000000, 0.000000, 0.048918>, <0.000000, 0.000000, 0.048918>, <0.000000, 0.000000, 0.048918>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.940510, 1.628280, 0.024491>, <2.025658, 1.526804, 0.024491>, <2.127543, 1.381297, 0.024491>, <2.193777, 1.266577, 0.024491>, 
      <1.358350, 1.139790, 0.030793>, <1.443498, 1.038314, 0.030793>, <1.469402, 1.001319, 0.030793>, <1.535636, 0.886599, 0.030793>, 
      <0.582153, 0.488484, 0.041590>, <0.582153, 0.488484, 0.041590>, <0.658133, 0.379973, 0.041590>, <0.658133, 0.379973, 0.041590>, 
      <0.000000, 0.000000, 0.048918>, <0.000000, 0.000000, 0.048918>, <0.000000, 0.000000, 0.048918>, <0.000000, 0.000000, 0.048918>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.628281, 1.940509, 0.024491>, <1.729757, 1.855360, 0.024491>, <1.855361, 1.729756, 0.024491>, <1.940510, 1.628280, 0.024491>, 
      <1.139791, 1.358349, 0.030794>, <1.241267, 1.273201, 0.030794>, <1.273202, 1.241266, 0.030793>, <1.358350, 1.139790, 0.030793>, 
      <0.488484, 0.582153, 0.041590>, <0.488484, 0.582153, 0.041590>, <0.582153, 0.488484, 0.041590>, <0.582153, 0.488484, 0.041590>, 
      <0.000000, 0.000000, 0.048918>, <0.000000, 0.000000, 0.048918>, <0.000000, 0.000000, 0.048918>, <0.000000, 0.000000, 0.048918>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.266578, 2.193777, 0.024491>, <1.381298, 2.127543, 0.024491>, <1.526805, 2.025657, 0.024491>, <1.628281, 1.940509, 0.024491>, 
      <0.886600, 1.535636, 0.030793>, <1.001320, 1.469402, 0.030793>, <1.038315, 1.443498, 0.030794>, <1.139791, 1.358349, 0.030794>, 
      <0.379973, 0.658133, 0.041590>, <0.379973, 0.658133, 0.041590>, <0.488484, 0.582153, 0.041590>, <0.488484, 0.582153, 0.041590>, 
      <0.000000, 0.000000, 0.048918>, <0.000000, 0.000000, 0.048918>, <0.000000, 0.000000, 0.048918>, <0.000000, 0.000000, 0.048918>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.866390, 2.380387, 0.024491>, <0.990869, 2.335081, 0.024491>, <1.151858, 2.260011, 0.024491>, <1.266578, 2.193777, 0.024491>, 
      <0.606470, 1.666262, 0.030793>, <0.730949, 1.620956, 0.030793>, <0.771880, 1.601870, 0.030793>, <0.886600, 1.535636, 0.030793>, 
      <0.259917, 0.714116, 0.041590>, <0.259917, 0.714116, 0.041590>, <0.379973, 0.658133, 0.041590>, <0.379973, 0.658133, 0.041590>, 
      <0.000000, 0.000000, 0.048918>, <0.000000, 0.000000, 0.048918>, <0.000000, 0.000000, 0.048918>, <0.000000, 0.000000, 0.048918>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.439878, 2.494671, 0.024491>, <0.570333, 2.471668, 0.024491>, <0.741911, 2.425694, 0.024491>, <0.866390, 2.380387, 0.024491>, 
      <0.307913, 1.746261, 0.030793>, <0.438368, 1.723258, 0.030793>, <0.481991, 1.711569, 0.030793>, <0.606470, 1.666262, 0.030793>, 
      <0.131963, 0.748401, 0.041590>, <0.131963, 0.748401, 0.041590>, <0.259917, 0.714116, 0.041590>, <0.259917, 0.714116, 0.041590>, 
      <0.000000, 0.000000, 0.048918>, <0.000000, 0.000000, 0.048918>, <0.000000, 0.000000, 0.048918>, <0.000000, 0.000000, 0.048918>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 2.533155, 0.024491>, <0.132467, 2.533155, 0.024491>, <0.309423, 2.517674, 0.024491>, <0.439878, 2.494671, 0.024491>, 
      <0.000000, 1.773199, 0.030793>, <0.132467, 1.773199, 0.030793>, <0.177458, 1.769264, 0.030793>, <0.307913, 1.746261, 0.030793>, 
      <0.000000, 0.759947, 0.041590>, <0.000000, 0.759947, 0.041590>, <0.131963, 0.748401, 0.041590>, <0.131963, 0.748401, 0.041590>, 
      <0.000000, 0.000000, 0.048918>, <0.000000, 0.000000, 0.048918>, <0.000000, 0.000000, 0.048918>, <0.000000, 0.000000, 0.048918>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.439878, 2.494671, 0.024491>, <-0.309423, 2.517674, 0.024491>, <-0.132467, 2.533155, 0.024491>, <0.000000, 2.533155, 0.024491>, 
      <-0.307913, 1.746261, 0.030793>, <-0.177458, 1.769264, 0.030793>, <-0.132467, 1.773199, 0.030793>, <0.000000, 1.773199, 0.030793>, 
      <-0.131963, 0.748401, 0.041590>, <-0.131963, 0.748401, 0.041590>, <0.000000, 0.759947, 0.041590>, <0.000000, 0.759947, 0.041590>, 
      <0.000000, 0.000000, 0.048918>, <0.000000, 0.000000, 0.048918>, <0.000000, 0.000000, 0.048918>, <0.000000, 0.000000, 0.048918>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.866390, 2.380387, 0.024491>, <-0.741911, 2.425694, 0.024491>, <-0.570333, 2.471668, 0.024491>, <-0.439878, 2.494671, 0.024491>, 
      <-0.606470, 1.666262, 0.030793>, <-0.481991, 1.711569, 0.030793>, <-0.438368, 1.723258, 0.030793>, <-0.307913, 1.746261, 0.030793>, 
      <-0.259917, 0.714116, 0.041590>, <-0.259917, 0.714116, 0.041590>, <-0.131963, 0.748401, 0.041590>, <-0.131963, 0.748401, 0.041590>, 
      <0.000000, 0.000000, 0.048918>, <0.000000, 0.000000, 0.048918>, <0.000000, 0.000000, 0.048918>, <0.000000, 0.000000, 0.048918>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.266577, 2.193777, 0.024491>, <-1.151857, 2.260011, 0.024491>, <-0.990868, 2.335081, 0.024491>, <-0.866390, 2.380387, 0.024491>, 
      <-0.886599, 1.535636, 0.030793>, <-0.771879, 1.601870, 0.030793>, <-0.730948, 1.620956, 0.030793>, <-0.606470, 1.666262, 0.030793>, 
      <-0.379973, 0.658133, 0.041590>, <-0.379973, 0.658133, 0.041590>, <-0.259917, 0.714116, 0.041590>, <-0.259917, 0.714116, 0.041590>, 
      <0.000000, 0.000000, 0.048918>, <0.000000, 0.000000, 0.048918>, <0.000000, 0.000000, 0.048918>, <0.000000, 0.000000, 0.048918>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.628281, 1.940510, 0.024491>, <-1.526805, 2.025659, 0.024491>, <-1.381297, 2.127543, 0.024491>, <-1.266577, 2.193777, 0.024491>, 
      <-1.139791, 1.358350, 0.030794>, <-1.038315, 1.443499, 0.030794>, <-1.001320, 1.469402, 0.030793>, <-0.886599, 1.535636, 0.030793>, 
      <-0.488484, 0.582153, 0.041590>, <-0.488484, 0.582153, 0.041590>, <-0.379973, 0.658133, 0.041590>, <-0.379973, 0.658133, 0.041590>, 
      <0.000000, 0.000000, 0.048918>, <0.000000, 0.000000, 0.048918>, <0.000000, 0.000000, 0.048918>, <0.000000, 0.000000, 0.048918>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.940509, 1.628281, 0.024491>, <-1.855361, 1.729757, 0.024491>, <-1.729757, 1.855362, 0.024491>, <-1.628281, 1.940510, 0.024491>, 
      <-1.358349, 1.139791, 0.030793>, <-1.273201, 1.241267, 0.030793>, <-1.241267, 1.273202, 0.030794>, <-1.139791, 1.358350, 0.030794>, 
      <-0.582153, 0.488484, 0.041590>, <-0.582153, 0.488484, 0.041590>, <-0.488484, 0.582153, 0.041590>, <-0.488484, 0.582153, 0.041590>, 
      <0.000000, 0.000000, 0.048918>, <0.000000, 0.000000, 0.048918>, <0.000000, 0.000000, 0.048918>, <0.000000, 0.000000, 0.048918>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.193777, 1.266578, 0.024491>, <-2.127543, 1.381298, 0.024491>, <-2.025657, 1.526805, 0.024491>, <-1.940509, 1.628281, 0.024491>, 
      <-1.535636, 0.886600, 0.030794>, <-1.469402, 1.001320, 0.030794>, <-1.443498, 1.038315, 0.030793>, <-1.358349, 1.139791, 0.030793>, 
      <-0.658133, 0.379973, 0.041590>, <-0.658133, 0.379973, 0.041590>, <-0.582153, 0.488484, 0.041590>, <-0.582153, 0.488484, 0.041590>, 
      <0.000000, 0.000000, 0.048918>, <0.000000, 0.000000, 0.048918>, <0.000000, 0.000000, 0.048918>, <0.000000, 0.000000, 0.048918>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.380387, 0.866390, 0.024491>, <-2.335081, 0.990869, 0.024491>, <-2.260011, 1.151858, 0.024491>, <-2.193777, 1.266578, 0.024491>, 
      <-1.666262, 0.606470, 0.030793>, <-1.620956, 0.730949, 0.030793>, <-1.601870, 0.771880, 0.030794>, <-1.535636, 0.886600, 0.030794>, 
      <-0.714116, 0.259917, 0.041590>, <-0.714116, 0.259917, 0.041590>, <-0.658133, 0.379973, 0.041590>, <-0.658133, 0.379973, 0.041590>, 
      <0.000000, 0.000000, 0.048918>, <0.000000, 0.000000, 0.048918>, <0.000000, 0.000000, 0.048918>, <0.000000, 0.000000, 0.048918>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.494671, 0.439878, 0.024491>, <-2.471668, 0.570333, 0.024491>, <-2.425694, 0.741911, 0.024491>, <-2.380387, 0.866390, 0.024491>, 
      <-1.746261, 0.307913, 0.030793>, <-1.723258, 0.438368, 0.030793>, <-1.711569, 0.481991, 0.030793>, <-1.666262, 0.606470, 0.030793>, 
      <-0.748401, 0.131963, 0.041590>, <-0.748401, 0.131963, 0.041590>, <-0.714116, 0.259917, 0.041590>, <-0.714116, 0.259917, 0.041590>, 
      <0.000000, 0.000000, 0.048918>, <0.000000, 0.000000, 0.048918>, <0.000000, 0.000000, 0.048918>, <0.000000, 0.000000, 0.048918>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.533155, 0.000000, 0.024491>, <-2.533155, 0.132467, 0.024491>, <-2.517674, 0.309423, 0.024491>, <-2.494671, 0.439878, 0.024491>, 
      <-1.773199, 0.000000, 0.030793>, <-1.773199, 0.132467, 0.030793>, <-1.769264, 0.177458, 0.030793>, <-1.746261, 0.307913, 0.030793>, 
      <-0.759947, 0.000000, 0.041590>, <-0.759947, 0.000000, 0.041590>, <-0.748401, 0.131963, 0.041590>, <-0.748401, 0.131963, 0.041590>, 
      <0.000000, 0.000000, 0.048918>, <0.000000, 0.000000, 0.048918>, <0.000000, 0.000000, 0.048918>, <0.000000, 0.000000, 0.048918>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.494671, -0.439878, 0.024491>, <-2.517674, -0.309423, 0.024491>, <-2.533155, -0.132467, 0.024491>, <-2.533155, 0.000000, 0.024491>, 
      <-1.746261, -0.307913, 0.030793>, <-1.769264, -0.177458, 0.030793>, <-1.773199, -0.132467, 0.030793>, <-1.773199, 0.000000, 0.030793>, 
      <-0.748401, -0.131963, 0.041590>, <-0.748401, -0.131963, 0.041590>, <-0.759947, 0.000000, 0.041590>, <-0.759947, 0.000000, 0.041590>, 
      <0.000000, 0.000000, 0.048918>, <0.000000, 0.000000, 0.048918>, <0.000000, 0.000000, 0.048918>, <0.000000, 0.000000, 0.048918>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.380387, -0.866390, 0.024491>, <-2.425694, -0.741911, 0.024491>, <-2.471668, -0.570333, 0.024491>, <-2.494671, -0.439878, 0.024491>, 
      <-1.666262, -0.606470, 0.030793>, <-1.711569, -0.481991, 0.030793>, <-1.723258, -0.438368, 0.030793>, <-1.746261, -0.307913, 0.030793>, 
      <-0.714116, -0.259917, 0.041590>, <-0.714116, -0.259917, 0.041590>, <-0.748401, -0.131963, 0.041590>, <-0.748401, -0.131963, 0.041590>, 
      <0.000000, 0.000000, 0.048918>, <0.000000, 0.000000, 0.048918>, <0.000000, 0.000000, 0.048918>, <0.000000, 0.000000, 0.048918>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.193777, -1.266578, 0.024491>, <-2.260011, -1.151858, 0.024491>, <-2.335081, -0.990869, 0.024491>, <-2.380387, -0.866390, 0.024491>, 
      <-1.535636, -0.886600, 0.030793>, <-1.601870, -0.771880, 0.030793>, <-1.620956, -0.730949, 0.030793>, <-1.666262, -0.606470, 0.030793>, 
      <-0.658133, -0.379973, 0.041590>, <-0.658133, -0.379973, 0.041590>, <-0.714116, -0.259917, 0.041590>, <-0.714116, -0.259917, 0.041590>, 
      <0.000000, 0.000000, 0.048918>, <0.000000, 0.000000, 0.048918>, <0.000000, 0.000000, 0.048918>, <0.000000, 0.000000, 0.048918>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.940510, -1.628281, 0.024491>, <-2.025658, -1.526805, 0.024491>, <-2.127543, -1.381298, 0.024491>, <-2.193777, -1.266578, 0.024491>, 
      <-1.358350, -1.139791, 0.030794>, <-1.443498, -1.038315, 0.030794>, <-1.469402, -1.001320, 0.030793>, <-1.535636, -0.886600, 0.030793>, 
      <-0.582153, -0.488484, 0.041590>, <-0.582153, -0.488484, 0.041590>, <-0.658133, -0.379973, 0.041590>, <-0.658133, -0.379973, 0.041590>, 
      <0.000000, 0.000000, 0.048918>, <0.000000, 0.000000, 0.048918>, <0.000000, 0.000000, 0.048918>, <0.000000, 0.000000, 0.048918>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.628281, -1.940509, 0.024491>, <-1.729757, -1.855361, 0.024491>, <-1.855362, -1.729757, 0.024491>, <-1.940510, -1.628281, 0.024491>, 
      <-1.139791, -1.358349, 0.030793>, <-1.241267, -1.273201, 0.030793>, <-1.273202, -1.241267, 0.030794>, <-1.358350, -1.139791, 0.030794>, 
      <-0.488484, -0.582153, 0.041590>, <-0.488484, -0.582153, 0.041590>, <-0.582153, -0.488484, 0.041590>, <-0.582153, -0.488484, 0.041590>, 
      <0.000000, 0.000000, 0.048918>, <0.000000, 0.000000, 0.048918>, <0.000000, 0.000000, 0.048918>, <0.000000, 0.000000, 0.048918>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.266578, -2.193777, 0.024491>, <-1.381298, -2.127543, 0.024491>, <-1.526805, -2.025657, 0.024491>, <-1.628281, -1.940509, 0.024491>, 
      <-0.886600, -1.535636, 0.030794>, <-1.001320, -1.469402, 0.030794>, <-1.038315, -1.443498, 0.030793>, <-1.139791, -1.358349, 0.030793>, 
      <-0.379973, -0.658133, 0.041590>, <-0.379973, -0.658133, 0.041590>, <-0.488484, -0.582153, 0.041590>, <-0.488484, -0.582153, 0.041590>, 
      <0.000000, 0.000000, 0.048918>, <0.000000, 0.000000, 0.048918>, <0.000000, 0.000000, 0.048918>, <0.000000, 0.000000, 0.048918>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.866390, -2.380387, 0.024491>, <-0.990869, -2.335081, 0.024491>, <-1.151858, -2.260011, 0.024491>, <-1.266578, -2.193777, 0.024491>, 
      <-0.606470, -1.666262, 0.030793>, <-0.730949, -1.620956, 0.030793>, <-0.771880, -1.601870, 0.030794>, <-0.886600, -1.535636, 0.030794>, 
      <-0.259917, -0.714116, 0.041590>, <-0.259917, -0.714116, 0.041590>, <-0.379973, -0.658133, 0.041590>, <-0.379973, -0.658133, 0.041590>, 
      <0.000000, 0.000000, 0.048918>, <0.000000, 0.000000, 0.048918>, <0.000000, 0.000000, 0.048918>, <0.000000, 0.000000, 0.048918>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.439878, -2.494671, 0.024491>, <-0.570333, -2.471668, 0.024491>, <-0.741911, -2.425694, 0.024491>, <-0.866390, -2.380387, 0.024491>, 
      <-0.307913, -1.746261, 0.030793>, <-0.438368, -1.723258, 0.030793>, <-0.481991, -1.711569, 0.030793>, <-0.606470, -1.666262, 0.030793>, 
      <-0.131963, -0.748401, 0.041590>, <-0.131963, -0.748401, 0.041590>, <-0.259917, -0.714116, 0.041590>, <-0.259917, -0.714116, 0.041590>, 
      <0.000000, 0.000000, 0.048918>, <0.000000, 0.000000, 0.048918>, <0.000000, 0.000000, 0.048918>, <0.000000, 0.000000, 0.048918>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -2.533155, 0.024491>, <-0.132467, -2.533155, 0.024491>, <-0.309423, -2.517674, 0.024491>, <-0.439878, -2.494671, 0.024491>, 
      <0.000000, -1.773199, 0.030793>, <-0.132467, -1.773199, 0.030793>, <-0.177458, -1.769264, 0.030793>, <-0.307913, -1.746261, 0.030793>, 
      <0.000000, -0.759947, 0.041590>, <0.000000, -0.759947, 0.041590>, <-0.131963, -0.748401, 0.041590>, <-0.131963, -0.748401, 0.041590>, 
      <0.000000, 0.000000, 0.048918>, <0.000000, 0.000000, 0.048918>, <0.000000, 0.000000, 0.048918>, <0.000000, 0.000000, 0.048918>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.439878, -2.494671, 0.024491>, <0.309423, -2.517674, 0.024491>, <0.132467, -2.533155, 0.024491>, <0.000000, -2.533155, 0.024491>, 
      <0.307913, -1.746261, 0.030793>, <0.177458, -1.769264, 0.030793>, <0.132467, -1.773199, 0.030793>, <0.000000, -1.773199, 0.030793>, 
      <0.131963, -0.748401, 0.041590>, <0.131963, -0.748401, 0.041590>, <0.000000, -0.759947, 0.041590>, <0.000000, -0.759947, 0.041590>, 
      <0.000000, 0.000000, 0.048918>, <0.000000, 0.000000, 0.048918>, <0.000000, 0.000000, 0.048918>, <0.000000, 0.000000, 0.048918>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.866390, -2.380387, 0.024491>, <0.741911, -2.425694, 0.024491>, <0.570333, -2.471668, 0.024491>, <0.439878, -2.494671, 0.024491>, 
      <0.606470, -1.666262, 0.030793>, <0.481991, -1.711569, 0.030793>, <0.438368, -1.723258, 0.030793>, <0.307913, -1.746261, 0.030793>, 
      <0.259917, -0.714116, 0.041590>, <0.259917, -0.714116, 0.041590>, <0.131963, -0.748401, 0.041590>, <0.131963, -0.748401, 0.041590>, 
      <0.000000, 0.000000, 0.048918>, <0.000000, 0.000000, 0.048918>, <0.000000, 0.000000, 0.048918>, <0.000000, 0.000000, 0.048918>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.266578, -2.193777, 0.024491>, <1.151858, -2.260011, 0.024491>, <0.990869, -2.335081, 0.024491>, <0.866390, -2.380387, 0.024491>, 
      <0.886600, -1.535636, 0.030793>, <0.771880, -1.601870, 0.030793>, <0.730949, -1.620956, 0.030793>, <0.606470, -1.666262, 0.030793>, 
      <0.379973, -0.658133, 0.041590>, <0.379973, -0.658133, 0.041590>, <0.259917, -0.714116, 0.041590>, <0.259917, -0.714116, 0.041590>, 
      <0.000000, 0.000000, 0.048918>, <0.000000, 0.000000, 0.048918>, <0.000000, 0.000000, 0.048918>, <0.000000, 0.000000, 0.048918>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.628281, -1.940509, 0.024491>, <1.526805, -2.025657, 0.024491>, <1.381298, -2.127543, 0.024491>, <1.266578, -2.193777, 0.024491>, 
      <1.139791, -1.358349, 0.030793>, <1.038315, -1.443498, 0.030793>, <1.001320, -1.469402, 0.030793>, <0.886600, -1.535636, 0.030793>, 
      <0.488484, -0.582153, 0.041590>, <0.488484, -0.582153, 0.041590>, <0.379973, -0.658133, 0.041590>, <0.379973, -0.658133, 0.041590>, 
      <0.000000, 0.000000, 0.048918>, <0.000000, 0.000000, 0.048918>, <0.000000, 0.000000, 0.048918>, <0.000000, 0.000000, 0.048918>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.940509, -1.628281, 0.024491>, <1.855361, -1.729757, 0.024491>, <1.729757, -1.855361, 0.024491>, <1.628281, -1.940509, 0.024491>, 
      <1.358349, -1.139791, 0.030793>, <1.273201, -1.241267, 0.030793>, <1.241267, -1.273201, 0.030793>, <1.139791, -1.358349, 0.030793>, 
      <0.582153, -0.488484, 0.041590>, <0.582153, -0.488484, 0.041590>, <0.488484, -0.582153, 0.041590>, <0.488484, -0.582153, 0.041590>, 
      <0.000000, 0.000000, 0.048918>, <0.000000, 0.000000, 0.048918>, <0.000000, 0.000000, 0.048918>, <0.000000, 0.000000, 0.048918>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.193777, -1.266578, 0.024491>, <2.127543, -1.381298, 0.024491>, <2.025657, -1.526805, 0.024491>, <1.940509, -1.628281, 0.024491>, 
      <1.535636, -0.886600, 0.030794>, <1.469402, -1.001320, 0.030794>, <1.443498, -1.038315, 0.030793>, <1.358349, -1.139791, 0.030793>, 
      <0.658133, -0.379973, 0.041590>, <0.658133, -0.379973, 0.041590>, <0.582153, -0.488484, 0.041590>, <0.582153, -0.488484, 0.041590>, 
      <0.000000, 0.000000, 0.048918>, <0.000000, 0.000000, 0.048918>, <0.000000, 0.000000, 0.048918>, <0.000000, 0.000000, 0.048918>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.380387, -0.866390, 0.024491>, <2.335081, -0.990869, 0.024491>, <2.260011, -1.151858, 0.024491>, <2.193777, -1.266578, 0.024491>, 
      <1.666262, -0.606470, 0.030793>, <1.620956, -0.730949, 0.030793>, <1.601870, -0.771880, 0.030794>, <1.535636, -0.886600, 0.030794>, 
      <0.714116, -0.259917, 0.041590>, <0.714116, -0.259917, 0.041590>, <0.658133, -0.379973, 0.041590>, <0.658133, -0.379973, 0.041590>, 
      <0.000000, 0.000000, 0.048918>, <0.000000, 0.000000, 0.048918>, <0.000000, 0.000000, 0.048918>, <0.000000, 0.000000, 0.048918>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.494671, -0.439878, 0.024491>, <2.471668, -0.570333, 0.024491>, <2.425694, -0.741911, 0.024491>, <2.380387, -0.866390, 0.024491>, 
      <1.746261, -0.307913, 0.030793>, <1.723258, -0.438368, 0.030793>, <1.711569, -0.481991, 0.030793>, <1.666262, -0.606470, 0.030793>, 
      <0.748401, -0.131963, 0.041590>, <0.748401, -0.131963, 0.041590>, <0.714116, -0.259917, 0.041590>, <0.714116, -0.259917, 0.041590>, 
      <0.000000, 0.000000, 0.048918>, <0.000000, 0.000000, 0.048918>, <0.000000, 0.000000, 0.048918>, <0.000000, 0.000000, 0.048918>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.533155, 0.000000, 0.024491>, <2.533155, -0.132467, 0.024491>, <2.517674, -0.309423, 0.024491>, <2.494671, -0.439878, 0.024491>, 
      <1.773199, 0.000000, 0.030793>, <1.773199, -0.132467, 0.030793>, <1.769264, -0.177458, 0.030793>, <1.746261, -0.307913, 0.030793>, 
      <0.759947, 0.000000, 0.041590>, <0.759947, 0.000000, 0.041590>, <0.748401, -0.131963, 0.041590>, <0.748401, -0.131963, 0.041590>, 
      <0.000000, 0.000000, 0.048918>, <0.000000, 0.000000, 0.048918>, <0.000000, 0.000000, 0.048918>, <0.000000, 0.000000, 0.048918>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.533155, 0.000000, 0.024491>, <1.773199, 0.000000, 0.030793>, <0.759947, 0.000000, 0.041590>, <0.000000, 0.000000, 0.048918>, 
      <2.533155, 0.132467, 0.024491>, <1.773199, 0.132467, 0.030793>, <0.759947, 0.000000, 0.041590>, <0.000000, 0.000000, 0.048918>, 
      <2.517674, 0.309422, 0.024491>, <1.769263, 0.177457, 0.030793>, <0.748401, 0.131963, 0.041590>, <0.000000, 0.000000, 0.048918>, 
      <2.494671, 0.439877, 0.024491>, <1.746261, 0.307912, 0.030793>, <0.748401, 0.131963, 0.041590>, <0.000000, 0.000000, 0.048918>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.443288, 0.161344, 0.381731>, <0.310302, 0.112941, 0.381731>, <0.132986, 0.048403, 0.381731>, <0.000000, 0.000000, 0.381731>, 
      <0.451588, 0.138113, 0.381731>, <0.318602, 0.089710, 0.381731>, <0.132986, 0.048403, 0.381731>, <0.000000, 0.000000, 0.381731>, 
      <0.460144, 0.106185, 0.381731>, <0.320773, 0.081610, 0.381731>, <0.139371, 0.024575, 0.381731>, <0.000000, 0.000000, 0.381731>, 
      <0.464571, 0.081916, 0.381731>, <0.325200, 0.057341, 0.381731>, <0.139371, 0.024575, 0.381731>, <0.000000, 0.000000, 0.381731>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.409388, 0.236360, 0.381731>, <0.286572, 0.165452, 0.381731>, <0.122816, 0.070908, 0.381731>, <0.000000, 0.000000, 0.381731>, 
      <0.421736, 0.214973, 0.381731>, <0.298920, 0.144065, 0.381731>, <0.122816, 0.070908, 0.381731>, <0.000000, 0.000000, 0.381731>, 
      <0.434979, 0.184600, 0.381731>, <0.301992, 0.136197, 0.381731>, <0.132986, 0.048403, 0.381731>, <0.000000, 0.000000, 0.381731>, 
      <0.443288, 0.161344, 0.381731>, <0.310302, 0.112941, 0.381731>, <0.132986, 0.048403, 0.381731>, <0.000000, 0.000000, 0.381731>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.361372, 0.303227, 0.381731>, <0.252960, 0.212259, 0.381731>, <0.108412, 0.090968, 0.381731>, <0.000000, 0.000000, 0.381731>, 
      <0.377358, 0.284403, 0.381731>, <0.268946, 0.193435, 0.381731>, <0.108412, 0.090968, 0.381731>, <0.000000, 0.000000, 0.381731>, 
      <0.397040, 0.257748, 0.381731>, <0.274224, 0.186840, 0.381731>, <0.122816, 0.070908, 0.381731>, <0.000000, 0.000000, 0.381731>, 
      <0.409388, 0.236360, 0.381731>, <0.286572, 0.165452, 0.381731>, <0.122816, 0.070908, 0.381731>, <0.000000, 0.000000, 0.381731>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.303227, 0.361372, 0.381731>, <0.212259, 0.252960, 0.381731>, <0.090968, 0.108412, 0.381731>, <0.000000, 0.000000, 0.381731>, 
      <0.322031, 0.345404, 0.381731>, <0.231062, 0.236992, 0.381731>, <0.090968, 0.108412, 0.381731>, <0.000000, 0.000000, 0.381731>, 
      <0.345404, 0.322031, 0.381731>, <0.236992, 0.231062, 0.381731>, <0.108412, 0.090968, 0.381731>, <0.000000, 0.000000, 0.381731>, 
      <0.361372, 0.303227, 0.381731>, <0.252960, 0.212259, 0.381731>, <0.108412, 0.090968, 0.381731>, <0.000000, 0.000000, 0.381731>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.236361, 0.409388, 0.381731>, <0.165453, 0.286571, 0.381731>, <0.070908, 0.122816, 0.381731>, <0.000000, 0.000000, 0.381731>, 
      <0.257748, 0.397040, 0.381731>, <0.186840, 0.274224, 0.381731>, <0.070908, 0.122816, 0.381731>, <0.000000, 0.000000, 0.381731>, 
      <0.284403, 0.377358, 0.381731>, <0.193435, 0.268946, 0.381731>, <0.090968, 0.108412, 0.381731>, <0.000000, 0.000000, 0.381731>, 
      <0.303227, 0.361372, 0.381731>, <0.212259, 0.252960, 0.381731>, <0.090968, 0.108412, 0.381731>, <0.000000, 0.000000, 0.381731>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.161344, 0.443288, 0.381731>, <0.112941, 0.310302, 0.381731>, <0.048403, 0.132986, 0.381731>, <0.000000, 0.000000, 0.381731>, 
      <0.184600, 0.434978, 0.381731>, <0.136197, 0.301992, 0.381731>, <0.048403, 0.132986, 0.381731>, <0.000000, 0.000000, 0.381731>, 
      <0.214973, 0.421736, 0.381731>, <0.144065, 0.298920, 0.381731>, <0.070908, 0.122816, 0.381731>, <0.000000, 0.000000, 0.381731>, 
      <0.236361, 0.409388, 0.381731>, <0.165453, 0.286571, 0.381731>, <0.070908, 0.122816, 0.381731>, <0.000000, 0.000000, 0.381731>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.081916, 0.464571, 0.381731>, <0.057341, 0.325200, 0.381731>, <0.024575, 0.139371, 0.381731>, <0.000000, 0.000000, 0.381731>, 
      <0.106185, 0.460144, 0.381731>, <0.081610, 0.320773, 0.381731>, <0.024575, 0.139371, 0.381731>, <0.000000, 0.000000, 0.381731>, 
      <0.138113, 0.451588, 0.381731>, <0.089710, 0.318602, 0.381731>, <0.048403, 0.132986, 0.381731>, <0.000000, 0.000000, 0.381731>, 
      <0.161344, 0.443288, 0.381731>, <0.112941, 0.310302, 0.381731>, <0.048403, 0.132986, 0.381731>, <0.000000, 0.000000, 0.381731>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 0.472721, 0.381731>, <0.000000, 0.330905, 0.381731>, <0.000000, 0.141816, 0.381731>, <0.000000, 0.000000, 0.381731>, 
      <0.024696, 0.472721, 0.381731>, <0.024696, 0.330905, 0.381731>, <0.000000, 0.141816, 0.381731>, <0.000000, 0.000000, 0.381731>, 
      <0.057621, 0.469003, 0.381731>, <0.033046, 0.329632, 0.381731>, <0.024575, 0.139371, 0.381731>, <0.000000, 0.000000, 0.381731>, 
      <0.081916, 0.464571, 0.381731>, <0.057341, 0.325200, 0.381731>, <0.024575, 0.139371, 0.381731>, <0.000000, 0.000000, 0.381731>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.081916, 0.464571, 0.381731>, <-0.057341, 0.325200, 0.381731>, <-0.024575, 0.139371, 0.381731>, <0.000000, 0.000000, 0.381731>, 
      <-0.057621, 0.469003, 0.381731>, <-0.033046, 0.329632, 0.381731>, <-0.024575, 0.139371, 0.381731>, <0.000000, 0.000000, 0.381731>, 
      <-0.024696, 0.472721, 0.381731>, <-0.024696, 0.330905, 0.381731>, <0.000000, 0.141816, 0.381731>, <0.000000, 0.000000, 0.381731>, 
      <0.000000, 0.472721, 0.381731>, <0.000000, 0.330905, 0.381731>, <0.000000, 0.141816, 0.381731>, <0.000000, 0.000000, 0.381731>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.161344, 0.443288, 0.381731>, <-0.112941, 0.310302, 0.381731>, <-0.048403, 0.132986, 0.381731>, <0.000000, 0.000000, 0.381731>, 
      <-0.138113, 0.451588, 0.381731>, <-0.089710, 0.318602, 0.381731>, <-0.048403, 0.132986, 0.381731>, <0.000000, 0.000000, 0.381731>, 
      <-0.106185, 0.460144, 0.381731>, <-0.081610, 0.320773, 0.381731>, <-0.024575, 0.139371, 0.381731>, <0.000000, 0.000000, 0.381731>, 
      <-0.081916, 0.464571, 0.381731>, <-0.057341, 0.325200, 0.381731>, <-0.024575, 0.139371, 0.381731>, <0.000000, 0.000000, 0.381731>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.236360, 0.409388, 0.381731>, <-0.165452, 0.286572, 0.381731>, <-0.070908, 0.122816, 0.381731>, <0.000000, 0.000000, 0.381731>, 
      <-0.214973, 0.421736, 0.381731>, <-0.144065, 0.298920, 0.381731>, <-0.070908, 0.122816, 0.381731>, <0.000000, 0.000000, 0.381731>, 
      <-0.184600, 0.434979, 0.381731>, <-0.136197, 0.301992, 0.381731>, <-0.048403, 0.132986, 0.381731>, <0.000000, 0.000000, 0.381731>, 
      <-0.161344, 0.443288, 0.381731>, <-0.112941, 0.310302, 0.381731>, <-0.048403, 0.132986, 0.381731>, <0.000000, 0.000000, 0.381731>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.303227, 0.361372, 0.381731>, <-0.212259, 0.252960, 0.381731>, <-0.090968, 0.108412, 0.381731>, <0.000000, 0.000000, 0.381731>, 
      <-0.284403, 0.377358, 0.381731>, <-0.193435, 0.268946, 0.381731>, <-0.090968, 0.108412, 0.381731>, <0.000000, 0.000000, 0.381731>, 
      <-0.257748, 0.397040, 0.381731>, <-0.186840, 0.274224, 0.381731>, <-0.070908, 0.122816, 0.381731>, <0.000000, 0.000000, 0.381731>, 
      <-0.236360, 0.409388, 0.381731>, <-0.165452, 0.286572, 0.381731>, <-0.070908, 0.122816, 0.381731>, <0.000000, 0.000000, 0.381731>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.361372, 0.303227, 0.381731>, <-0.252960, 0.212259, 0.381731>, <-0.108412, 0.090968, 0.381731>, <0.000000, 0.000000, 0.381731>, 
      <-0.345404, 0.322031, 0.381731>, <-0.236992, 0.231062, 0.381731>, <-0.108412, 0.090968, 0.381731>, <0.000000, 0.000000, 0.381731>, 
      <-0.322031, 0.345404, 0.381731>, <-0.231062, 0.236992, 0.381731>, <-0.090968, 0.108412, 0.381731>, <0.000000, 0.000000, 0.381731>, 
      <-0.303227, 0.361372, 0.381731>, <-0.212259, 0.252960, 0.381731>, <-0.090968, 0.108412, 0.381731>, <0.000000, 0.000000, 0.381731>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.409388, 0.236361, 0.381731>, <-0.286571, 0.165453, 0.381731>, <-0.122816, 0.070908, 0.381731>, <0.000000, 0.000000, 0.381731>, 
      <-0.397040, 0.257748, 0.381731>, <-0.274224, 0.186840, 0.381731>, <-0.122816, 0.070908, 0.381731>, <0.000000, 0.000000, 0.381731>, 
      <-0.377358, 0.284403, 0.381731>, <-0.268946, 0.193435, 0.381731>, <-0.108412, 0.090968, 0.381731>, <0.000000, 0.000000, 0.381731>, 
      <-0.361372, 0.303227, 0.381731>, <-0.252960, 0.212259, 0.381731>, <-0.108412, 0.090968, 0.381731>, <0.000000, 0.000000, 0.381731>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.443288, 0.161344, 0.381731>, <-0.310302, 0.112941, 0.381731>, <-0.132986, 0.048403, 0.381731>, <0.000000, 0.000000, 0.381731>, 
      <-0.434978, 0.184600, 0.381731>, <-0.301992, 0.136197, 0.381731>, <-0.132986, 0.048403, 0.381731>, <0.000000, 0.000000, 0.381731>, 
      <-0.421736, 0.214973, 0.381731>, <-0.298920, 0.144065, 0.381731>, <-0.122816, 0.070908, 0.381731>, <0.000000, 0.000000, 0.381731>, 
      <-0.409388, 0.236361, 0.381731>, <-0.286571, 0.165453, 0.381731>, <-0.122816, 0.070908, 0.381731>, <0.000000, 0.000000, 0.381731>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.464571, 0.081916, 0.381731>, <-0.325200, 0.057341, 0.381731>, <-0.139371, 0.024575, 0.381731>, <0.000000, 0.000000, 0.381731>, 
      <-0.460144, 0.106185, 0.381731>, <-0.320773, 0.081610, 0.381731>, <-0.139371, 0.024575, 0.381731>, <0.000000, 0.000000, 0.381731>, 
      <-0.451588, 0.138113, 0.381731>, <-0.318602, 0.089710, 0.381731>, <-0.132986, 0.048403, 0.381731>, <0.000000, 0.000000, 0.381731>, 
      <-0.443288, 0.161344, 0.381731>, <-0.310302, 0.112941, 0.381731>, <-0.132986, 0.048403, 0.381731>, <0.000000, 0.000000, 0.381731>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.472721, 0.000000, 0.381731>, <-0.330905, 0.000000, 0.381731>, <-0.141816, 0.000000, 0.381731>, <0.000000, 0.000000, 0.381731>, 
      <-0.472721, 0.024696, 0.381731>, <-0.330905, 0.024696, 0.381731>, <-0.141816, 0.000000, 0.381731>, <0.000000, 0.000000, 0.381731>, 
      <-0.469003, 0.057621, 0.381731>, <-0.329632, 0.033046, 0.381731>, <-0.139371, 0.024575, 0.381731>, <0.000000, 0.000000, 0.381731>, 
      <-0.464571, 0.081916, 0.381731>, <-0.325200, 0.057341, 0.381731>, <-0.139371, 0.024575, 0.381731>, <0.000000, 0.000000, 0.381731>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.464571, -0.081916, 0.381731>, <-0.325200, -0.057341, 0.381731>, <-0.139371, -0.024575, 0.381731>, <0.000000, 0.000000, 0.381731>, 
      <-0.469003, -0.057621, 0.381731>, <-0.329632, -0.033046, 0.381731>, <-0.139371, -0.024575, 0.381731>, <0.000000, 0.000000, 0.381731>, 
      <-0.472721, -0.024696, 0.381731>, <-0.330905, -0.024696, 0.381731>, <-0.141816, 0.000000, 0.381731>, <0.000000, 0.000000, 0.381731>, 
      <-0.472721, 0.000000, 0.381731>, <-0.330905, 0.000000, 0.381731>, <-0.141816, 0.000000, 0.381731>, <0.000000, 0.000000, 0.381731>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.443288, -0.161344, 0.381731>, <-0.310302, -0.112941, 0.381731>, <-0.132986, -0.048403, 0.381731>, <0.000000, 0.000000, 0.381731>, 
      <-0.451588, -0.138113, 0.381731>, <-0.318602, -0.089710, 0.381731>, <-0.132986, -0.048403, 0.381731>, <0.000000, 0.000000, 0.381731>, 
      <-0.460144, -0.106185, 0.381731>, <-0.320773, -0.081610, 0.381731>, <-0.139371, -0.024575, 0.381731>, <0.000000, 0.000000, 0.381731>, 
      <-0.464571, -0.081916, 0.381731>, <-0.325200, -0.057341, 0.381731>, <-0.139371, -0.024575, 0.381731>, <0.000000, 0.000000, 0.381731>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.409388, -0.236360, 0.381731>, <-0.286572, -0.165452, 0.381731>, <-0.122816, -0.070908, 0.381731>, <0.000000, 0.000000, 0.381731>, 
      <-0.421736, -0.214973, 0.381731>, <-0.298920, -0.144065, 0.381731>, <-0.122816, -0.070908, 0.381731>, <0.000000, 0.000000, 0.381731>, 
      <-0.434979, -0.184600, 0.381731>, <-0.301992, -0.136197, 0.381731>, <-0.132986, -0.048403, 0.381731>, <0.000000, 0.000000, 0.381731>, 
      <-0.443288, -0.161344, 0.381731>, <-0.310302, -0.112941, 0.381731>, <-0.132986, -0.048403, 0.381731>, <0.000000, 0.000000, 0.381731>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.361372, -0.303227, 0.381731>, <-0.252960, -0.212259, 0.381731>, <-0.108412, -0.090968, 0.381731>, <0.000000, 0.000000, 0.381731>, 
      <-0.377358, -0.284403, 0.381731>, <-0.268946, -0.193435, 0.381731>, <-0.108412, -0.090968, 0.381731>, <0.000000, 0.000000, 0.381731>, 
      <-0.397040, -0.257748, 0.381731>, <-0.274224, -0.186840, 0.381731>, <-0.122816, -0.070908, 0.381731>, <0.000000, 0.000000, 0.381731>, 
      <-0.409388, -0.236360, 0.381731>, <-0.286572, -0.165452, 0.381731>, <-0.122816, -0.070908, 0.381731>, <0.000000, 0.000000, 0.381731>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.303227, -0.361372, 0.381731>, <-0.212259, -0.252960, 0.381731>, <-0.090968, -0.108412, 0.381731>, <0.000000, 0.000000, 0.381731>, 
      <-0.322031, -0.345404, 0.381731>, <-0.231062, -0.236992, 0.381731>, <-0.090968, -0.108412, 0.381731>, <0.000000, 0.000000, 0.381731>, 
      <-0.345404, -0.322031, 0.381731>, <-0.236992, -0.231062, 0.381731>, <-0.108412, -0.090968, 0.381731>, <0.000000, 0.000000, 0.381731>, 
      <-0.361372, -0.303227, 0.381731>, <-0.252960, -0.212259, 0.381731>, <-0.108412, -0.090968, 0.381731>, <0.000000, 0.000000, 0.381731>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.236360, -0.409388, 0.381731>, <-0.165452, -0.286572, 0.381731>, <-0.070908, -0.122816, 0.381731>, <0.000000, 0.000000, 0.381731>, 
      <-0.257748, -0.397040, 0.381731>, <-0.186840, -0.274224, 0.381731>, <-0.070908, -0.122816, 0.381731>, <0.000000, 0.000000, 0.381731>, 
      <-0.284403, -0.377358, 0.381731>, <-0.193435, -0.268946, 0.381731>, <-0.090968, -0.108412, 0.381731>, <0.000000, 0.000000, 0.381731>, 
      <-0.303227, -0.361372, 0.381731>, <-0.212259, -0.252960, 0.381731>, <-0.090968, -0.108412, 0.381731>, <0.000000, 0.000000, 0.381731>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.161344, -0.443288, 0.381731>, <-0.112941, -0.310302, 0.381731>, <-0.048403, -0.132986, 0.381731>, <0.000000, 0.000000, 0.381731>, 
      <-0.184600, -0.434979, 0.381731>, <-0.136197, -0.301992, 0.381731>, <-0.048403, -0.132986, 0.381731>, <0.000000, 0.000000, 0.381731>, 
      <-0.214973, -0.421736, 0.381731>, <-0.144065, -0.298920, 0.381731>, <-0.070908, -0.122816, 0.381731>, <0.000000, 0.000000, 0.381731>, 
      <-0.236360, -0.409388, 0.381731>, <-0.165452, -0.286572, 0.381731>, <-0.070908, -0.122816, 0.381731>, <0.000000, 0.000000, 0.381731>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.081916, -0.464571, 0.381731>, <-0.057341, -0.325200, 0.381731>, <-0.024575, -0.139371, 0.381731>, <0.000000, 0.000000, 0.381731>, 
      <-0.106185, -0.460144, 0.381731>, <-0.081610, -0.320773, 0.381731>, <-0.024575, -0.139371, 0.381731>, <0.000000, 0.000000, 0.381731>, 
      <-0.138113, -0.451588, 0.381731>, <-0.089710, -0.318602, 0.381731>, <-0.048403, -0.132986, 0.381731>, <0.000000, 0.000000, 0.381731>, 
      <-0.161344, -0.443288, 0.381731>, <-0.112941, -0.310302, 0.381731>, <-0.048403, -0.132986, 0.381731>, <0.000000, 0.000000, 0.381731>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -0.472721, 0.381731>, <0.000000, -0.330905, 0.381731>, <0.000000, -0.141816, 0.381731>, <0.000000, 0.000000, 0.381731>, 
      <-0.024696, -0.472721, 0.381731>, <-0.024696, -0.330905, 0.381731>, <0.000000, -0.141816, 0.381731>, <0.000000, 0.000000, 0.381731>, 
      <-0.057621, -0.469003, 0.381731>, <-0.033046, -0.329632, 0.381731>, <-0.024575, -0.139371, 0.381731>, <0.000000, 0.000000, 0.381731>, 
      <-0.081916, -0.464571, 0.381731>, <-0.057341, -0.325200, 0.381731>, <-0.024575, -0.139371, 0.381731>, <0.000000, 0.000000, 0.381731>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.081916, -0.464571, 0.381731>, <0.057341, -0.325200, 0.381731>, <0.024575, -0.139371, 0.381731>, <0.000000, 0.000000, 0.381731>, 
      <0.057621, -0.469003, 0.381731>, <0.033046, -0.329632, 0.381731>, <0.024575, -0.139371, 0.381731>, <0.000000, 0.000000, 0.381731>, 
      <0.024696, -0.472721, 0.381731>, <0.024696, -0.330905, 0.381731>, <0.000000, -0.141816, 0.381731>, <0.000000, 0.000000, 0.381731>, 
      <0.000000, -0.472721, 0.381731>, <0.000000, -0.330905, 0.381731>, <0.000000, -0.141816, 0.381731>, <0.000000, 0.000000, 0.381731>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.161344, -0.443288, 0.381731>, <0.112941, -0.310302, 0.381731>, <0.048403, -0.132986, 0.381731>, <0.000000, 0.000000, 0.381731>, 
      <0.138113, -0.451588, 0.381731>, <0.089710, -0.318602, 0.381731>, <0.048403, -0.132986, 0.381731>, <0.000000, 0.000000, 0.381731>, 
      <0.106185, -0.460144, 0.381731>, <0.081610, -0.320773, 0.381731>, <0.024575, -0.139371, 0.381731>, <0.000000, 0.000000, 0.381731>, 
      <0.081916, -0.464571, 0.381731>, <0.057341, -0.325200, 0.381731>, <0.024575, -0.139371, 0.381731>, <0.000000, 0.000000, 0.381731>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.236360, -0.409388, 0.381731>, <0.165452, -0.286572, 0.381731>, <0.070908, -0.122816, 0.381731>, <0.000000, 0.000000, 0.381731>, 
      <0.214973, -0.421736, 0.381731>, <0.144065, -0.298920, 0.381731>, <0.070908, -0.122816, 0.381731>, <0.000000, 0.000000, 0.381731>, 
      <0.184600, -0.434979, 0.381731>, <0.136197, -0.301992, 0.381731>, <0.048403, -0.132986, 0.381731>, <0.000000, 0.000000, 0.381731>, 
      <0.161344, -0.443288, 0.381731>, <0.112941, -0.310302, 0.381731>, <0.048403, -0.132986, 0.381731>, <0.000000, 0.000000, 0.381731>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.303227, -0.361372, 0.381731>, <0.212259, -0.252960, 0.381731>, <0.090968, -0.108412, 0.381731>, <0.000000, 0.000000, 0.381731>, 
      <0.284403, -0.377358, 0.381731>, <0.193435, -0.268946, 0.381731>, <0.090968, -0.108412, 0.381731>, <0.000000, 0.000000, 0.381731>, 
      <0.257748, -0.397040, 0.381731>, <0.186840, -0.274224, 0.381731>, <0.070908, -0.122816, 0.381731>, <0.000000, 0.000000, 0.381731>, 
      <0.236360, -0.409388, 0.381731>, <0.165452, -0.286572, 0.381731>, <0.070908, -0.122816, 0.381731>, <0.000000, 0.000000, 0.381731>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.361372, -0.303227, 0.381731>, <0.252960, -0.212259, 0.381731>, <0.108412, -0.090968, 0.381731>, <0.000000, 0.000000, 0.381731>, 
      <0.345404, -0.322031, 0.381731>, <0.236992, -0.231062, 0.381731>, <0.108412, -0.090968, 0.381731>, <0.000000, 0.000000, 0.381731>, 
      <0.322031, -0.345404, 0.381731>, <0.231062, -0.236992, 0.381731>, <0.090968, -0.108412, 0.381731>, <0.000000, 0.000000, 0.381731>, 
      <0.303227, -0.361372, 0.381731>, <0.212259, -0.252960, 0.381731>, <0.090968, -0.108412, 0.381731>, <0.000000, 0.000000, 0.381731>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.409388, -0.236360, 0.381731>, <0.286572, -0.165452, 0.381731>, <0.122816, -0.070908, 0.381731>, <0.000000, 0.000000, 0.381731>, 
      <0.397040, -0.257748, 0.381731>, <0.274224, -0.186840, 0.381731>, <0.122816, -0.070908, 0.381731>, <0.000000, 0.000000, 0.381731>, 
      <0.377358, -0.284403, 0.381731>, <0.268946, -0.193435, 0.381731>, <0.108412, -0.090968, 0.381731>, <0.000000, 0.000000, 0.381731>, 
      <0.361372, -0.303227, 0.381731>, <0.252960, -0.212259, 0.381731>, <0.108412, -0.090968, 0.381731>, <0.000000, 0.000000, 0.381731>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.443288, -0.161344, 0.381731>, <0.310302, -0.112941, 0.381731>, <0.132986, -0.048403, 0.381731>, <0.000000, 0.000000, 0.381731>, 
      <0.434979, -0.184600, 0.381731>, <0.301992, -0.136197, 0.381731>, <0.132986, -0.048403, 0.381731>, <0.000000, 0.000000, 0.381731>, 
      <0.421736, -0.214973, 0.381731>, <0.298920, -0.144065, 0.381731>, <0.122816, -0.070908, 0.381731>, <0.000000, 0.000000, 0.381731>, 
      <0.409388, -0.236360, 0.381731>, <0.286572, -0.165452, 0.381731>, <0.122816, -0.070908, 0.381731>, <0.000000, 0.000000, 0.381731>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.464571, -0.081916, 0.381731>, <0.325200, -0.057341, 0.381731>, <0.139371, -0.024575, 0.381731>, <0.000000, 0.000000, 0.381731>, 
      <0.460144, -0.106185, 0.381731>, <0.320773, -0.081610, 0.381731>, <0.139371, -0.024575, 0.381731>, <0.000000, 0.000000, 0.381731>, 
      <0.451588, -0.138113, 0.381731>, <0.318602, -0.089710, 0.381731>, <0.132986, -0.048403, 0.381731>, <0.000000, 0.000000, 0.381731>, 
      <0.443288, -0.161344, 0.381731>, <0.310302, -0.112941, 0.381731>, <0.132986, -0.048403, 0.381731>, <0.000000, 0.000000, 0.381731>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.472721, 0.000000, 0.381731>, <0.330905, 0.000000, 0.381731>, <0.141816, 0.000000, 0.381731>, <0.000000, 0.000000, 0.381731>, 
      <0.472721, -0.024696, 0.381731>, <0.330905, -0.024696, 0.381731>, <0.141816, 0.000000, 0.381731>, <0.000000, 0.000000, 0.381731>, 
      <0.469003, -0.057621, 0.381731>, <0.329632, -0.033046, 0.381731>, <0.139371, -0.024575, 0.381731>, <0.000000, 0.000000, 0.381731>, 
      <0.464571, -0.081916, 0.381731>, <0.325200, -0.057341, 0.381731>, <0.139371, -0.024575, 0.381731>, <0.000000, 0.000000, 0.381731>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.472721, 0.000000, 0.381731>, <0.472721, 0.024696, 0.381731>, <0.469003, 0.057621, 0.381731>, <0.464571, 0.081916, 0.381731>, 
      <0.330905, 0.000000, 0.381731>, <0.330905, 0.024696, 0.381731>, <0.329632, 0.033046, 0.381731>, <0.325200, 0.057341, 0.381731>, 
      <0.141816, 0.000000, 0.381731>, <0.141816, 0.000000, 0.381731>, <0.139371, 0.024575, 0.381731>, <0.139371, 0.024575, 0.381731>, 
      <0.000000, 0.000000, 0.381731>, <0.000000, 0.000000, 0.381731>, <0.000000, 0.000000, 0.381731>, <0.000000, 0.000000, 0.381731>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.389694, 0.869777, 0.381731>, <1.806369, 0.657465, 0.353632>, <1.027210, 0.373874, 0.381731>, <0.443288, 0.161344, 0.381731>, 
      <2.434439, 0.744545, 0.381731>, <1.851115, 0.532233, 0.353632>, <1.035510, 0.350643, 0.381731>, <0.451588, 0.138113, 0.381731>, 
      <2.480560, 0.572423, 0.381731>, <1.869229, 0.464630, 0.353632>, <1.072100, 0.214089, 0.381731>, <0.460144, 0.106185, 0.381731>, 
      <2.504425, 0.441597, 0.381731>, <1.893095, 0.333803, 0.353632>, <1.076527, 0.189820, 0.381731>, <0.464571, 0.081916, 0.381731>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.206945, 1.274179, 0.381731>, <1.668227, 0.963150, 0.353632>, <0.948655, 0.547706, 0.381731>, <0.409388, 0.236360, 0.381731>, 
      <2.273511, 1.158882, 0.381731>, <1.734794, 0.847854, 0.353632>, <0.961003, 0.526318, 0.381731>, <0.421736, 0.214973, 0.381731>, 
      <2.344899, 0.995148, 0.381731>, <1.761575, 0.782836, 0.353632>, <1.018900, 0.397130, 0.381731>, <0.434979, 0.184600, 0.381731>, 
      <2.389694, 0.869777, 0.381731>, <1.806369, 0.657465, 0.353632>, <1.027210, 0.373874, 0.381731>, <0.443288, 0.161344, 0.381731>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.948097, 1.634647, 0.381731>, <1.472566, 1.235630, 0.353632>, <0.837390, 0.702653, 0.381731>, <0.361372, 0.303227, 0.381731>, 
      <2.034274, 1.533168, 0.381731>, <1.558744, 1.134150, 0.353632>, <0.853375, 0.683829, 0.381731>, <0.377358, 0.284403, 0.381731>, 
      <2.140378, 1.389476, 0.381731>, <1.601660, 1.078447, 0.353632>, <0.936307, 0.569093, 0.381731>, <0.397040, 0.257748, 0.381731>, 
      <2.206945, 1.274179, 0.381731>, <1.668227, 0.963150, 0.353632>, <0.948655, 0.547706, 0.381731>, <0.409388, 0.236360, 0.381731>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.634648, 1.948096, 0.381731>, <1.235630, 1.472566, 0.353632>, <0.702653, 0.837389, 0.381731>, <0.303227, 0.361372, 0.381731>, 
      <1.736014, 1.862015, 0.381731>, <1.336996, 1.386484, 0.353632>, <0.721457, 0.821421, 0.381731>, <0.322031, 0.345404, 0.381731>, 
      <1.862016, 1.736013, 0.381731>, <1.386485, 1.336996, 0.353632>, <0.821421, 0.721457, 0.381731>, <0.345404, 0.322031, 0.381731>, 
      <1.948097, 1.634647, 0.381731>, <1.472566, 1.235630, 0.353632>, <0.837390, 0.702653, 0.381731>, <0.361372, 0.303227, 0.381731>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.274180, 2.206945, 0.381731>, <0.963151, 1.668227, 0.353632>, <0.547707, 0.948655, 0.381731>, <0.236361, 0.409388, 0.381731>, 
      <1.389477, 2.140378, 0.381731>, <1.078448, 1.601660, 0.353632>, <0.569094, 0.936307, 0.381731>, <0.257748, 0.397040, 0.381731>, 
      <1.533169, 2.034273, 0.381731>, <1.134151, 1.558743, 0.353632>, <0.683829, 0.853375, 0.381731>, <0.284403, 0.377358, 0.381731>, 
      <1.634648, 1.948096, 0.381731>, <1.235630, 1.472566, 0.353632>, <0.702653, 0.837389, 0.381731>, <0.303227, 0.361372, 0.381731>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.869778, 2.389694, 0.381731>, <0.657465, 1.806370, 0.353632>, <0.373874, 1.027210, 0.381731>, <0.161344, 0.443288, 0.381731>, 
      <0.995149, 2.344899, 0.381731>, <0.782836, 1.761575, 0.353632>, <0.397131, 1.018900, 0.381731>, <0.184600, 0.434978, 0.381731>, 
      <1.158883, 2.273512, 0.381731>, <0.847855, 1.734794, 0.353632>, <0.526319, 0.961003, 0.381731>, <0.214973, 0.421736, 0.381731>, 
      <1.274180, 2.206945, 0.381731>, <0.963151, 1.668227, 0.353632>, <0.547707, 0.948655, 0.381731>, <0.236361, 0.409388, 0.381731>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.441598, 2.504425, 0.381731>, <0.333804, 1.893095, 0.353632>, <0.189821, 1.076527, 0.381731>, <0.081916, 0.464571, 0.381731>, 
      <0.572424, 2.480560, 0.381731>, <0.464630, 1.869229, 0.353632>, <0.214089, 1.072100, 0.381731>, <0.106185, 0.460144, 0.381731>, 
      <0.744546, 2.434439, 0.381731>, <0.532233, 1.851115, 0.353632>, <0.350644, 1.035510, 0.381731>, <0.138113, 0.451588, 0.381731>, 
      <0.869778, 2.389694, 0.381731>, <0.657465, 1.806370, 0.353632>, <0.373874, 1.027210, 0.381731>, <0.161344, 0.443288, 0.381731>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 2.548360, 0.381731>, <0.000000, 1.926303, 0.353632>, <0.000000, 1.095413, 0.381731>, <0.000000, 0.472721, 0.381731>, 
      <0.133133, 2.548360, 0.381731>, <0.133133, 1.926303, 0.353632>, <0.024696, 1.095413, 0.381731>, <0.024696, 0.472721, 0.381731>, 
      <0.310626, 2.528317, 0.381731>, <0.202832, 1.916987, 0.353632>, <0.165525, 1.080959, 0.381731>, <0.057621, 0.469003, 0.381731>, 
      <0.441598, 2.504425, 0.381731>, <0.333804, 1.893095, 0.353632>, <0.189821, 1.076527, 0.381731>, <0.081916, 0.464571, 0.381731>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.441597, 2.504425, 0.381731>, <-0.333803, 1.893095, 0.353632>, <-0.189820, 1.076527, 0.381731>, <-0.081916, 0.464571, 0.381731>, 
      <-0.310625, 2.528317, 0.381731>, <-0.202831, 1.916987, 0.353632>, <-0.165525, 1.080959, 0.381731>, <-0.057621, 0.469003, 0.381731>, 
      <-0.133133, 2.548360, 0.381731>, <-0.133133, 1.926303, 0.353632>, <-0.024696, 1.095413, 0.381731>, <-0.024696, 0.472721, 0.381731>, 
      <0.000000, 2.548360, 0.381731>, <0.000000, 1.926303, 0.353632>, <0.000000, 1.095413, 0.381731>, <0.000000, 0.472721, 0.381731>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.869777, 2.389694, 0.381731>, <-0.657465, 1.806370, 0.353632>, <-0.373874, 1.027210, 0.381731>, <-0.161344, 0.443288, 0.381731>, 
      <-0.744545, 2.434439, 0.381731>, <-0.532233, 1.851115, 0.353632>, <-0.350643, 1.035510, 0.381731>, <-0.138113, 0.451588, 0.381731>, 
      <-0.572423, 2.480560, 0.381731>, <-0.464630, 1.869229, 0.353632>, <-0.214089, 1.072100, 0.381731>, <-0.106185, 0.460144, 0.381731>, 
      <-0.441597, 2.504425, 0.381731>, <-0.333803, 1.893095, 0.353632>, <-0.189820, 1.076527, 0.381731>, <-0.081916, 0.464571, 0.381731>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.274180, 2.206945, 0.381731>, <-0.963151, 1.668227, 0.353632>, <-0.547706, 0.948655, 0.381731>, <-0.236360, 0.409388, 0.381731>, 
      <-1.158883, 2.273512, 0.381731>, <-0.847854, 1.734794, 0.353632>, <-0.526319, 0.961003, 0.381731>, <-0.214973, 0.421736, 0.381731>, 
      <-0.995148, 2.344899, 0.381731>, <-0.782836, 1.761575, 0.353632>, <-0.397130, 1.018900, 0.381731>, <-0.184600, 0.434979, 0.381731>, 
      <-0.869777, 2.389694, 0.381731>, <-0.657465, 1.806370, 0.353632>, <-0.373874, 1.027210, 0.381731>, <-0.161344, 0.443288, 0.381731>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.634647, 1.948097, 0.381731>, <-1.235630, 1.472566, 0.353632>, <-0.702653, 0.837390, 0.381731>, <-0.303227, 0.361372, 0.381731>, 
      <-1.533168, 2.034274, 0.381731>, <-1.134151, 1.558744, 0.353632>, <-0.683829, 0.853375, 0.381731>, <-0.284403, 0.377358, 0.381731>, 
      <-1.389477, 2.140378, 0.381731>, <-1.078448, 1.601661, 0.353632>, <-0.569094, 0.936307, 0.381731>, <-0.257748, 0.397040, 0.381731>, 
      <-1.274180, 2.206945, 0.381731>, <-0.963151, 1.668227, 0.353632>, <-0.547706, 0.948655, 0.381731>, <-0.236360, 0.409388, 0.381731>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.948097, 1.634648, 0.381731>, <-1.472566, 1.235630, 0.353632>, <-0.837390, 0.702653, 0.381731>, <-0.361372, 0.303227, 0.381731>, 
      <-1.862016, 1.736014, 0.381731>, <-1.386485, 1.336996, 0.353632>, <-0.821422, 0.721457, 0.381731>, <-0.345404, 0.322031, 0.381731>, 
      <-1.736013, 1.862016, 0.381731>, <-1.336996, 1.386485, 0.353632>, <-0.721457, 0.821421, 0.381731>, <-0.322031, 0.345404, 0.381731>, 
      <-1.634647, 1.948097, 0.381731>, <-1.235630, 1.472566, 0.353632>, <-0.702653, 0.837390, 0.381731>, <-0.303227, 0.361372, 0.381731>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.206945, 1.274181, 0.381731>, <-1.668227, 0.963152, 0.353632>, <-0.948655, 0.547707, 0.381731>, <-0.409388, 0.236361, 0.381731>, 
      <-2.140378, 1.389478, 0.381731>, <-1.601661, 1.078449, 0.353632>, <-0.936307, 0.569095, 0.381731>, <-0.397040, 0.257748, 0.381731>, 
      <-2.034274, 1.533169, 0.381731>, <-1.558744, 1.134151, 0.353632>, <-0.853375, 0.683829, 0.381731>, <-0.377358, 0.284403, 0.381731>, 
      <-1.948097, 1.634648, 0.381731>, <-1.472566, 1.235630, 0.353632>, <-0.837390, 0.702653, 0.381731>, <-0.361372, 0.303227, 0.381731>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.389694, 0.869778, 0.381731>, <-1.806369, 0.657465, 0.353632>, <-1.027210, 0.373874, 0.381731>, <-0.443288, 0.161344, 0.381731>, 
      <-2.344899, 0.995149, 0.381731>, <-1.761575, 0.782837, 0.353632>, <-1.018900, 0.397131, 0.381731>, <-0.434978, 0.184600, 0.381731>, 
      <-2.273512, 1.158884, 0.381731>, <-1.734794, 0.847855, 0.353632>, <-0.961003, 0.526320, 0.381731>, <-0.421736, 0.214973, 0.381731>, 
      <-2.206945, 1.274181, 0.381731>, <-1.668227, 0.963152, 0.353632>, <-0.948655, 0.547707, 0.381731>, <-0.409388, 0.236361, 0.381731>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.504425, 0.441598, 0.381731>, <-1.893095, 0.333804, 0.353632>, <-1.076527, 0.189821, 0.381731>, <-0.464571, 0.081916, 0.381731>, 
      <-2.480560, 0.572424, 0.381731>, <-1.869229, 0.464630, 0.353632>, <-1.072100, 0.214089, 0.381731>, <-0.460144, 0.106185, 0.381731>, 
      <-2.434439, 0.744546, 0.381731>, <-1.851114, 0.532234, 0.353632>, <-1.035510, 0.350644, 0.381731>, <-0.451588, 0.138113, 0.381731>, 
      <-2.389694, 0.869778, 0.381731>, <-1.806369, 0.657465, 0.353632>, <-1.027210, 0.373874, 0.381731>, <-0.443288, 0.161344, 0.381731>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.548360, 0.000000, 0.381731>, <-1.926303, 0.000000, 0.353632>, <-1.095413, 0.000000, 0.381731>, <-0.472721, 0.000000, 0.381731>, 
      <-2.548360, 0.133133, 0.381731>, <-1.926303, 0.133133, 0.353632>, <-1.095413, 0.024696, 0.381731>, <-0.472721, 0.024696, 0.381731>, 
      <-2.528317, 0.310626, 0.381731>, <-1.916987, 0.202832, 0.353632>, <-1.080959, 0.165525, 0.381731>, <-0.469003, 0.057621, 0.381731>, 
      <-2.504425, 0.441598, 0.381731>, <-1.893095, 0.333804, 0.353632>, <-1.076527, 0.189821, 0.381731>, <-0.464571, 0.081916, 0.381731>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.504425, -0.441597, 0.381731>, <-1.893095, -0.333803, 0.353632>, <-1.076527, -0.189820, 0.381731>, <-0.464571, -0.081916, 0.381731>, 
      <-2.528317, -0.310625, 0.381731>, <-1.916987, -0.202831, 0.353632>, <-1.080959, -0.165525, 0.381731>, <-0.469003, -0.057621, 0.381731>, 
      <-2.548360, -0.133133, 0.381731>, <-1.926303, -0.133133, 0.353632>, <-1.095413, -0.024696, 0.381731>, <-0.472721, -0.024696, 0.381731>, 
      <-2.548360, 0.000000, 0.381731>, <-1.926303, 0.000000, 0.353632>, <-1.095413, 0.000000, 0.381731>, <-0.472721, 0.000000, 0.381731>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.389694, -0.869777, 0.381731>, <-1.806370, -0.657465, 0.353632>, <-1.027210, -0.373874, 0.381731>, <-0.443288, -0.161344, 0.381731>, 
      <-2.434439, -0.744545, 0.381731>, <-1.851115, -0.532233, 0.353632>, <-1.035510, -0.350643, 0.381731>, <-0.451588, -0.138113, 0.381731>, 
      <-2.480560, -0.572423, 0.381731>, <-1.869229, -0.464630, 0.353632>, <-1.072100, -0.214089, 0.381731>, <-0.460144, -0.106185, 0.381731>, 
      <-2.504425, -0.441597, 0.381731>, <-1.893095, -0.333803, 0.353632>, <-1.076527, -0.189820, 0.381731>, <-0.464571, -0.081916, 0.381731>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.206945, -1.274180, 0.381731>, <-1.668227, -0.963151, 0.353632>, <-0.948655, -0.547706, 0.381731>, <-0.409388, -0.236360, 0.381731>, 
      <-2.273511, -1.158883, 0.381731>, <-1.734794, -0.847854, 0.353632>, <-0.961003, -0.526319, 0.381731>, <-0.421736, -0.214973, 0.381731>, 
      <-2.344899, -0.995148, 0.381731>, <-1.761575, -0.782836, 0.353632>, <-1.018900, -0.397130, 0.381731>, <-0.434979, -0.184600, 0.381731>, 
      <-2.389694, -0.869777, 0.381731>, <-1.806370, -0.657465, 0.353632>, <-1.027210, -0.373874, 0.381731>, <-0.443288, -0.161344, 0.381731>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.948097, -1.634648, 0.381731>, <-1.472566, -1.235630, 0.353632>, <-0.837390, -0.702653, 0.381731>, <-0.361372, -0.303227, 0.381731>, 
      <-2.034274, -1.533169, 0.381731>, <-1.558744, -1.134151, 0.353632>, <-0.853375, -0.683829, 0.381731>, <-0.377358, -0.284403, 0.381731>, 
      <-2.140378, -1.389477, 0.381731>, <-1.601660, -1.078448, 0.353632>, <-0.936307, -0.569094, 0.381731>, <-0.397040, -0.257748, 0.381731>, 
      <-2.206945, -1.274180, 0.381731>, <-1.668227, -0.963151, 0.353632>, <-0.948655, -0.547706, 0.381731>, <-0.409388, -0.236360, 0.381731>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.634648, -1.948097, 0.381731>, <-1.235630, -1.472566, 0.353632>, <-0.702653, -0.837390, 0.381731>, <-0.303227, -0.361372, 0.381731>, 
      <-1.736014, -1.862016, 0.381731>, <-1.336996, -1.386485, 0.353632>, <-0.721457, -0.821422, 0.381731>, <-0.322031, -0.345404, 0.381731>, 
      <-1.862016, -1.736014, 0.381731>, <-1.386485, -1.336997, 0.353632>, <-0.821422, -0.721457, 0.381731>, <-0.345404, -0.322031, 0.381731>, 
      <-1.948097, -1.634648, 0.381731>, <-1.472566, -1.235630, 0.353632>, <-0.837390, -0.702653, 0.381731>, <-0.361372, -0.303227, 0.381731>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.274180, -2.206945, 0.381731>, <-0.963151, -1.668227, 0.353632>, <-0.547706, -0.948655, 0.381731>, <-0.236360, -0.409388, 0.381731>, 
      <-1.389477, -2.140378, 0.381731>, <-1.078448, -1.601660, 0.353632>, <-0.569094, -0.936307, 0.381731>, <-0.257748, -0.397040, 0.381731>, 
      <-1.533169, -2.034274, 0.381731>, <-1.134151, -1.558744, 0.353632>, <-0.683829, -0.853375, 0.381731>, <-0.284403, -0.377358, 0.381731>, 
      <-1.634648, -1.948097, 0.381731>, <-1.235630, -1.472566, 0.353632>, <-0.702653, -0.837390, 0.381731>, <-0.303227, -0.361372, 0.381731>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.869778, -2.389694, 0.381731>, <-0.657465, -1.806369, 0.353632>, <-0.373874, -1.027210, 0.381731>, <-0.161344, -0.443288, 0.381731>, 
      <-0.995149, -2.344899, 0.381731>, <-0.782836, -1.761575, 0.353632>, <-0.397130, -1.018900, 0.381731>, <-0.184600, -0.434979, 0.381731>, 
      <-1.158883, -2.273511, 0.381731>, <-0.847854, -1.734794, 0.353632>, <-0.526319, -0.961003, 0.381731>, <-0.214973, -0.421736, 0.381731>, 
      <-1.274180, -2.206945, 0.381731>, <-0.963151, -1.668227, 0.353632>, <-0.547706, -0.948655, 0.381731>, <-0.236360, -0.409388, 0.381731>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.441598, -2.504425, 0.381731>, <-0.333804, -1.893095, 0.353632>, <-0.189821, -1.076527, 0.381731>, <-0.081916, -0.464571, 0.381731>, 
      <-0.572424, -2.480560, 0.381731>, <-0.464630, -1.869229, 0.353632>, <-0.214089, -1.072100, 0.381731>, <-0.106185, -0.460144, 0.381731>, 
      <-0.744546, -2.434439, 0.381731>, <-0.532234, -1.851115, 0.353632>, <-0.350644, -1.035510, 0.381731>, <-0.138113, -0.451588, 0.381731>, 
      <-0.869778, -2.389694, 0.381731>, <-0.657465, -1.806369, 0.353632>, <-0.373874, -1.027210, 0.381731>, <-0.161344, -0.443288, 0.381731>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -2.548360, 0.381731>, <0.000000, -1.926303, 0.353632>, <0.000000, -1.095413, 0.381731>, <0.000000, -0.472721, 0.381731>, 
      <-0.133133, -2.548360, 0.381731>, <-0.133133, -1.926303, 0.353632>, <-0.024696, -1.095413, 0.381731>, <-0.024696, -0.472721, 0.381731>, 
      <-0.310626, -2.528317, 0.381731>, <-0.202832, -1.916987, 0.353632>, <-0.165525, -1.080959, 0.381731>, <-0.057621, -0.469003, 0.381731>, 
      <-0.441598, -2.504425, 0.381731>, <-0.333804, -1.893095, 0.353632>, <-0.189821, -1.076527, 0.381731>, <-0.081916, -0.464571, 0.381731>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.441598, -2.504425, 0.381731>, <0.333804, -1.893095, 0.353632>, <0.189821, -1.076527, 0.381731>, <0.081916, -0.464571, 0.381731>, 
      <0.310626, -2.528317, 0.381731>, <0.202832, -1.916987, 0.353632>, <0.165525, -1.080959, 0.381731>, <0.057621, -0.469003, 0.381731>, 
      <0.133133, -2.548360, 0.381731>, <0.133133, -1.926303, 0.353632>, <0.024696, -1.095413, 0.381731>, <0.024696, -0.472721, 0.381731>, 
      <0.000000, -2.548360, 0.381731>, <0.000000, -1.926303, 0.353632>, <0.000000, -1.095413, 0.381731>, <0.000000, -0.472721, 0.381731>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.869778, -2.389694, 0.381731>, <0.657465, -1.806369, 0.353632>, <0.373874, -1.027210, 0.381731>, <0.161344, -0.443288, 0.381731>, 
      <0.744546, -2.434439, 0.381731>, <0.532234, -1.851115, 0.353632>, <0.350644, -1.035510, 0.381731>, <0.138113, -0.451588, 0.381731>, 
      <0.572424, -2.480560, 0.381731>, <0.464630, -1.869229, 0.353632>, <0.214089, -1.072100, 0.381731>, <0.106185, -0.460144, 0.381731>, 
      <0.441598, -2.504425, 0.381731>, <0.333804, -1.893095, 0.353632>, <0.189821, -1.076527, 0.381731>, <0.081916, -0.464571, 0.381731>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.274180, -2.206945, 0.381731>, <0.963151, -1.668227, 0.353632>, <0.547706, -0.948655, 0.381731>, <0.236360, -0.409388, 0.381731>, 
      <1.158883, -2.273511, 0.381731>, <0.847854, -1.734794, 0.353632>, <0.526319, -0.961003, 0.381731>, <0.214973, -0.421736, 0.381731>, 
      <0.995149, -2.344899, 0.381731>, <0.782836, -1.761575, 0.353632>, <0.397130, -1.018900, 0.381731>, <0.184600, -0.434979, 0.381731>, 
      <0.869778, -2.389694, 0.381731>, <0.657465, -1.806369, 0.353632>, <0.373874, -1.027210, 0.381731>, <0.161344, -0.443288, 0.381731>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.634647, -1.948097, 0.381731>, <1.235629, -1.472567, 0.353632>, <0.702653, -0.837390, 0.381731>, <0.303227, -0.361372, 0.381731>, 
      <1.533168, -2.034274, 0.381731>, <1.134150, -1.558744, 0.353632>, <0.683829, -0.853375, 0.381731>, <0.284403, -0.377358, 0.381731>, 
      <1.389477, -2.140378, 0.381731>, <1.078448, -1.601660, 0.353632>, <0.569094, -0.936307, 0.381731>, <0.257748, -0.397040, 0.381731>, 
      <1.274180, -2.206945, 0.381731>, <0.963151, -1.668227, 0.353632>, <0.547706, -0.948655, 0.381731>, <0.236360, -0.409388, 0.381731>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.948097, -1.634648, 0.381731>, <1.472566, -1.235630, 0.353632>, <0.837390, -0.702653, 0.381731>, <0.361372, -0.303227, 0.381731>, 
      <1.862016, -1.736014, 0.381731>, <1.386485, -1.336996, 0.353632>, <0.821422, -0.721457, 0.381731>, <0.345404, -0.322031, 0.381731>, 
      <1.736013, -1.862016, 0.381731>, <1.336996, -1.386485, 0.353632>, <0.721457, -0.821421, 0.381731>, <0.322031, -0.345404, 0.381731>, 
      <1.634647, -1.948097, 0.381731>, <1.235629, -1.472567, 0.353632>, <0.702653, -0.837390, 0.381731>, <0.303227, -0.361372, 0.381731>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.206945, -1.274180, 0.381731>, <1.668227, -0.963151, 0.353632>, <0.948655, -0.547706, 0.381731>, <0.409388, -0.236360, 0.381731>, 
      <2.140378, -1.389477, 0.381731>, <1.601660, -1.078448, 0.353632>, <0.936307, -0.569094, 0.381731>, <0.397040, -0.257748, 0.381731>, 
      <2.034274, -1.533169, 0.381731>, <1.558744, -1.134151, 0.353632>, <0.853375, -0.683829, 0.381731>, <0.377358, -0.284403, 0.381731>, 
      <1.948097, -1.634648, 0.381731>, <1.472566, -1.235630, 0.353632>, <0.837390, -0.702653, 0.381731>, <0.361372, -0.303227, 0.381731>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.389694, -0.869778, 0.381731>, <1.806369, -0.657465, 0.353632>, <1.027210, -0.373874, 0.381731>, <0.443288, -0.161344, 0.381731>, 
      <2.344899, -0.995149, 0.381731>, <1.761575, -0.782836, 0.353632>, <1.018900, -0.397130, 0.381731>, <0.434979, -0.184600, 0.381731>, 
      <2.273511, -1.158883, 0.381731>, <1.734794, -0.847854, 0.353632>, <0.961003, -0.526319, 0.381731>, <0.421736, -0.214973, 0.381731>, 
      <2.206945, -1.274180, 0.381731>, <1.668227, -0.963151, 0.353632>, <0.948655, -0.547706, 0.381731>, <0.409388, -0.236360, 0.381731>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.504425, -0.441598, 0.381731>, <1.893095, -0.333804, 0.353632>, <1.076527, -0.189821, 0.381731>, <0.464571, -0.081916, 0.381731>, 
      <2.480560, -0.572424, 0.381731>, <1.869229, -0.464630, 0.353632>, <1.072100, -0.214089, 0.381731>, <0.460144, -0.106185, 0.381731>, 
      <2.434439, -0.744546, 0.381731>, <1.851115, -0.532234, 0.353632>, <1.035510, -0.350644, 0.381731>, <0.451588, -0.138113, 0.381731>, 
      <2.389694, -0.869778, 0.381731>, <1.806369, -0.657465, 0.353632>, <1.027210, -0.373874, 0.381731>, <0.443288, -0.161344, 0.381731>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.548360, 0.000000, 0.381731>, <1.926303, 0.000000, 0.353632>, <1.095413, 0.000000, 0.381731>, <0.472721, 0.000000, 0.381731>, 
      <2.548360, -0.133133, 0.381731>, <1.926303, -0.133133, 0.353632>, <1.095413, -0.024696, 0.381731>, <0.472721, -0.024696, 0.381731>, 
      <2.528317, -0.310626, 0.381731>, <1.916987, -0.202832, 0.353632>, <1.080959, -0.165525, 0.381731>, <0.469003, -0.057621, 0.381731>, 
      <2.504425, -0.441598, 0.381731>, <1.893095, -0.333804, 0.353632>, <1.076527, -0.189821, 0.381731>, <0.464571, -0.081916, 0.381731>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.548360, 0.000000, 0.381731>, <2.548360, 0.133133, 0.381731>, <2.528317, 0.310625, 0.381731>, <2.504425, 0.441597, 0.381731>, 
      <1.926303, 0.000000, 0.353632>, <1.926303, 0.133133, 0.353632>, <1.916987, 0.202831, 0.353632>, <1.893095, 0.333803, 0.353632>, 
      <1.095413, 0.000000, 0.381731>, <1.095413, 0.024696, 0.381731>, <1.080959, 0.165525, 0.381731>, <1.076527, 0.189820, 0.381731>, 
      <0.472721, 0.000000, 0.381731>, <0.472721, 0.024696, 0.381731>, <0.469003, 0.057621, 0.381731>, <0.464571, 0.081916, 0.381731>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.978778, 1.084185, 0.503868>, <2.964114, 1.078848, 0.312901>, <2.569558, 0.935242, 0.390395>, <2.389694, 0.869777, 0.381731>, 
      <3.034553, 0.928083, 0.503868>, <3.019889, 0.922746, 0.312901>, <2.614303, 0.810010, 0.390395>, <2.434439, 0.744545, 0.381731>, 
      <3.092041, 0.713531, 0.503868>, <3.076674, 0.710821, 0.312902>, <2.669059, 0.605661, 0.390395>, <2.480560, 0.572423, 0.381731>, 
      <3.121790, 0.550455, 0.503868>, <3.106422, 0.547745, 0.312902>, <2.692924, 0.474834, 0.390395>, <2.504425, 0.441597, 0.381731>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.750978, 1.588277, 0.503868>, <2.737409, 1.580443, 0.312521>, <2.373042, 1.370075, 0.390395>, <2.206945, 1.274179, 0.381731>, 
      <2.833954, 1.444558, 0.503868>, <2.820385, 1.436724, 0.312521>, <2.439608, 1.254778, 0.390395>, <2.273511, 1.158882, 0.381731>, 
      <2.922940, 1.240462, 0.503868>, <2.908277, 1.235124, 0.312901>, <2.524763, 1.060613, 0.390395>, <2.344899, 0.995148, 0.381731>, 
      <2.978778, 1.084185, 0.503868>, <2.964114, 1.078848, 0.312901>, <2.569558, 0.935242, 0.390395>, <2.389694, 0.869777, 0.381731>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.428322, 2.037603, 0.503868>, <2.416368, 2.027572, 0.312902>, <2.094723, 1.757681, 0.390395>, <1.948097, 1.634647, 0.381731>, 
      <2.535743, 1.911108, 0.503868>, <2.523789, 1.901078, 0.312902>, <2.180900, 1.656202, 0.390395>, <2.034274, 1.533168, 0.381731>, 
      <2.668002, 1.731996, 0.503868>, <2.654433, 1.724161, 0.312521>, <2.306475, 1.485372, 0.390395>, <2.140378, 1.389476, 0.381731>, 
      <2.750978, 1.588277, 0.503868>, <2.737409, 1.580443, 0.312521>, <2.373042, 1.370075, 0.390395>, <2.206945, 1.274179, 0.381731>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.037604, 2.428321, 0.503868>, <2.027574, 2.416367, 0.312902>, <1.757682, 2.094722, 0.390395>, <1.634648, 1.948096, 0.381731>, 
      <2.163958, 2.321020, 0.503868>, <2.153928, 2.309066, 0.312902>, <1.859048, 2.008641, 0.390395>, <1.736014, 1.862015, 0.381731>, 
      <2.321021, 2.163957, 0.503868>, <2.309067, 2.153927, 0.312902>, <2.008642, 1.859047, 0.390395>, <1.862016, 1.736013, 0.381731>, 
      <2.428322, 2.037603, 0.503868>, <2.416368, 2.027572, 0.312902>, <2.094723, 1.757681, 0.390395>, <1.948097, 1.634647, 0.381731>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.588278, 2.750978, 0.503868>, <1.580444, 2.737409, 0.312521>, <1.370076, 2.373042, 0.390395>, <1.274180, 2.206945, 0.381731>, 
      <1.731997, 2.668002, 0.503868>, <1.724163, 2.654433, 0.312521>, <1.485373, 2.306475, 0.390395>, <1.389477, 2.140378, 0.381731>, 
      <1.911109, 2.535742, 0.503868>, <1.901079, 2.523788, 0.312902>, <1.656203, 2.180899, 0.390395>, <1.533169, 2.034273, 0.381731>, 
      <2.037604, 2.428321, 0.503868>, <2.027574, 2.416367, 0.312902>, <1.757682, 2.094722, 0.390395>, <1.634648, 1.948096, 0.381731>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.084187, 2.978777, 0.503868>, <1.078850, 2.964113, 0.312902>, <0.935243, 2.569558, 0.390395>, <0.869778, 2.389694, 0.381731>, 
      <1.240463, 2.922940, 0.503868>, <1.235126, 2.908276, 0.312902>, <1.060614, 2.524763, 0.390395>, <0.995149, 2.344899, 0.381731>, 
      <1.444560, 2.833954, 0.503868>, <1.436725, 2.820385, 0.312521>, <1.254779, 2.439608, 0.390395>, <1.158883, 2.273512, 0.381731>, 
      <1.588278, 2.750978, 0.503868>, <1.580444, 2.737409, 0.312521>, <1.370076, 2.373042, 0.390395>, <1.274180, 2.206945, 0.381731>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.550456, 3.121790, 0.503868>, <0.547746, 3.106422, 0.312902>, <0.474836, 2.692924, 0.390395>, <0.441598, 2.504425, 0.381731>, 
      <0.713533, 3.092041, 0.503868>, <0.710823, 3.076674, 0.312902>, <0.605662, 2.669059, 0.390395>, <0.572424, 2.480560, 0.381731>, 
      <0.928084, 3.034552, 0.503868>, <0.922747, 3.019888, 0.312902>, <0.810011, 2.614303, 0.390395>, <0.744546, 2.434439, 0.381731>, 
      <1.084187, 2.978777, 0.503868>, <1.078850, 2.964113, 0.312902>, <0.935243, 2.569558, 0.390395>, <0.869778, 2.389694, 0.381731>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 3.176556, 0.503868>, <0.000000, 3.160888, 0.312521>, <0.000000, 2.740152, 0.390395>, <0.000000, 2.548360, 0.381731>, 
      <0.165952, 3.176556, 0.503868>, <0.165952, 3.160888, 0.312521>, <0.133133, 2.740152, 0.390395>, <0.133133, 2.548360, 0.381731>, 
      <0.387198, 3.151572, 0.503868>, <0.384488, 3.136204, 0.312902>, <0.343863, 2.716816, 0.390395>, <0.310626, 2.528317, 0.381731>, 
      <0.550456, 3.121790, 0.503868>, <0.547746, 3.106422, 0.312902>, <0.474836, 2.692924, 0.390395>, <0.441598, 2.504425, 0.381731>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.550455, 3.121790, 0.503868>, <-0.547745, 3.106422, 0.312902>, <-0.474834, 2.692924, 0.390395>, <-0.441597, 2.504425, 0.381731>, 
      <-0.387197, 3.151572, 0.503868>, <-0.384488, 3.136204, 0.312902>, <-0.343863, 2.716816, 0.390395>, <-0.310625, 2.528317, 0.381731>, 
      <-0.165952, 3.176556, 0.503868>, <-0.165952, 3.160888, 0.312521>, <-0.133133, 2.740152, 0.390395>, <-0.133133, 2.548360, 0.381731>, 
      <0.000000, 3.176556, 0.503868>, <0.000000, 3.160888, 0.312521>, <0.000000, 2.740152, 0.390395>, <0.000000, 2.548360, 0.381731>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.084186, 2.978778, 0.503868>, <-1.078849, 2.964114, 0.312901>, <-0.935242, 2.569558, 0.390395>, <-0.869777, 2.389694, 0.381731>, 
      <-0.928083, 3.034553, 0.503868>, <-0.922746, 3.019889, 0.312901>, <-0.810010, 2.614303, 0.390395>, <-0.744545, 2.434439, 0.381731>, 
      <-0.713531, 3.092041, 0.503868>, <-0.710822, 3.076674, 0.312902>, <-0.605661, 2.669059, 0.390395>, <-0.572423, 2.480560, 0.381731>, 
      <-0.550455, 3.121790, 0.503868>, <-0.547745, 3.106422, 0.312902>, <-0.474834, 2.692924, 0.390395>, <-0.441597, 2.504425, 0.381731>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.588277, 2.750978, 0.503868>, <-1.580443, 2.737409, 0.312521>, <-1.370076, 2.373042, 0.390395>, <-1.274180, 2.206945, 0.381731>, 
      <-1.444558, 2.833954, 0.503868>, <-1.436724, 2.820385, 0.312521>, <-1.254779, 2.439608, 0.390395>, <-1.158883, 2.273512, 0.381731>, 
      <-1.240462, 2.922941, 0.503868>, <-1.235125, 2.908277, 0.312901>, <-1.060613, 2.524763, 0.390395>, <-0.995148, 2.344899, 0.381731>, 
      <-1.084186, 2.978778, 0.503868>, <-1.078849, 2.964114, 0.312901>, <-0.935242, 2.569558, 0.390395>, <-0.869777, 2.389694, 0.381731>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.037603, 2.428322, 0.503868>, <-2.027572, 2.416368, 0.312902>, <-1.757681, 2.094723, 0.390395>, <-1.634647, 1.948097, 0.381731>, 
      <-1.911108, 2.535743, 0.503868>, <-1.901078, 2.523789, 0.312902>, <-1.656202, 2.180900, 0.390395>, <-1.533168, 2.034274, 0.381731>, 
      <-1.731996, 2.668002, 0.503868>, <-1.724161, 2.654433, 0.312521>, <-1.485373, 2.306475, 0.390395>, <-1.389477, 2.140378, 0.381731>, 
      <-1.588277, 2.750978, 0.503868>, <-1.580443, 2.737409, 0.312521>, <-1.370076, 2.373042, 0.390395>, <-1.274180, 2.206945, 0.381731>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.428321, 2.037604, 0.503868>, <-2.416367, 2.027574, 0.312902>, <-2.094723, 1.757682, 0.390395>, <-1.948097, 1.634648, 0.381731>, 
      <-2.321020, 2.163958, 0.503868>, <-2.309066, 2.153928, 0.312902>, <-2.008642, 1.859048, 0.390395>, <-1.862016, 1.736014, 0.381731>, 
      <-2.163957, 2.321021, 0.503868>, <-2.153927, 2.309067, 0.312902>, <-1.859047, 2.008642, 0.390395>, <-1.736013, 1.862016, 0.381731>, 
      <-2.037603, 2.428322, 0.503868>, <-2.027572, 2.416368, 0.312902>, <-1.757681, 2.094723, 0.390395>, <-1.634647, 1.948097, 0.381731>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.750978, 1.588278, 0.503868>, <-2.737409, 1.580444, 0.312521>, <-2.373042, 1.370077, 0.390395>, <-2.206945, 1.274181, 0.381731>, 
      <-2.668002, 1.731997, 0.503868>, <-2.654433, 1.724163, 0.312521>, <-2.306475, 1.485374, 0.390395>, <-2.140378, 1.389478, 0.381731>, 
      <-2.535742, 1.911109, 0.503868>, <-2.523788, 1.901079, 0.312902>, <-2.180900, 1.656203, 0.390395>, <-2.034274, 1.533169, 0.381731>, 
      <-2.428321, 2.037604, 0.503868>, <-2.416367, 2.027574, 0.312902>, <-2.094723, 1.757682, 0.390395>, <-1.948097, 1.634648, 0.381731>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.978777, 1.084186, 0.503868>, <-2.964113, 1.078849, 0.312902>, <-2.569557, 0.935243, 0.390395>, <-2.389694, 0.869778, 0.381731>, 
      <-2.922940, 1.240462, 0.503868>, <-2.908276, 1.235125, 0.312902>, <-2.524763, 1.060614, 0.390395>, <-2.344899, 0.995149, 0.381731>, 
      <-2.833954, 1.444559, 0.503868>, <-2.820385, 1.436725, 0.312521>, <-2.439608, 1.254780, 0.390395>, <-2.273512, 1.158884, 0.381731>, 
      <-2.750978, 1.588278, 0.503868>, <-2.737409, 1.580444, 0.312521>, <-2.373042, 1.370077, 0.390395>, <-2.206945, 1.274181, 0.381731>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.121790, 0.550456, 0.503868>, <-3.106422, 0.547746, 0.312902>, <-2.692924, 0.474836, 0.390395>, <-2.504425, 0.441598, 0.381731>, 
      <-3.092041, 0.713532, 0.503868>, <-3.076674, 0.710823, 0.312902>, <-2.669059, 0.605662, 0.390395>, <-2.480560, 0.572424, 0.381731>, 
      <-3.034552, 0.928083, 0.503868>, <-3.019888, 0.922746, 0.312902>, <-2.614302, 0.810011, 0.390395>, <-2.434439, 0.744546, 0.381731>, 
      <-2.978777, 1.084186, 0.503868>, <-2.964113, 1.078849, 0.312902>, <-2.569557, 0.935243, 0.390395>, <-2.389694, 0.869778, 0.381731>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.176556, 0.000000, 0.503868>, <-3.160888, 0.000000, 0.312521>, <-2.740152, 0.000000, 0.390395>, <-2.548360, 0.000000, 0.381731>, 
      <-3.176556, 0.165952, 0.503868>, <-3.160888, 0.165952, 0.312521>, <-2.740152, 0.133133, 0.390395>, <-2.548360, 0.133133, 0.381731>, 
      <-3.151572, 0.387198, 0.503868>, <-3.136204, 0.384488, 0.312902>, <-2.716816, 0.343863, 0.390395>, <-2.528317, 0.310626, 0.381731>, 
      <-3.121790, 0.550456, 0.503868>, <-3.106422, 0.547746, 0.312902>, <-2.692924, 0.474836, 0.390395>, <-2.504425, 0.441598, 0.381731>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.121790, -0.550455, 0.503868>, <-3.106422, -0.547745, 0.312902>, <-2.692924, -0.474834, 0.390395>, <-2.504425, -0.441597, 0.381731>, 
      <-3.151572, -0.387197, 0.503868>, <-3.136204, -0.384488, 0.312902>, <-2.716816, -0.343863, 0.390395>, <-2.528317, -0.310625, 0.381731>, 
      <-3.176556, -0.165952, 0.503868>, <-3.160888, -0.165952, 0.312521>, <-2.740152, -0.133133, 0.390395>, <-2.548360, -0.133133, 0.381731>, 
      <-3.176556, 0.000000, 0.503868>, <-3.160888, 0.000000, 0.312521>, <-2.740152, 0.000000, 0.390395>, <-2.548360, 0.000000, 0.381731>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.978778, -1.084186, 0.503868>, <-2.964114, -1.078849, 0.312901>, <-2.569558, -0.935242, 0.390395>, <-2.389694, -0.869777, 0.381731>, 
      <-3.034553, -0.928083, 0.503868>, <-3.019889, -0.922746, 0.312901>, <-2.614303, -0.810010, 0.390395>, <-2.434439, -0.744545, 0.381731>, 
      <-3.092041, -0.713531, 0.503868>, <-3.076674, -0.710822, 0.312902>, <-2.669059, -0.605661, 0.390395>, <-2.480560, -0.572423, 0.381731>, 
      <-3.121790, -0.550455, 0.503868>, <-3.106422, -0.547745, 0.312902>, <-2.692924, -0.474834, 0.390395>, <-2.504425, -0.441597, 0.381731>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.750978, -1.588278, 0.503868>, <-2.737409, -1.580444, 0.312521>, <-2.373042, -1.370076, 0.390395>, <-2.206945, -1.274180, 0.381731>, 
      <-2.833954, -1.444559, 0.503868>, <-2.820385, -1.436725, 0.312521>, <-2.439608, -1.254779, 0.390395>, <-2.273511, -1.158883, 0.381731>, 
      <-2.922941, -1.240463, 0.503868>, <-2.908277, -1.235125, 0.312901>, <-2.524763, -1.060613, 0.390395>, <-2.344899, -0.995148, 0.381731>, 
      <-2.978778, -1.084186, 0.503868>, <-2.964114, -1.078849, 0.312901>, <-2.569558, -0.935242, 0.390395>, <-2.389694, -0.869777, 0.381731>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.428322, -2.037604, 0.503868>, <-2.416368, -2.027574, 0.312902>, <-2.094723, -1.757682, 0.390395>, <-1.948097, -1.634648, 0.381731>, 
      <-2.535743, -1.911110, 0.503868>, <-2.523789, -1.901079, 0.312902>, <-2.180900, -1.656203, 0.390395>, <-2.034274, -1.533169, 0.381731>, 
      <-2.668002, -1.731997, 0.503868>, <-2.654433, -1.724163, 0.312521>, <-2.306475, -1.485373, 0.390395>, <-2.140378, -1.389477, 0.381731>, 
      <-2.750978, -1.588278, 0.503868>, <-2.737409, -1.580444, 0.312521>, <-2.373042, -1.370076, 0.390395>, <-2.206945, -1.274180, 0.381731>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.037604, -2.428321, 0.503868>, <-2.027574, -2.416367, 0.312902>, <-1.757682, -2.094723, 0.390395>, <-1.634648, -1.948097, 0.381731>, 
      <-2.163958, -2.321020, 0.503868>, <-2.153928, -2.309066, 0.312902>, <-1.859048, -2.008642, 0.390395>, <-1.736014, -1.862016, 0.381731>, 
      <-2.321021, -2.163958, 0.503868>, <-2.309067, -2.153928, 0.312902>, <-2.008642, -1.859048, 0.390395>, <-1.862016, -1.736014, 0.381731>, 
      <-2.428322, -2.037604, 0.503868>, <-2.416368, -2.027574, 0.312902>, <-2.094723, -1.757682, 0.390395>, <-1.948097, -1.634648, 0.381731>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.588278, -2.750978, 0.503868>, <-1.580444, -2.737409, 0.312521>, <-1.370076, -2.373042, 0.390395>, <-1.274180, -2.206945, 0.381731>, 
      <-1.731997, -2.668002, 0.503868>, <-1.724163, -2.654433, 0.312521>, <-1.485373, -2.306475, 0.390395>, <-1.389477, -2.140378, 0.381731>, 
      <-1.911109, -2.535742, 0.503868>, <-1.901079, -2.523788, 0.312902>, <-1.656203, -2.180900, 0.390395>, <-1.533169, -2.034274, 0.381731>, 
      <-2.037604, -2.428321, 0.503868>, <-2.027574, -2.416367, 0.312902>, <-1.757682, -2.094723, 0.390395>, <-1.634648, -1.948097, 0.381731>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.084186, -2.978777, 0.503868>, <-1.078849, -2.964113, 0.312902>, <-0.935243, -2.569557, 0.390395>, <-0.869778, -2.389694, 0.381731>, 
      <-1.240462, -2.922940, 0.503868>, <-1.235125, -2.908276, 0.312902>, <-1.060614, -2.524763, 0.390395>, <-0.995149, -2.344899, 0.381731>, 
      <-1.444559, -2.833954, 0.503868>, <-1.436725, -2.820385, 0.312521>, <-1.254779, -2.439608, 0.390395>, <-1.158883, -2.273511, 0.381731>, 
      <-1.588278, -2.750978, 0.503868>, <-1.580444, -2.737409, 0.312521>, <-1.370076, -2.373042, 0.390395>, <-1.274180, -2.206945, 0.381731>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.550456, -3.121790, 0.503868>, <-0.547746, -3.106422, 0.312902>, <-0.474836, -2.692924, 0.390395>, <-0.441598, -2.504425, 0.381731>, 
      <-0.713532, -3.092041, 0.503868>, <-0.710823, -3.076674, 0.312902>, <-0.605662, -2.669059, 0.390395>, <-0.572424, -2.480560, 0.381731>, 
      <-0.928083, -3.034552, 0.503868>, <-0.922746, -3.019888, 0.312902>, <-0.810011, -2.614303, 0.390395>, <-0.744546, -2.434439, 0.381731>, 
      <-1.084186, -2.978777, 0.503868>, <-1.078849, -2.964113, 0.312902>, <-0.935243, -2.569557, 0.390395>, <-0.869778, -2.389694, 0.381731>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -3.176556, 0.503868>, <0.000000, -3.160888, 0.312521>, <0.000000, -2.740152, 0.390395>, <0.000000, -2.548360, 0.381731>, 
      <-0.165952, -3.176556, 0.503868>, <-0.165952, -3.160888, 0.312521>, <-0.133133, -2.740152, 0.390395>, <-0.133133, -2.548360, 0.381731>, 
      <-0.387198, -3.151572, 0.503868>, <-0.384488, -3.136204, 0.312902>, <-0.343863, -2.716816, 0.390395>, <-0.310626, -2.528317, 0.381731>, 
      <-0.550456, -3.121790, 0.503868>, <-0.547746, -3.106422, 0.312902>, <-0.474836, -2.692924, 0.390395>, <-0.441598, -2.504425, 0.381731>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.550456, -3.121790, 0.503868>, <0.547746, -3.106422, 0.312902>, <0.474836, -2.692924, 0.390395>, <0.441598, -2.504425, 0.381731>, 
      <0.387198, -3.151572, 0.503868>, <0.384488, -3.136204, 0.312902>, <0.343863, -2.716816, 0.390395>, <0.310626, -2.528317, 0.381731>, 
      <0.165952, -3.176556, 0.503868>, <0.165952, -3.160888, 0.312521>, <0.133133, -2.740152, 0.390395>, <0.133133, -2.548360, 0.381731>, 
      <0.000000, -3.176556, 0.503868>, <0.000000, -3.160888, 0.312521>, <0.000000, -2.740152, 0.390395>, <0.000000, -2.548360, 0.381731>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.084186, -2.978777, 0.503868>, <1.078849, -2.964113, 0.312902>, <0.935243, -2.569557, 0.390395>, <0.869778, -2.389694, 0.381731>, 
      <0.928083, -3.034552, 0.503868>, <0.922746, -3.019888, 0.312902>, <0.810011, -2.614303, 0.390395>, <0.744546, -2.434439, 0.381731>, 
      <0.713532, -3.092041, 0.503868>, <0.710823, -3.076674, 0.312902>, <0.605662, -2.669059, 0.390395>, <0.572424, -2.480560, 0.381731>, 
      <0.550456, -3.121790, 0.503868>, <0.547746, -3.106422, 0.312902>, <0.474836, -2.692924, 0.390395>, <0.441598, -2.504425, 0.381731>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.588278, -2.750978, 0.503868>, <1.580444, -2.737409, 0.312521>, <1.370076, -2.373042, 0.390395>, <1.274180, -2.206945, 0.381731>, 
      <1.444559, -2.833954, 0.503868>, <1.436725, -2.820385, 0.312521>, <1.254779, -2.439608, 0.390395>, <1.158883, -2.273511, 0.381731>, 
      <1.240462, -2.922940, 0.503868>, <1.235125, -2.908276, 0.312902>, <1.060614, -2.524763, 0.390395>, <0.995149, -2.344899, 0.381731>, 
      <1.084186, -2.978777, 0.503868>, <1.078849, -2.964113, 0.312902>, <0.935243, -2.569557, 0.390395>, <0.869778, -2.389694, 0.381731>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.037604, -2.428321, 0.503868>, <2.027574, -2.416367, 0.312902>, <1.757681, -2.094723, 0.390395>, <1.634647, -1.948097, 0.381731>, 
      <1.911109, -2.535742, 0.503868>, <1.901079, -2.523788, 0.312902>, <1.656202, -2.180900, 0.390395>, <1.533168, -2.034274, 0.381731>, 
      <1.731997, -2.668002, 0.503868>, <1.724163, -2.654433, 0.312521>, <1.485373, -2.306475, 0.390395>, <1.389477, -2.140378, 0.381731>, 
      <1.588278, -2.750978, 0.503868>, <1.580444, -2.737409, 0.312521>, <1.370076, -2.373042, 0.390395>, <1.274180, -2.206945, 0.381731>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.428321, -2.037604, 0.503868>, <2.416367, -2.027574, 0.312902>, <2.094723, -1.757682, 0.390395>, <1.948097, -1.634648, 0.381731>, 
      <2.321020, -2.163958, 0.503868>, <2.309066, -2.153927, 0.312902>, <2.008642, -1.859048, 0.390395>, <1.862016, -1.736014, 0.381731>, 
      <2.163958, -2.321020, 0.503868>, <2.153927, -2.309066, 0.312902>, <1.859047, -2.008642, 0.390395>, <1.736013, -1.862016, 0.381731>, 
      <2.037604, -2.428321, 0.503868>, <2.027574, -2.416367, 0.312902>, <1.757681, -2.094723, 0.390395>, <1.634647, -1.948097, 0.381731>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.750978, -1.588278, 0.503868>, <2.737409, -1.580444, 0.312521>, <2.373042, -1.370076, 0.390395>, <2.206945, -1.274180, 0.381731>, 
      <2.668002, -1.731997, 0.503868>, <2.654433, -1.724163, 0.312521>, <2.306475, -1.485373, 0.390395>, <2.140378, -1.389477, 0.381731>, 
      <2.535742, -1.911109, 0.503868>, <2.523788, -1.901079, 0.312902>, <2.180900, -1.656203, 0.390395>, <2.034274, -1.533169, 0.381731>, 
      <2.428321, -2.037604, 0.503868>, <2.416367, -2.027574, 0.312902>, <2.094723, -1.757682, 0.390395>, <1.948097, -1.634648, 0.381731>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.978777, -1.084186, 0.503868>, <2.964113, -1.078849, 0.312902>, <2.569557, -0.935243, 0.390395>, <2.389694, -0.869778, 0.381731>, 
      <2.922940, -1.240462, 0.503868>, <2.908276, -1.235125, 0.312902>, <2.524763, -1.060614, 0.390395>, <2.344899, -0.995149, 0.381731>, 
      <2.833954, -1.444559, 0.503868>, <2.820385, -1.436725, 0.312521>, <2.439608, -1.254779, 0.390395>, <2.273511, -1.158883, 0.381731>, 
      <2.750978, -1.588278, 0.503868>, <2.737409, -1.580444, 0.312521>, <2.373042, -1.370076, 0.390395>, <2.206945, -1.274180, 0.381731>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.121790, -0.550456, 0.503868>, <3.106422, -0.547746, 0.312902>, <2.692924, -0.474836, 0.390395>, <2.504425, -0.441598, 0.381731>, 
      <3.092041, -0.713532, 0.503868>, <3.076674, -0.710823, 0.312902>, <2.669059, -0.605662, 0.390395>, <2.480560, -0.572424, 0.381731>, 
      <3.034552, -0.928083, 0.503868>, <3.019888, -0.922746, 0.312902>, <2.614303, -0.810011, 0.390395>, <2.434439, -0.744546, 0.381731>, 
      <2.978777, -1.084186, 0.503868>, <2.964113, -1.078849, 0.312902>, <2.569557, -0.935243, 0.390395>, <2.389694, -0.869778, 0.381731>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.176556, 0.000000, 0.503868>, <3.160888, 0.000000, 0.312521>, <2.740152, 0.000000, 0.390395>, <2.548360, 0.000000, 0.381731>, 
      <3.176556, -0.165952, 0.503868>, <3.160888, -0.165952, 0.312521>, <2.740152, -0.133133, 0.390395>, <2.548360, -0.133133, 0.381731>, 
      <3.151572, -0.387198, 0.503868>, <3.136204, -0.384488, 0.312902>, <2.716816, -0.343863, 0.390395>, <2.528317, -0.310626, 0.381731>, 
      <3.121790, -0.550456, 0.503868>, <3.106422, -0.547746, 0.312902>, <2.692924, -0.474836, 0.390395>, <2.504425, -0.441598, 0.381731>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.176556, 0.000000, 0.503868>, <3.176556, 0.165952, 0.503868>, <3.151572, 0.387197, 0.503868>, <3.121790, 0.550455, 0.503868>, 
      <3.160888, 0.000000, 0.312521>, <3.160888, 0.165952, 0.312521>, <3.136204, 0.384488, 0.312902>, <3.106422, 0.547745, 0.312902>, 
      <2.740152, 0.000000, 0.390395>, <2.740152, 0.133133, 0.390395>, <2.716816, 0.343863, 0.390395>, <2.692924, 0.474834, 0.390395>, 
      <2.548360, 0.000000, 0.381731>, <2.548360, 0.133133, 0.381731>, <2.528317, 0.310625, 0.381731>, <2.504425, 0.441597, 0.381731>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.232181, 1.176417, 11.353526>, <3.070375, 1.117524, 8.102179>, <3.227957, 1.174879, 3.748955>, <2.978778, 1.084185, 0.503868>, 
      <3.292701, 1.007035, 11.353526>, <3.130894, 0.948142, 8.102179>, <3.283732, 1.018776, 3.748955>, <3.034553, 0.928083, 0.503868>, 
      <3.355080, 0.774231, 11.353526>, <3.185505, 0.744331, 8.102181>, <3.353184, 0.759578, 3.748954>, <3.092041, 0.713531, 0.503868>, 
      <3.387359, 0.597282, 11.353526>, <3.217784, 0.567381, 8.102181>, <3.382932, 0.596501, 3.748954>, <3.121790, 0.550455, 0.503868>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.985003, 1.723391, 11.353526>, <2.835571, 1.637117, 8.102194>, <2.981098, 1.721137, 3.748914>, <2.750978, 1.588277, 0.503868>, 
      <3.075038, 1.567447, 11.353526>, <2.925606, 1.481172, 8.102194>, <3.064075, 1.577418, 3.748914>, <2.833954, 1.444558, 0.503868>, 
      <3.171594, 1.345988, 11.353526>, <3.009788, 1.287095, 8.102179>, <3.172120, 1.331155, 3.748955>, <2.922940, 1.240462, 0.503868>, 
      <3.232181, 1.176417, 11.353526>, <3.070375, 1.117524, 8.102179>, <3.227957, 1.174879, 3.748955>, <2.978778, 1.084185, 0.503868>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.634898, 2.210941, 11.353526>, <2.502992, 2.100259, 8.102181>, <2.631455, 2.208051, 3.748954>, <2.428322, 2.037603, 0.503868>, 
      <2.751457, 2.073686, 11.353526>, <2.619551, 1.963004, 8.102181>, <2.738875, 2.081557, 3.748954>, <2.535743, 1.911108, 0.503868>, 
      <2.894968, 1.879336, 11.353526>, <2.745537, 1.793061, 8.102194>, <2.898123, 1.864856, 3.748914>, <2.668002, 1.731996, 0.503868>, 
      <2.985003, 1.723391, 11.353526>, <2.835571, 1.637117, 8.102194>, <2.981098, 1.721137, 3.748914>, <2.750978, 1.588277, 0.503868>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.210942, 2.634897, 11.353526>, <2.100260, 2.502991, 8.102181>, <2.208052, 2.631454, 3.748954>, <2.037604, 2.428321, 0.503868>, 
      <2.348045, 2.518468, 11.353526>, <2.237363, 2.386562, 8.102181>, <2.334406, 2.524152, 3.748954>, <2.163958, 2.321020, 0.503868>, 
      <2.518469, 2.348044, 11.353526>, <2.386563, 2.237362, 8.102181>, <2.524153, 2.334405, 3.748954>, <2.321021, 2.163957, 0.503868>, 
      <2.634898, 2.210941, 11.353526>, <2.502992, 2.100259, 8.102181>, <2.631455, 2.208051, 3.748954>, <2.428322, 2.037603, 0.503868>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.723392, 2.985003, 11.353526>, <1.637118, 2.835571, 8.102194>, <1.721138, 2.981098, 3.748914>, <1.588278, 2.750978, 0.503868>, 
      <1.879337, 2.894968, 11.353526>, <1.793063, 2.745536, 8.102194>, <1.864857, 2.898122, 3.748914>, <1.731997, 2.668002, 0.503868>, 
      <2.073686, 2.751456, 11.353526>, <1.963004, 2.619550, 8.102181>, <2.081558, 2.738874, 3.748954>, <1.911109, 2.535742, 0.503868>, 
      <2.210942, 2.634897, 11.353526>, <2.100260, 2.502991, 8.102181>, <2.208052, 2.631454, 3.748954>, <2.037604, 2.428321, 0.503868>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.176418, 3.232180, 11.353526>, <1.117525, 3.070374, 8.102181>, <1.174881, 3.227956, 3.748954>, <1.084187, 2.978777, 0.503868>, 
      <1.345988, 3.171593, 11.353526>, <1.287096, 3.009786, 8.102181>, <1.331157, 3.172119, 3.748954>, <1.240463, 2.922940, 0.503868>, 
      <1.567447, 3.075038, 11.353526>, <1.481173, 2.925606, 8.102194>, <1.577420, 3.064074, 3.748914>, <1.444560, 2.833954, 0.503868>, 
      <1.723392, 2.985003, 11.353526>, <1.637118, 2.835571, 8.102194>, <1.721138, 2.981098, 3.748914>, <1.588278, 2.750978, 0.503868>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.597283, 3.387359, 11.353526>, <0.567382, 3.217784, 8.102181>, <0.596502, 3.382932, 3.748954>, <0.550456, 3.121790, 0.503868>, 
      <0.774232, 3.355080, 11.353526>, <0.744332, 3.185505, 8.102181>, <0.759579, 3.353183, 3.748954>, <0.713533, 3.092041, 0.503868>, 
      <1.007036, 3.292700, 11.353526>, <0.948143, 3.130893, 8.102181>, <1.018778, 3.283731, 3.748954>, <0.928084, 3.034552, 0.503868>, 
      <1.176418, 3.232180, 11.353526>, <1.117525, 3.070374, 8.102181>, <1.174881, 3.227956, 3.748954>, <1.084187, 2.978777, 0.503868>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 3.446784, 11.353526>, <0.000000, 3.274235, 8.102194>, <0.000000, 3.442276, 3.748914>, <0.000000, 3.176556, 0.503868>, 
      <0.180070, 3.446784, 11.353526>, <0.180070, 3.274235, 8.102194>, <0.165952, 3.442276, 3.748914>, <0.165952, 3.176556, 0.503868>, 
      <0.420137, 3.419674, 11.353526>, <0.390236, 3.250099, 8.102181>, <0.433244, 3.412714, 3.748954>, <0.387198, 3.151572, 0.503868>, 
      <0.597283, 3.387359, 11.353526>, <0.567382, 3.217784, 8.102181>, <0.596502, 3.382932, 3.748954>, <0.550456, 3.121790, 0.503868>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.597282, 3.387359, 11.353526>, <-0.567381, 3.217784, 8.102181>, <-0.596501, 3.382932, 3.748954>, <-0.550455, 3.121790, 0.503868>, 
      <-0.420136, 3.419674, 11.353526>, <-0.390235, 3.250099, 8.102181>, <-0.433244, 3.412714, 3.748954>, <-0.387197, 3.151572, 0.503868>, 
      <-0.180069, 3.446784, 11.353526>, <-0.180069, 3.274235, 8.102194>, <-0.165952, 3.442276, 3.748914>, <-0.165952, 3.176556, 0.503868>, 
      <0.000000, 3.446784, 11.353526>, <0.000000, 3.274235, 8.102194>, <0.000000, 3.442276, 3.748914>, <0.000000, 3.176556, 0.503868>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.176417, 3.232181, 11.353526>, <-1.117524, 3.070375, 8.102181>, <-1.174880, 3.227957, 3.748954>, <-1.084186, 2.978778, 0.503868>, 
      <-1.007035, 3.292701, 11.353526>, <-0.948142, 3.130894, 8.102181>, <-1.018777, 3.283732, 3.748954>, <-0.928083, 3.034553, 0.503868>, 
      <-0.774231, 3.355080, 11.353526>, <-0.744330, 3.185505, 8.102181>, <-0.759578, 3.353183, 3.748954>, <-0.713531, 3.092041, 0.503868>, 
      <-0.597282, 3.387359, 11.353526>, <-0.567381, 3.217784, 8.102181>, <-0.596501, 3.382932, 3.748954>, <-0.550455, 3.121790, 0.503868>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.723392, 2.985003, 11.353526>, <-1.637117, 2.835571, 8.102194>, <-1.721137, 2.981098, 3.748914>, <-1.588277, 2.750978, 0.503868>, 
      <-1.567447, 3.075038, 11.353526>, <-1.481172, 2.925606, 8.102194>, <-1.577418, 3.064075, 3.748914>, <-1.444558, 2.833954, 0.503868>, 
      <-1.345988, 3.171594, 11.353526>, <-1.287095, 3.009788, 8.102181>, <-1.331156, 3.172120, 3.748954>, <-1.240462, 2.922941, 0.503868>, 
      <-1.176417, 3.232181, 11.353526>, <-1.117524, 3.070375, 8.102181>, <-1.174880, 3.227957, 3.748954>, <-1.084186, 2.978778, 0.503868>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.210941, 2.634898, 11.353526>, <-2.100259, 2.502992, 8.102181>, <-2.208051, 2.631455, 3.748954>, <-2.037603, 2.428322, 0.503868>, 
      <-2.073686, 2.751457, 11.353526>, <-1.963004, 2.619551, 8.102181>, <-2.081557, 2.738875, 3.748954>, <-1.911108, 2.535743, 0.503868>, 
      <-1.879337, 2.894968, 11.353526>, <-1.793062, 2.745537, 8.102194>, <-1.864856, 2.898122, 3.748914>, <-1.731996, 2.668002, 0.503868>, 
      <-1.723392, 2.985003, 11.353526>, <-1.637117, 2.835571, 8.102194>, <-1.721137, 2.981098, 3.748914>, <-1.588277, 2.750978, 0.503868>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.634897, 2.210942, 11.353526>, <-2.502991, 2.100260, 8.102181>, <-2.631453, 2.208052, 3.748954>, <-2.428321, 2.037604, 0.503868>, 
      <-2.518468, 2.348045, 11.353526>, <-2.386562, 2.237363, 8.102181>, <-2.524152, 2.334406, 3.748954>, <-2.321020, 2.163958, 0.503868>, 
      <-2.348044, 2.518469, 11.353526>, <-2.237362, 2.386563, 8.102181>, <-2.334405, 2.524153, 3.748954>, <-2.163957, 2.321021, 0.503868>, 
      <-2.210941, 2.634898, 11.353526>, <-2.100259, 2.502992, 8.102181>, <-2.208051, 2.631455, 3.748954>, <-2.037603, 2.428322, 0.503868>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.985002, 1.723392, 11.353526>, <-2.835570, 1.637118, 8.102194>, <-2.981098, 1.721138, 3.748914>, <-2.750978, 1.588278, 0.503868>, 
      <-2.894967, 1.879337, 11.353526>, <-2.745536, 1.793062, 8.102194>, <-2.898122, 1.864857, 3.748914>, <-2.668002, 1.731997, 0.503868>, 
      <-2.751456, 2.073687, 11.353526>, <-2.619550, 1.963004, 8.102181>, <-2.738874, 2.081558, 3.748954>, <-2.535742, 1.911109, 0.503868>, 
      <-2.634897, 2.210942, 11.353526>, <-2.502991, 2.100260, 8.102181>, <-2.631453, 2.208052, 3.748954>, <-2.428321, 2.037604, 0.503868>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.232180, 1.176418, 11.353526>, <-3.070374, 1.117525, 8.102179>, <-3.227956, 1.174880, 3.748955>, <-2.978777, 1.084186, 0.503868>, 
      <-3.171593, 1.345989, 11.353526>, <-3.009786, 1.287095, 8.102179>, <-3.172119, 1.331156, 3.748955>, <-2.922940, 1.240462, 0.503868>, 
      <-3.075037, 1.567447, 11.353526>, <-2.925605, 1.481173, 8.102194>, <-3.064074, 1.577419, 3.748914>, <-2.833954, 1.444559, 0.503868>, 
      <-2.985002, 1.723392, 11.353526>, <-2.835570, 1.637118, 8.102194>, <-2.981098, 1.721138, 3.748914>, <-2.750978, 1.588278, 0.503868>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.387359, 0.597283, 11.353526>, <-3.217784, 0.567383, 8.102181>, <-3.382932, 0.596502, 3.748954>, <-3.121790, 0.550456, 0.503868>, 
      <-3.355080, 0.774232, 11.353526>, <-3.185505, 0.744332, 8.102181>, <-3.353183, 0.759579, 3.748954>, <-3.092041, 0.713532, 0.503868>, 
      <-3.292700, 1.007036, 11.353526>, <-3.130893, 0.948143, 8.102179>, <-3.283731, 1.018777, 3.748955>, <-3.034552, 0.928083, 0.503868>, 
      <-3.232180, 1.176418, 11.353526>, <-3.070374, 1.117525, 8.102179>, <-3.227956, 1.174880, 3.748955>, <-2.978777, 1.084186, 0.503868>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.446784, 0.000000, 11.353526>, <-3.274235, 0.000000, 8.102194>, <-3.442276, 0.000000, 3.748914>, <-3.176556, 0.000000, 0.503868>, 
      <-3.446784, 0.180070, 11.353526>, <-3.274235, 0.180070, 8.102194>, <-3.442276, 0.165952, 3.748914>, <-3.176556, 0.165952, 0.503868>, 
      <-3.419674, 0.420137, 11.353526>, <-3.250099, 0.390236, 8.102181>, <-3.412714, 0.433244, 3.748954>, <-3.151572, 0.387198, 0.503868>, 
      <-3.387359, 0.597283, 11.353526>, <-3.217784, 0.567383, 8.102181>, <-3.382932, 0.596502, 3.748954>, <-3.121790, 0.550456, 0.503868>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.387359, -0.597282, 11.353526>, <-3.217784, -0.567381, 8.102181>, <-3.382932, -0.596501, 3.748954>, <-3.121790, -0.550455, 0.503868>, 
      <-3.419674, -0.420136, 11.353526>, <-3.250099, -0.390235, 8.102181>, <-3.412714, -0.433244, 3.748954>, <-3.151572, -0.387197, 0.503868>, 
      <-3.446784, -0.180069, 11.353526>, <-3.274235, -0.180069, 8.102194>, <-3.442276, -0.165952, 3.748914>, <-3.176556, -0.165952, 0.503868>, 
      <-3.446784, 0.000000, 11.353526>, <-3.274235, 0.000000, 8.102194>, <-3.442276, 0.000000, 3.748914>, <-3.176556, 0.000000, 0.503868>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.232181, -1.176417, 11.353526>, <-3.070375, -1.117524, 8.102181>, <-3.227957, -1.174880, 3.748954>, <-2.978778, -1.084186, 0.503868>, 
      <-3.292701, -1.007035, 11.353526>, <-3.130894, -0.948142, 8.102181>, <-3.283732, -1.018777, 3.748954>, <-3.034553, -0.928083, 0.503868>, 
      <-3.355080, -0.774231, 11.353526>, <-3.185505, -0.744330, 8.102181>, <-3.353183, -0.759578, 3.748954>, <-3.092041, -0.713531, 0.503868>, 
      <-3.387359, -0.597282, 11.353526>, <-3.217784, -0.567381, 8.102181>, <-3.382932, -0.596501, 3.748954>, <-3.121790, -0.550455, 0.503868>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.985003, -1.723392, 11.353526>, <-2.835571, -1.637118, 8.102194>, <-2.981098, -1.721138, 3.748914>, <-2.750978, -1.588278, 0.503868>, 
      <-3.075038, -1.567447, 11.353526>, <-2.925606, -1.481173, 8.102194>, <-3.064075, -1.577419, 3.748914>, <-2.833954, -1.444559, 0.503868>, 
      <-3.171594, -1.345988, 11.353526>, <-3.009788, -1.287095, 8.102181>, <-3.172120, -1.331156, 3.748954>, <-2.922941, -1.240463, 0.503868>, 
      <-3.232181, -1.176417, 11.353526>, <-3.070375, -1.117524, 8.102181>, <-3.227957, -1.174880, 3.748954>, <-2.978778, -1.084186, 0.503868>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.634898, -2.210942, 11.353526>, <-2.502992, -2.100260, 8.102181>, <-2.631455, -2.208052, 3.748954>, <-2.428322, -2.037604, 0.503868>, 
      <-2.751457, -2.073687, 11.353526>, <-2.619551, -1.963004, 8.102181>, <-2.738875, -2.081558, 3.748954>, <-2.535743, -1.911110, 0.503868>, 
      <-2.894968, -1.879337, 11.353526>, <-2.745537, -1.793063, 8.102194>, <-2.898123, -1.864857, 3.748914>, <-2.668002, -1.731997, 0.503868>, 
      <-2.985003, -1.723392, 11.353526>, <-2.835571, -1.637118, 8.102194>, <-2.981098, -1.721138, 3.748914>, <-2.750978, -1.588278, 0.503868>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.210942, -2.634897, 11.353526>, <-2.100260, -2.502991, 8.102181>, <-2.208052, -2.631453, 3.748954>, <-2.037604, -2.428321, 0.503868>, 
      <-2.348045, -2.518468, 11.353526>, <-2.237363, -2.386562, 8.102181>, <-2.334406, -2.524152, 3.748954>, <-2.163958, -2.321020, 0.503868>, 
      <-2.518469, -2.348045, 11.353526>, <-2.386563, -2.237362, 8.102181>, <-2.524154, -2.334406, 3.748954>, <-2.321021, -2.163958, 0.503868>, 
      <-2.634898, -2.210942, 11.353526>, <-2.502992, -2.100260, 8.102181>, <-2.631455, -2.208052, 3.748954>, <-2.428322, -2.037604, 0.503868>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.723392, -2.985002, 11.353526>, <-1.637118, -2.835570, 8.102194>, <-1.721138, -2.981098, 3.748914>, <-1.588278, -2.750978, 0.503868>, 
      <-1.879337, -2.894967, 11.353526>, <-1.793062, -2.745536, 8.102194>, <-1.864857, -2.898122, 3.748914>, <-1.731997, -2.668002, 0.503868>, 
      <-2.073686, -2.751456, 11.353526>, <-1.963004, -2.619550, 8.102181>, <-2.081558, -2.738874, 3.748954>, <-1.911109, -2.535742, 0.503868>, 
      <-2.210942, -2.634897, 11.353526>, <-2.100260, -2.502991, 8.102181>, <-2.208052, -2.631453, 3.748954>, <-2.037604, -2.428321, 0.503868>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.176418, -3.232180, 11.353526>, <-1.117525, -3.070374, 8.102179>, <-1.174880, -3.227956, 3.748955>, <-1.084186, -2.978777, 0.503868>, 
      <-1.345989, -3.171593, 11.353526>, <-1.287095, -3.009786, 8.102179>, <-1.331156, -3.172119, 3.748955>, <-1.240462, -2.922940, 0.503868>, 
      <-1.567447, -3.075037, 11.353526>, <-1.481173, -2.925605, 8.102194>, <-1.577419, -3.064074, 3.748914>, <-1.444559, -2.833954, 0.503868>, 
      <-1.723392, -2.985002, 11.353526>, <-1.637118, -2.835570, 8.102194>, <-1.721138, -2.981098, 3.748914>, <-1.588278, -2.750978, 0.503868>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.597283, -3.387359, 11.353526>, <-0.567383, -3.217784, 8.102181>, <-0.596502, -3.382932, 3.748954>, <-0.550456, -3.121790, 0.503868>, 
      <-0.774232, -3.355080, 11.353526>, <-0.744332, -3.185505, 8.102181>, <-0.759579, -3.353183, 3.748954>, <-0.713532, -3.092041, 0.503868>, 
      <-1.007036, -3.292700, 11.353526>, <-0.948143, -3.130893, 8.102179>, <-1.018777, -3.283731, 3.748955>, <-0.928083, -3.034552, 0.503868>, 
      <-1.176418, -3.232180, 11.353526>, <-1.117525, -3.070374, 8.102179>, <-1.174880, -3.227956, 3.748955>, <-1.084186, -2.978777, 0.503868>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -3.446784, 11.353526>, <0.000000, -3.274235, 8.102194>, <0.000000, -3.442276, 3.748914>, <0.000000, -3.176556, 0.503868>, 
      <-0.180070, -3.446784, 11.353526>, <-0.180070, -3.274235, 8.102194>, <-0.165952, -3.442276, 3.748914>, <-0.165952, -3.176556, 0.503868>, 
      <-0.420137, -3.419674, 11.353526>, <-0.390236, -3.250099, 8.102181>, <-0.433244, -3.412714, 3.748954>, <-0.387198, -3.151572, 0.503868>, 
      <-0.597283, -3.387359, 11.353526>, <-0.567383, -3.217784, 8.102181>, <-0.596502, -3.382932, 3.748954>, <-0.550456, -3.121790, 0.503868>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.597283, -3.387359, 11.353526>, <0.567383, -3.217784, 8.102181>, <0.596502, -3.382932, 3.748954>, <0.550456, -3.121790, 0.503868>, 
      <0.420137, -3.419674, 11.353526>, <0.390236, -3.250099, 8.102181>, <0.433244, -3.412714, 3.748954>, <0.387198, -3.151572, 0.503868>, 
      <0.180070, -3.446784, 11.353526>, <0.180070, -3.274235, 8.102194>, <0.165952, -3.442276, 3.748914>, <0.165952, -3.176556, 0.503868>, 
      <0.000000, -3.446784, 11.353526>, <0.000000, -3.274235, 8.102194>, <0.000000, -3.442276, 3.748914>, <0.000000, -3.176556, 0.503868>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.176417, -3.232180, 11.353526>, <1.117524, -3.070374, 8.102181>, <1.174879, -3.227956, 3.748954>, <1.084186, -2.978777, 0.503868>, 
      <1.007035, -3.292700, 11.353526>, <0.948142, -3.130893, 8.102181>, <1.018777, -3.283731, 3.748954>, <0.928083, -3.034552, 0.503868>, 
      <0.774232, -3.355080, 11.353526>, <0.744332, -3.185505, 8.102181>, <0.759579, -3.353183, 3.748954>, <0.713532, -3.092041, 0.503868>, 
      <0.597283, -3.387359, 11.353526>, <0.567383, -3.217784, 8.102181>, <0.596502, -3.382932, 3.748954>, <0.550456, -3.121790, 0.503868>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.723392, -2.985003, 11.353526>, <1.637118, -2.835571, 8.102194>, <1.721138, -2.981098, 3.748914>, <1.588278, -2.750978, 0.503868>, 
      <1.567447, -3.075038, 11.353526>, <1.481173, -2.925606, 8.102194>, <1.577419, -3.064075, 3.748914>, <1.444559, -2.833954, 0.503868>, 
      <1.345988, -3.171593, 11.353526>, <1.287095, -3.009786, 8.102181>, <1.331156, -3.172119, 3.748954>, <1.240462, -2.922940, 0.503868>, 
      <1.176417, -3.232180, 11.353526>, <1.117524, -3.070374, 8.102181>, <1.174879, -3.227956, 3.748954>, <1.084186, -2.978777, 0.503868>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.210942, -2.634897, 11.353526>, <2.100260, -2.502991, 8.102181>, <2.208053, -2.631453, 3.748954>, <2.037604, -2.428321, 0.503868>, 
      <2.073686, -2.751456, 11.353526>, <1.963005, -2.619550, 8.102181>, <2.081558, -2.738874, 3.748954>, <1.911109, -2.535742, 0.503868>, 
      <1.879337, -2.894968, 11.353526>, <1.793063, -2.745536, 8.102194>, <1.864857, -2.898122, 3.748914>, <1.731997, -2.668002, 0.503868>, 
      <1.723392, -2.985003, 11.353526>, <1.637118, -2.835571, 8.102194>, <1.721138, -2.981098, 3.748914>, <1.588278, -2.750978, 0.503868>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.634897, -2.210942, 11.353526>, <2.502991, -2.100260, 8.102181>, <2.631453, -2.208052, 3.748954>, <2.428321, -2.037604, 0.503868>, 
      <2.518468, -2.348045, 11.353526>, <2.386562, -2.237362, 8.102181>, <2.524152, -2.334406, 3.748954>, <2.321020, -2.163958, 0.503868>, 
      <2.348045, -2.518468, 11.353526>, <2.237363, -2.386562, 8.102181>, <2.334406, -2.524152, 3.748954>, <2.163958, -2.321020, 0.503868>, 
      <2.210942, -2.634897, 11.353526>, <2.100260, -2.502991, 8.102181>, <2.208053, -2.631453, 3.748954>, <2.037604, -2.428321, 0.503868>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.985002, -1.723392, 11.353526>, <2.835570, -1.637118, 8.102194>, <2.981098, -1.721138, 3.748914>, <2.750978, -1.588278, 0.503868>, 
      <2.894967, -1.879337, 11.353526>, <2.745536, -1.793062, 8.102194>, <2.898122, -1.864857, 3.748914>, <2.668002, -1.731997, 0.503868>, 
      <2.751456, -2.073687, 11.353526>, <2.619550, -1.963004, 8.102181>, <2.738874, -2.081558, 3.748954>, <2.535742, -1.911109, 0.503868>, 
      <2.634897, -2.210942, 11.353526>, <2.502991, -2.100260, 8.102181>, <2.631453, -2.208052, 3.748954>, <2.428321, -2.037604, 0.503868>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.232180, -1.176418, 11.353526>, <3.070374, -1.117525, 8.102179>, <3.227956, -1.174880, 3.748955>, <2.978777, -1.084186, 0.503868>, 
      <3.171593, -1.345989, 11.353526>, <3.009786, -1.287095, 8.102179>, <3.172119, -1.331156, 3.748955>, <2.922940, -1.240462, 0.503868>, 
      <3.075037, -1.567447, 11.353526>, <2.925605, -1.481173, 8.102194>, <3.064074, -1.577419, 3.748914>, <2.833954, -1.444559, 0.503868>, 
      <2.985002, -1.723392, 11.353526>, <2.835570, -1.637118, 8.102194>, <2.981098, -1.721138, 3.748914>, <2.750978, -1.588278, 0.503868>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.387359, -0.597283, 11.353526>, <3.217784, -0.567383, 8.102181>, <3.382932, -0.596502, 3.748954>, <3.121790, -0.550456, 0.503868>, 
      <3.355080, -0.774232, 11.353526>, <3.185505, -0.744332, 8.102181>, <3.353183, -0.759579, 3.748954>, <3.092041, -0.713532, 0.503868>, 
      <3.292700, -1.007036, 11.353526>, <3.130893, -0.948143, 8.102179>, <3.283731, -1.018777, 3.748955>, <3.034552, -0.928083, 0.503868>, 
      <3.232180, -1.176418, 11.353526>, <3.070374, -1.117525, 8.102179>, <3.227956, -1.174880, 3.748955>, <2.978777, -1.084186, 0.503868>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.446784, 0.000000, 11.353526>, <3.274235, 0.000000, 8.102194>, <3.442276, 0.000000, 3.748914>, <3.176556, 0.000000, 0.503868>, 
      <3.446784, -0.180070, 11.353526>, <3.274235, -0.180070, 8.102194>, <3.442276, -0.165952, 3.748914>, <3.176556, -0.165952, 0.503868>, 
      <3.419674, -0.420137, 11.353526>, <3.250099, -0.390236, 8.102181>, <3.412714, -0.433244, 3.748954>, <3.151572, -0.387198, 0.503868>, 
      <3.387359, -0.597283, 11.353526>, <3.217784, -0.567383, 8.102181>, <3.382932, -0.596502, 3.748954>, <3.121790, -0.550456, 0.503868>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.446784, 0.000000, 11.353526>, <3.446784, 0.180069, 11.353526>, <3.419674, 0.420136, 11.353526>, <3.387359, 0.597282, 11.353526>, 
      <3.274235, 0.000000, 8.102194>, <3.274235, 0.180069, 8.102194>, <3.250099, 0.390236, 8.102181>, <3.217784, 0.567381, 8.102181>, 
      <3.442276, 0.000000, 3.748914>, <3.442276, 0.165952, 3.748914>, <3.412714, 0.433244, 3.748954>, <3.382932, 0.596501, 3.748954>, 
      <3.176556, 0.000000, 0.503868>, <3.176556, 0.165952, 0.503868>, <3.151572, 0.387197, 0.503868>, <3.121790, 0.550455, 0.503868>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.526015, 1.283364, 11.500091>, <3.428757, 1.247965, 11.495512>, <3.237330, 1.178291, 11.456982>, <3.232181, 1.176417, 11.353526>, 
      <3.592037, 1.098583, 11.500091>, <3.494779, 1.063184, 11.495512>, <3.297849, 1.008909, 11.456982>, <3.292701, 1.007035, 11.353526>, 
      <3.660087, 0.844616, 11.500091>, <3.558160, 0.826643, 11.495512>, <3.360476, 0.775183, 11.456982>, <3.355080, 0.774231, 11.353526>, 
      <3.695301, 0.651580, 11.500091>, <3.593374, 0.633607, 11.495512>, <3.392755, 0.598233, 11.456982>, <3.387359, 0.597282, 11.353526>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.256366, 1.880063, 11.500091>, <3.166579, 1.828225, 11.495514>, <2.989766, 1.726141, 11.457158>, <2.985003, 1.723391, 11.353526>, 
      <3.354586, 1.709942, 11.500091>, <3.264799, 1.658103, 11.495514>, <3.079801, 1.570196, 11.457158>, <3.075038, 1.567447, 11.353526>, 
      <3.459920, 1.468350, 11.500091>, <3.362662, 1.432951, 11.495512>, <3.176743, 1.347862, 11.456982>, <3.171594, 1.345988, 11.353526>, 
      <3.526015, 1.283364, 11.500091>, <3.428757, 1.247965, 11.495512>, <3.237330, 1.178291, 11.456982>, <3.232181, 1.176417, 11.353526>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.874434, 2.411935, 11.500091>, <2.795148, 2.345407, 11.495512>, <2.639095, 2.214463, 11.456982>, <2.634898, 2.210941, 11.353526>, 
      <3.001589, 2.262202, 11.500091>, <2.922303, 2.195674, 11.495512>, <2.755654, 2.077208, 11.456982>, <2.751457, 2.073686, 11.353526>, 
      <3.158146, 2.050184, 11.500091>, <3.068359, 1.998346, 11.495514>, <2.899731, 1.882086, 11.457158>, <2.894968, 1.879336, 11.353526>, 
      <3.256366, 1.880063, 11.500091>, <3.166579, 1.828225, 11.495514>, <2.989766, 1.726141, 11.457158>, <2.985003, 1.723391, 11.353526>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.411937, 2.874433, 11.500091>, <2.345408, 2.795147, 11.495512>, <2.214464, 2.639094, 11.456982>, <2.210942, 2.634897, 11.353526>, 
      <2.561504, 2.747419, 11.500091>, <2.494975, 2.668133, 11.495512>, <2.351567, 2.522665, 11.456982>, <2.348045, 2.518468, 11.353526>, 
      <2.747420, 2.561502, 11.500091>, <2.668135, 2.494974, 11.495512>, <2.522666, 2.351566, 11.456982>, <2.518469, 2.348044, 11.353526>, 
      <2.874434, 2.411935, 11.500091>, <2.795148, 2.345407, 11.495512>, <2.639095, 2.214463, 11.456982>, <2.634898, 2.210941, 11.353526>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.880064, 3.256366, 11.500091>, <1.828225, 3.166579, 11.495514>, <1.726142, 2.989766, 11.457158>, <1.723392, 2.985003, 11.353526>, 
      <2.050186, 3.158146, 11.500091>, <1.998347, 3.068359, 11.495514>, <1.882087, 2.899731, 11.457158>, <1.879337, 2.894968, 11.353526>, 
      <2.262204, 3.001588, 11.500091>, <2.195675, 2.922303, 11.495512>, <2.077208, 2.755653, 11.456982>, <2.073686, 2.751456, 11.353526>, 
      <2.411937, 2.874433, 11.500091>, <2.345408, 2.795147, 11.495512>, <2.214464, 2.639094, 11.456982>, <2.210942, 2.634897, 11.353526>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.283365, 3.526015, 11.500091>, <1.247966, 3.428757, 11.495512>, <1.178292, 3.237329, 11.456982>, <1.176418, 3.232180, 11.353526>, 
      <1.468351, 3.459920, 11.500091>, <1.432952, 3.362661, 11.495512>, <1.347862, 3.176742, 11.456982>, <1.345988, 3.171593, 11.353526>, 
      <1.709943, 3.354586, 11.500091>, <1.658104, 3.264799, 11.495514>, <1.570197, 3.079801, 11.457158>, <1.567447, 3.075038, 11.353526>, 
      <1.880064, 3.256366, 11.500091>, <1.828225, 3.166579, 11.495514>, <1.726142, 2.989766, 11.457158>, <1.723392, 2.985003, 11.353526>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.651582, 3.695301, 11.500091>, <0.633609, 3.593373, 11.495512>, <0.598234, 3.392755, 11.456982>, <0.597283, 3.387359, 11.353526>, 
      <0.844617, 3.660087, 11.500091>, <0.826645, 3.558160, 11.495512>, <0.775184, 3.360476, 11.456982>, <0.774232, 3.355080, 11.353526>, 
      <1.098585, 3.592037, 11.500091>, <1.063186, 3.494779, 11.495512>, <1.008910, 3.297849, 11.456982>, <1.007036, 3.292700, 11.353526>, 
      <1.283365, 3.526015, 11.500091>, <1.247966, 3.428757, 11.495512>, <1.178292, 3.237329, 11.456982>, <1.176418, 3.232180, 11.353526>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 3.760128, 11.500091>, <-0.000000, 3.656451, 11.495514>, <0.000000, 3.452284, 11.457158>, <0.000000, 3.446784, 11.353526>, 
      <0.196440, 3.760128, 11.500091>, <0.196439, 3.656451, 11.495514>, <0.180070, 3.452284, 11.457158>, <0.180070, 3.446784, 11.353526>, 
      <0.458332, 3.730554, 11.500091>, <0.440359, 3.628626, 11.495512>, <0.421088, 3.425070, 11.456982>, <0.420137, 3.419674, 11.353526>, 
      <0.651582, 3.695301, 11.500091>, <0.633609, 3.593373, 11.495512>, <0.598234, 3.392755, 11.456982>, <0.597283, 3.387359, 11.353526>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.651581, 3.695301, 11.500091>, <-0.633608, 3.593373, 11.495512>, <-0.598233, 3.392755, 11.456982>, <-0.597282, 3.387359, 11.353526>, 
      <-0.458331, 3.730554, 11.500091>, <-0.440358, 3.628626, 11.495512>, <-0.421088, 3.425070, 11.456982>, <-0.420136, 3.419674, 11.353526>, 
      <-0.196439, 3.760128, 11.500091>, <-0.196440, 3.656451, 11.495514>, <-0.180069, 3.452284, 11.457158>, <-0.180069, 3.446784, 11.353526>, 
      <0.000000, 3.760128, 11.500091>, <-0.000000, 3.656451, 11.495514>, <0.000000, 3.452284, 11.457158>, <0.000000, 3.446784, 11.353526>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.283364, 3.526015, 11.500091>, <-1.247965, 3.428757, 11.495512>, <-1.178291, 3.237330, 11.456982>, <-1.176417, 3.232181, 11.353526>, 
      <-1.098584, 3.592037, 11.500091>, <-1.063185, 3.494779, 11.495512>, <-1.008909, 3.297849, 11.456982>, <-1.007035, 3.292701, 11.353526>, 
      <-0.844616, 3.660087, 11.500091>, <-0.826644, 3.558160, 11.495512>, <-0.775183, 3.360476, 11.456982>, <-0.774231, 3.355080, 11.353526>, 
      <-0.651581, 3.695301, 11.500091>, <-0.633608, 3.593373, 11.495512>, <-0.598233, 3.392755, 11.456982>, <-0.597282, 3.387359, 11.353526>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.880064, 3.256366, 11.500091>, <-1.828225, 3.166579, 11.495514>, <-1.726142, 2.989766, 11.457158>, <-1.723392, 2.985003, 11.353526>, 
      <-1.709942, 3.354586, 11.500091>, <-1.658104, 3.264799, 11.495514>, <-1.570197, 3.079801, 11.457158>, <-1.567447, 3.075038, 11.353526>, 
      <-1.468350, 3.459920, 11.500091>, <-1.432951, 3.362662, 11.495512>, <-1.347862, 3.176743, 11.456982>, <-1.345988, 3.171594, 11.353526>, 
      <-1.283364, 3.526015, 11.500091>, <-1.247965, 3.428757, 11.495512>, <-1.178291, 3.237330, 11.456982>, <-1.176417, 3.232181, 11.353526>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.411936, 2.874434, 11.500091>, <-2.345408, 2.795148, 11.495512>, <-2.214463, 2.639095, 11.456982>, <-2.210941, 2.634898, 11.353526>, 
      <-2.262203, 3.001589, 11.500091>, <-2.195675, 2.922303, 11.495512>, <-2.077208, 2.755654, 11.456982>, <-2.073686, 2.751457, 11.353526>, 
      <-2.050185, 3.158146, 11.500091>, <-1.998347, 3.068359, 11.495514>, <-1.882087, 2.899731, 11.457158>, <-1.879337, 2.894968, 11.353526>, 
      <-1.880064, 3.256366, 11.500091>, <-1.828225, 3.166579, 11.495514>, <-1.726142, 2.989766, 11.457158>, <-1.723392, 2.985003, 11.353526>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.874433, 2.411937, 11.500091>, <-2.795147, 2.345409, 11.495512>, <-2.639094, 2.214464, 11.456982>, <-2.634897, 2.210942, 11.353526>, 
      <-2.747419, 2.561504, 11.500091>, <-2.668134, 2.494975, 11.495512>, <-2.522665, 2.351567, 11.456982>, <-2.518468, 2.348045, 11.353526>, 
      <-2.561503, 2.747420, 11.500091>, <-2.494974, 2.668135, 11.495512>, <-2.351566, 2.522666, 11.456982>, <-2.348044, 2.518469, 11.353526>, 
      <-2.411936, 2.874434, 11.500091>, <-2.345408, 2.795148, 11.495512>, <-2.214463, 2.639095, 11.456982>, <-2.210941, 2.634898, 11.353526>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.256366, 1.880064, 11.500091>, <-3.166579, 1.828225, 11.495514>, <-2.989765, 1.726142, 11.457159>, <-2.985002, 1.723392, 11.353526>, 
      <-3.158146, 2.050186, 11.500091>, <-3.068359, 1.998347, 11.495514>, <-2.899730, 1.882087, 11.457159>, <-2.894967, 1.879337, 11.353526>, 
      <-3.001588, 2.262204, 11.500091>, <-2.922303, 2.195675, 11.495512>, <-2.755653, 2.077209, 11.456982>, <-2.751456, 2.073687, 11.353526>, 
      <-2.874433, 2.411937, 11.500091>, <-2.795147, 2.345409, 11.495512>, <-2.639094, 2.214464, 11.456982>, <-2.634897, 2.210942, 11.353526>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.526015, 1.283365, 11.500091>, <-3.428757, 1.247966, 11.495512>, <-3.237329, 1.178292, 11.456982>, <-3.232180, 1.176418, 11.353526>, 
      <-3.459920, 1.468351, 11.500091>, <-3.362662, 1.432952, 11.495512>, <-3.176741, 1.347863, 11.456982>, <-3.171593, 1.345989, 11.353526>, 
      <-3.354586, 1.709943, 11.500091>, <-3.264799, 1.658104, 11.495514>, <-3.079800, 1.570197, 11.457159>, <-3.075037, 1.567447, 11.353526>, 
      <-3.256366, 1.880064, 11.500091>, <-3.166579, 1.828225, 11.495514>, <-2.989765, 1.726142, 11.457159>, <-2.985002, 1.723392, 11.353526>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.695301, 0.651581, 11.500091>, <-3.593374, 0.633608, 11.495512>, <-3.392755, 0.598234, 11.456982>, <-3.387359, 0.597283, 11.353526>, 
      <-3.660087, 0.844617, 11.500091>, <-3.558160, 0.826644, 11.495512>, <-3.360476, 0.775184, 11.456982>, <-3.355080, 0.774232, 11.353526>, 
      <-3.592037, 1.098584, 11.500091>, <-3.494779, 1.063185, 11.495512>, <-3.297849, 1.008910, 11.456982>, <-3.292700, 1.007036, 11.353526>, 
      <-3.526015, 1.283365, 11.500091>, <-3.428757, 1.247966, 11.495512>, <-3.237329, 1.178292, 11.456982>, <-3.232180, 1.176418, 11.353526>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.760128, 0.000000, 11.500091>, <-3.656451, 0.000000, 11.495514>, <-3.452284, 0.000000, 11.457158>, <-3.446784, 0.000000, 11.353526>, 
      <-3.760128, 0.196439, 11.500091>, <-3.656451, 0.196439, 11.495514>, <-3.452284, 0.180070, 11.457158>, <-3.446784, 0.180070, 11.353526>, 
      <-3.730554, 0.458331, 11.500091>, <-3.628626, 0.440358, 11.495512>, <-3.425070, 0.421088, 11.456982>, <-3.419674, 0.420137, 11.353526>, 
      <-3.695301, 0.651581, 11.500091>, <-3.593374, 0.633608, 11.495512>, <-3.392755, 0.598234, 11.456982>, <-3.387359, 0.597283, 11.353526>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.695301, -0.651581, 11.500091>, <-3.593373, -0.633608, 11.495512>, <-3.392755, -0.598233, 11.456982>, <-3.387359, -0.597282, 11.353526>, 
      <-3.730554, -0.458331, 11.500091>, <-3.628626, -0.440358, 11.495512>, <-3.425070, -0.421088, 11.456982>, <-3.419674, -0.420136, 11.353526>, 
      <-3.760128, -0.196439, 11.500091>, <-3.656451, -0.196439, 11.495514>, <-3.452284, -0.180069, 11.457158>, <-3.446784, -0.180069, 11.353526>, 
      <-3.760128, 0.000000, 11.500091>, <-3.656451, 0.000000, 11.495514>, <-3.452284, 0.000000, 11.457158>, <-3.446784, 0.000000, 11.353526>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.526015, -1.283364, 11.500091>, <-3.428757, -1.247965, 11.495512>, <-3.237330, -1.178291, 11.456982>, <-3.232181, -1.176417, 11.353526>, 
      <-3.592037, -1.098584, 11.500091>, <-3.494779, -1.063185, 11.495512>, <-3.297849, -1.008909, 11.456982>, <-3.292701, -1.007035, 11.353526>, 
      <-3.660087, -0.844616, 11.500091>, <-3.558160, -0.826644, 11.495512>, <-3.360476, -0.775183, 11.456982>, <-3.355080, -0.774231, 11.353526>, 
      <-3.695301, -0.651581, 11.500091>, <-3.593373, -0.633608, 11.495512>, <-3.392755, -0.598233, 11.456982>, <-3.387359, -0.597282, 11.353526>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.256366, -1.880064, 11.500091>, <-3.166579, -1.828225, 11.495514>, <-2.989766, -1.726142, 11.457158>, <-2.985003, -1.723392, 11.353526>, 
      <-3.354586, -1.709942, 11.500091>, <-3.264799, -1.658104, 11.495514>, <-3.079801, -1.570197, 11.457158>, <-3.075038, -1.567447, 11.353526>, 
      <-3.459920, -1.468350, 11.500091>, <-3.362662, -1.432951, 11.495512>, <-3.176743, -1.347862, 11.456982>, <-3.171594, -1.345988, 11.353526>, 
      <-3.526015, -1.283364, 11.500091>, <-3.428757, -1.247965, 11.495512>, <-3.237330, -1.178291, 11.456982>, <-3.232181, -1.176417, 11.353526>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.874434, -2.411937, 11.500091>, <-2.795148, -2.345408, 11.495512>, <-2.639095, -2.214464, 11.456982>, <-2.634898, -2.210942, 11.353526>, 
      <-3.001589, -2.262204, 11.500091>, <-2.922303, -2.195675, 11.495512>, <-2.755654, -2.077209, 11.456982>, <-2.751457, -2.073687, 11.353526>, 
      <-3.158146, -2.050186, 11.500091>, <-3.068359, -1.998347, 11.495514>, <-2.899731, -1.882087, 11.457158>, <-2.894968, -1.879337, 11.353526>, 
      <-3.256366, -1.880064, 11.500091>, <-3.166579, -1.828225, 11.495514>, <-2.989766, -1.726142, 11.457158>, <-2.985003, -1.723392, 11.353526>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.411937, -2.874434, 11.500091>, <-2.345408, -2.795148, 11.495512>, <-2.214464, -2.639094, 11.456982>, <-2.210942, -2.634897, 11.353526>, 
      <-2.561504, -2.747421, 11.500091>, <-2.494975, -2.668135, 11.495512>, <-2.351567, -2.522665, 11.456982>, <-2.348045, -2.518468, 11.353526>, 
      <-2.747421, -2.561504, 11.500091>, <-2.668135, -2.494975, 11.495512>, <-2.522666, -2.351567, 11.456982>, <-2.518469, -2.348045, 11.353526>, 
      <-2.874434, -2.411937, 11.500091>, <-2.795148, -2.345408, 11.495512>, <-2.639095, -2.214464, 11.456982>, <-2.634898, -2.210942, 11.353526>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.880064, -3.256366, 11.500091>, <-1.828225, -3.166579, 11.495514>, <-1.726142, -2.989765, 11.457159>, <-1.723392, -2.985002, 11.353526>, 
      <-2.050186, -3.158146, 11.500091>, <-1.998347, -3.068359, 11.495514>, <-1.882087, -2.899730, 11.457159>, <-1.879337, -2.894967, 11.353526>, 
      <-2.262204, -3.001589, 11.500091>, <-2.195675, -2.922303, 11.495512>, <-2.077208, -2.755653, 11.456982>, <-2.073686, -2.751456, 11.353526>, 
      <-2.411937, -2.874434, 11.500091>, <-2.345408, -2.795148, 11.495512>, <-2.214464, -2.639094, 11.456982>, <-2.210942, -2.634897, 11.353526>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.283365, -3.526015, 11.500091>, <-1.247966, -3.428757, 11.495512>, <-1.178292, -3.237329, 11.456982>, <-1.176418, -3.232180, 11.353526>, 
      <-1.468351, -3.459920, 11.500091>, <-1.432952, -3.362662, 11.495512>, <-1.347863, -3.176741, 11.456982>, <-1.345989, -3.171593, 11.353526>, 
      <-1.709943, -3.354586, 11.500091>, <-1.658104, -3.264798, 11.495514>, <-1.570197, -3.079800, 11.457159>, <-1.567447, -3.075037, 11.353526>, 
      <-1.880064, -3.256366, 11.500091>, <-1.828225, -3.166579, 11.495514>, <-1.726142, -2.989765, 11.457159>, <-1.723392, -2.985002, 11.353526>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.651581, -3.695301, 11.500091>, <-0.633608, -3.593374, 11.495512>, <-0.598234, -3.392755, 11.456982>, <-0.597283, -3.387359, 11.353526>, 
      <-0.844617, -3.660087, 11.500091>, <-0.826644, -3.558160, 11.495512>, <-0.775184, -3.360476, 11.456982>, <-0.774232, -3.355080, 11.353526>, 
      <-1.098584, -3.592037, 11.500091>, <-1.063185, -3.494779, 11.495512>, <-1.008910, -3.297849, 11.456982>, <-1.007036, -3.292700, 11.353526>, 
      <-1.283365, -3.526015, 11.500091>, <-1.247966, -3.428757, 11.495512>, <-1.178292, -3.237329, 11.456982>, <-1.176418, -3.232180, 11.353526>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -3.760128, 11.500091>, <0.000000, -3.656451, 11.495514>, <0.000000, -3.452284, 11.457158>, <0.000000, -3.446784, 11.353526>, 
      <-0.196439, -3.760128, 11.500091>, <-0.196439, -3.656451, 11.495514>, <-0.180070, -3.452284, 11.457158>, <-0.180070, -3.446784, 11.353526>, 
      <-0.458331, -3.730554, 11.500091>, <-0.440358, -3.628626, 11.495512>, <-0.421088, -3.425070, 11.456982>, <-0.420137, -3.419674, 11.353526>, 
      <-0.651581, -3.695301, 11.500091>, <-0.633608, -3.593374, 11.495512>, <-0.598234, -3.392755, 11.456982>, <-0.597283, -3.387359, 11.353526>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.651581, -3.695301, 11.500091>, <0.633608, -3.593374, 11.495512>, <0.598234, -3.392755, 11.456982>, <0.597283, -3.387359, 11.353526>, 
      <0.458331, -3.730554, 11.500091>, <0.440358, -3.628626, 11.495512>, <0.421088, -3.425070, 11.456982>, <0.420137, -3.419674, 11.353526>, 
      <0.196439, -3.760128, 11.500091>, <0.196439, -3.656451, 11.495514>, <0.180070, -3.452284, 11.457158>, <0.180070, -3.446784, 11.353526>, 
      <0.000000, -3.760128, 11.500091>, <0.000000, -3.656451, 11.495514>, <0.000000, -3.452284, 11.457158>, <0.000000, -3.446784, 11.353526>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.283364, -3.526015, 11.500091>, <1.247965, -3.428757, 11.495512>, <1.178291, -3.237329, 11.456982>, <1.176417, -3.232180, 11.353526>, 
      <1.098584, -3.592037, 11.500091>, <1.063185, -3.494779, 11.495512>, <1.008909, -3.297848, 11.456982>, <1.007035, -3.292700, 11.353526>, 
      <0.844616, -3.660087, 11.500091>, <0.826644, -3.558160, 11.495512>, <0.775184, -3.360476, 11.456982>, <0.774232, -3.355080, 11.353526>, 
      <0.651581, -3.695301, 11.500091>, <0.633608, -3.593374, 11.495512>, <0.598234, -3.392755, 11.456982>, <0.597283, -3.387359, 11.353526>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.880064, -3.256366, 11.500091>, <1.828225, -3.166579, 11.495514>, <1.726142, -2.989766, 11.457158>, <1.723392, -2.985003, 11.353526>, 
      <1.709942, -3.354586, 11.500091>, <1.658104, -3.264799, 11.495514>, <1.570197, -3.079801, 11.457158>, <1.567447, -3.075038, 11.353526>, 
      <1.468350, -3.459920, 11.500091>, <1.432951, -3.362662, 11.495512>, <1.347862, -3.176742, 11.456982>, <1.345988, -3.171593, 11.353526>, 
      <1.283364, -3.526015, 11.500091>, <1.247965, -3.428757, 11.495512>, <1.178291, -3.237329, 11.456982>, <1.176417, -3.232180, 11.353526>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.411936, -2.874434, 11.500091>, <2.345408, -2.795148, 11.495512>, <2.214464, -2.639094, 11.456982>, <2.210942, -2.634897, 11.353526>, 
      <2.262203, -3.001589, 11.500091>, <2.195675, -2.922303, 11.495512>, <2.077208, -2.755653, 11.456982>, <2.073686, -2.751456, 11.353526>, 
      <2.050185, -3.158146, 11.500091>, <1.998347, -3.068359, 11.495514>, <1.882087, -2.899731, 11.457158>, <1.879337, -2.894968, 11.353526>, 
      <1.880064, -3.256366, 11.500091>, <1.828225, -3.166579, 11.495514>, <1.726142, -2.989766, 11.457158>, <1.723392, -2.985003, 11.353526>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.874434, -2.411937, 11.500091>, <2.795148, -2.345408, 11.495512>, <2.639094, -2.214464, 11.456982>, <2.634897, -2.210942, 11.353526>, 
      <2.747420, -2.561504, 11.500091>, <2.668134, -2.494975, 11.495512>, <2.522665, -2.351567, 11.456982>, <2.518468, -2.348045, 11.353526>, 
      <2.561503, -2.747420, 11.500091>, <2.494975, -2.668135, 11.495512>, <2.351567, -2.522665, 11.456982>, <2.348045, -2.518468, 11.353526>, 
      <2.411936, -2.874434, 11.500091>, <2.345408, -2.795148, 11.495512>, <2.214464, -2.639094, 11.456982>, <2.210942, -2.634897, 11.353526>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.256366, -1.880064, 11.500091>, <3.166579, -1.828225, 11.495514>, <2.989765, -1.726142, 11.457159>, <2.985002, -1.723392, 11.353526>, 
      <3.158146, -2.050186, 11.500091>, <3.068359, -1.998347, 11.495514>, <2.899730, -1.882087, 11.457159>, <2.894967, -1.879337, 11.353526>, 
      <3.001589, -2.262204, 11.500091>, <2.922303, -2.195675, 11.495512>, <2.755653, -2.077209, 11.456982>, <2.751456, -2.073687, 11.353526>, 
      <2.874434, -2.411937, 11.500091>, <2.795148, -2.345408, 11.495512>, <2.639094, -2.214464, 11.456982>, <2.634897, -2.210942, 11.353526>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.526015, -1.283365, 11.500091>, <3.428757, -1.247966, 11.495512>, <3.237329, -1.178292, 11.456982>, <3.232180, -1.176418, 11.353526>, 
      <3.459920, -1.468351, 11.500091>, <3.362662, -1.432952, 11.495512>, <3.176741, -1.347863, 11.456982>, <3.171593, -1.345989, 11.353526>, 
      <3.354586, -1.709943, 11.500091>, <3.264798, -1.658104, 11.495514>, <3.079800, -1.570197, 11.457159>, <3.075037, -1.567447, 11.353526>, 
      <3.256366, -1.880064, 11.500091>, <3.166579, -1.828225, 11.495514>, <2.989765, -1.726142, 11.457159>, <2.985002, -1.723392, 11.353526>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.695301, -0.651581, 11.500091>, <3.593374, -0.633608, 11.495512>, <3.392755, -0.598234, 11.456982>, <3.387359, -0.597283, 11.353526>, 
      <3.660087, -0.844617, 11.500091>, <3.558160, -0.826644, 11.495512>, <3.360476, -0.775184, 11.456982>, <3.355080, -0.774232, 11.353526>, 
      <3.592037, -1.098584, 11.500091>, <3.494779, -1.063185, 11.495512>, <3.297849, -1.008910, 11.456982>, <3.292700, -1.007036, 11.353526>, 
      <3.526015, -1.283365, 11.500091>, <3.428757, -1.247966, 11.495512>, <3.237329, -1.178292, 11.456982>, <3.232180, -1.176418, 11.353526>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.760128, 0.000000, 11.500091>, <3.656451, 0.000000, 11.495514>, <3.452284, 0.000000, 11.457158>, <3.446784, 0.000000, 11.353526>, 
      <3.760128, -0.196439, 11.500091>, <3.656451, -0.196439, 11.495514>, <3.452284, -0.180070, 11.457158>, <3.446784, -0.180070, 11.353526>, 
      <3.730554, -0.458331, 11.500091>, <3.628626, -0.440358, 11.495512>, <3.425070, -0.421088, 11.456982>, <3.419674, -0.420137, 11.353526>, 
      <3.695301, -0.651581, 11.500091>, <3.593374, -0.633608, 11.495512>, <3.392755, -0.598234, 11.456982>, <3.387359, -0.597283, 11.353526>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.760128, 0.000000, 11.500091>, <3.760128, 0.196439, 11.500091>, <3.730554, 0.458330, 11.500091>, <3.695301, 0.651580, 11.500091>, 
      <3.656451, 0.000000, 11.495514>, <3.656451, 0.196439, 11.495514>, <3.628626, 0.440358, 11.495512>, <3.593374, 0.633607, 11.495512>, 
      <3.452284, 0.000000, 11.457158>, <3.452284, 0.180069, 11.457158>, <3.425070, 0.421088, 11.456982>, <3.392755, 0.598233, 11.456982>, 
      <3.446784, 0.000000, 11.353526>, <3.446784, 0.180069, 11.353526>, <3.419674, 0.420136, 11.353526>, <3.387359, 0.597282, 11.353526>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.750952, 1.365234, 11.377954>, <3.744652, 1.362941, 11.458294>, <3.601699, 1.310911, 11.503655>, <3.526015, 1.283364, 11.500091>, 
      <3.821185, 1.168666, 11.377954>, <3.814885, 1.166372, 11.458294>, <3.667720, 1.126130, 11.503655>, <3.592037, 1.098583, 11.500091>, 
      <3.893577, 0.898497, 11.377954>, <3.886974, 0.897332, 11.458294>, <3.739404, 0.858602, 11.503655>, <3.660087, 0.844616, 11.500091>, 
      <3.931037, 0.693147, 11.377954>, <3.924434, 0.691983, 11.458294>, <3.774618, 0.665566, 11.503655>, <3.695301, 0.651580, 11.500091>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.464102, 1.999999, 11.377954>, <3.458274, 1.996634, 11.458426>, <3.326232, 1.920400, 11.503654>, <3.256366, 1.880063, 11.500091>, 
      <3.568587, 1.819025, 11.377954>, <3.562759, 1.815660, 11.458426>, <3.424452, 1.750279, 11.503654>, <3.354586, 1.709942, 11.500091>, 
      <3.680640, 1.562021, 11.377954>, <3.674340, 1.559728, 11.458294>, <3.535604, 1.495897, 11.503655>, <3.459920, 1.468350, 11.500091>, 
      <3.750952, 1.365234, 11.377954>, <3.744652, 1.362941, 11.458294>, <3.601699, 1.310911, 11.503655>, <3.526015, 1.283364, 11.500091>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.057805, 2.565802, 11.377954>, <3.052669, 2.561492, 11.458294>, <2.936132, 2.463706, 11.503655>, <2.874434, 2.411935, 11.500091>, 
      <3.193072, 2.406517, 11.377954>, <3.187936, 2.402207, 11.458294>, <3.063287, 2.313973, 11.503655>, <3.001589, 2.262202, 11.500091>, 
      <3.359617, 2.180974, 11.377954>, <3.353789, 2.177608, 11.458426>, <3.228013, 2.090522, 11.503654>, <3.158146, 2.050184, 11.500091>, 
      <3.464102, 1.999999, 11.377954>, <3.458274, 1.996634, 11.458426>, <3.326232, 1.920400, 11.503654>, <3.256366, 1.880063, 11.500091>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.565803, 3.057803, 11.377954>, <2.561493, 3.052667, 11.458294>, <2.463708, 2.936131, 11.503655>, <2.411937, 2.874433, 11.500091>, 
      <2.724911, 2.922687, 11.377954>, <2.720601, 2.917550, 11.458294>, <2.613274, 2.809117, 11.503655>, <2.561504, 2.747419, 11.500091>, 
      <2.922689, 2.724910, 11.377954>, <2.917552, 2.720600, 11.458294>, <2.809119, 2.613273, 11.503655>, <2.747420, 2.561502, 11.500091>, 
      <3.057805, 2.565802, 11.377954>, <3.052669, 2.561492, 11.458294>, <2.936132, 2.463706, 11.503655>, <2.874434, 2.411935, 11.500091>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.000000, 3.464102, 11.377954>, <1.996635, 3.458274, 11.458426>, <1.920401, 3.326232, 11.503654>, <1.880064, 3.256366, 11.500091>, 
      <2.180974, 3.359616, 11.377954>, <2.177609, 3.353788, 11.458426>, <2.090523, 3.228013, 11.503654>, <2.050186, 3.158146, 11.500091>, 
      <2.406518, 3.193070, 11.377954>, <2.402208, 3.187934, 11.458294>, <2.313974, 3.063286, 11.503655>, <2.262204, 3.001588, 11.500091>, 
      <2.565803, 3.057803, 11.377954>, <2.561493, 3.052667, 11.458294>, <2.463708, 2.936131, 11.503655>, <2.411937, 2.874433, 11.500091>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.365235, 3.750952, 11.377954>, <1.362942, 3.744652, 11.458294>, <1.310912, 3.601699, 11.503655>, <1.283365, 3.526015, 11.500091>, 
      <1.562022, 3.680640, 11.377954>, <1.559729, 3.674340, 11.458294>, <1.495898, 3.535603, 11.503655>, <1.468351, 3.459920, 11.500091>, 
      <1.819026, 3.568588, 11.377954>, <1.815661, 3.562759, 11.458426>, <1.750280, 3.424452, 11.503654>, <1.709943, 3.354586, 11.500091>, 
      <2.000000, 3.464102, 11.377954>, <1.996635, 3.458274, 11.458426>, <1.920401, 3.326232, 11.503654>, <1.880064, 3.256366, 11.500091>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.693148, 3.931037, 11.377954>, <0.691984, 3.924434, 11.458294>, <0.665568, 3.774618, 11.503655>, <0.651582, 3.695301, 11.500091>, 
      <0.898498, 3.893577, 11.377954>, <0.897334, 3.886974, 11.458294>, <0.858603, 3.739404, 11.503655>, <0.844617, 3.660087, 11.500091>, 
      <1.168667, 3.821185, 11.377954>, <1.166373, 3.814885, 11.458294>, <1.126131, 3.667720, 11.503655>, <1.098585, 3.592037, 11.500091>, 
      <1.365235, 3.750952, 11.377954>, <1.362942, 3.744652, 11.458294>, <1.310912, 3.601699, 11.503655>, <1.283365, 3.526015, 11.500091>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000001, 4.000000, 11.377954>, <0.000001, 3.993270, 11.458426>, <0.000000, 3.840802, 11.503654>, <0.000000, 3.760128, 11.500091>, 
      <0.208972, 4.000000, 11.377954>, <0.208972, 3.993270, 11.458426>, <0.196440, 3.840802, 11.503654>, <0.196440, 3.760128, 11.500091>, 
      <0.487570, 3.968539, 11.377954>, <0.486406, 3.961936, 11.458294>, <0.472317, 3.809871, 11.503655>, <0.458332, 3.730554, 11.500091>, 
      <0.693148, 3.931037, 11.377954>, <0.691984, 3.924434, 11.458294>, <0.665568, 3.774618, 11.503655>, <0.651582, 3.695301, 11.500091>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.693147, 3.931037, 11.377954>, <-0.691983, 3.924434, 11.458294>, <-0.665567, 3.774618, 11.503655>, <-0.651581, 3.695301, 11.500091>, 
      <-0.487569, 3.968539, 11.377954>, <-0.486404, 3.961936, 11.458294>, <-0.472316, 3.809871, 11.503655>, <-0.458331, 3.730554, 11.500091>, 
      <-0.208970, 4.000000, 11.377954>, <-0.208970, 3.993270, 11.458426>, <-0.196439, 3.840802, 11.503654>, <-0.196439, 3.760128, 11.500091>, 
      <0.000001, 4.000000, 11.377954>, <0.000001, 3.993270, 11.458426>, <0.000000, 3.840802, 11.503654>, <0.000000, 3.760128, 11.500091>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.365234, 3.750952, 11.377954>, <-1.362941, 3.744652, 11.458294>, <-1.310911, 3.601699, 11.503655>, <-1.283364, 3.526015, 11.500091>, 
      <-1.168666, 3.821185, 11.377954>, <-1.166372, 3.814885, 11.458294>, <-1.126130, 3.667720, 11.503655>, <-1.098584, 3.592037, 11.500091>, 
      <-0.898497, 3.893577, 11.377954>, <-0.897333, 3.886974, 11.458294>, <-0.858602, 3.739404, 11.503655>, <-0.844616, 3.660087, 11.500091>, 
      <-0.693147, 3.931037, 11.377954>, <-0.691983, 3.924434, 11.458294>, <-0.665567, 3.774618, 11.503655>, <-0.651581, 3.695301, 11.500091>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.000000, 3.464102, 11.377954>, <-1.996635, 3.458274, 11.458426>, <-1.920401, 3.326232, 11.503654>, <-1.880064, 3.256366, 11.500091>, 
      <-1.819026, 3.568588, 11.377954>, <-1.815661, 3.562759, 11.458426>, <-1.750280, 3.424452, 11.503654>, <-1.709942, 3.354586, 11.500091>, 
      <-1.562021, 3.680640, 11.377954>, <-1.559728, 3.674340, 11.458294>, <-1.495897, 3.535603, 11.503655>, <-1.468350, 3.459920, 11.500091>, 
      <-1.365234, 3.750952, 11.377954>, <-1.362941, 3.744652, 11.458294>, <-1.310911, 3.601699, 11.503655>, <-1.283364, 3.526015, 11.500091>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.565802, 3.057805, 11.377954>, <-2.561492, 3.052669, 11.458294>, <-2.463707, 2.936132, 11.503655>, <-2.411936, 2.874434, 11.500091>, 
      <-2.406517, 3.193072, 11.377954>, <-2.402207, 3.187936, 11.458294>, <-2.313974, 3.063287, 11.503655>, <-2.262203, 3.001589, 11.500091>, 
      <-2.180974, 3.359617, 11.377954>, <-2.177609, 3.353789, 11.458426>, <-2.090523, 3.228013, 11.503654>, <-2.050185, 3.158146, 11.500091>, 
      <-2.000000, 3.464102, 11.377954>, <-1.996635, 3.458274, 11.458426>, <-1.920401, 3.326232, 11.503654>, <-1.880064, 3.256366, 11.500091>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.057804, 2.565803, 11.377954>, <-3.052668, 2.561493, 11.458294>, <-2.936131, 2.463708, 11.503655>, <-2.874433, 2.411937, 11.500091>, 
      <-2.922688, 2.724911, 11.377954>, <-2.917551, 2.720601, 11.458294>, <-2.809117, 2.613275, 11.503655>, <-2.747419, 2.561504, 11.500091>, 
      <-2.724910, 2.922688, 11.377954>, <-2.720600, 2.917552, 11.458294>, <-2.613274, 2.809118, 11.503655>, <-2.561503, 2.747420, 11.500091>, 
      <-2.565802, 3.057805, 11.377954>, <-2.561492, 3.052669, 11.458294>, <-2.463707, 2.936132, 11.503655>, <-2.411936, 2.874434, 11.500091>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.464101, 2.000001, 11.377954>, <-3.458273, 1.996636, 11.458426>, <-3.326232, 1.920401, 11.503654>, <-3.256366, 1.880064, 11.500091>, 
      <-3.359616, 2.180975, 11.377954>, <-3.353788, 2.177610, 11.458426>, <-3.228012, 2.090523, 11.503654>, <-3.158146, 2.050186, 11.500091>, 
      <-3.193071, 2.406518, 11.377954>, <-3.187935, 2.402208, 11.458294>, <-3.063286, 2.313975, 11.503655>, <-3.001588, 2.262204, 11.500091>, 
      <-3.057804, 2.565803, 11.377954>, <-3.052668, 2.561493, 11.458294>, <-2.936131, 2.463708, 11.503655>, <-2.874433, 2.411937, 11.500091>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.750952, 1.365235, 11.377954>, <-3.744652, 1.362942, 11.458294>, <-3.601699, 1.310912, 11.503655>, <-3.526015, 1.283365, 11.500091>, 
      <-3.680640, 1.562022, 11.377954>, <-3.674340, 1.559729, 11.458294>, <-3.535604, 1.495898, 11.503655>, <-3.459920, 1.468351, 11.500091>, 
      <-3.568587, 1.819026, 11.377954>, <-3.562759, 1.815662, 11.458426>, <-3.424452, 1.750280, 11.503654>, <-3.354586, 1.709943, 11.500091>, 
      <-3.464101, 2.000001, 11.377954>, <-3.458273, 1.996636, 11.458426>, <-3.326232, 1.920401, 11.503654>, <-3.256366, 1.880064, 11.500091>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.931037, 0.693148, 11.377954>, <-3.924434, 0.691984, 11.458294>, <-3.774618, 0.665567, 11.503655>, <-3.695301, 0.651581, 11.500091>, 
      <-3.893577, 0.898498, 11.377954>, <-3.886974, 0.897334, 11.458294>, <-3.739404, 0.858603, 11.503655>, <-3.660087, 0.844617, 11.500091>, 
      <-3.821186, 1.168667, 11.377954>, <-3.814885, 1.166374, 11.458294>, <-3.667720, 1.126131, 11.503655>, <-3.592037, 1.098584, 11.500091>, 
      <-3.750952, 1.365235, 11.377954>, <-3.744652, 1.362942, 11.458294>, <-3.601699, 1.310912, 11.503655>, <-3.526015, 1.283365, 11.500091>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-4.000000, 0.000000, 11.377954>, <-3.993270, 0.000000, 11.458426>, <-3.840802, 0.000000, 11.503654>, <-3.760128, 0.000000, 11.500091>, 
      <-4.000000, 0.208971, 11.377954>, <-3.993270, 0.208971, 11.458426>, <-3.840802, 0.196439, 11.503654>, <-3.760128, 0.196439, 11.500091>, 
      <-3.968539, 0.487569, 11.377954>, <-3.961936, 0.486405, 11.458294>, <-3.809871, 0.472316, 11.503655>, <-3.730554, 0.458331, 11.500091>, 
      <-3.931037, 0.693148, 11.377954>, <-3.924434, 0.691984, 11.458294>, <-3.774618, 0.665567, 11.503655>, <-3.695301, 0.651581, 11.500091>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.931037, -0.693147, 11.377954>, <-3.924434, -0.691983, 11.458294>, <-3.774618, -0.665567, 11.503655>, <-3.695301, -0.651581, 11.500091>, 
      <-3.968539, -0.487569, 11.377954>, <-3.961936, -0.486405, 11.458294>, <-3.809871, -0.472316, 11.503655>, <-3.730554, -0.458331, 11.500091>, 
      <-4.000000, -0.208971, 11.377954>, <-3.993270, -0.208971, 11.458426>, <-3.840802, -0.196439, 11.503654>, <-3.760128, -0.196439, 11.500091>, 
      <-4.000000, 0.000000, 11.377954>, <-3.993270, 0.000000, 11.458426>, <-3.840802, 0.000000, 11.503654>, <-3.760128, 0.000000, 11.500091>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.750952, -1.365234, 11.377954>, <-3.744652, -1.362941, 11.458294>, <-3.601699, -1.310911, 11.503655>, <-3.526015, -1.283364, 11.500091>, 
      <-3.821185, -1.168666, 11.377954>, <-3.814885, -1.166372, 11.458294>, <-3.667720, -1.126130, 11.503655>, <-3.592037, -1.098584, 11.500091>, 
      <-3.893577, -0.898497, 11.377954>, <-3.886974, -0.897333, 11.458294>, <-3.739404, -0.858602, 11.503655>, <-3.660087, -0.844616, 11.500091>, 
      <-3.931037, -0.693147, 11.377954>, <-3.924434, -0.691983, 11.458294>, <-3.774618, -0.665567, 11.503655>, <-3.695301, -0.651581, 11.500091>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.464102, -2.000000, 11.377954>, <-3.458274, -1.996635, 11.458426>, <-3.326232, -1.920401, 11.503654>, <-3.256366, -1.880064, 11.500091>, 
      <-3.568588, -1.819026, 11.377954>, <-3.562759, -1.815661, 11.458426>, <-3.424452, -1.750280, 11.503654>, <-3.354586, -1.709942, 11.500091>, 
      <-3.680640, -1.562021, 11.377954>, <-3.674340, -1.559728, 11.458294>, <-3.535603, -1.495897, 11.503655>, <-3.459920, -1.468350, 11.500091>, 
      <-3.750952, -1.365234, 11.377954>, <-3.744652, -1.362941, 11.458294>, <-3.601699, -1.310911, 11.503655>, <-3.526015, -1.283364, 11.500091>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.057804, -2.565803, 11.377954>, <-3.052668, -2.561493, 11.458294>, <-2.936132, -2.463708, 11.503655>, <-2.874434, -2.411937, 11.500091>, 
      <-3.193071, -2.406518, 11.377954>, <-3.187935, -2.402208, 11.458294>, <-3.063287, -2.313974, 11.503655>, <-3.001589, -2.262204, 11.500091>, 
      <-3.359616, -2.180974, 11.377954>, <-3.353788, -2.177609, 11.458426>, <-3.228013, -2.090523, 11.503654>, <-3.158146, -2.050186, 11.500091>, 
      <-3.464102, -2.000000, 11.377954>, <-3.458274, -1.996635, 11.458426>, <-3.326232, -1.920401, 11.503654>, <-3.256366, -1.880064, 11.500091>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.565803, -3.057804, 11.377954>, <-2.561493, -3.052668, 11.458294>, <-2.463708, -2.936132, 11.503655>, <-2.411937, -2.874434, 11.500091>, 
      <-2.724911, -2.922688, 11.377954>, <-2.720601, -2.917552, 11.458294>, <-2.613274, -2.809119, 11.503655>, <-2.561504, -2.747421, 11.500091>, 
      <-2.922688, -2.724911, 11.377954>, <-2.917552, -2.720601, 11.458294>, <-2.809118, -2.613274, 11.503655>, <-2.747421, -2.561504, 11.500091>, 
      <-3.057804, -2.565803, 11.377954>, <-3.052668, -2.561493, 11.458294>, <-2.936132, -2.463708, 11.503655>, <-2.874434, -2.411937, 11.500091>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.000000, -3.464102, 11.377954>, <-1.996635, -3.458274, 11.458426>, <-1.920401, -3.326232, 11.503654>, <-1.880064, -3.256366, 11.500091>, 
      <-2.180974, -3.359616, 11.377954>, <-2.177609, -3.353788, 11.458426>, <-2.090523, -3.228013, 11.503654>, <-2.050186, -3.158146, 11.500091>, 
      <-2.406518, -3.193071, 11.377954>, <-2.402208, -3.187935, 11.458294>, <-2.313974, -3.063287, 11.503655>, <-2.262204, -3.001589, 11.500091>, 
      <-2.565803, -3.057804, 11.377954>, <-2.561493, -3.052668, 11.458294>, <-2.463708, -2.936132, 11.503655>, <-2.411937, -2.874434, 11.500091>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.365235, -3.750952, 11.377954>, <-1.362942, -3.744652, 11.458294>, <-1.310912, -3.601699, 11.503655>, <-1.283365, -3.526015, 11.500091>, 
      <-1.562022, -3.680640, 11.377954>, <-1.559729, -3.674340, 11.458294>, <-1.495898, -3.535604, 11.503655>, <-1.468351, -3.459920, 11.500091>, 
      <-1.819026, -3.568588, 11.377954>, <-1.815661, -3.562759, 11.458426>, <-1.750280, -3.424452, 11.503654>, <-1.709943, -3.354586, 11.500091>, 
      <-2.000000, -3.464102, 11.377954>, <-1.996635, -3.458274, 11.458426>, <-1.920401, -3.326232, 11.503654>, <-1.880064, -3.256366, 11.500091>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.693148, -3.931037, 11.377954>, <-0.691984, -3.924434, 11.458294>, <-0.665567, -3.774618, 11.503655>, <-0.651581, -3.695301, 11.500091>, 
      <-0.898498, -3.893577, 11.377954>, <-0.897334, -3.886974, 11.458294>, <-0.858603, -3.739404, 11.503655>, <-0.844617, -3.660087, 11.500091>, 
      <-1.168667, -3.821185, 11.377954>, <-1.166373, -3.814885, 11.458294>, <-1.126131, -3.667720, 11.503655>, <-1.098584, -3.592037, 11.500091>, 
      <-1.365235, -3.750952, 11.377954>, <-1.362942, -3.744652, 11.458294>, <-1.310912, -3.601699, 11.503655>, <-1.283365, -3.526015, 11.500091>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -4.000000, 11.377954>, <0.000000, -3.993270, 11.458426>, <0.000000, -3.840802, 11.503654>, <0.000000, -3.760128, 11.500091>, 
      <-0.208971, -4.000000, 11.377954>, <-0.208971, -3.993270, 11.458426>, <-0.196439, -3.840802, 11.503654>, <-0.196439, -3.760128, 11.500091>, 
      <-0.487569, -3.968539, 11.377954>, <-0.486405, -3.961936, 11.458294>, <-0.472316, -3.809871, 11.503655>, <-0.458331, -3.730554, 11.500091>, 
      <-0.693148, -3.931037, 11.377954>, <-0.691984, -3.924434, 11.458294>, <-0.665567, -3.774618, 11.503655>, <-0.651581, -3.695301, 11.500091>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.693148, -3.931037, 11.377954>, <0.691984, -3.924434, 11.458294>, <0.665567, -3.774618, 11.503655>, <0.651581, -3.695301, 11.500091>, 
      <0.487569, -3.968539, 11.377954>, <0.486405, -3.961936, 11.458294>, <0.472316, -3.809872, 11.503655>, <0.458331, -3.730554, 11.500091>, 
      <0.208971, -4.000000, 11.377954>, <0.208971, -3.993270, 11.458426>, <0.196439, -3.840802, 11.503654>, <0.196439, -3.760128, 11.500091>, 
      <0.000000, -4.000000, 11.377954>, <0.000000, -3.993270, 11.458426>, <0.000000, -3.840802, 11.503654>, <0.000000, -3.760128, 11.500091>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.365235, -3.750952, 11.377954>, <1.362942, -3.744652, 11.458294>, <1.310911, -3.601699, 11.503655>, <1.283364, -3.526015, 11.500091>, 
      <1.168667, -3.821185, 11.377954>, <1.166373, -3.814885, 11.458294>, <1.126130, -3.667720, 11.503655>, <1.098584, -3.592037, 11.500091>, 
      <0.898498, -3.893577, 11.377954>, <0.897334, -3.886974, 11.458294>, <0.858602, -3.739405, 11.503655>, <0.844616, -3.660087, 11.500091>, 
      <0.693148, -3.931037, 11.377954>, <0.691984, -3.924434, 11.458294>, <0.665567, -3.774618, 11.503655>, <0.651581, -3.695301, 11.500091>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.000000, -3.464102, 11.377954>, <1.996635, -3.458274, 11.458426>, <1.920401, -3.326232, 11.503654>, <1.880064, -3.256366, 11.500091>, 
      <1.819026, -3.568588, 11.377954>, <1.815661, -3.562759, 11.458426>, <1.750280, -3.424452, 11.503654>, <1.709942, -3.354586, 11.500091>, 
      <1.562022, -3.680640, 11.377954>, <1.559729, -3.674340, 11.458294>, <1.495897, -3.535604, 11.503655>, <1.468350, -3.459920, 11.500091>, 
      <1.365235, -3.750952, 11.377954>, <1.362942, -3.744652, 11.458294>, <1.310911, -3.601699, 11.503655>, <1.283364, -3.526015, 11.500091>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.565802, -3.057804, 11.377954>, <2.561492, -3.052668, 11.458294>, <2.463707, -2.936132, 11.503655>, <2.411936, -2.874434, 11.500091>, 
      <2.406517, -3.193071, 11.377954>, <2.402207, -3.187935, 11.458294>, <2.313974, -3.063287, 11.503655>, <2.262203, -3.001589, 11.500091>, 
      <2.180974, -3.359616, 11.377954>, <2.177609, -3.353788, 11.458426>, <2.090523, -3.228013, 11.503654>, <2.050185, -3.158146, 11.500091>, 
      <2.000000, -3.464102, 11.377954>, <1.996635, -3.458274, 11.458426>, <1.920401, -3.326232, 11.503654>, <1.880064, -3.256366, 11.500091>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.057804, -2.565803, 11.377954>, <3.052668, -2.561493, 11.458294>, <2.936132, -2.463708, 11.503655>, <2.874434, -2.411937, 11.500091>, 
      <2.922688, -2.724911, 11.377954>, <2.917552, -2.720601, 11.458294>, <2.809118, -2.613274, 11.503655>, <2.747420, -2.561504, 11.500091>, 
      <2.724910, -2.922688, 11.377954>, <2.720600, -2.917552, 11.458294>, <2.613274, -2.809118, 11.503655>, <2.561503, -2.747420, 11.500091>, 
      <2.565802, -3.057804, 11.377954>, <2.561492, -3.052668, 11.458294>, <2.463707, -2.936132, 11.503655>, <2.411936, -2.874434, 11.500091>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.464102, -2.000000, 11.377954>, <3.458274, -1.996635, 11.458426>, <3.326232, -1.920401, 11.503654>, <3.256366, -1.880064, 11.500091>, 
      <3.359616, -2.180974, 11.377954>, <3.353788, -2.177609, 11.458426>, <3.228013, -2.090523, 11.503654>, <3.158146, -2.050186, 11.500091>, 
      <3.193071, -2.406518, 11.377954>, <3.187935, -2.402208, 11.458294>, <3.063287, -2.313974, 11.503655>, <3.001589, -2.262204, 11.500091>, 
      <3.057804, -2.565803, 11.377954>, <3.052668, -2.561493, 11.458294>, <2.936132, -2.463708, 11.503655>, <2.874434, -2.411937, 11.500091>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.750952, -1.365235, 11.377954>, <3.744652, -1.362942, 11.458294>, <3.601699, -1.310912, 11.503655>, <3.526015, -1.283365, 11.500091>, 
      <3.680640, -1.562022, 11.377954>, <3.674340, -1.559729, 11.458294>, <3.535604, -1.495898, 11.503655>, <3.459920, -1.468351, 11.500091>, 
      <3.568588, -1.819026, 11.377954>, <3.562759, -1.815661, 11.458426>, <3.424452, -1.750280, 11.503654>, <3.354586, -1.709943, 11.500091>, 
      <3.464102, -2.000000, 11.377954>, <3.458274, -1.996635, 11.458426>, <3.326232, -1.920401, 11.503654>, <3.256366, -1.880064, 11.500091>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.931037, -0.693148, 11.377954>, <3.924434, -0.691984, 11.458294>, <3.774618, -0.665567, 11.503655>, <3.695301, -0.651581, 11.500091>, 
      <3.893577, -0.898498, 11.377954>, <3.886974, -0.897334, 11.458294>, <3.739404, -0.858603, 11.503655>, <3.660087, -0.844617, 11.500091>, 
      <3.821185, -1.168667, 11.377954>, <3.814885, -1.166373, 11.458294>, <3.667720, -1.126131, 11.503655>, <3.592037, -1.098584, 11.500091>, 
      <3.750952, -1.365235, 11.377954>, <3.744652, -1.362942, 11.458294>, <3.601699, -1.310912, 11.503655>, <3.526015, -1.283365, 11.500091>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.000000, 0.000000, 11.377954>, <3.993270, 0.000000, 11.458426>, <3.840802, 0.000000, 11.503654>, <3.760128, 0.000000, 11.500091>, 
      <4.000000, -0.208971, 11.377954>, <3.993270, -0.208971, 11.458426>, <3.840802, -0.196439, 11.503654>, <3.760128, -0.196439, 11.500091>, 
      <3.968539, -0.487569, 11.377954>, <3.961936, -0.486405, 11.458294>, <3.809871, -0.472316, 11.503655>, <3.730554, -0.458331, 11.500091>, 
      <3.931037, -0.693148, 11.377954>, <3.924434, -0.691984, 11.458294>, <3.774618, -0.665567, 11.503655>, <3.695301, -0.651581, 11.500091>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.000000, 0.000000, 11.377954>, <4.000000, 0.208971, 11.377954>, <3.968539, 0.487569, 11.377954>, <3.931037, 0.693147, 11.377954>, 
      <3.993270, 0.000000, 11.458426>, <3.993270, 0.208971, 11.458426>, <3.961936, 0.486405, 11.458294>, <3.924434, 0.691983, 11.458294>, 
      <3.840802, 0.000000, 11.503654>, <3.840802, 0.196439, 11.503654>, <3.809871, 0.472316, 11.503655>, <3.774618, 0.665566, 11.503655>, 
      <3.760128, 0.000000, 11.500091>, <3.760128, 0.196439, 11.500091>, <3.730554, 0.458330, 11.500091>, <3.695301, 0.651580, 11.500091>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.750952, 1.365234, 8.631811>, <3.831456, 1.394535, 9.451187>, <3.815336, 1.388668, 10.556965>, <3.750952, 1.365234, 11.377954>, 
      <3.821185, 1.168666, 8.631811>, <3.901689, 1.197967, 9.451187>, <3.885569, 1.192099, 10.556965>, <3.821185, 1.168666, 11.377954>, 
      <3.893577, 0.898497, 8.631811>, <3.977946, 0.913373, 9.451187>, <3.961052, 0.910395, 10.556965>, <3.893577, 0.898497, 11.377954>, 
      <3.931037, 0.693147, 8.631811>, <4.015406, 0.708024, 9.451187>, <3.998512, 0.705045, 10.556965>, <3.931037, 0.693147, 11.377954>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.464102, 1.999999, 8.631811>, <3.464102, 1.999999, 9.455654>, <3.523562, 2.034328, 10.556976>, <3.464102, 1.999999, 11.377954>, 
      <3.568587, 1.819025, 8.631811>, <3.568587, 1.819025, 9.455654>, <3.628047, 1.853354, 10.556976>, <3.568587, 1.819025, 11.377954>, 
      <3.680640, 1.562021, 8.631811>, <3.761144, 1.591322, 9.451187>, <3.745024, 1.585455, 10.556965>, <3.680640, 1.562021, 11.377954>, 
      <3.750952, 1.365234, 8.631811>, <3.831456, 1.394535, 9.451187>, <3.815336, 1.388668, 10.556965>, <3.750952, 1.365234, 11.377954>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.057805, 2.565802, 8.631811>, <3.123433, 2.620870, 9.451187>, <3.110291, 2.609843, 10.556965>, <3.057805, 2.565802, 11.377954>, 
      <3.193072, 2.406517, 8.631811>, <3.258699, 2.461585, 9.451187>, <3.245558, 2.450558, 10.556965>, <3.193072, 2.406517, 11.377954>, 
      <3.359617, 2.180974, 8.631811>, <3.359617, 2.180974, 9.455654>, <3.419076, 2.215302, 10.556976>, <3.359617, 2.180974, 11.377954>, 
      <3.464102, 1.999999, 8.631811>, <3.464102, 1.999999, 9.455654>, <3.523562, 2.034328, 10.556976>, <3.464102, 1.999999, 11.377954>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.565803, 3.057803, 8.631811>, <2.620871, 3.123430, 9.451187>, <2.609844, 3.110289, 10.556965>, <2.565803, 3.057803, 11.377954>, 
      <2.724911, 2.922687, 8.631811>, <2.779979, 2.988314, 9.451187>, <2.768952, 2.975173, 10.556965>, <2.724911, 2.922687, 11.377954>, 
      <2.922689, 2.724910, 8.631811>, <2.988316, 2.779978, 9.451187>, <2.975175, 2.768951, 10.556965>, <2.922689, 2.724910, 11.377954>, 
      <3.057805, 2.565802, 8.631811>, <3.123433, 2.620870, 9.451187>, <3.110291, 2.609843, 10.556965>, <3.057805, 2.565802, 11.377954>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.000000, 3.464102, 8.631811>, <2.000000, 3.464102, 9.455654>, <2.034329, 3.523562, 10.556976>, <2.000000, 3.464102, 11.377954>, 
      <2.180974, 3.359616, 8.631811>, <2.180974, 3.359616, 9.455654>, <2.215303, 3.419076, 10.556976>, <2.180974, 3.359616, 11.377954>, 
      <2.406518, 3.193070, 8.631811>, <2.461585, 3.258697, 9.451187>, <2.450559, 3.245556, 10.556965>, <2.406518, 3.193070, 11.377954>, 
      <2.565803, 3.057803, 8.631811>, <2.620871, 3.123430, 9.451187>, <2.609844, 3.110289, 10.556965>, <2.565803, 3.057803, 11.377954>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.365235, 3.750952, 8.631811>, <1.394536, 3.831456, 9.451187>, <1.388669, 3.815336, 10.556965>, <1.365235, 3.750952, 11.377954>, 
      <1.562022, 3.680640, 8.631811>, <1.591323, 3.761144, 9.451187>, <1.585456, 3.745024, 10.556965>, <1.562022, 3.680640, 11.377954>, 
      <1.819026, 3.568588, 8.631811>, <1.819026, 3.568588, 9.455654>, <1.853355, 3.628047, 10.556976>, <1.819026, 3.568588, 11.377954>, 
      <2.000000, 3.464102, 8.631811>, <2.000000, 3.464102, 9.455654>, <2.034329, 3.523562, 10.556976>, <2.000000, 3.464102, 11.377954>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.693148, 3.931037, 8.631811>, <0.708024, 4.015406, 9.451187>, <0.705045, 3.998512, 10.556965>, <0.693148, 3.931037, 11.377954>, 
      <0.898498, 3.893577, 8.631811>, <0.913374, 3.977946, 9.451187>, <0.910395, 3.961052, 10.556965>, <0.898498, 3.893577, 11.377954>, 
      <1.168667, 3.821185, 8.631811>, <1.197968, 3.901689, 9.451187>, <1.192100, 3.885569, 10.556965>, <1.168667, 3.821185, 11.377954>, 
      <1.365235, 3.750952, 8.631811>, <1.394536, 3.831456, 9.451187>, <1.388669, 3.815336, 10.556965>, <1.365235, 3.750952, 11.377954>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000001, 4.000000, 8.631811>, <0.000001, 4.000000, 9.455654>, <0.000001, 4.068658, 10.556976>, <0.000001, 4.000000, 11.377954>, 
      <0.208972, 4.000000, 8.631811>, <0.208972, 4.000000, 9.455654>, <0.208972, 4.068658, 10.556976>, <0.208972, 4.000000, 11.377954>, 
      <0.487570, 3.968539, 8.631811>, <0.502446, 4.052908, 9.451187>, <0.499467, 4.036014, 10.556965>, <0.487570, 3.968539, 11.377954>, 
      <0.693148, 3.931037, 8.631811>, <0.708024, 4.015406, 9.451187>, <0.705045, 3.998512, 10.556965>, <0.693148, 3.931037, 11.377954>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.693147, 3.931037, 8.631811>, <-0.708024, 4.015406, 9.451187>, <-0.705044, 3.998512, 10.556965>, <-0.693147, 3.931037, 11.377954>, 
      <-0.487569, 3.968539, 8.631811>, <-0.502445, 4.052908, 9.451187>, <-0.499466, 4.036014, 10.556965>, <-0.487569, 3.968539, 11.377954>, 
      <-0.208970, 4.000000, 8.631811>, <-0.208970, 4.000000, 9.455654>, <-0.208970, 4.068658, 10.556976>, <-0.208970, 4.000000, 11.377954>, 
      <0.000001, 4.000000, 8.631811>, <0.000001, 4.000000, 9.455654>, <0.000001, 4.068658, 10.556976>, <0.000001, 4.000000, 11.377954>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.365234, 3.750952, 8.631811>, <-1.394535, 3.831456, 9.451187>, <-1.388668, 3.815336, 10.556965>, <-1.365234, 3.750952, 11.377954>, 
      <-1.168666, 3.821185, 8.631811>, <-1.197967, 3.901689, 9.451187>, <-1.192099, 3.885569, 10.556965>, <-1.168666, 3.821185, 11.377954>, 
      <-0.898497, 3.893577, 8.631811>, <-0.913373, 3.977946, 9.451187>, <-0.910394, 3.961052, 10.556965>, <-0.898497, 3.893577, 11.377954>, 
      <-0.693147, 3.931037, 8.631811>, <-0.708024, 4.015406, 9.451187>, <-0.705044, 3.998512, 10.556965>, <-0.693147, 3.931037, 11.377954>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.000000, 3.464102, 8.631811>, <-2.000000, 3.464102, 9.455654>, <-2.034329, 3.523562, 10.556976>, <-2.000000, 3.464102, 11.377954>, 
      <-1.819026, 3.568588, 8.631811>, <-1.819026, 3.568588, 9.455654>, <-1.853354, 3.628047, 10.556976>, <-1.819026, 3.568588, 11.377954>, 
      <-1.562021, 3.680640, 8.631811>, <-1.591322, 3.761144, 9.451187>, <-1.585455, 3.745024, 10.556965>, <-1.562021, 3.680640, 11.377954>, 
      <-1.365234, 3.750952, 8.631811>, <-1.394535, 3.831456, 9.451187>, <-1.388668, 3.815336, 10.556965>, <-1.365234, 3.750952, 11.377954>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.565802, 3.057805, 8.631811>, <-2.620870, 3.123433, 9.451187>, <-2.609843, 3.110291, 10.556965>, <-2.565802, 3.057805, 11.377954>, 
      <-2.406517, 3.193072, 8.631811>, <-2.461585, 3.258699, 9.451187>, <-2.450558, 3.245558, 10.556965>, <-2.406517, 3.193072, 11.377954>, 
      <-2.180974, 3.359617, 8.631811>, <-2.180974, 3.359617, 9.455654>, <-2.215303, 3.419076, 10.556976>, <-2.180974, 3.359617, 11.377954>, 
      <-2.000000, 3.464102, 8.631811>, <-2.000000, 3.464102, 9.455654>, <-2.034329, 3.523562, 10.556976>, <-2.000000, 3.464102, 11.377954>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.057804, 2.565803, 8.631811>, <-3.123431, 2.620871, 9.451187>, <-3.110291, 2.609844, 10.556965>, <-3.057804, 2.565803, 11.377954>, 
      <-2.922688, 2.724911, 8.631811>, <-2.988315, 2.779979, 9.451187>, <-2.975174, 2.768952, 10.556965>, <-2.922688, 2.724911, 11.377954>, 
      <-2.724910, 2.922688, 8.631811>, <-2.779978, 2.988316, 9.451187>, <-2.768951, 2.975175, 10.556965>, <-2.724910, 2.922688, 11.377954>, 
      <-2.565802, 3.057805, 8.631811>, <-2.620870, 3.123433, 9.451187>, <-2.609843, 3.110291, 10.556965>, <-2.565802, 3.057805, 11.377954>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.464101, 2.000001, 8.631811>, <-3.464101, 2.000001, 9.455654>, <-3.523560, 2.034330, 10.556976>, <-3.464101, 2.000001, 11.377954>, 
      <-3.359616, 2.180975, 8.631811>, <-3.359616, 2.180975, 9.455654>, <-3.419075, 2.215304, 10.556976>, <-3.359616, 2.180975, 11.377954>, 
      <-3.193071, 2.406518, 8.631811>, <-3.258698, 2.461586, 9.451187>, <-3.245557, 2.450559, 10.556965>, <-3.193071, 2.406518, 11.377954>, 
      <-3.057804, 2.565803, 8.631811>, <-3.123431, 2.620871, 9.451187>, <-3.110291, 2.609844, 10.556965>, <-3.057804, 2.565803, 11.377954>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.750952, 1.365235, 8.631811>, <-3.831456, 1.394536, 9.451187>, <-3.815336, 1.388669, 10.556965>, <-3.750952, 1.365235, 11.377954>, 
      <-3.680640, 1.562022, 8.631811>, <-3.761144, 1.591323, 9.451187>, <-3.745024, 1.585456, 10.556965>, <-3.680640, 1.562022, 11.377954>, 
      <-3.568587, 1.819026, 8.631811>, <-3.568587, 1.819026, 9.455654>, <-3.628046, 1.853356, 10.556976>, <-3.568587, 1.819026, 11.377954>, 
      <-3.464101, 2.000001, 8.631811>, <-3.464101, 2.000001, 9.455654>, <-3.523560, 2.034330, 10.556976>, <-3.464101, 2.000001, 11.377954>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.931037, 0.693148, 8.631811>, <-4.015406, 0.708024, 9.451187>, <-3.998512, 0.705046, 10.556965>, <-3.931037, 0.693148, 11.377954>, 
      <-3.893577, 0.898498, 8.631811>, <-3.977946, 0.913374, 9.451187>, <-3.961052, 0.910396, 10.556965>, <-3.893577, 0.898498, 11.377954>, 
      <-3.821186, 1.168667, 8.631811>, <-3.901689, 1.197968, 9.451187>, <-3.885569, 1.192100, 10.556965>, <-3.821186, 1.168667, 11.377954>, 
      <-3.750952, 1.365235, 8.631811>, <-3.831456, 1.394536, 9.451187>, <-3.815336, 1.388669, 10.556965>, <-3.750952, 1.365235, 11.377954>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-4.000000, 0.000000, 8.631811>, <-4.000000, 0.000000, 9.455654>, <-4.068658, 0.000000, 10.556976>, <-4.000000, 0.000000, 11.377954>, 
      <-4.000000, 0.208971, 8.631811>, <-4.000000, 0.208971, 9.455654>, <-4.068658, 0.208971, 10.556976>, <-4.000000, 0.208971, 11.377954>, 
      <-3.968539, 0.487569, 8.631811>, <-4.052908, 0.502446, 9.451187>, <-4.036014, 0.499467, 10.556965>, <-3.968539, 0.487569, 11.377954>, 
      <-3.931037, 0.693148, 8.631811>, <-4.015406, 0.708024, 9.451187>, <-3.998512, 0.705046, 10.556965>, <-3.931037, 0.693148, 11.377954>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.931037, -0.693147, 8.631811>, <-4.015406, -0.708024, 9.451187>, <-3.998512, -0.705044, 10.556965>, <-3.931037, -0.693147, 11.377954>, 
      <-3.968539, -0.487569, 8.631811>, <-4.052908, -0.502445, 9.451187>, <-4.036014, -0.499466, 10.556965>, <-3.968539, -0.487569, 11.377954>, 
      <-4.000000, -0.208971, 8.631811>, <-4.000000, -0.208971, 9.455654>, <-4.068658, -0.208971, 10.556976>, <-4.000000, -0.208971, 11.377954>, 
      <-4.000000, 0.000000, 8.631811>, <-4.000000, 0.000000, 9.455654>, <-4.068658, 0.000000, 10.556976>, <-4.000000, 0.000000, 11.377954>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.750952, -1.365234, 8.631811>, <-3.831456, -1.394535, 9.451187>, <-3.815336, -1.388668, 10.556965>, <-3.750952, -1.365234, 11.377954>, 
      <-3.821185, -1.168666, 8.631811>, <-3.901689, -1.197967, 9.451187>, <-3.885569, -1.192099, 10.556965>, <-3.821185, -1.168666, 11.377954>, 
      <-3.893577, -0.898497, 8.631811>, <-3.977946, -0.913373, 9.451187>, <-3.961052, -0.910394, 10.556965>, <-3.893577, -0.898497, 11.377954>, 
      <-3.931037, -0.693147, 8.631811>, <-4.015406, -0.708024, 9.451187>, <-3.998512, -0.705044, 10.556965>, <-3.931037, -0.693147, 11.377954>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.464102, -2.000000, 8.631811>, <-3.464102, -2.000000, 9.455654>, <-3.523562, -2.034329, 10.556976>, <-3.464102, -2.000000, 11.377954>, 
      <-3.568588, -1.819026, 8.631811>, <-3.568588, -1.819026, 9.455654>, <-3.628047, -1.853354, 10.556976>, <-3.568588, -1.819026, 11.377954>, 
      <-3.680640, -1.562021, 8.631811>, <-3.761144, -1.591322, 9.451187>, <-3.745024, -1.585455, 10.556965>, <-3.680640, -1.562021, 11.377954>, 
      <-3.750952, -1.365234, 8.631811>, <-3.831456, -1.394535, 9.451187>, <-3.815336, -1.388668, 10.556965>, <-3.750952, -1.365234, 11.377954>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.057804, -2.565803, 8.631811>, <-3.123431, -2.620871, 9.451187>, <-3.110290, -2.609844, 10.556965>, <-3.057804, -2.565803, 11.377954>, 
      <-3.193071, -2.406518, 8.631811>, <-3.258698, -2.461586, 9.451187>, <-3.245557, -2.450559, 10.556965>, <-3.193071, -2.406518, 11.377954>, 
      <-3.359616, -2.180974, 8.631811>, <-3.359616, -2.180974, 9.455654>, <-3.419076, -2.215303, 10.556976>, <-3.359616, -2.180974, 11.377954>, 
      <-3.464102, -2.000000, 8.631811>, <-3.464102, -2.000000, 9.455654>, <-3.523562, -2.034329, 10.556976>, <-3.464102, -2.000000, 11.377954>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.565803, -3.057804, 8.631811>, <-2.620871, -3.123431, 9.451187>, <-2.609844, -3.110290, 10.556965>, <-2.565803, -3.057804, 11.377954>, 
      <-2.724911, -2.922688, 8.631811>, <-2.779979, -2.988315, 9.451187>, <-2.768952, -2.975174, 10.556965>, <-2.724911, -2.922688, 11.377954>, 
      <-2.922688, -2.724911, 8.631811>, <-2.988315, -2.779979, 9.451187>, <-2.975174, -2.768952, 10.556965>, <-2.922688, -2.724911, 11.377954>, 
      <-3.057804, -2.565803, 8.631811>, <-3.123431, -2.620871, 9.451187>, <-3.110290, -2.609844, 10.556965>, <-3.057804, -2.565803, 11.377954>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.000000, -3.464102, 8.631811>, <-2.000000, -3.464102, 9.455654>, <-2.034329, -3.523562, 10.556976>, <-2.000000, -3.464102, 11.377954>, 
      <-2.180974, -3.359616, 8.631811>, <-2.180974, -3.359616, 9.455654>, <-2.215303, -3.419076, 10.556976>, <-2.180974, -3.359616, 11.377954>, 
      <-2.406518, -3.193071, 8.631811>, <-2.461586, -3.258698, 9.451187>, <-2.450559, -3.245557, 10.556965>, <-2.406518, -3.193071, 11.377954>, 
      <-2.565803, -3.057804, 8.631811>, <-2.620871, -3.123431, 9.451187>, <-2.609844, -3.110290, 10.556965>, <-2.565803, -3.057804, 11.377954>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.365235, -3.750952, 8.631811>, <-1.394536, -3.831456, 9.451187>, <-1.388669, -3.815336, 10.556965>, <-1.365235, -3.750952, 11.377954>, 
      <-1.562022, -3.680640, 8.631811>, <-1.591323, -3.761144, 9.451187>, <-1.585456, -3.745024, 10.556965>, <-1.562022, -3.680640, 11.377954>, 
      <-1.819026, -3.568588, 8.631811>, <-1.819026, -3.568588, 9.455654>, <-1.853355, -3.628047, 10.556976>, <-1.819026, -3.568588, 11.377954>, 
      <-2.000000, -3.464102, 8.631811>, <-2.000000, -3.464102, 9.455654>, <-2.034329, -3.523562, 10.556976>, <-2.000000, -3.464102, 11.377954>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.693148, -3.931037, 8.631811>, <-0.708024, -4.015406, 9.451187>, <-0.705046, -3.998512, 10.556965>, <-0.693148, -3.931037, 11.377954>, 
      <-0.898498, -3.893577, 8.631811>, <-0.913374, -3.977946, 9.451187>, <-0.910396, -3.961052, 10.556965>, <-0.898498, -3.893577, 11.377954>, 
      <-1.168667, -3.821185, 8.631811>, <-1.197968, -3.901689, 9.451187>, <-1.192100, -3.885569, 10.556965>, <-1.168667, -3.821185, 11.377954>, 
      <-1.365235, -3.750952, 8.631811>, <-1.394536, -3.831456, 9.451187>, <-1.388669, -3.815336, 10.556965>, <-1.365235, -3.750952, 11.377954>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -4.000000, 8.631811>, <0.000000, -4.000000, 9.455654>, <0.000000, -4.068658, 10.556976>, <0.000000, -4.000000, 11.377954>, 
      <-0.208971, -4.000000, 8.631811>, <-0.208971, -4.000000, 9.455654>, <-0.208971, -4.068658, 10.556976>, <-0.208971, -4.000000, 11.377954>, 
      <-0.487569, -3.968539, 8.631811>, <-0.502446, -4.052908, 9.451187>, <-0.499467, -4.036014, 10.556965>, <-0.487569, -3.968539, 11.377954>, 
      <-0.693148, -3.931037, 8.631811>, <-0.708024, -4.015406, 9.451187>, <-0.705046, -3.998512, 10.556965>, <-0.693148, -3.931037, 11.377954>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.693148, -3.931037, 8.631811>, <0.708025, -4.015406, 9.451187>, <0.705046, -3.998512, 10.556965>, <0.693148, -3.931037, 11.377954>, 
      <0.487569, -3.968539, 8.631811>, <0.502446, -4.052908, 9.451187>, <0.499467, -4.036014, 10.556965>, <0.487569, -3.968539, 11.377954>, 
      <0.208971, -4.000000, 8.631811>, <0.208971, -4.000000, 9.455654>, <0.208971, -4.068658, 10.556976>, <0.208971, -4.000000, 11.377954>, 
      <0.000000, -4.000000, 8.631811>, <0.000000, -4.000000, 9.455654>, <0.000000, -4.068658, 10.556976>, <0.000000, -4.000000, 11.377954>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.365235, -3.750952, 8.631811>, <1.394536, -3.831456, 9.451187>, <1.388669, -3.815336, 10.556965>, <1.365235, -3.750952, 11.377954>, 
      <1.168667, -3.821185, 8.631811>, <1.197968, -3.901689, 9.451187>, <1.192101, -3.885569, 10.556965>, <1.168667, -3.821185, 11.377954>, 
      <0.898498, -3.893577, 8.631811>, <0.913374, -3.977946, 9.451187>, <0.910396, -3.961052, 10.556965>, <0.898498, -3.893577, 11.377954>, 
      <0.693148, -3.931037, 8.631811>, <0.708025, -4.015406, 9.451187>, <0.705046, -3.998512, 10.556965>, <0.693148, -3.931037, 11.377954>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.000000, -3.464102, 8.631811>, <2.000000, -3.464102, 9.455654>, <2.034329, -3.523562, 10.556976>, <2.000000, -3.464102, 11.377954>, 
      <1.819026, -3.568588, 8.631811>, <1.819026, -3.568588, 9.455654>, <1.853355, -3.628047, 10.556976>, <1.819026, -3.568588, 11.377954>, 
      <1.562022, -3.680640, 8.631811>, <1.591323, -3.761144, 9.451187>, <1.585456, -3.745024, 10.556965>, <1.562022, -3.680640, 11.377954>, 
      <1.365235, -3.750952, 8.631811>, <1.394536, -3.831456, 9.451187>, <1.388669, -3.815336, 10.556965>, <1.365235, -3.750952, 11.377954>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.565802, -3.057804, 8.631811>, <2.620870, -3.123431, 9.451187>, <2.609843, -3.110290, 10.556965>, <2.565802, -3.057804, 11.377954>, 
      <2.406517, -3.193071, 8.631811>, <2.461585, -3.258698, 9.451187>, <2.450558, -3.245557, 10.556965>, <2.406517, -3.193071, 11.377954>, 
      <2.180974, -3.359616, 8.631811>, <2.180974, -3.359616, 9.455654>, <2.215303, -3.419076, 10.556976>, <2.180974, -3.359616, 11.377954>, 
      <2.000000, -3.464102, 8.631811>, <2.000000, -3.464102, 9.455654>, <2.034329, -3.523562, 10.556976>, <2.000000, -3.464102, 11.377954>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.057804, -2.565803, 8.631811>, <3.123431, -2.620871, 9.451187>, <3.110290, -2.609844, 10.556965>, <3.057804, -2.565803, 11.377954>, 
      <2.922688, -2.724911, 8.631811>, <2.988315, -2.779979, 9.451187>, <2.975174, -2.768952, 10.556965>, <2.922688, -2.724911, 11.377954>, 
      <2.724910, -2.922688, 8.631811>, <2.779978, -2.988315, 9.451187>, <2.768951, -2.975174, 10.556965>, <2.724910, -2.922688, 11.377954>, 
      <2.565802, -3.057804, 8.631811>, <2.620870, -3.123431, 9.451187>, <2.609843, -3.110290, 10.556965>, <2.565802, -3.057804, 11.377954>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.464102, -2.000000, 8.631811>, <3.464102, -2.000000, 9.455654>, <3.523562, -2.034329, 10.556976>, <3.464102, -2.000000, 11.377954>, 
      <3.359616, -2.180974, 8.631811>, <3.359616, -2.180974, 9.455654>, <3.419076, -2.215303, 10.556976>, <3.359616, -2.180974, 11.377954>, 
      <3.193071, -2.406518, 8.631811>, <3.258698, -2.461586, 9.451187>, <3.245557, -2.450559, 10.556965>, <3.193071, -2.406518, 11.377954>, 
      <3.057804, -2.565803, 8.631811>, <3.123431, -2.620871, 9.451187>, <3.110290, -2.609844, 10.556965>, <3.057804, -2.565803, 11.377954>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.750952, -1.365235, 8.631811>, <3.831456, -1.394536, 9.451187>, <3.815336, -1.388669, 10.556965>, <3.750952, -1.365235, 11.377954>, 
      <3.680640, -1.562022, 8.631811>, <3.761144, -1.591323, 9.451187>, <3.745024, -1.585456, 10.556965>, <3.680640, -1.562022, 11.377954>, 
      <3.568588, -1.819026, 8.631811>, <3.568588, -1.819026, 9.455654>, <3.628047, -1.853355, 10.556976>, <3.568588, -1.819026, 11.377954>, 
      <3.464102, -2.000000, 8.631811>, <3.464102, -2.000000, 9.455654>, <3.523562, -2.034329, 10.556976>, <3.464102, -2.000000, 11.377954>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.931037, -0.693148, 8.631811>, <4.015406, -0.708025, 9.451187>, <3.998512, -0.705046, 10.556965>, <3.931037, -0.693148, 11.377954>, 
      <3.893577, -0.898498, 8.631811>, <3.977946, -0.913374, 9.451187>, <3.961052, -0.910396, 10.556965>, <3.893577, -0.898498, 11.377954>, 
      <3.821185, -1.168667, 8.631811>, <3.901689, -1.197968, 9.451187>, <3.885569, -1.192100, 10.556965>, <3.821185, -1.168667, 11.377954>, 
      <3.750952, -1.365235, 8.631811>, <3.831456, -1.394536, 9.451187>, <3.815336, -1.388669, 10.556965>, <3.750952, -1.365235, 11.377954>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.000000, 0.000000, 8.631811>, <4.000000, 0.000000, 9.455654>, <4.068658, 0.000000, 10.556976>, <4.000000, 0.000000, 11.377954>, 
      <4.000000, -0.208971, 8.631811>, <4.000000, -0.208971, 9.455654>, <4.068658, -0.208971, 10.556976>, <4.000000, -0.208971, 11.377954>, 
      <3.968539, -0.487569, 8.631811>, <4.052908, -0.502446, 9.451187>, <4.036014, -0.499467, 10.556965>, <3.968539, -0.487569, 11.377954>, 
      <3.931037, -0.693148, 8.631811>, <4.015406, -0.708025, 9.451187>, <3.998512, -0.705046, 10.556965>, <3.931037, -0.693148, 11.377954>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.000000, 0.000000, 8.631811>, <4.000000, 0.208971, 8.631811>, <3.968539, 0.487569, 8.631811>, <3.931037, 0.693147, 8.631811>, 
      <4.000000, 0.000000, 9.455654>, <4.000000, 0.208971, 9.455654>, <4.052908, 0.502445, 9.451187>, <4.015406, 0.708024, 9.451187>, 
      <4.068658, 0.000000, 10.556976>, <4.068658, 0.208971, 10.556976>, <4.036014, 0.499467, 10.556965>, <3.998512, 0.705045, 10.556965>, 
      <4.000000, 0.000000, 11.377954>, <4.000000, 0.208971, 11.377954>, <3.968539, 0.487569, 11.377954>, <3.931037, 0.693147, 11.377954>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.382894, 1.231272, 7.631812>, <3.408161, 1.240468, 7.952879>, <3.719468, 1.353775, 8.311367>, <3.750952, 1.365234, 8.631811>, 
      <3.393994, 1.043343, 7.631812>, <3.419261, 1.052540, 7.952879>, <3.789702, 1.157207, 8.311367>, <3.821185, 1.168666, 8.631811>, 
      <3.460956, 0.793434, 7.631812>, <3.487437, 0.798103, 7.952879>, <3.860582, 0.892679, 8.311367>, <3.893577, 0.898497, 8.631811>, 
      <3.545308, 0.625133, 7.631812>, <3.571788, 0.629802, 7.952879>, <3.898042, 0.687329, 8.311367>, <3.931037, 0.693147, 8.631811>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.464102, 1.999999, 7.631812>, <3.474219, 2.005840, 7.931584>, <3.464102, 1.999999, 8.331812>, <3.464102, 1.999999, 8.631811>, 
      <3.580053, 1.799167, 7.631812>, <3.590170, 1.805008, 7.931584>, <3.568587, 1.819025, 8.331812>, <3.568587, 1.819025, 8.631811>, 
      <3.369221, 1.462770, 7.631812>, <3.394488, 1.471966, 7.952879>, <3.649157, 1.550562, 8.311367>, <3.680640, 1.562021, 8.631811>, 
      <3.382894, 1.231272, 7.631812>, <3.408161, 1.240468, 7.952879>, <3.719468, 1.353775, 8.311367>, <3.750952, 1.365234, 8.631811>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.757760, 2.314034, 7.631812>, <2.778358, 2.331318, 7.952879>, <3.032139, 2.544266, 8.311367>, <3.057805, 2.565802, 8.631811>, 
      <2.951406, 2.186443, 7.631812>, <2.972004, 2.203727, 7.952879>, <3.167406, 2.384981, 8.311367>, <3.193072, 2.406517, 8.631811>, 
      <3.348151, 2.200832, 7.631812>, <3.358268, 2.206673, 7.931584>, <3.359617, 2.180974, 8.331812>, <3.359617, 2.180974, 8.631811>, 
      <3.464102, 1.999999, 7.631812>, <3.474219, 2.005840, 7.931584>, <3.464102, 1.999999, 8.331812>, <3.464102, 1.999999, 8.631811>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.314036, 2.757759, 7.631812>, <2.331320, 2.778357, 7.952879>, <2.544267, 3.032137, 8.311367>, <2.565803, 3.057803, 8.631811>, 
      <2.417613, 2.600558, 7.631812>, <2.434897, 2.621156, 7.952879>, <2.703375, 2.897021, 8.311367>, <2.724911, 2.922687, 8.631811>, 
      <2.600559, 2.417611, 7.631812>, <2.621157, 2.434895, 7.952879>, <2.897023, 2.703374, 8.311367>, <2.922689, 2.724910, 8.631811>, 
      <2.757760, 2.314034, 7.631812>, <2.778358, 2.331318, 7.952879>, <3.032139, 2.544266, 8.311367>, <3.057805, 2.565802, 8.631811>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.000000, 3.464102, 7.631812>, <2.005841, 3.474219, 7.931584>, <2.000000, 3.464102, 8.331812>, <2.000000, 3.464102, 8.631811>, 
      <2.200833, 3.348151, 7.631812>, <2.206674, 3.358268, 7.931584>, <2.180974, 3.359616, 8.331812>, <2.180974, 3.359616, 8.631811>, 
      <2.186445, 2.951406, 7.631812>, <2.203729, 2.972004, 7.952879>, <2.384981, 3.167404, 8.311367>, <2.406518, 3.193070, 8.631811>, 
      <2.314036, 2.757759, 7.631812>, <2.331320, 2.778357, 7.952879>, <2.544267, 3.032137, 8.311367>, <2.565803, 3.057803, 8.631811>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.231273, 3.382893, 7.631812>, <1.240469, 3.408160, 7.952879>, <1.353776, 3.719468, 8.311367>, <1.365235, 3.750952, 8.631811>, 
      <1.462771, 3.369220, 7.631812>, <1.471967, 3.394487, 7.952879>, <1.550563, 3.649157, 8.311367>, <1.562022, 3.680640, 8.631811>, 
      <1.799168, 3.580053, 7.631812>, <1.805009, 3.590170, 7.931584>, <1.819026, 3.568588, 8.331812>, <1.819026, 3.568588, 8.631811>, 
      <2.000000, 3.464102, 7.631812>, <2.005841, 3.474219, 7.931584>, <2.000000, 3.464102, 8.331812>, <2.000000, 3.464102, 8.631811>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.625134, 3.545308, 7.631812>, <0.629803, 3.571788, 7.952879>, <0.687330, 3.898042, 8.311367>, <0.693148, 3.931037, 8.631811>, 
      <0.793435, 3.460956, 7.631812>, <0.798104, 3.487437, 7.952879>, <0.892680, 3.860582, 8.311367>, <0.898498, 3.893577, 8.631811>, 
      <1.043344, 3.393993, 7.631812>, <1.052541, 3.419260, 7.952879>, <1.157207, 3.789702, 8.311367>, <1.168667, 3.821185, 8.631811>, 
      <1.231273, 3.382893, 7.631812>, <1.240469, 3.408160, 7.952879>, <1.353776, 3.719468, 8.311367>, <1.365235, 3.750952, 8.631811>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000001, 4.000000, 7.631812>, <0.000001, 4.011682, 7.931584>, <0.000001, 4.000000, 8.331812>, <0.000001, 4.000000, 8.631811>, 
      <0.231902, 4.000000, 7.631812>, <0.231902, 4.011682, 7.931584>, <0.208972, 4.000000, 8.331812>, <0.208972, 4.000000, 8.631811>, 
      <0.417814, 3.649216, 7.631812>, <0.422484, 3.675696, 7.952879>, <0.481752, 3.935544, 8.311367>, <0.487570, 3.968539, 8.631811>, 
      <0.625134, 3.545308, 7.631812>, <0.629803, 3.571788, 7.952879>, <0.687330, 3.898042, 8.311367>, <0.693148, 3.931037, 8.631811>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.625133, 3.545308, 7.631812>, <-0.629802, 3.571788, 7.952879>, <-0.687329, 3.898042, 8.311367>, <-0.693147, 3.931037, 8.631811>, 
      <-0.417813, 3.649216, 7.631812>, <-0.422482, 3.675696, 7.952879>, <-0.481751, 3.935544, 8.311367>, <-0.487569, 3.968539, 8.631811>, 
      <-0.231901, 4.000000, 7.631812>, <-0.231901, 4.011682, 7.931584>, <-0.208970, 4.000000, 8.331812>, <-0.208970, 4.000000, 8.631811>, 
      <0.000001, 4.000000, 7.631812>, <0.000001, 4.011682, 7.931584>, <0.000001, 4.000000, 8.331812>, <0.000001, 4.000000, 8.631811>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.231272, 3.382894, 7.631812>, <-1.240468, 3.408161, 7.952879>, <-1.353775, 3.719468, 8.311367>, <-1.365234, 3.750952, 8.631811>, 
      <-1.043343, 3.393994, 7.631812>, <-1.052540, 3.419261, 7.952879>, <-1.157207, 3.789702, 8.311367>, <-1.168666, 3.821185, 8.631811>, 
      <-0.793434, 3.460956, 7.631812>, <-0.798103, 3.487437, 7.952879>, <-0.892679, 3.860582, 8.311367>, <-0.898497, 3.893577, 8.631811>, 
      <-0.625133, 3.545308, 7.631812>, <-0.629802, 3.571788, 7.952879>, <-0.687329, 3.898042, 8.311367>, <-0.693147, 3.931037, 8.631811>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.000000, 3.464102, 7.631812>, <-2.005841, 3.474219, 7.931584>, <-2.000000, 3.464102, 8.331812>, <-2.000000, 3.464102, 8.631811>, 
      <-1.799167, 3.580053, 7.631812>, <-1.805009, 3.590170, 7.931584>, <-1.819026, 3.568588, 8.331812>, <-1.819026, 3.568588, 8.631811>, 
      <-1.462770, 3.369221, 7.631812>, <-1.471967, 3.394488, 7.952879>, <-1.550562, 3.649157, 8.311367>, <-1.562021, 3.680640, 8.631811>, 
      <-1.231272, 3.382894, 7.631812>, <-1.240468, 3.408161, 7.952879>, <-1.353775, 3.719468, 8.311367>, <-1.365234, 3.750952, 8.631811>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.314035, 2.757760, 7.631812>, <-2.331319, 2.778358, 7.952879>, <-2.544266, 3.032139, 8.311367>, <-2.565802, 3.057805, 8.631811>, 
      <-2.186444, 2.951406, 7.631812>, <-2.203728, 2.972004, 7.952879>, <-2.384981, 3.167406, 8.311367>, <-2.406517, 3.193072, 8.631811>, 
      <-2.200833, 3.348151, 7.631812>, <-2.206674, 3.358268, 7.931584>, <-2.180974, 3.359617, 8.331812>, <-2.180974, 3.359617, 8.631811>, 
      <-2.000000, 3.464102, 7.631812>, <-2.005841, 3.474219, 7.931584>, <-2.000000, 3.464102, 8.331812>, <-2.000000, 3.464102, 8.631811>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.757760, 2.314036, 7.631812>, <-2.778358, 2.331320, 7.952879>, <-3.032138, 2.544267, 8.311367>, <-3.057804, 2.565803, 8.631811>, 
      <-2.600559, 2.417613, 7.631812>, <-2.621157, 2.434897, 7.952879>, <-2.897022, 2.703375, 8.311367>, <-2.922688, 2.724911, 8.631811>, 
      <-2.417612, 2.600559, 7.631812>, <-2.434896, 2.621157, 7.952879>, <-2.703374, 2.897023, 8.311367>, <-2.724910, 2.922688, 8.631811>, 
      <-2.314035, 2.757760, 7.631812>, <-2.331319, 2.778358, 7.952879>, <-2.544266, 3.032139, 8.311367>, <-2.565802, 3.057805, 8.631811>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.464101, 2.000001, 7.631812>, <-3.474218, 2.005842, 7.931584>, <-3.464101, 2.000001, 8.331812>, <-3.464101, 2.000001, 8.631811>, 
      <-3.348150, 2.200833, 7.631812>, <-3.358268, 2.206675, 7.931584>, <-3.359616, 2.180975, 8.331812>, <-3.359616, 2.180975, 8.631811>, 
      <-2.951406, 2.186445, 7.631812>, <-2.972004, 2.203729, 7.952879>, <-3.167405, 2.384982, 8.311367>, <-3.193071, 2.406518, 8.631811>, 
      <-2.757760, 2.314036, 7.631812>, <-2.778358, 2.331320, 7.952879>, <-3.032138, 2.544267, 8.311367>, <-3.057804, 2.565803, 8.631811>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.382893, 1.231273, 7.631812>, <-3.408160, 1.240469, 7.952879>, <-3.719468, 1.353776, 8.311367>, <-3.750952, 1.365235, 8.631811>, 
      <-3.369220, 1.462771, 7.631812>, <-3.394487, 1.471968, 7.952879>, <-3.649156, 1.550563, 8.311367>, <-3.680640, 1.562022, 8.631811>, 
      <-3.580052, 1.799168, 7.631812>, <-3.590169, 1.805009, 7.931584>, <-3.568587, 1.819026, 8.331812>, <-3.568587, 1.819026, 8.631811>, 
      <-3.464101, 2.000001, 7.631812>, <-3.474218, 2.005842, 7.931584>, <-3.464101, 2.000001, 8.331812>, <-3.464101, 2.000001, 8.631811>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.545308, 0.625134, 7.631812>, <-3.571788, 0.629803, 7.952879>, <-3.898042, 0.687330, 8.311367>, <-3.931037, 0.693148, 8.631811>, 
      <-3.460956, 0.793435, 7.631812>, <-3.487437, 0.798104, 7.952879>, <-3.860582, 0.892680, 8.311367>, <-3.893577, 0.898498, 8.631811>, 
      <-3.393993, 1.043344, 7.631812>, <-3.419260, 1.052541, 7.952879>, <-3.789702, 1.157208, 8.311367>, <-3.821186, 1.168667, 8.631811>, 
      <-3.382893, 1.231273, 7.631812>, <-3.408160, 1.240469, 7.952879>, <-3.719468, 1.353776, 8.311367>, <-3.750952, 1.365235, 8.631811>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-4.000000, 0.000000, 7.631812>, <-4.011682, 0.000000, 7.931584>, <-4.000000, 0.000000, 8.331812>, <-4.000000, 0.000000, 8.631811>, 
      <-4.000000, 0.231902, 7.631812>, <-4.011682, 0.231902, 7.931584>, <-4.000000, 0.208971, 8.331812>, <-4.000000, 0.208971, 8.631811>, 
      <-3.649216, 0.417814, 7.631812>, <-3.675696, 0.422483, 7.952879>, <-3.935544, 0.481752, 8.311367>, <-3.968539, 0.487569, 8.631811>, 
      <-3.545308, 0.625134, 7.631812>, <-3.571788, 0.629803, 7.952879>, <-3.898042, 0.687330, 8.311367>, <-3.931037, 0.693148, 8.631811>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.545308, -0.625133, 7.631812>, <-3.571788, -0.629802, 7.952879>, <-3.898042, -0.687329, 8.311367>, <-3.931037, -0.693147, 8.631811>, 
      <-3.649216, -0.417813, 7.631812>, <-3.675696, -0.422482, 7.952879>, <-3.935544, -0.481751, 8.311367>, <-3.968539, -0.487569, 8.631811>, 
      <-4.000000, -0.231901, 7.631812>, <-4.011682, -0.231901, 7.931584>, <-4.000000, -0.208971, 8.331812>, <-4.000000, -0.208971, 8.631811>, 
      <-4.000000, 0.000000, 7.631812>, <-4.011682, 0.000000, 7.931584>, <-4.000000, 0.000000, 8.331812>, <-4.000000, 0.000000, 8.631811>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.382894, -1.231272, 7.631812>, <-3.408161, -1.240468, 7.952879>, <-3.719468, -1.353775, 8.311367>, <-3.750952, -1.365234, 8.631811>, 
      <-3.393994, -1.043343, 7.631812>, <-3.419261, -1.052540, 7.952879>, <-3.789702, -1.157207, 8.311367>, <-3.821185, -1.168666, 8.631811>, 
      <-3.460956, -0.793434, 7.631812>, <-3.487437, -0.798103, 7.952879>, <-3.860582, -0.892679, 8.311367>, <-3.893577, -0.898497, 8.631811>, 
      <-3.545308, -0.625133, 7.631812>, <-3.571788, -0.629802, 7.952879>, <-3.898042, -0.687329, 8.311367>, <-3.931037, -0.693147, 8.631811>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.464102, -2.000000, 7.631812>, <-3.474219, -2.005841, 7.931584>, <-3.464102, -2.000000, 8.331812>, <-3.464102, -2.000000, 8.631811>, 
      <-3.580053, -1.799167, 7.631812>, <-3.590170, -1.805009, 7.931584>, <-3.568588, -1.819026, 8.331812>, <-3.568588, -1.819026, 8.631811>, 
      <-3.369221, -1.462770, 7.631812>, <-3.394488, -1.471967, 7.952879>, <-3.649157, -1.550562, 8.311367>, <-3.680640, -1.562021, 8.631811>, 
      <-3.382894, -1.231272, 7.631812>, <-3.408161, -1.240468, 7.952879>, <-3.719468, -1.353775, 8.311367>, <-3.750952, -1.365234, 8.631811>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.757760, -2.314035, 7.631812>, <-2.778358, -2.331319, 7.952879>, <-3.032138, -2.544267, 8.311367>, <-3.057804, -2.565803, 8.631811>, 
      <-2.951407, -2.186445, 7.631812>, <-2.972005, -2.203728, 7.952879>, <-3.167405, -2.384981, 8.311367>, <-3.193071, -2.406518, 8.631811>, 
      <-3.348151, -2.200833, 7.631812>, <-3.358268, -2.206674, 7.931584>, <-3.359616, -2.180974, 8.331812>, <-3.359616, -2.180974, 8.631811>, 
      <-3.464102, -2.000000, 7.631812>, <-3.474219, -2.005841, 7.931584>, <-3.464102, -2.000000, 8.331812>, <-3.464102, -2.000000, 8.631811>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.314035, -2.757760, 7.631812>, <-2.331319, -2.778358, 7.952879>, <-2.544267, -3.032138, 8.311367>, <-2.565803, -3.057804, 8.631811>, 
      <-2.417612, -2.600559, 7.631812>, <-2.434896, -2.621157, 7.952879>, <-2.703375, -2.897022, 8.311367>, <-2.724911, -2.922688, 8.631811>, 
      <-2.600559, -2.417612, 7.631812>, <-2.621157, -2.434896, 7.952879>, <-2.897022, -2.703375, 8.311367>, <-2.922688, -2.724911, 8.631811>, 
      <-2.757760, -2.314035, 7.631812>, <-2.778358, -2.331319, 7.952879>, <-3.032138, -2.544267, 8.311367>, <-3.057804, -2.565803, 8.631811>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.000000, -3.464102, 7.631812>, <-2.005841, -3.474219, 7.931584>, <-2.000000, -3.464102, 8.331812>, <-2.000000, -3.464102, 8.631811>, 
      <-2.200833, -3.348151, 7.631812>, <-2.206674, -3.358268, 7.931584>, <-2.180974, -3.359616, 8.331812>, <-2.180974, -3.359616, 8.631811>, 
      <-2.186445, -2.951407, 7.631812>, <-2.203728, -2.972005, 7.952879>, <-2.384981, -3.167405, 8.311367>, <-2.406518, -3.193071, 8.631811>, 
      <-2.314035, -2.757760, 7.631812>, <-2.331319, -2.778358, 7.952879>, <-2.544267, -3.032138, 8.311367>, <-2.565803, -3.057804, 8.631811>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.231273, -3.382893, 7.631812>, <-1.240469, -3.408160, 7.952879>, <-1.353776, -3.719468, 8.311367>, <-1.365235, -3.750952, 8.631811>, 
      <-1.462771, -3.369220, 7.631812>, <-1.471967, -3.394487, 7.952879>, <-1.550563, -3.649157, 8.311367>, <-1.562022, -3.680640, 8.631811>, 
      <-1.799168, -3.580053, 7.631812>, <-1.805009, -3.590170, 7.931584>, <-1.819026, -3.568588, 8.331812>, <-1.819026, -3.568588, 8.631811>, 
      <-2.000000, -3.464102, 7.631812>, <-2.005841, -3.474219, 7.931584>, <-2.000000, -3.464102, 8.331812>, <-2.000000, -3.464102, 8.631811>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.625134, -3.545308, 7.631812>, <-0.629803, -3.571788, 7.952879>, <-0.687330, -3.898042, 8.311367>, <-0.693148, -3.931037, 8.631811>, 
      <-0.793435, -3.460956, 7.631812>, <-0.798104, -3.487437, 7.952879>, <-0.892680, -3.860582, 8.311367>, <-0.898498, -3.893577, 8.631811>, 
      <-1.043344, -3.393993, 7.631812>, <-1.052541, -3.419260, 7.952879>, <-1.157207, -3.789702, 8.311367>, <-1.168667, -3.821185, 8.631811>, 
      <-1.231273, -3.382893, 7.631812>, <-1.240469, -3.408160, 7.952879>, <-1.353776, -3.719468, 8.311367>, <-1.365235, -3.750952, 8.631811>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -4.000000, 7.631812>, <0.000000, -4.011682, 7.931584>, <0.000000, -4.000000, 8.331812>, <0.000000, -4.000000, 8.631811>, 
      <-0.231902, -4.000000, 7.631812>, <-0.231902, -4.011682, 7.931584>, <-0.208971, -4.000000, 8.331812>, <-0.208971, -4.000000, 8.631811>, 
      <-0.417814, -3.649216, 7.631812>, <-0.422483, -3.675696, 7.952879>, <-0.481752, -3.935544, 8.311367>, <-0.487569, -3.968539, 8.631811>, 
      <-0.625134, -3.545308, 7.631812>, <-0.629803, -3.571788, 7.952879>, <-0.687330, -3.898042, 8.311367>, <-0.693148, -3.931037, 8.631811>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.625133, -3.545308, 7.631812>, <0.629802, -3.571788, 7.952879>, <0.687330, -3.898042, 8.311367>, <0.693148, -3.931037, 8.631811>, 
      <0.417813, -3.649216, 7.631812>, <0.422482, -3.675696, 7.952879>, <0.481752, -3.935544, 8.311367>, <0.487569, -3.968539, 8.631811>, 
      <0.231901, -4.000000, 7.631812>, <0.231901, -4.011682, 7.931584>, <0.208971, -4.000000, 8.331812>, <0.208971, -4.000000, 8.631811>, 
      <0.000000, -4.000000, 7.631812>, <0.000000, -4.011682, 7.931584>, <0.000000, -4.000000, 8.331812>, <0.000000, -4.000000, 8.631811>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.231272, -3.382893, 7.631812>, <1.240468, -3.408160, 7.952879>, <1.353776, -3.719468, 8.311367>, <1.365235, -3.750952, 8.631811>, 
      <1.043343, -3.393993, 7.631812>, <1.052540, -3.419260, 7.952879>, <1.157207, -3.789702, 8.311367>, <1.168667, -3.821185, 8.631811>, 
      <0.793434, -3.460956, 7.631812>, <0.798103, -3.487437, 7.952879>, <0.892680, -3.860582, 8.311367>, <0.898498, -3.893577, 8.631811>, 
      <0.625133, -3.545308, 7.631812>, <0.629802, -3.571788, 7.952879>, <0.687330, -3.898042, 8.311367>, <0.693148, -3.931037, 8.631811>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.000000, -3.464102, 7.631812>, <2.005841, -3.474219, 7.931584>, <2.000000, -3.464102, 8.331812>, <2.000000, -3.464102, 8.631811>, 
      <1.799167, -3.580053, 7.631812>, <1.805008, -3.590170, 7.931584>, <1.819026, -3.568588, 8.331812>, <1.819026, -3.568588, 8.631811>, 
      <1.462770, -3.369220, 7.631812>, <1.471967, -3.394487, 7.952879>, <1.550563, -3.649157, 8.311367>, <1.562022, -3.680640, 8.631811>, 
      <1.231272, -3.382893, 7.631812>, <1.240468, -3.408160, 7.952879>, <1.353776, -3.719468, 8.311367>, <1.365235, -3.750952, 8.631811>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.314035, -2.757760, 7.631812>, <2.331319, -2.778358, 7.952879>, <2.544266, -3.032138, 8.311367>, <2.565802, -3.057804, 8.631811>, 
      <2.186445, -2.951407, 7.631812>, <2.203728, -2.972005, 7.952879>, <2.384981, -3.167405, 8.311367>, <2.406517, -3.193071, 8.631811>, 
      <2.200833, -3.348151, 7.631812>, <2.206674, -3.358268, 7.931584>, <2.180974, -3.359616, 8.331812>, <2.180974, -3.359616, 8.631811>, 
      <2.000000, -3.464102, 7.631812>, <2.005841, -3.474219, 7.931584>, <2.000000, -3.464102, 8.331812>, <2.000000, -3.464102, 8.631811>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.757760, -2.314035, 7.631812>, <2.778358, -2.331319, 7.952879>, <3.032138, -2.544267, 8.311367>, <3.057804, -2.565803, 8.631811>, 
      <2.600559, -2.417612, 7.631812>, <2.621157, -2.434896, 7.952879>, <2.897022, -2.703375, 8.311367>, <2.922688, -2.724911, 8.631811>, 
      <2.417612, -2.600559, 7.631812>, <2.434896, -2.621157, 7.952879>, <2.703374, -2.897022, 8.311367>, <2.724910, -2.922688, 8.631811>, 
      <2.314035, -2.757760, 7.631812>, <2.331319, -2.778358, 7.952879>, <2.544266, -3.032138, 8.311367>, <2.565802, -3.057804, 8.631811>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.464102, -2.000000, 7.631812>, <3.474219, -2.005841, 7.931584>, <3.464102, -2.000000, 8.331812>, <3.464102, -2.000000, 8.631811>, 
      <3.348151, -2.200833, 7.631812>, <3.358268, -2.206674, 7.931584>, <3.359616, -2.180974, 8.331812>, <3.359616, -2.180974, 8.631811>, 
      <2.951407, -2.186445, 7.631812>, <2.972005, -2.203728, 7.952879>, <3.167405, -2.384982, 8.311367>, <3.193071, -2.406518, 8.631811>, 
      <2.757760, -2.314035, 7.631812>, <2.778358, -2.331319, 7.952879>, <3.032138, -2.544267, 8.311367>, <3.057804, -2.565803, 8.631811>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.382893, -1.231273, 7.631812>, <3.408160, -1.240469, 7.952879>, <3.719468, -1.353776, 8.311367>, <3.750952, -1.365235, 8.631811>, 
      <3.369220, -1.462771, 7.631812>, <3.394487, -1.471967, 7.952879>, <3.649157, -1.550563, 8.311367>, <3.680640, -1.562022, 8.631811>, 
      <3.580053, -1.799168, 7.631812>, <3.590170, -1.805009, 7.931584>, <3.568588, -1.819026, 8.331812>, <3.568588, -1.819026, 8.631811>, 
      <3.464102, -2.000000, 7.631812>, <3.474219, -2.005841, 7.931584>, <3.464102, -2.000000, 8.331812>, <3.464102, -2.000000, 8.631811>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.545308, -0.625133, 7.631812>, <3.571788, -0.629802, 7.952879>, <3.898042, -0.687330, 8.311367>, <3.931037, -0.693148, 8.631811>, 
      <3.460956, -0.793435, 7.631812>, <3.487436, -0.798104, 7.952879>, <3.860582, -0.892680, 8.311367>, <3.893577, -0.898498, 8.631811>, 
      <3.393993, -1.043344, 7.631812>, <3.419260, -1.052540, 7.952879>, <3.789702, -1.157207, 8.311367>, <3.821185, -1.168667, 8.631811>, 
      <3.382893, -1.231273, 7.631812>, <3.408160, -1.240469, 7.952879>, <3.719468, -1.353776, 8.311367>, <3.750952, -1.365235, 8.631811>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.000000, 0.000000, 7.631812>, <4.011682, 0.000000, 7.931584>, <4.000000, 0.000000, 8.331812>, <4.000000, 0.000000, 8.631811>, 
      <4.000000, -0.231901, 7.631812>, <4.011682, -0.231901, 7.931584>, <4.000000, -0.208971, 8.331812>, <4.000000, -0.208971, 8.631811>, 
      <3.649216, -0.417813, 7.631812>, <3.675696, -0.422482, 7.952879>, <3.935544, -0.481752, 8.311367>, <3.968539, -0.487569, 8.631811>, 
      <3.545308, -0.625133, 7.631812>, <3.571788, -0.629802, 7.952879>, <3.898042, -0.687330, 8.311367>, <3.931037, -0.693148, 8.631811>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.000000, 0.000000, 7.631812>, <4.000000, 0.231901, 7.631812>, <3.649216, 0.417813, 7.631812>, <3.545308, 0.625133, 7.631812>, 
      <4.011682, 0.000000, 7.931584>, <4.011682, 0.231901, 7.931584>, <3.675696, 0.422482, 7.952879>, <3.571788, 0.629802, 7.952879>, 
      <4.000000, 0.000000, 8.331812>, <4.000000, 0.208971, 8.331812>, <3.935544, 0.481751, 8.311367>, <3.898042, 0.687329, 8.311367>, 
      <4.000000, 0.000000, 8.631811>, <4.000000, 0.208971, 8.631811>, <3.968539, 0.487569, 8.631811>, <3.931037, 0.693147, 8.631811>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.117675, 1.134740, 0.584795>, <3.288119, 1.196776, 2.692806>, <3.216968, 1.170880, 5.523393>, <3.382894, 1.231272, 7.631812>, 
      <3.127905, 0.961545, 0.584795>, <3.298349, 1.023581, 2.692806>, <3.228068, 0.982951, 5.523393>, <3.393994, 1.043343, 7.631812>, 
      <3.189617, 0.731228, 0.584795>, <3.368244, 0.762725, 2.692806>, <3.287064, 0.762772, 5.523393>, <3.460956, 0.793434, 7.631812>, 
      <3.267356, 0.576122, 0.584795>, <3.445982, 0.607619, 2.692806>, <3.371415, 0.594471, 5.523393>, <3.545308, 0.625133, 7.631812>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.192516, 1.843199, 0.584795>, <3.444165, 1.988489, 2.680948>, <3.392735, 1.958795, 5.517220>, <3.464102, 1.999999, 7.631812>, 
      <3.299376, 1.658112, 0.584795>, <3.551025, 1.803402, 2.680948>, <3.508686, 1.757963, 5.517220>, <3.580053, 1.799167, 7.631812>, 
      <3.105074, 1.348089, 0.584795>, <3.275517, 1.410125, 2.692806>, <3.203294, 1.402378, 5.523393>, <3.369221, 1.462770, 7.631812>, 
      <3.117675, 1.134740, 0.584795>, <3.288119, 1.196776, 2.692806>, <3.216968, 1.170880, 5.523393>, <3.382894, 1.231272, 7.631812>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.541552, 2.132614, 0.584795>, <2.680499, 2.249204, 2.692806>, <2.622495, 2.200533, 5.523393>, <2.757760, 2.314034, 7.631812>, 
      <2.720016, 2.015026, 0.584795>, <2.858963, 2.131616, 2.692806>, <2.816142, 2.072943, 5.523393>, <2.951406, 2.186443, 7.631812>, 
      <3.085656, 2.028286, 0.584795>, <3.337305, 2.173576, 2.680948>, <3.276784, 2.159628, 5.517220>, <3.348151, 2.200832, 7.631812>, 
      <3.192516, 1.843199, 0.584795>, <3.444165, 1.988489, 2.680948>, <3.392735, 1.958795, 5.517220>, <3.464102, 1.999999, 7.631812>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.132615, 2.541551, 0.584795>, <2.249206, 2.680498, 2.692806>, <2.200535, 2.622495, 5.523393>, <2.314036, 2.757759, 7.631812>, 
      <2.228072, 2.396674, 0.584795>, <2.344662, 2.535621, 2.692806>, <2.304112, 2.465293, 5.523393>, <2.417613, 2.600558, 7.631812>, 
      <2.396675, 2.228071, 0.584795>, <2.535622, 2.344661, 2.692806>, <2.465294, 2.304111, 5.523393>, <2.600559, 2.417611, 7.631812>, 
      <2.541552, 2.132614, 0.584795>, <2.680499, 2.249204, 2.692806>, <2.622495, 2.200533, 5.523393>, <2.757760, 2.314034, 7.631812>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.843200, 3.192516, 0.584795>, <1.988490, 3.444165, 2.680948>, <1.958796, 3.392735, 5.517220>, <2.000000, 3.464102, 7.631812>, 
      <2.028287, 3.085656, 0.584795>, <2.173577, 3.337305, 2.680948>, <2.159629, 3.276784, 5.517220>, <2.200833, 3.348151, 7.631812>, 
      <2.015028, 2.720016, 0.584795>, <2.131618, 2.858963, 2.692806>, <2.072945, 2.816142, 5.523393>, <2.186445, 2.951406, 7.631812>, 
      <2.132615, 2.541551, 0.584795>, <2.249206, 2.680498, 2.692806>, <2.200535, 2.622495, 5.523393>, <2.314036, 2.757759, 7.631812>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.134741, 3.117674, 0.584795>, <1.196777, 3.288118, 2.692806>, <1.170881, 3.216966, 5.523393>, <1.231273, 3.382893, 7.631812>, 
      <1.348089, 3.105073, 0.584795>, <1.410126, 3.275516, 2.692806>, <1.402379, 3.203293, 5.523393>, <1.462771, 3.369220, 7.631812>, 
      <1.658113, 3.299376, 0.584795>, <1.803402, 3.551025, 2.680948>, <1.757964, 3.508686, 5.517220>, <1.799168, 3.580053, 7.631812>, 
      <1.843200, 3.192516, 0.584795>, <1.988490, 3.444165, 2.680948>, <1.958796, 3.392735, 5.517220>, <2.000000, 3.464102, 7.631812>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.576123, 3.267355, 0.584795>, <0.607620, 3.445982, 2.692806>, <0.594472, 3.371415, 5.523393>, <0.625134, 3.545308, 7.631812>, 
      <0.731229, 3.189616, 0.584795>, <0.762726, 3.368243, 2.692806>, <0.762773, 3.287064, 5.523393>, <0.793435, 3.460956, 7.631812>, 
      <0.961546, 3.127904, 0.584795>, <1.023582, 3.298347, 2.692806>, <0.982952, 3.228066, 5.523393>, <1.043344, 3.393993, 7.631812>, 
      <1.134741, 3.117674, 0.584795>, <1.196777, 3.288118, 2.692806>, <1.170881, 3.216966, 5.523393>, <1.231273, 3.382893, 7.631812>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 3.686400, 0.584795>, <0.000000, 3.976979, 2.680948>, <0.000001, 3.917592, 5.517220>, <0.000001, 4.000000, 7.631812>, 
      <0.213721, 3.686400, 0.584795>, <0.213721, 3.976979, 2.680948>, <0.231902, 3.917592, 5.517220>, <0.231902, 4.000000, 7.631812>, 
      <0.385057, 3.363116, 0.584795>, <0.416554, 3.541743, 2.692806>, <0.387152, 3.475323, 5.523393>, <0.417814, 3.649216, 7.631812>, 
      <0.576123, 3.267355, 0.584795>, <0.607620, 3.445982, 2.692806>, <0.594472, 3.371415, 5.523393>, <0.625134, 3.545308, 7.631812>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.576123, 3.267356, 0.584795>, <-0.607620, 3.445982, 2.692806>, <-0.594471, 3.371415, 5.523393>, <-0.625133, 3.545308, 7.631812>, 
      <-0.385057, 3.363117, 0.584795>, <-0.416554, 3.541744, 2.692806>, <-0.387151, 3.475323, 5.523393>, <-0.417813, 3.649216, 7.631812>, 
      <-0.213720, 3.686400, 0.584795>, <-0.213720, 3.976980, 2.680948>, <-0.231901, 3.917592, 5.517220>, <-0.231901, 4.000000, 7.631812>, 
      <0.000000, 3.686400, 0.584795>, <0.000000, 3.976979, 2.680948>, <0.000001, 3.917592, 5.517220>, <0.000001, 4.000000, 7.631812>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.134740, 3.117675, 0.584795>, <-1.196776, 3.288119, 2.692806>, <-1.170880, 3.216968, 5.523393>, <-1.231272, 3.382894, 7.631812>, 
      <-0.961545, 3.127905, 0.584795>, <-1.023581, 3.298349, 2.692806>, <-0.982951, 3.228068, 5.523393>, <-1.043343, 3.393994, 7.631812>, 
      <-0.731229, 3.189618, 0.584795>, <-0.762726, 3.368244, 2.692806>, <-0.762772, 3.287064, 5.523393>, <-0.793434, 3.460956, 7.631812>, 
      <-0.576123, 3.267356, 0.584795>, <-0.607620, 3.445982, 2.692806>, <-0.594471, 3.371415, 5.523393>, <-0.625133, 3.545308, 7.631812>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.843200, 3.192516, 0.584795>, <-1.988490, 3.444165, 2.680948>, <-1.958796, 3.392735, 5.517220>, <-2.000000, 3.464102, 7.631812>, 
      <-1.658113, 3.299376, 0.584795>, <-1.803403, 3.551026, 2.680948>, <-1.757963, 3.508686, 5.517220>, <-1.799167, 3.580053, 7.631812>, 
      <-1.348089, 3.105074, 0.584795>, <-1.410125, 3.275517, 2.692806>, <-1.402378, 3.203294, 5.523393>, <-1.462770, 3.369221, 7.631812>, 
      <-1.134740, 3.117675, 0.584795>, <-1.196776, 3.288119, 2.692806>, <-1.170880, 3.216968, 5.523393>, <-1.231272, 3.382894, 7.631812>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.132614, 2.541552, 0.584795>, <-2.249204, 2.680499, 2.692806>, <-2.200534, 2.622495, 5.523393>, <-2.314035, 2.757760, 7.631812>, 
      <-2.015027, 2.720016, 0.584795>, <-2.131617, 2.858963, 2.692806>, <-2.072944, 2.816142, 5.523393>, <-2.186444, 2.951406, 7.631812>, 
      <-2.028287, 3.085656, 0.584795>, <-2.173577, 3.337305, 2.680948>, <-2.159629, 3.276784, 5.517220>, <-2.200833, 3.348151, 7.631812>, 
      <-1.843200, 3.192516, 0.584795>, <-1.988490, 3.444165, 2.680948>, <-1.958796, 3.392735, 5.517220>, <-2.000000, 3.464102, 7.631812>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.541551, 2.132615, 0.584795>, <-2.680498, 2.249206, 2.692806>, <-2.622495, 2.200535, 5.523393>, <-2.757760, 2.314036, 7.631812>, 
      <-2.396674, 2.228072, 0.584795>, <-2.535621, 2.344662, 2.692806>, <-2.465294, 2.304112, 5.523393>, <-2.600559, 2.417613, 7.631812>, 
      <-2.228071, 2.396675, 0.584795>, <-2.344661, 2.535622, 2.692806>, <-2.304112, 2.465294, 5.523393>, <-2.417612, 2.600559, 7.631812>, 
      <-2.132614, 2.541552, 0.584795>, <-2.249204, 2.680499, 2.692806>, <-2.200534, 2.622495, 5.523393>, <-2.314035, 2.757760, 7.631812>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.192516, 1.843201, 0.584795>, <-3.444165, 1.988491, 2.680948>, <-3.392734, 1.958797, 5.517220>, <-3.464101, 2.000001, 7.631812>, 
      <-3.085656, 2.028288, 0.584795>, <-3.337305, 2.173578, 2.680948>, <-3.276783, 2.159629, 5.517220>, <-3.348150, 2.200833, 7.631812>, 
      <-2.720016, 2.015028, 0.584795>, <-2.858963, 2.131618, 2.692806>, <-2.816142, 2.072945, 5.523393>, <-2.951406, 2.186445, 7.631812>, 
      <-2.541551, 2.132615, 0.584795>, <-2.680498, 2.249206, 2.692806>, <-2.622495, 2.200535, 5.523393>, <-2.757760, 2.314036, 7.631812>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.117674, 1.134741, 0.584795>, <-3.288118, 1.196777, 2.692806>, <-3.216966, 1.170881, 5.523393>, <-3.382893, 1.231273, 7.631812>, 
      <-3.105073, 1.348090, 0.584795>, <-3.275516, 1.410126, 2.692806>, <-3.203293, 1.402379, 5.523393>, <-3.369220, 1.462771, 7.631812>, 
      <-3.299376, 1.658114, 0.584795>, <-3.551026, 1.803403, 2.680948>, <-3.508685, 1.757964, 5.517220>, <-3.580052, 1.799168, 7.631812>, 
      <-3.192516, 1.843201, 0.584795>, <-3.444165, 1.988491, 2.680948>, <-3.392734, 1.958797, 5.517220>, <-3.464101, 2.000001, 7.631812>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.267355, 0.576123, 0.584795>, <-3.445982, 0.607620, 2.692806>, <-3.371415, 0.594472, 5.523393>, <-3.545308, 0.625134, 7.631812>, 
      <-3.189616, 0.731229, 0.584795>, <-3.368243, 0.762726, 2.692806>, <-3.287064, 0.762773, 5.523393>, <-3.460956, 0.793435, 7.631812>, 
      <-3.127904, 0.961546, 0.584795>, <-3.298347, 1.023582, 2.692806>, <-3.228066, 0.982952, 5.523393>, <-3.393993, 1.043344, 7.631812>, 
      <-3.117674, 1.134741, 0.584795>, <-3.288118, 1.196777, 2.692806>, <-3.216966, 1.170881, 5.523393>, <-3.382893, 1.231273, 7.631812>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.686400, 0.000000, 0.584795>, <-3.976979, 0.000000, 2.680948>, <-3.917592, 0.000000, 5.517220>, <-4.000000, 0.000000, 7.631812>, 
      <-3.686400, 0.213721, 0.584795>, <-3.976979, 0.213721, 2.680948>, <-3.917592, 0.231902, 5.517220>, <-4.000000, 0.231902, 7.631812>, 
      <-3.363116, 0.385057, 0.584795>, <-3.541743, 0.416554, 2.692806>, <-3.475323, 0.387152, 5.523393>, <-3.649216, 0.417814, 7.631812>, 
      <-3.267355, 0.576123, 0.584795>, <-3.445982, 0.607620, 2.692806>, <-3.371415, 0.594472, 5.523393>, <-3.545308, 0.625134, 7.631812>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.267356, -0.576123, 0.584795>, <-3.445982, -0.607620, 2.692806>, <-3.371415, -0.594471, 5.523393>, <-3.545308, -0.625133, 7.631812>, 
      <-3.363117, -0.385057, 0.584795>, <-3.541744, -0.416554, 2.692806>, <-3.475323, -0.387151, 5.523393>, <-3.649216, -0.417813, 7.631812>, 
      <-3.686400, -0.213720, 0.584795>, <-3.976980, -0.213720, 2.680948>, <-3.917592, -0.231901, 5.517220>, <-4.000000, -0.231901, 7.631812>, 
      <-3.686400, 0.000000, 0.584795>, <-3.976979, 0.000000, 2.680948>, <-3.917592, 0.000000, 5.517220>, <-4.000000, 0.000000, 7.631812>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.117675, -1.134740, 0.584795>, <-3.288119, -1.196776, 2.692806>, <-3.216968, -1.170880, 5.523393>, <-3.382894, -1.231272, 7.631812>, 
      <-3.127905, -0.961545, 0.584795>, <-3.298349, -1.023581, 2.692806>, <-3.228068, -0.982951, 5.523393>, <-3.393994, -1.043343, 7.631812>, 
      <-3.189618, -0.731229, 0.584795>, <-3.368244, -0.762726, 2.692806>, <-3.287064, -0.762772, 5.523393>, <-3.460956, -0.793434, 7.631812>, 
      <-3.267356, -0.576123, 0.584795>, <-3.445982, -0.607620, 2.692806>, <-3.371415, -0.594471, 5.523393>, <-3.545308, -0.625133, 7.631812>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.192516, -1.843200, 0.584795>, <-3.444165, -1.988490, 2.680948>, <-3.392735, -1.958796, 5.517220>, <-3.464102, -2.000000, 7.631812>, 
      <-3.299376, -1.658113, 0.584795>, <-3.551026, -1.803402, 2.680948>, <-3.508686, -1.757963, 5.517220>, <-3.580053, -1.799167, 7.631812>, 
      <-3.105074, -1.348089, 0.584795>, <-3.275517, -1.410125, 2.692806>, <-3.203294, -1.402378, 5.523393>, <-3.369221, -1.462770, 7.631812>, 
      <-3.117675, -1.134740, 0.584795>, <-3.288119, -1.196776, 2.692806>, <-3.216968, -1.170880, 5.523393>, <-3.382894, -1.231272, 7.631812>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.541551, -2.132615, 0.584795>, <-2.680498, -2.249205, 2.692806>, <-2.622495, -2.200534, 5.523393>, <-2.757760, -2.314035, 7.631812>, 
      <-2.720016, -2.015028, 0.584795>, <-2.858963, -2.131618, 2.692806>, <-2.816142, -2.072944, 5.523393>, <-2.951407, -2.186445, 7.631812>, 
      <-3.085656, -2.028287, 0.584795>, <-3.337305, -2.173577, 2.680948>, <-3.276784, -2.159629, 5.517220>, <-3.348151, -2.200833, 7.631812>, 
      <-3.192516, -1.843200, 0.584795>, <-3.444165, -1.988490, 2.680948>, <-3.392735, -1.958796, 5.517220>, <-3.464102, -2.000000, 7.631812>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.132615, -2.541551, 0.584795>, <-2.249205, -2.680498, 2.692806>, <-2.200534, -2.622495, 5.523393>, <-2.314035, -2.757760, 7.631812>, 
      <-2.228072, -2.396675, 0.584795>, <-2.344662, -2.535621, 2.692806>, <-2.304112, -2.465294, 5.523393>, <-2.417612, -2.600559, 7.631812>, 
      <-2.396675, -2.228072, 0.584795>, <-2.535621, -2.344662, 2.692806>, <-2.465294, -2.304112, 5.523393>, <-2.600559, -2.417612, 7.631812>, 
      <-2.541551, -2.132615, 0.584795>, <-2.680498, -2.249205, 2.692806>, <-2.622495, -2.200534, 5.523393>, <-2.757760, -2.314035, 7.631812>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.843200, -3.192516, 0.584795>, <-1.988490, -3.444166, 2.680948>, <-1.958796, -3.392735, 5.517220>, <-2.000000, -3.464102, 7.631812>, 
      <-2.028287, -3.085656, 0.584795>, <-2.173577, -3.337305, 2.680948>, <-2.159629, -3.276784, 5.517220>, <-2.200833, -3.348151, 7.631812>, 
      <-2.015028, -2.720016, 0.584795>, <-2.131618, -2.858963, 2.692806>, <-2.072944, -2.816142, 5.523393>, <-2.186445, -2.951407, 7.631812>, 
      <-2.132615, -2.541551, 0.584795>, <-2.249205, -2.680498, 2.692806>, <-2.200534, -2.622495, 5.523393>, <-2.314035, -2.757760, 7.631812>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.134741, -3.117674, 0.584795>, <-1.196777, -3.288118, 2.692806>, <-1.170881, -3.216966, 5.523393>, <-1.231273, -3.382893, 7.631812>, 
      <-1.348089, -3.105073, 0.584795>, <-1.410126, -3.275516, 2.692806>, <-1.402379, -3.203293, 5.523393>, <-1.462771, -3.369220, 7.631812>, 
      <-1.658113, -3.299376, 0.584795>, <-1.803402, -3.551026, 2.680948>, <-1.757964, -3.508686, 5.517220>, <-1.799168, -3.580053, 7.631812>, 
      <-1.843200, -3.192516, 0.584795>, <-1.988490, -3.444166, 2.680948>, <-1.958796, -3.392735, 5.517220>, <-2.000000, -3.464102, 7.631812>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.576123, -3.267355, 0.584795>, <-0.607620, -3.445982, 2.692806>, <-0.594472, -3.371415, 5.523393>, <-0.625134, -3.545308, 7.631812>, 
      <-0.731229, -3.189616, 0.584795>, <-0.762726, -3.368243, 2.692806>, <-0.762773, -3.287064, 5.523393>, <-0.793435, -3.460956, 7.631812>, 
      <-0.961546, -3.127904, 0.584795>, <-1.023582, -3.298347, 2.692806>, <-0.982952, -3.228066, 5.523393>, <-1.043344, -3.393993, 7.631812>, 
      <-1.134741, -3.117674, 0.584795>, <-1.196777, -3.288118, 2.692806>, <-1.170881, -3.216966, 5.523393>, <-1.231273, -3.382893, 7.631812>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -3.686400, 0.584795>, <0.000000, -3.976979, 2.680948>, <0.000000, -3.917592, 5.517220>, <0.000000, -4.000000, 7.631812>, 
      <-0.213721, -3.686400, 0.584795>, <-0.213721, -3.976979, 2.680948>, <-0.231902, -3.917592, 5.517220>, <-0.231902, -4.000000, 7.631812>, 
      <-0.385057, -3.363116, 0.584795>, <-0.416554, -3.541743, 2.692806>, <-0.387152, -3.475323, 5.523393>, <-0.417814, -3.649216, 7.631812>, 
      <-0.576123, -3.267355, 0.584795>, <-0.607620, -3.445982, 2.692806>, <-0.594472, -3.371415, 5.523393>, <-0.625134, -3.545308, 7.631812>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.576123, -3.267356, 0.584795>, <0.607620, -3.445982, 2.692806>, <0.594471, -3.371415, 5.523393>, <0.625133, -3.545308, 7.631812>, 
      <0.385057, -3.363117, 0.584795>, <0.416554, -3.541744, 2.692806>, <0.387151, -3.475323, 5.523393>, <0.417813, -3.649216, 7.631812>, 
      <0.213720, -3.686400, 0.584795>, <0.213720, -3.976980, 2.680948>, <0.231901, -3.917592, 5.517220>, <0.231901, -4.000000, 7.631812>, 
      <0.000000, -3.686400, 0.584795>, <0.000000, -3.976979, 2.680948>, <0.000000, -3.917592, 5.517220>, <0.000000, -4.000000, 7.631812>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.134741, -3.117674, 0.584795>, <1.196777, -3.288118, 2.692806>, <1.170880, -3.216966, 5.523393>, <1.231272, -3.382893, 7.631812>, 
      <0.961546, -3.127904, 0.584795>, <1.023582, -3.298347, 2.692806>, <0.982951, -3.228066, 5.523393>, <1.043343, -3.393993, 7.631812>, 
      <0.731229, -3.189617, 0.584795>, <0.762726, -3.368244, 2.692806>, <0.762772, -3.287064, 5.523393>, <0.793434, -3.460956, 7.631812>, 
      <0.576123, -3.267356, 0.584795>, <0.607620, -3.445982, 2.692806>, <0.594471, -3.371415, 5.523393>, <0.625133, -3.545308, 7.631812>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.843200, -3.192516, 0.584795>, <1.988490, -3.444165, 2.680948>, <1.958796, -3.392735, 5.517220>, <2.000000, -3.464102, 7.631812>, 
      <1.658113, -3.299376, 0.584795>, <1.803402, -3.551025, 2.680948>, <1.757963, -3.508686, 5.517220>, <1.799167, -3.580053, 7.631812>, 
      <1.348089, -3.105073, 0.584795>, <1.410126, -3.275516, 2.692806>, <1.402378, -3.203293, 5.523393>, <1.462770, -3.369220, 7.631812>, 
      <1.134741, -3.117674, 0.584795>, <1.196777, -3.288118, 2.692806>, <1.170880, -3.216966, 5.523393>, <1.231272, -3.382893, 7.631812>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.132615, -2.541551, 0.584795>, <2.249205, -2.680498, 2.692806>, <2.200535, -2.622495, 5.523393>, <2.314035, -2.757760, 7.631812>, 
      <2.015028, -2.720016, 0.584795>, <2.131618, -2.858963, 2.692806>, <2.072944, -2.816142, 5.523393>, <2.186445, -2.951407, 7.631812>, 
      <2.028287, -3.085656, 0.584795>, <2.173577, -3.337305, 2.680948>, <2.159629, -3.276784, 5.517220>, <2.200833, -3.348151, 7.631812>, 
      <1.843200, -3.192516, 0.584795>, <1.988490, -3.444165, 2.680948>, <1.958796, -3.392735, 5.517220>, <2.000000, -3.464102, 7.631812>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.541551, -2.132615, 0.584795>, <2.680498, -2.249205, 2.692806>, <2.622495, -2.200534, 5.523393>, <2.757760, -2.314035, 7.631812>, 
      <2.396675, -2.228072, 0.584795>, <2.535621, -2.344662, 2.692806>, <2.465294, -2.304112, 5.523393>, <2.600559, -2.417612, 7.631812>, 
      <2.228072, -2.396675, 0.584795>, <2.344662, -2.535621, 2.692806>, <2.304112, -2.465294, 5.523393>, <2.417612, -2.600559, 7.631812>, 
      <2.132615, -2.541551, 0.584795>, <2.249205, -2.680498, 2.692806>, <2.200535, -2.622495, 5.523393>, <2.314035, -2.757760, 7.631812>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.192516, -1.843200, 0.584795>, <3.444166, -1.988490, 2.680948>, <3.392735, -1.958796, 5.517220>, <3.464102, -2.000000, 7.631812>, 
      <3.085656, -2.028287, 0.584795>, <3.337305, -2.173577, 2.680948>, <3.276784, -2.159629, 5.517220>, <3.348151, -2.200833, 7.631812>, 
      <2.720016, -2.015028, 0.584795>, <2.858963, -2.131618, 2.692806>, <2.816142, -2.072944, 5.523393>, <2.951407, -2.186445, 7.631812>, 
      <2.541551, -2.132615, 0.584795>, <2.680498, -2.249205, 2.692806>, <2.622495, -2.200534, 5.523393>, <2.757760, -2.314035, 7.631812>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.117674, -1.134741, 0.584795>, <3.288118, -1.196777, 2.692806>, <3.216966, -1.170881, 5.523393>, <3.382893, -1.231273, 7.631812>, 
      <3.105073, -1.348089, 0.584795>, <3.275516, -1.410126, 2.692806>, <3.203293, -1.402379, 5.523393>, <3.369220, -1.462771, 7.631812>, 
      <3.299376, -1.658113, 0.584795>, <3.551026, -1.803402, 2.680948>, <3.508686, -1.757964, 5.517220>, <3.580053, -1.799168, 7.631812>, 
      <3.192516, -1.843200, 0.584795>, <3.444166, -1.988490, 2.680948>, <3.392735, -1.958796, 5.517220>, <3.464102, -2.000000, 7.631812>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.267355, -0.576123, 0.584795>, <3.445982, -0.607620, 2.692806>, <3.371415, -0.594471, 5.523393>, <3.545308, -0.625133, 7.631812>, 
      <3.189616, -0.731229, 0.584795>, <3.368243, -0.762726, 2.692806>, <3.287063, -0.762772, 5.523393>, <3.460956, -0.793435, 7.631812>, 
      <3.127904, -0.961546, 0.584795>, <3.298347, -1.023582, 2.692806>, <3.228066, -0.982951, 5.523393>, <3.393993, -1.043344, 7.631812>, 
      <3.117674, -1.134741, 0.584795>, <3.288118, -1.196777, 2.692806>, <3.216966, -1.170881, 5.523393>, <3.382893, -1.231273, 7.631812>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.767802, 1.007397, 0.024491>, <2.922137, 1.063570, 0.141778>, <3.101417, 1.128823, 0.383719>, <3.117675, 1.134740, 0.584795>, 
      <2.820482, 0.862659, 0.024491>, <2.974818, 0.918832, 0.141778>, <3.111647, 0.955627, 0.383719>, <3.127905, 0.961545, 0.584795>, 
      <2.873940, 0.663156, 0.024491>, <3.035684, 0.691676, 0.141778>, <3.172579, 0.728224, 0.383719>, <3.189617, 0.731228, 0.584795>, 
      <2.900686, 0.511469, 0.024491>, <3.062431, 0.539989, 0.141778>, <3.250317, 0.573118, 0.383719>, <3.267356, 0.576122, 0.584795>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.767802, 1.007397, 0.024491>, <2.820482, 0.862659, 0.024491>, <2.873940, 0.663156, 0.024491>, <2.900686, 0.511469, 0.024491>, 
      <2.673219, 0.972972, -0.047388>, <2.725899, 0.828234, -0.047388>, <2.774816, 0.645678, -0.047388>, <2.801562, 0.493991, -0.047388>, 
      <2.496608, 0.908691, 0.023465>, <2.541914, 0.784212, 0.023465>, <2.593469, 0.591809, 0.023465>, <2.616472, 0.461354, 0.023465>, 
      <2.380387, 0.866390, 0.024491>, <2.425694, 0.741911, 0.024491>, <2.471668, 0.570332, 0.024491>, <2.494671, 0.439877, 0.024491>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.550821, 1.472716, 0.024491>, <2.767907, 1.598051, 0.146279>, <3.159376, 1.824065, 0.308746>, <3.192516, 1.843199, 0.584795>, 
      <2.627834, 1.339325, 0.024491>, <2.844920, 1.464660, 0.146279>, <3.266236, 1.638978, 0.308746>, <3.299376, 1.658112, 0.584795>, 
      <2.715122, 1.152135, 0.024491>, <2.869457, 1.208308, 0.141778>, <3.088816, 1.342171, 0.383719>, <3.105074, 1.348089, 0.584795>, 
      <2.767802, 1.007397, 0.024491>, <2.922137, 1.063570, 0.141778>, <3.101417, 1.128823, 0.383719>, <3.117675, 1.134740, 0.584795>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.550821, 1.472716, 0.024491>, <2.627834, 1.339325, 0.024491>, <2.715122, 1.152135, 0.024491>, <2.767802, 1.007397, 0.024491>, 
      <2.454477, 1.417092, -0.029559>, <2.531490, 1.283701, -0.029559>, <2.620539, 1.117709, -0.047388>, <2.673219, 0.972972, -0.047388>, 
      <2.300887, 1.328417, 0.023465>, <2.367120, 1.213697, 0.023465>, <2.451301, 1.033169, 0.023465>, <2.496608, 0.908691, 0.023465>, 
      <2.193777, 1.266577, 0.024491>, <2.260011, 1.151857, 0.024491>, <2.335081, 0.990868, 0.024491>, <2.380387, 0.866390, 0.024491>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.256333, 1.893288, 0.024491>, <2.382148, 1.998859, 0.141778>, <2.528298, 2.121493, 0.383719>, <2.541552, 2.132614, 0.584795>, 
      <2.355340, 1.775296, 0.024491>, <2.481155, 1.880868, 0.141778>, <2.706763, 2.003905, 0.383719>, <2.720016, 2.015026, 0.584795>, 
      <2.473808, 1.606108, 0.024491>, <2.690894, 1.731442, 0.146279>, <3.052516, 2.009152, 0.308746>, <3.085656, 2.028286, 0.584795>, 
      <2.550821, 1.472716, 0.024491>, <2.767907, 1.598051, 0.146279>, <3.159376, 1.824065, 0.308746>, <3.192516, 1.843199, 0.584795>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.256333, 1.893288, 0.024491>, <2.355340, 1.775296, 0.024491>, <2.473808, 1.606108, 0.024491>, <2.550821, 1.472716, 0.024491>, 
      <2.179228, 1.828589, -0.047388>, <2.278235, 1.710598, -0.047388>, <2.377464, 1.550483, -0.029559>, <2.454477, 1.417092, -0.029559>, 
      <2.035254, 1.707780, 0.023465>, <2.120402, 1.606304, 0.023465>, <2.234653, 1.443137, 0.023465>, <2.300887, 1.328417, 0.023465>, 
      <1.940510, 1.628280, 0.024491>, <2.025658, 1.526804, 0.024491>, <2.127543, 1.381297, 0.024491>, <2.193777, 1.266577, 0.024491>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.893288, 2.256332, 0.024491>, <1.998859, 2.382147, 0.141779>, <2.121494, 2.528297, 0.383718>, <2.132615, 2.541551, 0.584795>, 
      <2.011279, 2.157325, 0.024491>, <2.116851, 2.283140, 0.141779>, <2.216951, 2.383420, 0.383718>, <2.228072, 2.396674, 0.584795>, 
      <2.157326, 2.011279, 0.024491>, <2.283141, 2.116851, 0.141778>, <2.383422, 2.216950, 0.383719>, <2.396675, 2.228071, 0.584795>, 
      <2.256333, 1.893288, 0.024491>, <2.382148, 1.998859, 0.141778>, <2.528298, 2.121493, 0.383719>, <2.541552, 2.132614, 0.584795>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.893288, 2.256332, 0.024491>, <2.011279, 2.157325, 0.024491>, <2.157326, 2.011279, 0.024491>, <2.256333, 1.893288, 0.024491>, 
      <1.828590, 2.179227, -0.047388>, <1.946581, 2.080221, -0.047388>, <2.080222, 1.946581, -0.047388>, <2.179228, 1.828589, -0.047388>, 
      <1.707780, 2.035253, 0.023465>, <1.809256, 1.950104, 0.023465>, <1.950105, 1.809255, 0.023465>, <2.035254, 1.707780, 0.023465>, 
      <1.628281, 1.940509, 0.024491>, <1.729757, 1.855360, 0.024491>, <1.855361, 1.729756, 0.024491>, <1.940510, 1.628280, 0.024491>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.472717, 2.550821, 0.024491>, <1.598052, 2.767907, 0.146279>, <1.824066, 3.159376, 0.308746>, <1.843200, 3.192516, 0.584795>, 
      <1.606108, 2.473807, 0.024491>, <1.731443, 2.690893, 0.146279>, <2.009154, 3.052515, 0.308746>, <2.028287, 3.085656, 0.584795>, 
      <1.775296, 2.355339, 0.024491>, <1.880868, 2.481154, 0.141779>, <2.003906, 2.706762, 0.383718>, <2.015028, 2.720016, 0.584795>, 
      <1.893288, 2.256332, 0.024491>, <1.998859, 2.382147, 0.141779>, <2.121494, 2.528297, 0.383718>, <2.132615, 2.541551, 0.584795>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.472717, 2.550821, 0.024491>, <1.606108, 2.473807, 0.024491>, <1.775296, 2.355339, 0.024491>, <1.893288, 2.256332, 0.024491>, 
      <1.417093, 2.454477, -0.029559>, <1.550484, 2.377463, -0.029559>, <1.710598, 2.278234, -0.047388>, <1.828590, 2.179227, -0.047388>, 
      <1.328418, 2.300887, 0.023465>, <1.443138, 2.234653, 0.023465>, <1.606304, 2.120401, 0.023465>, <1.707780, 2.035253, 0.023465>, 
      <1.266578, 2.193777, 0.024491>, <1.381298, 2.127543, 0.024491>, <1.526805, 2.025657, 0.024491>, <1.628281, 1.940509, 0.024491>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.007398, 2.767802, 0.024491>, <1.063571, 2.922137, 0.141778>, <1.128824, 3.101416, 0.383719>, <1.134741, 3.117674, 0.584795>, 
      <1.152136, 2.715122, 0.024491>, <1.208309, 2.869457, 0.141778>, <1.342172, 3.088815, 0.383719>, <1.348089, 3.105073, 0.584795>, 
      <1.339326, 2.627835, 0.024491>, <1.464661, 2.844921, 0.146279>, <1.638979, 3.266236, 0.308746>, <1.658113, 3.299376, 0.584795>, 
      <1.472717, 2.550821, 0.024491>, <1.598052, 2.767907, 0.146279>, <1.824066, 3.159376, 0.308746>, <1.843200, 3.192516, 0.584795>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.007398, 2.767802, 0.024491>, <1.152136, 2.715122, 0.024491>, <1.339326, 2.627835, 0.024491>, <1.472717, 2.550821, 0.024491>, 
      <0.972973, 2.673219, -0.047388>, <1.117710, 2.620539, -0.047388>, <1.283702, 2.531491, -0.029559>, <1.417093, 2.454477, -0.029559>, 
      <0.908691, 2.496608, 0.023465>, <1.033170, 2.451301, 0.023465>, <1.213697, 2.367120, 0.023465>, <1.328418, 2.300887, 0.023465>, 
      <0.866390, 2.380387, 0.024491>, <0.990869, 2.335081, 0.024491>, <1.151858, 2.260011, 0.024491>, <1.266578, 2.193777, 0.024491>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.511470, 2.900686, 0.024491>, <0.539990, 3.062431, 0.141778>, <0.573119, 3.250316, 0.383719>, <0.576123, 3.267355, 0.584795>, 
      <0.663157, 2.873940, 0.024491>, <0.691677, 3.035684, 0.141778>, <0.728225, 3.172578, 0.383719>, <0.731229, 3.189616, 0.584795>, 
      <0.862660, 2.820482, 0.024491>, <0.918834, 2.974817, 0.141778>, <0.955628, 3.111646, 0.383719>, <0.961546, 3.127904, 0.584795>, 
      <1.007398, 2.767802, 0.024491>, <1.063571, 2.922137, 0.141778>, <1.128824, 3.101416, 0.383719>, <1.134741, 3.117674, 0.584795>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.511470, 2.900686, 0.024491>, <0.663157, 2.873940, 0.024491>, <0.862660, 2.820482, 0.024491>, <1.007398, 2.767802, 0.024491>, 
      <0.493992, 2.801562, -0.047388>, <0.645679, 2.774816, -0.047388>, <0.828235, 2.725899, -0.047388>, <0.972973, 2.673219, -0.047388>, 
      <0.461355, 2.616472, 0.023465>, <0.591810, 2.593469, 0.023465>, <0.784212, 2.541914, 0.023465>, <0.908691, 2.496608, 0.023465>, 
      <0.439878, 2.494671, 0.024491>, <0.570333, 2.471668, 0.024491>, <0.741911, 2.425694, 0.024491>, <0.866390, 2.380387, 0.024491>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 2.945434, 0.024491>, <0.000000, 3.196104, 0.146279>, <0.000000, 3.648132, 0.308746>, <0.000000, 3.686400, 0.584795>, 
      <0.154027, 2.945434, 0.024491>, <0.154027, 3.196104, 0.146279>, <0.213721, 3.648132, 0.308746>, <0.213721, 3.686400, 0.584795>, 
      <0.359783, 2.927433, 0.024491>, <0.388303, 3.089177, 0.141778>, <0.382053, 3.346078, 0.383719>, <0.385057, 3.363116, 0.584795>, 
      <0.511470, 2.900686, 0.024491>, <0.539990, 3.062431, 0.141778>, <0.573119, 3.250316, 0.383719>, <0.576123, 3.267355, 0.584795>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 2.945434, 0.024491>, <0.154027, 2.945434, 0.024491>, <0.359783, 2.927433, 0.024491>, <0.511470, 2.900686, 0.024491>, 
      <0.000000, 2.834186, -0.029559>, <0.154027, 2.834186, -0.029559>, <0.342305, 2.828309, -0.047388>, <0.493992, 2.801562, -0.047388>, 
      <0.000000, 2.656834, 0.023465>, <0.132467, 2.656834, 0.023465>, <0.330900, 2.639474, 0.023465>, <0.461355, 2.616472, 0.023465>, 
      <0.000000, 2.533155, 0.024491>, <0.132467, 2.533155, 0.024491>, <0.309423, 2.517674, 0.024491>, <0.439878, 2.494671, 0.024491>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.511469, 2.900686, 0.024491>, <-0.539989, 3.062431, 0.141778>, <-0.573119, 3.250317, 0.383719>, <-0.576123, 3.267356, 0.584795>, 
      <-0.359782, 2.927433, 0.024491>, <-0.388302, 3.089178, 0.141778>, <-0.382053, 3.346078, 0.383719>, <-0.385057, 3.363117, 0.584795>, 
      <-0.154027, 2.945434, 0.024491>, <-0.154027, 3.196104, 0.146279>, <-0.213720, 3.648133, 0.308746>, <-0.213720, 3.686400, 0.584795>, 
      <0.000000, 2.945434, 0.024491>, <0.000000, 3.196104, 0.146279>, <0.000000, 3.648132, 0.308746>, <0.000000, 3.686400, 0.584795>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.511469, 2.900686, 0.024491>, <-0.359782, 2.927433, 0.024491>, <-0.154027, 2.945434, 0.024491>, <0.000000, 2.945434, 0.024491>, 
      <-0.493991, 2.801562, -0.047388>, <-0.342304, 2.828309, -0.047388>, <-0.154027, 2.834186, -0.029559>, <0.000000, 2.834186, -0.029559>, 
      <-0.461355, 2.616471, 0.023465>, <-0.330900, 2.639474, 0.023465>, <-0.132467, 2.656834, 0.023465>, <0.000000, 2.656834, 0.023465>, 
      <-0.439878, 2.494671, 0.024491>, <-0.309423, 2.517674, 0.024491>, <-0.132467, 2.533155, 0.024491>, <0.000000, 2.533155, 0.024491>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.007397, 2.767802, 0.024491>, <-1.063570, 2.922137, 0.141778>, <-1.128823, 3.101417, 0.383719>, <-1.134740, 3.117675, 0.584795>, 
      <-0.862659, 2.820482, 0.024491>, <-0.918832, 2.974818, 0.141778>, <-0.955628, 3.111647, 0.383719>, <-0.961545, 3.127905, 0.584795>, 
      <-0.663156, 2.873940, 0.024491>, <-0.691676, 3.035684, 0.141778>, <-0.728225, 3.172579, 0.383719>, <-0.731229, 3.189618, 0.584795>, 
      <-0.511469, 2.900686, 0.024491>, <-0.539989, 3.062431, 0.141778>, <-0.573119, 3.250317, 0.383719>, <-0.576123, 3.267356, 0.584795>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.007397, 2.767802, 0.024491>, <-0.862659, 2.820482, 0.024491>, <-0.663156, 2.873940, 0.024491>, <-0.511469, 2.900686, 0.024491>, 
      <-0.972972, 2.673219, -0.047388>, <-0.828234, 2.725899, -0.047388>, <-0.645678, 2.774816, -0.047388>, <-0.493991, 2.801562, -0.047388>, 
      <-0.908691, 2.496608, 0.023465>, <-0.784212, 2.541914, 0.023465>, <-0.591809, 2.593469, 0.023465>, <-0.461355, 2.616471, 0.023465>, 
      <-0.866390, 2.380387, 0.024491>, <-0.741911, 2.425694, 0.024491>, <-0.570333, 2.471668, 0.024491>, <-0.439878, 2.494671, 0.024491>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.472716, 2.550821, 0.024491>, <-1.598051, 2.767907, 0.146279>, <-1.824066, 3.159376, 0.308746>, <-1.843200, 3.192516, 0.584795>, 
      <-1.339325, 2.627834, 0.024491>, <-1.464660, 2.844920, 0.146279>, <-1.638979, 3.266236, 0.308746>, <-1.658113, 3.299376, 0.584795>, 
      <-1.152135, 2.715122, 0.024491>, <-1.208308, 2.869457, 0.141778>, <-1.342171, 3.088816, 0.383719>, <-1.348089, 3.105074, 0.584795>, 
      <-1.007397, 2.767802, 0.024491>, <-1.063570, 2.922137, 0.141778>, <-1.128823, 3.101417, 0.383719>, <-1.134740, 3.117675, 0.584795>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.472716, 2.550821, 0.024491>, <-1.339325, 2.627834, 0.024491>, <-1.152135, 2.715122, 0.024491>, <-1.007397, 2.767802, 0.024491>, 
      <-1.417092, 2.454477, -0.029559>, <-1.283701, 2.531490, -0.029559>, <-1.117709, 2.620539, -0.047388>, <-0.972972, 2.673219, -0.047388>, 
      <-1.328417, 2.300887, 0.023465>, <-1.213697, 2.367120, 0.023465>, <-1.033169, 2.451301, 0.023465>, <-0.908691, 2.496608, 0.023465>, 
      <-1.266577, 2.193777, 0.024491>, <-1.151857, 2.260011, 0.024491>, <-0.990868, 2.335081, 0.024491>, <-0.866390, 2.380387, 0.024491>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.893288, 2.256333, 0.024491>, <-1.998859, 2.382148, 0.141779>, <-2.121493, 2.528298, 0.383719>, <-2.132614, 2.541552, 0.584795>, 
      <-1.775296, 2.355340, 0.024491>, <-1.880867, 2.481155, 0.141779>, <-2.003905, 2.706763, 0.383719>, <-2.015027, 2.720016, 0.584795>, 
      <-1.606108, 2.473808, 0.024491>, <-1.731442, 2.690894, 0.146279>, <-2.009153, 3.052516, 0.308746>, <-2.028287, 3.085656, 0.584795>, 
      <-1.472716, 2.550821, 0.024491>, <-1.598051, 2.767907, 0.146279>, <-1.824066, 3.159376, 0.308746>, <-1.843200, 3.192516, 0.584795>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.893288, 2.256333, 0.024491>, <-1.775296, 2.355340, 0.024491>, <-1.606108, 2.473808, 0.024491>, <-1.472716, 2.550821, 0.024491>, 
      <-1.828590, 2.179228, -0.047388>, <-1.710598, 2.278235, -0.047388>, <-1.550483, 2.377464, -0.029559>, <-1.417092, 2.454477, -0.029559>, 
      <-1.707780, 2.035254, 0.023465>, <-1.606304, 2.120402, 0.023465>, <-1.443137, 2.234653, 0.023465>, <-1.328417, 2.300887, 0.023465>, 
      <-1.628281, 1.940510, 0.024491>, <-1.526805, 2.025659, 0.024491>, <-1.381297, 2.127543, 0.024491>, <-1.266577, 2.193777, 0.024491>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.256333, 1.893288, 0.024491>, <-2.382148, 1.998859, 0.141778>, <-2.528297, 2.121494, 0.383719>, <-2.541551, 2.132615, 0.584795>, 
      <-2.157326, 2.011280, 0.024491>, <-2.283142, 2.116851, 0.141778>, <-2.383420, 2.216951, 0.383719>, <-2.396674, 2.228072, 0.584795>, 
      <-2.011280, 2.157326, 0.024491>, <-2.116851, 2.283142, 0.141779>, <-2.216949, 2.383421, 0.383719>, <-2.228071, 2.396675, 0.584795>, 
      <-1.893288, 2.256333, 0.024491>, <-1.998859, 2.382148, 0.141779>, <-2.121493, 2.528298, 0.383719>, <-2.132614, 2.541552, 0.584795>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.256333, 1.893288, 0.024491>, <-2.157326, 2.011280, 0.024491>, <-2.011280, 2.157326, 0.024491>, <-1.893288, 2.256333, 0.024491>, 
      <-2.179228, 1.828589, -0.047388>, <-2.080222, 1.946581, -0.047388>, <-1.946581, 2.080222, -0.047388>, <-1.828590, 2.179228, -0.047388>, 
      <-2.035253, 1.707780, 0.023465>, <-1.950104, 1.809256, 0.023465>, <-1.809256, 1.950105, 0.023465>, <-1.707780, 2.035254, 0.023465>, 
      <-1.940509, 1.628281, 0.024491>, <-1.855361, 1.729757, 0.024491>, <-1.729757, 1.855362, 0.024491>, <-1.628281, 1.940510, 0.024491>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.550820, 1.472717, 0.024491>, <-2.767906, 1.598052, 0.146279>, <-3.159376, 1.824067, 0.308746>, <-3.192516, 1.843201, 0.584795>, 
      <-2.473807, 1.606108, 0.024491>, <-2.690893, 1.731443, 0.146279>, <-3.052516, 2.009155, 0.308746>, <-3.085656, 2.028288, 0.584795>, 
      <-2.355340, 1.775297, 0.024491>, <-2.481155, 1.880868, 0.141778>, <-2.706762, 2.003906, 0.383719>, <-2.720016, 2.015028, 0.584795>, 
      <-2.256333, 1.893288, 0.024491>, <-2.382148, 1.998859, 0.141778>, <-2.528297, 2.121494, 0.383719>, <-2.541551, 2.132615, 0.584795>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.550820, 1.472717, 0.024491>, <-2.473807, 1.606108, 0.024491>, <-2.355340, 1.775297, 0.024491>, <-2.256333, 1.893288, 0.024491>, 
      <-2.454476, 1.417093, -0.029559>, <-2.377463, 1.550484, -0.029559>, <-2.278235, 1.710598, -0.047388>, <-2.179228, 1.828589, -0.047388>, 
      <-2.300886, 1.328418, 0.023465>, <-2.234653, 1.443138, 0.023465>, <-2.120401, 1.606304, 0.023465>, <-2.035253, 1.707780, 0.023465>, 
      <-2.193777, 1.266578, 0.024491>, <-2.127543, 1.381298, 0.024491>, <-2.025657, 1.526805, 0.024491>, <-1.940509, 1.628281, 0.024491>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.767802, 1.007398, 0.024491>, <-2.922137, 1.063571, 0.141778>, <-3.101416, 1.128824, 0.383719>, <-3.117674, 1.134741, 0.584795>, 
      <-2.715122, 1.152136, 0.024491>, <-2.869457, 1.208309, 0.141778>, <-3.088815, 1.342172, 0.383719>, <-3.105073, 1.348090, 0.584795>, 
      <-2.627834, 1.339326, 0.024491>, <-2.844920, 1.464661, 0.146279>, <-3.266236, 1.638980, 0.308746>, <-3.299376, 1.658114, 0.584795>, 
      <-2.550820, 1.472717, 0.024491>, <-2.767906, 1.598052, 0.146279>, <-3.159376, 1.824067, 0.308746>, <-3.192516, 1.843201, 0.584795>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.767802, 1.007398, 0.024491>, <-2.715122, 1.152136, 0.024491>, <-2.627834, 1.339326, 0.024491>, <-2.550820, 1.472717, 0.024491>, 
      <-2.673219, 0.972973, -0.047388>, <-2.620539, 1.117710, -0.047388>, <-2.531490, 1.283702, -0.029559>, <-2.454476, 1.417093, -0.029559>, 
      <-2.496608, 0.908691, 0.023465>, <-2.451301, 1.033170, 0.023465>, <-2.367120, 1.213697, 0.023465>, <-2.300886, 1.328418, 0.023465>, 
      <-2.380387, 0.866390, 0.024491>, <-2.335081, 0.990869, 0.024491>, <-2.260011, 1.151858, 0.024491>, <-2.193777, 1.266578, 0.024491>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.900686, 0.511469, 0.024491>, <-3.062431, 0.539989, 0.141778>, <-3.250316, 0.573119, 0.383719>, <-3.267355, 0.576123, 0.584795>, 
      <-2.873940, 0.663156, 0.024491>, <-3.035684, 0.691676, 0.141778>, <-3.172578, 0.728225, 0.383719>, <-3.189616, 0.731229, 0.584795>, 
      <-2.820482, 0.862660, 0.024491>, <-2.974818, 0.918833, 0.141778>, <-3.111646, 0.955628, 0.383719>, <-3.127904, 0.961546, 0.584795>, 
      <-2.767802, 1.007398, 0.024491>, <-2.922137, 1.063571, 0.141778>, <-3.101416, 1.128824, 0.383719>, <-3.117674, 1.134741, 0.584795>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.900686, 0.511469, 0.024491>, <-2.873940, 0.663156, 0.024491>, <-2.820482, 0.862660, 0.024491>, <-2.767802, 1.007398, 0.024491>, 
      <-2.801562, 0.493991, -0.047388>, <-2.774816, 0.645678, -0.047388>, <-2.725899, 0.828234, -0.047388>, <-2.673219, 0.972973, -0.047388>, 
      <-2.616471, 0.461355, 0.023465>, <-2.593469, 0.591809, 0.023465>, <-2.541914, 0.784212, 0.023465>, <-2.496608, 0.908691, 0.023465>, 
      <-2.494671, 0.439878, 0.024491>, <-2.471668, 0.570333, 0.024491>, <-2.425694, 0.741911, 0.024491>, <-2.380387, 0.866390, 0.024491>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.945434, 0.000000, 0.024491>, <-3.196104, 0.000000, 0.146279>, <-3.648132, 0.000000, 0.308746>, <-3.686400, 0.000000, 0.584795>, 
      <-2.945434, 0.154027, 0.024491>, <-3.196104, 0.154027, 0.146279>, <-3.648132, 0.213721, 0.308746>, <-3.686400, 0.213721, 0.584795>, 
      <-2.927433, 0.359782, 0.024491>, <-3.089177, 0.388302, 0.141778>, <-3.346078, 0.382053, 0.383719>, <-3.363116, 0.385057, 0.584795>, 
      <-2.900686, 0.511469, 0.024491>, <-3.062431, 0.539989, 0.141778>, <-3.250316, 0.573119, 0.383719>, <-3.267355, 0.576123, 0.584795>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.945434, 0.000000, 0.024491>, <-2.945434, 0.154027, 0.024491>, <-2.927433, 0.359782, 0.024491>, <-2.900686, 0.511469, 0.024491>, 
      <-2.834186, 0.000000, -0.029559>, <-2.834186, 0.154027, -0.029559>, <-2.828309, 0.342304, -0.047388>, <-2.801562, 0.493991, -0.047388>, 
      <-2.656834, 0.000000, 0.023465>, <-2.656834, 0.132467, 0.023465>, <-2.639474, 0.330900, 0.023465>, <-2.616471, 0.461355, 0.023465>, 
      <-2.533155, 0.000000, 0.024491>, <-2.533155, 0.132467, 0.024491>, <-2.517674, 0.309423, 0.024491>, <-2.494671, 0.439878, 0.024491>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.900686, -0.511469, 0.024491>, <-3.062431, -0.539989, 0.141778>, <-3.250317, -0.573119, 0.383719>, <-3.267356, -0.576123, 0.584795>, 
      <-2.927433, -0.359782, 0.024491>, <-3.089178, -0.388302, 0.141778>, <-3.346078, -0.382053, 0.383719>, <-3.363117, -0.385057, 0.584795>, 
      <-2.945434, -0.154027, 0.024491>, <-3.196104, -0.154027, 0.146279>, <-3.648133, -0.213720, 0.308746>, <-3.686400, -0.213720, 0.584795>, 
      <-2.945434, 0.000000, 0.024491>, <-3.196104, 0.000000, 0.146279>, <-3.648132, 0.000000, 0.308746>, <-3.686400, 0.000000, 0.584795>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.900686, -0.511469, 0.024491>, <-2.927433, -0.359782, 0.024491>, <-2.945434, -0.154027, 0.024491>, <-2.945434, 0.000000, 0.024491>, 
      <-2.801562, -0.493991, -0.047388>, <-2.828309, -0.342304, -0.047388>, <-2.834186, -0.154027, -0.029559>, <-2.834186, 0.000000, -0.029559>, 
      <-2.616471, -0.461355, 0.023465>, <-2.639474, -0.330900, 0.023465>, <-2.656834, -0.132467, 0.023465>, <-2.656834, 0.000000, 0.023465>, 
      <-2.494671, -0.439878, 0.024491>, <-2.517674, -0.309423, 0.024491>, <-2.533155, -0.132467, 0.024491>, <-2.533155, 0.000000, 0.024491>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.767802, -1.007397, 0.024491>, <-2.922137, -1.063570, 0.141778>, <-3.101417, -1.128823, 0.383719>, <-3.117675, -1.134740, 0.584795>, 
      <-2.820482, -0.862659, 0.024491>, <-2.974818, -0.918832, 0.141778>, <-3.111647, -0.955628, 0.383719>, <-3.127905, -0.961545, 0.584795>, 
      <-2.873940, -0.663156, 0.024491>, <-3.035684, -0.691676, 0.141778>, <-3.172579, -0.728225, 0.383719>, <-3.189618, -0.731229, 0.584795>, 
      <-2.900686, -0.511469, 0.024491>, <-3.062431, -0.539989, 0.141778>, <-3.250317, -0.573119, 0.383719>, <-3.267356, -0.576123, 0.584795>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.767802, -1.007397, 0.024491>, <-2.820482, -0.862659, 0.024491>, <-2.873940, -0.663156, 0.024491>, <-2.900686, -0.511469, 0.024491>, 
      <-2.673219, -0.972972, -0.047388>, <-2.725899, -0.828234, -0.047388>, <-2.774816, -0.645678, -0.047388>, <-2.801562, -0.493991, -0.047388>, 
      <-2.496608, -0.908691, 0.023465>, <-2.541914, -0.784212, 0.023465>, <-2.593469, -0.591809, 0.023465>, <-2.616471, -0.461355, 0.023465>, 
      <-2.380387, -0.866390, 0.024491>, <-2.425694, -0.741911, 0.024491>, <-2.471668, -0.570333, 0.024491>, <-2.494671, -0.439878, 0.024491>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.550821, -1.472717, 0.024491>, <-2.767907, -1.598052, 0.146279>, <-3.159376, -1.824066, 0.308746>, <-3.192516, -1.843200, 0.584795>, 
      <-2.627835, -1.339326, 0.024491>, <-2.844921, -1.464660, 0.146279>, <-3.266236, -1.638979, 0.308746>, <-3.299376, -1.658113, 0.584795>, 
      <-2.715122, -1.152135, 0.024491>, <-2.869457, -1.208308, 0.141778>, <-3.088816, -1.342171, 0.383719>, <-3.105074, -1.348089, 0.584795>, 
      <-2.767802, -1.007397, 0.024491>, <-2.922137, -1.063570, 0.141778>, <-3.101417, -1.128823, 0.383719>, <-3.117675, -1.134740, 0.584795>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.550821, -1.472717, 0.024491>, <-2.627835, -1.339326, 0.024491>, <-2.715122, -1.152135, 0.024491>, <-2.767802, -1.007397, 0.024491>, 
      <-2.454477, -1.417093, -0.029559>, <-2.531491, -1.283701, -0.029559>, <-2.620539, -1.117710, -0.047388>, <-2.673219, -0.972972, -0.047388>, 
      <-2.300887, -1.328418, 0.023465>, <-2.367120, -1.213697, 0.023465>, <-2.451301, -1.033170, 0.023465>, <-2.496608, -0.908691, 0.023465>, 
      <-2.193777, -1.266578, 0.024491>, <-2.260011, -1.151858, 0.024491>, <-2.335081, -0.990869, 0.024491>, <-2.380387, -0.866390, 0.024491>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.256333, -1.893288, 0.024491>, <-2.382148, -1.998859, 0.141779>, <-2.528297, -2.121494, 0.383719>, <-2.541551, -2.132615, 0.584795>, 
      <-2.355340, -1.775297, 0.024491>, <-2.481155, -1.880868, 0.141779>, <-2.706762, -2.003906, 0.383719>, <-2.720016, -2.015028, 0.584795>, 
      <-2.473808, -1.606108, 0.024491>, <-2.690894, -1.731443, 0.146279>, <-3.052515, -2.009154, 0.308746>, <-3.085656, -2.028287, 0.584795>, 
      <-2.550821, -1.472717, 0.024491>, <-2.767907, -1.598052, 0.146279>, <-3.159376, -1.824066, 0.308746>, <-3.192516, -1.843200, 0.584795>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.256333, -1.893288, 0.024491>, <-2.355340, -1.775297, 0.024491>, <-2.473808, -1.606108, 0.024491>, <-2.550821, -1.472717, 0.024491>, 
      <-2.179229, -1.828589, -0.047388>, <-2.278235, -1.710598, -0.047388>, <-2.377464, -1.550484, -0.029559>, <-2.454477, -1.417093, -0.029559>, 
      <-2.035254, -1.707780, 0.023465>, <-2.120402, -1.606305, 0.023465>, <-2.234653, -1.443138, 0.023465>, <-2.300887, -1.328418, 0.023465>, 
      <-1.940510, -1.628281, 0.024491>, <-2.025658, -1.526805, 0.024491>, <-2.127543, -1.381298, 0.024491>, <-2.193777, -1.266578, 0.024491>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.893288, -2.256333, 0.024491>, <-1.998859, -2.382148, 0.141778>, <-2.121494, -2.528297, 0.383719>, <-2.132615, -2.541551, 0.584795>, 
      <-2.011280, -2.157326, 0.024491>, <-2.116851, -2.283142, 0.141778>, <-2.216950, -2.383421, 0.383719>, <-2.228072, -2.396675, 0.584795>, 
      <-2.157326, -2.011280, 0.024491>, <-2.283141, -2.116851, 0.141779>, <-2.383421, -2.216950, 0.383719>, <-2.396675, -2.228072, 0.584795>, 
      <-2.256333, -1.893288, 0.024491>, <-2.382148, -1.998859, 0.141779>, <-2.528297, -2.121494, 0.383719>, <-2.541551, -2.132615, 0.584795>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.893288, -2.256333, 0.024491>, <-2.011280, -2.157326, 0.024491>, <-2.157326, -2.011280, 0.024491>, <-2.256333, -1.893288, 0.024491>, 
      <-1.828589, -2.179228, -0.047388>, <-1.946581, -2.080222, -0.047388>, <-2.080222, -1.946581, -0.047388>, <-2.179229, -1.828589, -0.047388>, 
      <-1.707780, -2.035253, 0.023465>, <-1.809256, -1.950104, 0.023465>, <-1.950105, -1.809256, 0.023465>, <-2.035254, -1.707780, 0.023465>, 
      <-1.628281, -1.940509, 0.024491>, <-1.729757, -1.855361, 0.024491>, <-1.855362, -1.729757, 0.024491>, <-1.940510, -1.628281, 0.024491>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.472717, -2.550820, 0.024491>, <-1.598052, -2.767906, 0.146279>, <-1.824066, -3.159376, 0.308746>, <-1.843200, -3.192516, 0.584795>, 
      <-1.606108, -2.473807, 0.024491>, <-1.731443, -2.690893, 0.146279>, <-2.009154, -3.052515, 0.308746>, <-2.028287, -3.085656, 0.584795>, 
      <-1.775297, -2.355340, 0.024491>, <-1.880868, -2.481155, 0.141778>, <-2.003906, -2.706762, 0.383719>, <-2.015028, -2.720016, 0.584795>, 
      <-1.893288, -2.256333, 0.024491>, <-1.998859, -2.382148, 0.141778>, <-2.121494, -2.528297, 0.383719>, <-2.132615, -2.541551, 0.584795>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.472717, -2.550820, 0.024491>, <-1.606108, -2.473807, 0.024491>, <-1.775297, -2.355340, 0.024491>, <-1.893288, -2.256333, 0.024491>, 
      <-1.417093, -2.454476, -0.029559>, <-1.550484, -2.377463, -0.029559>, <-1.710598, -2.278235, -0.047388>, <-1.828589, -2.179228, -0.047388>, 
      <-1.328418, -2.300886, 0.023465>, <-1.443138, -2.234653, 0.023465>, <-1.606304, -2.120401, 0.023465>, <-1.707780, -2.035253, 0.023465>, 
      <-1.266578, -2.193777, 0.024491>, <-1.381298, -2.127543, 0.024491>, <-1.526805, -2.025657, 0.024491>, <-1.628281, -1.940509, 0.024491>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.007398, -2.767802, 0.024491>, <-1.063571, -2.922137, 0.141778>, <-1.128824, -3.101416, 0.383719>, <-1.134741, -3.117674, 0.584795>, 
      <-1.152136, -2.715122, 0.024491>, <-1.208309, -2.869457, 0.141778>, <-1.342172, -3.088815, 0.383719>, <-1.348089, -3.105073, 0.584795>, 
      <-1.339326, -2.627834, 0.024491>, <-1.464661, -2.844920, 0.146279>, <-1.638979, -3.266236, 0.308746>, <-1.658113, -3.299376, 0.584795>, 
      <-1.472717, -2.550820, 0.024491>, <-1.598052, -2.767906, 0.146279>, <-1.824066, -3.159376, 0.308746>, <-1.843200, -3.192516, 0.584795>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.007398, -2.767802, 0.024491>, <-1.152136, -2.715122, 0.024491>, <-1.339326, -2.627834, 0.024491>, <-1.472717, -2.550820, 0.024491>, 
      <-0.972973, -2.673219, -0.047388>, <-1.117710, -2.620539, -0.047388>, <-1.283702, -2.531490, -0.029559>, <-1.417093, -2.454476, -0.029559>, 
      <-0.908691, -2.496608, 0.023465>, <-1.033170, -2.451301, 0.023465>, <-1.213697, -2.367120, 0.023465>, <-1.328418, -2.300886, 0.023465>, 
      <-0.866390, -2.380387, 0.024491>, <-0.990869, -2.335081, 0.024491>, <-1.151858, -2.260011, 0.024491>, <-1.266578, -2.193777, 0.024491>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.511469, -2.900686, 0.024491>, <-0.539989, -3.062431, 0.141778>, <-0.573119, -3.250316, 0.383719>, <-0.576123, -3.267355, 0.584795>, 
      <-0.663156, -2.873940, 0.024491>, <-0.691676, -3.035684, 0.141778>, <-0.728225, -3.172578, 0.383719>, <-0.731229, -3.189616, 0.584795>, 
      <-0.862660, -2.820482, 0.024491>, <-0.918833, -2.974818, 0.141778>, <-0.955628, -3.111646, 0.383719>, <-0.961546, -3.127904, 0.584795>, 
      <-1.007398, -2.767802, 0.024491>, <-1.063571, -2.922137, 0.141778>, <-1.128824, -3.101416, 0.383719>, <-1.134741, -3.117674, 0.584795>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.511469, -2.900686, 0.024491>, <-0.663156, -2.873940, 0.024491>, <-0.862660, -2.820482, 0.024491>, <-1.007398, -2.767802, 0.024491>, 
      <-0.493991, -2.801562, -0.047388>, <-0.645678, -2.774816, -0.047388>, <-0.828234, -2.725899, -0.047388>, <-0.972973, -2.673219, -0.047388>, 
      <-0.461355, -2.616471, 0.023465>, <-0.591809, -2.593469, 0.023465>, <-0.784212, -2.541914, 0.023465>, <-0.908691, -2.496608, 0.023465>, 
      <-0.439878, -2.494671, 0.024491>, <-0.570333, -2.471668, 0.024491>, <-0.741911, -2.425694, 0.024491>, <-0.866390, -2.380387, 0.024491>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -2.945434, 0.024491>, <0.000000, -3.196104, 0.146279>, <0.000000, -3.648132, 0.308746>, <0.000000, -3.686400, 0.584795>, 
      <-0.154027, -2.945434, 0.024491>, <-0.154027, -3.196104, 0.146279>, <-0.213721, -3.648132, 0.308746>, <-0.213721, -3.686400, 0.584795>, 
      <-0.359782, -2.927433, 0.024491>, <-0.388302, -3.089177, 0.141778>, <-0.382053, -3.346078, 0.383719>, <-0.385057, -3.363116, 0.584795>, 
      <-0.511469, -2.900686, 0.024491>, <-0.539989, -3.062431, 0.141778>, <-0.573119, -3.250316, 0.383719>, <-0.576123, -3.267355, 0.584795>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -2.945434, 0.024491>, <-0.154027, -2.945434, 0.024491>, <-0.359782, -2.927433, 0.024491>, <-0.511469, -2.900686, 0.024491>, 
      <0.000000, -2.834186, -0.029559>, <-0.154027, -2.834186, -0.029559>, <-0.342304, -2.828309, -0.047388>, <-0.493991, -2.801562, -0.047388>, 
      <0.000000, -2.656834, 0.023465>, <-0.132467, -2.656834, 0.023465>, <-0.330900, -2.639474, 0.023465>, <-0.461355, -2.616471, 0.023465>, 
      <0.000000, -2.533155, 0.024491>, <-0.132467, -2.533155, 0.024491>, <-0.309423, -2.517674, 0.024491>, <-0.439878, -2.494671, 0.024491>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.511469, -2.900686, 0.024491>, <0.539989, -3.062431, 0.141778>, <0.573119, -3.250317, 0.383719>, <0.576123, -3.267356, 0.584795>, 
      <0.359782, -2.927433, 0.024491>, <0.388302, -3.089177, 0.141778>, <0.382053, -3.346078, 0.383719>, <0.385057, -3.363117, 0.584795>, 
      <0.154027, -2.945434, 0.024491>, <0.154027, -3.196104, 0.146279>, <0.213720, -3.648133, 0.308746>, <0.213720, -3.686400, 0.584795>, 
      <0.000000, -2.945434, 0.024491>, <0.000000, -3.196104, 0.146279>, <0.000000, -3.648132, 0.308746>, <0.000000, -3.686400, 0.584795>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.511469, -2.900686, 0.024491>, <0.359782, -2.927433, 0.024491>, <0.154027, -2.945434, 0.024491>, <0.000000, -2.945434, 0.024491>, 
      <0.493991, -2.801562, -0.047388>, <0.342304, -2.828309, -0.047388>, <0.154027, -2.834186, -0.029559>, <0.000000, -2.834186, -0.029559>, 
      <0.461355, -2.616471, 0.023465>, <0.330900, -2.639474, 0.023465>, <0.132467, -2.656834, 0.023465>, <0.000000, -2.656834, 0.023465>, 
      <0.439878, -2.494671, 0.024491>, <0.309423, -2.517674, 0.024491>, <0.132467, -2.533155, 0.024491>, <0.000000, -2.533155, 0.024491>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.007398, -2.767802, 0.024491>, <1.063571, -2.922137, 0.141778>, <1.128824, -3.101416, 0.383719>, <1.134741, -3.117674, 0.584795>, 
      <0.862660, -2.820482, 0.024491>, <0.918833, -2.974817, 0.141778>, <0.955628, -3.111646, 0.383719>, <0.961546, -3.127904, 0.584795>, 
      <0.663156, -2.873940, 0.024491>, <0.691676, -3.035684, 0.141778>, <0.728225, -3.172579, 0.383719>, <0.731229, -3.189617, 0.584795>, 
      <0.511469, -2.900686, 0.024491>, <0.539989, -3.062431, 0.141778>, <0.573119, -3.250317, 0.383719>, <0.576123, -3.267356, 0.584795>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.007398, -2.767802, 0.024491>, <0.862660, -2.820482, 0.024491>, <0.663156, -2.873940, 0.024491>, <0.511469, -2.900686, 0.024491>, 
      <0.972973, -2.673219, -0.047388>, <0.828234, -2.725899, -0.047388>, <0.645678, -2.774816, -0.047388>, <0.493991, -2.801562, -0.047388>, 
      <0.908691, -2.496608, 0.023465>, <0.784212, -2.541914, 0.023465>, <0.591809, -2.593469, 0.023465>, <0.461355, -2.616471, 0.023465>, 
      <0.866390, -2.380387, 0.024491>, <0.741911, -2.425694, 0.024491>, <0.570333, -2.471668, 0.024491>, <0.439878, -2.494671, 0.024491>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.472717, -2.550821, 0.024491>, <1.598052, -2.767907, 0.146279>, <1.824066, -3.159376, 0.308746>, <1.843200, -3.192516, 0.584795>, 
      <1.339326, -2.627834, 0.024491>, <1.464661, -2.844920, 0.146279>, <1.638979, -3.266236, 0.308746>, <1.658113, -3.299376, 0.584795>, 
      <1.152136, -2.715122, 0.024491>, <1.208309, -2.869457, 0.141778>, <1.342172, -3.088815, 0.383719>, <1.348089, -3.105073, 0.584795>, 
      <1.007398, -2.767802, 0.024491>, <1.063571, -2.922137, 0.141778>, <1.128824, -3.101416, 0.383719>, <1.134741, -3.117674, 0.584795>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.472717, -2.550821, 0.024491>, <1.339326, -2.627834, 0.024491>, <1.152136, -2.715122, 0.024491>, <1.007398, -2.767802, 0.024491>, 
      <1.417093, -2.454477, -0.029559>, <1.283702, -2.531490, -0.029559>, <1.117710, -2.620539, -0.047388>, <0.972973, -2.673219, -0.047388>, 
      <1.328418, -2.300887, 0.023465>, <1.213697, -2.367120, 0.023465>, <1.033170, -2.451301, 0.023465>, <0.908691, -2.496608, 0.023465>, 
      <1.266578, -2.193777, 0.024491>, <1.151858, -2.260011, 0.024491>, <0.990869, -2.335081, 0.024491>, <0.866390, -2.380387, 0.024491>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.893288, -2.256333, 0.024491>, <1.998859, -2.382148, 0.141778>, <2.121494, -2.528297, 0.383719>, <2.132615, -2.541551, 0.584795>, 
      <1.775297, -2.355340, 0.024491>, <1.880868, -2.481155, 0.141778>, <2.003906, -2.706762, 0.383719>, <2.015028, -2.720016, 0.584795>, 
      <1.606108, -2.473808, 0.024491>, <1.731443, -2.690894, 0.146279>, <2.009154, -3.052515, 0.308746>, <2.028287, -3.085656, 0.584795>, 
      <1.472717, -2.550821, 0.024491>, <1.598052, -2.767907, 0.146279>, <1.824066, -3.159376, 0.308746>, <1.843200, -3.192516, 0.584795>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.893288, -2.256333, 0.024491>, <1.775297, -2.355340, 0.024491>, <1.606108, -2.473808, 0.024491>, <1.472717, -2.550821, 0.024491>, 
      <1.828589, -2.179228, -0.047388>, <1.710598, -2.278235, -0.047388>, <1.550484, -2.377464, -0.029559>, <1.417093, -2.454477, -0.029559>, 
      <1.707780, -2.035253, 0.023465>, <1.606305, -2.120401, 0.023465>, <1.443138, -2.234653, 0.023465>, <1.328418, -2.300887, 0.023465>, 
      <1.628281, -1.940509, 0.024491>, <1.526805, -2.025657, 0.024491>, <1.381298, -2.127543, 0.024491>, <1.266578, -2.193777, 0.024491>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.256333, -1.893288, 0.024491>, <2.382148, -1.998859, 0.141778>, <2.528297, -2.121494, 0.383719>, <2.541551, -2.132615, 0.584795>, 
      <2.157326, -2.011280, 0.024491>, <2.283142, -2.116851, 0.141778>, <2.383421, -2.216950, 0.383719>, <2.396675, -2.228072, 0.584795>, 
      <2.011280, -2.157326, 0.024491>, <2.116851, -2.283142, 0.141778>, <2.216950, -2.383421, 0.383719>, <2.228072, -2.396675, 0.584795>, 
      <1.893288, -2.256333, 0.024491>, <1.998859, -2.382148, 0.141778>, <2.121494, -2.528297, 0.383719>, <2.132615, -2.541551, 0.584795>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.256333, -1.893288, 0.024491>, <2.157326, -2.011280, 0.024491>, <2.011280, -2.157326, 0.024491>, <1.893288, -2.256333, 0.024491>, 
      <2.179228, -1.828589, -0.047388>, <2.080222, -1.946581, -0.047388>, <1.946581, -2.080222, -0.047388>, <1.828589, -2.179228, -0.047388>, 
      <2.035253, -1.707780, 0.023465>, <1.950104, -1.809256, 0.023465>, <1.809256, -1.950104, 0.023465>, <1.707780, -2.035253, 0.023465>, 
      <1.940509, -1.628281, 0.024491>, <1.855361, -1.729757, 0.024491>, <1.729757, -1.855361, 0.024491>, <1.628281, -1.940509, 0.024491>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.550820, -1.472717, 0.024491>, <2.767906, -1.598052, 0.146279>, <3.159376, -1.824066, 0.308746>, <3.192516, -1.843200, 0.584795>, 
      <2.473807, -1.606108, 0.024491>, <2.690893, -1.731443, 0.146279>, <3.052515, -2.009154, 0.308746>, <3.085656, -2.028287, 0.584795>, 
      <2.355340, -1.775297, 0.024491>, <2.481155, -1.880868, 0.141778>, <2.706762, -2.003906, 0.383719>, <2.720016, -2.015028, 0.584795>, 
      <2.256333, -1.893288, 0.024491>, <2.382148, -1.998859, 0.141778>, <2.528297, -2.121494, 0.383719>, <2.541551, -2.132615, 0.584795>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.550820, -1.472717, 0.024491>, <2.473807, -1.606108, 0.024491>, <2.355340, -1.775297, 0.024491>, <2.256333, -1.893288, 0.024491>, 
      <2.454476, -1.417093, -0.029559>, <2.377463, -1.550484, -0.029559>, <2.278235, -1.710598, -0.047388>, <2.179228, -1.828589, -0.047388>, 
      <2.300886, -1.328418, 0.023465>, <2.234653, -1.443138, 0.023465>, <2.120401, -1.606305, 0.023465>, <2.035253, -1.707780, 0.023465>, 
      <2.193777, -1.266578, 0.024491>, <2.127543, -1.381298, 0.024491>, <2.025657, -1.526805, 0.024491>, <1.940509, -1.628281, 0.024491>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.767802, -1.007398, 0.024491>, <2.922137, -1.063571, 0.141778>, <3.101416, -1.128824, 0.383719>, <3.117674, -1.134741, 0.584795>, 
      <2.715122, -1.152136, 0.024491>, <2.869457, -1.208309, 0.141778>, <3.088815, -1.342172, 0.383719>, <3.105073, -1.348089, 0.584795>, 
      <2.627834, -1.339326, 0.024491>, <2.844920, -1.464661, 0.146279>, <3.266236, -1.638979, 0.308746>, <3.299376, -1.658113, 0.584795>, 
      <2.550820, -1.472717, 0.024491>, <2.767906, -1.598052, 0.146279>, <3.159376, -1.824066, 0.308746>, <3.192516, -1.843200, 0.584795>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.767802, -1.007398, 0.024491>, <2.715122, -1.152136, 0.024491>, <2.627834, -1.339326, 0.024491>, <2.550820, -1.472717, 0.024491>, 
      <2.673219, -0.972973, -0.047388>, <2.620539, -1.117710, -0.047388>, <2.531490, -1.283702, -0.029559>, <2.454476, -1.417093, -0.029559>, 
      <2.496608, -0.908691, 0.023465>, <2.451301, -1.033170, 0.023465>, <2.367120, -1.213697, 0.023465>, <2.300886, -1.328418, 0.023465>, 
      <2.380387, -0.866390, 0.024491>, <2.335081, -0.990869, 0.024491>, <2.260011, -1.151858, 0.024491>, <2.193777, -1.266578, 0.024491>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.900686, -0.511469, 0.024491>, <3.062431, -0.539989, 0.141778>, <3.250316, -0.573119, 0.383719>, <3.267355, -0.576123, 0.584795>, 
      <2.873940, -0.663156, 0.024491>, <3.035684, -0.691676, 0.141778>, <3.172578, -0.728225, 0.383719>, <3.189616, -0.731229, 0.584795>, 
      <2.820482, -0.862660, 0.024491>, <2.974818, -0.918833, 0.141778>, <3.111646, -0.955628, 0.383719>, <3.127904, -0.961546, 0.584795>, 
      <2.767802, -1.007398, 0.024491>, <2.922137, -1.063571, 0.141778>, <3.101416, -1.128824, 0.383719>, <3.117674, -1.134741, 0.584795>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.900686, -0.511469, 0.024491>, <2.873940, -0.663156, 0.024491>, <2.820482, -0.862660, 0.024491>, <2.767802, -1.007398, 0.024491>, 
      <2.801562, -0.493991, -0.047388>, <2.774816, -0.645678, -0.047388>, <2.725899, -0.828234, -0.047388>, <2.673219, -0.972973, -0.047388>, 
      <2.616471, -0.461355, 0.023465>, <2.593469, -0.591809, 0.023465>, <2.541914, -0.784212, 0.023465>, <2.496608, -0.908691, 0.023465>, 
      <2.494671, -0.439878, 0.024491>, <2.471668, -0.570333, 0.024491>, <2.425694, -0.741911, 0.024491>, <2.380387, -0.866390, 0.024491>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.686400, 0.000000, 0.584795>, <3.976979, 0.000000, 2.680948>, <3.917592, 0.000000, 5.517220>, <4.000000, 0.000000, 7.631812>, 
      <3.686400, -0.213721, 0.584795>, <3.976979, -0.213721, 2.680948>, <3.917592, -0.231901, 5.517220>, <4.000000, -0.231901, 7.631812>, 
      <3.363116, -0.385057, 0.584795>, <3.541743, -0.416554, 2.692806>, <3.475322, -0.387151, 5.523393>, <3.649216, -0.417813, 7.631812>, 
      <3.267355, -0.576123, 0.584795>, <3.445982, -0.607620, 2.692806>, <3.371415, -0.594471, 5.523393>, <3.545308, -0.625133, 7.631812>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.686400, 0.000000, 0.584795>, <3.686400, 0.213720, 0.584795>, <3.363117, 0.385056, 0.584795>, <3.267356, 0.576122, 0.584795>, 
      <3.976979, 0.000000, 2.680948>, <3.976980, 0.213720, 2.680948>, <3.541744, 0.416553, 2.692806>, <3.445982, 0.607619, 2.692806>, 
      <3.917592, 0.000000, 5.517220>, <3.917592, 0.231901, 5.517220>, <3.475323, 0.387151, 5.523393>, <3.371415, 0.594471, 5.523393>, 
      <4.000000, 0.000000, 7.631812>, <4.000000, 0.231901, 7.631812>, <3.649216, 0.417813, 7.631812>, <3.545308, 0.625133, 7.631812>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.945434, 0.000000, 0.024491>, <3.196104, 0.000000, 0.146279>, <3.648132, 0.000000, 0.308746>, <3.686400, 0.000000, 0.584795>, 
      <2.945434, -0.154027, 0.024491>, <3.196104, -0.154027, 0.146279>, <3.648132, -0.213721, 0.308746>, <3.686400, -0.213721, 0.584795>, 
      <2.927433, -0.359782, 0.024491>, <3.089177, -0.388302, 0.141778>, <3.346078, -0.382053, 0.383719>, <3.363116, -0.385057, 0.584795>, 
      <2.900686, -0.511469, 0.024491>, <3.062431, -0.539989, 0.141778>, <3.250316, -0.573119, 0.383719>, <3.267355, -0.576123, 0.584795>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.945434, 0.000000, 0.024491>, <2.945434, 0.154027, 0.024491>, <2.927433, 0.359782, 0.024491>, <2.900686, 0.511469, 0.024491>, 
      <3.196104, 0.000000, 0.146279>, <3.196104, 0.154027, 0.146279>, <3.089178, 0.388302, 0.141778>, <3.062431, 0.539989, 0.141778>, 
      <3.648132, 0.000000, 0.308746>, <3.648133, 0.213720, 0.308746>, <3.346078, 0.382052, 0.383719>, <3.250317, 0.573118, 0.383719>, 
      <3.686400, 0.000000, 0.584795>, <3.686400, 0.213720, 0.584795>, <3.363117, 0.385056, 0.584795>, <3.267356, 0.576122, 0.584795>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.945434, 0.000000, 0.024491>, <2.945434, -0.154027, 0.024491>, <2.927433, -0.359782, 0.024491>, <2.900686, -0.511469, 0.024491>, 
      <2.834186, 0.000000, -0.029559>, <2.834186, -0.154027, -0.029559>, <2.828309, -0.342304, -0.047388>, <2.801562, -0.493991, -0.047388>, 
      <2.656834, 0.000000, 0.023465>, <2.656834, -0.132467, 0.023465>, <2.639474, -0.330900, 0.023465>, <2.616471, -0.461355, 0.023465>, 
      <2.533155, 0.000000, 0.024491>, <2.533155, -0.132467, 0.024491>, <2.517674, -0.309423, 0.024491>, <2.494671, -0.439878, 0.024491>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.945434, 0.000000, 0.024491>, <2.834186, 0.000000, -0.029559>, <2.656834, 0.000000, 0.023465>, <2.533155, 0.000000, 0.024491>, 
      <2.945434, 0.154027, 0.024491>, <2.834186, 0.154027, -0.029559>, <2.656834, 0.132467, 0.023465>, <2.533155, 0.132467, 0.024491>, 
      <2.927433, 0.359782, 0.024491>, <2.828309, 0.342304, -0.047388>, <2.639474, 0.330899, 0.023465>, <2.517674, 0.309422, 0.024491>, 
      <2.900686, 0.511469, 0.024491>, <2.801562, 0.493991, -0.047388>, <2.616472, 0.461354, 0.023465>, <2.494671, 0.439877, 0.024491>
    }
  }
  material {
    vaso_bas_txt
  }
  scale <0.7, 0.7, 0.8>
  translate  <0.0, -4.229189, 0.983694>
}
union { // vasodientes
  object { pasta_dientes }
  object { cepillodientes }
  object { vaso }
  translate  0.07*z
}


#declare tornillohead = difference {
  cone { // Cone001
    <0,0,0>, 0.2, <0,0,1>, 1.0
  }
  box { // Cube012
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 1.2, 0.1>
    translate  0.917934*z
  }
}
#declare tornillo = union {
  object { tornillohead }
  cone { // Cone002
    <0,0,0>, 0.2, <0,0,1>, 0.2
    scale <1.0, 1.0, 5.0>
    translate  -4.903144*z
  }
  material {
    tornillo_txt
  }
  scale 0.5
  rotate -90.0*y
  translate  <-13.742831, 7.327999, 22.576006>
}
#declare tornillohead1 = difference {
  cone { // Cone003
    <0,0,0>, 0.2, <0,0,1>, 1.0
  }
  box { // Cube013
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 1.2, 0.1>
    translate  0.917934*z
  }
}
#declare tornillo1 = union {
  object { tornillohead1 }
  cone { // Cone004
    <0,0,0>, 0.2, <0,0,1>, 0.2
    scale <1.0, 1.0, 5.0>
    translate  -4.903144*z
  }
  material {
    tornillo_txt
  }
  scale 0.5
  rotate 90.0*y
  translate  <13.764785, 7.327999, 22.576006>
}
#declare marco = union {
  object { marco_espejo_1 }
  object { // marco_espejo_2->marco espejo 1
    marco_espejo_1
    rotate <-180.0, 0.0, -180.0>
    translate  15.0*z
  }
  translate  -7.590594*z
}
#declare espejo = union {
  object { marco }
  box { // reflejo
    <-1, -1, -1>, <1, 1, 1>
    material {
      cristal_espejo_txt_1
    }
    scale <9.5, 0.05, 13.0>
    translate  <0.0, 0.036632, 0.020181>
  }
  box { // tapa_trasera
    <-1, -1, -1>, <1, 1, 1>
    scale <11.468702, 0.5, 15.087923>
    translate  0.748462*y
  }
  rotate -19.602921*x
  translate  <0.0, 5.197767, 18.441079>
}
#declare mueblespejo = union {
  object { tornillo }
  object { tornillo1 }
  object { sPatchObj1 }
  object { // sPatchObj2->sPatchObj1
    sPatchObj1
    rotate -0.0*y
    translate  26.611317*x
  }
  object { espejo }
  scale 1.1
  translate  -0.05*z
}
#declare curva_mesa = difference {
  cylinder { // Cylndr005
    <0,0,1>, <0,0,0>, 1 
  }
  cylinder { // Cylndr006
    <0,0,1>, <0,0,0>, 1 
    scale <0.8, 0.8, 1.2>
    translate  -0.1*z
  }
  box { // Cube016
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.2, 1.0>
    translate  <-1.0, 0.0, 0.5>
  }
  box { // Cube017
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.2, 1.0>
    rotate -90.0*z
    translate  <0.0, 1.0, 0.5>
  }
  translate  <17.0, -8.0, 0.0>
}
#declare curva_mesa1 = difference {
  cylinder { // Cylndr007
    <0,0,1>, <0,0,0>, 1 
  }
  cylinder { // Cylndr008
    <0,0,1>, <0,0,0>, 1 
    scale <0.8, 0.8, 1.2>
    translate  -0.1*z
  }
  box { // Cube018
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.2, 1.0>
    translate  <-1.0, 0.0, 0.5>
  }
  box { // Cube019
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.2, 1.0>
    rotate -90.0*z
    translate  <0.0, 1.0, 0.5>
  }
  rotate -90.0*z
  translate  <-17.0, -8.0, 0.0>
}
#declare borde_dorado = union {
  object { curva_mesa }
  object { curva_mesa1 }
  box { // Cube020
    <-1, -1, -1>, <1, 1, 1>
    scale <17.02, 0.1, 0.5>
    translate  <0.0, -8.9, 0.5>
  }
  box { // Cube021
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 8.02, 0.5>
    translate  <17.9, 0.0, 0.5>
  }
  box { // Cube022
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 8.02, 0.5>
    translate  <-17.9, 0.0, 0.5>
  }
  box { // Cube023
    <-1, -1, -1>, <1, 1, 1>
    scale <17.02, 0.1, 0.5>
    translate  <0.0, 8.9, 0.5>
  }
  material {
    borde_dorado_txt
  }
  translate  0.01*z
}
#declare mesita_resta = difference {
  superellipsoid { // SuperQ002
    <0.005, 0.05>
    scale <18.0, 8.0, 3.0>
    translate  -4.0*z
  }
  box { // Cube014
    <-1, -1, -1>, <1, 1, 1>
    scale <17.1, 7.1, 2.0>
    translate  <0.0, -1.0, -4.0>
  }
}
#declare RotSweep001 = lathe {
  cubic_spline
  6  // control points
  <0.106345, -0.937444>,
  <0.659517, -0.982574>,
  <0.802391, -0.196604>,
  <0.468398, 0.569793>,
  <0.391421, 0.99151>,
  <0.401251, 2.251117>
  rotate <90,0,90>
  scale 1.8
  rotate 180.0*x
  translate  <-16.082073, -6.090849, -8.787942>
}
#declare RotSweep002 = lathe {
  cubic_spline
  6  // control points
  <0.106345, -0.937444>,
  <0.659517, -0.982574>,
  <0.802391, -0.196604>,
  <0.468398, 0.569793>,
  <0.391421, 0.99151>,
  <0.401251, 2.251117>
  rotate <90,0,90>
  scale 1.8
  rotate 180.0*x
  translate  <16.08207, 6.09085, -8.787942>
}
#declare RotSweep003 = lathe {
  cubic_spline
  6  // control points
  <0.106345, -0.937444>,
  <0.659517, -0.982574>,
  <0.802391, -0.196604>,
  <0.468398, 0.569793>,
  <0.391421, 0.99151>,
  <0.401251, 2.251117>
  rotate <90,0,90>
  scale 1.8
  rotate 180.0*x
  translate  <16.08207, -6.090849, -8.787942>
}
#declare RotSweep004 = lathe {
  cubic_spline
  6  // control points
  <0.106345, -0.937444>,
  <0.659517, -0.982574>,
  <0.802391, -0.196604>,
  <0.468398, 0.569793>,
  <0.391421, 0.99151>,
  <0.401251, 2.251117>
  rotate <90,0,90>
  scale 1.8
  rotate 180.0*x
  translate  <-16.082073, 6.09085, -8.787942>
}
#declare patas = union {
  object { RotSweep001 }
  object { RotSweep002 }
  object { RotSweep003 }
  object { RotSweep004 }
}
#declare mesita = union {
  object { borde_dorado }
  object { mesita_resta }
  superellipsoid { // SuperQ001
    <0.005, 0.05>
    scale <19.0, 10.0, 1.0>
  }
  object { patas }
  scale 0.93
  translate  <0.0, 0.609928, 0.05>
}
#declare sPatchObj3 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -0.800000, 0.000000>, <0.183688, -0.800000, 0.000000>, <0.435799, -0.695572, 0.000000>, <0.565686, -0.565685, 0.000000>, 
      <0.000000, -0.560732, -0.018725>, <0.183688, -0.560732, -0.018725>, <0.266610, -0.526384, -0.018725>, <0.396497, -0.396497, -0.018725>, 
      <0.000000, -0.240000, 0.000000>, <0.000000, -0.240000, 0.000000>, <0.169706, -0.169706, 0.000000>, <0.169706, -0.169706, 0.000000>, 
      <0.000000, 0.000000, 0.000000>, <0.000000, 0.000000, 0.000000>, <0.000000, 0.000000, 0.000000>, <0.000000, 0.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.565685, -0.565685, 0.000000>, <-0.435798, -0.695573, 0.000000>, <-0.183688, -0.800000, 0.000000>, <0.000000, -0.800000, 0.000000>, 
      <-0.396497, -0.396497, -0.018725>, <-0.266610, -0.526384, -0.018725>, <-0.183688, -0.560732, -0.018725>, <0.000000, -0.560732, -0.018725>, 
      <-0.169706, -0.169706, 0.000000>, <-0.169706, -0.169706, 0.000000>, <0.000000, -0.240000, 0.000000>, <0.000000, -0.240000, 0.000000>, 
      <0.000000, 0.000000, 0.000000>, <0.000000, 0.000000, 0.000000>, <0.000000, 0.000000, 0.000000>, <0.000000, 0.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.800000, -0.000000, 0.000000>, <-0.800000, -0.183688, 0.000000>, <-0.695573, -0.435798, 0.000000>, <-0.565685, -0.565685, 0.000000>, 
      <-0.560732, 0.000000, -0.018725>, <-0.560732, -0.183688, -0.018725>, <-0.526384, -0.266610, -0.018725>, <-0.396497, -0.396497, -0.018725>, 
      <-0.240000, 0.000000, 0.000000>, <-0.240000, 0.000000, 0.000000>, <-0.169706, -0.169706, 0.000000>, <-0.169706, -0.169706, 0.000000>, 
      <0.000000, 0.000000, 0.000000>, <0.000000, 0.000000, 0.000000>, <0.000000, 0.000000, 0.000000>, <0.000000, 0.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.565685, 0.565685, 0.000000>, <-0.695573, 0.435798, 0.000000>, <-0.800000, 0.183688, 0.000000>, <-0.800000, -0.000000, 0.000000>, 
      <-0.396497, 0.396497, -0.018725>, <-0.526384, 0.266610, -0.018725>, <-0.560732, 0.183688, -0.018725>, <-0.560732, 0.000000, -0.018725>, 
      <-0.169706, 0.169706, 0.000000>, <-0.169706, 0.169706, 0.000000>, <-0.240000, 0.000000, 0.000000>, <-0.240000, 0.000000, 0.000000>, 
      <0.000000, 0.000000, 0.000000>, <0.000000, 0.000000, 0.000000>, <0.000000, 0.000000, 0.000000>, <0.000000, 0.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 0.800000, 0.000000>, <-0.183688, 0.800000, 0.000000>, <-0.435798, 0.695573, 0.000000>, <-0.565685, 0.565685, 0.000000>, 
      <0.000000, 0.560732, -0.018725>, <-0.183688, 0.560732, -0.018725>, <-0.266610, 0.526384, -0.018725>, <-0.396497, 0.396497, -0.018725>, 
      <0.000000, 0.240000, 0.000000>, <0.000000, 0.240000, 0.000000>, <-0.169706, 0.169706, 0.000000>, <-0.169706, 0.169706, 0.000000>, 
      <0.000000, 0.000000, 0.000000>, <0.000000, 0.000000, 0.000000>, <0.000000, 0.000000, 0.000000>, <0.000000, 0.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.565685, 0.565685, 0.000000>, <0.435798, 0.695573, 0.000000>, <0.183688, 0.800000, 0.000000>, <0.000000, 0.800000, 0.000000>, 
      <0.396497, 0.396497, -0.018725>, <0.266610, 0.526384, -0.018725>, <0.183688, 0.560732, -0.018725>, <0.000000, 0.560732, -0.018725>, 
      <0.169706, 0.169706, 0.000000>, <0.169706, 0.169706, 0.000000>, <0.000000, 0.240000, 0.000000>, <0.000000, 0.240000, 0.000000>, 
      <0.000000, 0.000000, 0.000000>, <0.000000, 0.000000, 0.000000>, <0.000000, 0.000000, 0.000000>, <0.000000, 0.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -0.889881, 0.069642>, <0.204326, -0.889881, 0.069642>, <0.484761, -0.773721, 0.069642>, <0.629241, -0.629240, 0.069642>, 
      <0.000000, -0.889881, 0.035531>, <0.204326, -0.889881, 0.035531>, <0.484761, -0.773721, 0.035531>, <0.629241, -0.629240, 0.035531>, 
      <0.000000, -0.834007, 0.002661>, <0.183688, -0.834007, 0.002661>, <0.459845, -0.719619, 0.002661>, <0.589732, -0.589732, 0.002661>, 
      <0.000000, -0.800000, 0.000000>, <0.183688, -0.800000, 0.000000>, <0.435799, -0.695572, 0.000000>, <0.565686, -0.565685, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.629240, -0.629241, 0.069642>, <-0.484761, -0.773721, 0.069642>, <-0.204325, -0.889881, 0.069642>, <0.000000, -0.889881, 0.069642>, 
      <-0.629240, -0.629241, 0.035531>, <-0.484761, -0.773721, 0.035531>, <-0.204325, -0.889881, 0.035531>, <0.000000, -0.889881, 0.035531>, 
      <-0.589732, -0.589732, 0.002661>, <-0.459845, -0.719619, 0.002661>, <-0.183688, -0.834007, 0.002661>, <0.000000, -0.834007, 0.002661>, 
      <-0.565685, -0.565685, 0.000000>, <-0.435798, -0.695573, 0.000000>, <-0.183688, -0.800000, 0.000000>, <0.000000, -0.800000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.889881, -0.000000, 0.069642>, <-0.889881, -0.204326, 0.069642>, <-0.773721, -0.484761, 0.069642>, <-0.629240, -0.629241, 0.069642>, 
      <-0.889881, -0.000000, 0.035531>, <-0.889881, -0.204326, 0.035531>, <-0.773721, -0.484761, 0.035531>, <-0.629240, -0.629241, 0.035531>, 
      <-0.834007, -0.000000, 0.002661>, <-0.834007, -0.183688, 0.002661>, <-0.719619, -0.459845, 0.002661>, <-0.589732, -0.589732, 0.002661>, 
      <-0.800000, -0.000000, 0.000000>, <-0.800000, -0.183688, 0.000000>, <-0.695573, -0.435798, 0.000000>, <-0.565685, -0.565685, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.629241, 0.629241, 0.069642>, <-0.773721, 0.484761, 0.069642>, <-0.889881, 0.204325, 0.069642>, <-0.889881, -0.000000, 0.069642>, 
      <-0.629241, 0.629241, 0.035531>, <-0.773721, 0.484761, 0.035531>, <-0.889881, 0.204325, 0.035531>, <-0.889881, -0.000000, 0.035531>, 
      <-0.589732, 0.589732, 0.002661>, <-0.719619, 0.459845, 0.002661>, <-0.834007, 0.183688, 0.002661>, <-0.834007, -0.000000, 0.002661>, 
      <-0.565685, 0.565685, 0.000000>, <-0.695573, 0.435798, 0.000000>, <-0.800000, 0.183688, 0.000000>, <-0.800000, -0.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 0.889881, 0.069642>, <-0.204326, 0.889881, 0.069642>, <-0.484761, 0.773721, 0.069642>, <-0.629241, 0.629241, 0.069642>, 
      <0.000000, 0.889881, 0.035531>, <-0.204326, 0.889881, 0.035531>, <-0.484761, 0.773721, 0.035531>, <-0.629241, 0.629241, 0.035531>, 
      <0.000000, 0.834007, 0.002661>, <-0.183688, 0.834007, 0.002661>, <-0.459845, 0.719619, 0.002661>, <-0.589732, 0.589732, 0.002661>, 
      <0.000000, 0.800000, 0.000000>, <-0.183688, 0.800000, 0.000000>, <-0.435798, 0.695573, 0.000000>, <-0.565685, 0.565685, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.629241, 0.629241, 0.069642>, <0.484761, 0.773721, 0.069642>, <0.204325, 0.889881, 0.069642>, <0.000000, 0.889881, 0.069642>, 
      <0.629241, 0.629241, 0.035531>, <0.484761, 0.773721, 0.035531>, <0.204325, 0.889881, 0.035531>, <0.000000, 0.889881, 0.035531>, 
      <0.589732, 0.589732, 0.002661>, <0.459845, 0.719619, 0.002661>, <0.183688, 0.834007, 0.002661>, <0.000000, 0.834007, 0.002661>, 
      <0.565685, 0.565685, 0.000000>, <0.435798, 0.695573, 0.000000>, <0.183688, 0.800000, 0.000000>, <0.000000, 0.800000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -0.800000, 0.129165>, <0.183688, -0.800000, 0.129165>, <0.435799, -0.695572, 0.129165>, <0.565686, -0.565685, 0.129165>, 
      <0.000000, -0.810901, 0.098716>, <0.183688, -0.810901, 0.098716>, <0.443507, -0.703281, 0.098716>, <0.573394, -0.573394, 0.098716>, 
      <0.000000, -0.889881, 0.101983>, <0.204326, -0.889881, 0.101983>, <0.484761, -0.773721, 0.101983>, <0.629241, -0.629240, 0.101983>, 
      <0.000000, -0.889881, 0.069642>, <0.204326, -0.889881, 0.069642>, <0.484761, -0.773721, 0.069642>, <0.629241, -0.629240, 0.069642>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.565685, -0.565685, 0.129165>, <-0.435798, -0.695573, 0.129165>, <-0.183688, -0.800000, 0.129165>, <0.000000, -0.800000, 0.129165>, 
      <-0.573394, -0.573394, 0.098716>, <-0.443507, -0.703281, 0.098716>, <-0.183688, -0.810901, 0.098716>, <0.000000, -0.810901, 0.098716>, 
      <-0.629240, -0.629241, 0.101983>, <-0.484761, -0.773721, 0.101983>, <-0.204325, -0.889881, 0.101983>, <0.000000, -0.889881, 0.101983>, 
      <-0.629240, -0.629241, 0.069642>, <-0.484761, -0.773721, 0.069642>, <-0.204325, -0.889881, 0.069642>, <0.000000, -0.889881, 0.069642>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.800000, -0.000000, 0.129165>, <-0.800000, -0.183688, 0.129165>, <-0.695573, -0.435798, 0.129165>, <-0.565685, -0.565685, 0.129165>, 
      <-0.810901, -0.000000, 0.098716>, <-0.810901, -0.183688, 0.098716>, <-0.703281, -0.443507, 0.098716>, <-0.573394, -0.573394, 0.098716>, 
      <-0.889881, -0.000000, 0.101983>, <-0.889881, -0.204326, 0.101983>, <-0.773721, -0.484761, 0.101983>, <-0.629240, -0.629241, 0.101983>, 
      <-0.889881, -0.000000, 0.069642>, <-0.889881, -0.204326, 0.069642>, <-0.773721, -0.484761, 0.069642>, <-0.629240, -0.629241, 0.069642>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.565685, 0.565685, 0.129165>, <-0.695573, 0.435798, 0.129165>, <-0.800000, 0.183688, 0.129165>, <-0.800000, -0.000000, 0.129165>, 
      <-0.573394, 0.573394, 0.098716>, <-0.703281, 0.443507, 0.098716>, <-0.810901, 0.183688, 0.098716>, <-0.810901, -0.000000, 0.098716>, 
      <-0.629241, 0.629241, 0.101983>, <-0.773721, 0.484761, 0.101983>, <-0.889881, 0.204325, 0.101983>, <-0.889881, -0.000000, 0.101983>, 
      <-0.629241, 0.629241, 0.069642>, <-0.773721, 0.484761, 0.069642>, <-0.889881, 0.204325, 0.069642>, <-0.889881, -0.000000, 0.069642>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 0.800000, 0.129165>, <-0.183688, 0.800000, 0.129165>, <-0.435798, 0.695573, 0.129165>, <-0.565685, 0.565685, 0.129165>, 
      <0.000000, 0.810901, 0.098716>, <-0.183688, 0.810901, 0.098716>, <-0.443507, 0.703281, 0.098716>, <-0.573394, 0.573394, 0.098716>, 
      <0.000000, 0.889881, 0.101983>, <-0.204326, 0.889881, 0.101983>, <-0.484761, 0.773721, 0.101983>, <-0.629241, 0.629241, 0.101983>, 
      <0.000000, 0.889881, 0.069642>, <-0.204326, 0.889881, 0.069642>, <-0.484761, 0.773721, 0.069642>, <-0.629241, 0.629241, 0.069642>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.565685, 0.565685, 0.129165>, <0.435798, 0.695573, 0.129165>, <0.183688, 0.800000, 0.129165>, <0.000000, 0.800000, 0.129165>, 
      <0.573394, 0.573394, 0.098716>, <0.443507, 0.703281, 0.098716>, <0.183688, 0.810901, 0.098716>, <0.000000, 0.810901, 0.098716>, 
      <0.629241, 0.629241, 0.101983>, <0.484761, 0.773721, 0.101983>, <0.204325, 0.889881, 0.101983>, <0.000000, 0.889881, 0.101983>, 
      <0.629241, 0.629241, 0.069642>, <0.484761, 0.773721, 0.069642>, <0.204325, 0.889881, 0.069642>, <0.000000, 0.889881, 0.069642>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -0.700000, 0.600000>, <0.160727, -0.700000, 0.600000>, <0.381324, -0.608626, 0.600000>, <0.494975, -0.494975, 0.600000>, 
      <0.000000, -0.700000, 0.455599>, <0.160727, -0.700000, 0.455599>, <0.381324, -0.608626, 0.455599>, <0.494975, -0.494975, 0.455599>, 
      <0.000000, -0.751326, 0.265116>, <0.183688, -0.751326, 0.265116>, <0.401381, -0.661155, 0.265116>, <0.531268, -0.531268, 0.265116>, 
      <0.000000, -0.800000, 0.129165>, <0.183688, -0.800000, 0.129165>, <0.435799, -0.695572, 0.129165>, <0.565686, -0.565685, 0.129165>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.494975, -0.494975, 0.600000>, <-0.381323, -0.608626, 0.600000>, <-0.160727, -0.700000, 0.600000>, <0.000000, -0.700000, 0.600000>, 
      <-0.494975, -0.494975, 0.455599>, <-0.381323, -0.608626, 0.455599>, <-0.160727, -0.700000, 0.455599>, <0.000000, -0.700000, 0.455599>, 
      <-0.531268, -0.531268, 0.265116>, <-0.401381, -0.661155, 0.265116>, <-0.183688, -0.751327, 0.265116>, <0.000000, -0.751326, 0.265116>, 
      <-0.565685, -0.565685, 0.129165>, <-0.435798, -0.695573, 0.129165>, <-0.183688, -0.800000, 0.129165>, <0.000000, -0.800000, 0.129165>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.700000, -0.000000, 0.600000>, <-0.700000, -0.160727, 0.600000>, <-0.608626, -0.381324, 0.600000>, <-0.494975, -0.494975, 0.600000>, 
      <-0.700000, -0.000000, 0.455599>, <-0.700000, -0.160727, 0.455599>, <-0.608626, -0.381324, 0.455599>, <-0.494975, -0.494975, 0.455599>, 
      <-0.751326, -0.000000, 0.265116>, <-0.751326, -0.183688, 0.265116>, <-0.661155, -0.401381, 0.265116>, <-0.531268, -0.531268, 0.265116>, 
      <-0.800000, -0.000000, 0.129165>, <-0.800000, -0.183688, 0.129165>, <-0.695573, -0.435798, 0.129165>, <-0.565685, -0.565685, 0.129165>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.494975, 0.494975, 0.600000>, <-0.608626, 0.381323, 0.600000>, <-0.700000, 0.160727, 0.600000>, <-0.700000, -0.000000, 0.600000>, 
      <-0.494975, 0.494975, 0.455599>, <-0.608626, 0.381323, 0.455599>, <-0.700000, 0.160727, 0.455599>, <-0.700000, -0.000000, 0.455599>, 
      <-0.531268, 0.531268, 0.265116>, <-0.661155, 0.401381, 0.265116>, <-0.751326, 0.183688, 0.265116>, <-0.751326, -0.000000, 0.265116>, 
      <-0.565685, 0.565685, 0.129165>, <-0.695573, 0.435798, 0.129165>, <-0.800000, 0.183688, 0.129165>, <-0.800000, -0.000000, 0.129165>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 0.700000, 0.600000>, <-0.160727, 0.700000, 0.600000>, <-0.381324, 0.608626, 0.600000>, <-0.494975, 0.494975, 0.600000>, 
      <0.000000, 0.700000, 0.455599>, <-0.160727, 0.700000, 0.455599>, <-0.381324, 0.608626, 0.455599>, <-0.494975, 0.494975, 0.455599>, 
      <0.000000, 0.751326, 0.265116>, <-0.183688, 0.751326, 0.265116>, <-0.401381, 0.661155, 0.265116>, <-0.531268, 0.531268, 0.265116>, 
      <0.000000, 0.800000, 0.129165>, <-0.183688, 0.800000, 0.129165>, <-0.435798, 0.695573, 0.129165>, <-0.565685, 0.565685, 0.129165>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.494975, 0.494975, 0.600000>, <0.381324, 0.608626, 0.600000>, <0.160727, 0.700000, 0.600000>, <0.000000, 0.700000, 0.600000>, 
      <0.494975, 0.494975, 0.455599>, <0.381324, 0.608626, 0.455599>, <0.160727, 0.700000, 0.455599>, <0.000000, 0.700000, 0.455599>, 
      <0.531268, 0.531268, 0.265116>, <0.401381, 0.661155, 0.265116>, <0.183688, 0.751326, 0.265116>, <0.000000, 0.751326, 0.265116>, 
      <0.565685, 0.565685, 0.129165>, <0.435798, 0.695573, 0.129165>, <0.183688, 0.800000, 0.129165>, <0.000000, 0.800000, 0.129165>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -0.800000, 1.100000>, <0.183688, -0.800000, 1.100000>, <0.435799, -0.695572, 1.100000>, <0.565686, -0.565685, 1.100000>, 
      <0.000000, -0.699268, 0.984878>, <0.183688, -0.699268, 0.984878>, <0.364570, -0.624344, 0.984878>, <0.494457, -0.494457, 0.984878>, 
      <0.000000, -0.700000, 0.752971>, <0.160727, -0.700000, 0.752971>, <0.381324, -0.608626, 0.752971>, <0.494975, -0.494975, 0.752971>, 
      <0.000000, -0.700000, 0.600000>, <0.160727, -0.700000, 0.600000>, <0.381324, -0.608626, 0.600000>, <0.494975, -0.494975, 0.600000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.565685, -0.565685, 1.100000>, <-0.435798, -0.695573, 1.100000>, <-0.183688, -0.800000, 1.100000>, <0.000000, -0.800000, 1.100000>, 
      <-0.494457, -0.494457, 0.984878>, <-0.364570, -0.624344, 0.984878>, <-0.183688, -0.699268, 0.984878>, <0.000000, -0.699268, 0.984878>, 
      <-0.494975, -0.494975, 0.752971>, <-0.381323, -0.608626, 0.752971>, <-0.160727, -0.700000, 0.752971>, <0.000000, -0.700000, 0.752971>, 
      <-0.494975, -0.494975, 0.600000>, <-0.381323, -0.608626, 0.600000>, <-0.160727, -0.700000, 0.600000>, <0.000000, -0.700000, 0.600000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.800000, -0.000000, 1.100000>, <-0.800000, -0.183688, 1.100000>, <-0.695573, -0.435798, 1.100000>, <-0.565685, -0.565685, 1.100000>, 
      <-0.699268, -0.000000, 0.984878>, <-0.699268, -0.183688, 0.984878>, <-0.624344, -0.364570, 0.984878>, <-0.494457, -0.494457, 0.984878>, 
      <-0.700000, -0.000000, 0.752971>, <-0.700000, -0.160727, 0.752971>, <-0.608626, -0.381324, 0.752971>, <-0.494975, -0.494975, 0.752971>, 
      <-0.700000, -0.000000, 0.600000>, <-0.700000, -0.160727, 0.600000>, <-0.608626, -0.381324, 0.600000>, <-0.494975, -0.494975, 0.600000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.565685, 0.565685, 1.100000>, <-0.695573, 0.435798, 1.100000>, <-0.800000, 0.183688, 1.100000>, <-0.800000, -0.000000, 1.100000>, 
      <-0.494457, 0.494457, 0.984878>, <-0.624344, 0.364570, 0.984878>, <-0.699268, 0.183688, 0.984878>, <-0.699268, -0.000000, 0.984878>, 
      <-0.494975, 0.494975, 0.752971>, <-0.608626, 0.381323, 0.752971>, <-0.700000, 0.160727, 0.752971>, <-0.700000, -0.000000, 0.752971>, 
      <-0.494975, 0.494975, 0.600000>, <-0.608626, 0.381323, 0.600000>, <-0.700000, 0.160727, 0.600000>, <-0.700000, -0.000000, 0.600000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 0.800000, 1.100000>, <-0.183688, 0.800000, 1.100000>, <-0.435798, 0.695573, 1.100000>, <-0.565685, 0.565685, 1.100000>, 
      <0.000000, 0.699268, 0.984878>, <-0.183688, 0.699268, 0.984878>, <-0.364570, 0.624344, 0.984878>, <-0.494457, 0.494457, 0.984878>, 
      <0.000000, 0.700000, 0.752971>, <-0.160727, 0.700000, 0.752971>, <-0.381324, 0.608626, 0.752971>, <-0.494975, 0.494975, 0.752971>, 
      <0.000000, 0.700000, 0.600000>, <-0.160727, 0.700000, 0.600000>, <-0.381324, 0.608626, 0.600000>, <-0.494975, 0.494975, 0.600000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.565685, 0.565685, 1.100000>, <0.435798, 0.695573, 1.100000>, <0.183688, 0.800000, 1.100000>, <0.000000, 0.800000, 1.100000>, 
      <0.494457, 0.494457, 0.984878>, <0.364570, 0.624344, 0.984878>, <0.183688, 0.699268, 0.984878>, <0.000000, 0.699268, 0.984878>, 
      <0.494975, 0.494975, 0.752971>, <0.381324, 0.608626, 0.752971>, <0.160727, 0.700000, 0.752971>, <0.000000, 0.700000, 0.752971>, 
      <0.494975, 0.494975, 0.600000>, <0.381324, 0.608626, 0.600000>, <0.160727, 0.700000, 0.600000>, <0.000000, 0.700000, 0.600000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -1.400000, 1.400000>, <0.321454, -1.400000, 1.400000>, <0.762647, -1.217252, 1.400000>, <0.989950, -0.989949, 1.400000>, 
      <0.000000, -1.225269, 1.300154>, <0.321454, -1.225269, 1.300154>, <0.639094, -1.093698, 1.300154>, <0.866397, -0.866396, 1.300154>, 
      <0.000000, -0.932522, 1.251453>, <0.183688, -0.932522, 1.251453>, <0.529505, -0.789279, 1.251453>, <0.659393, -0.659392, 1.251453>, 
      <0.000000, -0.800000, 1.100000>, <0.183688, -0.800000, 1.100000>, <0.435799, -0.695572, 1.100000>, <0.565686, -0.565685, 1.100000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.989949, -0.989950, 1.400000>, <-0.762647, -1.217252, 1.400000>, <-0.321454, -1.400000, 1.400000>, <0.000000, -1.400000, 1.400000>, 
      <-0.866396, -0.866397, 1.300154>, <-0.639094, -1.093699, 1.300154>, <-0.321454, -1.225270, 1.300154>, <0.000000, -1.225269, 1.300154>, 
      <-0.659392, -0.659392, 1.251453>, <-0.529505, -0.789279, 1.251453>, <-0.183688, -0.932522, 1.251453>, <0.000000, -0.932522, 1.251453>, 
      <-0.565685, -0.565685, 1.100000>, <-0.435798, -0.695573, 1.100000>, <-0.183688, -0.800000, 1.100000>, <0.000000, -0.800000, 1.100000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.400000, -0.000000, 1.400000>, <-1.400000, -0.321454, 1.400000>, <-1.217252, -0.762647, 1.400000>, <-0.989949, -0.989950, 1.400000>, 
      <-1.225269, -0.000000, 1.300154>, <-1.225269, -0.321454, 1.300154>, <-1.093698, -0.639094, 1.300154>, <-0.866396, -0.866397, 1.300154>, 
      <-0.932522, -0.000000, 1.251453>, <-0.932522, -0.183688, 1.251453>, <-0.789279, -0.529505, 1.251453>, <-0.659392, -0.659392, 1.251453>, 
      <-0.800000, -0.000000, 1.100000>, <-0.800000, -0.183688, 1.100000>, <-0.695573, -0.435798, 1.100000>, <-0.565685, -0.565685, 1.100000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.989950, 0.989950, 1.400000>, <-1.217252, 0.762647, 1.400000>, <-1.400000, 0.321454, 1.400000>, <-1.400000, -0.000000, 1.400000>, 
      <-0.866396, 0.866396, 1.300154>, <-1.093699, 0.639094, 1.300154>, <-1.225269, 0.321454, 1.300154>, <-1.225269, -0.000000, 1.300154>, 
      <-0.659392, 0.659392, 1.251453>, <-0.789279, 0.529505, 1.251453>, <-0.932522, 0.183688, 1.251453>, <-0.932522, -0.000000, 1.251453>, 
      <-0.565685, 0.565685, 1.100000>, <-0.695573, 0.435798, 1.100000>, <-0.800000, 0.183688, 1.100000>, <-0.800000, -0.000000, 1.100000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.000000, 1.400000, 1.400000>, <-0.321454, 1.400000, 1.400000>, <-0.762647, 1.217252, 1.400000>, <-0.989950, 0.989950, 1.400000>, 
      <-0.000000, 1.225269, 1.300154>, <-0.321454, 1.225269, 1.300154>, <-0.639094, 1.093699, 1.300154>, <-0.866396, 0.866396, 1.300154>, 
      <0.000000, 0.932522, 1.251453>, <-0.183688, 0.932522, 1.251453>, <-0.529505, 0.789279, 1.251453>, <-0.659392, 0.659392, 1.251453>, 
      <0.000000, 0.800000, 1.100000>, <-0.183688, 0.800000, 1.100000>, <-0.435798, 0.695573, 1.100000>, <-0.565685, 0.565685, 1.100000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.989950, 0.989950, 1.400000>, <0.762647, 1.217252, 1.400000>, <0.321454, 1.400000, 1.400000>, <-0.000000, 1.400000, 1.400000>, 
      <0.866396, 0.866396, 1.300154>, <0.639094, 1.093699, 1.300154>, <0.321454, 1.225269, 1.300154>, <-0.000000, 1.225269, 1.300154>, 
      <0.659392, 0.659392, 1.251453>, <0.529505, 0.789279, 1.251453>, <0.183688, 0.932522, 1.251453>, <0.000000, 0.932522, 1.251453>, 
      <0.565685, 0.565685, 1.100000>, <0.435798, 0.695573, 1.100000>, <0.183688, 0.800000, 1.100000>, <0.000000, 0.800000, 1.100000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -1.500000, 1.500000>, <0.344415, -1.500000, 1.500000>, <0.817122, -1.304198, 1.500000>, <1.060661, -1.060660, 1.500000>, 
      <0.000000, -1.491584, 1.458417>, <0.344415, -1.491584, 1.458417>, <0.811171, -1.298247, 1.458417>, <1.054710, -1.054709, 1.458417>, 
      <0.000000, -1.436837, 1.421049>, <0.321454, -1.436836, 1.421049>, <0.788695, -1.243299, 1.421049>, <1.015997, -1.015997, 1.421049>, 
      <0.000000, -1.400000, 1.400000>, <0.321454, -1.400000, 1.400000>, <0.762647, -1.217252, 1.400000>, <0.989950, -0.989949, 1.400000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.060660, -1.060660, 1.500000>, <-0.817122, -1.304199, 1.500000>, <-0.344415, -1.500000, 1.500000>, <0.000000, -1.500000, 1.500000>, 
      <-1.054709, -1.054709, 1.458417>, <-0.811171, -1.298248, 1.458417>, <-0.344415, -1.491584, 1.458417>, <0.000000, -1.491584, 1.458417>, 
      <-1.015997, -1.015997, 1.421049>, <-0.788694, -1.243299, 1.421049>, <-0.321454, -1.436837, 1.421049>, <0.000000, -1.436837, 1.421049>, 
      <-0.989949, -0.989950, 1.400000>, <-0.762647, -1.217252, 1.400000>, <-0.321454, -1.400000, 1.400000>, <0.000000, -1.400000, 1.400000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.500000, -0.000000, 1.500000>, <-1.500000, -0.344415, 1.500000>, <-1.304198, -0.817122, 1.500000>, <-1.060660, -1.060660, 1.500000>, 
      <-1.491584, -0.000000, 1.458417>, <-1.491584, -0.344415, 1.458417>, <-1.298247, -0.811171, 1.458417>, <-1.054709, -1.054709, 1.458417>, 
      <-1.436837, -0.000000, 1.421049>, <-1.436837, -0.321454, 1.421049>, <-1.243299, -0.788695, 1.421049>, <-1.015997, -1.015997, 1.421049>, 
      <-1.400000, -0.000000, 1.400000>, <-1.400000, -0.321454, 1.400000>, <-1.217252, -0.762647, 1.400000>, <-0.989949, -0.989950, 1.400000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.060660, 1.060660, 1.500000>, <-1.304198, 0.817122, 1.500000>, <-1.500000, 0.344415, 1.500000>, <-1.500000, -0.000000, 1.500000>, 
      <-1.054709, 1.054709, 1.458417>, <-1.298248, 0.811171, 1.458417>, <-1.491584, 0.344415, 1.458417>, <-1.491584, -0.000000, 1.458417>, 
      <-1.015997, 1.015997, 1.421049>, <-1.243299, 0.788694, 1.421049>, <-1.436837, 0.321454, 1.421049>, <-1.436837, -0.000000, 1.421049>, 
      <-0.989950, 0.989950, 1.400000>, <-1.217252, 0.762647, 1.400000>, <-1.400000, 0.321454, 1.400000>, <-1.400000, -0.000000, 1.400000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.000000, 1.500000, 1.500000>, <-0.344415, 1.500000, 1.500000>, <-0.817122, 1.304198, 1.500000>, <-1.060660, 1.060660, 1.500000>, 
      <-0.000000, 1.491584, 1.458417>, <-0.344415, 1.491584, 1.458417>, <-0.811171, 1.298248, 1.458417>, <-1.054709, 1.054709, 1.458417>, 
      <-0.000000, 1.436837, 1.421049>, <-0.321454, 1.436837, 1.421049>, <-0.788694, 1.243299, 1.421049>, <-1.015997, 1.015997, 1.421049>, 
      <-0.000000, 1.400000, 1.400000>, <-0.321454, 1.400000, 1.400000>, <-0.762647, 1.217252, 1.400000>, <-0.989950, 0.989950, 1.400000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.060660, 1.060660, 1.500000>, <0.817122, 1.304199, 1.500000>, <0.344415, 1.500000, 1.500000>, <-0.000000, 1.500000, 1.500000>, 
      <1.054709, 1.054709, 1.458417>, <0.811171, 1.298248, 1.458417>, <0.344415, 1.491584, 1.458417>, <-0.000000, 1.491584, 1.458417>, 
      <1.015997, 1.015997, 1.421049>, <0.788694, 1.243299, 1.421049>, <0.321454, 1.436837, 1.421049>, <-0.000000, 1.436837, 1.421049>, 
      <0.989950, 0.989950, 1.400000>, <0.762647, 1.217252, 1.400000>, <0.321454, 1.400000, 1.400000>, <-0.000000, 1.400000, 1.400000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -1.440477, 1.600000>, <0.330748, -1.440477, 1.600000>, <0.784697, -1.252445, 1.600000>, <1.018572, -1.018571, 1.600000>, 
      <0.000000, -1.475320, 1.597790>, <0.330748, -1.475319, 1.597790>, <0.809334, -1.277082, 1.597790>, <1.043209, -1.043208, 1.597790>, 
      <0.000000, -1.506925, 1.534218>, <0.344415, -1.506925, 1.534218>, <0.822019, -1.309095, 1.534218>, <1.065557, -1.065557, 1.534218>, 
      <0.000000, -1.500000, 1.500000>, <0.344415, -1.500000, 1.500000>, <0.817122, -1.304198, 1.500000>, <1.060661, -1.060660, 1.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.018571, -1.018572, 1.600000>, <-0.784697, -1.252446, 1.600000>, <-0.330748, -1.440478, 1.600000>, <0.000000, -1.440477, 1.600000>, 
      <-1.043208, -1.043209, 1.597790>, <-0.809334, -1.277083, 1.597790>, <-0.330748, -1.475320, 1.597790>, <0.000000, -1.475320, 1.597790>, 
      <-1.065557, -1.065557, 1.534218>, <-0.822019, -1.309096, 1.534218>, <-0.344415, -1.506925, 1.534218>, <0.000000, -1.506925, 1.534218>, 
      <-1.060660, -1.060660, 1.500000>, <-0.817122, -1.304199, 1.500000>, <-0.344415, -1.500000, 1.500000>, <0.000000, -1.500000, 1.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.440477, -0.000000, 1.600000>, <-1.440477, -0.330748, 1.600000>, <-1.252446, -0.784697, 1.600000>, <-1.018571, -1.018572, 1.600000>, 
      <-1.475320, -0.000000, 1.597790>, <-1.475320, -0.330748, 1.597790>, <-1.277083, -0.809334, 1.597790>, <-1.043208, -1.043209, 1.597790>, 
      <-1.506925, -0.000000, 1.534218>, <-1.506925, -0.344415, 1.534218>, <-1.309095, -0.822019, 1.534218>, <-1.065557, -1.065557, 1.534218>, 
      <-1.500000, -0.000000, 1.500000>, <-1.500000, -0.344415, 1.500000>, <-1.304198, -0.817122, 1.500000>, <-1.060660, -1.060660, 1.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.018571, 1.018571, 1.600000>, <-1.252446, 0.784697, 1.600000>, <-1.440477, 0.330748, 1.600000>, <-1.440477, -0.000000, 1.600000>, 
      <-1.043209, 1.043209, 1.597790>, <-1.277083, 0.809334, 1.597790>, <-1.475320, 0.330748, 1.597790>, <-1.475320, -0.000000, 1.597790>, 
      <-1.065557, 1.065557, 1.534218>, <-1.309095, 0.822019, 1.534218>, <-1.506925, 0.344415, 1.534218>, <-1.506925, -0.000000, 1.534218>, 
      <-1.060660, 1.060660, 1.500000>, <-1.304198, 0.817122, 1.500000>, <-1.500000, 0.344415, 1.500000>, <-1.500000, -0.000000, 1.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.000000, 1.440477, 1.600000>, <-0.330748, 1.440477, 1.600000>, <-0.784697, 1.252446, 1.600000>, <-1.018571, 1.018571, 1.600000>, 
      <-0.000000, 1.475320, 1.597790>, <-0.330748, 1.475320, 1.597790>, <-0.809334, 1.277083, 1.597790>, <-1.043209, 1.043209, 1.597790>, 
      <-0.000000, 1.506925, 1.534218>, <-0.344415, 1.506925, 1.534218>, <-0.822019, 1.309095, 1.534218>, <-1.065557, 1.065557, 1.534218>, 
      <-0.000000, 1.500000, 1.500000>, <-0.344415, 1.500000, 1.500000>, <-0.817122, 1.304198, 1.500000>, <-1.060660, 1.060660, 1.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.018571, 1.018571, 1.600000>, <0.784697, 1.252446, 1.600000>, <0.330748, 1.440477, 1.600000>, <-0.000000, 1.440477, 1.600000>, 
      <1.043209, 1.043209, 1.597790>, <0.809334, 1.277083, 1.597790>, <0.330748, 1.475320, 1.597790>, <-0.000000, 1.475320, 1.597790>, 
      <1.065557, 1.065557, 1.534218>, <0.822019, 1.309096, 1.534218>, <0.344415, 1.506925, 1.534218>, <-0.000000, 1.506925, 1.534218>, 
      <1.060660, 1.060660, 1.500000>, <0.817122, 1.304199, 1.500000>, <0.344415, 1.500000, 1.500000>, <-0.000000, 1.500000, 1.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -1.340477, 1.510119>, <0.307787, -1.340477, 1.510119>, <0.730223, -1.165499, 1.510119>, <0.947861, -0.947860, 1.510119>, 
      <0.000000, -1.380573, 1.514523>, <0.307787, -1.380573, 1.514523>, <0.758575, -1.193851, 1.514523>, <0.976213, -0.976212, 1.514523>, 
      <0.000000, -1.400221, 1.602554>, <0.330748, -1.400221, 1.602554>, <0.756232, -1.223980, 1.602554>, <0.990106, -0.990106, 1.602554>, 
      <0.000000, -1.440477, 1.600000>, <0.330748, -1.440477, 1.600000>, <0.784697, -1.252445, 1.600000>, <1.018572, -1.018571, 1.600000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.947860, -0.947861, 1.510119>, <-0.730222, -1.165499, 1.510119>, <-0.307787, -1.340478, 1.510119>, <0.000000, -1.340477, 1.510119>, 
      <-0.976213, -0.976213, 1.514523>, <-0.758574, -1.193851, 1.514523>, <-0.307787, -1.380573, 1.514523>, <0.000000, -1.380573, 1.514523>, 
      <-0.990106, -0.990106, 1.602554>, <-0.756232, -1.223980, 1.602554>, <-0.330748, -1.400222, 1.602554>, <0.000000, -1.400221, 1.602554>, 
      <-1.018571, -1.018572, 1.600000>, <-0.784697, -1.252446, 1.600000>, <-0.330748, -1.440478, 1.600000>, <0.000000, -1.440477, 1.600000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.340477, -0.000000, 1.510119>, <-1.340477, -0.307787, 1.510119>, <-1.165499, -0.730223, 1.510119>, <-0.947860, -0.947861, 1.510119>, 
      <-1.380573, -0.000000, 1.514523>, <-1.380573, -0.307787, 1.514523>, <-1.193851, -0.758575, 1.514523>, <-0.976213, -0.976213, 1.514523>, 
      <-1.400221, -0.000000, 1.602554>, <-1.400221, -0.330748, 1.602554>, <-1.223980, -0.756232, 1.602554>, <-0.990106, -0.990106, 1.602554>, 
      <-1.440477, -0.000000, 1.600000>, <-1.440477, -0.330748, 1.600000>, <-1.252446, -0.784697, 1.600000>, <-1.018571, -1.018572, 1.600000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.947861, 0.947861, 1.510119>, <-1.165499, 0.730222, 1.510119>, <-1.340477, 0.307787, 1.510119>, <-1.340477, -0.000000, 1.510119>, 
      <-0.976213, 0.976213, 1.514523>, <-1.193851, 0.758574, 1.514523>, <-1.380573, 0.307787, 1.514523>, <-1.380573, -0.000000, 1.514523>, 
      <-0.990106, 0.990106, 1.602554>, <-1.223980, 0.756232, 1.602554>, <-1.400221, 0.330748, 1.602554>, <-1.400221, -0.000000, 1.602554>, 
      <-1.018571, 1.018571, 1.600000>, <-1.252446, 0.784697, 1.600000>, <-1.440477, 0.330748, 1.600000>, <-1.440477, -0.000000, 1.600000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.000000, 1.340477, 1.510119>, <-0.307787, 1.340477, 1.510119>, <-0.730222, 1.165499, 1.510119>, <-0.947861, 0.947861, 1.510119>, 
      <-0.000000, 1.380573, 1.514523>, <-0.307787, 1.380573, 1.514523>, <-0.758574, 1.193851, 1.514523>, <-0.976213, 0.976213, 1.514523>, 
      <-0.000000, 1.400221, 1.602554>, <-0.330748, 1.400221, 1.602554>, <-0.756232, 1.223980, 1.602554>, <-0.990106, 0.990106, 1.602554>, 
      <-0.000000, 1.440477, 1.600000>, <-0.330748, 1.440477, 1.600000>, <-0.784697, 1.252446, 1.600000>, <-1.018571, 1.018571, 1.600000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.947861, 0.947861, 1.510119>, <0.730222, 1.165499, 1.510119>, <0.307787, 1.340477, 1.510119>, <-0.000000, 1.340477, 1.510119>, 
      <0.976213, 0.976213, 1.514523>, <0.758574, 1.193851, 1.514523>, <0.307787, 1.380573, 1.514523>, <-0.000000, 1.380573, 1.514523>, 
      <0.990106, 0.990106, 1.602554>, <0.756232, 1.223980, 1.602554>, <0.330748, 1.400221, 1.602554>, <-0.000000, 1.400221, 1.602554>, 
      <1.018571, 1.018571, 1.600000>, <0.784697, 1.252446, 1.600000>, <0.330748, 1.440477, 1.600000>, <-0.000000, 1.440477, 1.600000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -1.153604, 1.568497>, <0.264879, -1.153604, 1.568497>, <0.628424, -1.003019, 1.568497>, <0.815721, -0.815721, 1.568497>, 
      <0.000000, -1.210884, 1.555509>, <0.264879, -1.210884, 1.555509>, <0.668927, -1.043522, 1.555509>, <0.856225, -0.856224, 1.555509>, 
      <0.000000, -1.282094, 1.503708>, <0.307787, -1.282094, 1.503708>, <0.688940, -1.124216, 1.503708>, <0.906578, -0.906577, 1.503708>, 
      <0.000000, -1.340477, 1.510119>, <0.307787, -1.340477, 1.510119>, <0.730223, -1.165499, 1.510119>, <0.947861, -0.947860, 1.510119>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.815721, -0.815721, 1.568497>, <-0.628423, -1.003019, 1.568497>, <-0.264879, -1.153604, 1.568497>, <0.000000, -1.153604, 1.568497>, 
      <-0.856224, -0.856224, 1.555509>, <-0.668926, -1.043522, 1.555509>, <-0.264879, -1.210884, 1.555509>, <0.000000, -1.210884, 1.555509>, 
      <-0.906578, -0.906578, 1.503708>, <-0.688939, -1.124216, 1.503708>, <-0.307787, -1.282095, 1.503708>, <0.000000, -1.282094, 1.503708>, 
      <-0.947860, -0.947861, 1.510119>, <-0.730222, -1.165499, 1.510119>, <-0.307787, -1.340478, 1.510119>, <0.000000, -1.340477, 1.510119>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.153604, -0.000000, 1.568497>, <-1.153604, -0.264879, 1.568497>, <-1.003019, -0.628424, 1.568497>, <-0.815721, -0.815721, 1.568497>, 
      <-1.210884, -0.000000, 1.555509>, <-1.210884, -0.264879, 1.555509>, <-1.043522, -0.668927, 1.555509>, <-0.856224, -0.856224, 1.555509>, 
      <-1.282094, -0.000000, 1.503708>, <-1.282094, -0.307787, 1.503708>, <-1.124216, -0.688940, 1.503708>, <-0.906578, -0.906578, 1.503708>, 
      <-1.340477, -0.000000, 1.510119>, <-1.340477, -0.307787, 1.510119>, <-1.165499, -0.730223, 1.510119>, <-0.947860, -0.947861, 1.510119>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.815721, 0.815721, 1.568497>, <-1.003019, 0.628423, 1.568497>, <-1.153604, 0.264879, 1.568497>, <-1.153604, -0.000000, 1.568497>, 
      <-0.856224, 0.856224, 1.555509>, <-1.043522, 0.668926, 1.555509>, <-1.210884, 0.264879, 1.555509>, <-1.210884, -0.000000, 1.555509>, 
      <-0.906578, 0.906578, 1.503708>, <-1.124216, 0.688939, 1.503708>, <-1.282094, 0.307787, 1.503708>, <-1.282094, -0.000000, 1.503708>, 
      <-0.947861, 0.947861, 1.510119>, <-1.165499, 0.730222, 1.510119>, <-1.340477, 0.307787, 1.510119>, <-1.340477, -0.000000, 1.510119>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.000000, 1.153604, 1.568497>, <-0.264879, 1.153604, 1.568497>, <-0.628423, 1.003019, 1.568497>, <-0.815721, 0.815721, 1.568497>, 
      <-0.000000, 1.210884, 1.555509>, <-0.264879, 1.210884, 1.555509>, <-0.668926, 1.043522, 1.555509>, <-0.856224, 0.856224, 1.555509>, 
      <-0.000000, 1.282094, 1.503708>, <-0.307787, 1.282094, 1.503708>, <-0.688939, 1.124216, 1.503708>, <-0.906578, 0.906578, 1.503708>, 
      <-0.000000, 1.340477, 1.510119>, <-0.307787, 1.340477, 1.510119>, <-0.730222, 1.165499, 1.510119>, <-0.947861, 0.947861, 1.510119>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.815721, 0.815721, 1.568497>, <0.628423, 1.003019, 1.568497>, <0.264879, 1.153604, 1.568497>, <-0.000000, 1.153604, 1.568497>, 
      <0.856224, 0.856224, 1.555509>, <0.668926, 1.043522, 1.555509>, <0.264879, 1.210884, 1.555509>, <-0.000000, 1.210884, 1.555509>, 
      <0.906578, 0.906578, 1.503708>, <0.688939, 1.124216, 1.503708>, <0.307787, 1.282094, 1.503708>, <-0.000000, 1.282094, 1.503708>, 
      <0.947861, 0.947861, 1.510119>, <0.730222, 1.165499, 1.510119>, <0.307787, 1.340477, 1.510119>, <-0.000000, 1.340477, 1.510119>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -0.988687, 1.589881>, <0.227013, -0.988687, 1.589881>, <0.538586, -0.859630, 1.589881>, <0.699108, -0.699107, 1.589881>, 
      <0.000000, -1.034252, 1.610199>, <0.227013, -1.034252, 1.610199>, <0.570804, -0.891848, 1.610199>, <0.731326, -0.731326, 1.610199>, 
      <0.000000, -1.104950, 1.579528>, <0.264879, -1.104950, 1.579528>, <0.594020, -0.968615, 1.579528>, <0.781318, -0.781317, 1.579528>, 
      <0.000000, -1.153604, 1.568497>, <0.264879, -1.153604, 1.568497>, <0.628424, -1.003019, 1.568497>, <0.815721, -0.815721, 1.568497>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.699107, -0.699108, 1.589881>, <-0.538585, -0.859630, 1.589881>, <-0.227013, -0.988687, 1.589881>, <0.000000, -0.988687, 1.589881>, 
      <-0.731326, -0.731326, 1.610199>, <-0.570804, -0.891848, 1.610199>, <-0.227013, -1.034252, 1.610199>, <0.000000, -1.034252, 1.610199>, 
      <-0.781317, -0.781318, 1.579528>, <-0.594020, -0.968615, 1.579528>, <-0.264879, -1.104950, 1.579528>, <0.000000, -1.104950, 1.579528>, 
      <-0.815721, -0.815721, 1.568497>, <-0.628423, -1.003019, 1.568497>, <-0.264879, -1.153604, 1.568497>, <0.000000, -1.153604, 1.568497>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.988687, -0.000000, 1.589881>, <-0.988687, -0.227013, 1.589881>, <-0.859630, -0.538586, 1.589881>, <-0.699107, -0.699108, 1.589881>, 
      <-1.034252, -0.000000, 1.610199>, <-1.034252, -0.227013, 1.610199>, <-0.891848, -0.570804, 1.610199>, <-0.731326, -0.731326, 1.610199>, 
      <-1.104950, -0.000000, 1.579528>, <-1.104950, -0.264879, 1.579528>, <-0.968615, -0.594020, 1.579528>, <-0.781317, -0.781318, 1.579528>, 
      <-1.153604, -0.000000, 1.568497>, <-1.153604, -0.264879, 1.568497>, <-1.003019, -0.628424, 1.568497>, <-0.815721, -0.815721, 1.568497>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.699108, 0.699108, 1.589881>, <-0.859630, 0.538585, 1.589881>, <-0.988687, 0.227013, 1.589881>, <-0.988687, -0.000000, 1.589881>, 
      <-0.731326, 0.731326, 1.610199>, <-0.891848, 0.570804, 1.610199>, <-1.034252, 0.227013, 1.610199>, <-1.034252, -0.000000, 1.610199>, 
      <-0.781317, 0.781317, 1.579528>, <-0.968615, 0.594020, 1.579528>, <-1.104950, 0.264879, 1.579528>, <-1.104950, -0.000000, 1.579528>, 
      <-0.815721, 0.815721, 1.568497>, <-1.003019, 0.628423, 1.568497>, <-1.153604, 0.264879, 1.568497>, <-1.153604, -0.000000, 1.568497>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 0.988687, 1.589881>, <-0.227013, 0.988687, 1.589881>, <-0.538585, 0.859630, 1.589881>, <-0.699108, 0.699108, 1.589881>, 
      <0.000000, 1.034252, 1.610199>, <-0.227013, 1.034252, 1.610199>, <-0.570804, 0.891848, 1.610199>, <-0.731326, 0.731326, 1.610199>, 
      <0.000000, 1.104950, 1.579528>, <-0.264879, 1.104950, 1.579528>, <-0.594020, 0.968615, 1.579528>, <-0.781317, 0.781317, 1.579528>, 
      <-0.000000, 1.153604, 1.568497>, <-0.264879, 1.153604, 1.568497>, <-0.628423, 1.003019, 1.568497>, <-0.815721, 0.815721, 1.568497>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.699108, 0.699108, 1.589881>, <0.538585, 0.859630, 1.589881>, <0.227013, 0.988687, 1.589881>, <0.000000, 0.988687, 1.589881>, 
      <0.731326, 0.731326, 1.610199>, <0.570804, 0.891848, 1.610199>, <0.227013, 1.034252, 1.610199>, <0.000000, 1.034252, 1.610199>, 
      <0.781317, 0.781317, 1.579528>, <0.594020, 0.968615, 1.579528>, <0.264879, 1.104950, 1.579528>, <0.000000, 1.104950, 1.579528>, 
      <0.815721, 0.815721, 1.568497>, <0.628423, 1.003019, 1.568497>, <0.264879, 1.153604, 1.568497>, <-0.000000, 1.153604, 1.568497>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -1.000000, 1.500000>, <0.229610, -1.000000, 1.500000>, <0.544748, -0.869465, 1.500000>, <0.707107, -0.707107, 1.500000>, 
      <0.000000, -1.026681, 1.494830>, <0.229610, -1.026681, 1.494830>, <0.563614, -0.888332, 1.494830>, <0.725973, -0.725973, 1.494830>, 
      <0.000000, -0.963866, 1.578812>, <0.227013, -0.963866, 1.578812>, <0.521035, -0.842078, 1.578812>, <0.681557, -0.681556, 1.578812>, 
      <0.000000, -0.988687, 1.589881>, <0.227013, -0.988687, 1.589881>, <0.538586, -0.859630, 1.589881>, <0.699108, -0.699107, 1.589881>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.707107, -0.707107, 1.500000>, <-0.544748, -0.869466, 1.500000>, <-0.229610, -1.000000, 1.500000>, <0.000000, -1.000000, 1.500000>, 
      <-0.725973, -0.725973, 1.494830>, <-0.563614, -0.888332, 1.494830>, <-0.229610, -1.026681, 1.494830>, <0.000000, -1.026681, 1.494830>, 
      <-0.681556, -0.681557, 1.578812>, <-0.521034, -0.842079, 1.578812>, <-0.227013, -0.963866, 1.578812>, <0.000000, -0.963866, 1.578812>, 
      <-0.699107, -0.699108, 1.589881>, <-0.538585, -0.859630, 1.589881>, <-0.227013, -0.988687, 1.589881>, <0.000000, -0.988687, 1.589881>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.000000, -0.000000, 1.500000>, <-1.000000, -0.229610, 1.500000>, <-0.869466, -0.544748, 1.500000>, <-0.707107, -0.707107, 1.500000>, 
      <-1.026681, -0.000000, 1.494830>, <-1.026681, -0.229610, 1.494830>, <-0.888332, -0.563614, 1.494830>, <-0.725973, -0.725973, 1.494830>, 
      <-0.963866, -0.000000, 1.578812>, <-0.963866, -0.227013, 1.578812>, <-0.842079, -0.521034, 1.578812>, <-0.681556, -0.681557, 1.578812>, 
      <-0.988687, -0.000000, 1.589881>, <-0.988687, -0.227013, 1.589881>, <-0.859630, -0.538586, 1.589881>, <-0.699107, -0.699108, 1.589881>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.707107, 0.707107, 1.500000>, <-0.869466, 0.544748, 1.500000>, <-1.000000, 0.229610, 1.500000>, <-1.000000, -0.000000, 1.500000>, 
      <-0.725973, 0.725973, 1.494830>, <-0.888332, 0.563614, 1.494830>, <-1.026681, 0.229610, 1.494830>, <-1.026681, -0.000000, 1.494830>, 
      <-0.681557, 0.681557, 1.578812>, <-0.842079, 0.521034, 1.578812>, <-0.963866, 0.227013, 1.578812>, <-0.963866, -0.000000, 1.578812>, 
      <-0.699108, 0.699108, 1.589881>, <-0.859630, 0.538585, 1.589881>, <-0.988687, 0.227013, 1.589881>, <-0.988687, -0.000000, 1.589881>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 1.000000, 1.500000>, <-0.229610, 1.000000, 1.500000>, <-0.544748, 0.869466, 1.500000>, <-0.707107, 0.707107, 1.500000>, 
      <0.000000, 1.026681, 1.494830>, <-0.229610, 1.026681, 1.494830>, <-0.563614, 0.888332, 1.494830>, <-0.725973, 0.725973, 1.494830>, 
      <0.000000, 0.963866, 1.578812>, <-0.227013, 0.963866, 1.578812>, <-0.521034, 0.842079, 1.578812>, <-0.681557, 0.681557, 1.578812>, 
      <0.000000, 0.988687, 1.589881>, <-0.227013, 0.988687, 1.589881>, <-0.538585, 0.859630, 1.589881>, <-0.699108, 0.699108, 1.589881>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.707107, 0.707107, 1.500000>, <0.544748, 0.869466, 1.500000>, <0.229610, 1.000000, 1.500000>, <0.000000, 1.000000, 1.500000>, 
      <0.725973, 0.725973, 1.494830>, <0.563614, 0.888332, 1.494830>, <0.229610, 1.026681, 1.494830>, <0.000000, 1.026681, 1.494830>, 
      <0.681557, 0.681557, 1.578812>, <0.521034, 0.842079, 1.578812>, <0.227013, 0.963866, 1.578812>, <0.000000, 0.963866, 1.578812>, 
      <0.699108, 0.699108, 1.589881>, <0.538585, 0.859630, 1.589881>, <0.227013, 0.988687, 1.589881>, <0.000000, 0.988687, 1.589881>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -0.576802, 1.669690>, <0.132440, -0.576802, 1.669690>, <0.314212, -0.501509, 1.669690>, <0.407861, -0.407860, 1.669690>, 
      <0.000000, -0.705637, 1.623736>, <0.132440, -0.705637, 1.623736>, <0.405312, -0.592610, 1.623736>, <0.498961, -0.498960, 1.623736>, 
      <0.000000, -0.865712, 1.526020>, <0.229610, -0.865712, 1.526020>, <0.449792, -0.774510, 1.526020>, <0.612151, -0.612151, 1.526020>, 
      <0.000000, -1.000000, 1.500000>, <0.229610, -1.000000, 1.500000>, <0.544748, -0.869465, 1.500000>, <0.707107, -0.707107, 1.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.407861, -0.407861, 1.669690>, <-0.314212, -0.501510, 1.669690>, <-0.132439, -0.576802, 1.669690>, <0.000000, -0.576802, 1.669690>, 
      <-0.498961, -0.498961, 1.623736>, <-0.405312, -0.592610, 1.623736>, <-0.132439, -0.705637, 1.623736>, <0.000000, -0.705637, 1.623736>, 
      <-0.612151, -0.612151, 1.526020>, <-0.449792, -0.774510, 1.526020>, <-0.229610, -0.865712, 1.526020>, <0.000000, -0.865712, 1.526020>, 
      <-0.707107, -0.707107, 1.500000>, <-0.544748, -0.869466, 1.500000>, <-0.229610, -1.000000, 1.500000>, <0.000000, -1.000000, 1.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.576802, -0.000000, 1.669690>, <-0.576802, -0.132440, 1.669690>, <-0.501510, -0.314212, 1.669690>, <-0.407861, -0.407861, 1.669690>, 
      <-0.705637, -0.000000, 1.623736>, <-0.705637, -0.132440, 1.623736>, <-0.592610, -0.405312, 1.623736>, <-0.498961, -0.498961, 1.623736>, 
      <-0.865712, -0.000000, 1.526020>, <-0.865712, -0.229610, 1.526020>, <-0.774510, -0.449792, 1.526020>, <-0.612151, -0.612151, 1.526020>, 
      <-1.000000, -0.000000, 1.500000>, <-1.000000, -0.229610, 1.500000>, <-0.869466, -0.544748, 1.500000>, <-0.707107, -0.707107, 1.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.407861, 0.407861, 1.669690>, <-0.501510, 0.314212, 1.669690>, <-0.576802, 0.132439, 1.669690>, <-0.576802, -0.000000, 1.669690>, 
      <-0.498961, 0.498961, 1.623736>, <-0.592610, 0.405312, 1.623736>, <-0.705637, 0.132439, 1.623736>, <-0.705637, -0.000000, 1.623736>, 
      <-0.612151, 0.612151, 1.526020>, <-0.774510, 0.449792, 1.526020>, <-0.865712, 0.229610, 1.526020>, <-0.865712, -0.000000, 1.526020>, 
      <-0.707107, 0.707107, 1.500000>, <-0.869466, 0.544748, 1.500000>, <-1.000000, 0.229610, 1.500000>, <-1.000000, -0.000000, 1.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 0.576802, 1.669690>, <-0.132440, 0.576802, 1.669690>, <-0.314212, 0.501510, 1.669690>, <-0.407861, 0.407861, 1.669690>, 
      <0.000000, 0.705637, 1.623736>, <-0.132440, 0.705637, 1.623736>, <-0.405312, 0.592610, 1.623736>, <-0.498961, 0.498961, 1.623736>, 
      <0.000000, 0.865712, 1.526020>, <-0.229610, 0.865712, 1.526020>, <-0.449792, 0.774510, 1.526020>, <-0.612151, 0.612151, 1.526020>, 
      <0.000000, 1.000000, 1.500000>, <-0.229610, 1.000000, 1.500000>, <-0.544748, 0.869466, 1.500000>, <-0.707107, 0.707107, 1.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.407861, 0.407861, 1.669690>, <0.314212, 0.501510, 1.669690>, <0.132439, 0.576802, 1.669690>, <0.000000, 0.576802, 1.669690>, 
      <0.498961, 0.498961, 1.623736>, <0.405312, 0.592610, 1.623736>, <0.132439, 0.705637, 1.623736>, <0.000000, 0.705637, 1.623736>, 
      <0.612151, 0.612151, 1.526020>, <0.449792, 0.774510, 1.526020>, <0.229610, 0.865712, 1.526020>, <0.000000, 0.865712, 1.526020>, 
      <0.707107, 0.707107, 1.500000>, <0.544748, 0.869466, 1.500000>, <0.229610, 1.000000, 1.500000>, <0.000000, 1.000000, 1.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -0.439284, 1.700000>, <0.100864, -0.439284, 1.700000>, <0.239299, -0.381942, 1.700000>, <0.310621, -0.310621, 1.700000>, 
      <0.000000, -0.478587, 1.715492>, <0.100864, -0.478587, 1.715492>, <0.267090, -0.409733, 1.715492>, <0.338412, -0.338412, 1.715492>, 
      <0.000000, -0.537012, 1.683883>, <0.132440, -0.537012, 1.683883>, <0.286076, -0.473374, 1.683882>, <0.379725, -0.379725, 1.683882>, 
      <0.000000, -0.576802, 1.669690>, <0.132440, -0.576802, 1.669690>, <0.314212, -0.501509, 1.669690>, <0.407861, -0.407860, 1.669690>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.310621, -0.310621, 1.700000>, <-0.239299, -0.381942, 1.700000>, <-0.100864, -0.439284, 1.700000>, <0.000000, -0.439284, 1.700000>, 
      <-0.338412, -0.338412, 1.715492>, <-0.267090, -0.409733, 1.715492>, <-0.100864, -0.478587, 1.715492>, <0.000000, -0.478587, 1.715492>, 
      <-0.379725, -0.379725, 1.683883>, <-0.286076, -0.473374, 1.683883>, <-0.132439, -0.537012, 1.683883>, <0.000000, -0.537012, 1.683883>, 
      <-0.407861, -0.407861, 1.669690>, <-0.314212, -0.501510, 1.669690>, <-0.132439, -0.576802, 1.669690>, <0.000000, -0.576802, 1.669690>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.439284, 0.000000, 1.700000>, <-0.439284, -0.100864, 1.700000>, <-0.381942, -0.239299, 1.700000>, <-0.310621, -0.310621, 1.700000>, 
      <-0.478587, 0.000000, 1.715492>, <-0.478587, -0.100864, 1.715492>, <-0.409733, -0.267090, 1.715492>, <-0.338412, -0.338412, 1.715492>, 
      <-0.537012, 0.000000, 1.683883>, <-0.537012, -0.132440, 1.683883>, <-0.473374, -0.286076, 1.683883>, <-0.379725, -0.379725, 1.683883>, 
      <-0.576802, -0.000000, 1.669690>, <-0.576802, -0.132440, 1.669690>, <-0.501510, -0.314212, 1.669690>, <-0.407861, -0.407861, 1.669690>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.310621, 0.310621, 1.700000>, <-0.381942, 0.239299, 1.700000>, <-0.439284, 0.100864, 1.700000>, <-0.439284, 0.000000, 1.700000>, 
      <-0.338412, 0.338412, 1.715492>, <-0.409733, 0.267090, 1.715492>, <-0.478587, 0.100864, 1.715492>, <-0.478587, 0.000000, 1.715492>, 
      <-0.379725, 0.379725, 1.683882>, <-0.473374, 0.286076, 1.683882>, <-0.537012, 0.132439, 1.683883>, <-0.537012, 0.000000, 1.683883>, 
      <-0.407861, 0.407861, 1.669690>, <-0.501510, 0.314212, 1.669690>, <-0.576802, 0.132439, 1.669690>, <-0.576802, -0.000000, 1.669690>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 0.439284, 1.700000>, <-0.100864, 0.439284, 1.700000>, <-0.239299, 0.381942, 1.700000>, <-0.310621, 0.310621, 1.700000>, 
      <0.000000, 0.478587, 1.715492>, <-0.100864, 0.478587, 1.715492>, <-0.267090, 0.409733, 1.715492>, <-0.338412, 0.338412, 1.715492>, 
      <0.000000, 0.537012, 1.683883>, <-0.132440, 0.537012, 1.683883>, <-0.286076, 0.473374, 1.683882>, <-0.379725, 0.379725, 1.683882>, 
      <0.000000, 0.576802, 1.669690>, <-0.132440, 0.576802, 1.669690>, <-0.314212, 0.501510, 1.669690>, <-0.407861, 0.407861, 1.669690>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.310621, 0.310621, 1.700000>, <0.239299, 0.381942, 1.700000>, <0.100864, 0.439284, 1.700000>, <0.000000, 0.439284, 1.700000>, 
      <0.338412, 0.338412, 1.715492>, <0.267090, 0.409733, 1.715492>, <0.100864, 0.478587, 1.715492>, <0.000000, 0.478587, 1.715492>, 
      <0.379725, 0.379725, 1.683882>, <0.286076, 0.473374, 1.683882>, <0.132439, 0.537012, 1.683883>, <0.000000, 0.537012, 1.683883>, 
      <0.407861, 0.407861, 1.669690>, <0.314212, 0.501510, 1.669690>, <0.132439, 0.576802, 1.669690>, <0.000000, 0.576802, 1.669690>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -0.400000, 1.600000>, <0.091844, -0.400000, 1.600000>, <0.217899, -0.347786, 1.600000>, <0.282843, -0.282843, 1.600000>, 
      <0.000000, -0.430951, 1.591005>, <0.091844, -0.430951, 1.591005>, <0.239785, -0.369672, 1.591005>, <0.304729, -0.304729, 1.591005>, 
      <0.000000, -0.409298, 1.688180>, <0.100864, -0.409298, 1.688180>, <0.218096, -0.360739, 1.688180>, <0.289417, -0.289417, 1.688180>, 
      <0.000000, -0.439284, 1.700000>, <0.100864, -0.439284, 1.700000>, <0.239299, -0.381942, 1.700000>, <0.310621, -0.310621, 1.700000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.282843, -0.282843, 1.600000>, <-0.217899, -0.347786, 1.600000>, <-0.091844, -0.400000, 1.600000>, <0.000000, -0.400000, 1.600000>, 
      <-0.304729, -0.304729, 1.591005>, <-0.239785, -0.369672, 1.591005>, <-0.091844, -0.430951, 1.591005>, <0.000000, -0.430951, 1.591005>, 
      <-0.289417, -0.289417, 1.688180>, <-0.218095, -0.360739, 1.688180>, <-0.100864, -0.409298, 1.688180>, <0.000000, -0.409298, 1.688180>, 
      <-0.310621, -0.310621, 1.700000>, <-0.239299, -0.381942, 1.700000>, <-0.100864, -0.439284, 1.700000>, <0.000000, -0.439284, 1.700000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.400000, 0.000000, 1.600000>, <-0.400000, -0.091844, 1.600000>, <-0.347786, -0.217899, 1.600000>, <-0.282843, -0.282843, 1.600000>, 
      <-0.430951, 0.000000, 1.591005>, <-0.430951, -0.091844, 1.591005>, <-0.369672, -0.239785, 1.591005>, <-0.304729, -0.304729, 1.591005>, 
      <-0.409298, 0.000000, 1.688180>, <-0.409298, -0.100864, 1.688180>, <-0.360739, -0.218096, 1.688180>, <-0.289417, -0.289417, 1.688180>, 
      <-0.439284, 0.000000, 1.700000>, <-0.439284, -0.100864, 1.700000>, <-0.381942, -0.239299, 1.700000>, <-0.310621, -0.310621, 1.700000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.282843, 0.282843, 1.600000>, <-0.347786, 0.217899, 1.600000>, <-0.400000, 0.091844, 1.600000>, <-0.400000, 0.000000, 1.600000>, 
      <-0.304729, 0.304729, 1.591005>, <-0.369672, 0.239785, 1.591005>, <-0.430951, 0.091844, 1.591005>, <-0.430951, 0.000000, 1.591005>, 
      <-0.289417, 0.289417, 1.688180>, <-0.360739, 0.218095, 1.688180>, <-0.409298, 0.100864, 1.688180>, <-0.409298, 0.000000, 1.688180>, 
      <-0.310621, 0.310621, 1.700000>, <-0.381942, 0.239299, 1.700000>, <-0.439284, 0.100864, 1.700000>, <-0.439284, 0.000000, 1.700000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 0.400000, 1.600000>, <-0.091844, 0.400000, 1.600000>, <-0.217899, 0.347786, 1.600000>, <-0.282843, 0.282843, 1.600000>, 
      <0.000000, 0.430951, 1.591005>, <-0.091844, 0.430951, 1.591005>, <-0.239785, 0.369672, 1.591005>, <-0.304729, 0.304729, 1.591005>, 
      <0.000000, 0.409298, 1.688180>, <-0.100864, 0.409298, 1.688180>, <-0.218096, 0.360739, 1.688180>, <-0.289417, 0.289417, 1.688180>, 
      <0.000000, 0.439284, 1.700000>, <-0.100864, 0.439284, 1.700000>, <-0.239299, 0.381942, 1.700000>, <-0.310621, 0.310621, 1.700000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.282843, 0.282843, 1.600000>, <0.217899, 0.347786, 1.600000>, <0.091844, 0.400000, 1.600000>, <0.000000, 0.400000, 1.600000>, 
      <0.304729, 0.304729, 1.591005>, <0.239785, 0.369672, 1.591005>, <0.091844, 0.430951, 1.591005>, <0.000000, 0.430951, 1.591005>, 
      <0.289417, 0.289417, 1.688180>, <0.218096, 0.360739, 1.688180>, <0.100864, 0.409298, 1.688180>, <0.000000, 0.409298, 1.688180>, 
      <0.310621, 0.310621, 1.700000>, <0.239299, 0.381942, 1.700000>, <0.100864, 0.439284, 1.700000>, <0.000000, 0.439284, 1.700000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -0.300000, 1.740477>, <0.068883, -0.300000, 1.740477>, <0.163424, -0.260840, 1.740477>, <0.212132, -0.212132, 1.740477>, 
      <0.000000, -0.335009, 1.702393>, <0.068883, -0.335009, 1.702393>, <0.188179, -0.285595, 1.702393>, <0.236887, -0.236887, 1.702393>, 
      <0.000000, -0.350325, 1.614436>, <0.091844, -0.350325, 1.614436>, <0.182773, -0.312660, 1.614436>, <0.247717, -0.247717, 1.614436>, 
      <0.000000, -0.400000, 1.600000>, <0.091844, -0.400000, 1.600000>, <0.217899, -0.347786, 1.600000>, <0.282843, -0.282843, 1.600000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.212132, -0.212132, 1.740477>, <-0.163424, -0.260840, 1.740477>, <-0.068883, -0.300000, 1.740477>, <0.000000, -0.300000, 1.740477>, 
      <-0.236887, -0.236887, 1.702393>, <-0.188179, -0.285595, 1.702393>, <-0.068883, -0.335009, 1.702393>, <0.000000, -0.335009, 1.702393>, 
      <-0.247717, -0.247717, 1.614436>, <-0.182773, -0.312661, 1.614436>, <-0.091844, -0.350325, 1.614436>, <0.000000, -0.350325, 1.614436>, 
      <-0.282843, -0.282843, 1.600000>, <-0.217899, -0.347786, 1.600000>, <-0.091844, -0.400000, 1.600000>, <0.000000, -0.400000, 1.600000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.300000, 0.000000, 1.740477>, <-0.300000, -0.068883, 1.740477>, <-0.260840, -0.163424, 1.740477>, <-0.212132, -0.212132, 1.740477>, 
      <-0.335009, 0.000000, 1.702393>, <-0.335009, -0.068883, 1.702393>, <-0.285595, -0.188179, 1.702393>, <-0.236887, -0.236887, 1.702393>, 
      <-0.350325, 0.000000, 1.614436>, <-0.350325, -0.091844, 1.614436>, <-0.312660, -0.182773, 1.614436>, <-0.247717, -0.247717, 1.614436>, 
      <-0.400000, 0.000000, 1.600000>, <-0.400000, -0.091844, 1.600000>, <-0.347786, -0.217899, 1.600000>, <-0.282843, -0.282843, 1.600000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.212132, 0.212132, 1.740477>, <-0.260840, 0.163424, 1.740477>, <-0.300000, 0.068883, 1.740477>, <-0.300000, 0.000000, 1.740477>, 
      <-0.236887, 0.236887, 1.702393>, <-0.285595, 0.188179, 1.702393>, <-0.335009, 0.068883, 1.702393>, <-0.335009, 0.000000, 1.702393>, 
      <-0.247717, 0.247717, 1.614436>, <-0.312660, 0.182773, 1.614436>, <-0.350325, 0.091844, 1.614436>, <-0.350325, 0.000000, 1.614436>, 
      <-0.282843, 0.282843, 1.600000>, <-0.347786, 0.217899, 1.600000>, <-0.400000, 0.091844, 1.600000>, <-0.400000, 0.000000, 1.600000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 0.300000, 1.740477>, <-0.068883, 0.300000, 1.740477>, <-0.163424, 0.260840, 1.740477>, <-0.212132, 0.212132, 1.740477>, 
      <0.000000, 0.335009, 1.702393>, <-0.068883, 0.335009, 1.702393>, <-0.188179, 0.285595, 1.702393>, <-0.236887, 0.236887, 1.702393>, 
      <0.000000, 0.350325, 1.614436>, <-0.091844, 0.350325, 1.614436>, <-0.182773, 0.312660, 1.614436>, <-0.247717, 0.247717, 1.614436>, 
      <0.000000, 0.400000, 1.600000>, <-0.091844, 0.400000, 1.600000>, <-0.217899, 0.347786, 1.600000>, <-0.282843, 0.282843, 1.600000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.212132, 0.212132, 1.740477>, <0.163424, 0.260840, 1.740477>, <0.068883, 0.300000, 1.740477>, <0.000000, 0.300000, 1.740477>, 
      <0.236887, 0.236887, 1.702393>, <0.188179, 0.285595, 1.702393>, <0.068883, 0.335009, 1.702393>, <0.000000, 0.335009, 1.702393>, 
      <0.247717, 0.247717, 1.614436>, <0.182773, 0.312661, 1.614436>, <0.091844, 0.350325, 1.614436>, <0.000000, 0.350325, 1.614436>, 
      <0.282843, 0.282843, 1.600000>, <0.217899, 0.347786, 1.600000>, <0.091844, 0.400000, 1.600000>, <0.000000, 0.400000, 1.600000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -0.169642, 1.850597>, <0.038952, -0.169642, 1.850597>, <0.092412, -0.147498, 1.850597>, <0.119955, -0.119955, 1.850597>, 
      <0.000000, -0.215467, 1.827775>, <0.038952, -0.215467, 1.827775>, <0.124815, -0.179901, 1.827775>, <0.152358, -0.152358, 1.827775>, 
      <0.000000, -0.265355, 1.778166>, <0.068883, -0.265355, 1.778166>, <0.138927, -0.236342, 1.778166>, <0.187634, -0.187634, 1.778166>, 
      <0.000000, -0.300000, 1.740477>, <0.068883, -0.300000, 1.740477>, <0.163424, -0.260840, 1.740477>, <0.212132, -0.212132, 1.740477>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.119955, -0.119955, 1.850597>, <-0.092412, -0.147498, 1.850597>, <-0.038952, -0.169642, 1.850597>, <0.000000, -0.169642, 1.850597>, 
      <-0.152358, -0.152358, 1.827775>, <-0.124815, -0.179901, 1.827775>, <-0.038952, -0.215467, 1.827775>, <0.000000, -0.215467, 1.827775>, 
      <-0.187634, -0.187634, 1.778166>, <-0.138927, -0.236342, 1.778166>, <-0.068883, -0.265355, 1.778166>, <0.000000, -0.265355, 1.778166>, 
      <-0.212132, -0.212132, 1.740477>, <-0.163424, -0.260840, 1.740477>, <-0.068883, -0.300000, 1.740477>, <0.000000, -0.300000, 1.740477>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.169642, 0.000000, 1.850597>, <-0.169642, -0.038952, 1.850597>, <-0.147498, -0.092412, 1.850597>, <-0.119955, -0.119955, 1.850597>, 
      <-0.215467, 0.000000, 1.827775>, <-0.215467, -0.038952, 1.827775>, <-0.179901, -0.124815, 1.827775>, <-0.152358, -0.152358, 1.827775>, 
      <-0.265355, 0.000000, 1.778166>, <-0.265355, -0.068883, 1.778166>, <-0.236342, -0.138927, 1.778166>, <-0.187634, -0.187634, 1.778166>, 
      <-0.300000, 0.000000, 1.740477>, <-0.300000, -0.068883, 1.740477>, <-0.260840, -0.163424, 1.740477>, <-0.212132, -0.212132, 1.740477>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.119955, 0.119955, 1.850597>, <-0.147498, 0.092412, 1.850597>, <-0.169642, 0.038952, 1.850597>, <-0.169642, 0.000000, 1.850597>, 
      <-0.152358, 0.152358, 1.827775>, <-0.179901, 0.124815, 1.827775>, <-0.215467, 0.038952, 1.827775>, <-0.215467, 0.000000, 1.827775>, 
      <-0.187634, 0.187634, 1.778166>, <-0.236342, 0.138927, 1.778166>, <-0.265355, 0.068883, 1.778166>, <-0.265355, 0.000000, 1.778166>, 
      <-0.212132, 0.212132, 1.740477>, <-0.260840, 0.163424, 1.740477>, <-0.300000, 0.068883, 1.740477>, <-0.300000, 0.000000, 1.740477>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 0.169642, 1.850597>, <-0.038952, 0.169642, 1.850597>, <-0.092412, 0.147498, 1.850597>, <-0.119955, 0.119955, 1.850597>, 
      <0.000000, 0.215467, 1.827775>, <-0.038952, 0.215467, 1.827775>, <-0.124815, 0.179901, 1.827775>, <-0.152358, 0.152358, 1.827775>, 
      <0.000000, 0.265355, 1.778166>, <-0.068883, 0.265355, 1.778166>, <-0.138927, 0.236342, 1.778166>, <-0.187634, 0.187634, 1.778166>, 
      <0.000000, 0.300000, 1.740477>, <-0.068883, 0.300000, 1.740477>, <-0.163424, 0.260840, 1.740477>, <-0.212132, 0.212132, 1.740477>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.119955, 0.119955, 1.850597>, <0.092412, 0.147498, 1.850597>, <0.038952, 0.169642, 1.850597>, <0.000000, 0.169642, 1.850597>, 
      <0.152358, 0.152358, 1.827775>, <0.124815, 0.179901, 1.827775>, <0.038952, 0.215467, 1.827775>, <0.000000, 0.215467, 1.827775>, 
      <0.187634, 0.187634, 1.778166>, <0.138927, 0.236342, 1.778166>, <0.068883, 0.265355, 1.778166>, <0.000000, 0.265355, 1.778166>, 
      <0.212132, 0.212132, 1.740477>, <0.163424, 0.260840, 1.740477>, <0.068883, 0.300000, 1.740477>, <0.000000, 0.300000, 1.740477>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 0.000000, 1.889881>, <0.000000, 0.000000, 1.889881>, <0.000000, 0.000000, 1.889881>, <0.000000, 0.000000, 1.889881>, 
      <0.000000, -0.050893, 1.878096>, <0.000000, -0.050893, 1.878096>, <0.035986, -0.035986, 1.878096>, <0.035986, -0.035986, 1.878096>, 
      <0.000000, -0.122881, 1.873884>, <0.038952, -0.122881, 1.873884>, <0.059347, -0.114433, 1.873884>, <0.086890, -0.086890, 1.873884>, 
      <0.000000, -0.169642, 1.850597>, <0.038952, -0.169642, 1.850597>, <0.092412, -0.147498, 1.850597>, <0.119955, -0.119955, 1.850597>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 0.000000, 1.889881>, <0.000000, 0.000000, 1.889881>, <0.000000, 0.000000, 1.889881>, <0.000000, 0.000000, 1.889881>, 
      <-0.035986, -0.035986, 1.878096>, <-0.035986, -0.035986, 1.878096>, <0.000000, -0.050893, 1.878096>, <0.000000, -0.050893, 1.878096>, 
      <-0.086890, -0.086890, 1.873884>, <-0.059347, -0.114433, 1.873884>, <-0.038952, -0.122881, 1.873884>, <0.000000, -0.122881, 1.873884>, 
      <-0.119955, -0.119955, 1.850597>, <-0.092412, -0.147498, 1.850597>, <-0.038952, -0.169642, 1.850597>, <0.000000, -0.169642, 1.850597>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 0.000000, 1.889881>, <0.000000, 0.000000, 1.889881>, <0.000000, 0.000000, 1.889881>, <0.000000, 0.000000, 1.889881>, 
      <-0.050893, 0.000000, 1.878096>, <-0.050893, 0.000000, 1.878096>, <-0.035986, -0.035986, 1.878096>, <-0.035986, -0.035986, 1.878096>, 
      <-0.122881, 0.000000, 1.873884>, <-0.122881, -0.038952, 1.873884>, <-0.114433, -0.059347, 1.873884>, <-0.086890, -0.086890, 1.873884>, 
      <-0.169642, 0.000000, 1.850597>, <-0.169642, -0.038952, 1.850597>, <-0.147498, -0.092412, 1.850597>, <-0.119955, -0.119955, 1.850597>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 0.000000, 1.889881>, <0.000000, 0.000000, 1.889881>, <0.000000, 0.000000, 1.889881>, <0.000000, 0.000000, 1.889881>, 
      <-0.035986, 0.035986, 1.878096>, <-0.035986, 0.035986, 1.878096>, <-0.050893, 0.000000, 1.878096>, <-0.050893, 0.000000, 1.878096>, 
      <-0.086890, 0.086890, 1.873884>, <-0.114433, 0.059347, 1.873884>, <-0.122881, 0.038952, 1.873884>, <-0.122881, 0.000000, 1.873884>, 
      <-0.119955, 0.119955, 1.850597>, <-0.147498, 0.092412, 1.850597>, <-0.169642, 0.038952, 1.850597>, <-0.169642, 0.000000, 1.850597>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 0.000000, 1.889881>, <0.000000, 0.000000, 1.889881>, <0.000000, 0.000000, 1.889881>, <0.000000, 0.000000, 1.889881>, 
      <0.000000, 0.050893, 1.878096>, <0.000000, 0.050893, 1.878096>, <-0.035986, 0.035986, 1.878096>, <-0.035986, 0.035986, 1.878096>, 
      <0.000000, 0.122881, 1.873884>, <-0.038952, 0.122881, 1.873884>, <-0.059347, 0.114433, 1.873884>, <-0.086890, 0.086890, 1.873884>, 
      <0.000000, 0.169642, 1.850597>, <-0.038952, 0.169642, 1.850597>, <-0.092412, 0.147498, 1.850597>, <-0.119955, 0.119955, 1.850597>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 0.000000, 1.889881>, <0.000000, 0.000000, 1.889881>, <0.000000, 0.000000, 1.889881>, <0.000000, 0.000000, 1.889881>, 
      <0.035986, 0.035986, 1.878096>, <0.035986, 0.035986, 1.878096>, <0.000000, 0.050893, 1.878096>, <0.000000, 0.050893, 1.878096>, 
      <0.086890, 0.086890, 1.873884>, <0.059347, 0.114433, 1.873884>, <0.038952, 0.122881, 1.873884>, <0.000000, 0.122881, 1.873884>, 
      <0.119955, 0.119955, 1.850597>, <0.092412, 0.147498, 1.850597>, <0.038952, 0.169642, 1.850597>, <0.000000, 0.169642, 1.850597>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.300000, 0.000000, 1.740477>, <0.300000, 0.068883, 1.740477>, <0.260840, 0.163424, 1.740477>, <0.212132, 0.212132, 1.740477>, 
      <0.265355, 0.000000, 1.778166>, <0.265355, 0.068883, 1.778166>, <0.236342, 0.138927, 1.778166>, <0.187634, 0.187634, 1.778166>, 
      <0.215467, 0.000000, 1.827775>, <0.215467, 0.038952, 1.827775>, <0.179901, 0.124815, 1.827775>, <0.152358, 0.152358, 1.827775>, 
      <0.169642, 0.000000, 1.850597>, <0.169642, 0.038952, 1.850597>, <0.147498, 0.092412, 1.850597>, <0.119955, 0.119955, 1.850597>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.300000, 0.000000, 1.740477>, <0.300000, -0.068883, 1.740477>, <0.260840, -0.163424, 1.740477>, <0.212132, -0.212132, 1.740477>, 
      <0.265355, 0.000000, 1.778166>, <0.265355, -0.068883, 1.778166>, <0.236342, -0.138927, 1.778166>, <0.187634, -0.187634, 1.778166>, 
      <0.215467, 0.000000, 1.827775>, <0.215467, -0.038952, 1.827775>, <0.179901, -0.124815, 1.827775>, <0.152358, -0.152358, 1.827775>, 
      <0.169642, 0.000000, 1.850597>, <0.169642, -0.038952, 1.850597>, <0.147498, -0.092412, 1.850597>, <0.119955, -0.119955, 1.850597>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.400000, 0.000000, 1.600000>, <0.400000, 0.091844, 1.600000>, <0.347786, 0.217899, 1.600000>, <0.282843, 0.282843, 1.600000>, 
      <0.350325, 0.000000, 1.614436>, <0.350325, 0.091844, 1.614436>, <0.312660, 0.182773, 1.614436>, <0.247717, 0.247717, 1.614436>, 
      <0.335009, 0.000000, 1.702393>, <0.335009, 0.068883, 1.702393>, <0.285595, 0.188179, 1.702393>, <0.236887, 0.236887, 1.702393>, 
      <0.300000, 0.000000, 1.740477>, <0.300000, 0.068883, 1.740477>, <0.260840, 0.163424, 1.740477>, <0.212132, 0.212132, 1.740477>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.400000, 0.000000, 1.600000>, <0.350325, 0.000000, 1.614436>, <0.335009, 0.000000, 1.702393>, <0.300000, 0.000000, 1.740477>, 
      <0.400000, -0.091844, 1.600000>, <0.350325, -0.091844, 1.614436>, <0.335009, -0.068883, 1.702393>, <0.300000, -0.068883, 1.740477>, 
      <0.347786, -0.217899, 1.600000>, <0.312661, -0.182773, 1.614436>, <0.285595, -0.188179, 1.702393>, <0.260840, -0.163424, 1.740477>, 
      <0.282843, -0.282843, 1.600000>, <0.247717, -0.247717, 1.614436>, <0.236887, -0.236887, 1.702393>, <0.212132, -0.212132, 1.740477>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 0.000000, 1.889881>, <0.000000, 0.000000, 1.889881>, <0.000000, 0.000000, 1.889881>, <0.000000, 0.000000, 1.889881>, 
      <0.050893, 0.000000, 1.878096>, <0.050893, 0.000000, 1.878096>, <0.035986, 0.035986, 1.878096>, <0.035986, 0.035986, 1.878096>, 
      <0.122881, 0.000000, 1.873884>, <0.122881, 0.038952, 1.873884>, <0.114433, 0.059347, 1.873884>, <0.086890, 0.086890, 1.873884>, 
      <0.169642, 0.000000, 1.850597>, <0.169642, 0.038952, 1.850597>, <0.147498, 0.092412, 1.850597>, <0.119955, 0.119955, 1.850597>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 0.000000, 1.889881>, <0.050893, 0.000000, 1.878096>, <0.122881, 0.000000, 1.873884>, <0.169642, 0.000000, 1.850597>, 
      <0.000000, 0.000000, 1.889881>, <0.050893, 0.000000, 1.878096>, <0.122881, -0.038952, 1.873884>, <0.169642, -0.038952, 1.850597>, 
      <0.000000, 0.000000, 1.889881>, <0.035986, -0.035986, 1.878096>, <0.114433, -0.059347, 1.873884>, <0.147498, -0.092412, 1.850597>, 
      <0.000000, 0.000000, 1.889881>, <0.035986, -0.035986, 1.878096>, <0.086890, -0.086890, 1.873884>, <0.119955, -0.119955, 1.850597>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.439284, 0.000000, 1.700000>, <0.478587, 0.000000, 1.715492>, <0.537012, 0.000000, 1.683883>, <0.576802, 0.000000, 1.669690>, 
      <0.439284, 0.100864, 1.700000>, <0.478587, 0.100864, 1.715492>, <0.537012, 0.132439, 1.683883>, <0.576802, 0.132439, 1.669690>, 
      <0.381942, 0.239299, 1.700000>, <0.409733, 0.267090, 1.715492>, <0.473374, 0.286076, 1.683882>, <0.501510, 0.314212, 1.669690>, 
      <0.310621, 0.310621, 1.700000>, <0.338412, 0.338412, 1.715492>, <0.379725, 0.379725, 1.683882>, <0.407861, 0.407861, 1.669690>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.439284, 0.000000, 1.700000>, <0.439284, -0.100864, 1.700000>, <0.381942, -0.239299, 1.700000>, <0.310621, -0.310621, 1.700000>, 
      <0.478587, 0.000000, 1.715492>, <0.478587, -0.100864, 1.715492>, <0.409733, -0.267090, 1.715492>, <0.338412, -0.338412, 1.715492>, 
      <0.537012, 0.000000, 1.683883>, <0.537012, -0.132439, 1.683883>, <0.473374, -0.286076, 1.683882>, <0.379725, -0.379725, 1.683882>, 
      <0.576802, 0.000000, 1.669690>, <0.576802, -0.132439, 1.669690>, <0.501510, -0.314212, 1.669690>, <0.407861, -0.407860, 1.669690>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.439284, 0.000000, 1.700000>, <0.439284, 0.100864, 1.700000>, <0.381942, 0.239299, 1.700000>, <0.310621, 0.310621, 1.700000>, 
      <0.409298, 0.000000, 1.688180>, <0.409298, 0.100864, 1.688180>, <0.360739, 0.218096, 1.688180>, <0.289417, 0.289417, 1.688180>, 
      <0.430951, 0.000000, 1.591005>, <0.430951, 0.091844, 1.591005>, <0.369672, 0.239785, 1.591005>, <0.304729, 0.304729, 1.591005>, 
      <0.400000, 0.000000, 1.600000>, <0.400000, 0.091844, 1.600000>, <0.347786, 0.217899, 1.600000>, <0.282843, 0.282843, 1.600000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.439284, 0.000000, 1.700000>, <0.409298, 0.000000, 1.688180>, <0.430951, 0.000000, 1.591005>, <0.400000, 0.000000, 1.600000>, 
      <0.439284, -0.100864, 1.700000>, <0.409298, -0.100864, 1.688180>, <0.430951, -0.091844, 1.591005>, <0.400000, -0.091844, 1.600000>, 
      <0.381942, -0.239299, 1.700000>, <0.360739, -0.218095, 1.688180>, <0.369672, -0.239785, 1.591005>, <0.347786, -0.217899, 1.600000>, 
      <0.310621, -0.310621, 1.700000>, <0.289417, -0.289417, 1.688180>, <0.304729, -0.304729, 1.591005>, <0.282843, -0.282843, 1.600000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.000000, 0.000000, 1.500000>, <1.000000, 0.229610, 1.500000>, <0.869466, 0.544748, 1.500000>, <0.707107, 0.707107, 1.500000>, 
      <0.865712, 0.000000, 1.526020>, <0.865712, 0.229610, 1.526020>, <0.774510, 0.449792, 1.526020>, <0.612151, 0.612151, 1.526020>, 
      <0.705637, 0.000000, 1.623736>, <0.705637, 0.132439, 1.623736>, <0.592610, 0.405312, 1.623736>, <0.498961, 0.498961, 1.623736>, 
      <0.576802, 0.000000, 1.669690>, <0.576802, 0.132439, 1.669690>, <0.501510, 0.314212, 1.669690>, <0.407861, 0.407861, 1.669690>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.000000, 0.000000, 1.500000>, <0.865712, 0.000000, 1.526020>, <0.705637, 0.000000, 1.623736>, <0.576802, 0.000000, 1.669690>, 
      <1.000000, -0.229610, 1.500000>, <0.865712, -0.229610, 1.526020>, <0.705637, -0.132439, 1.623736>, <0.576802, -0.132439, 1.669690>, 
      <0.869466, -0.544748, 1.500000>, <0.774510, -0.449792, 1.526020>, <0.592610, -0.405312, 1.623736>, <0.501510, -0.314212, 1.669690>, 
      <0.707107, -0.707107, 1.500000>, <0.612151, -0.612151, 1.526020>, <0.498961, -0.498960, 1.623736>, <0.407861, -0.407860, 1.669690>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.988687, 0.000000, 1.589881>, <1.034252, 0.000000, 1.610199>, <1.104950, 0.000000, 1.579528>, <1.153604, 0.000000, 1.568497>, 
      <0.988687, 0.227013, 1.589881>, <1.034252, 0.227013, 1.610199>, <1.104950, 0.264879, 1.579528>, <1.153604, 0.264879, 1.568497>, 
      <0.859630, 0.538585, 1.589881>, <0.891848, 0.570804, 1.610199>, <0.968615, 0.594020, 1.579528>, <1.003019, 0.628423, 1.568497>, 
      <0.699108, 0.699108, 1.589881>, <0.731326, 0.731326, 1.610199>, <0.781317, 0.781317, 1.579528>, <0.815721, 0.815721, 1.568497>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.988687, 0.000000, 1.589881>, <0.988687, -0.227013, 1.589881>, <0.859630, -0.538585, 1.589881>, <0.699108, -0.699107, 1.589881>, 
      <1.034252, 0.000000, 1.610199>, <1.034252, -0.227013, 1.610199>, <0.891849, -0.570804, 1.610199>, <0.731326, -0.731326, 1.610199>, 
      <1.104950, 0.000000, 1.579528>, <1.104950, -0.264879, 1.579528>, <0.968615, -0.594019, 1.579528>, <0.781318, -0.781317, 1.579528>, 
      <1.153604, 0.000000, 1.568497>, <1.153604, -0.264879, 1.568497>, <1.003019, -0.628423, 1.568497>, <0.815721, -0.815721, 1.568497>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.988687, 0.000000, 1.589881>, <0.988687, 0.227013, 1.589881>, <0.859630, 0.538585, 1.589881>, <0.699108, 0.699108, 1.589881>, 
      <0.963866, 0.000000, 1.578812>, <0.963866, 0.227013, 1.578812>, <0.842079, 0.521034, 1.578812>, <0.681557, 0.681557, 1.578812>, 
      <1.026681, 0.000000, 1.494830>, <1.026681, 0.229610, 1.494830>, <0.888332, 0.563614, 1.494830>, <0.725973, 0.725973, 1.494830>, 
      <1.000000, 0.000000, 1.500000>, <1.000000, 0.229610, 1.500000>, <0.869466, 0.544748, 1.500000>, <0.707107, 0.707107, 1.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.988687, 0.000000, 1.589881>, <0.963866, 0.000000, 1.578812>, <1.026681, 0.000000, 1.494830>, <1.000000, 0.000000, 1.500000>, 
      <0.988687, -0.227013, 1.589881>, <0.963866, -0.227013, 1.578812>, <1.026681, -0.229610, 1.494830>, <1.000000, -0.229610, 1.500000>, 
      <0.859630, -0.538585, 1.589881>, <0.842079, -0.521034, 1.578812>, <0.888332, -0.563614, 1.494830>, <0.869466, -0.544748, 1.500000>, 
      <0.699108, -0.699107, 1.589881>, <0.681557, -0.681556, 1.578812>, <0.725973, -0.725973, 1.494830>, <0.707107, -0.707107, 1.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.340477, 0.000000, 1.510119>, <1.340477, 0.307787, 1.510119>, <1.165499, 0.730222, 1.510119>, <0.947861, 0.947861, 1.510119>, 
      <1.282094, 0.000000, 1.503708>, <1.282094, 0.307787, 1.503708>, <1.124216, 0.688939, 1.503708>, <0.906578, 0.906578, 1.503708>, 
      <1.210884, 0.000000, 1.555509>, <1.210884, 0.264879, 1.555509>, <1.043522, 0.668926, 1.555509>, <0.856224, 0.856224, 1.555509>, 
      <1.153604, 0.000000, 1.568497>, <1.153604, 0.264879, 1.568497>, <1.003019, 0.628423, 1.568497>, <0.815721, 0.815721, 1.568497>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.340477, 0.000000, 1.510119>, <1.282094, 0.000000, 1.503708>, <1.210884, 0.000000, 1.555509>, <1.153604, 0.000000, 1.568497>, 
      <1.340477, -0.307787, 1.510119>, <1.282094, -0.307787, 1.503708>, <1.210884, -0.264879, 1.555509>, <1.153604, -0.264879, 1.568497>, 
      <1.165499, -0.730222, 1.510119>, <1.124216, -0.688939, 1.503708>, <1.043522, -0.668926, 1.555509>, <1.003019, -0.628423, 1.568497>, 
      <0.947861, -0.947860, 1.510119>, <0.906578, -0.906577, 1.503708>, <0.856225, -0.856224, 1.555509>, <0.815721, -0.815721, 1.568497>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.440477, 0.000000, 1.600000>, <1.475320, 0.000000, 1.597790>, <1.506925, 0.000000, 1.534218>, <1.500000, 0.000000, 1.500000>, 
      <1.440477, 0.330748, 1.600000>, <1.475320, 0.330748, 1.597790>, <1.506925, 0.344415, 1.534218>, <1.500000, 0.344415, 1.500000>, 
      <1.252446, 0.784697, 1.600000>, <1.277083, 0.809334, 1.597790>, <1.309095, 0.822019, 1.534218>, <1.304198, 0.817122, 1.500000>, 
      <1.018571, 1.018571, 1.600000>, <1.043209, 1.043209, 1.597790>, <1.065557, 1.065557, 1.534218>, <1.060660, 1.060660, 1.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.440477, 0.000000, 1.600000>, <1.440478, -0.330748, 1.600000>, <1.252446, -0.784697, 1.600000>, <1.018572, -1.018571, 1.600000>, 
      <1.475320, 0.000000, 1.597790>, <1.475320, -0.330748, 1.597790>, <1.277083, -0.809334, 1.597790>, <1.043209, -1.043208, 1.597790>, 
      <1.506925, 0.000000, 1.534218>, <1.506925, -0.344415, 1.534218>, <1.309096, -0.822019, 1.534218>, <1.065557, -1.065557, 1.534218>, 
      <1.500000, 0.000000, 1.500000>, <1.500000, -0.344415, 1.500000>, <1.304199, -0.817122, 1.500000>, <1.060661, -1.060660, 1.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.440477, 0.000000, 1.600000>, <1.440477, 0.330748, 1.600000>, <1.252446, 0.784697, 1.600000>, <1.018571, 1.018571, 1.600000>, 
      <1.400221, 0.000000, 1.602554>, <1.400221, 0.330748, 1.602554>, <1.223980, 0.756232, 1.602554>, <0.990106, 0.990106, 1.602554>, 
      <1.380573, 0.000000, 1.514523>, <1.380573, 0.307787, 1.514523>, <1.193851, 0.758574, 1.514523>, <0.976213, 0.976213, 1.514523>, 
      <1.340477, 0.000000, 1.510119>, <1.340477, 0.307787, 1.510119>, <1.165499, 0.730222, 1.510119>, <0.947861, 0.947861, 1.510119>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.440477, 0.000000, 1.600000>, <1.400221, 0.000000, 1.602554>, <1.380573, 0.000000, 1.514523>, <1.340477, 0.000000, 1.510119>, 
      <1.440478, -0.330748, 1.600000>, <1.400222, -0.330748, 1.602554>, <1.380573, -0.307787, 1.514523>, <1.340477, -0.307787, 1.510119>, 
      <1.252446, -0.784697, 1.600000>, <1.223980, -0.756232, 1.602554>, <1.193851, -0.758574, 1.514523>, <1.165499, -0.730222, 1.510119>, 
      <1.018572, -1.018571, 1.600000>, <0.990106, -0.990106, 1.602554>, <0.976213, -0.976212, 1.514523>, <0.947861, -0.947860, 1.510119>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.400000, 0.000000, 1.400000>, <1.400000, 0.321454, 1.400000>, <1.217252, 0.762647, 1.400000>, <0.989950, 0.989950, 1.400000>, 
      <1.436837, 0.000000, 1.421049>, <1.436837, 0.321454, 1.421049>, <1.243299, 0.788694, 1.421049>, <1.015997, 1.015997, 1.421049>, 
      <1.491584, 0.000000, 1.458417>, <1.491584, 0.344415, 1.458417>, <1.298248, 0.811171, 1.458417>, <1.054709, 1.054709, 1.458417>, 
      <1.500000, 0.000000, 1.500000>, <1.500000, 0.344415, 1.500000>, <1.304198, 0.817122, 1.500000>, <1.060660, 1.060660, 1.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.400000, 0.000000, 1.400000>, <1.436837, 0.000000, 1.421049>, <1.491584, 0.000000, 1.458417>, <1.500000, 0.000000, 1.500000>, 
      <1.400000, -0.321454, 1.400000>, <1.436837, -0.321454, 1.421049>, <1.491584, -0.344415, 1.458417>, <1.500000, -0.344415, 1.500000>, 
      <1.217252, -0.762647, 1.400000>, <1.243300, -0.788694, 1.421049>, <1.298248, -0.811171, 1.458417>, <1.304199, -0.817122, 1.500000>, 
      <0.989950, -0.989949, 1.400000>, <1.015997, -1.015997, 1.421049>, <1.054710, -1.054709, 1.458417>, <1.060661, -1.060660, 1.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.800000, 0.000000, 1.100000>, <0.800000, 0.183688, 1.100000>, <0.695573, 0.435798, 1.100000>, <0.565685, 0.565685, 1.100000>, 
      <0.932522, 0.000000, 1.251453>, <0.932522, 0.183688, 1.251453>, <0.789279, 0.529505, 1.251453>, <0.659392, 0.659392, 1.251453>, 
      <1.225269, 0.000000, 1.300154>, <1.225269, 0.321454, 1.300154>, <1.093699, 0.639094, 1.300154>, <0.866396, 0.866396, 1.300154>, 
      <1.400000, 0.000000, 1.400000>, <1.400000, 0.321454, 1.400000>, <1.217252, 0.762647, 1.400000>, <0.989950, 0.989950, 1.400000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.800000, 0.000000, 1.100000>, <0.932522, 0.000000, 1.251453>, <1.225269, 0.000000, 1.300154>, <1.400000, 0.000000, 1.400000>, 
      <0.800000, -0.183688, 1.100000>, <0.932522, -0.183688, 1.251453>, <1.225269, -0.321454, 1.300154>, <1.400000, -0.321454, 1.400000>, 
      <0.695573, -0.435798, 1.100000>, <0.789280, -0.529505, 1.251453>, <1.093699, -0.639094, 1.300154>, <1.217252, -0.762647, 1.400000>, 
      <0.565686, -0.565685, 1.100000>, <0.659393, -0.659392, 1.251453>, <0.866397, -0.866396, 1.300154>, <0.989950, -0.989949, 1.400000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.700000, 0.000000, 0.600000>, <0.700000, 0.160727, 0.600000>, <0.608626, 0.381324, 0.600000>, <0.494975, 0.494975, 0.600000>, 
      <0.700000, 0.000000, 0.752971>, <0.700000, 0.160727, 0.752971>, <0.608626, 0.381324, 0.752971>, <0.494975, 0.494975, 0.752971>, 
      <0.699268, 0.000000, 0.984878>, <0.699268, 0.183688, 0.984878>, <0.624344, 0.364570, 0.984878>, <0.494457, 0.494457, 0.984878>, 
      <0.800000, 0.000000, 1.100000>, <0.800000, 0.183688, 1.100000>, <0.695573, 0.435798, 1.100000>, <0.565685, 0.565685, 1.100000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.700000, 0.000000, 0.600000>, <0.700000, 0.000000, 0.752971>, <0.699268, 0.000000, 0.984878>, <0.800000, 0.000000, 1.100000>, 
      <0.700000, -0.160727, 0.600000>, <0.700000, -0.160727, 0.752971>, <0.699268, -0.183688, 0.984878>, <0.800000, -0.183688, 1.100000>, 
      <0.608626, -0.381323, 0.600000>, <0.608626, -0.381323, 0.752971>, <0.624344, -0.364570, 0.984878>, <0.695573, -0.435798, 1.100000>, 
      <0.494975, -0.494975, 0.600000>, <0.494975, -0.494975, 0.752971>, <0.494457, -0.494457, 0.984878>, <0.565686, -0.565685, 1.100000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.800000, 0.000000, 0.129165>, <0.800000, 0.183688, 0.129165>, <0.695573, 0.435798, 0.129165>, <0.565685, 0.565685, 0.129165>, 
      <0.751326, 0.000000, 0.265116>, <0.751326, 0.183688, 0.265116>, <0.661155, 0.401381, 0.265116>, <0.531268, 0.531268, 0.265116>, 
      <0.700000, 0.000000, 0.455599>, <0.700000, 0.160727, 0.455599>, <0.608626, 0.381324, 0.455599>, <0.494975, 0.494975, 0.455599>, 
      <0.700000, 0.000000, 0.600000>, <0.700000, 0.160727, 0.600000>, <0.608626, 0.381324, 0.600000>, <0.494975, 0.494975, 0.600000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.800000, 0.000000, 0.129165>, <0.751326, 0.000000, 0.265116>, <0.700000, 0.000000, 0.455599>, <0.700000, 0.000000, 0.600000>, 
      <0.800000, -0.183688, 0.129165>, <0.751327, -0.183688, 0.265116>, <0.700000, -0.160727, 0.455599>, <0.700000, -0.160727, 0.600000>, 
      <0.695573, -0.435798, 0.129165>, <0.661155, -0.401381, 0.265116>, <0.608626, -0.381323, 0.455599>, <0.608626, -0.381323, 0.600000>, 
      <0.565686, -0.565685, 0.129165>, <0.531268, -0.531268, 0.265116>, <0.494975, -0.494975, 0.455599>, <0.494975, -0.494975, 0.600000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.889881, 0.000000, 0.069642>, <0.889881, 0.204326, 0.069642>, <0.773721, 0.484761, 0.069642>, <0.629241, 0.629241, 0.069642>, 
      <0.889881, 0.000000, 0.101983>, <0.889881, 0.204326, 0.101983>, <0.773721, 0.484761, 0.101983>, <0.629241, 0.629241, 0.101983>, 
      <0.810901, 0.000000, 0.098716>, <0.810901, 0.183688, 0.098716>, <0.703281, 0.443507, 0.098716>, <0.573394, 0.573394, 0.098716>, 
      <0.800000, 0.000000, 0.129165>, <0.800000, 0.183688, 0.129165>, <0.695573, 0.435798, 0.129165>, <0.565685, 0.565685, 0.129165>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.889881, 0.000000, 0.069642>, <0.889881, 0.000000, 0.101983>, <0.810901, 0.000000, 0.098716>, <0.800000, 0.000000, 0.129165>, 
      <0.889881, -0.204325, 0.069642>, <0.889881, -0.204325, 0.101983>, <0.810901, -0.183688, 0.098716>, <0.800000, -0.183688, 0.129165>, 
      <0.773721, -0.484760, 0.069642>, <0.773721, -0.484760, 0.101983>, <0.703281, -0.443507, 0.098716>, <0.695573, -0.435798, 0.129165>, 
      <0.629241, -0.629240, 0.069642>, <0.629241, -0.629240, 0.101983>, <0.573394, -0.573394, 0.098716>, <0.565686, -0.565685, 0.129165>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.800000, 0.000000, 0.000000>, <0.800000, 0.183688, 0.000000>, <0.695573, 0.435798, 0.000000>, <0.565685, 0.565685, 0.000000>, 
      <0.834007, 0.000000, 0.002661>, <0.834007, 0.183688, 0.002661>, <0.719619, 0.459845, 0.002661>, <0.589732, 0.589732, 0.002661>, 
      <0.889881, 0.000000, 0.035531>, <0.889881, 0.204326, 0.035531>, <0.773721, 0.484761, 0.035531>, <0.629241, 0.629241, 0.035531>, 
      <0.889881, 0.000000, 0.069642>, <0.889881, 0.204326, 0.069642>, <0.773721, 0.484761, 0.069642>, <0.629241, 0.629241, 0.069642>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.800000, 0.000000, 0.000000>, <0.834007, 0.000000, 0.002661>, <0.889881, 0.000000, 0.035531>, <0.889881, 0.000000, 0.069642>, 
      <0.800000, -0.183688, 0.000000>, <0.834007, -0.183688, 0.002661>, <0.889881, -0.204325, 0.035531>, <0.889881, -0.204325, 0.069642>, 
      <0.695573, -0.435798, 0.000000>, <0.719619, -0.459845, 0.002661>, <0.773721, -0.484760, 0.035531>, <0.773721, -0.484760, 0.069642>, 
      <0.565686, -0.565685, 0.000000>, <0.589732, -0.589732, 0.002661>, <0.629241, -0.629240, 0.035531>, <0.629241, -0.629240, 0.069642>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 0.000000, 0.000000>, <0.000000, 0.000000, 0.000000>, <0.000000, 0.000000, 0.000000>, <0.000000, 0.000000, 0.000000>, 
      <0.240000, 0.000000, 0.000000>, <0.240000, 0.000000, 0.000000>, <0.169706, 0.169706, 0.000000>, <0.169706, 0.169706, 0.000000>, 
      <0.560732, 0.000000, -0.018725>, <0.560732, 0.183688, -0.018725>, <0.526384, 0.266610, -0.018725>, <0.396497, 0.396497, -0.018725>, 
      <0.800000, 0.000000, 0.000000>, <0.800000, 0.183688, 0.000000>, <0.695573, 0.435798, 0.000000>, <0.565685, 0.565685, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 0.000000, 0.000000>, <0.240000, 0.000000, 0.000000>, <0.560732, 0.000000, -0.018725>, <0.800000, 0.000000, 0.000000>, 
      <0.000000, 0.000000, 0.000000>, <0.240000, 0.000000, 0.000000>, <0.560732, -0.183688, -0.018725>, <0.800000, -0.183688, 0.000000>, 
      <0.000000, 0.000000, 0.000000>, <0.169706, -0.169706, 0.000000>, <0.526384, -0.266610, -0.018725>, <0.695573, -0.435798, 0.000000>, 
      <0.000000, 0.000000, 0.000000>, <0.169706, -0.169706, 0.000000>, <0.396497, -0.396497, -0.018725>, <0.565686, -0.565685, 0.000000>
    }
  }
  material {
    tirador_txt
  }
  scale 0.93
  rotate 90.0*x
  translate  <0.0, -6.768099, -3.67>
}
#declare cajonmesita = union {
  box { // cajon
    <-1, -1, -1>, <1, 1, 1>
    scale <15.81, 6.51, 1.76>
    translate  <0.0, -0.320072, -3.67>
  }
  object { sPatchObj3 }
  translate  -0.226599*y
}
#declare tornillohead2 = difference {
  cone { // Cone006
    <0,0,0>, 0.2, <0,0,1>, 1.0
  }
  box { // Cube015
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 1.2, 0.1>
    translate  0.917934*z
  }
}
#declare clavo = union {
  object { tornillohead2 }
  cone { // Cone007
    <0,0,0>, 0.2, <0,0,1>, 0.2
    scale <1.0, 1.0, 5.0>
    translate  -4.903144*z
  }
  material {
    tornillo_txt
  }
  scale 0.2
  translate  <14.616163, 8.035133, 35.605205>
}
union { // tocador
  object { mueblespejo }
  object { mesita }
  object { cajonmesita }
  object { clavo }
  material {
    mesa_txt_3
  }
}


box { // mesa
  <-1, -1, -1>, <1, 1, 1>
  material {
    mesa_txt_2
  }
  scale <75.0, 25.0, 1.0>
  translate  <0.0, -10.0, -10.855654>
}


box { // pared
  <-1, -1, -1>, <1, 1, 1>
  material {
    pared_txt
  }
  scale <100.0, 1.0, 100.0>
  translate  14.093002*y
}






#declare cesto = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000001, 5.396772, 1.149153>, <1.239154, 5.396772, 1.149153>, <2.939882, 4.692306, 1.149153>, <3.816095, 3.816093, 1.149153>, 
      <0.000001, 3.806656, 0.780223>, <1.239154, 3.806655, 0.780223>, <1.815499, 3.567925, 0.780223>, <2.691713, 2.691711, 0.780223>, 
      <0.000000, 1.619155, 0.662570>, <0.000097, 1.619132, 0.662570>, <1.144957, 1.144916, 0.662570>, <1.144916, 1.144916, 0.662570>, 
      <0.000000, 0.000176, 0.454034>, <0.000096, 0.000154, 0.454034>, <0.000041, 0.000176, 0.454034>, <0.000000, 0.000176, 0.454034>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.816094, 3.816095, 1.149153>, <-2.939880, 4.692309, 1.149153>, <-1.239152, 5.396772, 1.149153>, <0.000001, 5.396772, 1.149153>, 
      <-2.691712, 2.691713, 0.780223>, <-1.815498, 3.567927, 0.780223>, <-1.239153, 3.806656, 0.780223>, <0.000001, 3.806656, 0.780223>, 
      <-1.144916, 1.144916, 0.662570>, <-1.144831, 1.144967, 0.662570>, <0.000029, 1.619183, 0.662570>, <0.000000, 1.619155, 0.662570>, 
      <-0.000125, 0.000125, 0.454034>, <-0.000041, 0.000176, 0.454034>, <-0.000096, 0.000154, 0.454034>, <-0.000125, 0.000125, 0.454034>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-5.396772, 0.000000, 1.149153>, <-5.396772, 1.239153, 1.149153>, <-4.692308, 2.939881, 1.149153>, <-3.816094, 3.816095, 1.149153>, 
      <-3.806656, -0.000000, 0.780223>, <-3.806656, 1.239153, 0.780223>, <-3.567926, 1.815499, 0.780223>, <-2.691712, 2.691713, 0.780223>, 
      <-1.619155, 0.000000, 0.662570>, <-1.619132, 0.000096, 0.662570>, <-1.144916, 1.144957, 0.662570>, <-1.144916, 1.144916, 0.662570>, 
      <-0.000176, 0.000000, 0.454034>, <-0.000154, 0.000096, 0.454034>, <-0.000176, 0.000041, 0.454034>, <-0.000176, 0.000000, 0.454034>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.816095, -3.816094, 1.149153>, <-4.692308, -2.939880, 1.149153>, <-5.396772, -1.239153, 1.149153>, <-5.396772, 0.000000, 1.149153>, 
      <-2.691713, -2.691712, 0.780223>, <-3.567926, -1.815498, 0.780223>, <-3.806656, -1.239153, 0.780223>, <-3.806656, -0.000000, 0.780223>, 
      <-1.144916, -1.144916, 0.662570>, <-1.144967, -1.144831, 0.662570>, <-1.619183, 0.000029, 0.662570>, <-1.619155, 0.000000, 0.662570>, 
      <-0.000125, -0.000125, 0.454034>, <-0.000176, -0.000041, 0.454034>, <-0.000154, -0.000096, 0.454034>, <-0.000125, -0.000125, 0.454034>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -5.396772, 1.149153>, <-1.239153, -5.396772, 1.149153>, <-2.939881, -4.692308, 1.149153>, <-3.816095, -3.816094, 1.149153>, 
      <0.000000, -3.806656, 0.780223>, <-1.239153, -3.806656, 0.780223>, <-1.815499, -3.567926, 0.780223>, <-2.691713, -2.691712, 0.780223>, 
      <0.000000, -1.619155, 0.662570>, <-0.000096, -1.619132, 0.662570>, <-1.144957, -1.144916, 0.662570>, <-1.144916, -1.144916, 0.662570>, 
      <0.000000, -0.000176, 0.454034>, <-0.000096, -0.000154, 0.454034>, <-0.000041, -0.000176, 0.454034>, <0.000000, -0.000176, 0.454034>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.816094, -3.816094, 1.149153>, <2.939880, -4.692308, 1.149153>, <1.239153, -5.396772, 1.149153>, <0.000000, -5.396772, 1.149153>, 
      <2.691712, -2.691712, 0.780223>, <1.815498, -3.567926, 0.780223>, <1.239153, -3.806656, 0.780223>, <0.000000, -3.806656, 0.780223>, 
      <1.144916, -1.144916, 0.662570>, <1.144831, -1.144967, 0.662570>, <-0.000029, -1.619183, 0.662570>, <0.000000, -1.619155, 0.662570>, 
      <0.000125, -0.000125, 0.454034>, <0.000041, -0.000176, 0.454034>, <0.000096, -0.000154, 0.454034>, <0.000125, -0.000125, 0.454034>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000001, 6.510523, 1.964530>, <1.494882, 6.510522, 1.964530>, <3.546594, 5.660674, 1.964530>, <4.603635, 4.603633, 1.964530>, 
      <0.000001, 6.227742, 1.662023>, <1.494882, 6.227741, 1.662023>, <3.346637, 5.460718, 1.662024>, <4.403678, 4.403677, 1.662024>, 
      <0.000001, 5.800153, 1.242743>, <1.239154, 5.800152, 1.242743>, <3.225115, 4.977540, 1.242743>, <4.101328, 4.101326, 1.242743>, 
      <0.000001, 5.396772, 1.149153>, <1.239154, 5.396772, 1.149153>, <2.939882, 4.692306, 1.149153>, <3.816095, 3.816093, 1.149153>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-4.603634, 4.603635, 1.964530>, <-3.546593, 5.660676, 1.964530>, <-1.494881, 6.510523, 1.964530>, <0.000001, 6.510523, 1.964530>, 
      <-4.403678, 4.403679, 1.662024>, <-3.346636, 5.460720, 1.662024>, <-1.494881, 6.227742, 1.662023>, <0.000001, 6.227742, 1.662023>, 
      <-4.101327, 4.101328, 1.242743>, <-3.225113, 4.977542, 1.242743>, <-1.239152, 5.800153, 1.242743>, <0.000001, 5.800153, 1.242743>, 
      <-3.816094, 3.816095, 1.149153>, <-2.939880, 4.692309, 1.149153>, <-1.239152, 5.396772, 1.149153>, <0.000001, 5.396772, 1.149153>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-6.510523, 0.000001, 1.964530>, <-6.510523, 1.494882, 1.964530>, <-5.660675, 3.546594, 1.964530>, <-4.603634, 4.603635, 1.964530>, 
      <-6.227742, 0.000001, 1.662023>, <-6.227742, 1.494882, 1.662023>, <-5.460719, 3.346638, 1.662024>, <-4.403678, 4.403679, 1.662024>, 
      <-5.800153, 0.000000, 1.242743>, <-5.800153, 1.239154, 1.242743>, <-4.977541, 3.225115, 1.242743>, <-4.101327, 4.101328, 1.242743>, 
      <-5.396772, 0.000000, 1.149153>, <-5.396772, 1.239153, 1.149153>, <-4.692308, 2.939881, 1.149153>, <-3.816094, 3.816095, 1.149153>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-4.603635, -4.603635, 1.964530>, <-5.660676, -3.546594, 1.964530>, <-6.510523, -1.494881, 1.964530>, <-6.510523, 0.000001, 1.964530>, 
      <-4.403678, -4.403678, 1.662024>, <-5.460720, -3.346637, 1.662024>, <-6.227742, -1.494881, 1.662023>, <-6.227742, 0.000001, 1.662023>, 
      <-4.101328, -4.101327, 1.242743>, <-4.977542, -3.225113, 1.242743>, <-5.800153, -1.239153, 1.242743>, <-5.800153, 0.000000, 1.242743>, 
      <-3.816095, -3.816094, 1.149153>, <-4.692308, -2.939880, 1.149153>, <-5.396772, -1.239153, 1.149153>, <-5.396772, 0.000000, 1.149153>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -6.510523, 1.964530>, <-1.494882, -6.510523, 1.964530>, <-3.546594, -5.660676, 1.964530>, <-4.603635, -4.603635, 1.964530>, 
      <0.000000, -6.227742, 1.662023>, <-1.494882, -6.227742, 1.662023>, <-3.346638, -5.460720, 1.662024>, <-4.403678, -4.403678, 1.662024>, 
      <0.000000, -5.800153, 1.242743>, <-1.239153, -5.800153, 1.242743>, <-3.225115, -4.977540, 1.242743>, <-4.101328, -4.101327, 1.242743>, 
      <0.000000, -5.396772, 1.149153>, <-1.239153, -5.396772, 1.149153>, <-2.939881, -4.692308, 1.149153>, <-3.816095, -3.816094, 1.149153>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.603635, -4.603635, 1.964530>, <3.546594, -5.660676, 1.964530>, <1.494882, -6.510523, 1.964530>, <0.000000, -6.510523, 1.964530>, 
      <4.403678, -4.403678, 1.662023>, <3.346637, -5.460720, 1.662023>, <1.494882, -6.227742, 1.662023>, <0.000000, -6.227742, 1.662023>, 
      <4.101328, -4.101328, 1.242743>, <3.225114, -4.977541, 1.242743>, <1.239153, -5.800153, 1.242743>, <0.000000, -5.800153, 1.242743>, 
      <3.816094, -3.816094, 1.149153>, <2.939880, -4.692308, 1.149153>, <1.239153, -5.396772, 1.149153>, <0.000000, -5.396772, 1.149153>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000001, 7.132913, 3.006400>, <1.637790, 7.132913, 3.006400>, <3.885641, 6.201820, 3.006400>, <5.043732, 5.043729, 3.006400>, 
      <0.000001, 7.023255, 2.659222>, <1.637790, 7.023255, 2.659222>, <3.808101, 6.124280, 2.659222>, <4.966192, 4.966189, 2.659222>, 
      <0.000001, 6.759152, 2.230502>, <1.494882, 6.759151, 2.230502>, <3.722401, 5.836481, 2.230502>, <4.779442, 4.779440, 2.230502>, 
      <0.000001, 6.510523, 1.964530>, <1.494882, 6.510522, 1.964530>, <3.546594, 5.660674, 1.964530>, <4.603635, 4.603633, 1.964530>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-5.043731, 5.043732, 3.006400>, <-3.885640, 6.201824, 3.006400>, <-1.637788, 7.132914, 3.006400>, <0.000001, 7.132913, 3.006400>, 
      <-4.966191, 4.966192, 2.659222>, <-3.808100, 6.124284, 2.659222>, <-1.637788, 7.023256, 2.659222>, <0.000001, 7.023255, 2.659222>, 
      <-4.779441, 4.779442, 2.230503>, <-3.722400, 5.836483, 2.230503>, <-1.494881, 6.759153, 2.230502>, <0.000001, 6.759152, 2.230502>, 
      <-4.603634, 4.603635, 1.964530>, <-3.546593, 5.660676, 1.964530>, <-1.494881, 6.510523, 1.964530>, <0.000001, 6.510523, 1.964530>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-7.132913, 0.000001, 3.006400>, <-7.132913, 1.637790, 3.006400>, <-6.201823, 3.885641, 3.006400>, <-5.043731, 5.043732, 3.006400>, 
      <-7.023255, 0.000001, 2.659222>, <-7.023255, 1.637790, 2.659222>, <-6.124283, 3.808101, 2.659222>, <-4.966191, 4.966192, 2.659222>, 
      <-6.759152, 0.000001, 2.230502>, <-6.759152, 1.494883, 2.230502>, <-5.836482, 3.722402, 2.230503>, <-4.779441, 4.779442, 2.230503>, 
      <-6.510523, 0.000001, 1.964530>, <-6.510523, 1.494882, 1.964530>, <-5.660675, 3.546594, 1.964530>, <-4.603634, 4.603635, 1.964530>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-5.043732, -5.043731, 3.006400>, <-6.201824, -3.885640, 3.006400>, <-7.132913, -1.637788, 3.006400>, <-7.132913, 0.000001, 3.006400>, 
      <-4.966192, -4.966191, 2.659222>, <-6.124284, -3.808100, 2.659222>, <-7.023255, -1.637788, 2.659222>, <-7.023255, 0.000001, 2.659222>, 
      <-4.779442, -4.779442, 2.230502>, <-5.836484, -3.722401, 2.230502>, <-6.759152, -1.494881, 2.230502>, <-6.759152, 0.000001, 2.230502>, 
      <-4.603635, -4.603635, 1.964530>, <-5.660676, -3.546594, 1.964530>, <-6.510523, -1.494881, 1.964530>, <-6.510523, 0.000001, 1.964530>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -7.132913, 3.006400>, <-1.637789, -7.132913, 3.006400>, <-3.885641, -6.201823, 3.006400>, <-5.043732, -5.043731, 3.006400>, 
      <0.000000, -7.023255, 2.659222>, <-1.637789, -7.023255, 2.659222>, <-3.808101, -6.124283, 2.659222>, <-4.966192, -4.966191, 2.659222>, 
      <0.000000, -6.759152, 2.230502>, <-1.494882, -6.759152, 2.230502>, <-3.722402, -5.836484, 2.230502>, <-4.779442, -4.779442, 2.230502>, 
      <0.000000, -6.510523, 1.964530>, <-1.494882, -6.510523, 1.964530>, <-3.546594, -5.660676, 1.964530>, <-4.603635, -4.603635, 1.964530>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <5.043731, -5.043731, 3.006400>, <3.885640, -6.201823, 3.006400>, <1.637789, -7.132913, 3.006400>, <0.000000, -7.132913, 3.006400>, 
      <4.966191, -4.966191, 2.659222>, <3.808100, -6.124283, 2.659222>, <1.637789, -7.023255, 2.659222>, <0.000000, -7.023255, 2.659222>, 
      <4.779442, -4.779442, 2.230502>, <3.722401, -5.836484, 2.230502>, <1.494882, -6.759152, 2.230502>, <0.000000, -6.759152, 2.230502>, 
      <4.603635, -4.603635, 1.964530>, <3.546594, -5.660676, 1.964530>, <1.494882, -6.510523, 1.964530>, <0.000000, -6.510523, 1.964530>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000001, 7.755303, 5.905518>, <1.780697, 7.755302, 5.905518>, <4.224686, 6.742968, 5.905518>, <5.483828, 5.483825, 5.905518>, 
      <0.000001, 7.587695, 5.031898>, <1.780697, 7.587695, 5.031898>, <4.106170, 6.624451, 5.031898>, <5.365312, 5.365309, 5.031898>, 
      <0.000001, 7.400835, 3.854646>, <1.637790, 7.400835, 3.854646>, <4.075090, 6.391270, 3.854646>, <5.233182, 5.233179, 3.854646>, 
      <0.000001, 7.132913, 3.006400>, <1.637790, 7.132913, 3.006400>, <3.885641, 6.201820, 3.006400>, <5.043732, 5.043729, 3.006400>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-5.483827, 5.483828, 5.905518>, <-4.224685, 6.742970, 5.905518>, <-1.780695, 7.755303, 5.905518>, <0.000001, 7.755303, 5.905518>, 
      <-5.365311, 5.365312, 5.031898>, <-4.106169, 6.624454, 5.031898>, <-1.780695, 7.587696, 5.031898>, <0.000001, 7.587695, 5.031898>, 
      <-5.233181, 5.233182, 3.854646>, <-4.075090, 6.391274, 3.854646>, <-1.637788, 7.400836, 3.854646>, <0.000001, 7.400835, 3.854646>, 
      <-5.043731, 5.043732, 3.006400>, <-3.885640, 6.201824, 3.006400>, <-1.637788, 7.132914, 3.006400>, <0.000001, 7.132913, 3.006400>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-7.755303, 0.000001, 5.905518>, <-7.755303, 1.780697, 5.905518>, <-6.742970, 4.224686, 5.905518>, <-5.483827, 5.483828, 5.905518>, 
      <-7.587695, 0.000001, 5.031898>, <-7.587695, 1.780697, 5.031898>, <-6.624454, 4.106170, 5.031898>, <-5.365311, 5.365312, 5.031898>, 
      <-7.400835, 0.000001, 3.854646>, <-7.400835, 1.637790, 3.854646>, <-6.391272, 4.075090, 3.854646>, <-5.233181, 5.233182, 3.854646>, 
      <-7.132913, 0.000001, 3.006400>, <-7.132913, 1.637790, 3.006400>, <-6.201823, 3.885641, 3.006400>, <-5.043731, 5.043732, 3.006400>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-5.483828, -5.483827, 5.905518>, <-6.742970, -4.224685, 5.905518>, <-7.755303, -1.780695, 5.905518>, <-7.755303, 0.000001, 5.905518>, 
      <-5.365312, -5.365311, 5.031898>, <-6.624454, -4.106169, 5.031898>, <-7.587695, -1.780695, 5.031898>, <-7.587695, 0.000001, 5.031898>, 
      <-5.233182, -5.233181, 3.854646>, <-6.391274, -4.075090, 3.854646>, <-7.400835, -1.637788, 3.854646>, <-7.400835, 0.000001, 3.854646>, 
      <-5.043732, -5.043731, 3.006400>, <-6.201824, -3.885640, 3.006400>, <-7.132913, -1.637788, 3.006400>, <-7.132913, 0.000001, 3.006400>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -7.755303, 5.905518>, <-1.780696, -7.755303, 5.905518>, <-4.224686, -6.742970, 5.905518>, <-5.483828, -5.483827, 5.905518>, 
      <0.000000, -7.587695, 5.031898>, <-1.780696, -7.587695, 5.031898>, <-4.106170, -6.624454, 5.031898>, <-5.365312, -5.365311, 5.031898>, 
      <0.000000, -7.400835, 3.854646>, <-1.637789, -7.400835, 3.854646>, <-4.075090, -6.391272, 3.854646>, <-5.233182, -5.233181, 3.854646>, 
      <0.000000, -7.132913, 3.006400>, <-1.637789, -7.132913, 3.006400>, <-3.885641, -6.201823, 3.006400>, <-5.043732, -5.043731, 3.006400>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <5.483827, -5.483827, 5.905518>, <4.224685, -6.742969, 5.905518>, <1.780696, -7.755303, 5.905518>, <0.000000, -7.755303, 5.905518>, 
      <5.365311, -5.365311, 5.031898>, <4.106169, -6.624453, 5.031898>, <1.780696, -7.587695, 5.031898>, <0.000000, -7.587695, 5.031898>, 
      <5.233181, -5.233181, 3.854646>, <4.075090, -6.391272, 3.854646>, <1.637789, -7.400835, 3.854646>, <0.000000, -7.400835, 3.854646>, 
      <5.043731, -5.043731, 3.006400>, <3.885640, -6.201823, 3.006400>, <1.637789, -7.132913, 3.006400>, <0.000000, -7.132913, 3.006400>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000001, 7.984604, 7.445673>, <1.833346, 7.984603, 7.445673>, <4.349597, 6.942337, 7.445673>, <5.645968, 5.645966, 7.445673>, 
      <0.000001, 7.915814, 6.983626>, <1.833346, 7.915813, 6.983626>, <4.300955, 6.893695, 6.983626>, <5.597326, 5.597324, 6.983626>, 
      <0.000001, 7.843320, 6.364290>, <1.780697, 7.843319, 6.364290>, <4.286924, 6.805206, 6.364290>, <5.546065, 5.546063, 6.364290>, 
      <0.000001, 7.755303, 5.905518>, <1.780697, 7.755302, 5.905518>, <4.224686, 6.742968, 5.905518>, <5.483828, 5.483825, 5.905518>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-5.645967, 5.645968, 7.445673>, <-4.349596, 6.942339, 7.445673>, <-1.833345, 7.984604, 7.445673>, <0.000001, 7.984604, 7.445673>, 
      <-5.597325, 5.597326, 6.983626>, <-4.300953, 6.893697, 6.983626>, <-1.833345, 7.915814, 6.983626>, <0.000001, 7.915814, 6.983626>, 
      <-5.546064, 5.546065, 6.364290>, <-4.286922, 6.805207, 6.364290>, <-1.780695, 7.843320, 6.364290>, <0.000001, 7.843320, 6.364290>, 
      <-5.483827, 5.483828, 5.905518>, <-4.224685, 6.742970, 5.905518>, <-1.780695, 7.755303, 5.905518>, <0.000001, 7.755303, 5.905518>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-7.984604, 0.000001, 7.445673>, <-7.984604, 1.833346, 7.445673>, <-6.942338, 4.349597, 7.445673>, <-5.645967, 5.645968, 7.445673>, 
      <-7.915814, 0.000001, 6.983626>, <-7.915814, 1.833346, 6.983626>, <-6.893696, 4.300955, 6.983626>, <-5.597325, 5.597326, 6.983626>, 
      <-7.843320, 0.000001, 6.364290>, <-7.843320, 1.780697, 6.364290>, <-6.805206, 4.286924, 6.364290>, <-5.546064, 5.546065, 6.364290>, 
      <-7.755303, 0.000001, 5.905518>, <-7.755303, 1.780697, 5.905518>, <-6.742970, 4.224686, 5.905518>, <-5.483827, 5.483828, 5.905518>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-5.645968, -5.645967, 7.445673>, <-6.942339, -4.349596, 7.445673>, <-7.984604, -1.833345, 7.445673>, <-7.984604, 0.000001, 7.445673>, 
      <-5.597326, -5.597325, 6.983626>, <-6.893697, -4.300954, 6.983626>, <-7.915814, -1.833345, 6.983626>, <-7.915814, 0.000001, 6.983626>, 
      <-5.546065, -5.546064, 6.364290>, <-6.805207, -4.286922, 6.364290>, <-7.843320, -1.780695, 6.364290>, <-7.843320, 0.000001, 6.364290>, 
      <-5.483828, -5.483827, 5.905518>, <-6.742970, -4.224685, 5.905518>, <-7.755303, -1.780695, 5.905518>, <-7.755303, 0.000001, 5.905518>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -7.984604, 7.445673>, <-1.833346, -7.984604, 7.445673>, <-4.349597, -6.942338, 7.445673>, <-5.645968, -5.645967, 7.445673>, 
      <0.000000, -7.915814, 6.983626>, <-1.833346, -7.915814, 6.983626>, <-4.300955, -6.893696, 6.983626>, <-5.597326, -5.597325, 6.983626>, 
      <0.000000, -7.843320, 6.364290>, <-1.780696, -7.843320, 6.364290>, <-4.286923, -6.805206, 6.364290>, <-5.546065, -5.546064, 6.364290>, 
      <0.000000, -7.755303, 5.905518>, <-1.780696, -7.755303, 5.905518>, <-4.224686, -6.742970, 5.905518>, <-5.483828, -5.483827, 5.905518>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <5.645967, -5.645967, 7.445673>, <4.349596, -6.942338, 7.445673>, <1.833345, -7.984604, 7.445673>, <0.000000, -7.984604, 7.445673>, 
      <5.597325, -5.597325, 6.983626>, <4.300954, -6.893696, 6.983626>, <1.833345, -7.915814, 6.983626>, <0.000000, -7.915814, 6.983626>, 
      <5.546064, -5.546064, 6.364290>, <4.286922, -6.805206, 6.364290>, <1.780696, -7.843320, 6.364290>, <0.000000, -7.843320, 6.364290>, 
      <5.483827, -5.483827, 5.905518>, <4.224685, -6.742969, 5.905518>, <1.780696, -7.755303, 5.905518>, <0.000000, -7.755303, 5.905518>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <5.396772, 0.000000, 1.149153>, <5.396772, -1.239153, 1.149153>, <4.692308, -2.939880, 1.149153>, <3.816094, -3.816094, 1.149153>, 
      <3.806656, 0.000000, 0.780223>, <3.806656, -1.239153, 0.780223>, <3.567926, -1.815498, 0.780223>, <2.691712, -2.691712, 0.780223>, 
      <1.619155, 0.000000, 0.662570>, <1.619132, -0.000096, 0.662570>, <1.144916, -1.144956, 0.662570>, <1.144916, -1.144916, 0.662570>, 
      <0.000176, 0.000000, 0.454034>, <0.000154, -0.000096, 0.454034>, <0.000176, -0.000041, 0.454034>, <0.000176, 0.000000, 0.454034>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <5.396772, 0.000000, 1.149153>, <3.806656, 0.000000, 0.780223>, <1.619155, 0.000000, 0.662570>, <0.000125, 0.000125, 0.454034>, 
      <5.396772, 1.239153, 1.149153>, <3.806656, 1.239153, 0.780223>, <1.619183, -0.000029, 0.662570>, <0.000154, 0.000096, 0.454034>, 
      <4.692308, 2.939880, 1.149153>, <3.567926, 1.815498, 0.780223>, <1.144967, 1.144831, 0.662570>, <0.000176, 0.000041, 0.454034>, 
      <3.816095, 3.816093, 1.149153>, <2.691713, 2.691711, 0.780223>, <1.144916, 1.144916, 0.662570>, <0.000125, 0.000125, 0.454034>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <6.510523, 0.000000, 1.964530>, <6.510523, -1.494882, 1.964530>, <5.660676, -3.546594, 1.964530>, <4.603635, -4.603635, 1.964530>, 
      <6.227742, 0.000000, 1.662023>, <6.227742, -1.494882, 1.662023>, <5.460720, -3.346637, 1.662023>, <4.403678, -4.403678, 1.662023>, 
      <5.800153, 0.000000, 1.242743>, <5.800153, -1.239153, 1.242743>, <4.977541, -3.225114, 1.242743>, <4.101328, -4.101328, 1.242743>, 
      <5.396772, 0.000000, 1.149153>, <5.396772, -1.239153, 1.149153>, <4.692308, -2.939880, 1.149153>, <3.816094, -3.816094, 1.149153>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <6.510523, 0.000000, 1.964530>, <6.227742, 0.000000, 1.662023>, <5.800153, 0.000000, 1.242743>, <5.396772, 0.000000, 1.149153>, 
      <6.510523, 1.494881, 1.964530>, <6.227742, 1.494881, 1.662023>, <5.800153, 1.239153, 1.242743>, <5.396772, 1.239153, 1.149153>, 
      <5.660676, 3.546592, 1.964530>, <5.460719, 3.346636, 1.662024>, <4.977542, 3.225113, 1.242743>, <4.692308, 2.939880, 1.149153>, 
      <4.603635, 4.603633, 1.964530>, <4.403678, 4.403677, 1.662024>, <4.101328, 4.101326, 1.242743>, <3.816095, 3.816093, 1.149153>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <7.132913, 0.000000, 3.006400>, <7.132913, -1.637789, 3.006400>, <6.201823, -3.885640, 3.006400>, <5.043731, -5.043731, 3.006400>, 
      <7.023255, 0.000000, 2.659222>, <7.023255, -1.637789, 2.659222>, <6.124283, -3.808100, 2.659222>, <4.966191, -4.966191, 2.659222>, 
      <6.759152, 0.000000, 2.230502>, <6.759152, -1.494882, 2.230502>, <5.836484, -3.722401, 2.230502>, <4.779442, -4.779442, 2.230502>, 
      <6.510523, 0.000000, 1.964530>, <6.510523, -1.494882, 1.964530>, <5.660676, -3.546594, 1.964530>, <4.603635, -4.603635, 1.964530>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <7.132913, 0.000000, 3.006400>, <7.023255, 0.000000, 2.659222>, <6.759152, 0.000000, 2.230502>, <6.510523, 0.000000, 1.964530>, 
      <7.132913, 1.637788, 3.006400>, <7.023255, 1.637788, 2.659222>, <6.759152, 1.494881, 2.230502>, <6.510523, 1.494881, 1.964530>, 
      <6.201823, 3.885638, 3.006400>, <6.124283, 3.808098, 2.659222>, <5.836483, 3.722399, 2.230502>, <5.660676, 3.546592, 1.964530>, 
      <5.043732, 5.043729, 3.006400>, <4.966192, 4.966189, 2.659222>, <4.779442, 4.779440, 2.230502>, <4.603635, 4.603633, 1.964530>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <7.755303, 0.000000, 5.905518>, <7.755303, -1.780696, 5.905518>, <6.742969, -4.224685, 5.905518>, <5.483827, -5.483827, 5.905518>, 
      <7.587695, 0.000000, 5.031898>, <7.587695, -1.780696, 5.031898>, <6.624453, -4.106169, 5.031898>, <5.365311, -5.365311, 5.031898>, 
      <7.400835, 0.000000, 3.854646>, <7.400835, -1.637789, 3.854646>, <6.391272, -4.075090, 3.854646>, <5.233181, -5.233181, 3.854646>, 
      <7.132913, 0.000000, 3.006400>, <7.132913, -1.637789, 3.006400>, <6.201823, -3.885640, 3.006400>, <5.043731, -5.043731, 3.006400>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <7.755303, 0.000000, 5.905518>, <7.587695, 0.000000, 5.031898>, <7.400835, 0.000000, 3.854646>, <7.132913, 0.000000, 3.006400>, 
      <7.755303, 1.780695, 5.905518>, <7.587695, 1.780695, 5.031898>, <7.400835, 1.637788, 3.854646>, <7.132913, 1.637788, 3.006400>, 
      <6.742970, 4.224684, 5.905518>, <6.624454, 4.106167, 5.031898>, <6.391273, 4.075088, 3.854646>, <6.201823, 3.885638, 3.006400>, 
      <5.483828, 5.483825, 5.905518>, <5.365312, 5.365309, 5.031898>, <5.233182, 5.233179, 3.854646>, <5.043732, 5.043729, 3.006400>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <7.984604, 0.000000, 7.445673>, <7.984604, -1.833345, 7.445673>, <6.942338, -4.349596, 7.445673>, <5.645967, -5.645967, 7.445673>, 
      <7.915814, 0.000000, 6.983626>, <7.915814, -1.833345, 6.983626>, <6.893696, -4.300954, 6.983626>, <5.597325, -5.597325, 6.983626>, 
      <7.843320, 0.000000, 6.364290>, <7.843320, -1.780696, 6.364290>, <6.805206, -4.286922, 6.364290>, <5.546064, -5.546064, 6.364290>, 
      <7.755303, 0.000000, 5.905518>, <7.755303, -1.780696, 5.905518>, <6.742969, -4.224685, 5.905518>, <5.483827, -5.483827, 5.905518>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <7.984604, 0.000000, 7.445673>, <7.915814, 0.000000, 6.983626>, <7.843320, 0.000000, 6.364290>, <7.755303, 0.000000, 5.905518>, 
      <7.984604, 1.833345, 7.445673>, <7.915814, 1.833345, 6.983626>, <7.843320, 1.780695, 6.364290>, <7.755303, 1.780695, 5.905518>, 
      <6.942338, 4.349595, 7.445673>, <6.893696, 4.300953, 6.983626>, <6.805206, 4.286922, 6.364290>, <6.742970, 4.224684, 5.905518>, 
      <5.645968, 5.645966, 7.445673>, <5.597326, 5.597324, 6.983626>, <5.546065, 5.546063, 6.364290>, <5.483828, 5.483825, 5.905518>
    }
  }
  material {
    cesto_mapa_txt
  }
}
#declare Blob001 = blob {
  threshold 0.6
  sphere { <0.0, 0.0, 2.0>, 1.053149, 1.0 }

  sphere { <-0.5, 0.0, 1.5>, 1.053149, 1.0 }

  sphere { <-0.5, 0.0, 1.0>, 1.053149, 1.0 }

  sphere { <-0.5, 0.0, 0.5>, 1.053149, 1.0 }

  sphere { <0.0, 0.0, 0.0>, 1.053149, 1.0 }

  sphere { <0.5, 0.0, 0.5>, 1.053149, 1.0 }

  sphere { <0.5, 0.0, 1.0>, 1.053149, 1.0 }

  sphere { <0.5, 0.0, 1.5>, 1.053149, 1.0 }

  sphere { <0.478947, 0.532283, 0.0>, 0.298973, -1.0 }

  sphere { <0.478947, 0.532283, 0.975633>, 0.298973, -1.0 }

  sphere { <-0.514425, 0.532283, 1.472319>, 0.298973, -1.0 }

  sphere { <0.124171, 0.603254, 0.478947>, 0.298973, -1.0 }

  sphere { <-0.942888, 0.248399, 0.266918>, 0.298973, 1.0 }

  material {
    corteza_bas_txt
  }
  scale 3.5
  rotate <90.0, 0.0, 180.0>
  translate  <0.207, 0.0, 19.354496>
}

#declare pan = difference {
  object { Blob001 }
  sphere { // Sphere002
    <0,0,0>,1
    scale 2.0
    translate  <1.566824, 0.189088, 19.256382>
  }
  sphere { // Sphere001
    <0,0,0>,1
    scale 2.0
    translate  <-1.455473, -0.91048, 19.312467>
  }
  sphere { // Sphere003
    <0,0,0>,1
    scale 2.0
    rotate <1.631468, 0.0, 0.0>
    translate  <-0.18422, -0.93367, 19.391281>
  }
  material {
    miga_bas_txt
  }
  scale 1.25
  rotate <-32.775696, 11.03687, -6.598987>
  translate  <-5.715313, -17.559884, -12.100626>
}
union { // cesta_de_pan
  object { cesto }
  torus { // borde_cesto
    8.0, 0.25  rotate -x*90
    scale <1.0, 1.0, 1.3>
    translate  7.466549*z
  }
  object { pan }
  cylinder { // Cylndr028
    <0,0,1>, <0,0,0>, 1 
    scale <0.0625, 0.0625, 25.75>
    rotate <-62.528179, 12.99757, -10.565242>
    translate  <-6.112767, -4.778277, 7.507886>
  }
  cylinder { // Cylndr029
    <0,0,1>, <0,0,0>, 1 
    scale <0.0625, 0.0625, 17.5>
    rotate <-49.029469, -3.665522, 18.144852>
    translate  <6.163574, 5.14823, 7.689878>
  }
  torus { // Torus002
    0.5, 0.075  rotate -x*90
    material {
      bordecesto_txt
    }
    scale 1.25
    rotate <1.567179, 11.03687, -6.598987>
    translate  <0.89747, 18.027354, 19.168759>
  }
  material {
    bordecesto_txt
  }
  scale 0.8
  rotate <30.505976, -12.838174, -0.0>
  translate  <18.559416, 3.153685, 14.493027>
}


#declare HgtFld001 = object { 
  height_field {
    tga "C:\ARCHIVOS DE PROGRAMA\MORAY FOR WINDOWS\Maps\cepilloespejo.tga"
    water_level 0.2857
    smooth
  }
  rotate    <-90, 0, 0> // Turn onto XY plane. Now points along -Z
  scale     <  2, 2,-2> // Scale to Cube size. Now points along +Z
  translate < -1,-1,-1> // Center around origin
  material {
    pelo_cepillo_basico_txt
  }
  scale <4.7, 3.55, 1.75>
  translate  <5.558033, 0.0, 1.139972>
}
#declare peine = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <8.007272, -0.021001, 3.344402>, <7.916335, -0.022594, 2.342661>, <7.854405, -0.024643, 1.000399>, <7.704149, -0.026161, 0.006249>, 
      <8.007272, -0.021020, 3.344239>, <7.916335, -0.022613, 2.342497>, <7.877499, 0.034735, 2.058237>, <7.727243, 0.033217, 1.064087>, 
      <8.007272, -0.021046, 3.344107>, <7.939430, 0.036848, 3.400921>, <7.847596, 0.067828, 2.136344>, <7.754536, 0.103387, 2.171020>, 
      <8.007272, -0.021065, 3.343980>, <7.939430, 0.036829, 3.400794>, <7.874190, 0.136205, 3.497701>, <7.781130, 0.171765, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <8.007272, -0.021065, 3.343980>, <7.939430, -0.078193, 3.400794>, <7.873961, -0.176343, 3.497786>, <7.781130, -0.211346, 3.532377>, 
      <8.007272, -0.021084, 3.344107>, <7.939430, -0.078212, 3.400921>, <7.847367, -0.112370, 2.136482>, <7.754537, -0.147373, 2.171073>, 
      <8.007272, -0.021109, 3.344239>, <7.916335, -0.022575, 2.342497>, <7.877499, -0.080199, 2.058237>, <7.727243, -0.081716, 1.064087>, 
      <8.007272, -0.021128, 3.344402>, <7.916335, -0.022594, 2.342661>, <7.854405, -0.024643, 1.000399>, <7.704149, -0.026161, 0.006249>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <8.007272, -0.021128, 3.344402>, <7.939430, -0.078193, 3.525223>, <7.811936, -0.199729, 3.895428>, <7.781130, -0.211345, 3.946842>, 
      <8.007272, -0.021134, 3.344451>, <7.939430, -0.078199, 3.525272>, <7.811936, -0.249508, 3.841576>, <7.781130, -0.261123, 3.892990>, 
      <8.007272, -0.021163, 3.344494>, <7.939430, -0.078228, 3.400760>, <7.877082, -0.183850, 3.657538>, <7.784252, -0.218853, 3.692128>, 
      <8.007272, -0.021128, 3.344529>, <7.939430, -0.078193, 3.400794>, <7.873961, -0.176343, 3.497786>, <7.781130, -0.211346, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <8.007272, -0.021128, 3.344529>, <7.939430, 0.036829, 3.525223>, <7.811954, 0.159987, 3.895398>, <7.781130, 0.171765, 3.946842>, 
      <8.007272, -0.021093, 3.344563>, <7.939430, 0.036864, 3.525257>, <7.811954, 0.113974, 3.945176>, <7.781130, 0.125752, 3.996620>, 
      <8.007272, -0.021036, 3.344563>, <7.939430, -0.078228, 3.525257>, <7.811936, -0.153717, 3.945206>, <7.781130, -0.165332, 3.996620>, 
      <8.007272, -0.021001, 3.344529>, <7.939430, -0.078193, 3.525223>, <7.811936, -0.199729, 3.895428>, <7.781130, -0.211345, 3.946842>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <8.007272, -0.021001, 3.344529>, <8.007272, -0.020995, 3.344451>, <8.007272, -0.020966, 3.344494>, <8.007272, -0.021001, 3.344402>, 
      <7.939430, 0.036829, 3.525223>, <7.939430, 0.036834, 3.525144>, <7.939430, 0.036863, 3.400887>, <7.939430, 0.036829, 3.400794>, 
      <7.811954, 0.159987, 3.895398>, <7.811954, 0.209765, 3.841545>, <7.877310, 0.144228, 3.657427>, <7.874190, 0.136205, 3.497701>, 
      <7.781130, 0.171765, 3.946842>, <7.781130, 0.221543, 3.892990>, <7.784251, 0.179788, 3.692103>, <7.781130, 0.171765, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <7.502806, -0.026161, 0.006249>, <7.502806, 0.033217, 1.064087>, <7.502806, 0.107301, 2.170893>, <7.502806, 0.171765, 3.532377>, 
      <7.509338, -0.026161, -0.053800>, <7.509338, 0.033217, 1.004039>, <7.586304, 0.107301, 2.170893>, <7.586304, 0.171765, 3.532377>, 
      <7.695122, -0.026252, -0.053475>, <7.718217, 0.033126, 1.004363>, <7.680874, 0.131535, 2.198468>, <7.707469, 0.199913, 3.559825>, 
      <7.704149, -0.026161, 0.006249>, <7.727243, 0.033217, 1.064087>, <7.754536, 0.103387, 2.171020>, <7.781130, 0.171765, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <7.502806, -0.211346, 3.532377>, <7.502806, -0.151036, 2.170970>, <7.502806, -0.081716, 1.064087>, <7.502806, -0.026161, 0.006249>, 
      <7.586304, -0.211346, 3.532377>, <7.586304, -0.151036, 2.170970>, <7.509338, -0.081716, 1.004039>, <7.509338, -0.026161, -0.053800>, 
      <7.707358, -0.239163, 3.559866>, <7.680765, -0.175190, 2.198562>, <7.718217, -0.081808, 1.004363>, <7.695122, -0.026252, -0.053475>, 
      <7.781130, -0.211346, 3.532377>, <7.754537, -0.147373, 2.171073>, <7.727243, -0.081716, 1.064087>, <7.704149, -0.026161, 0.006249>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <7.502806, -0.211345, 4.186476>, <7.502806, -0.269837, 4.086610>, <7.502806, -0.222518, 3.784572>, <7.502806, -0.211346, 3.532377>, 
      <7.529740, -0.211345, 4.166688>, <7.529740, -0.269837, 4.066822>, <7.586304, -0.222518, 3.784572>, <7.586304, -0.211346, 3.532377>, 
      <7.764267, -0.217704, 3.974988>, <7.764267, -0.267482, 3.921136>, <7.710479, -0.246670, 3.719617>, <7.707358, -0.239163, 3.559866>, 
      <7.781130, -0.211345, 3.946842>, <7.781130, -0.261123, 3.892990>, <7.784252, -0.218853, 3.692128>, <7.781130, -0.211346, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <7.502806, 0.171765, 4.186476>, <7.502806, 0.137506, 4.244968>, <7.502806, -0.177086, 4.244968>, <7.502806, -0.211345, 4.186476>, 
      <7.529740, 0.171765, 4.166688>, <7.529740, 0.137506, 4.225180>, <7.529740, -0.177086, 4.225180>, <7.529740, -0.211345, 4.166688>, 
      <7.764275, 0.178206, 3.974974>, <7.764275, 0.132193, 4.024753>, <7.764267, -0.171691, 4.024766>, <7.764267, -0.217704, 3.974988>, 
      <7.781130, 0.171765, 3.946842>, <7.781130, 0.125752, 3.996620>, <7.781130, -0.165332, 3.996620>, <7.781130, -0.211345, 3.946842>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <7.502806, 0.171765, 4.186476>, <7.529740, 0.171765, 4.166688>, <7.764275, 0.178206, 3.974974>, <7.781130, 0.171765, 3.946842>, 
      <7.502806, 0.230257, 4.086610>, <7.529740, 0.230257, 4.066822>, <7.764275, 0.227984, 3.921122>, <7.781130, 0.221543, 3.892990>, 
      <7.502806, 0.183704, 3.784536>, <7.586304, 0.183704, 3.784536>, <7.710589, 0.207935, 3.719551>, <7.784251, 0.179788, 3.692103>, 
      <7.502806, 0.171765, 3.532377>, <7.586304, 0.171765, 3.532377>, <7.707469, 0.199913, 3.559825>, <7.781130, 0.171765, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <7.346247, -0.026161, 3.296675>, <7.346247, 0.033217, 3.367386>, <7.346247, 0.148009, 3.415992>, <7.346247, 0.171765, 3.532377>, 
      <7.393214, -0.026161, 2.309547>, <7.393214, 0.033217, 2.380258>, <7.393214, 0.148009, 3.415992>, <7.393214, 0.171765, 3.532377>, 
      <7.395945, -0.026161, 0.988699>, <7.395945, 0.033217, 2.046537>, <7.455838, 0.107301, 2.170893>, <7.455838, 0.171765, 3.532377>, 
      <7.502806, -0.026161, 0.006249>, <7.502806, 0.033217, 1.064087>, <7.502806, 0.107301, 2.170893>, <7.502806, 0.171765, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <7.346247, -0.211346, 3.532377>, <7.346247, -0.189645, 3.418746>, <7.346247, -0.081716, 3.367386>, <7.346247, -0.026161, 3.296675>, 
      <7.393214, -0.211346, 3.532377>, <7.393214, -0.189645, 3.418746>, <7.393214, -0.081716, 2.380258>, <7.393214, -0.026161, 2.309547>, 
      <7.455838, -0.211346, 3.532377>, <7.455838, -0.151036, 2.170970>, <7.395945, -0.081716, 2.046537>, <7.395945, -0.026161, 0.988699>, 
      <7.502806, -0.211346, 3.532377>, <7.502806, -0.151036, 2.170970>, <7.502806, -0.081716, 1.064087>, <7.502806, -0.026161, 0.006249>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <7.346247, -0.211345, 4.266354>, <7.346247, -0.271438, 4.151226>, <7.346247, -0.264483, 3.810618>, <7.346247, -0.211346, 3.532377>, 
      <7.361130, -0.211345, 4.260496>, <7.361130, -0.271438, 4.145368>, <7.393214, -0.264483, 3.810618>, <7.393214, -0.211346, 3.532377>, 
      <7.489917, -0.211345, 4.195946>, <7.489917, -0.269837, 4.096080>, <7.455838, -0.222518, 3.784572>, <7.455838, -0.211346, 3.532377>, 
      <7.502806, -0.211345, 4.186476>, <7.502806, -0.269837, 4.086610>, <7.502806, -0.222518, 3.784572>, <7.502806, -0.211346, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <7.346247, 0.171765, 4.266354>, <7.346247, 0.140399, 4.326447>, <7.346247, -0.179979, 4.326447>, <7.346247, -0.211345, 4.266354>, 
      <7.361130, 0.171765, 4.260496>, <7.361130, 0.140399, 4.320589>, <7.361130, -0.179979, 4.320589>, <7.361130, -0.211345, 4.260496>, 
      <7.489917, 0.171765, 4.195946>, <7.489917, 0.137506, 4.254438>, <7.489917, -0.177086, 4.254438>, <7.489917, -0.211345, 4.195946>, 
      <7.502806, 0.171765, 4.186476>, <7.502806, 0.137506, 4.244968>, <7.502806, -0.177086, 4.244968>, <7.502806, -0.211345, 4.186476>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <7.346247, 0.171765, 4.266354>, <7.361130, 0.171765, 4.260496>, <7.489917, 0.171765, 4.195946>, <7.502806, 0.171765, 4.186476>, 
      <7.346247, 0.231858, 4.151226>, <7.361130, 0.231858, 4.145368>, <7.489917, 0.230257, 4.096080>, <7.502806, 0.230257, 4.086610>, 
      <7.346247, 0.228416, 3.809924>, <7.393214, 0.228416, 3.809924>, <7.455838, 0.183704, 3.784536>, <7.502806, 0.183704, 3.784536>, 
      <7.346247, 0.171765, 3.532377>, <7.393214, 0.171765, 3.532377>, <7.455838, 0.171765, 3.532377>, <7.502806, 0.171765, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.076230, -0.026161, 3.296675>, <4.021730, -0.026161, 2.307613>, <3.983868, -0.026161, -0.000197>, <3.894562, -0.026161, -0.000197>, 
      <4.076230, 0.033217, 3.367386>, <4.021730, 0.033217, 2.378324>, <3.983868, 0.069534, -0.000197>, <3.894562, 0.069534, -0.000197>, 
      <4.076230, 0.149753, 3.415650>, <4.021730, 0.149753, 3.415650>, <3.949062, 0.109648, 2.168298>, <3.894562, 0.109648, 2.168298>, 
      <4.076230, 0.171765, 3.532377>, <4.021730, 0.171765, 3.532377>, <3.949062, 0.171765, 3.532377>, <3.894562, 0.171765, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.076230, -0.211346, 3.532377>, <4.021730, -0.211346, 3.532377>, <3.949062, -0.211346, 3.532377>, <3.894562, -0.211346, 3.532377>, 
      <4.076230, -0.191245, 3.418452>, <4.021730, -0.191245, 3.418452>, <3.949062, -0.153232, 2.168388>, <3.894562, -0.153232, 2.168388>, 
      <4.076230, -0.081716, 3.367386>, <4.021730, -0.081716, 2.378324>, <3.983868, -0.121838, -0.000197>, <3.894562, -0.121838, -0.000197>, 
      <4.076230, -0.026161, 3.296675>, <4.021730, -0.026161, 2.307613>, <3.983868, -0.026161, -0.000197>, <3.894562, -0.026161, -0.000197>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.076230, -0.211345, 4.346232>, <4.059698, -0.211345, 4.346232>, <3.911094, -0.211345, 4.346232>, <3.894562, -0.211345, 4.346232>, 
      <4.076230, -0.272676, 4.215944>, <4.059698, -0.272676, 4.215944>, <3.911094, -0.272676, 4.215944>, <3.894562, -0.272676, 4.215944>, 
      <4.076230, -0.265922, 3.841697>, <4.021730, -0.265922, 3.841697>, <3.949062, -0.224716, 3.846190>, <3.894562, -0.224716, 3.846190>, 
      <4.076230, -0.211346, 3.532377>, <4.021730, -0.211346, 3.532377>, <3.949062, -0.211346, 3.532377>, <3.894562, -0.211346, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.076230, 0.171765, 4.346232>, <4.059698, 0.171765, 4.346232>, <3.911094, 0.171765, 4.346232>, <3.894562, 0.171765, 4.346232>, 
      <4.076230, 0.142894, 4.407563>, <4.059698, 0.142894, 4.407563>, <3.911094, 0.142894, 4.407563>, <3.894562, 0.142894, 4.407563>, 
      <4.076230, -0.182474, 4.407563>, <4.059698, -0.182474, 4.407563>, <3.911094, -0.182474, 4.407563>, <3.894562, -0.182474, 4.407563>, 
      <4.076230, -0.211345, 4.346232>, <4.059698, -0.211345, 4.346232>, <3.911094, -0.211345, 4.346232>, <3.894562, -0.211345, 4.346232>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.076230, 0.171765, 4.346232>, <4.076230, 0.233096, 4.215944>, <4.076230, 0.229972, 3.841034>, <4.076230, 0.171765, 3.532377>, 
      <4.059698, 0.171765, 4.346232>, <4.059698, 0.233096, 4.215944>, <4.021730, 0.229972, 3.841034>, <4.021730, 0.171765, 3.532377>, 
      <3.911094, 0.171765, 4.346232>, <3.911094, 0.233096, 4.215944>, <3.949062, 0.186053, 3.846150>, <3.949062, 0.171765, 3.532377>, 
      <3.894562, 0.171765, 4.346232>, <3.894562, 0.233096, 4.215944>, <3.894562, 0.186053, 3.846150>, <3.894562, 0.171765, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.257897, -0.026161, -0.000197>, <4.168591, -0.026161, -0.000197>, <4.130730, -0.026161, 2.307613>, <4.076230, -0.026161, 3.296675>, 
      <4.257897, 0.069534, -0.000197>, <4.168591, 0.069534, -0.000197>, <4.130730, 0.033217, 2.378324>, <4.076230, 0.033217, 3.367386>, 
      <4.257897, 0.109648, 2.168298>, <4.203397, 0.109648, 2.168298>, <4.130730, 0.149753, 3.415650>, <4.076230, 0.149753, 3.415650>, 
      <4.257897, 0.171765, 3.532377>, <4.203397, 0.171765, 3.532377>, <4.130730, 0.171765, 3.532377>, <4.076230, 0.171765, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.257897, -0.211346, 3.532377>, <4.203397, -0.211346, 3.532377>, <4.130730, -0.211346, 3.532377>, <4.076230, -0.211346, 3.532377>, 
      <4.257897, -0.153232, 2.168388>, <4.203397, -0.153232, 2.168388>, <4.130730, -0.191245, 3.418452>, <4.076230, -0.191245, 3.418452>, 
      <4.257897, -0.121838, -0.000197>, <4.168591, -0.121838, -0.000197>, <4.130730, -0.081716, 2.378324>, <4.076230, -0.081716, 3.367386>, 
      <4.257897, -0.026161, -0.000197>, <4.168591, -0.026161, -0.000197>, <4.130730, -0.026161, 2.307613>, <4.076230, -0.026161, 3.296675>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.257897, -0.211345, 4.346232>, <4.241366, -0.211345, 4.346232>, <4.092762, -0.211345, 4.346232>, <4.076230, -0.211345, 4.346232>, 
      <4.257897, -0.272676, 4.215944>, <4.241366, -0.272676, 4.215944>, <4.092762, -0.272676, 4.215944>, <4.076230, -0.272676, 4.215944>, 
      <4.257897, -0.224716, 3.846190>, <4.203397, -0.224716, 3.846190>, <4.130730, -0.265922, 3.841697>, <4.076230, -0.265922, 3.841697>, 
      <4.257897, -0.211346, 3.532377>, <4.203397, -0.211346, 3.532377>, <4.130730, -0.211346, 3.532377>, <4.076230, -0.211346, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.257897, 0.171765, 4.346232>, <4.241366, 0.171765, 4.346232>, <4.092762, 0.171765, 4.346232>, <4.076230, 0.171765, 4.346232>, 
      <4.257897, 0.142894, 4.407563>, <4.241366, 0.142894, 4.407563>, <4.092762, 0.142894, 4.407563>, <4.076230, 0.142894, 4.407563>, 
      <4.257897, -0.182474, 4.407563>, <4.241366, -0.182474, 4.407563>, <4.092762, -0.182474, 4.407563>, <4.076230, -0.182474, 4.407563>, 
      <4.257897, -0.211345, 4.346232>, <4.241366, -0.211345, 4.346232>, <4.092762, -0.211345, 4.346232>, <4.076230, -0.211345, 4.346232>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.257897, 0.171765, 4.346232>, <4.257897, 0.233096, 4.215944>, <4.257897, 0.186053, 3.846150>, <4.257897, 0.171765, 3.532377>, 
      <4.241366, 0.171765, 4.346232>, <4.241366, 0.233096, 4.215944>, <4.203397, 0.186053, 3.846150>, <4.203397, 0.171765, 3.532377>, 
      <4.092762, 0.171765, 4.346232>, <4.092762, 0.233096, 4.215944>, <4.130730, 0.229972, 3.841034>, <4.130730, 0.171765, 3.532377>, 
      <4.076230, 0.171765, 4.346232>, <4.076230, 0.233096, 4.215944>, <4.076230, 0.229972, 3.841034>, <4.076230, 0.171765, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.439565, -0.026161, 3.296675>, <4.385065, -0.026161, 2.307613>, <4.347203, -0.026161, -0.000197>, <4.257897, -0.026161, -0.000197>, 
      <4.439565, 0.033217, 3.367386>, <4.385065, 0.033217, 2.378324>, <4.347203, 0.069534, -0.000197>, <4.257897, 0.069534, -0.000197>, 
      <4.439565, 0.149753, 3.415650>, <4.385065, 0.149753, 3.415650>, <4.312398, 0.109648, 2.168298>, <4.257897, 0.109648, 2.168298>, 
      <4.439565, 0.171765, 3.532377>, <4.385065, 0.171765, 3.532377>, <4.312398, 0.171765, 3.532377>, <4.257897, 0.171765, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.439565, -0.211346, 3.532377>, <4.385065, -0.211346, 3.532377>, <4.312398, -0.211346, 3.532377>, <4.257897, -0.211346, 3.532377>, 
      <4.439565, -0.191245, 3.418452>, <4.385065, -0.191245, 3.418452>, <4.312398, -0.153232, 2.168388>, <4.257897, -0.153232, 2.168388>, 
      <4.439565, -0.081716, 3.367386>, <4.385065, -0.081716, 2.378324>, <4.347203, -0.121838, -0.000197>, <4.257897, -0.121838, -0.000197>, 
      <4.439565, -0.026161, 3.296675>, <4.385065, -0.026161, 2.307613>, <4.347203, -0.026161, -0.000197>, <4.257897, -0.026161, -0.000197>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.439565, -0.211345, 4.346232>, <4.423033, -0.211345, 4.346232>, <4.274429, -0.211345, 4.346232>, <4.257897, -0.211345, 4.346232>, 
      <4.439565, -0.272676, 4.215944>, <4.423033, -0.272676, 4.215944>, <4.274429, -0.272676, 4.215944>, <4.257897, -0.272676, 4.215944>, 
      <4.439565, -0.265922, 3.841697>, <4.385065, -0.265922, 3.841697>, <4.312398, -0.224716, 3.846190>, <4.257897, -0.224716, 3.846190>, 
      <4.439565, -0.211346, 3.532377>, <4.385065, -0.211346, 3.532377>, <4.312398, -0.211346, 3.532377>, <4.257897, -0.211346, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.439565, 0.171765, 4.346232>, <4.423033, 0.171765, 4.346232>, <4.274429, 0.171765, 4.346232>, <4.257897, 0.171765, 4.346232>, 
      <4.439565, 0.142894, 4.407563>, <4.423033, 0.142894, 4.407563>, <4.274429, 0.142894, 4.407563>, <4.257897, 0.142894, 4.407563>, 
      <4.439565, -0.182474, 4.407563>, <4.423033, -0.182474, 4.407563>, <4.274429, -0.182474, 4.407563>, <4.257897, -0.182474, 4.407563>, 
      <4.439565, -0.211345, 4.346232>, <4.423033, -0.211345, 4.346232>, <4.274429, -0.211345, 4.346232>, <4.257897, -0.211345, 4.346232>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.439565, 0.171765, 4.346232>, <4.439565, 0.233096, 4.215944>, <4.439565, 0.229972, 3.841034>, <4.439565, 0.171765, 3.532377>, 
      <4.423033, 0.171765, 4.346232>, <4.423033, 0.233096, 4.215944>, <4.385065, 0.229972, 3.841034>, <4.385065, 0.171765, 3.532377>, 
      <4.274429, 0.171765, 4.346232>, <4.274429, 0.233096, 4.215944>, <4.312398, 0.186053, 3.846150>, <4.312398, 0.171765, 3.532377>, 
      <4.257897, 0.171765, 4.346232>, <4.257897, 0.233096, 4.215944>, <4.257897, 0.186053, 3.846150>, <4.257897, 0.171765, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.621233, -0.026161, -0.000197>, <4.531927, -0.026161, -0.000197>, <4.494066, -0.026161, 2.307613>, <4.439565, -0.026161, 3.296675>, 
      <4.621233, 0.069534, -0.000197>, <4.531927, 0.069534, -0.000197>, <4.494066, 0.033217, 2.378324>, <4.439565, 0.033217, 3.367386>, 
      <4.621233, 0.109648, 2.168298>, <4.566732, 0.109648, 2.168298>, <4.494066, 0.149753, 3.415650>, <4.439565, 0.149753, 3.415650>, 
      <4.621233, 0.171765, 3.532377>, <4.566732, 0.171765, 3.532377>, <4.494066, 0.171765, 3.532377>, <4.439565, 0.171765, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.621233, -0.211346, 3.532377>, <4.566732, -0.211346, 3.532377>, <4.494066, -0.211346, 3.532377>, <4.439565, -0.211346, 3.532377>, 
      <4.621233, -0.153232, 2.168388>, <4.566732, -0.153232, 2.168388>, <4.494066, -0.191245, 3.418452>, <4.439565, -0.191245, 3.418452>, 
      <4.621233, -0.121838, -0.000197>, <4.531927, -0.121838, -0.000197>, <4.494066, -0.081716, 2.378324>, <4.439565, -0.081716, 3.367386>, 
      <4.621233, -0.026161, -0.000197>, <4.531927, -0.026161, -0.000197>, <4.494066, -0.026161, 2.307613>, <4.439565, -0.026161, 3.296675>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.621233, -0.211345, 4.346232>, <4.604701, -0.211345, 4.346232>, <4.456097, -0.211345, 4.346232>, <4.439565, -0.211345, 4.346232>, 
      <4.621233, -0.272676, 4.215944>, <4.604701, -0.272676, 4.215944>, <4.456097, -0.272676, 4.215944>, <4.439565, -0.272676, 4.215944>, 
      <4.621233, -0.224716, 3.846190>, <4.566732, -0.224716, 3.846190>, <4.494066, -0.265922, 3.841697>, <4.439565, -0.265922, 3.841697>, 
      <4.621233, -0.211346, 3.532377>, <4.566732, -0.211346, 3.532377>, <4.494066, -0.211346, 3.532377>, <4.439565, -0.211346, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.621233, 0.171765, 4.346232>, <4.604701, 0.171765, 4.346232>, <4.456097, 0.171765, 4.346232>, <4.439565, 0.171765, 4.346232>, 
      <4.621233, 0.142894, 4.407563>, <4.604701, 0.142894, 4.407563>, <4.456097, 0.142894, 4.407563>, <4.439565, 0.142894, 4.407563>, 
      <4.621233, -0.182474, 4.407563>, <4.604701, -0.182474, 4.407563>, <4.456097, -0.182474, 4.407563>, <4.439565, -0.182474, 4.407563>, 
      <4.621233, -0.211345, 4.346232>, <4.604701, -0.211345, 4.346232>, <4.456097, -0.211345, 4.346232>, <4.439565, -0.211345, 4.346232>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.621233, 0.171765, 4.346232>, <4.621233, 0.233096, 4.215944>, <4.621233, 0.186053, 3.846150>, <4.621233, 0.171765, 3.532377>, 
      <4.604701, 0.171765, 4.346232>, <4.604701, 0.233096, 4.215944>, <4.566732, 0.186053, 3.846150>, <4.566732, 0.171765, 3.532377>, 
      <4.456097, 0.171765, 4.346232>, <4.456097, 0.233096, 4.215944>, <4.494066, 0.229972, 3.841034>, <4.494066, 0.171765, 3.532377>, 
      <4.439565, 0.171765, 4.346232>, <4.439565, 0.233096, 4.215944>, <4.439565, 0.229972, 3.841034>, <4.439565, 0.171765, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.802900, -0.026161, 3.296675>, <4.748400, -0.026161, 2.307613>, <4.710539, -0.026161, -0.000197>, <4.621233, -0.026161, -0.000197>, 
      <4.802900, 0.033217, 3.367386>, <4.748400, 0.033217, 2.378324>, <4.710539, 0.069534, -0.000197>, <4.621233, 0.069534, -0.000197>, 
      <4.802900, 0.149753, 3.415650>, <4.748400, 0.149753, 3.415650>, <4.675733, 0.109648, 2.168298>, <4.621233, 0.109648, 2.168298>, 
      <4.802900, 0.171765, 3.532377>, <4.748400, 0.171765, 3.532377>, <4.675733, 0.171765, 3.532377>, <4.621233, 0.171765, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.802900, -0.211346, 3.532377>, <4.748400, -0.211346, 3.532377>, <4.675733, -0.211346, 3.532377>, <4.621233, -0.211346, 3.532377>, 
      <4.802900, -0.191245, 3.418452>, <4.748400, -0.191245, 3.418452>, <4.675733, -0.153232, 2.168388>, <4.621233, -0.153232, 2.168388>, 
      <4.802900, -0.081716, 3.367386>, <4.748400, -0.081716, 2.378324>, <4.710539, -0.121838, -0.000197>, <4.621233, -0.121838, -0.000197>, 
      <4.802900, -0.026161, 3.296675>, <4.748400, -0.026161, 2.307613>, <4.710539, -0.026161, -0.000197>, <4.621233, -0.026161, -0.000197>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.802900, -0.211345, 4.346232>, <4.786368, -0.211345, 4.346232>, <4.637764, -0.211345, 4.346232>, <4.621233, -0.211345, 4.346232>, 
      <4.802900, -0.272676, 4.215944>, <4.786368, -0.272676, 4.215944>, <4.637764, -0.272676, 4.215944>, <4.621233, -0.272676, 4.215944>, 
      <4.802900, -0.265922, 3.841697>, <4.748400, -0.265922, 3.841697>, <4.675733, -0.224716, 3.846190>, <4.621233, -0.224716, 3.846190>, 
      <4.802900, -0.211346, 3.532377>, <4.748400, -0.211346, 3.532377>, <4.675733, -0.211346, 3.532377>, <4.621233, -0.211346, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.802900, 0.171765, 4.346232>, <4.786368, 0.171765, 4.346232>, <4.637764, 0.171765, 4.346232>, <4.621233, 0.171765, 4.346232>, 
      <4.802900, 0.142894, 4.407563>, <4.786368, 0.142894, 4.407563>, <4.637764, 0.142894, 4.407563>, <4.621233, 0.142894, 4.407563>, 
      <4.802900, -0.182474, 4.407563>, <4.786368, -0.182474, 4.407563>, <4.637764, -0.182474, 4.407563>, <4.621233, -0.182474, 4.407563>, 
      <4.802900, -0.211345, 4.346232>, <4.786368, -0.211345, 4.346232>, <4.637764, -0.211345, 4.346232>, <4.621233, -0.211345, 4.346232>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.802900, 0.171765, 4.346232>, <4.802900, 0.233096, 4.215944>, <4.802900, 0.229972, 3.841034>, <4.802900, 0.171765, 3.532377>, 
      <4.786368, 0.171765, 4.346232>, <4.786368, 0.233096, 4.215944>, <4.748400, 0.229972, 3.841034>, <4.748400, 0.171765, 3.532377>, 
      <4.637764, 0.171765, 4.346232>, <4.637764, 0.233096, 4.215944>, <4.675733, 0.186053, 3.846150>, <4.675733, 0.171765, 3.532377>, 
      <4.621233, 0.171765, 4.346232>, <4.621233, 0.233096, 4.215944>, <4.621233, 0.186053, 3.846150>, <4.621233, 0.171765, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.984568, -0.026161, -0.000197>, <4.895262, -0.026161, -0.000197>, <4.857400, -0.026161, 2.307613>, <4.802900, -0.026161, 3.296675>, 
      <4.984568, 0.069534, -0.000197>, <4.895262, 0.069534, -0.000197>, <4.857400, 0.033217, 2.378324>, <4.802900, 0.033217, 3.367386>, 
      <4.984568, 0.109648, 2.168298>, <4.930068, 0.109648, 2.168298>, <4.857400, 0.149753, 3.415650>, <4.802900, 0.149753, 3.415650>, 
      <4.984568, 0.171765, 3.532377>, <4.930068, 0.171765, 3.532377>, <4.857400, 0.171765, 3.532377>, <4.802900, 0.171765, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.984568, -0.211346, 3.532377>, <4.930068, -0.211346, 3.532377>, <4.857400, -0.211346, 3.532377>, <4.802900, -0.211346, 3.532377>, 
      <4.984568, -0.153232, 2.168388>, <4.930068, -0.153232, 2.168388>, <4.857400, -0.191245, 3.418452>, <4.802900, -0.191245, 3.418452>, 
      <4.984568, -0.121838, -0.000197>, <4.895262, -0.121838, -0.000197>, <4.857400, -0.081716, 2.378324>, <4.802900, -0.081716, 3.367386>, 
      <4.984568, -0.026161, -0.000197>, <4.895262, -0.026161, -0.000197>, <4.857400, -0.026161, 2.307613>, <4.802900, -0.026161, 3.296675>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.984568, -0.211345, 4.346232>, <4.968036, -0.211345, 4.346232>, <4.819432, -0.211345, 4.346232>, <4.802900, -0.211345, 4.346232>, 
      <4.984568, -0.272676, 4.215944>, <4.968036, -0.272676, 4.215944>, <4.819432, -0.272676, 4.215944>, <4.802900, -0.272676, 4.215944>, 
      <4.984568, -0.224716, 3.846190>, <4.930068, -0.224716, 3.846190>, <4.857400, -0.265922, 3.841697>, <4.802900, -0.265922, 3.841697>, 
      <4.984568, -0.211346, 3.532377>, <4.930068, -0.211346, 3.532377>, <4.857400, -0.211346, 3.532377>, <4.802900, -0.211346, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.984568, 0.171765, 4.346232>, <4.968036, 0.171765, 4.346232>, <4.819432, 0.171765, 4.346232>, <4.802900, 0.171765, 4.346232>, 
      <4.984568, 0.142894, 4.407563>, <4.968036, 0.142894, 4.407563>, <4.819432, 0.142894, 4.407563>, <4.802900, 0.142894, 4.407563>, 
      <4.984568, -0.182474, 4.407563>, <4.968036, -0.182474, 4.407563>, <4.819432, -0.182474, 4.407563>, <4.802900, -0.182474, 4.407563>, 
      <4.984568, -0.211345, 4.346232>, <4.968036, -0.211345, 4.346232>, <4.819432, -0.211345, 4.346232>, <4.802900, -0.211345, 4.346232>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.984568, 0.171765, 4.346232>, <4.984568, 0.233096, 4.215944>, <4.984568, 0.186053, 3.846150>, <4.984568, 0.171765, 3.532377>, 
      <4.968036, 0.171765, 4.346232>, <4.968036, 0.233096, 4.215944>, <4.930068, 0.186053, 3.846150>, <4.930068, 0.171765, 3.532377>, 
      <4.819432, 0.171765, 4.346232>, <4.819432, 0.233096, 4.215944>, <4.857400, 0.229972, 3.841034>, <4.857400, 0.171765, 3.532377>, 
      <4.802900, 0.171765, 4.346232>, <4.802900, 0.233096, 4.215944>, <4.802900, 0.229972, 3.841034>, <4.802900, 0.171765, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <5.166236, -0.026161, 3.296675>, <5.111735, -0.026161, 2.307613>, <5.073874, -0.026161, -0.000197>, <4.984568, -0.026161, -0.000197>, 
      <5.166236, 0.033217, 3.367386>, <5.111735, 0.033217, 2.378324>, <5.073874, 0.069534, -0.000197>, <4.984568, 0.069534, -0.000197>, 
      <5.166236, 0.149753, 3.415650>, <5.111735, 0.149753, 3.415650>, <5.039069, 0.109648, 2.168298>, <4.984568, 0.109648, 2.168298>, 
      <5.166236, 0.171765, 3.532377>, <5.111735, 0.171765, 3.532377>, <5.039069, 0.171765, 3.532377>, <4.984568, 0.171765, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <5.166236, -0.211346, 3.532377>, <5.111735, -0.211346, 3.532377>, <5.039069, -0.211346, 3.532377>, <4.984568, -0.211346, 3.532377>, 
      <5.166236, -0.191245, 3.418452>, <5.111735, -0.191245, 3.418452>, <5.039069, -0.153232, 2.168388>, <4.984568, -0.153232, 2.168388>, 
      <5.166236, -0.081716, 3.367386>, <5.111735, -0.081716, 2.378324>, <5.073874, -0.121838, -0.000197>, <4.984568, -0.121838, -0.000197>, 
      <5.166236, -0.026161, 3.296675>, <5.111735, -0.026161, 2.307613>, <5.073874, -0.026161, -0.000197>, <4.984568, -0.026161, -0.000197>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <5.166236, -0.211345, 4.346232>, <5.149704, -0.211345, 4.346232>, <5.001100, -0.211345, 4.346232>, <4.984568, -0.211345, 4.346232>, 
      <5.166236, -0.272676, 4.215944>, <5.149704, -0.272676, 4.215944>, <5.001100, -0.272676, 4.215944>, <4.984568, -0.272676, 4.215944>, 
      <5.166236, -0.265922, 3.841697>, <5.111735, -0.265922, 3.841697>, <5.039069, -0.224716, 3.846190>, <4.984568, -0.224716, 3.846190>, 
      <5.166236, -0.211346, 3.532377>, <5.111735, -0.211346, 3.532377>, <5.039069, -0.211346, 3.532377>, <4.984568, -0.211346, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <5.166236, 0.171765, 4.346232>, <5.149704, 0.171765, 4.346232>, <5.001100, 0.171765, 4.346232>, <4.984568, 0.171765, 4.346232>, 
      <5.166236, 0.142894, 4.407563>, <5.149704, 0.142894, 4.407563>, <5.001100, 0.142894, 4.407563>, <4.984568, 0.142894, 4.407563>, 
      <5.166236, -0.182474, 4.407563>, <5.149704, -0.182474, 4.407563>, <5.001100, -0.182474, 4.407563>, <4.984568, -0.182474, 4.407563>, 
      <5.166236, -0.211345, 4.346232>, <5.149704, -0.211345, 4.346232>, <5.001100, -0.211345, 4.346232>, <4.984568, -0.211345, 4.346232>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <5.166236, 0.171765, 4.346232>, <5.166236, 0.233096, 4.215944>, <5.166236, 0.229972, 3.841034>, <5.166236, 0.171765, 3.532377>, 
      <5.149704, 0.171765, 4.346232>, <5.149704, 0.233096, 4.215944>, <5.111735, 0.229972, 3.841034>, <5.111735, 0.171765, 3.532377>, 
      <5.001100, 0.171765, 4.346232>, <5.001100, 0.233096, 4.215944>, <5.039069, 0.186053, 3.846150>, <5.039069, 0.171765, 3.532377>, 
      <4.984568, 0.171765, 4.346232>, <4.984568, 0.233096, 4.215944>, <4.984568, 0.186053, 3.846150>, <4.984568, 0.171765, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <5.347904, -0.026161, -0.000197>, <5.258598, -0.026161, -0.000197>, <5.220736, -0.026161, 2.307613>, <5.166236, -0.026161, 3.296675>, 
      <5.347904, 0.069534, -0.000197>, <5.258598, 0.069534, -0.000197>, <5.220736, 0.033217, 2.378324>, <5.166236, 0.033217, 3.367386>, 
      <5.347904, 0.109648, 2.168298>, <5.293404, 0.109648, 2.168298>, <5.220736, 0.149753, 3.415650>, <5.166236, 0.149753, 3.415650>, 
      <5.347904, 0.171765, 3.532377>, <5.293404, 0.171765, 3.532377>, <5.220736, 0.171765, 3.532377>, <5.166236, 0.171765, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <5.347904, -0.211346, 3.532377>, <5.293404, -0.211346, 3.532377>, <5.220736, -0.211346, 3.532377>, <5.166236, -0.211346, 3.532377>, 
      <5.347904, -0.153232, 2.168388>, <5.293404, -0.153232, 2.168388>, <5.220736, -0.191245, 3.418452>, <5.166236, -0.191245, 3.418452>, 
      <5.347904, -0.121838, -0.000197>, <5.258598, -0.121838, -0.000197>, <5.220736, -0.081716, 2.378324>, <5.166236, -0.081716, 3.367386>, 
      <5.347904, -0.026161, -0.000197>, <5.258598, -0.026161, -0.000197>, <5.220736, -0.026161, 2.307613>, <5.166236, -0.026161, 3.296675>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <5.347904, -0.211345, 4.346232>, <5.331372, -0.211345, 4.346232>, <5.182768, -0.211345, 4.346232>, <5.166236, -0.211345, 4.346232>, 
      <5.347904, -0.272676, 4.215944>, <5.331372, -0.272676, 4.215944>, <5.182768, -0.272676, 4.215944>, <5.166236, -0.272676, 4.215944>, 
      <5.347904, -0.224716, 3.846190>, <5.293404, -0.224716, 3.846190>, <5.220736, -0.265922, 3.841697>, <5.166236, -0.265922, 3.841697>, 
      <5.347904, -0.211346, 3.532377>, <5.293404, -0.211346, 3.532377>, <5.220736, -0.211346, 3.532377>, <5.166236, -0.211346, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <5.347904, 0.171765, 4.346232>, <5.331372, 0.171765, 4.346232>, <5.182768, 0.171765, 4.346232>, <5.166236, 0.171765, 4.346232>, 
      <5.347904, 0.142894, 4.407563>, <5.331372, 0.142894, 4.407563>, <5.182768, 0.142894, 4.407563>, <5.166236, 0.142894, 4.407563>, 
      <5.347904, -0.182474, 4.407563>, <5.331372, -0.182474, 4.407563>, <5.182768, -0.182474, 4.407563>, <5.166236, -0.182474, 4.407563>, 
      <5.347904, -0.211345, 4.346232>, <5.331372, -0.211345, 4.346232>, <5.182768, -0.211345, 4.346232>, <5.166236, -0.211345, 4.346232>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <5.347904, 0.171765, 4.346232>, <5.347904, 0.233096, 4.215944>, <5.347904, 0.186053, 3.846150>, <5.347904, 0.171765, 3.532377>, 
      <5.331372, 0.171765, 4.346232>, <5.331372, 0.233096, 4.215944>, <5.293404, 0.186053, 3.846150>, <5.293404, 0.171765, 3.532377>, 
      <5.182768, 0.171765, 4.346232>, <5.182768, 0.233096, 4.215944>, <5.220736, 0.229972, 3.841034>, <5.220736, 0.171765, 3.532377>, 
      <5.166236, 0.171765, 4.346232>, <5.166236, 0.233096, 4.215944>, <5.166236, 0.229972, 3.841034>, <5.166236, 0.171765, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <5.529571, -0.026161, 3.296675>, <5.475071, -0.026161, 2.307613>, <5.437210, -0.026161, -0.000197>, <5.347904, -0.026161, -0.000197>, 
      <5.529571, 0.033217, 3.367386>, <5.475071, 0.033217, 2.378324>, <5.437210, 0.069534, -0.000197>, <5.347904, 0.069534, -0.000197>, 
      <5.529571, 0.149753, 3.415650>, <5.475071, 0.149753, 3.415650>, <5.402404, 0.109648, 2.168298>, <5.347904, 0.109648, 2.168298>, 
      <5.529571, 0.171765, 3.532377>, <5.475071, 0.171765, 3.532377>, <5.402404, 0.171765, 3.532377>, <5.347904, 0.171765, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <5.529571, -0.211346, 3.532377>, <5.475071, -0.211346, 3.532377>, <5.402404, -0.211346, 3.532377>, <5.347904, -0.211346, 3.532377>, 
      <5.529571, -0.191245, 3.418452>, <5.475071, -0.191245, 3.418452>, <5.402404, -0.153232, 2.168388>, <5.347904, -0.153232, 2.168388>, 
      <5.529571, -0.081716, 3.367386>, <5.475071, -0.081716, 2.378324>, <5.437210, -0.121838, -0.000197>, <5.347904, -0.121838, -0.000197>, 
      <5.529571, -0.026161, 3.296675>, <5.475071, -0.026161, 2.307613>, <5.437210, -0.026161, -0.000197>, <5.347904, -0.026161, -0.000197>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <5.529571, -0.211345, 4.346232>, <5.513040, -0.211345, 4.346232>, <5.364436, -0.211345, 4.346232>, <5.347904, -0.211345, 4.346232>, 
      <5.529571, -0.272676, 4.215944>, <5.513040, -0.272676, 4.215944>, <5.364436, -0.272676, 4.215944>, <5.347904, -0.272676, 4.215944>, 
      <5.529571, -0.265922, 3.841697>, <5.475071, -0.265922, 3.841697>, <5.402404, -0.224716, 3.846190>, <5.347904, -0.224716, 3.846190>, 
      <5.529571, -0.211346, 3.532377>, <5.475071, -0.211346, 3.532377>, <5.402404, -0.211346, 3.532377>, <5.347904, -0.211346, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <5.529571, 0.171765, 4.346232>, <5.513040, 0.171765, 4.346232>, <5.364436, 0.171765, 4.346232>, <5.347904, 0.171765, 4.346232>, 
      <5.529571, 0.142894, 4.407563>, <5.513040, 0.142894, 4.407563>, <5.364436, 0.142894, 4.407563>, <5.347904, 0.142894, 4.407563>, 
      <5.529571, -0.182474, 4.407563>, <5.513040, -0.182474, 4.407563>, <5.364436, -0.182474, 4.407563>, <5.347904, -0.182474, 4.407563>, 
      <5.529571, -0.211345, 4.346232>, <5.513040, -0.211345, 4.346232>, <5.364436, -0.211345, 4.346232>, <5.347904, -0.211345, 4.346232>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <5.529571, 0.171765, 4.346232>, <5.529571, 0.233096, 4.215944>, <5.529571, 0.229972, 3.841034>, <5.529571, 0.171765, 3.532377>, 
      <5.513040, 0.171765, 4.346232>, <5.513040, 0.233096, 4.215944>, <5.475071, 0.229972, 3.841034>, <5.475071, 0.171765, 3.532377>, 
      <5.364436, 0.171765, 4.346232>, <5.364436, 0.233096, 4.215944>, <5.402404, 0.186053, 3.846150>, <5.402404, 0.171765, 3.532377>, 
      <5.347904, 0.171765, 4.346232>, <5.347904, 0.233096, 4.215944>, <5.347904, 0.186053, 3.846150>, <5.347904, 0.171765, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <5.711238, -0.026161, -0.000197>, <5.621932, -0.026161, -0.000197>, <5.584071, -0.026161, 2.307613>, <5.529571, -0.026161, 3.296675>, 
      <5.711238, 0.069534, -0.000197>, <5.621932, 0.069534, -0.000197>, <5.584071, 0.033217, 2.378324>, <5.529571, 0.033217, 3.367386>, 
      <5.711238, 0.109648, 2.168298>, <5.656738, 0.109648, 2.168298>, <5.584071, 0.149753, 3.415650>, <5.529571, 0.149753, 3.415650>, 
      <5.711238, 0.171765, 3.532377>, <5.656738, 0.171765, 3.532377>, <5.584071, 0.171765, 3.532377>, <5.529571, 0.171765, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <5.711238, -0.211346, 3.532377>, <5.656738, -0.211346, 3.532377>, <5.584071, -0.211346, 3.532377>, <5.529571, -0.211346, 3.532377>, 
      <5.711238, -0.153232, 2.168388>, <5.656738, -0.153232, 2.168388>, <5.584071, -0.191245, 3.418452>, <5.529571, -0.191245, 3.418452>, 
      <5.711238, -0.121838, -0.000197>, <5.621932, -0.121838, -0.000197>, <5.584071, -0.081716, 2.378324>, <5.529571, -0.081716, 3.367386>, 
      <5.711238, -0.026161, -0.000197>, <5.621932, -0.026161, -0.000197>, <5.584071, -0.026161, 2.307613>, <5.529571, -0.026161, 3.296675>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <5.711238, -0.211345, 4.346232>, <5.694706, -0.211345, 4.346232>, <5.546102, -0.211345, 4.346232>, <5.529571, -0.211345, 4.346232>, 
      <5.711238, -0.272676, 4.215944>, <5.694706, -0.272676, 4.215944>, <5.546102, -0.272676, 4.215944>, <5.529571, -0.272676, 4.215944>, 
      <5.711238, -0.224716, 3.846190>, <5.656738, -0.224716, 3.846190>, <5.584071, -0.265922, 3.841697>, <5.529571, -0.265922, 3.841697>, 
      <5.711238, -0.211346, 3.532377>, <5.656738, -0.211346, 3.532377>, <5.584071, -0.211346, 3.532377>, <5.529571, -0.211346, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <5.711238, 0.171765, 4.346232>, <5.694706, 0.171765, 4.346232>, <5.546102, 0.171765, 4.346232>, <5.529571, 0.171765, 4.346232>, 
      <5.711238, 0.142894, 4.407563>, <5.694706, 0.142894, 4.407563>, <5.546102, 0.142894, 4.407563>, <5.529571, 0.142894, 4.407563>, 
      <5.711238, -0.182474, 4.407563>, <5.694706, -0.182474, 4.407563>, <5.546102, -0.182474, 4.407563>, <5.529571, -0.182474, 4.407563>, 
      <5.711238, -0.211345, 4.346232>, <5.694706, -0.211345, 4.346232>, <5.546102, -0.211345, 4.346232>, <5.529571, -0.211345, 4.346232>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <5.711238, 0.171765, 4.346232>, <5.711238, 0.233096, 4.215944>, <5.711238, 0.186053, 3.846150>, <5.711238, 0.171765, 3.532377>, 
      <5.694706, 0.171765, 4.346232>, <5.694706, 0.233096, 4.215944>, <5.656738, 0.186053, 3.846150>, <5.656738, 0.171765, 3.532377>, 
      <5.546102, 0.171765, 4.346232>, <5.546102, 0.233096, 4.215944>, <5.584071, 0.229972, 3.841034>, <5.584071, 0.171765, 3.532377>, 
      <5.529571, 0.171765, 4.346232>, <5.529571, 0.233096, 4.215944>, <5.529571, 0.229972, 3.841034>, <5.529571, 0.171765, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <5.892904, -0.026161, 3.296675>, <5.838404, -0.026161, 2.307613>, <5.800544, -0.026161, -0.000197>, <5.711238, -0.026161, -0.000197>, 
      <5.892904, 0.033217, 3.367386>, <5.838405, 0.033217, 2.378324>, <5.800544, 0.069534, -0.000197>, <5.711238, 0.069534, -0.000197>, 
      <5.892905, 0.149753, 3.415650>, <5.838405, 0.149753, 3.415650>, <5.765738, 0.109648, 2.168298>, <5.711238, 0.109648, 2.168298>, 
      <5.892905, 0.171765, 3.532377>, <5.838405, 0.171765, 3.532377>, <5.765738, 0.171765, 3.532377>, <5.711238, 0.171765, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <5.892904, -0.211346, 3.532377>, <5.838404, -0.211346, 3.532377>, <5.765738, -0.211346, 3.532377>, <5.711238, -0.211346, 3.532377>, 
      <5.892904, -0.191245, 3.418452>, <5.838404, -0.191245, 3.418452>, <5.765738, -0.153232, 2.168388>, <5.711238, -0.153232, 2.168388>, 
      <5.892904, -0.081716, 3.367386>, <5.838404, -0.081716, 2.378324>, <5.800544, -0.121838, -0.000197>, <5.711238, -0.121838, -0.000197>, 
      <5.892904, -0.026161, 3.296675>, <5.838404, -0.026161, 2.307613>, <5.800544, -0.026161, -0.000197>, <5.711238, -0.026161, -0.000197>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <5.892904, -0.211345, 4.346232>, <5.876372, -0.211345, 4.346232>, <5.727769, -0.211345, 4.346232>, <5.711238, -0.211345, 4.346232>, 
      <5.892904, -0.272676, 4.215944>, <5.876372, -0.272676, 4.215944>, <5.727769, -0.272676, 4.215944>, <5.711238, -0.272676, 4.215944>, 
      <5.892904, -0.265922, 3.841697>, <5.838404, -0.265922, 3.841697>, <5.765738, -0.224716, 3.846190>, <5.711238, -0.224716, 3.846190>, 
      <5.892904, -0.211346, 3.532377>, <5.838404, -0.211346, 3.532377>, <5.765738, -0.211346, 3.532377>, <5.711238, -0.211346, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <5.892905, 0.171765, 4.346232>, <5.876373, 0.171765, 4.346232>, <5.727770, 0.171765, 4.346232>, <5.711238, 0.171765, 4.346232>, 
      <5.892905, 0.142894, 4.407563>, <5.876373, 0.142894, 4.407563>, <5.727770, 0.142894, 4.407563>, <5.711238, 0.142894, 4.407563>, 
      <5.892904, -0.182474, 4.407563>, <5.876372, -0.182474, 4.407563>, <5.727769, -0.182474, 4.407563>, <5.711238, -0.182474, 4.407563>, 
      <5.892904, -0.211345, 4.346232>, <5.876372, -0.211345, 4.346232>, <5.727769, -0.211345, 4.346232>, <5.711238, -0.211345, 4.346232>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <5.892905, 0.171765, 4.346232>, <5.892906, 0.233096, 4.215944>, <5.892906, 0.229972, 3.841034>, <5.892905, 0.171765, 3.532377>, 
      <5.876373, 0.171765, 4.346232>, <5.876374, 0.233096, 4.215944>, <5.838406, 0.229972, 3.841034>, <5.838405, 0.171765, 3.532377>, 
      <5.727770, 0.171765, 4.346232>, <5.727770, 0.233096, 4.215944>, <5.765738, 0.186053, 3.846150>, <5.765738, 0.171765, 3.532377>, 
      <5.711238, 0.171765, 4.346232>, <5.711238, 0.233096, 4.215944>, <5.711238, 0.186053, 3.846150>, <5.711238, 0.171765, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <6.074574, -0.026161, -0.000197>, <5.985268, -0.026161, -0.000197>, <5.947405, -0.026161, 2.307613>, <5.892904, -0.026161, 3.296675>, 
      <6.074574, 0.069534, -0.000197>, <5.985268, 0.069534, -0.000197>, <5.947405, 0.033217, 2.378324>, <5.892904, 0.033217, 3.367386>, 
      <6.074574, 0.109648, 2.168298>, <6.020074, 0.109648, 2.168298>, <5.947406, 0.149753, 3.415650>, <5.892905, 0.149753, 3.415650>, 
      <6.074575, 0.171765, 3.532377>, <6.020074, 0.171765, 3.532377>, <5.947406, 0.171765, 3.532377>, <5.892905, 0.171765, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <6.074574, -0.211346, 3.532377>, <6.020073, -0.211346, 3.532377>, <5.947405, -0.211346, 3.532377>, <5.892904, -0.211346, 3.532377>, 
      <6.074574, -0.153232, 2.168388>, <6.020073, -0.153232, 2.168388>, <5.947405, -0.191245, 3.418452>, <5.892904, -0.191245, 3.418452>, 
      <6.074574, -0.121838, -0.000197>, <5.985268, -0.121838, -0.000197>, <5.947405, -0.081716, 2.378324>, <5.892904, -0.081716, 3.367386>, 
      <6.074574, -0.026161, -0.000197>, <5.985268, -0.026161, -0.000197>, <5.947405, -0.026161, 2.307613>, <5.892904, -0.026161, 3.296675>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <6.074574, -0.211345, 4.346232>, <6.058042, -0.211345, 4.346232>, <5.909436, -0.211345, 4.346232>, <5.892904, -0.211345, 4.346232>, 
      <6.074574, -0.272676, 4.215944>, <6.058042, -0.272676, 4.215944>, <5.909436, -0.272676, 4.215944>, <5.892904, -0.272676, 4.215944>, 
      <6.074574, -0.224716, 3.846190>, <6.020073, -0.224716, 3.846190>, <5.947405, -0.265922, 3.841697>, <5.892904, -0.265922, 3.841697>, 
      <6.074574, -0.211346, 3.532377>, <6.020073, -0.211346, 3.532377>, <5.947405, -0.211346, 3.532377>, <5.892904, -0.211346, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <6.074575, 0.171765, 4.346232>, <6.058043, 0.171765, 4.346232>, <5.909437, 0.171765, 4.346232>, <5.892905, 0.171765, 4.346232>, 
      <6.074575, 0.142894, 4.407563>, <6.058043, 0.142894, 4.407563>, <5.909437, 0.142894, 4.407563>, <5.892905, 0.142894, 4.407563>, 
      <6.074574, -0.182474, 4.407563>, <6.058042, -0.182474, 4.407563>, <5.909436, -0.182474, 4.407563>, <5.892904, -0.182474, 4.407563>, 
      <6.074574, -0.211345, 4.346232>, <6.058042, -0.211345, 4.346232>, <5.909436, -0.211345, 4.346232>, <5.892904, -0.211345, 4.346232>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <6.074575, 0.171765, 4.346232>, <6.074575, 0.233096, 4.215944>, <6.074575, 0.186053, 3.846150>, <6.074575, 0.171765, 3.532377>, 
      <6.058043, 0.171765, 4.346232>, <6.058043, 0.233096, 4.215944>, <6.020074, 0.186053, 3.846150>, <6.020074, 0.171765, 3.532377>, 
      <5.909437, 0.171765, 4.346232>, <5.909438, 0.233096, 4.215944>, <5.947407, 0.229972, 3.841034>, <5.947406, 0.171765, 3.532377>, 
      <5.892905, 0.171765, 4.346232>, <5.892906, 0.233096, 4.215944>, <5.892906, 0.229972, 3.841034>, <5.892905, 0.171765, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <6.256242, -0.026161, 3.296675>, <6.201741, -0.026161, 2.307613>, <6.163880, -0.026161, -0.000197>, <6.074574, -0.026161, -0.000197>, 
      <6.256242, 0.033217, 3.367386>, <6.201741, 0.033217, 2.378324>, <6.163880, 0.069534, -0.000197>, <6.074574, 0.069534, -0.000197>, 
      <6.256242, 0.149753, 3.415650>, <6.201742, 0.149753, 3.415650>, <6.129074, 0.109648, 2.168298>, <6.074574, 0.109648, 2.168298>, 
      <6.256242, 0.171765, 3.532377>, <6.201742, 0.171765, 3.532377>, <6.129075, 0.171765, 3.532377>, <6.074575, 0.171765, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <6.256242, -0.211346, 3.532377>, <6.201741, -0.211346, 3.532377>, <6.129074, -0.211346, 3.532377>, <6.074574, -0.211346, 3.532377>, 
      <6.256242, -0.191245, 3.418452>, <6.201741, -0.191245, 3.418452>, <6.129074, -0.153232, 2.168388>, <6.074574, -0.153232, 2.168388>, 
      <6.256242, -0.081716, 3.367386>, <6.201741, -0.081716, 2.378324>, <6.163880, -0.121838, -0.000197>, <6.074574, -0.121838, -0.000197>, 
      <6.256242, -0.026161, 3.296675>, <6.201741, -0.026161, 2.307613>, <6.163880, -0.026161, -0.000197>, <6.074574, -0.026161, -0.000197>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <6.256242, -0.211345, 4.346232>, <6.239710, -0.211345, 4.346232>, <6.091106, -0.211345, 4.346232>, <6.074574, -0.211345, 4.346232>, 
      <6.256242, -0.272676, 4.215944>, <6.239710, -0.272676, 4.215944>, <6.091106, -0.272676, 4.215944>, <6.074574, -0.272676, 4.215944>, 
      <6.256242, -0.265922, 3.841697>, <6.201741, -0.265922, 3.841697>, <6.129074, -0.224716, 3.846190>, <6.074574, -0.224716, 3.846190>, 
      <6.256242, -0.211346, 3.532377>, <6.201741, -0.211346, 3.532377>, <6.129074, -0.211346, 3.532377>, <6.074574, -0.211346, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <6.256242, 0.171765, 4.346232>, <6.239710, 0.171765, 4.346232>, <6.091106, 0.171765, 4.346232>, <6.074575, 0.171765, 4.346232>, 
      <6.256242, 0.142894, 4.407563>, <6.239710, 0.142894, 4.407563>, <6.091106, 0.142894, 4.407563>, <6.074575, 0.142894, 4.407563>, 
      <6.256242, -0.182474, 4.407563>, <6.239710, -0.182474, 4.407563>, <6.091106, -0.182474, 4.407563>, <6.074574, -0.182474, 4.407563>, 
      <6.256242, -0.211345, 4.346232>, <6.239710, -0.211345, 4.346232>, <6.091106, -0.211345, 4.346232>, <6.074574, -0.211345, 4.346232>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <6.256242, 0.171765, 4.346232>, <6.256242, 0.233096, 4.215944>, <6.256242, 0.229972, 3.841034>, <6.256242, 0.171765, 3.532377>, 
      <6.239710, 0.171765, 4.346232>, <6.239710, 0.233096, 4.215944>, <6.201742, 0.229972, 3.841034>, <6.201742, 0.171765, 3.532377>, 
      <6.091106, 0.171765, 4.346232>, <6.091106, 0.233096, 4.215944>, <6.129075, 0.186053, 3.846150>, <6.129075, 0.171765, 3.532377>, 
      <6.074575, 0.171765, 4.346232>, <6.074575, 0.233096, 4.215944>, <6.074575, 0.186053, 3.846150>, <6.074575, 0.171765, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <6.437909, -0.026161, -0.000197>, <6.348603, -0.026161, -0.000197>, <6.310742, -0.026161, 2.307613>, <6.256242, -0.026161, 3.296675>, 
      <6.437909, 0.069534, -0.000197>, <6.348603, 0.069534, -0.000197>, <6.310742, 0.033217, 2.378324>, <6.256242, 0.033217, 3.367386>, 
      <6.437910, 0.109648, 2.168298>, <6.383409, 0.109648, 2.168298>, <6.310742, 0.149753, 3.415650>, <6.256242, 0.149753, 3.415650>, 
      <6.437910, 0.171765, 3.532377>, <6.383410, 0.171765, 3.532377>, <6.310742, 0.171765, 3.532377>, <6.256242, 0.171765, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <6.437909, -0.211346, 3.532377>, <6.383409, -0.211346, 3.532377>, <6.310742, -0.211346, 3.532377>, <6.256242, -0.211346, 3.532377>, 
      <6.437909, -0.153232, 2.168388>, <6.383409, -0.153232, 2.168388>, <6.310742, -0.191245, 3.418452>, <6.256242, -0.191245, 3.418452>, 
      <6.437909, -0.121838, -0.000197>, <6.348603, -0.121838, -0.000197>, <6.310742, -0.081716, 2.378324>, <6.256242, -0.081716, 3.367386>, 
      <6.437909, -0.026161, -0.000197>, <6.348603, -0.026161, -0.000197>, <6.310742, -0.026161, 2.307613>, <6.256242, -0.026161, 3.296675>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <6.437909, -0.211345, 4.346232>, <6.421377, -0.211345, 4.346232>, <6.272774, -0.211345, 4.346232>, <6.256242, -0.211345, 4.346232>, 
      <6.437909, -0.272676, 4.215944>, <6.421377, -0.272676, 4.215944>, <6.272774, -0.272676, 4.215944>, <6.256242, -0.272676, 4.215944>, 
      <6.437909, -0.224716, 3.846190>, <6.383409, -0.224716, 3.846190>, <6.310742, -0.265922, 3.841697>, <6.256242, -0.265922, 3.841697>, 
      <6.437909, -0.211346, 3.532377>, <6.383409, -0.211346, 3.532377>, <6.310742, -0.211346, 3.532377>, <6.256242, -0.211346, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <6.437910, 0.171765, 4.346232>, <6.421378, 0.171765, 4.346232>, <6.272774, 0.171765, 4.346232>, <6.256242, 0.171765, 4.346232>, 
      <6.437910, 0.142894, 4.407563>, <6.421378, 0.142894, 4.407563>, <6.272774, 0.142894, 4.407563>, <6.256242, 0.142894, 4.407563>, 
      <6.437909, -0.182474, 4.407563>, <6.421377, -0.182474, 4.407563>, <6.272774, -0.182474, 4.407563>, <6.256242, -0.182474, 4.407563>, 
      <6.437909, -0.211345, 4.346232>, <6.421377, -0.211345, 4.346232>, <6.272774, -0.211345, 4.346232>, <6.256242, -0.211345, 4.346232>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <6.437910, 0.171765, 4.346232>, <6.437910, 0.233096, 4.215944>, <6.437910, 0.186053, 3.846150>, <6.437910, 0.171765, 3.532377>, 
      <6.421378, 0.171765, 4.346232>, <6.421378, 0.233096, 4.215944>, <6.383410, 0.186053, 3.846150>, <6.383410, 0.171765, 3.532377>, 
      <6.272774, 0.171765, 4.346232>, <6.272774, 0.233096, 4.215944>, <6.310742, 0.229972, 3.841034>, <6.310742, 0.171765, 3.532377>, 
      <6.256242, 0.171765, 4.346232>, <6.256242, 0.233096, 4.215944>, <6.256242, 0.229972, 3.841034>, <6.256242, 0.171765, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <6.619576, -0.026161, 3.296675>, <6.565076, -0.026161, 2.307613>, <6.527215, -0.026161, -0.000197>, <6.437909, -0.026161, -0.000197>, 
      <6.619576, 0.033217, 3.367386>, <6.565076, 0.033217, 2.378324>, <6.527215, 0.069534, -0.000197>, <6.437909, 0.069534, -0.000197>, 
      <6.619577, 0.149753, 3.415650>, <6.565077, 0.149753, 3.415650>, <6.492410, 0.109648, 2.168298>, <6.437910, 0.109648, 2.168298>, 
      <6.619577, 0.171765, 3.532377>, <6.565077, 0.171765, 3.532377>, <6.492410, 0.171765, 3.532377>, <6.437910, 0.171765, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <6.619576, -0.211346, 3.532377>, <6.565076, -0.211346, 3.532377>, <6.492409, -0.211346, 3.532377>, <6.437909, -0.211346, 3.532377>, 
      <6.619576, -0.191245, 3.418452>, <6.565076, -0.191245, 3.418452>, <6.492409, -0.153232, 2.168388>, <6.437909, -0.153232, 2.168388>, 
      <6.619576, -0.081716, 3.367386>, <6.565076, -0.081716, 2.378324>, <6.527215, -0.121838, -0.000197>, <6.437909, -0.121838, -0.000197>, 
      <6.619576, -0.026161, 3.296675>, <6.565076, -0.026161, 2.307613>, <6.527215, -0.026161, -0.000197>, <6.437909, -0.026161, -0.000197>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <6.619576, -0.211345, 4.346232>, <6.603044, -0.211345, 4.346232>, <6.454440, -0.211345, 4.346232>, <6.437909, -0.211345, 4.346232>, 
      <6.619576, -0.272676, 4.215944>, <6.603044, -0.272676, 4.215944>, <6.454440, -0.272676, 4.215944>, <6.437909, -0.272676, 4.215944>, 
      <6.619576, -0.265922, 3.841697>, <6.565076, -0.265922, 3.841697>, <6.492409, -0.224716, 3.846190>, <6.437909, -0.224716, 3.846190>, 
      <6.619576, -0.211346, 3.532377>, <6.565076, -0.211346, 3.532377>, <6.492409, -0.211346, 3.532377>, <6.437909, -0.211346, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <6.619577, 0.171765, 4.346232>, <6.603046, 0.171765, 4.346232>, <6.454442, 0.171765, 4.346232>, <6.437910, 0.171765, 4.346232>, 
      <6.619577, 0.142894, 4.407563>, <6.603046, 0.142894, 4.407563>, <6.454442, 0.142894, 4.407563>, <6.437910, 0.142894, 4.407563>, 
      <6.619576, -0.182474, 4.407563>, <6.603044, -0.182474, 4.407563>, <6.454440, -0.182474, 4.407563>, <6.437909, -0.182474, 4.407563>, 
      <6.619576, -0.211345, 4.346232>, <6.603044, -0.211345, 4.346232>, <6.454440, -0.211345, 4.346232>, <6.437909, -0.211345, 4.346232>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <6.619577, 0.171765, 4.346232>, <6.619577, 0.233096, 4.215944>, <6.619578, 0.229972, 3.841034>, <6.619577, 0.171765, 3.532377>, 
      <6.603046, 0.171765, 4.346232>, <6.603046, 0.233096, 4.215944>, <6.565077, 0.229972, 3.841034>, <6.565077, 0.171765, 3.532377>, 
      <6.454442, 0.171765, 4.346232>, <6.454442, 0.233096, 4.215944>, <6.492410, 0.186053, 3.846150>, <6.492410, 0.171765, 3.532377>, 
      <6.437910, 0.171765, 4.346232>, <6.437910, 0.233096, 4.215944>, <6.437910, 0.186053, 3.846150>, <6.437910, 0.171765, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <6.801244, -0.026161, -0.000197>, <6.711938, -0.026161, -0.000197>, <6.674076, -0.026161, 2.307613>, <6.619576, -0.026161, 3.296675>, 
      <6.801244, 0.069534, -0.000197>, <6.711938, 0.069534, -0.000197>, <6.674077, 0.033217, 2.378324>, <6.619576, 0.033217, 3.367386>, 
      <6.801244, 0.109648, 2.168298>, <6.746744, 0.109648, 2.168298>, <6.674077, 0.149753, 3.415650>, <6.619577, 0.149753, 3.415650>, 
      <6.801244, 0.171765, 3.532377>, <6.746744, 0.171765, 3.532377>, <6.674077, 0.171765, 3.532377>, <6.619577, 0.171765, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <6.801244, -0.211346, 3.532377>, <6.746743, -0.211346, 3.532377>, <6.674076, -0.211346, 3.532377>, <6.619576, -0.211346, 3.532377>, 
      <6.801244, -0.153232, 2.168388>, <6.746743, -0.153232, 2.168388>, <6.674076, -0.191245, 3.418452>, <6.619576, -0.191245, 3.418452>, 
      <6.801244, -0.121838, -0.000197>, <6.711938, -0.121838, -0.000197>, <6.674076, -0.081716, 2.378324>, <6.619576, -0.081716, 3.367386>, 
      <6.801244, -0.026161, -0.000197>, <6.711938, -0.026161, -0.000197>, <6.674076, -0.026161, 2.307613>, <6.619576, -0.026161, 3.296675>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <6.801244, -0.211345, 4.346232>, <6.784712, -0.211345, 4.346232>, <6.636108, -0.211345, 4.346232>, <6.619576, -0.211345, 4.346232>, 
      <6.801244, -0.272676, 4.215944>, <6.784712, -0.272676, 4.215944>, <6.636108, -0.272676, 4.215944>, <6.619576, -0.272676, 4.215944>, 
      <6.801244, -0.224716, 3.846190>, <6.746743, -0.224716, 3.846190>, <6.674076, -0.265922, 3.841697>, <6.619576, -0.265922, 3.841697>, 
      <6.801244, -0.211346, 3.532377>, <6.746743, -0.211346, 3.532377>, <6.674076, -0.211346, 3.532377>, <6.619576, -0.211346, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <6.801244, 0.171765, 4.346232>, <6.784712, 0.171765, 4.346232>, <6.636108, 0.171765, 4.346232>, <6.619577, 0.171765, 4.346232>, 
      <6.801244, 0.142894, 4.407563>, <6.784712, 0.142894, 4.407563>, <6.636108, 0.142894, 4.407563>, <6.619577, 0.142894, 4.407563>, 
      <6.801244, -0.182474, 4.407563>, <6.784712, -0.182474, 4.407563>, <6.636108, -0.182474, 4.407563>, <6.619576, -0.182474, 4.407563>, 
      <6.801244, -0.211345, 4.346232>, <6.784712, -0.211345, 4.346232>, <6.636108, -0.211345, 4.346232>, <6.619576, -0.211345, 4.346232>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <6.801244, 0.171765, 4.346232>, <6.801244, 0.233096, 4.215944>, <6.801244, 0.186053, 3.846150>, <6.801244, 0.171765, 3.532377>, 
      <6.784712, 0.171765, 4.346232>, <6.784712, 0.233096, 4.215944>, <6.746744, 0.186053, 3.846150>, <6.746744, 0.171765, 3.532377>, 
      <6.636108, 0.171765, 4.346232>, <6.636108, 0.233096, 4.215944>, <6.674078, 0.229972, 3.841034>, <6.674077, 0.171765, 3.532377>, 
      <6.619577, 0.171765, 4.346232>, <6.619577, 0.233096, 4.215944>, <6.619578, 0.229972, 3.841034>, <6.619577, 0.171765, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <6.982911, -0.026161, 3.296675>, <6.928411, -0.026161, 2.307613>, <6.890550, -0.026161, -0.000197>, <6.801244, -0.026161, -0.000197>, 
      <6.982911, 0.033217, 3.367386>, <6.928411, 0.033217, 2.378324>, <6.890550, 0.069534, -0.000197>, <6.801244, 0.069534, -0.000197>, 
      <6.982912, 0.149753, 3.415650>, <6.928411, 0.149753, 3.415650>, <6.855744, 0.109648, 2.168298>, <6.801244, 0.109648, 2.168298>, 
      <6.982912, 0.171765, 3.532377>, <6.928411, 0.171765, 3.532377>, <6.855744, 0.171765, 3.532377>, <6.801244, 0.171765, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <6.982911, -0.211346, 3.532377>, <6.928411, -0.211346, 3.532377>, <6.855744, -0.211346, 3.532377>, <6.801244, -0.211346, 3.532377>, 
      <6.982911, -0.191245, 3.418452>, <6.928411, -0.191245, 3.418452>, <6.855744, -0.153232, 2.168388>, <6.801244, -0.153232, 2.168388>, 
      <6.982911, -0.081716, 3.367386>, <6.928411, -0.081716, 2.378324>, <6.890550, -0.121838, -0.000197>, <6.801244, -0.121838, -0.000197>, 
      <6.982911, -0.026161, 3.296675>, <6.928411, -0.026161, 2.307613>, <6.890550, -0.026161, -0.000197>, <6.801244, -0.026161, -0.000197>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <6.982911, -0.211345, 4.346232>, <6.966423, -0.211345, 4.347440>, <6.817776, -0.211345, 4.346232>, <6.801244, -0.211345, 4.346232>, 
      <6.982911, -0.272676, 4.215944>, <6.966423, -0.272676, 4.217152>, <6.817776, -0.272676, 4.215944>, <6.801244, -0.272676, 4.215944>, 
      <6.982911, -0.265922, 3.841697>, <6.928411, -0.265922, 3.841697>, <6.855744, -0.224716, 3.846190>, <6.801244, -0.224716, 3.846190>, 
      <6.982911, -0.211346, 3.532377>, <6.928411, -0.211346, 3.532377>, <6.855744, -0.211346, 3.532377>, <6.801244, -0.211346, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <6.982912, 0.171765, 4.346232>, <6.966425, 0.171765, 4.347440>, <6.817776, 0.171765, 4.346232>, <6.801244, 0.171765, 4.346232>, 
      <6.982912, 0.142894, 4.407563>, <6.966425, 0.142894, 4.408772>, <6.817776, 0.142894, 4.407563>, <6.801244, 0.142894, 4.407563>, 
      <6.982911, -0.182474, 4.407563>, <6.966423, -0.182474, 4.408772>, <6.817776, -0.182474, 4.407563>, <6.801244, -0.182474, 4.407563>, 
      <6.982911, -0.211345, 4.346232>, <6.966423, -0.211345, 4.347440>, <6.817776, -0.211345, 4.346232>, <6.801244, -0.211345, 4.346232>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <6.982912, 0.171765, 4.346232>, <6.982912, 0.233096, 4.215944>, <6.982913, 0.229972, 3.841034>, <6.982912, 0.171765, 3.532377>, 
      <6.966425, 0.171765, 4.347440>, <6.966425, 0.233096, 4.217152>, <6.928412, 0.229972, 3.841034>, <6.928411, 0.171765, 3.532377>, 
      <6.817776, 0.171765, 4.346232>, <6.817776, 0.233096, 4.215944>, <6.855744, 0.186053, 3.846150>, <6.855744, 0.171765, 3.532377>, 
      <6.801244, 0.171765, 4.346232>, <6.801244, 0.233096, 4.215944>, <6.801244, 0.186053, 3.846150>, <6.801244, 0.171765, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <7.164579, -0.026161, -0.000197>, <7.164579, 0.069534, -0.000197>, <7.164579, 0.109266, 2.168315>, <7.164580, 0.171765, 3.532377>, 
      <7.253885, -0.026161, -0.000197>, <7.253885, 0.069534, -0.000197>, <7.219079, 0.109266, 2.168315>, <7.219080, 0.171765, 3.532377>, 
      <7.291746, -0.026161, 2.307613>, <7.291746, 0.033217, 2.378324>, <7.291747, 0.148009, 3.415992>, <7.291747, 0.171765, 3.532377>, 
      <7.346247, -0.026161, 3.296675>, <7.346247, 0.033217, 3.367386>, <7.346247, 0.148009, 3.415992>, <7.346247, 0.171765, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <7.164579, -0.026161, -0.000197>, <7.075273, -0.026161, -0.000197>, <7.037412, -0.026161, 2.307613>, <6.982911, -0.026161, 3.296675>, 
      <7.164579, 0.069534, -0.000197>, <7.075273, 0.069534, -0.000197>, <7.037412, 0.033217, 2.378324>, <6.982911, 0.033217, 3.367386>, 
      <7.164579, 0.109266, 2.168315>, <7.110079, 0.109266, 2.168315>, <7.037413, 0.149753, 3.415650>, <6.982912, 0.149753, 3.415650>, 
      <7.164580, 0.171765, 3.532377>, <7.110079, 0.171765, 3.532377>, <7.037413, 0.171765, 3.532377>, <6.982912, 0.171765, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <7.164579, -0.211346, 3.532377>, <7.164579, -0.152874, 2.168403>, <7.164579, -0.121838, -0.000197>, <7.164579, -0.026161, -0.000197>, 
      <7.219079, -0.211346, 3.532377>, <7.219079, -0.152874, 2.168403>, <7.253885, -0.121838, -0.000197>, <7.253885, -0.026161, -0.000197>, 
      <7.291746, -0.211346, 3.532377>, <7.291746, -0.189645, 3.418746>, <7.291746, -0.081716, 2.378324>, <7.291746, -0.026161, 2.307613>, 
      <7.346247, -0.211346, 3.532377>, <7.346247, -0.189645, 3.418746>, <7.346247, -0.081716, 3.367386>, <7.346247, -0.026161, 3.296675>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <7.164579, -0.211346, 3.532377>, <7.110078, -0.211346, 3.532377>, <7.037412, -0.211346, 3.532377>, <6.982911, -0.211346, 3.532377>, 
      <7.164579, -0.152874, 2.168403>, <7.110078, -0.152874, 2.168403>, <7.037412, -0.191245, 3.418452>, <6.982911, -0.191245, 3.418452>, 
      <7.164579, -0.121838, -0.000197>, <7.075273, -0.121838, -0.000197>, <7.037412, -0.081716, 2.378324>, <6.982911, -0.081716, 3.367386>, 
      <7.164579, -0.026161, -0.000197>, <7.075273, -0.026161, -0.000197>, <7.037412, -0.026161, 2.307613>, <6.982911, -0.026161, 3.296675>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <7.164579, -0.211345, 4.319606>, <7.164579, -0.272297, 4.194359>, <7.164579, -0.224358, 3.835920>, <7.164579, -0.211346, 3.532377>, 
      <7.181405, -0.211345, 4.315907>, <7.181405, -0.272297, 4.190660>, <7.219079, -0.224358, 3.835920>, <7.219079, -0.211346, 3.532377>, 
      <7.330217, -0.211345, 4.272664>, <7.330217, -0.271438, 4.157535>, <7.291746, -0.264483, 3.810618>, <7.291746, -0.211346, 3.532377>, 
      <7.346247, -0.211345, 4.266354>, <7.346247, -0.271438, 4.151226>, <7.346247, -0.264483, 3.810618>, <7.346247, -0.211346, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <7.164579, -0.211345, 4.319606>, <7.148260, -0.211345, 4.323194>, <6.999574, -0.211345, 4.345011>, <6.982911, -0.211345, 4.346232>, 
      <7.164579, -0.272297, 4.194359>, <7.148260, -0.272297, 4.197947>, <6.999574, -0.272676, 4.214723>, <6.982911, -0.272676, 4.215944>, 
      <7.164579, -0.224358, 3.835920>, <7.110078, -0.224358, 3.835920>, <7.037412, -0.265922, 3.841697>, <6.982911, -0.265922, 3.841697>, 
      <7.164579, -0.211346, 3.532377>, <7.110078, -0.211346, 3.532377>, <7.037412, -0.211346, 3.532377>, <6.982911, -0.211346, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <7.164580, 0.171765, 4.319606>, <7.164580, 0.142102, 4.380558>, <7.164579, -0.181682, 4.380558>, <7.164579, -0.211345, 4.319606>, 
      <7.181406, 0.171765, 4.315907>, <7.181406, 0.142102, 4.376859>, <7.181405, -0.181682, 4.376859>, <7.181405, -0.211345, 4.315907>, 
      <7.330217, 0.171765, 4.272664>, <7.330217, 0.140399, 4.332756>, <7.330217, -0.179979, 4.332756>, <7.330217, -0.211345, 4.272664>, 
      <7.346247, 0.171765, 4.266354>, <7.346247, 0.140399, 4.326447>, <7.346247, -0.179979, 4.326447>, <7.346247, -0.211345, 4.266354>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <7.164580, 0.171765, 4.319606>, <7.148261, 0.171765, 4.323194>, <6.999576, 0.171765, 4.345011>, <6.982912, 0.171765, 4.346232>, 
      <7.164580, 0.142102, 4.380558>, <7.148261, 0.142102, 4.384146>, <6.999576, 0.142894, 4.406342>, <6.982912, 0.142894, 4.407563>, 
      <7.164579, -0.181682, 4.380558>, <7.148260, -0.181682, 4.384146>, <6.999574, -0.182474, 4.406342>, <6.982911, -0.182474, 4.407563>, 
      <7.164579, -0.211345, 4.319606>, <7.148260, -0.211345, 4.323194>, <6.999574, -0.211345, 4.345011>, <6.982911, -0.211345, 4.346232>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <7.164580, 0.171765, 4.319606>, <7.181406, 0.171765, 4.315907>, <7.330217, 0.171765, 4.272664>, <7.346247, 0.171765, 4.266354>, 
      <7.164580, 0.232717, 4.194359>, <7.181406, 0.232717, 4.190660>, <7.330217, 0.231858, 4.157535>, <7.346247, 0.231858, 4.151226>, 
      <7.164580, 0.185671, 3.835880>, <7.219080, 0.185671, 3.835880>, <7.291747, 0.228416, 3.809924>, <7.346247, 0.228416, 3.809924>, 
      <7.164580, 0.171765, 3.532377>, <7.219080, 0.171765, 3.532377>, <7.291747, 0.171765, 3.532377>, <7.346247, 0.171765, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <7.164580, 0.171765, 4.319606>, <7.164580, 0.232717, 4.194359>, <7.164580, 0.185671, 3.835880>, <7.164580, 0.171765, 3.532377>, 
      <7.148261, 0.171765, 4.323194>, <7.148261, 0.232717, 4.197947>, <7.110079, 0.185671, 3.835880>, <7.110079, 0.171765, 3.532377>, 
      <6.999576, 0.171765, 4.345011>, <6.999576, 0.233096, 4.214723>, <7.037413, 0.229972, 3.841034>, <7.037413, 0.171765, 3.532377>, 
      <6.982912, 0.171765, 4.346232>, <6.982912, 0.233096, 4.215944>, <6.982913, 0.229972, 3.841034>, <6.982912, 0.171765, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.439088, -0.026161, 3.296675>, <0.384588, -0.026161, 2.307613>, <0.346726, -0.026161, -0.000197>, <0.257420, -0.026161, -0.000197>, 
      <0.439088, 0.033217, 3.367386>, <0.384588, 0.033217, 2.378324>, <0.346726, 0.069534, -0.000197>, <0.257420, 0.069534, -0.000197>, 
      <0.439088, 0.149753, 3.415650>, <0.384588, 0.149753, 3.415650>, <0.311920, 0.109648, 2.168298>, <0.257420, 0.109648, 2.168298>, 
      <0.439088, 0.171765, 3.532377>, <0.384588, 0.171765, 3.532377>, <0.311920, 0.171765, 3.532377>, <0.257420, 0.171765, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.439088, -0.211346, 3.532377>, <0.384588, -0.211346, 3.532377>, <0.311920, -0.211346, 3.532377>, <0.257420, -0.211346, 3.532377>, 
      <0.439088, -0.191245, 3.418452>, <0.384588, -0.191245, 3.418452>, <0.311920, -0.153232, 2.168388>, <0.257420, -0.153232, 2.168388>, 
      <0.439088, -0.081716, 3.367386>, <0.384588, -0.081716, 2.378324>, <0.346726, -0.121838, -0.000197>, <0.257420, -0.121838, -0.000197>, 
      <0.439088, -0.026161, 3.296675>, <0.384588, -0.026161, 2.307613>, <0.346726, -0.026161, -0.000197>, <0.257420, -0.026161, -0.000197>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.439088, -0.211345, 4.346232>, <0.422556, -0.211345, 4.346232>, <0.273952, -0.211345, 4.346232>, <0.257420, -0.211345, 4.346232>, 
      <0.439088, -0.272676, 4.215944>, <0.422556, -0.272676, 4.215944>, <0.273952, -0.272676, 4.215944>, <0.257420, -0.272676, 4.215944>, 
      <0.439088, -0.265922, 3.841697>, <0.384588, -0.265922, 3.841697>, <0.311920, -0.224716, 3.846190>, <0.257420, -0.224716, 3.846190>, 
      <0.439088, -0.211346, 3.532377>, <0.384588, -0.211346, 3.532377>, <0.311920, -0.211346, 3.532377>, <0.257420, -0.211346, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.439088, 0.171765, 4.346232>, <0.422556, 0.171765, 4.346232>, <0.273952, 0.171765, 4.346232>, <0.257420, 0.171765, 4.346232>, 
      <0.439088, 0.142894, 4.407563>, <0.422556, 0.142894, 4.407563>, <0.273952, 0.142894, 4.407563>, <0.257420, 0.142894, 4.407563>, 
      <0.439088, -0.182474, 4.407563>, <0.422556, -0.182474, 4.407563>, <0.273952, -0.182474, 4.407563>, <0.257420, -0.182474, 4.407563>, 
      <0.439088, -0.211345, 4.346232>, <0.422556, -0.211345, 4.346232>, <0.273952, -0.211345, 4.346232>, <0.257420, -0.211345, 4.346232>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.439088, 0.171765, 4.346232>, <0.439088, 0.233096, 4.215944>, <0.439088, 0.229972, 3.841034>, <0.439088, 0.171765, 3.532377>, 
      <0.422556, 0.171765, 4.346232>, <0.422556, 0.233096, 4.215944>, <0.384588, 0.229972, 3.841034>, <0.384588, 0.171765, 3.532377>, 
      <0.273952, 0.171765, 4.346232>, <0.273952, 0.233096, 4.215944>, <0.311920, 0.186053, 3.846150>, <0.311920, 0.171765, 3.532377>, 
      <0.257420, 0.171765, 4.346232>, <0.257420, 0.233096, 4.215944>, <0.257420, 0.186053, 3.846150>, <0.257420, 0.171765, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.620755, -0.026161, -0.000197>, <0.531449, -0.026161, -0.000197>, <0.493588, -0.026161, 2.307613>, <0.439088, -0.026161, 3.296675>, 
      <0.620755, 0.069534, -0.000197>, <0.531449, 0.069534, -0.000197>, <0.493588, 0.033217, 2.378324>, <0.439088, 0.033217, 3.367386>, 
      <0.620755, 0.109648, 2.168298>, <0.566255, 0.109648, 2.168298>, <0.493588, 0.149753, 3.415650>, <0.439088, 0.149753, 3.415650>, 
      <0.620755, 0.171765, 3.532377>, <0.566255, 0.171765, 3.532377>, <0.493588, 0.171765, 3.532377>, <0.439088, 0.171765, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.620755, -0.211346, 3.532377>, <0.566255, -0.211346, 3.532377>, <0.493588, -0.211346, 3.532377>, <0.439088, -0.211346, 3.532377>, 
      <0.620755, -0.153232, 2.168388>, <0.566255, -0.153232, 2.168388>, <0.493588, -0.191245, 3.418452>, <0.439088, -0.191245, 3.418452>, 
      <0.620755, -0.121838, -0.000197>, <0.531449, -0.121838, -0.000197>, <0.493588, -0.081716, 2.378324>, <0.439088, -0.081716, 3.367386>, 
      <0.620755, -0.026161, -0.000197>, <0.531449, -0.026161, -0.000197>, <0.493588, -0.026161, 2.307613>, <0.439088, -0.026161, 3.296675>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.620755, -0.211345, 4.346232>, <0.604223, -0.211345, 4.346232>, <0.455620, -0.211345, 4.346232>, <0.439088, -0.211345, 4.346232>, 
      <0.620755, -0.272676, 4.215944>, <0.604223, -0.272676, 4.215944>, <0.455620, -0.272676, 4.215944>, <0.439088, -0.272676, 4.215944>, 
      <0.620755, -0.224716, 3.846190>, <0.566255, -0.224716, 3.846190>, <0.493588, -0.265922, 3.841697>, <0.439088, -0.265922, 3.841697>, 
      <0.620755, -0.211346, 3.532377>, <0.566255, -0.211346, 3.532377>, <0.493588, -0.211346, 3.532377>, <0.439088, -0.211346, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.620755, 0.171765, 4.346232>, <0.604223, 0.171765, 4.346232>, <0.455620, 0.171765, 4.346232>, <0.439088, 0.171765, 4.346232>, 
      <0.620755, 0.142894, 4.407563>, <0.604223, 0.142894, 4.407563>, <0.455620, 0.142894, 4.407563>, <0.439088, 0.142894, 4.407563>, 
      <0.620755, -0.182474, 4.407563>, <0.604223, -0.182474, 4.407563>, <0.455620, -0.182474, 4.407563>, <0.439088, -0.182474, 4.407563>, 
      <0.620755, -0.211345, 4.346232>, <0.604223, -0.211345, 4.346232>, <0.455620, -0.211345, 4.346232>, <0.439088, -0.211345, 4.346232>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.620755, 0.171765, 4.346232>, <0.620755, 0.233096, 4.215944>, <0.620755, 0.186053, 3.846150>, <0.620755, 0.171765, 3.532377>, 
      <0.604223, 0.171765, 4.346232>, <0.604223, 0.233096, 4.215944>, <0.566255, 0.186053, 3.846150>, <0.566255, 0.171765, 3.532377>, 
      <0.455620, 0.171765, 4.346232>, <0.455620, 0.233096, 4.215944>, <0.493588, 0.229972, 3.841034>, <0.493588, 0.171765, 3.532377>, 
      <0.439088, 0.171765, 4.346232>, <0.439088, 0.233096, 4.215944>, <0.439088, 0.229972, 3.841034>, <0.439088, 0.171765, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.802423, -0.026161, 3.296675>, <0.747923, -0.026161, 2.307613>, <0.710061, -0.026161, -0.000197>, <0.620755, -0.026161, -0.000197>, 
      <0.802423, 0.033217, 3.367386>, <0.747923, 0.033217, 2.378324>, <0.710061, 0.069534, -0.000197>, <0.620755, 0.069534, -0.000197>, 
      <0.802423, 0.149753, 3.415650>, <0.747923, 0.149753, 3.415650>, <0.675255, 0.109648, 2.168298>, <0.620755, 0.109648, 2.168298>, 
      <0.802423, 0.171765, 3.532377>, <0.747923, 0.171765, 3.532377>, <0.675255, 0.171765, 3.532377>, <0.620755, 0.171765, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.802423, -0.211346, 3.532377>, <0.747923, -0.211346, 3.532377>, <0.675255, -0.211346, 3.532377>, <0.620755, -0.211346, 3.532377>, 
      <0.802423, -0.191245, 3.418452>, <0.747923, -0.191245, 3.418452>, <0.675255, -0.153232, 2.168388>, <0.620755, -0.153232, 2.168388>, 
      <0.802423, -0.081716, 3.367386>, <0.747923, -0.081716, 2.378324>, <0.710061, -0.121838, -0.000197>, <0.620755, -0.121838, -0.000197>, 
      <0.802423, -0.026161, 3.296675>, <0.747923, -0.026161, 2.307613>, <0.710061, -0.026161, -0.000197>, <0.620755, -0.026161, -0.000197>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.802423, -0.211345, 4.346232>, <0.785891, -0.211345, 4.346232>, <0.637287, -0.211345, 4.346232>, <0.620755, -0.211345, 4.346232>, 
      <0.802423, -0.272676, 4.215944>, <0.785891, -0.272676, 4.215944>, <0.637287, -0.272676, 4.215944>, <0.620755, -0.272676, 4.215944>, 
      <0.802423, -0.265922, 3.841697>, <0.747923, -0.265922, 3.841697>, <0.675255, -0.224716, 3.846190>, <0.620755, -0.224716, 3.846190>, 
      <0.802423, -0.211346, 3.532377>, <0.747923, -0.211346, 3.532377>, <0.675255, -0.211346, 3.532377>, <0.620755, -0.211346, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.802423, 0.171765, 4.346232>, <0.785891, 0.171765, 4.346232>, <0.637287, 0.171765, 4.346232>, <0.620755, 0.171765, 4.346232>, 
      <0.802423, 0.142894, 4.407563>, <0.785891, 0.142894, 4.407563>, <0.637287, 0.142894, 4.407563>, <0.620755, 0.142894, 4.407563>, 
      <0.802423, -0.182474, 4.407563>, <0.785891, -0.182474, 4.407563>, <0.637287, -0.182474, 4.407563>, <0.620755, -0.182474, 4.407563>, 
      <0.802423, -0.211345, 4.346232>, <0.785891, -0.211345, 4.346232>, <0.637287, -0.211345, 4.346232>, <0.620755, -0.211345, 4.346232>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.802423, 0.171765, 4.346232>, <0.802423, 0.233096, 4.215944>, <0.802423, 0.229972, 3.841034>, <0.802423, 0.171765, 3.532377>, 
      <0.785891, 0.171765, 4.346232>, <0.785891, 0.233096, 4.215944>, <0.747923, 0.229972, 3.841034>, <0.747923, 0.171765, 3.532377>, 
      <0.637287, 0.171765, 4.346232>, <0.637287, 0.233096, 4.215944>, <0.675255, 0.186053, 3.846150>, <0.675255, 0.171765, 3.532377>, 
      <0.620755, 0.171765, 4.346232>, <0.620755, 0.233096, 4.215944>, <0.620755, 0.186053, 3.846150>, <0.620755, 0.171765, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.984090, -0.026161, -0.000197>, <0.894784, -0.026161, -0.000197>, <0.856923, -0.026161, 2.307613>, <0.802423, -0.026161, 3.296675>, 
      <0.984090, 0.069534, -0.000197>, <0.894784, 0.069534, -0.000197>, <0.856923, 0.033217, 2.378324>, <0.802423, 0.033217, 3.367386>, 
      <0.984090, 0.109648, 2.168298>, <0.929590, 0.109648, 2.168298>, <0.856923, 0.149753, 3.415650>, <0.802423, 0.149753, 3.415650>, 
      <0.984090, 0.171765, 3.532377>, <0.929590, 0.171765, 3.532377>, <0.856923, 0.171765, 3.532377>, <0.802423, 0.171765, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.984090, -0.211346, 3.532377>, <0.929590, -0.211346, 3.532377>, <0.856923, -0.211346, 3.532377>, <0.802423, -0.211346, 3.532377>, 
      <0.984090, -0.153232, 2.168388>, <0.929590, -0.153232, 2.168388>, <0.856923, -0.191245, 3.418452>, <0.802423, -0.191245, 3.418452>, 
      <0.984090, -0.121838, -0.000197>, <0.894784, -0.121838, -0.000197>, <0.856923, -0.081716, 2.378324>, <0.802423, -0.081716, 3.367386>, 
      <0.984090, -0.026161, -0.000197>, <0.894784, -0.026161, -0.000197>, <0.856923, -0.026161, 2.307613>, <0.802423, -0.026161, 3.296675>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.984090, -0.211345, 4.346232>, <0.967558, -0.211345, 4.346232>, <0.818955, -0.211345, 4.346232>, <0.802423, -0.211345, 4.346232>, 
      <0.984090, -0.272676, 4.215944>, <0.967558, -0.272676, 4.215944>, <0.818955, -0.272676, 4.215944>, <0.802423, -0.272676, 4.215944>, 
      <0.984090, -0.224716, 3.846190>, <0.929590, -0.224716, 3.846190>, <0.856923, -0.265922, 3.841697>, <0.802423, -0.265922, 3.841697>, 
      <0.984090, -0.211346, 3.532377>, <0.929590, -0.211346, 3.532377>, <0.856923, -0.211346, 3.532377>, <0.802423, -0.211346, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.984090, 0.171765, 4.346232>, <0.967558, 0.171765, 4.346232>, <0.818955, 0.171765, 4.346232>, <0.802423, 0.171765, 4.346232>, 
      <0.984090, 0.142894, 4.407563>, <0.967558, 0.142894, 4.407563>, <0.818955, 0.142894, 4.407563>, <0.802423, 0.142894, 4.407563>, 
      <0.984090, -0.182474, 4.407563>, <0.967558, -0.182474, 4.407563>, <0.818955, -0.182474, 4.407563>, <0.802423, -0.182474, 4.407563>, 
      <0.984090, -0.211345, 4.346232>, <0.967558, -0.211345, 4.346232>, <0.818955, -0.211345, 4.346232>, <0.802423, -0.211345, 4.346232>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.984090, 0.171765, 4.346232>, <0.984090, 0.233096, 4.215944>, <0.984090, 0.186053, 3.846150>, <0.984090, 0.171765, 3.532377>, 
      <0.967558, 0.171765, 4.346232>, <0.967558, 0.233096, 4.215944>, <0.929590, 0.186053, 3.846150>, <0.929590, 0.171765, 3.532377>, 
      <0.818955, 0.171765, 4.346232>, <0.818955, 0.233096, 4.215944>, <0.856923, 0.229972, 3.841034>, <0.856923, 0.171765, 3.532377>, 
      <0.802423, 0.171765, 4.346232>, <0.802423, 0.233096, 4.215944>, <0.802423, 0.229972, 3.841034>, <0.802423, 0.171765, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.165758, -0.026161, 3.296675>, <1.111258, -0.026161, 2.307613>, <1.073396, -0.026161, -0.000197>, <0.984090, -0.026161, -0.000197>, 
      <1.165758, 0.033217, 3.367386>, <1.111258, 0.033217, 2.378324>, <1.073396, 0.069534, -0.000197>, <0.984090, 0.069534, -0.000197>, 
      <1.165758, 0.149753, 3.415650>, <1.111258, 0.149753, 3.415650>, <1.038590, 0.109648, 2.168298>, <0.984090, 0.109648, 2.168298>, 
      <1.165758, 0.171765, 3.532377>, <1.111258, 0.171765, 3.532377>, <1.038590, 0.171765, 3.532377>, <0.984090, 0.171765, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.165758, -0.211346, 3.532377>, <1.111258, -0.211346, 3.532377>, <1.038590, -0.211346, 3.532377>, <0.984090, -0.211346, 3.532377>, 
      <1.165758, -0.191245, 3.418452>, <1.111258, -0.191245, 3.418452>, <1.038590, -0.153232, 2.168388>, <0.984090, -0.153232, 2.168388>, 
      <1.165758, -0.081716, 3.367386>, <1.111258, -0.081716, 2.378324>, <1.073396, -0.121838, -0.000197>, <0.984090, -0.121838, -0.000197>, 
      <1.165758, -0.026161, 3.296675>, <1.111258, -0.026161, 2.307613>, <1.073396, -0.026161, -0.000197>, <0.984090, -0.026161, -0.000197>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.165758, -0.211345, 4.346232>, <1.149226, -0.211345, 4.346232>, <1.000622, -0.211345, 4.346232>, <0.984090, -0.211345, 4.346232>, 
      <1.165758, -0.272676, 4.215944>, <1.149226, -0.272676, 4.215944>, <1.000622, -0.272676, 4.215944>, <0.984090, -0.272676, 4.215944>, 
      <1.165758, -0.265922, 3.841697>, <1.111258, -0.265922, 3.841697>, <1.038590, -0.224716, 3.846190>, <0.984090, -0.224716, 3.846190>, 
      <1.165758, -0.211346, 3.532377>, <1.111258, -0.211346, 3.532377>, <1.038590, -0.211346, 3.532377>, <0.984090, -0.211346, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.165758, 0.171765, 4.346232>, <1.149226, 0.171765, 4.346232>, <1.000622, 0.171765, 4.346232>, <0.984090, 0.171765, 4.346232>, 
      <1.165758, 0.142894, 4.407563>, <1.149226, 0.142894, 4.407563>, <1.000622, 0.142894, 4.407563>, <0.984090, 0.142894, 4.407563>, 
      <1.165758, -0.182474, 4.407563>, <1.149226, -0.182474, 4.407563>, <1.000622, -0.182474, 4.407563>, <0.984090, -0.182474, 4.407563>, 
      <1.165758, -0.211345, 4.346232>, <1.149226, -0.211345, 4.346232>, <1.000622, -0.211345, 4.346232>, <0.984090, -0.211345, 4.346232>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.165758, 0.171765, 4.346232>, <1.165758, 0.233096, 4.215944>, <1.165758, 0.229972, 3.841034>, <1.165758, 0.171765, 3.532377>, 
      <1.149226, 0.171765, 4.346232>, <1.149226, 0.233096, 4.215944>, <1.111258, 0.229972, 3.841034>, <1.111258, 0.171765, 3.532377>, 
      <1.000622, 0.171765, 4.346232>, <1.000622, 0.233096, 4.215944>, <1.038590, 0.186053, 3.846150>, <1.038590, 0.171765, 3.532377>, 
      <0.984090, 0.171765, 4.346232>, <0.984090, 0.233096, 4.215944>, <0.984090, 0.186053, 3.846150>, <0.984090, 0.171765, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.347426, -0.026161, -0.000197>, <1.258120, -0.026161, -0.000197>, <1.220258, -0.026161, 2.307613>, <1.165758, -0.026161, 3.296675>, 
      <1.347426, 0.069534, -0.000197>, <1.258120, 0.069534, -0.000197>, <1.220258, 0.033217, 2.378324>, <1.165758, 0.033217, 3.367386>, 
      <1.347426, 0.109648, 2.168298>, <1.292926, 0.109648, 2.168298>, <1.220258, 0.149753, 3.415650>, <1.165758, 0.149753, 3.415650>, 
      <1.347426, 0.171765, 3.532377>, <1.292926, 0.171765, 3.532377>, <1.220258, 0.171765, 3.532377>, <1.165758, 0.171765, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.347426, -0.211346, 3.532377>, <1.292926, -0.211346, 3.532377>, <1.220258, -0.211346, 3.532377>, <1.165758, -0.211346, 3.532377>, 
      <1.347426, -0.153232, 2.168388>, <1.292926, -0.153232, 2.168388>, <1.220258, -0.191245, 3.418452>, <1.165758, -0.191245, 3.418452>, 
      <1.347426, -0.121838, -0.000197>, <1.258120, -0.121838, -0.000197>, <1.220258, -0.081716, 2.378324>, <1.165758, -0.081716, 3.367386>, 
      <1.347426, -0.026161, -0.000197>, <1.258120, -0.026161, -0.000197>, <1.220258, -0.026161, 2.307613>, <1.165758, -0.026161, 3.296675>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.347426, -0.211345, 4.346232>, <1.330894, -0.211345, 4.346232>, <1.182290, -0.211345, 4.346232>, <1.165758, -0.211345, 4.346232>, 
      <1.347426, -0.272676, 4.215944>, <1.330894, -0.272676, 4.215944>, <1.182290, -0.272676, 4.215944>, <1.165758, -0.272676, 4.215944>, 
      <1.347426, -0.224716, 3.846190>, <1.292926, -0.224716, 3.846190>, <1.220258, -0.265922, 3.841697>, <1.165758, -0.265922, 3.841697>, 
      <1.347426, -0.211346, 3.532377>, <1.292926, -0.211346, 3.532377>, <1.220258, -0.211346, 3.532377>, <1.165758, -0.211346, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.347426, 0.171765, 4.346232>, <1.330894, 0.171765, 4.346232>, <1.182290, 0.171765, 4.346232>, <1.165758, 0.171765, 4.346232>, 
      <1.347426, 0.142894, 4.407563>, <1.330894, 0.142894, 4.407563>, <1.182290, 0.142894, 4.407563>, <1.165758, 0.142894, 4.407563>, 
      <1.347426, -0.182474, 4.407563>, <1.330894, -0.182474, 4.407563>, <1.182290, -0.182474, 4.407563>, <1.165758, -0.182474, 4.407563>, 
      <1.347426, -0.211345, 4.346232>, <1.330894, -0.211345, 4.346232>, <1.182290, -0.211345, 4.346232>, <1.165758, -0.211345, 4.346232>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.347426, 0.171765, 4.346232>, <1.347426, 0.233096, 4.215944>, <1.347426, 0.186053, 3.846150>, <1.347426, 0.171765, 3.532377>, 
      <1.330894, 0.171765, 4.346232>, <1.330894, 0.233096, 4.215944>, <1.292926, 0.186053, 3.846150>, <1.292926, 0.171765, 3.532377>, 
      <1.182290, 0.171765, 4.346232>, <1.182290, 0.233096, 4.215944>, <1.220258, 0.229972, 3.841034>, <1.220258, 0.171765, 3.532377>, 
      <1.165758, 0.171765, 4.346232>, <1.165758, 0.233096, 4.215944>, <1.165758, 0.229972, 3.841034>, <1.165758, 0.171765, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.529094, -0.026161, 3.296675>, <1.474594, -0.026161, 2.307613>, <1.436732, -0.026161, -0.000197>, <1.347426, -0.026161, -0.000197>, 
      <1.529094, 0.033217, 3.367386>, <1.474594, 0.033217, 2.378324>, <1.436732, 0.069534, -0.000197>, <1.347426, 0.069534, -0.000197>, 
      <1.529094, 0.149753, 3.415650>, <1.474594, 0.149753, 3.415650>, <1.401926, 0.109648, 2.168298>, <1.347426, 0.109648, 2.168298>, 
      <1.529094, 0.171765, 3.532377>, <1.474594, 0.171765, 3.532377>, <1.401926, 0.171765, 3.532377>, <1.347426, 0.171765, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.529094, -0.211346, 3.532377>, <1.474594, -0.211346, 3.532377>, <1.401926, -0.211346, 3.532377>, <1.347426, -0.211346, 3.532377>, 
      <1.529094, -0.191245, 3.418452>, <1.474594, -0.191245, 3.418452>, <1.401926, -0.153232, 2.168388>, <1.347426, -0.153232, 2.168388>, 
      <1.529094, -0.081716, 3.367386>, <1.474594, -0.081716, 2.378324>, <1.436732, -0.121838, -0.000197>, <1.347426, -0.121838, -0.000197>, 
      <1.529094, -0.026161, 3.296675>, <1.474594, -0.026161, 2.307613>, <1.436732, -0.026161, -0.000197>, <1.347426, -0.026161, -0.000197>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.529094, -0.211345, 4.346232>, <1.512562, -0.211345, 4.346232>, <1.363958, -0.211345, 4.346232>, <1.347426, -0.211345, 4.346232>, 
      <1.529094, -0.272676, 4.215944>, <1.512562, -0.272676, 4.215944>, <1.363958, -0.272676, 4.215944>, <1.347426, -0.272676, 4.215944>, 
      <1.529094, -0.265922, 3.841697>, <1.474594, -0.265922, 3.841697>, <1.401926, -0.224716, 3.846190>, <1.347426, -0.224716, 3.846190>, 
      <1.529094, -0.211346, 3.532377>, <1.474594, -0.211346, 3.532377>, <1.401926, -0.211346, 3.532377>, <1.347426, -0.211346, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.529094, 0.171765, 4.346232>, <1.512562, 0.171765, 4.346232>, <1.363958, 0.171765, 4.346232>, <1.347426, 0.171765, 4.346232>, 
      <1.529094, 0.142894, 4.407563>, <1.512562, 0.142894, 4.407563>, <1.363958, 0.142894, 4.407563>, <1.347426, 0.142894, 4.407563>, 
      <1.529094, -0.182474, 4.407563>, <1.512562, -0.182474, 4.407563>, <1.363958, -0.182474, 4.407563>, <1.347426, -0.182474, 4.407563>, 
      <1.529094, -0.211345, 4.346232>, <1.512562, -0.211345, 4.346232>, <1.363958, -0.211345, 4.346232>, <1.347426, -0.211345, 4.346232>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.529094, 0.171765, 4.346232>, <1.529094, 0.233096, 4.215944>, <1.529094, 0.229972, 3.841034>, <1.529094, 0.171765, 3.532377>, 
      <1.512562, 0.171765, 4.346232>, <1.512562, 0.233096, 4.215944>, <1.474594, 0.229972, 3.841034>, <1.474594, 0.171765, 3.532377>, 
      <1.363958, 0.171765, 4.346232>, <1.363958, 0.233096, 4.215944>, <1.401926, 0.186053, 3.846150>, <1.401926, 0.171765, 3.532377>, 
      <1.347426, 0.171765, 4.346232>, <1.347426, 0.233096, 4.215944>, <1.347426, 0.186053, 3.846150>, <1.347426, 0.171765, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.710761, -0.026161, -0.000197>, <1.621455, -0.026161, -0.000197>, <1.583594, -0.026161, 2.307613>, <1.529094, -0.026161, 3.296675>, 
      <1.710761, 0.069534, -0.000197>, <1.621455, 0.069534, -0.000197>, <1.583594, 0.033217, 2.378324>, <1.529094, 0.033217, 3.367386>, 
      <1.710761, 0.109648, 2.168298>, <1.656261, 0.109648, 2.168298>, <1.583594, 0.149753, 3.415650>, <1.529094, 0.149753, 3.415650>, 
      <1.710761, 0.171765, 3.532377>, <1.656261, 0.171765, 3.532377>, <1.583594, 0.171765, 3.532377>, <1.529094, 0.171765, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.710761, -0.211346, 3.532377>, <1.656261, -0.211346, 3.532377>, <1.583594, -0.211346, 3.532377>, <1.529094, -0.211346, 3.532377>, 
      <1.710761, -0.153232, 2.168388>, <1.656261, -0.153232, 2.168388>, <1.583594, -0.191245, 3.418452>, <1.529094, -0.191245, 3.418452>, 
      <1.710761, -0.121838, -0.000197>, <1.621455, -0.121838, -0.000197>, <1.583594, -0.081716, 2.378324>, <1.529094, -0.081716, 3.367386>, 
      <1.710761, -0.026161, -0.000197>, <1.621455, -0.026161, -0.000197>, <1.583594, -0.026161, 2.307613>, <1.529094, -0.026161, 3.296675>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.710761, -0.211345, 4.346232>, <1.694229, -0.211345, 4.346232>, <1.545626, -0.211345, 4.346232>, <1.529094, -0.211345, 4.346232>, 
      <1.710761, -0.272676, 4.215944>, <1.694229, -0.272676, 4.215944>, <1.545626, -0.272676, 4.215944>, <1.529094, -0.272676, 4.215944>, 
      <1.710761, -0.224716, 3.846190>, <1.656261, -0.224716, 3.846190>, <1.583594, -0.265922, 3.841697>, <1.529094, -0.265922, 3.841697>, 
      <1.710761, -0.211346, 3.532377>, <1.656261, -0.211346, 3.532377>, <1.583594, -0.211346, 3.532377>, <1.529094, -0.211346, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.710761, 0.171765, 4.346232>, <1.694229, 0.171765, 4.346232>, <1.545626, 0.171765, 4.346232>, <1.529094, 0.171765, 4.346232>, 
      <1.710761, 0.142894, 4.407563>, <1.694229, 0.142894, 4.407563>, <1.545626, 0.142894, 4.407563>, <1.529094, 0.142894, 4.407563>, 
      <1.710761, -0.182474, 4.407563>, <1.694229, -0.182474, 4.407563>, <1.545626, -0.182474, 4.407563>, <1.529094, -0.182474, 4.407563>, 
      <1.710761, -0.211345, 4.346232>, <1.694229, -0.211345, 4.346232>, <1.545626, -0.211345, 4.346232>, <1.529094, -0.211345, 4.346232>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.710761, 0.171765, 4.346232>, <1.710761, 0.233096, 4.215944>, <1.710761, 0.186053, 3.846150>, <1.710761, 0.171765, 3.532377>, 
      <1.694229, 0.171765, 4.346232>, <1.694229, 0.233096, 4.215944>, <1.656261, 0.186053, 3.846150>, <1.656261, 0.171765, 3.532377>, 
      <1.545626, 0.171765, 4.346232>, <1.545626, 0.233096, 4.215944>, <1.583594, 0.229972, 3.841034>, <1.583594, 0.171765, 3.532377>, 
      <1.529094, 0.171765, 4.346232>, <1.529094, 0.233096, 4.215944>, <1.529094, 0.229972, 3.841034>, <1.529094, 0.171765, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.892429, -0.026161, 3.296675>, <1.837929, -0.026161, 2.307613>, <1.800067, -0.026161, -0.000197>, <1.710761, -0.026161, -0.000197>, 
      <1.892429, 0.033217, 3.367386>, <1.837929, 0.033217, 2.378324>, <1.800067, 0.069534, -0.000197>, <1.710761, 0.069534, -0.000197>, 
      <1.892429, 0.149753, 3.415650>, <1.837929, 0.149753, 3.415650>, <1.765261, 0.109648, 2.168298>, <1.710761, 0.109648, 2.168298>, 
      <1.892429, 0.171765, 3.532377>, <1.837929, 0.171765, 3.532377>, <1.765261, 0.171765, 3.532377>, <1.710761, 0.171765, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.892429, -0.211346, 3.532377>, <1.837929, -0.211346, 3.532377>, <1.765261, -0.211346, 3.532377>, <1.710761, -0.211346, 3.532377>, 
      <1.892429, -0.191245, 3.418452>, <1.837929, -0.191245, 3.418452>, <1.765261, -0.153232, 2.168388>, <1.710761, -0.153232, 2.168388>, 
      <1.892429, -0.081716, 3.367386>, <1.837929, -0.081716, 2.378324>, <1.800067, -0.121838, -0.000197>, <1.710761, -0.121838, -0.000197>, 
      <1.892429, -0.026161, 3.296675>, <1.837929, -0.026161, 2.307613>, <1.800067, -0.026161, -0.000197>, <1.710761, -0.026161, -0.000197>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.892429, -0.211345, 4.346232>, <1.875897, -0.211345, 4.346232>, <1.727293, -0.211345, 4.346232>, <1.710761, -0.211345, 4.346232>, 
      <1.892429, -0.272676, 4.215944>, <1.875897, -0.272676, 4.215944>, <1.727293, -0.272676, 4.215944>, <1.710761, -0.272676, 4.215944>, 
      <1.892429, -0.265922, 3.841697>, <1.837929, -0.265922, 3.841697>, <1.765261, -0.224716, 3.846190>, <1.710761, -0.224716, 3.846190>, 
      <1.892429, -0.211346, 3.532377>, <1.837929, -0.211346, 3.532377>, <1.765261, -0.211346, 3.532377>, <1.710761, -0.211346, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.892429, 0.171765, 4.346232>, <1.875897, 0.171765, 4.346232>, <1.727293, 0.171765, 4.346232>, <1.710761, 0.171765, 4.346232>, 
      <1.892429, 0.142894, 4.407563>, <1.875897, 0.142894, 4.407563>, <1.727293, 0.142894, 4.407563>, <1.710761, 0.142894, 4.407563>, 
      <1.892429, -0.182474, 4.407563>, <1.875897, -0.182474, 4.407563>, <1.727293, -0.182474, 4.407563>, <1.710761, -0.182474, 4.407563>, 
      <1.892429, -0.211345, 4.346232>, <1.875897, -0.211345, 4.346232>, <1.727293, -0.211345, 4.346232>, <1.710761, -0.211345, 4.346232>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.892429, 0.171765, 4.346232>, <1.892429, 0.233096, 4.215944>, <1.892429, 0.229972, 3.841034>, <1.892429, 0.171765, 3.532377>, 
      <1.875897, 0.171765, 4.346232>, <1.875897, 0.233096, 4.215944>, <1.837929, 0.229972, 3.841034>, <1.837929, 0.171765, 3.532377>, 
      <1.727293, 0.171765, 4.346232>, <1.727293, 0.233096, 4.215944>, <1.765261, 0.186053, 3.846150>, <1.765261, 0.171765, 3.532377>, 
      <1.710761, 0.171765, 4.346232>, <1.710761, 0.233096, 4.215944>, <1.710761, 0.186053, 3.846150>, <1.710761, 0.171765, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.074096, -0.026161, -0.000197>, <1.984790, -0.026161, -0.000197>, <1.946929, -0.026161, 2.307613>, <1.892429, -0.026161, 3.296675>, 
      <2.074096, 0.069534, -0.000197>, <1.984790, 0.069534, -0.000197>, <1.946929, 0.033217, 2.378324>, <1.892429, 0.033217, 3.367386>, 
      <2.074096, 0.109648, 2.168298>, <2.019596, 0.109648, 2.168298>, <1.946929, 0.149753, 3.415650>, <1.892429, 0.149753, 3.415650>, 
      <2.074096, 0.171765, 3.532377>, <2.019596, 0.171765, 3.532377>, <1.946929, 0.171765, 3.532377>, <1.892429, 0.171765, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.074096, -0.211346, 3.532377>, <2.019596, -0.211346, 3.532377>, <1.946929, -0.211346, 3.532377>, <1.892429, -0.211346, 3.532377>, 
      <2.074096, -0.153232, 2.168388>, <2.019596, -0.153232, 2.168388>, <1.946929, -0.191245, 3.418452>, <1.892429, -0.191245, 3.418452>, 
      <2.074096, -0.121838, -0.000197>, <1.984790, -0.121838, -0.000197>, <1.946929, -0.081716, 2.378324>, <1.892429, -0.081716, 3.367386>, 
      <2.074096, -0.026161, -0.000197>, <1.984790, -0.026161, -0.000197>, <1.946929, -0.026161, 2.307613>, <1.892429, -0.026161, 3.296675>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.074096, -0.211345, 4.346232>, <2.057564, -0.211345, 4.346232>, <1.908961, -0.211345, 4.346232>, <1.892429, -0.211345, 4.346232>, 
      <2.074096, -0.272676, 4.215944>, <2.057564, -0.272676, 4.215944>, <1.908961, -0.272676, 4.215944>, <1.892429, -0.272676, 4.215944>, 
      <2.074096, -0.224716, 3.846190>, <2.019596, -0.224716, 3.846190>, <1.946929, -0.265922, 3.841697>, <1.892429, -0.265922, 3.841697>, 
      <2.074096, -0.211346, 3.532377>, <2.019596, -0.211346, 3.532377>, <1.946929, -0.211346, 3.532377>, <1.892429, -0.211346, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.074096, 0.171765, 4.346232>, <2.057564, 0.171765, 4.346232>, <1.908961, 0.171765, 4.346232>, <1.892429, 0.171765, 4.346232>, 
      <2.074096, 0.142894, 4.407563>, <2.057564, 0.142894, 4.407563>, <1.908961, 0.142894, 4.407563>, <1.892429, 0.142894, 4.407563>, 
      <2.074096, -0.182474, 4.407563>, <2.057564, -0.182474, 4.407563>, <1.908961, -0.182474, 4.407563>, <1.892429, -0.182474, 4.407563>, 
      <2.074096, -0.211345, 4.346232>, <2.057564, -0.211345, 4.346232>, <1.908961, -0.211345, 4.346232>, <1.892429, -0.211345, 4.346232>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.074096, 0.171765, 4.346232>, <2.074096, 0.233096, 4.215944>, <2.074096, 0.186053, 3.846150>, <2.074096, 0.171765, 3.532377>, 
      <2.057564, 0.171765, 4.346232>, <2.057564, 0.233096, 4.215944>, <2.019596, 0.186053, 3.846150>, <2.019596, 0.171765, 3.532377>, 
      <1.908961, 0.171765, 4.346232>, <1.908961, 0.233096, 4.215944>, <1.946929, 0.229972, 3.841034>, <1.946929, 0.171765, 3.532377>, 
      <1.892429, 0.171765, 4.346232>, <1.892429, 0.233096, 4.215944>, <1.892429, 0.229972, 3.841034>, <1.892429, 0.171765, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.255764, -0.026161, 3.296675>, <2.201264, -0.026161, 2.307613>, <2.163402, -0.026161, -0.000197>, <2.074096, -0.026161, -0.000197>, 
      <2.255764, 0.033217, 3.367386>, <2.201264, 0.033217, 2.378324>, <2.163402, 0.069534, -0.000197>, <2.074096, 0.069534, -0.000197>, 
      <2.255764, 0.149753, 3.415650>, <2.201264, 0.149753, 3.415650>, <2.128596, 0.109648, 2.168298>, <2.074096, 0.109648, 2.168298>, 
      <2.255764, 0.171765, 3.532377>, <2.201264, 0.171765, 3.532377>, <2.128596, 0.171765, 3.532377>, <2.074096, 0.171765, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.255764, -0.211346, 3.532377>, <2.201264, -0.211346, 3.532377>, <2.128596, -0.211346, 3.532377>, <2.074096, -0.211346, 3.532377>, 
      <2.255764, -0.191245, 3.418452>, <2.201264, -0.191245, 3.418452>, <2.128596, -0.153232, 2.168388>, <2.074096, -0.153232, 2.168388>, 
      <2.255764, -0.081716, 3.367386>, <2.201264, -0.081716, 2.378324>, <2.163402, -0.121838, -0.000197>, <2.074096, -0.121838, -0.000197>, 
      <2.255764, -0.026161, 3.296675>, <2.201264, -0.026161, 2.307613>, <2.163402, -0.026161, -0.000197>, <2.074096, -0.026161, -0.000197>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.255764, -0.211345, 4.346232>, <2.239232, -0.211345, 4.346232>, <2.090628, -0.211345, 4.346232>, <2.074096, -0.211345, 4.346232>, 
      <2.255764, -0.272676, 4.215944>, <2.239232, -0.272676, 4.215944>, <2.090628, -0.272676, 4.215944>, <2.074096, -0.272676, 4.215944>, 
      <2.255764, -0.265922, 3.841697>, <2.201264, -0.265922, 3.841697>, <2.128596, -0.224716, 3.846190>, <2.074096, -0.224716, 3.846190>, 
      <2.255764, -0.211346, 3.532377>, <2.201264, -0.211346, 3.532377>, <2.128596, -0.211346, 3.532377>, <2.074096, -0.211346, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.255764, 0.171765, 4.346232>, <2.239232, 0.171765, 4.346232>, <2.090628, 0.171765, 4.346232>, <2.074096, 0.171765, 4.346232>, 
      <2.255764, 0.142894, 4.407563>, <2.239232, 0.142894, 4.407563>, <2.090628, 0.142894, 4.407563>, <2.074096, 0.142894, 4.407563>, 
      <2.255764, -0.182474, 4.407563>, <2.239232, -0.182474, 4.407563>, <2.090628, -0.182474, 4.407563>, <2.074096, -0.182474, 4.407563>, 
      <2.255764, -0.211345, 4.346232>, <2.239232, -0.211345, 4.346232>, <2.090628, -0.211345, 4.346232>, <2.074096, -0.211345, 4.346232>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.255764, 0.171765, 4.346232>, <2.255764, 0.233096, 4.215944>, <2.255764, 0.229972, 3.841034>, <2.255764, 0.171765, 3.532377>, 
      <2.239232, 0.171765, 4.346232>, <2.239232, 0.233096, 4.215944>, <2.201264, 0.229972, 3.841034>, <2.201264, 0.171765, 3.532377>, 
      <2.090628, 0.171765, 4.346232>, <2.090628, 0.233096, 4.215944>, <2.128596, 0.186053, 3.846150>, <2.128596, 0.171765, 3.532377>, 
      <2.074096, 0.171765, 4.346232>, <2.074096, 0.233096, 4.215944>, <2.074096, 0.186053, 3.846150>, <2.074096, 0.171765, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.437432, -0.026161, -0.000197>, <2.348126, -0.026161, -0.000197>, <2.310264, -0.026161, 2.307613>, <2.255764, -0.026161, 3.296675>, 
      <2.437432, 0.069534, -0.000197>, <2.348126, 0.069534, -0.000197>, <2.310264, 0.033217, 2.378324>, <2.255764, 0.033217, 3.367386>, 
      <2.437432, 0.109648, 2.168298>, <2.382932, 0.109648, 2.168298>, <2.310264, 0.149753, 3.415650>, <2.255764, 0.149753, 3.415650>, 
      <2.437432, 0.171765, 3.532377>, <2.382932, 0.171765, 3.532377>, <2.310264, 0.171765, 3.532377>, <2.255764, 0.171765, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.437432, -0.211346, 3.532377>, <2.382932, -0.211346, 3.532377>, <2.310264, -0.211346, 3.532377>, <2.255764, -0.211346, 3.532377>, 
      <2.437432, -0.153232, 2.168388>, <2.382932, -0.153232, 2.168388>, <2.310264, -0.191245, 3.418452>, <2.255764, -0.191245, 3.418452>, 
      <2.437432, -0.121838, -0.000197>, <2.348126, -0.121838, -0.000197>, <2.310264, -0.081716, 2.378324>, <2.255764, -0.081716, 3.367386>, 
      <2.437432, -0.026161, -0.000197>, <2.348126, -0.026161, -0.000197>, <2.310264, -0.026161, 2.307613>, <2.255764, -0.026161, 3.296675>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.437432, -0.211345, 4.346232>, <2.420900, -0.211345, 4.346232>, <2.272296, -0.211345, 4.346232>, <2.255764, -0.211345, 4.346232>, 
      <2.437432, -0.272676, 4.215944>, <2.420900, -0.272676, 4.215944>, <2.272296, -0.272676, 4.215944>, <2.255764, -0.272676, 4.215944>, 
      <2.437432, -0.224716, 3.846190>, <2.382932, -0.224716, 3.846190>, <2.310264, -0.265922, 3.841697>, <2.255764, -0.265922, 3.841697>, 
      <2.437432, -0.211346, 3.532377>, <2.382932, -0.211346, 3.532377>, <2.310264, -0.211346, 3.532377>, <2.255764, -0.211346, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.437432, 0.171765, 4.346232>, <2.420900, 0.171765, 4.346232>, <2.272296, 0.171765, 4.346232>, <2.255764, 0.171765, 4.346232>, 
      <2.437432, 0.142894, 4.407563>, <2.420900, 0.142894, 4.407563>, <2.272296, 0.142894, 4.407563>, <2.255764, 0.142894, 4.407563>, 
      <2.437432, -0.182474, 4.407563>, <2.420900, -0.182474, 4.407563>, <2.272296, -0.182474, 4.407563>, <2.255764, -0.182474, 4.407563>, 
      <2.437432, -0.211345, 4.346232>, <2.420900, -0.211345, 4.346232>, <2.272296, -0.211345, 4.346232>, <2.255764, -0.211345, 4.346232>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.437432, 0.171765, 4.346232>, <2.437432, 0.233096, 4.215944>, <2.437432, 0.186053, 3.846150>, <2.437432, 0.171765, 3.532377>, 
      <2.420900, 0.171765, 4.346232>, <2.420900, 0.233096, 4.215944>, <2.382932, 0.186053, 3.846150>, <2.382932, 0.171765, 3.532377>, 
      <2.272296, 0.171765, 4.346232>, <2.272296, 0.233096, 4.215944>, <2.310264, 0.229972, 3.841034>, <2.310264, 0.171765, 3.532377>, 
      <2.255764, 0.171765, 4.346232>, <2.255764, 0.233096, 4.215944>, <2.255764, 0.229972, 3.841034>, <2.255764, 0.171765, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.619099, -0.026161, 3.296675>, <2.564599, -0.026161, 2.307613>, <2.526738, -0.026161, -0.000197>, <2.437432, -0.026161, -0.000197>, 
      <2.619099, 0.033217, 3.367386>, <2.564599, 0.033217, 2.378324>, <2.526738, 0.069534, -0.000197>, <2.437432, 0.069534, -0.000197>, 
      <2.619099, 0.149753, 3.415650>, <2.564599, 0.149753, 3.415650>, <2.491932, 0.109648, 2.168298>, <2.437432, 0.109648, 2.168298>, 
      <2.619099, 0.171765, 3.532377>, <2.564599, 0.171765, 3.532377>, <2.491932, 0.171765, 3.532377>, <2.437432, 0.171765, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.619099, -0.211346, 3.532377>, <2.564599, -0.211346, 3.532377>, <2.491932, -0.211346, 3.532377>, <2.437432, -0.211346, 3.532377>, 
      <2.619099, -0.191245, 3.418452>, <2.564599, -0.191245, 3.418452>, <2.491932, -0.153232, 2.168388>, <2.437432, -0.153232, 2.168388>, 
      <2.619099, -0.081716, 3.367386>, <2.564599, -0.081716, 2.378324>, <2.526738, -0.121838, -0.000197>, <2.437432, -0.121838, -0.000197>, 
      <2.619099, -0.026161, 3.296675>, <2.564599, -0.026161, 2.307613>, <2.526738, -0.026161, -0.000197>, <2.437432, -0.026161, -0.000197>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.619099, -0.211345, 4.346232>, <2.602567, -0.211345, 4.346232>, <2.453964, -0.211345, 4.346232>, <2.437432, -0.211345, 4.346232>, 
      <2.619099, -0.272676, 4.215944>, <2.602567, -0.272676, 4.215944>, <2.453964, -0.272676, 4.215944>, <2.437432, -0.272676, 4.215944>, 
      <2.619099, -0.265922, 3.841697>, <2.564599, -0.265922, 3.841697>, <2.491932, -0.224716, 3.846190>, <2.437432, -0.224716, 3.846190>, 
      <2.619099, -0.211346, 3.532377>, <2.564599, -0.211346, 3.532377>, <2.491932, -0.211346, 3.532377>, <2.437432, -0.211346, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.619099, 0.171765, 4.346232>, <2.602567, 0.171765, 4.346232>, <2.453964, 0.171765, 4.346232>, <2.437432, 0.171765, 4.346232>, 
      <2.619099, 0.142894, 4.407563>, <2.602567, 0.142894, 4.407563>, <2.453964, 0.142894, 4.407563>, <2.437432, 0.142894, 4.407563>, 
      <2.619099, -0.182474, 4.407563>, <2.602567, -0.182474, 4.407563>, <2.453964, -0.182474, 4.407563>, <2.437432, -0.182474, 4.407563>, 
      <2.619099, -0.211345, 4.346232>, <2.602567, -0.211345, 4.346232>, <2.453964, -0.211345, 4.346232>, <2.437432, -0.211345, 4.346232>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.619099, 0.171765, 4.346232>, <2.619099, 0.233096, 4.215944>, <2.619099, 0.229972, 3.841034>, <2.619099, 0.171765, 3.532377>, 
      <2.602567, 0.171765, 4.346232>, <2.602567, 0.233096, 4.215944>, <2.564599, 0.229972, 3.841034>, <2.564599, 0.171765, 3.532377>, 
      <2.453964, 0.171765, 4.346232>, <2.453964, 0.233096, 4.215944>, <2.491932, 0.186053, 3.846150>, <2.491932, 0.171765, 3.532377>, 
      <2.437432, 0.171765, 4.346232>, <2.437432, 0.233096, 4.215944>, <2.437432, 0.186053, 3.846150>, <2.437432, 0.171765, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.800766, -0.026161, -0.000197>, <2.711460, -0.026161, -0.000197>, <2.673599, -0.026161, 2.307613>, <2.619099, -0.026161, 3.296675>, 
      <2.800766, 0.069534, -0.000197>, <2.711460, 0.069534, -0.000197>, <2.673599, 0.033217, 2.378324>, <2.619099, 0.033217, 3.367386>, 
      <2.800766, 0.109648, 2.168298>, <2.746266, 0.109648, 2.168298>, <2.673599, 0.149753, 3.415650>, <2.619099, 0.149753, 3.415650>, 
      <2.800766, 0.171765, 3.532377>, <2.746266, 0.171765, 3.532377>, <2.673599, 0.171765, 3.532377>, <2.619099, 0.171765, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.800766, -0.211346, 3.532377>, <2.746266, -0.211346, 3.532377>, <2.673599, -0.211346, 3.532377>, <2.619099, -0.211346, 3.532377>, 
      <2.800766, -0.153232, 2.168388>, <2.746266, -0.153232, 2.168388>, <2.673599, -0.191245, 3.418452>, <2.619099, -0.191245, 3.418452>, 
      <2.800766, -0.121838, -0.000197>, <2.711460, -0.121838, -0.000197>, <2.673599, -0.081716, 2.378324>, <2.619099, -0.081716, 3.367386>, 
      <2.800766, -0.026161, -0.000197>, <2.711460, -0.026161, -0.000197>, <2.673599, -0.026161, 2.307613>, <2.619099, -0.026161, 3.296675>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.800766, -0.211345, 4.346232>, <2.784234, -0.211345, 4.346232>, <2.635631, -0.211345, 4.346232>, <2.619099, -0.211345, 4.346232>, 
      <2.800766, -0.272676, 4.215944>, <2.784234, -0.272676, 4.215944>, <2.635631, -0.272676, 4.215944>, <2.619099, -0.272676, 4.215944>, 
      <2.800766, -0.224716, 3.846190>, <2.746266, -0.224716, 3.846190>, <2.673599, -0.265922, 3.841697>, <2.619099, -0.265922, 3.841697>, 
      <2.800766, -0.211346, 3.532377>, <2.746266, -0.211346, 3.532377>, <2.673599, -0.211346, 3.532377>, <2.619099, -0.211346, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.800766, 0.171765, 4.346232>, <2.784234, 0.171765, 4.346232>, <2.635631, 0.171765, 4.346232>, <2.619099, 0.171765, 4.346232>, 
      <2.800766, 0.142894, 4.407563>, <2.784234, 0.142894, 4.407563>, <2.635631, 0.142894, 4.407563>, <2.619099, 0.142894, 4.407563>, 
      <2.800766, -0.182474, 4.407563>, <2.784234, -0.182474, 4.407563>, <2.635631, -0.182474, 4.407563>, <2.619099, -0.182474, 4.407563>, 
      <2.800766, -0.211345, 4.346232>, <2.784234, -0.211345, 4.346232>, <2.635631, -0.211345, 4.346232>, <2.619099, -0.211345, 4.346232>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.800766, 0.171765, 4.346232>, <2.800766, 0.233096, 4.215944>, <2.800766, 0.186053, 3.846150>, <2.800766, 0.171765, 3.532377>, 
      <2.784234, 0.171765, 4.346232>, <2.784234, 0.233096, 4.215944>, <2.746266, 0.186053, 3.846150>, <2.746266, 0.171765, 3.532377>, 
      <2.635631, 0.171765, 4.346232>, <2.635631, 0.233096, 4.215944>, <2.673599, 0.229972, 3.841034>, <2.673599, 0.171765, 3.532377>, 
      <2.619099, 0.171765, 4.346232>, <2.619099, 0.233096, 4.215944>, <2.619099, 0.229972, 3.841034>, <2.619099, 0.171765, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.982434, -0.026161, 3.296675>, <2.927934, -0.026161, 2.307613>, <2.890072, -0.026161, -0.000197>, <2.800766, -0.026161, -0.000197>, 
      <2.982434, 0.033217, 3.367386>, <2.927934, 0.033217, 2.378324>, <2.890072, 0.069534, -0.000197>, <2.800766, 0.069534, -0.000197>, 
      <2.982434, 0.149753, 3.415650>, <2.927934, 0.149753, 3.415650>, <2.855266, 0.109648, 2.168298>, <2.800766, 0.109648, 2.168298>, 
      <2.982434, 0.171765, 3.532377>, <2.927934, 0.171765, 3.532377>, <2.855266, 0.171765, 3.532377>, <2.800766, 0.171765, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.982434, -0.211346, 3.532377>, <2.927934, -0.211346, 3.532377>, <2.855266, -0.211346, 3.532377>, <2.800766, -0.211346, 3.532377>, 
      <2.982434, -0.191245, 3.418452>, <2.927934, -0.191245, 3.418452>, <2.855266, -0.153232, 2.168388>, <2.800766, -0.153232, 2.168388>, 
      <2.982434, -0.081716, 3.367386>, <2.927934, -0.081716, 2.378324>, <2.890072, -0.121838, -0.000197>, <2.800766, -0.121838, -0.000197>, 
      <2.982434, -0.026161, 3.296675>, <2.927934, -0.026161, 2.307613>, <2.890072, -0.026161, -0.000197>, <2.800766, -0.026161, -0.000197>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.982434, -0.211345, 4.346232>, <2.965902, -0.211345, 4.346232>, <2.817298, -0.211345, 4.346232>, <2.800766, -0.211345, 4.346232>, 
      <2.982434, -0.272676, 4.215944>, <2.965902, -0.272676, 4.215944>, <2.817298, -0.272676, 4.215944>, <2.800766, -0.272676, 4.215944>, 
      <2.982434, -0.265922, 3.841697>, <2.927934, -0.265922, 3.841697>, <2.855266, -0.224716, 3.846190>, <2.800766, -0.224716, 3.846190>, 
      <2.982434, -0.211346, 3.532377>, <2.927934, -0.211346, 3.532377>, <2.855266, -0.211346, 3.532377>, <2.800766, -0.211346, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.982434, 0.171765, 4.346232>, <2.965902, 0.171765, 4.346232>, <2.817298, 0.171765, 4.346232>, <2.800766, 0.171765, 4.346232>, 
      <2.982434, 0.142894, 4.407563>, <2.965902, 0.142894, 4.407563>, <2.817298, 0.142894, 4.407563>, <2.800766, 0.142894, 4.407563>, 
      <2.982434, -0.182474, 4.407563>, <2.965902, -0.182474, 4.407563>, <2.817298, -0.182474, 4.407563>, <2.800766, -0.182474, 4.407563>, 
      <2.982434, -0.211345, 4.346232>, <2.965902, -0.211345, 4.346232>, <2.817298, -0.211345, 4.346232>, <2.800766, -0.211345, 4.346232>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.982434, 0.171765, 4.346232>, <2.982434, 0.233096, 4.215944>, <2.982434, 0.229972, 3.841034>, <2.982434, 0.171765, 3.532377>, 
      <2.965902, 0.171765, 4.346232>, <2.965902, 0.233096, 4.215944>, <2.927934, 0.229972, 3.841034>, <2.927934, 0.171765, 3.532377>, 
      <2.817298, 0.171765, 4.346232>, <2.817298, 0.233096, 4.215944>, <2.855266, 0.186053, 3.846150>, <2.855266, 0.171765, 3.532377>, 
      <2.800766, 0.171765, 4.346232>, <2.800766, 0.233096, 4.215944>, <2.800766, 0.186053, 3.846150>, <2.800766, 0.171765, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.164102, -0.026161, -0.000197>, <3.074796, -0.026161, -0.000197>, <3.036934, -0.026161, 2.307613>, <2.982434, -0.026161, 3.296675>, 
      <3.164102, 0.069534, -0.000197>, <3.074796, 0.069534, -0.000197>, <3.036934, 0.033217, 2.378324>, <2.982434, 0.033217, 3.367386>, 
      <3.164102, 0.109648, 2.168298>, <3.109602, 0.109648, 2.168298>, <3.036934, 0.149753, 3.415650>, <2.982434, 0.149753, 3.415650>, 
      <3.164102, 0.171765, 3.532377>, <3.109602, 0.171765, 3.532377>, <3.036934, 0.171765, 3.532377>, <2.982434, 0.171765, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.164102, -0.211346, 3.532377>, <3.109602, -0.211346, 3.532377>, <3.036934, -0.211346, 3.532377>, <2.982434, -0.211346, 3.532377>, 
      <3.164102, -0.153232, 2.168388>, <3.109602, -0.153232, 2.168388>, <3.036934, -0.191245, 3.418452>, <2.982434, -0.191245, 3.418452>, 
      <3.164102, -0.121838, -0.000197>, <3.074796, -0.121838, -0.000197>, <3.036934, -0.081716, 2.378324>, <2.982434, -0.081716, 3.367386>, 
      <3.164102, -0.026161, -0.000197>, <3.074796, -0.026161, -0.000197>, <3.036934, -0.026161, 2.307613>, <2.982434, -0.026161, 3.296675>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.164102, -0.211345, 4.346232>, <3.147570, -0.211345, 4.346232>, <2.998966, -0.211345, 4.346232>, <2.982434, -0.211345, 4.346232>, 
      <3.164102, -0.272676, 4.215944>, <3.147570, -0.272676, 4.215944>, <2.998966, -0.272676, 4.215944>, <2.982434, -0.272676, 4.215944>, 
      <3.164102, -0.224716, 3.846190>, <3.109602, -0.224716, 3.846190>, <3.036934, -0.265922, 3.841697>, <2.982434, -0.265922, 3.841697>, 
      <3.164102, -0.211346, 3.532377>, <3.109602, -0.211346, 3.532377>, <3.036934, -0.211346, 3.532377>, <2.982434, -0.211346, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.164102, 0.171765, 4.346232>, <3.147570, 0.171765, 4.346232>, <2.998966, 0.171765, 4.346232>, <2.982434, 0.171765, 4.346232>, 
      <3.164102, 0.142894, 4.407563>, <3.147570, 0.142894, 4.407563>, <2.998966, 0.142894, 4.407563>, <2.982434, 0.142894, 4.407563>, 
      <3.164102, -0.182474, 4.407563>, <3.147570, -0.182474, 4.407563>, <2.998966, -0.182474, 4.407563>, <2.982434, -0.182474, 4.407563>, 
      <3.164102, -0.211345, 4.346232>, <3.147570, -0.211345, 4.346232>, <2.998966, -0.211345, 4.346232>, <2.982434, -0.211345, 4.346232>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.164102, 0.171765, 4.346232>, <3.164102, 0.233096, 4.215944>, <3.164102, 0.186053, 3.846150>, <3.164102, 0.171765, 3.532377>, 
      <3.147570, 0.171765, 4.346232>, <3.147570, 0.233096, 4.215944>, <3.109602, 0.186053, 3.846150>, <3.109602, 0.171765, 3.532377>, 
      <2.998966, 0.171765, 4.346232>, <2.998966, 0.233096, 4.215944>, <3.036934, 0.229972, 3.841034>, <3.036934, 0.171765, 3.532377>, 
      <2.982434, 0.171765, 4.346232>, <2.982434, 0.233096, 4.215944>, <2.982434, 0.229972, 3.841034>, <2.982434, 0.171765, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.345769, -0.026161, 3.296675>, <3.291269, -0.026161, 2.307613>, <3.253408, -0.026161, -0.000197>, <3.164102, -0.026161, -0.000197>, 
      <3.345769, 0.033217, 3.367386>, <3.291269, 0.033217, 2.378324>, <3.253408, 0.069534, -0.000197>, <3.164102, 0.069534, -0.000197>, 
      <3.345769, 0.149753, 3.415650>, <3.291269, 0.149753, 3.415650>, <3.218602, 0.109648, 2.168298>, <3.164102, 0.109648, 2.168298>, 
      <3.345769, 0.171765, 3.532377>, <3.291269, 0.171765, 3.532377>, <3.218602, 0.171765, 3.532377>, <3.164102, 0.171765, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.345769, -0.211346, 3.532377>, <3.291269, -0.211346, 3.532377>, <3.218602, -0.211346, 3.532377>, <3.164102, -0.211346, 3.532377>, 
      <3.345769, -0.191245, 3.418452>, <3.291269, -0.191245, 3.418452>, <3.218602, -0.153232, 2.168388>, <3.164102, -0.153232, 2.168388>, 
      <3.345769, -0.081716, 3.367386>, <3.291269, -0.081716, 2.378324>, <3.253408, -0.121838, -0.000197>, <3.164102, -0.121838, -0.000197>, 
      <3.345769, -0.026161, 3.296675>, <3.291269, -0.026161, 2.307613>, <3.253408, -0.026161, -0.000197>, <3.164102, -0.026161, -0.000197>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.345769, -0.211345, 4.346232>, <3.329237, -0.211345, 4.346232>, <3.180634, -0.211345, 4.346232>, <3.164102, -0.211345, 4.346232>, 
      <3.345769, -0.272676, 4.215944>, <3.329237, -0.272676, 4.215944>, <3.180634, -0.272676, 4.215944>, <3.164102, -0.272676, 4.215944>, 
      <3.345769, -0.265922, 3.841697>, <3.291269, -0.265922, 3.841697>, <3.218602, -0.224716, 3.846190>, <3.164102, -0.224716, 3.846190>, 
      <3.345769, -0.211346, 3.532377>, <3.291269, -0.211346, 3.532377>, <3.218602, -0.211346, 3.532377>, <3.164102, -0.211346, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.345769, 0.171765, 4.346232>, <3.329237, 0.171765, 4.346232>, <3.180634, 0.171765, 4.346232>, <3.164102, 0.171765, 4.346232>, 
      <3.345769, 0.142894, 4.407563>, <3.329237, 0.142894, 4.407563>, <3.180634, 0.142894, 4.407563>, <3.164102, 0.142894, 4.407563>, 
      <3.345769, -0.182474, 4.407563>, <3.329237, -0.182474, 4.407563>, <3.180634, -0.182474, 4.407563>, <3.164102, -0.182474, 4.407563>, 
      <3.345769, -0.211345, 4.346232>, <3.329237, -0.211345, 4.346232>, <3.180634, -0.211345, 4.346232>, <3.164102, -0.211345, 4.346232>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.345769, 0.171765, 4.346232>, <3.345769, 0.233096, 4.215944>, <3.345769, 0.229972, 3.841034>, <3.345769, 0.171765, 3.532377>, 
      <3.329237, 0.171765, 4.346232>, <3.329237, 0.233096, 4.215944>, <3.291269, 0.229972, 3.841034>, <3.291269, 0.171765, 3.532377>, 
      <3.180634, 0.171765, 4.346232>, <3.180634, 0.233096, 4.215944>, <3.218602, 0.186053, 3.846150>, <3.218602, 0.171765, 3.532377>, 
      <3.164102, 0.171765, 4.346232>, <3.164102, 0.233096, 4.215944>, <3.164102, 0.186053, 3.846150>, <3.164102, 0.171765, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.527437, -0.026161, -0.000197>, <3.438131, -0.026161, -0.000197>, <3.400269, -0.026161, 2.307613>, <3.345769, -0.026161, 3.296675>, 
      <3.527437, 0.069534, -0.000197>, <3.438131, 0.069534, -0.000197>, <3.400269, 0.033217, 2.378324>, <3.345769, 0.033217, 3.367386>, 
      <3.527437, 0.109648, 2.168298>, <3.472937, 0.109648, 2.168298>, <3.400269, 0.149753, 3.415650>, <3.345769, 0.149753, 3.415650>, 
      <3.527437, 0.171765, 3.532377>, <3.472937, 0.171765, 3.532377>, <3.400269, 0.171765, 3.532377>, <3.345769, 0.171765, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.527437, -0.211346, 3.532377>, <3.472937, -0.211346, 3.532377>, <3.400269, -0.211346, 3.532377>, <3.345769, -0.211346, 3.532377>, 
      <3.527437, -0.153232, 2.168388>, <3.472937, -0.153232, 2.168388>, <3.400269, -0.191245, 3.418452>, <3.345769, -0.191245, 3.418452>, 
      <3.527437, -0.121838, -0.000197>, <3.438131, -0.121838, -0.000197>, <3.400269, -0.081716, 2.378324>, <3.345769, -0.081716, 3.367386>, 
      <3.527437, -0.026161, -0.000197>, <3.438131, -0.026161, -0.000197>, <3.400269, -0.026161, 2.307613>, <3.345769, -0.026161, 3.296675>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.527437, -0.211345, 4.346232>, <3.510905, -0.211345, 4.346232>, <3.362301, -0.211345, 4.346232>, <3.345769, -0.211345, 4.346232>, 
      <3.527437, -0.272676, 4.215944>, <3.510905, -0.272676, 4.215944>, <3.362301, -0.272676, 4.215944>, <3.345769, -0.272676, 4.215944>, 
      <3.527437, -0.224716, 3.846190>, <3.472937, -0.224716, 3.846190>, <3.400269, -0.265922, 3.841697>, <3.345769, -0.265922, 3.841697>, 
      <3.527437, -0.211346, 3.532377>, <3.472937, -0.211346, 3.532377>, <3.400269, -0.211346, 3.532377>, <3.345769, -0.211346, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.527437, 0.171765, 4.346232>, <3.510905, 0.171765, 4.346232>, <3.362301, 0.171765, 4.346232>, <3.345769, 0.171765, 4.346232>, 
      <3.527437, 0.142894, 4.407563>, <3.510905, 0.142894, 4.407563>, <3.362301, 0.142894, 4.407563>, <3.345769, 0.142894, 4.407563>, 
      <3.527437, -0.182474, 4.407563>, <3.510905, -0.182474, 4.407563>, <3.362301, -0.182474, 4.407563>, <3.345769, -0.182474, 4.407563>, 
      <3.527437, -0.211345, 4.346232>, <3.510905, -0.211345, 4.346232>, <3.362301, -0.211345, 4.346232>, <3.345769, -0.211345, 4.346232>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.527437, 0.171765, 4.346232>, <3.527437, 0.233096, 4.215944>, <3.527437, 0.186053, 3.846150>, <3.527437, 0.171765, 3.532377>, 
      <3.510905, 0.171765, 4.346232>, <3.510905, 0.233096, 4.215944>, <3.472937, 0.186053, 3.846150>, <3.472937, 0.171765, 3.532377>, 
      <3.362301, 0.171765, 4.346232>, <3.362301, 0.233096, 4.215944>, <3.400269, 0.229972, 3.841034>, <3.400269, 0.171765, 3.532377>, 
      <3.345769, 0.171765, 4.346232>, <3.345769, 0.233096, 4.215944>, <3.345769, 0.229972, 3.841034>, <3.345769, 0.171765, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.712895, -0.026161, 3.296675>, <3.712895, 0.033217, 3.367386>, <3.712895, 0.149753, 3.415650>, <3.712895, 0.171765, 3.532377>, 
      <3.767395, -0.026161, 2.307613>, <3.767395, 0.033217, 2.378324>, <3.767395, 0.149753, 3.415650>, <3.767395, 0.171765, 3.532377>, 
      <3.805256, -0.026161, -0.000197>, <3.805256, 0.069534, -0.000197>, <3.840062, 0.109648, 2.168298>, <3.840062, 0.171765, 3.532377>, 
      <3.894562, -0.026161, -0.000197>, <3.894562, 0.069534, -0.000197>, <3.894562, 0.109648, 2.168298>, <3.894562, 0.171765, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.712895, -0.026161, 3.296675>, <3.657258, -0.026161, 2.307613>, <3.616748, -0.026161, -0.000197>, <3.527437, -0.026161, -0.000197>, 
      <3.712895, 0.033217, 3.367386>, <3.657258, 0.033217, 2.378324>, <3.616748, 0.069534, -0.000197>, <3.527437, 0.069534, -0.000197>, 
      <3.712895, 0.149753, 3.415650>, <3.657258, 0.149753, 3.415650>, <3.583074, 0.109648, 2.168298>, <3.527437, 0.109648, 2.168298>, 
      <3.712895, 0.171765, 3.532377>, <3.657258, 0.171765, 3.532377>, <3.583074, 0.171765, 3.532377>, <3.527437, 0.171765, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.712895, -0.211346, 3.532377>, <3.712895, -0.191245, 3.418452>, <3.712895, -0.081716, 3.367386>, <3.712895, -0.026161, 3.296675>, 
      <3.767395, -0.211346, 3.532377>, <3.767395, -0.191245, 3.418452>, <3.767395, -0.081716, 2.378324>, <3.767395, -0.026161, 2.307613>, 
      <3.840062, -0.211346, 3.532377>, <3.840062, -0.153232, 2.168388>, <3.805256, -0.121838, -0.000197>, <3.805256, -0.026161, -0.000197>, 
      <3.894562, -0.211346, 3.532377>, <3.894562, -0.153232, 2.168388>, <3.894562, -0.121838, -0.000197>, <3.894562, -0.026161, -0.000197>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.712895, -0.211346, 3.532377>, <3.657258, -0.211346, 3.532377>, <3.583074, -0.211346, 3.532377>, <3.527437, -0.211346, 3.532377>, 
      <3.712895, -0.191245, 3.418452>, <3.657258, -0.191245, 3.418452>, <3.583074, -0.153232, 2.168388>, <3.527437, -0.153232, 2.168388>, 
      <3.712895, -0.081716, 3.367386>, <3.657258, -0.081716, 2.378324>, <3.616748, -0.121838, -0.000197>, <3.527437, -0.121838, -0.000197>, 
      <3.712895, -0.026161, 3.296675>, <3.657258, -0.026161, 2.307613>, <3.616748, -0.026161, -0.000197>, <3.527437, -0.026161, -0.000197>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.712895, -0.211345, 4.346232>, <3.712895, -0.272676, 4.215944>, <3.712895, -0.265922, 3.841697>, <3.712895, -0.211346, 3.532377>, 
      <3.729427, -0.211345, 4.346232>, <3.729427, -0.272676, 4.215944>, <3.767395, -0.265922, 3.841697>, <3.767395, -0.211346, 3.532377>, 
      <3.878030, -0.211345, 4.346232>, <3.878030, -0.272676, 4.215944>, <3.840062, -0.224716, 3.846190>, <3.840062, -0.211346, 3.532377>, 
      <3.894562, -0.211345, 4.346232>, <3.894562, -0.272676, 4.215944>, <3.894562, -0.224716, 3.846190>, <3.894562, -0.211346, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.712895, -0.211345, 4.346232>, <3.696018, -0.211345, 4.346232>, <3.544314, -0.211345, 4.346232>, <3.527437, -0.211345, 4.346232>, 
      <3.712895, -0.272676, 4.215944>, <3.696018, -0.272676, 4.215944>, <3.544314, -0.272676, 4.215944>, <3.527437, -0.272676, 4.215944>, 
      <3.712895, -0.265922, 3.841697>, <3.657258, -0.265922, 3.841697>, <3.583074, -0.224716, 3.846190>, <3.527437, -0.224716, 3.846190>, 
      <3.712895, -0.211346, 3.532377>, <3.657258, -0.211346, 3.532377>, <3.583074, -0.211346, 3.532377>, <3.527437, -0.211346, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.712895, 0.171765, 4.346232>, <3.712895, 0.142894, 4.407563>, <3.712895, -0.182474, 4.407563>, <3.712895, -0.211345, 4.346232>, 
      <3.729427, 0.171765, 4.346232>, <3.729427, 0.142894, 4.407563>, <3.729427, -0.182474, 4.407563>, <3.729427, -0.211345, 4.346232>, 
      <3.878030, 0.171765, 4.346232>, <3.878030, 0.142894, 4.407563>, <3.878030, -0.182474, 4.407563>, <3.878030, -0.211345, 4.346232>, 
      <3.894562, 0.171765, 4.346232>, <3.894562, 0.142894, 4.407563>, <3.894562, -0.182474, 4.407563>, <3.894562, -0.211345, 4.346232>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.712895, 0.171765, 4.346232>, <3.696018, 0.171765, 4.346232>, <3.544314, 0.171765, 4.346232>, <3.527437, 0.171765, 4.346232>, 
      <3.712895, 0.142894, 4.407563>, <3.696018, 0.142894, 4.407563>, <3.544314, 0.142894, 4.407563>, <3.527437, 0.142894, 4.407563>, 
      <3.712895, -0.182474, 4.407563>, <3.696018, -0.182474, 4.407563>, <3.544314, -0.182474, 4.407563>, <3.527437, -0.182474, 4.407563>, 
      <3.712895, -0.211345, 4.346232>, <3.696018, -0.211345, 4.346232>, <3.544314, -0.211345, 4.346232>, <3.527437, -0.211345, 4.346232>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.712895, 0.171765, 4.346232>, <3.729427, 0.171765, 4.346232>, <3.878030, 0.171765, 4.346232>, <3.894562, 0.171765, 4.346232>, 
      <3.712895, 0.233096, 4.215944>, <3.729427, 0.233096, 4.215944>, <3.878030, 0.233096, 4.215944>, <3.894562, 0.233096, 4.215944>, 
      <3.712895, 0.229972, 3.841034>, <3.767395, 0.229972, 3.841034>, <3.840062, 0.186053, 3.846150>, <3.894562, 0.186053, 3.846150>, 
      <3.712895, 0.171765, 3.532377>, <3.767395, 0.171765, 3.532377>, <3.840062, 0.171765, 3.532377>, <3.894562, 0.171765, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.712895, 0.171765, 4.346232>, <3.712895, 0.233096, 4.215944>, <3.712895, 0.229972, 3.841034>, <3.712895, 0.171765, 3.532377>, 
      <3.696018, 0.171765, 4.346232>, <3.696018, 0.233096, 4.215944>, <3.657258, 0.229972, 3.841034>, <3.657258, 0.171765, 3.532377>, 
      <3.544314, 0.171765, 4.346232>, <3.544314, 0.233096, 4.215944>, <3.583074, 0.186053, 3.846150>, <3.583074, 0.171765, 3.532377>, 
      <3.527437, 0.171765, 4.346232>, <3.527437, 0.233096, 4.215944>, <3.527437, 0.186053, 3.846150>, <3.527437, 0.171765, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-7.841351, -0.021065, 3.343980>, <-7.841351, -0.021046, 3.344107>, <-7.841351, -0.021020, 3.344239>, <-7.841351, -0.021001, 3.344402>, 
      <-7.750415, -0.022593, 2.342661>, <-7.750415, -0.022574, 2.342787>, <-7.773509, 0.036810, 3.400631>, <-7.773509, 0.036829, 3.400794>, 
      <-7.688486, -0.024642, 1.000398>, <-7.711581, 0.034735, 2.058237>, <-7.681676, 0.067828, 2.136344>, <-7.708270, 0.136205, 3.497701>, 
      <-7.538230, -0.026160, 0.006249>, <-7.561324, 0.033217, 1.064087>, <-7.588616, 0.103388, 2.171020>, <-7.615211, 0.171765, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-7.841351, -0.021127, 3.344402>, <-7.841351, -0.021108, 3.344239>, <-7.841351, -0.021084, 3.344107>, <-7.841351, -0.021065, 3.343980>, 
      <-7.773509, -0.078192, 3.400794>, <-7.773509, -0.078174, 3.400631>, <-7.750415, -0.022612, 2.342787>, <-7.750415, -0.022593, 2.342661>, 
      <-7.708041, -0.176342, 3.497786>, <-7.681447, -0.112369, 2.136482>, <-7.711581, -0.080198, 2.058237>, <-7.688486, -0.024642, 1.000398>, 
      <-7.615211, -0.211345, 3.532377>, <-7.588618, -0.147372, 2.171073>, <-7.561324, -0.081715, 1.064087>, <-7.538230, -0.026160, 0.006249>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-7.841351, -0.021127, 3.344529>, <-7.841351, -0.021162, 3.344494>, <-7.841351, -0.021132, 3.344451>, <-7.841351, -0.021127, 3.344402>, 
      <-7.773509, -0.078192, 3.525223>, <-7.773509, -0.078227, 3.525188>, <-7.773509, -0.078198, 3.400843>, <-7.773509, -0.078192, 3.400794>, 
      <-7.646017, -0.199729, 3.895428>, <-7.646017, -0.249508, 3.841576>, <-7.711162, -0.183849, 3.657538>, <-7.708041, -0.176342, 3.497786>, 
      <-7.615211, -0.211345, 3.946842>, <-7.615211, -0.261123, 3.892990>, <-7.618332, -0.218852, 3.692128>, <-7.615211, -0.211345, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-7.841351, -0.021001, 3.344529>, <-7.841351, -0.021035, 3.344563>, <-7.841351, -0.021093, 3.344563>, <-7.841351, -0.021127, 3.344529>, 
      <-7.773509, 0.036829, 3.525223>, <-7.773509, 0.036795, 3.525257>, <-7.773509, -0.078158, 3.525257>, <-7.773509, -0.078192, 3.525223>, 
      <-7.646034, 0.159987, 3.895398>, <-7.646034, 0.113974, 3.945176>, <-7.646017, -0.153717, 3.945206>, <-7.646017, -0.199729, 3.895428>, 
      <-7.615211, 0.171765, 3.946842>, <-7.615211, 0.125752, 3.996620>, <-7.615211, -0.165332, 3.996620>, <-7.615211, -0.211345, 3.946842>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-7.841351, -0.021001, 3.344529>, <-7.773509, 0.036829, 3.525223>, <-7.646034, 0.159987, 3.895398>, <-7.615211, 0.171765, 3.946842>, 
      <-7.841351, -0.020966, 3.344494>, <-7.773509, 0.036863, 3.525188>, <-7.646034, 0.209765, 3.841545>, <-7.615211, 0.221543, 3.892990>, 
      <-7.841351, -0.020995, 3.344451>, <-7.773509, 0.036834, 3.400843>, <-7.711391, 0.144228, 3.657427>, <-7.618331, 0.179788, 3.692103>, 
      <-7.841351, -0.021001, 3.344402>, <-7.773509, 0.036829, 3.400794>, <-7.708270, 0.136205, 3.497701>, <-7.615211, 0.171765, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-7.336884, -0.026160, 0.006249>, <-7.343416, -0.026160, -0.053801>, <-7.529203, -0.026251, -0.053476>, <-7.538230, -0.026160, 0.006249>, 
      <-7.336884, 0.033217, 1.064087>, <-7.343416, 0.033217, 1.004038>, <-7.552297, 0.033126, 1.004362>, <-7.561324, 0.033217, 1.064087>, 
      <-7.336884, 0.107302, 2.170893>, <-7.420382, 0.107302, 2.170893>, <-7.514954, 0.131536, 2.198468>, <-7.588616, 0.103388, 2.171020>, 
      <-7.336884, 0.171765, 3.532377>, <-7.420382, 0.171765, 3.532377>, <-7.541548, 0.199913, 3.559826>, <-7.615211, 0.171765, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-7.336884, -0.211345, 3.532377>, <-7.420382, -0.211345, 3.532377>, <-7.541438, -0.239162, 3.559866>, <-7.615211, -0.211345, 3.532377>, 
      <-7.336884, -0.151034, 2.170970>, <-7.420382, -0.151034, 2.170970>, <-7.514845, -0.175189, 2.198562>, <-7.588618, -0.147372, 2.171073>, 
      <-7.336884, -0.081715, 1.064087>, <-7.343416, -0.081715, 1.004038>, <-7.552297, -0.081807, 1.004362>, <-7.561324, -0.081715, 1.064087>, 
      <-7.336884, -0.026160, 0.006249>, <-7.343416, -0.026160, -0.053801>, <-7.529203, -0.026251, -0.053476>, <-7.538230, -0.026160, 0.006249>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-7.336884, -0.211345, 4.186476>, <-7.363818, -0.211345, 4.166688>, <-7.598346, -0.217704, 3.974988>, <-7.615211, -0.211345, 3.946842>, 
      <-7.336884, -0.269837, 4.086610>, <-7.363818, -0.269837, 4.066821>, <-7.598346, -0.267482, 3.921136>, <-7.615211, -0.261123, 3.892990>, 
      <-7.336884, -0.222517, 3.784572>, <-7.420382, -0.222517, 3.784572>, <-7.544559, -0.246670, 3.719617>, <-7.618332, -0.218852, 3.692128>, 
      <-7.336884, -0.211345, 3.532377>, <-7.420382, -0.211345, 3.532377>, <-7.541438, -0.239162, 3.559866>, <-7.615211, -0.211345, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-7.336884, 0.171765, 4.186476>, <-7.363818, 0.171765, 4.166688>, <-7.598355, 0.178206, 3.974974>, <-7.615211, 0.171765, 3.946842>, 
      <-7.336884, 0.137506, 4.244968>, <-7.363818, 0.137506, 4.225180>, <-7.598355, 0.132193, 4.024753>, <-7.615211, 0.125752, 3.996620>, 
      <-7.336884, -0.177086, 4.244968>, <-7.363818, -0.177086, 4.225180>, <-7.598346, -0.171691, 4.024766>, <-7.615211, -0.165332, 3.996620>, 
      <-7.336884, -0.211345, 4.186476>, <-7.363818, -0.211345, 4.166688>, <-7.598346, -0.217704, 3.974988>, <-7.615211, -0.211345, 3.946842>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-7.336884, 0.171765, 4.186476>, <-7.336884, 0.230257, 4.086610>, <-7.336884, 0.183704, 3.784536>, <-7.336884, 0.171765, 3.532377>, 
      <-7.363818, 0.171765, 4.166688>, <-7.363818, 0.230257, 4.066821>, <-7.420382, 0.183704, 3.784536>, <-7.420382, 0.171765, 3.532377>, 
      <-7.598355, 0.178206, 3.974974>, <-7.598355, 0.227984, 3.921122>, <-7.544669, 0.207936, 3.719551>, <-7.541548, 0.199913, 3.559826>, 
      <-7.615211, 0.171765, 3.946842>, <-7.615211, 0.221543, 3.892990>, <-7.618331, 0.179788, 3.692103>, <-7.615211, 0.171765, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-7.180326, -0.026161, 3.296675>, <-7.227294, -0.026161, 2.309547>, <-7.230022, -0.026160, 0.988699>, <-7.336884, -0.026160, 0.006249>, 
      <-7.180326, 0.033217, 3.367386>, <-7.227294, 0.033217, 2.380258>, <-7.230022, 0.033217, 2.046537>, <-7.336884, 0.033217, 1.064087>, 
      <-7.180326, 0.148009, 3.415992>, <-7.227294, 0.148009, 3.415992>, <-7.289917, 0.107302, 2.170893>, <-7.336884, 0.107302, 2.170893>, 
      <-7.180326, 0.171765, 3.532377>, <-7.227294, 0.171765, 3.532377>, <-7.289917, 0.171765, 3.532377>, <-7.336884, 0.171765, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-7.180326, -0.211346, 3.532377>, <-7.227294, -0.211346, 3.532377>, <-7.289917, -0.211345, 3.532377>, <-7.336884, -0.211345, 3.532377>, 
      <-7.180326, -0.189645, 3.418746>, <-7.227294, -0.189645, 3.418746>, <-7.289917, -0.151034, 2.170970>, <-7.336884, -0.151034, 2.170970>, 
      <-7.180326, -0.081716, 3.367386>, <-7.227294, -0.081716, 2.380258>, <-7.230022, -0.081716, 2.046537>, <-7.336884, -0.081715, 1.064087>, 
      <-7.180326, -0.026161, 3.296675>, <-7.227294, -0.026161, 2.309547>, <-7.230022, -0.026160, 0.988699>, <-7.336884, -0.026160, 0.006249>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-7.180326, -0.211345, 4.266354>, <-7.195209, -0.211345, 4.260496>, <-7.323994, -0.211345, 4.195946>, <-7.336884, -0.211345, 4.186476>, 
      <-7.180326, -0.271438, 4.151226>, <-7.195209, -0.271438, 4.145368>, <-7.323994, -0.269837, 4.096080>, <-7.336884, -0.269837, 4.086610>, 
      <-7.180326, -0.264483, 3.810618>, <-7.227294, -0.264483, 3.810618>, <-7.289917, -0.222517, 3.784572>, <-7.336884, -0.222517, 3.784572>, 
      <-7.180326, -0.211346, 3.532377>, <-7.227294, -0.211346, 3.532377>, <-7.289917, -0.211345, 3.532377>, <-7.336884, -0.211345, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-7.180326, 0.171765, 4.266354>, <-7.195209, 0.171765, 4.260496>, <-7.323994, 0.171765, 4.195946>, <-7.336884, 0.171765, 4.186476>, 
      <-7.180326, 0.140399, 4.326447>, <-7.195209, 0.140399, 4.320589>, <-7.323994, 0.137506, 4.254438>, <-7.336884, 0.137506, 4.244968>, 
      <-7.180326, -0.179979, 4.326447>, <-7.195209, -0.179979, 4.320589>, <-7.323994, -0.177086, 4.254438>, <-7.336884, -0.177086, 4.244968>, 
      <-7.180326, -0.211345, 4.266354>, <-7.195209, -0.211345, 4.260496>, <-7.323994, -0.211345, 4.195946>, <-7.336884, -0.211345, 4.186476>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-7.180326, 0.171765, 4.266354>, <-7.180326, 0.231858, 4.151226>, <-7.180326, 0.228416, 3.809924>, <-7.180326, 0.171765, 3.532377>, 
      <-7.195209, 0.171765, 4.260496>, <-7.195209, 0.231858, 4.145368>, <-7.227294, 0.228416, 3.809924>, <-7.227294, 0.171765, 3.532377>, 
      <-7.323994, 0.171765, 4.195946>, <-7.323994, 0.230257, 4.096080>, <-7.289917, 0.183704, 3.784536>, <-7.289917, 0.171765, 3.532377>, 
      <-7.336884, 0.171765, 4.186476>, <-7.336884, 0.230257, 4.086610>, <-7.336884, 0.183704, 3.784536>, <-7.336884, 0.171765, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.910309, -0.026161, 3.296675>, <-3.910309, 0.033217, 3.367386>, <-3.910309, 0.149753, 3.415650>, <-3.910309, 0.171765, 3.532377>, 
      <-3.855809, -0.026161, 2.307613>, <-3.855809, 0.033217, 2.378324>, <-3.855809, 0.149753, 3.415650>, <-3.855809, 0.171765, 3.532377>, 
      <-3.817948, -0.026161, -0.000197>, <-3.817948, 0.069534, -0.000197>, <-3.783142, 0.109648, 2.168298>, <-3.783142, 0.171765, 3.532377>, 
      <-3.728642, -0.026161, -0.000197>, <-3.728642, 0.069534, -0.000197>, <-3.728642, 0.109648, 2.168298>, <-3.728642, 0.171765, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.910309, -0.211346, 3.532377>, <-3.910309, -0.191245, 3.418452>, <-3.910309, -0.081716, 3.367386>, <-3.910309, -0.026161, 3.296675>, 
      <-3.855809, -0.211346, 3.532377>, <-3.855809, -0.191245, 3.418452>, <-3.855809, -0.081716, 2.378324>, <-3.855809, -0.026161, 2.307613>, 
      <-3.783142, -0.211346, 3.532377>, <-3.783142, -0.153232, 2.168388>, <-3.817948, -0.121838, -0.000197>, <-3.817948, -0.026161, -0.000197>, 
      <-3.728642, -0.211346, 3.532377>, <-3.728642, -0.153232, 2.168388>, <-3.728642, -0.121838, -0.000197>, <-3.728642, -0.026161, -0.000197>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.910309, -0.211345, 4.346232>, <-3.910309, -0.272676, 4.215944>, <-3.910309, -0.265922, 3.841697>, <-3.910309, -0.211346, 3.532377>, 
      <-3.893777, -0.211345, 4.346232>, <-3.893777, -0.272676, 4.215944>, <-3.855809, -0.265922, 3.841697>, <-3.855809, -0.211346, 3.532377>, 
      <-3.745174, -0.211345, 4.346232>, <-3.745174, -0.272676, 4.215944>, <-3.783142, -0.224716, 3.846190>, <-3.783142, -0.211346, 3.532377>, 
      <-3.728642, -0.211345, 4.346232>, <-3.728642, -0.272676, 4.215944>, <-3.728642, -0.224716, 3.846190>, <-3.728642, -0.211346, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.910309, 0.171765, 4.346232>, <-3.910309, 0.142894, 4.407563>, <-3.910309, -0.182474, 4.407563>, <-3.910309, -0.211345, 4.346232>, 
      <-3.893777, 0.171765, 4.346232>, <-3.893777, 0.142894, 4.407563>, <-3.893777, -0.182474, 4.407563>, <-3.893777, -0.211345, 4.346232>, 
      <-3.745174, 0.171765, 4.346232>, <-3.745174, 0.142894, 4.407563>, <-3.745174, -0.182474, 4.407563>, <-3.745174, -0.211345, 4.346232>, 
      <-3.728642, 0.171765, 4.346232>, <-3.728642, 0.142894, 4.407563>, <-3.728642, -0.182474, 4.407563>, <-3.728642, -0.211345, 4.346232>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.910309, 0.171765, 4.346232>, <-3.893777, 0.171765, 4.346232>, <-3.745174, 0.171765, 4.346232>, <-3.728642, 0.171765, 4.346232>, 
      <-3.910309, 0.233096, 4.215944>, <-3.893777, 0.233096, 4.215944>, <-3.745174, 0.233096, 4.215944>, <-3.728642, 0.233096, 4.215944>, 
      <-3.910309, 0.229972, 3.841034>, <-3.855809, 0.229972, 3.841034>, <-3.783142, 0.186053, 3.846150>, <-3.728642, 0.186053, 3.846150>, 
      <-3.910309, 0.171765, 3.532377>, <-3.855809, 0.171765, 3.532377>, <-3.783142, 0.171765, 3.532377>, <-3.728642, 0.171765, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-4.091977, -0.026161, -0.000197>, <-4.091977, 0.069534, -0.000197>, <-4.091977, 0.109648, 2.168298>, <-4.091977, 0.171765, 3.532377>, 
      <-4.002671, -0.026161, -0.000197>, <-4.002671, 0.069534, -0.000197>, <-4.037476, 0.109648, 2.168298>, <-4.037476, 0.171765, 3.532377>, 
      <-3.964810, -0.026161, 2.307613>, <-3.964810, 0.033217, 2.378324>, <-3.964810, 0.149753, 3.415650>, <-3.964810, 0.171765, 3.532377>, 
      <-3.910309, -0.026161, 3.296675>, <-3.910309, 0.033217, 3.367386>, <-3.910309, 0.149753, 3.415650>, <-3.910309, 0.171765, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-4.091977, -0.211346, 3.532377>, <-4.091977, -0.153232, 2.168388>, <-4.091977, -0.121838, -0.000197>, <-4.091977, -0.026161, -0.000197>, 
      <-4.037476, -0.211346, 3.532377>, <-4.037476, -0.153232, 2.168388>, <-4.002671, -0.121838, -0.000197>, <-4.002671, -0.026161, -0.000197>, 
      <-3.964810, -0.211346, 3.532377>, <-3.964810, -0.191245, 3.418452>, <-3.964810, -0.081716, 2.378324>, <-3.964810, -0.026161, 2.307613>, 
      <-3.910309, -0.211346, 3.532377>, <-3.910309, -0.191245, 3.418452>, <-3.910309, -0.081716, 3.367386>, <-3.910309, -0.026161, 3.296675>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-4.091977, -0.211345, 4.346232>, <-4.091977, -0.272676, 4.215944>, <-4.091977, -0.224716, 3.846190>, <-4.091977, -0.211346, 3.532377>, 
      <-4.075445, -0.211345, 4.346232>, <-4.075445, -0.272676, 4.215944>, <-4.037476, -0.224716, 3.846190>, <-4.037476, -0.211346, 3.532377>, 
      <-3.926841, -0.211345, 4.346232>, <-3.926841, -0.272676, 4.215944>, <-3.964810, -0.265922, 3.841697>, <-3.964810, -0.211346, 3.532377>, 
      <-3.910309, -0.211345, 4.346232>, <-3.910309, -0.272676, 4.215944>, <-3.910309, -0.265922, 3.841697>, <-3.910309, -0.211346, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-4.091977, 0.171765, 4.346232>, <-4.091977, 0.142894, 4.407563>, <-4.091977, -0.182474, 4.407563>, <-4.091977, -0.211345, 4.346232>, 
      <-4.075445, 0.171765, 4.346232>, <-4.075445, 0.142894, 4.407563>, <-4.075445, -0.182474, 4.407563>, <-4.075445, -0.211345, 4.346232>, 
      <-3.926841, 0.171765, 4.346232>, <-3.926841, 0.142894, 4.407563>, <-3.926841, -0.182474, 4.407563>, <-3.926841, -0.211345, 4.346232>, 
      <-3.910309, 0.171765, 4.346232>, <-3.910309, 0.142894, 4.407563>, <-3.910309, -0.182474, 4.407563>, <-3.910309, -0.211345, 4.346232>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-4.091977, 0.171765, 4.346232>, <-4.075445, 0.171765, 4.346232>, <-3.926841, 0.171765, 4.346232>, <-3.910309, 0.171765, 4.346232>, 
      <-4.091977, 0.233096, 4.215944>, <-4.075445, 0.233096, 4.215944>, <-3.926841, 0.233096, 4.215944>, <-3.910309, 0.233096, 4.215944>, 
      <-4.091977, 0.186053, 3.846150>, <-4.037476, 0.186053, 3.846150>, <-3.964810, 0.229972, 3.841034>, <-3.910309, 0.229972, 3.841034>, 
      <-4.091977, 0.171765, 3.532377>, <-4.037476, 0.171765, 3.532377>, <-3.964810, 0.171765, 3.532377>, <-3.910309, 0.171765, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-4.273645, -0.026161, 3.296675>, <-4.273645, 0.033217, 3.367386>, <-4.273645, 0.149753, 3.415650>, <-4.273645, 0.171765, 3.532377>, 
      <-4.219144, -0.026161, 2.307613>, <-4.219144, 0.033217, 2.378324>, <-4.219144, 0.149753, 3.415650>, <-4.219144, 0.171765, 3.532377>, 
      <-4.181283, -0.026161, -0.000197>, <-4.181283, 0.069534, -0.000197>, <-4.146478, 0.109648, 2.168298>, <-4.146478, 0.171765, 3.532377>, 
      <-4.091977, -0.026161, -0.000197>, <-4.091977, 0.069534, -0.000197>, <-4.091977, 0.109648, 2.168298>, <-4.091977, 0.171765, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-4.273645, -0.211346, 3.532377>, <-4.273645, -0.191245, 3.418452>, <-4.273645, -0.081716, 3.367386>, <-4.273645, -0.026161, 3.296675>, 
      <-4.219144, -0.211346, 3.532377>, <-4.219144, -0.191245, 3.418452>, <-4.219144, -0.081716, 2.378324>, <-4.219144, -0.026161, 2.307613>, 
      <-4.146478, -0.211346, 3.532377>, <-4.146478, -0.153232, 2.168388>, <-4.181283, -0.121838, -0.000197>, <-4.181283, -0.026161, -0.000197>, 
      <-4.091977, -0.211346, 3.532377>, <-4.091977, -0.153232, 2.168388>, <-4.091977, -0.121838, -0.000197>, <-4.091977, -0.026161, -0.000197>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-4.273645, -0.211345, 4.346232>, <-4.273645, -0.272676, 4.215944>, <-4.273645, -0.265922, 3.841697>, <-4.273645, -0.211346, 3.532377>, 
      <-4.257113, -0.211345, 4.346232>, <-4.257113, -0.272676, 4.215944>, <-4.219144, -0.265922, 3.841697>, <-4.219144, -0.211346, 3.532377>, 
      <-4.108509, -0.211345, 4.346232>, <-4.108509, -0.272676, 4.215944>, <-4.146478, -0.224716, 3.846190>, <-4.146478, -0.211346, 3.532377>, 
      <-4.091977, -0.211345, 4.346232>, <-4.091977, -0.272676, 4.215944>, <-4.091977, -0.224716, 3.846190>, <-4.091977, -0.211346, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-4.273645, 0.171765, 4.346232>, <-4.273645, 0.142894, 4.407563>, <-4.273645, -0.182474, 4.407563>, <-4.273645, -0.211345, 4.346232>, 
      <-4.257113, 0.171765, 4.346232>, <-4.257113, 0.142894, 4.407563>, <-4.257113, -0.182474, 4.407563>, <-4.257113, -0.211345, 4.346232>, 
      <-4.108509, 0.171765, 4.346232>, <-4.108509, 0.142894, 4.407563>, <-4.108509, -0.182474, 4.407563>, <-4.108509, -0.211345, 4.346232>, 
      <-4.091977, 0.171765, 4.346232>, <-4.091977, 0.142894, 4.407563>, <-4.091977, -0.182474, 4.407563>, <-4.091977, -0.211345, 4.346232>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-4.273645, 0.171765, 4.346232>, <-4.257113, 0.171765, 4.346232>, <-4.108509, 0.171765, 4.346232>, <-4.091977, 0.171765, 4.346232>, 
      <-4.273645, 0.233096, 4.215944>, <-4.257113, 0.233096, 4.215944>, <-4.108509, 0.233096, 4.215944>, <-4.091977, 0.233096, 4.215944>, 
      <-4.273645, 0.229972, 3.841034>, <-4.219144, 0.229972, 3.841034>, <-4.146478, 0.186053, 3.846150>, <-4.091977, 0.186053, 3.846150>, 
      <-4.273645, 0.171765, 3.532377>, <-4.219144, 0.171765, 3.532377>, <-4.146478, 0.171765, 3.532377>, <-4.091977, 0.171765, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-4.455312, -0.026161, -0.000197>, <-4.455312, 0.069534, -0.000197>, <-4.455312, 0.109648, 2.168298>, <-4.455312, 0.171765, 3.532377>, 
      <-4.366006, -0.026161, -0.000197>, <-4.366006, 0.069534, -0.000197>, <-4.400812, 0.109648, 2.168298>, <-4.400812, 0.171765, 3.532377>, 
      <-4.328145, -0.026161, 2.307613>, <-4.328145, 0.033217, 2.378324>, <-4.328145, 0.149753, 3.415650>, <-4.328145, 0.171765, 3.532377>, 
      <-4.273645, -0.026161, 3.296675>, <-4.273645, 0.033217, 3.367386>, <-4.273645, 0.149753, 3.415650>, <-4.273645, 0.171765, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-4.455312, -0.211346, 3.532377>, <-4.455312, -0.153232, 2.168388>, <-4.455312, -0.121838, -0.000197>, <-4.455312, -0.026161, -0.000197>, 
      <-4.400812, -0.211346, 3.532377>, <-4.400812, -0.153232, 2.168388>, <-4.366006, -0.121838, -0.000197>, <-4.366006, -0.026161, -0.000197>, 
      <-4.328145, -0.211346, 3.532377>, <-4.328145, -0.191245, 3.418452>, <-4.328145, -0.081716, 2.378324>, <-4.328145, -0.026161, 2.307613>, 
      <-4.273645, -0.211346, 3.532377>, <-4.273645, -0.191245, 3.418452>, <-4.273645, -0.081716, 3.367386>, <-4.273645, -0.026161, 3.296675>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-4.455312, -0.211345, 4.346232>, <-4.455312, -0.272676, 4.215944>, <-4.455312, -0.224716, 3.846190>, <-4.455312, -0.211346, 3.532377>, 
      <-4.438780, -0.211345, 4.346232>, <-4.438780, -0.272676, 4.215944>, <-4.400812, -0.224716, 3.846190>, <-4.400812, -0.211346, 3.532377>, 
      <-4.290176, -0.211345, 4.346232>, <-4.290176, -0.272676, 4.215944>, <-4.328145, -0.265922, 3.841697>, <-4.328145, -0.211346, 3.532377>, 
      <-4.273645, -0.211345, 4.346232>, <-4.273645, -0.272676, 4.215944>, <-4.273645, -0.265922, 3.841697>, <-4.273645, -0.211346, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-4.455312, 0.171765, 4.346232>, <-4.455312, 0.142894, 4.407563>, <-4.455312, -0.182474, 4.407563>, <-4.455312, -0.211345, 4.346232>, 
      <-4.438780, 0.171765, 4.346232>, <-4.438780, 0.142894, 4.407563>, <-4.438780, -0.182474, 4.407563>, <-4.438780, -0.211345, 4.346232>, 
      <-4.290176, 0.171765, 4.346232>, <-4.290176, 0.142894, 4.407563>, <-4.290176, -0.182474, 4.407563>, <-4.290176, -0.211345, 4.346232>, 
      <-4.273645, 0.171765, 4.346232>, <-4.273645, 0.142894, 4.407563>, <-4.273645, -0.182474, 4.407563>, <-4.273645, -0.211345, 4.346232>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-4.455312, 0.171765, 4.346232>, <-4.438780, 0.171765, 4.346232>, <-4.290176, 0.171765, 4.346232>, <-4.273645, 0.171765, 4.346232>, 
      <-4.455312, 0.233096, 4.215944>, <-4.438780, 0.233096, 4.215944>, <-4.290176, 0.233096, 4.215944>, <-4.273645, 0.233096, 4.215944>, 
      <-4.455312, 0.186053, 3.846150>, <-4.400812, 0.186053, 3.846150>, <-4.328145, 0.229972, 3.841034>, <-4.273645, 0.229972, 3.841034>, 
      <-4.455312, 0.171765, 3.532377>, <-4.400812, 0.171765, 3.532377>, <-4.328145, 0.171765, 3.532377>, <-4.273645, 0.171765, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-4.636979, -0.026161, 3.296675>, <-4.636979, 0.033217, 3.367386>, <-4.636979, 0.149753, 3.415650>, <-4.636979, 0.171765, 3.532377>, 
      <-4.582479, -0.026161, 2.307613>, <-4.582479, 0.033217, 2.378324>, <-4.582479, 0.149753, 3.415650>, <-4.582479, 0.171765, 3.532377>, 
      <-4.544618, -0.026161, -0.000197>, <-4.544618, 0.069534, -0.000197>, <-4.509812, 0.109648, 2.168298>, <-4.509812, 0.171765, 3.532377>, 
      <-4.455312, -0.026161, -0.000197>, <-4.455312, 0.069534, -0.000197>, <-4.455312, 0.109648, 2.168298>, <-4.455312, 0.171765, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-4.636979, -0.211346, 3.532377>, <-4.636979, -0.191245, 3.418452>, <-4.636979, -0.081716, 3.367386>, <-4.636979, -0.026161, 3.296675>, 
      <-4.582479, -0.211346, 3.532377>, <-4.582479, -0.191245, 3.418452>, <-4.582479, -0.081716, 2.378324>, <-4.582479, -0.026161, 2.307613>, 
      <-4.509812, -0.211346, 3.532377>, <-4.509812, -0.153232, 2.168388>, <-4.544618, -0.121838, -0.000197>, <-4.544618, -0.026161, -0.000197>, 
      <-4.455312, -0.211346, 3.532377>, <-4.455312, -0.153232, 2.168388>, <-4.455312, -0.121838, -0.000197>, <-4.455312, -0.026161, -0.000197>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-4.636979, -0.211345, 4.346232>, <-4.636979, -0.272676, 4.215944>, <-4.636979, -0.265922, 3.841697>, <-4.636979, -0.211346, 3.532377>, 
      <-4.620447, -0.211345, 4.346232>, <-4.620447, -0.272676, 4.215944>, <-4.582479, -0.265922, 3.841697>, <-4.582479, -0.211346, 3.532377>, 
      <-4.471844, -0.211345, 4.346232>, <-4.471844, -0.272676, 4.215944>, <-4.509812, -0.224716, 3.846190>, <-4.509812, -0.211346, 3.532377>, 
      <-4.455312, -0.211345, 4.346232>, <-4.455312, -0.272676, 4.215944>, <-4.455312, -0.224716, 3.846190>, <-4.455312, -0.211346, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-4.636979, 0.171765, 4.346232>, <-4.636979, 0.142894, 4.407563>, <-4.636979, -0.182474, 4.407563>, <-4.636979, -0.211345, 4.346232>, 
      <-4.620447, 0.171765, 4.346232>, <-4.620447, 0.142894, 4.407563>, <-4.620447, -0.182474, 4.407563>, <-4.620447, -0.211345, 4.346232>, 
      <-4.471844, 0.171765, 4.346232>, <-4.471844, 0.142894, 4.407563>, <-4.471844, -0.182474, 4.407563>, <-4.471844, -0.211345, 4.346232>, 
      <-4.455312, 0.171765, 4.346232>, <-4.455312, 0.142894, 4.407563>, <-4.455312, -0.182474, 4.407563>, <-4.455312, -0.211345, 4.346232>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-4.636979, 0.171765, 4.346232>, <-4.620447, 0.171765, 4.346232>, <-4.471844, 0.171765, 4.346232>, <-4.455312, 0.171765, 4.346232>, 
      <-4.636979, 0.233096, 4.215944>, <-4.620447, 0.233096, 4.215944>, <-4.471844, 0.233096, 4.215944>, <-4.455312, 0.233096, 4.215944>, 
      <-4.636979, 0.229972, 3.841034>, <-4.582479, 0.229972, 3.841034>, <-4.509812, 0.186053, 3.846150>, <-4.455312, 0.186053, 3.846150>, 
      <-4.636979, 0.171765, 3.532377>, <-4.582479, 0.171765, 3.532377>, <-4.509812, 0.171765, 3.532377>, <-4.455312, 0.171765, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-4.818647, -0.026161, -0.000197>, <-4.818647, 0.069534, -0.000197>, <-4.818647, 0.109648, 2.168298>, <-4.818647, 0.171765, 3.532377>, 
      <-4.729341, -0.026161, -0.000197>, <-4.729341, 0.069534, -0.000197>, <-4.764146, 0.109648, 2.168298>, <-4.764146, 0.171765, 3.532377>, 
      <-4.691480, -0.026161, 2.307613>, <-4.691480, 0.033217, 2.378324>, <-4.691480, 0.149753, 3.415650>, <-4.691480, 0.171765, 3.532377>, 
      <-4.636979, -0.026161, 3.296675>, <-4.636979, 0.033217, 3.367386>, <-4.636979, 0.149753, 3.415650>, <-4.636979, 0.171765, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-4.818647, -0.211346, 3.532377>, <-4.818647, -0.153232, 2.168388>, <-4.818647, -0.121838, -0.000197>, <-4.818647, -0.026161, -0.000197>, 
      <-4.764146, -0.211346, 3.532377>, <-4.764146, -0.153232, 2.168388>, <-4.729341, -0.121838, -0.000197>, <-4.729341, -0.026161, -0.000197>, 
      <-4.691480, -0.211346, 3.532377>, <-4.691480, -0.191245, 3.418452>, <-4.691480, -0.081716, 2.378324>, <-4.691480, -0.026161, 2.307613>, 
      <-4.636979, -0.211346, 3.532377>, <-4.636979, -0.191245, 3.418452>, <-4.636979, -0.081716, 3.367386>, <-4.636979, -0.026161, 3.296675>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-4.818647, -0.211345, 4.346232>, <-4.818647, -0.272676, 4.215944>, <-4.818647, -0.224716, 3.846190>, <-4.818647, -0.211346, 3.532377>, 
      <-4.802115, -0.211345, 4.346232>, <-4.802115, -0.272676, 4.215944>, <-4.764146, -0.224716, 3.846190>, <-4.764146, -0.211346, 3.532377>, 
      <-4.653511, -0.211345, 4.346232>, <-4.653511, -0.272676, 4.215944>, <-4.691480, -0.265922, 3.841697>, <-4.691480, -0.211346, 3.532377>, 
      <-4.636979, -0.211345, 4.346232>, <-4.636979, -0.272676, 4.215944>, <-4.636979, -0.265922, 3.841697>, <-4.636979, -0.211346, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-4.818647, 0.171765, 4.346232>, <-4.818647, 0.142894, 4.407563>, <-4.818647, -0.182474, 4.407563>, <-4.818647, -0.211345, 4.346232>, 
      <-4.802115, 0.171765, 4.346232>, <-4.802115, 0.142894, 4.407563>, <-4.802115, -0.182474, 4.407563>, <-4.802115, -0.211345, 4.346232>, 
      <-4.653511, 0.171765, 4.346232>, <-4.653511, 0.142894, 4.407563>, <-4.653511, -0.182474, 4.407563>, <-4.653511, -0.211345, 4.346232>, 
      <-4.636979, 0.171765, 4.346232>, <-4.636979, 0.142894, 4.407563>, <-4.636979, -0.182474, 4.407563>, <-4.636979, -0.211345, 4.346232>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-4.818647, 0.171765, 4.346232>, <-4.802115, 0.171765, 4.346232>, <-4.653511, 0.171765, 4.346232>, <-4.636979, 0.171765, 4.346232>, 
      <-4.818647, 0.233096, 4.215944>, <-4.802115, 0.233096, 4.215944>, <-4.653511, 0.233096, 4.215944>, <-4.636979, 0.233096, 4.215944>, 
      <-4.818647, 0.186053, 3.846150>, <-4.764146, 0.186053, 3.846150>, <-4.691480, 0.229972, 3.841034>, <-4.636979, 0.229972, 3.841034>, 
      <-4.818647, 0.171765, 3.532377>, <-4.764146, 0.171765, 3.532377>, <-4.691480, 0.171765, 3.532377>, <-4.636979, 0.171765, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-5.000315, -0.026161, 3.296675>, <-5.000315, 0.033217, 3.367386>, <-5.000315, 0.149753, 3.415650>, <-5.000315, 0.171765, 3.532377>, 
      <-4.945815, -0.026161, 2.307613>, <-4.945815, 0.033217, 2.378324>, <-4.945815, 0.149753, 3.415650>, <-4.945815, 0.171765, 3.532377>, 
      <-4.907953, -0.026161, -0.000197>, <-4.907953, 0.069534, -0.000197>, <-4.873148, 0.109648, 2.168298>, <-4.873148, 0.171765, 3.532377>, 
      <-4.818647, -0.026161, -0.000197>, <-4.818647, 0.069534, -0.000197>, <-4.818647, 0.109648, 2.168298>, <-4.818647, 0.171765, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-5.000315, -0.211346, 3.532377>, <-5.000315, -0.191245, 3.418452>, <-5.000315, -0.081716, 3.367386>, <-5.000315, -0.026161, 3.296675>, 
      <-4.945815, -0.211346, 3.532377>, <-4.945815, -0.191245, 3.418452>, <-4.945815, -0.081716, 2.378324>, <-4.945815, -0.026161, 2.307613>, 
      <-4.873148, -0.211346, 3.532377>, <-4.873148, -0.153232, 2.168388>, <-4.907953, -0.121838, -0.000197>, <-4.907953, -0.026161, -0.000197>, 
      <-4.818647, -0.211346, 3.532377>, <-4.818647, -0.153232, 2.168388>, <-4.818647, -0.121838, -0.000197>, <-4.818647, -0.026161, -0.000197>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-5.000315, -0.211345, 4.346232>, <-5.000315, -0.272676, 4.215944>, <-5.000315, -0.265922, 3.841697>, <-5.000315, -0.211346, 3.532377>, 
      <-4.983783, -0.211345, 4.346232>, <-4.983783, -0.272676, 4.215944>, <-4.945815, -0.265922, 3.841697>, <-4.945815, -0.211346, 3.532377>, 
      <-4.835179, -0.211345, 4.346232>, <-4.835179, -0.272676, 4.215944>, <-4.873148, -0.224716, 3.846190>, <-4.873148, -0.211346, 3.532377>, 
      <-4.818647, -0.211345, 4.346232>, <-4.818647, -0.272676, 4.215944>, <-4.818647, -0.224716, 3.846190>, <-4.818647, -0.211346, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-5.000315, 0.171765, 4.346232>, <-5.000315, 0.142894, 4.407563>, <-5.000315, -0.182474, 4.407563>, <-5.000315, -0.211345, 4.346232>, 
      <-4.983783, 0.171765, 4.346232>, <-4.983783, 0.142894, 4.407563>, <-4.983783, -0.182474, 4.407563>, <-4.983783, -0.211345, 4.346232>, 
      <-4.835179, 0.171765, 4.346232>, <-4.835179, 0.142894, 4.407563>, <-4.835179, -0.182474, 4.407563>, <-4.835179, -0.211345, 4.346232>, 
      <-4.818647, 0.171765, 4.346232>, <-4.818647, 0.142894, 4.407563>, <-4.818647, -0.182474, 4.407563>, <-4.818647, -0.211345, 4.346232>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-5.000315, 0.171765, 4.346232>, <-4.983783, 0.171765, 4.346232>, <-4.835179, 0.171765, 4.346232>, <-4.818647, 0.171765, 4.346232>, 
      <-5.000315, 0.233096, 4.215944>, <-4.983783, 0.233096, 4.215944>, <-4.835179, 0.233096, 4.215944>, <-4.818647, 0.233096, 4.215944>, 
      <-5.000315, 0.229972, 3.841034>, <-4.945815, 0.229972, 3.841034>, <-4.873148, 0.186053, 3.846150>, <-4.818647, 0.186053, 3.846150>, 
      <-5.000315, 0.171765, 3.532377>, <-4.945815, 0.171765, 3.532377>, <-4.873148, 0.171765, 3.532377>, <-4.818647, 0.171765, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-5.181983, -0.026161, -0.000197>, <-5.181983, 0.069534, -0.000197>, <-5.181983, 0.109648, 2.168298>, <-5.181983, 0.171765, 3.532377>, 
      <-5.092677, -0.026161, -0.000197>, <-5.092677, 0.069534, -0.000197>, <-5.127482, 0.109648, 2.168298>, <-5.127482, 0.171765, 3.532377>, 
      <-5.054816, -0.026161, 2.307613>, <-5.054816, 0.033217, 2.378324>, <-5.054816, 0.149753, 3.415650>, <-5.054816, 0.171765, 3.532377>, 
      <-5.000315, -0.026161, 3.296675>, <-5.000315, 0.033217, 3.367386>, <-5.000315, 0.149753, 3.415650>, <-5.000315, 0.171765, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-5.181983, -0.211346, 3.532377>, <-5.181983, -0.153232, 2.168388>, <-5.181983, -0.121838, -0.000197>, <-5.181983, -0.026161, -0.000197>, 
      <-5.127482, -0.211346, 3.532377>, <-5.127482, -0.153232, 2.168388>, <-5.092677, -0.121838, -0.000197>, <-5.092677, -0.026161, -0.000197>, 
      <-5.054816, -0.211346, 3.532377>, <-5.054816, -0.191245, 3.418452>, <-5.054816, -0.081716, 2.378324>, <-5.054816, -0.026161, 2.307613>, 
      <-5.000315, -0.211346, 3.532377>, <-5.000315, -0.191245, 3.418452>, <-5.000315, -0.081716, 3.367386>, <-5.000315, -0.026161, 3.296675>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-5.181983, -0.211345, 4.346232>, <-5.181983, -0.272676, 4.215944>, <-5.181983, -0.224716, 3.846190>, <-5.181983, -0.211346, 3.532377>, 
      <-5.165451, -0.211345, 4.346232>, <-5.165451, -0.272676, 4.215944>, <-5.127482, -0.224716, 3.846190>, <-5.127482, -0.211346, 3.532377>, 
      <-5.016847, -0.211345, 4.346232>, <-5.016847, -0.272676, 4.215944>, <-5.054816, -0.265922, 3.841697>, <-5.054816, -0.211346, 3.532377>, 
      <-5.000315, -0.211345, 4.346232>, <-5.000315, -0.272676, 4.215944>, <-5.000315, -0.265922, 3.841697>, <-5.000315, -0.211346, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-5.181983, 0.171765, 4.346232>, <-5.181983, 0.142894, 4.407563>, <-5.181983, -0.182474, 4.407563>, <-5.181983, -0.211345, 4.346232>, 
      <-5.165451, 0.171765, 4.346232>, <-5.165451, 0.142894, 4.407563>, <-5.165451, -0.182474, 4.407563>, <-5.165451, -0.211345, 4.346232>, 
      <-5.016847, 0.171765, 4.346232>, <-5.016847, 0.142894, 4.407563>, <-5.016847, -0.182474, 4.407563>, <-5.016847, -0.211345, 4.346232>, 
      <-5.000315, 0.171765, 4.346232>, <-5.000315, 0.142894, 4.407563>, <-5.000315, -0.182474, 4.407563>, <-5.000315, -0.211345, 4.346232>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-5.181983, 0.171765, 4.346232>, <-5.165451, 0.171765, 4.346232>, <-5.016847, 0.171765, 4.346232>, <-5.000315, 0.171765, 4.346232>, 
      <-5.181983, 0.233096, 4.215944>, <-5.165451, 0.233096, 4.215944>, <-5.016847, 0.233096, 4.215944>, <-5.000315, 0.233096, 4.215944>, 
      <-5.181983, 0.186053, 3.846150>, <-5.127482, 0.186053, 3.846150>, <-5.054816, 0.229972, 3.841034>, <-5.000315, 0.229972, 3.841034>, 
      <-5.181983, 0.171765, 3.532377>, <-5.127482, 0.171765, 3.532377>, <-5.054816, 0.171765, 3.532377>, <-5.000315, 0.171765, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-5.363650, -0.026161, 3.296675>, <-5.363650, 0.033217, 3.367386>, <-5.363650, 0.149753, 3.415650>, <-5.363650, 0.171765, 3.532377>, 
      <-5.309150, -0.026161, 2.307613>, <-5.309150, 0.033217, 2.378324>, <-5.309150, 0.149753, 3.415650>, <-5.309150, 0.171765, 3.532377>, 
      <-5.271289, -0.026161, -0.000197>, <-5.271289, 0.069534, -0.000197>, <-5.236483, 0.109648, 2.168298>, <-5.236483, 0.171765, 3.532377>, 
      <-5.181983, -0.026161, -0.000197>, <-5.181983, 0.069534, -0.000197>, <-5.181983, 0.109648, 2.168298>, <-5.181983, 0.171765, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-5.363650, -0.211346, 3.532377>, <-5.363650, -0.191245, 3.418452>, <-5.363650, -0.081716, 3.367386>, <-5.363650, -0.026161, 3.296675>, 
      <-5.309150, -0.211346, 3.532377>, <-5.309150, -0.191245, 3.418452>, <-5.309150, -0.081716, 2.378324>, <-5.309150, -0.026161, 2.307613>, 
      <-5.236483, -0.211346, 3.532377>, <-5.236483, -0.153232, 2.168388>, <-5.271289, -0.121838, -0.000197>, <-5.271289, -0.026161, -0.000197>, 
      <-5.181983, -0.211346, 3.532377>, <-5.181983, -0.153232, 2.168388>, <-5.181983, -0.121838, -0.000197>, <-5.181983, -0.026161, -0.000197>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-5.363650, -0.211345, 4.346232>, <-5.363650, -0.272676, 4.215944>, <-5.363650, -0.265922, 3.841697>, <-5.363650, -0.211346, 3.532377>, 
      <-5.347118, -0.211345, 4.346232>, <-5.347118, -0.272676, 4.215944>, <-5.309150, -0.265922, 3.841697>, <-5.309150, -0.211346, 3.532377>, 
      <-5.198514, -0.211345, 4.346232>, <-5.198514, -0.272676, 4.215944>, <-5.236483, -0.224716, 3.846190>, <-5.236483, -0.211346, 3.532377>, 
      <-5.181983, -0.211345, 4.346232>, <-5.181983, -0.272676, 4.215944>, <-5.181983, -0.224716, 3.846190>, <-5.181983, -0.211346, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-5.363650, 0.171765, 4.346232>, <-5.363650, 0.142894, 4.407563>, <-5.363650, -0.182474, 4.407563>, <-5.363650, -0.211345, 4.346232>, 
      <-5.347118, 0.171765, 4.346232>, <-5.347118, 0.142894, 4.407563>, <-5.347118, -0.182474, 4.407563>, <-5.347118, -0.211345, 4.346232>, 
      <-5.198514, 0.171765, 4.346232>, <-5.198514, 0.142894, 4.407563>, <-5.198514, -0.182474, 4.407563>, <-5.198514, -0.211345, 4.346232>, 
      <-5.181983, 0.171765, 4.346232>, <-5.181983, 0.142894, 4.407563>, <-5.181983, -0.182474, 4.407563>, <-5.181983, -0.211345, 4.346232>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-5.363650, 0.171765, 4.346232>, <-5.347118, 0.171765, 4.346232>, <-5.198514, 0.171765, 4.346232>, <-5.181983, 0.171765, 4.346232>, 
      <-5.363650, 0.233096, 4.215944>, <-5.347118, 0.233096, 4.215944>, <-5.198514, 0.233096, 4.215944>, <-5.181983, 0.233096, 4.215944>, 
      <-5.363650, 0.229972, 3.841034>, <-5.309150, 0.229972, 3.841034>, <-5.236483, 0.186053, 3.846150>, <-5.181983, 0.186053, 3.846150>, 
      <-5.363650, 0.171765, 3.532377>, <-5.309150, 0.171765, 3.532377>, <-5.236483, 0.171765, 3.532377>, <-5.181983, 0.171765, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-5.545318, -0.026161, -0.000197>, <-5.545318, 0.069534, -0.000197>, <-5.545318, 0.109648, 2.168298>, <-5.545318, 0.171765, 3.532377>, 
      <-5.456012, -0.026161, -0.000197>, <-5.456012, 0.069534, -0.000197>, <-5.490818, 0.109648, 2.168298>, <-5.490818, 0.171765, 3.532377>, 
      <-5.418150, -0.026161, 2.307613>, <-5.418150, 0.033217, 2.378324>, <-5.418150, 0.149753, 3.415650>, <-5.418150, 0.171765, 3.532377>, 
      <-5.363650, -0.026161, 3.296675>, <-5.363650, 0.033217, 3.367386>, <-5.363650, 0.149753, 3.415650>, <-5.363650, 0.171765, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-5.545318, -0.211346, 3.532377>, <-5.545318, -0.153232, 2.168388>, <-5.545318, -0.121838, -0.000197>, <-5.545318, -0.026161, -0.000197>, 
      <-5.490818, -0.211346, 3.532377>, <-5.490818, -0.153232, 2.168388>, <-5.456012, -0.121838, -0.000197>, <-5.456012, -0.026161, -0.000197>, 
      <-5.418150, -0.211346, 3.532377>, <-5.418150, -0.191245, 3.418452>, <-5.418150, -0.081716, 2.378324>, <-5.418150, -0.026161, 2.307613>, 
      <-5.363650, -0.211346, 3.532377>, <-5.363650, -0.191245, 3.418452>, <-5.363650, -0.081716, 3.367386>, <-5.363650, -0.026161, 3.296675>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-5.545318, -0.211345, 4.346232>, <-5.545318, -0.272676, 4.215944>, <-5.545318, -0.224716, 3.846190>, <-5.545318, -0.211346, 3.532377>, 
      <-5.528786, -0.211345, 4.346232>, <-5.528786, -0.272676, 4.215944>, <-5.490818, -0.224716, 3.846190>, <-5.490818, -0.211346, 3.532377>, 
      <-5.380182, -0.211345, 4.346232>, <-5.380182, -0.272676, 4.215944>, <-5.418150, -0.265922, 3.841697>, <-5.418150, -0.211346, 3.532377>, 
      <-5.363650, -0.211345, 4.346232>, <-5.363650, -0.272676, 4.215944>, <-5.363650, -0.265922, 3.841697>, <-5.363650, -0.211346, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-5.545318, 0.171765, 4.346232>, <-5.545318, 0.142894, 4.407563>, <-5.545318, -0.182474, 4.407563>, <-5.545318, -0.211345, 4.346232>, 
      <-5.528786, 0.171765, 4.346232>, <-5.528786, 0.142894, 4.407563>, <-5.528786, -0.182474, 4.407563>, <-5.528786, -0.211345, 4.346232>, 
      <-5.380182, 0.171765, 4.346232>, <-5.380182, 0.142894, 4.407563>, <-5.380182, -0.182474, 4.407563>, <-5.380182, -0.211345, 4.346232>, 
      <-5.363650, 0.171765, 4.346232>, <-5.363650, 0.142894, 4.407563>, <-5.363650, -0.182474, 4.407563>, <-5.363650, -0.211345, 4.346232>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-5.545318, 0.171765, 4.346232>, <-5.528786, 0.171765, 4.346232>, <-5.380182, 0.171765, 4.346232>, <-5.363650, 0.171765, 4.346232>, 
      <-5.545318, 0.233096, 4.215944>, <-5.528786, 0.233096, 4.215944>, <-5.380182, 0.233096, 4.215944>, <-5.363650, 0.233096, 4.215944>, 
      <-5.545318, 0.186053, 3.846150>, <-5.490818, 0.186053, 3.846150>, <-5.418150, 0.229972, 3.841034>, <-5.363650, 0.229972, 3.841034>, 
      <-5.545318, 0.171765, 3.532377>, <-5.490818, 0.171765, 3.532377>, <-5.418150, 0.171765, 3.532377>, <-5.363650, 0.171765, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-5.726986, -0.026161, 3.296675>, <-5.726986, 0.033217, 3.367386>, <-5.726986, 0.149753, 3.415650>, <-5.726986, 0.171765, 3.532377>, 
      <-5.672485, -0.026161, 2.307613>, <-5.672485, 0.033217, 2.378324>, <-5.672485, 0.149753, 3.415650>, <-5.672485, 0.171765, 3.532377>, 
      <-5.634624, -0.026161, -0.000197>, <-5.634624, 0.069534, -0.000197>, <-5.599819, 0.109648, 2.168298>, <-5.599819, 0.171765, 3.532377>, 
      <-5.545318, -0.026161, -0.000197>, <-5.545318, 0.069534, -0.000197>, <-5.545318, 0.109648, 2.168298>, <-5.545318, 0.171765, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-5.726986, -0.211346, 3.532377>, <-5.726986, -0.191245, 3.418452>, <-5.726986, -0.081716, 3.367386>, <-5.726986, -0.026161, 3.296675>, 
      <-5.672485, -0.211346, 3.532377>, <-5.672485, -0.191245, 3.418452>, <-5.672485, -0.081716, 2.378324>, <-5.672485, -0.026161, 2.307613>, 
      <-5.599819, -0.211346, 3.532377>, <-5.599819, -0.153232, 2.168388>, <-5.634624, -0.121838, -0.000197>, <-5.634624, -0.026161, -0.000197>, 
      <-5.545318, -0.211346, 3.532377>, <-5.545318, -0.153232, 2.168388>, <-5.545318, -0.121838, -0.000197>, <-5.545318, -0.026161, -0.000197>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-5.726986, -0.211345, 4.346232>, <-5.726986, -0.272676, 4.215944>, <-5.726986, -0.265922, 3.841697>, <-5.726986, -0.211346, 3.532377>, 
      <-5.710454, -0.211345, 4.346232>, <-5.710454, -0.272676, 4.215944>, <-5.672485, -0.265922, 3.841697>, <-5.672485, -0.211346, 3.532377>, 
      <-5.561850, -0.211345, 4.346232>, <-5.561850, -0.272676, 4.215944>, <-5.599819, -0.224716, 3.846190>, <-5.599819, -0.211346, 3.532377>, 
      <-5.545318, -0.211345, 4.346232>, <-5.545318, -0.272676, 4.215944>, <-5.545318, -0.224716, 3.846190>, <-5.545318, -0.211346, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-5.726986, 0.171765, 4.346232>, <-5.726986, 0.142894, 4.407563>, <-5.726986, -0.182474, 4.407563>, <-5.726986, -0.211345, 4.346232>, 
      <-5.710454, 0.171765, 4.346232>, <-5.710454, 0.142894, 4.407563>, <-5.710454, -0.182474, 4.407563>, <-5.710454, -0.211345, 4.346232>, 
      <-5.561850, 0.171765, 4.346232>, <-5.561850, 0.142894, 4.407563>, <-5.561850, -0.182474, 4.407563>, <-5.561850, -0.211345, 4.346232>, 
      <-5.545318, 0.171765, 4.346232>, <-5.545318, 0.142894, 4.407563>, <-5.545318, -0.182474, 4.407563>, <-5.545318, -0.211345, 4.346232>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-5.726986, 0.171765, 4.346232>, <-5.710454, 0.171765, 4.346232>, <-5.561850, 0.171765, 4.346232>, <-5.545318, 0.171765, 4.346232>, 
      <-5.726986, 0.233096, 4.215944>, <-5.710454, 0.233096, 4.215944>, <-5.561850, 0.233096, 4.215944>, <-5.545318, 0.233096, 4.215944>, 
      <-5.726986, 0.229972, 3.841034>, <-5.672485, 0.229972, 3.841034>, <-5.599819, 0.186053, 3.846150>, <-5.545318, 0.186053, 3.846150>, 
      <-5.726986, 0.171765, 3.532377>, <-5.672485, 0.171765, 3.532377>, <-5.599819, 0.171765, 3.532377>, <-5.545318, 0.171765, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-5.908653, -0.026161, -0.000197>, <-5.908653, 0.069534, -0.000197>, <-5.908653, 0.109648, 2.168298>, <-5.908653, 0.171765, 3.532377>, 
      <-5.819347, -0.026161, -0.000197>, <-5.819347, 0.069534, -0.000197>, <-5.854153, 0.109648, 2.168298>, <-5.854153, 0.171765, 3.532377>, 
      <-5.781486, -0.026161, 2.307613>, <-5.781486, 0.033217, 2.378324>, <-5.781486, 0.149753, 3.415650>, <-5.781486, 0.171765, 3.532377>, 
      <-5.726986, -0.026161, 3.296675>, <-5.726986, 0.033217, 3.367386>, <-5.726986, 0.149753, 3.415650>, <-5.726986, 0.171765, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-5.908653, -0.211346, 3.532377>, <-5.908653, -0.153232, 2.168388>, <-5.908653, -0.121838, -0.000197>, <-5.908653, -0.026161, -0.000197>, 
      <-5.854153, -0.211346, 3.532377>, <-5.854153, -0.153232, 2.168388>, <-5.819347, -0.121838, -0.000197>, <-5.819347, -0.026161, -0.000197>, 
      <-5.781486, -0.211346, 3.532377>, <-5.781486, -0.191245, 3.418452>, <-5.781486, -0.081716, 2.378324>, <-5.781486, -0.026161, 2.307613>, 
      <-5.726986, -0.211346, 3.532377>, <-5.726986, -0.191245, 3.418452>, <-5.726986, -0.081716, 3.367386>, <-5.726986, -0.026161, 3.296675>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-5.908653, -0.211345, 4.346232>, <-5.908653, -0.272676, 4.215944>, <-5.908653, -0.224716, 3.846190>, <-5.908653, -0.211346, 3.532377>, 
      <-5.892121, -0.211345, 4.346232>, <-5.892121, -0.272676, 4.215944>, <-5.854153, -0.224716, 3.846190>, <-5.854153, -0.211346, 3.532377>, 
      <-5.743517, -0.211345, 4.346232>, <-5.743517, -0.272676, 4.215944>, <-5.781486, -0.265922, 3.841697>, <-5.781486, -0.211346, 3.532377>, 
      <-5.726986, -0.211345, 4.346232>, <-5.726986, -0.272676, 4.215944>, <-5.726986, -0.265922, 3.841697>, <-5.726986, -0.211346, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-5.908653, 0.171765, 4.346232>, <-5.908653, 0.142894, 4.407563>, <-5.908653, -0.182474, 4.407563>, <-5.908653, -0.211345, 4.346232>, 
      <-5.892121, 0.171765, 4.346232>, <-5.892121, 0.142894, 4.407563>, <-5.892121, -0.182474, 4.407563>, <-5.892121, -0.211345, 4.346232>, 
      <-5.743517, 0.171765, 4.346232>, <-5.743517, 0.142894, 4.407563>, <-5.743517, -0.182474, 4.407563>, <-5.743517, -0.211345, 4.346232>, 
      <-5.726986, 0.171765, 4.346232>, <-5.726986, 0.142894, 4.407563>, <-5.726986, -0.182474, 4.407563>, <-5.726986, -0.211345, 4.346232>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-5.908653, 0.171765, 4.346232>, <-5.892121, 0.171765, 4.346232>, <-5.743517, 0.171765, 4.346232>, <-5.726986, 0.171765, 4.346232>, 
      <-5.908653, 0.233096, 4.215944>, <-5.892121, 0.233096, 4.215944>, <-5.743517, 0.233096, 4.215944>, <-5.726986, 0.233096, 4.215944>, 
      <-5.908653, 0.186053, 3.846150>, <-5.854153, 0.186053, 3.846150>, <-5.781486, 0.229972, 3.841034>, <-5.726986, 0.229972, 3.841034>, 
      <-5.908653, 0.171765, 3.532377>, <-5.854153, 0.171765, 3.532377>, <-5.781486, 0.171765, 3.532377>, <-5.726986, 0.171765, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-6.090321, -0.026161, 3.296675>, <-6.090321, 0.033217, 3.367386>, <-6.090321, 0.149753, 3.415650>, <-6.090321, 0.171765, 3.532377>, 
      <-6.035820, -0.026161, 2.307613>, <-6.035820, 0.033217, 2.378324>, <-6.035820, 0.149753, 3.415650>, <-6.035820, 0.171765, 3.532377>, 
      <-5.997959, -0.026161, -0.000197>, <-5.997959, 0.069534, -0.000197>, <-5.963153, 0.109648, 2.168298>, <-5.963153, 0.171765, 3.532377>, 
      <-5.908653, -0.026161, -0.000197>, <-5.908653, 0.069534, -0.000197>, <-5.908653, 0.109648, 2.168298>, <-5.908653, 0.171765, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-6.090321, -0.211346, 3.532377>, <-6.090321, -0.191245, 3.418452>, <-6.090321, -0.081716, 3.367386>, <-6.090321, -0.026161, 3.296675>, 
      <-6.035820, -0.211346, 3.532377>, <-6.035820, -0.191245, 3.418452>, <-6.035820, -0.081716, 2.378324>, <-6.035820, -0.026161, 2.307613>, 
      <-5.963153, -0.211346, 3.532377>, <-5.963153, -0.153232, 2.168388>, <-5.997959, -0.121838, -0.000197>, <-5.997959, -0.026161, -0.000197>, 
      <-5.908653, -0.211346, 3.532377>, <-5.908653, -0.153232, 2.168388>, <-5.908653, -0.121838, -0.000197>, <-5.908653, -0.026161, -0.000197>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-6.090321, -0.211345, 4.346232>, <-6.090321, -0.272676, 4.215944>, <-6.090321, -0.265922, 3.841697>, <-6.090321, -0.211346, 3.532377>, 
      <-6.073789, -0.211345, 4.346232>, <-6.073789, -0.272676, 4.215944>, <-6.035820, -0.265922, 3.841697>, <-6.035820, -0.211346, 3.532377>, 
      <-5.925185, -0.211345, 4.346232>, <-5.925185, -0.272676, 4.215944>, <-5.963153, -0.224716, 3.846190>, <-5.963153, -0.211346, 3.532377>, 
      <-5.908653, -0.211345, 4.346232>, <-5.908653, -0.272676, 4.215944>, <-5.908653, -0.224716, 3.846190>, <-5.908653, -0.211346, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-6.090321, 0.171765, 4.346232>, <-6.090321, 0.142894, 4.407563>, <-6.090321, -0.182474, 4.407563>, <-6.090321, -0.211345, 4.346232>, 
      <-6.073789, 0.171765, 4.346232>, <-6.073789, 0.142894, 4.407563>, <-6.073789, -0.182474, 4.407563>, <-6.073789, -0.211345, 4.346232>, 
      <-5.925185, 0.171765, 4.346232>, <-5.925185, 0.142894, 4.407563>, <-5.925185, -0.182474, 4.407563>, <-5.925185, -0.211345, 4.346232>, 
      <-5.908653, 0.171765, 4.346232>, <-5.908653, 0.142894, 4.407563>, <-5.908653, -0.182474, 4.407563>, <-5.908653, -0.211345, 4.346232>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-6.090321, 0.171765, 4.346232>, <-6.073789, 0.171765, 4.346232>, <-5.925185, 0.171765, 4.346232>, <-5.908653, 0.171765, 4.346232>, 
      <-6.090321, 0.233096, 4.215944>, <-6.073789, 0.233096, 4.215944>, <-5.925185, 0.233096, 4.215944>, <-5.908653, 0.233096, 4.215944>, 
      <-6.090321, 0.229972, 3.841034>, <-6.035820, 0.229972, 3.841034>, <-5.963153, 0.186053, 3.846150>, <-5.908653, 0.186053, 3.846150>, 
      <-6.090321, 0.171765, 3.532377>, <-6.035820, 0.171765, 3.532377>, <-5.963153, 0.171765, 3.532377>, <-5.908653, 0.171765, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-6.271989, -0.026161, -0.000197>, <-6.271989, 0.069534, -0.000197>, <-6.271989, 0.109648, 2.168298>, <-6.271989, 0.171765, 3.532377>, 
      <-6.182683, -0.026161, -0.000197>, <-6.182683, 0.069534, -0.000197>, <-6.217488, 0.109648, 2.168298>, <-6.217488, 0.171765, 3.532377>, 
      <-6.144822, -0.026161, 2.307613>, <-6.144822, 0.033217, 2.378324>, <-6.144822, 0.149753, 3.415650>, <-6.144822, 0.171765, 3.532377>, 
      <-6.090321, -0.026161, 3.296675>, <-6.090321, 0.033217, 3.367386>, <-6.090321, 0.149753, 3.415650>, <-6.090321, 0.171765, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-6.271989, -0.211346, 3.532377>, <-6.271989, -0.153232, 2.168388>, <-6.271989, -0.121838, -0.000197>, <-6.271989, -0.026161, -0.000197>, 
      <-6.217488, -0.211346, 3.532377>, <-6.217488, -0.153232, 2.168388>, <-6.182683, -0.121838, -0.000197>, <-6.182683, -0.026161, -0.000197>, 
      <-6.144822, -0.211346, 3.532377>, <-6.144822, -0.191245, 3.418452>, <-6.144822, -0.081716, 2.378324>, <-6.144822, -0.026161, 2.307613>, 
      <-6.090321, -0.211346, 3.532377>, <-6.090321, -0.191245, 3.418452>, <-6.090321, -0.081716, 3.367386>, <-6.090321, -0.026161, 3.296675>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-6.271989, -0.211345, 4.346232>, <-6.271989, -0.272676, 4.215944>, <-6.271989, -0.224716, 3.846190>, <-6.271989, -0.211346, 3.532377>, 
      <-6.255457, -0.211345, 4.346232>, <-6.255457, -0.272676, 4.215944>, <-6.217488, -0.224716, 3.846190>, <-6.217488, -0.211346, 3.532377>, 
      <-6.106853, -0.211345, 4.346232>, <-6.106853, -0.272676, 4.215944>, <-6.144822, -0.265922, 3.841697>, <-6.144822, -0.211346, 3.532377>, 
      <-6.090321, -0.211345, 4.346232>, <-6.090321, -0.272676, 4.215944>, <-6.090321, -0.265922, 3.841697>, <-6.090321, -0.211346, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-6.271989, 0.171765, 4.346232>, <-6.271989, 0.142894, 4.407563>, <-6.271989, -0.182474, 4.407563>, <-6.271989, -0.211345, 4.346232>, 
      <-6.255457, 0.171765, 4.346232>, <-6.255457, 0.142894, 4.407563>, <-6.255457, -0.182474, 4.407563>, <-6.255457, -0.211345, 4.346232>, 
      <-6.106853, 0.171765, 4.346232>, <-6.106853, 0.142894, 4.407563>, <-6.106853, -0.182474, 4.407563>, <-6.106853, -0.211345, 4.346232>, 
      <-6.090321, 0.171765, 4.346232>, <-6.090321, 0.142894, 4.407563>, <-6.090321, -0.182474, 4.407563>, <-6.090321, -0.211345, 4.346232>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-6.271989, 0.171765, 4.346232>, <-6.255457, 0.171765, 4.346232>, <-6.106853, 0.171765, 4.346232>, <-6.090321, 0.171765, 4.346232>, 
      <-6.271989, 0.233096, 4.215944>, <-6.255457, 0.233096, 4.215944>, <-6.106853, 0.233096, 4.215944>, <-6.090321, 0.233096, 4.215944>, 
      <-6.271989, 0.186053, 3.846150>, <-6.217488, 0.186053, 3.846150>, <-6.144822, 0.229972, 3.841034>, <-6.090321, 0.229972, 3.841034>, 
      <-6.271989, 0.171765, 3.532377>, <-6.217488, 0.171765, 3.532377>, <-6.144822, 0.171765, 3.532377>, <-6.090321, 0.171765, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-6.453655, -0.026161, 3.296675>, <-6.453655, 0.033217, 3.367386>, <-6.453655, 0.149753, 3.415650>, <-6.453655, 0.171765, 3.532377>, 
      <-6.399155, -0.026161, 2.307613>, <-6.399155, 0.033217, 2.378324>, <-6.399155, 0.149753, 3.415650>, <-6.399155, 0.171765, 3.532377>, 
      <-6.361295, -0.026161, -0.000197>, <-6.361295, 0.069534, -0.000197>, <-6.326488, 0.109648, 2.168298>, <-6.326488, 0.171765, 3.532377>, 
      <-6.271989, -0.026161, -0.000197>, <-6.271989, 0.069534, -0.000197>, <-6.271989, 0.109648, 2.168298>, <-6.271989, 0.171765, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-6.453655, -0.211346, 3.532377>, <-6.453655, -0.191245, 3.418452>, <-6.453655, -0.081716, 3.367386>, <-6.453655, -0.026161, 3.296675>, 
      <-6.399155, -0.211346, 3.532377>, <-6.399155, -0.191245, 3.418452>, <-6.399155, -0.081716, 2.378324>, <-6.399155, -0.026161, 2.307613>, 
      <-6.326488, -0.211346, 3.532377>, <-6.326488, -0.153232, 2.168388>, <-6.361295, -0.121838, -0.000197>, <-6.361295, -0.026161, -0.000197>, 
      <-6.271989, -0.211346, 3.532377>, <-6.271989, -0.153232, 2.168388>, <-6.271989, -0.121838, -0.000197>, <-6.271989, -0.026161, -0.000197>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-6.453655, -0.211345, 4.346232>, <-6.453655, -0.272676, 4.215944>, <-6.453655, -0.265922, 3.841697>, <-6.453655, -0.211346, 3.532377>, 
      <-6.437123, -0.211345, 4.346232>, <-6.437123, -0.272676, 4.215944>, <-6.399155, -0.265922, 3.841697>, <-6.399155, -0.211346, 3.532377>, 
      <-6.288520, -0.211345, 4.346232>, <-6.288520, -0.272676, 4.215944>, <-6.326488, -0.224716, 3.846190>, <-6.326488, -0.211346, 3.532377>, 
      <-6.271989, -0.211345, 4.346232>, <-6.271989, -0.272676, 4.215944>, <-6.271989, -0.224716, 3.846190>, <-6.271989, -0.211346, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-6.453655, 0.171765, 4.346232>, <-6.453655, 0.142894, 4.407563>, <-6.453655, -0.182474, 4.407563>, <-6.453655, -0.211345, 4.346232>, 
      <-6.437123, 0.171765, 4.346232>, <-6.437123, 0.142894, 4.407563>, <-6.437123, -0.182474, 4.407563>, <-6.437123, -0.211345, 4.346232>, 
      <-6.288520, 0.171765, 4.346232>, <-6.288520, 0.142894, 4.407563>, <-6.288520, -0.182474, 4.407563>, <-6.288520, -0.211345, 4.346232>, 
      <-6.271989, 0.171765, 4.346232>, <-6.271989, 0.142894, 4.407563>, <-6.271989, -0.182474, 4.407563>, <-6.271989, -0.211345, 4.346232>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-6.453655, 0.171765, 4.346232>, <-6.437123, 0.171765, 4.346232>, <-6.288520, 0.171765, 4.346232>, <-6.271989, 0.171765, 4.346232>, 
      <-6.453655, 0.233096, 4.215944>, <-6.437123, 0.233096, 4.215944>, <-6.288520, 0.233096, 4.215944>, <-6.271989, 0.233096, 4.215944>, 
      <-6.453655, 0.229972, 3.841034>, <-6.399155, 0.229972, 3.841034>, <-6.326488, 0.186053, 3.846150>, <-6.271989, 0.186053, 3.846150>, 
      <-6.453655, 0.171765, 3.532377>, <-6.399155, 0.171765, 3.532377>, <-6.326488, 0.171765, 3.532377>, <-6.271989, 0.171765, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-6.635323, -0.026161, -0.000197>, <-6.635323, 0.069534, -0.000197>, <-6.635323, 0.109648, 2.168298>, <-6.635323, 0.171765, 3.532377>, 
      <-6.546017, -0.026161, -0.000197>, <-6.546017, 0.069534, -0.000197>, <-6.580822, 0.109648, 2.168298>, <-6.580822, 0.171765, 3.532377>, 
      <-6.508155, -0.026161, 2.307613>, <-6.508155, 0.033217, 2.378324>, <-6.508155, 0.149753, 3.415650>, <-6.508155, 0.171765, 3.532377>, 
      <-6.453655, -0.026161, 3.296675>, <-6.453655, 0.033217, 3.367386>, <-6.453655, 0.149753, 3.415650>, <-6.453655, 0.171765, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-6.635323, -0.211346, 3.532377>, <-6.635323, -0.153232, 2.168388>, <-6.635323, -0.121838, -0.000197>, <-6.635323, -0.026161, -0.000197>, 
      <-6.580822, -0.211346, 3.532377>, <-6.580822, -0.153232, 2.168388>, <-6.546017, -0.121838, -0.000197>, <-6.546017, -0.026161, -0.000197>, 
      <-6.508155, -0.211346, 3.532377>, <-6.508155, -0.191245, 3.418452>, <-6.508155, -0.081716, 2.378324>, <-6.508155, -0.026161, 2.307613>, 
      <-6.453655, -0.211346, 3.532377>, <-6.453655, -0.191245, 3.418452>, <-6.453655, -0.081716, 3.367386>, <-6.453655, -0.026161, 3.296675>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-6.635323, -0.211345, 4.346232>, <-6.635323, -0.272676, 4.215944>, <-6.635323, -0.224716, 3.846190>, <-6.635323, -0.211346, 3.532377>, 
      <-6.618791, -0.211345, 4.346232>, <-6.618791, -0.272676, 4.215944>, <-6.580822, -0.224716, 3.846190>, <-6.580822, -0.211346, 3.532377>, 
      <-6.470187, -0.211345, 4.346232>, <-6.470187, -0.272676, 4.215944>, <-6.508155, -0.265922, 3.841697>, <-6.508155, -0.211346, 3.532377>, 
      <-6.453655, -0.211345, 4.346232>, <-6.453655, -0.272676, 4.215944>, <-6.453655, -0.265922, 3.841697>, <-6.453655, -0.211346, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-6.635323, 0.171765, 4.346232>, <-6.635323, 0.142894, 4.407563>, <-6.635323, -0.182474, 4.407563>, <-6.635323, -0.211345, 4.346232>, 
      <-6.618791, 0.171765, 4.346232>, <-6.618791, 0.142894, 4.407563>, <-6.618791, -0.182474, 4.407563>, <-6.618791, -0.211345, 4.346232>, 
      <-6.470187, 0.171765, 4.346232>, <-6.470187, 0.142894, 4.407563>, <-6.470187, -0.182474, 4.407563>, <-6.470187, -0.211345, 4.346232>, 
      <-6.453655, 0.171765, 4.346232>, <-6.453655, 0.142894, 4.407563>, <-6.453655, -0.182474, 4.407563>, <-6.453655, -0.211345, 4.346232>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-6.635323, 0.171765, 4.346232>, <-6.618791, 0.171765, 4.346232>, <-6.470187, 0.171765, 4.346232>, <-6.453655, 0.171765, 4.346232>, 
      <-6.635323, 0.233096, 4.215944>, <-6.618791, 0.233096, 4.215944>, <-6.470187, 0.233096, 4.215944>, <-6.453655, 0.233096, 4.215944>, 
      <-6.635323, 0.186053, 3.846150>, <-6.580822, 0.186053, 3.846150>, <-6.508155, 0.229972, 3.841034>, <-6.453655, 0.229972, 3.841034>, 
      <-6.635323, 0.171765, 3.532377>, <-6.580822, 0.171765, 3.532377>, <-6.508155, 0.171765, 3.532377>, <-6.453655, 0.171765, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-6.816991, -0.026161, 3.296675>, <-6.816991, 0.033217, 3.367386>, <-6.816991, 0.149753, 3.415650>, <-6.816991, 0.171765, 3.532377>, 
      <-6.762490, -0.026161, 2.307613>, <-6.762490, 0.033217, 2.378324>, <-6.762490, 0.149753, 3.415650>, <-6.762490, 0.171765, 3.532377>, 
      <-6.724629, -0.026161, -0.000197>, <-6.724629, 0.069534, -0.000197>, <-6.689824, 0.109648, 2.168298>, <-6.689824, 0.171765, 3.532377>, 
      <-6.635323, -0.026161, -0.000197>, <-6.635323, 0.069534, -0.000197>, <-6.635323, 0.109648, 2.168298>, <-6.635323, 0.171765, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-6.816991, -0.211346, 3.532377>, <-6.816991, -0.191245, 3.418452>, <-6.816991, -0.081716, 3.367386>, <-6.816991, -0.026161, 3.296675>, 
      <-6.762490, -0.211346, 3.532377>, <-6.762490, -0.191245, 3.418452>, <-6.762490, -0.081716, 2.378324>, <-6.762490, -0.026161, 2.307613>, 
      <-6.689824, -0.211346, 3.532377>, <-6.689824, -0.153232, 2.168388>, <-6.724629, -0.121838, -0.000197>, <-6.724629, -0.026161, -0.000197>, 
      <-6.635323, -0.211346, 3.532377>, <-6.635323, -0.153232, 2.168388>, <-6.635323, -0.121838, -0.000197>, <-6.635323, -0.026161, -0.000197>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-6.816991, -0.211345, 4.346232>, <-6.816991, -0.272676, 4.215944>, <-6.816991, -0.265922, 3.841697>, <-6.816991, -0.211346, 3.532377>, 
      <-6.800503, -0.211345, 4.347440>, <-6.800503, -0.272676, 4.217152>, <-6.762490, -0.265922, 3.841697>, <-6.762490, -0.211346, 3.532377>, 
      <-6.651855, -0.211345, 4.346232>, <-6.651855, -0.272676, 4.215944>, <-6.689824, -0.224716, 3.846190>, <-6.689824, -0.211346, 3.532377>, 
      <-6.635323, -0.211345, 4.346232>, <-6.635323, -0.272676, 4.215944>, <-6.635323, -0.224716, 3.846190>, <-6.635323, -0.211346, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-6.816991, 0.171765, 4.346232>, <-6.816991, 0.142894, 4.407563>, <-6.816991, -0.182474, 4.407563>, <-6.816991, -0.211345, 4.346232>, 
      <-6.800503, 0.171765, 4.347440>, <-6.800503, 0.142894, 4.408772>, <-6.800503, -0.182474, 4.408772>, <-6.800503, -0.211345, 4.347440>, 
      <-6.651855, 0.171765, 4.346232>, <-6.651855, 0.142894, 4.407563>, <-6.651855, -0.182474, 4.407563>, <-6.651855, -0.211345, 4.346232>, 
      <-6.635323, 0.171765, 4.346232>, <-6.635323, 0.142894, 4.407563>, <-6.635323, -0.182474, 4.407563>, <-6.635323, -0.211345, 4.346232>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-6.816991, 0.171765, 4.346232>, <-6.800503, 0.171765, 4.347440>, <-6.651855, 0.171765, 4.346232>, <-6.635323, 0.171765, 4.346232>, 
      <-6.816991, 0.233096, 4.215944>, <-6.800503, 0.233096, 4.217152>, <-6.651855, 0.233096, 4.215944>, <-6.635323, 0.233096, 4.215944>, 
      <-6.816991, 0.229972, 3.841034>, <-6.762490, 0.229972, 3.841034>, <-6.689824, 0.186053, 3.846150>, <-6.635323, 0.186053, 3.846150>, 
      <-6.816991, 0.171765, 3.532377>, <-6.762490, 0.171765, 3.532377>, <-6.689824, 0.171765, 3.532377>, <-6.635323, 0.171765, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-6.998658, -0.026161, -0.000197>, <-6.998658, 0.069534, -0.000197>, <-6.998658, 0.109266, 2.168315>, <-6.998658, 0.171765, 3.532377>, 
      <-6.909352, -0.026161, -0.000197>, <-6.909352, 0.069534, -0.000197>, <-6.944158, 0.109266, 2.168315>, <-6.944158, 0.171765, 3.532377>, 
      <-6.871491, -0.026161, 2.307613>, <-6.871491, 0.033217, 2.378324>, <-6.871491, 0.149753, 3.415650>, <-6.871491, 0.171765, 3.532377>, 
      <-6.816991, -0.026161, 3.296675>, <-6.816991, 0.033217, 3.367386>, <-6.816991, 0.149753, 3.415650>, <-6.816991, 0.171765, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-6.998658, -0.026161, -0.000197>, <-7.087964, -0.026161, -0.000197>, <-7.125826, -0.026161, 2.307613>, <-7.180326, -0.026161, 3.296675>, 
      <-6.998658, 0.069534, -0.000197>, <-7.087964, 0.069534, -0.000197>, <-7.125826, 0.033217, 2.378324>, <-7.180326, 0.033217, 3.367386>, 
      <-6.998658, 0.109266, 2.168315>, <-7.053158, 0.109266, 2.168315>, <-7.125826, 0.148009, 3.415992>, <-7.180326, 0.148009, 3.415992>, 
      <-6.998658, 0.171765, 3.532377>, <-7.053158, 0.171765, 3.532377>, <-7.125826, 0.171765, 3.532377>, <-7.180326, 0.171765, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-6.998658, -0.211346, 3.532377>, <-6.998658, -0.152874, 2.168403>, <-6.998658, -0.121838, -0.000197>, <-6.998658, -0.026161, -0.000197>, 
      <-6.944158, -0.211346, 3.532377>, <-6.944158, -0.152874, 2.168403>, <-6.909352, -0.121838, -0.000197>, <-6.909352, -0.026161, -0.000197>, 
      <-6.871491, -0.211346, 3.532377>, <-6.871491, -0.191245, 3.418452>, <-6.871491, -0.081716, 2.378324>, <-6.871491, -0.026161, 2.307613>, 
      <-6.816991, -0.211346, 3.532377>, <-6.816991, -0.191245, 3.418452>, <-6.816991, -0.081716, 3.367386>, <-6.816991, -0.026161, 3.296675>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-6.998658, -0.211346, 3.532377>, <-7.053158, -0.211346, 3.532377>, <-7.125826, -0.211346, 3.532377>, <-7.180326, -0.211346, 3.532377>, 
      <-6.998658, -0.152874, 2.168403>, <-7.053158, -0.152874, 2.168403>, <-7.125826, -0.189646, 3.418746>, <-7.180326, -0.189645, 3.418746>, 
      <-6.998658, -0.121838, -0.000197>, <-7.087964, -0.121838, -0.000197>, <-7.125826, -0.081716, 2.378324>, <-7.180326, -0.081716, 3.367386>, 
      <-6.998658, -0.026161, -0.000197>, <-7.087964, -0.026161, -0.000197>, <-7.125826, -0.026161, 2.307613>, <-7.180326, -0.026161, 3.296675>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-6.998658, -0.211345, 4.319606>, <-6.998658, -0.272297, 4.194359>, <-6.998658, -0.224358, 3.835920>, <-6.998658, -0.211346, 3.532377>, 
      <-6.982339, -0.211345, 4.323194>, <-6.982339, -0.272297, 4.197947>, <-6.944158, -0.224358, 3.835920>, <-6.944158, -0.211346, 3.532377>, 
      <-6.833654, -0.211345, 4.345011>, <-6.833654, -0.272676, 4.214723>, <-6.871491, -0.265922, 3.841697>, <-6.871491, -0.211346, 3.532377>, 
      <-6.816991, -0.211345, 4.346232>, <-6.816991, -0.272676, 4.215944>, <-6.816991, -0.265922, 3.841697>, <-6.816991, -0.211346, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-6.998658, -0.211345, 4.319606>, <-7.015484, -0.211345, 4.315907>, <-7.164296, -0.211345, 4.272664>, <-7.180326, -0.211345, 4.266354>, 
      <-6.998658, -0.272297, 4.194359>, <-7.015484, -0.272297, 4.190660>, <-7.164296, -0.271438, 4.157535>, <-7.180326, -0.271438, 4.151226>, 
      <-6.998658, -0.224358, 3.835920>, <-7.053158, -0.224358, 3.835920>, <-7.125826, -0.264483, 3.810618>, <-7.180326, -0.264483, 3.810618>, 
      <-6.998658, -0.211346, 3.532377>, <-7.053158, -0.211346, 3.532377>, <-7.125826, -0.211346, 3.532377>, <-7.180326, -0.211346, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-6.998658, 0.171765, 4.319606>, <-6.998658, 0.142102, 4.380558>, <-6.998658, -0.181682, 4.380558>, <-6.998658, -0.211345, 4.319606>, 
      <-6.982339, 0.171765, 4.323194>, <-6.982339, 0.142102, 4.384146>, <-6.982339, -0.181682, 4.384146>, <-6.982339, -0.211345, 4.323194>, 
      <-6.833654, 0.171765, 4.345011>, <-6.833654, 0.142894, 4.406342>, <-6.833654, -0.182474, 4.406342>, <-6.833654, -0.211345, 4.345011>, 
      <-6.816991, 0.171765, 4.346232>, <-6.816991, 0.142894, 4.407563>, <-6.816991, -0.182474, 4.407563>, <-6.816991, -0.211345, 4.346232>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-6.998658, 0.171765, 4.319606>, <-7.015484, 0.171765, 4.315907>, <-7.164296, 0.171765, 4.272664>, <-7.180326, 0.171765, 4.266354>, 
      <-6.998658, 0.142102, 4.380558>, <-7.015484, 0.142102, 4.376859>, <-7.164296, 0.140399, 4.332756>, <-7.180326, 0.140399, 4.326447>, 
      <-6.998658, -0.181682, 4.380558>, <-7.015484, -0.181682, 4.376859>, <-7.164296, -0.179979, 4.332756>, <-7.180326, -0.179979, 4.326447>, 
      <-6.998658, -0.211345, 4.319606>, <-7.015484, -0.211345, 4.315907>, <-7.164296, -0.211345, 4.272664>, <-7.180326, -0.211345, 4.266354>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-6.998658, 0.171765, 4.319606>, <-6.982339, 0.171765, 4.323194>, <-6.833654, 0.171765, 4.345011>, <-6.816991, 0.171765, 4.346232>, 
      <-6.998658, 0.232717, 4.194359>, <-6.982339, 0.232717, 4.197947>, <-6.833654, 0.233096, 4.214723>, <-6.816991, 0.233096, 4.215944>, 
      <-6.998658, 0.185671, 3.835880>, <-6.944158, 0.185671, 3.835880>, <-6.871491, 0.229972, 3.841034>, <-6.816991, 0.229972, 3.841034>, 
      <-6.998658, 0.171765, 3.532377>, <-6.944158, 0.171765, 3.532377>, <-6.871491, 0.171765, 3.532377>, <-6.816991, 0.171765, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-6.998658, 0.171765, 4.319606>, <-6.998658, 0.232717, 4.194359>, <-6.998658, 0.185671, 3.835880>, <-6.998658, 0.171765, 3.532377>, 
      <-7.015484, 0.171765, 4.315907>, <-7.015484, 0.232717, 4.190660>, <-7.053158, 0.185671, 3.835880>, <-7.053158, 0.171765, 3.532377>, 
      <-7.164296, 0.171765, 4.272664>, <-7.164296, 0.231858, 4.157535>, <-7.125826, 0.228416, 3.809924>, <-7.125826, 0.171765, 3.532377>, 
      <-7.180326, 0.171765, 4.266354>, <-7.180326, 0.231858, 4.151226>, <-7.180326, 0.228416, 3.809924>, <-7.180326, 0.171765, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.075752, -0.026161, 3.296675>, <0.075752, 0.033217, 3.367386>, <0.075752, 0.149753, 3.415650>, <0.075752, 0.171765, 3.532377>, 
      <0.130252, -0.026161, 2.307613>, <0.130252, 0.033217, 2.378324>, <0.130252, 0.149753, 3.415650>, <0.130252, 0.171765, 3.532377>, 
      <0.168114, -0.026161, -0.000197>, <0.168114, 0.069534, -0.000197>, <0.202920, 0.109648, 2.168298>, <0.202920, 0.171765, 3.532377>, 
      <0.257420, -0.026161, -0.000197>, <0.257420, 0.069534, -0.000197>, <0.257420, 0.109648, 2.168298>, <0.257420, 0.171765, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.075752, -0.026161, 3.296675>, <0.025576, -0.026161, 2.307613>, <-0.002215, -0.026161, -0.000197>, <-0.091500, -0.026161, -0.000197>, 
      <0.075752, 0.033217, 3.367386>, <0.025576, 0.033217, 2.378324>, <-0.002215, 0.069534, -0.000197>, <-0.091500, 0.069534, -0.000197>, 
      <0.075752, 0.149753, 3.415650>, <0.025576, 0.149753, 3.415650>, <-0.041324, 0.109648, 2.168298>, <-0.091500, 0.109648, 2.168298>, 
      <0.075752, 0.171765, 3.532377>, <0.025576, 0.171765, 3.532377>, <-0.041324, 0.171765, 3.532377>, <-0.091500, 0.171765, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.075752, -0.211346, 3.532377>, <0.075752, -0.191245, 3.418452>, <0.075752, -0.081716, 3.367386>, <0.075752, -0.026161, 3.296675>, 
      <0.130252, -0.211346, 3.532377>, <0.130252, -0.191245, 3.418452>, <0.130252, -0.081716, 2.378324>, <0.130252, -0.026161, 2.307613>, 
      <0.202920, -0.211346, 3.532377>, <0.202920, -0.153232, 2.168388>, <0.168114, -0.121838, -0.000197>, <0.168114, -0.026161, -0.000197>, 
      <0.257420, -0.211346, 3.532377>, <0.257420, -0.153232, 2.168388>, <0.257420, -0.121838, -0.000197>, <0.257420, -0.026161, -0.000197>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.075752, -0.211346, 3.532377>, <0.025576, -0.211346, 3.532377>, <-0.041324, -0.211346, 3.532377>, <-0.091500, -0.211346, 3.532377>, 
      <0.075752, -0.191245, 3.418452>, <0.025576, -0.191245, 3.418452>, <-0.041324, -0.153232, 2.168388>, <-0.091500, -0.153232, 2.168388>, 
      <0.075752, -0.081716, 3.367386>, <0.025576, -0.081716, 2.378324>, <-0.002215, -0.121838, -0.000197>, <-0.091500, -0.121838, -0.000197>, 
      <0.075752, -0.026161, 3.296675>, <0.025576, -0.026161, 2.307613>, <-0.002215, -0.026161, -0.000197>, <-0.091500, -0.026161, -0.000197>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.075752, -0.211345, 4.346232>, <0.075752, -0.272676, 4.215944>, <0.075752, -0.265922, 3.841697>, <0.075752, -0.211346, 3.532377>, 
      <0.092284, -0.211345, 4.346232>, <0.092284, -0.272676, 4.215944>, <0.130252, -0.265922, 3.841697>, <0.130252, -0.211346, 3.532377>, 
      <0.240888, -0.211345, 4.346232>, <0.240888, -0.272676, 4.215944>, <0.202920, -0.224716, 3.846190>, <0.202920, -0.211346, 3.532377>, 
      <0.257420, -0.211345, 4.346232>, <0.257420, -0.272676, 4.215944>, <0.257420, -0.224716, 3.846190>, <0.257420, -0.211346, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.075752, -0.211345, 4.346232>, <0.060532, -0.211345, 4.346232>, <-0.076280, -0.211345, 4.346232>, <-0.091500, -0.211345, 4.346232>, 
      <0.075752, -0.272676, 4.215944>, <0.060532, -0.272676, 4.215944>, <-0.076280, -0.272676, 4.215944>, <-0.091500, -0.272676, 4.215944>, 
      <0.075752, -0.265922, 3.841697>, <0.025576, -0.265922, 3.841697>, <-0.041324, -0.224716, 3.846190>, <-0.091500, -0.224716, 3.846190>, 
      <0.075752, -0.211346, 3.532377>, <0.025576, -0.211346, 3.532377>, <-0.041324, -0.211346, 3.532377>, <-0.091500, -0.211346, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.075752, 0.171765, 4.346232>, <0.075752, 0.142894, 4.407563>, <0.075752, -0.182474, 4.407563>, <0.075752, -0.211345, 4.346232>, 
      <0.092284, 0.171765, 4.346232>, <0.092284, 0.142894, 4.407563>, <0.092284, -0.182474, 4.407563>, <0.092284, -0.211345, 4.346232>, 
      <0.240888, 0.171765, 4.346232>, <0.240888, 0.142894, 4.407563>, <0.240888, -0.182474, 4.407563>, <0.240888, -0.211345, 4.346232>, 
      <0.257420, 0.171765, 4.346232>, <0.257420, 0.142894, 4.407563>, <0.257420, -0.182474, 4.407563>, <0.257420, -0.211345, 4.346232>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.075752, 0.171765, 4.346232>, <0.060532, 0.171765, 4.346232>, <-0.076280, 0.171765, 4.346232>, <-0.091500, 0.171765, 4.346232>, 
      <0.075752, 0.142894, 4.407563>, <0.060532, 0.142894, 4.407563>, <-0.076280, 0.142894, 4.407563>, <-0.091500, 0.142894, 4.407563>, 
      <0.075752, -0.182474, 4.407563>, <0.060532, -0.182474, 4.407563>, <-0.076280, -0.182474, 4.407563>, <-0.091500, -0.182474, 4.407563>, 
      <0.075752, -0.211345, 4.346232>, <0.060532, -0.211345, 4.346232>, <-0.076280, -0.211345, 4.346232>, <-0.091500, -0.211345, 4.346232>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.075752, 0.171765, 4.346232>, <0.092284, 0.171765, 4.346232>, <0.240888, 0.171765, 4.346232>, <0.257420, 0.171765, 4.346232>, 
      <0.075752, 0.233096, 4.215944>, <0.092284, 0.233096, 4.215944>, <0.240888, 0.233096, 4.215944>, <0.257420, 0.233096, 4.215944>, 
      <0.075752, 0.229972, 3.841034>, <0.130252, 0.229972, 3.841034>, <0.202920, 0.186053, 3.846150>, <0.257420, 0.186053, 3.846150>, 
      <0.075752, 0.171765, 3.532377>, <0.130252, 0.171765, 3.532377>, <0.202920, 0.171765, 3.532377>, <0.257420, 0.171765, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.075752, 0.171765, 4.346232>, <0.075752, 0.233096, 4.215944>, <0.075752, 0.229972, 3.841034>, <0.075752, 0.171765, 3.532377>, 
      <0.060532, 0.171765, 4.346232>, <0.060532, 0.233096, 4.215944>, <0.025576, 0.229972, 3.841034>, <0.025576, 0.171765, 3.532377>, 
      <-0.076280, 0.171765, 4.346232>, <-0.076280, 0.233096, 4.215944>, <-0.041324, 0.186053, 3.846150>, <-0.041324, 0.171765, 3.532377>, 
      <-0.091500, 0.171765, 4.346232>, <-0.091500, 0.233096, 4.215944>, <-0.091500, 0.186053, 3.846150>, <-0.091500, 0.171765, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.273167, -0.026161, 3.296675>, <-0.273167, 0.033217, 3.367386>, <-0.273167, 0.149753, 3.415650>, <-0.273167, 0.171765, 3.532377>, 
      <-0.218667, -0.026161, 2.307613>, <-0.218667, 0.033217, 2.378324>, <-0.218667, 0.149753, 3.415650>, <-0.218667, 0.171765, 3.532377>, 
      <-0.180806, -0.026161, -0.000197>, <-0.180806, 0.069534, -0.000197>, <-0.146000, 0.109648, 2.168298>, <-0.146000, 0.171765, 3.532377>, 
      <-0.091500, -0.026161, -0.000197>, <-0.091500, 0.069534, -0.000197>, <-0.091500, 0.109648, 2.168298>, <-0.091500, 0.171765, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.273167, -0.211346, 3.532377>, <-0.273167, -0.191245, 3.418452>, <-0.273167, -0.081716, 3.367386>, <-0.273167, -0.026161, 3.296675>, 
      <-0.218667, -0.211346, 3.532377>, <-0.218667, -0.191245, 3.418452>, <-0.218667, -0.081716, 2.378324>, <-0.218667, -0.026161, 2.307613>, 
      <-0.146000, -0.211346, 3.532377>, <-0.146000, -0.153232, 2.168388>, <-0.180806, -0.121838, -0.000197>, <-0.180806, -0.026161, -0.000197>, 
      <-0.091500, -0.211346, 3.532377>, <-0.091500, -0.153232, 2.168388>, <-0.091500, -0.121838, -0.000197>, <-0.091500, -0.026161, -0.000197>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.273167, -0.211345, 4.346232>, <-0.273167, -0.272676, 4.215944>, <-0.273167, -0.265922, 3.841697>, <-0.273167, -0.211346, 3.532377>, 
      <-0.256635, -0.211345, 4.346232>, <-0.256635, -0.272676, 4.215944>, <-0.218667, -0.265922, 3.841697>, <-0.218667, -0.211346, 3.532377>, 
      <-0.108032, -0.211345, 4.346232>, <-0.108032, -0.272676, 4.215944>, <-0.146000, -0.224716, 3.846190>, <-0.146000, -0.211346, 3.532377>, 
      <-0.091500, -0.211345, 4.346232>, <-0.091500, -0.272676, 4.215944>, <-0.091500, -0.224716, 3.846190>, <-0.091500, -0.211346, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.273167, 0.171765, 4.346232>, <-0.273167, 0.142894, 4.407563>, <-0.273167, -0.182474, 4.407563>, <-0.273167, -0.211345, 4.346232>, 
      <-0.256635, 0.171765, 4.346232>, <-0.256635, 0.142894, 4.407563>, <-0.256635, -0.182474, 4.407563>, <-0.256635, -0.211345, 4.346232>, 
      <-0.108032, 0.171765, 4.346232>, <-0.108032, 0.142894, 4.407563>, <-0.108032, -0.182474, 4.407563>, <-0.108032, -0.211345, 4.346232>, 
      <-0.091500, 0.171765, 4.346232>, <-0.091500, 0.142894, 4.407563>, <-0.091500, -0.182474, 4.407563>, <-0.091500, -0.211345, 4.346232>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.273167, 0.171765, 4.346232>, <-0.256635, 0.171765, 4.346232>, <-0.108032, 0.171765, 4.346232>, <-0.091500, 0.171765, 4.346232>, 
      <-0.273167, 0.233096, 4.215944>, <-0.256635, 0.233096, 4.215944>, <-0.108032, 0.233096, 4.215944>, <-0.091500, 0.233096, 4.215944>, 
      <-0.273167, 0.229972, 3.841034>, <-0.218667, 0.229972, 3.841034>, <-0.146000, 0.186053, 3.846150>, <-0.091500, 0.186053, 3.846150>, 
      <-0.273167, 0.171765, 3.532377>, <-0.218667, 0.171765, 3.532377>, <-0.146000, 0.171765, 3.532377>, <-0.091500, 0.171765, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.454835, -0.026161, -0.000197>, <-0.454835, 0.069534, -0.000197>, <-0.454835, 0.109648, 2.168298>, <-0.454835, 0.171765, 3.532377>, 
      <-0.365529, -0.026161, -0.000197>, <-0.365529, 0.069534, -0.000197>, <-0.400335, 0.109648, 2.168298>, <-0.400335, 0.171765, 3.532377>, 
      <-0.327667, -0.026161, 2.307613>, <-0.327667, 0.033217, 2.378324>, <-0.327667, 0.149753, 3.415650>, <-0.327667, 0.171765, 3.532377>, 
      <-0.273167, -0.026161, 3.296675>, <-0.273167, 0.033217, 3.367386>, <-0.273167, 0.149753, 3.415650>, <-0.273167, 0.171765, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.454835, -0.211346, 3.532377>, <-0.454835, -0.153232, 2.168388>, <-0.454835, -0.121838, -0.000197>, <-0.454835, -0.026161, -0.000197>, 
      <-0.400335, -0.211346, 3.532377>, <-0.400335, -0.153232, 2.168388>, <-0.365529, -0.121838, -0.000197>, <-0.365529, -0.026161, -0.000197>, 
      <-0.327667, -0.211346, 3.532377>, <-0.327667, -0.191245, 3.418452>, <-0.327667, -0.081716, 2.378324>, <-0.327667, -0.026161, 2.307613>, 
      <-0.273167, -0.211346, 3.532377>, <-0.273167, -0.191245, 3.418452>, <-0.273167, -0.081716, 3.367386>, <-0.273167, -0.026161, 3.296675>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.454835, -0.211345, 4.346232>, <-0.454835, -0.272676, 4.215944>, <-0.454835, -0.224716, 3.846190>, <-0.454835, -0.211346, 3.532377>, 
      <-0.438303, -0.211345, 4.346232>, <-0.438303, -0.272676, 4.215944>, <-0.400335, -0.224716, 3.846190>, <-0.400335, -0.211346, 3.532377>, 
      <-0.289699, -0.211345, 4.346232>, <-0.289699, -0.272676, 4.215944>, <-0.327667, -0.265922, 3.841697>, <-0.327667, -0.211346, 3.532377>, 
      <-0.273167, -0.211345, 4.346232>, <-0.273167, -0.272676, 4.215944>, <-0.273167, -0.265922, 3.841697>, <-0.273167, -0.211346, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.454835, 0.171765, 4.346232>, <-0.454835, 0.142894, 4.407563>, <-0.454835, -0.182474, 4.407563>, <-0.454835, -0.211345, 4.346232>, 
      <-0.438303, 0.171765, 4.346232>, <-0.438303, 0.142894, 4.407563>, <-0.438303, -0.182474, 4.407563>, <-0.438303, -0.211345, 4.346232>, 
      <-0.289699, 0.171765, 4.346232>, <-0.289699, 0.142894, 4.407563>, <-0.289699, -0.182474, 4.407563>, <-0.289699, -0.211345, 4.346232>, 
      <-0.273167, 0.171765, 4.346232>, <-0.273167, 0.142894, 4.407563>, <-0.273167, -0.182474, 4.407563>, <-0.273167, -0.211345, 4.346232>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.454835, 0.171765, 4.346232>, <-0.438303, 0.171765, 4.346232>, <-0.289699, 0.171765, 4.346232>, <-0.273167, 0.171765, 4.346232>, 
      <-0.454835, 0.233096, 4.215944>, <-0.438303, 0.233096, 4.215944>, <-0.289699, 0.233096, 4.215944>, <-0.273167, 0.233096, 4.215944>, 
      <-0.454835, 0.186053, 3.846150>, <-0.400335, 0.186053, 3.846150>, <-0.327667, 0.229972, 3.841034>, <-0.273167, 0.229972, 3.841034>, 
      <-0.454835, 0.171765, 3.532377>, <-0.400335, 0.171765, 3.532377>, <-0.327667, 0.171765, 3.532377>, <-0.273167, 0.171765, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.636502, -0.026161, 3.296675>, <-0.636502, 0.033217, 3.367386>, <-0.636502, 0.149753, 3.415650>, <-0.636502, 0.171765, 3.532377>, 
      <-0.582002, -0.026161, 2.307613>, <-0.582002, 0.033217, 2.378324>, <-0.582002, 0.149753, 3.415650>, <-0.582002, 0.171765, 3.532377>, 
      <-0.544141, -0.026161, -0.000197>, <-0.544141, 0.069534, -0.000197>, <-0.509335, 0.109648, 2.168298>, <-0.509335, 0.171765, 3.532377>, 
      <-0.454835, -0.026161, -0.000197>, <-0.454835, 0.069534, -0.000197>, <-0.454835, 0.109648, 2.168298>, <-0.454835, 0.171765, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.636502, -0.211346, 3.532377>, <-0.636502, -0.191245, 3.418452>, <-0.636502, -0.081716, 3.367386>, <-0.636502, -0.026161, 3.296675>, 
      <-0.582002, -0.211346, 3.532377>, <-0.582002, -0.191245, 3.418452>, <-0.582002, -0.081716, 2.378324>, <-0.582002, -0.026161, 2.307613>, 
      <-0.509335, -0.211346, 3.532377>, <-0.509335, -0.153232, 2.168388>, <-0.544141, -0.121838, -0.000197>, <-0.544141, -0.026161, -0.000197>, 
      <-0.454835, -0.211346, 3.532377>, <-0.454835, -0.153232, 2.168388>, <-0.454835, -0.121838, -0.000197>, <-0.454835, -0.026161, -0.000197>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.636502, -0.211345, 4.346232>, <-0.636502, -0.272676, 4.215944>, <-0.636502, -0.265922, 3.841697>, <-0.636502, -0.211346, 3.532377>, 
      <-0.619970, -0.211345, 4.346232>, <-0.619970, -0.272676, 4.215944>, <-0.582002, -0.265922, 3.841697>, <-0.582002, -0.211346, 3.532377>, 
      <-0.471367, -0.211345, 4.346232>, <-0.471367, -0.272676, 4.215944>, <-0.509335, -0.224716, 3.846190>, <-0.509335, -0.211346, 3.532377>, 
      <-0.454835, -0.211345, 4.346232>, <-0.454835, -0.272676, 4.215944>, <-0.454835, -0.224716, 3.846190>, <-0.454835, -0.211346, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.636502, 0.171765, 4.346232>, <-0.636502, 0.142894, 4.407563>, <-0.636502, -0.182474, 4.407563>, <-0.636502, -0.211345, 4.346232>, 
      <-0.619970, 0.171765, 4.346232>, <-0.619970, 0.142894, 4.407563>, <-0.619970, -0.182474, 4.407563>, <-0.619970, -0.211345, 4.346232>, 
      <-0.471367, 0.171765, 4.346232>, <-0.471367, 0.142894, 4.407563>, <-0.471367, -0.182474, 4.407563>, <-0.471367, -0.211345, 4.346232>, 
      <-0.454835, 0.171765, 4.346232>, <-0.454835, 0.142894, 4.407563>, <-0.454835, -0.182474, 4.407563>, <-0.454835, -0.211345, 4.346232>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.636502, 0.171765, 4.346232>, <-0.619970, 0.171765, 4.346232>, <-0.471367, 0.171765, 4.346232>, <-0.454835, 0.171765, 4.346232>, 
      <-0.636502, 0.233096, 4.215944>, <-0.619970, 0.233096, 4.215944>, <-0.471367, 0.233096, 4.215944>, <-0.454835, 0.233096, 4.215944>, 
      <-0.636502, 0.229972, 3.841034>, <-0.582002, 0.229972, 3.841034>, <-0.509335, 0.186053, 3.846150>, <-0.454835, 0.186053, 3.846150>, 
      <-0.636502, 0.171765, 3.532377>, <-0.582002, 0.171765, 3.532377>, <-0.509335, 0.171765, 3.532377>, <-0.454835, 0.171765, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.818170, -0.026161, -0.000197>, <-0.818170, 0.069534, -0.000197>, <-0.818170, 0.109648, 2.168298>, <-0.818170, 0.171765, 3.532377>, 
      <-0.728864, -0.026161, -0.000197>, <-0.728864, 0.069534, -0.000197>, <-0.763670, 0.109648, 2.168298>, <-0.763670, 0.171765, 3.532377>, 
      <-0.691002, -0.026161, 2.307613>, <-0.691002, 0.033217, 2.378324>, <-0.691002, 0.149753, 3.415650>, <-0.691002, 0.171765, 3.532377>, 
      <-0.636502, -0.026161, 3.296675>, <-0.636502, 0.033217, 3.367386>, <-0.636502, 0.149753, 3.415650>, <-0.636502, 0.171765, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.818170, -0.211346, 3.532377>, <-0.818170, -0.153232, 2.168388>, <-0.818170, -0.121838, -0.000197>, <-0.818170, -0.026161, -0.000197>, 
      <-0.763670, -0.211346, 3.532377>, <-0.763670, -0.153232, 2.168388>, <-0.728864, -0.121838, -0.000197>, <-0.728864, -0.026161, -0.000197>, 
      <-0.691002, -0.211346, 3.532377>, <-0.691002, -0.191245, 3.418452>, <-0.691002, -0.081716, 2.378324>, <-0.691002, -0.026161, 2.307613>, 
      <-0.636502, -0.211346, 3.532377>, <-0.636502, -0.191245, 3.418452>, <-0.636502, -0.081716, 3.367386>, <-0.636502, -0.026161, 3.296675>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.818170, -0.211345, 4.346232>, <-0.818170, -0.272676, 4.215944>, <-0.818170, -0.224716, 3.846190>, <-0.818170, -0.211346, 3.532377>, 
      <-0.801638, -0.211345, 4.346232>, <-0.801638, -0.272676, 4.215944>, <-0.763670, -0.224716, 3.846190>, <-0.763670, -0.211346, 3.532377>, 
      <-0.653034, -0.211345, 4.346232>, <-0.653034, -0.272676, 4.215944>, <-0.691002, -0.265922, 3.841697>, <-0.691002, -0.211346, 3.532377>, 
      <-0.636502, -0.211345, 4.346232>, <-0.636502, -0.272676, 4.215944>, <-0.636502, -0.265922, 3.841697>, <-0.636502, -0.211346, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.818170, 0.171765, 4.346232>, <-0.818170, 0.142894, 4.407563>, <-0.818170, -0.182474, 4.407563>, <-0.818170, -0.211345, 4.346232>, 
      <-0.801638, 0.171765, 4.346232>, <-0.801638, 0.142894, 4.407563>, <-0.801638, -0.182474, 4.407563>, <-0.801638, -0.211345, 4.346232>, 
      <-0.653034, 0.171765, 4.346232>, <-0.653034, 0.142894, 4.407563>, <-0.653034, -0.182474, 4.407563>, <-0.653034, -0.211345, 4.346232>, 
      <-0.636502, 0.171765, 4.346232>, <-0.636502, 0.142894, 4.407563>, <-0.636502, -0.182474, 4.407563>, <-0.636502, -0.211345, 4.346232>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.818170, 0.171765, 4.346232>, <-0.801638, 0.171765, 4.346232>, <-0.653034, 0.171765, 4.346232>, <-0.636502, 0.171765, 4.346232>, 
      <-0.818170, 0.233096, 4.215944>, <-0.801638, 0.233096, 4.215944>, <-0.653034, 0.233096, 4.215944>, <-0.636502, 0.233096, 4.215944>, 
      <-0.818170, 0.186053, 3.846150>, <-0.763670, 0.186053, 3.846150>, <-0.691002, 0.229972, 3.841034>, <-0.636502, 0.229972, 3.841034>, 
      <-0.818170, 0.171765, 3.532377>, <-0.763670, 0.171765, 3.532377>, <-0.691002, 0.171765, 3.532377>, <-0.636502, 0.171765, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.999838, -0.026161, 3.296675>, <-0.999838, 0.033217, 3.367386>, <-0.999838, 0.149753, 3.415650>, <-0.999838, 0.171765, 3.532377>, 
      <-0.945338, -0.026161, 2.307613>, <-0.945338, 0.033217, 2.378324>, <-0.945338, 0.149753, 3.415650>, <-0.945338, 0.171765, 3.532377>, 
      <-0.907476, -0.026161, -0.000197>, <-0.907476, 0.069534, -0.000197>, <-0.872670, 0.109648, 2.168298>, <-0.872670, 0.171765, 3.532377>, 
      <-0.818170, -0.026161, -0.000197>, <-0.818170, 0.069534, -0.000197>, <-0.818170, 0.109648, 2.168298>, <-0.818170, 0.171765, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.999838, -0.211346, 3.532377>, <-0.999838, -0.191245, 3.418452>, <-0.999838, -0.081716, 3.367386>, <-0.999838, -0.026161, 3.296675>, 
      <-0.945338, -0.211346, 3.532377>, <-0.945338, -0.191245, 3.418452>, <-0.945338, -0.081716, 2.378324>, <-0.945338, -0.026161, 2.307613>, 
      <-0.872670, -0.211346, 3.532377>, <-0.872670, -0.153232, 2.168388>, <-0.907476, -0.121838, -0.000197>, <-0.907476, -0.026161, -0.000197>, 
      <-0.818170, -0.211346, 3.532377>, <-0.818170, -0.153232, 2.168388>, <-0.818170, -0.121838, -0.000197>, <-0.818170, -0.026161, -0.000197>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.999838, -0.211345, 4.346232>, <-0.999838, -0.272676, 4.215944>, <-0.999838, -0.265922, 3.841697>, <-0.999838, -0.211346, 3.532377>, 
      <-0.983306, -0.211345, 4.346232>, <-0.983306, -0.272676, 4.215944>, <-0.945338, -0.265922, 3.841697>, <-0.945338, -0.211346, 3.532377>, 
      <-0.834702, -0.211345, 4.346232>, <-0.834702, -0.272676, 4.215944>, <-0.872670, -0.224716, 3.846190>, <-0.872670, -0.211346, 3.532377>, 
      <-0.818170, -0.211345, 4.346232>, <-0.818170, -0.272676, 4.215944>, <-0.818170, -0.224716, 3.846190>, <-0.818170, -0.211346, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.999838, 0.171765, 4.346232>, <-0.999838, 0.142894, 4.407563>, <-0.999838, -0.182474, 4.407563>, <-0.999838, -0.211345, 4.346232>, 
      <-0.983306, 0.171765, 4.346232>, <-0.983306, 0.142894, 4.407563>, <-0.983306, -0.182474, 4.407563>, <-0.983306, -0.211345, 4.346232>, 
      <-0.834702, 0.171765, 4.346232>, <-0.834702, 0.142894, 4.407563>, <-0.834702, -0.182474, 4.407563>, <-0.834702, -0.211345, 4.346232>, 
      <-0.818170, 0.171765, 4.346232>, <-0.818170, 0.142894, 4.407563>, <-0.818170, -0.182474, 4.407563>, <-0.818170, -0.211345, 4.346232>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.999838, 0.171765, 4.346232>, <-0.983306, 0.171765, 4.346232>, <-0.834702, 0.171765, 4.346232>, <-0.818170, 0.171765, 4.346232>, 
      <-0.999838, 0.233096, 4.215944>, <-0.983306, 0.233096, 4.215944>, <-0.834702, 0.233096, 4.215944>, <-0.818170, 0.233096, 4.215944>, 
      <-0.999838, 0.229972, 3.841034>, <-0.945338, 0.229972, 3.841034>, <-0.872670, 0.186053, 3.846150>, <-0.818170, 0.186053, 3.846150>, 
      <-0.999838, 0.171765, 3.532377>, <-0.945338, 0.171765, 3.532377>, <-0.872670, 0.171765, 3.532377>, <-0.818170, 0.171765, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.181505, -0.026161, -0.000197>, <-1.181505, 0.069534, -0.000197>, <-1.181505, 0.109648, 2.168298>, <-1.181505, 0.171765, 3.532377>, 
      <-1.092199, -0.026161, -0.000197>, <-1.092199, 0.069534, -0.000197>, <-1.127005, 0.109648, 2.168298>, <-1.127005, 0.171765, 3.532377>, 
      <-1.054338, -0.026161, 2.307613>, <-1.054338, 0.033217, 2.378324>, <-1.054338, 0.149753, 3.415650>, <-1.054338, 0.171765, 3.532377>, 
      <-0.999838, -0.026161, 3.296675>, <-0.999838, 0.033217, 3.367386>, <-0.999838, 0.149753, 3.415650>, <-0.999838, 0.171765, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.181505, -0.211346, 3.532377>, <-1.181505, -0.153232, 2.168388>, <-1.181505, -0.121838, -0.000197>, <-1.181505, -0.026161, -0.000197>, 
      <-1.127005, -0.211346, 3.532377>, <-1.127005, -0.153232, 2.168388>, <-1.092199, -0.121838, -0.000197>, <-1.092199, -0.026161, -0.000197>, 
      <-1.054338, -0.211346, 3.532377>, <-1.054338, -0.191245, 3.418452>, <-1.054338, -0.081716, 2.378324>, <-1.054338, -0.026161, 2.307613>, 
      <-0.999838, -0.211346, 3.532377>, <-0.999838, -0.191245, 3.418452>, <-0.999838, -0.081716, 3.367386>, <-0.999838, -0.026161, 3.296675>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.181505, -0.211345, 4.346232>, <-1.181505, -0.272676, 4.215944>, <-1.181505, -0.224716, 3.846190>, <-1.181505, -0.211346, 3.532377>, 
      <-1.164973, -0.211345, 4.346232>, <-1.164973, -0.272676, 4.215944>, <-1.127005, -0.224716, 3.846190>, <-1.127005, -0.211346, 3.532377>, 
      <-1.016370, -0.211345, 4.346232>, <-1.016370, -0.272676, 4.215944>, <-1.054338, -0.265922, 3.841697>, <-1.054338, -0.211346, 3.532377>, 
      <-0.999838, -0.211345, 4.346232>, <-0.999838, -0.272676, 4.215944>, <-0.999838, -0.265922, 3.841697>, <-0.999838, -0.211346, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.181505, 0.171765, 4.346232>, <-1.181505, 0.142894, 4.407563>, <-1.181505, -0.182474, 4.407563>, <-1.181505, -0.211345, 4.346232>, 
      <-1.164973, 0.171765, 4.346232>, <-1.164973, 0.142894, 4.407563>, <-1.164973, -0.182474, 4.407563>, <-1.164973, -0.211345, 4.346232>, 
      <-1.016370, 0.171765, 4.346232>, <-1.016370, 0.142894, 4.407563>, <-1.016370, -0.182474, 4.407563>, <-1.016370, -0.211345, 4.346232>, 
      <-0.999838, 0.171765, 4.346232>, <-0.999838, 0.142894, 4.407563>, <-0.999838, -0.182474, 4.407563>, <-0.999838, -0.211345, 4.346232>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.181505, 0.171765, 4.346232>, <-1.164973, 0.171765, 4.346232>, <-1.016370, 0.171765, 4.346232>, <-0.999838, 0.171765, 4.346232>, 
      <-1.181505, 0.233096, 4.215944>, <-1.164973, 0.233096, 4.215944>, <-1.016370, 0.233096, 4.215944>, <-0.999838, 0.233096, 4.215944>, 
      <-1.181505, 0.186053, 3.846150>, <-1.127005, 0.186053, 3.846150>, <-1.054338, 0.229972, 3.841034>, <-0.999838, 0.229972, 3.841034>, 
      <-1.181505, 0.171765, 3.532377>, <-1.127005, 0.171765, 3.532377>, <-1.054338, 0.171765, 3.532377>, <-0.999838, 0.171765, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.363173, -0.026161, 3.296675>, <-1.363173, 0.033217, 3.367386>, <-1.363173, 0.149753, 3.415650>, <-1.363173, 0.171765, 3.532377>, 
      <-1.308672, -0.026161, 2.307613>, <-1.308672, 0.033217, 2.378324>, <-1.308672, 0.149753, 3.415650>, <-1.308672, 0.171765, 3.532377>, 
      <-1.270811, -0.026161, -0.000197>, <-1.270811, 0.069534, -0.000197>, <-1.236005, 0.109648, 2.168298>, <-1.236005, 0.171765, 3.532377>, 
      <-1.181505, -0.026161, -0.000197>, <-1.181505, 0.069534, -0.000197>, <-1.181505, 0.109648, 2.168298>, <-1.181505, 0.171765, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.363173, -0.211346, 3.532377>, <-1.363173, -0.191245, 3.418452>, <-1.363173, -0.081716, 3.367386>, <-1.363173, -0.026161, 3.296675>, 
      <-1.308672, -0.211346, 3.532377>, <-1.308672, -0.191245, 3.418452>, <-1.308672, -0.081716, 2.378324>, <-1.308672, -0.026161, 2.307613>, 
      <-1.236005, -0.211346, 3.532377>, <-1.236005, -0.153232, 2.168388>, <-1.270811, -0.121838, -0.000197>, <-1.270811, -0.026161, -0.000197>, 
      <-1.181505, -0.211346, 3.532377>, <-1.181505, -0.153232, 2.168388>, <-1.181505, -0.121838, -0.000197>, <-1.181505, -0.026161, -0.000197>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.363173, -0.211345, 4.346232>, <-1.363173, -0.272676, 4.215944>, <-1.363173, -0.265922, 3.841697>, <-1.363173, -0.211346, 3.532377>, 
      <-1.346641, -0.211345, 4.346232>, <-1.346641, -0.272676, 4.215944>, <-1.308672, -0.265922, 3.841697>, <-1.308672, -0.211346, 3.532377>, 
      <-1.198037, -0.211345, 4.346232>, <-1.198037, -0.272676, 4.215944>, <-1.236005, -0.224716, 3.846190>, <-1.236005, -0.211346, 3.532377>, 
      <-1.181505, -0.211345, 4.346232>, <-1.181505, -0.272676, 4.215944>, <-1.181505, -0.224716, 3.846190>, <-1.181505, -0.211346, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.363173, 0.171765, 4.346232>, <-1.363173, 0.142894, 4.407563>, <-1.363173, -0.182474, 4.407563>, <-1.363173, -0.211345, 4.346232>, 
      <-1.346641, 0.171765, 4.346232>, <-1.346641, 0.142894, 4.407563>, <-1.346641, -0.182474, 4.407563>, <-1.346641, -0.211345, 4.346232>, 
      <-1.198037, 0.171765, 4.346232>, <-1.198037, 0.142894, 4.407563>, <-1.198037, -0.182474, 4.407563>, <-1.198037, -0.211345, 4.346232>, 
      <-1.181505, 0.171765, 4.346232>, <-1.181505, 0.142894, 4.407563>, <-1.181505, -0.182474, 4.407563>, <-1.181505, -0.211345, 4.346232>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.363173, 0.171765, 4.346232>, <-1.346641, 0.171765, 4.346232>, <-1.198037, 0.171765, 4.346232>, <-1.181505, 0.171765, 4.346232>, 
      <-1.363173, 0.233096, 4.215944>, <-1.346641, 0.233096, 4.215944>, <-1.198037, 0.233096, 4.215944>, <-1.181505, 0.233096, 4.215944>, 
      <-1.363173, 0.229972, 3.841034>, <-1.308672, 0.229972, 3.841034>, <-1.236005, 0.186053, 3.846150>, <-1.181505, 0.186053, 3.846150>, 
      <-1.363173, 0.171765, 3.532377>, <-1.308672, 0.171765, 3.532377>, <-1.236005, 0.171765, 3.532377>, <-1.181505, 0.171765, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.544840, -0.026161, -0.000197>, <-1.544840, 0.069534, -0.000197>, <-1.544840, 0.109648, 2.168298>, <-1.544840, 0.171765, 3.532377>, 
      <-1.455534, -0.026161, -0.000197>, <-1.455534, 0.069534, -0.000197>, <-1.490340, 0.109648, 2.168298>, <-1.490340, 0.171765, 3.532377>, 
      <-1.417673, -0.026161, 2.307613>, <-1.417673, 0.033217, 2.378324>, <-1.417673, 0.149753, 3.415650>, <-1.417673, 0.171765, 3.532377>, 
      <-1.363173, -0.026161, 3.296675>, <-1.363173, 0.033217, 3.367386>, <-1.363173, 0.149753, 3.415650>, <-1.363173, 0.171765, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.544840, -0.211346, 3.532377>, <-1.544840, -0.153232, 2.168388>, <-1.544840, -0.121838, -0.000197>, <-1.544840, -0.026161, -0.000197>, 
      <-1.490340, -0.211346, 3.532377>, <-1.490340, -0.153232, 2.168388>, <-1.455534, -0.121838, -0.000197>, <-1.455534, -0.026161, -0.000197>, 
      <-1.417673, -0.211346, 3.532377>, <-1.417673, -0.191245, 3.418452>, <-1.417673, -0.081716, 2.378324>, <-1.417673, -0.026161, 2.307613>, 
      <-1.363173, -0.211346, 3.532377>, <-1.363173, -0.191245, 3.418452>, <-1.363173, -0.081716, 3.367386>, <-1.363173, -0.026161, 3.296675>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.544840, -0.211345, 4.346232>, <-1.544840, -0.272676, 4.215944>, <-1.544840, -0.224716, 3.846190>, <-1.544840, -0.211346, 3.532377>, 
      <-1.528308, -0.211345, 4.346232>, <-1.528308, -0.272676, 4.215944>, <-1.490340, -0.224716, 3.846190>, <-1.490340, -0.211346, 3.532377>, 
      <-1.379705, -0.211345, 4.346232>, <-1.379705, -0.272676, 4.215944>, <-1.417673, -0.265922, 3.841697>, <-1.417673, -0.211346, 3.532377>, 
      <-1.363173, -0.211345, 4.346232>, <-1.363173, -0.272676, 4.215944>, <-1.363173, -0.265922, 3.841697>, <-1.363173, -0.211346, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.544840, 0.171765, 4.346232>, <-1.544840, 0.142894, 4.407563>, <-1.544840, -0.182474, 4.407563>, <-1.544840, -0.211345, 4.346232>, 
      <-1.528308, 0.171765, 4.346232>, <-1.528308, 0.142894, 4.407563>, <-1.528308, -0.182474, 4.407563>, <-1.528308, -0.211345, 4.346232>, 
      <-1.379705, 0.171765, 4.346232>, <-1.379705, 0.142894, 4.407563>, <-1.379705, -0.182474, 4.407563>, <-1.379705, -0.211345, 4.346232>, 
      <-1.363173, 0.171765, 4.346232>, <-1.363173, 0.142894, 4.407563>, <-1.363173, -0.182474, 4.407563>, <-1.363173, -0.211345, 4.346232>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.544840, 0.171765, 4.346232>, <-1.528308, 0.171765, 4.346232>, <-1.379705, 0.171765, 4.346232>, <-1.363173, 0.171765, 4.346232>, 
      <-1.544840, 0.233096, 4.215944>, <-1.528308, 0.233096, 4.215944>, <-1.379705, 0.233096, 4.215944>, <-1.363173, 0.233096, 4.215944>, 
      <-1.544840, 0.186053, 3.846150>, <-1.490340, 0.186053, 3.846150>, <-1.417673, 0.229972, 3.841034>, <-1.363173, 0.229972, 3.841034>, 
      <-1.544840, 0.171765, 3.532377>, <-1.490340, 0.171765, 3.532377>, <-1.417673, 0.171765, 3.532377>, <-1.363173, 0.171765, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.726508, -0.026161, 3.296675>, <-1.726508, 0.033217, 3.367386>, <-1.726508, 0.149753, 3.415650>, <-1.726508, 0.171765, 3.532377>, 
      <-1.672008, -0.026161, 2.307613>, <-1.672008, 0.033217, 2.378324>, <-1.672008, 0.149753, 3.415650>, <-1.672008, 0.171765, 3.532377>, 
      <-1.634146, -0.026161, -0.000197>, <-1.634146, 0.069534, -0.000197>, <-1.599340, 0.109648, 2.168298>, <-1.599340, 0.171765, 3.532377>, 
      <-1.544840, -0.026161, -0.000197>, <-1.544840, 0.069534, -0.000197>, <-1.544840, 0.109648, 2.168298>, <-1.544840, 0.171765, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.726508, -0.211346, 3.532377>, <-1.726508, -0.191245, 3.418452>, <-1.726508, -0.081716, 3.367386>, <-1.726508, -0.026161, 3.296675>, 
      <-1.672008, -0.211346, 3.532377>, <-1.672008, -0.191245, 3.418452>, <-1.672008, -0.081716, 2.378324>, <-1.672008, -0.026161, 2.307613>, 
      <-1.599340, -0.211346, 3.532377>, <-1.599340, -0.153232, 2.168388>, <-1.634146, -0.121838, -0.000197>, <-1.634146, -0.026161, -0.000197>, 
      <-1.544840, -0.211346, 3.532377>, <-1.544840, -0.153232, 2.168388>, <-1.544840, -0.121838, -0.000197>, <-1.544840, -0.026161, -0.000197>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.726508, -0.211345, 4.346232>, <-1.726508, -0.272676, 4.215944>, <-1.726508, -0.265922, 3.841697>, <-1.726508, -0.211346, 3.532377>, 
      <-1.709976, -0.211345, 4.346232>, <-1.709976, -0.272676, 4.215944>, <-1.672008, -0.265922, 3.841697>, <-1.672008, -0.211346, 3.532377>, 
      <-1.561372, -0.211345, 4.346232>, <-1.561372, -0.272676, 4.215944>, <-1.599340, -0.224716, 3.846190>, <-1.599340, -0.211346, 3.532377>, 
      <-1.544840, -0.211345, 4.346232>, <-1.544840, -0.272676, 4.215944>, <-1.544840, -0.224716, 3.846190>, <-1.544840, -0.211346, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.726508, 0.171765, 4.346232>, <-1.726508, 0.142894, 4.407563>, <-1.726508, -0.182474, 4.407563>, <-1.726508, -0.211345, 4.346232>, 
      <-1.709976, 0.171765, 4.346232>, <-1.709976, 0.142894, 4.407563>, <-1.709976, -0.182474, 4.407563>, <-1.709976, -0.211345, 4.346232>, 
      <-1.561372, 0.171765, 4.346232>, <-1.561372, 0.142894, 4.407563>, <-1.561372, -0.182474, 4.407563>, <-1.561372, -0.211345, 4.346232>, 
      <-1.544840, 0.171765, 4.346232>, <-1.544840, 0.142894, 4.407563>, <-1.544840, -0.182474, 4.407563>, <-1.544840, -0.211345, 4.346232>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.726508, 0.171765, 4.346232>, <-1.709976, 0.171765, 4.346232>, <-1.561372, 0.171765, 4.346232>, <-1.544840, 0.171765, 4.346232>, 
      <-1.726508, 0.233096, 4.215944>, <-1.709976, 0.233096, 4.215944>, <-1.561372, 0.233096, 4.215944>, <-1.544840, 0.233096, 4.215944>, 
      <-1.726508, 0.229972, 3.841034>, <-1.672008, 0.229972, 3.841034>, <-1.599340, 0.186053, 3.846150>, <-1.544840, 0.186053, 3.846150>, 
      <-1.726508, 0.171765, 3.532377>, <-1.672008, 0.171765, 3.532377>, <-1.599340, 0.171765, 3.532377>, <-1.544840, 0.171765, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.908175, -0.026161, -0.000197>, <-1.908175, 0.069534, -0.000197>, <-1.908175, 0.109648, 2.168298>, <-1.908175, 0.171765, 3.532377>, 
      <-1.818869, -0.026161, -0.000197>, <-1.818869, 0.069534, -0.000197>, <-1.853675, 0.109648, 2.168298>, <-1.853675, 0.171765, 3.532377>, 
      <-1.781008, -0.026161, 2.307613>, <-1.781008, 0.033217, 2.378324>, <-1.781008, 0.149753, 3.415650>, <-1.781008, 0.171765, 3.532377>, 
      <-1.726508, -0.026161, 3.296675>, <-1.726508, 0.033217, 3.367386>, <-1.726508, 0.149753, 3.415650>, <-1.726508, 0.171765, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.908175, -0.211346, 3.532377>, <-1.908175, -0.153232, 2.168388>, <-1.908175, -0.121838, -0.000197>, <-1.908175, -0.026161, -0.000197>, 
      <-1.853675, -0.211346, 3.532377>, <-1.853675, -0.153232, 2.168388>, <-1.818869, -0.121838, -0.000197>, <-1.818869, -0.026161, -0.000197>, 
      <-1.781008, -0.211346, 3.532377>, <-1.781008, -0.191245, 3.418452>, <-1.781008, -0.081716, 2.378324>, <-1.781008, -0.026161, 2.307613>, 
      <-1.726508, -0.211346, 3.532377>, <-1.726508, -0.191245, 3.418452>, <-1.726508, -0.081716, 3.367386>, <-1.726508, -0.026161, 3.296675>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.908175, -0.211345, 4.346232>, <-1.908175, -0.272676, 4.215944>, <-1.908175, -0.224716, 3.846190>, <-1.908175, -0.211346, 3.532377>, 
      <-1.891643, -0.211345, 4.346232>, <-1.891643, -0.272676, 4.215944>, <-1.853675, -0.224716, 3.846190>, <-1.853675, -0.211346, 3.532377>, 
      <-1.743040, -0.211345, 4.346232>, <-1.743040, -0.272676, 4.215944>, <-1.781008, -0.265922, 3.841697>, <-1.781008, -0.211346, 3.532377>, 
      <-1.726508, -0.211345, 4.346232>, <-1.726508, -0.272676, 4.215944>, <-1.726508, -0.265922, 3.841697>, <-1.726508, -0.211346, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.908175, 0.171765, 4.346232>, <-1.908175, 0.142894, 4.407563>, <-1.908175, -0.182474, 4.407563>, <-1.908175, -0.211345, 4.346232>, 
      <-1.891643, 0.171765, 4.346232>, <-1.891643, 0.142894, 4.407563>, <-1.891643, -0.182474, 4.407563>, <-1.891643, -0.211345, 4.346232>, 
      <-1.743040, 0.171765, 4.346232>, <-1.743040, 0.142894, 4.407563>, <-1.743040, -0.182474, 4.407563>, <-1.743040, -0.211345, 4.346232>, 
      <-1.726508, 0.171765, 4.346232>, <-1.726508, 0.142894, 4.407563>, <-1.726508, -0.182474, 4.407563>, <-1.726508, -0.211345, 4.346232>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.908175, 0.171765, 4.346232>, <-1.891643, 0.171765, 4.346232>, <-1.743040, 0.171765, 4.346232>, <-1.726508, 0.171765, 4.346232>, 
      <-1.908175, 0.233096, 4.215944>, <-1.891643, 0.233096, 4.215944>, <-1.743040, 0.233096, 4.215944>, <-1.726508, 0.233096, 4.215944>, 
      <-1.908175, 0.186053, 3.846150>, <-1.853675, 0.186053, 3.846150>, <-1.781008, 0.229972, 3.841034>, <-1.726508, 0.229972, 3.841034>, 
      <-1.908175, 0.171765, 3.532377>, <-1.853675, 0.171765, 3.532377>, <-1.781008, 0.171765, 3.532377>, <-1.726508, 0.171765, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.089843, -0.026161, 3.296675>, <-2.089843, 0.033217, 3.367386>, <-2.089843, 0.149753, 3.415650>, <-2.089843, 0.171765, 3.532377>, 
      <-2.035343, -0.026161, 2.307613>, <-2.035343, 0.033217, 2.378324>, <-2.035343, 0.149753, 3.415650>, <-2.035343, 0.171765, 3.532377>, 
      <-1.997481, -0.026161, -0.000197>, <-1.997481, 0.069534, -0.000197>, <-1.962675, 0.109648, 2.168298>, <-1.962675, 0.171765, 3.532377>, 
      <-1.908175, -0.026161, -0.000197>, <-1.908175, 0.069534, -0.000197>, <-1.908175, 0.109648, 2.168298>, <-1.908175, 0.171765, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.089843, -0.211346, 3.532377>, <-2.089843, -0.191245, 3.418452>, <-2.089843, -0.081716, 3.367386>, <-2.089843, -0.026161, 3.296675>, 
      <-2.035343, -0.211346, 3.532377>, <-2.035343, -0.191245, 3.418452>, <-2.035343, -0.081716, 2.378324>, <-2.035343, -0.026161, 2.307613>, 
      <-1.962675, -0.211346, 3.532377>, <-1.962675, -0.153232, 2.168388>, <-1.997481, -0.121838, -0.000197>, <-1.997481, -0.026161, -0.000197>, 
      <-1.908175, -0.211346, 3.532377>, <-1.908175, -0.153232, 2.168388>, <-1.908175, -0.121838, -0.000197>, <-1.908175, -0.026161, -0.000197>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.089843, -0.211345, 4.346232>, <-2.089843, -0.272676, 4.215944>, <-2.089843, -0.265922, 3.841697>, <-2.089843, -0.211346, 3.532377>, 
      <-2.073311, -0.211345, 4.346232>, <-2.073311, -0.272676, 4.215944>, <-2.035343, -0.265922, 3.841697>, <-2.035343, -0.211346, 3.532377>, 
      <-1.924707, -0.211345, 4.346232>, <-1.924707, -0.272676, 4.215944>, <-1.962675, -0.224716, 3.846190>, <-1.962675, -0.211346, 3.532377>, 
      <-1.908175, -0.211345, 4.346232>, <-1.908175, -0.272676, 4.215944>, <-1.908175, -0.224716, 3.846190>, <-1.908175, -0.211346, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.089843, 0.171765, 4.346232>, <-2.089843, 0.142894, 4.407563>, <-2.089843, -0.182474, 4.407563>, <-2.089843, -0.211345, 4.346232>, 
      <-2.073311, 0.171765, 4.346232>, <-2.073311, 0.142894, 4.407563>, <-2.073311, -0.182474, 4.407563>, <-2.073311, -0.211345, 4.346232>, 
      <-1.924707, 0.171765, 4.346232>, <-1.924707, 0.142894, 4.407563>, <-1.924707, -0.182474, 4.407563>, <-1.924707, -0.211345, 4.346232>, 
      <-1.908175, 0.171765, 4.346232>, <-1.908175, 0.142894, 4.407563>, <-1.908175, -0.182474, 4.407563>, <-1.908175, -0.211345, 4.346232>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.089843, 0.171765, 4.346232>, <-2.073311, 0.171765, 4.346232>, <-1.924707, 0.171765, 4.346232>, <-1.908175, 0.171765, 4.346232>, 
      <-2.089843, 0.233096, 4.215944>, <-2.073311, 0.233096, 4.215944>, <-1.924707, 0.233096, 4.215944>, <-1.908175, 0.233096, 4.215944>, 
      <-2.089843, 0.229972, 3.841034>, <-2.035343, 0.229972, 3.841034>, <-1.962675, 0.186053, 3.846150>, <-1.908175, 0.186053, 3.846150>, 
      <-2.089843, 0.171765, 3.532377>, <-2.035343, 0.171765, 3.532377>, <-1.962675, 0.171765, 3.532377>, <-1.908175, 0.171765, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.271511, -0.026161, -0.000197>, <-2.271511, 0.069534, -0.000197>, <-2.271511, 0.109648, 2.168298>, <-2.271511, 0.171765, 3.532377>, 
      <-2.182205, -0.026161, -0.000197>, <-2.182205, 0.069534, -0.000197>, <-2.217011, 0.109648, 2.168298>, <-2.217011, 0.171765, 3.532377>, 
      <-2.144343, -0.026161, 2.307613>, <-2.144343, 0.033217, 2.378324>, <-2.144343, 0.149753, 3.415650>, <-2.144343, 0.171765, 3.532377>, 
      <-2.089843, -0.026161, 3.296675>, <-2.089843, 0.033217, 3.367386>, <-2.089843, 0.149753, 3.415650>, <-2.089843, 0.171765, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.271511, -0.211346, 3.532377>, <-2.271511, -0.153232, 2.168388>, <-2.271511, -0.121838, -0.000197>, <-2.271511, -0.026161, -0.000197>, 
      <-2.217011, -0.211346, 3.532377>, <-2.217011, -0.153232, 2.168388>, <-2.182205, -0.121838, -0.000197>, <-2.182205, -0.026161, -0.000197>, 
      <-2.144343, -0.211346, 3.532377>, <-2.144343, -0.191245, 3.418452>, <-2.144343, -0.081716, 2.378324>, <-2.144343, -0.026161, 2.307613>, 
      <-2.089843, -0.211346, 3.532377>, <-2.089843, -0.191245, 3.418452>, <-2.089843, -0.081716, 3.367386>, <-2.089843, -0.026161, 3.296675>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.271511, -0.211345, 4.346232>, <-2.271511, -0.272676, 4.215944>, <-2.271511, -0.224716, 3.846190>, <-2.271511, -0.211346, 3.532377>, 
      <-2.254979, -0.211345, 4.346232>, <-2.254979, -0.272676, 4.215944>, <-2.217011, -0.224716, 3.846190>, <-2.217011, -0.211346, 3.532377>, 
      <-2.106375, -0.211345, 4.346232>, <-2.106375, -0.272676, 4.215944>, <-2.144343, -0.265922, 3.841697>, <-2.144343, -0.211346, 3.532377>, 
      <-2.089843, -0.211345, 4.346232>, <-2.089843, -0.272676, 4.215944>, <-2.089843, -0.265922, 3.841697>, <-2.089843, -0.211346, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.271511, 0.171765, 4.346232>, <-2.271511, 0.142894, 4.407563>, <-2.271511, -0.182474, 4.407563>, <-2.271511, -0.211345, 4.346232>, 
      <-2.254979, 0.171765, 4.346232>, <-2.254979, 0.142894, 4.407563>, <-2.254979, -0.182474, 4.407563>, <-2.254979, -0.211345, 4.346232>, 
      <-2.106375, 0.171765, 4.346232>, <-2.106375, 0.142894, 4.407563>, <-2.106375, -0.182474, 4.407563>, <-2.106375, -0.211345, 4.346232>, 
      <-2.089843, 0.171765, 4.346232>, <-2.089843, 0.142894, 4.407563>, <-2.089843, -0.182474, 4.407563>, <-2.089843, -0.211345, 4.346232>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.271511, 0.171765, 4.346232>, <-2.254979, 0.171765, 4.346232>, <-2.106375, 0.171765, 4.346232>, <-2.089843, 0.171765, 4.346232>, 
      <-2.271511, 0.233096, 4.215944>, <-2.254979, 0.233096, 4.215944>, <-2.106375, 0.233096, 4.215944>, <-2.089843, 0.233096, 4.215944>, 
      <-2.271511, 0.186053, 3.846150>, <-2.217011, 0.186053, 3.846150>, <-2.144343, 0.229972, 3.841034>, <-2.089843, 0.229972, 3.841034>, 
      <-2.271511, 0.171765, 3.532377>, <-2.217011, 0.171765, 3.532377>, <-2.144343, 0.171765, 3.532377>, <-2.089843, 0.171765, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.453178, -0.026161, 3.296675>, <-2.453178, 0.033217, 3.367386>, <-2.453178, 0.149753, 3.415650>, <-2.453178, 0.171765, 3.532377>, 
      <-2.398678, -0.026161, 2.307613>, <-2.398678, 0.033217, 2.378324>, <-2.398678, 0.149753, 3.415650>, <-2.398678, 0.171765, 3.532377>, 
      <-2.360817, -0.026161, -0.000197>, <-2.360817, 0.069534, -0.000197>, <-2.326011, 0.109648, 2.168298>, <-2.326011, 0.171765, 3.532377>, 
      <-2.271511, -0.026161, -0.000197>, <-2.271511, 0.069534, -0.000197>, <-2.271511, 0.109648, 2.168298>, <-2.271511, 0.171765, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.453178, -0.211346, 3.532377>, <-2.453178, -0.191245, 3.418452>, <-2.453178, -0.081716, 3.367386>, <-2.453178, -0.026161, 3.296675>, 
      <-2.398678, -0.211346, 3.532377>, <-2.398678, -0.191245, 3.418452>, <-2.398678, -0.081716, 2.378324>, <-2.398678, -0.026161, 2.307613>, 
      <-2.326011, -0.211346, 3.532377>, <-2.326011, -0.153232, 2.168388>, <-2.360817, -0.121838, -0.000197>, <-2.360817, -0.026161, -0.000197>, 
      <-2.271511, -0.211346, 3.532377>, <-2.271511, -0.153232, 2.168388>, <-2.271511, -0.121838, -0.000197>, <-2.271511, -0.026161, -0.000197>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.453178, -0.211345, 4.346232>, <-2.453178, -0.272676, 4.215944>, <-2.453178, -0.265922, 3.841697>, <-2.453178, -0.211346, 3.532377>, 
      <-2.436646, -0.211345, 4.346232>, <-2.436646, -0.272676, 4.215944>, <-2.398678, -0.265922, 3.841697>, <-2.398678, -0.211346, 3.532377>, 
      <-2.288043, -0.211345, 4.346232>, <-2.288043, -0.272676, 4.215944>, <-2.326011, -0.224716, 3.846190>, <-2.326011, -0.211346, 3.532377>, 
      <-2.271511, -0.211345, 4.346232>, <-2.271511, -0.272676, 4.215944>, <-2.271511, -0.224716, 3.846190>, <-2.271511, -0.211346, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.453178, 0.171765, 4.346232>, <-2.453178, 0.142894, 4.407563>, <-2.453178, -0.182474, 4.407563>, <-2.453178, -0.211345, 4.346232>, 
      <-2.436646, 0.171765, 4.346232>, <-2.436646, 0.142894, 4.407563>, <-2.436646, -0.182474, 4.407563>, <-2.436646, -0.211345, 4.346232>, 
      <-2.288043, 0.171765, 4.346232>, <-2.288043, 0.142894, 4.407563>, <-2.288043, -0.182474, 4.407563>, <-2.288043, -0.211345, 4.346232>, 
      <-2.271511, 0.171765, 4.346232>, <-2.271511, 0.142894, 4.407563>, <-2.271511, -0.182474, 4.407563>, <-2.271511, -0.211345, 4.346232>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.453178, 0.171765, 4.346232>, <-2.436646, 0.171765, 4.346232>, <-2.288043, 0.171765, 4.346232>, <-2.271511, 0.171765, 4.346232>, 
      <-2.453178, 0.233096, 4.215944>, <-2.436646, 0.233096, 4.215944>, <-2.288043, 0.233096, 4.215944>, <-2.271511, 0.233096, 4.215944>, 
      <-2.453178, 0.229972, 3.841034>, <-2.398678, 0.229972, 3.841034>, <-2.326011, 0.186053, 3.846150>, <-2.271511, 0.186053, 3.846150>, 
      <-2.453178, 0.171765, 3.532377>, <-2.398678, 0.171765, 3.532377>, <-2.326011, 0.171765, 3.532377>, <-2.271511, 0.171765, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.634846, -0.026161, -0.000197>, <-2.634846, 0.069534, -0.000197>, <-2.634846, 0.109648, 2.168298>, <-2.634846, 0.171765, 3.532377>, 
      <-2.545540, -0.026161, -0.000197>, <-2.545540, 0.069534, -0.000197>, <-2.580346, 0.109648, 2.168298>, <-2.580346, 0.171765, 3.532377>, 
      <-2.507678, -0.026161, 2.307613>, <-2.507678, 0.033217, 2.378324>, <-2.507678, 0.149753, 3.415650>, <-2.507678, 0.171765, 3.532377>, 
      <-2.453178, -0.026161, 3.296675>, <-2.453178, 0.033217, 3.367386>, <-2.453178, 0.149753, 3.415650>, <-2.453178, 0.171765, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.634846, -0.211346, 3.532377>, <-2.634846, -0.153232, 2.168388>, <-2.634846, -0.121838, -0.000197>, <-2.634846, -0.026161, -0.000197>, 
      <-2.580346, -0.211346, 3.532377>, <-2.580346, -0.153232, 2.168388>, <-2.545540, -0.121838, -0.000197>, <-2.545540, -0.026161, -0.000197>, 
      <-2.507678, -0.211346, 3.532377>, <-2.507678, -0.191245, 3.418452>, <-2.507678, -0.081716, 2.378324>, <-2.507678, -0.026161, 2.307613>, 
      <-2.453178, -0.211346, 3.532377>, <-2.453178, -0.191245, 3.418452>, <-2.453178, -0.081716, 3.367386>, <-2.453178, -0.026161, 3.296675>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.634846, -0.211345, 4.346232>, <-2.634846, -0.272676, 4.215944>, <-2.634846, -0.224716, 3.846190>, <-2.634846, -0.211346, 3.532377>, 
      <-2.618314, -0.211345, 4.346232>, <-2.618314, -0.272676, 4.215944>, <-2.580346, -0.224716, 3.846190>, <-2.580346, -0.211346, 3.532377>, 
      <-2.469710, -0.211345, 4.346232>, <-2.469710, -0.272676, 4.215944>, <-2.507678, -0.265922, 3.841697>, <-2.507678, -0.211346, 3.532377>, 
      <-2.453178, -0.211345, 4.346232>, <-2.453178, -0.272676, 4.215944>, <-2.453178, -0.265922, 3.841697>, <-2.453178, -0.211346, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.634846, 0.171765, 4.346232>, <-2.634846, 0.142894, 4.407563>, <-2.634846, -0.182474, 4.407563>, <-2.634846, -0.211345, 4.346232>, 
      <-2.618314, 0.171765, 4.346232>, <-2.618314, 0.142894, 4.407563>, <-2.618314, -0.182474, 4.407563>, <-2.618314, -0.211345, 4.346232>, 
      <-2.469710, 0.171765, 4.346232>, <-2.469710, 0.142894, 4.407563>, <-2.469710, -0.182474, 4.407563>, <-2.469710, -0.211345, 4.346232>, 
      <-2.453178, 0.171765, 4.346232>, <-2.453178, 0.142894, 4.407563>, <-2.453178, -0.182474, 4.407563>, <-2.453178, -0.211345, 4.346232>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.634846, 0.171765, 4.346232>, <-2.618314, 0.171765, 4.346232>, <-2.469710, 0.171765, 4.346232>, <-2.453178, 0.171765, 4.346232>, 
      <-2.634846, 0.233096, 4.215944>, <-2.618314, 0.233096, 4.215944>, <-2.469710, 0.233096, 4.215944>, <-2.453178, 0.233096, 4.215944>, 
      <-2.634846, 0.186053, 3.846150>, <-2.580346, 0.186053, 3.846150>, <-2.507678, 0.229972, 3.841034>, <-2.453178, 0.229972, 3.841034>, 
      <-2.634846, 0.171765, 3.532377>, <-2.580346, 0.171765, 3.532377>, <-2.507678, 0.171765, 3.532377>, <-2.453178, 0.171765, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.816514, -0.026161, 3.296675>, <-2.816514, 0.033217, 3.367386>, <-2.816514, 0.149753, 3.415650>, <-2.816514, 0.171765, 3.532377>, 
      <-2.762014, -0.026161, 2.307613>, <-2.762014, 0.033217, 2.378324>, <-2.762014, 0.149753, 3.415650>, <-2.762014, 0.171765, 3.532377>, 
      <-2.724152, -0.026161, -0.000197>, <-2.724152, 0.069534, -0.000197>, <-2.689346, 0.109648, 2.168298>, <-2.689346, 0.171765, 3.532377>, 
      <-2.634846, -0.026161, -0.000197>, <-2.634846, 0.069534, -0.000197>, <-2.634846, 0.109648, 2.168298>, <-2.634846, 0.171765, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.816514, -0.211346, 3.532377>, <-2.816514, -0.191245, 3.418452>, <-2.816514, -0.081716, 3.367386>, <-2.816514, -0.026161, 3.296675>, 
      <-2.762014, -0.211346, 3.532377>, <-2.762014, -0.191245, 3.418452>, <-2.762014, -0.081716, 2.378324>, <-2.762014, -0.026161, 2.307613>, 
      <-2.689346, -0.211346, 3.532377>, <-2.689346, -0.153232, 2.168388>, <-2.724152, -0.121838, -0.000197>, <-2.724152, -0.026161, -0.000197>, 
      <-2.634846, -0.211346, 3.532377>, <-2.634846, -0.153232, 2.168388>, <-2.634846, -0.121838, -0.000197>, <-2.634846, -0.026161, -0.000197>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.816514, -0.211345, 4.346232>, <-2.816514, -0.272676, 4.215944>, <-2.816514, -0.265922, 3.841697>, <-2.816514, -0.211346, 3.532377>, 
      <-2.799982, -0.211345, 4.346232>, <-2.799982, -0.272676, 4.215944>, <-2.762014, -0.265922, 3.841697>, <-2.762014, -0.211346, 3.532377>, 
      <-2.651378, -0.211345, 4.346232>, <-2.651378, -0.272676, 4.215944>, <-2.689346, -0.224716, 3.846190>, <-2.689346, -0.211346, 3.532377>, 
      <-2.634846, -0.211345, 4.346232>, <-2.634846, -0.272676, 4.215944>, <-2.634846, -0.224716, 3.846190>, <-2.634846, -0.211346, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.816514, 0.171765, 4.346232>, <-2.816514, 0.142894, 4.407563>, <-2.816514, -0.182474, 4.407563>, <-2.816514, -0.211345, 4.346232>, 
      <-2.799982, 0.171765, 4.346232>, <-2.799982, 0.142894, 4.407563>, <-2.799982, -0.182474, 4.407563>, <-2.799982, -0.211345, 4.346232>, 
      <-2.651378, 0.171765, 4.346232>, <-2.651378, 0.142894, 4.407563>, <-2.651378, -0.182474, 4.407563>, <-2.651378, -0.211345, 4.346232>, 
      <-2.634846, 0.171765, 4.346232>, <-2.634846, 0.142894, 4.407563>, <-2.634846, -0.182474, 4.407563>, <-2.634846, -0.211345, 4.346232>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.816514, 0.171765, 4.346232>, <-2.799982, 0.171765, 4.346232>, <-2.651378, 0.171765, 4.346232>, <-2.634846, 0.171765, 4.346232>, 
      <-2.816514, 0.233096, 4.215944>, <-2.799982, 0.233096, 4.215944>, <-2.651378, 0.233096, 4.215944>, <-2.634846, 0.233096, 4.215944>, 
      <-2.816514, 0.229972, 3.841034>, <-2.762014, 0.229972, 3.841034>, <-2.689346, 0.186053, 3.846150>, <-2.634846, 0.186053, 3.846150>, 
      <-2.816514, 0.171765, 3.532377>, <-2.762014, 0.171765, 3.532377>, <-2.689346, 0.171765, 3.532377>, <-2.634846, 0.171765, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.998181, -0.026161, -0.000197>, <-2.998181, 0.069534, -0.000197>, <-2.998181, 0.109648, 2.168298>, <-2.998181, 0.171765, 3.532377>, 
      <-2.908875, -0.026161, -0.000197>, <-2.908875, 0.069534, -0.000197>, <-2.943681, 0.109648, 2.168298>, <-2.943681, 0.171765, 3.532377>, 
      <-2.871014, -0.026161, 2.307613>, <-2.871014, 0.033217, 2.378324>, <-2.871014, 0.149753, 3.415650>, <-2.871014, 0.171765, 3.532377>, 
      <-2.816514, -0.026161, 3.296675>, <-2.816514, 0.033217, 3.367386>, <-2.816514, 0.149753, 3.415650>, <-2.816514, 0.171765, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.998181, -0.211346, 3.532377>, <-2.998181, -0.153232, 2.168388>, <-2.998181, -0.121838, -0.000197>, <-2.998181, -0.026161, -0.000197>, 
      <-2.943681, -0.211346, 3.532377>, <-2.943681, -0.153232, 2.168388>, <-2.908875, -0.121838, -0.000197>, <-2.908875, -0.026161, -0.000197>, 
      <-2.871014, -0.211346, 3.532377>, <-2.871014, -0.191245, 3.418452>, <-2.871014, -0.081716, 2.378324>, <-2.871014, -0.026161, 2.307613>, 
      <-2.816514, -0.211346, 3.532377>, <-2.816514, -0.191245, 3.418452>, <-2.816514, -0.081716, 3.367386>, <-2.816514, -0.026161, 3.296675>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.998181, -0.211345, 4.346232>, <-2.998181, -0.272676, 4.215944>, <-2.998181, -0.224716, 3.846190>, <-2.998181, -0.211346, 3.532377>, 
      <-2.981649, -0.211345, 4.346232>, <-2.981649, -0.272676, 4.215944>, <-2.943681, -0.224716, 3.846190>, <-2.943681, -0.211346, 3.532377>, 
      <-2.833046, -0.211345, 4.346232>, <-2.833046, -0.272676, 4.215944>, <-2.871014, -0.265922, 3.841697>, <-2.871014, -0.211346, 3.532377>, 
      <-2.816514, -0.211345, 4.346232>, <-2.816514, -0.272676, 4.215944>, <-2.816514, -0.265922, 3.841697>, <-2.816514, -0.211346, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.998181, 0.171765, 4.346232>, <-2.998181, 0.142894, 4.407563>, <-2.998181, -0.182474, 4.407563>, <-2.998181, -0.211345, 4.346232>, 
      <-2.981649, 0.171765, 4.346232>, <-2.981649, 0.142894, 4.407563>, <-2.981649, -0.182474, 4.407563>, <-2.981649, -0.211345, 4.346232>, 
      <-2.833046, 0.171765, 4.346232>, <-2.833046, 0.142894, 4.407563>, <-2.833046, -0.182474, 4.407563>, <-2.833046, -0.211345, 4.346232>, 
      <-2.816514, 0.171765, 4.346232>, <-2.816514, 0.142894, 4.407563>, <-2.816514, -0.182474, 4.407563>, <-2.816514, -0.211345, 4.346232>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.998181, 0.171765, 4.346232>, <-2.981649, 0.171765, 4.346232>, <-2.833046, 0.171765, 4.346232>, <-2.816514, 0.171765, 4.346232>, 
      <-2.998181, 0.233096, 4.215944>, <-2.981649, 0.233096, 4.215944>, <-2.833046, 0.233096, 4.215944>, <-2.816514, 0.233096, 4.215944>, 
      <-2.998181, 0.186053, 3.846150>, <-2.943681, 0.186053, 3.846150>, <-2.871014, 0.229972, 3.841034>, <-2.816514, 0.229972, 3.841034>, 
      <-2.998181, 0.171765, 3.532377>, <-2.943681, 0.171765, 3.532377>, <-2.871014, 0.171765, 3.532377>, <-2.816514, 0.171765, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.179849, -0.026161, 3.296675>, <-3.179849, 0.033217, 3.367386>, <-3.179849, 0.149753, 3.415650>, <-3.179849, 0.171765, 3.532377>, 
      <-3.125349, -0.026161, 2.307613>, <-3.125349, 0.033217, 2.378324>, <-3.125349, 0.149753, 3.415650>, <-3.125349, 0.171765, 3.532377>, 
      <-3.087487, -0.026161, -0.000197>, <-3.087487, 0.069534, -0.000197>, <-3.052681, 0.109648, 2.168298>, <-3.052681, 0.171765, 3.532377>, 
      <-2.998181, -0.026161, -0.000197>, <-2.998181, 0.069534, -0.000197>, <-2.998181, 0.109648, 2.168298>, <-2.998181, 0.171765, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.179849, -0.211346, 3.532377>, <-3.179849, -0.191245, 3.418452>, <-3.179849, -0.081716, 3.367386>, <-3.179849, -0.026161, 3.296675>, 
      <-3.125349, -0.211346, 3.532377>, <-3.125349, -0.191245, 3.418452>, <-3.125349, -0.081716, 2.378324>, <-3.125349, -0.026161, 2.307613>, 
      <-3.052681, -0.211346, 3.532377>, <-3.052681, -0.153232, 2.168388>, <-3.087487, -0.121838, -0.000197>, <-3.087487, -0.026161, -0.000197>, 
      <-2.998181, -0.211346, 3.532377>, <-2.998181, -0.153232, 2.168388>, <-2.998181, -0.121838, -0.000197>, <-2.998181, -0.026161, -0.000197>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.179849, -0.211345, 4.346232>, <-3.179849, -0.272676, 4.215944>, <-3.179849, -0.265922, 3.841697>, <-3.179849, -0.211346, 3.532377>, 
      <-3.163317, -0.211345, 4.346232>, <-3.163317, -0.272676, 4.215944>, <-3.125349, -0.265922, 3.841697>, <-3.125349, -0.211346, 3.532377>, 
      <-3.014713, -0.211345, 4.346232>, <-3.014713, -0.272676, 4.215944>, <-3.052681, -0.224716, 3.846190>, <-3.052681, -0.211346, 3.532377>, 
      <-2.998181, -0.211345, 4.346232>, <-2.998181, -0.272676, 4.215944>, <-2.998181, -0.224716, 3.846190>, <-2.998181, -0.211346, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.179849, 0.171765, 4.346232>, <-3.179849, 0.142894, 4.407563>, <-3.179849, -0.182474, 4.407563>, <-3.179849, -0.211345, 4.346232>, 
      <-3.163317, 0.171765, 4.346232>, <-3.163317, 0.142894, 4.407563>, <-3.163317, -0.182474, 4.407563>, <-3.163317, -0.211345, 4.346232>, 
      <-3.014713, 0.171765, 4.346232>, <-3.014713, 0.142894, 4.407563>, <-3.014713, -0.182474, 4.407563>, <-3.014713, -0.211345, 4.346232>, 
      <-2.998181, 0.171765, 4.346232>, <-2.998181, 0.142894, 4.407563>, <-2.998181, -0.182474, 4.407563>, <-2.998181, -0.211345, 4.346232>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.179849, 0.171765, 4.346232>, <-3.163317, 0.171765, 4.346232>, <-3.014713, 0.171765, 4.346232>, <-2.998181, 0.171765, 4.346232>, 
      <-3.179849, 0.233096, 4.215944>, <-3.163317, 0.233096, 4.215944>, <-3.014713, 0.233096, 4.215944>, <-2.998181, 0.233096, 4.215944>, 
      <-3.179849, 0.229972, 3.841034>, <-3.125349, 0.229972, 3.841034>, <-3.052681, 0.186053, 3.846150>, <-2.998181, 0.186053, 3.846150>, 
      <-3.179849, 0.171765, 3.532377>, <-3.125349, 0.171765, 3.532377>, <-3.052681, 0.171765, 3.532377>, <-2.998181, 0.171765, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.361516, -0.026161, -0.000197>, <-3.361516, 0.069534, -0.000197>, <-3.361516, 0.109648, 2.168298>, <-3.361516, 0.171765, 3.532377>, 
      <-3.272210, -0.026161, -0.000197>, <-3.272210, 0.069534, -0.000197>, <-3.307016, 0.109648, 2.168298>, <-3.307016, 0.171765, 3.532377>, 
      <-3.234349, -0.026161, 2.307613>, <-3.234349, 0.033217, 2.378324>, <-3.234349, 0.149753, 3.415650>, <-3.234349, 0.171765, 3.532377>, 
      <-3.179849, -0.026161, 3.296675>, <-3.179849, 0.033217, 3.367386>, <-3.179849, 0.149753, 3.415650>, <-3.179849, 0.171765, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.361516, -0.211346, 3.532377>, <-3.361516, -0.153232, 2.168388>, <-3.361516, -0.121838, -0.000197>, <-3.361516, -0.026161, -0.000197>, 
      <-3.307016, -0.211346, 3.532377>, <-3.307016, -0.153232, 2.168388>, <-3.272210, -0.121838, -0.000197>, <-3.272210, -0.026161, -0.000197>, 
      <-3.234349, -0.211346, 3.532377>, <-3.234349, -0.191245, 3.418452>, <-3.234349, -0.081716, 2.378324>, <-3.234349, -0.026161, 2.307613>, 
      <-3.179849, -0.211346, 3.532377>, <-3.179849, -0.191245, 3.418452>, <-3.179849, -0.081716, 3.367386>, <-3.179849, -0.026161, 3.296675>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.361516, -0.211345, 4.346232>, <-3.361516, -0.272676, 4.215944>, <-3.361516, -0.224716, 3.846190>, <-3.361516, -0.211346, 3.532377>, 
      <-3.344984, -0.211345, 4.346232>, <-3.344984, -0.272676, 4.215944>, <-3.307016, -0.224716, 3.846190>, <-3.307016, -0.211346, 3.532377>, 
      <-3.196381, -0.211345, 4.346232>, <-3.196381, -0.272676, 4.215944>, <-3.234349, -0.265922, 3.841697>, <-3.234349, -0.211346, 3.532377>, 
      <-3.179849, -0.211345, 4.346232>, <-3.179849, -0.272676, 4.215944>, <-3.179849, -0.265922, 3.841697>, <-3.179849, -0.211346, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.361516, 0.171765, 4.346232>, <-3.361516, 0.142894, 4.407563>, <-3.361516, -0.182474, 4.407563>, <-3.361516, -0.211345, 4.346232>, 
      <-3.344984, 0.171765, 4.346232>, <-3.344984, 0.142894, 4.407563>, <-3.344984, -0.182474, 4.407563>, <-3.344984, -0.211345, 4.346232>, 
      <-3.196381, 0.171765, 4.346232>, <-3.196381, 0.142894, 4.407563>, <-3.196381, -0.182474, 4.407563>, <-3.196381, -0.211345, 4.346232>, 
      <-3.179849, 0.171765, 4.346232>, <-3.179849, 0.142894, 4.407563>, <-3.179849, -0.182474, 4.407563>, <-3.179849, -0.211345, 4.346232>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.361516, 0.171765, 4.346232>, <-3.344984, 0.171765, 4.346232>, <-3.196381, 0.171765, 4.346232>, <-3.179849, 0.171765, 4.346232>, 
      <-3.361516, 0.233096, 4.215944>, <-3.344984, 0.233096, 4.215944>, <-3.196381, 0.233096, 4.215944>, <-3.179849, 0.233096, 4.215944>, 
      <-3.361516, 0.186053, 3.846150>, <-3.307016, 0.186053, 3.846150>, <-3.234349, 0.229972, 3.841034>, <-3.179849, 0.229972, 3.841034>, 
      <-3.361516, 0.171765, 3.532377>, <-3.307016, 0.171765, 3.532377>, <-3.234349, 0.171765, 3.532377>, <-3.179849, 0.171765, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.546974, -0.026161, 3.296675>, <-3.546974, 0.033217, 3.367386>, <-3.546974, 0.149753, 3.415650>, <-3.546974, 0.171765, 3.532377>, 
      <-3.491336, -0.026161, 2.307613>, <-3.491336, 0.033217, 2.378324>, <-3.491336, 0.149753, 3.415650>, <-3.491336, 0.171765, 3.532377>, 
      <-3.450827, -0.026161, -0.000197>, <-3.450827, 0.069534, -0.000197>, <-3.417153, 0.109648, 2.168298>, <-3.417153, 0.171765, 3.532377>, 
      <-3.361516, -0.026161, -0.000197>, <-3.361516, 0.069534, -0.000197>, <-3.361516, 0.109648, 2.168298>, <-3.361516, 0.171765, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.546974, -0.026161, 3.296675>, <-3.601474, -0.026161, 2.307613>, <-3.639336, -0.026161, -0.000197>, <-3.728642, -0.026161, -0.000197>, 
      <-3.546974, 0.033217, 3.367386>, <-3.601474, 0.033217, 2.378324>, <-3.639336, 0.069534, -0.000197>, <-3.728642, 0.069534, -0.000197>, 
      <-3.546974, 0.149753, 3.415650>, <-3.601474, 0.149753, 3.415650>, <-3.674142, 0.109648, 2.168298>, <-3.728642, 0.109648, 2.168298>, 
      <-3.546974, 0.171765, 3.532377>, <-3.601474, 0.171765, 3.532377>, <-3.674142, 0.171765, 3.532377>, <-3.728642, 0.171765, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.546974, -0.211346, 3.532377>, <-3.546974, -0.191245, 3.418452>, <-3.546974, -0.081716, 3.367386>, <-3.546974, -0.026161, 3.296675>, 
      <-3.491336, -0.211346, 3.532377>, <-3.491336, -0.191245, 3.418452>, <-3.491336, -0.081716, 2.378324>, <-3.491336, -0.026161, 2.307613>, 
      <-3.417153, -0.211346, 3.532377>, <-3.417153, -0.153232, 2.168388>, <-3.450827, -0.121838, -0.000197>, <-3.450827, -0.026161, -0.000197>, 
      <-3.361516, -0.211346, 3.532377>, <-3.361516, -0.153232, 2.168388>, <-3.361516, -0.121838, -0.000197>, <-3.361516, -0.026161, -0.000197>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.546974, -0.211346, 3.532377>, <-3.601474, -0.211346, 3.532377>, <-3.674142, -0.211346, 3.532377>, <-3.728642, -0.211346, 3.532377>, 
      <-3.546974, -0.191245, 3.418452>, <-3.601474, -0.191245, 3.418452>, <-3.674142, -0.153232, 2.168388>, <-3.728642, -0.153232, 2.168388>, 
      <-3.546974, -0.081716, 3.367386>, <-3.601474, -0.081716, 2.378324>, <-3.639336, -0.121838, -0.000197>, <-3.728642, -0.121838, -0.000197>, 
      <-3.546974, -0.026161, 3.296675>, <-3.601474, -0.026161, 2.307613>, <-3.639336, -0.026161, -0.000197>, <-3.728642, -0.026161, -0.000197>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.546974, -0.211345, 4.346232>, <-3.546974, -0.272676, 4.215944>, <-3.546974, -0.265922, 3.841697>, <-3.546974, -0.211346, 3.532377>, 
      <-3.530097, -0.211345, 4.346232>, <-3.530097, -0.272676, 4.215944>, <-3.491336, -0.265922, 3.841697>, <-3.491336, -0.211346, 3.532377>, 
      <-3.378393, -0.211345, 4.346232>, <-3.378393, -0.272676, 4.215944>, <-3.417153, -0.224716, 3.846190>, <-3.417153, -0.211346, 3.532377>, 
      <-3.361516, -0.211345, 4.346232>, <-3.361516, -0.272676, 4.215944>, <-3.361516, -0.224716, 3.846190>, <-3.361516, -0.211346, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.546974, -0.211345, 4.346232>, <-3.563506, -0.211345, 4.346232>, <-3.712110, -0.211345, 4.346232>, <-3.728642, -0.211345, 4.346232>, 
      <-3.546974, -0.272676, 4.215944>, <-3.563506, -0.272676, 4.215944>, <-3.712110, -0.272676, 4.215944>, <-3.728642, -0.272676, 4.215944>, 
      <-3.546974, -0.265922, 3.841697>, <-3.601474, -0.265922, 3.841697>, <-3.674142, -0.224716, 3.846190>, <-3.728642, -0.224716, 3.846190>, 
      <-3.546974, -0.211346, 3.532377>, <-3.601474, -0.211346, 3.532377>, <-3.674142, -0.211346, 3.532377>, <-3.728642, -0.211346, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.546974, 0.171765, 4.346232>, <-3.546974, 0.142894, 4.407563>, <-3.546974, -0.182474, 4.407563>, <-3.546974, -0.211345, 4.346232>, 
      <-3.530097, 0.171765, 4.346232>, <-3.530097, 0.142894, 4.407563>, <-3.530097, -0.182474, 4.407563>, <-3.530097, -0.211345, 4.346232>, 
      <-3.378393, 0.171765, 4.346232>, <-3.378393, 0.142894, 4.407563>, <-3.378393, -0.182474, 4.407563>, <-3.378393, -0.211345, 4.346232>, 
      <-3.361516, 0.171765, 4.346232>, <-3.361516, 0.142894, 4.407563>, <-3.361516, -0.182474, 4.407563>, <-3.361516, -0.211345, 4.346232>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.546974, 0.171765, 4.346232>, <-3.563506, 0.171765, 4.346232>, <-3.712110, 0.171765, 4.346232>, <-3.728642, 0.171765, 4.346232>, 
      <-3.546974, 0.142894, 4.407563>, <-3.563506, 0.142894, 4.407563>, <-3.712110, 0.142894, 4.407563>, <-3.728642, 0.142894, 4.407563>, 
      <-3.546974, -0.182474, 4.407563>, <-3.563506, -0.182474, 4.407563>, <-3.712110, -0.182474, 4.407563>, <-3.728642, -0.182474, 4.407563>, 
      <-3.546974, -0.211345, 4.346232>, <-3.563506, -0.211345, 4.346232>, <-3.712110, -0.211345, 4.346232>, <-3.728642, -0.211345, 4.346232>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.546974, 0.171765, 4.346232>, <-3.530097, 0.171765, 4.346232>, <-3.378393, 0.171765, 4.346232>, <-3.361516, 0.171765, 4.346232>, 
      <-3.546974, 0.233096, 4.215944>, <-3.530097, 0.233096, 4.215944>, <-3.378393, 0.233096, 4.215944>, <-3.361516, 0.233096, 4.215944>, 
      <-3.546974, 0.229972, 3.841034>, <-3.491336, 0.229972, 3.841034>, <-3.417153, 0.186053, 3.846150>, <-3.361516, 0.186053, 3.846150>, 
      <-3.546974, 0.171765, 3.532377>, <-3.491336, 0.171765, 3.532377>, <-3.417153, 0.171765, 3.532377>, <-3.361516, 0.171765, 3.532377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.546974, 0.171765, 4.346232>, <-3.546974, 0.233096, 4.215944>, <-3.546974, 0.229972, 3.841034>, <-3.546974, 0.171765, 3.532377>, 
      <-3.563506, 0.171765, 4.346232>, <-3.563506, 0.233096, 4.215944>, <-3.601474, 0.229972, 3.841034>, <-3.601474, 0.171765, 3.532377>, 
      <-3.712110, 0.171765, 4.346232>, <-3.712110, 0.233096, 4.215944>, <-3.674142, 0.186053, 3.846150>, <-3.674142, 0.171765, 3.532377>, 
      <-3.728642, 0.171765, 4.346232>, <-3.728642, 0.233096, 4.215944>, <-3.728642, 0.186053, 3.846150>, <-3.728642, 0.171765, 3.532377>
    }
  }
  material {
    peine_txt
  }
  scale <0.9, 0.8, 0.8>
  rotate -19.89539*z
  translate  <4.434313, 0.306776, 0.383657>
}
#declare cpelo = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-8.118152, -1.075347, 0.211930>, <-8.118152, -0.775659, 0.383163>, <-8.118152, -0.347818, 0.627924>, <-8.118152, -0.002661, 0.627924>, 
      <-7.033376, -1.317052, 0.184546>, <-7.033376, -1.017364, 0.355779>, <-7.007972, -0.345060, 0.679515>, <-7.007972, 0.000097, 0.679515>, 
      <-5.523930, -1.215891, 0.185530>, <-5.523930, -0.882623, 0.358553>, <-5.524652, -0.368228, 0.653541>, <-5.524652, 0.007278, 0.653541>, 
      <-4.413582, -1.167520, 0.211930>, <-4.413582, -0.834252, 0.384953>, <-4.413582, -0.362489, 0.627924>, <-4.413582, 0.013017, 0.627924>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-9.653429, 0.000000, 0.344205>, <-9.653429, 0.000000, 0.356270>, <-9.653429, 0.000000, 0.372357>, <-9.653429, 0.000000, 0.384422>, 
      <-9.653429, -0.563724, 0.344205>, <-9.653429, -0.563724, 0.356270>, <-9.192846, -0.000798, 0.445408>, <-9.192846, -0.000798, 0.457473>, 
      <-8.668216, -0.952784, 0.225816>, <-8.668216, -0.653096, 0.397049>, <-8.583988, -0.348976, 0.606276>, <-8.583988, -0.003818, 0.606276>, 
      <-8.118152, -1.075347, 0.211930>, <-8.118152, -0.775659, 0.383163>, <-8.118152, -0.347818, 0.627924>, <-8.118152, -0.002661, 0.627924>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-8.118152, 1.075347, 0.211930>, <-8.118152, 0.774001, 0.383260>, <-8.118152, 0.343985, 0.627924>, <-8.118152, -0.002661, 0.627924>, 
      <-8.668216, 0.952784, 0.225816>, <-8.668216, 0.651438, 0.397146>, <-8.583988, 0.342828, 0.606276>, <-8.583988, -0.003818, 0.606276>, 
      <-9.653429, 0.563724, 0.344205>, <-9.653429, 0.563724, 0.356270>, <-9.192846, -0.000798, 0.445408>, <-9.192846, -0.000798, 0.457473>, 
      <-9.653429, 0.000000, 0.344205>, <-9.653429, 0.000000, 0.356270>, <-9.653429, 0.000000, 0.372357>, <-9.653429, 0.000000, 0.384422>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-8.118152, 1.075347, 0.211930>, <-8.118152, 0.774001, 0.383260>, <-8.118152, 0.343985, 0.627924>, <-8.118152, -0.002661, 0.627924>, 
      <-8.668216, 0.952784, 0.225816>, <-8.668216, 0.651438, 0.397146>, <-8.118152, -0.001172, 0.627924>, <-8.118152, -0.347818, 0.627924>, 
      <-9.653429, 0.563724, 0.344205>, <-9.653429, 0.000000, 0.344205>, <-8.668216, -0.653096, 0.397049>, <-8.118152, -0.775659, 0.383163>, 
      <-9.653429, 0.000000, 0.344205>, <-9.653429, -0.563724, 0.344205>, <-8.668216, -0.952784, 0.225816>, <-8.118152, -1.075347, 0.211930>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-4.413582, 1.167520, 0.211930>, <-4.413582, 0.842352, 0.384555>, <-4.413582, 0.381166, 0.627924>, <-4.413582, 0.013017, 0.627924>, 
      <-5.523902, 1.216387, 0.185260>, <-5.523902, 0.891218, 0.357884>, <-5.524652, 0.375427, 0.653541>, <-5.524652, 0.007278, 0.653541>, 
      <-7.033376, 1.317052, 0.184546>, <-7.033376, 1.015706, 0.355876>, <-7.007972, 0.346743, 0.679515>, <-7.007972, 0.000097, 0.679515>, 
      <-8.118152, 1.075347, 0.211930>, <-8.118152, 0.774001, 0.383260>, <-8.118152, 0.343985, 0.627924>, <-8.118152, -0.002661, 0.627924>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.498441, 0.828017, 0.346917>, <-2.484957, 0.602969, 0.442913>, <-2.458961, 0.271503, 0.497249>, <-2.450425, 0.026614, 0.497249>, 
      <-3.078151, 0.900288, 0.318182>, <-3.064667, 0.675240, 0.414178>, <-3.048488, 0.279154, 0.525723>, <-3.039953, 0.034265, 0.525723>, 
      <-3.829412, 1.141810, 0.225962>, <-3.829412, 0.816642, 0.398586>, <-3.823482, 0.384214, 0.614319>, <-3.823482, 0.016065, 0.614319>, 
      <-4.413582, 1.167520, 0.211930>, <-4.413582, 0.842352, 0.384555>, <-4.413582, 0.381166, 0.627924>, <-4.413582, 0.013017, 0.627924>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.690312, 0.828017, 0.346917>, <-1.690312, 0.587612, 0.443319>, <-1.690312, 0.236690, 0.496390>, <-1.690312, -0.022324, 0.496390>, 
      <-1.925621, 0.772052, 0.330356>, <-1.925621, 0.531647, 0.426759>, <-1.918515, 0.238970, 0.507932>, <-1.918515, -0.020044, 0.507932>, 
      <-2.258155, 0.798061, 0.358828>, <-2.244671, 0.573013, 0.454824>, <-2.230740, 0.268542, 0.486226>, <-2.222204, 0.023652, 0.486226>, 
      <-2.498441, 0.828017, 0.346917>, <-2.484957, 0.602969, 0.442913>, <-2.458961, 0.271503, 0.497249>, <-2.450425, 0.026614, 0.497249>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.155037, 1.385363, 0.511843>, <-0.155037, 0.971100, 0.553533>, <-0.156269, 0.420031, 0.381156>, <-0.155037, 0.003677, 0.381156>, 
      <-0.584139, 1.144592, 0.490808>, <-0.584139, 0.730329, 0.532498>, <-0.617934, 0.417240, 0.396968>, <-0.616702, 0.000886, 0.396968>, 
      <-1.212311, 0.941703, 0.380558>, <-1.212311, 0.701298, 0.476961>, <-1.228981, 0.232080, 0.473058>, <-1.228981, -0.026934, 0.473058>, 
      <-1.690312, 0.828017, 0.346917>, <-1.690312, 0.587612, 0.443319>, <-1.690312, 0.236690, 0.496390>, <-1.690312, -0.022324, 0.496390>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.674116, 2.715809, 0.511843>, <1.674116, 1.900595, 0.553551>, <1.674116, 0.814295, 0.381156>, <1.674116, -0.001986, 0.381156>, 
      <1.034397, 2.489558, 0.511843>, <1.034397, 1.674344, 0.553551>, <1.125369, 0.815826, 0.381156>, <1.125369, -0.000454, 0.381156>, 
      <0.436183, 1.717099, 0.540825>, <0.436183, 1.302835, 0.582515>, <0.392148, 0.423346, 0.362372>, <0.393380, 0.006992, 0.362372>, 
      <-0.155037, 1.385363, 0.511843>, <-0.155037, 0.971100, 0.553533>, <-0.156269, 0.420031, 0.381156>, <-0.155037, 0.003677, 0.381156>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <5.372428, 3.340272, 0.511843>, <5.372428, 2.334766, 0.553553>, <5.372428, 0.994620, 0.381156>, <5.372428, -0.011751, 0.381156>, 
      <4.249669, 3.414334, 0.511843>, <4.249669, 2.408828, 0.553553>, <4.262931, 0.993555, 0.381156>, <4.262931, -0.012816, 0.381156>, 
      <2.734924, 3.090987, 0.511843>, <2.734924, 2.275773, 0.553551>, <2.783609, 0.811198, 0.381156>, <2.783609, -0.005083, 0.381156>, 
      <1.674116, 2.715809, 0.511843>, <1.674116, 1.900595, 0.553551>, <1.674116, 0.814295, 0.381156>, <1.674116, -0.001986, 0.381156>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <9.070738, 2.227898, 0.511843>, <9.070738, 1.561214, 0.553548>, <9.070738, 0.673099, 0.381156>, <9.070738, 0.005112, 0.381156>, 
      <8.114374, 2.881889, 0.511843>, <8.114374, 2.215205, 0.553548>, <7.962609, 0.670434, 0.326001>, <7.962609, 0.002446, 0.326001>, 
      <6.528509, 3.264012, 0.511843>, <6.528509, 2.258506, 0.553553>, <6.481932, 0.995685, 0.381156>, <6.481932, -0.010686, 0.381156>, 
      <5.372428, 3.340272, 0.511843>, <5.372428, 2.334766, 0.553553>, <5.372428, 0.994620, 0.381156>, <5.372428, -0.011751, 0.381156>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <10.257080, 0.000000, 0.511843>, <10.257080, 0.000000, 0.545574>, <10.257080, 0.000000, 0.590548>, <10.257080, 0.000000, 0.624278>, 
      <10.257080, 0.757221, 0.511843>, <10.257080, 0.757221, 0.545574>, <9.901178, 0.001534, 0.517611>, <9.901178, 0.001534, 0.551341>, 
      <9.695790, 1.800469, 0.511843>, <9.695790, 1.133785, 0.553548>, <9.433591, 0.673972, 0.399216>, <9.433591, 0.005985, 0.399216>, 
      <9.070738, 2.227898, 0.511843>, <9.070738, 1.561214, 0.553548>, <9.070738, 0.673099, 0.381156>, <9.070738, 0.005112, 0.381156>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <9.070738, -2.227898, 0.511843>, <9.070738, -1.558146, 0.553548>, <9.070738, -0.665937, 0.381156>, <9.070738, 0.005112, 0.381156>, 
      <9.695790, -1.800469, 0.511843>, <9.695790, -1.130717, 0.553548>, <9.433591, -0.665064, 0.399216>, <9.433591, 0.005985, 0.399216>, 
      <10.257080, -0.757221, 0.511843>, <10.257080, -0.757221, 0.545574>, <9.901178, 0.001534, 0.517611>, <9.901178, 0.001534, 0.551341>, 
      <10.257080, 0.000000, 0.511843>, <10.257080, 0.000000, 0.545574>, <10.257080, 0.000000, 0.590548>, <10.257080, 0.000000, 0.624278>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <9.070738, -2.227898, 0.511843>, <9.070738, -1.558146, 0.553548>, <9.070738, -0.665937, 0.381156>, <9.070738, 0.005112, 0.381156>, 
      <9.695790, -1.800469, 0.511843>, <9.695790, -1.130717, 0.553548>, <9.070738, 0.002050, 0.381156>, <9.070738, 0.673099, 0.381156>, 
      <10.257080, -0.757221, 0.511843>, <10.257080, 0.000000, 0.511843>, <9.695790, 1.133785, 0.553548>, <9.070738, 1.561214, 0.553548>, 
      <10.257080, 0.000000, 0.511843>, <10.257080, 0.757221, 0.511843>, <9.695790, 1.800469, 0.511843>, <9.070738, 2.227898, 0.511843>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <5.372428, -3.340272, 0.511843>, <5.372428, -2.341817, 0.553553>, <5.372428, -1.011077, 0.381156>, <5.372428, -0.011751, 0.381156>, 
      <6.528509, -3.264012, 0.511843>, <6.528509, -2.265557, 0.553553>, <6.481932, -1.010012, 0.381156>, <6.481932, -0.010686, 0.381156>, 
      <8.114374, -2.881889, 0.511843>, <8.114374, -2.212137, 0.553548>, <7.962609, -0.668603, 0.326001>, <7.962609, 0.002446, 0.326001>, 
      <9.070738, -2.227898, 0.511843>, <9.070738, -1.558146, 0.553548>, <9.070738, -0.665937, 0.381156>, <9.070738, 0.005112, 0.381156>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.674116, -2.715809, 0.511843>, <1.674116, -1.901786, 0.553551>, <1.674116, -0.817076, 0.381156>, <1.674116, -0.001986, 0.381156>, 
      <2.727641, -3.110977, 0.511843>, <2.727641, -2.296954, 0.553551>, <2.783609, -0.820173, 0.381156>, <2.783609, -0.005083, 0.381156>, 
      <4.249669, -3.414334, 0.511843>, <4.249669, -2.415879, 0.553553>, <4.262931, -1.012142, 0.381156>, <4.262931, -0.012816, 0.381156>, 
      <5.372428, -3.340272, 0.511843>, <5.372428, -2.341817, 0.553553>, <5.372428, -1.011077, 0.381156>, <5.372428, -0.011751, 0.381156>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.147181, -1.269915, 0.511843>, <-0.149536, -0.888100, 0.553529>, <-0.153901, -0.380412, 0.381156>, <-0.155037, 0.003677, 0.381156>, 
      <0.460669, -1.610982, 0.541640>, <0.458314, -1.229167, 0.583326>, <0.394516, -0.377097, 0.362372>, <0.393380, 0.006992, 0.362372>, 
      <1.020919, -2.470800, 0.511843>, <1.020919, -1.656778, 0.553551>, <1.125369, -0.815545, 0.381156>, <1.125369, -0.000454, 0.381156>, 
      <1.674116, -2.715809, 0.511843>, <1.674116, -1.901786, 0.553551>, <1.674116, -0.817076, 0.381156>, <1.674116, -0.001986, 0.381156>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.690312, -0.828017, 0.346917>, <-1.216153, -0.919374, 0.381013>, <-0.568962, -1.033252, 0.491167>, <-0.147181, -1.269915, 0.511843>, 
      <-1.690312, -0.601625, 0.442731>, <-1.216153, -0.692982, 0.476827>, <-0.571317, -0.651437, 0.532853>, <-0.149536, -0.888100, 0.553529>, 
      <-1.690312, -0.268156, 0.496390>, <-1.228981, -0.272766, 0.473058>, <-0.615565, -0.383203, 0.396968>, <-0.153901, -0.380412, 0.381156>, 
      <-1.690312, -0.022324, 0.496390>, <-1.228981, -0.026934, 0.473058>, <-0.616702, 0.000886, 0.396968>, <-0.155037, 0.003677, 0.381156>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.440718, -0.828017, 0.346917>, <-2.217595, -0.800201, 0.357977>, <-1.910819, -0.785532, 0.331061>, <-1.690312, -0.828017, 0.346917>, 
      <-2.443463, -0.586308, 0.443599>, <-2.220340, -0.558492, 0.454658>, <-1.910819, -0.559140, 0.426874>, <-1.690312, -0.601625, 0.442731>, 
      <-2.441356, -0.233570, 0.497249>, <-2.213135, -0.236532, 0.486226>, <-1.918515, -0.265876, 0.507932>, <-1.690312, -0.268156, 0.496390>, 
      <-2.450425, 0.026614, 0.497249>, <-2.222204, 0.023652, 0.486226>, <-1.918515, -0.020044, 0.507932>, <-1.690312, -0.022324, 0.496390>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.440718, -0.828017, 0.346917>, <-2.443463, -0.586308, 0.443599>, <-2.441356, -0.233570, 0.497249>, <-2.450425, 0.026614, 0.497249>, 
      <-3.037296, -0.902391, 0.317346>, <-3.040041, -0.660682, 0.414027>, <-3.030884, -0.225919, 0.525723>, <-3.039953, 0.034265, 0.525723>, 
      <-3.812399, -1.141330, 0.226224>, <-3.812399, -0.808062, 0.399247>, <-3.823482, -0.359441, 0.614319>, <-3.823482, 0.016065, 0.614319>, 
      <-4.413582, -1.167520, 0.211930>, <-4.413582, -0.834252, 0.384953>, <-4.413582, -0.362489, 0.627924>, <-4.413582, 0.013017, 0.627924>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-8.118152, -1.075347, 0.015024>, <-8.118152, -1.075347, 0.074096>, <-8.118152, -1.126637, 0.182625>, <-8.118152, -1.075347, 0.211930>, 
      <-7.034064, -1.316899, -0.033119>, <-7.034064, -1.316899, 0.025952>, <-7.033376, -1.368342, 0.155240>, <-7.033376, -1.317052, 0.184546>, 
      <-5.523905, -1.215890, -0.012430>, <-5.523905, -1.215890, 0.046642>, <-5.523930, -1.268318, 0.158312>, <-5.523930, -1.215891, 0.185530>, 
      <-4.413582, -1.167520, 0.015024>, <-4.413582, -1.167520, 0.074096>, <-4.413582, -1.219947, 0.184711>, <-4.413582, -1.167520, 0.211930>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-9.653429, 0.000000, 0.247721>, <-9.653429, 0.000000, 0.276666>, <-9.653429, 0.000000, 0.315260>, <-9.653429, 0.000000, 0.344205>, 
      <-9.653429, -0.566642, 0.247721>, <-9.653429, -0.566642, 0.276666>, <-9.653429, -0.563724, 0.315260>, <-9.653429, -0.563724, 0.344205>, 
      <-8.670713, -0.952228, 0.039563>, <-8.670713, -0.952228, 0.098635>, <-8.668216, -1.004074, 0.196510>, <-8.668216, -0.952784, 0.225816>, 
      <-8.118152, -1.075347, 0.015024>, <-8.118152, -1.075347, 0.074096>, <-8.118152, -1.126637, 0.182625>, <-8.118152, -1.075347, 0.211930>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-8.118152, 1.075347, 0.015024>, <-8.118152, 1.075347, 0.074096>, <-8.118152, 1.126699, 0.182734>, <-8.118152, 1.075347, 0.211930>, 
      <-8.670713, 0.952228, 0.039563>, <-8.670713, 0.952228, 0.098635>, <-8.668216, 1.004136, 0.196620>, <-8.668216, 0.952784, 0.225816>, 
      <-9.653429, 0.566642, 0.247721>, <-9.653429, 0.566642, 0.276666>, <-9.653429, 0.563724, 0.315260>, <-9.653429, 0.563724, 0.344205>, 
      <-9.653429, 0.000000, 0.247721>, <-9.653429, 0.000000, 0.276666>, <-9.653429, 0.000000, 0.315260>, <-9.653429, 0.000000, 0.344205>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-4.413582, 1.167520, 0.015024>, <-4.413582, 1.167520, 0.074096>, <-4.413582, 1.219695, 0.184231>, <-4.413582, 1.167520, 0.211930>, 
      <-5.523876, 1.216385, -0.012711>, <-5.523876, 1.216385, 0.046361>, <-5.523902, 1.268562, 0.157561>, <-5.523902, 1.216387, 0.185260>, 
      <-7.034064, 1.316899, -0.033119>, <-7.034064, 1.316899, 0.025952>, <-7.033376, 1.368404, 0.155350>, <-7.033376, 1.317052, 0.184546>, 
      <-8.118152, 1.075347, 0.015024>, <-8.118152, 1.075347, 0.074096>, <-8.118152, 1.126699, 0.182734>, <-8.118152, 1.075347, 0.211930>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.498441, 0.828017, 0.155403>, <-2.498441, 0.828017, 0.212857>, <-2.501602, 0.880784, 0.324409>, <-2.498441, 0.828017, 0.346917>, 
      <-3.078207, 0.900295, 0.125517>, <-3.078207, 0.900295, 0.182972>, <-3.081312, 0.953055, 0.295674>, <-3.078151, 0.900288, 0.318182>, 
      <-3.829312, 1.141806, 0.029619>, <-3.829312, 1.141806, 0.088691>, <-3.829412, 1.193985, 0.198263>, <-3.829412, 1.141810, 0.225962>, 
      <-4.413582, 1.167520, 0.015024>, <-4.413582, 1.167520, 0.074096>, <-4.413582, 1.219695, 0.184231>, <-4.413582, 1.167520, 0.211930>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.690312, 0.828017, 0.155403>, <-1.690312, 0.828017, 0.212857>, <-1.690312, 0.881343, 0.325533>, <-1.690312, 0.828017, 0.346917>, 
      <-1.926019, 0.771957, 0.146682>, <-1.926019, 0.771957, 0.204136>, <-1.925621, 0.825379, 0.308972>, <-1.925621, 0.772052, 0.330356>, 
      <-2.258179, 0.798064, 0.167788>, <-2.258179, 0.798064, 0.225242>, <-2.261317, 0.850828, 0.336319>, <-2.258155, 0.798061, 0.358828>, 
      <-2.498441, 0.828017, 0.155403>, <-2.498441, 0.828017, 0.212857>, <-2.501602, 0.880784, 0.324409>, <-2.498441, 0.828017, 0.346917>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.155037, 1.385363, 0.242108>, <-0.155037, 1.385363, 0.323029>, <-0.155037, 1.465877, 0.503740>, <-0.155037, 1.385363, 0.511843>, 
      <-0.582852, 1.145315, 0.231083>, <-0.582852, 1.145315, 0.312003>, <-0.584139, 1.225106, 0.482706>, <-0.584139, 1.144592, 0.490808>, 
      <-1.213254, 0.941479, 0.173054>, <-1.213254, 0.941479, 0.230508>, <-1.212311, 0.995029, 0.359174>, <-1.212311, 0.941703, 0.380558>, 
      <-1.690312, 0.828017, 0.155403>, <-1.690312, 0.828017, 0.212857>, <-1.690312, 0.881343, 0.325533>, <-1.690312, 0.828017, 0.346917>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.674116, 2.715809, 0.242108>, <1.674116, 2.715809, 0.323029>, <1.674116, 2.796624, 0.507708>, <1.674116, 2.715809, 0.511843>, 
      <1.034397, 2.489558, 0.242108>, <1.034397, 2.489558, 0.323029>, <1.034397, 2.570373, 0.507708>, <1.034397, 2.489558, 0.511843>, 
      <0.436574, 1.717318, 0.257354>, <0.436574, 1.717318, 0.338275>, <0.436183, 1.797613, 0.532722>, <0.436183, 1.717099, 0.540825>, 
      <-0.155037, 1.385363, 0.242108>, <-0.155037, 1.385363, 0.323029>, <-0.155037, 1.465877, 0.503740>, <-0.155037, 1.385363, 0.511843>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <5.372428, 3.340272, 0.242108>, <5.372428, 3.340272, 0.323029>, <5.372428, 3.421123, 0.508489>, <5.372428, 3.340272, 0.511843>, 
      <4.249669, 3.414334, 0.242108>, <4.249669, 3.414334, 0.323029>, <4.249669, 3.495185, 0.508489>, <4.249669, 3.414334, 0.511843>, 
      <2.734924, 3.090987, 0.242108>, <2.734924, 3.090987, 0.323029>, <2.734924, 3.171802, 0.507708>, <2.734924, 3.090987, 0.511843>, 
      <1.674116, 2.715809, 0.242108>, <1.674116, 2.715809, 0.323029>, <1.674116, 2.796624, 0.507708>, <1.674116, 2.715809, 0.511843>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <9.070738, 2.227898, 0.242108>, <9.070738, 2.227898, 0.323029>, <9.070738, 2.308661, 0.506791>, <9.070738, 2.227898, 0.511843>, 
      <8.114374, 2.881889, 0.242108>, <8.114374, 2.881889, 0.323029>, <8.114374, 2.962652, 0.506791>, <8.114374, 2.881889, 0.511843>, 
      <6.528509, 3.264012, 0.242108>, <6.528509, 3.264012, 0.323029>, <6.528509, 3.344863, 0.508489>, <6.528509, 3.264012, 0.511843>, 
      <5.372428, 3.340272, 0.242108>, <5.372428, 3.340272, 0.323029>, <5.372428, 3.421123, 0.508489>, <5.372428, 3.340272, 0.511843>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <10.257080, 0.000000, 0.242108>, <10.257080, 0.000000, 0.323029>, <10.257080, 0.000000, 0.430922>, <10.257080, 0.000000, 0.511843>, 
      <10.257080, 0.757221, 0.242108>, <10.257080, 0.757221, 0.323029>, <10.257080, 0.757221, 0.430922>, <10.257080, 0.757221, 0.511843>, 
      <9.695790, 1.800469, 0.242108>, <9.695790, 1.800469, 0.323029>, <9.695790, 1.881232, 0.506791>, <9.695790, 1.800469, 0.511843>, 
      <9.070738, 2.227898, 0.242108>, <9.070738, 2.227898, 0.323029>, <9.070738, 2.308661, 0.506791>, <9.070738, 2.227898, 0.511843>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <9.070738, -2.227898, 0.242108>, <9.070738, -2.227898, 0.323029>, <9.070738, -2.308662, 0.506814>, <9.070738, -2.227898, 0.511843>, 
      <9.695790, -1.800469, 0.242108>, <9.695790, -1.800469, 0.323029>, <9.695790, -1.881233, 0.506814>, <9.695790, -1.800469, 0.511843>, 
      <10.257080, -0.757221, 0.242108>, <10.257080, -0.757221, 0.323029>, <10.257080, -0.757221, 0.430922>, <10.257080, -0.757221, 0.511843>, 
      <10.257080, 0.000000, 0.242108>, <10.257080, 0.000000, 0.323029>, <10.257080, 0.000000, 0.430922>, <10.257080, 0.000000, 0.511843>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <5.372428, -3.340272, 0.242108>, <5.372428, -3.340272, 0.323029>, <5.372428, -3.421122, 0.508466>, <5.372428, -3.340272, 0.511843>, 
      <6.528509, -3.264012, 0.242108>, <6.528509, -3.264012, 0.323029>, <6.528509, -3.344862, 0.508466>, <6.528509, -3.264012, 0.511843>, 
      <8.114374, -2.881889, 0.242108>, <8.114374, -2.881889, 0.323029>, <8.114374, -2.962653, 0.506814>, <8.114374, -2.881889, 0.511843>, 
      <9.070738, -2.227898, 0.242108>, <9.070738, -2.227898, 0.323029>, <9.070738, -2.308662, 0.506814>, <9.070738, -2.227898, 0.511843>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.674116, -2.715809, 0.242108>, <1.674116, -2.715809, 0.323029>, <1.674116, -2.796624, 0.507702>, <1.674116, -2.715809, 0.511843>, 
      <2.727641, -3.110977, 0.242108>, <2.727641, -3.110977, 0.323029>, <2.727641, -3.191792, 0.507702>, <2.727641, -3.110977, 0.511843>, 
      <4.249669, -3.414334, 0.242108>, <4.249669, -3.414334, 0.323029>, <4.249669, -3.495184, 0.508466>, <4.249669, -3.414334, 0.511843>, 
      <5.372428, -3.340272, 0.242108>, <5.372428, -3.340272, 0.323029>, <5.372428, -3.421122, 0.508466>, <5.372428, -3.340272, 0.511843>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.147181, -1.269915, 0.242108>, <-0.147181, -1.269915, 0.323029>, <-0.146685, -1.350356, 0.503061>, <-0.147181, -1.269915, 0.511843>, 
      <0.461071, -1.611207, 0.257783>, <0.461071, -1.611207, 0.338704>, <0.461165, -1.691423, 0.532858>, <0.460669, -1.610982, 0.541640>, 
      <1.020919, -2.470800, 0.242108>, <1.020919, -2.470800, 0.323029>, <1.020919, -2.551615, 0.507702>, <1.020919, -2.470800, 0.511843>, 
      <1.674116, -2.715809, 0.242108>, <1.674116, -2.715809, 0.323029>, <1.674116, -2.796624, 0.507702>, <1.674116, -2.715809, 0.511843>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.690312, -0.828017, 0.155403>, <-1.217098, -0.919192, 0.173292>, <-0.567642, -1.033993, 0.231272>, <-0.147181, -1.269915, 0.242108>, 
      <-1.690312, -0.828017, 0.212857>, <-1.217098, -0.919192, 0.230747>, <-0.567642, -1.033993, 0.312193>, <-0.147181, -1.269915, 0.323029>, 
      <-1.690312, -0.880928, 0.324524>, <-1.216153, -0.972284, 0.358620>, <-0.568465, -1.113693, 0.482385>, <-0.146685, -1.350356, 0.503061>, 
      <-1.690312, -0.828017, 0.346917>, <-1.216153, -0.919374, 0.381013>, <-0.568962, -1.033252, 0.491167>, <-0.147181, -1.269915, 0.511843>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.440718, -0.828017, 0.155403>, <-2.217617, -0.800204, 0.166903>, <-1.911216, -0.785455, 0.147052>, <-1.690312, -0.828017, 0.155403>, 
      <-2.440718, -0.828017, 0.212857>, <-2.217617, -0.800204, 0.224358>, <-1.911216, -0.785455, 0.204506>, <-1.690312, -0.828017, 0.212857>, 
      <-2.440112, -0.881359, 0.325581>, <-2.216989, -0.853543, 0.336640>, <-1.910819, -0.838442, 0.308668>, <-1.690312, -0.880928, 0.324524>, 
      <-2.440718, -0.828017, 0.346917>, <-2.217595, -0.800201, 0.357977>, <-1.910819, -0.785532, 0.331061>, <-1.690312, -0.828017, 0.346917>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.440718, -0.828017, 0.155403>, <-2.440718, -0.828017, 0.212857>, <-2.440112, -0.881359, 0.325581>, <-2.440718, -0.828017, 0.346917>, 
      <-3.037347, -0.902397, 0.124648>, <-3.037347, -0.902397, 0.182102>, <-3.036690, -0.955733, 0.296009>, <-3.037296, -0.902391, 0.317346>, 
      <-3.812302, -1.141326, 0.029891>, <-3.812302, -1.141326, 0.088963>, <-3.812399, -1.193758, 0.199005>, <-3.812399, -1.141330, 0.226224>, 
      <-4.413582, -1.167520, 0.015024>, <-4.413582, -1.167520, 0.074096>, <-4.413582, -1.219947, 0.184711>, <-4.413582, -1.167520, 0.211930>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-8.118152, -1.075347, -0.536316>, <-8.118152, -0.762992, -0.617553>, <-8.118152, -0.325408, -0.618394>, <-8.118152, -0.002661, -0.618394>, 
      <-7.037984, -1.316025, -0.642250>, <-7.037984, -1.003670, -0.723487>, <-7.012973, -0.322662, -0.735610>, <-7.012973, 0.000084, -0.735610>, 
      <-5.523828, -1.215887, -0.566722>, <-5.523828, -0.870387, -0.648370>, <-5.524518, -0.347737, -0.649312>, <-5.524518, 0.007279, -0.649312>, 
      <-4.413582, -1.167520, -0.536316>, <-4.413582, -0.822020, -0.617964>, <-4.413582, -0.341999, -0.618394>, <-4.413582, 0.013017, -0.618394>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-9.653429, 0.000000, -0.022437>, <-9.653429, 0.000000, -0.034502>, <-9.653429, 0.000000, -0.050588>, <-9.653429, 0.000000, -0.062653>, 
      <-9.653429, -0.583075, -0.022437>, <-9.653429, -0.583075, -0.034502>, <-9.192846, -0.000798, -0.217310>, <-9.192846, -0.000798, -0.229375>, 
      <-8.684681, -0.949115, -0.480756>, <-8.684681, -0.636760, -0.561993>, <-8.605249, -0.326618, -0.566732>, <-8.605249, -0.003871, -0.566732>, 
      <-8.118152, -1.075347, -0.536316>, <-8.118152, -0.762992, -0.617553>, <-8.118152, -0.325408, -0.618394>, <-8.118152, -0.002661, -0.618394>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-8.118152, 1.075347, -0.536316>, <-8.118152, 0.761353, -0.617576>, <-8.118152, 0.321678, -0.618394>, <-8.118152, -0.002661, -0.618394>, 
      <-8.684681, 0.949115, -0.480756>, <-8.684681, 0.635122, -0.562016>, <-8.605249, 0.320467, -0.566732>, <-8.605249, -0.003871, -0.566732>, 
      <-9.653429, 0.583075, -0.022437>, <-9.653429, 0.583075, -0.034502>, <-9.192846, -0.000798, -0.217310>, <-9.192846, -0.000798, -0.229375>, 
      <-9.653429, 0.000000, -0.022437>, <-9.653429, 0.000000, -0.034502>, <-9.653429, 0.000000, -0.050588>, <-9.653429, 0.000000, -0.062653>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-8.118152, 1.075347, -0.536316>, <-8.118152, 0.761353, -0.617576>, <-8.118152, 0.321678, -0.618394>, <-8.118152, -0.002661, -0.618394>, 
      <-8.684681, 0.949115, -0.480756>, <-8.684681, 0.635122, -0.562016>, <-8.118152, -0.001069, -0.618394>, <-8.118152, -0.325408, -0.618394>, 
      <-9.653429, 0.583075, -0.022437>, <-9.653429, 0.000000, -0.022437>, <-8.684681, -0.636760, -0.561993>, <-8.118152, -0.762992, -0.617553>, 
      <-9.653429, 0.000000, -0.022437>, <-9.653429, -0.583075, -0.022437>, <-8.684681, -0.949115, -0.480756>, <-8.118152, -1.075347, -0.536316>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-4.413582, 1.167520, -0.536316>, <-4.413582, 0.830009, -0.617875>, <-4.413582, 0.360242, -0.618394>, <-4.413582, 0.013017, -0.618394>, 
      <-5.523798, 1.216382, -0.567033>, <-5.523798, 0.878871, -0.648592>, <-5.524518, 0.354504, -0.649312>, <-5.524518, 0.007279, -0.649312>, 
      <-7.037984, 1.316025, -0.642250>, <-7.037984, 1.002031, -0.723510>, <-7.012973, 0.324423, -0.735610>, <-7.012973, 0.000084, -0.735610>, 
      <-8.118152, 1.075347, -0.536316>, <-8.118152, 0.761353, -0.617576>, <-8.118152, 0.321678, -0.618394>, <-8.118152, -0.002661, -0.618394>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.498441, 0.828017, -0.380831>, <-2.484727, 0.599130, -0.458328>, <-2.458856, 0.268507, -0.460659>, <-2.450425, 0.026614, -0.460659>, 
      <-3.078376, 0.900316, -0.413942>, <-3.064662, 0.671429, -0.491440>, <-3.048666, 0.276161, -0.495008>, <-3.040235, 0.034268, -0.495008>, 
      <-3.829010, 1.141792, -0.520142>, <-3.829010, 0.804282, -0.601701>, <-3.822959, 0.363293, -0.601957>, <-3.822959, 0.016068, -0.601957>, 
      <-4.413582, 1.167520, -0.536316>, <-4.413582, 0.830009, -0.617875>, <-4.413582, 0.360242, -0.618394>, <-4.413582, 0.013017, -0.618394>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.690312, 0.828017, -0.380831>, <-1.690312, 0.583871, -0.458490>, <-1.690312, 0.233876, -0.459798>, <-1.690312, -0.022324, -0.459798>, 
      <-1.925817, 0.772006, -0.367533>, <-1.925817, 0.527859, -0.445192>, <-1.918219, 0.236153, -0.443423>, <-1.918219, -0.020047, -0.443423>, 
      <-2.258250, 0.798073, -0.367117>, <-2.244536, 0.569186, -0.444615>, <-2.230756, 0.265547, -0.447375>, <-2.222324, 0.023654, -0.447375>, 
      <-2.498441, 0.828017, -0.380831>, <-2.484727, 0.599130, -0.458328>, <-2.458856, 0.268507, -0.460659>, <-2.450425, 0.026614, -0.460659>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.155037, 1.385363, -0.513152>, <-0.155037, 0.984537, -0.624019>, <-0.156267, 0.419551, -0.625587>, <-0.155037, 0.003677, -0.625587>, 
      <-0.583506, 1.144948, -0.496301>, <-0.583506, 0.744122, -0.607168>, <-0.619023, 0.416754, -0.602784>, <-0.617793, 0.000880, -0.602784>, 
      <-1.212774, 0.941593, -0.407795>, <-1.212774, 0.697446, -0.485455>, <-1.228201, 0.229258, -0.493002>, <-1.228201, -0.026942, -0.493002>, 
      <-1.690312, 0.828017, -0.380831>, <-1.690312, 0.583871, -0.458490>, <-1.690312, 0.233876, -0.459798>, <-1.690312, -0.022324, -0.459798>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.674116, 2.715809, -0.513152>, <1.674116, 1.907723, -0.626783>, <1.674116, 0.814050, -0.625586>, <1.674116, -0.001986, -0.625586>, 
      <1.034397, 2.489558, -0.513152>, <1.034397, 1.681473, -0.626783>, <1.125369, 0.815582, -0.625586>, <1.125369, -0.000454, -0.625586>, 
      <0.436376, 1.717207, -0.536412>, <0.436376, 1.316381, -0.647279>, <0.391806, 0.422864, -0.652594>, <0.393037, 0.006990, -0.652594>, 
      <-0.155037, 1.385363, -0.513152>, <-0.155037, 0.984537, -0.624019>, <-0.156267, 0.419551, -0.625587>, <-0.155037, 0.003677, -0.625587>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <5.372428, 3.340272, -0.513152>, <5.372428, 2.340576, -0.627129>, <5.372428, 0.994421, -0.625586>, <5.372428, -0.011751, -0.625586>, 
      <4.249669, 3.414334, -0.513152>, <4.249669, 2.414637, -0.627129>, <4.262931, 0.993357, -0.625586>, <4.262931, -0.012816, -0.625586>, 
      <2.734924, 3.090987, -0.513152>, <2.734924, 2.282901, -0.626783>, <2.783609, 0.810953, -0.625586>, <2.783609, -0.005083, -0.625586>, 
      <1.674116, 2.715809, -0.513152>, <1.674116, 1.907723, -0.626783>, <1.674116, 0.814050, -0.625586>, <1.674116, -0.001986, -0.625586>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <9.070738, 2.227898, -0.513152>, <9.070738, 1.569865, -0.626289>, <9.070738, 0.672800, -0.625586>, <9.070738, 0.005112, -0.625586>, 
      <8.114374, 2.881889, -0.513152>, <8.114374, 2.223856, -0.626289>, <7.961237, 0.670131, -0.625586>, <7.961237, 0.002443, -0.625586>, 
      <6.528509, 3.264012, -0.513152>, <6.528509, 2.264316, -0.627129>, <6.481932, 0.995486, -0.625586>, <6.481932, -0.010686, -0.625586>, 
      <5.372428, 3.340272, -0.513152>, <5.372428, 2.340576, -0.627129>, <5.372428, 0.994421, -0.625586>, <5.372428, -0.011751, -0.625586>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <10.257080, 0.000000, -0.513152>, <10.257080, 0.000000, -0.546883>, <10.257080, 0.000000, -0.591857>, <10.257080, 0.000000, -0.625587>, 
      <10.257080, 0.757221, -0.513152>, <10.257080, 0.757221, -0.546883>, <9.901178, 0.001534, -0.591856>, <9.901178, 0.001534, -0.625587>, 
      <9.695790, 1.800469, -0.513152>, <9.695790, 1.142436, -0.626289>, <9.426643, 0.673656, -0.625586>, <9.426643, 0.005968, -0.625586>, 
      <9.070738, 2.227898, -0.513152>, <9.070738, 1.569865, -0.626289>, <9.070738, 0.672800, -0.625586>, <9.070738, 0.005112, -0.625586>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <9.070738, -2.227898, -0.513152>, <9.070738, -1.566759, -0.626303>, <9.070738, -0.665640, -0.625586>, <9.070738, 0.005112, -0.625586>, 
      <9.695790, -1.800469, -0.513152>, <9.695790, -1.139330, -0.626303>, <9.426643, -0.664783, -0.625586>, <9.426643, 0.005968, -0.625586>, 
      <10.257080, -0.757221, -0.513152>, <10.257080, -0.757221, -0.546883>, <9.901178, 0.001534, -0.591856>, <9.901178, 0.001534, -0.625587>, 
      <10.257080, 0.000000, -0.513152>, <10.257080, 0.000000, -0.546883>, <10.257080, 0.000000, -0.591857>, <10.257080, 0.000000, -0.625587>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <9.070738, -2.227898, -0.513152>, <9.070738, -1.566759, -0.626303>, <9.070738, -0.665640, -0.625586>, <9.070738, 0.005112, -0.625586>, 
      <9.695790, -1.800469, -0.513152>, <9.695790, -1.139330, -0.626303>, <9.070738, 0.002049, -0.625586>, <9.070738, 0.672800, -0.625586>, 
      <10.257080, -0.757221, -0.513152>, <10.257080, 0.000000, -0.513152>, <9.695790, 1.142436, -0.626289>, <9.070738, 1.569865, -0.626289>, 
      <10.257080, 0.000000, -0.513152>, <10.257080, 0.757221, -0.513152>, <9.695790, 1.800469, -0.513152>, <9.070738, 2.227898, -0.513152>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <5.372428, -3.340272, -0.513152>, <5.372428, -2.347667, -0.627119>, <5.372428, -1.010877, -0.625586>, <5.372428, -0.011751, -0.625586>, 
      <6.528509, -3.264012, -0.513152>, <6.528509, -2.271407, -0.627119>, <6.481932, -1.009812, -0.625586>, <6.481932, -0.010686, -0.625586>, 
      <8.114374, -2.881889, -0.513152>, <8.114374, -2.220750, -0.626303>, <7.961237, -0.668309, -0.625586>, <7.961237, 0.002443, -0.625586>, 
      <9.070738, -2.227898, -0.513152>, <9.070738, -1.566759, -0.626303>, <9.070738, -0.665640, -0.625586>, <9.070738, 0.005112, -0.625586>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.674116, -2.715809, -0.513152>, <1.674116, -1.908925, -0.626780>, <1.674116, -0.816831, -0.625586>, <1.674116, -0.001986, -0.625586>, 
      <2.727641, -3.110977, -0.513152>, <2.727641, -2.304093, -0.626780>, <2.783609, -0.819928, -0.625586>, <2.783609, -0.005083, -0.625586>, 
      <4.249669, -3.414334, -0.513152>, <4.249669, -2.421729, -0.627119>, <4.262931, -1.011942, -0.625586>, <4.262931, -0.012816, -0.625586>, 
      <5.372428, -3.340272, -0.513152>, <5.372428, -2.347667, -0.627119>, <5.372428, -1.010877, -0.625586>, <5.372428, -0.011751, -0.625586>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.147181, -1.269915, -0.513152>, <-0.149447, -0.902535, -0.623393>, <-0.153902, -0.379892, -0.625587>, <-0.155037, 0.003677, -0.625587>, 
      <0.460867, -1.611093, -0.537066>, <0.458601, -1.243712, -0.647307>, <0.394171, -0.376579, -0.652594>, <0.393037, 0.006990, -0.652594>, 
      <1.020919, -2.470800, -0.513152>, <1.020919, -1.663916, -0.626780>, <1.125369, -0.815300, -0.625586>, <1.125369, -0.000454, -0.625586>, 
      <1.674116, -2.715809, -0.513152>, <1.674116, -1.908925, -0.626780>, <1.674116, -0.816831, -0.625586>, <1.674116, -0.001986, -0.625586>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.690312, -0.828017, -0.380831>, <-1.690312, -0.597779, -0.458124>, <-1.690312, -0.265190, -0.459798>, <-1.690312, -0.022324, -0.459798>, 
      <-1.216617, -0.919284, -0.408160>, <-1.216617, -0.689046, -0.485453>, <-1.228201, -0.269808, -0.493002>, <-1.228201, -0.026942, -0.493002>, 
      <-0.568313, -1.033616, -0.496589>, <-0.570579, -0.666236, -0.606830>, <-0.616658, -0.382690, -0.602784>, <-0.617793, 0.000880, -0.602784>, 
      <-0.147181, -1.269915, -0.513152>, <-0.149447, -0.902535, -0.623393>, <-0.153902, -0.379892, -0.625587>, <-0.155037, 0.003677, -0.625587>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.440718, -0.828017, -0.380831>, <-2.443506, -0.582584, -0.458755>, <-2.441454, -0.230752, -0.460659>, <-2.450425, 0.026614, -0.460659>, 
      <-2.217683, -0.800212, -0.368097>, <-2.220471, -0.554778, -0.446020>, <-2.213354, -0.233712, -0.447375>, <-2.222324, 0.023654, -0.447375>, 
      <-1.911014, -0.785494, -0.368098>, <-1.911014, -0.555256, -0.445391>, <-1.918219, -0.262913, -0.443423>, <-1.918219, -0.020047, -0.443423>, 
      <-1.690312, -0.828017, -0.380831>, <-1.690312, -0.597779, -0.458124>, <-1.690312, -0.265190, -0.459798>, <-1.690312, -0.022324, -0.459798>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.440718, -0.828017, -0.380831>, <-3.037501, -0.902416, -0.414904>, <-3.812010, -1.141313, -0.519841>, <-4.413582, -1.167520, -0.536316>, 
      <-2.443506, -0.582584, -0.458755>, <-3.040289, -0.656983, -0.492828>, <-3.812010, -0.795814, -0.601489>, <-4.413582, -0.822020, -0.617964>, 
      <-2.441454, -0.230752, -0.460659>, <-3.031264, -0.223097, -0.495008>, <-3.822959, -0.338948, -0.601957>, <-4.413582, -0.341999, -0.618394>, 
      <-2.450425, 0.026614, -0.460659>, <-3.040235, 0.034268, -0.495008>, <-3.822959, 0.016068, -0.601957>, <-4.413582, 0.013017, -0.618394>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-8.118152, -1.075347, -0.339410>, <-8.118152, -1.075347, -0.398482>, <-8.118152, -1.132517, -0.521447>, <-8.118152, -1.075347, -0.536316>, 
      <-7.036250, -1.316412, -0.424779>, <-7.036250, -1.316412, -0.483851>, <-7.037984, -1.373195, -0.627381>, <-7.037984, -1.316025, -0.642250>, 
      <-5.523856, -1.215888, -0.368762>, <-5.523856, -1.215888, -0.427833>, <-5.523828, -1.273375, -0.553136>, <-5.523828, -1.215887, -0.566722>, 
      <-4.413582, -1.167520, -0.339410>, <-4.413582, -1.167520, -0.398482>, <-4.413582, -1.225008, -0.522730>, <-4.413582, -1.167520, -0.536316>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-9.653429, 0.000000, 0.074048>, <-9.653429, 0.000000, 0.045102>, <-9.653429, 0.000000, 0.006509>, <-9.653429, 0.000000, -0.022437>, 
      <-9.653429, -0.575843, 0.074048>, <-9.653429, -0.575843, 0.045102>, <-9.653429, -0.583075, 0.006509>, <-9.653429, -0.583075, -0.022437>, 
      <-8.678553, -0.950481, -0.295191>, <-8.678553, -0.950481, -0.354262>, <-8.684681, -1.006285, -0.465887>, <-8.684681, -0.949115, -0.480756>, 
      <-8.118152, -1.075347, -0.339410>, <-8.118152, -1.075347, -0.398482>, <-8.118152, -1.132517, -0.521447>, <-8.118152, -1.075347, -0.536316>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-8.118152, 1.075347, -0.339410>, <-8.118152, 1.075347, -0.398482>, <-8.118152, 1.132535, -0.521516>, <-8.118152, 1.075347, -0.536316>, 
      <-8.678553, 0.950481, -0.295191>, <-8.678553, 0.950481, -0.354262>, <-8.684681, 1.006303, -0.465956>, <-8.684681, 0.949115, -0.480756>, 
      <-9.653429, 0.575843, 0.074048>, <-9.653429, 0.575843, 0.045102>, <-9.653429, 0.583075, 0.006509>, <-9.653429, 0.583075, -0.022437>, 
      <-9.653429, 0.000000, 0.074048>, <-9.653429, 0.000000, 0.045102>, <-9.653429, 0.000000, 0.006509>, <-9.653429, 0.000000, -0.022437>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-4.413582, 1.167520, -0.339410>, <-4.413582, 1.167520, -0.398482>, <-4.413582, 1.224939, -0.522441>, <-4.413582, 1.167520, -0.536316>, 
      <-5.523826, 1.216383, -0.369063>, <-5.523826, 1.216383, -0.428134>, <-5.523798, 1.273801, -0.553158>, <-5.523798, 1.216382, -0.567033>, 
      <-7.036250, 1.316412, -0.424779>, <-7.036250, 1.316412, -0.483851>, <-7.037984, 1.373213, -0.627449>, <-7.037984, 1.316025, -0.642250>, 
      <-8.118152, 1.075347, -0.339410>, <-8.118152, 1.075347, -0.398482>, <-8.118152, 1.132535, -0.521516>, <-8.118152, 1.075347, -0.536316>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.498441, 0.828017, -0.189318>, <-2.498441, 0.828017, -0.246772>, <-2.501696, 0.882349, -0.362435>, <-2.498441, 0.828017, -0.380831>, 
      <-3.078314, 0.900308, -0.221277>, <-3.078314, 0.900308, -0.278731>, <-3.081631, 0.954648, -0.395547>, <-3.078376, 0.900316, -0.413942>, 
      <-3.829121, 1.141797, -0.323800>, <-3.829121, 1.141797, -0.382872>, <-3.829010, 1.199211, -0.506267>, <-3.829010, 1.141792, -0.520142>, 
      <-4.413582, 1.167520, -0.339410>, <-4.413582, 1.167520, -0.398482>, <-4.413582, 1.224939, -0.522441>, <-4.413582, 1.167520, -0.536316>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.690312, 0.828017, -0.189318>, <-1.690312, 0.828017, -0.246772>, <-1.690312, 0.882768, -0.363416>, <-1.690312, 0.828017, -0.380831>, 
      <-1.926112, 0.771935, -0.183874>, <-1.926112, 0.771935, -0.241328>, <-1.925817, 0.826756, -0.350118>, <-1.925817, 0.772006, -0.367533>, 
      <-2.258224, 0.798070, -0.176079>, <-2.258224, 0.798070, -0.233532>, <-2.261505, 0.852405, -0.348722>, <-2.258250, 0.798073, -0.367117>, 
      <-2.498441, 0.828017, -0.189318>, <-2.498441, 0.828017, -0.246772>, <-2.501696, 0.882349, -0.362435>, <-2.498441, 0.828017, -0.380831>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.155037, 1.385363, -0.243417>, <-0.155037, 1.385363, -0.324338>, <-0.155037, 1.463355, -0.491580>, <-0.155037, 1.385363, -0.513152>, 
      <-0.582550, 1.145484, -0.236543>, <-0.582550, 1.145484, -0.317463>, <-0.583506, 1.222940, -0.474728>, <-0.583506, 1.144948, -0.496301>, 
      <-1.213475, 0.941426, -0.200326>, <-1.213475, 0.941426, -0.257780>, <-1.212774, 0.996344, -0.390380>, <-1.212774, 0.941593, -0.407795>, 
      <-1.690312, 0.828017, -0.189318>, <-1.690312, 0.828017, -0.246772>, <-1.690312, 0.882768, -0.363416>, <-1.690312, 0.828017, -0.380831>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.674116, 2.715809, -0.243417>, <1.674116, 2.715809, -0.324338>, <1.674116, 2.795941, -0.501884>, <1.674116, 2.715809, -0.513152>, 
      <1.034397, 2.489558, -0.243417>, <1.034397, 2.489558, -0.324338>, <1.034397, 2.569691, -0.501884>, <1.034397, 2.489558, -0.513152>, 
      <0.436665, 1.717369, -0.252931>, <0.436665, 1.717369, -0.333852>, <0.436376, 1.795199, -0.514840>, <0.436376, 1.717207, -0.536412>, 
      <-0.155037, 1.385363, -0.243417>, <-0.155037, 1.385363, -0.324338>, <-0.155037, 1.463355, -0.491580>, <-0.155037, 1.385363, -0.513152>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <5.372428, 3.340272, -0.243417>, <5.372428, 3.340272, -0.324338>, <5.372428, 3.420672, -0.503985>, <5.372428, 3.340272, -0.513152>, 
      <4.249669, 3.414334, -0.243417>, <4.249669, 3.414334, -0.324338>, <4.249669, 3.494733, -0.503985>, <4.249669, 3.414334, -0.513152>, 
      <2.734924, 3.090987, -0.243417>, <2.734924, 3.090987, -0.324338>, <2.734924, 3.171119, -0.501884>, <2.734924, 3.090987, -0.513152>, 
      <1.674116, 2.715809, -0.243417>, <1.674116, 2.715809, -0.324338>, <1.674116, 2.795941, -0.501884>, <1.674116, 2.715809, -0.513152>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <9.070738, 2.227898, -0.243417>, <9.070738, 2.227898, -0.324338>, <9.070738, 2.307648, -0.499440>, <9.070738, 2.227898, -0.513152>, 
      <8.114374, 2.881889, -0.243417>, <8.114374, 2.881889, -0.324338>, <8.114374, 2.961640, -0.499440>, <8.114374, 2.881889, -0.513152>, 
      <6.528509, 3.264012, -0.243417>, <6.528509, 3.264012, -0.324338>, <6.528509, 3.344412, -0.503985>, <6.528509, 3.264012, -0.513152>, 
      <5.372428, 3.340272, -0.243417>, <5.372428, 3.340272, -0.324338>, <5.372428, 3.420672, -0.503985>, <5.372428, 3.340272, -0.513152>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <10.257080, 0.000000, -0.243417>, <10.257080, 0.000000, -0.324338>, <10.257080, 0.000000, -0.432231>, <10.257080, 0.000000, -0.513152>, 
      <10.257080, 0.757221, -0.243417>, <10.257080, 0.757221, -0.324338>, <10.257080, 0.757221, -0.432231>, <10.257080, 0.757221, -0.513152>, 
      <9.695790, 1.800469, -0.243417>, <9.695790, 1.800469, -0.324338>, <9.695790, 1.880219, -0.499440>, <9.695790, 1.800469, -0.513152>, 
      <9.070738, 2.227898, -0.243417>, <9.070738, 2.227898, -0.324338>, <9.070738, 2.307648, -0.499440>, <9.070738, 2.227898, -0.513152>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <9.070738, -2.227898, -0.243417>, <9.070738, -2.227898, -0.324338>, <9.070738, -2.307659, -0.499501>, <9.070738, -2.227898, -0.513152>, 
      <9.695790, -1.800469, -0.243417>, <9.695790, -1.800469, -0.324338>, <9.695790, -1.880230, -0.499501>, <9.695790, -1.800469, -0.513152>, 
      <10.257080, -0.757221, -0.243417>, <10.257080, -0.757221, -0.324338>, <10.257080, -0.757221, -0.432231>, <10.257080, -0.757221, -0.513152>, 
      <10.257080, 0.000000, -0.243417>, <10.257080, 0.000000, -0.324338>, <10.257080, 0.000000, -0.432231>, <10.257080, 0.000000, -0.513152>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <5.372428, -3.340272, -0.243417>, <5.372428, -3.340272, -0.324338>, <5.372428, -3.420664, -0.503922>, <5.372428, -3.340272, -0.513152>, 
      <6.528509, -3.264012, -0.243417>, <6.528509, -3.264012, -0.324338>, <6.528509, -3.344404, -0.503922>, <6.528509, -3.264012, -0.513152>, 
      <8.114374, -2.881889, -0.243417>, <8.114374, -2.881889, -0.324338>, <8.114374, -2.961650, -0.499501>, <8.114374, -2.881889, -0.513152>, 
      <9.070738, -2.227898, -0.243417>, <9.070738, -2.227898, -0.324338>, <9.070738, -2.307659, -0.499501>, <9.070738, -2.227898, -0.513152>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.674116, -2.715809, -0.243417>, <1.674116, -2.715809, -0.324338>, <1.674116, -2.795939, -0.501868>, <1.674116, -2.715809, -0.513152>, 
      <2.727641, -3.110977, -0.243417>, <2.727641, -3.110977, -0.324338>, <2.727641, -3.191107, -0.501868>, <2.727641, -3.110977, -0.513152>, 
      <4.249669, -3.414334, -0.243417>, <4.249669, -3.414334, -0.324338>, <4.249669, -3.494726, -0.503922>, <4.249669, -3.414334, -0.513152>, 
      <5.372428, -3.340272, -0.243417>, <5.372428, -3.340272, -0.324338>, <5.372428, -3.420664, -0.503922>, <5.372428, -3.340272, -0.513152>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.147181, -1.269915, -0.243417>, <-0.147181, -1.269915, -0.324338>, <-0.146703, -1.347420, -0.489895>, <-0.147181, -1.269915, -0.513152>, 
      <0.461164, -1.611260, -0.253199>, <0.461164, -1.611260, -0.334119>, <0.461345, -1.688597, -0.513809>, <0.460867, -1.611093, -0.537066>, 
      <1.020919, -2.470800, -0.243417>, <1.020919, -2.470800, -0.324338>, <1.020919, -2.550930, -0.501868>, <1.020919, -2.470800, -0.513152>, 
      <1.674116, -2.715809, -0.243417>, <1.674116, -2.715809, -0.324338>, <1.674116, -2.795939, -0.501868>, <1.674116, -2.715809, -0.513152>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.690312, -0.828017, -0.189319>, <-1.690312, -0.828017, -0.246773>, <-1.690312, -0.882483, -0.362546>, <-1.690312, -0.828017, -0.380831>, 
      <-1.217320, -0.919149, -0.200476>, <-1.217320, -0.919149, -0.257929>, <-1.216617, -0.973750, -0.389875>, <-1.216617, -0.919284, -0.408160>, 
      <-0.567333, -1.034166, -0.236661>, <-0.567333, -1.034166, -0.317582>, <-0.567835, -1.111121, -0.473332>, <-0.568313, -1.033616, -0.496589>, 
      <-0.147181, -1.269915, -0.243417>, <-0.147181, -1.269915, -0.324338>, <-0.146703, -1.347420, -0.489895>, <-0.147181, -1.269915, -0.513152>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.440718, -0.828017, -0.189319>, <-2.440718, -0.828017, -0.246773>, <-2.440096, -0.882774, -0.363446>, <-2.440718, -0.828017, -0.380831>, 
      <-2.217659, -0.800209, -0.177025>, <-2.217659, -0.800209, -0.234479>, <-2.217061, -0.854969, -0.350712>, <-2.217683, -0.800212, -0.368097>, 
      <-1.911309, -0.785437, -0.184106>, <-1.911309, -0.785437, -0.241560>, <-1.911014, -0.839960, -0.349813>, <-1.911014, -0.785494, -0.368098>, 
      <-1.690312, -0.828017, -0.189319>, <-1.690312, -0.828017, -0.246773>, <-1.690312, -0.882483, -0.362546>, <-1.690312, -0.828017, -0.380831>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.440718, -0.828017, -0.189319>, <-3.037444, -0.902409, -0.222207>, <-3.812118, -1.141318, -0.323510>, <-4.413582, -1.167520, -0.339410>, 
      <-2.440718, -0.828017, -0.246773>, <-3.037444, -0.902409, -0.279661>, <-3.812118, -1.141318, -0.382581>, <-4.413582, -1.167520, -0.398482>, 
      <-2.440096, -0.882774, -0.363446>, <-3.036879, -0.957173, -0.397519>, <-3.812010, -1.198802, -0.506255>, <-4.413582, -1.225008, -0.522730>, 
      <-2.440718, -0.828017, -0.380831>, <-3.037501, -0.902416, -0.414904>, <-3.812010, -1.141313, -0.519841>, <-4.413582, -1.167520, -0.536316>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.690312, -0.828017, -0.016958>, <-1.217449, -0.919124, -0.013597>, <-0.567154, -1.034267, -0.002689>, <-0.147181, -1.269915, -0.000654>, 
      <-1.690312, -0.828017, 0.034750>, <-1.217449, -0.919124, 0.038112>, <-0.567154, -1.034267, 0.070139>, <-0.147181, -1.269915, 0.072175>, 
      <-1.690312, -0.828017, 0.103695>, <-1.217098, -0.919192, 0.121584>, <-0.567642, -1.033993, 0.158444>, <-0.147181, -1.269915, 0.169279>, 
      <-1.690312, -0.828017, 0.155403>, <-1.217098, -0.919192, 0.173292>, <-0.567642, -1.033993, 0.231272>, <-0.147181, -1.269915, 0.242108>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.690312, -0.828017, -0.016958>, <-1.690312, -0.828017, 0.034750>, <-1.690312, -0.828017, 0.103695>, <-1.690312, -0.828017, 0.155403>, 
      <-1.911363, -0.785427, -0.018529>, <-1.911363, -0.785427, 0.033179>, <-1.911216, -0.785455, 0.095344>, <-1.911216, -0.785455, 0.147052>, 
      <-2.217638, -0.800206, -0.005061>, <-2.217638, -0.800206, 0.046647>, <-2.217617, -0.800204, 0.115195>, <-2.217617, -0.800204, 0.166903>, 
      <-2.440718, -0.828017, -0.016958>, <-2.440718, -0.828017, 0.034750>, <-2.440718, -0.828017, 0.103695>, <-2.440718, -0.828017, 0.155403>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.690312, -0.828017, -0.016958>, <-1.217449, -0.919124, -0.013597>, <-0.567154, -1.034267, -0.002689>, <-0.147181, -1.269915, -0.000654>, 
      <-1.690312, -0.828017, -0.068666>, <-1.217449, -0.919124, -0.065305>, <-0.567154, -1.034267, -0.075518>, <-0.147181, -1.269915, -0.073483>, 
      <-1.690312, -0.828017, -0.137611>, <-1.217320, -0.919149, -0.148767>, <-0.567333, -1.034166, -0.163832>, <-0.147181, -1.269915, -0.170588>, 
      <-1.690312, -0.828017, -0.189319>, <-1.217320, -0.919149, -0.200476>, <-0.567333, -1.034166, -0.236661>, <-0.147181, -1.269915, -0.243417>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.690312, -0.828017, -0.016958>, <-1.911363, -0.785427, -0.018529>, <-2.217638, -0.800206, -0.005061>, <-2.440718, -0.828017, -0.016958>, 
      <-1.690312, -0.828017, -0.068666>, <-1.911363, -0.785427, -0.070238>, <-2.217638, -0.800206, -0.056769>, <-2.440718, -0.828017, -0.068666>, 
      <-1.690312, -0.828017, -0.137611>, <-1.911309, -0.785437, -0.132398>, <-2.217659, -0.800209, -0.125317>, <-2.440718, -0.828017, -0.137611>, 
      <-1.690312, -0.828017, -0.189319>, <-1.911309, -0.785437, -0.184106>, <-2.217659, -0.800209, -0.177025>, <-2.440718, -0.828017, -0.189319>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.674116, 2.715809, -0.000654>, <1.034397, 2.489558, -0.000654>, <0.436718, 1.717399, 0.002214>, <-0.155037, 1.385363, -0.000654>, 
      <1.674116, 2.715809, 0.072175>, <1.034397, 2.489558, 0.072175>, <0.436718, 1.717399, 0.075042>, <-0.155037, 1.385363, 0.072175>, 
      <1.674116, 2.715809, 0.169279>, <1.034397, 2.489558, 0.169279>, <0.436574, 1.717318, 0.184526>, <-0.155037, 1.385363, 0.169279>, 
      <1.674116, 2.715809, 0.242108>, <1.034397, 2.489558, 0.242108>, <0.436574, 1.717318, 0.257354>, <-0.155037, 1.385363, 0.242108>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.674116, 2.715809, -0.000654>, <1.034397, 2.489558, -0.000654>, <0.436718, 1.717399, 0.002214>, <-0.155037, 1.385363, -0.000654>, 
      <1.674116, 2.715809, -0.073483>, <1.034397, 2.489558, -0.073483>, <0.436718, 1.717399, -0.070615>, <-0.155037, 1.385363, -0.073483>, 
      <1.674116, 2.715809, -0.170588>, <1.034397, 2.489558, -0.170588>, <0.436665, 1.717369, -0.180103>, <-0.155037, 1.385363, -0.170588>, 
      <1.674116, 2.715809, -0.243417>, <1.034397, 2.489558, -0.243417>, <0.436665, 1.717369, -0.252931>, <-0.155037, 1.385363, -0.243417>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-9.653429, 0.000000, 0.160884>, <-9.653429, 0.570618, 0.160884>, <-8.674106, 0.951472, -0.127915>, <-8.118152, 1.075347, -0.162194>, 
      <-9.653429, 0.000000, 0.134833>, <-9.653429, 0.570618, 0.134833>, <-8.674106, 0.951472, -0.181080>, <-8.118152, 1.075347, -0.215359>, 
      <-9.653429, 0.000000, 0.100099>, <-9.653429, 0.575843, 0.100099>, <-8.678553, 0.950481, -0.242026>, <-8.118152, 1.075347, -0.286245>, 
      <-9.653429, 0.000000, 0.074048>, <-9.653429, 0.575843, 0.074048>, <-8.678553, 0.950481, -0.295191>, <-8.118152, 1.075347, -0.339410>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-9.653429, 0.000000, 0.160884>, <-9.653429, 0.570618, 0.160884>, <-8.674106, 0.951472, -0.127915>, <-8.118152, 1.075347, -0.162194>, 
      <-9.653429, 0.000000, 0.186935>, <-9.653429, 0.570618, 0.186935>, <-8.674106, 0.951472, -0.074750>, <-8.118152, 1.075347, -0.109029>, 
      <-9.653429, 0.000000, 0.221670>, <-9.653429, 0.566642, 0.221670>, <-8.670713, 0.952228, -0.013603>, <-8.118152, 1.075347, -0.038141>, 
      <-9.653429, 0.000000, 0.247721>, <-9.653429, 0.566642, 0.247721>, <-8.670713, 0.952228, 0.039563>, <-8.118152, 1.075347, 0.015024>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-8.118152, -1.075347, -0.162192>, <-8.674105, -0.951472, -0.127913>, <-9.653429, -0.570618, 0.160885>, <-9.653429, 0.000000, 0.160884>, 
      <-8.118152, -1.075347, -0.215357>, <-8.674105, -0.951472, -0.181079>, <-9.653429, -0.570618, 0.134834>, <-9.653429, 0.000000, 0.134833>, 
      <-8.118152, -1.075347, -0.286245>, <-8.678553, -0.950481, -0.242025>, <-9.653429, -0.575843, 0.100099>, <-9.653429, 0.000000, 0.100099>, 
      <-8.118152, -1.075347, -0.339410>, <-8.678553, -0.950481, -0.295191>, <-9.653429, -0.575843, 0.074048>, <-9.653429, 0.000000, 0.074048>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-8.118152, -1.075347, -0.162192>, <-8.118152, -1.075347, -0.109027>, <-8.118152, -1.075347, -0.038141>, <-8.118152, -1.075347, 0.015024>, 
      <-8.674105, -0.951472, -0.127913>, <-8.674105, -0.951472, -0.074748>, <-8.670713, -0.952228, -0.013602>, <-8.670713, -0.952228, 0.039563>, 
      <-9.653429, -0.570618, 0.160885>, <-9.653429, -0.570618, 0.186936>, <-9.653429, -0.566642, 0.221670>, <-9.653429, -0.566642, 0.247721>, 
      <-9.653429, 0.000000, 0.160884>, <-9.653429, 0.000000, 0.186935>, <-9.653429, 0.000000, 0.221670>, <-9.653429, 0.000000, 0.247721>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-4.413582, -1.167520, -0.162192>, <-4.413582, -1.167520, -0.215357>, <-4.413582, -1.167520, -0.286245>, <-4.413582, -1.167520, -0.339410>, 
      <-3.812212, -1.141322, -0.146808>, <-3.812212, -1.141322, -0.199974>, <-3.812118, -1.141318, -0.270344>, <-3.812118, -1.141318, -0.323510>, 
      <-3.037395, -0.902403, -0.048779>, <-3.037395, -0.902403, -0.100487>, <-3.037444, -0.902409, -0.170499>, <-3.037444, -0.902409, -0.222207>, 
      <-2.440718, -0.828017, -0.016958>, <-2.440718, -0.828017, -0.068666>, <-2.440718, -0.828017, -0.137611>, <-2.440718, -0.828017, -0.189319>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-4.413582, -1.167520, -0.162192>, <-5.523881, -1.215889, -0.190595>, <-7.035006, -1.316689, -0.228976>, <-8.118152, -1.075347, -0.162192>, 
      <-4.413582, -1.167520, -0.215357>, <-5.523881, -1.215889, -0.243760>, <-7.035006, -1.316689, -0.282141>, <-8.118152, -1.075347, -0.215357>, 
      <-4.413582, -1.167520, -0.286245>, <-5.523856, -1.215888, -0.315596>, <-7.036250, -1.316412, -0.371614>, <-8.118152, -1.075347, -0.286245>, 
      <-4.413582, -1.167520, -0.339410>, <-5.523856, -1.215888, -0.368762>, <-7.036250, -1.316412, -0.424779>, <-8.118152, -1.075347, -0.339410>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-4.413582, -1.167520, -0.162192>, <-3.812212, -1.141322, -0.146808>, <-3.037395, -0.902403, -0.048779>, <-2.440718, -0.828017, -0.016958>, 
      <-4.413582, -1.167520, -0.109027>, <-3.812212, -1.141322, -0.093644>, <-3.037395, -0.902403, 0.002929>, <-2.440718, -0.828017, 0.034750>, 
      <-4.413582, -1.167520, -0.038141>, <-3.812302, -1.141326, -0.023274>, <-3.037347, -0.902397, 0.072940>, <-2.440718, -0.828017, 0.103695>, 
      <-4.413582, -1.167520, 0.015024>, <-3.812302, -1.141326, 0.029891>, <-3.037347, -0.902397, 0.124648>, <-2.440718, -0.828017, 0.155403>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-4.413582, -1.167520, -0.162192>, <-4.413582, -1.167520, -0.109027>, <-4.413582, -1.167520, -0.038141>, <-4.413582, -1.167520, 0.015024>, 
      <-5.523881, -1.215889, -0.190595>, <-5.523881, -1.215889, -0.137430>, <-5.523905, -1.215890, -0.065594>, <-5.523905, -1.215890, -0.012430>, 
      <-7.035006, -1.316689, -0.228976>, <-7.035006, -1.316689, -0.175811>, <-7.034064, -1.316899, -0.086284>, <-7.034064, -1.316899, -0.033119>, 
      <-8.118152, -1.075347, -0.162192>, <-8.118152, -1.075347, -0.109027>, <-8.118152, -1.075347, -0.038141>, <-8.118152, -1.075347, 0.015024>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.690312, 0.828017, -0.016958>, <-1.926166, 0.771922, -0.018599>, <-2.258201, 0.798067, -0.004146>, <-2.498441, 0.828017, -0.016958>, 
      <-1.690312, 0.828017, -0.068666>, <-1.926166, 0.771922, -0.070307>, <-2.258201, 0.798067, -0.055854>, <-2.498441, 0.828017, -0.068666>, 
      <-1.690312, 0.828017, -0.137610>, <-1.926112, 0.771935, -0.132166>, <-2.258224, 0.798070, -0.124370>, <-2.498441, 0.828017, -0.137610>, 
      <-1.690312, 0.828017, -0.189318>, <-1.926112, 0.771935, -0.183874>, <-2.258224, 0.798070, -0.176079>, <-2.498441, 0.828017, -0.189318>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.690312, 0.828017, -0.016958>, <-1.213603, 0.941396, -0.013641>, <-0.582375, 1.145582, -0.002725>, <-0.155037, 1.385363, -0.000654>, 
      <-1.690312, 0.828017, -0.068666>, <-1.213603, 0.941396, -0.065349>, <-0.582375, 1.145582, -0.075554>, <-0.155037, 1.385363, -0.073483>, 
      <-1.690312, 0.828017, -0.137610>, <-1.213475, 0.941426, -0.148618>, <-0.582550, 1.145484, -0.163714>, <-0.155037, 1.385363, -0.170588>, 
      <-1.690312, 0.828017, -0.189318>, <-1.213475, 0.941426, -0.200326>, <-0.582550, 1.145484, -0.236543>, <-0.155037, 1.385363, -0.243417>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.690312, 0.828017, -0.016958>, <-1.926166, 0.771922, -0.018599>, <-2.258201, 0.798067, -0.004146>, <-2.498441, 0.828017, -0.016958>, 
      <-1.690312, 0.828017, 0.034750>, <-1.926166, 0.771922, 0.033109>, <-2.258201, 0.798067, 0.047563>, <-2.498441, 0.828017, 0.034750>, 
      <-1.690312, 0.828017, 0.103695>, <-1.926019, 0.771957, 0.094974>, <-2.258179, 0.798064, 0.116080>, <-2.498441, 0.828017, 0.103695>, 
      <-1.690312, 0.828017, 0.155403>, <-1.926019, 0.771957, 0.146682>, <-2.258179, 0.798064, 0.167788>, <-2.498441, 0.828017, 0.155403>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.690312, 0.828017, -0.016958>, <-1.690312, 0.828017, 0.034750>, <-1.690312, 0.828017, 0.103695>, <-1.690312, 0.828017, 0.155403>, 
      <-1.213603, 0.941396, -0.013641>, <-1.213603, 0.941396, 0.038067>, <-1.213254, 0.941479, 0.121346>, <-1.213254, 0.941479, 0.173054>, 
      <-0.582375, 1.145582, -0.002725>, <-0.582375, 1.145582, 0.070104>, <-0.582852, 1.145315, 0.158254>, <-0.582852, 1.145315, 0.231083>, 
      <-0.155037, 1.385363, -0.000654>, <-0.155037, 1.385363, 0.072175>, <-0.155037, 1.385363, 0.169279>, <-0.155037, 1.385363, 0.242108>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-4.413582, 1.167520, -0.162194>, <-4.413582, 1.167520, -0.109029>, <-4.413582, 1.167520, -0.038141>, <-4.413582, 1.167520, 0.015024>, 
      <-5.523852, 1.216384, -0.190888>, <-5.523852, 1.216384, -0.137723>, <-5.523876, 1.216385, -0.065876>, <-5.523876, 1.216385, -0.012711>, 
      <-7.035006, 1.316689, -0.228979>, <-7.035006, 1.316689, -0.175813>, <-7.034064, 1.316899, -0.086285>, <-7.034064, 1.316899, -0.033119>, 
      <-8.118152, 1.075347, -0.162194>, <-8.118152, 1.075347, -0.109029>, <-8.118152, 1.075347, -0.038141>, <-8.118152, 1.075347, 0.015024>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-4.413582, 1.167520, -0.162194>, <-3.829218, 1.141801, -0.147092>, <-3.078259, 0.900301, -0.047881>, <-2.498441, 0.828017, -0.016958>, 
      <-4.413582, 1.167520, -0.109029>, <-3.829218, 1.141801, -0.093926>, <-3.078259, 0.900301, 0.003828>, <-2.498441, 0.828017, 0.034750>, 
      <-4.413582, 1.167520, -0.038141>, <-3.829312, 1.141806, -0.023547>, <-3.078207, 0.900295, 0.073809>, <-2.498441, 0.828017, 0.103695>, 
      <-4.413582, 1.167520, 0.015024>, <-3.829312, 1.141806, 0.029619>, <-3.078207, 0.900295, 0.125517>, <-2.498441, 0.828017, 0.155403>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-4.413582, 1.167520, -0.162194>, <-5.523852, 1.216384, -0.190888>, <-7.035006, 1.316689, -0.228979>, <-8.118152, 1.075347, -0.162194>, 
      <-4.413582, 1.167520, -0.215359>, <-5.523852, 1.216384, -0.244053>, <-7.035006, 1.316689, -0.282143>, <-8.118152, 1.075347, -0.215359>, 
      <-4.413582, 1.167520, -0.286245>, <-5.523826, 1.216383, -0.315898>, <-7.036250, 1.316412, -0.371614>, <-8.118152, 1.075347, -0.286245>, 
      <-4.413582, 1.167520, -0.339410>, <-5.523826, 1.216383, -0.369063>, <-7.036250, 1.316412, -0.424779>, <-8.118152, 1.075347, -0.339410>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-4.413582, 1.167520, -0.162194>, <-4.413582, 1.167520, -0.215359>, <-4.413582, 1.167520, -0.286245>, <-4.413582, 1.167520, -0.339410>, 
      <-3.829218, 1.141801, -0.147092>, <-3.829218, 1.141801, -0.200257>, <-3.829121, 1.141797, -0.270635>, <-3.829121, 1.141797, -0.323800>, 
      <-3.078259, 0.900301, -0.047881>, <-3.078259, 0.900301, -0.099589>, <-3.078314, 0.900308, -0.169570>, <-3.078314, 0.900308, -0.221277>, 
      <-2.498441, 0.828017, -0.016958>, <-2.498441, 0.828017, -0.068666>, <-2.498441, 0.828017, -0.137610>, <-2.498441, 0.828017, -0.189318>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.674116, -2.715809, -0.000654>, <1.674116, -2.715809, -0.073483>, <1.674116, -2.715809, -0.170588>, <1.674116, -2.715809, -0.243417>, 
      <1.020919, -2.470800, -0.000654>, <1.020919, -2.470800, -0.073483>, <1.020919, -2.470800, -0.170588>, <1.020919, -2.470800, -0.243417>, 
      <0.461219, -1.611290, 0.002294>, <0.461219, -1.611290, -0.070535>, <0.461164, -1.611260, -0.180370>, <0.461164, -1.611260, -0.253199>, 
      <-0.147181, -1.269915, -0.000654>, <-0.147181, -1.269915, -0.073483>, <-0.147181, -1.269915, -0.170588>, <-0.147181, -1.269915, -0.243417>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.674116, -2.715809, -0.000654>, <1.020919, -2.470800, -0.000654>, <0.461219, -1.611290, 0.002294>, <-0.147181, -1.269915, -0.000654>, 
      <1.674116, -2.715809, 0.072175>, <1.020919, -2.470800, 0.072175>, <0.461219, -1.611290, 0.075123>, <-0.147181, -1.269915, 0.072175>, 
      <1.674116, -2.715809, 0.169279>, <1.020919, -2.470800, 0.169279>, <0.461071, -1.611207, 0.184955>, <-0.147181, -1.269915, 0.169279>, 
      <1.674116, -2.715809, 0.242108>, <1.020919, -2.470800, 0.242108>, <0.461071, -1.611207, 0.257783>, <-0.147181, -1.269915, 0.242108>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <5.372428, -3.340272, -0.000654>, <5.372428, -3.340272, -0.073483>, <5.372428, -3.340272, -0.170588>, <5.372428, -3.340272, -0.243417>, 
      <4.249669, -3.414334, -0.000654>, <4.249669, -3.414334, -0.073483>, <4.249669, -3.414334, -0.170588>, <4.249669, -3.414334, -0.243417>, 
      <2.727641, -3.110977, -0.000654>, <2.727641, -3.110977, -0.073483>, <2.727641, -3.110977, -0.170588>, <2.727641, -3.110977, -0.243417>, 
      <1.674116, -2.715809, -0.000654>, <1.674116, -2.715809, -0.073483>, <1.674116, -2.715809, -0.170588>, <1.674116, -2.715809, -0.243417>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <5.372428, -3.340272, -0.000654>, <4.249669, -3.414334, -0.000654>, <2.727641, -3.110977, -0.000654>, <1.674116, -2.715809, -0.000654>, 
      <5.372428, -3.340272, 0.072175>, <4.249669, -3.414334, 0.072175>, <2.727641, -3.110977, 0.072175>, <1.674116, -2.715809, 0.072175>, 
      <5.372428, -3.340272, 0.169279>, <4.249669, -3.414334, 0.169279>, <2.727641, -3.110977, 0.169279>, <1.674116, -2.715809, 0.169279>, 
      <5.372428, -3.340272, 0.242108>, <4.249669, -3.414334, 0.242108>, <2.727641, -3.110977, 0.242108>, <1.674116, -2.715809, 0.242108>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <9.070738, -2.227898, -0.000654>, <9.070738, -2.227898, -0.073483>, <9.070738, -2.227898, -0.170588>, <9.070738, -2.227898, -0.243417>, 
      <8.114374, -2.881889, -0.000654>, <8.114374, -2.881889, -0.073483>, <8.114374, -2.881889, -0.170588>, <8.114374, -2.881889, -0.243417>, 
      <6.528509, -3.264012, -0.000654>, <6.528509, -3.264012, -0.073483>, <6.528509, -3.264012, -0.170588>, <6.528509, -3.264012, -0.243417>, 
      <5.372428, -3.340272, -0.000654>, <5.372428, -3.340272, -0.073483>, <5.372428, -3.340272, -0.170588>, <5.372428, -3.340272, -0.243417>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <9.070738, -2.227898, -0.000654>, <8.114374, -2.881889, -0.000654>, <6.528509, -3.264012, -0.000654>, <5.372428, -3.340272, -0.000654>, 
      <9.070738, -2.227898, 0.072175>, <8.114374, -2.881889, 0.072175>, <6.528509, -3.264012, 0.072175>, <5.372428, -3.340272, 0.072175>, 
      <9.070738, -2.227898, 0.169279>, <8.114374, -2.881889, 0.169279>, <6.528509, -3.264012, 0.169279>, <5.372428, -3.340272, 0.169279>, 
      <9.070738, -2.227898, 0.242108>, <8.114374, -2.881889, 0.242108>, <6.528509, -3.264012, 0.242108>, <5.372428, -3.340272, 0.242108>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <10.257080, 0.000000, -0.000654>, <10.257080, 0.000000, -0.073483>, <10.257080, 0.000000, -0.170588>, <10.257080, 0.000000, -0.243417>, 
      <10.257080, -0.757221, -0.000654>, <10.257080, -0.757221, -0.073483>, <10.257080, -0.757221, -0.170588>, <10.257080, -0.757221, -0.243417>, 
      <9.695790, -1.800469, -0.000654>, <9.695790, -1.800469, -0.073483>, <9.695790, -1.800469, -0.170588>, <9.695790, -1.800469, -0.243417>, 
      <9.070738, -2.227898, -0.000654>, <9.070738, -2.227898, -0.073483>, <9.070738, -2.227898, -0.170588>, <9.070738, -2.227898, -0.243417>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <10.257080, 0.000000, -0.000654>, <10.257080, -0.757221, -0.000654>, <9.695790, -1.800469, -0.000654>, <9.070738, -2.227898, -0.000654>, 
      <10.257080, 0.000000, 0.072175>, <10.257080, -0.757221, 0.072175>, <9.695790, -1.800469, 0.072175>, <9.070738, -2.227898, 0.072175>, 
      <10.257080, 0.000000, 0.169279>, <10.257080, -0.757221, 0.169279>, <9.695790, -1.800469, 0.169279>, <9.070738, -2.227898, 0.169279>, 
      <10.257080, 0.000000, 0.242108>, <10.257080, -0.757221, 0.242108>, <9.695790, -1.800469, 0.242108>, <9.070738, -2.227898, 0.242108>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <9.070738, 2.227898, -0.000654>, <9.695790, 1.800469, -0.000654>, <10.257080, 0.757221, -0.000654>, <10.257080, 0.000000, -0.000654>, 
      <9.070738, 2.227898, 0.072175>, <9.695790, 1.800469, 0.072175>, <10.257080, 0.757221, 0.072175>, <10.257080, 0.000000, 0.072175>, 
      <9.070738, 2.227898, 0.169279>, <9.695790, 1.800469, 0.169279>, <10.257080, 0.757221, 0.169279>, <10.257080, 0.000000, 0.169279>, 
      <9.070738, 2.227898, 0.242108>, <9.695790, 1.800469, 0.242108>, <10.257080, 0.757221, 0.242108>, <10.257080, 0.000000, 0.242108>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <9.070738, 2.227898, -0.000654>, <9.070738, 2.227898, -0.073483>, <9.070738, 2.227898, -0.170588>, <9.070738, 2.227898, -0.243417>, 
      <9.695790, 1.800469, -0.000654>, <9.695790, 1.800469, -0.073483>, <9.695790, 1.800469, -0.170588>, <9.695790, 1.800469, -0.243417>, 
      <10.257080, 0.757221, -0.000654>, <10.257080, 0.757221, -0.073483>, <10.257080, 0.757221, -0.170588>, <10.257080, 0.757221, -0.243417>, 
      <10.257080, 0.000000, -0.000654>, <10.257080, 0.000000, -0.073483>, <10.257080, 0.000000, -0.170588>, <10.257080, 0.000000, -0.243417>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <5.372428, 3.340272, -0.000654>, <5.372428, 3.340272, 0.072175>, <5.372428, 3.340272, 0.169279>, <5.372428, 3.340272, 0.242108>, 
      <4.249669, 3.414334, -0.000654>, <4.249669, 3.414334, 0.072175>, <4.249669, 3.414334, 0.169279>, <4.249669, 3.414334, 0.242108>, 
      <2.734924, 3.090987, -0.000654>, <2.734924, 3.090987, 0.072175>, <2.734924, 3.090987, 0.169279>, <2.734924, 3.090987, 0.242108>, 
      <1.674116, 2.715809, -0.000654>, <1.674116, 2.715809, 0.072175>, <1.674116, 2.715809, 0.169279>, <1.674116, 2.715809, 0.242108>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <5.372428, 3.340272, -0.000654>, <6.528509, 3.264012, -0.000654>, <8.114374, 2.881889, -0.000654>, <9.070738, 2.227898, -0.000654>, 
      <5.372428, 3.340272, 0.072175>, <6.528509, 3.264012, 0.072175>, <8.114374, 2.881889, 0.072175>, <9.070738, 2.227898, 0.072175>, 
      <5.372428, 3.340272, 0.169279>, <6.528509, 3.264012, 0.169279>, <8.114374, 2.881889, 0.169279>, <9.070738, 2.227898, 0.169279>, 
      <5.372428, 3.340272, 0.242108>, <6.528509, 3.264012, 0.242108>, <8.114374, 2.881889, 0.242108>, <9.070738, 2.227898, 0.242108>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <5.372428, 3.340272, -0.000654>, <4.249669, 3.414334, -0.000654>, <2.734924, 3.090987, -0.000654>, <1.674116, 2.715809, -0.000654>, 
      <5.372428, 3.340272, -0.073483>, <4.249669, 3.414334, -0.073483>, <2.734924, 3.090987, -0.073483>, <1.674116, 2.715809, -0.073483>, 
      <5.372428, 3.340272, -0.170588>, <4.249669, 3.414334, -0.170588>, <2.734924, 3.090987, -0.170588>, <1.674116, 2.715809, -0.170588>, 
      <5.372428, 3.340272, -0.243417>, <4.249669, 3.414334, -0.243417>, <2.734924, 3.090987, -0.243417>, <1.674116, 2.715809, -0.243417>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <5.372428, 3.340272, -0.000654>, <5.372428, 3.340272, -0.073483>, <5.372428, 3.340272, -0.170588>, <5.372428, 3.340272, -0.243417>, 
      <6.528509, 3.264012, -0.000654>, <6.528509, 3.264012, -0.073483>, <6.528509, 3.264012, -0.170588>, <6.528509, 3.264012, -0.243417>, 
      <8.114374, 2.881889, -0.000654>, <8.114374, 2.881889, -0.073483>, <8.114374, 2.881889, -0.170588>, <8.114374, 2.881889, -0.243417>, 
      <9.070738, 2.227898, -0.000654>, <9.070738, 2.227898, -0.073483>, <9.070738, 2.227898, -0.170588>, <9.070738, 2.227898, -0.243417>
    }
  }
  material {
    cepillodpelo_txt
  }
}
union { // pelos
  object { HgtFld001 }
  object { peine }
  object { cpelo }
  scale <0.857143, 0.8, 0.8>
  rotate 18.332964*z
  translate  <11.603753, -4.445219, 1.489078>
}


#declare tapa_cristal = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.328742, -0.197987, 11.183460>, <0.230119, -0.197987, 11.238960>, <0.098623, -0.197987, 11.312962>, <0.000000, -0.197987, 11.368462>, 
      <0.231335, -0.197987, 11.128644>, <0.132712, -0.197987, 11.184144>, <0.098623, -0.197987, 11.312962>, <0.000000, -0.197987, 11.368462>, 
      <-0.231335, -0.197987, 11.128644>, <-0.132712, -0.197987, 11.184144>, <-0.098623, -0.197987, 11.312962>, <0.000000, -0.197987, 11.368462>, 
      <-0.328742, -0.197987, 11.183460>, <-0.230119, -0.197987, 11.238960>, <-0.098623, -0.197987, 11.312962>, <0.000000, -0.197987, 11.368462>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.328742, -0.197987, 11.553461>, <0.230119, -0.197987, 11.497961>, <0.098623, -0.197987, 11.423962>, <0.000000, -0.197987, 11.368462>, 
      <0.383558, -0.197987, 11.522614>, <0.284936, -0.197987, 11.467114>, <0.098623, -0.197987, 11.423962>, <0.000000, -0.197987, 11.368462>, 
      <0.383558, -0.197987, 11.214308>, <0.284936, -0.197987, 11.269808>, <0.098623, -0.197987, 11.312962>, <0.000000, -0.197987, 11.368462>, 
      <0.328742, -0.197987, 11.183460>, <0.230119, -0.197987, 11.238960>, <0.098623, -0.197987, 11.312962>, <0.000000, -0.197987, 11.368462>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.328742, -0.197987, 11.553461>, <-0.230119, -0.197987, 11.497961>, <-0.098623, -0.197987, 11.423962>, <0.000000, -0.197987, 11.368462>, 
      <-0.231335, -0.197987, 11.608278>, <-0.132712, -0.197987, 11.552778>, <-0.098623, -0.197987, 11.423962>, <0.000000, -0.197987, 11.368462>, 
      <0.231335, -0.197987, 11.608278>, <0.132712, -0.197987, 11.552778>, <0.098623, -0.197987, 11.423962>, <0.000000, -0.197987, 11.368462>, 
      <0.328742, -0.197987, 11.553461>, <0.230119, -0.197987, 11.497961>, <0.098623, -0.197987, 11.423962>, <0.000000, -0.197987, 11.368462>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.328742, -0.197987, 11.553461>, <-0.383558, -0.197987, 11.522614>, <-0.383558, -0.197987, 11.214308>, <-0.328742, -0.197987, 11.183460>, 
      <-0.230119, -0.197987, 11.497961>, <-0.284936, -0.197987, 11.467114>, <-0.284936, -0.197987, 11.269808>, <-0.230119, -0.197987, 11.238960>, 
      <-0.098623, -0.197987, 11.423962>, <-0.098623, -0.197987, 11.423962>, <-0.098623, -0.197987, 11.312962>, <-0.098623, -0.197987, 11.312962>, 
      <0.000000, -0.197987, 11.368462>, <0.000000, -0.197987, 11.368462>, <0.000000, -0.197987, 11.368462>, <0.000000, -0.197987, 11.368462>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.328742, -0.197987, 11.183460>, <0.328742, -0.197987, 11.183460>, <0.328742, -0.197987, 11.183460>, <0.328742, -0.197987, 11.183460>, 
      <0.231335, -0.197987, 11.128644>, <0.231335, -0.197987, 11.128644>, <0.231335, -0.197987, 11.128644>, <0.231335, -0.197987, 11.128644>, 
      <-0.231335, -0.197987, 11.128644>, <-0.231335, -0.197987, 11.128644>, <-0.231335, -0.197987, 11.128644>, <-0.231335, -0.197987, 11.128644>, 
      <-0.328742, -0.197987, 11.183460>, <-0.328742, -0.197987, 11.183460>, <-0.328742, -0.197987, 11.183460>, <-0.328742, -0.197987, 11.183460>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.328742, -0.197987, 11.553461>, <0.328742, -0.197987, 11.553461>, <0.328742, -0.197987, 11.553461>, <0.328742, -0.197987, 11.553461>, 
      <0.383558, -0.197987, 11.522614>, <0.383558, -0.197987, 11.522614>, <0.383558, -0.197987, 11.522614>, <0.383558, -0.197987, 11.522614>, 
      <0.383558, -0.197987, 11.214308>, <0.383558, -0.197987, 11.214308>, <0.383558, -0.197987, 11.214308>, <0.383558, -0.197987, 11.214308>, 
      <0.328742, -0.197987, 11.183460>, <0.328742, -0.197987, 11.183460>, <0.328742, -0.197987, 11.183460>, <0.328742, -0.197987, 11.183460>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.328742, -0.197987, 11.553461>, <-0.328742, -0.197987, 11.553461>, <-0.328742, -0.197987, 11.553461>, <-0.328742, -0.197987, 11.553461>, 
      <-0.231335, -0.197987, 11.608278>, <-0.231335, -0.197987, 11.608278>, <-0.231335, -0.197987, 11.608278>, <-0.231335, -0.197987, 11.608278>, 
      <0.231335, -0.197987, 11.608278>, <0.231335, -0.197987, 11.608278>, <0.231335, -0.197987, 11.608278>, <0.231335, -0.197987, 11.608278>, 
      <0.328742, -0.197987, 11.553461>, <0.328742, -0.197987, 11.553461>, <0.328742, -0.197987, 11.553461>, <0.328742, -0.197987, 11.553461>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.328742, -0.197987, 11.553461>, <-0.383558, -0.197987, 11.522614>, <-0.383558, -0.197987, 11.214308>, <-0.328742, -0.197987, 11.183460>, 
      <-0.328742, -0.197987, 11.553461>, <-0.383558, -0.197987, 11.522614>, <-0.383558, -0.197987, 11.214308>, <-0.328742, -0.197987, 11.183460>, 
      <-0.328742, -0.197987, 11.553461>, <-0.383558, -0.197987, 11.522614>, <-0.383558, -0.197987, 11.214308>, <-0.328742, -0.197987, 11.183460>, 
      <-0.328742, -0.197987, 11.553461>, <-0.383558, -0.197987, 11.522614>, <-0.383558, -0.197987, 11.214308>, <-0.328742, -0.197987, 11.183460>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.328184, 0.170889, 11.183775>, <0.230942, 0.170889, 11.129052>, <-0.230942, 0.170889, 11.129052>, <-0.328184, 0.170889, 11.183775>, 
      <0.229738, 0.172464, 11.239176>, <0.132496, 0.172464, 11.184453>, <-0.132496, 0.172464, 11.184453>, <-0.229738, 0.172464, 11.239176>, 
      <0.098455, 0.170889, 11.313056>, <0.098455, 0.170889, 11.313056>, <-0.098455, 0.170889, 11.313056>, <-0.098455, 0.170889, 11.313056>, 
      <0.000000, 0.170889, 11.368462>, <0.000000, 0.170889, 11.368462>, <0.000000, 0.170889, 11.368462>, <0.000000, 0.170889, 11.368462>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.328184, 0.170889, 11.553146>, <0.382907, 0.170889, 11.522351>, <0.382907, 0.170889, 11.214570>, <0.328184, 0.170889, 11.183775>, 
      <0.229739, 0.172464, 11.497746>, <0.284462, 0.172464, 11.466951>, <0.284461, 0.172464, 11.269971>, <0.229738, 0.172464, 11.239176>, 
      <0.098455, 0.170889, 11.423867>, <0.098455, 0.170889, 11.423867>, <0.098455, 0.170889, 11.313056>, <0.098455, 0.170889, 11.313056>, 
      <0.000000, 0.170889, 11.368462>, <0.000000, 0.170889, 11.368462>, <0.000000, 0.170889, 11.368462>, <0.000000, 0.170889, 11.368462>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.328184, 0.170889, 11.553146>, <-0.230942, 0.170889, 11.607869>, <0.230942, 0.170889, 11.607869>, <0.328184, 0.170889, 11.553146>, 
      <-0.229739, 0.172464, 11.497746>, <-0.132496, 0.172464, 11.552470>, <0.132496, 0.172464, 11.552470>, <0.229739, 0.172464, 11.497746>, 
      <-0.098455, 0.170889, 11.423867>, <-0.098455, 0.170889, 11.423867>, <0.098455, 0.170889, 11.423867>, <0.098455, 0.170889, 11.423867>, 
      <0.000000, 0.170889, 11.368462>, <0.000000, 0.170889, 11.368462>, <0.000000, 0.170889, 11.368462>, <0.000000, 0.170889, 11.368462>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.328184, 0.170889, 11.553146>, <-0.229739, 0.172464, 11.497746>, <-0.098455, 0.170889, 11.423867>, <0.000000, 0.170889, 11.368462>, 
      <-0.382907, 0.170889, 11.522351>, <-0.284462, 0.172464, 11.466951>, <-0.098455, 0.170889, 11.423867>, <0.000000, 0.170889, 11.368462>, 
      <-0.382907, 0.170889, 11.214570>, <-0.284461, 0.172464, 11.269971>, <-0.098455, 0.170889, 11.313056>, <0.000000, 0.170889, 11.368462>, 
      <-0.328184, 0.170889, 11.183775>, <-0.229738, 0.172464, 11.239176>, <-0.098455, 0.170889, 11.313056>, <0.000000, 0.170889, 11.368462>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.886983, 0.156701, 10.869310>, <0.624166, 0.156701, 10.721410>, <-0.624166, 0.156701, 10.721410>, <-0.886983, 0.156701, 10.869310>, 
      <0.724272, 0.203199, 10.960875>, <0.461456, 0.203199, 10.812975>, <-0.461456, 0.203199, 10.812975>, <-0.724272, 0.203199, 10.960875>, 
      <0.495848, 0.168207, 11.089422>, <0.398606, 0.168207, 11.034698>, <-0.398606, 0.168207, 11.034698>, <-0.495848, 0.168207, 11.089422>, 
      <0.328184, 0.170889, 11.183775>, <0.230942, 0.170889, 11.129052>, <-0.230942, 0.170889, 11.129052>, <-0.328184, 0.170889, 11.183775>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.886983, 0.156701, 11.867611>, <1.034883, 0.156701, 11.784380>, <1.034883, 0.156701, 10.952542>, <0.886983, 0.156701, 10.869310>, 
      <0.724272, 0.203199, 11.776046>, <0.872173, 0.203199, 11.692815>, <0.872173, 0.203199, 11.044106>, <0.724272, 0.203199, 10.960875>, 
      <0.495849, 0.168207, 11.647499>, <0.550572, 0.168207, 11.616704>, <0.550571, 0.168207, 11.120216>, <0.495848, 0.168207, 11.089422>, 
      <0.328184, 0.170889, 11.553146>, <0.382907, 0.170889, 11.522351>, <0.382907, 0.170889, 11.214570>, <0.328184, 0.170889, 11.183775>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.886983, 0.156701, 11.867611>, <-0.624166, 0.156701, 12.015511>, <0.624166, 0.156701, 12.015511>, <0.886983, 0.156701, 11.867611>, 
      <-0.724272, 0.203199, 11.776046>, <-0.461456, 0.203199, 11.923946>, <0.461456, 0.203199, 11.923946>, <0.724272, 0.203199, 11.776046>, 
      <-0.495849, 0.168207, 11.647499>, <-0.398606, 0.168207, 11.702222>, <0.398606, 0.168207, 11.702222>, <0.495849, 0.168207, 11.647499>, 
      <-0.328184, 0.170889, 11.553146>, <-0.230942, 0.170889, 11.607869>, <0.230942, 0.170889, 11.607869>, <0.328184, 0.170889, 11.553146>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.886983, 0.156701, 11.867611>, <-0.724272, 0.203199, 11.776046>, <-0.495849, 0.168207, 11.647499>, <-0.328184, 0.170889, 11.553146>, 
      <-1.034883, 0.156701, 11.784380>, <-0.872173, 0.203199, 11.692815>, <-0.550572, 0.168207, 11.616704>, <-0.382907, 0.170889, 11.522351>, 
      <-1.034883, 0.156701, 10.952542>, <-0.872173, 0.203199, 11.044106>, <-0.550571, 0.168207, 11.120216>, <-0.382907, 0.170889, 11.214570>, 
      <-0.886983, 0.156701, 10.869310>, <-0.724272, 0.203199, 10.9608