//  Persistence of Vision Raytracer V3.1
//  World definition file.
//
//  Contains 3 lights, 6 materials and 78 primitives.
//
//  This file was generated for POV-Ray V3.1 by
//  Moray V3.2 For Windows Copyright (c) 1993-2000 Lutz + Kretzschmar
//

//  Date : 12/22/2000    (22.12.2000)
//

/*
  The text between these two comments is in MorayPOV.INC and is
  automatically included in all POV files that Moray exports.
*/

default {
  texture {
    pigment { rgb <1,0,0> }
  }
}

/* // Scene Comment

This scene was created with Moray V3.2 For Windows.
Comment merged from puerta.mdl:
This scene was created with Moray For Windows.

*/ // End Scene Comment

global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.9
  hf_gray_16 off
  irid_wavelength <0.247059,0.176471,0.137255>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
  radiosity {
    brightness       3.3
    count            100
    distance_maximum 0.0
    error_bound      0.4
    gray_threshold   0.5
    low_error_factor 0.8
    minimum_reuse    0.015
    nearest_count    6
    recursion_limit  1
  }
}

background { color <0.000,0.000,0.000> }

camera {  //  Camera StdCam
  location  <     -1.648,     -20.000,      10.115>
  sky       <    0.00000,     0.00000,     1.00000> // Use right handed-system 
  up        <        0.0,         0.0,         1.0> // Where Z is up
  right     <    0.73174,         0.0,         0.0> // Right Vector is adjusted to compensate for spherical (Moray) vs. planar (POV-Ray) aspect ratio
  angle         34.29500    // Vertical      45.727
  look_at   <      5.305,      37.009,       4.617>
}

//    Other cameras are commented out.
/*
camera {  //  Camera SpotCam001
  location  <     14.284,      14.288,      67.825> // Attached to Spotlight001
  sky       <    0.00000,     0.00000,     1.00000> // Use right handed-system 
  up        <        0.0,         0.0,         1.0> // Where Z is up
  right     <    1.68252,         0.0,         0.0> // Right Vector is adjusted to compensate for spherical (Moray) vs. planar (POV-Ray) aspect ratio
  angle        115.63354    // Vertical      86.725
  look_at   <     13.880,      14.306,      66.910> // Following Spotlight001
}

*/

/*
camera {  //  Camera SpotCam002
  location  <     26.321,      58.926,      69.042> // Attached to Spotlight002
  sky       <    0.00000,     0.00000,     1.00000> // Use right handed-system 
  up        <        0.0,         0.0,         1.0> // Where Z is up
  right     <    1.68252,         0.0,         0.0> // Right Vector is adjusted to compensate for spherical (Moray) vs. planar (POV-Ray) aspect ratio
  angle        115.63354    // Vertical      86.725
  look_at   <     25.917,      58.969,      68.128> // Following Spotlight002
}

*/

/*
camera {  //  Camera StdCam1
  location  <    -12.000,     -20.000,      15.000>
  sky       <    0.00000,     0.00000,     1.00000> // Use right handed-system 
  up        <        0.0,         0.0,         1.0> // Where Z is up
  right     <    1.35836,         0.0,         0.0> // Right Vector is adjusted to compensate for spherical (Moray) vs. planar (POV-Ray) aspect ratio
  angle         40.00000    // Vertical      30.000
  look_at   <      0.000,       0.000,       0.000>
}

*/

//
// *******  L I G H T S *******
//

light_source {   // Spotlight Spotlight001
  <0.0, 0.0, 0.0>
  color rgb <1.000, 0.950, 0.650>*1.5000
  spotlight
    point_at  <0.0, 0.0, -2.000>
    falloff    50.000  // outer radius (in deg)
    radius     40.000  // inner radius
    tightness  0.000
  rotate <-178.75444, -203.805801, -179.497223>
  translate  <14.284001, 14.287903, 67.824834>
}

light_source {   // Spotlight Spotlight002
  <0.0, 0.0, 0.0>
  color rgb <1.000, 0.950, 0.650>
  spotlight
    point_at  <0.0, 0.0, -2.000>
    falloff    50.000  // outer radius (in deg)
    radius     40.000  // inner radius
    tightness  0.000
  rotate <182.99968, -203.781845, -178.789368>
  translate  <26.320513, 58.925561, 69.04179>
}

light_source {   // Light1
  <0.0, 0.0, 0.0>
  color rgb <0.500, 0.500, 0.500>*0.3000
  fade_distance  15.0
  fade_power 2.0
  translate  <0.0, -20.0, 20.0>
}


//
// ********  MATERIALS  *******
//

#include "eschereflejo.inc"


//
// ********  REFERENCED OBJECTS  *******
//

#declare sPatchObj1 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.631823, 0.515584, 0.387097>, <0.778964, 0.405818, 0.387097>, <0.778964, -0.317322, 0.387097>, <0.631823, -0.427088, 0.387097>, 
      <0.631823, 0.515584, 0.387097>, <0.581723, 0.552959, 0.387097>, <0.417301, -0.032531, 0.495647>, <0.270160, -0.142298, 0.495647>, 
      <0.631823, 0.515584, 0.387097>, <0.581723, 0.552959, 0.387097>, <-0.061468, 0.394520, 0.499084>, <-0.258709, 0.247379, 0.499084>, 
      <0.631823, 0.515584, 0.387097>, <0.434582, 0.662725, 0.387097>, <-0.434582, 0.662725, 0.387097>, <-0.631823, 0.515584, 0.387097>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.631823, -0.427088, 0.387097>, <-0.778964, -0.317322, 0.387097>, <-0.778964, 0.405818, 0.387097>, <-0.631823, 0.515584, 0.387097>, 
      <-0.631823, -0.427088, 0.387097>, <-0.581723, -0.464463, 0.387097>, <-0.405850, 0.137613, 0.499084>, <-0.258709, 0.247379, 0.499084>, 
      <-0.631823, -0.427088, 0.387097>, <-0.581723, -0.464463, 0.387097>, <0.072918, -0.289439, 0.495647>, <0.270160, -0.142298, 0.495647>, 
      <-0.631823, -0.427088, 0.387097>, <-0.434582, -0.574229, 0.387097>, <0.434582, -0.574229, 0.387097>, <0.631823, -0.427088, 0.387097>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.657895, 0.500000, -0.349010>, <0.650073, 0.504675, 0.116129>, <0.639645, 0.510909, 0.270968>, <0.631823, 0.515584, 0.387097>, 
      <0.453892, 0.655042, -0.349010>, <0.446070, 0.659717, 0.116129>, <0.442403, 0.658050, 0.270968>, <0.434582, 0.662725, 0.387097>, 
      <-0.453892, 0.655042, -0.349010>, <-0.446070, 0.659717, 0.116129>, <-0.526477, 0.728782, 0.359515>, <-0.434582, 0.662725, 0.387097>, 
      <-0.657895, 0.500000, -0.349010>, <-0.650073, 0.504675, 0.116129>, <-0.723718, 0.581641, 0.359515>, <-0.631823, 0.515584, 0.387097>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.657895, -0.500000, -0.349010>, <0.650073, -0.478126, 0.116129>, <0.722384, -0.498400, 0.359916>, <0.631823, -0.427088, 0.387097>, 
      <0.812937, -0.382168, -0.349010>, <0.805116, -0.360294, 0.116129>, <0.869525, -0.388634, 0.359916>, <0.778964, -0.317322, 0.387097>, 
      <0.812937, 0.382168, -0.349010>, <0.805116, 0.386843, 0.116129>, <0.786786, 0.401143, 0.270968>, <0.778964, 0.405818, 0.387097>, 
      <0.657895, 0.500000, -0.349010>, <0.650073, 0.504675, 0.116129>, <0.639645, 0.510909, 0.270968>, <0.631823, 0.515584, 0.387097>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.657895, -0.500000, -0.349010>, <-0.650073, -0.478126, 0.116129>, <-0.639645, -0.448962, 0.270968>, <-0.631823, -0.427088, 0.387097>, 
      <-0.453892, -0.655042, -0.349010>, <-0.446070, -0.633169, 0.116129>, <-0.442403, -0.596103, 0.270968>, <-0.434582, -0.574229, 0.387097>, 
      <0.453892, -0.655042, -0.349010>, <0.446070, -0.633169, 0.116129>, <0.525143, -0.645541, 0.359916>, <0.434582, -0.574229, 0.387097>, 
      <0.657895, -0.500000, -0.349010>, <0.650073, -0.478126, 0.116129>, <0.722384, -0.498400, 0.359916>, <0.631823, -0.427088, 0.387097>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.657895, -0.500000, -0.349010>, <-0.812937, -0.382168, -0.349010>, <-0.812937, 0.382168, -0.349010>, <-0.657895, 0.500000, -0.349010>, 
      <-0.650073, -0.478126, 0.116129>, <-0.805116, -0.360294, 0.116129>, <-0.805116, 0.386843, 0.116129>, <-0.650073, 0.504675, 0.116129>, 
      <-0.639645, -0.448962, 0.270968>, <-0.786786, -0.339195, 0.270968>, <-0.870859, 0.471875, 0.359515>, <-0.723718, 0.581641, 0.359515>, 
      <-0.631823, -0.427088, 0.387097>, <-0.778964, -0.317322, 0.387097>, <-0.778964, 0.405818, 0.387097>, <-0.631823, 0.515584, 0.387097>
    }
  }
  scale <1.0, 1.0, 2.0>
  rotate 90.0*z
  translate  <-5.168994, 16.681935, 2.56883>
}
#declare sPatchObj4 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.631823, 0.515584, 0.387097>, <0.778964, 0.405818, 0.387097>, <0.778964, -0.317322, 0.387097>, <0.631823, -0.427088, 0.387097>, 
      <0.631823, 0.515584, 0.387097>, <0.581723, 0.552959, 0.387097>, <0.417301, -0.032531, 0.395141>, <0.270160, -0.142298, 0.395141>, 
      <0.631823, 0.515584, 0.387097>, <0.581723, 0.552959, 0.387097>, <-0.061468, 0.394520, 0.398577>, <-0.258709, 0.247379, 0.398577>, 
      <0.631823, 0.515584, 0.387097>, <0.434582, 0.662725, 0.387097>, <-0.434582, 0.662725, 0.387097>, <-0.631823, 0.515584, 0.387097>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.631823, -0.427088, 0.387097>, <-0.778964, -0.317322, 0.387097>, <-0.778964, 0.405818, 0.387097>, <-0.631823, 0.515584, 0.387097>, 
      <-0.631823, -0.427088, 0.387097>, <-0.581723, -0.464463, 0.387097>, <-0.405850, 0.137613, 0.398577>, <-0.258709, 0.247379, 0.398577>, 
      <-0.631823, -0.427088, 0.387097>, <-0.581723, -0.464463, 0.387097>, <0.072918, -0.289439, 0.395141>, <0.270160, -0.142298, 0.395141>, 
      <-0.631823, -0.427088, 0.387097>, <-0.434582, -0.574229, 0.387097>, <0.434582, -0.574229, 0.387097>, <0.631823, -0.427088, 0.387097>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.657895, 0.500000, -0.349010>, <0.650073, 0.504675, 0.116129>, <0.639645, 0.510909, 0.270968>, <0.631823, 0.515584, 0.387097>, 
      <0.453892, 0.655042, -0.349010>, <0.446070, 0.659717, 0.116129>, <0.442403, 0.658050, 0.270968>, <0.434582, 0.662725, 0.387097>, 
      <-0.453892, 0.655042, -0.349010>, <-0.446070, 0.659717, 0.116129>, <-0.526477, 0.728782, 0.359515>, <-0.434582, 0.662725, 0.387097>, 
      <-0.657895, 0.500000, -0.349010>, <-0.650073, 0.504675, 0.116129>, <-0.723718, 0.581641, 0.359515>, <-0.631823, 0.515584, 0.387097>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.657895, -0.500000, -0.349010>, <0.650073, -0.478126, 0.116129>, <0.722384, -0.498400, 0.359916>, <0.631823, -0.427088, 0.387097>, 
      <0.812937, -0.382168, -0.349010>, <0.805116, -0.360294, 0.116129>, <0.869525, -0.388634, 0.359916>, <0.778964, -0.317322, 0.387097>, 
      <0.812937, 0.382168, -0.349010>, <0.805116, 0.386843, 0.116129>, <0.786786, 0.401143, 0.270968>, <0.778964, 0.405818, 0.387097>, 
      <0.657895, 0.500000, -0.349010>, <0.650073, 0.504675, 0.116129>, <0.639645, 0.510909, 0.270968>, <0.631823, 0.515584, 0.387097>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.657895, -0.500000, -0.349010>, <-0.650073, -0.478126, 0.116129>, <-0.639645, -0.448962, 0.270968>, <-0.631823, -0.427088, 0.387097>, 
      <-0.453892, -0.655042, -0.349010>, <-0.446070, -0.633169, 0.116129>, <-0.442403, -0.596103, 0.270968>, <-0.434582, -0.574229, 0.387097>, 
      <0.453892, -0.655042, -0.349010>, <0.446070, -0.633169, 0.116129>, <0.525143, -0.645541, 0.359916>, <0.434582, -0.574229, 0.387097>, 
      <0.657895, -0.500000, -0.349010>, <0.650073, -0.478126, 0.116129>, <0.722384, -0.498400, 0.359916>, <0.631823, -0.427088, 0.387097>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.657895, -0.500000, -0.349010>, <-0.812937, -0.382168, -0.349010>, <-0.812937, 0.382168, -0.349010>, <-0.657895, 0.500000, -0.349010>, 
      <-0.650073, -0.478126, 0.116129>, <-0.805116, -0.360294, 0.116129>, <-0.805116, 0.386843, 0.116129>, <-0.650073, 0.504675, 0.116129>, 
      <-0.639645, -0.448962, 0.270968>, <-0.786786, -0.339195, 0.270968>, <-0.870859, 0.471875, 0.359515>, <-0.723718, 0.581641, 0.359515>, 
      <-0.631823, -0.427088, 0.387097>, <-0.778964, -0.317322, 0.387097>, <-0.778964, 0.405818, 0.387097>, <-0.631823, 0.515584, 0.387097>
    }
  }
  scale <1.0, 1.0, 2.0>
  rotate 90.0*z
  translate  <-5.168994, 2.5, 3.255127>
}
#declare ventana_resta = difference {
  box { // Cube009
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.0, 1.5>
  }
  box { // Cube010
    <-1, -1, -1>, <1, 1, 1>
    scale <1.2, 0.7, 1.4>
    translate  -0.178254*z
  }
}
#declare ventana = union {
  object { ventana_resta }
  box { // Cube011
    <-1, -1, -1>, <1, 1, 1>
    scale <1.5, 1.0, 0.1>
    translate  -1.60429*z
  }
  material {
    puertasventan_txt
  }
  translate  <7.1, 2.0, 14.146714>
}
#declare puerta = union {
  box { // Cube012
    <-1, -1, -1>, <1, 1, 1>
    scale <2.0, 4.0, 0.5>
    translate  <0.0, -4.0, 0.5>
  }
  cylinder { // Cylndr003
    <0,0,1>, <0,0,0>, 1 
    scale <2.0, 2.0, 1.0>
  }
  scale 2.0
}
#declare puerta1 = union {
  box { // Cube013
    <-1, -1, -1>, <1, 1, 1>
    scale <2.0, 4.0, 0.5>
    translate  <0.0, -4.0, 0.5>
  }
  cylinder { // Cylndr004
    <0,0,1>, <0,0,0>, 1 
    scale <2.0, 2.0, 1.0>
  }
  scale <1.5, 1.8, 3.0>
  translate  <0.0, -0.713011, -0.5>
}
#declare resta_puerta = difference {
  object { puerta }
  object { puerta1 }
  material {
    puertasventan_txt
  }
  scale 0.4
  rotate <90.0, 0.0, -90.0>
  translate  <-5.656485, 10.091085, 9.891455>
}
#declare ventana_resta1 = union {
  box { // Cube015
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.0, 1.5>
  }
  box { // Cube016
    <-1, -1, -1>, <1, 1, 1>
    scale <1.2, 0.7, 1.4>
    translate  -0.178254*z
  }
}
#declare ventana12 = union {
  object { ventana_resta1 }
  box { // Cube017
    <-1, -1, -1>, <1, 1, 1>
    scale <1.5, 1.0, 0.1>
    translate  -1.60429*z
  }
  material {
    puertasventan_txt
  }
  translate  <7.1, 2.0, 14.146714>
}
#declare puerta2 = union {
  box { // Cube018
    <-1, -1, -1>, <1, 1, 1>
    scale <2.0, 4.0, 0.5>
    translate  <0.0, -4.0, 0.5>
  }
  cylinder { // Cylndr005
    <0,0,1>, <0,0,0>, 1 
    scale <2.0, 2.0, 1.0>
  }
  scale 2.0
}
#declare puerta3 = union {
  box { // Cube019
    <-1, -1, -1>, <1, 1, 1>
    scale <2.0, 4.0, 0.5>
    translate  <0.0, -4.0, 0.5>
  }
  cylinder { // Cylndr006
    <0,0,1>, <0,0,0>, 1 
    scale <2.0, 2.0, 1.0>
  }
  scale <1.5, 1.8, 3.0>
  translate  <0.0, -0.713011, -0.5>
}
#declare resta_puerta6 = union {
  object { puerta2 }
  object { puerta3 }
  material {
    puertasventan_txt
  }
  scale 0.4
  rotate <90.0, 0.0, -90.0>
  translate  <-5.656485, 10.091085, 9.891455>
}
#declare sPatchObj9 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.631823, 0.515584, 0.387097>, <0.778964, 0.405818, 0.387097>, <0.778964, -0.317322, 0.387097>, <0.631823, -0.427088, 0.387097>, 
      <0.631823, 0.515584, 0.387097>, <0.581723, 0.552959, 0.387097>, <0.417301, -0.032531, 0.495647>, <0.270160, -0.142298, 0.495647>, 
      <0.631823, 0.515584, 0.387097>, <0.581723, 0.552959, 0.387097>, <-0.061468, 0.394520, 0.499084>, <-0.258709, 0.247379, 0.499084>, 
      <0.631823, 0.515584, 0.387097>, <0.434582, 0.662725, 0.387097>, <-0.434582, 0.662725, 0.387097>, <-0.631823, 0.515584, 0.387097>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.631823, -0.427088, 0.387097>, <-0.778964, -0.317322, 0.387097>, <-0.778964, 0.405818, 0.387097>, <-0.631823, 0.515584, 0.387097>, 
      <-0.631823, -0.427088, 0.387097>, <-0.581723, -0.464463, 0.387097>, <-0.405850, 0.137613, 0.499084>, <-0.258709, 0.247379, 0.499084>, 
      <-0.631823, -0.427088, 0.387097>, <-0.581723, -0.464463, 0.387097>, <0.072918, -0.289439, 0.495647>, <0.270160, -0.142298, 0.495647>, 
      <-0.631823, -0.427088, 0.387097>, <-0.434582, -0.574229, 0.387097>, <0.434582, -0.574229, 0.387097>, <0.631823, -0.427088, 0.387097>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.657895, 0.500000, -0.349010>, <0.650073, 0.504675, 0.116129>, <0.639645, 0.510909, 0.270968>, <0.631823, 0.515584, 0.387097>, 
      <0.453892, 0.655042, -0.349010>, <0.446070, 0.659717, 0.116129>, <0.442403, 0.658050, 0.270968>, <0.434582, 0.662725, 0.387097>, 
      <-0.453892, 0.655042, -0.349010>, <-0.446070, 0.659717, 0.116129>, <-0.526477, 0.728782, 0.359515>, <-0.434582, 0.662725, 0.387097>, 
      <-0.657895, 0.500000, -0.349010>, <-0.650073, 0.504675, 0.116129>, <-0.723718, 0.581641, 0.359515>, <-0.631823, 0.515584, 0.387097>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.657895, -0.500000, -0.349010>, <0.650073, -0.478126, 0.116129>, <0.722384, -0.498400, 0.359916>, <0.631823, -0.427088, 0.387097>, 
      <0.812937, -0.382168, -0.349010>, <0.805116, -0.360294, 0.116129>, <0.869525, -0.388634, 0.359916>, <0.778964, -0.317322, 0.387097>, 
      <0.812937, 0.382168, -0.349010>, <0.805116, 0.386843, 0.116129>, <0.786786, 0.401143, 0.270968>, <0.778964, 0.405818, 0.387097>, 
      <0.657895, 0.500000, -0.349010>, <0.650073, 0.504675, 0.116129>, <0.639645, 0.510909, 0.270968>, <0.631823, 0.515584, 0.387097>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.657895, -0.500000, -0.349010>, <-0.650073, -0.478126, 0.116129>, <-0.639645, -0.448962, 0.270968>, <-0.631823, -0.427088, 0.387097>, 
      <-0.453892, -0.655042, -0.349010>, <-0.446070, -0.633169, 0.116129>, <-0.442403, -0.596103, 0.270968>, <-0.434582, -0.574229, 0.387097>, 
      <0.453892, -0.655042, -0.349010>, <0.446070, -0.633169, 0.116129>, <0.525143, -0.645541, 0.359916>, <0.434582, -0.574229, 0.387097>, 
      <0.657895, -0.500000, -0.349010>, <0.650073, -0.478126, 0.116129>, <0.722384, -0.498400, 0.359916>, <0.631823, -0.427088, 0.387097>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.657895, -0.500000, -0.349010>, <-0.812937, -0.382168, -0.349010>, <-0.812937, 0.382168, -0.349010>, <-0.657895, 0.500000, -0.349010>, 
      <-0.650073, -0.478126, 0.116129>, <-0.805116, -0.360294, 0.116129>, <-0.805116, 0.386843, 0.116129>, <-0.650073, 0.504675, 0.116129>, 
      <-0.639645, -0.448962, 0.270968>, <-0.786786, -0.339195, 0.270968>, <-0.870859, 0.471875, 0.359515>, <-0.723718, 0.581641, 0.359515>, 
      <-0.631823, -0.427088, 0.387097>, <-0.778964, -0.317322, 0.387097>, <-0.778964, 0.405818, 0.387097>, <-0.631823, 0.515584, 0.387097>
    }
  }
  scale <1.0, 1.0, 2.0>
  rotate 90.0*z
  translate  <-5.168994, 16.681935, 2.56883>
}




//
// ********  OBJECTS  *******
//

#declare sPatchObj3 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.631823, 0.515584, 0.387097>, <0.778964, 0.405818, 0.387097>, <0.778964, -0.317322, 0.387097>, <0.631823, -0.427088, 0.387097>, 
      <0.631823, 0.515584, 0.387097>, <0.581723, 0.552959, 0.387097>, <0.417301, -0.032531, 0.495647>, <0.270160, -0.142298, 0.495647>, 
      <0.631823, 0.515584, 0.387097>, <0.581723, 0.552959, 0.387097>, <-0.061468, 0.394520, 0.499084>, <-0.258709, 0.247379, 0.499084>, 
      <0.631823, 0.515584, 0.387097>, <0.434582, 0.662725, 0.387097>, <-0.434582, 0.662725, 0.387097>, <-0.631823, 0.515584, 0.387097>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.631823, -0.427088, 0.387097>, <-0.778964, -0.317322, 0.387097>, <-0.778964, 0.405818, 0.387097>, <-0.631823, 0.515584, 0.387097>, 
      <-0.631823, -0.427088, 0.387097>, <-0.581723, -0.464463, 0.387097>, <-0.405850, 0.137613, 0.499084>, <-0.258709, 0.247379, 0.499084>, 
      <-0.631823, -0.427088, 0.387097>, <-0.581723, -0.464463, 0.387097>, <0.072918, -0.289439, 0.495647>, <0.270160, -0.142298, 0.495647>, 
      <-0.631823, -0.427088, 0.387097>, <-0.434582, -0.574229, 0.387097>, <0.434582, -0.574229, 0.387097>, <0.631823, -0.427088, 0.387097>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.657895, 0.500000, -0.756189>, <0.650073, 0.504675, 0.116129>, <0.639645, 0.510909, 0.270968>, <0.631823, 0.515584, 0.387097>, 
      <0.453892, 0.655042, -0.756189>, <0.446070, 0.659717, 0.116129>, <0.442403, 0.658050, 0.270968>, <0.434582, 0.662725, 0.387097>, 
      <-0.453892, 0.655042, -0.756189>, <-0.446070, 0.659717, 0.116129>, <-0.526477, 0.728782, 0.359515>, <-0.434582, 0.662725, 0.387097>, 
      <-0.657895, 0.500000, -0.756189>, <-0.650073, 0.504675, 0.116129>, <-0.723718, 0.581641, 0.359515>, <-0.631823, 0.515584, 0.387097>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.657895, -0.500000, -0.756189>, <0.650073, -0.478126, 0.116129>, <0.722384, -0.498400, 0.359916>, <0.631823, -0.427088, 0.387097>, 
      <0.812937, -0.382168, -0.756189>, <0.805116, -0.360294, 0.116129>, <0.869525, -0.388634, 0.359916>, <0.778964, -0.317322, 0.387097>, 
      <0.812937, 0.382168, -0.756189>, <0.805116, 0.386843, 0.116129>, <0.786786, 0.401143, 0.270968>, <0.778964, 0.405818, 0.387097>, 
      <0.657895, 0.500000, -0.756189>, <0.650073, 0.504675, 0.116129>, <0.639645, 0.510909, 0.270968>, <0.631823, 0.515584, 0.387097>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.657895, -0.500000, -0.756189>, <-0.650073, -0.478126, 0.116129>, <-0.639645, -0.448962, 0.270968>, <-0.631823, -0.427088, 0.387097>, 
      <-0.453892, -0.655042, -0.756189>, <-0.446070, -0.633169, 0.116129>, <-0.442403, -0.596103, 0.270968>, <-0.434582, -0.574229, 0.387097>, 
      <0.453892, -0.655042, -0.756189>, <0.446070, -0.633169, 0.116129>, <0.525143, -0.645541, 0.359916>, <0.434582, -0.574229, 0.387097>, 
      <0.657895, -0.500000, -0.756189>, <0.650073, -0.478126, 0.116129>, <0.722384, -0.498400, 0.359916>, <0.631823, -0.427088, 0.387097>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.657895, -0.500000, -0.756189>, <-0.812937, -0.382168, -0.756189>, <-0.812937, 0.382168, -0.756189>, <-0.657895, 0.500000, -0.756189>, 
      <-0.650073, -0.478126, 0.116129>, <-0.805116, -0.360294, 0.116129>, <-0.805116, 0.386843, 0.116129>, <-0.650073, 0.504675, 0.116129>, 
      <-0.639645, -0.448962, 0.270968>, <-0.786786, -0.339195, 0.270968>, <-0.870859, 0.471875, 0.359515>, <-0.723718, 0.581641, 0.359515>, 
      <-0.631823, -0.427088, 0.387097>, <-0.778964, -0.317322, 0.387097>, <-0.778964, 0.405818, 0.387097>, <-0.631823, 0.515584, 0.387097>
    }
  }
  scale <1.0, 1.0, 2.0>
  rotate 90.0*z
  translate  <-5.168994, 15.081629, 3.494933>
}
#declare piedras = union {
  object { // sPatchObj2->sPatchObj1
    sPatchObj1
    rotate <-0.0, 0.0, -0.0>
    translate  <0.0, -3.185795, 0.170403>
  }
  object { sPatchObj3 }
  object { sPatchObj1 }
  object { sPatchObj4 }
  object { // sPatchObj5->sPatchObj4
    sPatchObj4
    rotate -0.0*x
    translate  <0.0, 1.656852, -0.0>
  }
  object { // sPatchObj6->sPatchObj4
    sPatchObj4
    rotate -0.0*x
    translate  <0.0, 3.199321, -0.0>
  }
  material {
    piedra_txt
  }
  rotate -10.5*z
}
#declare resta_arco = union {
  cylinder { // Cylndr001
    <0,0,1>, <0,0,0>, 1 
    material {
      paredes_txt
    }
    scale <1.0, 1.0, 4.0>
    rotate -90.0*x
    translate  <0.0, 37.0, 9.062692>
  }
  box { // Cube003
    <-1, -1, -1>, <1, 1, 1>
    material {
      paredes_txt
    }
    scale <1.0, 2.0, 5.0>
    translate  <0.0, 39.0, 4.0>
  }
  scale <2.806716, 2.0, 2.896352>
  translate  <-3.0, -39.22879, -11.529306>
}
#declare pared_arco = difference {
  box { // Cube002
    <-1, -1, -1>, <1, 1, 1>
    scale <10.0, 2.0, 50.0>
    translate  <2.835675, 38.949755, 49.0>
  }
  object { resta_arco }
  box { // Cube020
    <-1, -1, -1>, <1, 1, 1>
    material {
      negro_txt
    }
    scale <0.5, 1.0, 1.5>
    rotate -90.0*z
    translate  <-3.000282, 37.397142, 21.14671>
  }
  material {
    paredes_txt
  }
  scale <1.0, 2.0, 1.0>
  translate  -42.780296*y
}
#declare pared_ventanas = union {
  object { ventana }
  object { // ventana1->ventana
    ventana
    rotate -0.0*z
    translate  <0.0, 62.0, -4.91891>
  }
  object { // ventana2->ventana
    ventana
    rotate -0.0*z
    translate  <0.0, 55.0, -2.888884>
  }
  object { // ventana3->ventana
    ventana
    rotate -0.0*z
    translate  <-0.0, 13.450443, 1.951948>
  }
  object { // ventana4->ventana
    ventana
    rotate -0.0*z
    translate  <-0.0, 21.681664, -0.156156>
  }
  object { // ventana5->ventana
    ventana
    rotate -0.0*z
    translate  <0.0, 26.0, 7.0>
  }
  object { // ventana6->ventana
    ventana
    rotate -0.0*z
    translate  <0.0, 24.0, 7.0>
  }
  object { // ventana7->ventana
    ventana
    rotate -0.0*z
    translate  <-0.0, 26.387378, -0.234234>
  }
  object { // ventana8->ventana
    ventana
    rotate -0.0*z
    translate  <-0.0, 35.165145, -0.312312>
  }
  object { // ventana9->ventana
    ventana
    rotate -0.0*z
    translate  50.0*y
  }
  object { // ventana11->ventana
    ventana
    rotate -0.0*z
    translate  <0.0, 60.0, 3.0>
  }
  translate  <-13.815597, -2.560569, 0.0>
}
#declare puerta4 = union {
  box { // Cube021
    <-1, -1, -1>, <1, 1, 1>
    scale <2.0, 4.0, 0.5>
    translate  <0.0, -4.0, 0.5>
  }
  cylinder { // Cylndr007
    <0,0,1>, <0,0,0>, 1 
    scale <2.0, 2.0, 1.0>
  }
  scale 2.0
}
#declare puerta5 = union {
  box { // Cube022
    <-1, -1, -1>, <1, 1, 1>
    scale <2.0, 4.0, 0.5>
    translate  <0.0, -4.0, 0.5>
  }
  cylinder { // Cylndr008
    <0,0,1>, <0,0,0>, 1 
    scale <2.0, 2.0, 1.0>
  }
  scale <1.5, 1.8, 3.0>
  translate  <0.0, -0.713011, -0.5>
}
#declare resta_puerta12 = difference {
  object { puerta4 }
  object { puerta5 }
  material {
    puertasventan_txt
  }
  scale <0.3, 0.35, 0.3>
  rotate <90.0, 0.0, -90.0>
  translate  <-5.75, 10.116666, 9.533323>
}
#declare puerta1a = difference {
  box { // Cube001
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.8, 4.0>
    translate  <-6.327625, 6.11051, 8.115521>
  }
  box { // Cube024
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.4, 3.6>
    translate  <-6.063974, 6.11051, 8.115521>
  }
  material {
    puertasventan_txt
  }
  translate  <-0.275, -2.0, 0.0>
}
#declare puertas = union {
  object { resta_puerta }
  object { // resta_puerta1->resta puerta
    resta_puerta
    rotate <0.0, -0.0, 0.0>
    translate  <0.0, 5.0, 0.917371>
  }
  object { // resta_puerta2->resta puerta
    resta_puerta
    scale 0.8
    rotate -0.0*y
    translate  <-1.171819, 15.274885, 0.0>
  }
  object { // resta_puerta3->resta puerta
    resta_puerta
    scale 0.8
    rotate -0.0*y
    translate  <-1.140828, 26.925828, 0.0>
  }
  object { // resta_puerta4->resta puerta
    resta_puerta
    scale 0.8
    rotate -0.0*y
    translate  <-1.075, 38.57677, -1.146714>
  }
  object { // resta_puerta5->resta puerta
    resta_puerta
    scale 0.8
    rotate -0.0*y
    translate  <-1.151199, 48.163627, -2.064086>
  }
  object { resta_puerta12 }
  object { puerta1a }
}
#declare puertas1 = union {
  object { resta_puerta6 }
  object { // resta_puerta7->resta puerta6
    resta_puerta6
    rotate <0.0, -0.0, 0.0>
    translate  <0.0, 5.0, 0.917371>
  }
  object { // resta_puerta8->resta puerta6
    resta_puerta6
    scale 0.8
    rotate -0.0*y
    translate  <-1.171819, 15.274885, 0.0>
  }
  object { // resta_puerta9->resta puerta6
    resta_puerta6
    scale 0.8
    rotate -0.0*y
    translate  <-1.140828, 26.925828, 0.0>
  }
  object { // resta_puerta10->resta puerta6
    resta_puerta6
    scale 0.8
    rotate -0.0*y
    translate  <-1.075, 38.57677, -1.146714>
  }
  object { // resta_puerta11->resta puerta6
    resta_puerta6
    scale 0.8
    rotate -0.0*y
    translate  <-1.151199, 48.163627, -2.064086>
  }
  translate  <13.815597, 2.560569, 0.0>
}
#declare pared_ventanas1 = difference {
  box { // Cube014
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 100.0, 25.0>
    translate  <7.022944, 74.975644, 24.0>
  }
  object { ventana12 }
  object { // ventana13->ventana12
    ventana12
    rotate -0.0*z
    translate  <0.0, 62.0, -4.91891>
  }
  object { // ventana14->ventana12
    ventana12
    rotate -0.0*z
    translate  <0.0, 55.0, -2.888884>
  }
  object { // ventana15->ventana12
    ventana12
    rotate -0.0*z
    translate  <-0.0, 13.450443, 1.951948>
  }
  object { // ventana16->ventana12
    ventana12
    rotate -0.0*z
    translate  <-0.0, 21.681664, -0.156156>
  }
  object { // ventana17->ventana12
    ventana12
    rotate -0.0*z
    translate  <0.0, 26.0, 7.0>
  }
  object { // ventana18->ventana12
    ventana12
    rotate -0.0*z
    translate  <0.0, 24.0, 7.0>
  }
  object { // ventana19->ventana12
    ventana12
    rotate -0.0*z
    translate  <-0.0, 26.387378, -0.234234>
  }
  object { // ventana20->ventana12
    ventana12
    rotate -0.0*z
    translate  <-0.0, 35.165145, -0.312312>
  }
  object { // ventana21->ventana12
    ventana12
    rotate -0.0*z
    translate  50.0*y
  }
  object { // ventana22->ventana12
    ventana12
    rotate -0.0*z
    translate  <0.0, 60.0, 3.0>
  }
  object { puertas1 }
  box { // Cube023
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.5, 4.0>
    translate  <7.487971, 6.67108, 8.115521>
  }
  material {
    paredes_txt
  }
  translate  <-13.815597, -2.560569, 0.0>
}
#declare paed_edificio = union {
  object { pared_arco }
  object { pared_ventanas }
  object { // ventana10->ventana
    ventana
    rotate -90.0*z
    translate  <-5.0, 39.117139, 7.0>
  }
  object { puertas }
  object { pared_ventanas1 }
  rotate -10.5*z
}
#declare sPatchObj8 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.631823, 0.515584, 0.387097>, <0.778964, 0.405818, 0.387097>, <0.778964, -0.317322, 0.387097>, <0.631823, -0.427088, 0.387097>, 
      <0.631823, 0.515584, 0.387097>, <0.581723, 0.552959, 0.387097>, <0.417301, -0.032531, 0.495647>, <0.270160, -0.142298, 0.495647>, 
      <0.631823, 0.515584, 0.387097>, <0.581723, 0.552959, 0.387097>, <-0.061468, 0.394520, 0.499084>, <-0.258709, 0.247379, 0.499084>, 
      <0.631823, 0.515584, 0.387097>, <0.434582, 0.662725, 0.387097>, <-0.434582, 0.662725, 0.387097>, <-0.631823, 0.515584, 0.387097>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.631823, -0.427088, 0.387097>, <-0.778964, -0.317322, 0.387097>, <-0.778964, 0.405818, 0.387097>, <-0.631823, 0.515584, 0.387097>, 
      <-0.631823, -0.427088, 0.387097>, <-0.581723, -0.464463, 0.387097>, <-0.405850, 0.137613, 0.499084>, <-0.258709, 0.247379, 0.499084>, 
      <-0.631823, -0.427088, 0.387097>, <-0.581723, -0.464463, 0.387097>, <0.072918, -0.289439, 0.495647>, <0.270160, -0.142298, 0.495647>, 
      <-0.631823, -0.427088, 0.387097>, <-0.434582, -0.574229, 0.387097>, <0.434582, -0.574229, 0.387097>, <0.631823, -0.427088, 0.387097>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.657895, 0.500000, -0.756189>, <0.650073, 0.504675, 0.116129>, <0.639645, 0.510909, 0.270968>, <0.631823, 0.515584, 0.387097>, 
      <0.453892, 0.655042, -0.756189>, <0.446070, 0.659717, 0.116129>, <0.442403, 0.658050, 0.270968>, <0.434582, 0.662725, 0.387097>, 
      <-0.453892, 0.655042, -0.756189>, <-0.446070, 0.659717, 0.116129>, <-0.526477, 0.728782, 0.359515>, <-0.434582, 0.662725, 0.387097>, 
      <-0.657895, 0.500000, -0.756189>, <-0.650073, 0.504675, 0.116129>, <-0.723718, 0.581641, 0.359515>, <-0.631823, 0.515584, 0.387097>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.657895, -0.500000, -0.756189>, <0.650073, -0.478126, 0.116129>, <0.722384, -0.498400, 0.359916>, <0.631823, -0.427088, 0.387097>, 
      <0.812937, -0.382168, -0.756189>, <0.805116, -0.360294, 0.116129>, <0.869525, -0.388634, 0.359916>, <0.778964, -0.317322, 0.387097>, 
      <0.812937, 0.382168, -0.756189>, <0.805116, 0.386843, 0.116129>, <0.786786, 0.401143, 0.270968>, <0.778964, 0.405818, 0.387097>, 
      <0.657895, 0.500000, -0.756189>, <0.650073, 0.504675, 0.116129>, <0.639645, 0.510909, 0.270968>, <0.631823, 0.515584, 0.387097>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.657895, -0.500000, -0.756189>, <-0.650073, -0.478126, 0.116129>, <-0.639645, -0.448962, 0.270968>, <-0.631823, -0.427088, 0.387097>, 
      <-0.453892, -0.655042, -0.756189>, <-0.446070, -0.633169, 0.116129>, <-0.442403, -0.596103, 0.270968>, <-0.434582, -0.574229, 0.387097>, 
      <0.453892, -0.655042, -0.756189>, <0.446070, -0.633169, 0.116129>, <0.525143, -0.645541, 0.359916>, <0.434582, -0.574229, 0.387097>, 
      <0.657895, -0.500000, -0.756189>, <0.650073, -0.478126, 0.116129>, <0.722384, -0.498400, 0.359916>, <0.631823, -0.427088, 0.387097>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.657895, -0.500000, -0.756189>, <-0.812937, -0.382168, -0.756189>, <-0.812937, 0.382168, -0.756189>, <-0.657895, 0.500000, -0.756189>, 
      <-0.650073, -0.478126, 0.116129>, <-0.805116, -0.360294, 0.116129>, <-0.805116, 0.386843, 0.116129>, <-0.650073, 0.504675, 0.116129>, 
      <-0.639645, -0.448962, 0.270968>, <-0.786786, -0.339195, 0.270968>, <-0.870859, 0.471875, 0.359515>, <-0.723718, 0.581641, 0.359515>, 
      <-0.631823, -0.427088, 0.387097>, <-0.778964, -0.317322, 0.387097>, <-0.778964, 0.405818, 0.387097>, <-0.631823, 0.515584, 0.387097>
    }
  }
  scale <1.0, 1.0, 2.0>
  rotate 90.0*z
  translate  <-5.168994, 15.081629, 3.494933>
}
#declare piedras1 = union {
  object { // sPatchObj7->sPatchObj9
    sPatchObj9
    rotate <-0.0, 0.0, -0.0>
    translate  <0.0, -3.185795, 0.170403>
  }
  object { sPatchObj8 }
  object { sPatchObj9 }
  material {
    piedra_txt
  }
  rotate -10.5*z
  translate  <3.5, 19.5, -1.643811>
}
union { // superpared
  object { piedras }
  object { paed_edificio }
  object { piedras1 }
  rotate -5.0*z
}


#declare BezPtch001 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-3.000000, -3.000000, 0.000000>, <-2.000000, -3.000000, 0.000000>, <-1.000000, -3.000000, 0.000000>, <0.000000, -3.000000, 0.000000>, 
      <-3.000000, -2.000000, 0.423601>, <-2.000000, -2.000000, 0.423601>, <-1.000000, -2.000000, 0.423601>, <0.000000, -2.000000, 0.423601>, 
      <-3.000000, -1.000000, 0.000000>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.000000, -0.510456, 0.007564>, <-2.000000, -0.510456, 0.007564>, <-1.000000, -0.510456, 0.007564>, <0.000000, -0.510456, 0.007564>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-3.000000, -0.510456, 0.007564>, <-2.000000, -0.510456, 0.007564>, <-1.000000, -0.510456, 0.007564>, <0.000000, -0.510456, 0.007564>, 
      <-3.000000, -0.020912, 0.015129>, <-2.000000, -0.020912, 0.015129>, <-1.000000, -0.020912, 0.015129>, <0.000000, -0.020912, 0.015129>, 
      <-3.000000, 0.979088, -0.408472>, <-2.000000, 0.979088, -0.408472>, <-1.000000, 0.979088, -0.408472>, <0.000000, 0.979088, -0.408472>, 
      <-3.000000, 1.979088, -0.408472>, <-2.000000, 1.979088, -0.408472>, <-1.000000, 1.979088, -0.408472>, <0.000000, 1.979088, -0.408472>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, -3.000000, 0.000000>, <1.000000, -3.000000, 0.000000>, <2.000000, -3.000000, 0.000000>, <3.000000, -3.000000, 0.000000>, 
      <0.000000, -2.000000, 0.423601>, <1.000000, -2.000000, 0.423601>, <2.000000, -2.000000, 0.423601>, <3.000000, -2.000000, 0.423601>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.000000, -1.000000, 0.000000>, 
      <0.000000, -0.510456, 0.007564>, <1.000000, -0.510456, 0.007564>, <2.000000, -0.510456, 0.007564>, <3.000000, -0.510456, 0.007564>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, -0.510456, 0.007564>, <1.000000, -0.510456, 0.007564>, <2.000000, -0.510456, 0.007564>, <3.000000, -0.510456, 0.007564>, 
      <0.000000, -0.020912, 0.015129>, <1.000000, -0.020912, 0.015129>, <2.000000, -0.020912, 0.015129>, <3.000000, -0.020912, 0.015129>, 
      <0.000000, 0.979088, -0.408472>, <1.000000, 0.979088, -0.408472>, <2.000000, 0.979088, -0.408472>, <3.000000, 0.979088, -0.408472>, 
      <0.000000, 1.979088, -0.408472>, <1.000000, 1.979088, -0.408472>, <2.000000, 1.979088, -0.408472>, <3.000000, 1.979088, -0.408472>
    }
  }
  scale <11.420828, 11.420828, 5.0>
  translate  <18.631177, 27.271445, 2.078947>
}
union { // suelo
  plane { // Plane001
    z,0
  }
  object { BezPtch001 }
  material {
    suelo_txt
  }
}


#declare resta_arco1 = union {
  cylinder { // Cylndr002
    <0,0,1>, <0,0,0>, 1 
    material {
      paredes_txt
    }
    scale <1.0, 1.0, 4.0>
    rotate -90.0*x
    translate  <0.0, 37.0, 9.062692>
  }
  box { // Cube007
    <-1, -1, -1>, <1, 1, 1>
    material {
      paredes_txt
    }
    scale <1.0, 2.0, 5.0>
    translate  <0.0, 39.0, 4.0>
  }
  material {
    paredes_txt
  }
  scale <5.75, 2.0, 4.0>
  translate  <0.030787, -39.22879, -23.965145>
}
#declare pared_arco1 = difference {
  box { // Cube006
    <-1, -1, -1>, <1, 1, 1>
    material {
      paredes_txt
    }
    scale <10.0, 1.5, 50.0>
    translate  <2.835675, 38.949755, 49.0>
  }
  object { resta_arco1 }
  material {
    paredes_txt
  }
  translate  -37.571139*y
}
union { // primer_plano
  object { pared_arco1 }
  box { // Cube005
    <-1, -1, -1>, <1, 1, 1>
    scale <10.0, 8.0, 6.0>
    rotate 10.0*y
    translate  <15.574364, 7.89, 10.741297>
  }
  box { // Cube008
    <-1, -1, -1>, <1, 1, 1>
    scale <10.0, 8.0, 10.0>
    translate  <14.68424, 7.89, -3.431543>
  }
  cylinder { // Cylndr009
    <0,0,1>, <0,0,0>, 1 
    scale <0.25, 0.25, 3.0>
    rotate -90.0*x
    translate  <5.511498, -0.137091, 12.548076>
  }
  material {
    paredes_txt
  }
  // All transformations fixed
}




box { // Cube004
  <-1, -1, -1>, <1, 1, 1>
  material {
    paredes_txt
  }
  scale <1.0, 20.0, 25.0>
  translate  <6.75788, -16.923341, 24.0>
}






