
// Glenn's POV-Ray Scene File - Brick Maker
// created 11-Dec-00
// last update 30-Dec-00
// 2000 Glenn McCarter (gmccarter@hotmail.com)
//
// Makes a pretty good brick wall

//#include "Colors.inc"
#include "GIncludeRH.inc"
//#include "GRuler.inc"

#version unofficial MegaPov 0.6;
//#version 3.1;

global_settings {
	adc_bailout 0.003922
	ambient_light <1.0,1.0,1.0>
	assumed_gamma 1.0
	hf_gray_16 off
	irid_wavelength <0.25,0.18,0.14>
	max_intersections 64
	max_trace_level 10
	number_of_waves 10
}

//===============================================
//             Variables
//===============================================

#declare WallLength = 40*Feet;
#declare WallHeight = WallLength/1.33333;

// Image must be rendered twice.
// Once for the color map, once (in greyscale) for the height field
#declare ColorOn=0; // turn on color version for color map, otherwise use greys for heightfield


//===============================================
//             Cameras
//===============================================

#declare Closeup_Cam =
	camera {
		perspective
		direction <0.0,     1.0,  0.0>
		sky       <0.0,     0.0,  1.0>  // Use right handed-system
		up        <0.0,     0.0,  1.0>  // Where Z is up
		right     <1.33333, 0.0,  0.0>
//	angle 6
	angle 36
//	location  <0.01*Feet, -30*Feet, 0.01*Feet>
	location  <4.01*Feet, -8*Feet, 4.01*Feet>
//	location  <8.01*Feet, -.61*Feet, 4.01*Feet>
	look_at <0,0,0>
//	location  <WallLength/2, -30*Feet, WallHeight/2>
//	look_at <WallLength/2, 0, WallHeight/2>
}

#declare Parallel_Cam =
	camera {
		orthographic

		sky       <0.0,     0.0,  1.0>  // Use right handed-system
		up        <0.0,     0.0,  WallHeight>  // full wall
		right     <WallLength, 0.0,  0.0>
//		up        <0.0,     0.0,  WallHeight/20>  // test small patch
//		right     <WallLength/20, 0.0,  0.0>
//	location  <WallLength/40, -30*Feet, WallHeight/40> // test
//	look_at <WallLength/10, 0, WallHeight/10>
	location  <WallLength/2, -30*Feet, WallHeight/2> // render
	look_at <WallLength/2, 0, WallHeight/2>
	}

camera {
//	Closeup_Cam
	Parallel_Cam
  }


//===============================================
//             Textures
//===============================================

#declare PlainTex =
	texture {
		pigment { color rgb <1,1,3> }
		finish { ambient .10 specular .65 roughness .125 }
	}
#declare SimpleBrickTex =
	texture {
		pigment {
			brick
				color rgb <0.812,0.776,0.718> // morter
				color rgb <0.553,0.204,0.180> // brick
				brick_size <8,3,4.5>
				mortar 0.4
				rotate x*90
		}
		finish { ambient 0.1 diffuse 0.6 specular 0.3 roughness 0.2 }
	}

#declare RS = seed(95317);
#macro RandomBrickTex()
	#declare Brightness = rand(RS)*0.8+0.2; // range 0.2 to 1.0
	#declare Redness = rand(RS)*0.2+0.7; // range 0.7 to 0.9
//	pigment { color rgb<Redness*Brightness,0.21*Brightness,0.08*Brightness> }
	pigment { color rgb<Redness,0.21,0.08>*Brightness }
#end

#declare BigMortarTex =
	texture {
		pigment {
			bozo
			color_map {
				[ 0.00 color rgb <0.878,0.800,0.694> ]
				[ 1.00 color rgb <0.733,0.667,0.580>*0.5 ]
			}
			scale <6,3,1>
		}
	}

#declare GradientYHFTex =
	texture {
		pigment {
			gradient y
			color_map {
				[ 0.0 color rgb<1,1,1> ]
				[ 1.0 color rgb<0,0,0> ]
			}
		}
		finish { ambient 1.0 diffuse 0.6 specular 0.0 }
	}


//===============================================
//             Lighting
//===============================================

//object {StdBulb60Watt translate <4*Feet,8*Feet,7*Feet> }
//object {StdBulb60Watt translate <-10*Feet,8*Feet,2*Feet> }
#declare MyLight =
	light_source {
		<0,0,0>
		color rgb<1,1,1>
//		fade_distance 12*Feet
//		fade_power 1
	}
//object { MyLight translate <-4*Feet,-4*Feet,8*Feet> } // test
//object { MyLight translate <24*Feet,-1*Feet,24*Feet> } // testr
//object { MyLight translate <12,-4,12> } // test

#if ( ColorOn=1 )
	object { MyLight translate <WallLength/2, -1000*Feet, WallHeight/2> } // render
#end

//===============================================
//             Environment
//===============================================

background { color rgb <0.93, 0.99, 0.4> } // bright yellow


//===============================================
//             Objects
//===============================================

#declare BluSph =
	sphere {
		<0,0,0>,.5
		texture { PlainTex }
		translate <0,0,0.5>
	}

#declare BrickHeight = 3;
#declare BrickLength = 8;
#declare Mortar = 0.5;

#declare MaxGradient=0.999;
#declare H=1.0;
#declare Lacunarity=2.0;
#declare Octaves=5;
#declare Offset=0.0;
#declare T = 0; // '1/f'
#declare F0 =	function { "heteroMF", <H, Lacunarity, Octaves, Offset, T> }
#declare BumpSurface =
	isosurface { 
//		function { "heteroMF", <H, Lacunarity, Octaves, Offset, T> } 
		function{y-F0(x,0,z)}
		contained_by { box { <-10, -4/0.2 ,-5 >, <(WallLength+10)*2, 4.0, WallHeight+5> } }
//		contained_by { box { <0,-4/0.2,0>, <BrickLength*2, 4.0, BrickHeight> } }
		threshold 1.0
		eval
		max_gradient MaxGradient
		accuracy 0.001
//		texture { PlainTex }
		scale <0.5,-.2,1>
	}


#declare SimpleBricks =
	box {
		<0,0,-1>,<WallLength,1,WallHeight>
		texture { SimpleBrickTex }
	}

#declare WallMortar =
	box {
		<0,0,0>,<WallLength,1,WallHeight>
		translate <0,0.4,0>
#if ( ColorOn = 1 )
		texture { BigMortarTex }
#end
//		texture { GradientYHFTex translate <0,-0.2,0> }
// texture it later...
	}

#declare BrickWall =
	union {
		object { WallMortar }
		#declare TotRows = WallHeight/(BrickHeight+Mortar);

		#declare Row = 1; // this section does the odd rows
		#while ( Row < TotRows )
//		#while ( Row < 3 ) // test
			#declare TotBricksPerRow = WallLength/(BrickLength+Mortar);
			#declare BrickCount = 1;
			#while ( BrickCount < TotBricksPerRow )
//			#while ( BrickCount < 3 ) // test
				intersection {
					object { BumpSurface }
					box {
						<-0.1,-0.15,-0.1>,<BrickLength*1.01,4,BrickHeight*1.01>
						translate <BrickCount*(BrickLength+Mortar),0,Row*(BrickHeight+Mortar)>
					}
					translate <0,rand(RS)*0.4,0>
					#if ( ColorOn = 1 )
					texture { RandomBrickTex() }
					#end
				} // end intersection
				#declare BrickCount = BrickCount + 1;
			#end
			#declare Row = Row + 2; // every other row
		#end

		#declare Row = 2; // this section does the even rows
		#while ( Row < TotRows )
//		#while ( Row < 3 ) // test
			#declare TotBricksPerRow = WallLength/(BrickLength+Mortar);
			#declare BrickCount = 1;
			#while ( BrickCount < TotBricksPerRow )
//			#while ( BrickCount < 3 ) // test

				intersection {
					object { BumpSurface }
					box {
						<-0.1,-0.15,-0.1>,<BrickLength*1.01,4,BrickHeight*1.01>
						translate <BrickCount*(BrickLength+Mortar)+BrickLength/2,0,Row*(BrickHeight+Mortar)>
					}
					translate <0,rand(RS)*0.4,0>
					#if ( ColorOn = 1 )
					texture { RandomBrickTex() }
					#end
				} // end intersection

				#declare BrickCount = BrickCount + 1;
			#end
			#declare Row = Row + 2; // every other row

		#end
		#if ( ColorOn = 0 )
			texture { GradientYHFTex scale <1,0.7,1> translate <0,-0.2,0> }
		#end
	} // end union



//===============================================
//             Object Placement
//===============================================

//object { TestSphere scale 2 translate <0,-2,1> }
/*
object { BluSph scale 2 translate <3.6*Feet,-7.0*Feet,3.6*Feet> }
object { BluSph scale 5 translate <30,-30,0> }
object { BluSph scale 5 translate <0,-40,0> }
object { BluSph scale 5 translate <0,-35,0> }
object { BluSph scale 5 translate <0,-25,0> }
object { BluSph scale 5 translate <0,-15,0> }
object { BluSph scale 5 translate <0,-5,0> }
object { BluSph scale 5 translate <-2,5,0> }
object { BluSph scale 5 translate <2,15,0> }
*/
//object { SimpleBricks translate <0,0,0> }

object { BrickWall }
object { WallMortar }

//box { <0,0.5,0>,<80,40,80> texture { PlainTex } }