
// POV-Ray Object File - Furnace
// created 26-Nov-00
// last update 9-Dec-00
// 2000 Glenn McCarter
//
// This file does not render.  #include "Furnace.inc" in another .pov file
// Required #include files: (none)
//
// Objects:
// FurnaceS (simple version)
// Furnace
// AnnealingFurnace
//
// Intended scale is English system (inches)
// Uses RH coordinate reference system (Z=up)


//===============================================
//             Variables
//===============================================



//===============================================
//             Textures
//===============================================

#declare FurnaceTex =
	texture {
		pigment {
			brick
				color rgb <0.349,0.322,0.306>, // mortar
				color rgb <0.649,0.453,0.226> // brick
				brick_size <8,3,4.5>
				mortar 0.4
				rotate x*90
		}
		normal { bumps 0.1 scale 3}
		finish { ambient 0.1 specular 0.1 roughness 0.08 }
	}

#declare FurnaceInteriorTex =
	texture {
		pigment {
//				color rgb <0.999,0.996,0.306> // white/yellow hot
//				color rgb <0.799,0.696,0.306> // a tinge of orange
				color rgb <0.699,0.596,0.206> // yellow/orange hot?
		}
		normal { bumps 0.1 scale 3}
		finish { ambient 4 specular 0.1 roughness 0.08 }
	}

#declare FlueTex =
	texture {
		pigment {
			gradient z
			color_map {
				[ 0.00 color rgb <0.576,0.624,0.643> ] // old tin
				[ 0.02 color rgb <0.576,0.624,0.643>*0.23 ] // 
				[ 0.04 color rgb <0.576,0.624,0.643>*0.23 ]
			}
			scale 16
		}
		normal { bumps 0.1 scale 3}
		finish { ambient 0.1 metallic specular 0.5 roughness 0.03 }
	}
#declare FlueTex2 =
	texture {
		pigment { color rgb <0.576,0.624,0.643> } // old tin
		normal { bumps 0.1 scale 3}
		finish { ambient 0.1 metallic specular 0.5 roughness 0.03 }
	}

#declare FurnaceMetalTex =
	texture {
		pigment { color rgb <0.476,0.424,0.443> } // old metal
		normal { bumps 0.2 scale .6 }
		finish { ambient 0.1 metallic specular 0.5 roughness 0.03 }
	}

#declare DarkTex =
	texture {
		pigment { color rgb <0.076,0.024,0.043> }
		finish { ambient 0.06 metallic specular 0.2 roughness 0.13 }
	}

//===============================================
//             Objects
//===============================================

#declare FurnaceS = // simple version
	box {
		<0,0,0>,<48,48,7*Feet>
		texture { FurnaceTex }
	}
#declare FluePipe =
	cylinder {
		<0,0,0>,<0,0,12*Feet>,4.4
		texture { FlueTex }
	}
#declare InletPipe =
	union {
		cylinder {
			<0,0,8>,<0,0,18*Feet>,1.2
			texture { FlueTex2 }
		}
		sphere {
			<0,0,8>,1.2
			texture { FlueTex2 }
		}
		cylinder { // bracket
			<0,0,0>,<0,0,2>,1.5
			translate <0,0,6.6*Feet>
		}
		box {
			<1.5,-2.5,0>,<3,2.5,2>
			translate <0,0,6.6*Feet>
		}
		cylinder { // bracket
			<0,0,0>,<0,0,2>,1.5
			translate <0,0,2.1*Feet>
		}
		box {
			<1.5,-2.5,0>,<3,2.5,2>
			translate <0,0,2.1*Feet>
		}
		texture { FurnaceMetalTex }
	} // end union
#declare FDoorAssy =
	union {
		box { <-6,0,-1.5>,<25,2,0> } // lower rail
		box { <-6,0,0>,<25,2,1.5> translate <0,0,16> } // upper rail
		difference {
			object {
				RoundedBox(0.1)
				scale <16,4,16>
			}
			cylinder {
				<0,-8,0>,<0,8,0>,2.8
			}
			translate <0,-3,8>
		} // end difference
		texture { FurnaceMetalTex }
	} // end union
#declare FireboxDoorAssy =
	union {
		difference {
			object {
				RoundedBox(.2)
				scale <18,2.8,12>
				translate <0,-2.8/2-0.4,0>
			}
			box {
				<-4,-6,-1>,<4,6,3>
			}
		} // end difference
		box {
			<-4.3,-0.3,-1.3>,<4.3,2,3.3>
			texture { DarkTex }
		}
		cylinder { <0,0,-5>,<0,0,5>,0.5 translate <-3,-1,0> }
		cylinder { <0,0,-5>,<0,0,5>,0.5 translate <-1,-1,0> }
		cylinder { <0,0,-5>,<0,0,5>,0.5 translate <1,-1,0> }
		cylinder { <0,0,-5>,<0,0,5>,0.5 translate <3,-1,0> }
		box { // latch
			<0,-2,0>,<1,2,1>
			translate <-10,-3,0>
		}
		box { // latch
			<0,-2,0>,<5,2,1>
			translate <-10,-2.8,0>
		}
		box { // latch plate
			<-1,0,-2>,<1,3,2>
			translate <-10,-0.3,0>
		}
		cylinder { // latch
			<0,0,-1.2>,<0,0,1.5>,0.3
			translate <-9.5,-3.2,0>
		}
		cylinder { // hinge
			<0,0,-1>,<0,0,1>,0.8
			translate <9.8,-2,-5>
		}
		cylinder { // hinge
			<0,0,-1>,<0,0,1>,0.8
			translate <9.8,-2,5>
		}
		texture { FurnaceMetalTex }
	} // end union
#declare Furnace = // faces -Y
	union {
		difference {
			box { // main
				<0,0,0>,<48,48,7*Feet>
			}
			box { // firebox
				<-8,-6,0>,<8,28,16>
				translate <24,0,44>
				texture { FurnaceInteriorTex }
			}
		} // end difference
		object { FluePipe translate <24,18,6.9*Feet> }
		object { InletPipe translate <-2.8,8,0> }
		object { InletPipe translate <-2.8,15,0> }
		object { FDoorAssy translate <9,-2,44> }
		object { FireboxDoorAssy translate <24,0,14> }
		texture { FurnaceTex }
	} // end union

#declare FurnaceLight =
	light_source {
		<24,18,44+8>
		color rgb <1.0,1.0,0.4>*3.6
		fade_distance 1*Feet
		fade_power 1.2
	}

#declare AnnealingFurnace = // faces -Y
	union {
		box { // main
			<-21,0,2.5*Feet>,<21,30,5*Feet>
		}
		box { // lower
			<-19,4,0>,<19,28,2.5*Feet>
		}
		texture { FurnaceTex }
	} // end union

//--------------- Object --------------------

