
// POV-Ray Object File - Furnishings
// created 26-Nov-00
// last update 31-Dec-00
// 2000 Glenn McCarter
//
// This file does not render.  #include "Furnishings.inc" in another .pov file
// Required #include files: "HandTools.inc"
//
// Objects:
// GlassrollingWorkbench
// WorkTable
// WorkGroup1
// Shelves
// SmallSign
// CheckoutCabinet
// CashRegister
// CheckoutCounterGroup
//
// Intended scale is English system (inches)
// Uses RH coordinate reference system (Z=up)

#version unofficial MegaPov 0.6;
#include "HandTools.inc"

//===============================================
//             Variables
//===============================================



//===============================================
//             Textures
//===============================================

#declare WoodSeatTex =
	texture {
		pigment {
			color rgb <0.649,0.622,0.306>
		}
		normal { bumps 0.1 scale 3}
		finish { ambient 0.1 specular 0.1 roughness 0.08 }
	}
#declare IronFrameTex = // workbench
	texture {
		pigment {
			color rgb <0.249,0.222,0.206>
		}
		normal { bumps 0.1 scale .72}
		finish { ambient 0.1 metallic specular 0.5 roughness 0.02 }
	}

#declare CabinetTex =
	texture {
		pigment {
			color rgb <0.949,0.929,0.984>*1.4
		}
		normal { bumps 0.05 scale <8,8,16> }
		finish { ambient 0.1 specular 0.3 roughness 0.13 }
	}
#declare CabinetCounterTex =
	texture {
		pigment {
			color rgb <0.675,0.510,0.349>
		}
		normal { bumps 0.15 scale <3.8,.8,.8> }
		finish { ambient 0.1 specular 0.56 roughness 0.13 }
	}

#declare ShelfMetalTex =
	texture {
		pigment {
			color rgb <0.693,0.649,0.788>*1.3
		}
		normal { bumps 0.08 scale 20}
		finish { ambient 0.1 metallic specular 0.3 roughness 0.13 reflection 0.3 }
	}
#declare ShelfBaseTex =
	texture {
		pigment {
//			color rgb <0.180,0.353,0.529> // deep pale battleship blue
//			color rgb <0.153,0.376,0.800> // too rich slate blue
			color rgb <0.553,0.643,0.804>
//		color rgb <0.732,0.871,1.000>
		}
//		normal { bumps 0.12 scale <1.2,1.2,12> }
		finish { ambient 0.1 diffuse 0.6 specular 0.87 roughness 0.083 }
	}
#declare ShelfCounterTex =
	texture {
		pigment {
			color rgb <0.180,0.353,0.529> // pale blue
		}
//		normal { bumps 0.05 scale <0.27,0.27,0.27> }
		finish { ambient 0.1 specular 0.56 roughness 0.13 reflection 0.14 }
	}
#declare ShelfCapTex = // rubber plugs
	texture {
		pigment {
			color rgb <0.018,0.035,0.052>
		}
		finish { ambient 0.1 specular 0.16 roughness 0.34 }
	}
#declare ShelfGlassInt =
	interior { ior 1.45 }
#declare ShelfGlassTex = // high quality plate glass version
	texture {
		pigment {
			color rgbt <0.70,0.73,0.96,0.16>
		}
		finish { ambient 0.1 diffuse 0.1 specular 0.999 roughness 0.0048 reflection 0.18 }
	}
#declare ShelfGlassMat =
	material {
		texture { ShelfGlassTex }
		interior { ShelfGlassInt }
	}
#declare CleanBrassTex =
	texture {
		pigment {
			color rgb <0.659,0.486,0.125>
		}
//		finish { ambient 0.1 diffuse 0.3 specular 0.92 roughness 0.025 reflection 0.4}
		finish { ambient 0.1 diffuse 0.3 specular 0.92 roughness 0.025
			reflection 0.4
			reflection_blur 0.10
			reflection_samples 25
		}
	}


#declare CashRegisterTex =
	texture {
		pigment {
			color rgb <0.303,0.332,0.188>
		}
		normal { bumps 0.1 scale 5}
		finish { ambient 0.1 specular 0.5 roughness 0.03 }
	}
#declare CRKeyTex =
	texture {
		pigment {
			color rgb <0.063,0.052,0.048>
		}
		finish { ambient 0.1 specular 0.84 roughness 0.03 }
	}
#declare PopUpTex =
	texture {
		pigment {
			color rgb <0.933,0.432,0.488>
		}
		finish { ambient 0.1 specular 0.5 roughness 0.03 }
	}

#declare GreenGlassInt =
	interior { ior 1.45 }
#declare GreenGlassTex = // high quality plate glass version
	texture {
		pigment {
			color rgbft <0.90,0.93,0.96,0.34,0.96>
		}
		finish { ambient 0.1 diffuse 0.1 specular 0.999 roughness 0.0035 reflection 0.12 }
	}
#declare GreenGlassMat =
	material {
		texture { GreenGlassTex }
		interior { GreenGlassInt }
	}
                             
#declare WelcomeMatTex =
	texture {
		pigment {
			color rgb <0.451,0.447,0.227>
		}
		normal { bumps 0.8 scale <.1,.1,5> }
		finish { ambient 0.1 specular 0.5 roughness 0.3 }
	}

#declare GiftBox1Tex =
	texture {
		pigment {
			color rgb <1.00,0.95,0.72>*1.4
		}
		normal { bumps 0.2 scale <2,3,4> }
		finish { ambient 0.1 specular 0.8 roughness 0.08 }
	}


//===============================================
//             Objects
//===============================================

//--------------- Glassworking Workbench --------------------

#declare GlassrollingWorkbench =
	union {
		box {
			<0,0,0>,<36,12,1> // seat top
			translate <0,0,14>
			texture { WoodSeatTex }
		}
		box { <0,0,0>,<1,1,14> translate <0,0,0> } // seat leg
		box { <0,0,0>,<1,1,14> translate <0,11,0> } // seat leg
		box { <0,0,0>,<1,1,14> translate <35,0,0> } // seat leg
		box { <0,0,0>,<1,1,14> translate <35,11,0> } // seat leg
		box { <0,0,0>,<1,1,24> translate <35,-20,0> } // far end frame
		box { <0,0,0>,<1,1,24> translate <35,0,0> } // far end frame
		box { <0,-20,0>,<1,0,1> translate <35,0,24> } // far end frame
		box { <0,-20,0>,<1,0,1> translate <35,0,5> } // far end frame
		box { <0,0,0>,<1,1,24> translate <0,-20,0> } // near end frame
		box { <0,0,0>,<1,1,24> translate <0,0,0> } // near end frame
		box { <0,-20,0>,<1,0,1> translate <0,0,24> } // near end frame
		box { <0,-20,0>,<1,0,1> translate <0,0,5> } // near end frame
		box { <0.25,-19,5>,<0.75,0,24> translate <0,0,0> texture { WoodSeatTex } } // near wood barrier
		texture { IronFrameTex } // default texture
	} // end union

#declare WorkTable =
	union {
		box {
			<-28,0,0>,<0,12,1> // work top
			translate <0,0,18>
		}
		box { <0,0,0>,<1,1,18> translate <-28+1.5,1.5,0> } // leg
		box { <0,0,0>,<1,1,18> translate <-28+1.5,11-1.5,0> } // leg
		box { <0,0,0>,<1,1,18> translate <-1.5,1.5,0> } // leg
		box { <0,0,0>,<1,1,18> translate <-1.5,11-1.5,0> } // leg
		texture { IronFrameTex } // default texture
	} // end union

#declare WorkGroup1 =
	union {
		object { GlassrollingWorkbench }
		object { WorkTable }
		object { SmallBox rotate z*22 translate <-20,0,19> }
		object { Roller rotate z*12 translate <-14,7,19> }
	} // end union


//--------------- Cabinet --------------------

#declare CabinetS = // simple version
	box {
		<0,0,0>,<6*Feet,28,36>
		texture { CabinetTex }
	}

#declare CheckoutCabinet =
	union {
		box { // top
			<0,0,-1.7>,<6*Feet,28,0>
			translate <0,0,36>
			texture { CabinetCounterTex }
		}
		union { // left end group
			box { // base
				<0,1+3.5+0.06,0>,<0.75,27-3.5-0.05,7.5>
			}
			box { // top
				<0,1+3.5+0.11,0>,<0.75,27-3.5-0.08,3.5>
				translate <0,0,36-1.7-3.5>
			}
			box { // front
				<0.12,1+0.75,0>,<0.75,1+3.5,36-1.7>
			}
			box { // rear
				<0,1,0>,<0.75,1+3.5,36-1.7>
				translate <0,27-3.5,0>
			}
			box { // interior
				<0,2,2>,<0.5,25,34>
				translate <0.5,0,0>
			}
			translate <1,0,0>
		} // end union

		union { // front group
			box { // base
				<1+3.5+0.12,0,0>,<6*Feet-1-3.5-0.06,0.75,7.5>
			}
			box { // top
				<1+3.5+0.12,0,0>,<6*Feet-1-3.5-0.06,0.75,3.5>
				translate <0,0,36-1.7-3.5>
			}
			box { // left
				<0,0,0>,<3.5,0.75,36-1.7>
				translate <1,0,0>
			}
			box { // right
				<0,0,0>,<3.5,0.75,36-1.7>
				translate <6*Feet-1-3.5,0,0>
			}
			box { // center stile
				<-0.85,0,0>,<0.85,0.75,36-1.7>
				translate <6*Feet/2,0,0>
			}
			translate <0,1,0>
		} // end union

		box { // right end
			<0,1,0>,<0.75,27,35.1>
			translate <6*Feet-1.75,0,0>
		}
		box { // middle shelf
			<1.5,5,0>,<6*Feet-0.5,27,1>
			translate <0,0,19>
		}
		box { // bottom shelf
			<1.5,5,0>,<6*Feet-0.5,27,1>
			translate <0,0,4>
		}

		#if (WindowGlass=1)

		box { // front glass
			<3.5-0.5,0,6>,<6*Feet-3.5+0.5,0.1,35.1>
			translate <0,0.95+0.35,0>
			material { GreenGlassMat }
		}

		#end
		texture { CabinetTex }
	} // end union

//--------------- Cash Register --------------------

#declare CRKey =
	union {
		cylinder {
			<0,0,0>,<0,0,0.15>,0.37
		}
		box {
			<-0.05,-0.2,-0.85>,<0.05,0.2,0>
		}
		box {
			<-0.05,-0.2,-0.85>,<0.05,2.2,-0.30>
			rotate x*-15
		}
		texture { CRKeyTex }
	} // end union
#declare CashRegister =
	union {
		object { // base
			RoundedBox(.05)
			translate <0.5,0.5,0.5>
			scale <18,18,4>
		}
		difference {
			object { // upright
				RoundedBox(0.5)
				translate <0.5,0.5,0.5>
				scale <16,2.5,16>
				translate <1,0,0>
			}
			box {
				<1.8,-1,14>,<17-0.8,4,18>
			}
				translate <0,18-1-2.5,0>
		} // end difference
		box { // top glass
			<1.5,0.2,-0.29>,<16.5,2.2,0>
			translate <0,18-1-2.5,15.8>
			material { GreenGlassMat }
		}
		box { // rear glass
			<1.5,-0.29,-2.2>,<16.5,0,-0.2>
			translate <0,18-1-2.5-0.3,15.8>
			material { GreenGlassMat }
		}
		box { // "no sale" pop-up
			<-0.5,0,-2>,<0.5,0.1,1.4>
			translate <13,18-1-1.25,14>
			texture { PopUpTex }
		}
		cylinder { // front
			<1+0.5,0,0>,<17-0.5,0,0>,10
			translate <0,18-1-2.5,4>
			clipped_by { box{<0,0,0>,<18,16,18>}}
		}
		cylinder { // end
			<1,0,0>,<17,0,0>,10-0.5
			translate <0,18-1-2.5,4>
			clipped_by { box{<0,0,0>,<18,16,18>}}
		}
		torus { // right end
			10-0.5,0.5
			rotate z*90
			translate <17-0.5,18-1-2.5,4>
			clipped_by { box{<16,0,0>,<18,16,18>}}
		}
		object { CRKey translate <16.3,3.1,8.5> }
		object { CRKey translate <16.0,2.7,6.5> }
		object { CRKey translate <15.3,3.1,8.5> }
		object { CRKey translate <15.0,2.7,6.5> }
		texture { CashRegisterTex }
	} // end union

//--------------- Shelves --------------------

#macro ShelfLeg(Height)
	union {
		box {
			<0,0,0>,<1,1,Height-0.1>
			translate <-0.5,-0.5,0> // center
			texture { ShelfMetalTex }
		}
		box {
			<-0.02,-0.02,0>,<1.02,1.02,0.2>
			translate <-0.5,-0.5,0> // center
			texture { ShelfCapTex }
		}
		box {
			<-0.02,-0.02,0>,<1.02,1.02,0.2>
			translate <-0.5,-0.5,Height-0.2> // center
			texture { ShelfCapTex }
		}
	} // end union
#end

#declare ShelfDoor =
	union {
		difference {
			object { // left-hinged door
				RoundedBox(.07)
				scale <10,0.4,19>
			}
			object { // cutout
				RoundedBox(.07)
				scale <6.5,0.3,15>
				translate <0,-0.20,0> // origin at lower LH corner
			}
			translate <5,-0.26,19/2> // origin at lower LH corner
			texture { ShelfBaseTex }
		} // end difference
		sphere { // doorknob
			<0,0,0>,0.6
			translate <8.8,-1.3,17>
		}
		cylinder { // doorknob base
			<0,0,0>,<0,1.5,0>,0.14
			translate <8.8,-1.3,17>
		}
		cylinder { // lower hinge
			<0,0,0>,<0,0,1.6>,0.07
			translate <-0.2,-0.3,2>
		}
		cylinder { // upper hinge
			<0,0,0>,<0,0,1.6>,0.07
			translate <-0.2,-0.3,19-2-1.6>
		}
		texture { CleanBrassTex }
	} // end union

#declare SBH = 30; // Shelf Countertop height
#declare ShelfLength = 48;
#declare SL = ShelfLength;
#declare SBEndPlate =
	union {
		box { <0.2,0,0>,<1-0.2,24,SBH-0.5> }
		box { <0,0.2,0>,<1,24-0.2,SBH-0.5> }
		cylinder { <0,0,0>,<0,0,SBH-0.5>,0.2 translate <0.2,0.2,0> }
		cylinder { <0,0,0>,<0,0,SBH-0.5>,0.2 translate <1-0.2,1-0.2,0> }
		texture { ShelfBaseTex }
	} // end union
#declare ShelfBase =
	union {
		box { // base cabinet
			<1,1,6>,<SL-1,24-1,SBH-1>
		}
		object { SBEndPlate translate <SL-1,-0.7,0> }
		object { ShelfDoor translate <24,1,8> }
		object { ShelfDoor scale <-1,1,1> translate <45,1,8> }
		object { ShelfDoor scale <-1,1,1> translate <22,1,8> }
		box { // countertop
			<-1,-1,-1>,<SL+1,24+1,0>
			translate <0,0,SBH>
			texture { ShelfCounterTex }
		}
		box { // countertop formica dark edges
			<-1,-1.01,-0.11>,<SL+1,-0.99,-0.01>
			translate <0,0,SBH>
			texture { ShelfCapTex }
		}
		texture { ShelfBaseTex }
	} // end union
#declare TSH = 38; // top shelf height over countertop
#declare Shelf =
	union {
		box { // glass shelf
			<0.6,0.05,-0.2>,<SL-0.6,12,0>
			material { ShelfGlassMat }
		}
		difference {
			box { <0,0,-0.4>,<SL,12,0> }
			box { <0.4,0.4,-1>,<SL-0.4,12-0.4,1> }
			translate <0,0,-0.3>
		} // end difference
		texture { ShelfMetalTex }
	} // end union
#declare TopShelves =
	union {
		object { ShelfLeg(TSH) translate <0,0,0> }
		object { ShelfLeg(TSH) translate <SL,0,0> }
		object { ShelfLeg(TSH) translate <0,12,0> }
		object { ShelfLeg(TSH) translate <SL,12,0> }
//		box { <0,0,-0.4>,<SL,12,0> translate <0,0,12> } // shelf
//		box { <0,0,-0.4>,<SL,12,0> translate <0,0,24> } // shelf
//		box { <0,0,-0.4>,<SL,12,0> translate <0,0,36> } // shelf
		object { Shelf translate <0,0,12> }
		object { Shelf translate <0,0,24> }
		object { Shelf translate <0,0,36> }
		texture { ShelfMetalTex }
	} // end union
#declare EmptyShelfGroup =
	union {
		object { ShelfBase }
		object { TopShelves translate <0,12,SBH> }
	} // end union

//--------------- Misc --------------------

#declare SmallSign =
	box { // sign
		//sits on xy plane, at z=0
		#local ImageWidth = 8.5;
		#local ImageHeight = 11;
		<0,0,0>,<ImageWidth,ImageHeight,0.18>
//		texture { PaperWhite } // test
		texture {
			pigment {
					image_map { // image is always projected from -z, with front facing +z
					png "SmallSign.png"
					once
					}
			}
			finish { ambient .9 }
			scale <ImageWidth,ImageHeight,1>
		}
	}

#declare WelcomeMat =
	object { RoundedHalfBox(0.1)
		scale <28,22,2>
		translate <0,0,-0.3>
		texture { WelcomeMatTex }
	}

#macro GiftBox1(GBSize,GBHeight)
	object { RoundedBox(0.08)
		scale <GBSize,GBSize,GBHeight>
		translate <0,0,GBHeight/2+0.07>
		texture { GiftBox1Tex }
	}
#end

#macro CookieJar(CJColor)
	#local CJD = 2.2 ;
	union {
		cylinder { // main
			<0.1,0,0>,<0,0,8-0.1>,CJD
		}
		torus { CJD-0.1*2,0.1 rotate x*90 }
		torus { CJD-0.1*2,0.1 rotate x*90 translate <0,0,8-0.1> }
		cylinder { <0,0,7>,<0,0,8.5>,CJD-0.2 } // inner hider
		cylinder { // top
			<0,0,0>,<0,0,1>,CJD
			translate <0,0,8.15>
		}
		sphere { // top
			<0,0,0>,CJD
			scale <1,1,0.23>
			translate <0,0,8.15+1>
		}
		texture {
			pigment { CJColor }
			finish { ambient 0.1 diffuse 0.6 specular 0.85 roughness .045 }
		}
	} // end union
#end

#declare PencilJar =
	union {
		cylinder {
			<0,0,0>,<0,0,5>,1.6
			texture {
				pigment { color rgb<0.23,0.25,0.26> }
				finish { ambient 0.1 diffuse 0.6 specular 0.85 roughness .045 }
			}
		}
		sphere { // pen
			<0,0,0>,0.18
			scale <1,1,26>
			rotate <14,0,28>
			translate <0,0,5>
			texture {
				pigment { color rgb<0.123,0.075,0.036> }
				finish { ambient 0.1 diffuse 0.6 specular 0.96 roughness .025 }
			}
		}
		union {
			cylinder {
				<0,0,0>,<0,0,6>,0.11
				texture {
					pigment { color rgb<0.923,0.935,0.236> }
					finish { ambient 0.1 diffuse 0.6 specular 0.86 roughness .045 }
				}
			}
			sphere {
				<0,0,6>,0.11
				texture {
					pigment { color rgb<0.923,0.635,0.636> }
					finish { ambient 0.1 diffuse 0.6 specular 0.16 roughness .25 }
				}
			}
			rotate <11,0,55>
		} // end union
	} // end union

#declare SalesMat =
	object {
		RoundedBox(.03)
		scale <24,24,0.2>
		texture {
			pigment { color rgb <0.949,0.929,0.984>*1.0 }
			normal { bumps 0.15 scale <7,3,2> }
			finish { ambient 0.1 specular 0.3 roughness 0.13 }
		}
		translate <0,0,0.13>
	}

//===============================================
//             Groups
//===============================================

#declare CheckoutCounterGroup =
	union {
//		object { CabinetS }
		object { CheckoutCabinet }
		object { CashRegister rotate z*178 translate <24,24,36> }
		object { SalesMat rotate z*-3 translate <40,20,36> } 
		object { SimpleGlassC(rgbt<.33,.78,.89,0.5>) translate <5*Feet+10,11,36> } // countertop
		object { GiftBox1(3,2) translate <5*Feet+10,20,36> }
		object { GiftBox1(3,2) translate <5*Feet+10,23.5,36> }
		object { GiftBox1(3,2) translate <5*Feet+9.85,21.5,36+2.1> }
		object { PencilJar rotate z*90 translate <5*Feet+6,16,36> }

		object { WineGlassC(rgbt<0.98,0.82,0.72,0.42>) translate <22,8,5> } // lowest shelf
		object { WineGlassC(rgbt<0.98,0.82,0.72,0.42>) translate <22,11.3,5> }
		object { WineGlassC(rgbt<0.48,0.92,0.62,0.62>) translate <42,8,5> }
		object { WineGlassC(rgbt<0.48,0.92,0.62,0.62>) translate <42.4,12,5> }
		object { WineGlassC(rgbt<0.48,0.92,0.62,0.62>) translate <42.1,16.5,5> }
		object { DarkChampagneGlass1 translate <54,9.5,5> }
		object { CookieJar(rgb<.89,.88,.69>) translate <66,8,5> }
		object { CookieJar(rgb<.89,.88,.69>) translate <66,14,5> }
		object { CookieJar(rgb<.89,.88,.69>) translate <65,20,5> }
		object { CookieJar(rgb<.39,.18,.89>) translate <16,8,20> } // middle shelf
		object { SimpleGlassC(rgbt<.33,.78,.89,0.5>) translate <25,8,20> }
		object { SimpleGlassC(rgbt<.33,.78,.89,0.5>) translate <25,11,20> }
		object { DarkChampagneGlass1 translate <32,8,20> }
		object { DarkChampagneGlass1 translate <37,8,20> }
		object { DarkChampagneGlass1 translate <41,8.3,20> }
		object { DarkChampagneGlass1 translate <46,7.6,20> }
		object { GiftBox1(6,8) rotate z*15 translate <42,14.5,20> }
		object { GiftBox1(6,4) rotate z*3 translate <66,9.5,20> }
 		object { GiftBox1(6,4) rotate z*0 translate <66,15.8,20> }

	} // end union

#declare FilledShelfGroup =
	union {
		object { EmptyShelfGroup }
		object { WineGlass1 translate <40,23,SBH+36> } // top shelf
		object { WineGlass1 translate <40.2,26,SBH+36> }
		object { WineGlass1 translate <44,23,SBH+36> }
		object { WineGlass1 translate <43.7,26,SBH+36> }
		object { GiftBox1(10,7) rotate z*-8 translate <29,24,SBH+36> }
		object { ChampagneGlass1 translate <34,20,SBH+24> } // second shelf
		object { ChampagneGlass1 translate <37,20.5,SBH+24> }
		object { ChampagneGlass1 translate <40.4,20.1,SBH+24> }
		object { GiftBox1(4,4) rotate z*-7 translate <43,24,SBH+24> }
		object { GiftBox1(4,4) rotate z*-2 translate <43,23.8,SBH+24+4.05> }
		object { GiftBox1(4,4) rotate z*3 translate <45.5,19.5,SBH+24> }
		object { GiftBox1(4,4) rotate z*-1 translate <45.7,19.3,SBH+24+4.05> }
		object { DarkChampagneGlass1 translate <30,15,SBH+12> } // first shelf
		object { DarkChampagneGlass1 translate <33,18,SBH+12> }
		object { DarkChampagneGlass1 translate <37,20,SBH+12> }
		object { GiftBox1(7,7) rotate z*0 translate <41,18,SBH+12> }
		object { Chalice1 translate <38,18,SBH> } // base
		object { Chalice1 translate <31,17,SBH> }
		object { Chalice1 translate <35,23,SBH> }
		object { Chalice1 translate <28,23,SBH> }
		object { GiftBox1(8,6) rotate z*1 translate <44,20,SBH> }
		object { CookieJar(rgb<.996,.830,.830>) scale 0.8 translate <24,10,SBH+0.1> }
	} // end union

