
// POV-Ray Object File - Glassblowing Hand Tools
// created 30-Nov-00
// last update 19-Dec-00
// 2000 Glenn McCarter
//
// This file does not render.  #include "HandTools.inc" in another .pov file
// Required #include files: (none)
//
// Objects:
// SmallBox
// Roller
// Jacks
// BlowPipe(XLength)
//
// Intended scale is English system (inches)
// Uses RH coordinate reference system (Z=up)


//===============================================
//             Variables
//===============================================



//===============================================
//             Textures
//===============================================

#declare SteelToolTex =
	texture {
		pigment {
			color rgb <0.649,0.622,0.506>
		}
		normal { bumps 0.03 scale 2}
		finish { ambient 0.14 specular 0.81 roughness 0.013 }
	}
#declare WoodBoxTex =
	texture {
		pigment {
			color rgb <0.649,0.522,0.206>
		}
		normal { bumps 0.4 scale .52}
		finish { ambient 0.1 specular 0.57 roughness 0.033 }
	}

#declare BlowPipeTex =
	texture {
		pigment {
			color rgb <0.649,0.622,0.506>
		}
		normal { bumps 0.03 scale 2}
		finish { ambient 0.14 specular 0.81 roughness 0.013 }
	}

#declare HotGlassTex =
	texture {
		pigment {
//				color rgbt <40.999,40.996,10.306,0.08> // fiery white
				color rgbt <10.999,10.996,1.306,0.08> // fiery white
		}
		normal { bumps 0.1 scale 3}
		finish { ambient 4 specular 0.1 roughness 0.08 }
	}
#declare WarmGlassTex =
	texture {
		pigment {
//				color rgbt <4.0,3.6,1.306,0.04>*10 // hot
				color rgbt <4.0,2.6,1.306,0.04>*6 // test
		}
		normal { bumps 0.1 scale 3}
		finish { ambient 4 diffuse 0.026 specular 0.1 roughness 0.08 }
	}

//===============================================
//             Objects
//===============================================

#declare SmallBox =
	difference {
		box { <0,0,0>,<4,5,3> }
		box { <0.25,0.25,0.3>,<3.75,4.75,4> }
		texture { WoodBoxTex }
	} // end difference

#declare Roller =
	cylinder {
		<0,0,0>,<0,0,4>,0.57
		translate <0,0,0.57>
		texture { SteelToolTex }
	}

#macro BlowPipe(XLength)
	union {
		cylinder { // main
			<0,0,0>,<XLength,0,0>,0.38
			texture { BlowPipeTex }
		}
		cylinder { // handle
			<1.5,0,0>,<16,0,0>,0.72
			texture { WoodBoxTex }
		}
	} // end union
#end

#declare JOpenAngle = 7;
#declare JacksHalf =
	union {
		difference {
			cylinder {
				<0,-0.6,0>,<0,0.6,0>,0.5
			}
			cylinder {
				<0,-2,0>,<0,2,0>,0.4
			}
		} // end difference
		box {
			<0,-0.6,-0.1>,<2,0.6.0>
			rotate y*-JOpenAngle
			translate <0,0,0.5>
		}
		cylinder {
			<2,0,0>,<7,0,0>,-0.3
			rotate y*-JOpenAngle
			translate <0,0,0.5>
		}
		cone { // pincer
			<6,0,0>,0.2,<13,0,0>,0.08
			rotate y*-JOpenAngle
			translate <0,0,0.5>
		}
		texture { SteelToolTex }
	} // end union
#declare Jacks =
	union {
		object { JacksHalf }
		object { JacksHalf scale <1,1,-1> }
	}


//--------------- Groups --------------------

#declare HotBlowPipeSmall =
	union {
		object { BlowPipe(48) }
		sphere {
			<0,0,0>,0.8
			scale <2,1,1>
			translate <48,0,0>
			texture { HotGlassTex }
		}
	}

#declare HotBlowPipeLarge =
	union {
		object { BlowPipe(48) }
		sphere {
			<0,0,0>,1.4
			scale <2,1,1>
			translate <48,0,0>
			texture { WarmGlassTex }
		}
	}
