
// POV-Ray Object File - Shop Items
// created 19-Dec-00
// last update 19-Dec-00
// 2000 Glenn McCarter
//
// This file does not render.  #include "ShopItems.inc" in another .pov file
// Required #include files: (none)
//
// Objects:
// Bucket
// PipeRest
// PipeGroup
//
// Intended scale is English system (inches)
// Uses RH coordinate reference system (Z=up)

#version unofficial MegaPov 0.6;

//===============================================
//             Variables
//===============================================



//===============================================
//             Textures
//===============================================

#declare ShinyHandleTex =
	texture {
		pigment {
			color rgb <0.649,0.622,0.506>*1.5
		}
		finish { ambient 0.14 metallic specular 0.98 roughness 0.010 reflection 0 }
	}
#declare WoodHandleTex =
	texture {
		pigment {
			bozo
//gradient z
			color_map {
//				[ 0.50 color rgb <0.471,0.314,0.169> ]
				[ 0.50 color rgb <0.471,0.364,0.269> ]
				[ 0.70 color rgb <0.471,0.314,0.169>*0.3 ]
			}
			scale <2.72,2.72,2.0>
		}
		finish { ambient 0.14 specular 0.4 roughness 0.05 }
	}
#declare GalvanizedBucketTex =
	texture {
		pigment {
				crackle solid
//				scale 0.4 // rather big
				scale 0.2
		}
//		normal { bumps 0.3 scale 1.3 } // rather big
		normal { bumps 0.3 scale 0.7 } // smaller
		finish { ambient 0.14 metallic specular 0.71 roughness 0.023 reflection 0.35 }
	}


//===============================================
//             Objects
//===============================================

#declare WoodHandle =
	union {
		cylinder {
			<0,0,0>,<0,0,16>,0.55
		}
		sphere {
			<0,0,0>,0.55
			scale <1,1,0.7>
			translate <0,0,16>
		}
		texture { WoodHandleTex }
	} // end union

#declare BucketHandle =
	union {
		torus { // handle
			9.8,0.14
			rotate x*90
			clipped_by { box{<-11,-11,-1>,<11,0,1> } }
		}
		cylinder {
			<-2.2,0,0>,<2.2,0,0>,0.36
			translate <0,-9.5,0>
			texture { WoodHandleTex }
		}
		texture { ShinyHandleTex }
	} // end union

#declare Bucket =
	union {
		difference {
			cone { // main
				<0,0,0.6>,6,<0,0,14>,8.2
			}
			cone { // inner
				<0,0,0.8>,5.75,<0,0,15>,8.1
			}
		} // end difference
		cylinder { // base
			<0,0,0>,<0,0,1>,5.78
		}
		cylinder { // handle mount
			<-8.5,0,0>,<-8.2,0,0>,0.55
			translate <0,0,14-0.6>
		}
		cylinder { // handle mount
			<8.5,0,0>,<8.2,0,0>,0.55
			translate <0,0,14-0.6>
		}
		torus { // rim
			8.35,0.18
			rotate x*90
			translate <0,0,14>
		}
		torus {
			7.45,0.14
			rotate x*90
			scale <1,1,1.4>
			translate <0,0,9>
		}
		torus {
			7.22,0.14
			rotate x*90
			scale <1,1,1.4>
			translate <0,0,7.5>
		}
		object { BucketHandle
			rotate x*45
			translate <0,0,14-1.3>
		}
		scale <0.75,0.75,0.75> // downsize it a little
		texture { GalvanizedBucketTex }
	} // end union


#declare FilledBucket =
	union {
		object { Bucket }
		object { WoodHandle
			rotate <10,16,0>
			translate <0,0,0.4>
		}
	} // end union


#local PRH = 48 ; // nominal height
#declare PipeRest =
	union {
		cylinder { // lower
			<0,0,8>,<0,0,24>,0.55
		}
		cylinder { // middle collar
			<0,0,23>,<0,0,25>,0.68
		}
		cylinder { // mid lock bolt
			<-1.5,0,0>,<0,0,0>,0.38
			translate <0,0,24>
		}
		cylinder { // mid lock bolt
			<-1.5,0,0>,<-1.5,-2.5,0>,0.38
			rotate x*28
			translate <0,0,24>
		}
		cylinder { // upper
			<0,0,23>,<0,0,PRH>,0.43
		}
		cylinder { // upper collar
			<0,0,PRH-1.4>,<0,0,PRH>,0.68
		}
		box {
			<-4,-0.54,-0.3>,<4,0.54,0.1>
			translate <0,0,PRH>
		}
		box { // end
			<-4,-0.54,-0.3>,<-3.78,0.54,0.1>
			translate <0,0,PRH>
		}
		box { // end
			<4,-0.54,-0.3>,<3.78,0.54,0.1>
			translate <0,0,PRH>
		}
		cylinder { // base collar
			<0,0,7.5>,<0,0,8.8>,0.78
		}
		box { // base
			<-0.7,-16,0>,<0.7,0,0.25>
			rotate <40,0,0+24>
			translate <0,0,8>
		}
		box { // base
			<-0.7,-16,0>,<0.7,0,0.25>
			rotate <40,0,120+24>
			translate <0,0,8>
		}
		box { // base
			<-0.7,-16,0>,<0.7,0,0.25>
			rotate <40,0,240+24>
			translate <0,0,8>
		}
		texture { GalvanizedBucketTex }
	} // end union

#declare PipeGroup =
	union {
		object { BlowPipe(48) rotate <0,90,0> rotate <-8,0,0> translate <-1.4,0,0> }
		object { BlowPipe(48) rotate <0,90,0> rotate <-11,-1,0> translate <3,0,0.8> }
		object { BlowPipe(48) rotate <0,90,0> rotate <-5,2,0> translate <5,0,-0.3> }
		object { BlowPipe(56) rotate <0,90,0> rotate <-8,-2,0> translate <3.4,0,9-0.3> }
		object { BlowPipe(56) rotate <0,90,0> rotate <-9,-1,0> translate <7,0,9-0.5> }
		translate <0,0,46>
	} // end union