#version unofficial MegaPov 0.6;

#ifndef (BOTTLE_INC)
  #declare BOTTLE_INC = 0 ;
  
  #ifndef (HighQuality)
    #declare HighQuality = on ;
  #end
  
  #include "enter"
  #include "metrics.inc"
  #include "text.inc"

  #declare Bottle = lathe{
    cubic_spline
    15,
    <-0.11270,0.004830>,
    <0.000000,0.020930>,
    <0.112700,0.004830>,
    <0.160999,0.117530>,
    <0.160999,0.552228>,
    <0.064400,0.825927>,
    <0.064400,0.954727>,
    <0.096600,0.954727>,
    <0.096600,0.986927>,
    <0.048300,0.986927>,
    <0.032200,0.825927>,
    <0.128800,0.536128>,
    <0.128800,0.085330>,
    <0.000000,0.053130>,
    <-0.12880,0.085330>
    
    scale 30*cm
    material { MGreenGlass }
    photons { target refraction on }
  }

  #declare Cork = cone {
    28*cm*y, 1*cm, 32*cm*y, 1.6*cm
    pigment { PCork }
  }
  
  #if (!included)
    global_settings {
      assumed_gamma 1
      max_trace_level 10
      #if (HighQuality)
        photons {
          spacing 1*mm
          autostop 0
        }
      #end
    }
    camera {
      up y
      right (image_width/image_height)*x
      location 40*cm*y-50*cm*z
      look_at  20*cm*y
      angle 40
    }
    light_source {
      110*cm*y-3*m*z
      color rgb 0.25
      shadowless
    }
    
    light_source {
      <1000, 1000, -1000>*m
      color rgb 1
    }
    light_source {
      <-1000, 1000, -1000>*m
      color rgb 1/4
    }
    light_source {
      <0, 1000, 1000>*m
      color rgb 1.5
    }
    
    cylinder {
      -y, 0, 2*m
      pigment {
        checker
        color rgb 0.25
        color rgb 0.50
        scale 20*cm
      }
      finish {
        diffuse 0.5
        reflection 0.25
        reflection_blur 0.05
        reflection_samples 1
      }
      rotate 30*y
    }
    
    union {
      //difference {
        object { Bottle }
        //plane { z, 0 pigment { color rgb <0, 1, 0> } }
      //}
      object { Cork }
      rotate 30*y
    }
  #end
  
  #include "leave"
#end
