#version unofficial MegaPov 0.6;

#ifndef (COMPUTER_INC)
  #declare COMPUTER_INC = 0 ;
  
  #include "enter"
  #include "metrics.inc"

  #ifndef (HighQuality)
    #declare HighQuality = no ;
  #end

  #include "text.inc"
  #include "isosurf.inc"
  #include "paintbrush.inc"
  #include "timbal.inc"

  #declare Computer = union {
    difference {
      union {
        object {
          RoundedBox (19, 49, 42, 0.5)
          translate 24.5*y
          scale 1*cm
        }
        isoblob {
          threshold 0.1
          function { max (1.1-z/40-sqrt (sqr (x)+sqr (y))/8, 0) } // cone
          function { max (1.1-max (max (abs (x/8), abs ((z-20)/23)), abs (y/8)), 0) } // box
          function { max (1.1-sqrt (sqr (x)+sqr (y)+sqr (z))/8, 0) } // sphere
          
          cylinder { -12*z+0.5*y, -12*z+41*y, 15, 1 2 }
          cylinder { -15*z+y, -15*z+39*y, 12, 1 1 }
          sphere { -15*z+8*y, 12, 1 3 scale <1, 1/8, 1> }
      
          scale 1*cm
          translate -0.999*cm*z
        }
      }
      box { <-8.3, 27.5, -22>*cm, <8.3, 47.8, -20>*cm }
      box { <-7.5, 27.6, -21>*cm, <3, 32.8, 0>*cm }
      box { <-7.5, 34.8, -21>*cm, <7.5, 47.7, 0>*cm }
      cylinder { <6, 30.2, -21>*cm, <6, 30.2, 0>*cm, 1*cm }
      cylinder { <4, 30.2, -21>*cm, <4, 30.2, 0>*cm, 0.15*cm }
    }
    difference {
      cylinder { <6, 30.2, -19.95>*cm, <6, 30.2, -19>*cm, 0.95*cm }
      sphere { 0, 1*cm scale <1, 1, 0.25> translate <6, 30.2, -19.05>*cm }
    }
    cylinder {
      <4, 30.2, -19.9>*cm, <4, 30.2, -19>*cm, 0.2*cm
      pigment { color rgb <0, 1, 0> }
      finish { ambient 1 diffuse 0 }
    }
    
    object {
      RoundedBox (10, 2.4, 4, 0.1)
      translate <-2.25, 28.9, -18>
      scale 1*cm
    }
    union {      // floppy drive
      difference {
        RoundedBox (10, 2.4, 4, 0.1)
        box { <-4.5, 0.1, -3>, <4.5, 0.6, 1.9> }
        box { <2.2, -0.3, -3>, <3.7, -0.8, 0> }
        box { <-1.75, -1, -1>, <1.75, 1, 1> rotate 45*x translate 0.1*y-2.6*z }
      }
      box { <-4.6, -0.1, -1.8>, <4.6, 1.0, 0> }
      box { <2.25, -0.35, -2.2>, <3.65, -0.75, 0> }
      translate <-2.25, 31.4, -18>
      scale 1*cm
    }
    
    object {
      RoundedBox (14.7, 4.1, 4, 0.1)
      translate <0, 36.9, -18>
      scale 1*cm
    }
    object {
      RoundedBox (14.7, 4.1, 4, 0.1)
      translate <0, 41, -18>
      scale 1*cm
    }
    union {    // CD drive
      difference {
        RoundedBox (14.7, 4.1, 4, 0.1)
        box { <-7, 0, -3>, <7, 1.7, 1.9> }
        box { <-7, -1, -1>, <7, 0.1, 0> rotate 45*x translate -1.8*z }
        box { <4.3, -1.5, -3>, <5.8, -1, 0> }
        cylinder { <3.8, -1.2, -3>, <3.8, -1.2, 0>, 0.1 }
        cylinder { <-5.8, -1.2, -3>, <-5.8, -1.2, 0>, 0.25 }
        box { <-4.7, -1.35, -3>, <-2.7, -1.05, -1.9> }
        box { <-4.5, -1.345, -2.5>, <-2.9, -1.055, 0> }
      }
      cylinder { <-7, -1, -1.7>, <-7, 1.8, -1.7>, 0.3 }
      cylinder { <7, -1, -1.7>, <7, 1.8, -1.7>, 0.3 }
      box { <-7, -0.2, -1.7>, <7, 1.9, 1.9> }
      object {
        RoundedBox (13.1, 1.5, 2, 0.2)
        translate <0, 0.8, -1>
      }
      box { <4.35, -1.45, -2.15>, <5.75, -1.05, 0.1> }
      cylinder {
        <3.8, -1.2, -1.9>, <3.8, -1.2, -1.8>, 0.3
        pigment { color rgb <1, 1, 0> }
        finish { ambient 1 diffuse 0 }
      }
      difference {
        cylinder { <-5.8, -1.2, -2.1>, <-5.8, -1.2, -1>, 0.35 }
        cylinder { <-5.8, -1.2, -2.2>, <-5.8, -1.2, -1.1>, 0.25 }
        pigment { color rgb 0 }
        finish { phong 0.2 }
      }
      cylinder {
        -0.14*y, 0.14*y, 1
        pigment { color rgb 0 }
        finish { phong 0.2 }
        normal { radial 0.1 frequency 180 }
        translate <-3.7, -1.2, -1.1>
      }
      translate <0, 45.1, -18>
      scale 1*cm
    }
    object {
      #include "drape.inc"
      uv_mapping
      pigment {
        object {
          sphere { 1.5*x+y, 0.5 }
          pigment {
            object {
              box { <0, 0.5, -0.5>, <1, 1.5, 0.5> }
              color rgb 0.75
              color rgb 0.25
            }
          }
          pigment { color rgb 0.5 }
        }
        warp { repeat 2*x }
        warp { repeat 2*y }
        scale 0.025
      }
      translate 49*y
      scale 1*cm
      rotate 180*y
    }
    
    texture {
      pigment { color rgb <1.0, 1.0, 0.95> }
      normal { bumps 0.1*mm scale 3*mm }
      finish { phong 0.2 }
    }
    Dirty (1*cm, 2)
  }
  
  #if (!included)
    global_settings {
      assumed_gamma 1
    }
    camera {
      up y
      right (image_width/image_height)*x
      location 110*cm*y-1.5*m*z
      look_at  50*cm*y
      angle 20
      //angle 5
    }
    light_source {
      <1000, 1000, -1000>*m
      color rgb 1
    }
    light_source {
      <-1000, 1000, -1000>*m
      color rgb 1/4
    }
    light_source {
      <0, 1000, 1000>*m
      color rgb 1.5
    }
    
    cylinder {
      -y, 0, 2*m
      pigment {
        checker
        color rgb 0.25
        color rgb 0.50
        scale 20*cm
      }
      finish {
        diffuse 0.5
        reflection 0.25
        reflection_blur 0.05
        reflection_samples 1
      }
      rotate 30*y
    }
    
    object {
      Computer
      rotate -30*y
    }
  #end
  
  #include "leave"
#end
