#version unofficial MegaPov 0.6;

#ifndef (CUPBOARD_INC)
  #declare CUPBOARD_INC = 0 ;
  
  #ifndef (HighQuality)
    #declare HighQuality = on ;
  #end
  
  #include "enter"
  #include "metrics.inc"
  #include "text.inc"
  #include "isosurf.inc"

  #macro AngledCylinder (Start, End, R)
    difference {
      cylinder { (Start-R)*y, (End+R)*y, R }
      plane { y, 0 rotate 45*z translate Start*y }
      plane { -y, 0 rotate -45*z translate End*y }
      texture { DarkWood() scale 0.5/cm rotate 90*z }
    }
  #end

  #local FrontFoot = union {
    box { <-6.5, 0, -49>*cm, <6.5, 11, -42>*cm }
    object {
      AngledCylinder (-6.5, 6.5, 1)
      rotate 90*z
      rotate 90*x
      translate 10*y-49*z
      scale 1*cm
    }
    object {
      AngledCylinder (-6.5, 6.5, 1)
      rotate 90*z
      rotate -90*x
      translate 10*y-42*z
      scale 1*cm
    }
    object {
      AngledCylinder (-3.5, 3.5, 1)
      rotate 90*z
      translate 10*y-45.5*z
      scale 1*cm
    }
    object {
      AngledCylinder (-3.5, 3.5, 1)
      rotate 90*z
      rotate 180*y
      translate 10*y-45.5*z
      scale 1*cm
    }
    texture { DarkWood() scale 0.5 rotate 90*z }
  }

  
  #declare Cupboard = union {
    difference {
      box { <-75, 10, -50>*cm, <75, 220, 0>*cm }
      box { <-71, 14, -51>*cm, <71, 208, -48.5>*cm }
    }
    box { <-85, 216, -60>*cm, <85, 220, 0>*cm texture { DarkWood() scale 0.5 translate 218*cm*y-85*cm*z } }
    box { <-79, 212, -54>*cm, <79, 219, 0>*cm texture { DarkWood() scale 0.5 translate 215.5*cm*y-79*cm*z } }

    union {
      object {
        AngledCylinder (15, 207, 1.5)
        translate -70*x-48.5*z
        scale 1*cm
      }
      cylinder { <-68.5, 15, -48.5>*cm, <-68.5, 207, -48.5>, 0.5*cm texture { DarkWood() scale 0.5 rotate 90*z } }
      object {
        AngledCylinder (15, 207, 1.5)
        rotate 180*y
        translate 70*x-48.5*z
        scale 1*cm
      }
      cylinder { <68.5, 15, -48.5>*cm, <68.5, 207, -48.5>, 0.5*cm texture { DarkWood() scale 0.5 rotate 90*z } }
      object {
        AngledCylinder (-70, 70, 1.5)
        rotate -90*z
        translate 207*y-48.5*z
        scale 1*cm
      }
      cylinder { <-70, 205.5, -48.5>*cm, <70, 205.5, -48.5>*cm, 0.5*cm texture { DarkWood() scale 0.5 } }
      object {
        AngledCylinder (-70, 70, 1.5)
        rotate 90*z
        translate 15*y-48.5*z
        scale 1*cm
      }
      cylinder { <-70, 16.5, -48.5>*cm, <70, 16.5, -48.5>*cm, 0.5*cm texture { DarkWood() scale 0.5 } }
    }
    
    union {                                                 // doors
      box { <-62, 43, -49.5>*cm, <62, 199, -48>*cm }
      cylinder { <-62, 43, -48.5>*cm, <-62, 199, -48.5>*cm, 1*cm }
      cylinder { <62, 43, -48.5>*cm, <62, 199, -48.5>*cm, 1*cm }
      cylinder { <-62, 43, -48.5>*cm, <62, 43, -48.5>*cm, 1*cm }
      cylinder { <-62, 199, -48.5>*cm, <62, 199, -48.5>*cm, 1*cm }
      sphere { <-62, 43, -48.5>*cm, 1*cm }
      sphere { <62, 43, -48.5>*cm, 1*cm }
      sphere { <62, 199, -48.5>*cm, 1*cm }
      sphere { <-62, 199, -48.5>*cm, 1*cm }
      
      difference {
        height_field {
          png "keyhole.png"
          translate -0.5*x-0.5*z
          scale  <3, 0.5, 12>*cm
        }
        cylinder { -1*cm*y, 1*cm*y, 0.5*cm }
        box { <-0.3, -1, -1.5>*cm, <0.3, 1, 0>*cm }
        rotate -90*x
        translate -5.25*cm*x+121*cm*y-49.4*cm*z
        texture { DarkMetal }
      }
      difference {
        height_field {
          png "keyhole.png"
          translate -0.5*x-0.5*z
          scale  <3, 0.5, 12>*cm
        }
        cylinder { -1*cm*y, 1*cm*y, 0.5*cm }
        box { <-0.3, -1, -1.5>*cm, <0.3, 1, 0>*cm }
        rotate -90*x
        translate 5.25*cm*x+121*cm*y-49.4*cm*z
        texture { DarkMetal }
      }
      
      #local OneDoor = union {
        object {
          AngledCylinder (44.5, 197.5, 1.5)
          translate -26*x-49.5*z
        }
        cylinder { <-24.5, 44.5, -49.5>, <-24.5, 197.5, -49.5>, 0.5 texture { DarkWood() scale 0.5/cm rotate 90*z } }
        object {
          AngledCylinder (44.5, 197.5, 1.5)
          rotate 180*y
          translate 26*x-49.5*z
        }
        cylinder { <24.5, 44.5, -49.5>, <24.5, 197.5, -49.5>, 0.5 texture { DarkWood() scale 0.5/cm rotate 90*z } }
        object {
          AngledCylinder (-26, 26, 1.5)
          rotate -90*z
          translate 197.5*y-49.5*z
        }
        cylinder { <-26, 196, -49.5>, <26, 196, -49.5>, 0.5 texture { DarkWood() scale 0.5/cm } }
        object {
          AngledCylinder (-26, 26, 1.5)
          rotate 90*z
          translate 44.5*y-49.5*z
        }
        cylinder { <-26, 46, -49.5>, <26, 46, -49.5>, 0.5 texture { DarkWood() scale 0.5/cm } }
        
        #local Decor = union {
          cylinder { <0, 44.5, -49.5>, <0, 67.5, -49.5>, 1.5 }
          cylinder { <-1.5, 44.5, -49.5>, <-1.5, 67.5, -49.5>, 0.5 }
          cylinder { <1.5, 44.5, -49.5>, <1.5, 67.5, -49.5>, 0.5 }
          union {
            torus { 13, 1.5 }
            torus { 14.5, 0.5 }
            torus { 11.5, 0.5 }
            clipped_by { box { <-15, -1.5, 15>, <15, 1.5, 0> } }
            bounded_by { clipped_by }
            rotate 90*x
            translate 80.5*y-49.5*z
          }
          sphere { <-13, 80.5, -49.5>, 1.5 }
          sphere { <13, 80.5, -49.5>, 1.5 }
          torus {
            1.5, 0.5
            clipped_by { box { <0, -0.5, -2>, <2, 0.5, 0> } }
            rotate 90*x
            translate <-13, 80.5, -49.5>
          }
          torus {
            1.5, 0.5
            clipped_by { box { <-2, -0.5, -2>, <0, 0.5, 0> } }
            rotate 90*x
            translate <13, 80.5, -49.5>
          }
          cylinder { <-26, 80.5, -49.5>, <-13, 80.5, -49.5>, 1.5 texture { DarkWood() scale 0.5/cm } }
          cylinder { <-26, 82, -49.5>, <-13, 82, -49.5>, 0.5 texture { DarkWood() scale 0.5/cm } }
          cylinder { <-26, 79, -49.5>, <-13, 79, -49.5>, 0.5 texture { DarkWood() scale 0.5/cm } }
          cylinder { <26, 80.5, -49.5>, <13, 80.5, -49.5>, 1.5 texture { DarkWood() scale 0.5/cm } }
          cylinder { <26, 82, -49.5>, <13, 82, -49.5>, 0.5 texture { DarkWood() scale 0.5/cm } }
          cylinder { <26, 79, -49.5>, <13, 79, -49.5>, 0.5 texture { DarkWood() scale 0.5/cm } }
          texture { DarkWood() scale 0.5/cm rotate 90*z } 
        }
        object { Decor }
        object { Decor scale <1, -1, 1> translate 242*y }
        scale 1*cm
      }
      #local Fixture = union {
        cylinder { <0, -16, -49.25>*cm, <0, 16, -49.25>*cm, 0.75*cm }
        sphere { <0, -16, -49.25>*cm, 0.75*cm }
        sphere { <0, 16, -49.25>*cm, 0.75*cm }
        texture { DarkMetal }
      }
      
      object {
        OneDoor
        translate -34.5*cm*x
      }
      object { Fixture translate <-64, 168, 0>*cm }
      object { Fixture translate <-64, 75, 0>*cm }
      object {
        OneDoor
        translate 34.5*cm*x
      }
      object { Fixture translate <64, 168, 0>*cm }
      object { Fixture translate <64, 75, 0>*cm }
      
      union {
        difference {
          union {
            cylinder { <0, 43, -48.5>*cm, <0, 199, -48.5>*cm, 3*cm }
            sphere { <0, 43, -48.5>*cm, 3*cm }
            sphere { <0, 199, -48.5>*cm, 3*cm }
          }
          union {
            cylinder { <0, 42, -51.5>*cm, <0, 200, -51.5>*cm, 1*cm }
            sphere { <0, 43, -51.5>*cm, 1*cm }
            sphere { <0, 199, -51.5>*cm, 1*cm }
          }
        }
          
        cylinder { <-3, 43, -48.5>*cm, <-3, 199, -48.5>*cm, 1.5*cm }
        cylinder { <3, 43, -48.5>*cm, <3, 199, -48.5>*cm, 1.5*cm }
        torus {
          3*cm, 1.5*cm
          clipped_by { box { <-4.5, -1.5, 4.5>*cm, <4.5, 1.5, 0>*cm } }
          rotate 90*x
          translate 43*y*cm-48.5*cm*z
        }
        torus {
          3*cm, 1.5*cm
          clipped_by { box { <-4.5, -1.5, -4.5>*cm, <4.5, 1.5, 0>*cm } }
          rotate 90*x
          translate 199*y*cm-48.5*cm*z
        }
        texture { DarkWood() scale 0.5 rotate 90*z } 
      }
    }
    
    #local Drawer = union {
      box { <-62, 23, -49.5>*cm, <-6, 37, -48>*cm }
      cylinder { <-62, 23, -48.5>*cm, <-6, 23, -48.5>*cm, 1*cm }
      cylinder { <-62, 37, -48.5>*cm, <-6, 37, -48.5>*cm, 1*cm }
      cylinder { <-62, 23, -48.5>*cm, <-62, 37, -48.5>*cm, 1*cm }
      cylinder { <-6, 23, -48.5>*cm, <-6, 37, -48.5>*cm, 1*cm }
      sphere { <-62, 23, -48.5>*cm, 1*cm }
      sphere { <-6, 23, -48.5>*cm, 1*cm }
      sphere { <-62, 37, -48.5>*cm, 1*cm }
      sphere { <-6, 37, -48.5>*cm, 1*cm }
      
      object {
        AngledCylinder (24.5, 35.5, 1.5)
        translate -60.5*x-49.5*z
        scale 1*cm
      }
      cylinder { <-59, 24.5, -49.5>*cm, <-59, 35.5, -49.5>*cm, 0.5*cm texture { DarkWood() scale 0.5 rotate 90*z } }
      object {
        AngledCylinder (24.5, 35.5, 1.5)
        rotate 180*y
        translate -7.5*x-49.5*z
        scale 1*cm
      }
      cylinder { <-9, 24.5, -49.5>*cm, <-9, 35.5, -49.5>*cm, 0.5*cm texture { DarkWood() scale 0.5 rotate 90*z } }
      object {
        AngledCylinder (-26.5, 26.5, 1.5)
        rotate -90*z
        translate -34*x+35.5*y-49.5*z
        scale 1*cm
      }
      cylinder { <-60.5, 34, -49.5>*cm, <-7.5, 34, 49.5>*cm, 0.5*cm texture { DarkWood() scale 0.5 } }
      object {
        AngledCylinder (-26.5, 26.5, 1.5)
        rotate 90*z
        translate 34*x+24.5*y-49.5*z
        scale 1*cm
      }
      cylinder { <-60.5, 26, -49.5>*cm, <-7.5, 26, -49.5>*cm, 0.5*cm texture { DarkWood() scale 0.5 } }
      
      union {
        cylinder { <-34, 30, -48>*cm, <-34, 30, -52>*cm, 1.5*cm }
        sphere { 0, 3*cm scale <1, 1, 0.5> translate <-34, 30, -52>*cm }
        texture { DarkWood() scale 0.5 rotate 90*y }
      }
    }

    object { Drawer }
    object { Drawer scale <-1, 1, 1> }
    
    object { FrontFoot translate -67.5*cm*x }
    object { FrontFoot translate 67.5*cm*x }
    box { <74, 0, -8>*cm, <61, 11, -1>*cm }
    box { <-74, 0, -8>*cm, <-61, 11, -1>*cm }
    //pigment { color rgb <0.50, 0.34, 0.15> }
    texture {
      #local Tr = <rand(Seed), rand(Seed), rand(Seed)*100>/10 ;
      #local Ro = <rand(Seed)-0.5, rand(Seed)-0.5, rand(Seed)*360> ;
      pigment {
        wood
        color_map { M_Teak }
        turbulence <0.07, 0.07, 0.2 >
        scale <0.3, 0.3, 0.7>/4
        translate Tr
        rotate Ro
        rotate 90*y
        scale 10*cm
        scale 0.5
        rotate 90*z
        translate 10*cm*x
        warp { repeat 20*cm*x offset 3*m*y flip y }
        translate 2.5*cm*z
        warp { repeat 5*cm*z offset -1*m*y flip y }
        translate -2.5*cm*z
      }
      normal {
        wood 3
        turbulence <0.07, 0.07, 0.2 >
        scale <0.3, 0.3, 0.7>/4
        translate Tr
        rotate Ro
        rotate 90*y
        scale 10*cm
        scale 0.5
        rotate 90*z
        translate 10*cm*x
        warp { repeat 20*cm*x offset 3*m*y flip y }
        translate 3*cm*z
        warp { repeat 6*cm*z offset -1*m*y flip y }
      }
      finish {
        brilliance 1.2
        specular 0.01
        roughness 0.2
      }
    }
  }
  
  #if (!included)
    global_settings {
      assumed_gamma 1
    }
    camera {
      up y
      right (image_width/image_height)*x
      location 110*cm*y-3*m*z
      look_at  100*cm*y
      angle 40
    }
    light_source {
      110*cm*y-3*m*z
      color rgb 0.25
      shadowless
    }
    
    light_source {
      <1000, 1000, -1000>*m
      color rgb 1
    }
    light_source {
      <-1000, 1000, -1000>*m
      color rgb 1/4
    }
    light_source {
      <0, 1000, 1000>*m
      color rgb 1.5
    }
    
    cylinder {
      -y, 0, 2*m
      pigment {
        checker
        color rgb 0.25
        color rgb 0.50
        scale 20*cm
      }
      finish {
        diffuse 0.5
        reflection 0.25
        reflection_blur 0.05
        reflection_samples 1
      }
      rotate 30*y
    }
    
    object {
      Cupboard
      rotate 30*y
    }
  #end
  
  #include "leave"
#end