#version unofficial MegaPov 0.6;

global_settings {
  assumed_gamma 1
}

camera {
  location -10*z+2*y
  look_at y
  angle 40
  focal_point y
  aperture 0.2
  blur_samples 160
  confidence 0.99
  variance 1/256
}

light_source {
  <1000, 1000, -1000>
  color rgb 1
}
light_source {
  <-1000, 1000, -1000>
  color rgb 0.25
}
light_source {
  <0, 1000, 1000>
  color rgb 2
}

background { color rgb <0.2, 0.2, 1.0> }

plane {
  y, 0
  pigment {
    checker color rgb 0, color rgb 1
    rotate 30*y
  }
  finish {
    ambient 0.1
    diffuse 0.4
  }
}

sphere {
  y, 1
  pigment { color rgb <0.39, 0.41, 0.43> }
  finish {
    ambient 0.25
    brilliance 4
    diffuse 0.5
    metallic
    reflect_metallic
    blinn 2.6 facets 0.20
    reflection 0.75
    reflection_blur 0.05
    reflection_samples 20
  }
  interior { ior 20 }
}